# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from equinix.services.metalv1.models.metro import Metro
from equinix.services.metalv1.models.project import Project
from equinix.services.metalv1.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class Vrf(BaseModel):
    """
    Vrf
    """ # noqa: E501
    bgp_dynamic_neighbors_bfd_enabled: Optional[StrictBool] = Field(default=None, description="Toggle BFD on dynamic bgp neighbors sessions")
    bgp_dynamic_neighbors_enabled: Optional[StrictBool] = Field(default=None, description="Toggle to enable the dynamic bgp neighbors feature on the VRF")
    bgp_dynamic_neighbors_export_route_map: Optional[StrictBool] = Field(default=None, description="Toggle to export the VRF route-map to the dynamic bgp neighbors")
    bill: Optional[StrictBool] = Field(default=False, description="True if the VRF is being billed. Usage will start when the first VRF Virtual Circuit is active, and will only stop when the VRF has been deleted.")
    created_at: Optional[datetime] = None
    created_by: Optional[User] = None
    description: Optional[StrictStr] = Field(default=None, description="Optional field that can be set to describe the VRF")
    href: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    ip_ranges: Optional[List[StrictStr]] = Field(default=None, description="A list of CIDR network addresses. Like [\"10.0.0.0/16\", \"2001:d78::/59\"].")
    local_asn: Optional[Annotated[int, Field(le=4294967295, strict=True, ge=0)]] = Field(default=None, description="A 4-byte ASN associated with the VRF.")
    metro: Optional[Metro] = None
    name: Optional[StrictStr] = None
    project: Optional[Project] = None
    tags: Optional[List[StrictStr]] = None
    updated_at: Optional[datetime] = None
    virtual_circuits: Optional[List[VrfVirtualCircuit]] = Field(default=None, description="Virtual circuits that are in the VRF")
    __properties: ClassVar[List[str]] = ["bgp_dynamic_neighbors_bfd_enabled", "bgp_dynamic_neighbors_enabled", "bgp_dynamic_neighbors_export_route_map", "bill", "created_at", "created_by", "description", "href", "id", "ip_ranges", "local_asn", "metro", "name", "project", "tags", "updated_at", "virtual_circuits"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Vrf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['created_by'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metro
        if self.metro:
            _dict['metro'] = self.metro.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in virtual_circuits (list)
        _items = []
        if self.virtual_circuits:
            for _item in self.virtual_circuits:
                if _item:
                    _items.append(_item.to_dict())
            _dict['virtual_circuits'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Vrf from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bgp_dynamic_neighbors_bfd_enabled": obj.get("bgp_dynamic_neighbors_bfd_enabled"),
            "bgp_dynamic_neighbors_enabled": obj.get("bgp_dynamic_neighbors_enabled"),
            "bgp_dynamic_neighbors_export_route_map": obj.get("bgp_dynamic_neighbors_export_route_map"),
            "bill": obj.get("bill") if obj.get("bill") is not None else False,
            "created_at": obj.get("created_at"),
            "created_by": User.from_dict(obj["created_by"]) if obj.get("created_by") is not None else None,
            "description": obj.get("description"),
            "href": obj.get("href"),
            "id": obj.get("id"),
            "ip_ranges": obj.get("ip_ranges"),
            "local_asn": obj.get("local_asn"),
            "metro": Metro.from_dict(obj["metro"]) if obj.get("metro") is not None else None,
            "name": obj.get("name"),
            "project": Project.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "tags": obj.get("tags"),
            "updated_at": obj.get("updated_at"),
            "virtual_circuits": [VrfVirtualCircuit.from_dict(_item) for _item in obj["virtual_circuits"]] if obj.get("virtual_circuits") is not None else None
        })
        return _obj

from equinix.services.metalv1.models.vrf_virtual_circuit import VrfVirtualCircuit
# TODO: Rewrite to not use raise_errors
Vrf.model_rebuild(raise_errors=False)

