# coding: utf-8

"""
    Metal API

    The version of the OpenAPI document: 1.0.0
    Contact: support@equinixmetal.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class VrfCreateInput(BaseModel):
    """
    VrfCreateInput
    """ # noqa: E501
    bgp_dynamic_neighbors_bfd_enabled: Optional[StrictBool] = Field(default=None, description="Toggle BFD on dynamic bgp neighbors sessions")
    bgp_dynamic_neighbors_enabled: Optional[StrictBool] = Field(default=None, description="Toggle to enable the dynamic bgp neighbors feature on the VRF")
    bgp_dynamic_neighbors_export_route_map: Optional[StrictBool] = Field(default=None, description="Toggle to export the VRF route-map to the dynamic bgp neighbors")
    description: Optional[StrictStr] = None
    href: Optional[StrictStr] = None
    ip_ranges: Optional[List[StrictStr]] = Field(default=None, description="A list of CIDR network addresses. Like [\"10.0.0.0/16\", \"2001:d78::/59\"]. IPv4 blocks must be between /8 and /29 in size. IPv6 blocks must be between /59 and /64. A VRF\\'s IP ranges must be defined in order to create VRF IP Reservations, which can then be used for Metal Gateways or Virtual Circuits.")
    local_asn: Optional[Annotated[int, Field(le=4294967295, strict=True, ge=0)]] = None
    metro: StrictStr = Field(description="The UUID (or metro code) for the Metro in which to create this VRF.")
    name: StrictStr
    tags: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["bgp_dynamic_neighbors_bfd_enabled", "bgp_dynamic_neighbors_enabled", "bgp_dynamic_neighbors_export_route_map", "description", "href", "ip_ranges", "local_asn", "metro", "name", "tags"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VrfCreateInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VrfCreateInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bgp_dynamic_neighbors_bfd_enabled": obj.get("bgp_dynamic_neighbors_bfd_enabled"),
            "bgp_dynamic_neighbors_enabled": obj.get("bgp_dynamic_neighbors_enabled"),
            "bgp_dynamic_neighbors_export_route_map": obj.get("bgp_dynamic_neighbors_export_route_map"),
            "description": obj.get("description"),
            "href": obj.get("href"),
            "ip_ranges": obj.get("ip_ranges"),
            "local_asn": obj.get("local_asn"),
            "metro": obj.get("metro"),
            "name": obj.get("name"),
            "tags": obj.get("tags")
        })
        return _obj


