# (c) Copyright [2015] Hewlett-Packard Development Company, L.P.
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.

# NOTE - this code originally resided in overrides.py, but Horizon
# only allows one plug-in to use an overrides file. Since this
# plug-in may be installed with other plug-ins, a short term
# solution is to place the overrides file contents in this file,
# which will always be loaded at startup.

# from django.utils.translation import ugettext_lazy as _
# from horizon import tables
# from openstack_dashboard.dashboards.admin.volumes.volumes import tables \
#     as volumes_tables
# from openstack_dashboard.dashboards.admin.volumes import tabs
#
# from django.core.urlresolvers import reverse
#
# import logging
#
# LOG = logging.getLogger(__name__)
#
# class LaunchElementManagerVolume(tables.LinkAction):
#     LOG.info(("Deep Link - launch element manager volume"))
#     name = "link_volume"
#     verbose_name = _("View Volume in HP 3PAR SSMC")
#     url = "horizon:admin:ssmc_link:link_to_volume"
#
#     # launch in new window
#     attrs = {"target": "_blank"}
#
#     policy_rules = (("volume", "volume:deep_link"),)
#
#     def get_link_url(self, volume):
#         link_url = reverse(self.url, args=[volume.id])
#         return link_url
#
#
# class LaunchElementManagerCPG(tables.LinkAction):
#     LOG.info(("Deep Link - launch element manager CPG"))
#     name = "link_cpg"
#     verbose_name = _("View Volume CPG in HP 3PAR SSMC")
#     url = "horizon:admin:ssmc_link:link_to_cpg"
#
#     # launch in new window
#     attrs = {"target": "_blank"}
#
#     policy_rules = (("volume", "volume:deep_link"),)
#
#     def get_link_url(self, volume):
#         link_url = reverse(self.url, args=[volume.id])
#         return link_url
#
#
# class LaunchElementManagerDomain(tables.LinkAction):
#     LOG.info(("Deep Link - launch element manager domain"))
#     name = "link_domain"
#     verbose_name = _("View Volume Domain in HP 3PAR SSMC")
#     url = "horizon:admin:ssmc_link:link_to_domain"
#
#     # launch in new window
#     attrs = {"target": "_blank"}
#
#     policy_rules = (("volume", "volume:deep_link"),)
#
#     def get_link_url(self, volume):
#         link_url = reverse(self.url, args=[volume.id])
#         return link_url
#
#
# class VolumesTableWithLaunch(volumes_tables.VolumesTable):
#     """ Extend the VolumesTable by adding the new row action
#     """
#     class Meta(volumes_tables.VolumesTable.Meta):
#         # Add the extra action to the end of the row actions
#         row_actions = volumes_tables.VolumesTable.Meta.row_actions + \
#                       (LaunchElementManagerVolume,
#                        LaunchElementManagerCPG,
#                        LaunchElementManagerDomain)
#
# # Replace the standard Volumes table with this extended version
# tabs.VolumeTab.table_classes = (VolumesTableWithLaunch,)
