
import requests
import os

def cache_git_file(repository_name, user_name, file_path, file_name, token, local_directory_base_path):

    file_contents  = download_git_file(repository_name, user_name, file_path, file_name, token)
    local_cache_file_path = create_local_cache_file(repository_name, user_name, file_path, file_name, local_directory_base_path, file_contents)
    return local_cache_file_path

def create_local_cache_file(repository_name, user_name, file_path, file_name, local_directory_base_path, contents):

    local_directory_full_path = local_directory_base_path + "/generated"
    local_directory_full_path = f"{local_directory_full_path}/{user_name}/{repository_name}/{file_path}"

    if (not os.path.exists(local_directory_full_path)):
        os.makedirs(local_directory_full_path)

    local_cache_file_path_with_name = local_directory_full_path + "/" + file_name

    f = open(local_cache_file_path_with_name, "w")
    f.write(contents)
    f.close()

    print(f"Cache file created : {local_cache_file_path_with_name}")

    return local_cache_file_path_with_name


def get_local_cache_file_path(repository_name, user_name, file_path, file_name, local_directory_path):

    local_directory_path = local_directory_path + "/generated"
    local_directory_path = f"{local_directory_path}/{user_name}/{repository_name}/{file_path}"

    file_path_with_name = local_directory_path + "/" + file_name
    return file_path_with_name

def download_git_file(repository_name, user_name, file_path, file_name, token):

    file_path_with_name = file_path + "/" + file_name

    final_url = 'https://api.github.com/repos/{owner}/{repo}/contents/{path}'.format(
            owner=user_name, repo=repository_name, path=file_path_with_name)
    print(f'Final URL is {final_url}')
    # send a request

    response = requests.get(final_url,
        headers={
            'accept': 'application/vnd.github.v3.raw',
            'authorization': 'token {}'.format(token)
        }
    )
    print(f"Response is {response}")

    print(f"Response is {response.text}")

    return response.text