from estnltk_core.converters import dict_to_text
from estnltk.taggers import SyntaxDependencyRetagger


def test_syntax_dependency_retagger():
    input_text_dict = {
        'text': 'Iga üheksas kroon tuli salapärastelt isikutelt . See oli rohkem kui 10 protsenti kogu Hansapanka paigutatud rahast .',
        'meta': {},
        'layers': [{'name': 'conll_syntax',
                    'attributes': ('id',
                                   'lemma',
                                   'upostag',
                                   'xpostag',
                                   'feats',
                                   'head',
                                   'deprel',
                                   'deps',
                                   'misc'),
                    'parent': None,
                    '_base': 'conll_syntax',
                    'enveloping': None,
                    'ambiguous': False,
                    'serialisation_module': 'legacy_v0',
                    'spans': [{'id': 1,
                               'lemma': 'iga',
                               'upostag': 'P',
                               'xpostag': 'P',
                               'feats': 'det|sg|nom',
                               'head': 2,
                               'deprel': '@NN>',
                               'deps': None,
                               'misc': None,
                               'start': 0,
                               'end': 3},
                              {'id': 2,
                               'lemma': 'üheksas',
                               'upostag': 'N',
                               'xpostag': 'A',
                               'feats': 'ord|sg|nom|l',
                               'head': 3,
                               'deprel': '@AN>',
                               'deps': None,
                               'misc': None,
                               'start': 4,
                               'end': 11},
                              {'id': 3,
                               'lemma': 'kroon',
                               'upostag': 'S',
                               'xpostag': 'S',
                               'feats': 'sg|nom',
                               'head': 4,
                               'deprel': '@SUBJ',
                               'deps': None,
                               'misc': None,
                               'start': 12,
                               'end': 17},
                              {'id': 4,
                               'lemma': 'tule',
                               'upostag': 'V',
                               'xpostag': 'V',
                               'feats': 'indic|impf|ps3|sg',
                               'head': 0,
                               'deprel': 'ROOT',
                               'deps': None,
                               'misc': None,
                               'start': 18,
                               'end': 22},
                              {'id': 5,
                               'lemma': 'sala_pärane',
                               'upostag': 'A',
                               'xpostag': 'A',
                               'feats': 'pl|abl',
                               'head': 6,
                               'deprel': '@AN>',
                               'deps': None,
                               'misc': None,
                               'start': 23,
                               'end': 36},
                              {'id': 6,
                               'lemma': 'isik',
                               'upostag': 'S',
                               'xpostag': 'S',
                               'feats': 'pl|abl',
                               'head': 4,
                               'deprel': '@ADVL',
                               'deps': None,
                               'misc': None,
                               'start': 37,
                               'end': 46},
                              {'id': 7,
                               'lemma': '.',
                               'upostag': 'Z',
                               'xpostag': 'Z',
                               'feats': 'Fst',
                               'head': 6,
                               'deprel': '@Punc',
                               'deps': None,
                               'misc': None,
                               'start': 47,
                               'end': 48},
                              {'id': 1,
                               'lemma': 'see',
                               'upostag': 'P',
                               'xpostag': 'P',
                               'feats': 'dem|sg|nom',
                               'head': 2,
                               'deprel': '@SUBJ',
                               'deps': None,
                               'misc': None,
                               'start': 49,
                               'end': 52},
                              {'id': 2,
                               'lemma': 'ole',
                               'upostag': 'V',
                               'xpostag': 'V',
                               'feats': 'indic|impf|ps3|sg',
                               'head': 0,
                               'deprel': 'ROOT',
                               'deps': None,
                               'misc': None,
                               'start': 53,
                               'end': 56},
                              {'id': 3,
                               'lemma': 'rohkem',
                               'upostag': 'D',
                               'xpostag': 'D',
                               'feats': None,
                               'head': 2,
                               'deprel': '@OBJ',
                               'deps': None,
                               'misc': None,
                               'start': 57,
                               'end': 63},
                              {'id': 4,
                               'lemma': 'kui',
                               'upostag': 'J',
                               'xpostag': 'Jc',
                               'feats': None,
                               'head': 5,
                               'deprel': '@J',
                               'deps': None,
                               'misc': None,
                               'start': 64,
                               'end': 67},
                              {'id': 5,
                               'lemma': '10',
                               'upostag': 'N',
                               'xpostag': 'N',
                               'feats': 'card|sg|nom',
                               'head': 3,
                               'deprel': '@ADVL',
                               'deps': None,
                               'misc': None,
                               'start': 68,
                               'end': 70},
                              {'id': 6,
                               'lemma': 'protsent',
                               'upostag': 'S',
                               'xpostag': 'S',
                               'feats': 'sg|part',
                               'head': 5,
                               'deprel': '@<Q',
                               'deps': None,
                               'misc': None,
                               'start': 71,
                               'end': 80},
                              {'id': 7,
                               'lemma': 'kogu',
                               'upostag': 'A',
                               'xpostag': 'A',
                               'feats': None,
                               'head': 10,
                               'deprel': '@AN>',
                               'deps': None,
                               'misc': None,
                               'start': 81,
                               'end': 85},
                              {'id': 8,
                               'lemma': 'Hansa_pank',
                               'upostag': 'S',
                               'xpostag': 'H',
                               'feats': 'sg|adit',
                               'head': 9,
                               'deprel': '@ADVL',
                               'deps': None,
                               'misc': None,
                               'start': 86,
                               'end': 96},
                              {'id': 9,
                               'lemma': 'paiguta=tud',
                               'upostag': 'A',
                               'xpostag': 'A',
                               'feats': 'partic',
                               'head': 10,
                               'deprel': '@AN>',
                               'deps': None,
                               'misc': None,
                               'start': 97,
                               'end': 107},
                              {'id': 10,
                               'lemma': 'raha',
                               'upostag': 'S',
                               'xpostag': 'S',
                               'feats': 'sg|el',
                               'head': 5,
                               'deprel': '@ADVL',
                               'deps': None,
                               'misc': None,
                               'start': 108,
                               'end': 114},
                              {'id': 11,
                               'lemma': '.',
                               'upostag': 'Z',
                               'xpostag': 'Z',
                               'feats': 'Fst',
                               'head': 10,
                               'deprel': '@Punc',
                               'deps': None,
                               'misc': None,
                               'start': 115,
                               'end': 116}]},
                   {'name': 'words',
                    'attributes': (),
                    'parent': None,
                    '_base': 'words',
                    'enveloping': None,
                    'ambiguous': False,
                    'serialisation_module': 'legacy_v0',
                    'spans': [{'start': 0, 'end': 3},
                              {'start': 4, 'end': 11},
                              {'start': 12, 'end': 17},
                              {'start': 18, 'end': 22},
                              {'start': 23, 'end': 36},
                              {'start': 37, 'end': 46},
                              {'start': 47, 'end': 48},
                              {'start': 49, 'end': 52},
                              {'start': 53, 'end': 56},
                              {'start': 57, 'end': 63},
                              {'start': 64, 'end': 67},
                              {'start': 68, 'end': 70},
                              {'start': 71, 'end': 80},
                              {'start': 81, 'end': 85},
                              {'start': 86, 'end': 96},
                              {'start': 97, 'end': 107},
                              {'start': 108, 'end': 114},
                              {'start': 115, 'end': 116}]}]}

    text = dict_to_text(input_text_dict)

    retagger = SyntaxDependencyRetagger()
    retagger.retag(text)

    layer = text.conll_syntax
    assert list(layer.secondary_attributes) == ['parent_span', 'children']
    assert list(layer.parent_span) == [layer[1], layer[2], layer[3], None, layer[5], layer[3],
                                       layer[5], layer[8], None, layer[8], layer[11], layer[9], layer[11],
                                       layer[16], layer[15], layer[16],  layer[11], layer[16]]
    assert list(layer.children) == [(), (layer[0],), (layer[1],), (layer[2],layer[5]), (),
                                    (layer[4],layer[6]), (), (), (layer[7], layer[9]), (layer[11],), (),
                                    (layer[10], layer[12], layer[16]), (), (), (), (layer[14],),
                                    (layer[13], layer[15], layer[17]), ()]
