from collections.abc import Sequence
import enum
from typing import Annotated, overload

from numpy.typing import ArrayLike


class Handedness(enum.Enum):
    right_handed = 0

    left_handed = 1

@overload
def abs(x: float1) -> float1: ...

@overload
def abs(x: float2) -> float2: ...

@overload
def abs(x: float3) -> float3: ...

@overload
def abs(x: float4) -> float4: ...

@overload
def abs(x: int1) -> int1: ...

@overload
def abs(x: int2) -> int2: ...

@overload
def abs(x: int3) -> int3: ...

@overload
def abs(x: int4) -> int4: ...

@overload
def acos(x: float) -> float: ...

@overload
def acos(x: float) -> float: ...

@overload
def acos(x: float1) -> float1: ...

@overload
def acos(x: float2) -> float2: ...

@overload
def acos(x: float3) -> float3: ...

@overload
def acos(x: float4) -> float4: ...

@overload
def all(x: bool1) -> bool: ...

@overload
def all(x: bool2) -> bool: ...

@overload
def all(x: bool3) -> bool: ...

@overload
def all(x: bool4) -> bool: ...

@overload
def any(x: bool1) -> bool: ...

@overload
def any(x: bool2) -> bool: ...

@overload
def any(x: bool3) -> bool: ...

@overload
def any(x: bool4) -> bool: ...

@overload
def asfloat(x: int) -> float: ...

@overload
def asfloat(x: int) -> float: ...

def asfloat16(x: int) -> float16_t: ...

@overload
def asin(x: float) -> float: ...

@overload
def asin(x: float) -> float: ...

@overload
def asin(x: float1) -> float1: ...

@overload
def asin(x: float2) -> float2: ...

@overload
def asin(x: float3) -> float3: ...

@overload
def asin(x: float4) -> float4: ...

def asint(x: float) -> int: ...

@overload
def asuint(x: float) -> int: ...

@overload
def asuint(x: float2) -> uint2: ...

@overload
def asuint(x: float3) -> uint3: ...

@overload
def asuint(x: float4) -> uint4: ...

def asuint16(x: float16_t) -> int: ...

@overload
def atan(x: float) -> float: ...

@overload
def atan(x: float) -> float: ...

@overload
def atan(x: float1) -> float1: ...

@overload
def atan(x: float2) -> float2: ...

@overload
def atan(x: float3) -> float3: ...

@overload
def atan(x: float4) -> float4: ...

@overload
def atan2(y: float, x: float) -> float: ...

@overload
def atan2(y: float, x: float) -> float: ...

@overload
def atan2(y: float1, x: float1) -> float1: ...

@overload
def atan2(y: float2, x: float2) -> float2: ...

@overload
def atan2(y: float3, x: float3) -> float3: ...

@overload
def atan2(y: float4, x: float4) -> float4: ...

class bool1:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: bool) -> None: ...

    @overload
    def __init__(self, a: Sequence[bool]) -> None: ...

    @property
    def x(self) -> bool: ...

    @x.setter
    def x(self, arg: bool, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> bool: ...

    def __setitem__(self, arg0: int, arg1: bool, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __bool__(self) -> bool: ...

    @overload
    def __eq__(self, arg: bool1, /) -> bool1: ...

    @overload
    def __eq__(self, arg: bool, /) -> bool1: ...

    @overload
    def __eq__(self, arg: bool, /) -> bool1: ...

    @overload
    def __ne__(self, arg: bool1, /) -> bool1: ...

    @overload
    def __ne__(self, arg: bool, /) -> bool1: ...

    @overload
    def __ne__(self, arg: bool, /) -> bool1: ...

class bool2:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: bool) -> None: ...

    @overload
    def __init__(self, x: bool, y: bool) -> None: ...

    @overload
    def __init__(self, a: Sequence[bool]) -> None: ...

    @property
    def x(self) -> bool: ...

    @x.setter
    def x(self, arg: bool, /) -> None: ...

    @property
    def y(self) -> bool: ...

    @y.setter
    def y(self, arg: bool, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> bool: ...

    def __setitem__(self, arg0: int, arg1: bool, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __bool__(self) -> bool: ...

    @overload
    def __eq__(self, arg: bool2, /) -> bool2: ...

    @overload
    def __eq__(self, arg: bool, /) -> bool2: ...

    @overload
    def __eq__(self, arg: bool, /) -> bool2: ...

    @overload
    def __ne__(self, arg: bool2, /) -> bool2: ...

    @overload
    def __ne__(self, arg: bool, /) -> bool2: ...

    @overload
    def __ne__(self, arg: bool, /) -> bool2: ...

class bool3:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: bool) -> None: ...

    @overload
    def __init__(self, x: bool, y: bool, z: bool) -> None: ...

    @overload
    def __init__(self, xy: bool2, z: bool) -> None: ...

    @overload
    def __init__(self, x: bool, yz: bool2) -> None: ...

    @overload
    def __init__(self, a: Sequence[bool]) -> None: ...

    @property
    def x(self) -> bool: ...

    @x.setter
    def x(self, arg: bool, /) -> None: ...

    @property
    def y(self) -> bool: ...

    @y.setter
    def y(self, arg: bool, /) -> None: ...

    @property
    def z(self) -> bool: ...

    @z.setter
    def z(self, arg: bool, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> bool: ...

    def __setitem__(self, arg0: int, arg1: bool, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __bool__(self) -> bool: ...

    @overload
    def __eq__(self, arg: bool3, /) -> bool3: ...

    @overload
    def __eq__(self, arg: bool, /) -> bool3: ...

    @overload
    def __eq__(self, arg: bool, /) -> bool3: ...

    @overload
    def __ne__(self, arg: bool3, /) -> bool3: ...

    @overload
    def __ne__(self, arg: bool, /) -> bool3: ...

    @overload
    def __ne__(self, arg: bool, /) -> bool3: ...

class bool4:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: bool) -> None: ...

    @overload
    def __init__(self, x: bool, y: bool, z: bool, w: bool) -> None: ...

    @overload
    def __init__(self, xy: bool2, zw: bool2) -> None: ...

    @overload
    def __init__(self, xyz: bool3, w: bool) -> None: ...

    @overload
    def __init__(self, x: bool, yzw: bool3) -> None: ...

    @overload
    def __init__(self, a: Sequence[bool]) -> None: ...

    @property
    def x(self) -> bool: ...

    @x.setter
    def x(self, arg: bool, /) -> None: ...

    @property
    def y(self) -> bool: ...

    @y.setter
    def y(self, arg: bool, /) -> None: ...

    @property
    def z(self) -> bool: ...

    @z.setter
    def z(self, arg: bool, /) -> None: ...

    @property
    def w(self) -> bool: ...

    @w.setter
    def w(self, arg: bool, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> bool: ...

    def __setitem__(self, arg0: int, arg1: bool, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __bool__(self) -> bool: ...

    @overload
    def __eq__(self, arg: bool4, /) -> bool4: ...

    @overload
    def __eq__(self, arg: bool, /) -> bool4: ...

    @overload
    def __eq__(self, arg: bool, /) -> bool4: ...

    @overload
    def __ne__(self, arg: bool4, /) -> bool4: ...

    @overload
    def __ne__(self, arg: bool, /) -> bool4: ...

    @overload
    def __ne__(self, arg: bool, /) -> bool4: ...

@overload
def ceil(x: float) -> float: ...

@overload
def ceil(x: float) -> float: ...

@overload
def ceil(x: float1) -> float1: ...

@overload
def ceil(x: float2) -> float2: ...

@overload
def ceil(x: float3) -> float3: ...

@overload
def ceil(x: float4) -> float4: ...

@overload
def clamp(x: float1, min: float1, max: float1) -> float1: ...

@overload
def clamp(x: float2, min: float2, max: float2) -> float2: ...

@overload
def clamp(x: float3, min: float3, max: float3) -> float3: ...

@overload
def clamp(x: float4, min: float4, max: float4) -> float4: ...

@overload
def clamp(x: uint1, min: uint1, max: uint1) -> uint1: ...

@overload
def clamp(x: uint2, min: uint2, max: uint2) -> uint2: ...

@overload
def clamp(x: uint3, min: uint3, max: uint3) -> uint3: ...

@overload
def clamp(x: uint4, min: uint4, max: uint4) -> uint4: ...

@overload
def clamp(x: int1, min: int1, max: int1) -> int1: ...

@overload
def clamp(x: int2, min: int2, max: int2) -> int2: ...

@overload
def clamp(x: int3, min: int3, max: int3) -> int3: ...

@overload
def clamp(x: int4, min: int4, max: int4) -> int4: ...

@overload
def clamp(x: bool1, min: bool1, max: bool1) -> bool1: ...

@overload
def clamp(x: bool2, min: bool2, max: bool2) -> bool2: ...

@overload
def clamp(x: bool3, min: bool3, max: bool3) -> bool3: ...

@overload
def clamp(x: bool4, min: bool4, max: bool4) -> bool4: ...

def conjugate(x: quatf) -> quatf: ...

@overload
def cos(x: float) -> float: ...

@overload
def cos(x: float) -> float: ...

@overload
def cos(x: float1) -> float1: ...

@overload
def cos(x: float2) -> float2: ...

@overload
def cos(x: float3) -> float3: ...

@overload
def cos(x: float4) -> float4: ...

@overload
def cosh(x: float) -> float: ...

@overload
def cosh(x: float) -> float: ...

@overload
def cosh(x: float1) -> float1: ...

@overload
def cosh(x: float2) -> float2: ...

@overload
def cosh(x: float3) -> float3: ...

@overload
def cosh(x: float4) -> float4: ...

@overload
def cross(x: float3, y: float3) -> float3: ...

@overload
def cross(x: uint3, y: uint3) -> uint3: ...

@overload
def cross(x: int3, y: int3) -> int3: ...

@overload
def cross(x: quatf, y: quatf) -> quatf: ...

@overload
def degrees(x: float) -> float: ...

@overload
def degrees(x: float) -> float: ...

@overload
def degrees(x: float1) -> float1: ...

@overload
def degrees(x: float2) -> float2: ...

@overload
def degrees(x: float3) -> float3: ...

@overload
def degrees(x: float4) -> float4: ...

@overload
def determinant(x: float2x2) -> float: ...

@overload
def determinant(x: float3x3) -> float: ...

@overload
def determinant(x: float4x4) -> float: ...

@overload
def dot(x: float1, y: float1) -> float: ...

@overload
def dot(x: float2, y: float2) -> float: ...

@overload
def dot(x: float3, y: float3) -> float: ...

@overload
def dot(x: float4, y: float4) -> float: ...

@overload
def dot(x: uint1, y: uint1) -> int: ...

@overload
def dot(x: uint2, y: uint2) -> int: ...

@overload
def dot(x: uint3, y: uint3) -> int: ...

@overload
def dot(x: uint4, y: uint4) -> int: ...

@overload
def dot(x: int1, y: int1) -> int: ...

@overload
def dot(x: int2, y: int2) -> int: ...

@overload
def dot(x: int3, y: int3) -> int: ...

@overload
def dot(x: int4, y: int4) -> int: ...

@overload
def dot(x: quatf, y: quatf) -> float: ...

def euler_angles(x: quatf) -> float3: ...

@overload
def exp(x: float) -> float: ...

@overload
def exp(x: float) -> float: ...

@overload
def exp(x: float16_t) -> float16_t: ...

@overload
def exp(x: float1) -> float1: ...

@overload
def exp(x: float2) -> float2: ...

@overload
def exp(x: float3) -> float3: ...

@overload
def exp(x: float4) -> float4: ...

@overload
def exp2(x: float) -> float: ...

@overload
def exp2(x: float) -> float: ...

@overload
def exp2(x: float16_t) -> float16_t: ...

@overload
def exp2(x: float1) -> float1: ...

@overload
def exp2(x: float2) -> float2: ...

@overload
def exp2(x: float3) -> float3: ...

@overload
def exp2(x: float4) -> float4: ...

@overload
def f16tof32(x: int) -> float: ...

@overload
def f16tof32(x: uint2) -> float2: ...

@overload
def f16tof32(x: uint3) -> float3: ...

@overload
def f16tof32(x: uint4) -> float4: ...

@overload
def f32tof16(x: float) -> int: ...

@overload
def f32tof16(x: float2) -> uint2: ...

@overload
def f32tof16(x: float3) -> uint3: ...

@overload
def f32tof16(x: float4) -> uint4: ...

class float1:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: float) -> None: ...

    @overload
    def __init__(self, a: Sequence[float]) -> None: ...

    @property
    def x(self) -> float: ...

    @x.setter
    def x(self, arg: float, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> float: ...

    def __setitem__(self, arg0: int, arg1: float, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __pos__(self) -> float1: ...

    def __neg__(self) -> float1: ...

    @overload
    def __add__(self, arg: float1, /) -> float1: ...

    @overload
    def __add__(self, arg: float, /) -> float1: ...

    def __radd__(self, arg: float, /) -> float1: ...

    @overload
    def __sub__(self, arg: float1, /) -> float1: ...

    @overload
    def __sub__(self, arg: float, /) -> float1: ...

    def __rsub__(self, arg: float, /) -> float1: ...

    @overload
    def __mul__(self, arg: float1, /) -> float1: ...

    @overload
    def __mul__(self, arg: float, /) -> float1: ...

    def __rmul__(self, arg: float, /) -> float1: ...

    @overload
    def __truediv__(self, arg: float1, /) -> float1: ...

    @overload
    def __truediv__(self, arg: float, /) -> float1: ...

    def __rtruediv__(self, arg: float, /) -> float1: ...

    @overload
    def __iadd__(self, arg: float1, /) -> float1: ...

    @overload
    def __iadd__(self, arg: float, /) -> float1: ...

    @overload
    def __isub__(self, arg: float1, /) -> float1: ...

    @overload
    def __isub__(self, arg: float, /) -> float1: ...

    @overload
    def __imul__(self, arg: float1, /) -> float1: ...

    @overload
    def __imul__(self, arg: float, /) -> float1: ...

    @overload
    def __itruediv__(self, arg: float1, /) -> float1: ...

    @overload
    def __itruediv__(self, arg: float, /) -> float1: ...

    @overload
    def __eq__(self, arg: float1, /) -> bool1: ...

    @overload
    def __eq__(self, arg: float, /) -> bool1: ...

    @overload
    def __eq__(self, arg: float, /) -> bool1: ...

    @overload
    def __ne__(self, arg: float1, /) -> bool1: ...

    @overload
    def __ne__(self, arg: float, /) -> bool1: ...

    @overload
    def __ne__(self, arg: float, /) -> bool1: ...

    @overload
    def __lt__(self, arg: float1, /) -> bool1: ...

    @overload
    def __lt__(self, arg: float, /) -> bool1: ...

    @overload
    def __lt__(self, arg: float, /) -> bool1: ...

    @overload
    def __gt__(self, arg: float, /) -> bool1: ...

    @overload
    def __gt__(self, arg: float1, /) -> bool1: ...

    @overload
    def __gt__(self, arg: float, /) -> bool1: ...

    @overload
    def __le__(self, arg: float1, /) -> bool1: ...

    @overload
    def __le__(self, arg: float, /) -> bool1: ...

    @overload
    def __le__(self, arg: float, /) -> bool1: ...

    @overload
    def __ge__(self, arg: float, /) -> bool1: ...

    @overload
    def __ge__(self, arg: float1, /) -> bool1: ...

    @overload
    def __ge__(self, arg: float, /) -> bool1: ...

class float16_t:
    @overload
    def __init__(self, value: float) -> None: ...

    @overload
    def __init__(self, value: float) -> None: ...

    def __float__(self) -> float: ...

class float16_t1:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: float16_t) -> None: ...

    @overload
    def __init__(self, a: Sequence[float16_t]) -> None: ...

    @property
    def x(self) -> float16_t: ...

    @x.setter
    def x(self, arg: float16_t, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> float16_t: ...

    def __setitem__(self, arg0: int, arg1: float16_t, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __pos__(self) -> float16_t1: ...

    def __neg__(self) -> float16_t1: ...

    @overload
    def __add__(self, arg: float16_t1, /) -> float16_t1: ...

    @overload
    def __add__(self, arg: float16_t, /) -> float16_t1: ...

    def __radd__(self, arg: float16_t, /) -> float16_t1: ...

    @overload
    def __sub__(self, arg: float16_t1, /) -> float16_t1: ...

    @overload
    def __sub__(self, arg: float16_t, /) -> float16_t1: ...

    def __rsub__(self, arg: float16_t, /) -> float16_t1: ...

    @overload
    def __mul__(self, arg: float16_t1, /) -> float16_t1: ...

    @overload
    def __mul__(self, arg: float16_t, /) -> float16_t1: ...

    def __rmul__(self, arg: float16_t, /) -> float16_t1: ...

    @overload
    def __truediv__(self, arg: float16_t1, /) -> float16_t1: ...

    @overload
    def __truediv__(self, arg: float16_t, /) -> float16_t1: ...

    def __rtruediv__(self, arg: float16_t, /) -> float16_t1: ...

    @overload
    def __iadd__(self, arg: float16_t1, /) -> float16_t1: ...

    @overload
    def __iadd__(self, arg: float16_t, /) -> float16_t1: ...

    @overload
    def __isub__(self, arg: float16_t1, /) -> float16_t1: ...

    @overload
    def __isub__(self, arg: float16_t, /) -> float16_t1: ...

    @overload
    def __imul__(self, arg: float16_t1, /) -> float16_t1: ...

    @overload
    def __imul__(self, arg: float16_t, /) -> float16_t1: ...

    @overload
    def __itruediv__(self, arg: float16_t1, /) -> float16_t1: ...

    @overload
    def __itruediv__(self, arg: float16_t, /) -> float16_t1: ...

    @overload
    def __eq__(self, arg: float16_t1, /) -> bool1: ...

    @overload
    def __eq__(self, arg: float16_t, /) -> bool1: ...

    @overload
    def __eq__(self, arg: float16_t, /) -> bool1: ...

    @overload
    def __ne__(self, arg: float16_t1, /) -> bool1: ...

    @overload
    def __ne__(self, arg: float16_t, /) -> bool1: ...

    @overload
    def __ne__(self, arg: float16_t, /) -> bool1: ...

    @overload
    def __lt__(self, arg: float16_t1, /) -> bool1: ...

    @overload
    def __lt__(self, arg: float16_t, /) -> bool1: ...

    @overload
    def __lt__(self, arg: float16_t, /) -> bool1: ...

    @overload
    def __gt__(self, arg: float16_t, /) -> bool1: ...

    @overload
    def __gt__(self, arg: float16_t1, /) -> bool1: ...

    @overload
    def __gt__(self, arg: float16_t, /) -> bool1: ...

    @overload
    def __le__(self, arg: float16_t1, /) -> bool1: ...

    @overload
    def __le__(self, arg: float16_t, /) -> bool1: ...

    @overload
    def __le__(self, arg: float16_t, /) -> bool1: ...

    @overload
    def __ge__(self, arg: float16_t, /) -> bool1: ...

    @overload
    def __ge__(self, arg: float16_t1, /) -> bool1: ...

    @overload
    def __ge__(self, arg: float16_t, /) -> bool1: ...

class float16_t2:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: float16_t) -> None: ...

    @overload
    def __init__(self, x: float16_t, y: float16_t) -> None: ...

    @overload
    def __init__(self, a: Sequence[float16_t]) -> None: ...

    @property
    def x(self) -> float16_t: ...

    @x.setter
    def x(self, arg: float16_t, /) -> None: ...

    @property
    def y(self) -> float16_t: ...

    @y.setter
    def y(self, arg: float16_t, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> float16_t: ...

    def __setitem__(self, arg0: int, arg1: float16_t, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __pos__(self) -> float16_t2: ...

    def __neg__(self) -> float16_t2: ...

    @overload
    def __add__(self, arg: float16_t2, /) -> float16_t2: ...

    @overload
    def __add__(self, arg: float16_t, /) -> float16_t2: ...

    def __radd__(self, arg: float16_t, /) -> float16_t2: ...

    @overload
    def __sub__(self, arg: float16_t2, /) -> float16_t2: ...

    @overload
    def __sub__(self, arg: float16_t, /) -> float16_t2: ...

    def __rsub__(self, arg: float16_t, /) -> float16_t2: ...

    @overload
    def __mul__(self, arg: float16_t2, /) -> float16_t2: ...

    @overload
    def __mul__(self, arg: float16_t, /) -> float16_t2: ...

    def __rmul__(self, arg: float16_t, /) -> float16_t2: ...

    @overload
    def __truediv__(self, arg: float16_t2, /) -> float16_t2: ...

    @overload
    def __truediv__(self, arg: float16_t, /) -> float16_t2: ...

    def __rtruediv__(self, arg: float16_t, /) -> float16_t2: ...

    @overload
    def __iadd__(self, arg: float16_t2, /) -> float16_t2: ...

    @overload
    def __iadd__(self, arg: float16_t, /) -> float16_t2: ...

    @overload
    def __isub__(self, arg: float16_t2, /) -> float16_t2: ...

    @overload
    def __isub__(self, arg: float16_t, /) -> float16_t2: ...

    @overload
    def __imul__(self, arg: float16_t2, /) -> float16_t2: ...

    @overload
    def __imul__(self, arg: float16_t, /) -> float16_t2: ...

    @overload
    def __itruediv__(self, arg: float16_t2, /) -> float16_t2: ...

    @overload
    def __itruediv__(self, arg: float16_t, /) -> float16_t2: ...

    @overload
    def __eq__(self, arg: float16_t2, /) -> bool2: ...

    @overload
    def __eq__(self, arg: float16_t, /) -> bool2: ...

    @overload
    def __eq__(self, arg: float16_t, /) -> bool2: ...

    @overload
    def __ne__(self, arg: float16_t2, /) -> bool2: ...

    @overload
    def __ne__(self, arg: float16_t, /) -> bool2: ...

    @overload
    def __ne__(self, arg: float16_t, /) -> bool2: ...

    @overload
    def __lt__(self, arg: float16_t2, /) -> bool2: ...

    @overload
    def __lt__(self, arg: float16_t, /) -> bool2: ...

    @overload
    def __lt__(self, arg: float16_t, /) -> bool2: ...

    @overload
    def __gt__(self, arg: float16_t, /) -> bool2: ...

    @overload
    def __gt__(self, arg: float16_t2, /) -> bool2: ...

    @overload
    def __gt__(self, arg: float16_t, /) -> bool2: ...

    @overload
    def __le__(self, arg: float16_t2, /) -> bool2: ...

    @overload
    def __le__(self, arg: float16_t, /) -> bool2: ...

    @overload
    def __le__(self, arg: float16_t, /) -> bool2: ...

    @overload
    def __ge__(self, arg: float16_t, /) -> bool2: ...

    @overload
    def __ge__(self, arg: float16_t2, /) -> bool2: ...

    @overload
    def __ge__(self, arg: float16_t, /) -> bool2: ...

class float16_t3:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: float16_t) -> None: ...

    @overload
    def __init__(self, x: float16_t, y: float16_t, z: float16_t) -> None: ...

    @overload
    def __init__(self, xy: float16_t2, z: float16_t) -> None: ...

    @overload
    def __init__(self, x: float16_t, yz: float16_t2) -> None: ...

    @overload
    def __init__(self, a: Sequence[float16_t]) -> None: ...

    @property
    def x(self) -> float16_t: ...

    @x.setter
    def x(self, arg: float16_t, /) -> None: ...

    @property
    def y(self) -> float16_t: ...

    @y.setter
    def y(self, arg: float16_t, /) -> None: ...

    @property
    def z(self) -> float16_t: ...

    @z.setter
    def z(self, arg: float16_t, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> float16_t: ...

    def __setitem__(self, arg0: int, arg1: float16_t, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __pos__(self) -> float16_t3: ...

    def __neg__(self) -> float16_t3: ...

    @overload
    def __add__(self, arg: float16_t3, /) -> float16_t3: ...

    @overload
    def __add__(self, arg: float16_t, /) -> float16_t3: ...

    def __radd__(self, arg: float16_t, /) -> float16_t3: ...

    @overload
    def __sub__(self, arg: float16_t3, /) -> float16_t3: ...

    @overload
    def __sub__(self, arg: float16_t, /) -> float16_t3: ...

    def __rsub__(self, arg: float16_t, /) -> float16_t3: ...

    @overload
    def __mul__(self, arg: float16_t3, /) -> float16_t3: ...

    @overload
    def __mul__(self, arg: float16_t, /) -> float16_t3: ...

    def __rmul__(self, arg: float16_t, /) -> float16_t3: ...

    @overload
    def __truediv__(self, arg: float16_t3, /) -> float16_t3: ...

    @overload
    def __truediv__(self, arg: float16_t, /) -> float16_t3: ...

    def __rtruediv__(self, arg: float16_t, /) -> float16_t3: ...

    @overload
    def __iadd__(self, arg: float16_t3, /) -> float16_t3: ...

    @overload
    def __iadd__(self, arg: float16_t, /) -> float16_t3: ...

    @overload
    def __isub__(self, arg: float16_t3, /) -> float16_t3: ...

    @overload
    def __isub__(self, arg: float16_t, /) -> float16_t3: ...

    @overload
    def __imul__(self, arg: float16_t3, /) -> float16_t3: ...

    @overload
    def __imul__(self, arg: float16_t, /) -> float16_t3: ...

    @overload
    def __itruediv__(self, arg: float16_t3, /) -> float16_t3: ...

    @overload
    def __itruediv__(self, arg: float16_t, /) -> float16_t3: ...

    @overload
    def __eq__(self, arg: float16_t3, /) -> bool3: ...

    @overload
    def __eq__(self, arg: float16_t, /) -> bool3: ...

    @overload
    def __eq__(self, arg: float16_t, /) -> bool3: ...

    @overload
    def __ne__(self, arg: float16_t3, /) -> bool3: ...

    @overload
    def __ne__(self, arg: float16_t, /) -> bool3: ...

    @overload
    def __ne__(self, arg: float16_t, /) -> bool3: ...

    @overload
    def __lt__(self, arg: float16_t3, /) -> bool3: ...

    @overload
    def __lt__(self, arg: float16_t, /) -> bool3: ...

    @overload
    def __lt__(self, arg: float16_t, /) -> bool3: ...

    @overload
    def __gt__(self, arg: float16_t, /) -> bool3: ...

    @overload
    def __gt__(self, arg: float16_t3, /) -> bool3: ...

    @overload
    def __gt__(self, arg: float16_t, /) -> bool3: ...

    @overload
    def __le__(self, arg: float16_t3, /) -> bool3: ...

    @overload
    def __le__(self, arg: float16_t, /) -> bool3: ...

    @overload
    def __le__(self, arg: float16_t, /) -> bool3: ...

    @overload
    def __ge__(self, arg: float16_t, /) -> bool3: ...

    @overload
    def __ge__(self, arg: float16_t3, /) -> bool3: ...

    @overload
    def __ge__(self, arg: float16_t, /) -> bool3: ...

class float16_t4:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: float16_t) -> None: ...

    @overload
    def __init__(self, x: float16_t, y: float16_t, z: float16_t, w: float16_t) -> None: ...

    @overload
    def __init__(self, xy: float16_t2, zw: float16_t2) -> None: ...

    @overload
    def __init__(self, xyz: float16_t3, w: float16_t) -> None: ...

    @overload
    def __init__(self, x: float16_t, yzw: float16_t3) -> None: ...

    @overload
    def __init__(self, a: Sequence[float16_t]) -> None: ...

    @property
    def x(self) -> float16_t: ...

    @x.setter
    def x(self, arg: float16_t, /) -> None: ...

    @property
    def y(self) -> float16_t: ...

    @y.setter
    def y(self, arg: float16_t, /) -> None: ...

    @property
    def z(self) -> float16_t: ...

    @z.setter
    def z(self, arg: float16_t, /) -> None: ...

    @property
    def w(self) -> float16_t: ...

    @w.setter
    def w(self, arg: float16_t, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> float16_t: ...

    def __setitem__(self, arg0: int, arg1: float16_t, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __pos__(self) -> float16_t4: ...

    def __neg__(self) -> float16_t4: ...

    @overload
    def __add__(self, arg: float16_t4, /) -> float16_t4: ...

    @overload
    def __add__(self, arg: float16_t, /) -> float16_t4: ...

    def __radd__(self, arg: float16_t, /) -> float16_t4: ...

    @overload
    def __sub__(self, arg: float16_t4, /) -> float16_t4: ...

    @overload
    def __sub__(self, arg: float16_t, /) -> float16_t4: ...

    def __rsub__(self, arg: float16_t, /) -> float16_t4: ...

    @overload
    def __mul__(self, arg: float16_t4, /) -> float16_t4: ...

    @overload
    def __mul__(self, arg: float16_t, /) -> float16_t4: ...

    def __rmul__(self, arg: float16_t, /) -> float16_t4: ...

    @overload
    def __truediv__(self, arg: float16_t4, /) -> float16_t4: ...

    @overload
    def __truediv__(self, arg: float16_t, /) -> float16_t4: ...

    def __rtruediv__(self, arg: float16_t, /) -> float16_t4: ...

    @overload
    def __iadd__(self, arg: float16_t4, /) -> float16_t4: ...

    @overload
    def __iadd__(self, arg: float16_t, /) -> float16_t4: ...

    @overload
    def __isub__(self, arg: float16_t4, /) -> float16_t4: ...

    @overload
    def __isub__(self, arg: float16_t, /) -> float16_t4: ...

    @overload
    def __imul__(self, arg: float16_t4, /) -> float16_t4: ...

    @overload
    def __imul__(self, arg: float16_t, /) -> float16_t4: ...

    @overload
    def __itruediv__(self, arg: float16_t4, /) -> float16_t4: ...

    @overload
    def __itruediv__(self, arg: float16_t, /) -> float16_t4: ...

    @overload
    def __eq__(self, arg: float16_t4, /) -> bool4: ...

    @overload
    def __eq__(self, arg: float16_t, /) -> bool4: ...

    @overload
    def __eq__(self, arg: float16_t, /) -> bool4: ...

    @overload
    def __ne__(self, arg: float16_t4, /) -> bool4: ...

    @overload
    def __ne__(self, arg: float16_t, /) -> bool4: ...

    @overload
    def __ne__(self, arg: float16_t, /) -> bool4: ...

    @overload
    def __lt__(self, arg: float16_t4, /) -> bool4: ...

    @overload
    def __lt__(self, arg: float16_t, /) -> bool4: ...

    @overload
    def __lt__(self, arg: float16_t, /) -> bool4: ...

    @overload
    def __gt__(self, arg: float16_t, /) -> bool4: ...

    @overload
    def __gt__(self, arg: float16_t4, /) -> bool4: ...

    @overload
    def __gt__(self, arg: float16_t, /) -> bool4: ...

    @overload
    def __le__(self, arg: float16_t4, /) -> bool4: ...

    @overload
    def __le__(self, arg: float16_t, /) -> bool4: ...

    @overload
    def __le__(self, arg: float16_t, /) -> bool4: ...

    @overload
    def __ge__(self, arg: float16_t, /) -> bool4: ...

    @overload
    def __ge__(self, arg: float16_t4, /) -> bool4: ...

    @overload
    def __ge__(self, arg: float16_t, /) -> bool4: ...

class float2:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: float) -> None: ...

    @overload
    def __init__(self, x: float, y: float) -> None: ...

    @overload
    def __init__(self, a: Sequence[float]) -> None: ...

    @property
    def x(self) -> float: ...

    @x.setter
    def x(self, arg: float, /) -> None: ...

    @property
    def y(self) -> float: ...

    @y.setter
    def y(self, arg: float, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> float: ...

    def __setitem__(self, arg0: int, arg1: float, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __pos__(self) -> float2: ...

    def __neg__(self) -> float2: ...

    @overload
    def __add__(self, arg: float2, /) -> float2: ...

    @overload
    def __add__(self, arg: float, /) -> float2: ...

    def __radd__(self, arg: float, /) -> float2: ...

    @overload
    def __sub__(self, arg: float2, /) -> float2: ...

    @overload
    def __sub__(self, arg: float, /) -> float2: ...

    def __rsub__(self, arg: float, /) -> float2: ...

    @overload
    def __mul__(self, arg: float2, /) -> float2: ...

    @overload
    def __mul__(self, arg: float, /) -> float2: ...

    def __rmul__(self, arg: float, /) -> float2: ...

    @overload
    def __truediv__(self, arg: float2, /) -> float2: ...

    @overload
    def __truediv__(self, arg: float, /) -> float2: ...

    def __rtruediv__(self, arg: float, /) -> float2: ...

    @overload
    def __iadd__(self, arg: float2, /) -> float2: ...

    @overload
    def __iadd__(self, arg: float, /) -> float2: ...

    @overload
    def __isub__(self, arg: float2, /) -> float2: ...

    @overload
    def __isub__(self, arg: float, /) -> float2: ...

    @overload
    def __imul__(self, arg: float2, /) -> float2: ...

    @overload
    def __imul__(self, arg: float, /) -> float2: ...

    @overload
    def __itruediv__(self, arg: float2, /) -> float2: ...

    @overload
    def __itruediv__(self, arg: float, /) -> float2: ...

    @overload
    def __eq__(self, arg: float2, /) -> bool2: ...

    @overload
    def __eq__(self, arg: float, /) -> bool2: ...

    @overload
    def __eq__(self, arg: float, /) -> bool2: ...

    @overload
    def __ne__(self, arg: float2, /) -> bool2: ...

    @overload
    def __ne__(self, arg: float, /) -> bool2: ...

    @overload
    def __ne__(self, arg: float, /) -> bool2: ...

    @overload
    def __lt__(self, arg: float2, /) -> bool2: ...

    @overload
    def __lt__(self, arg: float, /) -> bool2: ...

    @overload
    def __lt__(self, arg: float, /) -> bool2: ...

    @overload
    def __gt__(self, arg: float, /) -> bool2: ...

    @overload
    def __gt__(self, arg: float2, /) -> bool2: ...

    @overload
    def __gt__(self, arg: float, /) -> bool2: ...

    @overload
    def __le__(self, arg: float2, /) -> bool2: ...

    @overload
    def __le__(self, arg: float, /) -> bool2: ...

    @overload
    def __le__(self, arg: float, /) -> bool2: ...

    @overload
    def __ge__(self, arg: float, /) -> bool2: ...

    @overload
    def __ge__(self, arg: float2, /) -> bool2: ...

    @overload
    def __ge__(self, arg: float, /) -> bool2: ...

class float2x2:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, arg: Sequence[float], /) -> None: ...

    @overload
    def __init__(self, arg: Annotated[ArrayLike, dict(dtype='float32', shape=(2, 2))], /) -> None: ...

    @staticmethod
    def zeros() -> float2x2: ...

    @staticmethod
    def identity() -> float2x2: ...

    @overload
    def __getitem__(self, arg: int, /) -> float2: ...

    @overload
    def __getitem__(self, arg: Sequence[int], /) -> float: ...

    @overload
    def __setitem__(self, arg0: int, arg1: float2, /) -> None: ...

    @overload
    def __setitem__(self, arg0: Sequence[int], arg1: float, /) -> None: ...

    def get_row(self, row: int) -> float2: ...

    def set_row(self, row: int, value: float2) -> None: ...

    def get_col(self, col: int) -> float2: ...

    def set_col(self, col: int, value: float2) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __dlpack__(self) -> Annotated[ArrayLike, dict(dtype='float32')]: ...

    def to_numpy(self) -> Annotated[ArrayLike, dict(dtype='float32', shape=(2, 2), writable=False)]: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __eq__(self, arg: float2x2, /) -> bool: ...

    def __ne__(self, arg: float2x2, /) -> bool: ...

class float2x4:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, arg: Sequence[float], /) -> None: ...

    @overload
    def __init__(self, arg: Annotated[ArrayLike, dict(dtype='float32', shape=(2, 4))], /) -> None: ...

    @staticmethod
    def zeros() -> float2x4: ...

    @staticmethod
    def identity() -> float2x4: ...

    @overload
    def __getitem__(self, arg: int, /) -> float4: ...

    @overload
    def __getitem__(self, arg: Sequence[int], /) -> float: ...

    @overload
    def __setitem__(self, arg0: int, arg1: float4, /) -> None: ...

    @overload
    def __setitem__(self, arg0: Sequence[int], arg1: float, /) -> None: ...

    def get_row(self, row: int) -> float4: ...

    def set_row(self, row: int, value: float4) -> None: ...

    def get_col(self, col: int) -> float2: ...

    def set_col(self, col: int, value: float2) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __dlpack__(self) -> Annotated[ArrayLike, dict(dtype='float32')]: ...

    def to_numpy(self) -> Annotated[ArrayLike, dict(dtype='float32', shape=(2, 4), writable=False)]: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __eq__(self, arg: float2x4, /) -> bool: ...

    def __ne__(self, arg: float2x4, /) -> bool: ...

class float3:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: float) -> None: ...

    @overload
    def __init__(self, x: float, y: float, z: float) -> None: ...

    @overload
    def __init__(self, xy: float2, z: float) -> None: ...

    @overload
    def __init__(self, x: float, yz: float2) -> None: ...

    @overload
    def __init__(self, a: Sequence[float]) -> None: ...

    @property
    def x(self) -> float: ...

    @x.setter
    def x(self, arg: float, /) -> None: ...

    @property
    def y(self) -> float: ...

    @y.setter
    def y(self, arg: float, /) -> None: ...

    @property
    def z(self) -> float: ...

    @z.setter
    def z(self, arg: float, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> float: ...

    def __setitem__(self, arg0: int, arg1: float, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __pos__(self) -> float3: ...

    def __neg__(self) -> float3: ...

    @overload
    def __add__(self, arg: float3, /) -> float3: ...

    @overload
    def __add__(self, arg: float, /) -> float3: ...

    def __radd__(self, arg: float, /) -> float3: ...

    @overload
    def __sub__(self, arg: float3, /) -> float3: ...

    @overload
    def __sub__(self, arg: float, /) -> float3: ...

    def __rsub__(self, arg: float, /) -> float3: ...

    @overload
    def __mul__(self, arg: float3, /) -> float3: ...

    @overload
    def __mul__(self, arg: float, /) -> float3: ...

    def __rmul__(self, arg: float, /) -> float3: ...

    @overload
    def __truediv__(self, arg: float3, /) -> float3: ...

    @overload
    def __truediv__(self, arg: float, /) -> float3: ...

    def __rtruediv__(self, arg: float, /) -> float3: ...

    @overload
    def __iadd__(self, arg: float3, /) -> float3: ...

    @overload
    def __iadd__(self, arg: float, /) -> float3: ...

    @overload
    def __isub__(self, arg: float3, /) -> float3: ...

    @overload
    def __isub__(self, arg: float, /) -> float3: ...

    @overload
    def __imul__(self, arg: float3, /) -> float3: ...

    @overload
    def __imul__(self, arg: float, /) -> float3: ...

    @overload
    def __itruediv__(self, arg: float3, /) -> float3: ...

    @overload
    def __itruediv__(self, arg: float, /) -> float3: ...

    @overload
    def __eq__(self, arg: float3, /) -> bool3: ...

    @overload
    def __eq__(self, arg: float, /) -> bool3: ...

    @overload
    def __eq__(self, arg: float, /) -> bool3: ...

    @overload
    def __ne__(self, arg: float3, /) -> bool3: ...

    @overload
    def __ne__(self, arg: float, /) -> bool3: ...

    @overload
    def __ne__(self, arg: float, /) -> bool3: ...

    @overload
    def __lt__(self, arg: float3, /) -> bool3: ...

    @overload
    def __lt__(self, arg: float, /) -> bool3: ...

    @overload
    def __lt__(self, arg: float, /) -> bool3: ...

    @overload
    def __gt__(self, arg: float, /) -> bool3: ...

    @overload
    def __gt__(self, arg: float3, /) -> bool3: ...

    @overload
    def __gt__(self, arg: float, /) -> bool3: ...

    @overload
    def __le__(self, arg: float3, /) -> bool3: ...

    @overload
    def __le__(self, arg: float, /) -> bool3: ...

    @overload
    def __le__(self, arg: float, /) -> bool3: ...

    @overload
    def __ge__(self, arg: float, /) -> bool3: ...

    @overload
    def __ge__(self, arg: float3, /) -> bool3: ...

    @overload
    def __ge__(self, arg: float, /) -> bool3: ...

class float3x3:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, arg: float4x4, /) -> None: ...

    @overload
    def __init__(self, arg: float3x4, /) -> None: ...

    @overload
    def __init__(self, arg: Sequence[float], /) -> None: ...

    @overload
    def __init__(self, arg: Annotated[ArrayLike, dict(dtype='float32', shape=(3, 3))], /) -> None: ...

    @staticmethod
    def zeros() -> float3x3: ...

    @staticmethod
    def identity() -> float3x3: ...

    @overload
    def __getitem__(self, arg: int, /) -> float3: ...

    @overload
    def __getitem__(self, arg: Sequence[int], /) -> float: ...

    @overload
    def __setitem__(self, arg0: int, arg1: float3, /) -> None: ...

    @overload
    def __setitem__(self, arg0: Sequence[int], arg1: float, /) -> None: ...

    def get_row(self, row: int) -> float3: ...

    def set_row(self, row: int, value: float3) -> None: ...

    def get_col(self, col: int) -> float3: ...

    def set_col(self, col: int, value: float3) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __dlpack__(self) -> Annotated[ArrayLike, dict(dtype='float32')]: ...

    def to_numpy(self) -> Annotated[ArrayLike, dict(dtype='float32', shape=(3, 3), writable=False)]: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __eq__(self, arg: float3x3, /) -> bool: ...

    def __ne__(self, arg: float3x3, /) -> bool: ...

class float3x4:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, arg: float3x3, /) -> None: ...

    @overload
    def __init__(self, arg: float4x4, /) -> None: ...

    @overload
    def __init__(self, arg: Sequence[float], /) -> None: ...

    @overload
    def __init__(self, arg: Annotated[ArrayLike, dict(dtype='float32', shape=(3, 4))], /) -> None: ...

    @staticmethod
    def zeros() -> float3x4: ...

    @staticmethod
    def identity() -> float3x4: ...

    @overload
    def __getitem__(self, arg: int, /) -> float4: ...

    @overload
    def __getitem__(self, arg: Sequence[int], /) -> float: ...

    @overload
    def __setitem__(self, arg0: int, arg1: float4, /) -> None: ...

    @overload
    def __setitem__(self, arg0: Sequence[int], arg1: float, /) -> None: ...

    def get_row(self, row: int) -> float4: ...

    def set_row(self, row: int, value: float4) -> None: ...

    def get_col(self, col: int) -> float3: ...

    def set_col(self, col: int, value: float3) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __dlpack__(self) -> Annotated[ArrayLike, dict(dtype='float32')]: ...

    def to_numpy(self) -> Annotated[ArrayLike, dict(dtype='float32', shape=(3, 4), writable=False)]: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __eq__(self, arg: float3x4, /) -> bool: ...

    def __ne__(self, arg: float3x4, /) -> bool: ...

class float4:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: float) -> None: ...

    @overload
    def __init__(self, x: float, y: float, z: float, w: float) -> None: ...

    @overload
    def __init__(self, xy: float2, zw: float2) -> None: ...

    @overload
    def __init__(self, xyz: float3, w: float) -> None: ...

    @overload
    def __init__(self, x: float, yzw: float3) -> None: ...

    @overload
    def __init__(self, a: Sequence[float]) -> None: ...

    @property
    def x(self) -> float: ...

    @x.setter
    def x(self, arg: float, /) -> None: ...

    @property
    def y(self) -> float: ...

    @y.setter
    def y(self, arg: float, /) -> None: ...

    @property
    def z(self) -> float: ...

    @z.setter
    def z(self, arg: float, /) -> None: ...

    @property
    def w(self) -> float: ...

    @w.setter
    def w(self, arg: float, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> float: ...

    def __setitem__(self, arg0: int, arg1: float, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __pos__(self) -> float4: ...

    def __neg__(self) -> float4: ...

    @overload
    def __add__(self, arg: float4, /) -> float4: ...

    @overload
    def __add__(self, arg: float, /) -> float4: ...

    def __radd__(self, arg: float, /) -> float4: ...

    @overload
    def __sub__(self, arg: float4, /) -> float4: ...

    @overload
    def __sub__(self, arg: float, /) -> float4: ...

    def __rsub__(self, arg: float, /) -> float4: ...

    @overload
    def __mul__(self, arg: float4, /) -> float4: ...

    @overload
    def __mul__(self, arg: float, /) -> float4: ...

    def __rmul__(self, arg: float, /) -> float4: ...

    @overload
    def __truediv__(self, arg: float4, /) -> float4: ...

    @overload
    def __truediv__(self, arg: float, /) -> float4: ...

    def __rtruediv__(self, arg: float, /) -> float4: ...

    @overload
    def __iadd__(self, arg: float4, /) -> float4: ...

    @overload
    def __iadd__(self, arg: float, /) -> float4: ...

    @overload
    def __isub__(self, arg: float4, /) -> float4: ...

    @overload
    def __isub__(self, arg: float, /) -> float4: ...

    @overload
    def __imul__(self, arg: float4, /) -> float4: ...

    @overload
    def __imul__(self, arg: float, /) -> float4: ...

    @overload
    def __itruediv__(self, arg: float4, /) -> float4: ...

    @overload
    def __itruediv__(self, arg: float, /) -> float4: ...

    @overload
    def __eq__(self, arg: float4, /) -> bool4: ...

    @overload
    def __eq__(self, arg: float, /) -> bool4: ...

    @overload
    def __eq__(self, arg: float, /) -> bool4: ...

    @overload
    def __ne__(self, arg: float4, /) -> bool4: ...

    @overload
    def __ne__(self, arg: float, /) -> bool4: ...

    @overload
    def __ne__(self, arg: float, /) -> bool4: ...

    @overload
    def __lt__(self, arg: float4, /) -> bool4: ...

    @overload
    def __lt__(self, arg: float, /) -> bool4: ...

    @overload
    def __lt__(self, arg: float, /) -> bool4: ...

    @overload
    def __gt__(self, arg: float, /) -> bool4: ...

    @overload
    def __gt__(self, arg: float4, /) -> bool4: ...

    @overload
    def __gt__(self, arg: float, /) -> bool4: ...

    @overload
    def __le__(self, arg: float4, /) -> bool4: ...

    @overload
    def __le__(self, arg: float, /) -> bool4: ...

    @overload
    def __le__(self, arg: float, /) -> bool4: ...

    @overload
    def __ge__(self, arg: float, /) -> bool4: ...

    @overload
    def __ge__(self, arg: float4, /) -> bool4: ...

    @overload
    def __ge__(self, arg: float, /) -> bool4: ...

class float4x4:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, arg: float3x3, /) -> None: ...

    @overload
    def __init__(self, arg: float3x4, /) -> None: ...

    @overload
    def __init__(self, arg: Sequence[float], /) -> None: ...

    @overload
    def __init__(self, arg: Annotated[ArrayLike, dict(dtype='float32', shape=(4, 4))], /) -> None: ...

    @staticmethod
    def zeros() -> float4x4: ...

    @staticmethod
    def identity() -> float4x4: ...

    @overload
    def __getitem__(self, arg: int, /) -> float4: ...

    @overload
    def __getitem__(self, arg: Sequence[int], /) -> float: ...

    @overload
    def __setitem__(self, arg0: int, arg1: float4, /) -> None: ...

    @overload
    def __setitem__(self, arg0: Sequence[int], arg1: float, /) -> None: ...

    def get_row(self, row: int) -> float4: ...

    def set_row(self, row: int, value: float4) -> None: ...

    def get_col(self, col: int) -> float4: ...

    def set_col(self, col: int, value: float4) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __dlpack__(self) -> Annotated[ArrayLike, dict(dtype='float32')]: ...

    def to_numpy(self) -> Annotated[ArrayLike, dict(dtype='float32', shape=(4, 4), writable=False)]: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __eq__(self, arg: float4x4, /) -> bool: ...

    def __ne__(self, arg: float4x4, /) -> bool: ...

@overload
def floor(x: float) -> float: ...

@overload
def floor(x: float) -> float: ...

@overload
def floor(x: float1) -> float1: ...

@overload
def floor(x: float2) -> float2: ...

@overload
def floor(x: float3) -> float3: ...

@overload
def floor(x: float4) -> float4: ...

@overload
def fmod(x: float, y: float) -> float: ...

@overload
def fmod(x: float, y: float) -> float: ...

@overload
def fmod(x: float1, y: float1) -> float1: ...

@overload
def fmod(x: float2, y: float2) -> float2: ...

@overload
def fmod(x: float3, y: float3) -> float3: ...

@overload
def fmod(x: float4, y: float4) -> float4: ...

@overload
def frac(x: float) -> float: ...

@overload
def frac(x: float) -> float: ...

@overload
def frac(x: float1) -> float1: ...

@overload
def frac(x: float2) -> float2: ...

@overload
def frac(x: float3) -> float3: ...

@overload
def frac(x: float4) -> float4: ...

class int1:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: int) -> None: ...

    @overload
    def __init__(self, a: Sequence[int]) -> None: ...

    @property
    def x(self) -> int: ...

    @x.setter
    def x(self, arg: int, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> int: ...

    def __setitem__(self, arg0: int, arg1: int, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __pos__(self) -> int1: ...

    def __neg__(self) -> int1: ...

    @overload
    def __add__(self, arg: int1, /) -> int1: ...

    @overload
    def __add__(self, arg: int, /) -> int1: ...

    def __radd__(self, arg: int, /) -> int1: ...

    @overload
    def __sub__(self, arg: int1, /) -> int1: ...

    @overload
    def __sub__(self, arg: int, /) -> int1: ...

    def __rsub__(self, arg: int, /) -> int1: ...

    @overload
    def __mul__(self, arg: int1, /) -> int1: ...

    @overload
    def __mul__(self, arg: int, /) -> int1: ...

    def __rmul__(self, arg: int, /) -> int1: ...

    @overload
    def __truediv__(self, arg: int1, /) -> int1: ...

    @overload
    def __truediv__(self, arg: int, /) -> int1: ...

    def __rtruediv__(self, arg: int, /) -> int1: ...

    @overload
    def __iadd__(self, arg: int1, /) -> int1: ...

    @overload
    def __iadd__(self, arg: int, /) -> int1: ...

    @overload
    def __isub__(self, arg: int1, /) -> int1: ...

    @overload
    def __isub__(self, arg: int, /) -> int1: ...

    @overload
    def __imul__(self, arg: int1, /) -> int1: ...

    @overload
    def __imul__(self, arg: int, /) -> int1: ...

    @overload
    def __itruediv__(self, arg: int1, /) -> int1: ...

    @overload
    def __itruediv__(self, arg: int, /) -> int1: ...

    @overload
    def __mod__(self, arg: int1, /) -> int1: ...

    @overload
    def __mod__(self, arg: int, /) -> int1: ...

    def __rmod__(self, arg: int, /) -> int1: ...

    @overload
    def __lshift__(self, arg: int1, /) -> int1: ...

    @overload
    def __lshift__(self, arg: int, /) -> int1: ...

    def __rlshift__(self, arg: int, /) -> int1: ...

    @overload
    def __rshift__(self, arg: int1, /) -> int1: ...

    @overload
    def __rshift__(self, arg: int, /) -> int1: ...

    def __rrshift__(self, arg: int, /) -> int1: ...

    @overload
    def __or__(self, arg: int1, /) -> int1: ...

    @overload
    def __or__(self, arg: int, /) -> int1: ...

    def __ror__(self, arg: int, /) -> int1: ...

    @overload
    def __and__(self, arg: int1, /) -> int1: ...

    @overload
    def __and__(self, arg: int, /) -> int1: ...

    def __rand__(self, arg: int, /) -> int1: ...

    @overload
    def __xor__(self, arg: int1, /) -> int1: ...

    @overload
    def __xor__(self, arg: int, /) -> int1: ...

    def __rxor__(self, arg: int, /) -> int1: ...

    @overload
    def __imod__(self, arg: int1, /) -> int1: ...

    @overload
    def __imod__(self, arg: int, /) -> int1: ...

    @overload
    def __ilshift__(self, arg: int1, /) -> int1: ...

    @overload
    def __ilshift__(self, arg: int, /) -> int1: ...

    @overload
    def __irshift__(self, arg: int1, /) -> int1: ...

    @overload
    def __irshift__(self, arg: int, /) -> int1: ...

    @overload
    def __ior__(self, arg: int1, /) -> int1: ...

    @overload
    def __ior__(self, arg: int, /) -> int1: ...

    @overload
    def __iand__(self, arg: int1, /) -> int1: ...

    @overload
    def __iand__(self, arg: int, /) -> int1: ...

    @overload
    def __ixor__(self, arg: int1, /) -> int1: ...

    @overload
    def __ixor__(self, arg: int, /) -> int1: ...

    @overload
    def __eq__(self, arg: int1, /) -> bool1: ...

    @overload
    def __eq__(self, arg: int, /) -> bool1: ...

    @overload
    def __eq__(self, arg: int, /) -> bool1: ...

    @overload
    def __ne__(self, arg: int1, /) -> bool1: ...

    @overload
    def __ne__(self, arg: int, /) -> bool1: ...

    @overload
    def __ne__(self, arg: int, /) -> bool1: ...

    @overload
    def __lt__(self, arg: int1, /) -> bool1: ...

    @overload
    def __lt__(self, arg: int, /) -> bool1: ...

    @overload
    def __lt__(self, arg: int, /) -> bool1: ...

    @overload
    def __gt__(self, arg: int, /) -> bool1: ...

    @overload
    def __gt__(self, arg: int1, /) -> bool1: ...

    @overload
    def __gt__(self, arg: int, /) -> bool1: ...

    @overload
    def __le__(self, arg: int1, /) -> bool1: ...

    @overload
    def __le__(self, arg: int, /) -> bool1: ...

    @overload
    def __le__(self, arg: int, /) -> bool1: ...

    @overload
    def __ge__(self, arg: int, /) -> bool1: ...

    @overload
    def __ge__(self, arg: int1, /) -> bool1: ...

    @overload
    def __ge__(self, arg: int, /) -> bool1: ...

class int2:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: int) -> None: ...

    @overload
    def __init__(self, x: int, y: int) -> None: ...

    @overload
    def __init__(self, a: Sequence[int]) -> None: ...

    @property
    def x(self) -> int: ...

    @x.setter
    def x(self, arg: int, /) -> None: ...

    @property
    def y(self) -> int: ...

    @y.setter
    def y(self, arg: int, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> int: ...

    def __setitem__(self, arg0: int, arg1: int, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __pos__(self) -> int2: ...

    def __neg__(self) -> int2: ...

    @overload
    def __add__(self, arg: int2, /) -> int2: ...

    @overload
    def __add__(self, arg: int, /) -> int2: ...

    def __radd__(self, arg: int, /) -> int2: ...

    @overload
    def __sub__(self, arg: int2, /) -> int2: ...

    @overload
    def __sub__(self, arg: int, /) -> int2: ...

    def __rsub__(self, arg: int, /) -> int2: ...

    @overload
    def __mul__(self, arg: int2, /) -> int2: ...

    @overload
    def __mul__(self, arg: int, /) -> int2: ...

    def __rmul__(self, arg: int, /) -> int2: ...

    @overload
    def __truediv__(self, arg: int2, /) -> int2: ...

    @overload
    def __truediv__(self, arg: int, /) -> int2: ...

    def __rtruediv__(self, arg: int, /) -> int2: ...

    @overload
    def __iadd__(self, arg: int2, /) -> int2: ...

    @overload
    def __iadd__(self, arg: int, /) -> int2: ...

    @overload
    def __isub__(self, arg: int2, /) -> int2: ...

    @overload
    def __isub__(self, arg: int, /) -> int2: ...

    @overload
    def __imul__(self, arg: int2, /) -> int2: ...

    @overload
    def __imul__(self, arg: int, /) -> int2: ...

    @overload
    def __itruediv__(self, arg: int2, /) -> int2: ...

    @overload
    def __itruediv__(self, arg: int, /) -> int2: ...

    @overload
    def __mod__(self, arg: int2, /) -> int2: ...

    @overload
    def __mod__(self, arg: int, /) -> int2: ...

    def __rmod__(self, arg: int, /) -> int2: ...

    @overload
    def __lshift__(self, arg: int2, /) -> int2: ...

    @overload
    def __lshift__(self, arg: int, /) -> int2: ...

    def __rlshift__(self, arg: int, /) -> int2: ...

    @overload
    def __rshift__(self, arg: int2, /) -> int2: ...

    @overload
    def __rshift__(self, arg: int, /) -> int2: ...

    def __rrshift__(self, arg: int, /) -> int2: ...

    @overload
    def __or__(self, arg: int2, /) -> int2: ...

    @overload
    def __or__(self, arg: int, /) -> int2: ...

    def __ror__(self, arg: int, /) -> int2: ...

    @overload
    def __and__(self, arg: int2, /) -> int2: ...

    @overload
    def __and__(self, arg: int, /) -> int2: ...

    def __rand__(self, arg: int, /) -> int2: ...

    @overload
    def __xor__(self, arg: int2, /) -> int2: ...

    @overload
    def __xor__(self, arg: int, /) -> int2: ...

    def __rxor__(self, arg: int, /) -> int2: ...

    @overload
    def __imod__(self, arg: int2, /) -> int2: ...

    @overload
    def __imod__(self, arg: int, /) -> int2: ...

    @overload
    def __ilshift__(self, arg: int2, /) -> int2: ...

    @overload
    def __ilshift__(self, arg: int, /) -> int2: ...

    @overload
    def __irshift__(self, arg: int2, /) -> int2: ...

    @overload
    def __irshift__(self, arg: int, /) -> int2: ...

    @overload
    def __ior__(self, arg: int2, /) -> int2: ...

    @overload
    def __ior__(self, arg: int, /) -> int2: ...

    @overload
    def __iand__(self, arg: int2, /) -> int2: ...

    @overload
    def __iand__(self, arg: int, /) -> int2: ...

    @overload
    def __ixor__(self, arg: int2, /) -> int2: ...

    @overload
    def __ixor__(self, arg: int, /) -> int2: ...

    @overload
    def __eq__(self, arg: int2, /) -> bool2: ...

    @overload
    def __eq__(self, arg: int, /) -> bool2: ...

    @overload
    def __eq__(self, arg: int, /) -> bool2: ...

    @overload
    def __ne__(self, arg: int2, /) -> bool2: ...

    @overload
    def __ne__(self, arg: int, /) -> bool2: ...

    @overload
    def __ne__(self, arg: int, /) -> bool2: ...

    @overload
    def __lt__(self, arg: int2, /) -> bool2: ...

    @overload
    def __lt__(self, arg: int, /) -> bool2: ...

    @overload
    def __lt__(self, arg: int, /) -> bool2: ...

    @overload
    def __gt__(self, arg: int, /) -> bool2: ...

    @overload
    def __gt__(self, arg: int2, /) -> bool2: ...

    @overload
    def __gt__(self, arg: int, /) -> bool2: ...

    @overload
    def __le__(self, arg: int2, /) -> bool2: ...

    @overload
    def __le__(self, arg: int, /) -> bool2: ...

    @overload
    def __le__(self, arg: int, /) -> bool2: ...

    @overload
    def __ge__(self, arg: int, /) -> bool2: ...

    @overload
    def __ge__(self, arg: int2, /) -> bool2: ...

    @overload
    def __ge__(self, arg: int, /) -> bool2: ...

class int3:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: int) -> None: ...

    @overload
    def __init__(self, x: int, y: int, z: int) -> None: ...

    @overload
    def __init__(self, xy: int2, z: int) -> None: ...

    @overload
    def __init__(self, x: int, yz: int2) -> None: ...

    @overload
    def __init__(self, a: Sequence[int]) -> None: ...

    @property
    def x(self) -> int: ...

    @x.setter
    def x(self, arg: int, /) -> None: ...

    @property
    def y(self) -> int: ...

    @y.setter
    def y(self, arg: int, /) -> None: ...

    @property
    def z(self) -> int: ...

    @z.setter
    def z(self, arg: int, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> int: ...

    def __setitem__(self, arg0: int, arg1: int, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __pos__(self) -> int3: ...

    def __neg__(self) -> int3: ...

    @overload
    def __add__(self, arg: int3, /) -> int3: ...

    @overload
    def __add__(self, arg: int, /) -> int3: ...

    def __radd__(self, arg: int, /) -> int3: ...

    @overload
    def __sub__(self, arg: int3, /) -> int3: ...

    @overload
    def __sub__(self, arg: int, /) -> int3: ...

    def __rsub__(self, arg: int, /) -> int3: ...

    @overload
    def __mul__(self, arg: int3, /) -> int3: ...

    @overload
    def __mul__(self, arg: int, /) -> int3: ...

    def __rmul__(self, arg: int, /) -> int3: ...

    @overload
    def __truediv__(self, arg: int3, /) -> int3: ...

    @overload
    def __truediv__(self, arg: int, /) -> int3: ...

    def __rtruediv__(self, arg: int, /) -> int3: ...

    @overload
    def __iadd__(self, arg: int3, /) -> int3: ...

    @overload
    def __iadd__(self, arg: int, /) -> int3: ...

    @overload
    def __isub__(self, arg: int3, /) -> int3: ...

    @overload
    def __isub__(self, arg: int, /) -> int3: ...

    @overload
    def __imul__(self, arg: int3, /) -> int3: ...

    @overload
    def __imul__(self, arg: int, /) -> int3: ...

    @overload
    def __itruediv__(self, arg: int3, /) -> int3: ...

    @overload
    def __itruediv__(self, arg: int, /) -> int3: ...

    @overload
    def __mod__(self, arg: int3, /) -> int3: ...

    @overload
    def __mod__(self, arg: int, /) -> int3: ...

    def __rmod__(self, arg: int, /) -> int3: ...

    @overload
    def __lshift__(self, arg: int3, /) -> int3: ...

    @overload
    def __lshift__(self, arg: int, /) -> int3: ...

    def __rlshift__(self, arg: int, /) -> int3: ...

    @overload
    def __rshift__(self, arg: int3, /) -> int3: ...

    @overload
    def __rshift__(self, arg: int, /) -> int3: ...

    def __rrshift__(self, arg: int, /) -> int3: ...

    @overload
    def __or__(self, arg: int3, /) -> int3: ...

    @overload
    def __or__(self, arg: int, /) -> int3: ...

    def __ror__(self, arg: int, /) -> int3: ...

    @overload
    def __and__(self, arg: int3, /) -> int3: ...

    @overload
    def __and__(self, arg: int, /) -> int3: ...

    def __rand__(self, arg: int, /) -> int3: ...

    @overload
    def __xor__(self, arg: int3, /) -> int3: ...

    @overload
    def __xor__(self, arg: int, /) -> int3: ...

    def __rxor__(self, arg: int, /) -> int3: ...

    @overload
    def __imod__(self, arg: int3, /) -> int3: ...

    @overload
    def __imod__(self, arg: int, /) -> int3: ...

    @overload
    def __ilshift__(self, arg: int3, /) -> int3: ...

    @overload
    def __ilshift__(self, arg: int, /) -> int3: ...

    @overload
    def __irshift__(self, arg: int3, /) -> int3: ...

    @overload
    def __irshift__(self, arg: int, /) -> int3: ...

    @overload
    def __ior__(self, arg: int3, /) -> int3: ...

    @overload
    def __ior__(self, arg: int, /) -> int3: ...

    @overload
    def __iand__(self, arg: int3, /) -> int3: ...

    @overload
    def __iand__(self, arg: int, /) -> int3: ...

    @overload
    def __ixor__(self, arg: int3, /) -> int3: ...

    @overload
    def __ixor__(self, arg: int, /) -> int3: ...

    @overload
    def __eq__(self, arg: int3, /) -> bool3: ...

    @overload
    def __eq__(self, arg: int, /) -> bool3: ...

    @overload
    def __eq__(self, arg: int, /) -> bool3: ...

    @overload
    def __ne__(self, arg: int3, /) -> bool3: ...

    @overload
    def __ne__(self, arg: int, /) -> bool3: ...

    @overload
    def __ne__(self, arg: int, /) -> bool3: ...

    @overload
    def __lt__(self, arg: int3, /) -> bool3: ...

    @overload
    def __lt__(self, arg: int, /) -> bool3: ...

    @overload
    def __lt__(self, arg: int, /) -> bool3: ...

    @overload
    def __gt__(self, arg: int, /) -> bool3: ...

    @overload
    def __gt__(self, arg: int3, /) -> bool3: ...

    @overload
    def __gt__(self, arg: int, /) -> bool3: ...

    @overload
    def __le__(self, arg: int3, /) -> bool3: ...

    @overload
    def __le__(self, arg: int, /) -> bool3: ...

    @overload
    def __le__(self, arg: int, /) -> bool3: ...

    @overload
    def __ge__(self, arg: int, /) -> bool3: ...

    @overload
    def __ge__(self, arg: int3, /) -> bool3: ...

    @overload
    def __ge__(self, arg: int, /) -> bool3: ...

class int4:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: int) -> None: ...

    @overload
    def __init__(self, x: int, y: int, z: int, w: int) -> None: ...

    @overload
    def __init__(self, xy: int2, zw: int2) -> None: ...

    @overload
    def __init__(self, xyz: int3, w: int) -> None: ...

    @overload
    def __init__(self, x: int, yzw: int3) -> None: ...

    @overload
    def __init__(self, a: Sequence[int]) -> None: ...

    @property
    def x(self) -> int: ...

    @x.setter
    def x(self, arg: int, /) -> None: ...

    @property
    def y(self) -> int: ...

    @y.setter
    def y(self, arg: int, /) -> None: ...

    @property
    def z(self) -> int: ...

    @z.setter
    def z(self, arg: int, /) -> None: ...

    @property
    def w(self) -> int: ...

    @w.setter
    def w(self, arg: int, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> int: ...

    def __setitem__(self, arg0: int, arg1: int, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __pos__(self) -> int4: ...

    def __neg__(self) -> int4: ...

    @overload
    def __add__(self, arg: int4, /) -> int4: ...

    @overload
    def __add__(self, arg: int, /) -> int4: ...

    def __radd__(self, arg: int, /) -> int4: ...

    @overload
    def __sub__(self, arg: int4, /) -> int4: ...

    @overload
    def __sub__(self, arg: int, /) -> int4: ...

    def __rsub__(self, arg: int, /) -> int4: ...

    @overload
    def __mul__(self, arg: int4, /) -> int4: ...

    @overload
    def __mul__(self, arg: int, /) -> int4: ...

    def __rmul__(self, arg: int, /) -> int4: ...

    @overload
    def __truediv__(self, arg: int4, /) -> int4: ...

    @overload
    def __truediv__(self, arg: int, /) -> int4: ...

    def __rtruediv__(self, arg: int, /) -> int4: ...

    @overload
    def __iadd__(self, arg: int4, /) -> int4: ...

    @overload
    def __iadd__(self, arg: int, /) -> int4: ...

    @overload
    def __isub__(self, arg: int4, /) -> int4: ...

    @overload
    def __isub__(self, arg: int, /) -> int4: ...

    @overload
    def __imul__(self, arg: int4, /) -> int4: ...

    @overload
    def __imul__(self, arg: int, /) -> int4: ...

    @overload
    def __itruediv__(self, arg: int4, /) -> int4: ...

    @overload
    def __itruediv__(self, arg: int, /) -> int4: ...

    @overload
    def __mod__(self, arg: int4, /) -> int4: ...

    @overload
    def __mod__(self, arg: int, /) -> int4: ...

    def __rmod__(self, arg: int, /) -> int4: ...

    @overload
    def __lshift__(self, arg: int4, /) -> int4: ...

    @overload
    def __lshift__(self, arg: int, /) -> int4: ...

    def __rlshift__(self, arg: int, /) -> int4: ...

    @overload
    def __rshift__(self, arg: int4, /) -> int4: ...

    @overload
    def __rshift__(self, arg: int, /) -> int4: ...

    def __rrshift__(self, arg: int, /) -> int4: ...

    @overload
    def __or__(self, arg: int4, /) -> int4: ...

    @overload
    def __or__(self, arg: int, /) -> int4: ...

    def __ror__(self, arg: int, /) -> int4: ...

    @overload
    def __and__(self, arg: int4, /) -> int4: ...

    @overload
    def __and__(self, arg: int, /) -> int4: ...

    def __rand__(self, arg: int, /) -> int4: ...

    @overload
    def __xor__(self, arg: int4, /) -> int4: ...

    @overload
    def __xor__(self, arg: int, /) -> int4: ...

    def __rxor__(self, arg: int, /) -> int4: ...

    @overload
    def __imod__(self, arg: int4, /) -> int4: ...

    @overload
    def __imod__(self, arg: int, /) -> int4: ...

    @overload
    def __ilshift__(self, arg: int4, /) -> int4: ...

    @overload
    def __ilshift__(self, arg: int, /) -> int4: ...

    @overload
    def __irshift__(self, arg: int4, /) -> int4: ...

    @overload
    def __irshift__(self, arg: int, /) -> int4: ...

    @overload
    def __ior__(self, arg: int4, /) -> int4: ...

    @overload
    def __ior__(self, arg: int, /) -> int4: ...

    @overload
    def __iand__(self, arg: int4, /) -> int4: ...

    @overload
    def __iand__(self, arg: int, /) -> int4: ...

    @overload
    def __ixor__(self, arg: int4, /) -> int4: ...

    @overload
    def __ixor__(self, arg: int, /) -> int4: ...

    @overload
    def __eq__(self, arg: int4, /) -> bool4: ...

    @overload
    def __eq__(self, arg: int, /) -> bool4: ...

    @overload
    def __eq__(self, arg: int, /) -> bool4: ...

    @overload
    def __ne__(self, arg: int4, /) -> bool4: ...

    @overload
    def __ne__(self, arg: int, /) -> bool4: ...

    @overload
    def __ne__(self, arg: int, /) -> bool4: ...

    @overload
    def __lt__(self, arg: int4, /) -> bool4: ...

    @overload
    def __lt__(self, arg: int, /) -> bool4: ...

    @overload
    def __lt__(self, arg: int, /) -> bool4: ...

    @overload
    def __gt__(self, arg: int, /) -> bool4: ...

    @overload
    def __gt__(self, arg: int4, /) -> bool4: ...

    @overload
    def __gt__(self, arg: int, /) -> bool4: ...

    @overload
    def __le__(self, arg: int4, /) -> bool4: ...

    @overload
    def __le__(self, arg: int, /) -> bool4: ...

    @overload
    def __le__(self, arg: int, /) -> bool4: ...

    @overload
    def __ge__(self, arg: int, /) -> bool4: ...

    @overload
    def __ge__(self, arg: int4, /) -> bool4: ...

    @overload
    def __ge__(self, arg: int, /) -> bool4: ...

@overload
def inverse(x: float2x2) -> float2x2: ...

@overload
def inverse(x: float3x3) -> float3x3: ...

@overload
def inverse(x: float4x4) -> float4x4: ...

@overload
def inverse(x: quatf) -> quatf: ...

@overload
def isfinite(x: float) -> bool: ...

@overload
def isfinite(x: float) -> bool: ...

@overload
def isfinite(x: float16_t) -> bool: ...

@overload
def isfinite(x: float1) -> bool1: ...

@overload
def isfinite(x: float2) -> bool2: ...

@overload
def isfinite(x: float3) -> bool3: ...

@overload
def isfinite(x: float4) -> bool4: ...

@overload
def isfinite(x: quatf) -> bool4: ...

@overload
def isinf(x: float) -> bool: ...

@overload
def isinf(x: float) -> bool: ...

@overload
def isinf(x: float16_t) -> bool: ...

@overload
def isinf(x: float1) -> bool1: ...

@overload
def isinf(x: float2) -> bool2: ...

@overload
def isinf(x: float3) -> bool3: ...

@overload
def isinf(x: float4) -> bool4: ...

@overload
def isinf(x: quatf) -> bool4: ...

@overload
def isnan(x: float) -> bool: ...

@overload
def isnan(x: float) -> bool: ...

@overload
def isnan(x: float16_t) -> bool: ...

@overload
def isnan(x: float1) -> bool1: ...

@overload
def isnan(x: float2) -> bool2: ...

@overload
def isnan(x: float3) -> bool3: ...

@overload
def isnan(x: float4) -> bool4: ...

@overload
def isnan(x: quatf) -> bool4: ...

@overload
def length(x: float1) -> float: ...

@overload
def length(x: float2) -> float: ...

@overload
def length(x: float3) -> float: ...

@overload
def length(x: float4) -> float: ...

@overload
def length(x: quatf) -> float: ...

@overload
def lerp(x: float, y: float, s: float) -> float: ...

@overload
def lerp(x: float, y: float, s: float) -> float: ...

@overload
def lerp(x: float1, y: float1, s: float1) -> float1: ...

@overload
def lerp(x: float1, y: float1, s: float) -> float1: ...

@overload
def lerp(x: float2, y: float2, s: float2) -> float2: ...

@overload
def lerp(x: float2, y: float2, s: float) -> float2: ...

@overload
def lerp(x: float3, y: float3, s: float3) -> float3: ...

@overload
def lerp(x: float3, y: float3, s: float) -> float3: ...

@overload
def lerp(x: float4, y: float4, s: float4) -> float4: ...

@overload
def lerp(x: float4, y: float4, s: float) -> float4: ...

@overload
def lerp(x: quatf, y: quatf, s: float) -> quatf: ...

@overload
def log(x: float) -> float: ...

@overload
def log(x: float) -> float: ...

@overload
def log(x: float16_t) -> float16_t: ...

@overload
def log(x: float1) -> float1: ...

@overload
def log(x: float2) -> float2: ...

@overload
def log(x: float3) -> float3: ...

@overload
def log(x: float4) -> float4: ...

@overload
def log10(x: float) -> float: ...

@overload
def log10(x: float) -> float: ...

@overload
def log10(x: float1) -> float1: ...

@overload
def log10(x: float2) -> float2: ...

@overload
def log10(x: float3) -> float3: ...

@overload
def log10(x: float4) -> float4: ...

@overload
def log2(x: float) -> float: ...

@overload
def log2(x: float) -> float: ...

@overload
def log2(x: float1) -> float1: ...

@overload
def log2(x: float2) -> float2: ...

@overload
def log2(x: float3) -> float3: ...

@overload
def log2(x: float4) -> float4: ...

def matrix_from_look_at(eye: float3, center: float3, up: float3, handedness: Handedness = Handedness.right_handed) -> float4x4: ...

def matrix_from_quat(q: quatf) -> float3x3: ...

def matrix_from_rotation(angle: float, axis: float3) -> float4x4: ...

def matrix_from_rotation_x(angle: float) -> float4x4: ...

@overload
def matrix_from_rotation_xyz(angle_x: float, angle_y: float, angle_z: float) -> float4x4: ...

@overload
def matrix_from_rotation_xyz(angles: float3) -> float4x4: ...

def matrix_from_rotation_y(angle: float) -> float4x4: ...

def matrix_from_rotation_z(angle: float) -> float4x4: ...

def matrix_from_scaling(v: float3) -> float4x4: ...

def matrix_from_translation(v: float3) -> float4x4: ...

@overload
def max(x: float1, y: float1) -> float1: ...

@overload
def max(x: float2, y: float2) -> float2: ...

@overload
def max(x: float3, y: float3) -> float3: ...

@overload
def max(x: float4, y: float4) -> float4: ...

@overload
def max(x: uint1, y: uint1) -> uint1: ...

@overload
def max(x: uint2, y: uint2) -> uint2: ...

@overload
def max(x: uint3, y: uint3) -> uint3: ...

@overload
def max(x: uint4, y: uint4) -> uint4: ...

@overload
def max(x: int1, y: int1) -> int1: ...

@overload
def max(x: int2, y: int2) -> int2: ...

@overload
def max(x: int3, y: int3) -> int3: ...

@overload
def max(x: int4, y: int4) -> int4: ...

@overload
def max(x: bool1, y: bool1) -> bool1: ...

@overload
def max(x: bool2, y: bool2) -> bool2: ...

@overload
def max(x: bool3, y: bool3) -> bool3: ...

@overload
def max(x: bool4, y: bool4) -> bool4: ...

@overload
def min(x: float1, y: float1) -> float1: ...

@overload
def min(x: float2, y: float2) -> float2: ...

@overload
def min(x: float3, y: float3) -> float3: ...

@overload
def min(x: float4, y: float4) -> float4: ...

@overload
def min(x: uint1, y: uint1) -> uint1: ...

@overload
def min(x: uint2, y: uint2) -> uint2: ...

@overload
def min(x: uint3, y: uint3) -> uint3: ...

@overload
def min(x: uint4, y: uint4) -> uint4: ...

@overload
def min(x: int1, y: int1) -> int1: ...

@overload
def min(x: int2, y: int2) -> int2: ...

@overload
def min(x: int3, y: int3) -> int3: ...

@overload
def min(x: int4, y: int4) -> int4: ...

@overload
def min(x: bool1, y: bool1) -> bool1: ...

@overload
def min(x: bool2, y: bool2) -> bool2: ...

@overload
def min(x: bool3, y: bool3) -> bool3: ...

@overload
def min(x: bool4, y: bool4) -> bool4: ...

@overload
def mul(x: float2x2, y: float2x2) -> float2x2: ...

@overload
def mul(x: float2x2, y: float2) -> float2: ...

@overload
def mul(x: float2, y: float2x2) -> float2: ...

@overload
def mul(x: float3x3, y: float3x3) -> float3x3: ...

@overload
def mul(x: float3x3, y: float3) -> float3: ...

@overload
def mul(x: float3, y: float3x3) -> float3: ...

@overload
def mul(x: float2x4, y: "sgl::math::matrix<float,4,2>") -> float2x2: ...

@overload
def mul(x: float2x4, y: float4) -> float2: ...

@overload
def mul(x: float2, y: float2x4) -> float4: ...

@overload
def mul(x: float3x4, y: "sgl::math::matrix<float,4,3>") -> float3x3: ...

@overload
def mul(x: float3x4, y: float4) -> float3: ...

@overload
def mul(x: float3, y: float3x4) -> float4: ...

@overload
def mul(x: float4x4, y: float4x4) -> float4x4: ...

@overload
def mul(x: float4x4, y: float4) -> float4: ...

@overload
def mul(x: float4, y: float4x4) -> float4: ...

@overload
def mul(x: quatf, y: quatf) -> quatf: ...

@overload
def mul(x: quatf, y: float3) -> float3: ...

@overload
def none(x: bool1) -> bool: ...

@overload
def none(x: bool2) -> bool: ...

@overload
def none(x: bool3) -> bool: ...

@overload
def none(x: bool4) -> bool: ...

@overload
def normalize(x: float1) -> float1: ...

@overload
def normalize(x: float2) -> float2: ...

@overload
def normalize(x: float3) -> float3: ...

@overload
def normalize(x: float4) -> float4: ...

@overload
def normalize(x: quatf) -> quatf: ...

def ortho(left: float, right: float, bottom: float, top: float, z_near: float, z_far: float) -> float4x4: ...

def perspective(fovy: float, aspect: float, z_near: float, z_far: float) -> float4x4: ...

def pitch(x: quatf) -> float: ...

@overload
def pow(x: float, y: float) -> float: ...

@overload
def pow(x: float, y: float) -> float: ...

@overload
def pow(x: float1, y: float1) -> float1: ...

@overload
def pow(x: float2, y: float2) -> float2: ...

@overload
def pow(x: float3, y: float3) -> float3: ...

@overload
def pow(x: float4, y: float4) -> float4: ...

def quat_from_angle_axis(angle: float, axis: float3) -> quatf: ...

def quat_from_euler_angles(angles: float3) -> quatf: ...

def quat_from_look_at(dir: float3, up: float3, handedness: Handedness = Handedness.right_handed) -> quatf: ...

def quat_from_matrix(m: float3x3) -> quatf: ...

def quat_from_rotation_between_vectors(from_: float3, to: float3) -> quatf: ...

class quatf:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, x: float, y: float, z: float, w: float) -> None: ...

    @overload
    def __init__(self, xyz: float3, w: float) -> None: ...

    @overload
    def __init__(self, a: Sequence[float]) -> None: ...

    @staticmethod
    def identity() -> quatf: ...

    @property
    def x(self) -> float: ...

    @x.setter
    def x(self, arg: float, /) -> None: ...

    @property
    def y(self) -> float: ...

    @y.setter
    def y(self, arg: float, /) -> None: ...

    @property
    def z(self) -> float: ...

    @z.setter
    def z(self, arg: float, /) -> None: ...

    @property
    def w(self) -> float: ...

    @w.setter
    def w(self, arg: float, /) -> None: ...

    def __getitem__(self, arg: int, /) -> float: ...

    def __setitem__(self, arg0: int, arg1: float, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __pos__(self) -> quatf: ...

    def __neg__(self) -> quatf: ...

    @overload
    def __add__(self, arg: quatf, /) -> quatf: ...

    @overload
    def __add__(self, arg: float, /) -> quatf: ...

    def __radd__(self, arg: float, /) -> quatf: ...

    @overload
    def __sub__(self, arg: quatf, /) -> quatf: ...

    @overload
    def __sub__(self, arg: float, /) -> quatf: ...

    def __rsub__(self, arg: float, /) -> quatf: ...

    def __mul__(self, arg: float, /) -> quatf: ...

    def __rmul__(self, arg: float, /) -> quatf: ...

    def __truediv__(self, arg: float, /) -> quatf: ...

    def __eq__(self, arg: quatf, /) -> bool4: ...

    def __ne__(self, arg: quatf, /) -> bool4: ...

@overload
def radians(x: float) -> float: ...

@overload
def radians(x: float) -> float: ...

@overload
def radians(x: float1) -> float1: ...

@overload
def radians(x: float2) -> float2: ...

@overload
def radians(x: float3) -> float3: ...

@overload
def radians(x: float4) -> float4: ...

@overload
def rcp(x: float) -> float: ...

@overload
def rcp(x: float) -> float: ...

@overload
def rcp(x: float1) -> float1: ...

@overload
def rcp(x: float2) -> float2: ...

@overload
def rcp(x: float3) -> float3: ...

@overload
def rcp(x: float4) -> float4: ...

@overload
def reflect(i: float1, n: float1) -> float1: ...

@overload
def reflect(i: float2, n: float2) -> float2: ...

@overload
def reflect(i: float3, n: float3) -> float3: ...

@overload
def reflect(i: float4, n: float4) -> float4: ...

def roll(x: quatf) -> float: ...

def rotate(m: float4x4, angle: float, axis: float3) -> float4x4: ...

@overload
def round(x: float) -> float: ...

@overload
def round(x: float) -> float: ...

@overload
def round(x: float1) -> float1: ...

@overload
def round(x: float2) -> float2: ...

@overload
def round(x: float3) -> float3: ...

@overload
def round(x: float4) -> float4: ...

@overload
def rsqrt(x: float) -> float: ...

@overload
def rsqrt(x: float) -> float: ...

@overload
def rsqrt(x: float1) -> float1: ...

@overload
def rsqrt(x: float2) -> float2: ...

@overload
def rsqrt(x: float3) -> float3: ...

@overload
def rsqrt(x: float4) -> float4: ...

@overload
def saturate(x: float) -> float: ...

@overload
def saturate(x: float) -> float: ...

@overload
def saturate(x: float1) -> float1: ...

@overload
def saturate(x: float2) -> float2: ...

@overload
def saturate(x: float3) -> float3: ...

@overload
def saturate(x: float4) -> float4: ...

def scale(m: float4x4, v: float3) -> float4x4: ...

@overload
def sign(x: float1) -> float1: ...

@overload
def sign(x: float2) -> float2: ...

@overload
def sign(x: float3) -> float3: ...

@overload
def sign(x: float4) -> float4: ...

@overload
def sign(x: int1) -> int1: ...

@overload
def sign(x: int2) -> int2: ...

@overload
def sign(x: int3) -> int3: ...

@overload
def sign(x: int4) -> int4: ...

@overload
def sin(x: float) -> float: ...

@overload
def sin(x: float) -> float: ...

@overload
def sin(x: float1) -> float1: ...

@overload
def sin(x: float2) -> float2: ...

@overload
def sin(x: float3) -> float3: ...

@overload
def sin(x: float4) -> float4: ...

@overload
def sinh(x: float) -> float: ...

@overload
def sinh(x: float) -> float: ...

@overload
def sinh(x: float1) -> float1: ...

@overload
def sinh(x: float2) -> float2: ...

@overload
def sinh(x: float3) -> float3: ...

@overload
def sinh(x: float4) -> float4: ...

def slerp(x: quatf, y: quatf, s: float) -> quatf: ...

@overload
def smoothstep(min: float, max: float, x: float) -> float: ...

@overload
def smoothstep(min: float, max: float, x: float) -> float: ...

@overload
def smoothstep(min: float1, max: float1, x: float1) -> float1: ...

@overload
def smoothstep(min: float2, max: float2, x: float2) -> float2: ...

@overload
def smoothstep(min: float3, max: float3, x: float3) -> float3: ...

@overload
def smoothstep(min: float4, max: float4, x: float4) -> float4: ...

@overload
def sqrt(x: float) -> float: ...

@overload
def sqrt(x: float) -> float: ...

@overload
def sqrt(x: float1) -> float1: ...

@overload
def sqrt(x: float2) -> float2: ...

@overload
def sqrt(x: float3) -> float3: ...

@overload
def sqrt(x: float4) -> float4: ...

@overload
def step(x: float, y: float) -> float: ...

@overload
def step(x: float, y: float) -> float: ...

@overload
def step(x: float1, y: float1) -> float1: ...

@overload
def step(x: float2, y: float2) -> float2: ...

@overload
def step(x: float3, y: float3) -> float3: ...

@overload
def step(x: float4, y: float4) -> float4: ...

@overload
def tan(x: float) -> float: ...

@overload
def tan(x: float) -> float: ...

@overload
def tan(x: float1) -> float1: ...

@overload
def tan(x: float2) -> float2: ...

@overload
def tan(x: float3) -> float3: ...

@overload
def tan(x: float4) -> float4: ...

@overload
def tanh(x: float) -> float: ...

@overload
def tanh(x: float) -> float: ...

@overload
def tanh(x: float1) -> float1: ...

@overload
def tanh(x: float2) -> float2: ...

@overload
def tanh(x: float3) -> float3: ...

@overload
def tanh(x: float4) -> float4: ...

def transform_point(m: float4x4, v: float3) -> float3: ...

@overload
def transform_vector(m: float3x3, v: float3) -> float3: ...

@overload
def transform_vector(m: float4x4, v: float3) -> float3: ...

@overload
def transform_vector(q: quatf, v: float3) -> float3: ...

def translate(m: float4x4, v: float3) -> float4x4: ...

@overload
def transpose(x: float2x2) -> float2x2: ...

@overload
def transpose(x: float3x3) -> float3x3: ...

@overload
def transpose(x: float2x4) -> "sgl::math::matrix<float,4,2>": ...

@overload
def transpose(x: float3x4) -> "sgl::math::matrix<float,4,3>": ...

@overload
def transpose(x: float4x4) -> float4x4: ...

@overload
def trunc(x: float) -> float: ...

@overload
def trunc(x: float) -> float: ...

@overload
def trunc(x: float1) -> float1: ...

@overload
def trunc(x: float2) -> float2: ...

@overload
def trunc(x: float3) -> float3: ...

@overload
def trunc(x: float4) -> float4: ...

class uint1:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: int) -> None: ...

    @overload
    def __init__(self, a: Sequence[int]) -> None: ...

    @property
    def x(self) -> int: ...

    @x.setter
    def x(self, arg: int, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> int: ...

    def __setitem__(self, arg0: int, arg1: int, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __pos__(self) -> uint1: ...

    def __neg__(self) -> uint1: ...

    @overload
    def __add__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __add__(self, arg: int, /) -> uint1: ...

    def __radd__(self, arg: int, /) -> uint1: ...

    @overload
    def __sub__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __sub__(self, arg: int, /) -> uint1: ...

    def __rsub__(self, arg: int, /) -> uint1: ...

    @overload
    def __mul__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __mul__(self, arg: int, /) -> uint1: ...

    def __rmul__(self, arg: int, /) -> uint1: ...

    @overload
    def __truediv__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __truediv__(self, arg: int, /) -> uint1: ...

    def __rtruediv__(self, arg: int, /) -> uint1: ...

    @overload
    def __iadd__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __iadd__(self, arg: int, /) -> uint1: ...

    @overload
    def __isub__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __isub__(self, arg: int, /) -> uint1: ...

    @overload
    def __imul__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __imul__(self, arg: int, /) -> uint1: ...

    @overload
    def __itruediv__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __itruediv__(self, arg: int, /) -> uint1: ...

    @overload
    def __mod__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __mod__(self, arg: int, /) -> uint1: ...

    def __rmod__(self, arg: int, /) -> uint1: ...

    @overload
    def __lshift__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __lshift__(self, arg: int, /) -> uint1: ...

    def __rlshift__(self, arg: int, /) -> uint1: ...

    @overload
    def __rshift__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __rshift__(self, arg: int, /) -> uint1: ...

    def __rrshift__(self, arg: int, /) -> uint1: ...

    @overload
    def __or__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __or__(self, arg: int, /) -> uint1: ...

    def __ror__(self, arg: int, /) -> uint1: ...

    @overload
    def __and__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __and__(self, arg: int, /) -> uint1: ...

    def __rand__(self, arg: int, /) -> uint1: ...

    @overload
    def __xor__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __xor__(self, arg: int, /) -> uint1: ...

    def __rxor__(self, arg: int, /) -> uint1: ...

    @overload
    def __imod__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __imod__(self, arg: int, /) -> uint1: ...

    @overload
    def __ilshift__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __ilshift__(self, arg: int, /) -> uint1: ...

    @overload
    def __irshift__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __irshift__(self, arg: int, /) -> uint1: ...

    @overload
    def __ior__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __ior__(self, arg: int, /) -> uint1: ...

    @overload
    def __iand__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __iand__(self, arg: int, /) -> uint1: ...

    @overload
    def __ixor__(self, arg: uint1, /) -> uint1: ...

    @overload
    def __ixor__(self, arg: int, /) -> uint1: ...

    @overload
    def __eq__(self, arg: uint1, /) -> bool1: ...

    @overload
    def __eq__(self, arg: int, /) -> bool1: ...

    @overload
    def __eq__(self, arg: int, /) -> bool1: ...

    @overload
    def __ne__(self, arg: uint1, /) -> bool1: ...

    @overload
    def __ne__(self, arg: int, /) -> bool1: ...

    @overload
    def __ne__(self, arg: int, /) -> bool1: ...

    @overload
    def __lt__(self, arg: uint1, /) -> bool1: ...

    @overload
    def __lt__(self, arg: int, /) -> bool1: ...

    @overload
    def __lt__(self, arg: int, /) -> bool1: ...

    @overload
    def __gt__(self, arg: int, /) -> bool1: ...

    @overload
    def __gt__(self, arg: uint1, /) -> bool1: ...

    @overload
    def __gt__(self, arg: int, /) -> bool1: ...

    @overload
    def __le__(self, arg: uint1, /) -> bool1: ...

    @overload
    def __le__(self, arg: int, /) -> bool1: ...

    @overload
    def __le__(self, arg: int, /) -> bool1: ...

    @overload
    def __ge__(self, arg: int, /) -> bool1: ...

    @overload
    def __ge__(self, arg: uint1, /) -> bool1: ...

    @overload
    def __ge__(self, arg: int, /) -> bool1: ...

class uint2:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: int) -> None: ...

    @overload
    def __init__(self, x: int, y: int) -> None: ...

    @overload
    def __init__(self, a: Sequence[int]) -> None: ...

    @property
    def x(self) -> int: ...

    @x.setter
    def x(self, arg: int, /) -> None: ...

    @property
    def y(self) -> int: ...

    @y.setter
    def y(self, arg: int, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> int: ...

    def __setitem__(self, arg0: int, arg1: int, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __pos__(self) -> uint2: ...

    def __neg__(self) -> uint2: ...

    @overload
    def __add__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __add__(self, arg: int, /) -> uint2: ...

    def __radd__(self, arg: int, /) -> uint2: ...

    @overload
    def __sub__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __sub__(self, arg: int, /) -> uint2: ...

    def __rsub__(self, arg: int, /) -> uint2: ...

    @overload
    def __mul__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __mul__(self, arg: int, /) -> uint2: ...

    def __rmul__(self, arg: int, /) -> uint2: ...

    @overload
    def __truediv__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __truediv__(self, arg: int, /) -> uint2: ...

    def __rtruediv__(self, arg: int, /) -> uint2: ...

    @overload
    def __iadd__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __iadd__(self, arg: int, /) -> uint2: ...

    @overload
    def __isub__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __isub__(self, arg: int, /) -> uint2: ...

    @overload
    def __imul__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __imul__(self, arg: int, /) -> uint2: ...

    @overload
    def __itruediv__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __itruediv__(self, arg: int, /) -> uint2: ...

    @overload
    def __mod__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __mod__(self, arg: int, /) -> uint2: ...

    def __rmod__(self, arg: int, /) -> uint2: ...

    @overload
    def __lshift__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __lshift__(self, arg: int, /) -> uint2: ...

    def __rlshift__(self, arg: int, /) -> uint2: ...

    @overload
    def __rshift__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __rshift__(self, arg: int, /) -> uint2: ...

    def __rrshift__(self, arg: int, /) -> uint2: ...

    @overload
    def __or__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __or__(self, arg: int, /) -> uint2: ...

    def __ror__(self, arg: int, /) -> uint2: ...

    @overload
    def __and__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __and__(self, arg: int, /) -> uint2: ...

    def __rand__(self, arg: int, /) -> uint2: ...

    @overload
    def __xor__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __xor__(self, arg: int, /) -> uint2: ...

    def __rxor__(self, arg: int, /) -> uint2: ...

    @overload
    def __imod__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __imod__(self, arg: int, /) -> uint2: ...

    @overload
    def __ilshift__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __ilshift__(self, arg: int, /) -> uint2: ...

    @overload
    def __irshift__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __irshift__(self, arg: int, /) -> uint2: ...

    @overload
    def __ior__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __ior__(self, arg: int, /) -> uint2: ...

    @overload
    def __iand__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __iand__(self, arg: int, /) -> uint2: ...

    @overload
    def __ixor__(self, arg: uint2, /) -> uint2: ...

    @overload
    def __ixor__(self, arg: int, /) -> uint2: ...

    @overload
    def __eq__(self, arg: uint2, /) -> bool2: ...

    @overload
    def __eq__(self, arg: int, /) -> bool2: ...

    @overload
    def __eq__(self, arg: int, /) -> bool2: ...

    @overload
    def __ne__(self, arg: uint2, /) -> bool2: ...

    @overload
    def __ne__(self, arg: int, /) -> bool2: ...

    @overload
    def __ne__(self, arg: int, /) -> bool2: ...

    @overload
    def __lt__(self, arg: uint2, /) -> bool2: ...

    @overload
    def __lt__(self, arg: int, /) -> bool2: ...

    @overload
    def __lt__(self, arg: int, /) -> bool2: ...

    @overload
    def __gt__(self, arg: int, /) -> bool2: ...

    @overload
    def __gt__(self, arg: uint2, /) -> bool2: ...

    @overload
    def __gt__(self, arg: int, /) -> bool2: ...

    @overload
    def __le__(self, arg: uint2, /) -> bool2: ...

    @overload
    def __le__(self, arg: int, /) -> bool2: ...

    @overload
    def __le__(self, arg: int, /) -> bool2: ...

    @overload
    def __ge__(self, arg: int, /) -> bool2: ...

    @overload
    def __ge__(self, arg: uint2, /) -> bool2: ...

    @overload
    def __ge__(self, arg: int, /) -> bool2: ...

class uint3:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: int) -> None: ...

    @overload
    def __init__(self, x: int, y: int, z: int) -> None: ...

    @overload
    def __init__(self, xy: uint2, z: int) -> None: ...

    @overload
    def __init__(self, x: int, yz: uint2) -> None: ...

    @overload
    def __init__(self, a: Sequence[int]) -> None: ...

    @property
    def x(self) -> int: ...

    @x.setter
    def x(self, arg: int, /) -> None: ...

    @property
    def y(self) -> int: ...

    @y.setter
    def y(self, arg: int, /) -> None: ...

    @property
    def z(self) -> int: ...

    @z.setter
    def z(self, arg: int, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> int: ...

    def __setitem__(self, arg0: int, arg1: int, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __pos__(self) -> uint3: ...

    def __neg__(self) -> uint3: ...

    @overload
    def __add__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __add__(self, arg: int, /) -> uint3: ...

    def __radd__(self, arg: int, /) -> uint3: ...

    @overload
    def __sub__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __sub__(self, arg: int, /) -> uint3: ...

    def __rsub__(self, arg: int, /) -> uint3: ...

    @overload
    def __mul__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __mul__(self, arg: int, /) -> uint3: ...

    def __rmul__(self, arg: int, /) -> uint3: ...

    @overload
    def __truediv__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __truediv__(self, arg: int, /) -> uint3: ...

    def __rtruediv__(self, arg: int, /) -> uint3: ...

    @overload
    def __iadd__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __iadd__(self, arg: int, /) -> uint3: ...

    @overload
    def __isub__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __isub__(self, arg: int, /) -> uint3: ...

    @overload
    def __imul__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __imul__(self, arg: int, /) -> uint3: ...

    @overload
    def __itruediv__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __itruediv__(self, arg: int, /) -> uint3: ...

    @overload
    def __mod__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __mod__(self, arg: int, /) -> uint3: ...

    def __rmod__(self, arg: int, /) -> uint3: ...

    @overload
    def __lshift__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __lshift__(self, arg: int, /) -> uint3: ...

    def __rlshift__(self, arg: int, /) -> uint3: ...

    @overload
    def __rshift__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __rshift__(self, arg: int, /) -> uint3: ...

    def __rrshift__(self, arg: int, /) -> uint3: ...

    @overload
    def __or__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __or__(self, arg: int, /) -> uint3: ...

    def __ror__(self, arg: int, /) -> uint3: ...

    @overload
    def __and__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __and__(self, arg: int, /) -> uint3: ...

    def __rand__(self, arg: int, /) -> uint3: ...

    @overload
    def __xor__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __xor__(self, arg: int, /) -> uint3: ...

    def __rxor__(self, arg: int, /) -> uint3: ...

    @overload
    def __imod__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __imod__(self, arg: int, /) -> uint3: ...

    @overload
    def __ilshift__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __ilshift__(self, arg: int, /) -> uint3: ...

    @overload
    def __irshift__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __irshift__(self, arg: int, /) -> uint3: ...

    @overload
    def __ior__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __ior__(self, arg: int, /) -> uint3: ...

    @overload
    def __iand__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __iand__(self, arg: int, /) -> uint3: ...

    @overload
    def __ixor__(self, arg: uint3, /) -> uint3: ...

    @overload
    def __ixor__(self, arg: int, /) -> uint3: ...

    @overload
    def __eq__(self, arg: uint3, /) -> bool3: ...

    @overload
    def __eq__(self, arg: int, /) -> bool3: ...

    @overload
    def __eq__(self, arg: int, /) -> bool3: ...

    @overload
    def __ne__(self, arg: uint3, /) -> bool3: ...

    @overload
    def __ne__(self, arg: int, /) -> bool3: ...

    @overload
    def __ne__(self, arg: int, /) -> bool3: ...

    @overload
    def __lt__(self, arg: uint3, /) -> bool3: ...

    @overload
    def __lt__(self, arg: int, /) -> bool3: ...

    @overload
    def __lt__(self, arg: int, /) -> bool3: ...

    @overload
    def __gt__(self, arg: int, /) -> bool3: ...

    @overload
    def __gt__(self, arg: uint3, /) -> bool3: ...

    @overload
    def __gt__(self, arg: int, /) -> bool3: ...

    @overload
    def __le__(self, arg: uint3, /) -> bool3: ...

    @overload
    def __le__(self, arg: int, /) -> bool3: ...

    @overload
    def __le__(self, arg: int, /) -> bool3: ...

    @overload
    def __ge__(self, arg: int, /) -> bool3: ...

    @overload
    def __ge__(self, arg: uint3, /) -> bool3: ...

    @overload
    def __ge__(self, arg: int, /) -> bool3: ...

class uint4:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, scalar: int) -> None: ...

    @overload
    def __init__(self, x: int, y: int, z: int, w: int) -> None: ...

    @overload
    def __init__(self, xy: uint2, zw: uint2) -> None: ...

    @overload
    def __init__(self, xyz: uint3, w: int) -> None: ...

    @overload
    def __init__(self, x: int, yzw: uint3) -> None: ...

    @overload
    def __init__(self, a: Sequence[int]) -> None: ...

    @property
    def x(self) -> int: ...

    @x.setter
    def x(self, arg: int, /) -> None: ...

    @property
    def y(self) -> int: ...

    @y.setter
    def y(self, arg: int, /) -> None: ...

    @property
    def z(self) -> int: ...

    @z.setter
    def z(self, arg: int, /) -> None: ...

    @property
    def w(self) -> int: ...

    @w.setter
    def w(self, arg: int, /) -> None: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> int: ...

    def __setitem__(self, arg0: int, arg1: int, /) -> None: ...

    @property
    def shape(self) -> tuple: ...

    @property
    def element_type(self) -> object: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __pos__(self) -> uint4: ...

    def __neg__(self) -> uint4: ...

    @overload
    def __add__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __add__(self, arg: int, /) -> uint4: ...

    def __radd__(self, arg: int, /) -> uint4: ...

    @overload
    def __sub__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __sub__(self, arg: int, /) -> uint4: ...

    def __rsub__(self, arg: int, /) -> uint4: ...

    @overload
    def __mul__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __mul__(self, arg: int, /) -> uint4: ...

    def __rmul__(self, arg: int, /) -> uint4: ...

    @overload
    def __truediv__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __truediv__(self, arg: int, /) -> uint4: ...

    def __rtruediv__(self, arg: int, /) -> uint4: ...

    @overload
    def __iadd__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __iadd__(self, arg: int, /) -> uint4: ...

    @overload
    def __isub__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __isub__(self, arg: int, /) -> uint4: ...

    @overload
    def __imul__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __imul__(self, arg: int, /) -> uint4: ...

    @overload
    def __itruediv__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __itruediv__(self, arg: int, /) -> uint4: ...

    @overload
    def __mod__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __mod__(self, arg: int, /) -> uint4: ...

    def __rmod__(self, arg: int, /) -> uint4: ...

    @overload
    def __lshift__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __lshift__(self, arg: int, /) -> uint4: ...

    def __rlshift__(self, arg: int, /) -> uint4: ...

    @overload
    def __rshift__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __rshift__(self, arg: int, /) -> uint4: ...

    def __rrshift__(self, arg: int, /) -> uint4: ...

    @overload
    def __or__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __or__(self, arg: int, /) -> uint4: ...

    def __ror__(self, arg: int, /) -> uint4: ...

    @overload
    def __and__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __and__(self, arg: int, /) -> uint4: ...

    def __rand__(self, arg: int, /) -> uint4: ...

    @overload
    def __xor__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __xor__(self, arg: int, /) -> uint4: ...

    def __rxor__(self, arg: int, /) -> uint4: ...

    @overload
    def __imod__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __imod__(self, arg: int, /) -> uint4: ...

    @overload
    def __ilshift__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __ilshift__(self, arg: int, /) -> uint4: ...

    @overload
    def __irshift__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __irshift__(self, arg: int, /) -> uint4: ...

    @overload
    def __ior__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __ior__(self, arg: int, /) -> uint4: ...

    @overload
    def __iand__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __iand__(self, arg: int, /) -> uint4: ...

    @overload
    def __ixor__(self, arg: uint4, /) -> uint4: ...

    @overload
    def __ixor__(self, arg: int, /) -> uint4: ...

    @overload
    def __eq__(self, arg: uint4, /) -> bool4: ...

    @overload
    def __eq__(self, arg: int, /) -> bool4: ...

    @overload
    def __eq__(self, arg: int, /) -> bool4: ...

    @overload
    def __ne__(self, arg: uint4, /) -> bool4: ...

    @overload
    def __ne__(self, arg: int, /) -> bool4: ...

    @overload
    def __ne__(self, arg: int, /) -> bool4: ...

    @overload
    def __lt__(self, arg: uint4, /) -> bool4: ...

    @overload
    def __lt__(self, arg: int, /) -> bool4: ...

    @overload
    def __lt__(self, arg: int, /) -> bool4: ...

    @overload
    def __gt__(self, arg: int, /) -> bool4: ...

    @overload
    def __gt__(self, arg: uint4, /) -> bool4: ...

    @overload
    def __gt__(self, arg: int, /) -> bool4: ...

    @overload
    def __le__(self, arg: uint4, /) -> bool4: ...

    @overload
    def __le__(self, arg: int, /) -> bool4: ...

    @overload
    def __le__(self, arg: int, /) -> bool4: ...

    @overload
    def __ge__(self, arg: int, /) -> bool4: ...

    @overload
    def __ge__(self, arg: uint4, /) -> bool4: ...

    @overload
    def __ge__(self, arg: int, /) -> bool4: ...

def yaw(x: quatf) -> float: ...
