# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class BinaryDetailsResponse(BaseModel):
    """
    BinaryDetailsResponse
    """ # noqa: E501
    arch: StrictStr = Field(description="The architecture of the binary")
    bits: StrictInt = Field(description="The size of the binary in bits")
    crc32: StrictStr
    var_class: StrictStr = Field(alias="Class")
    entropy: Union[StrictFloat, StrictInt]
    file_size: StrictInt
    language: StrictStr
    md5: StrictStr
    machine: StrictStr
    os: StrictStr = Field(description="OS target of the binary")
    sha1: StrictStr = Field(description="SHA1 hash of the binary")
    sha256: StrictStr = Field(description="SHA256 hash of the binary")
    ssdeep: StrictStr
    static: StrictBool
    stripped: StrictBool
    sub_sys: StrictStr
    tlsh: StrictStr
    type: StrictStr
    debug: StrictBool
    first_seen: datetime
    __properties: ClassVar[List[str]] = ["arch", "bits", "crc32", "Class", "entropy", "file_size", "language", "md5", "machine", "os", "sha1", "sha256", "ssdeep", "static", "stripped", "sub_sys", "tlsh", "type", "debug", "first_seen"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BinaryDetailsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BinaryDetailsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "arch": obj.get("arch"),
            "bits": obj.get("bits"),
            "crc32": obj.get("crc32"),
            "Class": obj.get("Class"),
            "entropy": obj.get("entropy"),
            "file_size": obj.get("file_size"),
            "language": obj.get("language"),
            "md5": obj.get("md5"),
            "machine": obj.get("machine"),
            "os": obj.get("os"),
            "sha1": obj.get("sha1"),
            "sha256": obj.get("sha256"),
            "ssdeep": obj.get("ssdeep"),
            "static": obj.get("static"),
            "stripped": obj.get("stripped"),
            "sub_sys": obj.get("sub_sys"),
            "tlsh": obj.get("tlsh"),
            "type": obj.get("type"),
            "debug": obj.get("debug"),
            "first_seen": obj.get("first_seen")
        })
        return _obj


