# coding: utf-8

"""
    VRt.Account [AC]

    # Description  Veeroute Account Panel.  ## Entity relationship diagram  ![erd](../uml/account.svg) 

    The version of the OpenAPI document: 7.9.2527
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_account.models.attribute import Attribute
from vrt_lss_account.models.user_role import UserRole
from typing import Optional, Set
from typing_extensions import Self

class User(BaseModel):
    """
    User.
    """ # noqa: E501
    username: Annotated[str, Field(min_length=2, strict=True, max_length=256)] = Field(description="Unique username for login.")
    password: Optional[Annotated[str, Field(min_length=10, strict=True, max_length=256)]] = Field(default=None, description="Password.")
    specification: Optional[Annotated[str, Field(min_length=2, strict=True, max_length=256)]] = Field(default=None, description="User specification.")
    email: Optional[Annotated[str, Field(min_length=5, strict=True, max_length=256)]] = Field(default=None, description="User e-mail address.")
    phone: Optional[Annotated[str, Field(min_length=5, strict=True, max_length=32)]] = Field(default=None, description="User phone.")
    company_key: Annotated[str, Field(min_length=3, strict=True, max_length=256)] = Field(description="Unique company key.")
    enabled: Optional[StrictBool] = Field(default=True, description="User status.")
    roles: Annotated[List[UserRole], Field(min_length=0, max_length=2)] = Field(description="List of user roles.")
    timezone: Optional[Annotated[int, Field(le=12, strict=True, ge=-12)]] = Field(default=0, description="Timezone.")
    edit_date: Optional[datetime] = Field(default=None, description="Last edit date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. ")
    creation_date: Optional[datetime] = Field(default=None, description="Creation date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. ")
    attributes: Optional[Annotated[List[Attribute], Field(min_length=0, max_length=1000)]] = Field(default=None, description="Attributes. Used to add service information.")
    __properties: ClassVar[List[str]] = ["username", "password", "specification", "email", "phone", "company_key", "enabled", "roles", "timezone", "edit_date", "creation_date", "attributes"]

    @field_validator('username')
    def username_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\w+", value):
            raise ValueError(r"must validate the regular expression /\w+/")
        return value

    @field_validator('company_key')
    def company_key_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\w+", value):
            raise ValueError(r"must validate the regular expression /\w+/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of User from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "edit_date",
            "creation_date",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        # set to None if password (nullable) is None
        # and model_fields_set contains the field
        if self.password is None and "password" in self.model_fields_set:
            _dict['password'] = None

        # set to None if specification (nullable) is None
        # and model_fields_set contains the field
        if self.specification is None and "specification" in self.model_fields_set:
            _dict['specification'] = None

        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if phone (nullable) is None
        # and model_fields_set contains the field
        if self.phone is None and "phone" in self.model_fields_set:
            _dict['phone'] = None

        # set to None if edit_date (nullable) is None
        # and model_fields_set contains the field
        if self.edit_date is None and "edit_date" in self.model_fields_set:
            _dict['edit_date'] = None

        # set to None if creation_date (nullable) is None
        # and model_fields_set contains the field
        if self.creation_date is None and "creation_date" in self.model_fields_set:
            _dict['creation_date'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of User from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "username": obj.get("username"),
            "password": obj.get("password"),
            "specification": obj.get("specification"),
            "email": obj.get("email"),
            "phone": obj.get("phone"),
            "company_key": obj.get("company_key"),
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "roles": obj.get("roles"),
            "timezone": obj.get("timezone") if obj.get("timezone") is not None else 0,
            "edit_date": obj.get("edit_date"),
            "creation_date": obj.get("creation_date"),
            "attributes": [Attribute.from_dict(_item) for _item in obj["attributes"]] if obj.get("attributes") is not None else None
        })
        return _obj


