"""workflow module"""

CODON_TABLE = {
    "ATA": "Ile",
    "ATC": "Ile",
    "ATT": "Ile",
    "ATG": "Met",
    "ACA": "Thr",
    "ACC": "Thr",
    "ACG": "Thr",
    "ACT": "Thr",
    "AAC": "Asn",
    "AAT": "Asn",
    "AAA": "Lys",
    "AAG": "Lys",
    "AGC": "Ser",
    "AGT": "Ser",
    "AGA": "Arg",
    "AGG": "Arg",
    "CTA": "Leu",
    "CTC": "Leu",
    "CTG": "Leu",
    "CTT": "Leu",
    "CCA": "Pro",
    "CCC": "Pro",
    "CCG": "Pro",
    "CCT": "Pro",
    "CAC": "His",
    "CAT": "His",
    "CAA": "Gln",
    "CAG": "Gln",
    "CGA": "Arg",
    "CGC": "Arg",
    "CGG": "Arg",
    "CGT": "Arg",
    "GTA": "Val",
    "GTC": "Val",
    "GTG": "Val",
    "GTT": "Val",
    "GCA": "Ala",
    "GCC": "Ala",
    "GCG": "Ala",
    "GCT": "Ala",
    "GAC": "Asp",
    "GAT": "Asp",
    "GAA": "Glu",
    "GAG": "Glu",
    "GGA": "Gly",
    "GGC": "Gly",
    "GGG": "Gly",
    "GGT": "Gly",
    "TCA": "Ser",
    "TCC": "Ser",
    "TCG": "Ser",
    "TCT": "Ser",
    "TTC": "Phe",
    "TTT": "Phe",
    "TTA": "Leu",
    "TTG": "Leu",
    "TAC": "Tyr",
    "TAT": "Tyr",
    "TAA": "Stop",
    "TAG": "Stop",
    "TGC": "Cys",
    "TGT": "Cys",
    "TGA": "Stop",
    "TGG": "Trp",
}

INV_CODON_TABLE = {
    "Ile": ["ATA", "ATC", "ATT"],
    "Met": ["ATG"],
    "Thr": ["ACA", "ACC", "ACG", "ACT"],
    "Asn": ["AAC", "AAT"],
    "Lys": ["AAA", "AAG"],
    "Ser": ["TCT", "TCC", "TCA", "TCG", "AGC", "AGT"],
    "Phe": ["TTT", "TTC"],
    "Arg": ["CGT", "CGC", "CGA", "CGG", "AGA", "AGG"],
    "Leu": ["CTA", "CTC", "CTG", "CTT", "TTA", "TTG"],
    "Pro": ["CCT", "CCC", "CCA", "CCG"],
    "His": ["CAT", "CAC"],
    "Gln": ["CAA", "CAG"],
    "Val": ["GTT", "GTC", "GTA", "GTG"],
    "Ala": ["GCT", "GCC", "GCA", "GCG"],
    "Asp": ["GAT", "GAC"],
    "Glu": ["GAA", "GAG"],
    "Gly": ["GGT", "GGC", "GGA", "GGG"],
    "Tyr": ["TAT", "TAC"],
    "Cys": ["TGC", "TGT"],
    "Trp": ["TGG"],
    "Stop": ["TGA", "TAG", "TAA"],
}

AMINO_ACIDS_ONE_TO_THREE: dict = {
    "A": "Ala",
    "C": "Cys",
    "D": "Asp",
    "E": "Glu",
    "F": "Phe",
    "G": "Gly",
    "H": "His",
    "I": "Ile",
    "K": "Lys",
    "L": "Leu",
    "M": "Met",
    "N": "Asn",
    "P": "Pro",
    "Q": "Gln",
    "R": "Arg",
    "S": "Ser",
    "T": "Thr",
    "V": "Val",
    "W": "Trp",
    "Y": "Tyr",
}

CODON_COUNTS_TABLE_COLUMN_NAMES_DICT = {
    "codon": str,
    "base_count": int,
    "error_count": int,
    "detection_rate": float,
}

CODON_COUNTS_TABLE_COLUMN_NAMES_LIST = [
    item for item in CODON_COUNTS_TABLE_COLUMN_NAMES_DICT
]

SUBSTITUTION_ERROR_FILE_NAME_SUFFIX = "substitution_errors.csv"
