#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Mar 3 2022

@author: s.bendjebla
"""

# %% Librairies
from geomdl import BSpline

import volmdlr as vm
import volmdlr.faces


# %% Surface 1
# %%% Control points

control_points = [vm.Point3D(2.241, 2.4869e-16, 1.09426168652),
                  vm.Point3D(2.241, 0.113630651448, 1.09426168652),
                  vm.Point3D(2.241, 0.223810847892, 1.08268817839),
                  vm.Point3D(2.241, 0.33054058933200003, 1.0595411620800002),
                  vm.Point3D(2.241, 0.5361862970250001, 0.990895196727),
                  vm.Point3D(2.241, 0.723465858812, 0.879930616975),
                  vm.Point3D(2.241, 0.8118294543450001, 0.8144649862590001),
                  vm.Point3D(2.241, 0.9761785443359999, 0.6651572105469999),
                  vm.Point3D(2.241, 1.11211997147, 0.482276741071),
                  vm.Point3D(2.241, 1.17207590414, 0.383238416591),
                  vm.Point3D(2.241, 1.27413247734, 0.17155575554699998),
                  vm.Point3D(2.241, 1.33773987072, -0.0649536786244),
                  vm.Point3D(2.241, 1.35924662357, -0.188818776231),
                  vm.Point3D(2.241, 1.37, -0.317896712535),
                  vm.Point3D(2.241, 1.37, -0.45218748759),
                  vm.Point3D(2.59343707867, 1.9185e-16, 1.3231370015400001),
                  vm.Point3D(2.59342622313, 0.12093735572900001, 1.32312995187),
                  vm.Point3D(2.59288136788, 0.24045506429400001, 1.3121304390200001),
                  vm.Point3D(2.59222336812, 0.358102575366, 1.2891144239499999),
                  vm.Point3D(2.5915094518300004, 0.587185746842, 1.21804435526),
                  vm.Point3D(2.5928176277399997, 0.798165377834, 1.09823098512),
                  vm.Point3D(2.59418982522, 0.897715973003, 1.0264313247099999),
                  vm.Point3D(2.5984436896900003, 1.08183513015, 0.860987234209),
                  vm.Point3D(2.60522913179, 1.2310065670500001, 0.656413457028),
                  vm.Point3D(2.60914226048, 1.29560461061, 0.545483967348),
                  vm.Point3D(2.61737883972, 1.40293758378, 0.309109838505),
                  vm.Point3D(2.6249788339699998, 1.4661551148799998, 0.0483962044126),
                  vm.Point3D(2.6282494287, 1.48659201783, -0.08684558618539999),
                  vm.Point3D(2.63066141546, 1.49660866911, -0.22613178554000002),
                  vm.Point3D(2.6320408778699997, 1.49705688325, -0.369003086062),
                  vm.Point3D(2.96970174124, 1.5632000000000002e-16, 1.50692549123),
                  vm.Point3D(2.96968712047, 0.12710190956700002, 1.50692000803),
                  vm.Point3D(2.9688984693, 0.254265989991, 1.49599766247),
                  vm.Point3D(2.96796075502, 0.380658221389, 1.47255805327),
                  vm.Point3D(2.96702656827, 0.628340389171, 1.3986464942),
                  vm.Point3D(2.96919864976, 0.858138846883, 1.27145594036),
                  vm.Point3D(2.97137947109, 0.966657184806, 1.19467574985),
                  vm.Point3D(2.9780408535, 1.1669699287200002, 1.01693177593),
                  vm.Point3D(2.98856802122, 1.32789489111, 0.7963773875319999),
                  vm.Point3D(2.9946287679799997, 1.39701748223, 0.676785791572),
                  vm.Point3D(3.0073961149, 1.51059308594, 0.42256892736600005),
                  vm.Point3D(3.01926313653, 1.5756236406600002, 0.144704181224),
                  vm.Point3D(3.02441474363, 1.5961316139400001, 0.00150531527407),
                  vm.Point3D(3.02828901899, 1.60602680707, -0.144728468174),
                  vm.Point3D(3.0306261656599998, 1.60664229302, -0.293132378072),
                  vm.Point3D(3.3697939877099996, 1.279e-16, 1.64562715561),
                  vm.Point3D(3.36978683774, 0.132300624259, 1.6456265908299998),
                  vm.Point3D(3.36894041364, 0.26564878498899996, 1.63451205833),
                  vm.Point3D(3.36792633613, 0.39889333094400004, 1.61044197729),
                  vm.Point3D(3.36690804288, 0.6609243920379999, 1.53399549651),
                  vm.Point3D(3.36924492177, 0.905147394916, 1.4015010541700001),
                  vm.Point3D(3.3715994616200002, 1.02059433347, 1.3213147423999998),
                  vm.Point3D(3.3788075708900003, 1.23369114388, 1.13537342905),
                  vm.Point3D(3.39022922598, 1.40463293888, 0.9044488949080001),
                  vm.Point3D(3.39681278561, 1.47791518971, 0.779277162161),
                  vm.Point3D(3.4107010261300004, 1.59799571668, 0.513599162378),
                  vm.Point3D(3.42366211913, 1.66621077446, 0.22481932560800003),
                  vm.Point3D(3.42930913685, 1.68755070982, 0.07658946309510001),
                  vm.Point3D(3.43358713742, 1.69772906706, -0.07393585849350001),
                  vm.Point3D(3.43621972055, 1.69826984004, -0.22556239804),
                  vm.Point3D(4.20228055916, 1.279e-16, 1.84933424467),
                  vm.Point3D(4.202299667829999, 0.141118968529, 1.84933892905),
                  vm.Point3D(4.20158886394, 0.284385157266, 1.83741974655),
                  vm.Point3D(4.20070504937, 0.428144793008, 1.81175503501),
                  vm.Point3D(4.1997387863, 0.7116534971649999, 1.73062512444),
                  vm.Point3D(4.201534676690001, 0.977086807174, 1.59053803649),
                  vm.Point3D(4.20342476396, 1.10277940195, 1.50585455053),
                  vm.Point3D(4.209317530420001, 1.33521030494, 1.3096022379),
                  vm.Point3D(4.21880261746, 1.52252096123, 1.0663228536),
                  vm.Point3D(4.22429849012, 1.60308253571, 0.9346076457020001),
                  vm.Point3D(4.2359408604099995, 1.73569923434, 0.65556929098),
                  vm.Point3D(4.2468985966299995, 1.81185637348, 0.35423557795099997),
                  vm.Point3D(4.25170225529, 1.83588970199, 0.200261253592),
                  vm.Point3D(4.25538210013, 1.8473118126599999, 0.0449983413932),
                  vm.Point3D(4.2577178843, 1.84760875238, -0.109839644429),
                  vm.Point3D(5.0686651091, 2.558e-16, 1.9386036762199998),
                  vm.Point3D(5.0687066837, 0.147484373339, 1.93860739961),
                  vm.Point3D(5.06840335144, 0.296791695661, 1.92533047173),
                  vm.Point3D(5.06799205673, 0.44600826013800005, 1.89763497202),
                  vm.Point3D(5.0674804591000004, 0.739449954325, 1.8123150275600002),
                  vm.Point3D(5.06814171581, 1.0135265119099999, 1.6686221427999999),
                  vm.Point3D(5.06890905485, 1.1433809623100002, 1.58252068759),
                  vm.Point3D(5.071394825950001, 1.38422313033, 1.38411956653),
                  vm.Point3D(5.07552078644, 1.58041863103, 1.1398136847),
                  vm.Point3D(5.0779348742499995, 1.66561808244, 1.00780168494),
                  vm.Point3D(5.08308336834, 1.8077975520499998, 0.728316147398),
                  vm.Point3D(5.087981345549999, 1.8923045357700001, 0.426717712291),
                  vm.Point3D(5.0901419073400005, 1.91979546233, 0.27260821706500005),
                  vm.Point3D(5.091812721919999, 1.93311311743, 0.117383854208),
                  vm.Point3D(5.09290705677, 1.93316927492, -0.0369815392096),
                  vm.Point3D(5.50265533406, 3.4817e-16, 1.9628676830899998),
                  vm.Point3D(5.50270053327, 0.150230145192, 1.9628695227400001),
                  vm.Point3D(5.5026079317, 0.301842595401, 1.9488462116),
                  vm.Point3D(5.50245666935, 0.452849734807, 1.92008257768),
                  vm.Point3D(5.502248412449999, 0.749086539031, 1.83271750086),
                  vm.Point3D(5.502461825929999, 1.02500964197, 1.68770319624),
                  vm.Point3D(5.50273491906, 1.1557035037799999, 1.6012725463700002),
                  vm.Point3D(5.50365764652, 1.39839736466, 1.40283175405),
                  vm.Point3D(5.50524298043, 1.5971207334000002, 1.15948004496),
                  vm.Point3D(5.50618167695, 1.6838376076300001, 1.02813280194),
                  vm.Point3D(5.50820075066, 1.82955145475, 0.750096386409),
                  vm.Point3D(5.510149021399999, 1.9176645665399998, 0.449870851011),
                  vm.Point3D(5.511016082129999, 1.9467618767, 0.29633961112999996),
                  vm.Point3D(5.5116958682799995, 1.96102852335, 0.14160045904500002),
                  vm.Point3D(5.51216318569, 1.9610314091299998, -0.0123021631713),
                  vm.Point3D(5.929766964360001, 4.9027e-16, 1.9749996865200001),
                  vm.Point3D(5.92980090962, 0.152715305401, 1.9749996865200001),
                  vm.Point3D(5.92986941794, 0.30618159113000004, 1.96024310023),
                  vm.Point3D(5.92994835365, 0.458386185715, 1.93043175799),
                  vm.Point3D(5.93011657116, 0.7560080646280001, 1.84104263295),
                  vm.Point3D(5.9302975706300005, 1.03202619865, 1.6947334941199999),
                  vm.Point3D(5.93038972751, 1.1626258145, 1.6079959718699999),
                  vm.Point3D(5.930580819869999, 1.40524583869, 1.40961116771),
                  vm.Point3D(5.93077936656, 1.60456983802, 1.16738025166),
                  vm.Point3D(5.93087941678, 1.69186911453, 1.03679206759),
                  vm.Point3D(5.93107239473, 1.8393612226, 0.760373621125),
                  vm.Point3D(5.93123087705, 1.9297836236600001, 0.46148950315299997),
                  vm.Point3D(5.9312968679499996, 1.96000722565, 0.308434116642),
                  vm.Point3D(5.93134425644, 1.975, 0.153917802518),
                  vm.Point3D(5.93137847935, 1.975, -3.1347656337e-07),
                  vm.Point3D(6.35, 6.8923e-16, 1.9749996865200001),
                  vm.Point3D(6.35, 0.15511613727100002, 1.9749996865200001),
                  vm.Point3D(6.35, 0.310232313739, 1.95977142018),
                  vm.Point3D(6.35, 0.463354924914, 1.9293134313),
                  vm.Point3D(6.35, 0.761627384154, 1.8387308468199999),
                  vm.Point3D(6.35, 1.0365894224599999, 1.6918719279899999),
                  vm.Point3D(6.35, 1.1664005373800002, 1.60513491404),
                  vm.Point3D(6.35, 1.4073039032399999, 1.40730358976),
                  vm.Point3D(6.35, 1.60513522752, 1.1664002239),
                  vm.Point3D(6.35, 1.69187224147, 1.0365891089900001),
                  vm.Point3D(6.35, 1.8387311603, 0.761627070677),
                  vm.Point3D(6.35, 1.9293137447700002, 0.463354611438),
                  vm.Point3D(6.35, 1.95977173366, 0.310232000262),
                  vm.Point3D(6.35, 1.975, 0.155115823794),
                  vm.Point3D(6.35, 1.975, -3.13476563974e-07)]

# %%% Bspline-surface parameters 

degree_u, degree_v, nb_u, nb_v = 5, 5, 9, 15

u_knots, u_multiplicities = [0.0, 0.5, 1.0], [6, 3, 6]
v_knots, v_multiplicities = [0.0, 0.24999999999982622, 0.49999999999826233, 0.7499999999991311, 1.0], [6, 3, 3, 3, 6]

# %%% Bspline-surface definition (1)

bspline_surface_1 = volmdlr.faces.BSplineSurface3D(degree_u = degree_u,
                                                   degree_v = degree_v,
                                                   control_points = control_points,
                                                   nb_u = nb_u,
                                                   nb_v = nb_v,
                                                   u_multiplicities = u_multiplicities,
                                                   v_multiplicities = v_multiplicities,
                                                   u_knots = u_knots,
                                                   v_knots = v_knots)
                                            
bspline_face_1 = bspline_surface_1.rectangular_cut(0, 1, 0, 1)

# %% Surface 2
# %%% Control points

control_points = [vm.Point3D(1.95067028031, 1.20347039895, 0.0836398269635),
                  vm.Point3D(1.94618683437, 1.22586931185, -0.0252478180436),
                  vm.Point3D(1.9426426107199999, 1.24362581059, -0.12955778591999997),
                  vm.Point3D(1.94005687246, 1.25664468085, -0.229196190084),
                  vm.Point3D(1.9378920580399999, 1.26768003279, -0.362267075562),
                  vm.Point3D(1.9378097379299999, 1.26842197355, -0.485188088308),
                  vm.Point3D(1.9379569596500001, 1.26779131769, -0.5199545668419999),
                  vm.Point3D(1.93883504708, 1.26372071811, -0.6142751271229999),
                  vm.Point3D(1.94095621489, 1.25350578602, -0.702537035717),
                  vm.Point3D(1.94277746766, 1.2446762466099999, -0.756776678028),
                  vm.Point3D(1.94574916031, 1.23021758752, -0.826365084771),
                  vm.Point3D(1.94938089488, 1.2124964546700001, -0.8927365119449999),
                  vm.Point3D(1.95032597347, 1.20788240048, -0.9090861870910001),
                  vm.Point3D(1.95322702248, 1.19371206052, -0.956763561998),
                  vm.Point3D(1.95645346422, 1.17793336024, -1.00285500469),
                  vm.Point3D(1.95872036186, 1.16684021477, -1.0326672757900002),
                  vm.Point3D(1.96222643355, 1.14967386447, -1.07538924135),
                  vm.Point3D(1.96599864974, 1.13119200773, -1.1168140448),
                  vm.Point3D(1.9672200788499998, 1.1252065131500002, -1.12981022641),
                  vm.Point3D(1.96925166417, 1.1152491328, -1.1507705417),
                  vm.Point3D(1.9713514117, 1.1049548383599999, -1.17139864107),
                  vm.Point3D(1.9721720036100001, 1.10093137071, -1.17931191216),
                  vm.Point3D(1.97404612715, 1.09174140328, -1.19705611348),
                  vm.Point3D(1.97597109819, 1.0823001053699999, -1.21455248906),
                  vm.Point3D(1.97705858004, 1.07696579547, -1.22421794924),
                  vm.Point3D(1.98037116072, 1.0607151792699998, -1.25301491757),
                  vm.Point3D(1.98382409966, 1.0437707964199998, -1.28112779361),
                  vm.Point3D(1.98618930021, 1.03216199143, -1.2995764597600001),
                  vm.Point3D(2.0057727316, 0.9360258205159999, -1.44597535311),
                  vm.Point3D(2.02941720211, 0.819816631872, -1.5725811406699999),
                  vm.Point3D(2.05335225804, 0.702089154601, -1.66779422194),
                  vm.Point3D(2.0920976649300003, 0.511378623133, -1.7719903619500001),
                  vm.Point3D(2.13984361869, 0.276179936522, -1.83231872047),
                  vm.Point3D(2.15377861063, 0.20752363103299998, -1.84556819277),
                  vm.Point3D(2.1795742882, 0.08040944222669999, -1.8622412875899998),
                  vm.Point3D(2.20761112416, -0.057782406936100005, -1.86799119657),
                  vm.Point3D(2.2201093517, -0.11939155028899999, -1.86830750238),
                  vm.Point3D(2.25281427413, -0.280620262339, -1.86472079381),
                  vm.Point3D(2.2877370727799997, -0.452811555034, -1.85032437441),
                  vm.Point3D(2.30968685881, -0.561046923388, -1.83792570505),
                  vm.Point3D(2.35294348977, -0.7743634058860001, -1.80759796224),
                  vm.Point3D(2.39879403338, -1.0005011524, -1.76462774398),
                  vm.Point3D(2.42119593914, -1.11099496378, -1.74136145168),
                  vm.Point3D(2.4441785727500003, -1.2243592130899998, -1.7152647488400001),
                  vm.Point3D(2.46773961919, -1.34058245745, -1.68634891872),
                  vm.Point3D(2.0580536772099998, 1.2466238945099999, 0.06346074840020001),
                  vm.Point3D(2.05381709469, 1.2678026039999999, -0.0442237085582),
                  vm.Point3D(2.05055498572, 1.28416465836, -0.147158677154),
                  vm.Point3D(2.04806551606, 1.29670768956, -0.246327877689),
                  vm.Point3D(2.04624533862, 1.30603956015, -0.377719036342),
                  vm.Point3D(2.04633799607, 1.3059166169499998, -0.499787225671),
                  vm.Point3D(2.0465455331499998, 1.30498783265, -0.5342597330700001),
                  vm.Point3D(2.0475904425900002, 1.30009266058, -0.6277672192679999),
                  vm.Point3D(2.04983939289, 1.28924612163, -0.715406328572),
                  vm.Point3D(2.0517186479799996, 1.2801298867600002, -0.769363273311),
                  vm.Point3D(2.05472985214, 1.26547592902, -0.838759104783),
                  vm.Point3D(2.0583679519799998, 1.24772333378, -0.9050995083000001),
                  vm.Point3D(2.0593115321999997, 1.24311668577, -0.921456486355),
                  vm.Point3D(2.06220387852, 1.2289893617099998, -0.9691762773210001),
                  vm.Point3D(2.0654060674399997, 1.21333053895, -1.01538592588),
                  vm.Point3D(2.06765131527, 1.20234440473, -1.04530371599),
                  vm.Point3D(2.0711193137199997, 1.1853662439300001, -1.08821124682),
                  vm.Point3D(2.07484631243, 1.16710788938, -1.1298564358),
                  vm.Point3D(2.0760528009, 1.1611962438299999, -1.1429254366400001),
                  vm.Point3D(2.07805920766, 1.1513633167400001, -1.16400846974),
                  vm.Point3D(2.08013262687, 1.1411991586599999, -1.18476489075),
                  vm.Point3D(2.08094290619, 1.1372266644, -1.1927284244299998),
                  vm.Point3D(2.0827934642300003, 1.12815317713, -1.2105874816400002),
                  vm.Point3D(2.08469429867, 1.1188311822900001, -1.2282014966300001),
                  vm.Point3D(2.08576820271, 1.11356398514, -1.2379331337000001),
                  vm.Point3D(2.08903967949, 1.0975165385099999, -1.26693043847),
                  vm.Point3D(2.0924507939, 1.08077888708, -1.29524716313),
                  vm.Point3D(2.09478802668, 1.0693083219600001, -1.31383214144),
                  vm.Point3D(2.11414616688, 0.9742857266680001, -1.46132908194),
                  vm.Point3D(2.13758496045, 0.859093163661, -1.58893731868),
                  vm.Point3D(2.1613826820099997, 0.742044506683, -1.68481975424),
                  vm.Point3D(2.1998925592700003, 0.5524981575739999, -1.7901638425000002),
                  vm.Point3D(2.2470804067, 0.320058094657, -1.85321235643),
                  vm.Point3D(2.2608659598300003, 0.252140439544, -1.86719017888),
                  vm.Point3D(2.28619566931, 0.127329450866, -1.8861343563400002),
                  vm.Point3D(2.31396154832, -0.009523104730069998, -1.8932048828699999),
                  vm.Point3D(2.3264207572199997, -0.0709393856452, -1.8937113617),
                  vm.Point3D(2.35879587782, -0.23053794398900002, -1.89173207486),
                  vm.Point3D(2.39343630596, -0.401333527822, -1.87871190159),
                  vm.Point3D(2.41514126908, -0.508358778656, -1.86750647504),
                  vm.Point3D(2.45798900193, -0.7196541481350001, -1.83917166145),
                  vm.Point3D(2.5033912550700004, -0.943576071954, -1.79838636693),
                  vm.Point3D(2.52558407185, -1.0530363925100001, -1.7761391537500002),
                  vm.Point3D(2.5483494319699997, -1.16532669627, -1.7511014206),
                  vm.Point3D(2.57169393573, -1.28047960744, -1.7232409982199999),
                  vm.Point3D(2.16557658867, 1.28908779358, 0.0439616501184),
                  vm.Point3D(2.16160479553, 1.30895769475, -0.062432249449),
                  vm.Point3D(2.1585151312399997, 1.32446738474, -0.164526739636),
                  vm.Point3D(2.15656387136, 1.33435013752, -0.26107275851399997),
                  vm.Point3D(2.15465666907, 1.34411215708, -0.392888067844),
                  vm.Point3D(2.15509075842, 1.34230157469, -0.513292151593),
                  vm.Point3D(2.15538693693, 1.34093465101, -0.547332629332),
                  vm.Point3D(2.15663982757, 1.33501146366, -0.6398264356050001),
                  vm.Point3D(2.1590352833799997, 1.3234407732, -0.7267514914309999),
                  vm.Point3D(2.16097836446, 1.31400905749, -0.7803973546099999),
                  vm.Point3D(2.16403362998, 1.29913731202, -0.8495784353479999),
                  vm.Point3D(2.1676757518, 1.28136483684, -0.915899236163),
                  vm.Point3D(2.16862037776, 1.2767530198500001, -0.9322511173200001),
                  vm.Point3D(2.1715074600500004, 1.26265171503, -0.979996564699),
                  vm.Point3D(2.17468975044, 1.24709124727, -1.02630319672),
                  vm.Point3D(2.17691695066, 1.23619431928, -1.0563089491200002),
                  vm.Point3D(2.18035328244, 1.21937268137, -1.0993708201699999),
                  vm.Point3D(2.18404309959, 1.20129810889, -1.14119722843),
                  vm.Point3D(2.18523735954, 1.1954469068, -1.15432582987),
                  vm.Point3D(2.18722326646, 1.18571530693, -1.1755087772100001),
                  vm.Point3D(2.1892754512800003, 1.17565610679, -1.19636869256),
                  vm.Point3D(2.1900774446, 1.17172456879, -1.20437261137),
                  vm.Point3D(2.19190915654, 1.16274423454, -1.22232352261),
                  vm.Point3D(2.1937908743, 1.15351673019, -1.24003071046),
                  vm.Point3D(2.19485407859, 1.1483024200299998, -1.24981449702),
                  vm.Point3D(2.19809337267, 1.1324140469300001, -1.2789686570799998),
                  vm.Point3D(2.2014723570699997, 1.11583520859, -1.30744198024),
                  vm.Point3D(2.2037883768, 1.10446949601, -1.32613034895),
                  vm.Point3D(2.2229785519100003, 1.01027712312, -1.4744459348),
                  vm.Point3D(2.24627656487, 0.895780414254, -1.6027403220799998),
                  vm.Point3D(2.27003242392, 0.7789386769259999, -1.69882679193),
                  vm.Point3D(2.30838133643, 0.590187948606, -1.80495540624),
                  vm.Point3D(2.35530205215, 0.35906827190199997, -1.86930589402),
                  vm.Point3D(2.3689471750299997, 0.291844739392, -1.88396815966),
                  vm.Point3D(2.3943685902, 0.166580465239, -1.9024653726199998),
                  vm.Point3D(2.42182059638, 0.0312793290428, -1.91106568446),
                  vm.Point3D(2.43389176266, -0.0282189239111, -1.91346344496),
                  vm.Point3D(2.46588581542, -0.18593392950399998, -1.9133414453),
                  vm.Point3D(2.49993714461, -0.353817698556, -1.9031924824600002),
                  vm.Point3D(2.52143218514, -0.45980533814, -1.89301019799),
                  vm.Point3D(2.5637733402099996, -0.6685967807759999, -1.8671443947600002),
                  vm.Point3D(2.60872420796, -0.890287584249, -1.8285591082900001),
                  vm.Point3D(2.63068931782, -0.998622388654, -1.80742171629),
                  vm.Point3D(2.6532378812400004, -1.10984110366, -1.78344062893),
                  vm.Point3D(2.67636373855, -1.22391328301, -1.75664586789),
                  vm.Point3D(2.2730124050600002, 1.3319821887099998, 0.0240380589329),
                  vm.Point3D(2.2693719758000004, 1.35021421521, -0.0807408056148),
                  vm.Point3D(2.26661895365, 1.36405994101, -0.181194535075),
                  vm.Point3D(2.26474425312, 1.37356427414, -0.27736741126200004),
                  vm.Point3D(2.26326704969, 1.38120088323, -0.407086948304),
                  vm.Point3D(2.26407714734, 1.3775317566199998, -0.525658404645),
                  vm.Point3D(2.26448791384, 1.37559844423, -0.559140391788),
                  vm.Point3D(2.2660179006899996, 1.36830561797, -0.6502836583580001),
                  vm.Point3D(2.26858237658, 1.3558994903400001, -0.736384926986),
                  vm.Point3D(2.2705616485199998, 1.34628888937, -0.789854399411),
                  vm.Point3D(2.27365745599, 1.33121675202, -0.858837882667),
                  vm.Point3D(2.2773011356699997, 1.31343657657, -0.9251510905720001),
                  vm.Point3D(2.2782430052, 1.30883838418, -0.94151640633),
                  vm.Point3D(2.2811189932000002, 1.29479191649, -0.9893159261460001),
                  vm.Point3D(2.2842789933499996, 1.2793416255699999, -1.03573119862),
                  vm.Point3D(2.28648855256, 1.2685318940499999, -1.06582293155),
                  vm.Point3D(2.2898964062199996, 1.2518510186, -1.1090236021600002),
                  vm.Point3D(2.29355579253, 1.23392686054, -1.15099832734),
                  vm.Point3D(2.29474030001, 1.2281238632, -1.16417446133),
                  vm.Point3D(2.29671026579, 1.21847105765, -1.18543510422),
                  vm.Point3D(2.2987465814, 1.2084902962700002, -1.20637236451),
                  vm.Point3D(2.29954247572, 1.20458890455, -1.2144060092300002),
                  vm.Point3D(2.3013605067, 1.1956761929700002, -1.23242360014),
                  vm.Point3D(2.30322880752, 1.18651500622, -1.25019618081),
                  vm.Point3D(2.30428465439, 1.18133706257, -1.26001582676),
                  vm.Point3D(2.307502224, 1.1655560698, -1.28927586976),
                  vm.Point3D(2.31086078084, 1.14907820136, -1.31784875481),
                  vm.Point3D(2.31316389289, 1.1377762891699998, -1.33660003423),
                  vm.Point3D(2.33225637091, 1.0440668162500002, -1.48539178599),
                  vm.Point3D(2.3555078707100003, 0.929800014328, -1.61391287457),
                  vm.Point3D(2.37928028769, 0.812876433091, -1.7099186419299999),
                  vm.Point3D(2.41763109963, 0.6241163169830001, -1.8160379989800002),
                  vm.Point3D(2.4643910885, 0.393791085214, -1.8811718534500002),
                  vm.Point3D(2.47802823623, 0.326606972456, -1.89587298924),
                  vm.Point3D(2.50306072304, 0.20326510431099998, -1.91626580085),
                  vm.Point3D(2.5301384597400003, 0.069813917759, -1.92669026539),
                  vm.Point3D(2.54218490825, 0.010437840465900001, -1.92920849785),
                  vm.Point3D(2.57358298046, -0.144331335765, -1.93199124889),
                  vm.Point3D(2.60727683434, -0.310448165884, -1.92358458555),
                  vm.Point3D(2.6284780399, -0.414983429768, -1.91483442385),
                  vm.Point3D(2.67033567678, -0.621384925182, -1.8913252407699999),
                  vm.Point3D(2.71478400583, -0.840591766315, -1.8551892785600002),
                  vm.Point3D(2.73652355311, -0.9478116536710001, -1.8351512564199999),
                  vm.Point3D(2.7588423084900002, -1.05789446703, -1.81229023091),
                  vm.Point3D(2.78174200605, -1.17084877765, -1.78659775027),
                  vm.Point3D(2.5596632929500003, 1.44559923804, -0.0283342227731),
                  vm.Point3D(2.5570575404299998, 1.45871703541, -0.12807017454800002),
                  vm.Point3D(2.55530709759, 1.46760718416, -0.223637430981),
                  vm.Point3D(2.5543518272299996, 1.4725669321000001, -0.315329094796),
                  vm.Point3D(2.55445861213, 1.47237415939, -0.437328428398),
                  vm.Point3D(2.55585987134, 1.46578302272, -0.553018621245),
                  vm.Point3D(2.55638414098, 1.46328868388, -0.585947405292),
                  vm.Point3D(2.55821512476, 1.45450808152, -0.675623642344),
                  vm.Point3D(2.5609897821, 1.44106306315, -0.760700507203),
                  vm.Point3D(2.56313359587, 1.43063916023, -0.813368018915),
                  vm.Point3D(2.5663748534199997, 1.4148480881999999, -0.881642592809),
                  vm.Point3D(2.57013013388, 1.39651628933, -0.947411869502),
                  vm.Point3D(2.57109705355, 1.3917942783900001, -0.963655093322),
                  vm.Point3D(2.57403921566, 1.37742072344, -1.011132087),
                  vm.Point3D(2.57724329802, 1.36175254176, -1.05733250712),
                  vm.Point3D(2.57947303203, 1.3508430897, -1.08732591007),
                  vm.Point3D(2.5829000250200003, 1.33406761184, -1.13043329745),
                  vm.Point3D(2.5865665410400003, 1.31610821287, -1.1723732731299998),
                  vm.Point3D(2.58775225696, 1.31029924244, -1.18554351731),
                  vm.Point3D(2.5897227050400002, 1.30064405297, -1.2068018095100002),
                  vm.Point3D(2.5917574189900003, 1.29067120834, -1.2277468761499999),
                   vm.Point3D(2.5925524157499997, 1.28677425314, -1.2357848955100001),
                   vm.Point3D(2.5943678708799998, 1.27787427355, -1.2538150408700002),
                   vm.Point3D(2.59623246276, 1.2687314194200001, -1.27160569851),
                   vm.Point3D(2.59728593753, 1.26356520069, -1.28143690587),
                   vm.Point3D(2.60049564209, 1.24782308348, -1.3107352823199998),
                   vm.Point3D(2.60384444032, 1.2313934501900001, -1.33935572989),
                   vm.Point3D(2.60614053078, 1.22012624456, -1.3581412319000001),
                   vm.Point3D(2.62517429526, 1.12670698259, -1.50721914779),
                   vm.Point3D(2.64836557309, 1.01273784685, -1.63603375164),
                   vm.Point3D(2.67208816988, 0.896060519453, -1.7322823384200001),
                   vm.Point3D(2.71028133704, 0.708079613361, -1.83917004027),
                   vm.Point3D(2.75621237165, 0.481851760207, -1.90834413662),
                   vm.Point3D(2.76951706708, 0.416310901952, -1.92466561219),
                   vm.Point3D(2.7939973329099996, 0.295698567112, -1.94774989462),
                   vm.Point3D(2.82028405695, 0.166157220101, -1.96202967721),
                   vm.Point3D(2.8318835124699997, 0.108990552226, -1.96672650955),
                   vm.Point3D(2.86240162561, -0.0414291376782, -1.97379809468),
                   vm.Point3D(2.8949361033, -0.20181537069699998, -1.9710421170499999),
                   vm.Point3D(2.91544309913, -0.30291927532400004, -1.9656754653600002),
                   vm.Point3D(2.95595927789, -0.502690174012, -1.9487044173799999),
                   vm.Point3D(2.99912531884, -0.7155588856030001, -1.91881820144),
                   vm.Point3D(3.0202591863799997, -0.819785002231, -1.90173220283),
                   vm.Point3D(3.04197873451, -0.926906037234, -1.8817916545800002),
                   vm.Point3D(3.0642822857, -1.03691369888, -1.8590047328200001),
                   vm.Point3D(2.8503301773, 1.53936590773, -0.061132932370799996),
                   vm.Point3D(2.8486944011, 1.54768927895, -0.156141314794),
                   vm.Point3D(2.84775945223, 1.5525485813, -0.247733933696),
                   vm.Point3D(2.84761998362, 1.55347596151, -0.33544945992999997),
                   vm.Point3D(2.84825132378, 1.55069040233, -0.454892162629),
                   vm.Point3D(2.85025366692, 1.54112821129, -0.567652731506),
                   vm.Point3D(2.8509382793599998, 1.53784132557, -0.5998000204730001),
                   vm.Point3D(2.85309832163, 1.5274342437400001, -0.68787245879),
                   vm.Point3D(2.85600512507, 1.5133360499, -0.7723052565299999),
                   vm.Point3D(2.85816351564, 1.50284009636, -0.824901722334),
                   vm.Point3D(2.86145631624, 1.48679425588, -0.8929250804309999),
                   vm.Point3D(2.86526758244, 1.46818572913, -0.95842148812),
                   vm.Point3D(2.86624967794, 1.46338870667, -0.974590746427),
                   vm.Point3D(2.86924000406, 1.4487770853300002, -1.0218329934700001),
                   vm.Point3D(2.8725026586399998, 1.43281939123, -1.06774793833),
                   vm.Point3D(2.87477563112, 1.42169621884, -1.0975306012200001),
                   vm.Point3D(2.87826971309, 1.4045891316899999, -1.1403110035100001),
                   vm.Point3D(2.88200571779, 1.38628626212, -1.18191229819),
                   vm.Point3D(2.88321353405, 1.3803680535, -1.1949748274799998),
                   vm.Point3D(2.88521989036, 1.3705353758199998, -1.21605810649),
                   vm.Point3D(2.8872900339500003, 1.36038740854, -1.23683049253),
                   vm.Point3D(2.88809860394, 1.3564233632, -1.2448023573),
                   vm.Point3D(2.88994436639, 1.3473735797, -1.26268478773),
                   vm.Point3D(2.8918384486999997, 1.3380849594900002, -1.28033171196),
                   vm.Point3D(2.8929080488, 1.33283903599, -1.290084326),
                   vm.Point3D(2.89616509162, 1.31686293393, -1.31915198046),
                   vm.Point3D(2.89955762812, 1.3002171098900002, -1.347559252),
                   vm.Point3D(2.90188094245, 1.28881534129, -1.36621206747),
                   vm.Point3D(2.9211162171800003, 1.1944000488, -1.51430784208),
                   vm.Point3D(2.9443419637400003, 1.08026054078, -1.6429544492800001),
                   vm.Point3D(2.96795077901, 0.9641456147840001, -1.73975759543),
                   vm.Point3D(3.00559200522, 0.778892858671, -1.84933540365),
                   vm.Point3D(3.05044803832, 0.557978552714, -1.92374895157),
                   vm.Point3D(3.0634484299099998, 0.49394181600299997, -1.94155357422),
                   vm.Point3D(3.08720410315, 0.37691101766999996, -1.96816944974),
                   vm.Point3D(3.11273864, 0.251087602526, -1.98611531878),
                   vm.Point3D(3.12407033049, 0.19524445118099998, -1.99211721162),
                   vm.Point3D(3.15364075936, 0.0495090016487, -2.00380771682),
                   vm.Point3D(3.18530395625, -0.106570640262, -2.0052982762),
                   vm.Point3D(3.20523503472, -0.20482788441299998, -2.00273858918),
                   vm.Point3D(3.2446830602700003, -0.39931908554199996, -1.99097361501),
                   vm.Point3D(3.28671211236, -0.606567856814, -1.96662897106),
                   vm.Point3D(3.30730183404, -0.708104353988, -1.9521950859900001),
                   vm.Point3D(3.32847604494, -0.812529880909, -1.9349124578),
                   vm.Point3D(3.3502354708900004, -0.919848025078, -1.91477754901),
                   vm.Point3D(3.03350855879, 1.59049860235, -0.0742648392914),
                   vm.Point3D(3.0322964039899998, 1.59672808592, -0.167208532669),
                   vm.Point3D(3.0317484238000003, 1.59967466863, -0.256915104238),
                   vm.Point3D(3.03178496226, 1.5997320762, -0.343772789295),
                   vm.Point3D(3.0327611398600003, 1.59524204491, -0.46153478822099997),
                   vm.Point3D(3.03493165107, 1.58484862802, -0.573475722434),
                   vm.Point3D(3.03566220842, 1.58133464445, -0.605399080372),
                   vm.Point3D(3.03798045149, 1.5701456032799999, -0.692700463527),
                   vm.Point3D(3.04106250799, 1.55518116373, -0.776279095064),
                   vm.Point3D(3.04333507497, 1.54412085586, -0.828319076292),
                   vm.Point3D(3.04673425983, 1.52754917628, -0.895823927959),
                   vm.Point3D(3.05062661215, 1.50853985475, -0.960925129836),
                   vm.Point3D(3.05162710465, 1.5036518991299999, -0.977004723022),
                   vm.Point3D(3.05466729479, 1.4887938085, -1.02400393772),
                   vm.Point3D(3.05796804114, 1.47264783332, -1.0697332270300002),
                   vm.Point3D(3.06026240019, 1.46141895078, -1.0994116538599998),
                   vm.Point3D(3.06378438271, 1.44417395604, -1.1420560716400001),
                   vm.Point3D(3.0675447651999996, 1.42575059122, -1.1835385513399999),
                   vm.Point3D(3.06876002608, 1.41979558512, -1.1965647962800001),
                   vm.Point3D(3.0707781097, 1.40990494133, -1.2175909175),
                   vm.Point3D(3.07285938342, 1.39970195977, -1.23830905641),
                   vm.Point3D(3.07367216486, 1.39571709794, -1.2462603949700002),
                   vm.Point3D(3.07552726553, 1.38662115727, -1.26409731187),
                   vm.Point3D(3.0774302622199996, 1.3772884748199998, -1.28170078829),
                   vm.Point3D(3.07850467646, 1.37201875586, -1.29142993871),
                   vm.Point3D(3.08177577091, 1.3559731990000001, -1.32042910688),
                   vm.Point3D(3.08518095699, 1.33926485026, -1.34877472561),
                   vm.Point3D(3.08751197645, 1.32782499653, -1.3673899870400001),
                   vm.Point3D(3.10680233885, 1.2331374152099999, -1.51521726989),
                   vm.Point3D(3.13001827612, 1.11904639244, -1.6439116862599998),
                   vm.Point3D(3.1534754636, 1.00368093705, -1.74145385169),
                   vm.Point3D(3.1907000238800003, 0.820487688569, -1.85306244854),
                   vm.Point3D(3.2348816327, 0.6029069460140001, -1.9307630742700002),
                   vm.Point3D(3.2476574191300003, 0.539980393967, -1.9496624003699998),
                   vm.Point3D(3.27106285166, 0.424680775232, -1.97798531473),
                   vm.Point3D(3.29615854122, 0.301026506739, -1.9980700823300002),
                   vm.Point3D(3.30725249007, 0.246358471412, -2.00523070456),
                   vm.Point3D(3.3363157987200003, 0.10312962984799999, -2.01939286386),
                   vm.Point3D(3.3673974628699996, -0.0500755957271, -2.02371775673),
                   vm.Point3D(3.3870329174, -0.146871621596, -2.0225989117500003),
                   vm.Point3D(3.42582272186, -0.33810934902100004, -2.01404204258),
                   vm.Point3D(3.46721275348, -0.5421995520640001, -1.99281192162),
                   vm.Point3D(3.4874982171299997, -0.642232154158, -1.9798609602700001),
                   vm.Point3D(3.5083653685200002, -0.745139938691, -1.9640749100200001),
                   vm.Point3D(3.5298144748599998, -0.8509242264870001, -1.94545246846),
                   vm.Point3D(3.43408616284, 1.68921145377, -0.0905705175987),
                   vm.Point3D(3.43342696562, 1.6927077631, -0.180819150028),
                   vm.Point3D(3.43332669747, 1.69344138223, -0.268343617087),
                   vm.Point3D(3.4338692578599996, 1.69099761044, -0.352735001006),
                   vm.Point3D(3.4354047382600004, 1.6837430416199999, -0.46777101303),
                   vm.Point3D(3.4380483543, 1.6710111489200001, -0.577406080748),
                   vm.Point3D(3.4389033093799997, 1.6668822888100001, -0.6087231363979999),
                   vm.Point3D(3.4415162595699997, 1.65423656106, -0.694588146029),
                   vm.Point3D(3.44480367552, 1.6382570650400001, -0.7771658757459999),
                   vm.Point3D(3.4471827657499996, 1.6266702310999999, -0.828686673144),
                   vm.Point3D(3.45072264124, 1.6094031419200001, -0.895505812487),
                   vm.Point3D(3.4547381912, 1.5897848756400002, -0.960006561162),
                   vm.Point3D(3.45576857086, 1.58474919292, -0.975940487251),
                   vm.Point3D(3.45889418978, 1.5694688425199999, -1.02252333047),
                   vm.Point3D(3.46227245228, 1.55293971835, -1.06787481368),
                   vm.Point3D(3.46461447533, 1.5414752408899999, -1.09732093089),
                   vm.Point3D(3.4682003724199997, 1.5239143274, -1.13965383532),
                   vm.Point3D(3.4720154924899997, 1.5052204041400001, -1.18086952944),
                   vm.Point3D(3.47324714113, 1.49918439617, -1.19381590206),
                   vm.Point3D(3.47529033057, 1.48916965863, -1.21471965999),
                   vm.Point3D(3.47739406707, 1.47885564743, -1.23532831753),
                   vm.Point3D(3.47821511993, 1.47482990137, -1.24323934198),
                   vm.Point3D(3.48008793099, 1.46564642129, -1.26098994019),
                   vm.Point3D(3.4820065318, 1.45623661031, -1.27851736362),
                   vm.Point3D(3.48308899302, 1.45092711653, -1.28820729386),
                   vm.Point3D(3.4863821767, 1.4347723764100002, -1.3170988013),
                   vm.Point3D(3.4898031974, 1.41798575985, -1.3453672436300002),
                   vm.Point3D(3.49214188864, 1.40650798585, -1.36394511358),
                   vm.Point3D(3.51146952521, 1.3116361646699999, -1.51159072569),
                   vm.Point3D(3.53451161107, 1.19840445967, -1.6411324769800002),
                   vm.Point3D(3.55760199763, 1.08485203794, -1.7404623938800001),
                   vm.Point3D(3.59388036294, 0.906335668587, -1.8566826521400002),
                   vm.Point3D(3.63658074643, 0.6960763679499999, -1.94160262454),
                   vm.Point3D(3.6489187732999997, 0.635313586138, -1.96263554778),
                   vm.Point3D(3.6714483857099998, 0.5243429955840001, -1.99522712333),
                   vm.Point3D(3.69561102784, 0.405300620083, -2.01985947249),
                   vm.Point3D(3.70631689925, 0.35255078479, -2.0289115460400002),
                   vm.Point3D(3.7343162268400003, 0.21458101861200002, -2.04825944453),
                   vm.Point3D(3.76432018745, 0.0667026961911, -2.0578369585300003),
                   vm.Point3D(3.78323975107, -0.0265548040383, -2.06020729556),
                   vm.Point3D(3.82074885039, -0.21146222631800002, -2.0578924574),
                   vm.Point3D(3.8608376584, -0.409120704838, -2.0430043725),
                   vm.Point3D(3.88050106096, -0.506078565939, -2.03308527584),
                   vm.Point3D(3.9007531504, -0.60594620506, -2.02029697711),
                   vm.Point3D(3.92159319118, -0.708719986516, -2.00464306129),
                   vm.Point3D(3.8389068275700002, 1.76695158612, -0.0861959349675),
                   vm.Point3D(3.83854279157, 1.76898896437, -0.17500598063800002),
                   vm.Point3D(3.83874937207, 1.76820588335, -0.26103489748700004),
                   vm.Point3D(3.83947796675, 1.76484257606, -0.344519568495),
                   vm.Point3D(3.84128406988, 1.7562503656500001, -0.45823659192500005),
                   vm.Point3D(3.84414104312, 1.7424638850199998, -0.566831777634),
                   vm.Point3D(3.8450571771, 1.7380326281099998, -0.597850653317),
                   vm.Point3D(3.8478511708800003, 1.72449203306, -0.682833274299),
                   vm.Point3D(3.8513146821, 1.7076421284299999, -0.764552733),
                   vm.Point3D(3.8537985574999998, 1.69553735935, -0.815562817712),
                   vm.Point3D(3.85744853496, 1.67772605506, -0.881845330862),
                   vm.Point3D(3.8615504773100002, 1.6576807661200001, -0.945925011586),
                   vm.Point3D(3.86260079332, 1.65254654142, -0.961761769838),
                   vm.Point3D(3.8657809276500004, 1.63699673072, -1.0080789102999999),
                   vm.Point3D(3.86920126091, 1.6202596580500002, -1.0532253448),
                   vm.Point3D(3.87156604482, 1.60868267754, -1.08256052779),
                   vm.Point3D(3.87517839852, 1.5909909935600002, -1.1247644852799998),
                   vm.Point3D(3.87901006236, 1.57221529727, -1.1658995466900002),
                   vm.Point3D(3.88024596771, 1.5661582491500001, -1.17882517254),
                   vm.Point3D(3.8822944670400004, 1.55611726575, -1.1997030506000002),
                   vm.Point3D(3.88440082907, 1.54579027698, -1.22029891155),
                   vm.Point3D(3.885222491, 1.5417615204000001, -1.22820696746),
                   vm.Point3D(3.8870958039000003, 1.53257555981, -1.24595511975),
                   vm.Point3D(3.88901280641, 1.52317364898, -1.26349033316),
                   vm.Point3D(3.89009368181, 1.51787199359, -1.27318799249),
                   vm.Point3D(3.89338012389, 1.5017505760399998, -1.30211235784),
                   vm.Point3D(3.89678817298, 1.48502807593, -1.33044402254),
                   vm.Point3D(3.89911530726, 1.4736074259899998, -1.34907821997),
                   vm.Point3D(3.91832536567, 1.3793167734399998, -1.49729689656),
                   vm.Point3D(3.94104552758, 1.2676762830400001, -1.62840767341),
                   vm.Point3D(3.9636396536799996, 1.15657679154, -1.73015631517),
                   vm.Point3D(3.99889450528, 0.9831194742720001, -1.85136507864),
                   vm.Point3D(4.04018020065, 0.7798527337069999, -1.94318010199),
                   vm.Point3D(4.05208936023, 0.721209769135, -1.96630328226),
                   vm.Point3D(4.07385831748, 0.613998966214, -2.00260221636),
                   vm.Point3D(4.09717104095, 0.499157592433, -2.03137698556),
                   vm.Point3D(4.10748046109, 0.448367347576, -2.0423613236500002),
                   vm.Point3D(4.13448125652, 0.315333154085, -2.06657596977),
                   vm.Point3D(4.1634097246, 0.172770806332, -2.0813953287899998),
                   vm.Point3D(4.18171657295, 0.0825418522461, -2.0867519797800003),
                   vm.Point3D(4.218017421260001, -0.09639339305900001, -2.09032603838),
                   vm.Point3D(4.25694140334, -0.288294337347, -2.0811152006799998),
                   vm.Point3D(4.27606156529, -0.382567053584, -2.07384380534),
                   vm.Point3D(4.29576954105, -0.479745232322, -2.06370746326),
                   vm.Point3D(4.31606613087, -0.579832829163, -2.05070227404),
                   vm.Point3D(4.05849536532, 1.80371033448, -0.07869919913159999),
                   vm.Point3D(4.0582473561, 1.80517421225, -0.166943741614),
                   vm.Point3D(4.05852361912, 1.80404670255, -0.252633032695),
                   vm.Point3D(4.05935344249, 1.80018303928, -0.33562432506400003),
                   vm.Point3D(4.061272897129999, 1.7910305518299998, -0.448788884339),
                   vm.Point3D(4.0642327288, 1.77673565967, -0.5568827481549999),
                   vm.Point3D(4.06517573104, 1.7721715976, -0.587770670601),
                   vm.Point3D(4.06802955857, 1.75833525457, -0.672461667712),
                   vm.Point3D(4.07153209294, 1.74129246526, -0.753990931454),
                   vm.Point3D(4.07403558214, 1.72909074851, -0.804905420411),
                   vm.Point3D(4.0777145199, 1.71113629848, -0.871046783937),
                   vm.Point3D(4.08183999678, 1.69097468237, -0.9350117596490001),
                   vm.Point3D(4.08289589853, 1.68581284833, -0.9508212935679999),
                   vm.Point3D(4.0860913982, 1.67018708942, -0.997063544893),
                   vm.Point3D(4.08952357616, 1.6533914703800001, -1.0421522494400002),
                   vm.Point3D(4.09189432794, 1.6417849917399998, -1.07145834564),
                   vm.Point3D(4.095512234, 1.6240658634199998, -1.11363524151),
                   vm.Point3D(4.09934433099, 1.60528802614, -1.1547681917800001),
                   vm.Point3D(4.1005798343099995, 1.5992329651800001, -1.16769577709),
                   vm.Point3D(4.102626785589999, 1.5891996334999998, -1.18858120017),
                   vm.Point3D(4.10473010746, 1.57888767172, -1.20919187856),
                   vm.Point3D(4.10555037114, 1.57486582647, -1.21710674943),
                   vm.Point3D(4.10741994498, 1.5656983473600001, -1.2348731254899998),
                   vm.Point3D(4.10933201952, 1.55632079466, -1.25243235735),
                   vm.Point3D(4.11040982326, 1.55103432199, -1.2621449876900002),
                   vm.Point3D(4.11368583123, 1.53496447842, -1.29112020784),
                   vm.Point3D(4.11707997433, 1.51831071326, -1.319519649),
                   vm.Point3D(4.11939626378, 1.50694366743, -1.33820670306),
                   vm.Point3D(4.13850559362, 1.41315089887, -1.48691632078),
                   vm.Point3D(4.16101568298, 1.302548761, -1.61905097068),
                   vm.Point3D(4.183329935370001, 1.19283263702, -1.7221636893499999),
                   vm.Point3D(4.218029727, 1.02211888581, -1.84607776067),
                   vm.Point3D(4.25854625674, 0.8226539986400001, -1.94164162177),
                   vm.Point3D(4.27023142666, 0.7651181763880001, -1.9658565056),
                   vm.Point3D(4.29156114512, 0.6600784552479999, -2.00429624641),
                   vm.Point3D(4.31440711015, 0.547544188149, -2.03534595039),
                   vm.Point3D(4.32452080829, 0.49772136348499996, -2.0472842183),
                   vm.Point3D(4.3509932664, 0.367298650505, -2.07407392863),
                   vm.Point3D(4.3793957916299995, 0.227335947723, -2.09145668136),
                   vm.Point3D(4.39735365339, 0.138831974325, -2.09851425872),
                   vm.Point3D(4.43303646442, -0.0370484190643, -2.10510057026),
                   vm.Point3D(4.471358341039999, -0.22597325964, -2.0988243353900002),
                   vm.Point3D(4.49020011779, -0.31886996572, -2.09290976218),
                   vm.Point3D(4.50965051086, -0.41477495759599997, -2.08402885281),
                   vm.Point3D(4.52971034836, -0.513692328404, -2.0721775711599997),
                   vm.Point3D(4.50226299978, 1.86808449544, -0.054161811031299995),
                   vm.Point3D(4.50213824282, 1.86893915864, -0.141805634183),
                   vm.Point3D(4.50255976424, 1.86709366162, -0.226786950091),
                   vm.Point3D(4.50350041051, 1.8626822198100002, -0.309238102492),
                   vm.Point3D(4.505561092910001, 1.8528316678199999, -0.421714331524),
                   vm.Point3D(4.5086311795, 1.8379918045399999, -0.5292708236989999),
                   vm.Point3D(4.509604856889999, 1.83327612045, -0.560009238452),
                   vm.Point3D(4.51254506417, 1.81901281715, -0.644279229141),
                   vm.Point3D(4.516123426389999, 1.8015952238, -0.7254389153780001),
                   vm.Point3D(4.51866964613, 1.7891822973599998, -0.7761451398970001),
                   vm.Point3D(4.522390790759999, 1.77101922605, -0.8420807913170001),
                   vm.Point3D(4.52654370652, 1.75072198426, -0.9059120326060001),
                   vm.Point3D(4.52760546685, 1.7455311922599999, -0.921693012377),
                   vm.Point3D(4.530815468789999, 1.72983375112, -0.967864581073),
                   vm.Point3D(4.5342537941800005, 1.7130077464000002, -1.0129233236500002),
                   vm.Point3D(4.53662490703, 1.7013994830599999, -1.04222766004),
                   vm.Point3D(4.54023768468, 1.68370570355, -1.08442955124),
                   vm.Point3D(4.54405593968, 1.66499628486, -1.12562996602),
                   vm.Point3D(4.5452861683000005, 1.65896729583, -1.1385832597),
                   vm.Point3D(4.54732301555, 1.64898390664, -1.15951792884),
                   vm.Point3D(4.54941369286, 1.63873444478, -1.18019023561),
                   vm.Point3D(4.55022868827, 1.6347386396599999, -1.18813078348),
                   vm.Point3D(4.55208560717, 1.62563371179, -1.20595883852),
                   vm.Point3D(4.5539829986900004, 1.61632873468, -1.22358963395),
                   vm.Point3D(4.555051901210001, 1.6110862591800001, -1.23334564792),
                   vm.Point3D(4.558299316409999, 1.59515774478, -1.26246022645),
                   vm.Point3D(4.56165876557, 1.57867546578, -1.29102876244),
                   vm.Point3D(4.56394904441, 1.56743698597, -1.3098425897100001),
                   vm.Point3D(4.58282459055, 1.47479977001, -1.45969164623),
                   vm.Point3D(4.60489775123, 1.36635729543, -1.59395584357),
                   vm.Point3D(4.62662066674, 1.25956404799, -1.69995068016),
                   vm.Point3D(4.66016048768, 1.0945838323200001, -1.82951833464),
                   vm.Point3D(4.69909761069, 0.90292568095, -1.9327800689799999),
                   vm.Point3D(4.710311458670001, 0.8477195220029999, -1.9592921296699999),
                   vm.Point3D(4.7307800239999995, 0.7469363326930001, -2.00192904629),
                   vm.Point3D(4.7526899211, 0.639028888361, -2.03754105341),
                   vm.Point3D(4.76238286128, 0.591285797902, -2.0515300542599997),
                   vm.Point3D(4.7877766381, 0.46619482103399995, -2.08357715129),
                   vm.Point3D(4.81504522206, 0.331836994904, -2.1064866224000003),
                   vm.Point3D(4.8323267647499994, 0.24667595032200001, -2.11684051248),
                   vm.Point3D(4.86670925521, 0.0772228178368, -2.12976445878),
                   vm.Point3D(4.903833603140001, -0.105782844633, -2.1293248609399997),
                   vm.Point3D(4.92210972915, -0.195883636476, -2.12616721379),
                   vm.Point3D(4.9409918389000005, -0.288979701676, -2.1200560614199997),
                   vm.Point3D(4.96047250234, -0.385034314852, -2.11102761718),
                   vm.Point3D(4.9497248124199995, 1.9141989692899999, -0.0116193614667),
                   vm.Point3D(4.94958854416, 1.91511053059, -0.0993192893971),
                   vm.Point3D(4.94998020262, 1.91341264107, -0.18444615442200002),
                   vm.Point3D(4.9509182099, 1.90901424329, -0.266910168988),
                   vm.Point3D(4.95298221914, 1.89914724732, -0.379370183355),
                   vm.Point3D(4.9560668485, 1.88423550169, -0.486855795543),
                    vm.Point3D(4.9570444699700005, 1.87950032271, -0.517574987264),
                    vm.Point3D(4.9599907162, 1.8652071699600001, -0.601815544739),
                    vm.Point3D(4.9635700032, 1.84778500562, -0.682970723719),
                    vm.Point3D(4.966114118249999, 1.83538248232, -0.733687206313),
                    vm.Point3D(4.96983193654, 1.8172358524999999, -0.799639069941),
                    vm.Point3D(4.97397445244, 1.79699001546, -0.8635209991530001),
                    vm.Point3D(4.975033172350001, 1.79181425171, -0.879316797605),
                    vm.Point3D(4.97823261462, 1.77616900521, -0.9255398330919999),
                    vm.Point3D(4.98165528699, 1.75942037069, -0.970674866973),
                    vm.Point3D(4.98401342847, 1.74787622259, -1.00004242453),
                    vm.Point3D(4.98760293413, 1.73029747256, -1.04235774115),
                    vm.Point3D(4.99139085816, 1.71173797461, -1.08370598607),
                    vm.Point3D(4.9926107251800005, 1.7057602011900002, -1.09670978118),
                    vm.Point3D(4.994629450780001, 1.69586638419, -1.11773277345),
                    vm.Point3D(4.99669990018, 1.68571690541, -1.13850366906),
                    vm.Point3D(4.99750676884, 1.6817612694100001, -1.1464838259099999),
                    vm.Point3D(4.999344444229999, 1.6727514588599999, -1.16440567189),
                    vm.Point3D(5.0012208648200005, 1.6635501375300001, -1.18213867763),
                    vm.Point3D(5.00227765465, 1.65836753294, -1.1919537276399998),
                    vm.Point3D(5.00548683584, 1.64262800268, -1.22125465497),
                    vm.Point3D(5.00880284058, 1.62636046196, -1.2500349348),
                    vm.Point3D(5.01106174012, 1.61527708461, -1.26900170166),
                    vm.Point3D(5.0296635098, 1.5239930986199999, -1.42018511775),
                    vm.Point3D(5.051291056299999, 1.41775321825, -1.55662119481),
                    vm.Point3D(5.07246318383, 1.31368242101, -1.66530051786),
                    vm.Point3D(5.1049155406999995, 1.15407735319, -1.80016836538),
                    vm.Point3D(5.14229720024, 0.970107590213, -1.91101127589),
                    vm.Point3D(5.153046197949999, 0.9171991061889999, -1.93978897113),
                    vm.Point3D(5.17262760823, 0.820800971635, -1.98674979426),
                    vm.Point3D(5.19355749405, 0.717737554468, -2.02713828008),
                    vm.Point3D(5.202818698750001, 0.672128458251, -2.04323151729),
                    vm.Point3D(5.22706851404, 0.552691886368, -2.08085417037),
                    vm.Point3D(5.25314569501, 0.42422296030199996, -2.10957042266),
                    vm.Point3D(5.26968080068, 0.34275142555399996, -2.12356237349),
                    vm.Point3D(5.30268817169, 0.180095271963, -2.14318851693),
                    vm.Point3D(5.33851087608, 0.00352340981114, -2.14909300213),
                    vm.Point3D(5.3562384519099995, -0.0838659927565, -2.14860893482),
                    vm.Point3D(5.37463278415, -0.17455105763200002, -2.14487516226),
                    vm.Point3D(5.3937155388299995, -0.268638876204, -2.1377860862699998),
                    vm.Point3D(5.1756853632299995, 1.9330089607, 0.0141039230945),
                    vm.Point3D(5.17550196676, 1.93415346886, -0.07382570325679999),
                    vm.Point3D(5.17586869653, 1.93257879757, -0.159074068365),
                    vm.Point3D(5.17677076206, 1.92835805366, -0.241713259463),
                    vm.Point3D(5.17879672607, 1.9186791087500001, -0.35435870257),
                    vm.Point3D(5.1818497276999995, 1.9039236935300001, -0.461998465175),
                    vm.Point3D(5.18281923319, 1.89922863042, -0.49275721336100003),
                    vm.Point3D(5.185747743019999, 1.88502314564, -0.577084216286),
                    vm.Point3D(5.18931464115, 1.86766221729, -0.6582997773329999),
                    vm.Point3D(5.19185205075, 1.8552928379, -0.709048941642),
                    vm.Point3D(5.195558666109999, 1.83720158221, -0.77505540722),
                    vm.Point3D(5.19968803769, 1.8170207152600002, -0.839001400532),
                    vm.Point3D(5.20074330104, 1.81186203672, -0.8548140459479999),
                    vm.Point3D(5.2039320164800005, 1.7962698110700002, -0.90108936293),
                    vm.Point3D(5.20734211908, 1.77958330676, -0.9462856606310001),
                    vm.Point3D(5.20969094339, 1.7680852118200001, -0.975698629155),
                    vm.Point3D(5.21326494112, 1.7505831148, -1.01808952988),
                    vm.Point3D(5.217034561659999, 1.73211408791, -1.05952698427),
                    vm.Point3D(5.21824835609, 1.72616633025, -1.07256037657),
                    vm.Point3D(5.2202566835, 1.71632390971, -1.0936340486),
                    vm.Point3D(5.22231587694, 1.7062300671800001, -1.11445980463),
                    vm.Point3D(5.22311826636, 1.70229657129, -1.12246179285),
                    vm.Point3D(5.22494581789, 1.69333680127, -1.14043298155),
                    vm.Point3D(5.22681146705, 1.6841887212, -1.15821848613),
                    vm.Point3D(5.2278618654499995, 1.6790377084399999, -1.16806468743),
                    vm.Point3D(5.23105150698, 1.6633947593, -1.19746084909),
                    vm.Point3D(5.234346061919999, 1.6472332412600001, -1.22634567314),
                    vm.Point3D(5.23658973161, 1.63622514247, -1.24538666883),
                    vm.Point3D(5.25506128709, 1.54558478283, -1.3972047361),
                    vm.Point3D(5.2764929062, 1.44031333785, -1.53459574401),
                    vm.Point3D(5.297415711519999, 1.3374748974100001, -1.64449023901),
                    vm.Point3D(5.32937504475, 1.1803067606300002, -1.78176103532),
                    vm.Point3D(5.36598991451, 1.00012710761, -1.89634120387),
                    vm.Point3D(5.37650276606, 0.948385853411, -1.92626985228),
                    vm.Point3D(5.39563507061, 0.854207571259, -1.9754195726600001),
                    vm.Point3D(5.41605339072, 0.753672735387, -2.01830137949),
                    vm.Point3D(5.425080539370001, 0.709220537917, -2.03553538285),
                    vm.Point3D(5.44872393412, 0.592781398459, -2.0761136701000003),
                    vm.Point3D(5.47414969448, 0.467532332356, -2.10800488242),
                    vm.Point3D(5.49030257657, 0.38795006296999995, -2.1238597534),
                    vm.Point3D(5.52256451626, 0.228978448231, -2.1471190559299997),
                    vm.Point3D(5.557740402319999, 0.0556036978173, -2.15617607001),
                    vm.Point3D(5.57511459701, -0.0300390025889, -2.15741434769),
                    vm.Point3D(5.59322553017, -0.119323274502, -2.1550618343299996),
                    vm.Point3D(5.61197008326, -0.211739420785, -2.14962111977),
                    vm.Point3D(5.50370313057, 1.95394348735, 0.0574793455532),
                    vm.Point3D(5.5033913137, 1.95572275539, -0.0310761892452),
                    vm.Point3D(5.5036396748200005, 1.95473316001, -0.116901471452),
                    vm.Point3D(5.50446292016, 1.95090201084, -0.199924824512),
                    vm.Point3D(5.50639633807, 1.94168050537, -0.313021328225),
                    vm.Point3D(5.50938166191, 1.92725960979, -0.4209909457),
                    vm.Point3D(5.5103328903, 1.92265488728, -0.451838774703),
                    vm.Point3D(5.5132115136, 1.90869598302, -0.536408919666),
                    vm.Point3D(5.516733386259999, 1.89155760779, -0.617843930398),
                    vm.Point3D(5.51924160915, 1.87933249329, -0.6687353478820001),
                    vm.Point3D(5.52290776133, 1.86144124017, -0.7349390270630001),
                    vm.Point3D(5.52699072379, 1.8414897655, -0.799111213849),
                    vm.Point3D(5.52803403362, 1.83639017116, -0.814982119552),
                    vm.Point3D(5.53118619056, 1.82097864791, -0.8614356190879999),
                    vm.Point3D(5.53455576622, 1.80449246129, -0.906829441115),
                    vm.Point3D(5.53687593493, 1.7931360060500001, -0.9363820742169999),
                    vm.Point3D(5.54040542573, 1.7758538991200001, -0.978989897337),
                    vm.Point3D(5.5441262642, 1.7576259935999998, -1.02066511074),
                    vm.Point3D(5.54532413507, 1.75175694333, -1.0337761128899998),
                    vm.Point3D(5.5473058302, 1.7420461616099998, -1.05497958806),
                    vm.Point3D(5.54933724764, 1.73208961106, -1.0759407215799999),
                    vm.Point3D(5.55012875193, 1.7282099184900002, -1.0839957628499999),
                    vm.Point3D(5.55193087703, 1.71937582695, -1.10209087749),
                    vm.Point3D(5.5537701435099995, 1.7103581519300002, -1.12000496866),
                    vm.Point3D(5.55480586945, 1.70527966256, -1.1299226820300001),
                    vm.Point3D(5.5579500723, 1.68986130907, -1.15954030743),
                    vm.Point3D(5.56119644686, 1.67393793833, -1.18865995789),
                    vm.Point3D(5.56340682062, 1.6630944156, -1.20786323467),
                    vm.Point3D(5.58159989616, 1.5738305344099999, -1.36103858582),
                    vm.Point3D(5.60268149103, 1.47028919903, -1.50013557747),
                    vm.Point3D(5.62328913013, 1.3690085710000002, -1.61156616168),
                    vm.Point3D(5.6547222184, 1.21444157257, -1.75140182426),
                    vm.Point3D(5.6905133033299995, 1.03833374627, -1.86999703918),
                    vm.Point3D(5.70077084807, 0.987854429723, -1.90117002792),
                    vm.Point3D(5.71939246155, 0.896200405652, -1.95280880639),
                    vm.Point3D(5.73917659123, 0.7988002639830001, -1.9987815951),
                    vm.Point3D(5.74790911917, 0.75580432605, -2.01745155092),
                    vm.Point3D(5.77072524295, 0.643454244665, -2.06206187559),
                    vm.Point3D(5.795176158209999, 0.5230236702700001, -2.09870438723),
                    vm.Point3D(5.81066423648, 0.446727411837, -2.1177994467600003),
                    vm.Point3D(5.84167445726, 0.293942828299, -2.1471595042700002),
                    vm.Point3D(5.87568374822, 0.12633435679, -2.1619023883999997),
                    vm.Point3D(5.8927173988699995, 0.0423749069631, -2.16480044407),
                    vm.Point3D(5.9103446679400005, -0.0445186966491, -2.1648052619700002),
                    vm.Point3D(5.92878023142, -0.135407560373, -2.1608705322699997),
                    vm.Point3D(5.83370704216, 1.96506084469, 0.11053503983900001),
                    vm.Point3D(5.833130012180001, 1.96815101553, 0.020686882470099997),
                    vm.Point3D(5.83316745421, 1.9682039568299998, -0.0661663986435),
                    vm.Point3D(5.8338152212, 1.9652401669200001, -0.150045015897),
                    vm.Point3D(5.83556249122, 1.9569387584000002, -0.264048786067),
                    vm.Point3D(5.838404558060001, 1.94322595757, -0.37271662413400003),
                    vm.Point3D(5.83931699195, 1.93881298961, -0.40375353373399997),
                    vm.Point3D(5.84209316667, 1.92536047106, -0.48882300302200005),
                    vm.Point3D(5.84551660582, 1.9087086357799998, -0.570737769057),
                    vm.Point3D(5.84795814883, 1.8968131084500002, -0.621954177713),
                    vm.Point3D(5.85152440433, 1.87941562744, -0.6886447435049999),
                    vm.Point3D(5.85549109747, 1.86003885204, -0.7533836155589999),
                    vm.Point3D(5.85650433384, 1.85508790563, -0.7694010963429999),
                    vm.Point3D(5.85956451381, 1.84013100868, -0.816302882564),
                    vm.Point3D(5.86283243888, 1.82414726347, -0.8621921396000001),
                    vm.Point3D(5.8650811329999994, 1.8131440948500002, -0.892093132858),
                    vm.Point3D(5.86850008831, 1.79640834584, -0.935239695097),
                    vm.Point3D(5.87210385927, 1.7787590849000001, -0.977485484058),
                    vm.Point3D(5.87326409861, 1.77307604079, -0.99077989856),
                    vm.Point3D(5.87518368908, 1.76367223172, -1.0122860657500001),
                    vm.Point3D(5.87715191661, 1.75402801803, -1.03355518069),
                    vm.Point3D(5.87791888034, 1.75026962523, -1.04172983025),
                    vm.Point3D(5.87966591306, 1.74170784586, -1.06009345974),
                    vm.Point3D(5.881449710969999, 1.73296434243, -1.07827789927),
                    vm.Point3D(5.88245413198, 1.72804058797, -1.08834818982),
                    vm.Point3D(5.88550478669, 1.71308462682, -1.11842175963),
                    vm.Point3D(5.88865780336, 1.6976227081100002, -1.1479964273099998),
                    vm.Point3D(5.89080624834, 1.68708528864, -1.16750153885),
                    vm.Point3D(5.908505238609999, 1.60026358595, -1.32308501307),
                    vm.Point3D(5.9291405979, 1.4989279163, -1.46435691313),
                    vm.Point3D(5.94940231598, 1.39935711638, -1.5774734824),
                    vm.Point3D(5.98029907904, 1.2474410812, -1.71992314137),
                    vm.Point3D(6.01541176159, 1.0746864811699999, -1.84182482287),
                    vm.Point3D(6.02546777428, 1.02520330287, -1.8739800590100002),
                    vm.Point3D(6.04370748379, 0.935436964471, -1.92748019996),
                    vm.Point3D(6.063047356979999, 0.840232706216, -1.97561825116),
                    vm.Point3D(6.07157332321, 0.798257767293, -1.99529496846),
                    vm.Point3D(6.09383044249, 0.688670748982, -2.0426298261399998),
                    vm.Point3D(6.11758109572, 0.571701449354, -2.0826853461300003),
                    vm.Point3D(6.1326020113799995, 0.497714295289, -2.10405731026),
                    vm.Point3D(6.16251189209, 0.35036850346799997, -2.13878031718),
                    vm.Point3D(6.19528655469, 0.188862587517, -2.1595406585),
                    vm.Point3D(6.21152461646, 0.108835596674, -2.1663163364),
                    vm.Point3D(6.22886241798, 0.0233727814455, -2.1677319907299997),
                    vm.Point3D(6.24706346323, -0.06635689909369999, -2.16494027994),
                    vm.Point3D(5.93570241784, 1.96749104857, 0.12788577148),
                    vm.Point3D(5.93502342487, 1.9710852049, 0.0375406565185),
                    vm.Point3D(5.93497385744, 1.97156821905, -0.0497367001541),
                    vm.Point3D(5.93556353169, 1.96889157157, -0.133898455716),
                    vm.Point3D(5.937242641279999, 1.9609270682900002, -0.248234433116),
                    vm.Point3D(5.94003361839, 1.94746679519, -0.357151277493),
                    vm.Point3D(5.94093231742, 1.94312171626, -0.38825512944),
                    vm.Point3D(5.9436713909600005, 1.92985258246, -0.47350542623400005),
                    vm.Point3D(5.94705970127, 1.91337438302, -0.5555914068119999),
                    vm.Point3D(5.9494768365, 1.90159949916, -0.606926776604),
                    vm.Point3D(5.95300628938, 1.88438392716, -0.673796714742),
                    vm.Point3D(5.95692886592, 1.86522521251, -0.738750606762),
                    vm.Point3D(5.95793065091, 1.86033086829, -0.754823900432),
                    vm.Point3D(5.960955670590001, 1.84554776265, -0.801897054487),
                    vm.Point3D(5.96418455, 1.8297570134099999, -0.8479766162360001),
                    vm.Point3D(5.96640595906, 1.81888871015, -0.878010594186),
                    vm.Point3D(5.96978388158, 1.80235577915, -0.921357146207),
                    vm.Point3D(5.97334467438, 1.78491895185, -0.9638124064879999),
                    vm.Point3D(5.9744910538100005, 1.77930441493, -0.977174372873),
                    vm.Point3D(5.97638789817, 1.77001303597, -0.9987914023710001),
                    vm.Point3D(5.97833326745, 1.76048180666, -1.02017192615),
                    vm.Point3D(5.97909145134, 1.7567668111299999, -1.02838936781),
                    vm.Point3D(5.98081750254, 1.7483087397700001, -1.04685525914),
                    vm.Point3D(5.98258025193, 1.73966927555, -1.06514228708),
                    vm.Point3D(5.98357371712, 1.73479967383, -1.07526597523),
                    vm.Point3D(5.98659039494, 1.72001165458, -1.10550514505),
                    vm.Point3D(5.98970977589, 1.7047159914599999, -1.13524374994),
                    vm.Point3D(5.99183620853, 1.69428737522, -1.15485614747),
                    vm.Point3D(6.00935942436, 1.6083344953599998, -1.3112963290600002),
                    vm.Point3D(6.0298416804, 1.50775558875, -1.45331443933),
                    vm.Point3D(6.049999527210001, 1.40869820659, -1.5669372669100001),
                    vm.Point3D(6.08071428575, 1.25768178844, -1.7102739980300001),
                    vm.Point3D(6.11562383862, 1.08593122349, -1.83316571364),
                    vm.Point3D(6.12562036877, 1.03674205719, -1.8656108618799998),
                    vm.Point3D(6.14375068853, 0.947516413494, -1.9196441577099999),
                    vm.Point3D(6.16296619399, 0.852926883554, -1.96838836502),
                    vm.Point3D(6.17143750132, 0.81122211412, -1.98833148439),
                    vm.Point3D(6.19353978912, 0.7024004012289999, -2.03642097553),
                    vm.Point3D(6.21713162597, 0.586216103599, -2.07725055091),
                    vm.Point3D(6.2320235925, 0.5128663229679999, -2.0992510005),
                    vm.Point3D(6.26169357556, 0.366706303915, -2.13514324497),
                    vm.Point3D(6.29411712053, 0.206935902015, -2.15761489918),
                    vm.Point3D(6.310276211700001, 0.12729924928, -2.16477547194),
                    vm.Point3D(6.32710294532, 0.044362554709500006, -2.168682021),
                    vm.Point3D(6.34530100919, -0.045352389313899996, -2.16590484116),
                    vm.Point3D(6.07162784129, 1.96925324258, 0.15240674794200001),
                    vm.Point3D(6.07077250733, 1.97371902209, 0.061202164342700004),
                    vm.Point3D(6.07058943155, 1.97486194503, -0.026725898908200003),
                    vm.Point3D(6.0710695867, 1.9727266316099998, -0.111421439801),
                    vm.Point3D(6.07264326172, 1.9652832733299999, -0.22627129497),
                    vm.Point3D(6.07535560868, 1.95221165553, -0.335571374977),
                    vm.Point3D(6.07623259557, 1.94797389596, -0.36678104974500003),
                    vm.Point3D(6.07891263856, 1.93499654005, -0.452319055681),
                    vm.Point3D(6.08223993007, 1.91881994603, -0.5347024358910001),
                    vm.Point3D(6.08461521928, 1.90725189984, -0.5862417590579999),
                    vm.Point3D(6.0880844638, 1.8903339273500002, -0.653405146781),
                    vm.Point3D(6.0919392961100005, 1.8715100608400002, -0.718689217581),
                    vm.Point3D(6.09292365699, 1.86670184102, -0.7348474346780001),
                    vm.Point3D(6.09589556153, 1.85218127433, -0.782179466658),
                    vm.Point3D(6.09906570142, 1.83668086445, -0.828545319071),
                    vm.Point3D(6.101245179929999, 1.8260198166800001, -0.858783662401),
                    vm.Point3D(6.10455604697, 1.8098183293699999, -0.9024570362350001),
                    vm.Point3D(6.1080460071400005, 1.79273161559, -0.945257527801),
                    vm.Point3D(6.1091698335, 1.78722855461, -0.958729415635),
                    vm.Point3D(6.11102966258, 1.7781201357699998, -0.98052685393),
                    vm.Point3D(6.1129376093, 1.7687738797399999, -1.0020897716),
                    vm.Point3D(6.11368118369, 1.7651310965, -1.01037841857),
                    vm.Point3D(6.11537657846, 1.7568245545699999, -1.0289937263),
                    vm.Point3D(6.11710882373, 1.74833586701, -1.04742942836),
                    vm.Point3D(6.11808385197, 1.7435573959400001, -1.05764297637),
                    vm.Point3D(6.12104772736, 1.72903037004, -1.08813950006),
                    vm.Point3D(6.12411542361, 1.71399017549, -1.1181300110899999),
                    vm.Point3D(6.1262079290900004, 1.70372925534, -1.13790776625),
                    vm.Point3D(6.1434696667, 1.61906881737, -1.29562236702),
                    vm.Point3D(6.16378764509, 1.51930190691, -1.43844115041),
                    vm.Point3D(6.18375158428, 1.4212029768299999, -1.5530090647500001),
                    vm.Point3D(6.2142106010400004, 1.27145064628, -1.6975922561499999),
                    vm.Point3D(6.248824040360001, 1.1011637196700002, -1.82192720013),
                    vm.Point3D(6.258735789139999, 1.05239361306, -1.85478556439),
                    vm.Point3D(6.27670851415, 0.963946933095, -1.90958696153),
                    vm.Point3D(6.29575496718, 0.870193000236, -1.95915511379),
                    vm.Point3D(6.30414888841, 0.8288707369920001, -1.9794754054099999),
                    vm.Point3D(6.32605584719, 0.721014501849, -2.02851691102),
                    vm.Point3D(6.34941338461, 0.605988306017, -2.07048843882),
                    vm.Point3D(6.36417526957, 0.5332814961719999, -2.09312289319),
                    vm.Point3D(6.39357367743, 0.388463826628, -2.13033876851),
                    vm.Point3D(6.4256517315399995, 0.23040112665, -2.15449431129),
                    vm.Point3D(6.44161788209, 0.151718146166, -2.16259525771),
                    vm.Point3D(6.45850935527, 0.06846145516270001, -2.16618627253),
                    vm.Point3D(6.47615128358, -0.0185046065504, -2.16611964265),
                    vm.Point3D(6.2079967612, 1.96882330989, 0.179089282609),
                    vm.Point3D(6.2069090563, 1.9744376589500001, 0.08675214589399999),
                    vm.Point3D(6.2065323694500005, 1.97653756815, -0.00211955873517),
                    vm.Point3D(6.20688888123, 1.97501340263, -0.087417725264),
                    vm.Point3D(6.2083238536400005, 1.96825562753, -0.202943603373),
                    vm.Point3D(6.21091237953, 1.95579603594, -0.31284717507099996),
                    vm.Point3D(6.21175400825, 1.9517330457200002, -0.344229182091),
                    vm.Point3D(6.21433638735, 1.93923842561, -0.430243192219),
                    vm.Point3D(6.21756800715, 1.9235347204, -0.51309286695),
                    vm.Point3D(6.21988170592, 1.9122711051399999, -0.564932375857),
                    vm.Point3D(6.22326929724, 1.89575673042, -0.632493733297),
                    vm.Point3D(6.227041771580001, 1.87733994515, -0.698179208707),
                    vm.Point3D(6.2280055689000005, 1.87263336748, -0.714437650589),
                    vm.Point3D(6.23091661476, 1.85841361478, -0.762066301807),
                    vm.Point3D(6.234024918979999, 1.84321884796, -0.80873353518),
                    vm.Point3D(6.23616309246, 1.83276196384, -0.8391731951629999),
                    vm.Point3D(6.23941121453, 1.81687061419, -0.883152381882),
                    vm.Point3D(6.24283002603, 1.8001355759800002, -0.92629964501),
                    vm.Point3D(6.24393018032, 1.79474952201, -0.939886908225),
                    vm.Point3D(6.24574998719, 1.78583892609, -0.961879410853),
                    vm.Point3D(6.24761655939, 1.77669717719, -0.983643983868),
                    vm.Point3D(6.24834418954, 1.77313320356, -0.992010341475),
                    vm.Point3D(6.25000096459, 1.7650175522699998, -1.01081387793),
                    vm.Point3D(6.2516948887899995, 1.75671827915, -1.02943635311),
                    vm.Point3D(6.25265057578, 1.7520354085399998, -1.0397441684600002),
                    vm.Point3D(6.25555533224, 1.73780059734, -1.0705288320100002),
                    vm.Point3D(6.25856916434, 1.7230266440400002, -1.10078187164),
                    vm.Point3D(6.2606289341700005, 1.71292753058, -1.12071917714),
                    vm.Point3D(6.27763738651, 1.6295190381100002, -1.27966826541),
                    vm.Point3D(6.29774834257, 1.53077540344, -1.42349605533),
                    vm.Point3D(6.3175029896899995, 1.43371096803, -1.53908403863),
                    vm.Point3D(6.34767909014, 1.28535704419, -1.68504613641),
                    vm.Point3D(6.381982685660001, 1.11660162213, -1.81089122855),
                    vm.Point3D(6.391806249319999, 1.06826739946, -1.8441793984900001),
                    vm.Point3D(6.40962212151, 0.980596016008, -1.89974528087),
                    vm.Point3D(6.42850398538, 0.887655619002, -1.95011562447),
                     vm.Point3D(6.43682692796, 0.8466841910399999, -1.97078185909),
                     vm.Point3D(6.45854452486, 0.739763939075, -2.02074629587),
                     vm.Point3D(6.48170611223, 0.625706290644, -2.063672865),
                     vm.Point3D(6.49634435728, 0.55361061162, -2.08690992814),
                     vm.Point3D(6.52548549622, 0.410064578063, -2.1253797069),
                     vm.Point3D(6.5573370872, 0.253121246396, -2.15063900874),
                     vm.Point3D(6.57319369002, 0.174979741495, -2.15927388),
                     vm.Point3D(6.589844541440001, 0.0929124024465, -2.16403766164),
                     vm.Point3D(6.60732361075, 0.00675132482613, -2.16476479062),
                     vm.Point3D(6.241840830299999, 1.9685802778, 0.18584047585400001),
                     vm.Point3D(6.24069207438, 1.97449639158, 0.09320578243859999),
                     vm.Point3D(6.240265033009999, 1.9768451944999998, 0.00408865481898),
                     vm.Point3D(6.24058797847, 1.97548694155, -0.08137311067320001),
                     vm.Point3D(6.24198778109, 1.9689030046, -0.19707040281600002),
                     vm.Point3D(6.2445417259100005, 1.9566143413400001, -0.3071425193),
                     vm.Point3D(6.245373303, 1.95260103461, -0.33857351698000004),
                     vm.Point3D(6.24792912745, 1.94023766956, -0.424716951861),
                     vm.Point3D(6.2511342799900005, 1.92466478744, -0.507695625389),
                     vm.Point3D(6.25343169912, 1.91348163965, -0.559614479674),
                     vm.Point3D(6.25679745954, 1.89707517132, -0.627282238786),
                     vm.Point3D(6.26054863003, 1.8787636873, -0.6930715470559999),
                     vm.Point3D(6.26150710068, 1.87408343844, -0.709355950592),
                     vm.Point3D(6.2644024934299996, 1.8599410564, -0.757060893562),
                     vm.Point3D(6.26749527485, 1.8448230160999999, -0.803803783527),
                     vm.Point3D(6.269622920380001, 1.8344181698100002, -0.8342947556929999),
                     vm.Point3D(6.27285635309, 1.81859942712, -0.878345536881),
                     vm.Point3D(6.27625905456, 1.80194401808, -0.92157131878),
                     vm.Point3D(6.2773540503000005, 1.79658346187, -0.9351837242000001),
                     vm.Point3D(6.27916357797, 1.78772367431, -0.957226326688),
                     vm.Point3D(6.281017158349999, 1.7786461417200001, -0.9790542205289999),
                     vm.Point3D(6.28173908627, 1.77511035321, -0.987448370224),
                     vm.Point3D(6.283388514, 1.76703101852, -1.00628771685),
                     vm.Point3D(6.28507498329, 1.75876859372, -1.02494652652),
                     vm.Point3D(6.2860228654100005, 1.7541243012699999, -1.03529238206),
                     vm.Point3D(6.2889117952, 1.73996771859, -1.06615418326),
                     vm.Point3D(6.29191401868, 1.72525114465, -1.09646380211),
                     vm.Point3D(6.29396613953, 1.7151898388, -1.11643838801),
                     vm.Point3D(6.310912034199999, 1.63209055813, -1.2756923762199999),
                     vm.Point3D(6.33096801752, 1.53361864427, -1.41978809788),
                     vm.Point3D(6.35067073996, 1.4368108636199999, -1.53562915697),
                     vm.Point3D(6.38077472447, 1.28881339644, -1.68194274073),
                     vm.Point3D(6.41500115667, 1.12043937944, -1.80816391935),
                     vm.Point3D(6.42480296923, 1.07221266868, -1.84155810198),
                     vm.Point3D(6.44257990521, 0.984733740178, -1.89731375559),
                     vm.Point3D(6.46142159366, 0.891991923437, -1.94787991031),
                     vm.Point3D(6.46972680719, 0.851108127082, -1.96863255454),
                     vm.Point3D(6.49139863096, 0.744414123819, -2.01882008507),
                     vm.Point3D(6.51451279497, 0.630590880884, -2.0619777909700003),
                     vm.Point3D(6.52911916072, 0.5586527757699999, -2.08537023071),
                     vm.Point3D(6.55820441522, 0.415382969388, -2.12411238474),
                     vm.Point3D(6.58999536687, 0.25873936747099996, -2.14966723669),
                     vm.Point3D(6.6058132851, 0.180789073887, -2.15849065287),
                     vm.Point3D(6.62244024431, 0.0988398299206, -2.16337088281),
                     vm.Point3D(6.6398536013200005, 0.0130035568879, -2.16441828707),
                     vm.Point3D(6.29312382687, 1.96800541064, 0.196266047523),
                     vm.Point3D(6.29188145265, 1.97438426361, 0.103175067663),
                     vm.Point3D(6.291362760629999, 1.97718607992, 0.013611243798400001),
                     vm.Point3D(6.291646999079999, 1.97601914906, -0.07203917586769999),
                     vm.Point3D(6.2929828720200005, 1.96975120554, -0.188048055015),
                     vm.Point3D(6.2954770925800005, 1.95775774901, -0.29841126166),
                     vm.Point3D(6.29629300336, 1.95382187818, -0.329918615417),
                     vm.Point3D(6.29880291904, 1.94168543224, -0.416285805088),
                     vm.Point3D(6.301965937119999, 1.9263208135499998, -0.499469837882),
                     vm.Point3D(6.30423576007, 1.91527406893, -0.551523193234),
                     vm.Point3D(6.30756710939, 1.8990376887, -0.619358668618),
                     vm.Point3D(6.31128427535, 1.88089428327, -0.685313711672),
                     vm.Point3D(6.312234392260001, 1.8762553254899998, -0.7016388305079999),
                     vm.Point3D(6.3151051985599995, 1.86223447005, -0.749463605419),
                     vm.Point3D(6.31817366562, 1.84723661147, -0.796325001207),
                     vm.Point3D(6.320285446550001, 1.8369101811600002, -0.8268932958630001),
                     vm.Point3D(6.323495025500001, 1.82120934347, -0.871060337904),
                     vm.Point3D(6.32687381383, 1.80467213298, -0.9144026701169999),
                     vm.Point3D(6.327960903729999, 1.79935065396, -0.9280536078),
                     vm.Point3D(6.32975907193, 1.79054701428, -0.950151575203),
                     vm.Point3D(6.33160059963, 1.78152905604, -0.972038212649),
                     vm.Point3D(6.3323180279999995, 1.77801550807, -0.9804542927479999),
                     vm.Point3D(6.333944939639999, 1.77004746647, -0.9994033805279999),
                     vm.Point3D(6.3356098669000005, 1.76189152027, -1.01816718397),
                     vm.Point3D(6.33655491, 1.7572612605700002, -1.02852687658),
                     vm.Point3D(6.339424757040001, 1.74319900065, -1.05948168525),
                     vm.Point3D(6.34240801074, 1.72857619108, -1.0898837609499998),
                     vm.Point3D(6.34444736948, 1.71857796614, -1.10992054811),
                     vm.Point3D(6.3612943755, 1.63596747508, -1.2696565099100001),
                     vm.Point3D(6.3812665293099995, 1.53790991604, -1.41416080833),
                     vm.Point3D(6.40088784695, 1.44150450535, -1.53039862647),
                     vm.Point3D(6.43088130602, 1.2940533463700001, -1.67725090033),
                     vm.Point3D(6.46499046131, 1.12625900897, -1.8040436750900002),
                     vm.Point3D(6.47475928362, 1.0781953633299999, -1.83759864895),
                     vm.Point3D(6.492477544170001, 0.991006457403, -1.8936402808600001),
                     vm.Point3D(6.51125870906, 0.898563798182, -1.94450142144),
                     vm.Point3D(6.5195377233, 0.857809500447, -1.96538175847),
                     vm.Point3D(6.54114112107, 0.751453715133, -2.0159027905999998),
                     vm.Point3D(6.564184898090001, 0.637978382979, -2.05940355578),
                     vm.Point3D(6.57874532618, 0.566267339787, -2.0830198911299997),
                     vm.Point3D(6.60774786825, 0.42340636679099997, -2.1221651775),
                     vm.Point3D(6.63944566071, 0.267223234702, -2.1481740781600003),
                     vm.Point3D(6.65522062466, 0.18948525672900002, -2.15720684928),
                     vm.Point3D(6.67177972007, 0.107871451819, -2.16241784067),
                     vm.Point3D(6.68912598617, 0.0223667976469, -2.1637922394799998),
                     vm.Point3D(6.34445929, 1.9671712103699999, 0.206947335991),
                     vm.Point3D(6.343129187530001, 1.97398368895, 0.113428777289),
                     vm.Point3D(6.3425110580199995, 1.9772770076700001, 0.0233803048484),
                     vm.Point3D(6.34275806608, 1.97629410019, -0.0624515720487),
                     vm.Point3D(6.34401163895, 1.9704329517999999, -0.178861573685),
                     vm.Point3D(6.346442691999999, 1.9587517213999999, -0.28953265256),
                     vm.Point3D(6.34723855943, 1.95491492137, -0.321137695609),
                     vm.Point3D(6.34969863017, 1.9430248504199998, -0.407747824647),
                     vm.Point3D(6.3528125779, 1.927902778, -0.491171021472),
                     vm.Point3D(6.35505410902, 1.9169958750599998, -0.543362268455),
                     vm.Point3D(6.35834708919, 1.90094914698, -0.611384751353),
                     vm.Point3D(6.36202867038, 1.8829816308699998, -0.6775132310090001),
                     vm.Point3D(6.3629699317499995, 1.87838644454, -0.6938815109030001),
                     vm.Point3D(6.3658149999099995, 1.8644928082799999, -0.741831730968),
                     vm.Point3D(6.36885842417, 1.8496187319400001, -0.788815182888),
                     vm.Point3D(6.3709537664800004, 1.8393735549299999, -0.8194635977929999),
                     vm.Point3D(6.374139441770001, 1.82379086893, -0.863747143938),
                     vm.Point3D(6.3774929473599995, 1.80737862662, -0.9072127016870001),
                     vm.Point3D(6.37857202372, 1.80209675719, -0.9209026966139999),
                     vm.Point3D(6.38035583126, 1.79336409979, -0.943070656469),
                     vm.Point3D(6.3821822915, 1.78442061741, -0.96503073124),
                     vm.Point3D(6.38289361776, 1.7809372311, -0.973476552404),
                     vm.Point3D(6.384513456810001, 1.77300414813, -0.9924601113229999),
                     vm.Point3D(6.3861695292, 1.76489197001, -1.0112670725200001),
                     vm.Point3D(6.3871041472200005, 1.76031323969, -1.02167757595),
                     vm.Point3D(6.38995074115, 1.74636591589, -1.0527457179800002),
                     vm.Point3D(6.39291273098, 1.73184820996, -1.08325143168),
                     vm.Point3D(6.39493884248, 1.72191546386, -1.10335278461),
                     vm.Point3D(6.41168154271, 1.63982053838, -1.26359712258),
                     vm.Point3D(6.43156948447, 1.54217922501, -1.4085118622600001),
                     vm.Point3D(6.45110516992, 1.44619707949, -1.52516704326),
                     vm.Point3D(6.48098637721, 1.29930076179, -1.67256642132),
                     vm.Point3D(6.514977428660001, 1.13209019132, -1.79993482256),
                     vm.Point3D(6.52471336107, 1.0841891148, -1.83365009855),
                     vm.Point3D(6.54237319047, 0.99728902404, -1.88997651819),
                     vm.Point3D(6.5610947991, 0.905140741155, -1.94112793012),
                     vm.Point3D(6.56934796395, 0.864514212456, -1.96213425448),
                     vm.Point3D(6.590884930750001, 0.758486784047, -2.01297906468),
                     vm.Point3D(6.613859806180001, 0.6453520205690001, -2.05681564941),
                     vm.Point3D(6.62837749136, 0.5738522482549999, -2.08064030954),
                     vm.Point3D(6.65729857934, 0.43139388879199997, -2.1201825951199997),
                     vm.Point3D(6.6889062916399995, 0.275656007445, -2.14663053763),
                     vm.Point3D(6.70463121292, 0.19816538181, -2.15590721184),
                     vm.Point3D(6.721134155640001, 0.11682912999299999, -2.16139188593),
                     vm.Point3D(6.73841314203, 0.0316570278057, -2.1630941994),
                     vm.Point3D(6.36189392039, 1.9668606149899999, 0.210600770903),
                     vm.Point3D(6.36053373088, 1.97382180868, 0.116935570876),
                     vm.Point3D(6.35988553895, 1.9772637207600001, 0.0267405771636),
                     vm.Point3D(6.36011421369, 1.9763714317399999, -0.0591806545411),
                     vm.Point3D(6.36134169758, 1.9706392366899999, -0.17571781130900002),
                     vm.Point3D(6.363749234879999, 1.95907424062, -0.286503503668),
                     vm.Point3D(6.364538341149999, 1.95527085982, -0.318141499925),
                     vm.Point3D(6.36698074079, 1.94346813407, -0.404837756152),
                     vm.Point3D(6.37007761057, 1.92843047503, -0.488344189243),
                     vm.Point3D(6.37230916764, 1.9175728720499998, -0.540584048712),
                     vm.Point3D(6.37558893322, 1.90159146144, -0.60867093825),
                     vm.Point3D(6.37925814869, 1.88368506699, -0.674859687241),
                     vm.Point3D(6.38019637549, 1.8791048799899999, -0.691242757312),
                     vm.Point3D(6.38303259309, 1.8652549905400002, -0.739236114145),
                     vm.Point3D(6.386067429470001, 1.85042336261, -0.786261422549),
                     vm.Point3D(6.38815716165, 1.84020591548, -0.816937180645),
                     vm.Point3D(6.39133466788, 1.82466360779, -0.8612605420370001),
                     vm.Point3D(6.39467933295, 1.80829506266, -0.904769187622),
                     vm.Point3D(6.39575550329, 1.8030275571899999, -0.9184733462100001),
                     vm.Point3D(6.3975344089199995, 1.79431912904, -0.940665197446),
                     vm.Point3D(6.39935626002, 1.78539842889, -0.962647736751),
                     vm.Point3D(6.40006574555, 1.78192414095, -0.9711025294129999),
                     vm.Point3D(6.40168224471, 1.7740075665100001, -0.9901023666500001),
                     vm.Point3D(6.40333540505, 1.76590978212, -1.00892352086),
                     vm.Point3D(6.4042679243, 1.76134142567, -1.0193442535000001),
                     vm.Point3D(6.407106949209999, 1.74743151422, -1.0504492861799999),
                     vm.Point3D(6.41006113082, 1.73295240299, -1.08099305639),
                     vm.Point3D(6.41208263392, 1.72304243544, -1.10111687022),
                     vm.Point3D(6.42878910623, 1.6411265783, -1.26153777949),
                     vm.Point3D(6.44864864217, 1.54362567003, -1.40659096636),
                     vm.Point3D(6.46815463607, 1.44779028477, -1.52339086111),
                     vm.Point3D(6.497997616509999, 1.30108291577, -1.67097655303),
                     vm.Point3D(6.53194844949, 1.13407113832, -1.7985409751800001),
                     vm.Point3D(6.54167322523, 1.08622520729, -1.83231062767),
                     vm.Point3D(6.5593132785799995, 0.99942286609, -1.8887334337800001),
                     vm.Point3D(6.57801473008, 0.9073742164640001, -1.9399830896099999),
                     vm.Point3D(6.58625923471, 0.866790493765, -1.96103162306),
                     vm.Point3D(6.6077737167, 0.7608742038640001, -2.01198602198),
                     vm.Point3D(6.63072560527, 0.647853060501, -2.05593464243),
                     vm.Point3D(6.6452287958500005, 0.576424932492, -2.0798299478),
                     vm.Point3D(6.67412289016, 0.434099998081, -2.1195037978599998),
                     vm.Point3D(6.705699559859999, 0.278515555014, -2.146103039),
                     vm.Point3D(6.72140853516, 0.201103747579, -2.15545743232),
                     vm.Point3D(6.73789097817, 0.11986882230700001, -2.16104201999),
                     vm.Point3D(6.75514874093, 0.0348016248801, -2.16284777535),
                     vm.Point3D(6.37933396005, 1.96652328257, 0.214280570015),
                     vm.Point3D(6.37794334145, 1.97363488199, 0.120467061621),
                     vm.Point3D(6.3772679517699995, 1.97721122786, 0.0301395087539),
                     vm.Point3D(6.37747375664, 1.97643198072, -0.055893188496900004),
                     vm.Point3D(6.37867671027, 1.97082103451, -0.172549903329),
                     vm.Point3D(6.38105883101, 1.95938166811, -0.283459473483),
                     vm.Point3D(6.3818414924199995, 1.9556101431500001, -0.315128881369),
                     vm.Point3D(6.384264970379999, 1.94390094403, -0.401917360025),
                     vm.Point3D(6.38734499172, 1.9289465639099999, -0.485505910742),
                     vm.Point3D(6.38956569905, 1.91814258938, -0.5377986508220001),
                     vm.Point3D(6.39283231552, 1.90222617249, -0.605949627758),
                     vm.Point3D(6.39648881897, 1.8843826114000002, -0.672200333923),
                     vm.Point3D(6.397423975020001, 1.8798176026000002, -0.688598370534),
                     vm.Point3D(6.40025118966, 1.86601221319, -0.736635606869),
                     vm.Point3D(6.40327732751, 1.85122358065, -0.783703311101),
                     vm.Point3D(6.40536141174, 1.84103405035, -0.81440659674),
                     vm.Point3D(6.40853053875, 1.82553315966, -0.858770797594),
                     vm.Point3D(6.41186635735, 1.80920834115, -0.902322560034),
                     vm.Point3D(6.41293967439, 1.80395493904, -0.916040625317),
                     vm.Point3D(6.41471387704, 1.79526975692, -0.938255398427),
                     vm.Point3D(6.41653128606, 1.78637101319, -0.960259587972),
                     vm.Point3D(6.417239389600001, 1.78290355619, -0.968721116322),
                     vm.Point3D(6.4188522382999995, 1.77500502532, -0.98773874552),
                     vm.Point3D(6.4205016398799994, 1.76692581988, -1.0065782196),
                     vm.Point3D(6.42143214344, 1.76236742664, -1.01700877652),
                     vm.Point3D(6.4242642521099995, 1.74849170094, -1.04814751823),
                     vm.Point3D(6.4272108971, 1.73404984195, -1.07872802122),
                     vm.Point3D(6.42922763485, 1.7241634286599998, -1.09887506085),
                     vm.Point3D(6.44589727126, 1.64242964508, -1.25947550472),
                     vm.Point3D(6.465728240250001, 1.54506993835, -1.40466792411),
                     vm.Point3D(6.48520420724, 1.4493829709100001, -1.52161416704),
                     vm.Point3D(6.51500870897, 1.30286579558, -1.66938740044),
                     vm.Point3D(6.54891925722, 1.13605313861, -1.79714816639),
                     vm.Point3D(6.55863289576, 1.08826225683, -1.8309721005),
                     vm.Point3D(6.57625316811, 1.00155768972, -1.8874913172599999),
                     vm.Point3D(6.59493463433, 0.909607823872, -1.9388383793600001),
                     vm.Point3D(6.60317046819, 0.869066959334, -1.95992917333),
                     vm.Point3D(6.62466271563, 0.763260571006, -2.01099194127),
                     vm.Point3D(6.647591783279999, 0.650352227507, -2.0550517886299997),
                     vm.Point3D(6.6620807620899996, 0.578994345832, -2.07901636078),
                     vm.Point3D(6.69094802794, 0.436802019899, -2.1188209701300003),
                     vm.Point3D(6.72249388266, 0.281369889946, -2.14557040043),
                     vm.Point3D(6.7381867602100005, 0.204037650933, -2.1550032526),
                     vm.Point3D(6.75464911123, 0.12290203694, -2.16068576669),
                     vm.Point3D(6.7718857023700005, 0.0379394871765, -2.16259471043),
                     vm.Point3D(6.39677946698, 1.96615892638, 0.217987016071),
                     vm.Point3D(6.39535881388, 1.97341898115, 0.124027122484),
                     vm.Point3D(6.39465643295, 1.9771287401500002, 0.033568016884400004),
                     vm.Point3D(6.39483829918, 1.97646781754, -0.0525813549004),
                     vm.Point3D(6.39601566634, 1.97098334088, -0.1693627757),
                     vm.Point3D(6.3983718644600005, 1.9596721055400002, -0.28039869016900004),
                     vm.Point3D(6.39914767474, 1.95593444452, -0.31210148977),
                     vm.Point3D(6.40155178856, 1.94432095904, -0.39898434737399996),
                     vm.Point3D(6.404614280120001, 1.9294532255799999, -0.482658336479),
                     vm.Point3D(6.40682400824, 1.91870351936, -0.535004588118),
                     vm.Point3D(6.41007705287, 1.90285418582, -0.6032217129499999),
                     vm.Point3D(6.41372069373, 1.88507420224, -0.6695351100479999),
                     vm.Point3D(6.41465270446, 1.8805247402, -0.685948476628),
                     vm.Point3D(6.41747078463, 1.86676450097, -0.734030233541),
                     vm.Point3D(6.42048810529, 1.85201945023, -0.781140911844),
                     vm.Point3D(6.42256648127, 1.84185813486, -0.811872018956),
                     vm.Point3D(6.42572710157, 1.82639929139, -0.856277680694),
                     vm.Point3D(6.42905407999, 1.8101181683299998, -0.8998725292640001),
                     vm.Point3D(6.43012456784, 1.8048787504100001, -0.913604383733),
                     vm.Point3D(6.43189416062, 1.79621635412, -0.93584162493),
                     vm.Point3D(6.43370729793, 1.7873387246899999, -0.9578666343469999),
                     vm.Point3D(6.434413741579999, 1.78387947227, -0.966336252864),
                     vm.Point3D(6.4360230859200005, 1.77599826284, -0.985370961962),
                     vm.Point3D(6.43766889395, 1.76793681967, -1.00422795062),
                     vm.Point3D(6.43859724983, 1.76338904205, -1.01466897512),
                     vm.Point3D(6.4414226477800005, 1.74954648632, -1.04584042428),
                     vm.Point3D(6.44436185481, 1.7351413918799998, -1.07645717913),
                     vm.Point3D(6.4463738283900005, 1.7252785271, -1.09662743889),
                     vm.Point3D(6.463006062180001, 1.64372961817, -1.2574101793899999),
                     vm.Point3D(6.4828082613, 1.54651211597, -1.40274282031),
                     vm.Point3D(6.5022538907400005, 1.45097510184, -1.5198369255),
                     vm.Point3D(6.53201963122, 1.3046495167099998, -1.66779907744),
                     vm.Point3D(6.56588985198, 1.1380361915700001, -1.79575639561),
                     vm.Point3D(6.57559235062, 1.09030037242, -1.8296346245100001),
                     vm.Point3D(6.59319288793, 1.00369335219, -1.8862500278899998),
                     vm.Point3D(6.611854473489999, 0.911841753029, -1.93769398638),
                     vm.Point3D(6.62008169682, 0.8713434488340001, -1.9588267472),
                     vm.Point3D(6.64155188094, 0.765646115714, -2.00999704961),
                     vm.Point3D(6.66445838511, 0.652849299621, -2.05416686915),
                     vm.Point3D(6.67893333779, 0.581560746704, -2.07819980329),
                     vm.Point3D(6.70777407142, 0.439499564963, -2.11813372807),
                     vm.Point3D(6.73928917812, 0.28421941721399996, -2.14503302123),
                     vm.Point3D(6.75496607208, 0.206966182322, -2.1545437758399997),
                     vm.Point3D(6.77140842161, 0.12592943224, -2.1603237752099997),
                     vm.Point3D(6.78862405678, 0.0410704642475, -2.1623348562999998)]
                


# %%% Bspline-surface parameters 

degree_u, degree_v, nb_u, nb_v = 5, 5, 24, 45

u_knots = [0.0, 0.126199505044518, 0.33653201345123473, 0.5832766092786071, 
           0.8330000042927476, 0.944389000712475, 0.9811193044589769, 1.0]

v_knots = [0.0, 0.10143712492393875, 0.14279250386240222, 0.21635226998191412,
           0.24077562803610145, 0.2883975768139987, 0.3104823269608461,
           0.32436622394861875, 0.3418082667619294, 0.3767447302199956,
           0.6236719791688692, 0.7182695556983949, 0.7896326418305322,
           0.8998651352044769, 0.9999999999999999]


u_multiplicities = [6, 3, 3, 3, 3, 3, 3, 6]

v_multiplicities =  [6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 6]


# %%% Bspline-surface definition (2)

bspline_surface_2 = volmdlr.faces.BSplineSurface3D(degree_u = degree_u,
                                                   degree_v = degree_v,
                                                   control_points = control_points,
                                                   nb_u = nb_u, 
                                                   nb_v = nb_v,
                                                   u_multiplicities = u_multiplicities, 
                                                   v_multiplicities = v_multiplicities, 
                                                   u_knots = u_knots,
                                                   v_knots = v_knots)

#bsplinesurface to check volume
control_points = [[[0, 0, 0], [1, 0, 0], [2, 0, 0]],
                  [[0, 1, 0], [1, 1, 1], [2, 1, 0]],
                  [[0, 2, 0], [1, 2, 0], [2, 2, 0]]]
knots_u = [0, 0, 0, 1, 1, 1]
knots_v = [0, 0, 0, 1, 1, 1]

# Create the B-spline surface
surface = BSpline.Surface()
surface.degree_u = 2
surface.degree_v = 2
surface.ctrlpts2d = control_points
surface.knotvector_u = knots_u
surface.knotvector_v = knots_v

bspline_surface_3 = volmdlr.faces.BSplineSurface3D.from_geomdl_surface(surface)
