# Vtex Auth
APP_KEY_HEADER = "X-VTEX-API-AppKey"
APP_TOKEN_HEADER = "X-VTEX-API-AppToken"  # noqa: S105

# Configs
ACCOUNT_NAME_ENV_VAR = "VTEX_ACCOUNT_NAME"
APP_KEY_ENV_VAR = "VTEX_APP_KEY"
APP_TOKEN_ENV_VAR = "VTEX_APP_TOKEN"  # noqa: S105
TIMEOUT_ENV_VAR = "VTEX_TIMEOUT"
RETRY_ATTEMPTS_ENV_VAR = "VTEX_RETRY_ATTEMPTS"
RETRY_BACKOFF_MIN_ENV_VAR = "VTEX_RETRY_BACKOFF_MIN"
RETRY_BACKOFF_MAX_ENV_VAR = "VTEX_RETRY_BACKOFF_MAX"
RETRY_BACKOFF_EXPONENTIAL_ENV_VAR = "VTEX_RETRY_BACKOFF_EXPONENTIAL"
RETRY_STATUSES_ENV_VAR = "VTEX_RETRY_STATUSES"
RETRY_LOGS_ENV_VAR = "VTEX_RETRY_LOGS"
RAISE_FOR_STATUS_ENV_VAR = "VTEX_RAISE_FOR_STATUS"

DEFAULT_TIMEOUT = 10
DEFAULT_RETRY_ATTEMPTS = 5
DEFAULT_RETRY_BACKOFF_MIN = 1.0
DEFAULT_RETRY_BACKOFF_MAX = 64.0
DEFAULT_RETRY_BACKOFF_EXPONENTIAL = 2.0
DEFAULT_RETRY_STATUSES = {
    401,
    407,
    408,
    409,
    425,
    429,
    500,
    502,
    503,
    504,
    507,
    511,
    525,
}
DEFAULT_RETRY_LOGS = True
DEFAULT_RAISE_FOR_STATUS = True

# Generics
MIN_PAGE_SIZE = 1

# Catalog
LIST_SKU_IDS_START_PAGE = 1
LIST_SKU_IDS_MAX_PAGE_SIZE = 1_000

LIST_CATEGORIES_START_PAGE = 1
LIST_CATEGORIES_MAX_PAGE_SIZE = 50

GET_CATEGORY_TREE_MAX_LEVELS = 1_000_000

# Logistics
LIST_CARRIERS_START_PAGE = 1
LIST_CARRIERS_MAX_PAGE_SIZE = 1_000

LIST_DOCKS_START_PAGE = 1
LIST_DOCKS_MAX_PAGE_SIZE = 1_000

LIST_SHIPPING_POLICIES_START_PAGE = 1
LIST_SHIPPING_POLICIES_MAX_PAGE_SIZE = 1_000

# Master Data
SEARCH_DOCUMENTS_START_PAGE = 1
SEARCH_DOCUMENTS_MAX_PAGE_SIZE = 100

# Orders
LIST_FEED_ORDERS_MAX_PAGE_SIZE = 10
LIST_ORDERS_START_PAGE = 1
LIST_ORDERS_MAX_PAGE = 30
LIST_ORDERS_MAX_PAGE_SIZE = 100

# Transactions
LIST_TRANSACTION_INTERACTIONS_RETRIES = 10
