class ConfigurationError(Exception):
    """
    Error setting up an object due to incorrect configuration
    """
    pass


class SubscriptionError(Exception):
    """
    Error subscribing to a stream that is not available
    """
    pass


class ConnectionError(Exception):
    """
    Error connecting to a Joule server
    """
    pass


class DataError(Exception):
    """
    Error generated by backend storage (timescale)
    """
    pass


class DecimationError(DataError):
    """
    Requested data is not sufficiently decimated
    """
    pass


class ApiError(Exception):
    """
    Error generated by an API call. Catches all API related errors.
    """
    pass

class InvalidDataStreamParameter(ApiError):
    """
    Passing an invalid datatype to an API function that expects a DataStream
    """
    def __init__(self):
        message = "Invalid stream datatype. Must be DataStream, Path, or ID"
        super().__init__(message)

class InvalidEventStreamParameter(ApiError):
    """
    Passing an invalid datatype to an API function that expects an EventStream
    """
    def __init__(self):
        message = "Invalid stream datatype. Must be EventStream, Path, or ID"
        super().__init__(message)

class StreamNotFound(ApiError):
    """
    Type of APIError. Requested stream does not exist
    """
    pass

class PipeError(Exception):
    """
    Error reading from or writing to a pipe
    """
    pass

class EmptyPipeError(PipeError):
    """
    Attempt to read from an empty pipe
    """
    pass
