#used some code from the WxPython wiki:
#https://wiki.wxpython.org/DragAndDropWithFolderMovingAndRearranging
#-1.4 Recursively building a list into a wxTreeCtrl (yet another sample) by Rob
#-1.5 Simple Drag and Drop by Titus
#-TraversingwxTree

#tested on wxPython 2.5.4 and Python 2.4, under Windows and Linux

import  wx
try:
    from wx.gizmos import TreeListCtrl # Version 3
except ImportError:
    from wx.dataview import TreeListCtrl # Version 4
    
import SpecViewLite_build2 as svl
#import RICviewLite as rvl
import RICviewLite_multi as rvl_multi
import mzStudio
#import mz_workbench.protein_core as protein_core
import cPickle, re
import subprocess
import BlaisPepCalcSlim_aui2
#import wx.lib.agw.hypertreelist as HTL
#import wx.lib.mixins.listctrl  as  listmix
#import wx.lib.agw.hypertreelist as HTL
#---------------------------------------------------------------------------

PPT_COM = None
EXL_COM = None

class MyTreeCtrl(TreeListCtrl):#wx.TreeCtrl  #, listmix.TextEditMixin
#class MyTreeCtrl(HTL.HyperTreeList):
    def __init__(self, parent, id, pos, size, style, log):
        self.idextract = re.compile('.*? at ([a-z0-9]+?)> ')
        print '-------'
        print pos
        #wx.TreeCtrl.__init__(self, parent, id, pos, size, style)
        TreeListCtrl.__init__(self, parent, id, pos, size, style=style)
        #HTL.HyperTreeList.__init__(self,parent,id, pos,size,style=style)
        
        self.log = log
        self.Bind(wx.EVT_RIGHT_DCLICK, self.OnRightDC)
        #------------NEEDED TREELISTCTRL
        #listmix.TextEditMixin.__init__(self)
        self.node_dict = {}

    def OnRightDC(self, evt):
        print "Captured"
        evt.Skip()        

    def Traverse(self, func, startNode):
        """Apply 'func' to each node in a branch, beginning with 'startNode'. """
        def TraverseAux(node, depth, func):
            nc = self.GetChildrenCount(node, 0)
            child, cookie = self.GetFirstChild(node)
            # In wxPython 2.5.4, GetFirstChild only takes 1 argument
            for i in xrange(nc):
                func(child, depth)
                TraverseAux(child, depth + 1, func)
                child, cookie = self.GetNextChild(node, cookie)
        func(startNode, 0)
        TraverseAux(startNode, 1, func)

    def ItemIsChildOf(self, item1, item2):
        ''' Tests if item1 is a child of item2, using the Traverse function '''
        self.result = False
        def test_func(node, depth):
            if node == item1:
                self.result = True

        self.Traverse(test_func, item2)
        return self.result

    def SaveItemsToList(self, startnode):
        ''' Generates a python object representation of the tree (or a branch of it),
            composed of a list of dictionaries with the following key/values:
            label:      the text that the tree item had
            data:       the node's data, returned from GetItemPyData(node)
            children:   a list containing the node's children (one of these dictionaries for each)
        '''
        global list
        list = []
        #print startnode
        def save_func(node, depth):
            tmplist = list
            for x in range(depth):
                if type(tmplist[-1]) is not dict:
                    tmplist.append({})
                tmplist = tmplist[-1].setdefault('children', [])

            item = {}
            item['label'] = self.GetItemText(node)
            item['data'] = self.GetItemPyData(node)
            item['icon-normal'] = self.GetItemImage(node, wx.TreeItemIcon_Normal)
            item['icon-selected'] = self.IsSelected(node) #self.GetItemImage(node, wx.TreeItemIcon_Selected)
            item['icon-expanded'] = self.IsExpanded(node)   #self.GetItemImage(node, wx.TreeItemIcon_Expanded)
            item['icon-selectedexpanded'] = self.GetItemImage(node, wx.TreeItemIcon_SelectedExpanded)
            item['columnLabel'] = self.GetItemText(node, 1)
            #nodeid = self.idextract.match(str(node)).groups()[0]
            #item['node']=nodeid
            #item[''] = self.GetItemText(node, 1)

            tmplist.append(item)

        self.Traverse(save_func, startnode)
        #print list
        return list       

    def InsertItemsFromList(self, itemlist, parent, insertafter=None, appendafter=False):
        ''' Takes a list, 'itemslist', generated by SaveItemsToList, and inserts
            it in to the tree. The items are inserted as children of the
            treeitem given by 'parent', and if 'insertafter' is specified, they
            are inserted directly after that treeitem. Otherwise, they are put at
            the beginning.
            
            If 'appendafter' is True, each item is appended. Otherwise it is prepended.
            In the case of children, you want to append them to keep them in the same order.
            However, to put an item at the start of a branch that has children, you need to
            use prepend. (This will need modification for multiple inserts. Probably reverse
            the list.)

            Returns a list of the newly inserted treeitems, so they can be
            selected, etc..
            
            Made changes to original code.  2017-06-11.  Could not get this function to rebuilt entire list after deleting all nodes.
            Says needs parent.  However, when you delete all items, then add a root, then call this with the entire list, you end up
            with 2 root nodes!  Added logic such that if it is on the root node from the list (item['data']['type'] != 'root') it will not add
            it (it is already there).  Also, keeps track of expandednotes so you can also regenerate expansion state.
            
            2017-06-13 Added self.node_dict which maps "memory location" (a unique identifier) to the node so it can be looked up later.
            Why not just store the node itself?  Can't pickle the wx.TreeId SWIG object.  So if the node is added directly to the PyData,
            save and load will not work.
            
            '''
        newitems = []
        self.node_dict = {}
        
        for item in itemlist:
            if item['data']['type'] != 'root':
                if insertafter:
                    node = self.InsertItem(parent, insertafter, item['label'])
                elif appendafter:
                    node = self.AppendItem(parent, item['label'])
                else:
                    node = self.PrependItem(parent, item['label'])
                    
                self.SetItemPyData(node, item['data'])
                
                #self.node_dict[self.idextract.match(str(node)).groups()[0]] = node
                self.node_dict[item['label']] = node
                
                if item['data']['type'] == 'auxfile':
                    icon = -1
                    if item['data']['full_path'].find(".py") > -1:
                        icon = 6
                    if item['data']['full_path'].find(".ppt") > -1:
                        icon = 5
                    if item['data']['full_path'].find(".xls") > -1:
                        icon = 4
                    
                    self.SetItemImage(node, icon, wx.TreeItemIcon_Normal)
                    #self.SetItemImage(node, icon, wx.TreeItemIcon_Selected)
                    #self.SetItemImage(node, icon, wx.TreeItemIcon_Expanded)
                    #self.SetItemImage(node, icon, wx.TreeItemIcon_SelectedExpanded)
                
                    self.SetItemText(node, item['data']['exp'], 1)
                
                if item['data']['type'] == 'container':
                    icon = 0
                    self.SetItemImage(node, icon, wx.TreeItemIcon_Normal)
                    #icon = 2
                    #self.SetItemImage(node, icon, wx.TreeItemIcon_Selected)                    
                
                if item['data']['type'] == 'specfile':
                    icon = 3
                    
                    self.SetItemImage(node, icon, wx.TreeItemIcon_Normal)
                    #self.SetItemImage(node, icon, wx.TreeItemIcon_Selected)
                
                    self.SetItemText(node, item['data']['exp'], 1)  
                    
                if item['data']['type'] == 'XIC':
                    icon = 7
                    
                    self.SetItemImage(node, icon, wx.TreeItemIcon_Normal)
                    #self.SetItemImage(node, icon, wx.TreeItemIcon_Selected)
                
                    self.SetItemText(node, item['data']['exp'], 1)                  
                
                newitems.append(node)
                #print self.GetItemText(node)
                #print item['icon-expanded']
                
                if item['icon-expanded']:
                    self.expanditems.append(node)
                if item['icon-selected']:
                    self.selected = node
                    
            if 'children' in item:
                if item['data']['type'] != 'root':
                    self.InsertItemsFromList(item['children'], node, appendafter=True)
                                       
                else:
                    self.InsertItemsFromList(item['children'], self.GetRootItem(), appendafter=True)
                    if item['icon-expanded']:
                        self.Expand(self.GetRootItem())                    
        
        return newitems

def OnCompareItems(self, item1, item2):
        t1 = self.GetItemText(item1)
        t2 = self.GetItemText(item2)
        self.log.WriteText('compare: ' + t1 + ' <> ' + t2 + '\n')
        if t1 < t2: return -1
        if t1 == t2: return 0
        return 1


#---------------------------------------------------------------------------
#TestTreeCtrlPanel = Panel; self.tree = MyTreeCtrl
class TestTreeCtrlPanel(wx.Panel):
    def __init__(self, parent, log, parentframe=None, pos=wx.DefaultPosition):
        # Use the WANTS_CHARS style so the panel doesn't eat the Return key.
        wx.Panel.__init__(self, parent, -1, style=wx.WANTS_CHARS, pos=pos) #|wx.TR_EDIT_LABELS
        self.Bind(wx.EVT_SIZE, self.OnSize)

        self.log = log
        tID = wx.NewId()

        self.tree = MyTreeCtrl(self, tID, pos, wx.DefaultSize,
                                    wx.TR_HAS_BUTTONS | wx.TR_EDIT_LABELS, self.log)
        # Example needs some more work to use wx.TR_MULTIPLE

        isize = (16,16)
        il = wx.ImageList(isize[0], isize[1])
        fldridx   = il.Add(wx.ArtProvider.GetBitmap(wx.ART_FOLDER,  wx.ART_OTHER, isize))
        fldropenidx = il.Add(wx.ArtProvider.GetBitmap(wx.ART_FILE_OPEN, wx.ART_OTHER,isize))
        fileidx   = il.Add(wx.ArtProvider.GetBitmap(wx.ART_REPORT_VIEW, wx.ART_OTHER,isize))

        self.tree.SetImageList(il)
        self.il = il

        self.tree.AddColumn("Infobar")
        self.tree.AddColumn("Title")
        
        self.tree.SetMainColumn(0) # the one with the tree in it...
        self.tree.SetColumnWidth(0, 250)
        self.tree.SetColumnWidth(1, 250)


        self.root = self.tree.AddRoot("The Root Item")
        self.root = self.tree.GetRootItem()
        self.tree.SetPyData(self.root, {"type":"root"})
        self.tree.SetItemImage(self.root, fldridx, wx.TreeItemIcon_Normal)
        self.tree.SetItemImage(self.root, fldropenidx, wx.TreeItemIcon_Expanded)
        self.tree.SetItemText(self.root, "Sequence", 1)
        
        self.tree.GetMainWindow().Bind(wx.EVT_CONTEXT_MENU, self.OnContextMenu)
        self.tree.Bind(wx.EVT_CONTEXT_MENU, self.OnContextMenu)
        
        self.tree.GetMainWindow().Bind(wx.EVT_RIGHT_DOWN, self.OnRightDown)
        
        self.tree.Bind(wx.EVT_RIGHT_DOWN, self.OnRightDown)
        self.tree.Bind(wx.EVT_TREE_ITEM_ACTIVATED, self.OnActivate)
        self.tree.Bind(wx.EVT_TREE_ITEM_RIGHT_CLICK, self.OnContextMenu)
        #self.tree.Bind(wx.EVT_TREE_BEGIN_LABEL_EDIT, self.OnLabelEdit)
        self.tree.Bind(wx.EVT_LEFT_DCLICK, self.OnLeftDClick)
        self.tree.Bind(wx.EVT_RIGHT_DOWN, self.OnRightDown)
        self.tree.Bind(wx.EVT_TREE_END_LABEL_EDIT, self.OnLabelEndEdit)
        self.tree.Bind(wx.EVT_TREE_BEGIN_RDRAG, self.OnBeginRightDrag)
        self.tree.Bind(wx.EVT_TREE_BEGIN_DRAG, self.OnBeginLeftDrag)
        self.tree.Bind(wx.EVT_TREE_END_DRAG, self.OnEndDrag)
        self.parent = parentframe
        self.column_edit = None
        self.column_text = None
    #def OnLabelEdit(self, evt):
    #    print "LAbel edit"
            
    def get_tree_item_from_folder_name(self,searchFolder):
        item = None
        if searchFolder in self.tree.node_dict.keys():
            item = self.tree.node_dict[searchFolder]
        return item

    def scan_for_folders(self, member, folder_names):
        if member['data']['type']=='container':
            folder_names.append(member['label'])
        if 'children' in member.keys():
            if member['children']:
                for child in member['children']:
                    self.scan_for_folders(child, folder_names) 
    
    def scan_for_dataItems(self, member, data_items):
        if member['data']['type'] == 'specfile':
            data_items.append(('specfile', member['data']['spectrum_data'], member))
        if member['data']['type'] == 'XIC':
            data_items.append(('XIC', member['data']['xic_data']))        
        if 'children' in member.keys():
            if member['children']:
                for child in member['children']:
                    self.scan_for_dataItems(child, data_items)         
    
    def get_data_items(self):
        data = self.tree.SaveItemsToList(self.tree.GetRootItem())
        
        data_items = []
        
        for member in data:
            self.scan_for_dataItems(member, data_items)
            
        return data_items
    
    def get_folders(self):
        data = self.tree.SaveItemsToList(self.tree.GetRootItem())
        
        folder_names = []
        
        for member in data:
            self.scan_for_folders(member, folder_names)
        
        return folder_names    
    
    def OnContextMenu(self, event):
        print "CONTEXT"
        if not hasattr(self, "popupID1"):
            print "making..."
            self.popupID1 = wx.NewId()
            self.popupID2 = wx.NewId()
            self.popupID3 = wx.NewId()
            self.popupID4 = wx.NewId()
            self.Bind(wx.EVT_MENU, self.OnPopupOne_evt, id=self.popupID1)
            self.Bind(wx.EVT_MENU, self.OnPopupTwo_evt, id=self.popupID2)
            self.Bind(wx.EVT_MENU, self.OnPopupThree_evt, id=self.popupID3)
            self.Bind(wx.EVT_MENU, self.OnPopupFour_evt, id=self.popupID4)

        # make a menu
        menu = wx.Menu()
        # Show how to put an icon in the menu
        item = wx.MenuItem(menu, self.popupID1,"Sequence-->BPC")
        item2 = wx.MenuItem(menu, self.popupID2,"Sequence-->Clipboard")
        item3 = wx.MenuItem(menu, self.popupID3,"Edit Info Bar")
        item4 = wx.MenuItem(menu, self.popupID4,"Edit Title Bar")
        #bmp = images.Smiles.GetBitmap()
        #item.SetBitmap(bmp)
        menu.AppendItem(item)
        menu.AppendItem(item2)
        menu.AppendItem(item3)
        menu.AppendItem(item4)
        # add some other items
        
        # Popup the menu.  If an item is selected then its handler
        # will be called before PopupMenu returns.
        self.PopupMenu(menu)
        menu.Destroy()
        
    def _OnPopupFour_evt(self, event):
        print "4"
        a = self.tree.SaveItemsToList(self.tree.GetRootItem())
        #r = self.tree.GetRootItem()
        print a
        self.tree.DeleteAllItems()

        isize = (16,16)
        il = wx.ImageList(isize[0], isize[1])
        fldridx   = il.Add(wx.ArtProvider.GetBitmap(wx.ART_FOLDER,  wx.ART_OTHER, isize))
        fldropenidx = il.Add(wx.ArtProvider.GetBitmap(wx.ART_FILE_OPEN, wx.ART_OTHER,isize))
        fileidx   = il.Add(wx.ArtProvider.GetBitmap(wx.ART_REPORT_VIEW, wx.ART_OTHER,isize))

        self.tree.SetImageList(il)
        self.il = il

        self.tree.AddColumn("Peptide Sequences")
        self.tree.AddColumn("Title")
        self.tree.AddColumn("Column 2")
        self.tree.SetMainColumn(0) # the one with the tree in it...
        self.tree.SetColumnWidth(0, 250)
        self.tree.SetColumnWidth(1, 250)        
        
        self.root = self.tree.AddRoot("The Root Item")
        #self.tree.SetPyData(self.root, {"type":"root"})
        self.tree.SetItemImage(self.root, fldridx, wx.TreeItemIcon_Normal)
        self.tree.SetItemImage(self.root, fldropenidx, wx.TreeItemIcon_Expanded)
        self.tree.SetItemText(self.root, "Sequence", 1)      
        self.tree.Expand(self.root)
        self.tree.expanditems = []
        self.tree.selected = None
        #self.tree.first_vis = self.tree.GetFirstVisibleItem()
        #self.sp = self.GetScrollPos(0)
        new_items = self.tree.InsertItemsFromList(a, self.root, insertafter=None, appendafter=False)
        print new_items
        print self.tree.expanditems
        print 
        for member in self.tree.expanditems:
            self.tree.Expand(member)
        if self.tree.selected:
            self.tree.SelectItem(self.tree.selected)
            
        #-------------------Trying to get scroll position to original setting
        #-------------------So far haven't gotten this.
        #self.tree.ScrollTo(self.tree.selected)
        #self.SetScrollPos = self.sp

    def OnPopupOne_evt(self, event):
        if not self.parent.organizer.containsType(BlaisPepCalcSlim_aui2.MainBPC):
            import wx.lib.agw.aui as aui
            bpc = BlaisPepCalcSlim_aui2.MainBPC(self.parent.parent, -1, self.parent.organizer)         
            self.parent.parent._mgr.AddPane(bpc, aui.AuiPaneInfo().Left().MaximizeButton(True).MinimizeButton(True).Caption("PepCalc"))
            self.parent.parent._mgr.Update()            
        else:
            bpc = self.parent.organizer.getObjectOfType(BlaisPepCalcSlim_aui2.MainBPC)
            
        item = self.tree.GetSelection()
        data = self.tree.GetPyData(item)  
        if 'spectrum_data' in data.keys():
            obj = data['spectrum_data']
            current_sequence = obj.sequence
            fixedmod = obj.fixedmod
            varmod = obj.varmod  
            if obj.sequence.find("-") > -1:
                #H-AAVEEGIVLGGGykl-4-126CALLR-OH
                seqstart = obj.sequence.find("-")
                seqend = obj.sequence.rfind("-")
                current_sequence = obj.sequence[seqstart+1:seqend]
                #current_sequence = obj.sequence.split("-")[1]
                if obj.sequence.split("-")[0] != "H":
                    if not fixedmod:
                        fixedmod = "N-term: " + obj.sequence.split("-")[0]
                    else:
                        fixedmod += ", N-term: " + obj.sequence.split("-")[0]
                else:
                    bpc.b.FindWindowByName("nTerm").SetValue("None")
            bpc.b.FindWindowByName("sequence").SetValue(current_sequence)
            mod_dict = {'iTRAQ4plex': 'iTRAQ',
                      'TMT6plex': 'TMT',
                      'iTRAQ8plex': 'iTRAQ8plex',
                      'HGly-HGly': 'HCGlyHCGly',
                      'HCGly-HCGly': 'HCGlyHCGly',
                      'HCGly-HCGly-HCGly-HCGly': 'HCGlyHCGlyHCGlyHCGly',
                      'HNGly-HNGly': 'HNGlyHNGly',
                      'LbA-LbA': 'LbALbA',
                      'Acetyl':'Acetyl'}
            for mod in fixedmod.split(","):
                print mod
                mod = mod.strip()
                if mod.find("N-term") > -1:
                    print "NTERM"
                    mod = mod.split(" ")[1]
                    mod = mod.strip()
                    if mod in mod_dict.keys():
                        bpc.b.FindWindowByName("nTerm").SetValue(mod_dict[mod])
                    print mod_dict[mod]
            bpc.b.OnCalculate(None)
            bpc.b.Refresh()        
        else:
            wx.MessageBox("Not a spectrum entry.")
        
            
    def OnPopupTwo_evt(self, event):
        print "Pop 2"    
        item = self.tree.GetSelection()
        #print event.GetItem()
        #print self.tree.GetItemText(event.GetSelection())
        data = self.tree.GetPyData(item)
        if 'spectrum_data' in data.keys():
            obj = data['spectrum_data']
            if not wx.TheClipboard.IsOpened():
                wx.TheClipboard.Open()
            clipdata = wx.TextDataObject()
            clipdata.SetText(obj.sequence)
            wx.TheClipboard.SetData(clipdata)
            wx.TheClipboard.Close()
        else:
            wx.MessageBox("Not a spectrum object.")
        
    def OnPopupThree_evt(self, event):
        #--------------------------------------------------------NOTE: this just edits the label.
        #-------You have to catch the event, and use event.GetLabel to update the actual object.
        #pos = event.GetPosition()
        #item, flags, col = self.tree.HitTest(pos)
        self.column_edit = 0  # tell the event handler which column
        self.tree.EditLabel(self.tree.GetSelection())
        # Edit Infobar
        # For spectrum, this is the sequence
        
        
    def OnPopupFour_evt(self, event):
        #--------------------------------------------------------NOTE: this just edits the label.
        #-------You have to catch the event, and use event.GetLabel to update the actual object.        
        
        #-----------------Original code.
        #-----------------Problem -- after edit, the Infobar text is changed also to the title bar!!  Strange.
        #-----------------Tried many things, could not fix.
        #-----------------For now, we'll just prompt user with dialog.
        #self.column_edit = 1 # tell the event handler which column.
        #self.column_text = self.tree.GetItemText(self.tree.GetSelection(),0)
        #self.tree.EditLabel(self.tree.GetSelection(), 1)
        item = self.tree.GetSelection()
        dlg = wx.TextEntryDialog(self, 'Enter New Title Bar', 'Edit Title Bar',  defaultValue=self.tree.GetItemText(item, 1))
        
        if dlg.ShowModal() == wx.ID_OK:
            item = self.tree.GetSelection()
            data = self.tree.GetPyData(item)
            data['exp']=dlg.GetValue()
            self.tree.SetItemText(item, dlg.GetValue(), 1)
            
            self.parent.TreeRefresh()            
        dlg.Destroy()        
        
        
    def OnLabelEndEdit(self, event):
        #------------------------------Text is edited, but need to update the object.
        if self.column_edit == 0:
            item = self.tree.GetSelection()
            data = self.tree.GetPyData(item)
            if 'spectrum_data' in data.keys():
                obj = data['spectrum_data']
                obj.sequence = event.GetLabel()  #self.tree.GetItemText(item, 0)
            if 'xic_data' in data.keys():
                obj = data['xic_data']
                obj.title = event.GetLabel()  #self.tree.GetItemText(item, 0)            
            self.parent.TreeRefresh()            
        #--------------------------------For editing Title bar; strange error so this is not used now (see above).
        if self.column_edit == 1:
            item = self.tree.GetSelection()
            data = self.tree.GetPyData(item)
            data['exp']=event.GetLabel() #self.tree.GetItemText(item, 1)
            self.tree.SetItemText(item, self.column_text, 0)
            #self.tree.Refresh()
            self.parent.TreeRefresh()
        event.Skip()
        
        
    def OnEditItem(self, event):
        print "EDIT"
        item=self.tree.GetSelection()
        if item:
            self.tree.EditLabel(item)
        event.Skip()

    def OnActivate(self, event):
        edit = False
        if not edit:
            print self.tree.GetItemText(event.GetItem())
            item = event.GetItem()
            data = self.tree.GetPyData(item)
            #try:
            #    obj = self.tree.GetPyData(item)["obj"]
            #except KeyError:
            #    event.Skip()
            #    return
            if data['type'] == "specfile":
                #print self.tree.GetPyData(item)["scan_data"]
                frame = svl.SpecViewLitePanel(None, data['spectrum_data'])
            if data['type'] == "XIC":
                frame = rvl_multi.RICviewLitePanel(None, data['xic_data'])        
            #if obj.type == "XIC":
            #    frame = rvl.RICviewLitePanel(None, self.tree.GetPyData(item)["obj"])
            #if obj.type == "Protein Coverage Map":
            #    pickle_file = open(obj.filename, "r")
            #    prot = cPickle.load(pickle_file)
            #    pickle_file.close()
            #    frame = protein_core.TextFrame(prot)
            if data['type'] == "auxfile":
                #print obj.filename
                if self.tree.GetItemText(item).lower().endswith(".ppt"):
                    #subprocess.Popen('"C:\Program Files (x86)\Microsoft Office\OFFICE14\POWERPNT.EXE" "' + obj.filename + '"')
                    import win32com.client
                    global PPT_COM
                    if not PPT_COM:
                        PPT_COM = win32com.client.DispatchEx('Powerpoint.Application')
                    PPT_COM.Visible = 1
                    comopen = PPT_COM.Presentations.Open(data['full_path'])
                    del comopen
                elif self.tree.GetItemText(item).lower().endswith(".xls") or self.tree.GetItemText(item).lower().endswith(".xlsx"):
                    #subprocess.Popen('"C:\Program Files (x86)\Microsoft Office\OFFICE14\EXCEL.EXE" "' + obj.filename + '"')
                    import win32com.client
                    global EXL_COM
                    if not EXL_COM:
                        EXL_COM = win32com.client.DispatchEx('Excel.Application')
                    EXL_COM.Visible = 1
                    comopen = EXL_COM.Workbooks.Open(data['full_path'])
                    del comopen
                # The above can sometimes (?) leave instances of Excel and Powerpoint
                # running in the background after the windows are closed, for some 
                # reason.
                elif self.tree.GetItemText(item).lower().endswith(".py"):
                    from customProcessing import ProcessorDialog
                    prodog = ProcessorDialog(self, '')
                    prodog.loadAndCheckFunction(data['full_path'])
                    if prodog.success:
                        self.parent.parent.custom_spectrum_process = prodog.function
                        self.parent.parent.custom_spectrum_process_file = prodog.filename  
                    prodog.Destroy()
                    
                #subprocess.Popen('"' + obj.filename + '"')
            if data['type'] == "Folder":
                subprocess.Popen('explorer "' + obj.folder + '"')
            if data['type'] in ["specfile", "XIC"]:
                frame.Show()
                event.Skip()
            
        else:
            self.tree.EditLabel(self.tree.GetSelection())
            #a = self.tree.GetSelection()
            #self.tree.OpenEditor(0,0)
            
            #self.OpenEditor(col, row)
            #item = event.GetItem() 
            #print "A"

    def OnBeginLeftDrag(self, event):
        '''Allow drag-and-drop for leaf nodes.'''
        print "DRAG"
        #self.log.WriteText("OnBeginDrag")
        event.Allow()
        self.dragType = "left button"
        self.dragItem = event.GetItem()
        event.Skip()

    def OnBeginRightDrag(self, event):
        print "RDRAG"
        '''Allow drag-and-drop for leaf nodes.'''
        self.log.WriteText("OnBeginDrag")
        event.Allow()
        self.dragType = "right button"
        self.dragItem = event.GetItem()
        event.Skip()

    def OnEndDrag(self, event):
        print "OnEndDrag"

        # If we dropped somewhere that isn't on top of an item, ignore the event
        if event.GetItem().IsOk():
            target = event.GetItem()
        else:
            return

        # Make sure this member exists.
        try:
            source = self.dragItem
        except:
            return

        # Prevent the user from dropping an item inside of itself
        if self.tree.ItemIsChildOf(target, source):
            print "the tree item can not be moved in to itself! "
            self.tree.Unselect()
            return

        # Get the target's parent's ID
        targetparent = self.tree.GetItemParent(target)
        if not targetparent.IsOk():
            targetparent = self.tree.GetRootItem()

        # One of the following methods of inserting will be called...   
        def MoveHere(event):
            # Save + delete the source
            save = self.tree.SaveItemsToList(source)
            self.tree.Delete(source)
            newitems = self.tree.InsertItemsFromList(save, targetparent, target)
            #self.tree.UnselectAll()
            for item in newitems:
                self.tree.SelectItem(item)

        def InsertInToThisGroup(event):
            # Save + delete the source
            save = self.tree.SaveItemsToList(source)
            self.tree.Delete(source)
            newitems = self.tree.InsertItemsFromList(save, target)
            #self.tree.UnselectAll()
            for item in newitems:
                self.tree.SelectItem(item)
        #---------------------------------------

        if self.tree.GetPyData(target)["type"] == "container" and self.dragType == "right button":
            menu = wx.Menu()
            menu.Append(101, "Move to after this group", "")
            menu.Append(102, "Insert into this group", "")
            menu.UpdateUI()
            menu.Bind(wx.EVT_MENU, MoveHere, id=101)
            menu.Bind(wx.EVT_MENU, InsertInToThisGroup,id=102)
            self.PopupMenu(menu)
        else:
            #if self.tree.IsExpanded(target):
            InsertInToThisGroup(None)
            #else:
            #    MoveHere(None)
        event.Skip()

    def OnRightUp(self, event):
        pt = event.GetPosition()
        print "ORU"
        #item, flags = self.tree.HitTest(pt)
        #self.log.WriteText("OnRightUp: %s (manually starting label edit)\n" % self.tree.GetItemText(item))
        #self.tree.EditLabel(item)
        event.Skip()

    def OnLeftDown(self, event):
        event.Skip() # Bypassing function entirely.
        print "control key is", event.m_controlDown

        pt = event.GetPosition();
        #item, flags = self.tree.HitTest(pt)
        item = self.tree.HitTest(pt)
        obj, flags = item[0], item[1:]
        #try:
        self.tree.SelectItem(obj)
        #except:
            #pass
        event.Skip()

    def OnRightDown(self, event):
        #pos = event.GetPosition()
        #item, flags, col = self.tree.HitTest(pos)         
        #print "control key is", event.m_controlDown
        #if self.tree.GetRootItem().IsOk():
        #    seq = self.tree.GetItemText(item)
            #print item.GetString()
            #print flags
            #print col
        #except:
        event.Skip()
        #return
        #pt = event.GetPosition();
        #item, flags = self.tree.HitTest(pt)
        #self.tree.SelectItem(item)
        #self.tree.currentSequence = seq
        

    def OnLeftDClick(self, event):
        #pt = event.GetPosition();
        #item, flags, etc = self.tree.HitTest(pt)
        #self.log.WriteText("OnLeftDClick: %s\n" % self.tree.GetItemText(item))

        #expand/collapse toggle
        #self.tree.Toggle(item)
        #print "toggled ", item
        #self.tree.EditLabel()
        event.Skip()

    def OnSize(self, event):
        w,h = self.GetClientSize()
        self.tree.SetDimensions(0, 0, w, h)


#---------------------------------------------------------------------------

class MyLog:
    def __init__(self):
        pass
    def WriteText(self, text):
        print text

class MyFrame(wx.Frame):
    def __init__(self, *args, **kwds):
        wx.Frame.__init__(self, *args, **kwds)
        log = MyLog()
        pnl = TestTreeCtrlPanel(self, log)

class MyApp(wx.App):
    def OnInit(self):
        wx.InitAllImageHandlers()
        frame_1 = MyFrame(None, -1, "")
        self.SetTopWindow(frame_1)
        frame_1.Show(1)
        return 1

# end of class MyApp

if __name__ == "__main__":
    app = MyApp(0)
    app.MainLoop()
