"""This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from typing import Iterable, overload

from zospy.api._ZOSAPI import IOpticalSystem
from zospy.api._ZOSAPI.Common import IMatrixData, IVectorData
from zospy.api._ZOSAPI.SystemData import ISDRayAimingData
from zospy.api._ZOSAPI.Tools import ISystemTool
from zospy.api._ZOSAPI.Tools.FileManager import IFile

__all__ = (
    "ACISExportVersion",
    "ArchiveFileStatus",
    "CADAngularToleranceType",
    "CADFileType",
    "CADToleranceType",
    "DataTypes",
    "EntryCompressionModes",
    "IComputeRMSSpotSize",
    "ICovarianceData",
    "ICreateArchive",
    "ICreateProject",
    "IDataDictionary",
    "IDataEntry",
    "IExportCAD",
    "IHullTools",
    "ILensCatalogLens",
    "ILensCatalogs",
    "IPoint3D",
    "IPointList3D",
    "IPointTools",
    "IQuickAdjust",
    "IQuickFocus",
    "IRayAimingWizard",
    "IRestoreArchive",
    "IRestoreProject",
    "IScale",
    "LensShape",
    "LensType",
    "QuickAdjustCriterion",
    "QuickAdjustType",
    "QuickFocusCriterion",
    "RayPatternType",
    "ScaleToUnits",
    "SplineSegmentsType",
    "ZemaxFileTypes",
)

class ACISExportVersion:
    Current = 0
    V25 = 1
    V26 = 2
    V27 = 3
    V28 = 4
    V29 = 5
    V30 = 6

class ArchiveFileStatus:
    Okay = 0
    InvalidVersion = -3
    InvalidFile = -2
    UnableToOpen = -1

class CADAngularToleranceType:
    Low = 0
    Medium = 1
    High = 2
    Presentation = 3

class CADFileType:
    IGES = 0
    STEP = 1
    SAT = 2
    STL = 3
    SAB = 4
    ASAT = 5
    ASAB = 6
    MODEL = 7
    CATPART = 8
    CATPRODUCT = 9
    XCGM = 10
    ZMO = 11
    XT = 12
    XB = 13
    PRC = 14
    JT = 15
    N3MF = 16
    U3D = 17
    VRML = 18
    OBJ = 19

class CADToleranceType:
    N_TenEMinus4 = 0
    N_TenEMinus5 = 1
    N_TenEMinus6 = 2
    N_TenEMinus7 = 3

class DataTypes:
    NotSet = 0
    Boolean = 1
    Integer = 2
    IntegerArray = 3
    IntegerMatrix = 4
    Float = 5
    FloatArray = 6
    FloatMatrix = 7
    Double = 8
    DoubleArray = 9
    DoubleMatrix = 10
    String = 11
    StringArray = 12
    StringMatrix = 13
    ByteArray = 14
    Dictionary = 15
    Serializable = 16
    File = 17

class EntryCompressionModes:
    Auto = 0
    On = 1
    Off = 2

class IComputeRMSSpotSize(ISystemTool):
    @property
    def UseGaussianQuadrature(self) -> bool: ...
    @property
    def UseRectangularArray(self) -> bool: ...
    @property
    def NumberOfRings(self) -> int: ...
    @property
    def NumberOfArms(self) -> int: ...
    @property
    def ObscuredFration(self) -> float: ...
    @property
    def GridSampling(self) -> int: ...
    @property
    def DeleteVignetted(self) -> bool: ...
    @property
    def AssumeAxialSymmetry(self) -> bool: ...
    @AssumeAxialSymmetry.setter
    def AssumeAxialSymmetry(self, value: bool) -> None: ...
    @property
    def IgnoreLateralColor(self) -> bool: ...
    @IgnoreLateralColor.setter
    def IgnoreLateralColor(self, value: bool) -> None: ...
    @property
    def NumberOfConfigurations(self) -> int: ...
    @property
    def NumberOfFields(self) -> int: ...
    @property
    def RMSSpotRadii(self) -> list[list[float]]: ...
    def GetSpotRadius(self, configuration: int, field: int) -> float: ...
    def SetMethodGaussianQuadrature(self, numberOfRings: int, numberOfArms: int, obscuredFraction: float) -> None: ...
    def SetMethodRectangularArray(self, gridSampling: int, deleteVignetted: bool) -> None: ...

class ICovarianceData:
    @property
    def Cov(self) -> list[list[float]]: ...
    @property
    def V(self) -> list[list[float]]: ...
    @property
    def W(self) -> list[float]: ...
    def GetCovariance(self) -> IMatrixData: ...
    def GetValues(self) -> IVectorData: ...
    def GetVectors(self) -> IMatrixData: ...

class ICreateArchive(ISystemTool):
    @property
    def UseDataCompression(self) -> bool: ...
    @UseDataCompression.setter
    def UseDataCompression(self, value: bool) -> None: ...
    def GetArchiveFileName(self) -> str: ...
    def SetArchiveFileName(self, fullFileName: str) -> bool: ...

class ICreateProject(ISystemTool):
    @property
    def UseDataCompression(self) -> bool: ...
    @UseDataCompression.setter
    def UseDataCompression(self, value: bool) -> None: ...
    def GetArchiveFileName(self) -> str: ...
    def SetArchiveFileName(self, fullFileName: str) -> bool: ...

class IDataDictionary:
    @property
    def FileName(self) -> str: ...
    @property
    def FileType(self) -> ZemaxFileTypes: ...
    @property
    def FileVersion(self) -> int: ...
    @property
    def FileData1(self) -> int: ...
    @property
    def FileData2(self) -> int: ...
    @property
    def Keys(self) -> list[str]: ...
    @property
    def NumberOfEntries(self) -> int: ...
    @property
    def Entries(self) -> list[IDataEntry]: ...
    def Close(self) -> None: ...
    def CreateEntry(self, key: str) -> IDataEntry: ...
    def GetEntry(self, key: str) -> IDataEntry: ...
    def GetKey(self, keyIndex: int) -> str: ...
    def Save(self) -> None: ...

class IDataEntry:
    @property
    def DataType(self) -> DataTypes: ...
    @property
    def IsSet(self) -> bool: ...
    @property
    def Key(self) -> str: ...
    @property
    def CompressionMode(self) -> EntryCompressionModes: ...
    @CompressionMode.setter
    def CompressionMode(self, value: EntryCompressionModes) -> None: ...
    def Delete(self) -> None: ...
    def GetBooleanValue(self) -> bool: ...
    def GetByteArray(self) -> list[int]: ...
    def GetDoubleArray(self) -> list[float]: ...
    def GetDoubleMatrix(self) -> list[list[float]]: ...
    def GetDoubleValue(self) -> float: ...
    def GetFile(self, fileName: str) -> None: ...
    def GetFloatArray(self) -> list[float]: ...
    def GetFloatMatrix(self) -> list[list[float]]: ...
    def GetFloatValue(self) -> float: ...
    def GetIntegerArray(self) -> list[int]: ...
    def GetIntegerMatrix(self) -> list[list[int]]: ...
    def GetIntegerValue(self) -> int: ...
    def GetSerializableValue(self) -> Object: ...
    def GetStringArray(self) -> list[str]: ...
    def GetStringMatrix(self) -> list[list[str]]: ...
    def GetStringValue(self) -> str: ...
    def SetBooleanValue(self, val: bool) -> bool: ...
    def SetByteArray(self, val: list[int]) -> bool: ...
    def SetDoubleArray(self, val: list[float]) -> bool: ...
    def SetDoubleMatrix(self, val: list[list[float]]) -> bool: ...
    def SetDoubleValue(self, val: float) -> bool: ...
    def SetFile(self, fileName: str) -> bool: ...
    def SetFloatArray(self, val: list[float]) -> bool: ...
    def SetFloatMatrix(self, val: list[list[float]]) -> bool: ...
    def SetFloatValue(self, val: float) -> bool: ...
    def SetIntegerArray(self, val: list[int]) -> bool: ...
    def SetIntegerMatrix(self, val: list[list[int]]) -> bool: ...
    def SetIntegerValue(self, val: int) -> bool: ...
    def SetSerializableValue(self, val: Object) -> bool: ...
    def SetStringArray(self, val: list[str]) -> bool: ...
    def SetStringMatrix(self, val: list[list[str]]) -> bool: ...
    def SetStringValue(self, val: str) -> bool: ...

class IExportCAD(ISystemTool):
    @property
    def FirstSurface(self) -> int: ...
    @FirstSurface.setter
    def FirstSurface(self, value: int) -> None: ...
    @property
    def LastSurface(self) -> int: ...
    @LastSurface.setter
    def LastSurface(self, value: int) -> None: ...
    @property
    def CanChangeSurface(self) -> bool: ...
    @property
    def FirstObject(self) -> int: ...
    @FirstObject.setter
    def FirstObject(self, value: int) -> None: ...
    @property
    def LastObject(self) -> int: ...
    @LastObject.setter
    def LastObject(self, value: int) -> None: ...
    @property
    def SequentialSettingsEnabled(self) -> bool: ...
    @property
    def RayPattern(self) -> RayPatternType: ...
    @RayPattern.setter
    def RayPattern(self, value: RayPatternType) -> None: ...
    @property
    def NumberOfRays(self) -> int: ...
    @NumberOfRays.setter
    def NumberOfRays(self, value: int) -> None: ...
    @property
    def Wavelength(self) -> int: ...
    @Wavelength.setter
    def Wavelength(self, value: int) -> None: ...
    @property
    def Field(self) -> int: ...
    @Field.setter
    def Field(self, value: int) -> None: ...
    @property
    def DeleteVignetted(self) -> bool: ...
    @DeleteVignetted.setter
    def DeleteVignetted(self, value: bool) -> None: ...
    @property
    def RayLayer(self) -> int: ...
    @RayLayer.setter
    def RayLayer(self, value: int) -> None: ...
    @property
    def LensLayer(self) -> int: ...
    @LensLayer.setter
    def LensLayer(self, value: int) -> None: ...
    @property
    def DummyThickness(self) -> float: ...
    @DummyThickness.setter
    def DummyThickness(self, value: float) -> None: ...
    @property
    def SplineSegments(self) -> SplineSegmentsType: ...
    @SplineSegments.setter
    def SplineSegments(self, value: SplineSegmentsType) -> None: ...
    @property
    def FileType(self) -> CADFileType: ...
    @FileType.setter
    def FileType(self, value: CADFileType) -> None: ...
    @property
    def Tolerance(self) -> CADToleranceType: ...
    @Tolerance.setter
    def Tolerance(self, value: CADToleranceType) -> None: ...
    @property
    def AngularTolerance(self) -> CADAngularToleranceType: ...
    @AngularTolerance.setter
    def AngularTolerance(self, value: CADAngularToleranceType) -> None: ...
    @property
    def Configuration(self) -> int: ...
    @property
    def ExportDummySurfaces(self) -> bool: ...
    @ExportDummySurfaces.setter
    def ExportDummySurfaces(self, value: bool) -> None: ...
    @property
    def SurfacesAsSolids(self) -> bool: ...
    @SurfacesAsSolids.setter
    def SurfacesAsSolids(self, value: bool) -> None: ...
    @property
    def ScatterNSCRays(self) -> bool: ...
    @ScatterNSCRays.setter
    def ScatterNSCRays(self, value: bool) -> None: ...
    @property
    def SplitNSCRays(self) -> bool: ...
    @SplitNSCRays.setter
    def SplitNSCRays(self, value: bool) -> None: ...
    @property
    def UsePolarization(self) -> bool: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...
    @property
    def OutputFileName(self) -> str: ...
    @OutputFileName.setter
    def OutputFileName(self, value: str) -> None: ...
    @property
    def AutoNameFaces(self) -> bool: ...
    @AutoNameFaces.setter
    def AutoNameFaces(self, value: bool) -> None: ...
    @property
    def FileVersion(self) -> ACISExportVersion: ...
    @FileVersion.setter
    def FileVersion(self, value: ACISExportVersion) -> None: ...
    def SetConfigurationAllAtOnce(self) -> None: ...
    def SetConfigurationAllByFile(self) -> None: ...
    def SetConfigurationAllByLayer(self) -> None: ...
    def SetCurrentConfiguration(self) -> None: ...
    def SetFieldAll(self) -> None: ...
    def SetSingleConfiguration(self, ConfigurationNumber: int) -> None: ...
    def SetWavelengthAll(self) -> None: ...

class IHullTools:
    def Compute2DHull(
        self, points: IPointList3D, planeOrigin: IPoint3D, planeX: IPoint3D, planeY: IPoint3D
    ) -> IPointList3D: ...
    def ComputeCovData(self, points: IPointList3D, center: IPoint3D) -> ICovarianceData: ...

class ILensCatalogLens:
    @property
    def Vendor(self) -> str: ...
    @property
    def LensName(self) -> str: ...
    @property
    def EFL(self) -> float: ...
    @property
    def EPD(self) -> float: ...
    @property
    def Shape(self) -> LensShape: ...
    @property
    def Type(self) -> LensType: ...
    @property
    def NumberOfElements(self) -> int: ...
    @property
    def Telecentric(self) -> bool: ...
    def InsertLensNonSeq(self) -> bool: ...
    def InsertLensSeq(self, atSurface: int, ignoreObject: bool, reverseSurfGeom: bool) -> bool: ...
    def LoadLens(self, saveIfNeeded: bool) -> None: ...
    def LoadNewLensNonSeq(self) -> IOpticalSystem: ...
    def LoadNewLensSeq(self) -> IOpticalSystem: ...

class ILensCatalogs(ISystemTool):
    @property
    def SelectedVendor(self) -> str: ...
    @SelectedVendor.setter
    def SelectedVendor(self, value: str) -> None: ...
    @property
    def UseEFL(self) -> bool: ...
    @UseEFL.setter
    def UseEFL(self, value: bool) -> None: ...
    @property
    def MinEFL(self) -> float: ...
    @MinEFL.setter
    def MinEFL(self, value: float) -> None: ...
    @property
    def MaxEFL(self) -> float: ...
    @MaxEFL.setter
    def MaxEFL(self, value: float) -> None: ...
    @property
    def UseEPD(self) -> bool: ...
    @UseEPD.setter
    def UseEPD(self, value: bool) -> None: ...
    @property
    def MinEPD(self) -> float: ...
    @MinEPD.setter
    def MinEPD(self, value: float) -> None: ...
    @property
    def MaxEPD(self) -> float: ...
    @MaxEPD.setter
    def MaxEPD(self, value: float) -> None: ...
    @property
    def IncShapeEqui(self) -> bool: ...
    @IncShapeEqui.setter
    def IncShapeEqui(self, value: bool) -> None: ...
    @property
    def IncShapeBi(self) -> bool: ...
    @IncShapeBi.setter
    def IncShapeBi(self, value: bool) -> None: ...
    @property
    def IncShapePlano(self) -> bool: ...
    @IncShapePlano.setter
    def IncShapePlano(self, value: bool) -> None: ...
    @property
    def IncShapeMeniscus(self) -> bool: ...
    @IncShapeMeniscus.setter
    def IncShapeMeniscus(self, value: bool) -> None: ...
    @property
    def IncTypeSpherical(self) -> bool: ...
    @IncTypeSpherical.setter
    def IncTypeSpherical(self, value: bool) -> None: ...
    @property
    def IncTypeGRIN(self) -> bool: ...
    @IncTypeGRIN.setter
    def IncTypeGRIN(self, value: bool) -> None: ...
    @property
    def IncTypeAspheric(self) -> bool: ...
    @IncTypeAspheric.setter
    def IncTypeAspheric(self, value: bool) -> None: ...
    @property
    def IncTypeToroidal(self) -> bool: ...
    @IncTypeToroidal.setter
    def IncTypeToroidal(self, value: bool) -> None: ...
    @property
    def NumberOfElements(self) -> int: ...
    @NumberOfElements.setter
    def NumberOfElements(self, value: int) -> None: ...
    @property
    def MatchingLenses(self) -> int: ...
    @property
    def LensesForVendor(self) -> int: ...
    def GetAllVendors(self) -> list[str]: ...
    def GetResult(self, index: int) -> ILensCatalogLens: ...
    def SetNumberOfElementsAny(self) -> None: ...

class IPoint3D:
    @property
    def X(self) -> float: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @property
    def Y(self) -> float: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @property
    def Z(self) -> float: ...
    @Z.setter
    def Z(self, value: float) -> None: ...
    def Add(self, p: IPoint3D) -> None: ...
    def GetDim(self, Dim: int) -> float: ...
    def GetSortedDims(self) -> list[int]: ...
    def Magnitude(self) -> float: ...
    def MagnitudeSq(self) -> float: ...
    def SetDim(self, Dim: int, Value: float) -> None: ...
    def VectorAndScalar(self) -> tuple[bool, IPoint3D, float]: ...

class IPointList3D:
    @property
    def NumberOfPoints(self) -> int: ...
    @overload
    def AddPoint(self, p: IPoint3D) -> None: ...
    @overload
    def AddPoint(self, X: float, Y: float, Z: float) -> None: ...
    def Clear(self) -> None: ...
    def GetPoint(self, Index: int) -> IPoint3D: ...
    def RemovePoint(self, Index: int) -> None: ...

class IPointTools:
    def Add(self, p1: IPoint3D, p2: IPoint3D) -> IPoint3D: ...
    def ComputeCentroid(self, points: IPointList3D) -> IPoint3D: ...
    def CreatePoint(self, x: float, y: float, z: float) -> IPoint3D: ...
    def CreatePointList(self) -> IPointList3D: ...
    def Cross(self, p1: IPoint3D, p2: IPoint3D) -> IPoint3D: ...
    def Divide(self, p: IPoint3D, s: float) -> IPoint3D: ...
    def Dot(self, p1: IPoint3D, p2: IPoint3D) -> float: ...
    def Multiply(self, p: IPoint3D, s: float) -> IPoint3D: ...
    def Subtract(self, p1: IPoint3D, p2: IPoint3D) -> IPoint3D: ...

class IQuickAdjust(ISystemTool):
    @property
    def AdjustSurface(self) -> int: ...
    @AdjustSurface.setter
    def AdjustSurface(self, value: int) -> None: ...
    @property
    def SurfaceParameter(self) -> QuickAdjustType: ...
    @SurfaceParameter.setter
    def SurfaceParameter(self, value: QuickAdjustType) -> None: ...
    @property
    def Criterion(self) -> QuickAdjustCriterion: ...
    @Criterion.setter
    def Criterion(self, value: QuickAdjustCriterion) -> None: ...
    @property
    def EvaluateSurface(self) -> int: ...
    @EvaluateSurface.setter
    def EvaluateSurface(self, value: int) -> None: ...
    def SetEvaluateSurfaceImage(self) -> None: ...

class IQuickFocus(ISystemTool):
    @property
    def UseCentroid(self) -> bool: ...
    @UseCentroid.setter
    def UseCentroid(self, value: bool) -> None: ...
    @property
    def Criterion(self) -> QuickFocusCriterion: ...
    @Criterion.setter
    def Criterion(self, value: QuickFocusCriterion) -> None: ...

class IRayAimingWizard(ISystemTool):
    def ApplyRecommendedSettings(self) -> None: ...
    def GetRecommendedSettings(self) -> ISDRayAimingData: ...

class IRestoreArchive(ISystemTool):
    @property
    def ArchiveFile(self) -> str: ...
    @property
    def NumberOfFilesInArchive(self) -> int: ...
    @property
    def ExtractAllFilesToProjectDirectory(self) -> bool: ...
    @ExtractAllFilesToProjectDirectory.setter
    def ExtractAllFilesToProjectDirectory(self, value: bool) -> None: ...
    def GetFileNameInArchive(self, fileNumber: int) -> str: ...
    def GetOutputFolder(self) -> str: ...
    def SetFileName(self, archiveFile: str) -> ArchiveFileStatus: ...
    def SetFileOverwrite(self, fileNumber: int, allowOverwrite: bool) -> None: ...
    def SetFilesAllOverwrite(self) -> None: ...
    def SetFilesNoOverwrite(self) -> None: ...
    def SetOutputFolder(self, folder: str) -> bool: ...

class IRestoreProject(ISystemTool):
    @property
    def ArchiveFile(self) -> str: ...
    @property
    def NumberOfFilesInArchive(self) -> int: ...
    @property
    def NumberOfAdditionalFiles(self) -> int: ...
    def GetAdditionalFile(self, addfileNumber: int) -> IFile: ...
    def GetFile(self, fileNumber: int) -> IFile: ...
    def GetFileNameInArchive(self, fileNumber: int) -> str: ...
    def GetOutputFolder(self) -> str: ...
    def SetAllFilesToProject(self) -> bool: ...
    def SetAllFilesToRoot(self) -> bool: ...
    def SetFileName(self, archiveFile: str) -> ArchiveFileStatus: ...
    def SetFileOverwrite(self, fileNumber: int, allowOverwrite: bool) -> None: ...
    def SetFilesAllOverwrite(self) -> None: ...
    def SetFilesNoOverwrite(self) -> None: ...
    def SetOutputFolder(self, folder: str) -> bool: ...
    def UseProjectFile(self, fileNumber: int) -> bool: ...
    def UseRootFile(self, fileNumber: int) -> bool: ...

class IScale(ISystemTool):
    @property
    def ScaleFactor(self) -> float: ...
    @ScaleFactor.setter
    def ScaleFactor(self, value: float) -> None: ...
    @property
    def FirstComponent(self) -> int: ...
    @FirstComponent.setter
    def FirstComponent(self, value: int) -> None: ...
    @property
    def LastComponent(self) -> int: ...
    @LastComponent.setter
    def LastComponent(self, value: int) -> None: ...
    @property
    def ScaleToUnit(self) -> ScaleToUnits: ...
    @ScaleToUnit.setter
    def ScaleToUnit(self, value: ScaleToUnits) -> None: ...
    @property
    def ScaleByFactor(self) -> bool: ...
    @ScaleByFactor.setter
    def ScaleByFactor(self, value: bool) -> None: ...
    @property
    def ScaleByUnits(self) -> bool: ...
    @ScaleByUnits.setter
    def ScaleByUnits(self, value: bool) -> None: ...
    @property
    def NumberOfComponents(self) -> int: ...
    def GetComponentAt(self, idx: int) -> str: ...

class LensShape:
    Unknown = 0
    Equi = 1
    Bi = 2
    Plano = 3
    Meniscus = 4

class LensType:
    Other = 0
    Spherical = 1
    GRIN = 2
    Aspheric = 3
    Toroidal = 4

class QuickAdjustCriterion:
    SpotSizeRadial = 0
    SpotSizeXOnly = 1
    SpotSizeYOnly = 2
    AngularRadial = 3
    AngularXOnly = 4
    AngularYOnly = 5

class QuickAdjustType:
    Radius = 0
    Thickness = 1

class QuickFocusCriterion:
    SpotSizeRadial = 0
    SpotSizeXOnly = 1
    SpotSizeYOnly = 2
    RMSWavefront = 3

class RayPatternType:
    XYFan = 0
    XFan = 1
    YFan = 2
    Ring = 3
    List = 4
    Random = 5
    Grid = 6
    SolidRing = 7

class ScaleToUnits:
    Millimeters = 0
    Centimeters = 1
    Inches = 2
    Meters = 3

class SplineSegmentsType:
    N_016 = 0
    N_032 = 1
    N_064 = 2
    N_128 = 3
    N_256 = 4
    N_512 = 5

class ZemaxFileTypes:
    Unknown = 0
    LMX = 1
    User = 2
