"""This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from typing import Iterable, overload

from zospy.api._ZOSAPI.Tools import ISystemTool

__all__ = (
    "IGlobalOptimization",
    "IHammerOptimization",
    "ILocalOptimization",
    "OptimizationAlgorithm",
    "OptimizationCycles",
    "OptimizationSaveCount",
)

class IGlobalOptimization(ISystemTool):
    @property
    def Algorithm(self) -> OptimizationAlgorithm: ...
    @Algorithm.setter
    def Algorithm(self, value: OptimizationAlgorithm) -> None: ...
    @property
    def NumberOfCores(self) -> int: ...
    @NumberOfCores.setter
    def NumberOfCores(self, value: int) -> None: ...
    @property
    def MaxCores(self) -> int: ...
    @property
    def NumberToSave(self) -> OptimizationSaveCount: ...
    @NumberToSave.setter
    def NumberToSave(self, value: OptimizationSaveCount) -> None: ...
    @property
    def Targets(self) -> int: ...
    @property
    def Variables(self) -> int: ...
    @property
    def InitialMeritFunction(self) -> float: ...
    @property
    def Systems(self) -> int: ...
    @property
    def Cycles(self) -> int: ...
    @property
    def CurrentMeritFunction01(self) -> float: ...
    @property
    def CurrentMeritFunction02(self) -> float: ...
    @property
    def CurrentMeritFunction03(self) -> float: ...
    @property
    def CurrentMeritFunction04(self) -> float: ...
    @property
    def CurrentMeritFunction05(self) -> float: ...
    @property
    def CurrentMeritFunction06(self) -> float: ...
    @property
    def CurrentMeritFunction07(self) -> float: ...
    @property
    def CurrentMeritFunction08(self) -> float: ...
    @property
    def CurrentMeritFunction09(self) -> float: ...
    @property
    def CurrentMeritFunction10(self) -> float: ...
    @property
    def IsHPCEnabled(self) -> bool: ...
    @property
    def HPCEstimatedTimeS(self) -> float: ...
    @property
    def HPCRemainingTimeS(self) -> float: ...
    @property
    def HPCTimeToStartS(self) -> float: ...
    @property
    def HPCQueuePosition(self) -> int: ...
    @property
    def HPCState(self) -> HPCRunState: ...
    @property
    def HPCHasTimeEstimate(self) -> bool: ...
    @property
    def TargetRunTimeM(self) -> float: ...
    @TargetRunTimeM.setter
    def TargetRunTimeM(self, value: float) -> None: ...
    def CurrentMeritFunction(self, N: int) -> float: ...
    def EstimateHPCTime(self) -> bool: ...

class IHammerOptimization(ISystemTool):
    @property
    def Algorithm(self) -> OptimizationAlgorithm: ...
    @Algorithm.setter
    def Algorithm(self, value: OptimizationAlgorithm) -> None: ...
    @property
    def NumberOfCores(self) -> int: ...
    @NumberOfCores.setter
    def NumberOfCores(self, value: int) -> None: ...
    @property
    def MaxCores(self) -> int: ...
    @property
    def AutomaticOptimization(self) -> bool: ...
    @AutomaticOptimization.setter
    def AutomaticOptimization(self, value: bool) -> None: ...
    @property
    def Targets(self) -> int: ...
    @property
    def Variables(self) -> int: ...
    @property
    def InitialMeritFunction(self) -> float: ...
    @property
    def CurrentMeritFunction(self) -> float: ...
    @property
    def Systems(self) -> int: ...
    @property
    def IsHPCEnabled(self) -> bool: ...
    @property
    def HPCEstimatedTimeS(self) -> float: ...
    @property
    def HPCRemainingTimeS(self) -> float: ...
    @property
    def HPCTimeToStartS(self) -> float: ...
    @property
    def HPCQueuePosition(self) -> int: ...
    @property
    def HPCState(self) -> HPCRunState: ...
    @property
    def HPCHasTimeEstimate(self) -> bool: ...
    @property
    def TargetRunTimeM(self) -> float: ...
    @TargetRunTimeM.setter
    def TargetRunTimeM(self, value: float) -> None: ...
    def EstimateHPCTime(self) -> bool: ...

class ILocalOptimization(ISystemTool):
    @property
    def Algorithm(self) -> OptimizationAlgorithm: ...
    @Algorithm.setter
    def Algorithm(self, value: OptimizationAlgorithm) -> None: ...
    @property
    def NumberOfCores(self) -> int: ...
    @NumberOfCores.setter
    def NumberOfCores(self, value: int) -> None: ...
    @property
    def MaxCores(self) -> int: ...
    @property
    def Cycles(self) -> OptimizationCycles: ...
    @Cycles.setter
    def Cycles(self, value: OptimizationCycles) -> None: ...
    @property
    def Targets(self) -> int: ...
    @property
    def Variables(self) -> int: ...
    @property
    def InitialMeritFunction(self) -> float: ...
    @property
    def CurrentMeritFunction(self) -> float: ...

class OptimizationAlgorithm:
    DampedLeastSquares = 0
    OrthogonalDescent = 1

class OptimizationCycles:
    Automatic = 0
    Fixed_1_Cycle = 1
    Fixed_5_Cycles = 2
    Fixed_10_Cycles = 3
    Fixed_50_Cycles = 4
    Infinite = 5

class OptimizationSaveCount:
    Save_10 = 0
    Save_20 = 1
    Save_30 = 2
    Save_40 = 3
    Save_50 = 4
    Save_60 = 5
    Save_70 = 6
    Save_80 = 7
    Save_90 = 8
    Save_100 = 9
