"""This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from typing import Iterable, overload

from zospy.api._ZOSAPI.Analysis import SampleSizes
from zospy.api._ZOSAPI.Analysis.Settings import IAS_

__all__ = (
    "IAS_PhysicalOpticsPropagation",
    "POPBeamTypes",
    "POPDataTypes",
    "POPFiberPositions",
    "POPFiberTypes",
    "POPProjectionTypes",
    "POPScaleTypes",
    "POPShowAsTypes",
    "POPZoomTypes",
)

class IAS_PhysicalOpticsPropagation(IAS_):
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def StartSurface(self) -> IAS_Surface: ...
    @property
    def EndSurface(self) -> IAS_Surface: ...
    @property
    def SurfaceToBeam(self) -> float: ...
    @SurfaceToBeam.setter
    def SurfaceToBeam(self, value: float) -> None: ...
    @property
    def UsePolarization(self) -> bool: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...
    @property
    def SeparateXY(self) -> bool: ...
    @SeparateXY.setter
    def SeparateXY(self, value: bool) -> None: ...
    @property
    def UseDiskStorage(self) -> bool: ...
    @UseDiskStorage.setter
    def UseDiskStorage(self, value: bool) -> None: ...
    @property
    def BeamType(self) -> POPBeamTypes: ...
    @BeamType.setter
    def BeamType(self, value: POPBeamTypes) -> None: ...
    @property
    def XSampling(self) -> SampleSizes: ...
    @XSampling.setter
    def XSampling(self, value: SampleSizes) -> None: ...
    @property
    def YSampling(self) -> SampleSizes: ...
    @YSampling.setter
    def YSampling(self, value: SampleSizes) -> None: ...
    @property
    def XWidth(self) -> float: ...
    @XWidth.setter
    def XWidth(self, value: float) -> None: ...
    @property
    def YWidth(self) -> float: ...
    @YWidth.setter
    def YWidth(self, value: float) -> None: ...
    @property
    def UseTotalPower(self) -> bool: ...
    @UseTotalPower.setter
    def UseTotalPower(self, value: bool) -> None: ...
    @property
    def TotalPower(self) -> float: ...
    @TotalPower.setter
    def TotalPower(self, value: float) -> None: ...
    @property
    def UsePeakIrradiance(self) -> bool: ...
    @UsePeakIrradiance.setter
    def UsePeakIrradiance(self, value: bool) -> None: ...
    @property
    def PeakIrradiance(self) -> float: ...
    @PeakIrradiance.setter
    def PeakIrradiance(self, value: float) -> None: ...
    @property
    def NumberOfBeamTypeFiles(self) -> int: ...
    @property
    def BeamTypeFilename(self) -> str: ...
    @BeamTypeFilename.setter
    def BeamTypeFilename(self, value: str) -> None: ...
    @property
    def NumberOfParameters(self) -> int: ...
    @property
    def ShowAs(self) -> POPShowAsTypes: ...
    @ShowAs.setter
    def ShowAs(self, value: POPShowAsTypes) -> None: ...
    @property
    def DataType(self) -> POPDataTypes: ...
    @DataType.setter
    def DataType(self, value: POPDataTypes) -> None: ...
    @property
    def Project(self) -> POPProjectionTypes: ...
    @Project.setter
    def Project(self, value: POPProjectionTypes) -> None: ...
    @property
    def ContourFormat(self) -> str: ...
    @ContourFormat.setter
    def ContourFormat(self, value: str) -> None: ...
    @property
    def PlotScale(self) -> float: ...
    @PlotScale.setter
    def PlotScale(self, value: float) -> None: ...
    @property
    def LogScale(self) -> POPScaleTypes: ...
    @LogScale.setter
    def LogScale(self, value: POPScaleTypes) -> None: ...
    @property
    def ZoomIn(self) -> POPZoomTypes: ...
    @ZoomIn.setter
    def ZoomIn(self, value: POPZoomTypes) -> None: ...
    @property
    def RowOrColumn(self) -> int: ...
    @RowOrColumn.setter
    def RowOrColumn(self, value: int) -> None: ...
    @property
    def ZeroPhaseLevel(self) -> float: ...
    @ZeroPhaseLevel.setter
    def ZeroPhaseLevel(self, value: float) -> None: ...
    @property
    def SaveOutputBeam(self) -> bool: ...
    @SaveOutputBeam.setter
    def SaveOutputBeam(self, value: bool) -> None: ...
    @property
    def OutputBeamFile(self) -> str: ...
    @OutputBeamFile.setter
    def OutputBeamFile(self, value: str) -> None: ...
    @property
    def SaveBeamAtAllSurfaces(self) -> bool: ...
    @SaveBeamAtAllSurfaces.setter
    def SaveBeamAtAllSurfaces(self, value: bool) -> None: ...
    @property
    def ComputeFiberCouplingIntegral(self) -> bool: ...
    @ComputeFiberCouplingIntegral.setter
    def ComputeFiberCouplingIntegral(self, value: bool) -> None: ...
    @property
    def IgnoreFiberPolarization(self) -> bool: ...
    @IgnoreFiberPolarization.setter
    def IgnoreFiberPolarization(self, value: bool) -> None: ...
    @property
    def FiberType(self) -> POPFiberTypes: ...
    @FiberType.setter
    def FiberType(self, value: POPFiberTypes) -> None: ...
    @property
    def FiberPosition(self) -> POPFiberPositions: ...
    @FiberPosition.setter
    def FiberPosition(self, value: POPFiberPositions) -> None: ...
    @property
    def TiltAboutX(self) -> float: ...
    @TiltAboutX.setter
    def TiltAboutX(self, value: float) -> None: ...
    @property
    def TiltAboutY(self) -> float: ...
    @TiltAboutY.setter
    def TiltAboutY(self, value: float) -> None: ...
    @property
    def NumberOfFiberTypeFiles(self) -> int: ...
    @property
    def FiberTypeFilename(self) -> str: ...
    @FiberTypeFilename.setter
    def FiberTypeFilename(self, value: str) -> None: ...
    @property
    def NumberOfFiberParameters(self) -> int: ...
    def AutoCalculateBeamSampling(self) -> None: ...
    def GetBeamTypeFileName(self, fileIndex: int) -> str: ...
    def GetBeamTypeFiles(self) -> list[str]: ...
    def GetFiberParameterName(self, paramIdx: int) -> str: ...
    def GetFiberParameterValue(self, paramIdx: int) -> float: ...
    def GetFiberTypeFileName(self, fileIndex: int) -> str: ...
    def GetFiberTypeFiles(self) -> list[str]: ...
    def GetParameterName(self, paramIdx: int) -> str: ...
    def GetParameterValue(self, paramIdx: int) -> float: ...
    def ReadPowerFromFile(self) -> None: ...
    def SetFiberParameterValue(self, paramIdx: int, Value: float) -> None: ...
    def SetParameterValue(self, paramIdx: int, Value: float) -> None: ...

class POPBeamTypes:
    GaussianWaist = 0
    GaussianAngle = 1
    GaussianSizeAngle = 2
    TopHat = 3
    File = 4
    DLL = 5
    Multimode = 6
    AstigmaticGaussian = 7

class POPDataTypes:
    Irradiance = 0
    EXIrradiance = 1
    EYIrradiance = 2
    Phase = 3
    EXPhase = 4
    EYPhase = 5
    TransferMagnitude = 6
    TransferPhase = 7

class POPFiberPositions:
    ChiefRay = 0
    SurfaceVertex = 1

class POPFiberTypes:
    GaussianWaist = 0
    GaussianAngle = 1
    GaussianSizeAngle = 2
    TopHat = 3
    File = 4
    DLL = 5
    AstigmaticGaussian = 6

class POPProjectionTypes:
    AlongBeam = 0
    AlongNormal = 1
    AlongLocalZ = 2

class POPScaleTypes:
    Linear = 0
    Log_Minus_5 = 1
    Log_Minus_10 = 2
    Log_Minus_15 = 3

class POPShowAsTypes:
    Surface = 0
    Contour = 1
    GrayScale = 2
    InverseGrayScale = 3
    FalseColor = 4
    InverseFalseColor = 5
    CrossX = 6
    CrossY = 7
    Encircled = 8
    Ensquared = 9
    EnslittedX = 10
    EnslittedY = 11

class POPZoomTypes:
    NoZoom = 0
    X2 = 1
    X4 = 2
    X8 = 3
    X16 = 4
