"""This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from typing import Iterable, overload

from zospy.api._ZOSAPI.Analysis.Settings import IAS_
from zospy.api._ZOSAPI.Tools.Tolerancing import MonteCarloStatistics

from . import QuickYield

__all__ = (
    "QuickYield",
    "IAS_QuickYield",
    "IAS_TolerancingHistogram",
    "IAS_TolerancingYield",
    "ITolerancingOperand",
    "ITolerancingOperands",
    "QYCompensations",
    "QYCompensatorStrategy",
    "QYPrecisions",
)

class IAS_QuickYield(IAS_):
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @property
    def Configuration(self) -> int: ...
    @Configuration.setter
    def Configuration(self, value: int) -> None: ...
    @property
    def NumMonteCarlo(self) -> int: ...
    @NumMonteCarlo.setter
    def NumMonteCarlo(self, value: int) -> None: ...
    @property
    def PupilSampling(self) -> int: ...
    @PupilSampling.setter
    def PupilSampling(self, value: int) -> None: ...
    @property
    def Statistic(self) -> MonteCarloStatistics: ...
    @Statistic.setter
    def Statistic(self, value: MonteCarloStatistics) -> None: ...
    @property
    def Precision(self) -> QYPrecisions: ...
    @Precision.setter
    def Precision(self, value: QYPrecisions) -> None: ...
    @property
    def Compensation(self) -> QYCompensations: ...
    @Compensation.setter
    def Compensation(self, value: QYCompensations) -> None: ...
    @property
    def QYField(self) -> IAS_QYField: ...
    @property
    def CompensatorStrategy(self) -> QYCompensatorStrategy: ...
    @CompensatorStrategy.setter
    def CompensatorStrategy(self, value: QYCompensatorStrategy) -> None: ...

class IAS_TolerancingHistogram(IAS_):
    @property
    def Filename(self) -> str: ...
    @Filename.setter
    def Filename(self, value: str) -> None: ...
    @property
    def Operand(self) -> int: ...
    @Operand.setter
    def Operand(self, value: int) -> None: ...
    @property
    def MinValue(self) -> float: ...
    @MinValue.setter
    def MinValue(self, value: float) -> None: ...
    @property
    def MaxValue(self) -> float: ...
    @MaxValue.setter
    def MaxValue(self, value: float) -> None: ...
    @property
    def NumBins(self) -> int: ...
    @NumBins.setter
    def NumBins(self, value: int) -> None: ...
    def GetOperands(self) -> ITolerancingOperands: ...
    def GetToleranceFiles(self) -> list[str]: ...
    def UseSystemTolerances(self) -> None: ...

class IAS_TolerancingYield(IAS_):
    @property
    def Filename(self) -> str: ...
    @Filename.setter
    def Filename(self, value: str) -> None: ...
    @property
    def Operand(self) -> int: ...
    @Operand.setter
    def Operand(self, value: int) -> None: ...
    def GetOperands(self) -> ITolerancingOperands: ...
    def GetToleranceFiles(self) -> list[str]: ...
    def UseSystemTolerances(self) -> None: ...

class ITolerancingOperand:
    @property
    def OperandName(self) -> str: ...
    @property
    def ParameterData(self) -> str: ...

class ITolerancingOperands:
    @property
    def NumberOfOperands(self) -> int: ...
    @property
    def Operands(self) -> list[ITolerancingOperand]: ...
    def GetOperand(self, operandIndex: int) -> ITolerancingOperand: ...

class QYCompensations:
    Standard = 0
    High = 1
    VeryHigh = 2

class QYCompensatorStrategy:
    OptimizeAllDampedLeastSquares = 0
    ParaxialFocus = 1
    Ignore = 2
    OptimizeAllOrthogonalDescent = 3

class QYPrecisions:
    Standard = 0
    High = 1
    VeryHigh = 2
