"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/cdk");
const cdk_1 = require("@aws-cdk/cdk");
const s3 = require("../lib");
const notification_dests_1 = require("./notification-dests");
const app = new cdk.App();
const stack = new cdk_1.Stack(app, 'test-3');
const bucket = new s3.Bucket(stack, 'Bucket', {
    removalPolicy: cdk.RemovalPolicy.Destroy
});
const topic = new notification_dests_1.Topic(stack, 'Topic');
const topic3 = new notification_dests_1.Topic(stack, 'Topic3');
bucket.addEventNotification(s3.EventType.ObjectCreatedPut, topic);
bucket.addEventNotification(s3.EventType.ObjectRemoved, topic3, { prefix: 'home/myusername/' });
const bucket2 = new s3.Bucket(stack, 'Bucket2', {
    removalPolicy: cdk.RemovalPolicy.Destroy
});
bucket2.addObjectRemovedNotification(topic3, { prefix: 'foo' }, { suffix: 'foo/bar' });
app.run();
//# sourceMappingURL=data:application/json;base64,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