import * as apigv2 from '@aws-cdk/aws-apigatewayv2';
import * as route53 from '@aws-cdk/aws-route53';
/**
 * Defines an API Gateway V2 domain name as the alias target.
 *
 * @stability stable
 */
export declare class ApiGatewayv2Domain implements route53.IAliasRecordTarget {
    private readonly domainName;
    /**
     * @stability stable
     */
    constructor(domainName: apigv2.IDomainName);
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record: route53.IRecordSet): route53.AliasRecordTargetConfig;
}
