"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalAcceleratorTarget = exports.GlobalAcceleratorDomainTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use a Global Accelerator domain name as an alias record target.
 *
 * @stability stable
 */
class GlobalAcceleratorDomainTarget {
    /**
     * Create an Alias Target for a Global Accelerator domain name.
     *
     * @stability stable
     */
    constructor(acceleratorDomainName) {
        this.acceleratorDomainName = acceleratorDomainName;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record) {
        return {
            hostedZoneId: GlobalAcceleratorTarget.GLOBAL_ACCELERATOR_ZONE_ID,
            dnsName: this.acceleratorDomainName,
        };
    }
}
exports.GlobalAcceleratorDomainTarget = GlobalAcceleratorDomainTarget;
_a = JSII_RTTI_SYMBOL_1;
GlobalAcceleratorDomainTarget[_a] = { fqn: "@aws-cdk/aws-route53-targets.GlobalAcceleratorDomainTarget", version: "1.95.0" };
/**
 * The hosted zone Id if using an alias record in Route53.
 *
 * This value never changes.
 * Ref: https://docs.aws.amazon.com/general/latest/gr/global_accelerator.html
 *
 * @stability stable
 */
GlobalAcceleratorDomainTarget.GLOBAL_ACCELERATOR_ZONE_ID = 'Z2BJ6XQ5FK7U4H';
/**
 * Use a Global Accelerator instance domain name as an alias record target.
 *
 * @stability stable
 */
class GlobalAcceleratorTarget extends GlobalAcceleratorDomainTarget {
    /**
     * Create an Alias Target for a Global Accelerator instance.
     *
     * @stability stable
     */
    constructor(accelerator) {
        super(accelerator.dnsName);
    }
}
exports.GlobalAcceleratorTarget = GlobalAcceleratorTarget;
_b = JSII_RTTI_SYMBOL_1;
GlobalAcceleratorTarget[_b] = { fqn: "@aws-cdk/aws-route53-targets.GlobalAcceleratorTarget", version: "1.95.0" };
//# sourceMappingURL=data:application/json;base64,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