#! /usr/bin/env python

from solid2 import *

#this imports (and enables) the child optimizer extension
import solid2_extensions.child_optimizer

#some SolidPython model to be optimized
c = cube(2)
m1 = cube(1) + sphere(2)
m2 = circle(5) + c + c + m1
model1 = m1 - m2 + m1.translateX(10)

#render (and optimize it)
model1.save_as_scad()


"""
This is the output:

// Generated by ExpSolidPython

module wrapperModule0() {
union() {
	difference() {
		children(3);
		union() {
			circle(r = 5);
			children(0);
			children(0);
			children(2);
			children(1);
		}
	}
	translate(v = [10, 0, 0]) {
		children(3);
	}
}
}
module wrapperModule1() {
wrapperModule0(){children(0);children(1);children(2);union() {
	children(2);
	children(1);
}
}}
module wrapperModule2() {
wrapperModule1(){children(0);children(1);cube(size = 1);
}}
module wrapperModule3() {
wrapperModule2(){children(0);sphere(r = 2);
}}
module wrapperModule4() {
wrapperModule3(){cube(size = 2);
}}
wrapperModule4(){};

"""
