#  Licensed to the Apache Software Foundation (ASF) under one or more
#  contributor license agreements. See the NOTICE file distributed with
#  this work for additional information regarding copyright ownership.
#  The ASF licenses this file to You under the Apache License, Version 2.0
#  (the "License"); you may not use this file except in compliance with
#  the License. You may obtain a copy of the License at
#
#  http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

# generated by datamodel-codegen:
#   filename:  schema/entity/data/table.json
#   timestamp: 2021-07-31T17:12:10+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Field, constr

from metadata.generated.schema.type import basic, entityReference, tagLabel, usageDetails


class TableType(Enum):
    Regular = 'Regular'
    External = 'External'
    View = 'View'
    SecureView = 'SecureView'
    MaterializedView = 'MaterializedView'


class ColumnDataType(Enum):
    NUMBER = 'NUMBER'
    TINYINT = 'TINYINT'
    SMALLINT = 'SMALLINT'
    INT = 'INT'
    BIGINT = 'BIGINT'
    FLOAT = 'FLOAT'
    DOUBLE = 'DOUBLE'
    DECIMAL = 'DECIMAL'
    NUMERIC = 'NUMERIC'
    TIMESTAMP = 'TIMESTAMP'
    TIME = 'TIME'
    DATE = 'DATE'
    DATETIME = 'DATETIME'
    INTERVAL = 'INTERVAL'
    STRING = 'STRING'
    MEDIUMTEXT = 'MEDIUMTEXT'
    TEXT = 'TEXT'
    CHAR = 'CHAR'
    VARCHAR = 'VARCHAR'
    BOOLEAN = 'BOOLEAN'
    BINARY = 'BINARY'
    VARBINARY = 'VARBINARY'
    ARRAY = 'ARRAY'
    BLOB = 'BLOB'
    LONGBLOB = 'LONGBLOB'
    MEDIUMBLOB = 'MEDIUMBLOB'
    MAP = 'MAP'
    STRUCT = 'STRUCT'
    UNION = 'UNION'
    SET = 'SET'
    GEOGRAPHY = 'GEOGRAPHY'
    ENUM = 'ENUM'
    JSON = 'JSON'


class ColumnConstraint(Enum):
    NULL = 'NULL'
    NOT_NULL = 'NOT_NULL'
    UNIQUE = 'UNIQUE'
    PRIMARY_KEY = 'PRIMARY_KEY'


class ConstraintType(Enum):
    UNIQUE = 'UNIQUE'
    PRIMARY_KEY = 'PRIMARY_KEY'
    FOREIGN_KEY = 'FOREIGN_KEY'


class TableConstraint(BaseModel):
    constraintType: Optional[ConstraintType] = None
    columns: Optional[List[str]] = Field(
        None, description='List of column names corresponding to the constraint'
    )


class ColumnName(BaseModel):
    __root__: constr(regex=r'^[^.]*$', min_length=1, max_length=64) = Field(
        ..., description='Local name (not fully qualified name) of the column'
    )


class TableName(BaseModel):
    __root__: constr(regex=r'^[^.]*$', min_length=1, max_length=64) = Field(
        ..., description='Local name (not fully qualified name) of the table'
    )


class FullyQualifiedColumnName(BaseModel):
    __root__: constr(min_length=1, max_length=256) = Field(
        ...,
        description='Fully qualified name of the column that includes serviceName.databaseName.tableName.columnName',
    )


class JoinedWithItem(BaseModel):
    fullyQualifiedName: Optional[FullyQualifiedColumnName] = None
    joinCount: Optional[int] = None


class ColumnJoins(BaseModel):
    columnName: Optional[ColumnName] = None
    joinedWith: Optional[List[JoinedWithItem]] = Field(
        None,
        description='Fully qualified names of the columns that this column is joined with',
    )


class TableData(BaseModel):
    columns: Optional[List[ColumnName]] = None
    rows: Optional[List[List]] = Field(
        None, description='Data for a multiple rows of the table'
    )


class TableJoins(BaseModel):
    startDate: Optional[basic.Date] = Field(
        None, description='Date can be only from today going back to last 29 days'
    )
    dayCount: Optional[int] = 1
    columnJoins: Optional[List[ColumnJoins]] = None


class Column(BaseModel):
    name: ColumnName
    columnDataType: ColumnDataType = Field(
        ..., description='Data type of the column (int, date etc.)'
    )
    description: Optional[str] = Field(None, description='Description of the column')
    fullyQualifiedName: Optional[FullyQualifiedColumnName] = None
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags associated with the column'
    )
    columnConstraint: Optional[ColumnConstraint] = Field(
        None, description='Column level constraint'
    )
    ordinalPosition: Optional[int] = Field(
        None, description='Ordinal position of the column'
    )


class TableEntity(BaseModel):
    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier that identifies this table instance'
    )
    name: TableName = Field(
        ..., description='Name of the table. Expected to be unique with in a database'
    )
    description: Optional[str] = Field(None, description='Description of the table')
    href: Optional[basic.Href] = Field(None, description='Link to this table resource')
    tableType: Optional[TableType] = None
    fullyQualifiedName: Optional[str] = Field(
        None,
        description='Fully qualified name of the table in the form serviceName.databaseName.tableName',
    )
    columns: List[Column] = Field(..., description='Columns in the table')
    tableConstraints: Optional[List[TableConstraint]] = Field(
        None, description='Table constraints'
    )
    usageSummary: Optional[usageDetails.TypeUsedToReturnUsageDetailsOfAnEntity] = Field(
        None, description='Latest usage information for this table'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this table'
    )
    followers: Optional[entityReference.EntityReferenceList] = Field(
        None, description='Followers of this table'
    )
    database: Optional[entityReference.EntityReference] = Field(
        None, description='Reference to Database that contains this table'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this table'
    )
    joins: Optional[TableJoins] = Field(
        None, description='Details of other tables this table is frequently joined with'
    )
    sampleData: Optional[TableData] = Field(
        None, description='Sample data for the table'
    )
