#  Licensed to the Apache Software Foundation (ASF) under one or more
#  contributor license agreements. See the NOTICE file distributed with
#  this work for additional information regarding copyright ownership.
#  The ASF licenses this file to You under the Apache License, Version 2.0
#  (the "License"); you may not use this file except in compliance with
#  the License. You may obtain a copy of the License at
#
#  http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

# generated by datamodel-codegen:
#   filename:  schema/entity/teams/team.json
#   timestamp: 2021-07-31T17:12:10+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Field, constr

from metadata.generated.schema.type import basic, entityReference, profile


class TeamName(BaseModel):
    __root__: constr(min_length=1, max_length=64) = Field(
        ...,
        description='Unique name of the team typically the team ID from the identify provider. Example - group Id from ldap.',
    )


class TeamEntity(BaseModel):
    id: basic.Uuid
    name: TeamName
    displayName: Optional[str] = Field(
        None, description="Name used for display purposes. Example 'Data Science team'"
    )
    description: Optional[str] = Field(None, description='Description of the team')
    href: basic.Href = Field(
        ..., description='Link to the resource corresponding to this entity'
    )
    profile: Optional[
        profile.TypeUsedToCaptureProfileOfAUserTeamOrAnOrganization
    ] = Field(None, description='Team profile information')
    deleted: Optional[bool] = None
    users: Optional[entityReference.EntityReferenceList] = Field(
        None, description='Users that are part of the team'
    )
    owns: Optional[entityReference.EntityReferenceList] = Field(
        None, description='Entities owned by the team'
    )
