#  Licensed to the Apache Software Foundation (ASF) under one or more
#  contributor license agreements. See the NOTICE file distributed with
#  this work for additional information regarding copyright ownership.
#  The ASF licenses this file to You under the Apache License, Version 2.0
#  (the "License"); you may not use this file except in compliance with
#  the License. You may obtain a copy of the License at
#
#  http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

# generated by datamodel-codegen:
#   filename:  schema/type/basic.json
#   timestamp: 2021-07-31T17:12:10+00:00

from __future__ import annotations

from datetime import date
from typing import Any, Optional
from uuid import UUID

from pydantic import AnyUrl, BaseModel, EmailStr, Field, constr


class CommonTypes(BaseModel):
    __root__: Any = Field(
        ..., description='Common reusable types', title='Common types'
    )


class Uuid(BaseModel):
    __root__: UUID = Field(..., description='Unique id used to identify an entity')


class Schema(BaseModel):
    __root__: AnyUrl = Field(..., description='URL for the schema of an entity')


class Email(BaseModel):
    __root__: EmailStr = Field(
        ..., description='Email address of user or other entities'
    )


class EntityLink(BaseModel):
    __root__: constr(regex=r'^<#E/\S+/\S+>$') = Field(
        ...,
        description='Entity or field thread is created for with format <#E/{enties}/{entityName}/{field}/{fieldValue}',
    )


class Timestamp(BaseModel):
    __root__: str


class Href(BaseModel):
    __root__: AnyUrl


class TimeInterval(BaseModel):
    start: Optional[int] = Field(None, description='Start unixTimeMillis')
    end: Optional[int] = Field(None, description='End unixTimeMillis')


class Duration(BaseModel):
    __root__: str = Field(
        ..., description="Duration in ISO 8601 format in UTC time. Example - 'P23DT23H'"
    )


class Date(BaseModel):
    __root__: date = Field(
        ..., description="Date in ISO 8601 format in UTC time. Example - '2018-11-13'"
    )


class DateTime(BaseModel):
    __root__: str = Field(
        ...,
        description="Date and time in ISO 8601 format. Example - '2018-11-13T20:20:39+00:00'",
    )
