#  Licensed to the Apache Software Foundation (ASF) under one or more
#  contributor license agreements. See the NOTICE file distributed with
#  this work for additional information regarding copyright ownership.
#  The ASF licenses this file to You under the Apache License, Version 2.0
#  (the "License"); you may not use this file except in compliance with
#  the License. You may obtain a copy of the License at
#
#  http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

# generated by datamodel-codegen:
#   filename:  schema/type/entityReference.json
#   timestamp: 2021-07-31T17:12:10+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Field

from . import basic


class EntityReference(BaseModel):
    id: basic.Uuid = Field(
        ..., description='Unique identifier that identifies an entity instance'
    )
    type: str = Field(
        ...,
        description='Entity type/class name - Examples: database, table, metrics, redshift, mysql, bigquery, snowflake...',
    )
    name: Optional[str] = Field(None, description='Name of the entity instance')
    description: Optional[str] = Field(
        None, description='Optional description of entity'
    )
    href: Optional[basic.Href] = Field(None, description='Link to the entity resource')


class EntityReferenceList(BaseModel):
    __root__: List[EntityReference]
