from typing import Any, Dict, List, Type, TypeVar, Union

import attr

from ..models.api_fluid_component_block import ApiFluidComponentBlock
from ..models.api_fluid_pseudo_component import ApiFluidPseudoComponent
from ..models.polymer_type import PolymerType
from ..types import UNSET, Unset

T = TypeVar("T", bound="ApiFluidPolymerComponent")


@attr.s(auto_attribs=True)
class ApiFluidPolymerComponent:
    """Information for a fluid component"""

    formula: Union[Unset, None, str] = UNSET
    short_name: Union[Unset, None, str] = UNSET
    sorting_order: Union[Unset, int] = UNSET
    polymer_type: Union[Unset, PolymerType] = UNSET
    pseudo_components: Union[Unset, None, List[ApiFluidPseudoComponent]] = UNSET
    blocks: Union[Unset, None, List[ApiFluidComponentBlock]] = UNSET

    def to_dict(self) -> Dict[str, Any]:
        formula = self.formula
        short_name = self.short_name
        sorting_order = self.sorting_order
        polymer_type: Union[Unset, str] = UNSET
        if not isinstance(self.polymer_type, Unset):
            polymer_type = self.polymer_type.value

        pseudo_components: Union[Unset, None, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.pseudo_components, Unset):
            if self.pseudo_components is None:
                pseudo_components = None
            else:
                pseudo_components = []
                for pseudo_components_item_data in self.pseudo_components:
                    pseudo_components_item = pseudo_components_item_data.to_dict()

                    pseudo_components.append(pseudo_components_item)

        blocks: Union[Unset, None, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.blocks, Unset):
            if self.blocks is None:
                blocks = None
            else:
                blocks = []
                for blocks_item_data in self.blocks:
                    blocks_item = blocks_item_data.to_dict()

                    blocks.append(blocks_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update({})
        if formula is not UNSET:
            field_dict["formula"] = formula
        if short_name is not UNSET:
            field_dict["shortName"] = short_name
        if sorting_order is not UNSET:
            field_dict["sortingOrder"] = sorting_order
        if polymer_type is not UNSET:
            field_dict["polymerType"] = polymer_type
        if pseudo_components is not UNSET:
            field_dict["pseudoComponents"] = pseudo_components
        if blocks is not UNSET:
            field_dict["blocks"] = blocks

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        formula = d.pop("formula", UNSET)

        short_name = d.pop("shortName", UNSET)

        sorting_order = d.pop("sortingOrder", UNSET)

        _polymer_type = d.pop("polymerType", UNSET)
        polymer_type: Union[Unset, PolymerType]
        if isinstance(_polymer_type, Unset):
            polymer_type = UNSET
        else:
            polymer_type = PolymerType(_polymer_type)

        pseudo_components = []
        _pseudo_components = d.pop("pseudoComponents", UNSET)
        for pseudo_components_item_data in _pseudo_components or []:
            pseudo_components_item = ApiFluidPseudoComponent.from_dict(pseudo_components_item_data)

            pseudo_components.append(pseudo_components_item)

        blocks = []
        _blocks = d.pop("blocks", UNSET)
        for blocks_item_data in _blocks or []:
            blocks_item = ApiFluidComponentBlock.from_dict(blocks_item_data)

            blocks.append(blocks_item)

        api_fluid_polymer_component = cls(
            formula=formula,
            short_name=short_name,
            sorting_order=sorting_order,
            polymer_type=polymer_type,
            pseudo_components=pseudo_components,
            blocks=blocks,
        )

        return api_fluid_polymer_component
