# coding: utf-8

"""
    VRt.Account [AC]

    # Description  Veeroute Account Panel.  ## Entity relationship diagram  ![erd](../uml/account.svg) 

    The version of the OpenAPI document: 7.6.2491
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import date
from pydantic import Field, StrictBytes, StrictStr
from typing import Optional, Union
from typing_extensions import Annotated
from vrt_lss_account.models.process_type import ProcessType
from vrt_lss_account.models.service import Service
from vrt_lss_account.models.user_statistics import UserStatistics

from vrt_lss_account.api_client import ApiClient, RequestSerialized
from vrt_lss_account.api_response import ApiResponse
from vrt_lss_account.rest import RESTResponseType


class StatisticsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def generate_report(
        self,
        var_from: Annotated[Optional[date], Field(description="Date `from` in the YYYY-MM-DD format.")] = None,
        to: Annotated[Optional[date], Field(description="Date `to` (including) in the YYYY-MM-DD format.")] = None,
        service: Annotated[Optional[Service], Field(description="Service name.")] = None,
        process_type: Annotated[Optional[ProcessType], Field(description="Process type.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Report creating

        Creating report with usage statistics. If the period is not specified, records are returned from the beginning of the month to the present day (excluding). If no `from` datetime is specified, data are returned from the beginning of the month. If no `to` datetime is specified, data are returned be the the present day (excluding). Empty service and process type fields mean returning statistics for all services and process types. 

        :param var_from: Date `from` in the YYYY-MM-DD format.
        :type var_from: date
        :param to: Date `to` (including) in the YYYY-MM-DD format.
        :type to: date
        :param service: Service name.
        :type service: Service
        :param process_type: Process type.
        :type process_type: ProcessType
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._generate_report_serialize(
            var_from=var_from,
            to=to,
            service=service,
            process_type=process_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "General400",
            '401': None,
            '402': "General402",
            '403': "General403",
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def generate_report_with_http_info(
        self,
        var_from: Annotated[Optional[date], Field(description="Date `from` in the YYYY-MM-DD format.")] = None,
        to: Annotated[Optional[date], Field(description="Date `to` (including) in the YYYY-MM-DD format.")] = None,
        service: Annotated[Optional[Service], Field(description="Service name.")] = None,
        process_type: Annotated[Optional[ProcessType], Field(description="Process type.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Report creating

        Creating report with usage statistics. If the period is not specified, records are returned from the beginning of the month to the present day (excluding). If no `from` datetime is specified, data are returned from the beginning of the month. If no `to` datetime is specified, data are returned be the the present day (excluding). Empty service and process type fields mean returning statistics for all services and process types. 

        :param var_from: Date `from` in the YYYY-MM-DD format.
        :type var_from: date
        :param to: Date `to` (including) in the YYYY-MM-DD format.
        :type to: date
        :param service: Service name.
        :type service: Service
        :param process_type: Process type.
        :type process_type: ProcessType
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._generate_report_serialize(
            var_from=var_from,
            to=to,
            service=service,
            process_type=process_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "General400",
            '401': None,
            '402': "General402",
            '403': "General403",
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def generate_report_without_preload_content(
        self,
        var_from: Annotated[Optional[date], Field(description="Date `from` in the YYYY-MM-DD format.")] = None,
        to: Annotated[Optional[date], Field(description="Date `to` (including) in the YYYY-MM-DD format.")] = None,
        service: Annotated[Optional[Service], Field(description="Service name.")] = None,
        process_type: Annotated[Optional[ProcessType], Field(description="Process type.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Report creating

        Creating report with usage statistics. If the period is not specified, records are returned from the beginning of the month to the present day (excluding). If no `from` datetime is specified, data are returned from the beginning of the month. If no `to` datetime is specified, data are returned be the the present day (excluding). Empty service and process type fields mean returning statistics for all services and process types. 

        :param var_from: Date `from` in the YYYY-MM-DD format.
        :type var_from: date
        :param to: Date `to` (including) in the YYYY-MM-DD format.
        :type to: date
        :param service: Service name.
        :type service: Service
        :param process_type: Process type.
        :type process_type: ProcessType
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._generate_report_serialize(
            var_from=var_from,
            to=to,
            service=service,
            process_type=process_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "General400",
            '401': None,
            '402': "General402",
            '403': "General403",
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _generate_report_serialize(
        self,
        var_from,
        to,
        service,
        process_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if var_from is not None:
            if isinstance(var_from, date):
                _query_params.append(
                    (
                        'from',
                        var_from.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('from', var_from))
            
        if to is not None:
            if isinstance(to, date):
                _query_params.append(
                    (
                        'to',
                        to.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('to', to))
            
        if service is not None:
            
            _query_params.append(('service', service.value))
            
        if process_type is not None:
            
            _query_params.append(('process_type', process_type.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/octet-stream', 
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/account/report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def generate_statistics(
        self,
        var_from: Annotated[Optional[date], Field(description="Date `from` in the YYYY-MM-DD format.")] = None,
        to: Annotated[Optional[date], Field(description="Date `to` (including) in the YYYY-MM-DD format.")] = None,
        service: Annotated[Optional[Service], Field(description="Service name.")] = None,
        process_type: Annotated[Optional[ProcessType], Field(description="Process type.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UserStatistics:
        """Statistics for the period

        User statistics for the period. If the period is not specified, the statistics for the current month returns (from the beginning of the month to the present day). If no `from` datetime is specified, data are returned from the beginning of the month. If no `to` datetime is specified, data are returned be to the present day (excluding). Empty service and process type fields mean returning statistics for all services and process types. 

        :param var_from: Date `from` in the YYYY-MM-DD format.
        :type var_from: date
        :param to: Date `to` (including) in the YYYY-MM-DD format.
        :type to: date
        :param service: Service name.
        :type service: Service
        :param process_type: Process type.
        :type process_type: ProcessType
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._generate_statistics_serialize(
            var_from=var_from,
            to=to,
            service=service,
            process_type=process_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserStatistics",
            '400': "General400",
            '401': None,
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def generate_statistics_with_http_info(
        self,
        var_from: Annotated[Optional[date], Field(description="Date `from` in the YYYY-MM-DD format.")] = None,
        to: Annotated[Optional[date], Field(description="Date `to` (including) in the YYYY-MM-DD format.")] = None,
        service: Annotated[Optional[Service], Field(description="Service name.")] = None,
        process_type: Annotated[Optional[ProcessType], Field(description="Process type.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UserStatistics]:
        """Statistics for the period

        User statistics for the period. If the period is not specified, the statistics for the current month returns (from the beginning of the month to the present day). If no `from` datetime is specified, data are returned from the beginning of the month. If no `to` datetime is specified, data are returned be to the present day (excluding). Empty service and process type fields mean returning statistics for all services and process types. 

        :param var_from: Date `from` in the YYYY-MM-DD format.
        :type var_from: date
        :param to: Date `to` (including) in the YYYY-MM-DD format.
        :type to: date
        :param service: Service name.
        :type service: Service
        :param process_type: Process type.
        :type process_type: ProcessType
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._generate_statistics_serialize(
            var_from=var_from,
            to=to,
            service=service,
            process_type=process_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserStatistics",
            '400': "General400",
            '401': None,
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def generate_statistics_without_preload_content(
        self,
        var_from: Annotated[Optional[date], Field(description="Date `from` in the YYYY-MM-DD format.")] = None,
        to: Annotated[Optional[date], Field(description="Date `to` (including) in the YYYY-MM-DD format.")] = None,
        service: Annotated[Optional[Service], Field(description="Service name.")] = None,
        process_type: Annotated[Optional[ProcessType], Field(description="Process type.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Statistics for the period

        User statistics for the period. If the period is not specified, the statistics for the current month returns (from the beginning of the month to the present day). If no `from` datetime is specified, data are returned from the beginning of the month. If no `to` datetime is specified, data are returned be to the present day (excluding). Empty service and process type fields mean returning statistics for all services and process types. 

        :param var_from: Date `from` in the YYYY-MM-DD format.
        :type var_from: date
        :param to: Date `to` (including) in the YYYY-MM-DD format.
        :type to: date
        :param service: Service name.
        :type service: Service
        :param process_type: Process type.
        :type process_type: ProcessType
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._generate_statistics_serialize(
            var_from=var_from,
            to=to,
            service=service,
            process_type=process_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserStatistics",
            '400': "General400",
            '401': None,
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _generate_statistics_serialize(
        self,
        var_from,
        to,
        service,
        process_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if var_from is not None:
            if isinstance(var_from, date):
                _query_params.append(
                    (
                        'from',
                        var_from.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('from', var_from))
            
        if to is not None:
            if isinstance(to, date):
                _query_params.append(
                    (
                        'to',
                        to.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('to', to))
            
        if service is not None:
            
            _query_params.append(('service', service.value))
            
        if process_type is not None:
            
            _query_params.append(('process_type', process_type.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/account/statistics',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


