# coding: utf-8

"""
    VRt.Account [AC]

    # Description  Veeroute Account Panel.  ## Entity relationship diagram  ![erd](../uml/account.svg) 

    The version of the OpenAPI document: 7.6.2491
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from vrt_lss_account.models.process_type import ProcessType
from typing import Optional, Set
from typing_extensions import Self

class ProcessStatistics(BaseModel):
    """
    Usage statistics of the service method.
    """ # noqa: E501
    process_type: ProcessType
    unique_points_per_day: Annotated[int, Field(le=100000000, strict=True, ge=0)] = Field(description="Unique points per day.")
    points_per_day: Annotated[int, Field(le=100000000, strict=True, ge=0)] = Field(description="Non-unique points per day.")
    elements_per_day: Annotated[int, Field(le=100000000, strict=True, ge=0)] = Field(description="Non-unique elements of the result per day.")
    processes_per_day: Annotated[int, Field(le=100000000, strict=True, ge=0)] = Field(description="Total number of processes per day.")
    __properties: ClassVar[List[str]] = ["process_type", "unique_points_per_day", "points_per_day", "elements_per_day", "processes_per_day"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProcessStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProcessStatistics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "process_type": obj.get("process_type"),
            "unique_points_per_day": obj.get("unique_points_per_day"),
            "points_per_day": obj.get("points_per_day"),
            "elements_per_day": obj.get("elements_per_day"),
            "processes_per_day": obj.get("processes_per_day")
        })
        return _obj


