from ...forall import *
#######################################################################################################################
# Доверительный интервал для коэффициента корреляции
#######################################################################################################################
def CICC_1(x,y,trust):
    """Пусть (x1,y1);...;(x31,y31)– реализация случайной выборки (X1,Y1);...;(X31,Y31)из двумерного нормального распределения N(μx;μy;σ2x;σ2y;ρ). 
    Используя векторы x⃗ =(x1;...;x31)и y⃗ =(y1;...;y31), постройте асимптотический 0,93-доверительный интервал (θˆ1;θˆ2)для коэффициента корреляции ρ. 
    В ответе укажите: 
    - выборочный коэффициент корреляции ρˆ;
    - верхнюю границу θˆ2построенного доверительного интервала для ρ

    Args:
        x : string
            Строка вектора X, начинающийся с круглых скобок и заканчивающийся круглыми скобками. 
            x1;x2;...;x31
        y : string
            Строка вектора Y, начинающийся с круглых скобок и заканчивающийся круглыми скобками.
            y1;y2;...;y31
        trust : float
            Доверительный уровень
            trust level

    Returns
    -------
    answer : tuple
        (ρˆ, θˆ1, θˆ2)

    """
    import numpy as np
    from scipy.stats import norm

    alpha = 1 - trust

    to_array = lambda x : np.array(x[1:-1].replace(',','.').split('; ')).astype('float')
    x = to_array(x)
    y = to_array(y)

    r = np.corrcoef(x, y)[0,1]

    z = 1/2 * np.log((1 + r) / (1 - r))

    se_z = 1/np.sqrt(len(x) - 3)

    z_alpha_div_2 = norm.ppf(1 - alpha/2)

    inter = np.tanh([z+z_alpha_div_2*se_z,z-z_alpha_div_2*se_z])

    answer = (r, min(inter),max(inter))
    
    print('Выборочный коэффициент корреляции: ', rrstr(answer[0],3))
    print('Верхняя граница доверительного интервала: ', rrstr(answer[2],3))
    print('Нижняя граница доверительного интервала: ', rrstr(answer[1],3))

    return answer
#######################################################################################################################
CICC = [CICC_1]