from ...forall import *
#######################################################################################################################
# Проверка гипотез о значении среднего
#######################################################################################################################
def TMH_1(text,mu_0,mu_1,alpha,splitter = ';',locale = 'rus') -> tuple:
    """Проверка гипотезы об определенном значении ГЕНЕРАЛЬНОГО СРЕДНЕГО ПРИ НЕИЗВЕСТНОЙ ДИСПЕРСИИ на уровне значимости 𝜶.
    Пусть X- =(x1,…,x_n) - реализация случайной выборки X =(X1,…,X_n)
    из нормального распределения N(μ; σ^2).
    Проверяется на уровне значимости α =`alpha` основная гипотеза H0: μ=`mu_0`
    против альтернативной гипотезы H1:μ≠`mu_0` с критическим множеством вида
    Kα = (−∞,-A)∪(A,+∞).
    - Найдите значение статистики критерия  t = T_набл. = T(X- ). 
    - Найдите границу A критического множества. 
    - Найдите P-значение критерия и сделайте выводы.
    - Найдите мощность W критерия для H1:μ= `mu_1`
    
    
    Исходные данные: X- = `text`



    ## Args:
        text (str): Строка перечисления всех чисел, данных как X-
        mu_0 (numerical): Значение среднего при гипотизе H0
        mu_1 (numerical): Значение среднего для W критерия
        alpha (numerical): Уровень значимости
        splitter (str, optional): Разделитель между каждым значением в `text`. Стандартно равно =  ';'.
        locale (str, optional): Локализция данных - если целая и дробная часть каждого числа из `text разделена не запятой, то нужно изменить значение этого параметра на любое другое. Стандартно равно =  'rus'.

    ## Prints
        `answer` каждое значение последовательно.<br>C запятой вместо точки и сокращенное до соответствующего количества десятичных знаков.

    ## Returns:
        `answer` (tuple): Соответствующие значения
    """
    from scipy.stats import t, nct
    
    if locale== 'rus':
        x = np.array(text.replace(',','.').split(splitter)).astype(float)
    else:
        x = np.array(text.split(splitter)).astype(float)
        
    n = x.size

    # Вычисление
    x_bar = np.mean(x)
    s = np.std(x, ddof=1)
    t_stat = (x_bar - mu_0) / (s / np.sqrt(n))

    # Критические значения
    t_critical = t.ppf(1 - alpha/2, df=n-1)  # Критическое значение для уровня alpha
    K_alpha = (-t_critical, t_critical)

    print("Значение статистики критерия = " + one_rrstr(t_stat,3))
    print("Граница А критического множества = " + one_rrstr(t_critical,3))
    print("Гипотеза H0 отвергается." if not (K_alpha[0] <= t_stat <= K_alpha[1]) else "Гипотеза H0 принимается.")


    p_value = 2 * (1 - t.cdf(abs(t_stat), df=n-1))
    print("P-значение критерия = " + one_rrstr(p_value,3) )




    # Параметры для Beta
    delta = (mu_1 - mu_0) / (s / np.sqrt(n))
    
    ##########################
    df=n-1
    G=nct(df,delta)
    T=t(df)
    talpha2=T.isf(alpha/2)
    beta=G.cdf(talpha2)-G.cdf(-talpha2)
    
    power = 1 - beta

    print("Мощность критерия = " + one_rrstr(power,3))
    
    return (t_stat, t_critical, p_value, power)
#######################################################################################################################
def TMH_2(text,sigma,mu_0,mu_1,alpha,splitter = ';',locale = 'rus') -> tuple:
    """Проверка  гипотезы  об  определенном значении  ГЕНЕРАЛЬНОГО СРЕДНЕГО ПРИ ИЗВЕСТНОЙ ДИСПЕРСИИ на уровне значимости 𝜶.
    Пусть X- =(x1,…,x_n) - реализация случайной выборки X =(X1,…,X_n)
    из нормального распределения N(μ;`sigma`^2).
    Проверяется на уровне значимости α =`alpha` основная гипотеза H0: μ=`mu_0`
    против альтернативной гипотезы H1:μ≠`mu_0` с критическим множеством вида
    Kα = (−∞,-A)∪(A,+∞).
    - Найдите значение статистики критерия Z_набл. = Z(X-). 
    - Найдите границу A критического множества. 
    - Найдите P-значение критерия и сделайте выводы.
    - Найдите мощность W критерия для H1:μ= `mu_1`
    
    
    Исходные данные: X- = `text`
    
    
    ## Args:
        text (str): Строка перечисления всех чисел, данных как X-
        sigma (numerical): Стандартное отклонение
        mu_0 (numerical): Значение среднего при гипотизе H0
        mu_1 (numerical): Значение среднего для W критерия
        alpha (numerical): Уровень значимости
        splitter (str, optional): Разделитель между каждым значением в `text`. Стандартно равно =  ';'.
        locale (str, optional): Локализция данных - если целая и дробная часть каждого числа из `text разделена не запятой, то нужно изменить значение этого параметра на любое другое. Стандартно равно =  'rus'.

    ## Prints
        `answer` каждое значение последовательно.<br>C запятой вместо точки и сокращенное до соответствующего количества десятичных знаков.

    ## Returns:
        `answer` (tuple): Соответствующие значения
    """
    from scipy.stats import norm
    
    # Данные
    if locale== 'rus':
        x = np.array(text.replace(',','.').split(splitter)).astype(float)
    else:
        x = np.array(text.split(splitter)).astype(float)

    # Параметры
    n = x.size                # Размер выборки


    # 1. Значение статистики критерия Zнабл.
    x_bar = np.mean(x)        # Среднее выборки
    z_stat = (x_bar - mu_0) / (sigma / np.sqrt(n))
    print(f"Значение статистики критерия = {z_stat:.3f}".replace('.',','))

    # 2. Граница A критического множества
    A = norm.ppf(1 - alpha / 2)
    print(f"Граница A критического множества = {A:.3f}".replace('.',','))

    # 3. P-значение критерия
    p_value = 2 * (1 - norm.cdf(abs(z_stat)))
    print(f"P-значение критерия = {p_value:.3f}".replace('.',','))

    # Вывод по гипотезе
    if abs(z_stat) > A:
        print("Гипотеза H0 отвергается.")
    else:
        print("Гипотеза H0 принимается.")

    # 4. Мощность критерия W
    delta = (mu_1 - mu_0) / (sigma / np.sqrt(n))
    beta = norm.cdf(A - delta) - norm.cdf(-A - delta)
    power = 1 - beta
    print(f"Мощность критерия = {power:.3f}".replace('.',','))
    
    return (z_stat, A, p_value, power)
#######################################################################################################################
TMH = [TMH_1,TMH_2]