# Generated by Django 3.1 on 2020-08-27 12:25

import app_kit.generic
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='GenericField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('field_class', models.CharField(choices=[('BooleanField', 'Checkbox field'), ('CharField', 'Text field'), ('ChoiceField', 'Choice field'), ('DecimalField', 'Decimal number field (fixed precision)'), ('FloatField', 'Floating number field (precision not fixed)'), ('IntegerField', 'Integer field'), ('MultipleChoiceField', 'Multiple choice field'), ('DateTimeJSONField', 'Datetime field'), ('TaxonField', 'Taxon field'), ('PointJSONField', 'Point field'), ('PictureField', 'Image field')], max_length=255)),
                ('render_as', models.CharField(choices=[('CheckboxInput', 'Checkbox'), ('TextInput', 'Single line text input'), ('Textarea', 'Multi-line text input'), ('NumberInput', 'Number field'), ('MobileNumberInput', 'Number input with +/- buttons'), ('HiddenInput', 'Hidden field'), ('Select', 'Dropdown'), ('CheckboxSelectMultiple', 'Multiple choice'), ('RadioSelect', 'Radio'), ('SelectDateTimeWidget', 'Date and time with autofill'), ('MobilePositionInput', 'GPS-supported point input with map'), ('BackboneTaxonAutocompleteWidget', 'Taxon input with backend search'), ('CameraAndAlbumWidget', 'Camera and album')], max_length=255)),
                ('version', models.IntegerField(default=1)),
                ('role', models.CharField(choices=[('temporal_reference', 'Temporal Reference'), ('taxonomic_reference', 'Taxon'), ('geographic_reference', 'Geographic Reference'), ('regular', 'Regular')], default='regular', max_length=50)),
                ('options', models.JSONField(null=True)),
                ('label', models.CharField(max_length=255)),
                ('help_text', models.CharField(max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='GenericFieldToGenericForm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_required', models.BooleanField(default=False)),
                ('is_sticky', models.BooleanField(default=False)),
                ('position', models.IntegerField(default=0)),
                ('generic_field', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='generic_forms.genericfield')),
            ],
            options={
                'ordering': ['position', 'id'],
            },
        ),
        migrations.CreateModel(
            name='GenericValues',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text_value', models.CharField(max_length=255)),
                ('value_type', models.CharField(choices=[('choice', 'Choice')], max_length=20)),
                ('is_default', models.BooleanField(default=False)),
                ('position', models.IntegerField(default=0)),
                ('name', models.CharField(max_length=255)),
                ('generic_field', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='generic_forms.genericfield')),
            ],
            options={
                'ordering': ['position', 'id'],
            },
        ),
        migrations.CreateModel(
            name='GenericForm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('primary_language', models.CharField(max_length=15)),
                ('name', models.CharField(max_length=255, null=True)),
                ('published_version', models.IntegerField(null=True)),
                ('current_version', models.IntegerField(default=1)),
                ('is_locked', models.BooleanField(default=False)),
                ('messages', models.JSONField(null=True)),
                ('global_options', models.JSONField(null=True)),
                ('fields', models.ManyToManyField(through='generic_forms.GenericFieldToGenericForm', to='generic_forms.GenericField')),
            ],
            options={
                'verbose_name': 'Observation form',
                'verbose_name_plural': 'Observation forms',
            },
            bases=(app_kit.generic.GenericContentMethodsMixin, models.Model),
        ),
        migrations.AddField(
            model_name='genericfieldtogenericform',
            name='generic_form',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='generic_forms.genericform'),
        ),
        migrations.AlterUniqueTogether(
            name='genericfieldtogenericform',
            unique_together={('generic_form', 'generic_field')},
        ),
    ]
