from typing import List

from .......Internal.Core import Core
from .......Internal.CommandsGroup import CommandsGroup
from .......Internal.ArgSingleSuppressed import ArgSingleSuppressed
from .......Internal.Types import DataType


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class AverageCls:
	"""Average commands group definition. 2 total commands, 0 Subgroups, 2 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("average", core, parent)

	def fetch(self) -> List[float]:
		"""SCPI: FETCh:WCDMa:MEASurement<instance>:MEValuation:TRACe:MERRor:CHIP:AVERage \n
		Snippet: value: List[float] = driver.wcdmaMeas.multiEval.trace.merror.chip.average.fetch() \n
		Returns the values of the magnitude error vs chip traces, measured in the preselected slot (see method RsCMPX_WcdmaMeas.
		Configure.WcdmaMeas.MultiEval.pslot) . One value per chip is returned. The results of the current, average and maximum
		traces can be retrieved. \n
		Suppressed linked return values: reliability \n
			:return: mag_error_chip: No help available"""
		suppressed = ArgSingleSuppressed(0, DataType.Integer, False, 1, 'Reliability')
		response = self._core.io.query_bin_or_ascii_float_list_suppressed(f'FETCh:WCDMa:MEASurement<Instance>:MEValuation:TRACe:MERRor:CHIP:AVERage?', suppressed)
		return response

	def read(self) -> List[float]:
		"""SCPI: READ:WCDMa:MEASurement<instance>:MEValuation:TRACe:MERRor:CHIP:AVERage \n
		Snippet: value: List[float] = driver.wcdmaMeas.multiEval.trace.merror.chip.average.read() \n
		Returns the values of the magnitude error vs chip traces, measured in the preselected slot (see method RsCMPX_WcdmaMeas.
		Configure.WcdmaMeas.MultiEval.pslot) . One value per chip is returned. The results of the current, average and maximum
		traces can be retrieved. \n
		Suppressed linked return values: reliability \n
			:return: mag_error_chip: No help available"""
		suppressed = ArgSingleSuppressed(0, DataType.Integer, False, 1, 'Reliability')
		response = self._core.io.query_bin_or_ascii_float_list_suppressed(f'READ:WCDMa:MEASurement<Instance>:MEValuation:TRACe:MERRor:CHIP:AVERage?', suppressed)
		return response
