
from typing import List, Optional, Dict, Iterable, Any, overload
import io
import collections.abc
from datetime import datetime
from aspose.pyreflection import Type
import aspose.pycore
import aspose.pydrawing
import aspose.cells
import aspose.cells.charts
import aspose.cells.digitalsignatures
import aspose.cells.drawing
import aspose.cells.drawing.activexcontrols
import aspose.cells.drawing.equations
import aspose.cells.drawing.texts
import aspose.cells.externalconnections
import aspose.cells.json
import aspose.cells.markup
import aspose.cells.metadata
import aspose.cells.numbers
import aspose.cells.ods
import aspose.cells.pivot
import aspose.cells.properties
import aspose.cells.querytables
import aspose.cells.rendering
import aspose.cells.rendering.pdfsecurity
import aspose.cells.revisions
import aspose.cells.saving
import aspose.cells.settings
import aspose.cells.slicers
import aspose.cells.slides
import aspose.cells.tables
import aspose.cells.timelines
import aspose.cells.utility
import aspose.cells.vba
import aspose.cells.webextensions

class AboveAverage:
    '''Describe the AboveAverage conditional formatting rule.
    This conditional formatting rule highlights cells that
    are above or below the average for all values in the range.'''
    
    @property
    def is_above_average(self) -> bool:
        '''Get or set the flag indicating whether the rule is an "above average" rule.
        \'true\' indicates \'above average\'.
        Default value is true.'''
        raise NotImplementedError()
    
    @is_above_average.setter
    def is_above_average(self, value : bool) -> None:
        '''Get or set the flag indicating whether the rule is an "above average" rule.
        \'true\' indicates \'above average\'.
        Default value is true.'''
        raise NotImplementedError()
    
    @property
    def is_equal_average(self) -> bool:
        '''Get or set the flag indicating whether the \'aboveAverage\' and \'belowAverage\' criteria
        is inclusive of the average itself, or exclusive of that value.
        \'true\' indicates to include the average value in the criteria.
        Default value is false.'''
        raise NotImplementedError()
    
    @is_equal_average.setter
    def is_equal_average(self, value : bool) -> None:
        '''Get or set the flag indicating whether the \'aboveAverage\' and \'belowAverage\' criteria
        is inclusive of the average itself, or exclusive of that value.
        \'true\' indicates to include the average value in the criteria.
        Default value is false.'''
        raise NotImplementedError()
    
    @property
    def std_dev(self) -> int:
        '''Get or set the number of standard deviations to include above or below the average in the
        conditional formatting rule.
        The input value must between 0 and 3 (include 0 and 3).
        Setting this value to 0 means stdDev is not set.
        The default value is 0.'''
        raise NotImplementedError()
    
    @std_dev.setter
    def std_dev(self, value : int) -> None:
        '''Get or set the number of standard deviations to include above or below the average in the
        conditional formatting rule.
        The input value must between 0 and 3 (include 0 and 3).
        Setting this value to 0 means stdDev is not set.
        The default value is 0.'''
        raise NotImplementedError()
    

class AbstractCalculationEngine:
    '''Represents user\'s custom calculation engine to extend the default calculation engine of Aspose.Cells.'''
    
    def calculate(self, data : aspose.cells.CalculationData) -> None:
        '''Calculates one function with given data.
        
        :param data: the required data to calculate function such as function name, parameters, ...etc.'''
        raise NotImplementedError()
    
    def force_recalculate(self, function_name : str) -> bool:
        raise NotImplementedError()
    
    @property
    def is_param_literal_required(self) -> bool:
        '''Indicates whether this engine needs the literal text of parameter while doing calculation. Default value is false.'''
        raise NotImplementedError()
    
    @property
    def is_param_array_mode_required(self) -> bool:
        '''Indicates whether this engine needs the parameter to be calculated in array mode. Default value is false.
        If :py:func:`aspose.cells.CalculationData.get_param_value_in_array_mode` is required when calculating custom
        functions and user has not updated the definition for them
        (by :py:func:`aspose.cells.Workbook.update_custom_function_definition`),
        this property needs to be set as true.'''
        raise NotImplementedError()
    
    @property
    def process_built_in_functions(self) -> bool:
        '''Whether built-in functions that have been supported by the built-in engine
        should be checked and processed by this implementation.
        Default is false.'''
        raise NotImplementedError()
    

class AbstractCalculationMonitor:
    '''Monitor for user to track the progress of formula calculation.'''
    
    def before_calculate(self, sheet_index : int, row_index : int, col_index : int) -> None:
        '''Implement this method to do business before calculating one cell.
        
        :param sheet_index: Index of the sheet that the cell belongs to.
        :param row_index: Row index of the cell
        :param col_index: Column index of the cell'''
        raise NotImplementedError()
    
    def after_calculate(self, sheet_index : int, row_index : int, col_index : int) -> None:
        '''Implement this method to do business after one cell has been calculated.
        
        :param sheet_index: Index of the sheet that the cell belongs to.
        :param row_index: Row index of the cell
        :param col_index: Column index of the cell'''
        raise NotImplementedError()
    
    def on_circular(self, circular_cells_data : collections.abc.Iterator[Any]) -> bool:
        '''Implement this method to do business when calculating formulas with circular references.
        
        :param circular_cells_data: IEnumerator with :py:class:`aspose.cells.CalculationCell` items representing cells that
        depend on circular references.
        :returns: Whether the formula engine needs to calculate those cells in circular after this call.
        True to let the formula engine continue to do calculation for them.
        False to let the formula engine just mark those cells as Calculated.'''
        raise NotImplementedError()
    
    @property
    def original_value(self) -> Any:
        '''Gets the old value of the calculated cell.
        Should be used only in :py:func:`aspose.cells.AbstractCalculationMonitor.before_calculate` and :py:func:`aspose.cells.AbstractCalculationMonitor.after_calculate`.'''
        raise NotImplementedError()
    
    @property
    def value_changed(self) -> bool:
        '''Whether the cell\'s value has been changed after the calculation.
        Should be used only in :py:func:`aspose.cells.AbstractCalculationMonitor.after_calculate`.'''
        raise NotImplementedError()
    
    @property
    def calculated_value(self) -> Any:
        '''Gets the newly calculated value of the cell.
        Should be used only in :py:func:`aspose.cells.AbstractCalculationMonitor.after_calculate`.'''
        raise NotImplementedError()
    

class AbstractGlobalizationSettings:
    '''Represents the globalization settings.'''
    
    def compare(self, v1 : str, v2 : str, ignore_case : bool) -> int:
        '''Compares two string values according to certain collation rules.
        
        :param v1: the first string
        :param v2: the second string
        :param ignore_case: whether ignore case when comparing values
        :returns: Integer that indicates the lexical relationship between the two comparands'''
        raise NotImplementedError()
    

class AbstractInterruptMonitor:
    '''Monitor for interruption requests in all time-consuming operations.'''
    
    @property
    def is_interruption_requested(self) -> bool:
        '''Indicates whether interruption is requested for current operation.
        If true then current operation will be interrupted.
        Implementation should perform fast and efficient check here, otherwise it may become another bottleneck for the procedure.'''
        raise NotImplementedError()
    
    @property
    def terminate_without_exception(self) -> bool:
        '''When procedure is interrupted, whether terminate the procedure quietly or throw an Exception.
        Default is false, that is, when :py:attr:`aspose.cells.AbstractInterruptMonitor.is_interruption_requested` is true,
        a :py:class:`aspose.cells.CellsException` with code :py:attr:`aspose.cells.ExceptionType.INTERRUPTED` will be thrown.'''
        raise NotImplementedError()
    

class AbstractTextLoadOptions(LoadOptions):
    '''Common options for loading text values'''
    
    def set_paper_size(self, type : aspose.cells.PaperSizeType) -> None:
        '''Sets the default print paper size from default printer\'s setting.
        
        :param type: The default paper size.'''
        raise NotImplementedError()
    
    @property
    def load_format(self) -> aspose.cells.LoadFormat:
        '''Gets the load format.'''
        raise NotImplementedError()
    
    @property
    def password(self) -> str:
        '''Gets and set the password of the workbook.'''
        raise NotImplementedError()
    
    @password.setter
    def password(self, value : str) -> None:
        '''Gets and set the password of the workbook.'''
        raise NotImplementedError()
    
    @property
    def parsing_formula_on_open(self) -> bool:
        '''Indicates whether parsing the formula when reading the file.'''
        raise NotImplementedError()
    
    @parsing_formula_on_open.setter
    def parsing_formula_on_open(self, value : bool) -> None:
        '''Indicates whether parsing the formula when reading the file.'''
        raise NotImplementedError()
    
    @property
    def parsing_pivot_cached_records(self) -> bool:
        '''Indicates whether parsing pivot cached records when loading the file.
        The default value is false.'''
        raise NotImplementedError()
    
    @parsing_pivot_cached_records.setter
    def parsing_pivot_cached_records(self, value : bool) -> None:
        '''Indicates whether parsing pivot cached records when loading the file.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def language_code(self) -> aspose.cells.CountryCode:
        '''Gets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @language_code.setter
    def language_code(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @property
    def region(self) -> aspose.cells.CountryCode:
        '''Gets the system regional settings based on CountryCode at the time the file was loaded.'''
        raise NotImplementedError()
    
    @region.setter
    def region(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the system regional settings based on CountryCode at the time the file was loaded.'''
        raise NotImplementedError()
    
    @property
    def default_style_settings(self) -> aspose.cells.DefaultStyleSettings:
        '''Gets the default style settings for initializing styles of the workbook'''
        raise NotImplementedError()
    
    @property
    def standard_font(self) -> str:
        '''Sets the default standard font name'''
        raise NotImplementedError()
    
    @standard_font.setter
    def standard_font(self, value : str) -> None:
        '''Sets the default standard font name'''
        raise NotImplementedError()
    
    @property
    def standard_font_size(self) -> float:
        '''Sets the default standard font size.'''
        raise NotImplementedError()
    
    @standard_font_size.setter
    def standard_font_size(self, value : float) -> None:
        '''Sets the default standard font size.'''
        raise NotImplementedError()
    
    @property
    def interrupt_monitor(self) -> aspose.cells.AbstractInterruptMonitor:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.cells.AbstractInterruptMonitor) -> None:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @property
    def ignore_not_printed(self) -> bool:
        '''Ignore the data which are not printed if directly printing the file'''
        raise NotImplementedError()
    
    @ignore_not_printed.setter
    def ignore_not_printed(self, value : bool) -> None:
        '''Ignore the data which are not printed if directly printing the file'''
        raise NotImplementedError()
    
    @property
    def check_data_valid(self) -> bool:
        '''Check whether data is valid in the template file.'''
        raise NotImplementedError()
    
    @check_data_valid.setter
    def check_data_valid(self, value : bool) -> None:
        '''Check whether data is valid in the template file.'''
        raise NotImplementedError()
    
    @property
    def check_excel_restriction(self) -> bool:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @check_excel_restriction.setter
    def check_excel_restriction(self, value : bool) -> None:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @property
    def keep_unparsed_data(self) -> bool:
        '''Whether keep the unparsed data in memory for the Workbook when it is loaded from template file. Default is true.'''
        raise NotImplementedError()
    
    @keep_unparsed_data.setter
    def keep_unparsed_data(self, value : bool) -> None:
        '''Whether keep the unparsed data in memory for the Workbook when it is loaded from template file. Default is true.'''
        raise NotImplementedError()
    
    @property
    def load_filter(self) -> aspose.cells.LoadFilter:
        '''The filter to denote how to load data.'''
        raise NotImplementedError()
    
    @load_filter.setter
    def load_filter(self, value : aspose.cells.LoadFilter) -> None:
        '''The filter to denote how to load data.'''
        raise NotImplementedError()
    
    @property
    def light_cells_data_handler(self) -> aspose.cells.LightCellsDataHandler:
        '''The data handler for processing cells data when reading template file.'''
        raise NotImplementedError()
    
    @light_cells_data_handler.setter
    def light_cells_data_handler(self, value : aspose.cells.LightCellsDataHandler) -> None:
        '''The data handler for processing cells data when reading template file.'''
        raise NotImplementedError()
    
    @property
    def memory_setting(self) -> aspose.cells.MemorySetting:
        '''Gets the memory usage options.'''
        raise NotImplementedError()
    
    @memory_setting.setter
    def memory_setting(self, value : aspose.cells.MemorySetting) -> None:
        '''Sets the memory usage options.'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def auto_fitter_options(self) -> aspose.cells.AutoFitterOptions:
        '''Gets and sets the auto fitter options'''
        raise NotImplementedError()
    
    @auto_fitter_options.setter
    def auto_fitter_options(self, value : aspose.cells.AutoFitterOptions) -> None:
        '''Gets and sets the auto fitter options'''
        raise NotImplementedError()
    
    @property
    def auto_filter(self) -> bool:
        '''Indicates whether auto filtering the data when loading the files.'''
        raise NotImplementedError()
    
    @auto_filter.setter
    def auto_filter(self, value : bool) -> None:
        '''Indicates whether auto filtering the data when loading the files.'''
        raise NotImplementedError()
    
    @property
    def font_configs(self) -> aspose.cells.IndividualFontConfigs:
        '''Gets and sets individual font configs.
        Only works for the :py:class:`aspose.cells.Workbook` which uses this :py:class:`aspose.cells.LoadOptions` to load.'''
        raise NotImplementedError()
    
    @font_configs.setter
    def font_configs(self, value : aspose.cells.IndividualFontConfigs) -> None:
        '''Gets and sets individual font configs.
        Only works for the :py:class:`aspose.cells.Workbook` which uses this :py:class:`aspose.cells.LoadOptions` to load.'''
        raise NotImplementedError()
    
    @property
    def ignore_useless_shapes(self) -> bool:
        '''Indicates whether ignoring useless shapes.'''
        raise NotImplementedError()
    
    @ignore_useless_shapes.setter
    def ignore_useless_shapes(self, value : bool) -> None:
        '''Indicates whether ignoring useless shapes.'''
        raise NotImplementedError()
    
    @property
    def preserve_padding_spaces_in_formula(self) -> bool:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    
    @preserve_padding_spaces_in_formula.setter
    def preserve_padding_spaces_in_formula(self, value : bool) -> None:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    
    @property
    def encoding(self) -> str:
        '''Gets and sets the default encoding. Only applies for csv file.'''
        raise NotImplementedError()
    
    @encoding.setter
    def encoding(self, value : str) -> None:
        '''Gets and sets the default encoding. Only applies for csv file.'''
        raise NotImplementedError()
    
    @property
    def load_style_strategy(self) -> aspose.cells.TxtLoadStyleStrategy:
        '''Indicates the strategy to apply style for parsed values when converting string value to number or datetime.'''
        raise NotImplementedError()
    
    @load_style_strategy.setter
    def load_style_strategy(self, value : aspose.cells.TxtLoadStyleStrategy) -> None:
        '''Indicates the strategy to apply style for parsed values when converting string value to number or datetime.'''
        raise NotImplementedError()
    
    @property
    def convert_numeric_data(self) -> bool:
        '''Gets a value that indicates whether the string in text file is converted to numeric data.'''
        raise NotImplementedError()
    
    @convert_numeric_data.setter
    def convert_numeric_data(self, value : bool) -> None:
        '''Sets a value that indicates whether the string in text file is converted to numeric data.'''
        raise NotImplementedError()
    
    @property
    def convert_date_time_data(self) -> bool:
        '''Gets a value that indicates whether the string in text file is converted to date data.'''
        raise NotImplementedError()
    
    @convert_date_time_data.setter
    def convert_date_time_data(self, value : bool) -> None:
        '''Sets a value that indicates whether the string in text file is converted to date data.'''
        raise NotImplementedError()
    
    @property
    def keep_precision(self) -> bool:
        '''Indicates whether not parsing a string value if the length is 15.'''
        raise NotImplementedError()
    
    @keep_precision.setter
    def keep_precision(self, value : bool) -> None:
        '''Indicates whether not parsing a string value if the length is 15.'''
        raise NotImplementedError()
    

class AdvancedFilter:
    
    @property
    def list_range(self) -> str:
        raise NotImplementedError()
    
    @property
    def criteria_range(self) -> str:
        raise NotImplementedError()
    
    @property
    def copy_to_range(self) -> str:
        raise NotImplementedError()
    

class AutoFilter:
    '''Represents autofiltering for the specified worksheet.'''
    
    @overload
    def remove_filter(self, field_index : int, criteria : str) -> None:
        '''Removes a filter for a filter column.
        
        :param field_index: The integer offset of the field on which you want to base the filter
        (from the left of the list; the leftmost field is field 0).
        :param criteria: The specified criteria (a string; for example, "101").
        It only can be null or be one of the cells\' value in this column.'''
        raise NotImplementedError()
    
    @overload
    def remove_filter(self, field_index : int) -> None:
        '''Remove the specific filter.
        
        :param field_index: The specific filter index'''
        raise NotImplementedError()
    
    @overload
    def custom(self, field_index : int, operator_type1 : aspose.cells.FilterOperatorType, criteria1 : Any) -> None:
        '''Filters a list with a custom criteria.
        
        :param field_index: The integer offset of the field on which you want to base the filter
        (from the left of the list; the leftmost field is field 0).
        :param operator_type1: The filter operator type
        :param criteria1: The custom criteria'''
        raise NotImplementedError()
    
    @overload
    def custom(self, field_index : int, operator_type1 : aspose.cells.FilterOperatorType, criteria1 : Any, is_and : bool, operator_type2 : aspose.cells.FilterOperatorType, criteria2 : Any) -> None:
        '''Filters a list with custom criteria.
        
        :param field_index: The integer offset of the field on which you want to base the filter
        (from the left of the list; the leftmost field is field 0).
        :param operator_type1: The filter operator type
        :param criteria1: The custom criteria
        :param operator_type2: The filter operator type
        :param criteria2: The custom criteria'''
        raise NotImplementedError()
    
    @overload
    def refresh(self) -> List[int]:
        '''Refresh auto filters to hide or unhide the rows.
        
        :returns: Returns all hidden rows\' indexes.'''
        raise NotImplementedError()
    
    @overload
    def refresh(self, hide_rows : bool) -> List[int]:
        '''Gets all hidden rows\' indexes.
        
        :param hide_rows: If true, hide the filtered rows.
        :returns: Returns all hidden rows indexes.'''
        raise NotImplementedError()
    
    def set_range(self, row : int, start_column : int, end_column : int) -> None:
        '''Sets the range to which the specified AutoFilter applies.
        
        :param row: Row index.
        :param start_column: Start column index.
        :param end_column: End column Index.'''
        raise NotImplementedError()
    
    def get_cell_area(self) -> aspose.cells.CellArea:
        '''Gets the :py:class:`aspose.cells.CellArea` where the specified AutoFilter applies to.'''
        raise NotImplementedError()
    
    def add_filter(self, field_index : int, criteria : str) -> None:
        '''Adds a filter for a filter column.
        
        :param field_index: The integer offset of the field on which you want to base the filter
        (from the left of the list; the leftmost field is field 0).
        :param criteria: The specified criteria (a string; for example, "101").
        It only can be null or be one of the cells\' value in this column.'''
        raise NotImplementedError()
    
    def add_date_filter(self, field_index : int, date_time_grouping_type : aspose.cells.DateTimeGroupingType, year : int, month : int, day : int, hour : int, minute : int, second : int) -> None:
        '''Adds a date filter.
        
        :param field_index: The integer offset of the field on which you want to base the filter
        (from the left of the list; the leftmost field is field 0).
        :param date_time_grouping_type: The grouping type
        :param year: The year.
        :param month: The month.
        :param day: The day.
        :param hour: The hour.
        :param minute: The minute.
        :param second: The second.'''
        raise NotImplementedError()
    
    def remove_date_filter(self, field_index : int, date_time_grouping_type : aspose.cells.DateTimeGroupingType, year : int, month : int, day : int, hour : int, minute : int, second : int) -> None:
        '''Removes a date filter.
        
        :param field_index: The integer offset of the field on which you want to base the filter
        (from the left of the list; the leftmost field is field 0).
        :param date_time_grouping_type: The grouping type
        :param year: The year.
        :param month: The month.
        :param day: The day.
        :param hour: The hour.
        :param minute: The minute.
        :param second: The second.'''
        raise NotImplementedError()
    
    def filter(self, field_index : int, criteria : str) -> None:
        '''Filters a list with specified criteria.
        
        :param field_index: The integer offset of the field on which you want to base the filter
        (from the left of the list; the leftmost field is field 0).
        :param criteria: The specified criteria (a string; for example, "101").'''
        raise NotImplementedError()
    
    def filter_top10(self, field_index : int, is_top : bool, is_percent : bool, item_count : int) -> None:
        '''Filter the top 10 item in the list
        
        :param field_index: The integer offset of the field on which you want to base the filter
        (from the left of the list; the leftmost field is field 0).
        :param is_top: Indicates whether filter from top or bottom
        :param is_percent: Indicates whether the items is percent or count
        :param item_count: The item count'''
        raise NotImplementedError()
    
    def dynamic_filter(self, field_index : int, dynamic_filter_type : aspose.cells.DynamicFilterType) -> None:
        '''Adds a dynamic filter.
        
        :param field_index: The integer offset of the field on which you want to base the filter
        (from the left of the list; the leftmost field is field 0).
        :param dynamic_filter_type: Dynamic filter type.'''
        raise NotImplementedError()
    
    def add_font_color_filter(self, field_index : int, color : aspose.cells.CellsColor) -> None:
        '''Adds a font color filter.
        
        :param field_index: The integer offset of the field on which you want to base the filter
        (from the left of the list; the leftmost field is field 0).
        :param color: The :py:class:`aspose.cells.CellsColor` object.'''
        raise NotImplementedError()
    
    def add_fill_color_filter(self, field_index : int, pattern : aspose.cells.BackgroundType, foreground_color : aspose.cells.CellsColor, background_color : aspose.cells.CellsColor) -> None:
        '''Adds a fill color filter.
        
        :param field_index: The integer offset of the field on which you want to base the filter
        (from the left of the list; the leftmost field is field 0).
        :param pattern: The background pattern type.
        :param foreground_color: The foreground color.
        :param background_color: The background color.'''
        raise NotImplementedError()
    
    def add_icon_filter(self, field_index : int, icon_set_type : aspose.cells.IconSetType, icon_id : int) -> None:
        '''Adds an icon filter.
        
        :param field_index: The integer offset of the field on which you want to base the filter
        (from the left of the list; the leftmost field is field 0).
        :param icon_set_type: The icon set type.
        :param icon_id: The icon id.'''
        raise NotImplementedError()
    
    def match_blanks(self, field_index : int) -> None:
        '''Match all blank cell in the list.
        
        :param field_index: The integer offset of the field on which you want to base the filter
        (from the left of the list; the leftmost field is field 0).'''
        raise NotImplementedError()
    
    def match_non_blanks(self, field_index : int) -> None:
        '''Match all not blank cell in the list.
        
        :param field_index: The integer offset of the field on which you want to base the filter
        (from the left of the list; the leftmost field is field 0).'''
        raise NotImplementedError()
    
    def show_all(self) -> None:
        '''Unhide all rows.'''
        raise NotImplementedError()
    
    @property
    def sorter(self) -> aspose.cells.DataSorter:
        '''Gets the data sorter.'''
        raise NotImplementedError()
    
    @property
    def range(self) -> str:
        '''Represents the range to which the specified AutoFilter applies.'''
        raise NotImplementedError()
    
    @range.setter
    def range(self, value : str) -> None:
        '''Represents the range to which the specified AutoFilter applies.'''
        raise NotImplementedError()
    
    @property
    def show_filter_button(self) -> bool:
        '''Indicates whether the AutoFilter button for this column is visible.'''
        raise NotImplementedError()
    
    @show_filter_button.setter
    def show_filter_button(self, value : bool) -> None:
        '''Indicates whether the AutoFilter button for this column is visible.'''
        raise NotImplementedError()
    
    @property
    def filter_columns(self) -> aspose.cells.FilterColumnCollection:
        '''Gets the collection of the filter columns.'''
        raise NotImplementedError()
    

class AutoFitterOptions:
    '''Represents all auto fitter options.'''
    
    @property
    def default_edit_language(self) -> aspose.cells.DefaultEditLanguage:
        '''Gets default edit language.'''
        raise NotImplementedError()
    
    @default_edit_language.setter
    def default_edit_language(self, value : aspose.cells.DefaultEditLanguage) -> None:
        '''Sets default edit language.'''
        raise NotImplementedError()
    
    @property
    def auto_fit_merged_cells(self) -> bool:
        '''Indicates whether auto fit row height when the cells is merged in a row.
        The default value is false.'''
        raise NotImplementedError()
    
    @auto_fit_merged_cells.setter
    def auto_fit_merged_cells(self, value : bool) -> None:
        '''Indicates whether auto fit row height when the cells is merged in a row.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def auto_fit_merged_cells_type(self) -> aspose.cells.AutoFitMergedCellsType:
        '''Gets and set the type of auto fitting row height of merged cells.'''
        raise NotImplementedError()
    
    @auto_fit_merged_cells_type.setter
    def auto_fit_merged_cells_type(self, value : aspose.cells.AutoFitMergedCellsType) -> None:
        '''Gets and set the type of auto fitting row height of merged cells.'''
        raise NotImplementedError()
    
    @property
    def only_auto(self) -> bool:
        '''Indicates whether only fit the rows which height are not customed.'''
        raise NotImplementedError()
    
    @only_auto.setter
    def only_auto(self, value : bool) -> None:
        '''Indicates whether only fit the rows which height are not customed.'''
        raise NotImplementedError()
    
    @property
    def ignore_hidden(self) -> bool:
        '''Ignores the hidden rows/columns.'''
        raise NotImplementedError()
    
    @ignore_hidden.setter
    def ignore_hidden(self, value : bool) -> None:
        '''Ignores the hidden rows/columns.'''
        raise NotImplementedError()
    
    @property
    def max_row_height(self) -> float:
        '''Gets and sets the max row height(in unit of Point) when autofitting rows.'''
        raise NotImplementedError()
    
    @max_row_height.setter
    def max_row_height(self, value : float) -> None:
        '''Gets and sets the max row height(in unit of Point) when autofitting rows.'''
        raise NotImplementedError()
    
    @property
    def auto_fit_wrapped_text_type(self) -> aspose.cells.AutoFitWrappedTextType:
        '''Gets and sets the type of auto fitting wrapped text.'''
        raise NotImplementedError()
    
    @auto_fit_wrapped_text_type.setter
    def auto_fit_wrapped_text_type(self, value : aspose.cells.AutoFitWrappedTextType) -> None:
        '''Gets and sets the type of auto fitting wrapped text.'''
        raise NotImplementedError()
    
    @property
    def format_strategy(self) -> aspose.cells.CellValueFormatStrategy:
        '''Gets and sets the formatted strategy.'''
        raise NotImplementedError()
    
    @format_strategy.setter
    def format_strategy(self, value : aspose.cells.CellValueFormatStrategy) -> None:
        '''Gets and sets the formatted strategy.'''
        raise NotImplementedError()
    
    @property
    def for_rendering(self) -> bool:
        '''Indicates whether fit for rendering purpose.'''
        raise NotImplementedError()
    
    @for_rendering.setter
    def for_rendering(self, value : bool) -> None:
        '''Indicates whether fit for rendering purpose.'''
        raise NotImplementedError()
    

class Border:
    '''Encapsulates the object that represents the cell border.'''
    
    @property
    def theme_color(self) -> aspose.cells.ThemeColor:
        '''Gets and sets the theme color of the border.'''
        raise NotImplementedError()
    
    @theme_color.setter
    def theme_color(self, value : aspose.cells.ThemeColor) -> None:
        '''Gets and sets the theme color of the border.'''
        raise NotImplementedError()
    
    @property
    def color(self) -> aspose.pydrawing.Color:
        '''Gets the :py:class:`aspose.pydrawing.Color` of the border.'''
        raise NotImplementedError()
    
    @color.setter
    def color(self, value : aspose.pydrawing.Color) -> None:
        '''Sets the :py:class:`aspose.pydrawing.Color` of the border.'''
        raise NotImplementedError()
    
    @property
    def argb_color(self) -> int:
        '''Gets and sets the color with a 32-bit ARGB value.'''
        raise NotImplementedError()
    
    @argb_color.setter
    def argb_color(self, value : int) -> None:
        '''Gets and sets the color with a 32-bit ARGB value.'''
        raise NotImplementedError()
    
    @property
    def line_style(self) -> aspose.cells.CellBorderType:
        '''Gets the cell border type.'''
        raise NotImplementedError()
    
    @line_style.setter
    def line_style(self, value : aspose.cells.CellBorderType) -> None:
        '''Sets the cell border type.'''
        raise NotImplementedError()
    

class BorderCollection:
    '''Encapsulates a collection of :py:class:`aspose.cells.Border` objects.'''
    
    def get(self, border_type : aspose.cells.BorderType) -> aspose.cells.Border:
        raise NotImplementedError()
    
    def set_color(self, color : aspose.pydrawing.Color) -> None:
        '''Sets the :py:class:`aspose.pydrawing.Color` of all borders in the collection.
        
        :param color: Borders\' :py:class:`aspose.pydrawing.Color`.'''
        raise NotImplementedError()
    
    def set_style(self, style : aspose.cells.CellBorderType) -> None:
        '''Sets the style of all borders of the collection.
        
        :param style: Borders\' style'''
        raise NotImplementedError()
    
    @property
    def diagonal_color(self) -> aspose.pydrawing.Color:
        '''Gets the :py:class:`aspose.pydrawing.Color` of Diagonal lines.'''
        raise NotImplementedError()
    
    @diagonal_color.setter
    def diagonal_color(self, value : aspose.pydrawing.Color) -> None:
        '''Sets the :py:class:`aspose.pydrawing.Color` of Diagonal lines.'''
        raise NotImplementedError()
    
    @property
    def diagonal_style(self) -> aspose.cells.CellBorderType:
        '''Gets the style of Diagonal lines.'''
        raise NotImplementedError()
    
    @diagonal_style.setter
    def diagonal_style(self, value : aspose.cells.CellBorderType) -> None:
        '''Sets the style of Diagonal lines.'''
        raise NotImplementedError()
    

class CalculationCell:
    '''Represents the calculation relevant data about one cell which is being calculated.'''
    
    def set_calculated_value(self, v : Any) -> None:
        '''Sets the calculated value for the cell.'''
        raise NotImplementedError()
    
    @property
    def workbook(self) -> aspose.cells.Workbook:
        '''Gets the Workbook object.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the Worksheet object where the cell is in.'''
        raise NotImplementedError()
    
    @property
    def cell_row(self) -> int:
        '''Gets the row index of the cell.'''
        raise NotImplementedError()
    
    @property
    def cell_column(self) -> int:
        '''Gets the column index of the cell.'''
        raise NotImplementedError()
    
    @property
    def cell(self) -> aspose.cells.Cell:
        '''Gets the Cell object which is being calculated.'''
        raise NotImplementedError()
    

class CalculationData:
    '''Represents the required data when calculating one function, such as function name, parameters, ...etc.'''
    
    def get_param_value(self, index : int) -> Any:
        '''Gets the represented value object of the parameter at given index.
        
        :param index: The index of the parameter(0 based)
        :returns: The calculated value of the parameter.'''
        raise NotImplementedError()
    
    def get_param_value_in_array_mode(self, index : int, max_row_count : int, max_column_count : int) -> List[List[Any]]:
        '''Gets the value(s) of the parameter at given index.
        If the parameter is some kind of expression that needs to be calculated,
        then it will be calculated in array mode.
        
        :param index: The index of the parameter(0 based)
        :param max_row_count: The row count limit for the returned array.
        If it is non-positive or greater than the actual row count, then actual row count will be used.
        :param max_column_count: The column count limit for the returned array.
        If it is non-positive or greater than the actual row count, then actual column count will be used.
        :returns: An array which contains all items represented by the specified parameter.'''
        raise NotImplementedError()
    
    def get_param_text(self, index : int) -> str:
        '''Gets the literal text of the parameter at given index.
        
        :param index: index of the parameter(0 based)
        :returns: literal text of the parameter'''
        raise NotImplementedError()
    
    @property
    def calculated_value(self) -> Any:
        '''Gets the calculated value for this function.'''
        raise NotImplementedError()
    
    @calculated_value.setter
    def calculated_value(self, value : Any) -> None:
        '''Sets the calculated value for this function.'''
        raise NotImplementedError()
    
    @property
    def workbook(self) -> aspose.cells.Workbook:
        '''Gets the Workbook object where the function is in.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the Worksheet object where the function is in.'''
        raise NotImplementedError()
    
    @property
    def cell_row(self) -> int:
        '''Gets the row index of the cell where the function is in.'''
        raise NotImplementedError()
    
    @property
    def cell_column(self) -> int:
        '''Gets the column index of the cell where the function is in.'''
        raise NotImplementedError()
    
    @property
    def cell(self) -> aspose.cells.Cell:
        '''Gets the Cell object where the function is in.'''
        raise NotImplementedError()
    
    @property
    def function_name(self) -> str:
        '''Gets the function name to be calculated.'''
        raise NotImplementedError()
    
    @property
    def param_count(self) -> int:
        '''Gets the count of parameters'''
        raise NotImplementedError()
    

class CalculationOptions:
    '''Represents options for calculation.'''
    
    @property
    def ignore_error(self) -> bool:
        '''Indicates whether errors encountered while calculating formulas should be ignored.
        The error may be unsupported function, external links, etc.
        The default value is true.'''
        raise NotImplementedError()
    
    @ignore_error.setter
    def ignore_error(self, value : bool) -> None:
        '''Indicates whether errors encountered while calculating formulas should be ignored.
        The error may be unsupported function, external links, etc.
        The default value is true.'''
        raise NotImplementedError()
    
    @property
    def recursive(self) -> bool:
        '''Indicates whether calculate the dependent cells recursively when calculating one cell and it depends on other cells.
        The default value is true.'''
        raise NotImplementedError()
    
    @recursive.setter
    def recursive(self, value : bool) -> None:
        '''Indicates whether calculate the dependent cells recursively when calculating one cell and it depends on other cells.
        The default value is true.'''
        raise NotImplementedError()
    
    @property
    def custom_engine(self) -> aspose.cells.AbstractCalculationEngine:
        '''The custom formula calculation engine to extend the default calculation engine of Aspose.Cells.'''
        raise NotImplementedError()
    
    @custom_engine.setter
    def custom_engine(self, value : aspose.cells.AbstractCalculationEngine) -> None:
        '''The custom formula calculation engine to extend the default calculation engine of Aspose.Cells.'''
        raise NotImplementedError()
    
    @property
    def calculation_monitor(self) -> aspose.cells.AbstractCalculationMonitor:
        '''The monitor for user to track the progress of formula calculation.'''
        raise NotImplementedError()
    
    @calculation_monitor.setter
    def calculation_monitor(self, value : aspose.cells.AbstractCalculationMonitor) -> None:
        '''The monitor for user to track the progress of formula calculation.'''
        raise NotImplementedError()
    
    @property
    def calc_stack_size(self) -> int:
        '''The stack size for calculating cells recursively. Default value is 200.'''
        raise NotImplementedError()
    
    @calc_stack_size.setter
    def calc_stack_size(self, value : int) -> None:
        '''The stack size for calculating cells recursively. Default value is 200.'''
        raise NotImplementedError()
    
    @property
    def precision_strategy(self) -> aspose.cells.CalculationPrecisionStrategy:
        '''Specifies the strategy for processing precision of calculation.'''
        raise NotImplementedError()
    
    @precision_strategy.setter
    def precision_strategy(self, value : aspose.cells.CalculationPrecisionStrategy) -> None:
        '''Specifies the strategy for processing precision of calculation.'''
        raise NotImplementedError()
    
    @property
    def linked_data_sources(self) -> List[aspose.cells.Workbook]:
        '''Specifies the data sources for external links used in formulas.'''
        raise NotImplementedError()
    
    @linked_data_sources.setter
    def linked_data_sources(self, value : List[aspose.cells.Workbook]) -> None:
        '''Specifies the data sources for external links used in formulas.'''
        raise NotImplementedError()
    
    @property
    def character_encoding(self) -> str:
        '''Specifies the encoding used for encoding/decoding characters when calculating formulas.
        For functions such as CHAR, CODE, the calculated result depends on the region settings and default charset of the environment.
        With this property user can specify the proper encoding used for those function to get the expected result.'''
        raise NotImplementedError()
    
    @character_encoding.setter
    def character_encoding(self, value : str) -> None:
        '''Specifies the encoding used for encoding/decoding characters when calculating formulas.
        For functions such as CHAR, CODE, the calculated result depends on the region settings and default charset of the environment.
        With this property user can specify the proper encoding used for those function to get the expected result.'''
        raise NotImplementedError()
    

class Cell:
    '''Encapsulates the object that represents a single Workbook cell.'''
    
    @overload
    def put_value(self, bool_value : bool) -> None:
        '''Puts a boolean value into the cell.'''
        raise NotImplementedError()
    
    @overload
    def put_value(self, int_value : int) -> None:
        '''Puts an integer value into the cell.
        
        :param int_value: Input value'''
        raise NotImplementedError()
    
    @overload
    def put_value(self, double_value : float) -> None:
        '''Puts a double value into the cell.
        
        :param double_value: Input value'''
        raise NotImplementedError()
    
    @overload
    def put_value(self, string_value : str, is_converted : bool, set_style : bool) -> None:
        '''Puts a value into the cell, if appropriate the value will be converted to other data type and cell\'s number format will be reset.
        
        :param string_value: Input value
        :param is_converted: True: converted to other data type if appropriate.
        :param set_style: True: set the number format to cell\'s style when converting to other data type'''
        raise NotImplementedError()
    
    @overload
    def put_value(self, string_value : str, is_converted : bool) -> None:
        '''Puts a string value into the cell and converts the value to other data type if appropriate.
        
        :param string_value: Input value
        :param is_converted: True: converted to other data type if appropriate.'''
        raise NotImplementedError()
    
    @overload
    def put_value(self, string_value : str) -> None:
        '''Puts a string value into the cell.
        
        :param string_value: Input value'''
        raise NotImplementedError()
    
    @overload
    def put_value(self, date_time : datetime) -> None:
        '''Puts a DateTime value into the cell.
        
        :param date_time: Input value'''
        raise NotImplementedError()
    
    @overload
    def put_value(self, object_value : Any) -> None:
        '''Puts an object value into the cell.
        
        :param object_value: input value'''
        raise NotImplementedError()
    
    @overload
    def get_display_style(self) -> aspose.cells.Style:
        '''Gets the display style of the cell.
        If this cell is also affected by other settings such as conditional formatting, list objects, etc.,
        then the display style may be different from cell.GetStyle().'''
        raise NotImplementedError()
    
    @overload
    def get_display_style(self, include_merged_borders : bool) -> aspose.cells.Style:
        '''Gets the display style of the cell.
        If the cell is conditional formatted, the display style is not same as the cell.GetStyle().
        
        :param include_merged_borders: Indicates whether checking borders of the merged cells.'''
        raise NotImplementedError()
    
    @overload
    def get_style(self) -> aspose.cells.Style:
        '''Gets the cell style.
        
        :returns: Style object.'''
        raise NotImplementedError()
    
    @overload
    def get_style(self, check_borders : bool) -> aspose.cells.Style:
        '''If checkBorders is true, check whether other cells\' borders will effect the style of this cell.
        
        :param check_borders: Check other cells\' borders
        :returns: Style object.'''
        raise NotImplementedError()
    
    @overload
    def set_style(self, style : aspose.cells.Style) -> None:
        '''Sets the cell style.
        
        :param style: The cell style.'''
        raise NotImplementedError()
    
    @overload
    def set_style(self, style : aspose.cells.Style, explicit_flag : bool) -> None:
        '''Apply the changed property of style to the cell.
        
        :param style: The cell style.
        :param explicit_flag: True, only overwriting formatting which is explicitly set.'''
        raise NotImplementedError()
    
    @overload
    def set_style(self, style : aspose.cells.Style, flag : aspose.cells.StyleFlag) -> None:
        '''Apply the cell style based on flags.
        
        :param style: The cell style.
        :param flag: The style flag.'''
        raise NotImplementedError()
    
    @overload
    def set_formula(self, formula : str, value : Any) -> None:
        '''Set the formula and the value(calculated result) of the formula.
        
        :param formula: The formula.
        :param value: The value(calculated result) of the formula.'''
        raise NotImplementedError()
    
    @overload
    def set_formula(self, formula : str, options : aspose.cells.FormulaParseOptions) -> None:
        raise NotImplementedError()
    
    @overload
    def set_formula(self, formula : str, is_r1c1 : bool, is_local : bool, value : Any) -> None:
        '''Set the formula and the value of the formula.
        
        :param formula: The formula.
        :param is_r1c1: Whether the formula is R1C1 formula.
        :param is_local: Whether the formula is locale formatted.
        :param value: The value of the formula.'''
        raise NotImplementedError()
    
    @overload
    def set_formula(self, formula : str, options : aspose.cells.FormulaParseOptions, value : Any) -> None:
        '''Set the formula and the value(calculated result) of the formula.
        
        :param formula: The formula.
        :param options: Options for parsing the formula.
        :param value: The value(calculated result) of the formula.'''
        raise NotImplementedError()
    
    @overload
    def set_array_formula(self, array_formula : str, row_number : int, column_number : int, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets an array formula to a range of cells.
        
        :param array_formula: Array formula.
        :param row_number: Number of rows to populate result of the array formula.
        :param column_number: Number of columns to populate result of the array formula.
        :param is_r1c1: whether the formula is R1C1 formula
        :param is_local: whether the formula is locale formatted'''
        raise NotImplementedError()
    
    @overload
    def set_array_formula(self, array_formula : str, row_number : int, column_number : int) -> None:
        '''Sets an array formula(legacy array formula entered via CTRL+SHIFT+ENTER in ms excel) to a range of cells.
        
        :param array_formula: Array formula.
        :param row_number: Number of rows to populate result of the array formula.
        :param column_number: Number of columns to populate result of the array formula.'''
        raise NotImplementedError()
    
    @overload
    def set_array_formula(self, array_formula : str, row_number : int, column_number : int, options : aspose.cells.FormulaParseOptions) -> None:
        '''Sets an array formula to a range of cells.
        
        :param array_formula: Array formula.
        :param row_number: Number of rows to populate result of the array formula.
        :param column_number: Number of columns to populate result of the array formula.
        :param options: Options for parsing the formula.'''
        raise NotImplementedError()
    
    @overload
    def set_array_formula(self, array_formula : str, row_number : int, column_number : int, options : aspose.cells.FormulaParseOptions, values : List[List[Any]]) -> None:
        '''Sets an array formula to a range of cells.
        
        :param array_formula: Array formula.
        :param row_number: Number of rows to populate result of the array formula.
        :param column_number: Number of columns to populate result of the array formula.
        :param options: Options for parsing the formula.
        :param values: values for those cells with given array formula'''
        raise NotImplementedError()
    
    @overload
    def set_shared_formula(self, shared_formula : str, row_number : int, column_number : int, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets a formula to a range of cells.
        
        :param shared_formula: Shared formula.
        :param row_number: Number of rows to populate the formula.
        :param column_number: Number of columns to populate the formula.
        :param is_r1c1: whether the formula is R1C1 formula
        :param is_local: whether the formula is locale formatted'''
        raise NotImplementedError()
    
    @overload
    def set_shared_formula(self, shared_formula : str, row_number : int, column_number : int) -> None:
        '''Sets shared formulas to a range of cells.
        
        :param shared_formula: Shared formula.
        :param row_number: Number of rows to populate the formula.
        :param column_number: Number of columns to populate the formula.'''
        raise NotImplementedError()
    
    @overload
    def set_shared_formula(self, shared_formula : str, row_number : int, column_number : int, options : aspose.cells.FormulaParseOptions) -> None:
        '''Sets shared formulas to a range of cells.
        
        :param shared_formula: Shared formula.
        :param row_number: Number of rows to populate the formula.
        :param column_number: Number of columns to populate the formula.
        :param options: Options for parsing the formula.'''
        raise NotImplementedError()
    
    @overload
    def set_shared_formula(self, shared_formula : str, row_number : int, column_number : int, options : aspose.cells.FormulaParseOptions, values : List[List[Any]]) -> None:
        '''Sets shared formulas to a range of cells.
        
        :param shared_formula: Shared formula.
        :param row_number: Number of rows to populate the formula.
        :param column_number: Number of columns to populate the formula.
        :param options: Options for parsing the formula.
        :param values: values for those cells with given shared formula'''
        raise NotImplementedError()
    
    @overload
    def get_leafs(self) -> collections.abc.Iterator[Any]:
        '''Get all cells which reference to this cell directly and need to be updated when this cell is modified.
        
        :returns: Enumerator to enumerate all dependents(Cell)'''
        raise NotImplementedError()
    
    @overload
    def get_leafs(self, recursive : bool) -> collections.abc.Iterator[Any]:
        '''Get all cells which will be updated when this cell is modified.
        
        :param recursive: Whether returns those leafs that do not reference to this cell directly
        but reference to other leafs of this cell
        :returns: Enumerator to enumerate all dependents(Cell)'''
        raise NotImplementedError()
    
    @overload
    def set_dynamic_array_formula(self, array_formula : str, options : aspose.cells.FormulaParseOptions, calculate_value : bool) -> aspose.cells.CellArea:
        '''Sets dynamic array formula and make the formula spill into neighboring cells if possible.
        
        :param array_formula: the formula expression
        :param options: options to parse formula.
        "Parse" option will be ignored and the formula will always be parsed immediately
        :param calculate_value: whether calculate this dynamic array formula for those cells in the spilled range.
        :returns: the range that the formula should spill into.'''
        raise NotImplementedError()
    
    @overload
    def set_dynamic_array_formula(self, array_formula : str, options : aspose.cells.FormulaParseOptions, values : List[List[Any]], calculate_range : bool, calculate_value : bool) -> aspose.cells.CellArea:
        '''Sets dynamic array formula and make the formula spill into neighboring cells if possible.
        
        :param array_formula: the formula expression
        :param options: options to parse formula.
        "Parse" option will be ignored and the formula will always be parsed immediately
        :param values: values(calculated results) for those cells with given dynamic array formula
        :param calculate_range: Whether calculate the spilled range for this dynamic array formula.
        If the "values" parameter is not null and this flag is false,
        then the spilled range\'s height will be values.Length and width will be values[0].Length.
        :param calculate_value: whether calculate this dynamic array formula for those cells in the spilled range when "values" is null
        or corresponding item in "values" for one cell is null.
        :returns: the range that the formula should spill into.'''
        raise NotImplementedError()
    
    @overload
    def set_dynamic_array_formula(self, array_formula : str, options : aspose.cells.FormulaParseOptions, values : List[List[Any]], calculate_range : bool, calculate_value : bool, copts : aspose.cells.CalculationOptions) -> aspose.cells.CellArea:
        '''Sets dynamic array formula and make the formula spill into neighboring cells if possible.
        
        :param array_formula: the formula expression
        :param options: options to parse formula.
        "Parse" option will be ignored and the formula will always be parsed immediately
        :param values: values(calculated results) for those cells with given dynamic array formula
        :param calculate_range: Whether calculate the spilled range for this dynamic array formula.
        If the "values" parameter is not null and this flag is false,
        then the spilled range\'s height will be values.Length and width will be values[0].Length.
        :param calculate_value: whether calculate this dynamic array formula for those cells in the spilled range when "values" is null
        or corresponding item in "values" for one cell is null.
        :param copts: The options for calculating formula.
        Commonly, for performance consideration, the :py:attr:`aspose.cells.CalculationOptions.recursive` property should be false.
        :returns: the range that the formula should spill into.'''
        raise NotImplementedError()
    
    @overload
    def set_table_formula(self, row_number : int, column_number : int, row_input_cell : str, column_input_cell : str, values : List[List[Any]]) -> None:
        '''Create two-variable data table for given range starting from this cell.
        
        :param row_number: Number of rows to populate the formula.
        :param column_number: Number of columns to populate the formula.
        :param row_input_cell: the row input cell
        :param column_input_cell: the column input cell
        :param values: values for cells in table formula range'''
        raise NotImplementedError()
    
    @overload
    def set_table_formula(self, row_number : int, column_number : int, input_cell : str, is_row_input : bool, values : List[List[Any]]) -> None:
        '''Create one-variable data table for given range starting from this cell.
        
        :param row_number: Number of rows to populate the formula.
        :param column_number: Number of columns to populate the formula.
        :param input_cell: the input cell
        :param is_row_input: Indicates whether the input cell is a row input cell(true) or a column input cell(false).
        :param values: values for cells in table formula range'''
        raise NotImplementedError()
    
    @overload
    def set_table_formula(self, row_number : int, column_number : int, row_index_of_row_input_cell : int, column_index_of_row_input_cell : int, row_index_of_column_input_cell : int, column_index_of_column_input_cell : int, values : List[List[Any]]) -> None:
        '''Create two-variable data table for given range starting from this cell.
        
        :param row_number: Number of rows to populate the formula.
        :param column_number: Number of columns to populate the formula.
        :param row_index_of_row_input_cell: row index of the row input cell
        :param column_index_of_row_input_cell: column index of the row input cell
        :param row_index_of_column_input_cell: row index of the column input cell
        :param column_index_of_column_input_cell: column index of the column input cell
        :param values: values for cells in table formula range'''
        raise NotImplementedError()
    
    @overload
    def set_table_formula(self, row_number : int, column_number : int, row_index_of_input_cell : int, column_index_of_input_cell : int, is_row_input : bool, values : List[List[Any]]) -> None:
        '''Create one-variable data table for given range starting from this cell.
        
        :param row_number: Number of rows to populate the formula.
        :param column_number: Number of columns to populate the formula.
        :param row_index_of_input_cell: row index of the input cell
        :param column_index_of_input_cell: column index of the input cell
        :param is_row_input: Indicates whether the input cell is a row input cell(true) or a column input cell(false).
        :param values: values for cells in table formula range'''
        raise NotImplementedError()
    
    @overload
    def get_characters(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the cell text.
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    @overload
    def get_characters(self, flag : bool) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the cell text.
        
        :param flag: Indicates whether applying table style to the cell if the cell is in the table.
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def calculate(self, options : aspose.cells.CalculationOptions) -> None:
        '''Calculates the formula of the cell.
        
        :param options: Options for calculation'''
        raise NotImplementedError()
    
    def get_string_value(self, format_strategy : aspose.cells.CellValueFormatStrategy) -> str:
        '''Gets the string value by specific formatted strategy.
        
        :param format_strategy: The formatted strategy.'''
        raise NotImplementedError()
    
    def get_width_of_value(self) -> int:
        '''Gets the width of the value in unit of pixels.'''
        raise NotImplementedError()
    
    def get_height_of_value(self) -> int:
        '''Gets the height of the value in unit of pixels.'''
        raise NotImplementedError()
    
    def get_format_conditions(self) -> List[aspose.cells.FormatConditionCollection]:
        '''Gets format conditions which applies to this cell.
        
        :returns: Returns :py:class:`aspose.cells.FormatConditionCollection` object'''
        raise NotImplementedError()
    
    def get_formula(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Get the formula of this cell.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: the formula of this cell.'''
        raise NotImplementedError()
    
    def get_precedents(self) -> aspose.cells.ReferredAreaCollection:
        '''Gets all references appearing in this cell\'s formula.
        
        :returns: Collection of all references appearing in this cell\'s formula.'''
        raise NotImplementedError()
    
    def get_dependents(self, is_all : bool) -> List[aspose.cells.Cell]:
        '''Get all cells whose formula references to this cell directly.
        
        :param is_all: Indicates whether check formulas in other worksheets'''
        raise NotImplementedError()
    
    def get_precedents_in_calculation(self) -> collections.abc.Iterator[Any]:
        '''Gets all precedents(reference to cells in current workbook) used by this cell\'s formula while calculating it.
        
        :returns: Enumerator to enumerate all references(ReferredArea)'''
        raise NotImplementedError()
    
    def get_dependents_in_calculation(self, recursive : bool) -> collections.abc.Iterator[Any]:
        '''Gets all cells whose calculated result depends on this cell.
        
        :param recursive: Whether returns those dependents which do not reference to this cell directly
        but reference to other leafs of this cell
        :returns: Enumerator to enumerate all dependents(Cell objects)'''
        raise NotImplementedError()
    
    def get_array_range(self) -> aspose.cells.CellArea:
        '''Gets the array range if the cell\'s formula is an array formula.
        
        :returns: The array range.'''
        raise NotImplementedError()
    
    def remove_array_formula(self, leave_normal_formula : bool) -> None:
        '''Remove array formula.
        
        :param leave_normal_formula: True represents converting the array formula to normal formula.'''
        raise NotImplementedError()
    
    def copy(self, cell : aspose.cells.Cell) -> None:
        '''Copies data from a source cell.
        
        :param cell: Source :py:class:`aspose.cells.Cell` object.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the cell text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def replace(self, place_holder : str, new_value : str, options : aspose.cells.ReplaceOptions) -> None:
        '''Replace text of the cell with options.
        
        :param place_holder: Cell placeholder
        :param new_value: String value to replace
        :param options: The replace options'''
        raise NotImplementedError()
    
    def insert_text(self, index : int, text : str) -> None:
        '''Insert some characters to the cell.
        If the cell is rich formatted, this method could keep the original formatting.
        
        :param index: The index.
        :param text: Inserted text.'''
        raise NotImplementedError()
    
    def is_rich_text(self) -> bool:
        '''Indicates whether the string value of this cell is a rich formatted text.'''
        raise NotImplementedError()
    
    def set_characters(self, characters : List[aspose.cells.FontSetting]) -> None:
        '''Sets rich text format of the cell.
        
        :param characters: All Characters objects.'''
        raise NotImplementedError()
    
    def get_merged_range(self) -> aspose.cells.Range:
        '''Returns a :py:class:`aspose.cells.Range` object which represents a merged range.
        
        :returns: :py:class:`aspose.cells.Range` object. Null if this cell is not merged.'''
        raise NotImplementedError()
    
    def get_html_string(self, html5 : bool) -> str:
        '''Gets the html string which contains data and some formats in this cell.
        
        :param html5: Indicates whether the value is compatible for html5'''
        raise NotImplementedError()
    
    def to_json(self) -> str:
        '''Convert :py:class:`aspose.cells.Cell` to JSON struct data.'''
        raise NotImplementedError()
    
    def equals(self, cell : aspose.cells.Cell) -> bool:
        '''Checks whether this object refers to the same cell with another cell object.
        
        :param cell: another cell object
        :returns: true if two cell objects refers to the same cell.'''
        raise NotImplementedError()
    
    def get_conditional_formatting_result(self) -> aspose.cells.ConditionalFormattingResult:
        '''Get the result of the conditional formatting.'''
        raise NotImplementedError()
    
    def get_validation(self) -> aspose.cells.Validation:
        '''Gets the validation applied to this cell.'''
        raise NotImplementedError()
    
    def get_validation_value(self) -> bool:
        '''Gets the value of validation which applied to this cell.'''
        raise NotImplementedError()
    
    def get_table(self) -> aspose.cells.tables.ListObject:
        '''Gets the table which contains this cell.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the parent worksheet.'''
        raise NotImplementedError()
    
    @property
    def date_time_value(self) -> datetime:
        '''Gets the DateTime value contained in the cell.'''
        raise NotImplementedError()
    
    @property
    def row(self) -> int:
        '''Gets row number (zero based) of the cell.'''
        raise NotImplementedError()
    
    @property
    def column(self) -> int:
        '''Gets column number (zero based) of the cell.'''
        raise NotImplementedError()
    
    @property
    def is_formula(self) -> bool:
        '''Represents if the specified cell contains formula.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.CellValueType:
        '''Represents cell value type.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets the name of the cell.'''
        raise NotImplementedError()
    
    @property
    def is_error_value(self) -> bool:
        '''Checks if the value of this cell is an error.'''
        raise NotImplementedError()
    
    @property
    def is_numeric_value(self) -> bool:
        '''Indicates whether the value of this cell is numeric(int, double and datetime)'''
        raise NotImplementedError()
    
    @property
    def string_value(self) -> str:
        '''Gets the string value contained in the cell. If the type of this cell is string, then return the string value itself.
        For other cell types, the formatted string value (formatted with the specified style of this cell) will be returned.
        The formatted cell value is same with what you can get from excel when copying a cell as text(such as
        copying cell to text editor or exporting to csv).'''
        raise NotImplementedError()
    
    @property
    def string_value_without_format(self) -> str:
        '''Gets cell\'s value as string without any format.'''
        raise NotImplementedError()
    
    @property
    def number_category_type(self) -> aspose.cells.NumberCategoryType:
        '''Represents the category type of this cell\'s number formatting.'''
        raise NotImplementedError()
    
    @property
    def display_string_value(self) -> str:
        '''Gets the formatted string value of this cell by cell\'s display style.'''
        raise NotImplementedError()
    
    @property
    def int_value(self) -> int:
        '''Gets the integer value contained in the cell.'''
        raise NotImplementedError()
    
    @property
    def double_value(self) -> float:
        '''Gets the double value contained in the cell.'''
        raise NotImplementedError()
    
    @property
    def float_value(self) -> float:
        '''Gets the float value contained in the cell.'''
        raise NotImplementedError()
    
    @property
    def bool_value(self) -> bool:
        '''Gets the boolean value contained in the cell.'''
        raise NotImplementedError()
    
    @property
    def has_custom_style(self) -> bool:
        '''Indicates whether this cell has custom style settings(different from the default one inherited
        from corresponding row, column, or workbook).'''
        raise NotImplementedError()
    
    @property
    def shared_style_index(self) -> int:
        '''Gets cell\'s shared style index in the style pool.'''
        raise NotImplementedError()
    
    @property
    def formula(self) -> str:
        '''Gets a formula of the :py:class:`aspose.cells.Cell`.'''
        raise NotImplementedError()
    
    @formula.setter
    def formula(self, value : str) -> None:
        '''Sets a formula of the :py:class:`aspose.cells.Cell`.'''
        raise NotImplementedError()
    
    @property
    def formula_local(self) -> str:
        '''Get the locale formatted formula of the cell.'''
        raise NotImplementedError()
    
    @formula_local.setter
    def formula_local(self, value : str) -> None:
        '''Get the locale formatted formula of the cell.'''
        raise NotImplementedError()
    
    @property
    def r1c1_formula(self) -> str:
        '''Gets a R1C1 formula of the :py:class:`aspose.cells.Cell`.'''
        raise NotImplementedError()
    
    @r1c1_formula.setter
    def r1c1_formula(self, value : str) -> None:
        '''Sets a R1C1 formula of the :py:class:`aspose.cells.Cell`.'''
        raise NotImplementedError()
    
    @property
    def contains_external_link(self) -> bool:
        '''Indicates whether this cell contains an external link.
        Only applies when the cell is a formula cell.'''
        raise NotImplementedError()
    
    @property
    def is_array_header(self) -> bool:
        '''Indicates the cell\'s formula is an array formula
        and it is the first cell of the array.'''
        raise NotImplementedError()
    
    @property
    def is_dynamic_array_formula(self) -> bool:
        '''Indicates whether the cell\'s formula is dynamic array formula(true) or legacy array formula(false).'''
        raise NotImplementedError()
    
    @property
    def is_array_formula(self) -> bool:
        '''Indicates whether the cell formula is an array formula.'''
        raise NotImplementedError()
    
    @property
    def is_in_array(self) -> bool:
        '''Indicates whether the cell formula is an array formula.'''
        raise NotImplementedError()
    
    @property
    def is_shared_formula(self) -> bool:
        '''Indicates whether the cell formula is part of shared formula.'''
        raise NotImplementedError()
    
    @property
    def is_table_formula(self) -> bool:
        '''Indicates whether this cell is part of table formula.'''
        raise NotImplementedError()
    
    @property
    def is_in_table(self) -> bool:
        '''Indicates whether this cell is part of table formula.'''
        raise NotImplementedError()
    
    @property
    def value(self) -> Any:
        '''Gets/sets the value contained in this cell.'''
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : Any) -> None:
        '''Gets/sets the value contained in this cell.'''
        raise NotImplementedError()
    
    @property
    def is_style_set(self) -> bool:
        '''Indicates if the cell\'s style is set. If return false, it means this cell has a default cell format.'''
        raise NotImplementedError()
    
    @property
    def is_merged(self) -> bool:
        '''Checks if a cell is part of a merged range or not.'''
        raise NotImplementedError()
    
    @property
    def comment(self) -> aspose.cells.Comment:
        '''Gets the comment of this cell.'''
        raise NotImplementedError()
    
    @property
    def html_string(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this cell.'''
        raise NotImplementedError()
    
    @html_string.setter
    def html_string(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this cell.'''
        raise NotImplementedError()
    
    @property
    def is_check_box_style(self) -> bool:
        raise NotImplementedError()
    
    @is_check_box_style.setter
    def is_check_box_style(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def embedded_image(self) -> List[int]:
        raise NotImplementedError()
    
    @embedded_image.setter
    def embedded_image(self, value : List[int]) -> None:
        raise NotImplementedError()
    

class CellArea:
    '''Represent an area of cells.'''
    
    @overload
    @staticmethod
    def create_cell_area(start_row : int, start_column : int, end_row : int, end_column : int) -> aspose.cells.CellArea:
        '''Creates a cell area.
        
        :param start_row: The start row.
        :param start_column: The start column.
        :param end_row: The end row.
        :param end_column: The end column.
        :returns: Return a :py:class:`aspose.cells.CellArea`.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_cell_area(start_cell_name : str, end_cell_name : str) -> aspose.cells.CellArea:
        '''Creates a cell area.
        
        :param start_cell_name: The top-left cell of the range.
        :param end_cell_name: The bottom-right cell of the range.
        :returns: Return a :py:class:`aspose.cells.CellArea`.'''
        raise NotImplementedError()
    
    def compare_to(self, obj : Any) -> int:
        '''Compare two CellArea objects according to their top-left corner.
        
        :returns: If two corners are in different rows, then compare their row index. Otherwise compare their column index.
        If two corners are same, then 0 will be returned.'''
        raise NotImplementedError()
    
    @property
    def start_row(self) -> int:
        '''Gets or set the start row of this area.'''
        raise NotImplementedError()
    
    @start_row.setter
    def start_row(self, value : int) -> None:
        '''Set the start row of this area.'''
        raise NotImplementedError()
    
    @property
    def end_row(self) -> int:
        '''Gets or set the end row of this area.'''
        raise NotImplementedError()
    
    @end_row.setter
    def end_row(self, value : int) -> None:
        '''Set the end row of this area.'''
        raise NotImplementedError()
    
    @property
    def start_column(self) -> int:
        '''Gets or set the start column of this area.'''
        raise NotImplementedError()
    
    @start_column.setter
    def start_column(self, value : int) -> None:
        '''Set the start column of this area.'''
        raise NotImplementedError()
    
    @property
    def end_column(self) -> int:
        '''Gets or set the end column of this area.'''
        raise NotImplementedError()
    
    @end_column.setter
    def end_column(self, value : int) -> None:
        '''Set the end column of this area.'''
        raise NotImplementedError()
    

class CellValue:
    '''Represents the cell value and corresponding type.'''
    
    @property
    def type(self) -> aspose.cells.CellValueType:
        '''Gets/sets the type of cell value.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.cells.CellValueType) -> None:
        '''Gets/sets the type of cell value.'''
        raise NotImplementedError()
    
    @property
    def value(self) -> Any:
        '''Gets/sets the cell value.'''
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : Any) -> None:
        '''Gets/sets the cell value.'''
        raise NotImplementedError()
    

class CellWatch:
    '''Represents Cell Watch Item in the \'watch window\'.'''
    
    @property
    def row(self) -> int:
        '''Gets and sets the row of the cell.'''
        raise NotImplementedError()
    
    @row.setter
    def row(self, value : int) -> None:
        '''Gets and sets the row of the cell.'''
        raise NotImplementedError()
    
    @property
    def column(self) -> int:
        '''Gets and sets the column of the cell.'''
        raise NotImplementedError()
    
    @column.setter
    def column(self, value : int) -> None:
        '''Gets and sets the column of the cell.'''
        raise NotImplementedError()
    
    @property
    def cell_name(self) -> str:
        '''Gets and sets the name of the cell.'''
        raise NotImplementedError()
    
    @cell_name.setter
    def cell_name(self, value : str) -> None:
        '''Gets and sets the name of the cell.'''
        raise NotImplementedError()
    

class CellWatchCollection:
    '''Represents the collection of cells on this worksheet being watched in the \'watch window\'.'''
    
    @overload
    def add(self, row : int, column : int) -> int:
        '''Adds :py:class:`aspose.cells.CellWatch` with row and column.
        
        :param row: The row index.
        :param column: The column index.
        :returns: Returns the position of this item in the collection.'''
        raise NotImplementedError()
    
    @overload
    def add(self, cell_name : str) -> int:
        '''Adds :py:class:`aspose.cells.CellWatch` with the name the of cell.
        
        :param cell_name: The name of the cell.'''
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.CellWatch]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.CellWatch], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.CellWatch, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.CellWatch, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.CellWatch) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.CellWatch, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.CellWatch, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.CellWatch) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class Cells:
    '''Encapsulates a collection of cell relevant objects, such as :py:class:`aspose.cells.Cell`, :py:class:`aspose.cells.Row`, ...etc.'''
    
    @overload
    def create_range(self, upper_left_cell : str, lower_right_cell : str) -> aspose.cells.Range:
        '''Creates a :py:class:`aspose.cells.Range` object from a range of cells.
        
        :param upper_left_cell: Upper left cell name.
        :param lower_right_cell: Lower right cell name.
        :returns: A :py:class:`aspose.cells.Range` object'''
        raise NotImplementedError()
    
    @overload
    def create_range(self, first_row : int, first_column : int, total_rows : int, total_columns : int) -> aspose.cells.Range:
        '''Creates a :py:class:`aspose.cells.Range` object from a range of cells.
        
        :param first_row: First row of this range
        :param first_column: First column of this range
        :param total_rows: Number of rows
        :param total_columns: Number of columns
        :returns: A :py:class:`aspose.cells.Range` object'''
        raise NotImplementedError()
    
    @overload
    def create_range(self, address : str) -> aspose.cells.Range:
        '''Creates a :py:class:`aspose.cells.Range` object from an address of the range.
        
        :param address: The address of the range.
        :returns: A :py:class:`aspose.cells.Range` object'''
        raise NotImplementedError()
    
    @overload
    def create_range(self, first_index : int, number : int, is_vertical : bool) -> aspose.cells.Range:
        '''Creates a :py:class:`aspose.cells.Range` object from rows of cells or columns of cells.
        
        :param first_index: First row index or first column index, zero based.
        :param number: Total number of rows or columns, one based.
        :param is_vertical: True - Range created from columns of cells. False - Range created from rows of cells.
        :returns: A :py:class:`aspose.cells.Range` object.'''
        raise NotImplementedError()
    
    @overload
    def get(self, row : int, column : int) -> aspose.cells.Cell:
        '''Add API for Python Via .Net.since this[int row, int column] is unsupported
        
        :param row: Row index.
        :param column: Column index.
        :returns: The :py:class:`aspose.cells.Cell` object.'''
        raise NotImplementedError()
    
    @overload
    def get(self, cell_name : str) -> aspose.cells.Cell:
        '''Add API for Python Via .Net.since this[string cellName] is unsupported
        
        :param cell_name: Cell name,including its column letter and row number, for example A5.
        :returns: A :py:class:`aspose.cells.Cell` object'''
        raise NotImplementedError()
    
    @overload
    def import_object_array(self, obj_array : List[Any], first_row : int, first_column : int, is_vertical : bool) -> None:
        '''Imports an array of data into a worksheet.
        
        :param obj_array: Data array.
        :param first_row: The row number of the first cell to import in.
        :param first_column: The column number of the first cell to import in.
        :param is_vertical: Specifies to import data vertically or horizontally.'''
        raise NotImplementedError()
    
    @overload
    def import_object_array(self, obj_array : List[Any], first_row : int, first_column : int, is_vertical : bool, skip : int) -> None:
        '''Imports an array of data into a worksheet.
        
        :param obj_array: Data array.
        :param first_row: The row number of the first cell to import in.
        :param first_column: The column number of the first cell to import in.
        :param is_vertical: Specifies to import data vertically or horizontally.
        :param skip: Skipped number of rows or columns.'''
        raise NotImplementedError()
    
    @overload
    def import_array(self, string_array : List[str], first_row : int, first_column : int, is_vertical : bool) -> None:
        '''Imports an array of string into a worksheet.
        
        :param string_array: String array.
        :param first_row: The row number of the first cell to import in.
        :param first_column: The column number of the first cell to import in.
        :param is_vertical: Specifies to import data vertically or horizontally.'''
        raise NotImplementedError()
    
    @overload
    def import_array(self, int_array : List[int], first_row : int, first_column : int, is_vertical : bool) -> None:
        '''Imports an array of integer into a worksheet.
        
        :param int_array: Integer array.
        :param first_row: The row number of the first cell to import in.
        :param first_column: The column number of the first cell to import in.
        :param is_vertical: Specifies to import data vertically or horizontally.'''
        raise NotImplementedError()
    
    @overload
    def import_array(self, double_array : List[float], first_row : int, first_column : int, is_vertical : bool) -> None:
        '''Imports an array of double into a worksheet.
        
        :param double_array: Double array.
        :param first_row: The row number of the first cell to import in.
        :param first_column: The column number of the first cell to import in.
        :param is_vertical: Specifies to import data vertically or horizontally.'''
        raise NotImplementedError()
    
    @overload
    def import_csv(self, file_name : str, splitter : str, convert_numeric_data : bool, first_row : int, first_column : int) -> None:
        '''Import a CSV file to the cells.
        
        :param file_name: The CSV file name.
        :param splitter: The splitter
        :param convert_numeric_data: Whether the string in text file is converted to numeric data.
        :param first_row: The row number of the first cell to import in.
        :param first_column: The column number of the first cell to import in.'''
        raise NotImplementedError()
    
    @overload
    def import_csv(self, stream : io.RawIOBase, splitter : str, convert_numeric_data : bool, first_row : int, first_column : int) -> None:
        '''Import a CSV file to the cells.
        
        :param stream: The CSV file stream.
        :param splitter: The splitter
        :param convert_numeric_data: Whether the string in text file is converted to numeric data.
        :param first_row: The row number of the first cell to import in.
        :param first_column: The column number of the first cell to import in.'''
        raise NotImplementedError()
    
    @overload
    def import_csv(self, file_name : str, options : aspose.cells.TxtLoadOptions, first_row : int, first_column : int) -> None:
        '''Import a CSV file to the cells.
        
        :param file_name: The CSV file name.
        :param options: The load options for reading text file
        :param first_row: The row number of the first cell to import in.
        :param first_column: The column number of the first cell to import in.'''
        raise NotImplementedError()
    
    @overload
    def import_csv(self, stream : io.RawIOBase, options : aspose.cells.TxtLoadOptions, first_row : int, first_column : int) -> None:
        '''Import a CSV file to the cells.
        
        :param stream: The CSV file stream.
        :param options: The load options for reading text file
        :param first_row: The row number of the first cell to import in.
        :param first_column: The column number of the first cell to import in.'''
        raise NotImplementedError()
    
    @overload
    def merge(self, first_row : int, first_column : int, total_rows : int, total_columns : int) -> None:
        '''Merges a specified range of cells into a single cell.
        
        :param first_row: First row of this range(zero based)
        :param first_column: First column of this range(zero based)
        :param total_rows: Number of rows(one based)
        :param total_columns: Number of columns(one based)'''
        raise NotImplementedError()
    
    @overload
    def merge(self, first_row : int, first_column : int, total_rows : int, total_columns : int, merge_conflict : bool) -> None:
        '''Merges a specified range of cells into a single cell.
        
        :param first_row: First row of this range(zero based)
        :param first_column: First column of this range(zero based)
        :param total_rows: Number of rows(one based)
        :param total_columns: Number of columns(one based)
        :param merge_conflict: Merge conflict merged ranges.'''
        raise NotImplementedError()
    
    @overload
    def merge(self, first_row : int, first_column : int, total_rows : int, total_columns : int, check_conflict : bool, merge_conflict : bool) -> None:
        '''Merges a specified range of cells into a single cell.
        
        :param first_row: First row of this range(zero based)
        :param first_column: First column of this range(zero based)
        :param total_rows: Number of rows(one based)
        :param total_columns: Number of columns(one based)
        :param check_conflict: Indicates whether check the merged cells intersects other merged cells
        :param merge_conflict: Merge conflict merged ranges.'''
        raise NotImplementedError()
    
    @overload
    def get_row_height(self, row : int, is_original : bool, unit_type : aspose.cells.CellsUnitType) -> float:
        raise NotImplementedError()
    
    @overload
    def get_row_height(self, row : int) -> float:
        '''Gets the height of a specified row, in unit of points.
        
        :param row: Row index
        :returns: Height of row'''
        raise NotImplementedError()
    
    @overload
    def get_column_width(self, column : int, is_original : bool, unit_type : aspose.cells.CellsUnitType) -> float:
        raise NotImplementedError()
    
    @overload
    def get_column_width(self, column : int) -> float:
        '''Gets the width(in unit of characters) of the specified column in normal view
        
        :param column: Column index
        :returns: Width of column. For spreadsheet, column width is measured as the number of characters
        of the maximum digit width of the numbers 0~9 as rendered in the normal style\'s font.'''
        raise NotImplementedError()
    
    @overload
    def get_column_width_pixel(self, column : int) -> int:
        '''Gets the width of the specified column in normal view, in units of pixel.
        
        :param column: Column index
        :returns: Width of column in normal view.'''
        raise NotImplementedError()
    
    @overload
    def get_column_width_pixel(self, column : int, original : bool) -> int:
        '''Gets the width of the specified column in normal view, in units of pixel.
        
        :param column: Column index
        :param original: Indicates whether returning original width even when the column is hidden
        :returns: Width of column in normal view.'''
        raise NotImplementedError()
    
    @overload
    def copy_columns(self, source_cells0 : aspose.cells.Cells, source_column_index : int, destination_column_index : int, column_number : int, paste_options : aspose.cells.PasteOptions) -> None:
        '''Copies data and formats of a whole column.
        
        :param source_cells0: Source Cells object contains data and formats to copy.
        :param source_column_index: Source column index.
        :param destination_column_index: Destination column index.
        :param column_number: The copied column number.
        :param paste_options: the options of pasting.'''
        raise NotImplementedError()
    
    @overload
    def copy_columns(self, source_cells0 : aspose.cells.Cells, source_column_index : int, destination_column_index : int, column_number : int) -> None:
        '''Copies data and formats of a whole column.
        
        :param source_cells0: Source Cells object contains data and formats to copy.
        :param source_column_index: Source column index.
        :param destination_column_index: Destination column index.
        :param column_number: The copied column number.'''
        raise NotImplementedError()
    
    @overload
    def copy_columns(self, source_cells : aspose.cells.Cells, source_column_index : int, source_total_columns : int, destination_column_index : int, destination_total_columns : int) -> None:
        '''Copies data and formats of the whole columns.
        
        :param source_cells: Source Cells object contains data and formats to copy.
        :param source_column_index: Source column index.
        :param source_total_columns: The number of the source columns.
        :param destination_column_index: Destination column index.
        :param destination_total_columns: The number of the destination columns.'''
        raise NotImplementedError()
    
    @overload
    def copy_rows(self, source_cells : aspose.cells.Cells, source_row_index : int, destination_row_index : int, row_number : int) -> None:
        '''Copies data and formats of some whole rows.
        
        :param source_cells: Source Cells object contains data and formats to copy.
        :param source_row_index: Source row index.
        :param destination_row_index: Destination row index.
        :param row_number: The copied row number.'''
        raise NotImplementedError()
    
    @overload
    def copy_rows(self, source_cells0 : aspose.cells.Cells, source_row_index : int, destination_row_index : int, row_number : int, copy_options : aspose.cells.CopyOptions) -> None:
        '''Copies data and formats of some whole rows.
        
        :param source_cells0: Source Cells object contains data and formats to copy.
        :param source_row_index: Source row index.
        :param destination_row_index: Destination row index.
        :param row_number: The copied row number.
        :param copy_options: The copy options.'''
        raise NotImplementedError()
    
    @overload
    def copy_rows(self, source_cells0 : aspose.cells.Cells, source_row_index : int, destination_row_index : int, row_number : int, copy_options : aspose.cells.CopyOptions, paste_options : aspose.cells.PasteOptions) -> None:
        '''Copies data and formats of some whole rows.
        
        :param source_cells0: Source Cells object contains data and formats to copy.
        :param source_row_index: Source row index.
        :param destination_row_index: Destination row index.
        :param row_number: The copied row number.
        :param copy_options: The copy options.
        :param paste_options: the options of pasting.'''
        raise NotImplementedError()
    
    @overload
    def group_columns(self, first_index : int, last_index : int) -> None:
        '''Groups columns.
        
        :param first_index: The first column index to be grouped.
        :param last_index: The last column index to be grouped.'''
        raise NotImplementedError()
    
    @overload
    def group_columns(self, first_index : int, last_index : int, is_hidden : bool) -> None:
        '''Groups columns.
        
        :param first_index: The first column index to be grouped.
        :param last_index: The last column index to be grouped.
        :param is_hidden: Specifies if the grouped columns are hidden.'''
        raise NotImplementedError()
    
    @overload
    def ungroup_rows(self, first_index : int, last_index : int, is_all : bool) -> None:
        '''Ungroups rows.
        
        :param first_index: The first row index to be ungrouped.
        :param last_index: The last row index to be ungrouped.
        :param is_all: True, removes all grouped info.Otherwise, remove the outer group info.'''
        raise NotImplementedError()
    
    @overload
    def ungroup_rows(self, first_index : int, last_index : int) -> None:
        '''Ungroups rows.
        
        :param first_index: The first row index to be ungrouped.
        :param last_index: The last row index to be ungrouped.'''
        raise NotImplementedError()
    
    @overload
    def group_rows(self, first_index : int, last_index : int, is_hidden : bool) -> None:
        '''Groups rows.
        
        :param first_index: The first row index to be grouped.
        :param last_index: The last row index to be grouped.
        :param is_hidden: Specifies if the grouped rows are hidden.'''
        raise NotImplementedError()
    
    @overload
    def group_rows(self, first_index : int, last_index : int) -> None:
        '''Groups rows.
        
        :param first_index: The first row index to be grouped.
        :param last_index: The last row index to be grouped.'''
        raise NotImplementedError()
    
    @overload
    def delete_column(self, column_index : int, update_reference : bool) -> None:
        '''Deletes a column.
        
        :param column_index: Index of the column to be deleted.
        :param update_reference: Indicates whether update references in other worksheets.'''
        raise NotImplementedError()
    
    @overload
    def delete_column(self, column_index : int) -> None:
        '''Deletes a column.
        
        :param column_index: Index of the column to be deleted.'''
        raise NotImplementedError()
    
    @overload
    def delete_row(self, row_index : int) -> None:
        '''Deletes a row.
        
        :param row_index: Index of the row to be deleted.'''
        raise NotImplementedError()
    
    @overload
    def delete_row(self, row_index : int, update_reference : bool) -> None:
        '''Deletes a row.
        
        :param row_index: Index of the row to be deleted.
        :param update_reference: Indicates whether update references in other worksheets.'''
        raise NotImplementedError()
    
    @overload
    def delete_rows(self, row_index : int, total_rows : int) -> bool:
        '''Deletes several rows.
        
        :param row_index: The first row index to be deleted.
        :param total_rows: Count of rows to be deleted.'''
        raise NotImplementedError()
    
    @overload
    def delete_rows(self, row_index : int, total_rows : int, update_reference : bool) -> bool:
        '''Deletes multiple rows in the worksheet.
        
        :param row_index: Index of the first row to be deleted.
        :param total_rows: Count of rows to be deleted.
        :param update_reference: Indicates whether update references in other worksheets.'''
        raise NotImplementedError()
    
    @overload
    def delete_blank_columns(self) -> None:
        '''Delete all blank columns which do not contain any data.'''
        raise NotImplementedError()
    
    @overload
    def delete_blank_columns(self, options : aspose.cells.DeleteOptions) -> None:
        '''Delete all blank columns which do not contain any data.
        
        :param options: The options of deleting range.'''
        raise NotImplementedError()
    
    @overload
    def delete_blank_rows(self) -> None:
        '''Delete all blank rows which do not contain any data or other object.'''
        raise NotImplementedError()
    
    @overload
    def delete_blank_rows(self, options : aspose.cells.DeleteOptions) -> None:
        '''Delete all blank rows which do not contain any data or other object.
        
        :param options: The options of deleting range.'''
        raise NotImplementedError()
    
    @overload
    def insert_columns(self, column_index : int, total_columns : int) -> None:
        '''Inserts some columns into the worksheet.
        
        :param column_index: Column index.
        :param total_columns: The number of columns.'''
        raise NotImplementedError()
    
    @overload
    def insert_columns(self, column_index : int, total_columns : int, update_reference : bool) -> None:
        '''Inserts some columns into the worksheet.
        
        :param column_index: Column index.
        :param total_columns: The number of columns.
        :param update_reference: Indicates if references in other worksheets will be updated.'''
        raise NotImplementedError()
    
    @overload
    def insert_column(self, column_index : int, update_reference : bool) -> None:
        '''Inserts a new column into the worksheet.
        
        :param column_index: Column index.
        :param update_reference: Indicates if references in other worksheets will be updated.'''
        raise NotImplementedError()
    
    @overload
    def insert_column(self, column_index : int) -> None:
        '''Inserts a new column into the worksheet.
        
        :param column_index: Column index.'''
        raise NotImplementedError()
    
    @overload
    def insert_rows(self, row_index : int, total_rows : int, update_reference : bool) -> None:
        '''Inserts multiple rows into the worksheet.
        
        :param row_index: Row index.
        :param total_rows: Number of rows to be inserted.
        :param update_reference: Indicates if references in other worksheets will be updated.'''
        raise NotImplementedError()
    
    @overload
    def insert_rows(self, row_index : int, total_rows : int, options : aspose.cells.InsertOptions) -> None:
        '''Inserts multiple rows into the worksheet.
        
        :param row_index: Row index.
        :param total_rows: Number of rows to be inserted.
        :param options: Indicates if references in other worksheets will be updated.'''
        raise NotImplementedError()
    
    @overload
    def insert_rows(self, row_index : int, total_rows : int) -> None:
        '''Inserts multiple rows into the worksheet.
        
        :param row_index: Row index.
        :param total_rows: Number of rows to be inserted.'''
        raise NotImplementedError()
    
    @overload
    def clear_range(self, range : aspose.cells.CellArea) -> None:
        '''Clears contents and formatting of a range.
        
        :param range: Range to be cleared.'''
        raise NotImplementedError()
    
    @overload
    def clear_range(self, start_row : int, start_column : int, end_row : int, end_column : int) -> None:
        '''Clears contents and formatting of a range.
        
        :param start_row: Start row index.
        :param start_column: Start column index.
        :param end_row: End row index.
        :param end_column: End column index.'''
        raise NotImplementedError()
    
    @overload
    def clear_contents(self, range : aspose.cells.CellArea) -> None:
        '''Clears contents of a range.
        
        :param range: Range to be cleared.'''
        raise NotImplementedError()
    
    @overload
    def clear_contents(self, start_row : int, start_column : int, end_row : int, end_column : int) -> None:
        '''Clears contents of a range.
        
        :param start_row: Start row index.
        :param start_column: Start column index.
        :param end_row: End row index.
        :param end_column: End column index.'''
        raise NotImplementedError()
    
    @overload
    def clear_formats(self, range : aspose.cells.CellArea) -> None:
        '''Clears formatting of a range.
        
        :param range: Range to be cleared.'''
        raise NotImplementedError()
    
    @overload
    def clear_formats(self, start_row : int, start_column : int, end_row : int, end_column : int) -> None:
        '''Clears formatting of a range.
        
        :param start_row: Start row index.
        :param start_column: Start column index.
        :param end_row: End row index.
        :param end_column: End column index.'''
        raise NotImplementedError()
    
    @overload
    def find(self, what : Any, previous_cell : aspose.cells.Cell) -> aspose.cells.Cell:
        '''Finds the cell containing with the input object.
        
        :param what: The object to search for.
        The type should be int,double,DateTime,string,bool.
        :param previous_cell: Previous cell with the same object.
        This parameter can be set to null if searching from the start.
        :returns: Cell object.'''
        raise NotImplementedError()
    
    @overload
    def find(self, what : Any, previous_cell : aspose.cells.Cell, find_options : aspose.cells.FindOptions) -> aspose.cells.Cell:
        '''Finds the cell containing with the input object.
        
        :param what: The object to search for.
        The type should be int,double,DateTime,string,bool.
        :param previous_cell: Previous cell with the same object.
        This parameter can be set to null if searching from the start.
        :param find_options: Find options
        :returns: Cell object.'''
        raise NotImplementedError()
    
    @overload
    def end_cell_in_row(self, row_index : int) -> aspose.cells.Cell:
        '''Gets the last cell in this row.
        
        :param row_index: Row index.
        :returns: Cell object.'''
        raise NotImplementedError()
    
    @overload
    def end_cell_in_row(self, start_row : int, end_row : int, start_column : int, end_column : int) -> aspose.cells.Cell:
        '''Gets the last cell with maximum row index in this range.
        
        :param start_row: Start row index.
        :param end_row: End row index.
        :param start_column: Start column index.
        :param end_column: End column index.
        :returns: Cell object.'''
        raise NotImplementedError()
    
    @overload
    def end_cell_in_column(self, column_index : int) -> aspose.cells.Cell:
        '''Gets the last cell in this column.
        
        :param column_index: Column index.
        :returns: Cell object.'''
        raise NotImplementedError()
    
    @overload
    def end_cell_in_column(self, start_row : int, end_row : int, start_column : int, end_column : int) -> aspose.cells.Cell:
        '''Gets the last cell with maximum column index in this range.
        
        :param start_row: Start row index.
        :param end_row: End row index.
        :param start_column: Start column index.
        :param end_column: End column index.
        :returns: Cell object.'''
        raise NotImplementedError()
    
    @overload
    def insert_range(self, area : aspose.cells.CellArea, shift_number : int, shift_type : aspose.cells.ShiftType, update_reference : bool) -> None:
        '''Inserts a range of cells and shift cells according to the shift option.
        
        :param area: Shift area.
        :param shift_number: Number of rows or columns to be inserted.
        :param shift_type: Shift cells option.
        :param update_reference: Indicates whether update references in other worksheets.'''
        raise NotImplementedError()
    
    @overload
    def insert_range(self, area : aspose.cells.CellArea, shift_type : aspose.cells.ShiftType) -> None:
        '''Inserts a range of cells and shift cells according to the shift option.
        
        :param area: Shift area.
        :param shift_type: Shift cells option.'''
        raise NotImplementedError()
    
    @overload
    def insert_range(self, area : aspose.cells.CellArea, shift_number : int, shift_type : aspose.cells.ShiftType) -> None:
        '''Inserts a range of cells and shift cells according to the shift option.
        
        :param area: Shift area.
        :param shift_number: Number of rows or columns to be inserted.
        :param shift_type: Shift cells option.'''
        raise NotImplementedError()
    
    @overload
    def import_custom_objects(self, list : List[Any], property_names : List[str], is_property_name_shown : bool, first_row : int, first_column : int, row_number : int, insert_rows : bool, date_format_string : str, convert_string_to_number : bool) -> int:
        '''Imports custom objects.
        
        :param list: The custom object
        :param property_names: The property names.If it is null,we will import all properties of the object.
        :param is_property_name_shown: Indicates whether the property name will be imported to the first row.
        :param first_row: The row number of the first cell to import in.
        :param first_column: The column number of the first cell to import in.
        :param row_number: Number of rows to be imported.
        :param insert_rows: Indicates whether extra rows are added to fit data.
        :param date_format_string: Date format string for cells.
        :param convert_string_to_number: Indicates if this method will try to convert string to number.
        :returns: Total number of rows imported.'''
        raise NotImplementedError()
    
    @overload
    def import_custom_objects(self, list : List[Any], first_row : int, first_column : int, options : aspose.cells.ImportTableOptions) -> int:
        '''Imports custom objects.
        
        :param list: The custom object
        :param first_row: The row number of the first cell to import in.
        :param first_column: The column number of the first cell to import in.
        :param options: The import options.
        :returns: Total number of rows imported.'''
        raise NotImplementedError()
    
    @overload
    def subtotal(self, ca : aspose.cells.CellArea, group_by : int, function : aspose.cells.ConsolidationFunction, total_list : List[int]) -> None:
        '''Creates subtotals for the range.
        
        :param ca: The range
        :param group_by: The field to group by, as a zero-based integer offset
        :param function: The subtotal function.
        :param total_list: An array of zero-based field offsets, indicating the fields to which the subtotals are added.'''
        raise NotImplementedError()
    
    @overload
    def subtotal(self, ca : aspose.cells.CellArea, group_by : int, function : aspose.cells.ConsolidationFunction, total_list : List[int], replace : bool, page_breaks : bool, summary_below_data : bool) -> None:
        '''Creates subtotals for the range.
        
        :param ca: The range
        :param group_by: The field to group by, as a zero-based integer offset
        :param function: The subtotal function.
        :param total_list: An array of zero-based field offsets, indicating the fields to which the subtotals are added.
        :param replace: Indicates whether replace the current subtotals
        :param page_breaks: Indicates whether add page break between groups
        :param summary_below_data: Indicates whether add summary below data.'''
        raise NotImplementedError()
    
    @overload
    def remove_duplicates(self) -> None:
        '''Removes duplicate rows in the sheet.'''
        raise NotImplementedError()
    
    @overload
    def remove_duplicates(self, start_row : int, start_column : int, end_row : int, end_column : int) -> None:
        '''Removes duplicate values in the range.
        
        :param start_row: The start row.
        :param start_column: The start column
        :param end_row: The end row index.
        :param end_column: The end column index.'''
        raise NotImplementedError()
    
    @overload
    def remove_duplicates(self, start_row : int, start_column : int, end_row : int, end_column : int, has_headers : bool, column_offsets : List[int]) -> None:
        '''Removes duplicate data of the range.
        
        :param start_row: The start row.
        :param start_column: The start column
        :param end_row: The end row index.
        :param end_column: The end column index.
        :param has_headers: Indicates whether the range contains headers.
        :param column_offsets: The column offsets.'''
        raise NotImplementedError()
    
    def get_row_enumerator(self) -> collections.abc.Iterator[Any]:
        '''Gets the rows enumerator.
        
        :returns: The rows enumerator.'''
        raise NotImplementedError()
    
    def get_merged_areas(self) -> List[aspose.cells.CellArea]:
        '''Gets all merged cells.'''
        raise NotImplementedError()
    
    def get_cell(self, row : int, column : int) -> aspose.cells.Cell:
        '''Gets the :py:class:`aspose.cells.Cell` element or null at the specified cell row index and column index.
        
        :param row: Row index
        :param column: Column index
        :returns: Return Cell object if a Cell object exists.
        Return null if the cell does not exist.'''
        raise NotImplementedError()
    
    def get_row(self, row : int) -> aspose.cells.Row:
        '''Gets the :py:class:`aspose.cells.Row` element at the specified cell row index.
        
        :param row: Row index
        :returns: If the row object does exist return Row object, otherwise return null.'''
        raise NotImplementedError()
    
    def check_cell(self, row : int, column : int) -> aspose.cells.Cell:
        '''Gets the :py:class:`aspose.cells.Cell` element or null at the specified cell row index and column index.
        
        :param row: Row index
        :param column: Column index
        :returns: Return Cell object if a Cell object exists.
        Return null if the cell does not exist.'''
        raise NotImplementedError()
    
    def check_row(self, row : int) -> aspose.cells.Row:
        '''Gets the :py:class:`aspose.cells.Row` element or null at the specified cell row index.
        
        :param row: Row index
        :returns: Returns :py:class:`aspose.cells.Row` object If the row object does exist, otherwise returns null.'''
        raise NotImplementedError()
    
    def check_column(self, column_index : int) -> aspose.cells.Column:
        '''Gets the :py:class:`aspose.cells.Column` element or null at the specified column index.
        
        :param column_index: The column index.
        :returns: The Column object.'''
        raise NotImplementedError()
    
    def is_row_hidden(self, row_index : int) -> bool:
        '''Checks whether a row at given index is hidden.
        
        :param row_index: row index
        :returns: true if the row is hidden'''
        raise NotImplementedError()
    
    def is_column_hidden(self, column_index : int) -> bool:
        '''Checks whether a column at given index is hidden.
        
        :param column_index: column index
        :returns: true if the column is hidden.'''
        raise NotImplementedError()
    
    def add_range(self, range_object : aspose.cells.Range) -> None:
        '''Adds a range object reference to cells
        
        :param range_object: The range object will be contained in the cells'''
        raise NotImplementedError()
    
    def clear(self) -> None:
        '''Clears all data of the worksheet.'''
        raise NotImplementedError()
    
    def import_data(self, table : aspose.cells.ICellsDataTable, first_row : int, first_column : int, options : aspose.cells.ImportTableOptions) -> int:
        '''Import data from custom data table.
        
        :param table: The custom data table.
        :param first_row: First row index.
        :param first_column: First column index.
        :param options: The import options'''
        raise NotImplementedError()
    
    def import_array_list(self, array_list : List[Any], first_row : int, first_column : int, is_vertical : bool) -> None:
        '''Imports an arraylist of data into a worksheet.
        
        :param array_list: Data arraylist.
        :param first_row: The row number of the first cell to import in.
        :param first_column: The column number of the first cell to import in.
        :param is_vertical: Specifies to import data vertically or horizontally.'''
        raise NotImplementedError()
    
    def import_formula_array(self, string_array : List[str], first_row : int, first_column : int, is_vertical : bool) -> None:
        '''Imports an array of formula into a worksheet.
        
        :param string_array: Formula array.
        :param first_row: The row number of the first cell to import in.
        :param first_column: The column number of the first cell to import in.
        :param is_vertical: Specifies to import data vertically or horizontally.'''
        raise NotImplementedError()
    
    def text_to_columns(self, row : int, column : int, total_rows : int, options : aspose.cells.TxtLoadOptions) -> None:
        '''Splits the text in the column to columns.
        
        :param row: The row index.
        :param column: The column index.
        :param total_rows: The number of rows.
        :param options: The split options.'''
        raise NotImplementedError()
    
    def un_merge(self, first_row : int, first_column : int, total_rows : int, total_columns : int) -> None:
        '''Unmerges a specified range of merged cells.
        
        :param first_row: First row of this range(zero based)
        :param first_column: First column of this range(zero based)
        :param total_rows: Number of rows(one based)
        :param total_columns: Number of columns(one based)'''
        raise NotImplementedError()
    
    def clear_merged_cells(self) -> None:
        '''Clears all merged ranges.'''
        raise NotImplementedError()
    
    def hide_row(self, row : int) -> None:
        '''Hides a row.
        
        :param row: Row index.'''
        raise NotImplementedError()
    
    def unhide_row(self, row : int, height : float) -> None:
        '''Unhides a row.
        
        :param row: Row index.
        :param height: Row height. The row\'s height will be changed only when the row is hidden and given height value is positive.'''
        raise NotImplementedError()
    
    def hide_rows(self, row : int, total_rows : int) -> None:
        '''Hides multiple rows.
        
        :param row: The row index.
        :param total_rows: The row number.'''
        raise NotImplementedError()
    
    def unhide_rows(self, row : int, total_rows : int, height : float) -> None:
        '''Unhides the hidden rows.
        
        :param row: The row index.
        :param total_rows: The row number.
        :param height: Row height. The row\'s height will be changed only when the row is hidden and given height value is positive.'''
        raise NotImplementedError()
    
    def set_row_height_pixel(self, row : int, pixels : int) -> None:
        '''Sets row height in unit of pixels.
        
        :param row: Row index.
        :param pixels: Number of pixels.'''
        raise NotImplementedError()
    
    def set_row_height_inch(self, row : int, inches : float) -> None:
        '''Sets row height in unit of inches.
        
        :param row: Row index.
        :param inches: Number of inches. It should be between 0 and 409.5/72.'''
        raise NotImplementedError()
    
    def set_row_height(self, row : int, height : float) -> None:
        '''Sets the height of the specified row.
        
        :param row: Row index.
        :param height: Height of row.In unit of point It should be between 0 and 409.5.'''
        raise NotImplementedError()
    
    def get_row_original_height_point(self, row : int) -> float:
        '''Gets original row\'s height in unit of point if the row is hidden
        
        :param row: The row index.'''
        raise NotImplementedError()
    
    def get_column_original_width_point(self, column : int) -> float:
        raise NotImplementedError()
    
    def hide_column(self, column : int) -> None:
        '''Hides a column.
        
        :param column: Column index.'''
        raise NotImplementedError()
    
    def unhide_column(self, column : int, width : float) -> None:
        '''Unhides a column
        
        :param column: Column index.
        :param width: Column width.'''
        raise NotImplementedError()
    
    def hide_columns(self, column : int, total_columns : int) -> None:
        '''Hide multiple columns.
        
        :param column: Column index.
        :param total_columns: Column number.'''
        raise NotImplementedError()
    
    def unhide_columns(self, column : int, total_columns : int, width : float) -> None:
        '''Unhide multiple columns.
        
        :param column: Column index.
        :param total_columns: Column number
        :param width: Column width.'''
        raise NotImplementedError()
    
    def get_view_row_height(self, row : int) -> float:
        '''Gets the height of a specified row.
        
        :param row: Row index.
        :returns: Height of row.'''
        raise NotImplementedError()
    
    def get_row_height_inch(self, row : int) -> float:
        '''Gets the height of a specified row in unit of inches.
        
        :param row: Row index
        :returns: Height of row'''
        raise NotImplementedError()
    
    def get_view_row_height_inch(self, row : int) -> float:
        '''Gets the height of a specified row in unit of inches.
        
        :param row: Row index
        :returns: Height of row'''
        raise NotImplementedError()
    
    def get_row_height_pixel(self, row : int) -> int:
        '''Gets the height of a specified row in unit of pixel.
        
        :param row: Row index
        :returns: Height of row'''
        raise NotImplementedError()
    
    def set_column_width_pixel(self, column : int, pixels : int) -> None:
        '''Sets column width in unit of pixels in normal view.
        
        :param column: Column index.
        :param pixels: Number of pixels.'''
        raise NotImplementedError()
    
    def set_column_width_inch(self, column : int, inches : float) -> None:
        '''Sets column width in unit of inches  in normal view.
        
        :param column: Column index.
        :param inches: Number of inches.'''
        raise NotImplementedError()
    
    def set_column_width(self, column : int, width : float) -> None:
        '''Sets the width of the specified column in normal view.
        
        :param column: Column index.
        :param width: Width of column.Column width must be between 0 and 255.'''
        raise NotImplementedError()
    
    def get_column_width_inch(self, column : int) -> float:
        '''Gets the width of the specified column in normal view, in units of inches.
        
        :param column: Column index
        :returns: Width of column'''
        raise NotImplementedError()
    
    def get_view_column_width_pixel(self, column : int) -> int:
        '''Get the width in different view type.
        
        :param column: The column index.
        :returns: the column width in unit of pixels'''
        raise NotImplementedError()
    
    def set_view_column_width_pixel(self, column : int, pixels : int) -> None:
        '''Sets the width of the column in different view.
        
        :param column: The column index.
        :param pixels: The width in unit of pixels.'''
        raise NotImplementedError()
    
    def get_last_data_row(self, column : int) -> int:
        '''Gets the last row index of cell which contains data in the specified column.
        
        :param column: Column index.
        :returns: last row index.'''
        raise NotImplementedError()
    
    def apply_column_style(self, column : int, style : aspose.cells.Style, flag : aspose.cells.StyleFlag) -> None:
        '''Applies formats for a whole column.
        
        :param column: The column index.
        :param style: The style object which will be applied.
        :param flag: Flags which indicates applied formatting properties.'''
        raise NotImplementedError()
    
    def apply_row_style(self, row : int, style : aspose.cells.Style, flag : aspose.cells.StyleFlag) -> None:
        '''Applies formats for a whole row.
        
        :param row: The row index.
        :param style: The style object which will be applied.
        :param flag: Flags which indicates applied formatting properties.'''
        raise NotImplementedError()
    
    def apply_style(self, style : aspose.cells.Style, flag : aspose.cells.StyleFlag) -> None:
        '''Applies formats for a whole worksheet.
        
        :param style: The style object which will be applied.
        :param flag: Flags which indicates applied formatting properties.'''
        raise NotImplementedError()
    
    def copy_column(self, source_cells : aspose.cells.Cells, source_column_index : int, destination_column_index : int) -> None:
        '''Copies data and formats of a whole column.
        
        :param source_cells: Source Cells object contains data and formats to copy.
        :param source_column_index: Source column index.
        :param destination_column_index: Destination column index.'''
        raise NotImplementedError()
    
    def copy_row(self, source_cells : aspose.cells.Cells, source_row_index : int, destination_row_index : int) -> None:
        '''Copies data and formats of a whole row.
        
        :param source_cells: Source Cells object contains data and formats to copy.
        :param source_row_index: Source row index.
        :param destination_row_index: Destination row index.'''
        raise NotImplementedError()
    
    def get_grouped_row_outline_level(self, row_index : int) -> int:
        '''Gets the outline level (zero-based) of the row.
        
        :param row_index: The row index.
        :returns: The outline level (zero-based) of the row.'''
        raise NotImplementedError()
    
    def get_grouped_column_outline_level(self, column_index : int) -> int:
        '''Gets the outline level (zero-based) of the column.
        
        :param column_index: The column index
        :returns: The outline level of the column'''
        raise NotImplementedError()
    
    def get_max_grouped_column_outline_level(self) -> int:
        '''Gets the max grouped column outline level (zero-based).
        
        :returns: The max grouped column outline level (zero-based)'''
        raise NotImplementedError()
    
    def get_max_grouped_row_outline_level(self) -> int:
        '''Gets the max grouped row outline level (zero-based).
        
        :returns: The max grouped row outline level (zero-based)'''
        raise NotImplementedError()
    
    def show_group_detail(self, is_vertical : bool, index : int) -> None:
        '''Expands the grouped rows/columns.
        
        :param is_vertical: True, expands the grouped rows.
        :param index: The row/column index'''
        raise NotImplementedError()
    
    def hide_group_detail(self, is_vertical : bool, index : int) -> None:
        '''Collapses the grouped rows/columns.
        
        :param is_vertical: True, collapse the grouped rows.
        :param index: The row/column index'''
        raise NotImplementedError()
    
    def ungroup_columns(self, first_index : int, last_index : int) -> None:
        '''Ungroups columns.
        
        :param first_index: The first column index to be ungrouped.
        :param last_index: The last column index to be ungrouped.'''
        raise NotImplementedError()
    
    def delete_columns(self, column_index : int, total_columns : int, update_reference : bool) -> None:
        '''Deletes several columns.
        
        :param column_index: Index of the first column to be deleted.
        :param total_columns: Count of columns to be deleted.
        :param update_reference: Indicates whether update references in other worksheets.'''
        raise NotImplementedError()
    
    def is_deleting_range_enabled(self, start_row : int, start_column : int, total_rows : int, total_columns : int) -> bool:
        '''Check whether the range could be deleted.
        
        :param start_row: The start row index of the range.
        :param start_column: The start column index of the range.
        :param total_rows: The number of the rows in the range.
        :param total_columns: The number of the columns in the range.'''
        raise NotImplementedError()
    
    def is_blank_column(self, column_index : int) -> bool:
        '''Checks whether given column is blank(does not contain any data).
        
        :param column_index: the column index
        :returns: true if given column does not contain any data'''
        raise NotImplementedError()
    
    def insert_row(self, row_index : int) -> None:
        '''Inserts a new row into the worksheet.
        
        :param row_index: Row index.'''
        raise NotImplementedError()
    
    def link_to_xml_map(self, map_name : str, row : int, column : int, path : str) -> None:
        '''Link to a xml map.
        
        :param map_name: name of xml map
        :param row: row of the destination cell
        :param column: column of the destination cell
        :param path: path of xml element in xml map'''
        raise NotImplementedError()
    
    def move_range(self, source_area : aspose.cells.CellArea, dest_row : int, dest_column : int) -> None:
        '''Moves the range.
        
        :param source_area: The range which should be moved.
        :param dest_row: The dest row.
        :param dest_column: The dest column.'''
        raise NotImplementedError()
    
    def insert_cut_cells(self, cut_range : aspose.cells.Range, row : int, column : int, shift_type : aspose.cells.ShiftType) -> None:
        '''Insert cut range.
        
        :param cut_range: The cut range.
        :param row: The row.
        :param column: The column.
        :param shift_type: The shift type .'''
        raise NotImplementedError()
    
    def delete_range(self, start_row : int, start_column : int, end_row : int, end_column : int, shift_type : aspose.cells.ShiftType) -> None:
        '''Deletes a range of cells and shift cells according to the shift option.
        
        :param start_row: Start row index.
        :param start_column: Start column index.
        :param end_row: End row index.
        :param end_column: End column index.
        :param shift_type: Shift cells option.'''
        raise NotImplementedError()
    
    def retrieve_subtotal_setting(self, ca : aspose.cells.CellArea) -> aspose.cells.SubtotalSetting:
        '''Retrieves subtotals setting of the range.
        
        :param ca: The range'''
        raise NotImplementedError()
    
    def remove_formulas(self) -> None:
        '''Removes all formula and replaces with the value of the formula.'''
        raise NotImplementedError()
    
    def convert_string_to_numeric_value(self) -> None:
        '''Converts all string data in the worksheet to numeric value if possible.'''
        raise NotImplementedError()
    
    def get_dependents(self, is_all : bool, row : int, column : int) -> List[aspose.cells.Cell]:
        '''Get all cells which refer to the specific cell.
        
        :param is_all: Indicates whether check other worksheets
        :param row: The row index.
        :param column: The column index.'''
        raise NotImplementedError()
    
    def get_dependents_in_calculation(self, row : int, column : int, recursive : bool) -> collections.abc.Iterator[Any]:
        '''Gets all cells whose calculated result depends on specific cell.
        
        :param row: Row index of the specific cell
        :param column: Column index of the specific cell.
        :param recursive: Whether returns those dependents which do not reference to the specific cell directly
        but reference to other leafs of that cell.
        :returns: Enumerator to enumerate all dependents(Cell objects)'''
        raise NotImplementedError()
    
    def get_cells_with_place_in_cell_picture(self) -> collections.abc.Iterator[Any]:
        raise NotImplementedError()
    
    def get_cell_style(self, row : int, column : int) -> aspose.cells.Style:
        '''Get the style of given cell.
        
        :param row: row index
        :param column: column
        :returns: the style of given cell.'''
        raise NotImplementedError()
    
    @property
    def ods_cell_fields(self) -> aspose.cells.ods.OdsCellFieldCollection:
        '''Gets the list of fields of ods.'''
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        '''Gets the total count of instantiated Cell objects.'''
        raise NotImplementedError()
    
    @property
    def count_large(self) -> int:
        '''Gets the total count of instantiated Cell objects.'''
        raise NotImplementedError()
    
    @property
    def rows(self) -> aspose.cells.RowCollection:
        '''Gets the collection of :py:class:`aspose.cells.Row` objects that represents the individual rows in this worksheet.'''
        raise NotImplementedError()
    
    @property
    def merged_cells(self) -> List[Any]:
        '''Gets the collection of merged cells.'''
        raise NotImplementedError()
    
    @property
    def multi_thread_reading(self) -> bool:
        '''Gets whether the cells data model should support Multi-Thread reading.
        Default value of this property is false.'''
        raise NotImplementedError()
    
    @multi_thread_reading.setter
    def multi_thread_reading(self, value : bool) -> None:
        '''Sets whether the cells data model should support Multi-Thread reading.
        Default value of this property is false.'''
        raise NotImplementedError()
    
    @property
    def memory_setting(self) -> aspose.cells.MemorySetting:
        '''Gets the memory usage option for this cells.'''
        raise NotImplementedError()
    
    @memory_setting.setter
    def memory_setting(self, value : aspose.cells.MemorySetting) -> None:
        '''Sets the memory usage option for this cells.'''
        raise NotImplementedError()
    
    @property
    def style(self) -> aspose.cells.Style:
        '''Gets and sets the default style of the worksheet.'''
        raise NotImplementedError()
    
    @style.setter
    def style(self, value : aspose.cells.Style) -> None:
        '''Gets and sets the default style of the worksheet.'''
        raise NotImplementedError()
    
    @property
    def standard_width_inch(self) -> float:
        '''Gets the default column width in the worksheet, in unit of inches.'''
        raise NotImplementedError()
    
    @standard_width_inch.setter
    def standard_width_inch(self, value : float) -> None:
        '''Sets the default column width in the worksheet, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def standard_width_pixels(self) -> int:
        '''Gets the default column width in the worksheet, in unit of pixels.'''
        raise NotImplementedError()
    
    @standard_width_pixels.setter
    def standard_width_pixels(self, value : int) -> None:
        '''Sets the default column width in the worksheet, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def standard_width(self) -> float:
        '''Gets the default column width in the worksheet, in unit of characters.'''
        raise NotImplementedError()
    
    @standard_width.setter
    def standard_width(self, value : float) -> None:
        '''Sets the default column width in the worksheet, in unit of characters.'''
        raise NotImplementedError()
    
    @property
    def standard_height(self) -> float:
        '''Gets the default row height in this worksheet, in unit of points.'''
        raise NotImplementedError()
    
    @standard_height.setter
    def standard_height(self, value : float) -> None:
        '''Sets the default row height in this worksheet, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def standard_height_pixels(self) -> int:
        '''Gets the default row height in this worksheet, in unit of pixels.'''
        raise NotImplementedError()
    
    @standard_height_pixels.setter
    def standard_height_pixels(self, value : int) -> None:
        '''Sets the default row height in this worksheet, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def standard_height_inch(self) -> float:
        '''Gets the default row height in this worksheet, in unit of inches.'''
        raise NotImplementedError()
    
    @standard_height_inch.setter
    def standard_height_inch(self, value : float) -> None:
        '''Sets the default row height in this worksheet, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def preserve_string(self) -> bool:
        '''Gets a value indicating whether all worksheet values are preserved as strings.
        Default is false.'''
        raise NotImplementedError()
    
    @preserve_string.setter
    def preserve_string(self, value : bool) -> None:
        '''Sets a value indicating whether all worksheet values are preserved as strings.
        Default is false.'''
        raise NotImplementedError()
    
    @property
    def min_row(self) -> int:
        '''Minimum row index of cell which contains data or style.'''
        raise NotImplementedError()
    
    @property
    def max_row(self) -> int:
        '''Maximum row index of cell which contains data or style.'''
        raise NotImplementedError()
    
    @property
    def min_column(self) -> int:
        '''Minimum column index of those cells that have been instantiated in the collection(does not include the column
        where style is defined for the whole column but no cell has been instantiated in it).'''
        raise NotImplementedError()
    
    @property
    def max_column(self) -> int:
        '''Maximum column index of those cells that have been instantiated in the collection(does not include the column
        where style is defined for the whole column but no cell has been instantiated in it).'''
        raise NotImplementedError()
    
    @property
    def min_data_row(self) -> int:
        '''Minimum row index of cell which contains data.'''
        raise NotImplementedError()
    
    @property
    def max_data_row(self) -> int:
        '''Maximum row index of cell which contains data.'''
        raise NotImplementedError()
    
    @property
    def min_data_column(self) -> int:
        '''Minimum column index of cell which contains data.'''
        raise NotImplementedError()
    
    @property
    def max_data_column(self) -> int:
        '''Maximum column index of cell which contains data.'''
        raise NotImplementedError()
    
    @property
    def is_default_row_height_matched(self) -> bool:
        '''Indicates that row height and default font height matches'''
        raise NotImplementedError()
    
    @is_default_row_height_matched.setter
    def is_default_row_height_matched(self, value : bool) -> None:
        '''Indicates that row height and default font height matches'''
        raise NotImplementedError()
    
    @property
    def is_default_row_hidden(self) -> bool:
        '''Indicates whether the row is default hidden.'''
        raise NotImplementedError()
    
    @is_default_row_hidden.setter
    def is_default_row_hidden(self, value : bool) -> None:
        '''Indicates whether the row is default hidden.'''
        raise NotImplementedError()
    
    @property
    def columns(self) -> aspose.cells.ColumnCollection:
        '''Gets the collection of :py:class:`aspose.cells.Column` objects that represents the individual columns in this worksheet.'''
        raise NotImplementedError()
    
    @property
    def ranges(self) -> aspose.cells.RangeCollection:
        '''Gets the collection of :py:class:`aspose.cells.Range` objects created at run time.'''
        raise NotImplementedError()
    
    @property
    def last_cell(self) -> aspose.cells.Cell:
        '''Gets the last cell in this worksheet.'''
        raise NotImplementedError()
    
    @property
    def max_display_range(self) -> aspose.cells.Range:
        '''Gets the max range which includes data, merged cells and shapes.'''
        raise NotImplementedError()
    
    @property
    def first_cell(self) -> aspose.cells.Cell:
        '''Gets the first cell in this worksheet.'''
        raise NotImplementedError()
    

class CellsColor:
    '''Represents all types of color.'''
    
    def set_tint_of_shape_color(self, tint : float) -> None:
        '''Set the tint of the shape color'''
        raise NotImplementedError()
    
    @property
    def is_shape_color(self) -> bool:
        '''Gets and set the color which should apply to cell or shape.'''
        raise NotImplementedError()
    
    @is_shape_color.setter
    def is_shape_color(self, value : bool) -> None:
        '''Gets and set the color which should apply to cell or shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.ColorType:
        '''The color type.'''
        raise NotImplementedError()
    
    @property
    def theme_color(self) -> aspose.cells.ThemeColor:
        '''Gets the theme color. Only applies for theme color type.'''
        raise NotImplementedError()
    
    @theme_color.setter
    def theme_color(self, value : aspose.cells.ThemeColor) -> None:
        '''Gets the theme color. Only applies for theme color type.'''
        raise NotImplementedError()
    
    @property
    def color_index(self) -> int:
        '''Gets and sets the color index in the color palette. Only applies of indexed color.'''
        raise NotImplementedError()
    
    @color_index.setter
    def color_index(self, value : int) -> None:
        '''Gets and sets the color index in the color palette. Only applies of indexed color.'''
        raise NotImplementedError()
    
    @property
    def color(self) -> aspose.pydrawing.Color:
        '''Gets and sets the RGB color.'''
        raise NotImplementedError()
    
    @color.setter
    def color(self, value : aspose.pydrawing.Color) -> None:
        '''Gets and sets the RGB color.'''
        raise NotImplementedError()
    
    @property
    def argb(self) -> int:
        '''Gets and sets the color from a 32-bit ARGB value.'''
        raise NotImplementedError()
    
    @argb.setter
    def argb(self, value : int) -> None:
        '''Gets and sets the color from a 32-bit ARGB value.'''
        raise NotImplementedError()
    
    @property
    def transparency(self) -> float:
        '''Gets and sets transparency as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : float) -> None:
        '''Gets and sets transparency as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    

class CellsDataTableFactory:
    '''Utility to build ICellsDataTable from custom objects for user\'s convenience.'''
    
    @overload
    def get_instance(self, vals : List[int], column_names : List[str]) -> aspose.cells.ICellsDataTable:
        '''Creates ICellsDataTable from given sequence of int values.
        
        :param vals: int values to build table
        :param column_names: Column names of the table.
        Its length can only be either 1(build table by the int values vertically)
        or length of the int values(build table by the int values horizontally)
        :returns: Instance of ICellsDataTable'''
        raise NotImplementedError()
    
    @overload
    def get_instance(self, vals : List[int], vertial : bool) -> aspose.cells.ICellsDataTable:
        '''Creates ICellsDataTable from given sequence of int values.
        
        :param vals: int values to build table
        :param vertial: whether build table by the int values vertiacally(true) or horizontally(false)
        :returns: Instance of ICellsDataTable'''
        raise NotImplementedError()
    
    @overload
    def get_instance(self, vals : List[float], column_names : List[str]) -> aspose.cells.ICellsDataTable:
        '''Creates ICellsDataTable from given sequence of double values.
        
        :param vals: double values to build table
        :param column_names: Column names of the table.
        Its length can only be either 1(build table by the double values vertically)
        or length of the double values(build table by the double values horizontally)
        :returns: Instance of ICellsDataTable'''
        raise NotImplementedError()
    
    @overload
    def get_instance(self, vals : List[float], vertial : bool) -> aspose.cells.ICellsDataTable:
        '''Creates ICellsDataTable from given sequence of double values.
        
        :param vals: double values to build table
        :param vertial: whether build table by the double values vertiacally(true) or horizontally(false)
        :returns: Instance of ICellsDataTable'''
        raise NotImplementedError()
    
    @overload
    def get_instance(self, vals : List[Any], column_names : List[str]) -> aspose.cells.ICellsDataTable:
        '''Creates ICellsDataTable from given sequence of objects.
        
        :param vals: objects to build table
        :param column_names: Column names of the table.
        Its length can only be either 1(build table by the objects vertically)
        or length of the objects(build table by the objects horizontally)
        :returns: Instance of ICellsDataTable'''
        raise NotImplementedError()
    
    @overload
    def get_instance(self, vals : List[Any], vertial : bool) -> aspose.cells.ICellsDataTable:
        '''Creates ICellsDataTable from given sequence of objects.
        
        :param vals: objects to build table
        :param vertial: whether build table by the objects vertiacally(true) or horizontally(false)
        :returns: Instance of ICellsDataTable'''
        raise NotImplementedError()
    
    @overload
    def get_instance(self, collection : List[Any]) -> aspose.cells.ICellsDataTable:
        '''Creates ICellsDataTable from given collection.
        
        :param collection: the collection to build table
        :returns: Instance of ICellsDataTable'''
        raise NotImplementedError()
    

class CellsException:
    '''The exception that is thrown when Aspose.Cells specified error occurs.'''
    
    @property
    def code(self) -> aspose.cells.ExceptionType:
        '''Represents custom exception code.'''
        raise NotImplementedError()
    

class CellsFactory:
    '''Utility for instantiating classes of Cells model.'''
    
    def create_style(self) -> aspose.cells.Style:
        '''Creates a new style.
        
        :returns: Returns a style object.'''
        raise NotImplementedError()
    

class CellsHelper:
    '''Provides helper functions.'''
    
    @overload
    @staticmethod
    def create_safe_sheet_name(name_proposal : str) -> str:
        '''Checks given sheet name and create a valid one when needed.
        If given sheet name conforms to the rules of excel sheet name, then return it.
        Otherwise string will be truncated if length exceeds the limit
        and invalid characters will be replaced with \' \', then return the rebuilt string value.
        
        :param name_proposal: sheet name to be used'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_safe_sheet_name(name_proposal : str, replace_char : str) -> str:
        '''Checks given sheet name and create a valid one when needed.
        If given sheet name conforms to the rules of excel sheet name, then return it.
        Otherwise string will be truncated if length exceeds the limit
        and invalid characters will be replaced with given character, then return the rebuilt string value.
        
        :param name_proposal: sheet name to be used
        :param replace_char: character which will be used to replace invalid characters in given sheet name'''
        raise NotImplementedError()
    
    @staticmethod
    def get_text_width(text : str, font : aspose.cells.Font, scaling : float) -> float:
        '''Get width of text in unit of points.
        
        :param text: The text.
        :param font: The font of the text.
        :param scaling: The scaling of text.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_version() -> str:
        '''Get the release version.
        
        :returns: The release version.'''
        raise NotImplementedError()
    
    @staticmethod
    def cell_name_to_index(cell_name : str, row : List[int], column : List[int]) -> None:
        '''Gets the cell row and column indexes according to its name.
        
        :param cell_name: Name of cell.
        :param row: Output row index
        :param column: Output column index'''
        raise NotImplementedError()
    
    @staticmethod
    def cell_index_to_name(row : int, column : int) -> str:
        '''Gets cell name according to its row and column indexes.
        
        :param row: Row index.
        :param column: Column index.
        :returns: Name of cell.'''
        raise NotImplementedError()
    
    @staticmethod
    def column_index_to_name(column : int) -> str:
        '''Gets column name according to column index.
        
        :param column: Column index.
        :returns: Name of column.'''
        raise NotImplementedError()
    
    @staticmethod
    def column_name_to_index(column_name : str) -> int:
        '''Gets column index according to column name.
        
        :param column_name: Column name.
        :returns: Column index.'''
        raise NotImplementedError()
    
    @staticmethod
    def row_index_to_name(row : int) -> str:
        '''Gets row name according to row index.
        
        :param row: Row index.
        :returns: Name of row.'''
        raise NotImplementedError()
    
    @staticmethod
    def row_name_to_index(row_name : str) -> int:
        '''Gets row index according to row name.
        
        :param row_name: Row name.
        :returns: Row index.'''
        raise NotImplementedError()
    
    @staticmethod
    def convert_r1c1_formula_to_a1(r_1c1_formula : str, row : int, column : int) -> str:
        '''Converts the r1c1 formula of the cell to A1 formula.
        
        :param r_1c1_formula: The r1c1 formula.
        :param row: The row index of the cell.
        :param column: The column index of the cell.
        :returns: The A1 formula.'''
        raise NotImplementedError()
    
    @staticmethod
    def convert_a1_formula_to_r1c1(formula : str, row : int, column : int) -> str:
        '''Converts A1 formula of the cell to the r1c1 formula.
        
        :param formula: The A1 formula.
        :param row: The row index of the cell.
        :param column: The column index of the cell.
        :returns: The R1C1 formula.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_date_time_from_double(double_value : float, date1904 : bool) -> datetime:
        '''Convert the double value to the date time value.
        
        :param double_value: The double value.
        :param date1904: Date 1904 system.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_double_from_date_time(date_time : datetime, date1904 : bool) -> float:
        '''Convert the date time to double value.
        
        :param date_time: The date time.
        :param date1904: Date 1904 system.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_used_colors(workbook : aspose.cells.Workbook) -> List[aspose.pydrawing.Color]:
        '''Gets all used colors in the workbook.
        
        :param workbook: The workbook object.
        :returns: The used colors.'''
        raise NotImplementedError()
    
    @staticmethod
    def add_add_in_function(function : str, min_count_of_parameters : int, max_count_of_parameters : int, paramers_type : List[aspose.cells.ParameterType], function_value_type : aspose.cells.ParameterType) -> None:
        '''Add addin function.
        
        :param function: The function name.
        :param min_count_of_parameters: Minimum number of parameters this function requires
        :param max_count_of_parameters: Maximum number of parameters this function allows.
        :param paramers_type: The excepted parameters type of the function
        :param function_value_type: The function value type.'''
        raise NotImplementedError()
    
    @staticmethod
    def merge_files(files : List[str], cached_file : str, dest_file : str) -> None:
        '''Merges some large xls files to a xls file.
        
        :param files: The files.
        :param cached_file: The cached file.
        :param dest_file: The dest file.'''
        raise NotImplementedError()
    
    @staticmethod
    def need_quote_in_formula(sheet_name : str) -> bool:
        '''Indicates whether the name of the sheet should be enclosed in single quotes
        
        :param sheet_name: The name of the sheet'''
        raise NotImplementedError()
    
    @staticmethod
    def init_for_dot_net_core() -> None:
        '''Do the initialization for .NetCore programme.
        We suggest you to call this method for all .NetCore initialization first.
        For example:
        CellsHelper.InitForDotNetCore();
        Workbook wb = new Workbook();'''
        raise NotImplementedError()
    
    significant_digits : int
    '''Gets and sets the number of significant digits.
    The default value is 17.'''
    dpi : float
    '''Gets the DPI of the machine.'''
    startup_path : str
    '''Gets or sets the startup path, which is referred to by some external formula references.'''
    alt_start_path : str
    '''Gets or sets the alternate startup path, which is referred to by some external formula references.'''
    library_path : str
    '''Gets or sets the library path which is referred to by some external formula references.'''
    custom_implementation_factory : aspose.cells.CustomImplementationFactory
    '''Gets or sets the factory for creating instances with special implementation.'''
    is_cloud_platform : bool
    '''Please set this property True when running on a cloud platform, such as: Azure, AWSLambda, etc,'''

class ColorFilter:
    '''Represents filtering the range by color.'''
    
    def get_color(self, sheets : aspose.cells.WorksheetCollection) -> aspose.pydrawing.Color:
        '''Gets the color of this filter.'''
        raise NotImplementedError()
    
    @property
    def filter_by_fill_color(self) -> bool:
        '''Whether filter by the cell\'s fill color.'''
        raise NotImplementedError()
    
    @filter_by_fill_color.setter
    def filter_by_fill_color(self, value : bool) -> None:
        '''Whether filter by the cell\'s fill color.'''
        raise NotImplementedError()
    

class ColorScale:
    '''Describe the ColorScale conditional formatting rule.
    This conditional formatting rule creates a gradated color scale on the cells.'''
    
    @property
    def is_3_color_scale(self) -> bool:
        '''Indicates whether conditional formatting is 3 color scale.'''
        raise NotImplementedError()
    
    @is_3_color_scale.setter
    def is_3_color_scale(self, value : bool) -> None:
        '''Indicates whether conditional formatting is 3 color scale.'''
        raise NotImplementedError()
    
    @property
    def min_cfvo(self) -> aspose.cells.ConditionalFormattingValue:
        '''Get or set this ColorScale\'s min value object.
        Cannot set null or CFValueObject with type FormatConditionValueType.Max to it.'''
        raise NotImplementedError()
    
    @property
    def mid_cfvo(self) -> aspose.cells.ConditionalFormattingValue:
        '''Get or set this ColorScale\'s mid value object.
        Cannot set CFValueObject with type FormatConditionValueType.Max or FormatConditionValueType.Min to it.'''
        raise NotImplementedError()
    
    @property
    def max_cfvo(self) -> aspose.cells.ConditionalFormattingValue:
        '''Get or set this ColorScale\'s max value object.
        Cannot set null or CFValueObject with type FormatConditionValueType.Min to it.'''
        raise NotImplementedError()
    
    @property
    def min_color(self) -> aspose.pydrawing.Color:
        '''Get or set the gradient color for the minimum value in the range.'''
        raise NotImplementedError()
    
    @min_color.setter
    def min_color(self, value : aspose.pydrawing.Color) -> None:
        '''Get or set the gradient color for the minimum value in the range.'''
        raise NotImplementedError()
    
    @property
    def mid_color(self) -> aspose.pydrawing.Color:
        '''Get or set the gradient color for the middle value in the range.'''
        raise NotImplementedError()
    
    @mid_color.setter
    def mid_color(self, value : aspose.pydrawing.Color) -> None:
        '''Get or set the gradient color for the middle value in the range.'''
        raise NotImplementedError()
    
    @property
    def max_color(self) -> aspose.pydrawing.Color:
        '''Get or set the gradient color for the maximum value in the range.'''
        raise NotImplementedError()
    
    @max_color.setter
    def max_color(self, value : aspose.pydrawing.Color) -> None:
        '''Get or set the gradient color for the maximum value in the range.'''
        raise NotImplementedError()
    

class Column:
    '''Represents a single column in a worksheet.'''
    
    def apply_style(self, style : aspose.cells.Style, flag : aspose.cells.StyleFlag) -> None:
        '''Applies formats for a whole column.
        
        :param style: The style object which will be applied.
        :param flag: Flags which indicates applied formatting properties.'''
        raise NotImplementedError()
    
    def get_style(self) -> aspose.cells.Style:
        '''Gets the style of this column.'''
        raise NotImplementedError()
    
    def set_style(self, style : aspose.cells.Style) -> None:
        '''Sets the style of this column.
        
        :param style: the style to be used as the default style for cells in this column.'''
        raise NotImplementedError()
    
    @property
    def index(self) -> int:
        '''Gets the index of this column.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> float:
        '''Gets and sets the column width in unit of characters.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : float) -> None:
        '''Gets and sets the column width in unit of characters.'''
        raise NotImplementedError()
    
    @property
    def group_level(self) -> int:
        '''Gets the group level of the column.'''
        raise NotImplementedError()
    
    @group_level.setter
    def group_level(self, value : int) -> None:
        '''Gets the group level of the column.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the column is hidden.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the column is hidden.'''
        raise NotImplementedError()
    
    @property
    def has_custom_style(self) -> bool:
        '''Indicates whether this column has custom style settings(different from the default one inherited from workbook).'''
        raise NotImplementedError()
    
    @property
    def style(self) -> aspose.cells.Style:
        '''Gets the style of this column.'''
        raise NotImplementedError()
    
    @property
    def is_collapsed(self) -> bool:
        '''whether the column is collapsed'''
        raise NotImplementedError()
    
    @is_collapsed.setter
    def is_collapsed(self, value : bool) -> None:
        '''whether the column is collapsed'''
        raise NotImplementedError()
    

class ColumnCollection:
    '''Collection of the :py:class:`aspose.cells.Column` objects that represent the individual column(setting)s in a worksheet.
    The Column object only represents the settings such as column width, styles, .etc. for the whole column,
    has nothing to do with the fact that there are non-empty cells(data) or not in corresponding column.
    And the "Count" of this collection only represents the count Column objects that have been instantiated in this collection,
    has nothing to do with the fact that there are non-empty cells(data) or not in the worksheet.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.Column]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.Column], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Column, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Column, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Column) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Column, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Column, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def get_by_index(self, index : int) -> aspose.cells.Column:
        '''Gets the column object by the index.
        
        :returns: Returns the column object.'''
        raise NotImplementedError()
    
    def get_column_by_index(self, index : int) -> aspose.cells.Column:
        '''Gets the :py:class:`aspose.cells.Column` object by the position in the list.
        
        :param index: The position in the list.
        :returns: Returns the column object.'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.Column) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class Comment:
    '''Encapsulates the object that represents a cell comment.'''
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Format some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the comment text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the comment text.
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the comment text.
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    @property
    def author(self) -> str:
        '''Gets and sets Name of the original comment author'''
        raise NotImplementedError()
    
    @author.setter
    def author(self, value : str) -> None:
        '''Gets and sets Name of the original comment author'''
        raise NotImplementedError()
    
    @property
    def comment_shape(self) -> aspose.cells.drawing.CommentShape:
        '''Get a Shape object that represents the shape attached to the specified comment.'''
        raise NotImplementedError()
    
    @property
    def row(self) -> int:
        '''Gets the row index of the comment.'''
        raise NotImplementedError()
    
    @property
    def column(self) -> int:
        '''Gets the column index of the comment.'''
        raise NotImplementedError()
    
    @property
    def is_threaded_comment(self) -> bool:
        '''Indicates whether this comment is a threaded comment.'''
        raise NotImplementedError()
    
    @property
    def threaded_comments(self) -> aspose.cells.ThreadedCommentCollection:
        '''Gets the list of threaded comments;'''
        raise NotImplementedError()
    
    @property
    def note(self) -> str:
        '''Represents the content of comment.'''
        raise NotImplementedError()
    
    @note.setter
    def note(self, value : str) -> None:
        '''Represents the content of comment.'''
        raise NotImplementedError()
    
    @property
    def html_note(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this comment.'''
        raise NotImplementedError()
    
    @html_note.setter
    def html_note(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this comment.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Gets the font of comment.'''
        raise NotImplementedError()
    
    @property
    def is_visible(self) -> bool:
        '''Represents if the comment is visible or not.'''
        raise NotImplementedError()
    
    @is_visible.setter
    def is_visible(self, value : bool) -> None:
        '''Represents if the comment is visible or not.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the comment.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the comment.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the comment.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the comment.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the comment.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the comment.'''
        raise NotImplementedError()
    
    @property
    def auto_size(self) -> bool:
        '''Indicates if size of comment is adjusted automatically according to its content.'''
        raise NotImplementedError()
    
    @auto_size.setter
    def auto_size(self, value : bool) -> None:
        '''Indicates if size of comment is adjusted automatically according to its content.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the comment, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the comment, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the comment, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the comment, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of the comment, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of the comment, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the Height of the comment, in unit of pixels.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the Height of the comment, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the comment, in unit of inches.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the comment, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the comment, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the comment, in unit of inches.'''
        raise NotImplementedError()
    

class CommentCollection:
    '''Encapsulates a collection of :py:class:`aspose.cells.Comment` objects.'''
    
    @overload
    def add_threaded_comment(self, row : int, column : int, text : str, author : aspose.cells.ThreadedCommentAuthor) -> int:
        '''Adds a threaded comment.
        
        :param row: Cell row index.
        :param column: Cell column index.
        :param text: The text of the comment
        :param author: The user of this threaded comment.
        :returns: :py:class:`aspose.cells.ThreadedComment` object index.'''
        raise NotImplementedError()
    
    @overload
    def add_threaded_comment(self, cell_name : str, text : str, author : aspose.cells.ThreadedCommentAuthor) -> int:
        '''Adds a threaded comment.
        
        :param cell_name: The name of the cell.
        :param text: The text of the comment
        :param author: The user of this threaded comment.
        :returns: :py:class:`aspose.cells.ThreadedComment` object index.'''
        raise NotImplementedError()
    
    @overload
    def get_threaded_comments(self, row : int, column : int) -> aspose.cells.ThreadedCommentCollection:
        '''Gets the threaded comments by row and column index.
        
        :param row: The row index.
        :param column: The column index.'''
        raise NotImplementedError()
    
    @overload
    def get_threaded_comments(self, cell_name : str) -> aspose.cells.ThreadedCommentCollection:
        '''Gets the threaded comments by cell name.
        
        :param cell_name: The name of the cell.'''
        raise NotImplementedError()
    
    @overload
    def add(self, row : int, column : int) -> int:
        '''Adds a comment to the collection.
        
        :param row: Cell row index.
        :param column: Cell column index.
        :returns: :py:class:`aspose.cells.Comment` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, cell_name : str) -> int:
        '''Adds a comment to the collection.
        
        :param cell_name: Cell name.
        :returns: :py:class:`aspose.cells.Comment` object index.'''
        raise NotImplementedError()
    
    @overload
    def remove_at(self, cell_name : str) -> None:
        '''Removes the comment of the specific cell.
        
        :param cell_name: The name of cell which contains a comment.'''
        raise NotImplementedError()
    
    @overload
    def remove_at(self, row : int, column : int) -> None:
        '''Removes the comment of the specific cell.
        
        :param row: The row index.
        :param column: the column index.'''
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.Comment]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.Comment], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Comment, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Comment, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Comment) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Comment, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Comment, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def get(self, row : int, column : int) -> aspose.cells.Comment:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.Comment) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class ConditionalFormattingCollection:
    '''Encapsulates a collection of :py:class:`aspose.cells.FormatCondition` objects.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.FormatConditionCollection]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.FormatConditionCollection], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.FormatConditionCollection, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.FormatConditionCollection, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.FormatConditionCollection) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.FormatConditionCollection, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.FormatConditionCollection, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def remove_area(self, start_row : int, start_column : int, total_rows : int, total_columns : int) -> None:
        '''Remove all conditional formatting in the range.
        
        :param start_row: The start row of the range.
        :param start_column: The start column of the range.
        :param total_rows: The number of rows of the range.
        :param total_columns: The number of columns of the range.'''
        raise NotImplementedError()
    
    def add(self) -> int:
        '''Adds a FormatConditions to the collection.
        
        :returns: FormatConditions object index.'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.FormatConditionCollection) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class ConditionalFormattingIcon:
    '''Represents  the custom  icon of conditional formatting rule.'''
    
    @staticmethod
    def get_icon_image_data(type : aspose.cells.IconSetType, index : int) -> List[int]:
        '''Get the icon set data
        
        :param type: icon\'s type
        :param index: icon\'s index'''
        raise NotImplementedError()
    
    def get_image_data(self, cell : aspose.cells.Cell) -> List[int]:
        '''Gets the image data with the setting of cell.
        
        :param cell: The setting of cell.
        :returns: Returns the image data of icon.'''
        raise NotImplementedError()
    
    @property
    def image_data(self) -> List[int]:
        '''Gets the icon set data.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.IconSetType:
        '''Gets and sets the icon set type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.cells.IconSetType) -> None:
        '''Gets and sets the icon set type.'''
        raise NotImplementedError()
    
    @property
    def index(self) -> int:
        '''Gets and sets the icon\'s index in the icon set.'''
        raise NotImplementedError()
    
    @index.setter
    def index(self, value : int) -> None:
        '''Gets and sets the icon\'s index in the icon set.'''
        raise NotImplementedError()
    

class ConditionalFormattingIconCollection:
    '''Represents  a collection of :py:class:`aspose.cells.ConditionalFormattingIcon` objects.'''
    
    @overload
    def add(self, type : aspose.cells.IconSetType, index : int) -> int:
        '''Adds :py:class:`aspose.cells.ConditionalFormattingIcon` object.
        
        :param type: The value type.
        :param index: The Index.
        :returns: Returns the index of new object in the list.'''
        raise NotImplementedError()
    
    @overload
    def add(self, cficon : aspose.cells.ConditionalFormattingIcon) -> int:
        '''Adds :py:class:`aspose.cells.ConditionalFormattingIcon` object.
        
        :param cficon: Returns the index of new object in the list.'''
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.ConditionalFormattingIcon]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.ConditionalFormattingIcon], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.ConditionalFormattingIcon, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.ConditionalFormattingIcon, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ConditionalFormattingIcon) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ConditionalFormattingIcon, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ConditionalFormattingIcon, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.ConditionalFormattingIcon) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class ConditionalFormattingResult:
    '''Represents the result of conditional formatting which applies to a cell.'''
    
    @property
    def conditional_style(self) -> aspose.cells.Style:
        '''Gets the conditional result style.'''
        raise NotImplementedError()
    
    @property
    def conditional_formatting_icon(self) -> aspose.cells.ConditionalFormattingIcon:
        '''Gets the image of icon set.'''
        raise NotImplementedError()
    
    @property
    def conditional_formatting_data_bar(self) -> aspose.cells.DataBar:
        '''Gets the DataBar object.'''
        raise NotImplementedError()
    
    @property
    def conditional_formatting_color_scale(self) -> aspose.cells.ColorScale:
        '''Gets the ColorScale object.'''
        raise NotImplementedError()
    
    @property
    def color_scale_result(self) -> aspose.pydrawing.Color:
        '''Gets the display color of color scale.'''
        raise NotImplementedError()
    

class ConditionalFormattingValue:
    '''Describes the values of the interpolation points in a gradient scale, dataBar or iconSet.'''
    
    @property
    def value(self) -> Any:
        '''Get or set the value of this conditional formatting value object.
        It should be used in conjunction with Type.'''
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : Any) -> None:
        '''Get or set the value of this conditional formatting value object.
        It should be used in conjunction with Type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.FormatConditionValueType:
        '''Get or set the type of this conditional formatting value object.
        Setting the type to FormatConditionValueType.Min or FormatConditionValueType.Max
        will auto set "Value" to null.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.cells.FormatConditionValueType) -> None:
        '''Get or set the type of this conditional formatting value object.
        Setting the type to FormatConditionValueType.Min or FormatConditionValueType.Max
        will auto set "Value" to null.'''
        raise NotImplementedError()
    
    @property
    def is_gte(self) -> bool:
        '''Get or set the Greater Than Or Equal flag.
        Use only for icon sets, determines whether this threshold value uses
        the greater than or equal to operator.
        \'false\' indicates \'greater than\' is used instead of \'greater than or equal to\'.
        Default value is true.'''
        raise NotImplementedError()
    
    @is_gte.setter
    def is_gte(self, value : bool) -> None:
        '''Get or set the Greater Than Or Equal flag.
        Use only for icon sets, determines whether this threshold value uses
        the greater than or equal to operator.
        \'false\' indicates \'greater than\' is used instead of \'greater than or equal to\'.
        Default value is true.'''
        raise NotImplementedError()
    

class ConditionalFormattingValueCollection:
    '''Describes a collection of CFValueObject.
    Use only for icon sets.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.ConditionalFormattingValue]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.ConditionalFormattingValue], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.ConditionalFormattingValue, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.ConditionalFormattingValue, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ConditionalFormattingValue) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ConditionalFormattingValue, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ConditionalFormattingValue, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def add(self, type : aspose.cells.FormatConditionValueType, value : str) -> int:
        '''Adds :py:class:`aspose.cells.ConditionalFormattingValue` object.
        
        :param type: The value type.
        :param value: The value.
        :returns: Returns the index of new object in the list.'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.ConditionalFormattingValue) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class CopyOptions:
    '''Represents the copy options.'''
    
    @property
    def keep_macros(self) -> bool:
        '''Indicates whether keeping macros;'''
        raise NotImplementedError()
    
    @keep_macros.setter
    def keep_macros(self, value : bool) -> None:
        '''Indicates whether keeping macros;'''
        raise NotImplementedError()
    
    @property
    def extend_to_adjacent_range(self) -> bool:
        '''Indicates whether extend ranges when copying the range to adjacent range.'''
        raise NotImplementedError()
    
    @extend_to_adjacent_range.setter
    def extend_to_adjacent_range(self, value : bool) -> None:
        '''Indicates whether extend ranges when copying the range to adjacent range.'''
        raise NotImplementedError()
    
    @property
    def copy_names(self) -> bool:
        '''Indicates whether copying the names.'''
        raise NotImplementedError()
    
    @copy_names.setter
    def copy_names(self, value : bool) -> None:
        '''Indicates whether copying the names.'''
        raise NotImplementedError()
    
    @property
    def copy_invalid_formulas_as_values(self) -> bool:
        '''If the formula is not valid for the dest destination, only copy values.'''
        raise NotImplementedError()
    
    @copy_invalid_formulas_as_values.setter
    def copy_invalid_formulas_as_values(self, value : bool) -> None:
        '''If the formula is not valid for the dest destination, only copy values.'''
        raise NotImplementedError()
    
    @property
    def column_character_width(self) -> bool:
        '''Indicates whether copying column width in unit of characters.'''
        raise NotImplementedError()
    
    @column_character_width.setter
    def column_character_width(self, value : bool) -> None:
        '''Indicates whether copying column width in unit of characters.'''
        raise NotImplementedError()
    
    @property
    def refer_to_sheet_with_same_name(self) -> bool:
        '''In ms excel, when copying formulas which refer to other worksheets while copying a worksheet to another one,
        the copied formulas should refer to source workbook.
        However, for some situations user may need the copied formulas refer to worksheets with the same name
        in the same workbook, such as when those worksheets have been copied before this copy operation,
        then this property should be kept as true.'''
        raise NotImplementedError()
    
    @refer_to_sheet_with_same_name.setter
    def refer_to_sheet_with_same_name(self, value : bool) -> None:
        '''In ms excel, when copying formulas which refer to other worksheets while copying a worksheet to another one,
        the copied formulas should refer to source workbook.
        However, for some situations user may need the copied formulas refer to worksheets with the same name
        in the same workbook, such as when those worksheets have been copied before this copy operation,
        then this property should be kept as true.'''
        raise NotImplementedError()
    
    @property
    def refer_to_destination_sheet(self) -> bool:
        '''When copying the range in the same file and the chart refers to the source sheet,
        False means the copied chart\'s data source will not be changed.
        True means the copied chart\'s data source refers to the destination sheet.'''
        raise NotImplementedError()
    
    @refer_to_destination_sheet.setter
    def refer_to_destination_sheet(self, value : bool) -> None:
        '''When copying the range in the same file and the chart refers to the source sheet,
        False means the copied chart\'s data source will not be changed.
        True means the copied chart\'s data source refers to the destination sheet.'''
        raise NotImplementedError()
    

class CustomFilter:
    '''Represents the custom filter.'''
    
    def set_criteria(self, filter_operator : aspose.cells.FilterOperatorType, criteria : Any) -> None:
        '''Sets the filter criteria.
        
        :param filter_operator: filter operator type
        :param criteria: filter criteria value'''
        raise NotImplementedError()
    
    @property
    def filter_operator_type(self) -> aspose.cells.FilterOperatorType:
        '''Gets and sets the filter operator type.'''
        raise NotImplementedError()
    
    @filter_operator_type.setter
    def filter_operator_type(self, value : aspose.cells.FilterOperatorType) -> None:
        '''Gets and sets the filter operator type.'''
        raise NotImplementedError()
    
    @property
    def criteria(self) -> Any:
        '''Gets and sets the criteria.'''
        raise NotImplementedError()
    
    @criteria.setter
    def criteria(self, value : Any) -> None:
        '''Gets and sets the criteria.'''
        raise NotImplementedError()
    

class CustomFilterCollection:
    '''Represents the custom filters.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.CustomFilter]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.CustomFilter], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.CustomFilter, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.CustomFilter, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.CustomFilter) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.CustomFilter, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.CustomFilter, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.CustomFilter) -> int:
        raise NotImplementedError()
    
    @property
    def both(self) -> bool:
        '''Indicates whether the two criteria have an "and" relationship.'''
        raise NotImplementedError()
    
    @both.setter
    def both(self, value : bool) -> None:
        '''Indicates whether the two criteria have an "and" relationship.'''
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class CustomFunctionDefinition:
    '''Definition of custom function for calculating with user\'s custom engine.'''
    
    def get_array_mode_parameters(self, function_name : str) -> List[int]:
        '''Gets the indices of given custom function\'s parameters that need to be calculated in array mode.
        
        :param function_name: Name of the custom function.
        :returns: Indices of the parameters that need to be calculated in array mode for given custom function.
        Default is null, there is no parameter which needs to be calculated in array mode for the custom function.'''
        raise NotImplementedError()
    

class CustomImplementationFactory:
    '''Factory to create some instances which may be re-implemented by user for special purpose.'''
    

class DataBar:
    '''Describe the DataBar conditional formatting rule.
    This conditional formatting rule displays a gradated
    data bar in the range of cells.'''
    
    def to_image(self, cell : aspose.cells.Cell, img_opts : aspose.cells.rendering.ImageOrPrintOptions) -> List[int]:
        '''Render data bar in cell to image byte array.
        
        :param cell: Indicate the data bar in which cell to be rendered
        :param img_opts: ImageOrPrintOptions contains some property of output image'''
        raise NotImplementedError()
    
    @property
    def axis_color(self) -> aspose.pydrawing.Color:
        '''Gets the color of the axis for cells with conditional formatting as data bars.'''
        raise NotImplementedError()
    
    @axis_color.setter
    def axis_color(self, value : aspose.pydrawing.Color) -> None:
        '''Gets the color of the axis for cells with conditional formatting as data bars.'''
        raise NotImplementedError()
    
    @property
    def axis_position(self) -> aspose.cells.DataBarAxisPosition:
        '''Gets the position of the axis of the data bars specified by a conditional formatting rule.'''
        raise NotImplementedError()
    
    @axis_position.setter
    def axis_position(self, value : aspose.cells.DataBarAxisPosition) -> None:
        '''Sets the position of the axis of the data bars specified by a conditional formatting rule.'''
        raise NotImplementedError()
    
    @property
    def bar_fill_type(self) -> aspose.cells.DataBarFillType:
        '''Gets how a data bar is filled with color.'''
        raise NotImplementedError()
    
    @bar_fill_type.setter
    def bar_fill_type(self, value : aspose.cells.DataBarFillType) -> None:
        '''Sets how a data bar is filled with color.'''
        raise NotImplementedError()
    
    @property
    def direction(self) -> aspose.cells.TextDirectionType:
        '''Gets the direction the databar is displayed.'''
        raise NotImplementedError()
    
    @direction.setter
    def direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Sets the direction the databar is displayed.'''
        raise NotImplementedError()
    
    @property
    def bar_border(self) -> aspose.cells.DataBarBorder:
        '''Gets an object that specifies the border of a data bar.'''
        raise NotImplementedError()
    
    @property
    def negative_bar_format(self) -> aspose.cells.NegativeBarFormat:
        '''Gets the NegativeBarFormat object associated with a data bar conditional formatting rule.'''
        raise NotImplementedError()
    
    @property
    def min_cfvo(self) -> aspose.cells.ConditionalFormattingValue:
        '''Get or set this DataBar\'s min value object.
        Cannot set null or CFValueObject with type FormatConditionValueType.Max to it.'''
        raise NotImplementedError()
    
    @property
    def max_cfvo(self) -> aspose.cells.ConditionalFormattingValue:
        '''Get or set this DataBar\'s max value object.
        Cannot set null or CFValueObject with type FormatConditionValueType.Min to it.'''
        raise NotImplementedError()
    
    @property
    def color(self) -> aspose.pydrawing.Color:
        '''Get or set this DataBar\'s Color.'''
        raise NotImplementedError()
    
    @color.setter
    def color(self, value : aspose.pydrawing.Color) -> None:
        '''Get or set this DataBar\'s Color.'''
        raise NotImplementedError()
    
    @property
    def min_length(self) -> int:
        '''Represents the min length of data bar .'''
        raise NotImplementedError()
    
    @min_length.setter
    def min_length(self, value : int) -> None:
        '''Represents the min length of data bar .'''
        raise NotImplementedError()
    
    @property
    def max_length(self) -> int:
        '''Represents the max length of data bar .'''
        raise NotImplementedError()
    
    @max_length.setter
    def max_length(self, value : int) -> None:
        '''Represents the max length of data bar .'''
        raise NotImplementedError()
    
    @property
    def show_value(self) -> bool:
        '''Get or set the flag indicating whether to show the values of the cells on which this data bar is applied.
        Default value is true.'''
        raise NotImplementedError()
    
    @show_value.setter
    def show_value(self, value : bool) -> None:
        '''Get or set the flag indicating whether to show the values of the cells on which this data bar is applied.
        Default value is true.'''
        raise NotImplementedError()
    

class DataBarBorder:
    '''Represents the border of the data bars specified by a conditional formatting rule.'''
    
    @property
    def color(self) -> aspose.pydrawing.Color:
        '''Gets the border\'s color of data bars specified by a conditional formatting rule.'''
        raise NotImplementedError()
    
    @color.setter
    def color(self, value : aspose.pydrawing.Color) -> None:
        '''Sets the border\'s color of data bars specified by a conditional formatting rule.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.DataBarBorderType:
        '''Gets the border\'s type of data bars specified by a conditional formatting rule.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.cells.DataBarBorderType) -> None:
        '''Sets the border\'s type of data bars specified by a conditional formatting rule.'''
        raise NotImplementedError()
    

class DataSorter:
    '''Summary description for DataSorter.'''
    
    @overload
    def add_key(self, key : int, order : aspose.cells.SortOrder) -> None:
        '''Adds sorted column index and sort order.
        
        :param key: The sorted column index(absolute position, column A is 0, B is 1, ...)
        :param order: The sort order'''
        raise NotImplementedError()
    
    @overload
    def add_key(self, key : int, order : aspose.cells.SortOrder, custom_list : str) -> None:
        '''Adds sorted column index and sort order with custom sort list.
        
        :param key: The sorted column index(absolute position, column A is 0, B is 1, ...)
        :param order: The sort order.
        :param custom_list: The custom sort list.'''
        raise NotImplementedError()
    
    @overload
    def add_key(self, key : int, type : aspose.cells.SortOnType, order : aspose.cells.SortOrder, custom_list : Any) -> None:
        '''Adds sorted column index and sort order with custom sort list.
        
        :param key: The sorted column index(absolute position, column A is 0, B is 1, ...)
        :param type: The sorted value type.
        :param order: The sort order.
        :param custom_list: The custom sort list.'''
        raise NotImplementedError()
    
    @overload
    def add_key(self, key : int, order : aspose.cells.SortOrder, custom_list : List[str]) -> None:
        '''Adds sorted column index and sort order with custom sort list.
        
        :param key: The sorted column index(absolute position, column A is 0, B is 1, ...)
        :param order: The sort order.
        :param custom_list: The custom sort list.'''
        raise NotImplementedError()
    
    @overload
    def sort(self, cells : aspose.cells.Cells, start_row : int, start_column : int, end_row : int, end_column : int) -> List[int]:
        '''Sorts the data of the area.
        
        :param cells: The cells contains the data area.
        :param start_row: The start row of the area.
        :param start_column: The start column of the area.
        :param end_row: The end row of the area.
        :param end_column: The end column of the area.
        :returns: the original indices(absolute position, for example, column A is 0, B is 1, ...) of the sorted rows/columns.
        If no rows/columns needs to be moved by this sorting operation, null will be returned.'''
        raise NotImplementedError()
    
    @overload
    def sort(self, cells : aspose.cells.Cells, area : aspose.cells.CellArea) -> List[int]:
        '''Sort the data of the area.
        
        :param cells: The cells contains the data area.
        :param area: The area needed to sort
        :returns: the original indices(absolute position, for example, column A is 0, B is 1, ...) of the sorted rows/columns.
        If no rows/columns needs to be moved by this sorting operation, null will be returned.'''
        raise NotImplementedError()
    
    @overload
    def sort(self) -> List[int]:
        '''Sort the data in the range.
        
        :returns: the original indices(absolute position, for example, column A is 0, B is 1, ...) of the sorted rows/columns.
        If no rows/columns needs to be moved by this sorting operation, null will be returned.'''
        raise NotImplementedError()
    
    def clear(self) -> None:
        '''Clear all settings.'''
        raise NotImplementedError()
    
    @property
    def keys(self) -> aspose.cells.DataSorterKeyCollection:
        '''Gets the key list of data sorter.'''
        raise NotImplementedError()
    
    @property
    def has_headers(self) -> bool:
        '''Represents whether the range has headers.'''
        raise NotImplementedError()
    
    @has_headers.setter
    def has_headers(self, value : bool) -> None:
        '''Represents whether the range has headers.'''
        raise NotImplementedError()
    
    @property
    def key1(self) -> int:
        '''Represents first sorted column index(absolute position, column A is 0, B is 1, ...).'''
        raise NotImplementedError()
    
    @key1.setter
    def key1(self, value : int) -> None:
        '''Represents first sorted column index(absolute position, column A is 0, B is 1, ...).'''
        raise NotImplementedError()
    
    @property
    def order1(self) -> aspose.cells.SortOrder:
        '''Represents sort order of the first key.'''
        raise NotImplementedError()
    
    @order1.setter
    def order1(self, value : aspose.cells.SortOrder) -> None:
        '''Represents sort order of the first key.'''
        raise NotImplementedError()
    
    @property
    def key2(self) -> int:
        '''Represents second sorted column index(absolute position, column A is 0, B is 1, ...).'''
        raise NotImplementedError()
    
    @key2.setter
    def key2(self, value : int) -> None:
        '''Represents second sorted column index(absolute position, column A is 0, B is 1, ...).'''
        raise NotImplementedError()
    
    @property
    def order2(self) -> aspose.cells.SortOrder:
        '''Represents sort order of the second key.'''
        raise NotImplementedError()
    
    @order2.setter
    def order2(self, value : aspose.cells.SortOrder) -> None:
        '''Represents sort order of the second key.'''
        raise NotImplementedError()
    
    @property
    def key3(self) -> int:
        '''Represents third sorted column index(absolute position, column A is 0, B is 1, ...).'''
        raise NotImplementedError()
    
    @key3.setter
    def key3(self, value : int) -> None:
        '''Represents third sorted column index(absolute position, column A is 0, B is 1, ...).'''
        raise NotImplementedError()
    
    @property
    def order3(self) -> aspose.cells.SortOrder:
        '''Represents sort order of the third key.'''
        raise NotImplementedError()
    
    @order3.setter
    def order3(self, value : aspose.cells.SortOrder) -> None:
        '''Represents sort order of the third key.'''
        raise NotImplementedError()
    
    @property
    def sort_left_to_right(self) -> bool:
        '''True means that sorting orientation is from left to right.
        False means that sorting orientation is from top to bottom.
        The default value is false.'''
        raise NotImplementedError()
    
    @sort_left_to_right.setter
    def sort_left_to_right(self, value : bool) -> None:
        '''True means that sorting orientation is from left to right.
        False means that sorting orientation is from top to bottom.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def case_sensitive(self) -> bool:
        '''Gets and sets whether case sensitive when comparing string.'''
        raise NotImplementedError()
    
    @case_sensitive.setter
    def case_sensitive(self, value : bool) -> None:
        '''Gets and sets whether case sensitive when comparing string.'''
        raise NotImplementedError()
    
    @property
    def sort_as_number(self) -> bool:
        '''Indicates whether sorting anything that looks like a number.'''
        raise NotImplementedError()
    
    @sort_as_number.setter
    def sort_as_number(self, value : bool) -> None:
        '''Indicates whether sorting anything that looks like a number.'''
        raise NotImplementedError()
    

class DataSorterKey:
    '''Represents the key of the data sorter.'''
    
    @property
    def order(self) -> aspose.cells.SortOrder:
        '''Indicates the order of sorting.'''
        raise NotImplementedError()
    
    @property
    def index(self) -> int:
        '''Gets the sorted column index(absolute position, column A is 0, B is 1, ...).'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.SortOnType:
        '''Represents the type of sorting.'''
        raise NotImplementedError()
    
    @property
    def icon_set_type(self) -> aspose.cells.IconSetType:
        '''Represents the icon set type.'''
        raise NotImplementedError()
    
    @property
    def icon_id(self) -> int:
        '''Represents the id of the icon set type.'''
        raise NotImplementedError()
    
    @property
    def color(self) -> aspose.pydrawing.Color:
        '''Gets the sorted color.'''
        raise NotImplementedError()
    

class DataSorterKeyCollection:
    '''Represents the key list of data sorter.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.DataSorterKey]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.DataSorterKey], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.DataSorterKey, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.DataSorterKey, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.DataSorterKey) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.DataSorterKey, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.DataSorterKey, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.DataSorterKey) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class DateTimeGroupItem:
    '''Represents the datetime\'s group setting.'''
    
    @property
    def min_value(self) -> datetime:
        '''Gets the min value.'''
        raise NotImplementedError()
    
    @property
    def date_time_grouping_type(self) -> aspose.cells.DateTimeGroupingType:
        '''Gets and sets the group type.'''
        raise NotImplementedError()
    
    @date_time_grouping_type.setter
    def date_time_grouping_type(self, value : aspose.cells.DateTimeGroupingType) -> None:
        '''Gets and sets the group type.'''
        raise NotImplementedError()
    
    @property
    def year(self) -> int:
        '''Gets and sets the year of the grouped date time.'''
        raise NotImplementedError()
    
    @year.setter
    def year(self, value : int) -> None:
        '''Gets and sets the year of the grouped date time.'''
        raise NotImplementedError()
    
    @property
    def month(self) -> int:
        '''Gets and sets the month of the grouped date time.'''
        raise NotImplementedError()
    
    @month.setter
    def month(self, value : int) -> None:
        '''Gets and sets the month of the grouped date time.'''
        raise NotImplementedError()
    
    @property
    def day(self) -> int:
        '''Gets and sets the day of the grouped date time.'''
        raise NotImplementedError()
    
    @day.setter
    def day(self, value : int) -> None:
        '''Gets and sets the day of the grouped date time.'''
        raise NotImplementedError()
    
    @property
    def hour(self) -> int:
        '''Gets and sets the hour of the grouped date time.'''
        raise NotImplementedError()
    
    @hour.setter
    def hour(self, value : int) -> None:
        '''Gets and sets the hour of the grouped date time.'''
        raise NotImplementedError()
    
    @property
    def minute(self) -> int:
        '''Gets and sets the minute of the grouped date time.'''
        raise NotImplementedError()
    
    @minute.setter
    def minute(self, value : int) -> None:
        '''Gets and sets the minute of the grouped date time.'''
        raise NotImplementedError()
    
    @property
    def second(self) -> int:
        '''Gets and sets the second of the grouped date time.'''
        raise NotImplementedError()
    
    @second.setter
    def second(self, value : int) -> None:
        '''Gets and sets the second of the grouped date time.'''
        raise NotImplementedError()
    

class DefaultStyleSettings:
    '''Settings for the default values of workbook\'s style properties.'''
    
    @property
    def built_in_preference(self) -> bool:
        raise NotImplementedError()
    
    @built_in_preference.setter
    def built_in_preference(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def font_name(self) -> str:
        '''Gets/Sets the default font name for the workbook'''
        raise NotImplementedError()
    
    @font_name.setter
    def font_name(self, value : str) -> None:
        '''Gets/Sets the default font name for the workbook'''
        raise NotImplementedError()
    
    @property
    def font_size(self) -> float:
        '''Gets/Sets the default standard font size for the workbook.'''
        raise NotImplementedError()
    
    @font_size.setter
    def font_size(self, value : float) -> None:
        '''Gets/Sets the default standard font size for the workbook.'''
        raise NotImplementedError()
    
    @property
    def horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets/Sets the default value for horizontal alignment'''
        raise NotImplementedError()
    
    @horizontal_alignment.setter
    def horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets/Sets the default value for horizontal alignment'''
        raise NotImplementedError()
    
    @property
    def vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets/Sets the default value for vertical alignment'''
        raise NotImplementedError()
    
    @vertical_alignment.setter
    def vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets/Sets the default value for vertical alignment'''
        raise NotImplementedError()
    

class DeleteBlankOptions(DeleteOptions):
    
    @property
    def update_reference(self) -> bool:
        '''Indicates if update references in other worksheets.'''
        raise NotImplementedError()
    
    @update_reference.setter
    def update_reference(self, value : bool) -> None:
        '''Indicates if update references in other worksheets.'''
        raise NotImplementedError()
    
    @property
    def empty_string_as_blank(self) -> bool:
        raise NotImplementedError()
    
    @empty_string_as_blank.setter
    def empty_string_as_blank(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def empty_formula_value_as_blank(self) -> bool:
        raise NotImplementedError()
    
    @empty_formula_value_as_blank.setter
    def empty_formula_value_as_blank(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def drawings_as_blank(self) -> bool:
        raise NotImplementedError()
    
    @drawings_as_blank.setter
    def drawings_as_blank(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def merged_cells_shrink_type(self) -> aspose.cells.MergedCellsShrinkType:
        raise NotImplementedError()
    
    @merged_cells_shrink_type.setter
    def merged_cells_shrink_type(self, value : aspose.cells.MergedCellsShrinkType) -> None:
        raise NotImplementedError()
    
    @property
    def start_index(self) -> int:
        raise NotImplementedError()
    
    @start_index.setter
    def start_index(self, value : int) -> None:
        raise NotImplementedError()
    
    @property
    def end_index(self) -> int:
        raise NotImplementedError()
    
    @end_index.setter
    def end_index(self, value : int) -> None:
        raise NotImplementedError()
    

class DeleteOptions:
    '''Represents the setting of deleting rows/columns.'''
    
    @property
    def update_reference(self) -> bool:
        '''Indicates if update references in other worksheets.'''
        raise NotImplementedError()
    
    @update_reference.setter
    def update_reference(self, value : bool) -> None:
        '''Indicates if update references in other worksheets.'''
        raise NotImplementedError()
    

class DifSaveOptions(SaveOptions):
    '''Represents the options of saving dif file.'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    

class DocxSaveOptions(PaginatedSaveOptions):
    '''Represents options of saving .docx file.'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def default_font(self) -> str:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set the DefaultFont such as MingLiu or MS Gothic to show these characters.
        If this property is not set, Aspose.Cells will use system default font to show these unicode characters.'''
        raise NotImplementedError()
    
    @default_font.setter
    def default_font(self, value : str) -> None:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set the DefaultFont such as MingLiu or MS Gothic to show these characters.
        If this property is not set, Aspose.Cells will use system default font to show these unicode characters.'''
        raise NotImplementedError()
    
    @property
    def check_workbook_default_font(self) -> bool:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set this to true to try to use workbook\'s default font to show these characters first.'''
        raise NotImplementedError()
    
    @check_workbook_default_font.setter
    def check_workbook_default_font(self, value : bool) -> None:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set this to true to try to use workbook\'s default font to show these characters first.'''
        raise NotImplementedError()
    
    @property
    def check_font_compatibility(self) -> bool:
        '''Indicates whether to check font compatibility for every character in text.'''
        raise NotImplementedError()
    
    @check_font_compatibility.setter
    def check_font_compatibility(self, value : bool) -> None:
        '''Indicates whether to check font compatibility for every character in text.'''
        raise NotImplementedError()
    
    @property
    def is_font_substitution_char_granularity(self) -> bool:
        '''Indicates whether to only substitute the font of character when the cell font is not compatibility for it.'''
        raise NotImplementedError()
    
    @is_font_substitution_char_granularity.setter
    def is_font_substitution_char_granularity(self, value : bool) -> None:
        '''Indicates whether to only substitute the font of character when the cell font is not compatibility for it.'''
        raise NotImplementedError()
    
    @property
    def one_page_per_sheet(self) -> bool:
        '''If OnePagePerSheet is true , all content of one sheet will output to only one page in result.
        The paper size of pagesetup will be invalid, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @one_page_per_sheet.setter
    def one_page_per_sheet(self, value : bool) -> None:
        '''If OnePagePerSheet is true , all content of one sheet will output to only one page in result.
        The paper size of pagesetup will be invalid, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @property
    def all_columns_in_one_page_per_sheet(self) -> bool:
        '''If AllColumnsInOnePagePerSheet is true , all column content of one sheet will output to only one page in result.
        The width of paper size of pagesetup will be ignored, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @all_columns_in_one_page_per_sheet.setter
    def all_columns_in_one_page_per_sheet(self, value : bool) -> None:
        '''If AllColumnsInOnePagePerSheet is true , all column content of one sheet will output to only one page in result.
        The width of paper size of pagesetup will be ignored, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @property
    def ignore_error(self) -> bool:
        '''Indicates if you need to hide the error while rendering.
        The error can be error in shape, image, chart rendering, etc.'''
        raise NotImplementedError()
    
    @ignore_error.setter
    def ignore_error(self, value : bool) -> None:
        '''Indicates if you need to hide the error while rendering.
        The error can be error in shape, image, chart rendering, etc.'''
        raise NotImplementedError()
    
    @property
    def output_blank_page_when_nothing_to_print(self) -> bool:
        '''Indicates whether to output a blank page when there is nothing to print.'''
        raise NotImplementedError()
    
    @output_blank_page_when_nothing_to_print.setter
    def output_blank_page_when_nothing_to_print(self, value : bool) -> None:
        '''Indicates whether to output a blank page when there is nothing to print.'''
        raise NotImplementedError()
    
    @property
    def page_index(self) -> int:
        '''Gets the 0-based index of the first page to save.'''
        raise NotImplementedError()
    
    @page_index.setter
    def page_index(self, value : int) -> None:
        '''Sets the 0-based index of the first page to save.'''
        raise NotImplementedError()
    
    @property
    def page_count(self) -> int:
        '''Gets the number of pages to save.'''
        raise NotImplementedError()
    
    @page_count.setter
    def page_count(self, value : int) -> None:
        '''Sets the number of pages to save.'''
        raise NotImplementedError()
    
    @property
    def printing_page_type(self) -> aspose.cells.PrintingPageType:
        '''Indicates which pages will not be printed.'''
        raise NotImplementedError()
    
    @printing_page_type.setter
    def printing_page_type(self, value : aspose.cells.PrintingPageType) -> None:
        '''Indicates which pages will not be printed.'''
        raise NotImplementedError()
    
    @property
    def gridline_type(self) -> aspose.cells.GridlineType:
        '''Gets gridline type.'''
        raise NotImplementedError()
    
    @gridline_type.setter
    def gridline_type(self, value : aspose.cells.GridlineType) -> None:
        '''Sets gridline type.'''
        raise NotImplementedError()
    
    @property
    def text_cross_type(self) -> aspose.cells.TextCrossType:
        '''Gets displaying text type when the text width is larger than cell width.'''
        raise NotImplementedError()
    
    @text_cross_type.setter
    def text_cross_type(self, value : aspose.cells.TextCrossType) -> None:
        '''Sets displaying text type when the text width is larger than cell width.'''
        raise NotImplementedError()
    
    @property
    def default_edit_language(self) -> aspose.cells.DefaultEditLanguage:
        '''Gets default edit language.'''
        raise NotImplementedError()
    
    @default_edit_language.setter
    def default_edit_language(self, value : aspose.cells.DefaultEditLanguage) -> None:
        '''Sets default edit language.'''
        raise NotImplementedError()
    
    @property
    def sheet_set(self) -> aspose.cells.rendering.SheetSet:
        '''Gets the sheets to render. Default is all visible sheets in the workbook: :py:attr:`aspose.cells.rendering.SheetSet.visible`.'''
        raise NotImplementedError()
    
    @sheet_set.setter
    def sheet_set(self, value : aspose.cells.rendering.SheetSet) -> None:
        '''Sets the sheets to render. Default is all visible sheets in the workbook: :py:attr:`aspose.cells.rendering.SheetSet.visible`.'''
        raise NotImplementedError()
    
    @property
    def draw_object_event_handler(self) -> aspose.cells.rendering.DrawObjectEventHandler:
        '''Implements this interface to get DrawObject and Bound when rendering.'''
        raise NotImplementedError()
    
    @draw_object_event_handler.setter
    def draw_object_event_handler(self, value : aspose.cells.rendering.DrawObjectEventHandler) -> None:
        '''Implements this interface to get DrawObject and Bound when rendering.'''
        raise NotImplementedError()
    
    @property
    def page_saving_callback(self) -> aspose.cells.rendering.IPageSavingCallback:
        '''Control/Indicate progress of page saving process.'''
        raise NotImplementedError()
    
    @page_saving_callback.setter
    def page_saving_callback(self, value : aspose.cells.rendering.IPageSavingCallback) -> None:
        '''Control/Indicate progress of page saving process.'''
        raise NotImplementedError()
    
    @property
    def emf_render_setting(self) -> aspose.cells.EmfRenderSetting:
        '''Setting for rendering Emf metafile.'''
        raise NotImplementedError()
    
    @emf_render_setting.setter
    def emf_render_setting(self, value : aspose.cells.EmfRenderSetting) -> None:
        '''Setting for rendering Emf metafile.'''
        raise NotImplementedError()
    

class DxfCollection:
    '''Represents the master differential formatting records.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.Style]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.Style], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Style, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Style, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Style) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Style, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Style, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.Style) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class DynamicFilter:
    '''Represents the dynamic filter.'''
    
    @property
    def dynamic_filter_type(self) -> aspose.cells.DynamicFilterType:
        '''Gets and sets the dynamic filter type.'''
        raise NotImplementedError()
    
    @dynamic_filter_type.setter
    def dynamic_filter_type(self, value : aspose.cells.DynamicFilterType) -> None:
        '''Gets and sets the dynamic filter type.'''
        raise NotImplementedError()
    
    @property
    def value(self) -> Any:
        '''Gets and sets the dynamic filter value.'''
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : Any) -> None:
        '''Gets and sets the dynamic filter value.'''
        raise NotImplementedError()
    
    @property
    def max_value(self) -> Any:
        '''Gets and sets the dynamic filter max value.'''
        raise NotImplementedError()
    
    @max_value.setter
    def max_value(self, value : Any) -> None:
        '''Gets and sets the dynamic filter max value.'''
        raise NotImplementedError()
    

class EbookLoadOptions(HtmlLoadOptions):
    '''Represents options when importing an ebook file.'''
    
    def set_paper_size(self, type : aspose.cells.PaperSizeType) -> None:
        '''Sets the default print paper size from default printer\'s setting.
        
        :param type: The default paper size.'''
        raise NotImplementedError()
    
    @property
    def load_format(self) -> aspose.cells.LoadFormat:
        '''Gets the load format.'''
        raise NotImplementedError()
    
    @property
    def password(self) -> str:
        '''Gets and set the password of the workbook.'''
        raise NotImplementedError()
    
    @password.setter
    def password(self, value : str) -> None:
        '''Gets and set the password of the workbook.'''
        raise NotImplementedError()
    
    @property
    def parsing_formula_on_open(self) -> bool:
        '''Indicates whether parsing the formula when reading the file.'''
        raise NotImplementedError()
    
    @parsing_formula_on_open.setter
    def parsing_formula_on_open(self, value : bool) -> None:
        '''Indicates whether parsing the formula when reading the file.'''
        raise NotImplementedError()
    
    @property
    def parsing_pivot_cached_records(self) -> bool:
        '''Indicates whether parsing pivot cached records when loading the file.
        The default value is false.'''
        raise NotImplementedError()
    
    @parsing_pivot_cached_records.setter
    def parsing_pivot_cached_records(self, value : bool) -> None:
        '''Indicates whether parsing pivot cached records when loading the file.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def language_code(self) -> aspose.cells.CountryCode:
        '''Gets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @language_code.setter
    def language_code(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @property
    def region(self) -> aspose.cells.CountryCode:
        '''Gets the system regional settings based on CountryCode at the time the file was loaded.'''
        raise NotImplementedError()
    
    @region.setter
    def region(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the system regional settings based on CountryCode at the time the file was loaded.'''
        raise NotImplementedError()
    
    @property
    def default_style_settings(self) -> aspose.cells.DefaultStyleSettings:
        '''Gets the default style settings for initializing styles of the workbook'''
        raise NotImplementedError()
    
    @property
    def standard_font(self) -> str:
        '''Sets the default standard font name'''
        raise NotImplementedError()
    
    @standard_font.setter
    def standard_font(self, value : str) -> None:
        '''Sets the default standard font name'''
        raise NotImplementedError()
    
    @property
    def standard_font_size(self) -> float:
        '''Sets the default standard font size.'''
        raise NotImplementedError()
    
    @standard_font_size.setter
    def standard_font_size(self, value : float) -> None:
        '''Sets the default standard font size.'''
        raise NotImplementedError()
    
    @property
    def interrupt_monitor(self) -> aspose.cells.AbstractInterruptMonitor:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.cells.AbstractInterruptMonitor) -> None:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @property
    def ignore_not_printed(self) -> bool:
        '''Ignore the data which are not printed if directly printing the file'''
        raise NotImplementedError()
    
    @ignore_not_printed.setter
    def ignore_not_printed(self, value : bool) -> None:
        '''Ignore the data which are not printed if directly printing the file'''
        raise NotImplementedError()
    
    @property
    def check_data_valid(self) -> bool:
        '''Check whether data is valid in the template file.'''
        raise NotImplementedError()
    
    @check_data_valid.setter
    def check_data_valid(self, value : bool) -> None:
        '''Check whether data is valid in the template file.'''
        raise NotImplementedError()
    
    @property
    def check_excel_restriction(self) -> bool:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @check_excel_restriction.setter
    def check_excel_restriction(self, value : bool) -> None:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @property
    def keep_unparsed_data(self) -> bool:
        '''Whether keep the unparsed data in memory for the Workbook when it is loaded from template file. Default is true.'''
        raise NotImplementedError()
    
    @keep_unparsed_data.setter
    def keep_unparsed_data(self, value : bool) -> None:
        '''Whether keep the unparsed data in memory for the Workbook when it is loaded from template file. Default is true.'''
        raise NotImplementedError()
    
    @property
    def load_filter(self) -> aspose.cells.LoadFilter:
        '''The filter to denote how to load data.'''
        raise NotImplementedError()
    
    @load_filter.setter
    def load_filter(self, value : aspose.cells.LoadFilter) -> None:
        '''The filter to denote how to load data.'''
        raise NotImplementedError()
    
    @property
    def light_cells_data_handler(self) -> aspose.cells.LightCellsDataHandler:
        '''The data handler for processing cells data when reading template file.'''
        raise NotImplementedError()
    
    @light_cells_data_handler.setter
    def light_cells_data_handler(self, value : aspose.cells.LightCellsDataHandler) -> None:
        '''The data handler for processing cells data when reading template file.'''
        raise NotImplementedError()
    
    @property
    def memory_setting(self) -> aspose.cells.MemorySetting:
        '''Gets the memory usage options.'''
        raise NotImplementedError()
    
    @memory_setting.setter
    def memory_setting(self, value : aspose.cells.MemorySetting) -> None:
        '''Sets the memory usage options.'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def auto_fitter_options(self) -> aspose.cells.AutoFitterOptions:
        '''Gets and sets the auto fitter options'''
        raise NotImplementedError()
    
    @auto_fitter_options.setter
    def auto_fitter_options(self, value : aspose.cells.AutoFitterOptions) -> None:
        '''Gets and sets the auto fitter options'''
        raise NotImplementedError()
    
    @property
    def auto_filter(self) -> bool:
        '''Indicates whether auto filtering the data when loading the files.'''
        raise NotImplementedError()
    
    @auto_filter.setter
    def auto_filter(self, value : bool) -> None:
        '''Indicates whether auto filtering the data when loading the files.'''
        raise NotImplementedError()
    
    @property
    def font_configs(self) -> aspose.cells.IndividualFontConfigs:
        '''Gets and sets individual font configs.
        Only works for the :py:class:`aspose.cells.Workbook` which uses this :py:class:`aspose.cells.LoadOptions` to load.'''
        raise NotImplementedError()
    
    @font_configs.setter
    def font_configs(self, value : aspose.cells.IndividualFontConfigs) -> None:
        '''Gets and sets individual font configs.
        Only works for the :py:class:`aspose.cells.Workbook` which uses this :py:class:`aspose.cells.LoadOptions` to load.'''
        raise NotImplementedError()
    
    @property
    def ignore_useless_shapes(self) -> bool:
        '''Indicates whether ignoring useless shapes.'''
        raise NotImplementedError()
    
    @ignore_useless_shapes.setter
    def ignore_useless_shapes(self, value : bool) -> None:
        '''Indicates whether ignoring useless shapes.'''
        raise NotImplementedError()
    
    @property
    def preserve_padding_spaces_in_formula(self) -> bool:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    
    @preserve_padding_spaces_in_formula.setter
    def preserve_padding_spaces_in_formula(self, value : bool) -> None:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    
    @property
    def encoding(self) -> str:
        '''Gets and sets the default encoding. Only applies for csv file.'''
        raise NotImplementedError()
    
    @encoding.setter
    def encoding(self, value : str) -> None:
        '''Gets and sets the default encoding. Only applies for csv file.'''
        raise NotImplementedError()
    
    @property
    def load_style_strategy(self) -> aspose.cells.TxtLoadStyleStrategy:
        '''Indicates the strategy to apply style for parsed values when converting string value to number or datetime.'''
        raise NotImplementedError()
    
    @load_style_strategy.setter
    def load_style_strategy(self, value : aspose.cells.TxtLoadStyleStrategy) -> None:
        '''Indicates the strategy to apply style for parsed values when converting string value to number or datetime.'''
        raise NotImplementedError()
    
    @property
    def convert_numeric_data(self) -> bool:
        '''Gets a value that indicates whether the string in text file is converted to numeric data.'''
        raise NotImplementedError()
    
    @convert_numeric_data.setter
    def convert_numeric_data(self, value : bool) -> None:
        '''Sets a value that indicates whether the string in text file is converted to numeric data.'''
        raise NotImplementedError()
    
    @property
    def convert_date_time_data(self) -> bool:
        '''Gets a value that indicates whether the string in text file is converted to date data.'''
        raise NotImplementedError()
    
    @convert_date_time_data.setter
    def convert_date_time_data(self, value : bool) -> None:
        '''Sets a value that indicates whether the string in text file is converted to date data.'''
        raise NotImplementedError()
    
    @property
    def keep_precision(self) -> bool:
        '''Indicates whether not parsing a string value if the length is 15.'''
        raise NotImplementedError()
    
    @keep_precision.setter
    def keep_precision(self, value : bool) -> None:
        '''Indicates whether not parsing a string value if the length is 15.'''
        raise NotImplementedError()
    
    @property
    def attached_files_directory(self) -> str:
        '''The directory that the attached files will be saved to.'''
        raise NotImplementedError()
    
    @attached_files_directory.setter
    def attached_files_directory(self, value : str) -> None:
        '''The directory that the attached files will be saved to.'''
        raise NotImplementedError()
    
    @property
    def load_formulas(self) -> bool:
        '''Indicates whether importing formulas if the original html file contains formulas'''
        raise NotImplementedError()
    
    @load_formulas.setter
    def load_formulas(self, value : bool) -> None:
        '''Indicates whether importing formulas if the original html file contains formulas'''
        raise NotImplementedError()
    
    @property
    def support_div_tag(self) -> bool:
        '''Indicates whether support the layout of ``<div>`` tag when the html file contains it.
        The default value is false.'''
        raise NotImplementedError()
    
    @support_div_tag.setter
    def support_div_tag(self, value : bool) -> None:
        '''Indicates whether support the layout of ``<div>`` tag when the html file contains it.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def delete_redundant_spaces(self) -> bool:
        '''Indicates whether delete redundant spaces when the text wraps lines using ``<br>`` tag.
        The default value is false.'''
        raise NotImplementedError()
    
    @delete_redundant_spaces.setter
    def delete_redundant_spaces(self, value : bool) -> None:
        '''Indicates whether delete redundant spaces when the text wraps lines using ``<br>`` tag.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def auto_fit_cols_and_rows(self) -> bool:
        '''Indicates whether auto-fit columns and rows. The default value is false.'''
        raise NotImplementedError()
    
    @auto_fit_cols_and_rows.setter
    def auto_fit_cols_and_rows(self, value : bool) -> None:
        '''Indicates whether auto-fit columns and rows. The default value is false.'''
        raise NotImplementedError()
    
    @property
    def convert_formulas_data(self) -> bool:
        '''if true, convert string to formula when string value starts with character \'=\',the default value is false.'''
        raise NotImplementedError()
    
    @convert_formulas_data.setter
    def convert_formulas_data(self, value : bool) -> None:
        '''if true, convert string to formula when string value starts with character \'=\',the default value is false.'''
        raise NotImplementedError()
    
    @property
    def has_formula(self) -> bool:
        '''Indicates whether the text is formula if it starts with "=".'''
        raise NotImplementedError()
    
    @has_formula.setter
    def has_formula(self, value : bool) -> None:
        '''Indicates whether the text is formula if it starts with "=".'''
        raise NotImplementedError()
    
    @property
    def stream_provider(self) -> aspose.cells.IStreamProvider:
        '''Gets the StreamProviderImportHtmlFile for importing objects.'''
        raise NotImplementedError()
    
    @stream_provider.setter
    def stream_provider(self, value : aspose.cells.IStreamProvider) -> None:
        '''Sets the StreamProviderImportHtmlFile for importing objects.'''
        raise NotImplementedError()
    
    @property
    def prog_id(self) -> str:
        '''Gets the program id of creating the file.
        Only for MHT files.'''
        raise NotImplementedError()
    
    @property
    def table_load_options(self) -> aspose.cells.HtmlTableLoadOptionCollection:
        '''Get the HtmlTableLoadOptionCollection instance'''
        raise NotImplementedError()
    

class ErrorCheckOption:
    '''Error check setting applied on certain ranges.'''
    
    def is_error_check(self, error_check_type : aspose.cells.ErrorCheckType) -> bool:
        '''Checks whether given error type will be checked.
        
        :param error_check_type: error type can be checked
        :returns: return true if given error type will be checked(green triangle will be shown for cell if the check failed).'''
        raise NotImplementedError()
    
    def set_error_check(self, error_check_type : aspose.cells.ErrorCheckType, is_check : bool) -> None:
        '''Sets whether given error type will be checked.
        
        :param error_check_type: error type can be checked.
        :param is_check: true if given error type needs to be checked(green triangle will be shown for cell if the check failed).'''
        raise NotImplementedError()
    
    def get_count_of_range(self) -> int:
        '''Gets the count of ranges that influenced by this setting.
        
        :returns: the count of ranges that influenced by this setting.'''
        raise NotImplementedError()
    
    def add_range(self, ca : aspose.cells.CellArea) -> int:
        '''Adds one influenced range by this setting.
        
        :param ca: the range to be added.
        :returns: the index of the added range in the range list of this setting.'''
        raise NotImplementedError()
    
    def get_range(self, index : int) -> aspose.cells.CellArea:
        '''Gets the influenced range of this setting by given index.
        
        :param index: the index of range
        :returns: return influenced range at given index.'''
        raise NotImplementedError()
    
    def remove_range(self, index : int) -> None:
        '''Removes one range by given index.
        
        :param index: the index of the range to be removed.'''
        raise NotImplementedError()
    

class ErrorCheckOptionCollection:
    '''Represents all error check option.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.ErrorCheckOption]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.ErrorCheckOption], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.ErrorCheckOption, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.ErrorCheckOption, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ErrorCheckOption) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ErrorCheckOption, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ErrorCheckOption, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def add(self) -> int:
        '''Add an error check option.'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.ErrorCheckOption) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class ExportObjectEvent:
    '''The event triggered when exporting an object, such as Picture.'''
    
    def get_source(self) -> Any:
        '''Gets the object to be exported.
        
        :returns: the object to be exported.'''
        raise NotImplementedError()
    

class ExportTableOptions:
    '''Represents all export table options.'''
    
    def preprocess_exported_value(self, cell_row : int, cell_column : int, value : aspose.cells.CellValue) -> bool:
        '''Preprocess the value of current cell to be exported.
        
        :param cell_row: the row index of current cell
        :param cell_column: the column index of cell
        :param value: value and type of current cell
        :returns: Whether current cell has been replaced with different type and/or value.'''
        raise NotImplementedError()
    
    @property
    def export_column_name(self) -> bool:
        '''Indicates whether the data in the first row are exported to the column name of the DataTable.
        The default value is false.'''
        raise NotImplementedError()
    
    @export_column_name.setter
    def export_column_name(self, value : bool) -> None:
        '''Indicates whether the data in the first row are exported to the column name of the DataTable.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def skip_error_value(self) -> bool:
        '''Indicates whether skip invalid value for the column.
        For example,if the column type is decimal ,the value is greater than decimal.MaxValue
        and this property is true,we will not throw exception again.
        The default value is false.'''
        raise NotImplementedError()
    
    @skip_error_value.setter
    def skip_error_value(self, value : bool) -> None:
        '''Indicates whether skip invalid value for the column.
        For example,if the column type is decimal ,the value is greater than decimal.MaxValue
        and this property is true,we will not throw exception again.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def plot_visible_cells(self) -> bool:
        '''Only exports visible cells.'''
        raise NotImplementedError()
    
    @plot_visible_cells.setter
    def plot_visible_cells(self, value : bool) -> None:
        '''Only exports visible cells.'''
        raise NotImplementedError()
    
    @property
    def plot_visible_rows(self) -> bool:
        '''Only exports visible rows.'''
        raise NotImplementedError()
    
    @plot_visible_rows.setter
    def plot_visible_rows(self, value : bool) -> None:
        '''Only exports visible rows.'''
        raise NotImplementedError()
    
    @property
    def plot_visible_columns(self) -> bool:
        '''Only exports visible columns.'''
        raise NotImplementedError()
    
    @plot_visible_columns.setter
    def plot_visible_columns(self, value : bool) -> None:
        '''Only exports visible columns.'''
        raise NotImplementedError()
    
    @property
    def export_as_string(self) -> bool:
        '''Exports the string value of the cells to the DataTable.'''
        raise NotImplementedError()
    
    @export_as_string.setter
    def export_as_string(self, value : bool) -> None:
        '''Exports the string value of the cells to the DataTable.'''
        raise NotImplementedError()
    
    @property
    def export_as_html_string(self) -> bool:
        '''Exports the html string value of the cells to the DataTable.'''
        raise NotImplementedError()
    
    @export_as_html_string.setter
    def export_as_html_string(self, value : bool) -> None:
        '''Exports the html string value of the cells to the DataTable.'''
        raise NotImplementedError()
    
    @property
    def format_strategy(self) -> aspose.cells.CellValueFormatStrategy:
        '''Gets and sets the format strategy when exporting the value as string value.'''
        raise NotImplementedError()
    
    @format_strategy.setter
    def format_strategy(self, value : aspose.cells.CellValueFormatStrategy) -> None:
        '''Gets and sets the format strategy when exporting the value as string value.'''
        raise NotImplementedError()
    
    @property
    def check_mixed_value_type(self) -> bool:
        '''False, Aspose.Cells will set the DataColumn\'s type by the value type of the first row for performance.
        True, Aspose.Cells will check whether the value type in the column are mixed before set the DataColumn\'s type
        And the value type are mixed, the DataColumn\'s type will be string.'''
        raise NotImplementedError()
    
    @check_mixed_value_type.setter
    def check_mixed_value_type(self, value : bool) -> None:
        '''False, Aspose.Cells will set the DataColumn\'s type by the value type of the first row for performance.
        True, Aspose.Cells will check whether the value type in the column are mixed before set the DataColumn\'s type
        And the value type are mixed, the DataColumn\'s type will be string.'''
        raise NotImplementedError()
    
    @property
    def allow_db_null(self) -> bool:
        '''This value indicates whether DBNulls are allowed in this table.'''
        raise NotImplementedError()
    
    @allow_db_null.setter
    def allow_db_null(self, value : bool) -> None:
        '''This value indicates whether DBNulls are allowed in this table.'''
        raise NotImplementedError()
    
    @property
    def is_vertical(self) -> bool:
        '''True if a row in Workbook file represents a row in DataTable. False if a column in Workbook file represents a row in DataTable.'''
        raise NotImplementedError()
    
    @is_vertical.setter
    def is_vertical(self, value : bool) -> None:
        '''True if a row in Workbook file represents a row in DataTable. False if a column in Workbook file represents a row in DataTable.'''
        raise NotImplementedError()
    
    @property
    def indexes(self) -> List[int]:
        '''The indexes of columns/rows which should be exported out.'''
        raise NotImplementedError()
    
    @indexes.setter
    def indexes(self, value : List[int]) -> None:
        '''The indexes of columns/rows which should be exported out.'''
        raise NotImplementedError()
    
    @property
    def rename_strategy(self) -> aspose.cells.RenameStrategy:
        '''Strategy for duplicate names of columns.'''
        raise NotImplementedError()
    
    @rename_strategy.setter
    def rename_strategy(self, value : aspose.cells.RenameStrategy) -> None:
        '''Strategy for duplicate names of columns.'''
        raise NotImplementedError()
    

class ExternalLink:
    '''Represents an external link in a workbook.'''
    
    def add_external_name(self, text : str, refer_to : str) -> None:
        '''Adds an external name.
        
        :param text: The text of the external name.
        If the external name belongs to a worksheet, the text should be as Sheet1!Text.
        :param refer_to: The referTo of the external name. It must be a cell or the range.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.ExternalLinkType:
        '''Gets the type of external link.'''
        raise NotImplementedError()
    
    @property
    def path_type(self) -> str:
        raise NotImplementedError()
    
    @property
    def original_data_source(self) -> str:
        '''Represents stored data source of the external link.'''
        raise NotImplementedError()
    
    @original_data_source.setter
    def original_data_source(self, value : str) -> None:
        '''Represents stored data source of the external link.'''
        raise NotImplementedError()
    
    @property
    def data_source(self) -> str:
        '''Represents data source of the external link.'''
        raise NotImplementedError()
    
    @data_source.setter
    def data_source(self, value : str) -> None:
        '''Represents data source of the external link.'''
        raise NotImplementedError()
    
    @property
    def is_referred(self) -> bool:
        '''Indicates whether this external link is referenced by others.'''
        raise NotImplementedError()
    
    @property
    def is_visible(self) -> bool:
        '''Indicates whether this external link is visible in MS Excel.'''
        raise NotImplementedError()
    

class ExternalLinkCollection:
    '''Represents external links collection in a workbook.'''
    
    @overload
    def add(self, file_name : str, sheet_names : List[str]) -> int:
        '''Adds an external link.
        
        :param file_name: The external file name.
        :param sheet_names: All sheet names of the external file.
        :returns: The position of the external name in this list.'''
        raise NotImplementedError()
    
    @overload
    def add(self, directory_type : aspose.cells.DirectoryType, file_name : str, sheet_names : List[str]) -> int:
        '''Add an external link .
        
        :param directory_type: The directory type of the file name.
        :param file_name: the file name.
        :param sheet_names: All sheet names of the external file.
        :returns: The position of the external name in this list.'''
        raise NotImplementedError()
    
    @overload
    def clear(self) -> None:
        '''Removes all external links.'''
        raise NotImplementedError()
    
    @overload
    def clear(self, update_references_as_local : bool) -> None:
        '''Removes all external links.
        
        :param update_references_as_local: Whether update all references of external links in formulas to references of current workbook itself.'''
        raise NotImplementedError()
    
    @overload
    def remove_at(self, index : int) -> None:
        '''Removes the specified external link from the workbook.
        
        :param index: the index of the external link to be removed.'''
        raise NotImplementedError()
    
    @overload
    def remove_at(self, index : int, update_references_as_local : bool) -> None:
        '''Removes the specified external link from the workbook.
        
        :param index: the index of the external link to be removed.
        :param update_references_as_local: Whether update all references of given external link to reference of current workbook itself.
        Check :py:func:`aspose.cells.ExternalLinkCollection.clear` to get more details about this parameter.'''
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        '''Gets the number of elements actually contained in the collection.'''
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.cells.ExternalLink:
        '''Gets the :py:class:`aspose.cells.ExternalLink` element at the specified index.'''
        raise NotImplementedError()
    

class FileFontSource(FontSourceBase):
    '''Represents the single TrueType font file stored in the file system.'''
    
    @property
    def type(self) -> aspose.cells.FontSourceType:
        '''Returns the type of the font source.'''
        raise NotImplementedError()
    
    @property
    def file_path(self) -> str:
        '''Path to font file.'''
        raise NotImplementedError()
    

class FileFormatInfo:
    '''Contains data returned by :py:class:`aspose.cells.FileFormatUtil` file format detection methods.'''
    
    @property
    def is_protected_by_rms(self) -> bool:
        '''Gets whether the file is protected by Microsoft Rights Management Server.'''
        raise NotImplementedError()
    
    @property
    def is_encrypted(self) -> bool:
        '''Returns true if the document is encrypted and requires a password to open.'''
        raise NotImplementedError()
    
    @property
    def file_format_type(self) -> aspose.cells.FileFormatType:
        '''Gets the detected file format.'''
        raise NotImplementedError()
    
    @property
    def load_format(self) -> aspose.cells.LoadFormat:
        '''Gets the detected load format.'''
        raise NotImplementedError()
    

class FileFormatUtil:
    '''Provides utility methods for converting file format enums to strings or file extensions and back.'''
    
    @overload
    @staticmethod
    def detect_file_format(stream : io.RawIOBase) -> aspose.cells.FileFormatInfo:
        '''Detects and returns the information about a format of an excel stored in a stream.
        
        :returns: A :py:class:`aspose.cells.FileFormatInfo` object that contains the detected information.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def detect_file_format(stream : io.RawIOBase, password : str) -> aspose.cells.FileFormatInfo:
        '''Detects and returns the information about a format of an excel stored in a stream.
        
        :param password: The password for encrypted ooxml files.
        :returns: A :py:class:`aspose.cells.FileFormatInfo` object that contains the detected information.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def detect_file_format(file_path : str) -> aspose.cells.FileFormatInfo:
        '''Detects and returns the information about a format of an excel stored in a file.
        
        :param file_path: The file path.
        :returns: A :py:class:`aspose.cells.FileFormatInfo` object that contains the detected information.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def detect_file_format(file_path : str, password : str) -> aspose.cells.FileFormatInfo:
        '''Detects and returns the information about a format of an excel stored in a file.
        
        :param file_path: The file path.
        :param password: The password for encrypted ooxml files.
        :returns: A :py:class:`aspose.cells.FileFormatInfo` object that contains the detected information.'''
        raise NotImplementedError()
    
    @staticmethod
    def verify_password(stream : io.RawIOBase, password : str) -> bool:
        '''Detects and returns the information about a format of an excel stored in a stream.
        
        :param password: The password for encrypted ooxml files.
        :returns: Returns whether the password is corrected.'''
        raise NotImplementedError()
    
    @staticmethod
    def file_format_to_save_format(format : aspose.cells.FileFormatType) -> aspose.cells.SaveFormat:
        '''Converting file format to save format.
        
        :param format: The file format type.'''
        raise NotImplementedError()
    
    @staticmethod
    def extension_to_save_format(extension : str) -> aspose.cells.SaveFormat:
        '''Converts a file name extension into a SaveFormat value.
        
        :param extension: The file extension. Can be with or without a leading dot. Case-insensitive.'''
        raise NotImplementedError()
    
    @staticmethod
    def is_template_format(extension : str) -> bool:
        '''Returns true if the extension is .xlt, .xltX, .xltm,.ots.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_format_to_extension(load_format : aspose.cells.LoadFormat) -> str:
        '''Converts a load format enumerated value into a file extension.
        
        :param load_format: The loaded file format.
        :returns: The returned extension is a lower-case string with a leading dot.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_format_to_save_format(load_format : aspose.cells.LoadFormat) -> aspose.cells.SaveFormat:
        '''Converts a LoadFormat value to a SaveFormat value if possible.
        
        :param load_format: The load format.
        :returns: The save format.'''
        raise NotImplementedError()
    
    @staticmethod
    def save_format_to_extension(format : aspose.cells.SaveFormat) -> str:
        '''Converts a save format enumerated value into a file extension.
        
        :param format: The save format.
        :returns: The returned extension is a lower-case string with a leading dot.'''
        raise NotImplementedError()
    
    @staticmethod
    def save_format_to_load_format(save_format : aspose.cells.SaveFormat) -> aspose.cells.LoadFormat:
        '''Converts a SaveFormat value to a LoadFormat value if possible.
        
        :param save_format: The save format.
        :returns: The load format'''
        raise NotImplementedError()
    

class FilterColumn:
    '''Represents a filter for a single column. The Filter object is a member of the Filters collection'''
    
    @property
    def is_dropdown_visible(self) -> bool:
        '''Indicates whether the AutoFilter button for this column is visible.'''
        raise NotImplementedError()
    
    @is_dropdown_visible.setter
    def is_dropdown_visible(self, value : bool) -> None:
        '''Indicates whether the AutoFilter button for this column is visible.'''
        raise NotImplementedError()
    
    @property
    def filter(self) -> Any:
        '''Gets and sets the condition of filtering data.'''
        raise NotImplementedError()
    
    @filter.setter
    def filter(self, value : Any) -> None:
        '''Gets and sets the condition of filtering data.'''
        raise NotImplementedError()
    
    @property
    def filter_type(self) -> aspose.cells.FilterType:
        '''Gets and sets the type fo filtering data.'''
        raise NotImplementedError()
    
    @filter_type.setter
    def filter_type(self, value : aspose.cells.FilterType) -> None:
        '''Gets and sets the type fo filtering data.'''
        raise NotImplementedError()
    
    @property
    def field_index(self) -> int:
        '''Gets and sets the column offset in the range.'''
        raise NotImplementedError()
    
    @field_index.setter
    def field_index(self, value : int) -> None:
        '''Gets and sets the column offset in the range.'''
        raise NotImplementedError()
    

class FilterColumnCollection:
    '''A collection of Filter objects that represents all the filters in an autofiltered range.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.FilterColumn]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.FilterColumn], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.FilterColumn, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.FilterColumn, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.FilterColumn) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.FilterColumn, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.FilterColumn, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def get_by_index(self, index : int) -> aspose.cells.FilterColumn:
        '''Returns a single Filter object from a collection.'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.FilterColumn) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class FindOptions:
    '''Represents find options.'''
    
    def get_range(self) -> aspose.cells.CellArea:
        '''Gets and sets the searched range.
        
        :returns: Returns the searched range.'''
        raise NotImplementedError()
    
    def set_range(self, ca : aspose.cells.CellArea) -> None:
        '''Sets the searched range.
        
        :param ca: the searched range.'''
        raise NotImplementedError()
    
    @property
    def is_case_sensitive(self) -> bool:
        '''Indicates if the searched string is case sensitive.'''
        raise NotImplementedError()
    
    @is_case_sensitive.setter
    def is_case_sensitive(self, value : bool) -> None:
        '''Indicates if the searched string is case sensitive.'''
        raise NotImplementedError()
    
    @property
    def case_sensitive(self) -> bool:
        '''Indicates if the searched string is case sensitive.'''
        raise NotImplementedError()
    
    @case_sensitive.setter
    def case_sensitive(self, value : bool) -> None:
        '''Indicates if the searched string is case sensitive.'''
        raise NotImplementedError()
    
    @property
    def look_at_type(self) -> aspose.cells.LookAtType:
        '''Look at type.'''
        raise NotImplementedError()
    
    @look_at_type.setter
    def look_at_type(self, value : aspose.cells.LookAtType) -> None:
        '''Look at type.'''
        raise NotImplementedError()
    
    @property
    def is_range_set(self) -> bool:
        '''Indicates whether the searched range is set.'''
        raise NotImplementedError()
    
    @property
    def search_next(self) -> bool:
        '''Search order. True: search next. False: search previous.'''
        raise NotImplementedError()
    
    @search_next.setter
    def search_next(self, value : bool) -> None:
        '''Search order. True: search next. False: search previous.'''
        raise NotImplementedError()
    
    @property
    def search_backward(self) -> bool:
        '''Whether search backward for cells.'''
        raise NotImplementedError()
    
    @search_backward.setter
    def search_backward(self, value : bool) -> None:
        '''Whether search backward for cells.'''
        raise NotImplementedError()
    
    @property
    def seach_order_by_rows(self) -> bool:
        '''Indicates whether search order by rows or columns.'''
        raise NotImplementedError()
    
    @seach_order_by_rows.setter
    def seach_order_by_rows(self, value : bool) -> None:
        '''Indicates whether search order by rows or columns.'''
        raise NotImplementedError()
    
    @property
    def look_in_type(self) -> aspose.cells.LookInType:
        '''Look in type.'''
        raise NotImplementedError()
    
    @look_in_type.setter
    def look_in_type(self, value : aspose.cells.LookInType) -> None:
        '''Look in type.'''
        raise NotImplementedError()
    
    @property
    def regex_key(self) -> bool:
        '''Indicates whether the searched key is regex.
        If true the searched key will be taken as regex and parsed. Otherwise the key will be parsed according to the rules in ms excel.'''
        raise NotImplementedError()
    
    @regex_key.setter
    def regex_key(self, value : bool) -> None:
        '''Indicates whether the searched key is regex.
        If true the searched key will be taken as regex and parsed. Otherwise the key will be parsed according to the rules in ms excel.'''
        raise NotImplementedError()
    
    @property
    def value_type_sensitive(self) -> bool:
        '''Indicates whether searched cell value type should be same with the searched key.'''
        raise NotImplementedError()
    
    @value_type_sensitive.setter
    def value_type_sensitive(self, value : bool) -> None:
        '''Indicates whether searched cell value type should be same with the searched key.'''
        raise NotImplementedError()
    
    @property
    def style(self) -> aspose.cells.Style:
        '''The format to search for.'''
        raise NotImplementedError()
    
    @style.setter
    def style(self, value : aspose.cells.Style) -> None:
        '''The format to search for.'''
        raise NotImplementedError()
    
    @property
    def convert_numeric_data(self) -> bool:
        '''Gets a value that indicates whether converting the searched string value to numeric data.'''
        raise NotImplementedError()
    
    @convert_numeric_data.setter
    def convert_numeric_data(self, value : bool) -> None:
        '''Sets a value that indicates whether converting the searched string value to numeric data.'''
        raise NotImplementedError()
    

class FolderFontSource(FontSourceBase):
    '''Represents the folder that contains TrueType font files.'''
    
    @property
    def type(self) -> aspose.cells.FontSourceType:
        '''Returns the type of the font source.'''
        raise NotImplementedError()
    
    @property
    def folder_path(self) -> str:
        '''Path to fonts folder.'''
        raise NotImplementedError()
    
    @property
    def scan_sub_folders(self) -> bool:
        '''Determines whether or not to scan the subfolders.'''
        raise NotImplementedError()
    

class Font:
    '''Encapsulates the font object used in a spreadsheet.'''
    
    def equals(self, font : aspose.cells.Font) -> bool:
        '''Checks if two fonts are equals.
        
        :param font: Compared font object.
        :returns: True if equal to the compared font object.'''
        raise NotImplementedError()
    
    @property
    def charset(self) -> int:
        '''Represent the character set.'''
        raise NotImplementedError()
    
    @charset.setter
    def charset(self, value : int) -> None:
        '''Represent the character set.'''
        raise NotImplementedError()
    
    @property
    def is_italic(self) -> bool:
        '''Gets a value indicating whether the font is italic.'''
        raise NotImplementedError()
    
    @is_italic.setter
    def is_italic(self, value : bool) -> None:
        '''Sets a value indicating whether the font is italic.'''
        raise NotImplementedError()
    
    @property
    def is_bold(self) -> bool:
        '''Gets a value indicating whether the font is bold.'''
        raise NotImplementedError()
    
    @is_bold.setter
    def is_bold(self, value : bool) -> None:
        '''Sets a value indicating whether the font is bold.'''
        raise NotImplementedError()
    
    @property
    def caps_type(self) -> aspose.cells.TextCapsType:
        '''Gets and sets the text caps type.'''
        raise NotImplementedError()
    
    @caps_type.setter
    def caps_type(self, value : aspose.cells.TextCapsType) -> None:
        '''Gets and sets the text caps type.'''
        raise NotImplementedError()
    
    @property
    def strike_type(self) -> aspose.cells.TextStrikeType:
        '''Gets the strike type of the text.'''
        raise NotImplementedError()
    
    @strike_type.setter
    def strike_type(self, value : aspose.cells.TextStrikeType) -> None:
        '''Gets the strike type of the text.'''
        raise NotImplementedError()
    
    @property
    def is_strikeout(self) -> bool:
        '''Gets a value indicating whether the font is single strikeout.'''
        raise NotImplementedError()
    
    @is_strikeout.setter
    def is_strikeout(self, value : bool) -> None:
        '''Sets a value indicating whether the font is single strikeout.'''
        raise NotImplementedError()
    
    @property
    def script_offset(self) -> float:
        '''Gets and sets the script offset,in unit of percentage'''
        raise NotImplementedError()
    
    @script_offset.setter
    def script_offset(self, value : float) -> None:
        '''Gets and sets the script offset,in unit of percentage'''
        raise NotImplementedError()
    
    @property
    def is_superscript(self) -> bool:
        '''Gets a value indicating whether the font is super script.'''
        raise NotImplementedError()
    
    @is_superscript.setter
    def is_superscript(self, value : bool) -> None:
        '''Sets a value indicating whether the font is super script.'''
        raise NotImplementedError()
    
    @property
    def is_subscript(self) -> bool:
        '''Gets a value indicating whether the font is subscript.'''
        raise NotImplementedError()
    
    @is_subscript.setter
    def is_subscript(self, value : bool) -> None:
        '''Sets a value indicating whether the font is subscript.'''
        raise NotImplementedError()
    
    @property
    def underline(self) -> aspose.cells.FontUnderlineType:
        '''Gets the font underline type.'''
        raise NotImplementedError()
    
    @underline.setter
    def underline(self, value : aspose.cells.FontUnderlineType) -> None:
        '''Sets the font underline type.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets  the name of the :py:class:`aspose.cells.Font`.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets  or sets the name of the :py:class:`aspose.cells.Font`.'''
        raise NotImplementedError()
    
    @property
    def double_size(self) -> float:
        '''Gets and sets the double size of the font.'''
        raise NotImplementedError()
    
    @double_size.setter
    def double_size(self, value : float) -> None:
        '''Gets and sets the double size of the font.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the font.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the font.'''
        raise NotImplementedError()
    
    @property
    def theme_color(self) -> aspose.cells.ThemeColor:
        '''Gets and sets the theme color.'''
        raise NotImplementedError()
    
    @theme_color.setter
    def theme_color(self, value : aspose.cells.ThemeColor) -> None:
        '''Gets and sets the theme color.'''
        raise NotImplementedError()
    
    @property
    def color(self) -> aspose.pydrawing.Color:
        '''Gets the :py:class:`aspose.pydrawing.Color` of the font.'''
        raise NotImplementedError()
    
    @color.setter
    def color(self, value : aspose.pydrawing.Color) -> None:
        '''Sets the :py:class:`aspose.pydrawing.Color` of the font.'''
        raise NotImplementedError()
    
    @property
    def argb_color(self) -> int:
        '''Gets and sets the color with a 32-bit ARGB value.'''
        raise NotImplementedError()
    
    @argb_color.setter
    def argb_color(self, value : int) -> None:
        '''Gets and sets the color with a 32-bit ARGB value.'''
        raise NotImplementedError()
    
    @property
    def is_normalize_heights(self) -> bool:
        '''Indicates whether the normalization of height that is to be applied to the text run.'''
        raise NotImplementedError()
    
    @is_normalize_heights.setter
    def is_normalize_heights(self, value : bool) -> None:
        '''Indicates whether the normalization of height that is to be applied to the text run.'''
        raise NotImplementedError()
    
    @property
    def scheme_type(self) -> aspose.cells.FontSchemeType:
        '''Gets and sets the scheme type of the font.'''
        raise NotImplementedError()
    
    @scheme_type.setter
    def scheme_type(self, value : aspose.cells.FontSchemeType) -> None:
        '''Gets and sets the scheme type of the font.'''
        raise NotImplementedError()
    

class FontConfigs:
    '''Specifies font settings'''
    
    @staticmethod
    def is_font_available(font_name : str) -> bool:
        '''Indicate whether the font is available.
        
        :param font_name: font name
        :returns: true if font is available, otherwise false.'''
        raise NotImplementedError()
    
    @staticmethod
    def set_font_substitutes(original_font_name : str, substitute_font_names : List[str]) -> None:
        '''Font substitute names for given original font name.
        
        :param original_font_name: Original font name.
        :param substitute_font_names: List of font substitute names to be used if original font is not presented.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_font_substitutes(original_font_name : str) -> List[str]:
        '''Returns array containing font substitute names to be used if original font is not presented.
        
        :param original_font_name: originalFontName
        :returns: An array containing font substitute names to be used if original font is not presented.'''
        raise NotImplementedError()
    
    @staticmethod
    def set_font_folder(font_folder : str, recursive : bool) -> None:
        '''Sets the fonts folder
        
        :param font_folder: The folder that contains TrueType fonts.
        :param recursive: Determines whether or not to scan subfolders.'''
        raise NotImplementedError()
    
    @staticmethod
    def set_font_folders(font_folders : List[str], recursive : bool) -> None:
        '''Sets the fonts folders
        
        :param font_folders: The folders that contains TrueType fonts.
        :param recursive: Determines whether or not to scan subfolders.'''
        raise NotImplementedError()
    
    @staticmethod
    def set_font_sources(sources : List[aspose.cells.FontSourceBase]) -> None:
        '''Sets the fonts sources.
        
        :param sources: An array of sources that contain TrueType fonts.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_font_sources() -> List[aspose.cells.FontSourceBase]:
        '''Gets a copy of the array that contains the list of sources'''
        raise NotImplementedError()
    
    default_font_name : str
    '''Gets or sets the default font name.'''
    prefer_system_font_substitutes : bool
    '''Indicate whether to use system font substitutes first or not when a font is not presented and the substitute of this font is not set.
    e.g. On Ubuntu, "Arial" font is generally substituted by "Liberation Sans".
    Default value is false.'''

class FontSetting:
    '''Represents a range of characters within the cell text.'''
    
    def set_word_art_style(self, style : aspose.cells.drawing.PresetWordArtStyle) -> None:
        '''Sets the preset WordArt style.
        
        :param style: The preset WordArt style.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.texts.TextNodeType:
        '''Gets the type of text node.'''
        raise NotImplementedError()
    
    @property
    def start_index(self) -> int:
        '''Gets the start index of the characters.'''
        raise NotImplementedError()
    
    @property
    def length(self) -> int:
        '''Gets the length of the characters.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Returns the font of this object.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Returns the text options.'''
        raise NotImplementedError()
    

class FontSourceBase:
    '''This is an abstract base class for the classes that allow the user to specify various font sources'''
    
    @property
    def type(self) -> aspose.cells.FontSourceType:
        '''Returns the type of the font source.'''
        raise NotImplementedError()
    

class FormatCondition:
    '''Represents conditional formatting condition.'''
    
    @overload
    def get_formula1(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the value or expression associated with this format condition.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The value or expression associated with this format condition.'''
        raise NotImplementedError()
    
    @overload
    def get_formula1(self, is_r1c1 : bool, is_local : bool, row : int, column : int) -> str:
        '''Gets the value or expression of the conditional formatting of the cell.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :param row: The row index.
        :param column: The column index.
        :returns: The value or expression associated with the conditional formatting of the cell.'''
        raise NotImplementedError()
    
    @overload
    def get_formula1(self, row : int, column : int) -> str:
        '''Gets the formula of the conditional formatting of the cell.
        
        :param row: The row index.
        :param column: The column index.
        :returns: The formula.'''
        raise NotImplementedError()
    
    @overload
    def get_formula2(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the value or expression associated with this format condition.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The value or expression associated with this format condition.'''
        raise NotImplementedError()
    
    @overload
    def get_formula2(self, is_r1c1 : bool, is_local : bool, row : int, column : int) -> str:
        '''Gets the value or expression of the conditional formatting of the cell.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :param row: The row index.
        :param column: The column index.
        :returns: The value or expression associated with the conditional formatting of the cell.'''
        raise NotImplementedError()
    
    @overload
    def get_formula2(self, row : int, column : int) -> str:
        '''Gets the formula of the conditional formatting of the cell.
        
        :param row: The row index.
        :param column: The column index.
        :returns: The formula.'''
        raise NotImplementedError()
    
    def set_formulas(self, formula1 : str, formula2 : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the value or expression associated with this format condition.
        
        :param formula1: The value or expression associated with this format condition.
        If the input value starts with \'=\', then it will be taken as formula. Otherwise it will be taken as plain value(text, number, bool).
        For text value that starts with \'=\', user may input it as formula in format: "=\"=...\"".
        :param formula2: The value or expression associated with this format condition. The input format is same with formula1
        :param is_r1c1: Whether the formula is R1C1 formula.
        :param is_local: Whether the formula is locale formatted.'''
        raise NotImplementedError()
    
    def set_formula1(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the value or expression associated with this format condition.
        
        :param formula: The value or expression associated with this format condition.
        If the input value starts with \'=\', then it will be taken as formula. Otherwise it will be taken as plain value(text, number, bool).
        For text value that starts with \'=\', user may input it as formula in format: "=\"=...\"".
        :param is_r1c1: Whether the formula is R1C1 formula.
        :param is_local: Whether the formula is locale formatted.'''
        raise NotImplementedError()
    
    def set_formula2(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the value or expression associated with this format condition.
        
        :param formula: The value or expression associated with this format condition.
        If the input value starts with \'=\', then it will be taken as formula. Otherwise it will be taken as plain value(text, number, bool).
        For text value that starts with \'=\', user may input it as formula in format: "=\"=...\"".
        :param is_r1c1: Whether the formula is R1C1 formula.
        :param is_local: Whether the formula is locale formatted.'''
        raise NotImplementedError()
    
    @property
    def formula1(self) -> str:
        '''Gets and sets the value or expression associated with conditional formatting.'''
        raise NotImplementedError()
    
    @formula1.setter
    def formula1(self, value : str) -> None:
        '''Gets and sets the value or expression associated with conditional formatting.'''
        raise NotImplementedError()
    
    @property
    def formula2(self) -> str:
        '''Gets and sets the value or expression associated with conditional formatting.'''
        raise NotImplementedError()
    
    @formula2.setter
    def formula2(self, value : str) -> None:
        '''Gets and sets the value or expression associated with conditional formatting.'''
        raise NotImplementedError()
    
    @property
    def operator(self) -> aspose.cells.OperatorType:
        '''Gets and sets the conditional format operator type.'''
        raise NotImplementedError()
    
    @operator.setter
    def operator(self, value : aspose.cells.OperatorType) -> None:
        '''Gets and sets the conditional format operator type.'''
        raise NotImplementedError()
    
    @property
    def stop_if_true(self) -> bool:
        '''True, no rules with lower priority may be applied over this rule, when this rule evaluates to true.
        Only applies for Excel 2007;'''
        raise NotImplementedError()
    
    @stop_if_true.setter
    def stop_if_true(self, value : bool) -> None:
        '''True, no rules with lower priority may be applied over this rule, when this rule evaluates to true.
        Only applies for Excel 2007;'''
        raise NotImplementedError()
    
    @property
    def priority(self) -> int:
        '''The priority of this conditional formatting rule. This value is used to determine which
        format should be evaluated and rendered. Lower numeric values are higher priority than
        higher numeric values, where \'1\' is the highest priority.'''
        raise NotImplementedError()
    
    @priority.setter
    def priority(self, value : int) -> None:
        '''The priority of this conditional formatting rule. This value is used to determine which
        format should be evaluated and rendered. Lower numeric values are higher priority than
        higher numeric values, where \'1\' is the highest priority.'''
        raise NotImplementedError()
    
    @property
    def style(self) -> aspose.cells.Style:
        '''Gets or setts style of conditional formatted cell ranges.'''
        raise NotImplementedError()
    
    @style.setter
    def style(self, value : aspose.cells.Style) -> None:
        '''Setts style of conditional formatted cell ranges.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.FormatConditionType:
        '''Gets and sets whether the conditional format Type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.cells.FormatConditionType) -> None:
        '''Gets and sets whether the conditional format Type.'''
        raise NotImplementedError()
    
    @property
    def icon_set(self) -> aspose.cells.IconSet:
        '''Get the conditional formatting\'s "IconSet" instance.
        The default instance\'s IconSetType is TrafficLights31.
        Valid only for type = IconSet.'''
        raise NotImplementedError()
    
    @property
    def data_bar(self) -> aspose.cells.DataBar:
        '''Get the conditional formatting\'s "DataBar" instance.
        The default instance\'s color is blue.
        Valid only for type is DataBar.'''
        raise NotImplementedError()
    
    @property
    def color_scale(self) -> aspose.cells.ColorScale:
        '''Get the conditional formatting\'s "ColorScale" instance.
        The default instance is a "green-yellow-red" 3ColorScale .
        Valid only for type = ColorScale.'''
        raise NotImplementedError()
    
    @property
    def top10(self) -> aspose.cells.Top10:
        '''Get the conditional formatting\'s "Top10" instance.
        The default instance\'s rule highlights cells whose
        values fall in the top 10 bracket.
        Valid only for type is Top10.'''
        raise NotImplementedError()
    
    @property
    def above_average(self) -> aspose.cells.AboveAverage:
        '''Get the conditional formatting\'s "AboveAverage" instance.
        The default instance\'s rule highlights cells that are
        above the average for all values in the range.
        Valid only for type = AboveAverage.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''The text value in a "text contains" conditional formatting rule.
        Valid only for type = containsText, notContainsText, beginsWith and endsWith.
        The default value is null.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''The text value in a "text contains" conditional formatting rule.
        Valid only for type = containsText, notContainsText, beginsWith and endsWith.
        The default value is null.'''
        raise NotImplementedError()
    
    @property
    def time_period(self) -> aspose.cells.TimePeriodType:
        '''The applicable time period in a "date occurring…" conditional formatting rule.
        Valid only for type = timePeriod.
        The default value is TimePeriodType.Today.'''
        raise NotImplementedError()
    
    @time_period.setter
    def time_period(self, value : aspose.cells.TimePeriodType) -> None:
        '''The applicable time period in a "date occurring…" conditional formatting rule.
        Valid only for type = timePeriod.
        The default value is TimePeriodType.Today.'''
        raise NotImplementedError()
    

class FormatConditionCollection:
    '''Represents conditional formatting.
    The FormatConditions can contain up to three conditional formats.'''
    
    @overload
    def add_condition(self, type : aspose.cells.FormatConditionType, operator_type : aspose.cells.OperatorType, formula1 : str, formula2 : str) -> int:
        '''Adds a formatting condition.
        
        :param type: The type of format condition.
        :param operator_type: The operator type
        :param formula1: The value or expression associated with conditional formatting.
        If the input value starts with \'=\', then it will be taken as formula.
        Otherwise it will be taken as plain value(text, number, bool).
        For text value that starts with \'=\', user may input it as formula in format: "=\"=...\"".
        :param formula2: The value or expression associated with conditional formatting.
        The input format is same with formula1
        :returns: Formatting condition object index;'''
        raise NotImplementedError()
    
    @overload
    def add_condition(self, type : aspose.cells.FormatConditionType) -> int:
        '''Add a format condition.
        
        :param type: Format condition type.
        :returns: Formatting condition object index;'''
        raise NotImplementedError()
    
    @overload
    def remove_area(self, index : int) -> None:
        '''Removes conditional formatted cell range by index.
        
        :param index: The index of the conditional formatted cell range to be removed.'''
        raise NotImplementedError()
    
    @overload
    def remove_area(self, start_row : int, start_column : int, total_rows : int, total_columns : int) -> bool:
        '''Remove conditional formatting int the range.
        
        :param start_row: The startRow of the range.
        :param start_column: The startColumn of the range.
        :param total_rows: The number of rows of the range.
        :param total_columns: The number of columns of the range.
        :returns: Returns TRUE, this FormatCondtionCollection should be removed.'''
        raise NotImplementedError()
    
    def add(self, cell_area : aspose.cells.CellArea, type : aspose.cells.FormatConditionType, operator_type : aspose.cells.OperatorType, formula1 : str, formula2 : str) -> List[int]:
        '''Adds a formatting condition and effected cell rang to the FormatConditions
        The FormatConditions can contain up to three conditional formats.
        References to the other sheets are not allowed in the formulas of conditional formatting.
        
        :param cell_area: Conditional formatted cell range.
        :param type: Type of conditional formatting.It could be one of the members of FormatConditionType.
        :param operator_type: Comparison operator.It could be one of the members of OperatorType.
        :param formula1: The value or expression associated with conditional formatting.
        :param formula2: The value or expression associated with conditional formatting
        :returns: [0]:Formatting condition object index;[1] Effected cell rang index.'''
        raise NotImplementedError()
    
    def add_area(self, cell_area : aspose.cells.CellArea) -> int:
        '''Adds a conditional formatted cell range.
        
        :param cell_area: Conditional formatted cell range.
        :returns: Conditional formatted cell rang index.'''
        raise NotImplementedError()
    
    def get_cell_area(self, index : int) -> aspose.cells.CellArea:
        '''Gets the conditional formatted cell range by index.
        
        :param index: the index of the conditional formatted cell range.
        :returns: the conditional formatted cell range'''
        raise NotImplementedError()
    
    def remove_condition(self, index : int) -> None:
        '''Removes the formatting condition by index.
        
        :param index: The index of the formatting condition to be removed.'''
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        '''Gets the count of the conditions.'''
        raise NotImplementedError()
    
    @property
    def range_count(self) -> int:
        '''Gets count of conditionally formatted ranges.'''
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.cells.FormatCondition:
        '''Gets the formatting condition by index.'''
        raise NotImplementedError()
    

class FormulaParseOptions:
    '''Represents options when parsing formula.'''
    
    @property
    def locale_dependent(self) -> bool:
        '''Whether the formula is locale formatted. Default is false.'''
        raise NotImplementedError()
    
    @locale_dependent.setter
    def locale_dependent(self, value : bool) -> None:
        '''Whether the formula is locale formatted. Default is false.'''
        raise NotImplementedError()
    
    @property
    def r1c1_style(self) -> bool:
        '''Whether the formula is R1C1 reference style. Default is false.'''
        raise NotImplementedError()
    
    @r1c1_style.setter
    def r1c1_style(self, value : bool) -> None:
        '''Whether the formula is R1C1 reference style. Default is false.'''
        raise NotImplementedError()
    
    @property
    def check_add_in(self) -> bool:
        '''Whether check addins in existing external links of current workbook for user defined function without external link.
        Default is true(if user defined function matches one addin in existing external links, then take it as the addin).'''
        raise NotImplementedError()
    
    @check_add_in.setter
    def check_add_in(self, value : bool) -> None:
        '''Whether check addins in existing external links of current workbook for user defined function without external link.
        Default is true(if user defined function matches one addin in existing external links, then take it as the addin).'''
        raise NotImplementedError()
    
    @property
    def parse(self) -> bool:
        '''Whether parse given formula. Default is true.
        If it is false, then given formula string will be kept as it is for the cell until user call other methods to parse them
        or parsed formula data is required by other operations such as calculating formulas.'''
        raise NotImplementedError()
    
    @parse.setter
    def parse(self, value : bool) -> None:
        '''Whether parse given formula. Default is true.
        If it is false, then given formula string will be kept as it is for the cell until user call other methods to parse them
        or parsed formula data is required by other operations such as calculating formulas.'''
        raise NotImplementedError()
    
    @property
    def custom_function_definition(self) -> aspose.cells.CustomFunctionDefinition:
        '''Definition for parsing custom functions.'''
        raise NotImplementedError()
    
    @custom_function_definition.setter
    def custom_function_definition(self, value : aspose.cells.CustomFunctionDefinition) -> None:
        '''Definition for parsing custom functions.'''
        raise NotImplementedError()
    

class FormulaSettings:
    '''Settings of formulas and calculation.'''
    
    @property
    def calculate_on_open(self) -> bool:
        '''Indicates whether the application is required to perform a full calculation when the workbook is opened.'''
        raise NotImplementedError()
    
    @calculate_on_open.setter
    def calculate_on_open(self, value : bool) -> None:
        '''Indicates whether the application is required to perform a full calculation when the workbook is opened.'''
        raise NotImplementedError()
    
    @property
    def calculate_on_save(self) -> bool:
        '''Indicates whether recalculate the workbook before saving the document, when in manual calculation mode.'''
        raise NotImplementedError()
    
    @calculate_on_save.setter
    def calculate_on_save(self, value : bool) -> None:
        '''Indicates whether recalculate the workbook before saving the document, when in manual calculation mode.'''
        raise NotImplementedError()
    
    @property
    def force_full_calculation(self) -> bool:
        '''Indicates whether calculates all formulas every time when a calculation is triggered.'''
        raise NotImplementedError()
    
    @force_full_calculation.setter
    def force_full_calculation(self, value : bool) -> None:
        '''Indicates whether calculates all formulas every time when a calculation is triggered.'''
        raise NotImplementedError()
    
    @property
    def calculation_mode(self) -> aspose.cells.CalcModeType:
        '''Gets the mode for workbook calculation in ms excel.'''
        raise NotImplementedError()
    
    @calculation_mode.setter
    def calculation_mode(self, value : aspose.cells.CalcModeType) -> None:
        '''Sets the mode for workbook calculation in ms excel.'''
        raise NotImplementedError()
    
    @property
    def calculation_id(self) -> str:
        '''Specifies the version of the calculation engine used to calculate values in the workbook.'''
        raise NotImplementedError()
    
    @calculation_id.setter
    def calculation_id(self, value : str) -> None:
        '''Specifies the version of the calculation engine used to calculate values in the workbook.'''
        raise NotImplementedError()
    
    @property
    def enable_iterative_calculation(self) -> bool:
        '''Indicates whether enable iterative calculation to resolve circular references.'''
        raise NotImplementedError()
    
    @enable_iterative_calculation.setter
    def enable_iterative_calculation(self, value : bool) -> None:
        '''Indicates whether enable iterative calculation to resolve circular references.'''
        raise NotImplementedError()
    
    @property
    def max_iteration(self) -> int:
        '''The maximum iterations to resolve a circular reference.'''
        raise NotImplementedError()
    
    @max_iteration.setter
    def max_iteration(self, value : int) -> None:
        '''The maximum iterations to resolve a circular reference.'''
        raise NotImplementedError()
    
    @property
    def max_change(self) -> float:
        '''The maximum change to resolve a circular reference.'''
        raise NotImplementedError()
    
    @max_change.setter
    def max_change(self, value : float) -> None:
        '''The maximum change to resolve a circular reference.'''
        raise NotImplementedError()
    
    @property
    def precision_as_displayed(self) -> bool:
        '''Whether the precision of calculated result be set as they are displayed while calculating formulas'''
        raise NotImplementedError()
    
    @precision_as_displayed.setter
    def precision_as_displayed(self, value : bool) -> None:
        '''Whether the precision of calculated result be set as they are displayed while calculating formulas'''
        raise NotImplementedError()
    
    @property
    def enable_calculation_chain(self) -> bool:
        '''Whether enable calculation chain for formulas. Default is false.'''
        raise NotImplementedError()
    
    @enable_calculation_chain.setter
    def enable_calculation_chain(self, value : bool) -> None:
        '''Whether enable calculation chain for formulas. Default is false.'''
        raise NotImplementedError()
    
    @property
    def preserve_padding_spaces(self) -> bool:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    
    @preserve_padding_spaces.setter
    def preserve_padding_spaces(self, value : bool) -> None:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    

class GlobalizationSettings:
    '''Represents the globalization settings.'''
    
    def get_pivot_total_name(self) -> str:
        '''Gets the name of "Total" label in the PivotTable.
        You need to override this method when the PivotTable contains two or more PivotFields in the data area.
        
        :returns: The name of "Total" label'''
        raise NotImplementedError()
    
    def get_pivot_grand_total_name(self) -> str:
        '''Gets the name of "Grand Total" label in the PivotTable.
        
        :returns: The name of "Grand Total" label'''
        raise NotImplementedError()
    
    def get_multiple_items_name(self) -> str:
        '''Gets the name of "(Multiple Items)" label in the PivotTable.
        
        :returns: The name of "(Multiple Items)" label'''
        raise NotImplementedError()
    
    def get_all_name(self) -> str:
        '''Gets the name of "(All)" label in the PivotTable.
        
        :returns: The name of "(All)" label'''
        raise NotImplementedError()
    
    def get_protection_name_of_pivot_table(self) -> str:
        '''Gets the protection name in the PivotTable.
        
        :returns: The protection name of PivotTable'''
        raise NotImplementedError()
    
    def get_column_labels_of_pivot_table(self) -> str:
        '''Gets the name of "Column Labels" label in the PivotTable.
        
        :returns: The name of column labels'''
        raise NotImplementedError()
    
    def get_row_labels_name_of_pivot_table(self) -> str:
        '''Gets the name of "Row Labels" label in the PivotTable.
        
        :returns: The name of row labels'''
        raise NotImplementedError()
    
    def get_empty_data_name(self) -> str:
        '''Gets the name of "(blank)" label in the PivotTable.
        
        :returns: The name of empty data'''
        raise NotImplementedError()
    
    def get_data_field_header_name_of_pivot_table(self) -> str:
        '''Gets the the name of the value area field header in the PivotTable.
        
        :returns: The name of data field header name'''
        raise NotImplementedError()
    
    def get_sub_total_name(self, sub_total_type : aspose.cells.pivot.PivotFieldSubtotalType) -> str:
        '''Gets the name of :py:class:`aspose.cells.pivot.PivotFieldSubtotalType` type in the PivotTable.
        
        :param sub_total_type: The :py:class:`aspose.cells.pivot.PivotFieldSubtotalType` type
        :returns: The name of :py:class:`aspose.cells.pivot.PivotFieldSubtotalType` type'''
        raise NotImplementedError()
    
    def get_total_name(self, function_type : aspose.cells.ConsolidationFunction) -> str:
        '''Gets the total name of the function.
        
        :param function_type: The function type.
        :returns: The total name of the function.'''
        raise NotImplementedError()
    
    def get_grand_total_name(self, function_type : aspose.cells.ConsolidationFunction) -> str:
        '''Gets the grand total name of the function.
        
        :param function_type: The function type.
        :returns: The grand total name of the function.'''
        raise NotImplementedError()
    
    def get_default_sheet_name(self) -> str:
        '''Gets the default sheet name for adding worksheet automatically.
        Default is "Sheet".
        
        :returns: the default sheet name for adding worksheet automatically'''
        raise NotImplementedError()
    
    def get_table_row_type_of_headers(self) -> str:
        '''Gets the type name of table rows that consists of the table header.
        Default is "Headers", so in formula "#Headers" represents the table header.
        
        :returns: the type name of table rows'''
        raise NotImplementedError()
    
    def get_table_row_type_of_data(self) -> str:
        '''Gets the type name of table rows that consists of data region of referenced table.
        Default is "Data", so in formula "#Data" represents the data region of the table.
        
        :returns: the type name of table rows'''
        raise NotImplementedError()
    
    def get_table_row_type_of_all(self) -> str:
        '''Gets the type name of table rows that consists of all rows in referenced table.
        Default is "All", so in formula "#All" represents all rows in referenced table.
        
        :returns: the type name of table rows'''
        raise NotImplementedError()
    
    def get_table_row_type_of_totals(self) -> str:
        '''Gets the type name of table rows that consists of the total row of referenced table.
        Default is "Totals", so in formula "#Totals" represents the total row of referenced table.
        
        :returns: the type name of table rows'''
        raise NotImplementedError()
    
    def get_table_row_type_of_current(self) -> str:
        '''Gets the type name of table rows that consists of the current row in referenced table.
        Default is "This Row", so in formula "#This Row" represents the current row in referenced table.
        
        :returns: the type name of table rows'''
        raise NotImplementedError()
    
    def get_error_value_string(self, err : str) -> str:
        '''Gets the display string value for cell\'s error value
        
        :param err: error values such as #VALUE!,#NAME?
        :returns: By default returns the error value itself'''
        raise NotImplementedError()
    
    def get_boolean_value_string(self, bv : bool) -> str:
        '''Gets the display string value for cell\'s boolean value
        
        :param bv: boolean value
        :returns: By default returns "TRUE" for true value and "FALSE" for false value.'''
        raise NotImplementedError()
    
    def get_local_function_name(self, standard_name : str) -> str:
        '''Gets the locale dependent function name according to given standard function name.
        
        :param standard_name: Standard(en-US locale) function name.
        :returns: Locale dependent function name. The locale was specified by the Workbook for which this settings is used.'''
        raise NotImplementedError()
    
    def get_standard_function_name(self, local_name : str) -> str:
        '''Gets the standard function name according to given locale dependent function name.
        
        :param local_name: Locale dependent function name. The locale was specified by the Workbook for which this settings is used.
        :returns: Standard(en-US locale) function name.'''
        raise NotImplementedError()
    
    def get_local_built_in_name(self, standard_name : str) -> str:
        '''Gets the locale dependent text for built-in Name according to given standard text.
        
        :param standard_name: Standard(en-US locale) text of built-in Name.
        :returns: Locale dependent text. The locale was specified by the Workbook for which this settings is used.'''
        raise NotImplementedError()
    
    def get_standard_built_in_name(self, local_name : str) -> str:
        '''Gets the standard text of built-in Name according to given locale dependent text.
        
        :param local_name: Locale dependent text of built-in Name. The locale was specified by the Workbook for which this settings is used.
        :returns: Standard(en-US locale) text.'''
        raise NotImplementedError()
    
    def get_standard_header_footer_font_style_name(self, localfont_style_name : str) -> str:
        '''Gets standard English font style name(Regular, Bold, Italic) for Header/Footer according to given locale font style name.
        
        :param localfont_style_name: Locale font style name for Header/Footer.
        :returns: Standard English font style name(Regular, Bold, Italic)'''
        raise NotImplementedError()
    
    def get_comment_title_name(self, type : aspose.cells.rendering.CommentTitleType) -> str:
        '''Gets the locale dependent comment title name according to comment title type.'''
        raise NotImplementedError()
    
    def compare(self, v1 : str, v2 : str, ignore_case : bool) -> int:
        '''Compares two string values according to certain collation rules.
        
        :param v1: the first string
        :param v2: the second string
        :param ignore_case: whether ignore case when comparing values
        :returns: Integer that indicates the lexical relationship between the two comparands'''
        raise NotImplementedError()
    
    @property
    def chart_settings(self) -> aspose.cells.charts.ChartGlobalizationSettings:
        '''Gets the globalization settings for Chart.'''
        raise NotImplementedError()
    
    @chart_settings.setter
    def chart_settings(self, value : aspose.cells.charts.ChartGlobalizationSettings) -> None:
        '''Sets the globalization settings for Chart.'''
        raise NotImplementedError()
    
    @property
    def pivot_settings(self) -> aspose.cells.settings.PivotGlobalizationSettings:
        '''Gets the globalization settings for pivot table.'''
        raise NotImplementedError()
    
    @pivot_settings.setter
    def pivot_settings(self, value : aspose.cells.settings.PivotGlobalizationSettings) -> None:
        '''Sets the globalization settings for pivot table.'''
        raise NotImplementedError()
    
    @property
    def list_separator(self) -> str:
        '''Gets the separator for list, parameters of function, ...etc.'''
        raise NotImplementedError()
    
    @property
    def row_separator_of_formula_array(self) -> str:
        '''Gets the separator for rows in array data in formula.'''
        raise NotImplementedError()
    
    @property
    def column_separator_of_formula_array(self) -> str:
        '''Gets the separator for the items in array\'s row data in formula.'''
        raise NotImplementedError()
    

class HeaderFooterCommand:
    '''Represents the command of header/footer'''
    
    @property
    def type(self) -> aspose.cells.HeaderFooterCommandType:
        '''Gets the header/footer\' command type .'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Gets the font of the command\'s value.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets the text of the command.'''
        raise NotImplementedError()
    

class HorizontalPageBreak:
    '''Encapsulates the object that represents a horizontal page break.'''
    
    @property
    def start_column(self) -> int:
        '''Gets the start column index of this horizontal page break.'''
        raise NotImplementedError()
    
    @property
    def end_column(self) -> int:
        '''Gets the end column index of this horizontal page break.'''
        raise NotImplementedError()
    
    @property
    def row(self) -> int:
        '''Gets the zero based row index.'''
        raise NotImplementedError()
    

class HorizontalPageBreakCollection:
    '''Encapsulates a collection of :py:class:`aspose.cells.HorizontalPageBreak` objects.'''
    
    @overload
    def add(self, row : int, start_column : int, end_column : int) -> int:
        '''Adds a horizontal page break to the collection.
        
        :param row: Row index, zero based.
        :param start_column: Start column index, zero based.
        :param end_column: End column index, zero based.
        :returns: :py:class:`aspose.cells.HorizontalPageBreak` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, row : int) -> int:
        '''Adds a horizontal page break to the collection.
        
        :param row: Cell row index, zero based.
        :returns: :py:class:`aspose.cells.HorizontalPageBreak` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, row : int, column : int) -> int:
        '''Adds a horizontal page break to the collection.
        
        :param row: Cell row index, zero based.
        :param column: Cell column index, zero based.
        :returns: :py:class:`aspose.cells.HorizontalPageBreak` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, cell_name : str) -> int:
        '''Adds a horizontal page break to the collection.
        
        :param cell_name: Cell name.
        :returns: :py:class:`aspose.cells.HorizontalPageBreak` object index.'''
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.HorizontalPageBreak]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.HorizontalPageBreak], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.HorizontalPageBreak, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.HorizontalPageBreak, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.HorizontalPageBreak) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.HorizontalPageBreak, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.HorizontalPageBreak, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.HorizontalPageBreak) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class HtmlLoadOptions(AbstractTextLoadOptions):
    '''Represents options when importing a html file.'''
    
    def set_paper_size(self, type : aspose.cells.PaperSizeType) -> None:
        '''Sets the default print paper size from default printer\'s setting.
        
        :param type: The default paper size.'''
        raise NotImplementedError()
    
    @property
    def load_format(self) -> aspose.cells.LoadFormat:
        '''Gets the load format.'''
        raise NotImplementedError()
    
    @property
    def password(self) -> str:
        '''Gets and set the password of the workbook.'''
        raise NotImplementedError()
    
    @password.setter
    def password(self, value : str) -> None:
        '''Gets and set the password of the workbook.'''
        raise NotImplementedError()
    
    @property
    def parsing_formula_on_open(self) -> bool:
        '''Indicates whether parsing the formula when reading the file.'''
        raise NotImplementedError()
    
    @parsing_formula_on_open.setter
    def parsing_formula_on_open(self, value : bool) -> None:
        '''Indicates whether parsing the formula when reading the file.'''
        raise NotImplementedError()
    
    @property
    def parsing_pivot_cached_records(self) -> bool:
        '''Indicates whether parsing pivot cached records when loading the file.
        The default value is false.'''
        raise NotImplementedError()
    
    @parsing_pivot_cached_records.setter
    def parsing_pivot_cached_records(self, value : bool) -> None:
        '''Indicates whether parsing pivot cached records when loading the file.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def language_code(self) -> aspose.cells.CountryCode:
        '''Gets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @language_code.setter
    def language_code(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @property
    def region(self) -> aspose.cells.CountryCode:
        '''Gets the system regional settings based on CountryCode at the time the file was loaded.'''
        raise NotImplementedError()
    
    @region.setter
    def region(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the system regional settings based on CountryCode at the time the file was loaded.'''
        raise NotImplementedError()
    
    @property
    def default_style_settings(self) -> aspose.cells.DefaultStyleSettings:
        '''Gets the default style settings for initializing styles of the workbook'''
        raise NotImplementedError()
    
    @property
    def standard_font(self) -> str:
        '''Sets the default standard font name'''
        raise NotImplementedError()
    
    @standard_font.setter
    def standard_font(self, value : str) -> None:
        '''Sets the default standard font name'''
        raise NotImplementedError()
    
    @property
    def standard_font_size(self) -> float:
        '''Sets the default standard font size.'''
        raise NotImplementedError()
    
    @standard_font_size.setter
    def standard_font_size(self, value : float) -> None:
        '''Sets the default standard font size.'''
        raise NotImplementedError()
    
    @property
    def interrupt_monitor(self) -> aspose.cells.AbstractInterruptMonitor:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.cells.AbstractInterruptMonitor) -> None:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @property
    def ignore_not_printed(self) -> bool:
        '''Ignore the data which are not printed if directly printing the file'''
        raise NotImplementedError()
    
    @ignore_not_printed.setter
    def ignore_not_printed(self, value : bool) -> None:
        '''Ignore the data which are not printed if directly printing the file'''
        raise NotImplementedError()
    
    @property
    def check_data_valid(self) -> bool:
        '''Check whether data is valid in the template file.'''
        raise NotImplementedError()
    
    @check_data_valid.setter
    def check_data_valid(self, value : bool) -> None:
        '''Check whether data is valid in the template file.'''
        raise NotImplementedError()
    
    @property
    def check_excel_restriction(self) -> bool:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @check_excel_restriction.setter
    def check_excel_restriction(self, value : bool) -> None:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @property
    def keep_unparsed_data(self) -> bool:
        '''Whether keep the unparsed data in memory for the Workbook when it is loaded from template file. Default is true.'''
        raise NotImplementedError()
    
    @keep_unparsed_data.setter
    def keep_unparsed_data(self, value : bool) -> None:
        '''Whether keep the unparsed data in memory for the Workbook when it is loaded from template file. Default is true.'''
        raise NotImplementedError()
    
    @property
    def load_filter(self) -> aspose.cells.LoadFilter:
        '''The filter to denote how to load data.'''
        raise NotImplementedError()
    
    @load_filter.setter
    def load_filter(self, value : aspose.cells.LoadFilter) -> None:
        '''The filter to denote how to load data.'''
        raise NotImplementedError()
    
    @property
    def light_cells_data_handler(self) -> aspose.cells.LightCellsDataHandler:
        '''The data handler for processing cells data when reading template file.'''
        raise NotImplementedError()
    
    @light_cells_data_handler.setter
    def light_cells_data_handler(self, value : aspose.cells.LightCellsDataHandler) -> None:
        '''The data handler for processing cells data when reading template file.'''
        raise NotImplementedError()
    
    @property
    def memory_setting(self) -> aspose.cells.MemorySetting:
        '''Gets the memory usage options.'''
        raise NotImplementedError()
    
    @memory_setting.setter
    def memory_setting(self, value : aspose.cells.MemorySetting) -> None:
        '''Sets the memory usage options.'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def auto_fitter_options(self) -> aspose.cells.AutoFitterOptions:
        '''Gets and sets the auto fitter options'''
        raise NotImplementedError()
    
    @auto_fitter_options.setter
    def auto_fitter_options(self, value : aspose.cells.AutoFitterOptions) -> None:
        '''Gets and sets the auto fitter options'''
        raise NotImplementedError()
    
    @property
    def auto_filter(self) -> bool:
        '''Indicates whether auto filtering the data when loading the files.'''
        raise NotImplementedError()
    
    @auto_filter.setter
    def auto_filter(self, value : bool) -> None:
        '''Indicates whether auto filtering the data when loading the files.'''
        raise NotImplementedError()
    
    @property
    def font_configs(self) -> aspose.cells.IndividualFontConfigs:
        '''Gets and sets individual font configs.
        Only works for the :py:class:`aspose.cells.Workbook` which uses this :py:class:`aspose.cells.LoadOptions` to load.'''
        raise NotImplementedError()
    
    @font_configs.setter
    def font_configs(self, value : aspose.cells.IndividualFontConfigs) -> None:
        '''Gets and sets individual font configs.
        Only works for the :py:class:`aspose.cells.Workbook` which uses this :py:class:`aspose.cells.LoadOptions` to load.'''
        raise NotImplementedError()
    
    @property
    def ignore_useless_shapes(self) -> bool:
        '''Indicates whether ignoring useless shapes.'''
        raise NotImplementedError()
    
    @ignore_useless_shapes.setter
    def ignore_useless_shapes(self, value : bool) -> None:
        '''Indicates whether ignoring useless shapes.'''
        raise NotImplementedError()
    
    @property
    def preserve_padding_spaces_in_formula(self) -> bool:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    
    @preserve_padding_spaces_in_formula.setter
    def preserve_padding_spaces_in_formula(self, value : bool) -> None:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    
    @property
    def encoding(self) -> str:
        '''Gets and sets the default encoding. Only applies for csv file.'''
        raise NotImplementedError()
    
    @encoding.setter
    def encoding(self, value : str) -> None:
        '''Gets and sets the default encoding. Only applies for csv file.'''
        raise NotImplementedError()
    
    @property
    def load_style_strategy(self) -> aspose.cells.TxtLoadStyleStrategy:
        '''Indicates the strategy to apply style for parsed values when converting string value to number or datetime.'''
        raise NotImplementedError()
    
    @load_style_strategy.setter
    def load_style_strategy(self, value : aspose.cells.TxtLoadStyleStrategy) -> None:
        '''Indicates the strategy to apply style for parsed values when converting string value to number or datetime.'''
        raise NotImplementedError()
    
    @property
    def convert_numeric_data(self) -> bool:
        '''Gets a value that indicates whether the string in text file is converted to numeric data.'''
        raise NotImplementedError()
    
    @convert_numeric_data.setter
    def convert_numeric_data(self, value : bool) -> None:
        '''Sets a value that indicates whether the string in text file is converted to numeric data.'''
        raise NotImplementedError()
    
    @property
    def convert_date_time_data(self) -> bool:
        '''Gets a value that indicates whether the string in text file is converted to date data.'''
        raise NotImplementedError()
    
    @convert_date_time_data.setter
    def convert_date_time_data(self, value : bool) -> None:
        '''Sets a value that indicates whether the string in text file is converted to date data.'''
        raise NotImplementedError()
    
    @property
    def keep_precision(self) -> bool:
        '''Indicates whether not parsing a string value if the length is 15.'''
        raise NotImplementedError()
    
    @keep_precision.setter
    def keep_precision(self, value : bool) -> None:
        '''Indicates whether not parsing a string value if the length is 15.'''
        raise NotImplementedError()
    
    @property
    def attached_files_directory(self) -> str:
        '''The directory that the attached files will be saved to.'''
        raise NotImplementedError()
    
    @attached_files_directory.setter
    def attached_files_directory(self, value : str) -> None:
        '''The directory that the attached files will be saved to.'''
        raise NotImplementedError()
    
    @property
    def load_formulas(self) -> bool:
        '''Indicates whether importing formulas if the original html file contains formulas'''
        raise NotImplementedError()
    
    @load_formulas.setter
    def load_formulas(self, value : bool) -> None:
        '''Indicates whether importing formulas if the original html file contains formulas'''
        raise NotImplementedError()
    
    @property
    def support_div_tag(self) -> bool:
        '''Indicates whether support the layout of ``<div>`` tag when the html file contains it.
        The default value is false.'''
        raise NotImplementedError()
    
    @support_div_tag.setter
    def support_div_tag(self, value : bool) -> None:
        '''Indicates whether support the layout of ``<div>`` tag when the html file contains it.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def delete_redundant_spaces(self) -> bool:
        '''Indicates whether delete redundant spaces when the text wraps lines using ``<br>`` tag.
        The default value is false.'''
        raise NotImplementedError()
    
    @delete_redundant_spaces.setter
    def delete_redundant_spaces(self, value : bool) -> None:
        '''Indicates whether delete redundant spaces when the text wraps lines using ``<br>`` tag.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def auto_fit_cols_and_rows(self) -> bool:
        '''Indicates whether auto-fit columns and rows. The default value is false.'''
        raise NotImplementedError()
    
    @auto_fit_cols_and_rows.setter
    def auto_fit_cols_and_rows(self, value : bool) -> None:
        '''Indicates whether auto-fit columns and rows. The default value is false.'''
        raise NotImplementedError()
    
    @property
    def convert_formulas_data(self) -> bool:
        '''if true, convert string to formula when string value starts with character \'=\',the default value is false.'''
        raise NotImplementedError()
    
    @convert_formulas_data.setter
    def convert_formulas_data(self, value : bool) -> None:
        '''if true, convert string to formula when string value starts with character \'=\',the default value is false.'''
        raise NotImplementedError()
    
    @property
    def has_formula(self) -> bool:
        '''Indicates whether the text is formula if it starts with "=".'''
        raise NotImplementedError()
    
    @has_formula.setter
    def has_formula(self, value : bool) -> None:
        '''Indicates whether the text is formula if it starts with "=".'''
        raise NotImplementedError()
    
    @property
    def stream_provider(self) -> aspose.cells.IStreamProvider:
        '''Gets the StreamProviderImportHtmlFile for importing objects.'''
        raise NotImplementedError()
    
    @stream_provider.setter
    def stream_provider(self, value : aspose.cells.IStreamProvider) -> None:
        '''Sets the StreamProviderImportHtmlFile for importing objects.'''
        raise NotImplementedError()
    
    @property
    def prog_id(self) -> str:
        '''Gets the program id of creating the file.
        Only for MHT files.'''
        raise NotImplementedError()
    
    @property
    def table_load_options(self) -> aspose.cells.HtmlTableLoadOptionCollection:
        '''Get the HtmlTableLoadOptionCollection instance'''
        raise NotImplementedError()
    

class HtmlSaveOptions(SaveOptions):
    '''Represents the options for saving html file.'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def ignore_invisible_shapes(self) -> bool:
        '''Indicate whether exporting those not visible shapes'''
        raise NotImplementedError()
    
    @ignore_invisible_shapes.setter
    def ignore_invisible_shapes(self, value : bool) -> None:
        '''Indicate whether exporting those not visible shapes'''
        raise NotImplementedError()
    
    @property
    def page_title(self) -> str:
        '''The title of the html page.
        Only for saving to html stream.'''
        raise NotImplementedError()
    
    @page_title.setter
    def page_title(self, value : str) -> None:
        '''The title of the html page.
        Only for saving to html stream.'''
        raise NotImplementedError()
    
    @property
    def attached_files_directory(self) -> str:
        '''The directory that the attached files will be saved to.
        Only for saving to html stream.'''
        raise NotImplementedError()
    
    @attached_files_directory.setter
    def attached_files_directory(self, value : str) -> None:
        '''The directory that the attached files will be saved to.
        Only for saving to html stream.'''
        raise NotImplementedError()
    
    @property
    def attached_files_url_prefix(self) -> str:
        '''Specify the Url prefix of attached files such as image in the html file.
        Only for saving to html stream.'''
        raise NotImplementedError()
    
    @attached_files_url_prefix.setter
    def attached_files_url_prefix(self, value : str) -> None:
        '''Specify the Url prefix of attached files such as image in the html file.
        Only for saving to html stream.'''
        raise NotImplementedError()
    
    @property
    def default_font_name(self) -> str:
        '''Specify the default font name for exporting html, the default font will be used  when the font of style is not existing,
        If this property is null, Aspose.Cells will use universal font which have the same family with the original font,
        the default value is null.'''
        raise NotImplementedError()
    
    @default_font_name.setter
    def default_font_name(self, value : str) -> None:
        '''Specify the default font name for exporting html, the default font will be used  when the font of style is not existing,
        If this property is null, Aspose.Cells will use universal font which have the same family with the original font,
        the default value is null.'''
        raise NotImplementedError()
    
    @property
    def add_generic_font(self) -> bool:
        raise NotImplementedError()
    
    @add_generic_font.setter
    def add_generic_font(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def worksheet_scalable(self) -> bool:
        '''Indicates if zooming in or out the html via worksheet zoom level when saving file to html, the default value is false.'''
        raise NotImplementedError()
    
    @worksheet_scalable.setter
    def worksheet_scalable(self, value : bool) -> None:
        '''Indicates if zooming in or out the html via worksheet zoom level when saving file to html, the default value is false.'''
        raise NotImplementedError()
    
    @property
    def is_export_comments(self) -> bool:
        '''Indicates if exporting comments when saving file to html, the default value is false.'''
        raise NotImplementedError()
    
    @is_export_comments.setter
    def is_export_comments(self, value : bool) -> None:
        '''Indicates if exporting comments when saving file to html, the default value is false.'''
        raise NotImplementedError()
    
    @property
    def export_comments_type(self) -> aspose.cells.PrintCommentsType:
        '''Represents type of exporting comments to html files.'''
        raise NotImplementedError()
    
    @export_comments_type.setter
    def export_comments_type(self, value : aspose.cells.PrintCommentsType) -> None:
        '''Represents type of exporting comments to html files.'''
        raise NotImplementedError()
    
    @property
    def disable_downlevel_revealed_comments(self) -> bool:
        '''Indicates if disable Downlevel-revealed conditional comments when exporting file to html, the default value is false.'''
        raise NotImplementedError()
    
    @disable_downlevel_revealed_comments.setter
    def disable_downlevel_revealed_comments(self, value : bool) -> None:
        '''Indicates if disable Downlevel-revealed conditional comments when exporting file to html, the default value is false.'''
        raise NotImplementedError()
    
    @property
    def is_exp_image_to_temp_dir(self) -> bool:
        '''Indicates whether exporting image files to temp directory.
        Only for saving to html stream.'''
        raise NotImplementedError()
    
    @is_exp_image_to_temp_dir.setter
    def is_exp_image_to_temp_dir(self, value : bool) -> None:
        '''Indicates whether exporting image files to temp directory.
        Only for saving to html stream.'''
        raise NotImplementedError()
    
    @property
    def image_scalable(self) -> bool:
        '''Indicates whether using scalable unit to describe the image width
        when using scalable unit to describe the column width.
        The default value is true.'''
        raise NotImplementedError()
    
    @image_scalable.setter
    def image_scalable(self, value : bool) -> None:
        '''Indicates whether using scalable unit to describe the image width
        when using scalable unit to describe the column width.
        The default value is true.'''
        raise NotImplementedError()
    
    @property
    def width_scalable(self) -> bool:
        '''Indicates whether exporting column width in unit of scale to html.
        The default value is false.'''
        raise NotImplementedError()
    
    @width_scalable.setter
    def width_scalable(self, value : bool) -> None:
        '''Indicates whether exporting column width in unit of scale to html.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def export_single_tab(self) -> bool:
        '''Indicates whether exporting the single tab when the file only has one worksheet.
        The default value is false.'''
        raise NotImplementedError()
    
    @export_single_tab.setter
    def export_single_tab(self, value : bool) -> None:
        '''Indicates whether exporting the single tab when the file only has one worksheet.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def export_images_as_base64(self) -> bool:
        '''Specifies whether images are saved in Base64 format to HTML, MHTML or EPUB.'''
        raise NotImplementedError()
    
    @export_images_as_base64.setter
    def export_images_as_base64(self, value : bool) -> None:
        '''Specifies whether images are saved in Base64 format to HTML, MHTML or EPUB.'''
        raise NotImplementedError()
    
    @property
    def export_active_worksheet_only(self) -> bool:
        '''Indicates if only exporting the active worksheet to html file.
        If true then only the active worksheet will be exported to html file;
        If false then the whole workbook will be exported to html file.
        The default value is false.'''
        raise NotImplementedError()
    
    @export_active_worksheet_only.setter
    def export_active_worksheet_only(self, value : bool) -> None:
        '''Indicates if only exporting the active worksheet to html file.
        If true then only the active worksheet will be exported to html file;
        If false then the whole workbook will be exported to html file.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def export_print_area_only(self) -> bool:
        '''Indicates if only exporting the print area to html file. The default value is false.'''
        raise NotImplementedError()
    
    @export_print_area_only.setter
    def export_print_area_only(self, value : bool) -> None:
        '''Indicates if only exporting the print area to html file. The default value is false.'''
        raise NotImplementedError()
    
    @property
    def export_area(self) -> aspose.cells.CellArea:
        '''Gets or Sets the exporting CellArea of current active Worksheet.
        If you set this attribute, the print area of current active Worksheet will be omitted.
        Only the specified area will be exported when saving the file to html.'''
        raise NotImplementedError()
    
    @export_area.setter
    def export_area(self, value : aspose.cells.CellArea) -> None:
        '''Gets or Sets the exporting CellArea of current active Worksheet.
        If you set this attribute, the print area of current active Worksheet will be omitted.
        Only the specified area will be exported when saving the file to html.'''
        raise NotImplementedError()
    
    @property
    def parse_html_tag_in_cell(self) -> bool:
        '''Indicates whether html tag(such as ``<div></div>``) in cell should be parsed as cell value or preserved as it is.
        The default value is true.'''
        raise NotImplementedError()
    
    @parse_html_tag_in_cell.setter
    def parse_html_tag_in_cell(self, value : bool) -> None:
        '''Indicates whether html tag(such as ``<div></div>``) in cell should be parsed as cell value or preserved as it is.
        The default value is true.'''
        raise NotImplementedError()
    
    @property
    def html_cross_string_type(self) -> aspose.cells.HtmlCrossType:
        '''Indicates if a cross-cell string will be displayed in the same way as MS Excel when saving an Excel file in html format.
        By default the value is Default, so, for cross-cell strings, there is little difference between the html files created by Aspose.Cells and MS Excel.
        But the performance for creating large html files,setting the value to Cross would be several times faster than setting it to Default or Fit2Cell.'''
        raise NotImplementedError()
    
    @html_cross_string_type.setter
    def html_cross_string_type(self, value : aspose.cells.HtmlCrossType) -> None:
        '''Indicates if a cross-cell string will be displayed in the same way as MS Excel when saving an Excel file in html format.
        By default the value is Default, so, for cross-cell strings, there is little difference between the html files created by Aspose.Cells and MS Excel.
        But the performance for creating large html files,setting the value to Cross would be several times faster than setting it to Default or Fit2Cell.'''
        raise NotImplementedError()
    
    @property
    def hidden_col_display_type(self) -> aspose.cells.HtmlHiddenColDisplayType:
        '''Hidden column(the width of this column is 0) in excel,before save this into html format,
        if HtmlHiddenColDisplayType is "Remove",the hidden column would not been output,
        if the value is "Hidden", the column would been output,but was hidden,the default value is "Hidden"'''
        raise NotImplementedError()
    
    @hidden_col_display_type.setter
    def hidden_col_display_type(self, value : aspose.cells.HtmlHiddenColDisplayType) -> None:
        '''Hidden column(the width of this column is 0) in excel,before save this into html format,
        if HtmlHiddenColDisplayType is "Remove",the hidden column would not been output,
        if the value is "Hidden", the column would been output,but was hidden,the default value is "Hidden"'''
        raise NotImplementedError()
    
    @property
    def hidden_row_display_type(self) -> aspose.cells.HtmlHiddenRowDisplayType:
        '''Hidden row(the height of this row is 0) in excel,before save this into html format,
        if HtmlHiddenRowDisplayType is "Remove",the hidden row would not been output,
        if the value is "Hidden", the row would been output,but was hidden,the default value is "Hidden"'''
        raise NotImplementedError()
    
    @hidden_row_display_type.setter
    def hidden_row_display_type(self, value : aspose.cells.HtmlHiddenRowDisplayType) -> None:
        '''Hidden row(the height of this row is 0) in excel,before save this into html format,
        if HtmlHiddenRowDisplayType is "Remove",the hidden row would not been output,
        if the value is "Hidden", the row would been output,but was hidden,the default value is "Hidden"'''
        raise NotImplementedError()
    
    @property
    def encoding(self) -> str:
        '''If not set,use Encoding.UTF8 as default enconding type.'''
        raise NotImplementedError()
    
    @encoding.setter
    def encoding(self, value : str) -> None:
        '''If not set,use Encoding.UTF8 as default enconding type.'''
        raise NotImplementedError()
    
    @property
    def export_object_listener(self) -> aspose.cells.IExportObjectListener:
        '''Gets the ExportObjectListener for exporting objects.'''
        raise NotImplementedError()
    
    @export_object_listener.setter
    def export_object_listener(self, value : aspose.cells.IExportObjectListener) -> None:
        '''Sets the ExportObjectListener for exporting objects.'''
        raise NotImplementedError()
    
    @property
    def file_path_provider(self) -> aspose.cells.IFilePathProvider:
        '''Gets the IFilePathProvider for exporting Worksheet to html separately.'''
        raise NotImplementedError()
    
    @file_path_provider.setter
    def file_path_provider(self, value : aspose.cells.IFilePathProvider) -> None:
        '''Sets the IFilePathProvider for exporting Worksheet to html separately.'''
        raise NotImplementedError()
    
    @property
    def stream_provider(self) -> aspose.cells.IStreamProvider:
        '''Gets the IStreamProvider for exporting objects.'''
        raise NotImplementedError()
    
    @stream_provider.setter
    def stream_provider(self, value : aspose.cells.IStreamProvider) -> None:
        '''Sets the IStreamProvider for exporting objects.'''
        raise NotImplementedError()
    
    @property
    def image_options(self) -> aspose.cells.rendering.ImageOrPrintOptions:
        '''Get the ImageOrPrintOptions object before exporting'''
        raise NotImplementedError()
    
    @property
    def save_as_single_file(self) -> bool:
        '''Indicates whether save the html as single file.
        The default value is false.'''
        raise NotImplementedError()
    
    @save_as_single_file.setter
    def save_as_single_file(self, value : bool) -> None:
        '''Indicates whether save the html as single file.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def show_all_sheets(self) -> bool:
        '''Indicates whether showing all sheets when saving  as a single html file.'''
        raise NotImplementedError()
    
    @show_all_sheets.setter
    def show_all_sheets(self, value : bool) -> None:
        '''Indicates whether showing all sheets when saving  as a single html file.'''
        raise NotImplementedError()
    
    @property
    def export_page_headers(self) -> bool:
        '''Indicates whether exporting page headers.'''
        raise NotImplementedError()
    
    @export_page_headers.setter
    def export_page_headers(self, value : bool) -> None:
        '''Indicates whether exporting page headers.'''
        raise NotImplementedError()
    
    @property
    def export_page_footers(self) -> bool:
        '''Indicates whether exporting page headers.'''
        raise NotImplementedError()
    
    @export_page_footers.setter
    def export_page_footers(self, value : bool) -> None:
        '''Indicates whether exporting page headers.'''
        raise NotImplementedError()
    
    @property
    def export_hidden_worksheet(self) -> bool:
        '''Indicating if exporting the hidden worksheet content.The default value is true.'''
        raise NotImplementedError()
    
    @export_hidden_worksheet.setter
    def export_hidden_worksheet(self, value : bool) -> None:
        '''Indicating if exporting the hidden worksheet content.The default value is true.'''
        raise NotImplementedError()
    
    @property
    def presentation_preference(self) -> bool:
        '''Indicating if html or mht file is presentation preference.
        The default value is false.
        if you want to get more beautiful presentation,please set the value to true.'''
        raise NotImplementedError()
    
    @presentation_preference.setter
    def presentation_preference(self, value : bool) -> None:
        '''Indicating if html or mht file is presentation preference.
        The default value is false.
        if you want to get more beautiful presentation,please set the value to true.'''
        raise NotImplementedError()
    
    @property
    def cell_css_prefix(self) -> str:
        '''Gets and sets the prefix of the css name,the default value is "".'''
        raise NotImplementedError()
    
    @cell_css_prefix.setter
    def cell_css_prefix(self, value : str) -> None:
        '''Gets and sets the prefix of the css name,the default value is "".'''
        raise NotImplementedError()
    
    @property
    def table_css_id(self) -> str:
        '''Gets and sets the prefix of the type css name such as tr,col,td and so on, they are contained in the table element
        which has the specific TableCssId attribute. The default value is "".'''
        raise NotImplementedError()
    
    @table_css_id.setter
    def table_css_id(self, value : str) -> None:
        '''Gets and sets the prefix of the type css name such as tr,col,td and so on, they are contained in the table element
        which has the specific TableCssId attribute. The default value is "".'''
        raise NotImplementedError()
    
    @property
    def is_full_path_link(self) -> bool:
        '''Indicating whether using full path link in sheet00x.htm,filelist.xml and tabstrip.htm.
        The default value is false.'''
        raise NotImplementedError()
    
    @is_full_path_link.setter
    def is_full_path_link(self, value : bool) -> None:
        '''Indicating whether using full path link in sheet00x.htm,filelist.xml and tabstrip.htm.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def export_worksheet_css_separately(self) -> bool:
        '''Indicating whether export the worksheet css separately.The default value is false.'''
        raise NotImplementedError()
    
    @export_worksheet_css_separately.setter
    def export_worksheet_css_separately(self, value : bool) -> None:
        '''Indicating whether export the worksheet css separately.The default value is false.'''
        raise NotImplementedError()
    
    @property
    def export_similar_border_style(self) -> bool:
        '''Indicating whether exporting the similar border style when the border style is not supported by browsers.
        If you want to import the html or mht file to excel, please keep the default value.
        The default value is false.'''
        raise NotImplementedError()
    
    @export_similar_border_style.setter
    def export_similar_border_style(self, value : bool) -> None:
        '''Indicating whether exporting the similar border style when the border style is not supported by browsers.
        If you want to import the html or mht file to excel, please keep the default value.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def merge_empty_td_forcely(self) -> bool:
        '''Indicates whether merging empty TD element forcedly when exporting file to html.
        The size of html file will be reduced significantly after setting value to true. The default value is false.
        If you want to import the html file to excel or export perfect grid lines when saving file to html,
        please keep the default value.'''
        raise NotImplementedError()
    
    @merge_empty_td_forcely.setter
    def merge_empty_td_forcely(self, value : bool) -> None:
        '''Indicates whether merging empty TD element forcedly when exporting file to html.
        The size of html file will be reduced significantly after setting value to true. The default value is false.
        If you want to import the html file to excel or export perfect grid lines when saving file to html,
        please keep the default value.'''
        raise NotImplementedError()
    
    @property
    def merge_empty_td_type(self) -> aspose.cells.MergeEmptyTdType:
        '''Indicates if empty TD element will be merged in the same way as MS Excel when saving an Excel file in html format.
        The default value is MergeEmptyTdType.Default.'''
        raise NotImplementedError()
    
    @merge_empty_td_type.setter
    def merge_empty_td_type(self, value : aspose.cells.MergeEmptyTdType) -> None:
        '''Indicates if empty TD element will be merged in the same way as MS Excel when saving an Excel file in html format.
        The default value is MergeEmptyTdType.Default.'''
        raise NotImplementedError()
    
    @property
    def export_cell_coordinate(self) -> bool:
        '''Indicates whether exporting excel coordinate of nonblank cells when saving file to html. The default value is false.
        If you want to import the output html to excel, please keep the default value.'''
        raise NotImplementedError()
    
    @export_cell_coordinate.setter
    def export_cell_coordinate(self, value : bool) -> None:
        '''Indicates whether exporting excel coordinate of nonblank cells when saving file to html. The default value is false.
        If you want to import the output html to excel, please keep the default value.'''
        raise NotImplementedError()
    
    @property
    def export_extra_headings(self) -> bool:
        '''Indicates whether exporting extra headings when the length of text is longer than max display column.
        The default value is false. If you want to import the html file to excel, please keep the default value.'''
        raise NotImplementedError()
    
    @export_extra_headings.setter
    def export_extra_headings(self, value : bool) -> None:
        '''Indicates whether exporting extra headings when the length of text is longer than max display column.
        The default value is false. If you want to import the html file to excel, please keep the default value.'''
        raise NotImplementedError()
    
    @property
    def export_headings(self) -> bool:
        '''Indicates whether exports sheet\'s row and column headings when saving to HTML files.'''
        raise NotImplementedError()
    
    @export_headings.setter
    def export_headings(self, value : bool) -> None:
        '''Indicates whether exports sheet\'s row and column headings when saving to HTML files.'''
        raise NotImplementedError()
    
    @property
    def export_row_column_headings(self) -> bool:
        '''Indicates whether exports sheet\'s row and column headings when saving to HTML files.'''
        raise NotImplementedError()
    
    @export_row_column_headings.setter
    def export_row_column_headings(self, value : bool) -> None:
        '''Indicates whether exports sheet\'s row and column headings when saving to HTML files.'''
        raise NotImplementedError()
    
    @property
    def export_formula(self) -> bool:
        '''Indicates whether exporting formula when saving file to html. The default value is true.
        If you want to import the output html to excel, please keep the default value.'''
        raise NotImplementedError()
    
    @export_formula.setter
    def export_formula(self, value : bool) -> None:
        '''Indicates whether exporting formula when saving file to html. The default value is true.
        If you want to import the output html to excel, please keep the default value.'''
        raise NotImplementedError()
    
    @property
    def add_tooltip_text(self) -> bool:
        '''Indicates whether adding tooltip text when the data can\'t be fully displayed.
        The default value is false.'''
        raise NotImplementedError()
    
    @add_tooltip_text.setter
    def add_tooltip_text(self, value : bool) -> None:
        '''Indicates whether adding tooltip text when the data can\'t be fully displayed.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def export_grid_lines(self) -> bool:
        '''Indicating whether exporting the gridlines.The default value is false.'''
        raise NotImplementedError()
    
    @export_grid_lines.setter
    def export_grid_lines(self, value : bool) -> None:
        '''Indicating whether exporting the gridlines.The default value is false.'''
        raise NotImplementedError()
    
    @property
    def export_bogus_row_data(self) -> bool:
        '''Indicating whether exporting bogus bottom row data. The default value is true.If you want to import the html or mht file
        to excel, please keep the default value.'''
        raise NotImplementedError()
    
    @export_bogus_row_data.setter
    def export_bogus_row_data(self, value : bool) -> None:
        '''Indicating whether exporting bogus bottom row data. The default value is true.If you want to import the html or mht file
        to excel, please keep the default value.'''
        raise NotImplementedError()
    
    @property
    def exclude_unused_styles(self) -> bool:
        '''Indicating whether excludes unused styles.
        For the generated html files, excluding unused styles can make the file size smaller
        without affecting the visual effects. So the default value of this property is true.
        If user needs to keep all styles in the workbook for the generated html(such as the scenario that user
        needs to restore the workbook from the generated html later), please set this property as false.'''
        raise NotImplementedError()
    
    @exclude_unused_styles.setter
    def exclude_unused_styles(self, value : bool) -> None:
        '''Indicating whether excludes unused styles.
        For the generated html files, excluding unused styles can make the file size smaller
        without affecting the visual effects. So the default value of this property is true.
        If user needs to keep all styles in the workbook for the generated html(such as the scenario that user
        needs to restore the workbook from the generated html later), please set this property as false.'''
        raise NotImplementedError()
    
    @property
    def export_document_properties(self) -> bool:
        '''Indicating whether exporting document properties.The default value is true.If you want to import
        the html or mht file to excel, please keep the default value.'''
        raise NotImplementedError()
    
    @export_document_properties.setter
    def export_document_properties(self, value : bool) -> None:
        '''Indicating whether exporting document properties.The default value is true.If you want to import
        the html or mht file to excel, please keep the default value.'''
        raise NotImplementedError()
    
    @property
    def export_worksheet_properties(self) -> bool:
        '''Indicating whether exporting worksheet properties.The default value is true.If you want to import
        the html or mht file to excel, please keep the default value.'''
        raise NotImplementedError()
    
    @export_worksheet_properties.setter
    def export_worksheet_properties(self, value : bool) -> None:
        '''Indicating whether exporting worksheet properties.The default value is true.If you want to import
        the html or mht file to excel, please keep the default value.'''
        raise NotImplementedError()
    
    @property
    def export_workbook_properties(self) -> bool:
        '''Indicating whether exporting workbook properties.The default value is true.If you want to import
        the html or mht file to excel, please keep the default value.'''
        raise NotImplementedError()
    
    @export_workbook_properties.setter
    def export_workbook_properties(self, value : bool) -> None:
        '''Indicating whether exporting workbook properties.The default value is true.If you want to import
        the html or mht file to excel, please keep the default value.'''
        raise NotImplementedError()
    
    @property
    def export_frame_scripts_and_properties(self) -> bool:
        '''Indicating whether exporting frame scripts and document properties. The default value is true.If you want to import the html or mht file
        to excel, please keep the default value.'''
        raise NotImplementedError()
    
    @export_frame_scripts_and_properties.setter
    def export_frame_scripts_and_properties(self, value : bool) -> None:
        '''Indicating whether exporting frame scripts and document properties. The default value is true.If you want to import the html or mht file
        to excel, please keep the default value.'''
        raise NotImplementedError()
    
    @property
    def export_data_options(self) -> aspose.cells.HtmlExportDataOptions:
        '''Indicating the rule of exporting html file data.The default value is All.'''
        raise NotImplementedError()
    
    @export_data_options.setter
    def export_data_options(self, value : aspose.cells.HtmlExportDataOptions) -> None:
        '''Indicating the rule of exporting html file data.The default value is All.'''
        raise NotImplementedError()
    
    @property
    def link_target_type(self) -> aspose.cells.HtmlLinkTargetType:
        '''Indicating the type of target attribute in ``<a>`` link. The default value is HtmlLinkTargetType.Parent.'''
        raise NotImplementedError()
    
    @link_target_type.setter
    def link_target_type(self, value : aspose.cells.HtmlLinkTargetType) -> None:
        '''Indicating the type of target attribute in ``<a>`` link. The default value is HtmlLinkTargetType.Parent.'''
        raise NotImplementedError()
    
    @property
    def is_ie_compatible(self) -> bool:
        '''Indicating whether the output HTML is compatible with IE browser.
        The defalut value is false'''
        raise NotImplementedError()
    
    @is_ie_compatible.setter
    def is_ie_compatible(self, value : bool) -> None:
        '''Indicating whether the output HTML is compatible with IE browser.
        The defalut value is false'''
        raise NotImplementedError()
    
    @property
    def format_data_ignore_column_width(self) -> bool:
        '''Indicating whether show the whole formatted data of cell when overflowing the column.
        If true then ignore the column width and the whole data of cell will be exported.
        If false then the data will be exported same as Excel.
        The default value is false.'''
        raise NotImplementedError()
    
    @format_data_ignore_column_width.setter
    def format_data_ignore_column_width(self, value : bool) -> None:
        '''Indicating whether show the whole formatted data of cell when overflowing the column.
        If true then ignore the column width and the whole data of cell will be exported.
        If false then the data will be exported same as Excel.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def calculate_formula(self) -> bool:
        '''Indicates whether to calculate formulas before saving html file.'''
        raise NotImplementedError()
    
    @calculate_formula.setter
    def calculate_formula(self, value : bool) -> None:
        '''Indicates whether to calculate formulas before saving html file.'''
        raise NotImplementedError()
    
    @property
    def is_js_browser_compatible(self) -> bool:
        '''Indicates whether JavaScript is compatible with browsers that do not support JavaScript.
        The default value is true.'''
        raise NotImplementedError()
    
    @is_js_browser_compatible.setter
    def is_js_browser_compatible(self, value : bool) -> None:
        '''Indicates whether JavaScript is compatible with browsers that do not support JavaScript.
        The default value is true.'''
        raise NotImplementedError()
    
    @property
    def is_mobile_compatible(self) -> bool:
        '''Indicates whether the output HTML is compatible with mobile devices.
        The default value is false.'''
        raise NotImplementedError()
    
    @is_mobile_compatible.setter
    def is_mobile_compatible(self, value : bool) -> None:
        '''Indicates whether the output HTML is compatible with mobile devices.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def css_styles(self) -> str:
        '''Gets the additional css styles for the formatter.
        Only works when :py:attr:`aspose.cells.HtmlSaveOptions.save_as_single_file` is True.'''
        raise NotImplementedError()
    
    @css_styles.setter
    def css_styles(self, value : str) -> None:
        '''Sets the additional css styles for the formatter.
        Only works when :py:attr:`aspose.cells.HtmlSaveOptions.save_as_single_file` is True.'''
        raise NotImplementedError()
    
    @property
    def hide_overflow_wrapped_text(self) -> bool:
        raise NotImplementedError()
    
    @hide_overflow_wrapped_text.setter
    def hide_overflow_wrapped_text(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def is_border_collapsed(self) -> bool:
        raise NotImplementedError()
    
    @is_border_collapsed.setter
    def is_border_collapsed(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def encode_entity_as_code(self) -> bool:
        raise NotImplementedError()
    
    @encode_entity_as_code.setter
    def encode_entity_as_code(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def office_math_output_mode(self) -> aspose.cells.HtmlOfficeMathOutputType:
        raise NotImplementedError()
    
    @office_math_output_mode.setter
    def office_math_output_mode(self, value : aspose.cells.HtmlOfficeMathOutputType) -> None:
        raise NotImplementedError()
    
    @property
    def cell_name_attribute(self) -> str:
        raise NotImplementedError()
    
    @cell_name_attribute.setter
    def cell_name_attribute(self, value : str) -> None:
        raise NotImplementedError()
    

class HtmlTableLoadOption:
    '''Represents the option when import table from html.'''
    
    @property
    def table_index(self) -> int:
        '''Get or set the index of table to import from html.'''
        raise NotImplementedError()
    
    @table_index.setter
    def table_index(self, value : int) -> None:
        '''Get or set the index of table to import from html.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> str:
        '''Get or set the id of table to import from html'''
        raise NotImplementedError()
    
    @id.setter
    def id(self, value : str) -> None:
        '''Get or set the id of table to import from html'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Get or set the name of table to import from html'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Get or set the name of table to import from html'''
        raise NotImplementedError()
    
    @property
    def original_sheet_index(self) -> int:
        '''Get or set the original index of worksheet in the html.'''
        raise NotImplementedError()
    
    @original_sheet_index.setter
    def original_sheet_index(self, value : int) -> None:
        '''Get or set the original index of worksheet in the html.'''
        raise NotImplementedError()
    
    @property
    def target_sheet_index(self) -> int:
        '''Get or set the target index of worksheet where the table is to be located.'''
        raise NotImplementedError()
    
    @target_sheet_index.setter
    def target_sheet_index(self, value : int) -> None:
        '''Get or set the target index of worksheet where the table is to be located.'''
        raise NotImplementedError()
    
    @property
    def table_to_list_object(self) -> bool:
        raise NotImplementedError()
    
    @table_to_list_object.setter
    def table_to_list_object(self, value : bool) -> None:
        raise NotImplementedError()
    

class HtmlTableLoadOptionCollection:
    '''Represents the table options when importing html.'''
    
    @overload
    def add(self, item : aspose.cells.HtmlTableLoadOption) -> int:
        '''Adds one HtmlTableLoadOption into this collection.
        
        :param item: one HtmlTableLoadOption
        :returns: the index of the added item'''
        raise NotImplementedError()
    
    @overload
    def add(self, table_index : int) -> int:
        '''Add a HtmlTableLoadOption to the list.
        
        :param table_index: Table index'''
        raise NotImplementedError()
    
    @overload
    def add(self, table_id : str) -> int:
        raise NotImplementedError()
    
    @overload
    def add(self, table_index : int, target_sheet_index : int) -> int:
        '''Add a HtmlTableLoadOption to the list.
        
        :param table_index: Table index
        :param target_sheet_index: Worksheet index'''
        raise NotImplementedError()
    
    @overload
    def add(self, table_id : str, target_sheet_index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def add(self, table_index : int, target_sheet_index : int, original_sheet_index : int) -> int:
        '''Add a HtmlTableLoadOption to the list.
        
        :param table_index: Table index
        :param target_sheet_index: The target index of worksheet where table to export to
        :param original_sheet_index: The original index of worksheet in the html'''
        raise NotImplementedError()
    
    @overload
    def add(self, table_id : str, target_sheet_index : int, original_sheet_index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.HtmlTableLoadOption]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.HtmlTableLoadOption], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.HtmlTableLoadOption, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.HtmlTableLoadOption, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.HtmlTableLoadOption) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.HtmlTableLoadOption, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.HtmlTableLoadOption, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.HtmlTableLoadOption) -> int:
        raise NotImplementedError()
    
    @property
    def table_to_list_object(self) -> bool:
        raise NotImplementedError()
    
    @table_to_list_object.setter
    def table_to_list_object(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class Hyperlink:
    '''Encapsulates the object that represents a hyperlink.'''
    
    def delete(self) -> None:
        '''Deletes this hyperlink'''
        raise NotImplementedError()
    
    @property
    def address(self) -> str:
        '''Represents the address of a hyperlink.'''
        raise NotImplementedError()
    
    @address.setter
    def address(self, value : str) -> None:
        '''Represents the address of a hyperlink.'''
        raise NotImplementedError()
    
    @property
    def text_to_display(self) -> str:
        '''Represents the text to be displayed for the specified hyperlink. The default value is the address of the hyperlink.'''
        raise NotImplementedError()
    
    @text_to_display.setter
    def text_to_display(self, value : str) -> None:
        '''Represents the text to be displayed for the specified hyperlink. The default value is the address of the hyperlink.'''
        raise NotImplementedError()
    
    @property
    def area(self) -> aspose.cells.CellArea:
        '''Gets the range of hyperlink.'''
        raise NotImplementedError()
    
    @property
    def screen_tip(self) -> str:
        '''Returns the ScreenTip text for the specified hyperlink.'''
        raise NotImplementedError()
    
    @screen_tip.setter
    def screen_tip(self, value : str) -> None:
        '''Returns or sets the ScreenTip text for the specified hyperlink.'''
        raise NotImplementedError()
    
    @property
    def link_type(self) -> aspose.cells.TargetModeType:
        '''Gets the link type.'''
        raise NotImplementedError()
    

class HyperlinkCollection:
    '''Encapsulates a collection of :py:class:`aspose.cells.Hyperlink` objects.'''
    
    @overload
    def add(self, first_row : int, first_column : int, total_rows : int, total_columns : int, address : str) -> int:
        '''Adds a hyperlink to a specified cell or a range of cells.
        
        :param first_row: First row of the hyperlink range.
        :param first_column: First column of the hyperlink range.
        :param total_rows: Number of rows in this hyperlink range.
        :param total_columns: Number of columns of this hyperlink range.
        :param address: Address of the hyperlink.
        :returns: :py:class:`aspose.cells.Hyperlink` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, cell_name : str, total_rows : int, total_columns : int, address : str) -> int:
        '''Adds a hyperlink to a specified cell or a range of cells.
        
        :param cell_name: Cell name.
        :param total_rows: Number of rows in this hyperlink range.
        :param total_columns: Number of columns of this hyperlink range.
        :param address: Address of the hyperlink.
        :returns: :py:class:`aspose.cells.Hyperlink` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, start_cell_name : str, end_cell_name : str, address : str, text_to_display : str, screen_tip : str) -> int:
        '''Adds a hyperlink to a specified cell or a range of cells.
        
        :param start_cell_name: The top-left cell of the range.
        :param end_cell_name: The bottom-right cell of the range.
        :param address: Address of the hyperlink.
        :param text_to_display: The text to be displayed for the specified hyperlink.
        :param screen_tip: The screenTip text for the specified hyperlink.
        :returns: :py:class:`aspose.cells.Hyperlink` object index.'''
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.Hyperlink]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.Hyperlink], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Hyperlink, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Hyperlink, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Hyperlink) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Hyperlink, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Hyperlink, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.Hyperlink) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class ICellsDataTable:
    '''Represents data table.'''
    
    def before_first(self) -> None:
        '''Move the cursor to the front of this object, just before the first row.'''
        raise NotImplementedError()
    
    def next(self) -> bool:
        '''Moves the cursor down one row from its current position.
        
        :returns: if the new current row is valid; false if there are no more rows'''
        raise NotImplementedError()
    
    @property
    def columns(self) -> List[str]:
        '''Gets the columns\' name.'''
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        '''Gets the count of the records. -1 for unknown records count.'''
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> Any:
        '''Gets the data stored in the column specified by index.'''
        raise NotImplementedError()
    

class ICustomParser:
    '''Allows users to add their custom value parser for parsing string values to other proper cell value object.'''
    
    def parse_object(self, value : str) -> Any:
        '''Parses given string to proper value object.
        
        :param value: The string value to be parsed
        :returns: Parsed value object from given string. If given string cannot be parsed to proper value object, returns null.'''
        raise NotImplementedError()
    
    def get_format(self) -> str:
        '''Gets the formatting pattern corresponding to the parsed value by last invocation of :py:func:`aspose.cells.ICustomParser.parse_object`.'''
        raise NotImplementedError()
    

class IExportObjectListener:
    '''Allows users to manipulate objects while exporting.'''
    
    def export_object(self, e : aspose.cells.ExportObjectEvent) -> Any:
        '''Export one object.
        
        :param e: The event triggered when one object needs to be exported.
        :returns: The information about the result of exporting object.
        
        *'''
        raise NotImplementedError()
    

class IFilePathProvider:
    '''Represents the exported file path provider.'''
    
    def get_full_name(self, sheet_name : str) -> str:
        '''Gets the full path of the file by Worksheet name when exporting Worksheet to html separately.
        So the references among the Worksheets can be exported correctly.
        
        :param sheet_name: Worksheet name
        :returns: the full path of the file'''
        raise NotImplementedError()
    

class ISmartMarkerCallBack:
    '''Represents callback interface of processing smartmarker.'''
    
    def process(self, sheet_index : int, row_index : int, col_index : int, table_name : str, column_name : str) -> None:
        '''Callback for processing a smart marker.
        
        :param sheet_index: The sheet index.
        :param row_index: The row index.
        :param col_index: The column index.
        :param table_name: The table name of smartmarker.
        :param column_name: The table name of smartmarker.'''
        raise NotImplementedError()
    

class IStreamProvider:
    '''Represents the exported stream provider.'''
    
    def init_stream(self, options : aspose.cells.StreamProviderOptions) -> None:
        '''Gets the stream.'''
        raise NotImplementedError()
    
    def close_stream(self, options : aspose.cells.StreamProviderOptions) -> None:
        '''Closes the stream.'''
        raise NotImplementedError()
    

class IWarningCallback:
    '''Callback interface of warning.'''
    
    def warning(self, warning_info : aspose.cells.WarningInfo) -> None:
        '''Our callback only needs to implement the "Warning" method.
        
        :param warning_info: warning info'''
        raise NotImplementedError()
    

class IconFilter:
    '''Represents icon filter.'''
    
    @property
    def icon_set_type(self) -> aspose.cells.IconSetType:
        '''Gets and sets which icon set is used in the filter criteria.'''
        raise NotImplementedError()
    
    @icon_set_type.setter
    def icon_set_type(self, value : aspose.cells.IconSetType) -> None:
        '''Gets and sets which icon set is used in the filter criteria.'''
        raise NotImplementedError()
    
    @property
    def icon_id(self) -> int:
        '''Gets and sets Zero-based index of an icon in an icon set.'''
        raise NotImplementedError()
    
    @icon_id.setter
    def icon_id(self, value : int) -> None:
        '''Gets and sets Zero-based index of an icon in an icon set.'''
        raise NotImplementedError()
    

class IconSet:
    '''Describe the IconSet conditional formatting rule.
    This conditional formatting rule applies icons to cells
    according to their values.'''
    
    @property
    def cf_icons(self) -> aspose.cells.ConditionalFormattingIconCollection:
        '''Get the:py:class:`aspose.cells.ConditionalFormattingIcon` from the collection'''
        raise NotImplementedError()
    
    @property
    def cfvos(self) -> aspose.cells.ConditionalFormattingValueCollection:
        '''Get the CFValueObjects instance.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.IconSetType:
        '''Get or Set the icon set type to display.
        Setting the type will auto check if the current Cfvos\'s count is
        accord with the new type. If not accord, old Cfvos will be cleaned and
        default Cfvos will be added.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.cells.IconSetType) -> None:
        '''Get or Set the icon set type to display.
        Setting the type will auto check if the current Cfvos\'s count is
        accord with the new type. If not accord, old Cfvos will be cleaned and
        default Cfvos will be added.'''
        raise NotImplementedError()
    
    @property
    def is_custom(self) -> bool:
        '''Indicates whether the icon set is custom.
        Default value is false.'''
        raise NotImplementedError()
    
    @property
    def show_value(self) -> bool:
        '''Get or set the flag indicating whether to show the values of the cells on which this icon set is applied.
        Default value is true.'''
        raise NotImplementedError()
    
    @show_value.setter
    def show_value(self, value : bool) -> None:
        '''Get or set the flag indicating whether to show the values of the cells on which this icon set is applied.
        Default value is true.'''
        raise NotImplementedError()
    
    @property
    def reverse(self) -> bool:
        '''Get or set the flag indicating whether to reverses the default order of the icons in this icon set.
        Default value is false.'''
        raise NotImplementedError()
    
    @reverse.setter
    def reverse(self, value : bool) -> None:
        '''Get or set the flag indicating whether to reverses the default order of the icons in this icon set.
        Default value is false.'''
        raise NotImplementedError()
    

class ImageSaveOptions(SaveOptions):
    '''Represents image save options.
    For advanced usage, please use :py:class:`aspose.cells.rendering.WorkbookRender` or :py:class:`aspose.cells.rendering.SheetRender`.'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def image_or_print_options(self) -> aspose.cells.rendering.ImageOrPrintOptions:
        '''Additional image creation options.'''
        raise NotImplementedError()
    
    @property
    def stream_provider(self) -> aspose.cells.IStreamProvider:
        '''Gets the IStreamProvider for exporting objects.'''
        raise NotImplementedError()
    
    @stream_provider.setter
    def stream_provider(self, value : aspose.cells.IStreamProvider) -> None:
        '''Sets the IStreamProvider for exporting objects.'''
        raise NotImplementedError()
    

class ImportTableOptions:
    '''Represents the options of importing data into cells.'''
    
    @property
    def convert_grid_style(self) -> bool:
        '''Indicates whether apply the style of the grid view to cells.'''
        raise NotImplementedError()
    
    @convert_grid_style.setter
    def convert_grid_style(self, value : bool) -> None:
        '''Indicates whether apply the style of the grid view to cells.'''
        raise NotImplementedError()
    
    @property
    def convert_numeric_data(self) -> bool:
        '''Gets a value that indicates whether the string value should be converted to numeric or date value.'''
        raise NotImplementedError()
    
    @convert_numeric_data.setter
    def convert_numeric_data(self, value : bool) -> None:
        '''Sets a value that indicates whether the string value should be converted to numeric or date value.'''
        raise NotImplementedError()
    
    @property
    def insert_rows(self) -> bool:
        '''Indicates whether new rows should be added for importing data records.'''
        raise NotImplementedError()
    
    @insert_rows.setter
    def insert_rows(self, value : bool) -> None:
        '''Indicates whether new rows should be added for importing data records.'''
        raise NotImplementedError()
    
    @property
    def shift_first_row_down(self) -> bool:
        '''Indicates whether shifting the first row down when inserting rows.'''
        raise NotImplementedError()
    
    @shift_first_row_down.setter
    def shift_first_row_down(self, value : bool) -> None:
        '''Indicates whether shifting the first row down when inserting rows.'''
        raise NotImplementedError()
    
    @property
    def is_field_name_shown(self) -> bool:
        '''Indicates whether field name should be imported.'''
        raise NotImplementedError()
    
    @is_field_name_shown.setter
    def is_field_name_shown(self, value : bool) -> None:
        '''Indicates whether field name should be imported.'''
        raise NotImplementedError()
    
    @property
    def export_caption_as_field_name(self) -> bool:
        '''Indicates whether exporting caption as field name'''
        raise NotImplementedError()
    
    @export_caption_as_field_name.setter
    def export_caption_as_field_name(self, value : bool) -> None:
        '''Indicates whether exporting caption as field name'''
        raise NotImplementedError()
    
    @property
    def date_format(self) -> str:
        '''Gets date format string for cells with imported datetime values.'''
        raise NotImplementedError()
    
    @date_format.setter
    def date_format(self, value : str) -> None:
        '''Sets date format string for cells with imported datetime values.'''
        raise NotImplementedError()
    
    @property
    def number_formats(self) -> List[str]:
        '''Gets the number formats'''
        raise NotImplementedError()
    
    @number_formats.setter
    def number_formats(self, value : List[str]) -> None:
        '''Sets the number formats'''
        raise NotImplementedError()
    
    @property
    def is_formulas(self) -> List[bool]:
        '''Indicates whether the data are formulas.'''
        raise NotImplementedError()
    
    @is_formulas.setter
    def is_formulas(self, value : List[bool]) -> None:
        '''Indicates whether the data are formulas.'''
        raise NotImplementedError()
    
    @property
    def total_rows(self) -> int:
        '''Gets total row count to import from data source. -1 means all rows of given data source.'''
        raise NotImplementedError()
    
    @total_rows.setter
    def total_rows(self, value : int) -> None:
        '''Sets total row count to import from data source. -1 means all rows of given data source.'''
        raise NotImplementedError()
    
    @property
    def total_columns(self) -> int:
        '''Gets total column count to import from data source. -1 means all rows of given data source.'''
        raise NotImplementedError()
    
    @total_columns.setter
    def total_columns(self, value : int) -> None:
        '''Sets total column count to import from data source. -1 means all rows of given data source.'''
        raise NotImplementedError()
    
    @property
    def column_indexes(self) -> List[int]:
        '''Gets the columns(0-based) to import from data source. null means all columns should be imported.'''
        raise NotImplementedError()
    
    @column_indexes.setter
    def column_indexes(self, value : List[int]) -> None:
        '''Sets the columns(0-based) to import from data source. null means all columns should be imported.'''
        raise NotImplementedError()
    
    @property
    def default_values(self) -> List[Any]:
        '''Default value for the value in the table is null.'''
        raise NotImplementedError()
    
    @default_values.setter
    def default_values(self, value : List[Any]) -> None:
        '''Default value for the value in the table is null.'''
        raise NotImplementedError()
    
    @property
    def is_html_string(self) -> bool:
        '''Indicates whether the value contains html tags.'''
        raise NotImplementedError()
    
    @is_html_string.setter
    def is_html_string(self, value : bool) -> None:
        '''Indicates whether the value contains html tags.'''
        raise NotImplementedError()
    
    @property
    def check_merged_cells(self) -> bool:
        '''Indicates whether checking merged cells.'''
        raise NotImplementedError()
    
    @check_merged_cells.setter
    def check_merged_cells(self, value : bool) -> None:
        '''Indicates whether checking merged cells.'''
        raise NotImplementedError()
    

class IndividualFontConfigs:
    '''Font configs for each :py:class:`aspose.cells.Workbook` object.'''
    
    def set_font_substitutes(self, original_font_name : str, substitute_font_names : List[str]) -> None:
        '''Font substitute names for given original font name.
        
        :param original_font_name: Original font name.
        :param substitute_font_names: List of font substitute names to be used if original font is not presented.'''
        raise NotImplementedError()
    
    def get_font_substitutes(self, original_font_name : str) -> List[str]:
        '''Returns array containing font substitute names to be used if original font is not presented.
        
        :param original_font_name: originalFontName
        :returns: An array containing font substitute names to be used if original font is not presented.'''
        raise NotImplementedError()
    
    def set_font_folder(self, font_folder : str, recursive : bool) -> None:
        '''Sets the fonts folder
        
        :param font_folder: The folder that contains TrueType fonts.
        :param recursive: Determines whether or not to scan subfolders.'''
        raise NotImplementedError()
    
    def set_font_folders(self, font_folders : List[str], recursive : bool) -> None:
        '''Sets the fonts folders
        
        :param font_folders: The folders that contains TrueType fonts.
        :param recursive: Determines whether or not to scan subfolders.'''
        raise NotImplementedError()
    
    def set_font_sources(self, sources : List[aspose.cells.FontSourceBase]) -> None:
        '''Sets the fonts sources.
        
        :param sources: An array of sources that contain TrueType fonts.'''
        raise NotImplementedError()
    
    def get_font_sources(self) -> List[aspose.cells.FontSourceBase]:
        '''Gets a copy of the array that contains the list of sources'''
        raise NotImplementedError()
    

class InsertOptions:
    '''Represents the options of inserting.'''
    
    @property
    def copy_format_type(self) -> aspose.cells.CopyFormatType:
        raise NotImplementedError()
    
    @copy_format_type.setter
    def copy_format_type(self, value : aspose.cells.CopyFormatType) -> None:
        raise NotImplementedError()
    
    @property
    def update_reference(self) -> bool:
        '''Indicates if references in other worksheets will be updated.'''
        raise NotImplementedError()
    
    @update_reference.setter
    def update_reference(self, value : bool) -> None:
        '''Indicates if references in other worksheets will be updated.'''
        raise NotImplementedError()
    

class InterruptMonitor(AbstractInterruptMonitor):
    '''Represents all operator about the interrupt.'''
    
    def interrupt(self) -> None:
        '''Interrupt the current operator.'''
        raise NotImplementedError()
    
    @property
    def is_interruption_requested(self) -> bool:
        '''Mark the monitor as requesting interruption'''
        raise NotImplementedError()
    
    @property
    def terminate_without_exception(self) -> bool:
        '''When procedure is interrupted, whether terminate the procedure quietly or throw an Exception.
        Default is false, that is, when :py:attr:`aspose.cells.AbstractInterruptMonitor.is_interruption_requested` is true,
        a :py:class:`aspose.cells.CellsException` with code :py:attr:`aspose.cells.ExceptionType.INTERRUPTED` will be thrown.'''
        raise NotImplementedError()
    

class JsonLoadOptions(LoadOptions):
    '''Represents the options of loading json files'''
    
    def set_paper_size(self, type : aspose.cells.PaperSizeType) -> None:
        '''Sets the default print paper size from default printer\'s setting.
        
        :param type: The default paper size.'''
        raise NotImplementedError()
    
    @property
    def load_format(self) -> aspose.cells.LoadFormat:
        '''Gets the load format.'''
        raise NotImplementedError()
    
    @property
    def password(self) -> str:
        '''Gets and set the password of the workbook.'''
        raise NotImplementedError()
    
    @password.setter
    def password(self, value : str) -> None:
        '''Gets and set the password of the workbook.'''
        raise NotImplementedError()
    
    @property
    def parsing_formula_on_open(self) -> bool:
        '''Indicates whether parsing the formula when reading the file.'''
        raise NotImplementedError()
    
    @parsing_formula_on_open.setter
    def parsing_formula_on_open(self, value : bool) -> None:
        '''Indicates whether parsing the formula when reading the file.'''
        raise NotImplementedError()
    
    @property
    def parsing_pivot_cached_records(self) -> bool:
        '''Indicates whether parsing pivot cached records when loading the file.
        The default value is false.'''
        raise NotImplementedError()
    
    @parsing_pivot_cached_records.setter
    def parsing_pivot_cached_records(self, value : bool) -> None:
        '''Indicates whether parsing pivot cached records when loading the file.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def language_code(self) -> aspose.cells.CountryCode:
        '''Gets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @language_code.setter
    def language_code(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @property
    def region(self) -> aspose.cells.CountryCode:
        '''Gets the system regional settings based on CountryCode at the time the file was loaded.'''
        raise NotImplementedError()
    
    @region.setter
    def region(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the system regional settings based on CountryCode at the time the file was loaded.'''
        raise NotImplementedError()
    
    @property
    def default_style_settings(self) -> aspose.cells.DefaultStyleSettings:
        '''Gets the default style settings for initializing styles of the workbook'''
        raise NotImplementedError()
    
    @property
    def standard_font(self) -> str:
        '''Sets the default standard font name'''
        raise NotImplementedError()
    
    @standard_font.setter
    def standard_font(self, value : str) -> None:
        '''Sets the default standard font name'''
        raise NotImplementedError()
    
    @property
    def standard_font_size(self) -> float:
        '''Sets the default standard font size.'''
        raise NotImplementedError()
    
    @standard_font_size.setter
    def standard_font_size(self, value : float) -> None:
        '''Sets the default standard font size.'''
        raise NotImplementedError()
    
    @property
    def interrupt_monitor(self) -> aspose.cells.AbstractInterruptMonitor:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.cells.AbstractInterruptMonitor) -> None:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @property
    def ignore_not_printed(self) -> bool:
        '''Ignore the data which are not printed if directly printing the file'''
        raise NotImplementedError()
    
    @ignore_not_printed.setter
    def ignore_not_printed(self, value : bool) -> None:
        '''Ignore the data which are not printed if directly printing the file'''
        raise NotImplementedError()
    
    @property
    def check_data_valid(self) -> bool:
        '''Check whether data is valid in the template file.'''
        raise NotImplementedError()
    
    @check_data_valid.setter
    def check_data_valid(self, value : bool) -> None:
        '''Check whether data is valid in the template file.'''
        raise NotImplementedError()
    
    @property
    def check_excel_restriction(self) -> bool:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @check_excel_restriction.setter
    def check_excel_restriction(self, value : bool) -> None:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @property
    def keep_unparsed_data(self) -> bool:
        '''Whether keep the unparsed data in memory for the Workbook when it is loaded from template file. Default is true.'''
        raise NotImplementedError()
    
    @keep_unparsed_data.setter
    def keep_unparsed_data(self, value : bool) -> None:
        '''Whether keep the unparsed data in memory for the Workbook when it is loaded from template file. Default is true.'''
        raise NotImplementedError()
    
    @property
    def load_filter(self) -> aspose.cells.LoadFilter:
        '''The filter to denote how to load data.'''
        raise NotImplementedError()
    
    @load_filter.setter
    def load_filter(self, value : aspose.cells.LoadFilter) -> None:
        '''The filter to denote how to load data.'''
        raise NotImplementedError()
    
    @property
    def light_cells_data_handler(self) -> aspose.cells.LightCellsDataHandler:
        '''The data handler for processing cells data when reading template file.'''
        raise NotImplementedError()
    
    @light_cells_data_handler.setter
    def light_cells_data_handler(self, value : aspose.cells.LightCellsDataHandler) -> None:
        '''The data handler for processing cells data when reading template file.'''
        raise NotImplementedError()
    
    @property
    def memory_setting(self) -> aspose.cells.MemorySetting:
        '''Gets the memory usage options.'''
        raise NotImplementedError()
    
    @memory_setting.setter
    def memory_setting(self, value : aspose.cells.MemorySetting) -> None:
        '''Sets the memory usage options.'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def auto_fitter_options(self) -> aspose.cells.AutoFitterOptions:
        '''Gets and sets the auto fitter options'''
        raise NotImplementedError()
    
    @auto_fitter_options.setter
    def auto_fitter_options(self, value : aspose.cells.AutoFitterOptions) -> None:
        '''Gets and sets the auto fitter options'''
        raise NotImplementedError()
    
    @property
    def auto_filter(self) -> bool:
        '''Indicates whether auto filtering the data when loading the files.'''
        raise NotImplementedError()
    
    @auto_filter.setter
    def auto_filter(self, value : bool) -> None:
        '''Indicates whether auto filtering the data when loading the files.'''
        raise NotImplementedError()
    
    @property
    def font_configs(self) -> aspose.cells.IndividualFontConfigs:
        '''Gets and sets individual font configs.
        Only works for the :py:class:`aspose.cells.Workbook` which uses this :py:class:`aspose.cells.LoadOptions` to load.'''
        raise NotImplementedError()
    
    @font_configs.setter
    def font_configs(self, value : aspose.cells.IndividualFontConfigs) -> None:
        '''Gets and sets individual font configs.
        Only works for the :py:class:`aspose.cells.Workbook` which uses this :py:class:`aspose.cells.LoadOptions` to load.'''
        raise NotImplementedError()
    
    @property
    def ignore_useless_shapes(self) -> bool:
        '''Indicates whether ignoring useless shapes.'''
        raise NotImplementedError()
    
    @ignore_useless_shapes.setter
    def ignore_useless_shapes(self, value : bool) -> None:
        '''Indicates whether ignoring useless shapes.'''
        raise NotImplementedError()
    
    @property
    def preserve_padding_spaces_in_formula(self) -> bool:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    
    @preserve_padding_spaces_in_formula.setter
    def preserve_padding_spaces_in_formula(self, value : bool) -> None:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    
    @property
    def start_cell(self) -> str:
        '''Gets and sets the start cell.'''
        raise NotImplementedError()
    
    @start_cell.setter
    def start_cell(self, value : str) -> None:
        '''Gets and sets the start cell.'''
        raise NotImplementedError()
    
    @property
    def layout_options(self) -> aspose.cells.utility.JsonLayoutOptions:
        '''The options of import json.'''
        raise NotImplementedError()
    
    @layout_options.setter
    def layout_options(self, value : aspose.cells.utility.JsonLayoutOptions) -> None:
        '''The options of import json.'''
        raise NotImplementedError()
    
    @property
    def multiple_worksheets(self) -> bool:
        '''Indicates whether importing each attribute of JsonObject object as one worksheet when all child nodes are array nodes.'''
        raise NotImplementedError()
    
    @multiple_worksheets.setter
    def multiple_worksheets(self, value : bool) -> None:
        '''Indicates whether importing each attribute of JsonObject object as one worksheet when all child nodes are array nodes.'''
        raise NotImplementedError()
    
    @property
    def kept_schema(self) -> bool:
        raise NotImplementedError()
    
    @kept_schema.setter
    def kept_schema(self, value : bool) -> None:
        raise NotImplementedError()
    

class JsonSaveOptions(SaveOptions):
    '''Represents the options of saving the workbook as a json file.'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def export_hyperlink_type(self) -> aspose.cells.json.JsonExportHyperlinkType:
        '''Represents the type of exporting hyperlink to json.'''
        raise NotImplementedError()
    
    @export_hyperlink_type.setter
    def export_hyperlink_type(self, value : aspose.cells.json.JsonExportHyperlinkType) -> None:
        '''Represents the type of exporting hyperlink to json.'''
        raise NotImplementedError()
    
    @property
    def skip_empty_rows(self) -> bool:
        '''Indicates whether skipping emtpy rows.'''
        raise NotImplementedError()
    
    @skip_empty_rows.setter
    def skip_empty_rows(self, value : bool) -> None:
        '''Indicates whether skipping emtpy rows.'''
        raise NotImplementedError()
    
    @property
    def sheet_indexes(self) -> List[int]:
        '''Represents the indexes of exported sheets.'''
        raise NotImplementedError()
    
    @sheet_indexes.setter
    def sheet_indexes(self, value : List[int]) -> None:
        '''Represents the indexes of exported sheets.'''
        raise NotImplementedError()
    
    @property
    def schemas(self) -> List[str]:
        raise NotImplementedError()
    
    @schemas.setter
    def schemas(self, value : List[str]) -> None:
        raise NotImplementedError()
    
    @property
    def export_area(self) -> aspose.cells.CellArea:
        '''Gets the exporting range.'''
        raise NotImplementedError()
    
    @export_area.setter
    def export_area(self, value : aspose.cells.CellArea) -> None:
        '''Sets the exporting range.'''
        raise NotImplementedError()
    
    @property
    def has_header_row(self) -> bool:
        '''Indicates whether the range contains header row.'''
        raise NotImplementedError()
    
    @has_header_row.setter
    def has_header_row(self, value : bool) -> None:
        '''Indicates whether the range contains header row.'''
        raise NotImplementedError()
    
    @property
    def export_as_string(self) -> bool:
        '''Exports the string value of the cells to json.'''
        raise NotImplementedError()
    
    @export_as_string.setter
    def export_as_string(self, value : bool) -> None:
        '''Exports the string value of the cells to json.'''
        raise NotImplementedError()
    
    @property
    def indent(self) -> str:
        '''Indicates the indent.'''
        raise NotImplementedError()
    
    @indent.setter
    def indent(self, value : str) -> None:
        '''Indicates the indent.'''
        raise NotImplementedError()
    
    @property
    def export_nested_structure(self) -> bool:
        '''Exported as parent-child hierarchy Json structure.'''
        raise NotImplementedError()
    
    @export_nested_structure.setter
    def export_nested_structure(self, value : bool) -> None:
        '''Exported as parent-child hierarchy Json structure.'''
        raise NotImplementedError()
    
    @property
    def export_empty_cells(self) -> bool:
        '''Indicates whether exporting empty cells as null.'''
        raise NotImplementedError()
    
    @export_empty_cells.setter
    def export_empty_cells(self, value : bool) -> None:
        '''Indicates whether exporting empty cells as null.'''
        raise NotImplementedError()
    
    @property
    def always_export_as_json_object(self) -> bool:
        '''Indicates whether always exporting excel to json as object, even there is only a worksheet in the file.'''
        raise NotImplementedError()
    
    @always_export_as_json_object.setter
    def always_export_as_json_object(self, value : bool) -> None:
        '''Indicates whether always exporting excel to json as object, even there is only a worksheet in the file.'''
        raise NotImplementedError()
    
    @property
    def to_excel_struct(self) -> bool:
        raise NotImplementedError()
    
    @to_excel_struct.setter
    def to_excel_struct(self, value : bool) -> None:
        raise NotImplementedError()
    

class License:
    '''Provides methods to license the component.'''
    
    @overload
    def set_license(self, license_name : str) -> None:
        '''Licenses the component.'''
        raise NotImplementedError()
    
    @overload
    def set_license(self, stream : io.RawIOBase) -> None:
        '''Licenses the component.
        
        :param stream: A stream that contains the license.'''
        raise NotImplementedError()
    

class LightCellsDataHandler:
    '''Represents cells data handler for reading large spreadsheet files in light weight mode.'''
    
    def start_sheet(self, sheet : aspose.cells.Worksheet) -> bool:
        '''Starts to process a worksheet.
        
        :param sheet: the worksheet to read cells data.
        :returns: whether this sheet\'s cells data needs to be processed. false to ignore this sheet.'''
        raise NotImplementedError()
    
    def start_row(self, row_index : int) -> bool:
        '''Prepares to process a row.
        
        :param row_index: the index of next row to be processed
        :returns: whether this row(properties or cells data) needs to be processed. false to ignore this row and its cells and check the next row.'''
        raise NotImplementedError()
    
    def process_row(self, row : aspose.cells.Row) -> bool:
        '''Starts to process one row.
        
        :param row: Row object which is being processed currently.
        :returns: whether this row\'s cells need to be processed. false to ignore all cells in this row.'''
        raise NotImplementedError()
    
    def start_cell(self, column_index : int) -> bool:
        '''Prepares to process a cell.
        
        :param column_index: column index of the cell to be processed
        :returns: whether this cell needs to be processed. false to ignore the cell and check the next one until reach the end of cells data of current row'''
        raise NotImplementedError()
    
    def process_cell(self, cell : aspose.cells.Cell) -> bool:
        '''Starts to process one cell.
        
        :param cell: Cell object which is being processed currently
        :returns: whether this cell needs to be kept in cells model of current sheet.
        Commonly it should be false so that all cells will not be kept in memory after being processed and then memory be saved.
        For some special purpose such as user needs to access some cells later after the whole workbook having been processed,
        user can make this method return true to keep those special cells in Cells model and access them later by APIs such as Cells[row, column].
        However, keeping cells data in Cells model will requires more memory and if all cells are kept then reading template file
        in LightCells mode will become same with reading it in normal way.'''
        raise NotImplementedError()
    

class LightCellsDataProvider:
    '''Represents Data provider for saving large spreadsheet files in light weight mode.'''
    
    def start_sheet(self, sheet_index : int) -> bool:
        '''Starts to save a worksheet.
        
        :param sheet_index: index of current sheet to be saved.
        :returns: true if this provider will provide data for the given sheet; false if given sheet should use its normal data model(Cells).'''
        raise NotImplementedError()
    
    def next_row(self) -> int:
        '''Gets the next row to be saved.
        
        :returns: the next row index to be saved. -1 means the end of current sheet data has been reached and no further row of current sheet to be saved.'''
        raise NotImplementedError()
    
    def start_row(self, row : aspose.cells.Row) -> None:
        '''Starts to save data of one row.
        
        :param row: Row object for implementation to fill data. Its row index is the returned value of latest call of :py:func:`aspose.cells.LightCellsDataProvider.next_row`.
        If the row has been initialized in the inner cells model, the existing row object will be used.
        Otherwise a temporary Row object will be used for implementation to fill data.'''
        raise NotImplementedError()
    
    def next_cell(self) -> int:
        '''Gets next cell to be saved.
        
        :returns: column index of the next cell to be saved. -1 means the end of current row data has been reached and no further cell of current row to be saved.'''
        raise NotImplementedError()
    
    def start_cell(self, cell : aspose.cells.Cell) -> None:
        '''Starts to save data of one cell.
        
        :param cell: Cell object for implementation to fill data. Its column index is the returned value of latest call of :py:func:`aspose.cells.LightCellsDataProvider.next_cell`.
        If the cell has been initialized in the inner cells model, the existed cell object will be used.
        Otherwise a temporary Cell object will be used for implementation to fill data.'''
        raise NotImplementedError()
    
    def is_gather_string(self) -> bool:
        '''Checks whether the current string value of cell needs to be gathered into a global pool.
        
        :returns: true if string value need to be gathered into a global pool for the resultant file.'''
        raise NotImplementedError()
    

class LoadFilter:
    '''Represents the filter that provides options for loading data when loading workbook from template.'''
    
    def start_sheet(self, sheet : aspose.cells.Worksheet) -> None:
        '''Prepares filter options before loading given worksheet.
        User\'s implementation of LoadFilter can change the LoadDataFilterOptions here
        to denote how to load data for this worksheet.
        
        :param sheet: The worksheet to be loaded.
        There are only few properties can be used for the given worksheet object here
        because most data and properties have not been loaded. The available properties are:
        Name, Index, VisibilityType'''
        raise NotImplementedError()
    
    @property
    def load_data_filter_options(self) -> aspose.cells.LoadDataFilterOptions:
        '''The filter options to denote what data should be loaded.'''
        raise NotImplementedError()
    
    @load_data_filter_options.setter
    def load_data_filter_options(self, value : aspose.cells.LoadDataFilterOptions) -> None:
        '''The filter options to denote what data should be loaded.'''
        raise NotImplementedError()
    
    @property
    def sheets_in_loading_order(self) -> List[int]:
        '''Specifies the sheets(indices) and order to be loaded.
        Default is null, that denotes to load all sheets in the default order in template file.
        If not null and some sheet\'s index is not in the returned array, then the sheet will not be loaded.'''
        raise NotImplementedError()
    

class LoadOptions:
    '''Represents the options of loading the file.'''
    
    def set_paper_size(self, type : aspose.cells.PaperSizeType) -> None:
        '''Sets the default print paper size from default printer\'s setting.
        
        :param type: The default paper size.'''
        raise NotImplementedError()
    
    @property
    def load_format(self) -> aspose.cells.LoadFormat:
        '''Gets the load format.'''
        raise NotImplementedError()
    
    @property
    def password(self) -> str:
        '''Gets and set the password of the workbook.'''
        raise NotImplementedError()
    
    @password.setter
    def password(self, value : str) -> None:
        '''Gets and set the password of the workbook.'''
        raise NotImplementedError()
    
    @property
    def parsing_formula_on_open(self) -> bool:
        '''Indicates whether parsing the formula when reading the file.'''
        raise NotImplementedError()
    
    @parsing_formula_on_open.setter
    def parsing_formula_on_open(self, value : bool) -> None:
        '''Indicates whether parsing the formula when reading the file.'''
        raise NotImplementedError()
    
    @property
    def parsing_pivot_cached_records(self) -> bool:
        '''Indicates whether parsing pivot cached records when loading the file.
        The default value is false.'''
        raise NotImplementedError()
    
    @parsing_pivot_cached_records.setter
    def parsing_pivot_cached_records(self, value : bool) -> None:
        '''Indicates whether parsing pivot cached records when loading the file.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def language_code(self) -> aspose.cells.CountryCode:
        '''Gets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @language_code.setter
    def language_code(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @property
    def region(self) -> aspose.cells.CountryCode:
        '''Gets the system regional settings based on CountryCode at the time the file was loaded.'''
        raise NotImplementedError()
    
    @region.setter
    def region(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the system regional settings based on CountryCode at the time the file was loaded.'''
        raise NotImplementedError()
    
    @property
    def default_style_settings(self) -> aspose.cells.DefaultStyleSettings:
        '''Gets the default style settings for initializing styles of the workbook'''
        raise NotImplementedError()
    
    @property
    def standard_font(self) -> str:
        '''Sets the default standard font name'''
        raise NotImplementedError()
    
    @standard_font.setter
    def standard_font(self, value : str) -> None:
        '''Sets the default standard font name'''
        raise NotImplementedError()
    
    @property
    def standard_font_size(self) -> float:
        '''Sets the default standard font size.'''
        raise NotImplementedError()
    
    @standard_font_size.setter
    def standard_font_size(self, value : float) -> None:
        '''Sets the default standard font size.'''
        raise NotImplementedError()
    
    @property
    def interrupt_monitor(self) -> aspose.cells.AbstractInterruptMonitor:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.cells.AbstractInterruptMonitor) -> None:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @property
    def ignore_not_printed(self) -> bool:
        '''Ignore the data which are not printed if directly printing the file'''
        raise NotImplementedError()
    
    @ignore_not_printed.setter
    def ignore_not_printed(self, value : bool) -> None:
        '''Ignore the data which are not printed if directly printing the file'''
        raise NotImplementedError()
    
    @property
    def check_data_valid(self) -> bool:
        '''Check whether data is valid in the template file.'''
        raise NotImplementedError()
    
    @check_data_valid.setter
    def check_data_valid(self, value : bool) -> None:
        '''Check whether data is valid in the template file.'''
        raise NotImplementedError()
    
    @property
    def check_excel_restriction(self) -> bool:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @check_excel_restriction.setter
    def check_excel_restriction(self, value : bool) -> None:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @property
    def keep_unparsed_data(self) -> bool:
        '''Whether keep the unparsed data in memory for the Workbook when it is loaded from template file. Default is true.'''
        raise NotImplementedError()
    
    @keep_unparsed_data.setter
    def keep_unparsed_data(self, value : bool) -> None:
        '''Whether keep the unparsed data in memory for the Workbook when it is loaded from template file. Default is true.'''
        raise NotImplementedError()
    
    @property
    def load_filter(self) -> aspose.cells.LoadFilter:
        '''The filter to denote how to load data.'''
        raise NotImplementedError()
    
    @load_filter.setter
    def load_filter(self, value : aspose.cells.LoadFilter) -> None:
        '''The filter to denote how to load data.'''
        raise NotImplementedError()
    
    @property
    def light_cells_data_handler(self) -> aspose.cells.LightCellsDataHandler:
        '''The data handler for processing cells data when reading template file.'''
        raise NotImplementedError()
    
    @light_cells_data_handler.setter
    def light_cells_data_handler(self, value : aspose.cells.LightCellsDataHandler) -> None:
        '''The data handler for processing cells data when reading template file.'''
        raise NotImplementedError()
    
    @property
    def memory_setting(self) -> aspose.cells.MemorySetting:
        '''Gets the memory usage options.'''
        raise NotImplementedError()
    
    @memory_setting.setter
    def memory_setting(self, value : aspose.cells.MemorySetting) -> None:
        '''Sets the memory usage options.'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def auto_fitter_options(self) -> aspose.cells.AutoFitterOptions:
        '''Gets and sets the auto fitter options'''
        raise NotImplementedError()
    
    @auto_fitter_options.setter
    def auto_fitter_options(self, value : aspose.cells.AutoFitterOptions) -> None:
        '''Gets and sets the auto fitter options'''
        raise NotImplementedError()
    
    @property
    def auto_filter(self) -> bool:
        '''Indicates whether auto filtering the data when loading the files.'''
        raise NotImplementedError()
    
    @auto_filter.setter
    def auto_filter(self, value : bool) -> None:
        '''Indicates whether auto filtering the data when loading the files.'''
        raise NotImplementedError()
    
    @property
    def font_configs(self) -> aspose.cells.IndividualFontConfigs:
        '''Gets and sets individual font configs.
        Only works for the :py:class:`aspose.cells.Workbook` which uses this :py:class:`aspose.cells.LoadOptions` to load.'''
        raise NotImplementedError()
    
    @font_configs.setter
    def font_configs(self, value : aspose.cells.IndividualFontConfigs) -> None:
        '''Gets and sets individual font configs.
        Only works for the :py:class:`aspose.cells.Workbook` which uses this :py:class:`aspose.cells.LoadOptions` to load.'''
        raise NotImplementedError()
    
    @property
    def ignore_useless_shapes(self) -> bool:
        '''Indicates whether ignoring useless shapes.'''
        raise NotImplementedError()
    
    @ignore_useless_shapes.setter
    def ignore_useless_shapes(self, value : bool) -> None:
        '''Indicates whether ignoring useless shapes.'''
        raise NotImplementedError()
    
    @property
    def preserve_padding_spaces_in_formula(self) -> bool:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    
    @preserve_padding_spaces_in_formula.setter
    def preserve_padding_spaces_in_formula(self, value : bool) -> None:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    

class MarkdownSaveOptions(SaveOptions):
    '''Represents the save options for markdown.'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def encoding(self) -> str:
        '''Gets and sets the default encoding.'''
        raise NotImplementedError()
    
    @encoding.setter
    def encoding(self, value : str) -> None:
        '''Gets and sets the default encoding.'''
        raise NotImplementedError()
    
    @property
    def format_strategy(self) -> aspose.cells.CellValueFormatStrategy:
        '''Gets and sets the format strategy when exporting the cell value as string.'''
        raise NotImplementedError()
    
    @format_strategy.setter
    def format_strategy(self, value : aspose.cells.CellValueFormatStrategy) -> None:
        '''Gets and sets the format strategy when exporting the cell value as string.'''
        raise NotImplementedError()
    
    @property
    def light_cells_data_provider(self) -> aspose.cells.LightCellsDataProvider:
        '''The Data provider to provide cells data for saving workbook in light mode.'''
        raise NotImplementedError()
    
    @light_cells_data_provider.setter
    def light_cells_data_provider(self, value : aspose.cells.LightCellsDataProvider) -> None:
        '''The Data provider to provide cells data for saving workbook in light mode.'''
        raise NotImplementedError()
    
    @property
    def line_separator(self) -> str:
        '''Gets and sets the line separator.'''
        raise NotImplementedError()
    
    @line_separator.setter
    def line_separator(self, value : str) -> None:
        '''Gets and sets the line separator.'''
        raise NotImplementedError()
    

class MemoryFontSource(FontSourceBase):
    '''Represents the single TrueType font file stored in memory.'''
    
    @property
    def type(self) -> aspose.cells.FontSourceType:
        '''Returns the type of the font source.'''
        raise NotImplementedError()
    
    @property
    def font_data(self) -> List[int]:
        '''Binary font data.'''
        raise NotImplementedError()
    

class Metered:
    '''Provides methods to set metered key.'''
    
    def set_metered_key(self, public_key : str, private_key : str) -> None:
        '''Sets metered public and private key.
        If you purchase metered license, when start application, this API should be called, normally, this is enough.
        However, if always fail to upload consumption data and exceed 24 hours, the license will be set to evaluation status,
        to avoid such case, you should regularly check the license status, if it is evaluation status, call this API again.
        
        :param public_key: public key
        :param private_key: private key'''
        raise NotImplementedError()
    
    @staticmethod
    def get_consumption_quantity() -> float:
        '''Gets consumption file size
        
        :returns: consumption quantity'''
        raise NotImplementedError()
    
    @staticmethod
    def get_consumption_credit() -> float:
        '''Gets consumption credit
        
        :returns: consumption quantity'''
        raise NotImplementedError()
    
    def get_product_name(self) -> str:
        '''Gets product name
        
        :returns: product name'''
        raise NotImplementedError()
    
    @staticmethod
    def is_metered_licensed() -> bool:
        '''Check whether metered is licensed
        
        :returns: True or false'''
        raise NotImplementedError()
    

class MultipleFilterCollection:
    '''Represents the multiple filter collection.'''
    
    def add(self, filter : str) -> None:
        '''Adds string filter.
        
        :param filter: The filter data.'''
        raise NotImplementedError()
    
    @property
    def match_blank(self) -> bool:
        '''Indicates whether to filter by blank.'''
        raise NotImplementedError()
    
    @match_blank.setter
    def match_blank(self, value : bool) -> None:
        '''Indicates whether to filter by blank.'''
        raise NotImplementedError()
    

class Name:
    '''Represents a defined name for a range of cells.'''
    
    @overload
    def get_refers_to(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Get the reference of this Name.
        
        :param is_r1c1: Whether the reference needs to be formatted as R1C1.
        :param is_local: Whether the reference needs to be formatted by locale.'''
        raise NotImplementedError()
    
    @overload
    def get_refers_to(self, is_r1c1 : bool, is_local : bool, row : int, column : int) -> str:
        '''Get the reference of this Name based on specified cell.
        
        :param is_r1c1: Whether the reference needs to be formatted as R1C1.
        :param is_local: Whether the reference needs to be formatted by locale.
        :param row: The row index of the cell.
        :param column: The column index of the cell.'''
        raise NotImplementedError()
    
    @overload
    def get_ranges(self) -> List[aspose.cells.Range]:
        '''Gets all ranges referred by this name.
        
        :returns: All ranges.'''
        raise NotImplementedError()
    
    @overload
    def get_ranges(self, recalculate : bool) -> List[aspose.cells.Range]:
        '''Gets all ranges referred by this name.
        
        :param recalculate: whether recalculate it if this name has been calculated before this invocation.
        :returns: All ranges.'''
        raise NotImplementedError()
    
    @overload
    def get_range(self) -> aspose.cells.Range:
        '''Gets the range if this name refers to a range.
        
        :returns: The range.'''
        raise NotImplementedError()
    
    @overload
    def get_range(self, recalculate : bool) -> aspose.cells.Range:
        '''Gets the range if this name refers to a range
        
        :param recalculate: whether recalculate it if this name has been calculated before this invocation.
        :returns: The range.'''
        raise NotImplementedError()
    
    @overload
    def get_range(self, sheet_index : int, row : int, column : int) -> aspose.cells.Range:
        '''Gets the range if this name refers to a range.
        If the reference of this name is not absolute, the range may be different for different cell.
        
        :param sheet_index: The according sheet index.
        :param row: The according row index.
        :param column: The according column index
        :returns: The range.'''
        raise NotImplementedError()
    
    def set_refers_to(self, refers_to : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Set the reference of this Name.
        
        :param refers_to: The reference.
        :param is_r1c1: Whether the reference is R1C1 format.
        :param is_local: Whether the reference is locale formatted.'''
        raise NotImplementedError()
    
    def get_referred_areas(self, recalculate : bool) -> List[aspose.cells.ReferredArea]:
        '''Gets all references referred by this name.
        
        :param recalculate: whether recalculate it if this name has been calculated before this invocation.
        :returns: All ranges.'''
        raise NotImplementedError()
    
    @property
    def comment(self) -> str:
        '''Gets and sets the comment of the name.
        Only applies for Excel 2007 or higher versions.'''
        raise NotImplementedError()
    
    @comment.setter
    def comment(self, value : str) -> None:
        '''Gets and sets the comment of the name.
        Only applies for Excel 2007 or higher versions.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets the name text of the object.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets the name text of the object.'''
        raise NotImplementedError()
    
    @property
    def full_text(self) -> str:
        '''Gets the name  full text of the object with the scope setting.'''
        raise NotImplementedError()
    
    @property
    def refers_to(self) -> str:
        '''Returns the formula that the name is defined to refer to, beginning with an equal sign.'''
        raise NotImplementedError()
    
    @refers_to.setter
    def refers_to(self, value : str) -> None:
        '''Returns or sets the formula that the name is defined to refer to, beginning with an equal sign.'''
        raise NotImplementedError()
    
    @property
    def r1c1_refers_to(self) -> str:
        '''Gets a R1C1 reference of the :py:class:`aspose.cells.Name`.'''
        raise NotImplementedError()
    
    @r1c1_refers_to.setter
    def r1c1_refers_to(self, value : str) -> None:
        '''Sets a R1C1 reference of the :py:class:`aspose.cells.Name`.'''
        raise NotImplementedError()
    
    @property
    def is_referred(self) -> bool:
        '''Indicates whether this name is referred by other formulas.'''
        raise NotImplementedError()
    
    @property
    def is_visible(self) -> bool:
        '''Indicates whether the name is visible.'''
        raise NotImplementedError()
    
    @is_visible.setter
    def is_visible(self, value : bool) -> None:
        '''Indicates whether the name is visible.'''
        raise NotImplementedError()
    
    @property
    def sheet_index(self) -> int:
        '''Indicates this name belongs to Workbook or Worksheet.
        0 = Global name, otherwise index to sheet (one-based)'''
        raise NotImplementedError()
    
    @sheet_index.setter
    def sheet_index(self, value : int) -> None:
        '''Indicates this name belongs to Workbook or Worksheet.
        0 = Global name, otherwise index to sheet (one-based)'''
        raise NotImplementedError()
    

class NameCollection:
    '''Represents a collection of all the :py:class:`aspose.cells.Name` objects in the spreadsheet.'''
    
    @overload
    def get(self, index : int) -> aspose.cells.Name:
        '''Add API for Python Via .Net.since this[int index] is unsupported
        
        :param index: The zero based index of the element.'''
        raise NotImplementedError()
    
    @overload
    def get(self, text : str) -> aspose.cells.Name:
        '''Add API for Python Via .Net.since this[string text] is unsupported
        
        :param text: Name text.'''
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.Name]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.Name], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Name, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Name, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Name) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Name, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Name, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def add(self, text : str) -> int:
        '''Defines a new name.
        
        :param text: The text to use as the name.
        :returns: :py:class:`aspose.cells.Name` object index.'''
        raise NotImplementedError()
    
    def filter(self, type : aspose.cells.NameScopeType, sheet_index : int) -> List[aspose.cells.Name]:
        '''Gets all defined name by scope.
        
        :param type: The scope type.
        :param sheet_index: The sheet index.
        Only effects when scope type is :py:attr:`aspose.cells.NameScopeType.WORKSHEET`'''
        raise NotImplementedError()
    
    def remove_a_name(self, text : str) -> None:
        raise NotImplementedError()
    
    def remove_names_by_array(self, names : List[str]) -> None:
        raise NotImplementedError()
    
    def remove_duplicate_names(self) -> None:
        '''Remove the duplicate defined names'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.Name) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class NegativeBarFormat:
    '''Represents the color settings of the data bars for negative values that are defined by a data bar conditional formatting rule.'''
    
    @property
    def border_color(self) -> aspose.pydrawing.Color:
        '''Gets a FormatColor object that you can use to specify the border color for negative data bars.'''
        raise NotImplementedError()
    
    @border_color.setter
    def border_color(self, value : aspose.pydrawing.Color) -> None:
        '''Sets a FormatColor object that you can use to specify the border color for negative data bars.'''
        raise NotImplementedError()
    
    @property
    def border_color_type(self) -> aspose.cells.DataBarNegativeColorType:
        '''Gets whether to use the same border color as positive data bars.'''
        raise NotImplementedError()
    
    @border_color_type.setter
    def border_color_type(self, value : aspose.cells.DataBarNegativeColorType) -> None:
        '''Gets whether to use the same border color as positive data bars.'''
        raise NotImplementedError()
    
    @property
    def color(self) -> aspose.pydrawing.Color:
        '''Gets a FormatColor object that you can use to specify the fill color for negative data bars.'''
        raise NotImplementedError()
    
    @color.setter
    def color(self, value : aspose.pydrawing.Color) -> None:
        '''Sets a FormatColor object that you can use to specify the fill color for negative data bars.'''
        raise NotImplementedError()
    
    @property
    def color_type(self) -> aspose.cells.DataBarNegativeColorType:
        '''Gets whether to use the same fill color as positive data bars.'''
        raise NotImplementedError()
    
    @color_type.setter
    def color_type(self, value : aspose.cells.DataBarNegativeColorType) -> None:
        '''Sets whether to use the same fill color as positive data bars.'''
        raise NotImplementedError()
    

class OdsLoadOptions(LoadOptions):
    '''Represents the options of loading ods file.'''
    
    def set_paper_size(self, type : aspose.cells.PaperSizeType) -> None:
        '''Sets the default print paper size from default printer\'s setting.
        
        :param type: The default paper size.'''
        raise NotImplementedError()
    
    @property
    def load_format(self) -> aspose.cells.LoadFormat:
        '''Gets the load format.'''
        raise NotImplementedError()
    
    @property
    def password(self) -> str:
        '''Gets and set the password of the workbook.'''
        raise NotImplementedError()
    
    @password.setter
    def password(self, value : str) -> None:
        '''Gets and set the password of the workbook.'''
        raise NotImplementedError()
    
    @property
    def parsing_formula_on_open(self) -> bool:
        '''Indicates whether parsing the formula when reading the file.'''
        raise NotImplementedError()
    
    @parsing_formula_on_open.setter
    def parsing_formula_on_open(self, value : bool) -> None:
        '''Indicates whether parsing the formula when reading the file.'''
        raise NotImplementedError()
    
    @property
    def parsing_pivot_cached_records(self) -> bool:
        '''Indicates whether parsing pivot cached records when loading the file.
        The default value is false.'''
        raise NotImplementedError()
    
    @parsing_pivot_cached_records.setter
    def parsing_pivot_cached_records(self, value : bool) -> None:
        '''Indicates whether parsing pivot cached records when loading the file.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def language_code(self) -> aspose.cells.CountryCode:
        '''Gets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @language_code.setter
    def language_code(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @property
    def region(self) -> aspose.cells.CountryCode:
        '''Gets the system regional settings based on CountryCode at the time the file was loaded.'''
        raise NotImplementedError()
    
    @region.setter
    def region(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the system regional settings based on CountryCode at the time the file was loaded.'''
        raise NotImplementedError()
    
    @property
    def default_style_settings(self) -> aspose.cells.DefaultStyleSettings:
        '''Gets the default style settings for initializing styles of the workbook'''
        raise NotImplementedError()
    
    @property
    def standard_font(self) -> str:
        '''Sets the default standard font name'''
        raise NotImplementedError()
    
    @standard_font.setter
    def standard_font(self, value : str) -> None:
        '''Sets the default standard font name'''
        raise NotImplementedError()
    
    @property
    def standard_font_size(self) -> float:
        '''Sets the default standard font size.'''
        raise NotImplementedError()
    
    @standard_font_size.setter
    def standard_font_size(self, value : float) -> None:
        '''Sets the default standard font size.'''
        raise NotImplementedError()
    
    @property
    def interrupt_monitor(self) -> aspose.cells.AbstractInterruptMonitor:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.cells.AbstractInterruptMonitor) -> None:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @property
    def ignore_not_printed(self) -> bool:
        '''Ignore the data which are not printed if directly printing the file'''
        raise NotImplementedError()
    
    @ignore_not_printed.setter
    def ignore_not_printed(self, value : bool) -> None:
        '''Ignore the data which are not printed if directly printing the file'''
        raise NotImplementedError()
    
    @property
    def check_data_valid(self) -> bool:
        '''Check whether data is valid in the template file.'''
        raise NotImplementedError()
    
    @check_data_valid.setter
    def check_data_valid(self, value : bool) -> None:
        '''Check whether data is valid in the template file.'''
        raise NotImplementedError()
    
    @property
    def check_excel_restriction(self) -> bool:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @check_excel_restriction.setter
    def check_excel_restriction(self, value : bool) -> None:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @property
    def keep_unparsed_data(self) -> bool:
        '''Whether keep the unparsed data in memory for the Workbook when it is loaded from template file. Default is true.'''
        raise NotImplementedError()
    
    @keep_unparsed_data.setter
    def keep_unparsed_data(self, value : bool) -> None:
        '''Whether keep the unparsed data in memory for the Workbook when it is loaded from template file. Default is true.'''
        raise NotImplementedError()
    
    @property
    def load_filter(self) -> aspose.cells.LoadFilter:
        '''The filter to denote how to load data.'''
        raise NotImplementedError()
    
    @load_filter.setter
    def load_filter(self, value : aspose.cells.LoadFilter) -> None:
        '''The filter to denote how to load data.'''
        raise NotImplementedError()
    
    @property
    def light_cells_data_handler(self) -> aspose.cells.LightCellsDataHandler:
        '''The data handler for processing cells data when reading template file.'''
        raise NotImplementedError()
    
    @light_cells_data_handler.setter
    def light_cells_data_handler(self, value : aspose.cells.LightCellsDataHandler) -> None:
        '''The data handler for processing cells data when reading template file.'''
        raise NotImplementedError()
    
    @property
    def memory_setting(self) -> aspose.cells.MemorySetting:
        '''Gets the memory usage options.'''
        raise NotImplementedError()
    
    @memory_setting.setter
    def memory_setting(self, value : aspose.cells.MemorySetting) -> None:
        '''Sets the memory usage options.'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def auto_fitter_options(self) -> aspose.cells.AutoFitterOptions:
        '''Gets and sets the auto fitter options'''
        raise NotImplementedError()
    
    @auto_fitter_options.setter
    def auto_fitter_options(self, value : aspose.cells.AutoFitterOptions) -> None:
        '''Gets and sets the auto fitter options'''
        raise NotImplementedError()
    
    @property
    def auto_filter(self) -> bool:
        '''Indicates whether auto filtering the data when loading the files.'''
        raise NotImplementedError()
    
    @auto_filter.setter
    def auto_filter(self, value : bool) -> None:
        '''Indicates whether auto filtering the data when loading the files.'''
        raise NotImplementedError()
    
    @property
    def font_configs(self) -> aspose.cells.IndividualFontConfigs:
        '''Gets and sets individual font configs.
        Only works for the :py:class:`aspose.cells.Workbook` which uses this :py:class:`aspose.cells.LoadOptions` to load.'''
        raise NotImplementedError()
    
    @font_configs.setter
    def font_configs(self, value : aspose.cells.IndividualFontConfigs) -> None:
        '''Gets and sets individual font configs.
        Only works for the :py:class:`aspose.cells.Workbook` which uses this :py:class:`aspose.cells.LoadOptions` to load.'''
        raise NotImplementedError()
    
    @property
    def ignore_useless_shapes(self) -> bool:
        '''Indicates whether ignoring useless shapes.'''
        raise NotImplementedError()
    
    @ignore_useless_shapes.setter
    def ignore_useless_shapes(self, value : bool) -> None:
        '''Indicates whether ignoring useless shapes.'''
        raise NotImplementedError()
    
    @property
    def preserve_padding_spaces_in_formula(self) -> bool:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    
    @preserve_padding_spaces_in_formula.setter
    def preserve_padding_spaces_in_formula(self, value : bool) -> None:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    
    @property
    def apply_excel_default_style_to_hyperlink(self) -> bool:
        '''Indicates whether applying the default style of the Excel to hyperlink.'''
        raise NotImplementedError()
    
    @apply_excel_default_style_to_hyperlink.setter
    def apply_excel_default_style_to_hyperlink(self, value : bool) -> None:
        '''Indicates whether applying the default style of the Excel to hyperlink.'''
        raise NotImplementedError()
    
    @property
    def refresh_pivot_tables(self) -> bool:
        '''Indicates whether refresh pivot tables when loading file.'''
        raise NotImplementedError()
    
    @refresh_pivot_tables.setter
    def refresh_pivot_tables(self, value : bool) -> None:
        '''Indicates whether refresh pivot tables when loading file.'''
        raise NotImplementedError()
    
    @property
    def is_classic_pivot_table(self) -> bool:
        raise NotImplementedError()
    
    @is_classic_pivot_table.setter
    def is_classic_pivot_table(self, value : bool) -> None:
        raise NotImplementedError()
    

class OdsSaveOptions(SaveOptions):
    '''Represents the options of saving ods file.'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def generator_type(self) -> aspose.cells.ods.OdsGeneratorType:
        '''Gets and sets the generator of the ods file.'''
        raise NotImplementedError()
    
    @generator_type.setter
    def generator_type(self, value : aspose.cells.ods.OdsGeneratorType) -> None:
        '''Gets and sets the generator of the ods file.'''
        raise NotImplementedError()
    
    @property
    def is_strict_schema11(self) -> bool:
        '''Indicates whether the ods file should be saved as ODF format version 1.1. Default is false.'''
        raise NotImplementedError()
    
    @is_strict_schema11.setter
    def is_strict_schema11(self, value : bool) -> None:
        '''Indicates whether the ods file should be saved as ODF format version 1.1. Default is false.'''
        raise NotImplementedError()
    
    @property
    def odf_strict_version(self) -> aspose.cells.ods.OpenDocumentFormatVersionType:
        '''Gets and sets the ODF version.'''
        raise NotImplementedError()
    
    @odf_strict_version.setter
    def odf_strict_version(self, value : aspose.cells.ods.OpenDocumentFormatVersionType) -> None:
        '''Gets and sets the ODF version.'''
        raise NotImplementedError()
    
    @property
    def ignore_pivot_tables(self) -> bool:
        raise NotImplementedError()
    
    @ignore_pivot_tables.setter
    def ignore_pivot_tables(self, value : bool) -> None:
        raise NotImplementedError()
    

class OoxmlSaveOptions(SaveOptions):
    '''Represents the options of saving office open xml file.'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def export_cell_name(self) -> bool:
        '''Indicates if export cell name to Excel2007 .xlsx (.xlsm, .xltx, .xltm) file.
        If the output file may be accessed by SQL Server DTS, this value must be true.
        Setting the value to false will highly increase the performance and reduce the file size when creating large file.
        Default value is true.'''
        raise NotImplementedError()
    
    @export_cell_name.setter
    def export_cell_name(self, value : bool) -> None:
        '''Indicates if export cell name to Excel2007 .xlsx (.xlsm, .xltx, .xltm) file.
        If the output file may be accessed by SQL Server DTS, this value must be true.
        Setting the value to false will highly increase the performance and reduce the file size when creating large file.
        Default value is true.'''
        raise NotImplementedError()
    
    @property
    def light_cells_data_provider(self) -> aspose.cells.LightCellsDataProvider:
        '''The data provider for saving workbook in light mode.'''
        raise NotImplementedError()
    
    @light_cells_data_provider.setter
    def light_cells_data_provider(self, value : aspose.cells.LightCellsDataProvider) -> None:
        '''The data provider for saving workbook in light mode.'''
        raise NotImplementedError()
    
    @property
    def update_zoom(self) -> bool:
        '''Indicates whether update scaling factor before saving the file
        if the PageSetup.FitToPagesWide and PageSetup.FitToPagesTall properties control how the worksheet is scaled.'''
        raise NotImplementedError()
    
    @update_zoom.setter
    def update_zoom(self, value : bool) -> None:
        '''Indicates whether update scaling factor before saving the file
        if the PageSetup.FitToPagesWide and PageSetup.FitToPagesTall properties control how the worksheet is scaled.'''
        raise NotImplementedError()
    
    @property
    def enable_zip64(self) -> bool:
        '''Always use ZIP64 extensions when writing zip archives, even when unnecessary.'''
        raise NotImplementedError()
    
    @enable_zip64.setter
    def enable_zip64(self, value : bool) -> None:
        '''Always use ZIP64 extensions when writing zip archives, even when unnecessary.'''
        raise NotImplementedError()
    
    @property
    def embed_ooxml_as_ole_object(self) -> bool:
        '''Indicates whether embedding Ooxml files of OleObject as ole object.'''
        raise NotImplementedError()
    
    @embed_ooxml_as_ole_object.setter
    def embed_ooxml_as_ole_object(self, value : bool) -> None:
        '''Indicates whether embedding Ooxml files of OleObject as ole object.'''
        raise NotImplementedError()
    
    @property
    def compression_type(self) -> aspose.cells.OoxmlCompressionType:
        '''Gets and sets the compression type for ooxml file.'''
        raise NotImplementedError()
    
    @compression_type.setter
    def compression_type(self, value : aspose.cells.OoxmlCompressionType) -> None:
        '''Gets and sets the compression type for ooxml file.'''
        raise NotImplementedError()
    

class Outline:
    '''Represents an outline on a worksheet.'''
    
    @property
    def summary_row_below(self) -> bool:
        '''Indicates if the summary row will be positioned below the detail rows in the outline.'''
        raise NotImplementedError()
    
    @summary_row_below.setter
    def summary_row_below(self, value : bool) -> None:
        '''Indicates if the summary row will be positioned below the detail rows in the outline.'''
        raise NotImplementedError()
    
    @property
    def summary_column_right(self) -> bool:
        '''Indicates if the summary column will be positioned to the right of the detail columns in the outline.'''
        raise NotImplementedError()
    
    @summary_column_right.setter
    def summary_column_right(self, value : bool) -> None:
        '''Indicates if the summary column will be positioned to the right of the detail columns in the outline.'''
        raise NotImplementedError()
    

class PageSetup:
    '''Encapsulates the object that represents the page setup description.
    The PageSetup object contains all page setup options.'''
    
    @overload
    def get_picture(self, is_header : bool, section : int) -> aspose.cells.drawing.Picture:
        '''Gets the :py:class:`aspose.cells.drawing.Picture` object of the header / footer.
        
        :param is_header: Indicates whether it is in the header or footer.
        :param section: 0: Left Section, 1: Center Section, 2: Right Section.
        :returns: Returns :py:class:`aspose.cells.drawing.Picture` object.
        Returns null if there is no picture.'''
        raise NotImplementedError()
    
    @overload
    def get_picture(self, is_first : bool, is_even : bool, is_header : bool, section : int) -> aspose.cells.drawing.Picture:
        '''Gets the :py:class:`aspose.cells.drawing.Picture` object of the header / footer.
        
        :param is_first: Indicates whether getting the picture of first page header/footer.
        :param is_even: Indicates whether getting the picture of even page header/footer.
        :param is_header: Indicates whether getting the picture of header/footer.
        :param section: 0: Left Section, 1: Center Section, 2: Right Section.
        :returns: Returns :py:class:`aspose.cells.drawing.Picture` object.'''
        raise NotImplementedError()
    
    def copy(self, source : aspose.cells.PageSetup, copy_options : aspose.cells.CopyOptions) -> None:
        '''Copies the setting of the page setup.
        
        :param source: The source.
        :param copy_options: The copy options.'''
        raise NotImplementedError()
    
    def set_fit_to_pages(self, wide : int, tall : int) -> None:
        '''Sets the number of pages the worksheet will be scaled to when it\'s printed.
        
        :param wide: Pages wide.
        :param tall: Pages tall.'''
        raise NotImplementedError()
    
    def custom_paper_size(self, width : float, height : float) -> None:
        '''Sets the custom paper size, in unit of inches.
        
        :param width: The width of the paper.
        :param height: The height of the paper.'''
        raise NotImplementedError()
    
    def clear_header_footer(self) -> None:
        '''Clears header and footer setting.'''
        raise NotImplementedError()
    
    def get_header(self, section : int) -> str:
        '''Gets a script formatting the header of an Excel file.
        
        :param section: 0: Left Section, 1: Center Section, 2: Right Section.'''
        raise NotImplementedError()
    
    def get_commands(self, header_footer_script : str) -> List[aspose.cells.HeaderFooterCommand]:
        '''Gets all commands of header or footer.
        
        :param header_footer_script: The header/footer script
        :returns: Returns all commands of header or footer.'''
        raise NotImplementedError()
    
    def get_footer(self, section : int) -> str:
        '''Gets a script formatting the footer of an Excel file.
        
        :param section: 0: Left Section, 1: Center Section, 2: Right Section.'''
        raise NotImplementedError()
    
    def set_header(self, section : int, header_script : str) -> None:
        '''Sets a script formatting the header of an Excel file.
        
        :param section: 0: Left Section, 1: Center Section, 2: Right Section.
        :param header_script: Header format script.'''
        raise NotImplementedError()
    
    def set_footer(self, section : int, footer_script : str) -> None:
        '''Sets a script formatting the footer of an Excel file.
        
        :param section: 0: Left Section, 1: Center Section, 2: Right Section.
        :param footer_script: Footer format script.'''
        raise NotImplementedError()
    
    def set_even_header(self, section : int, header_script : str) -> None:
        '''Sets a script formatting the even page header of an Excel file.
        Only effect in Excel 2007 when IsHFDiffOddEven is true.
        
        :param section: 0: Left Section, 1: Center Section, 2: Right Section.
        :param header_script: Header format script.'''
        raise NotImplementedError()
    
    def get_even_header(self, section : int) -> str:
        '''Gets a script formatting the even header of an Excel file.
        
        :param section: 0: Left Section, 1: Center Section, 2: Right Section.'''
        raise NotImplementedError()
    
    def set_even_footer(self, section : int, footer_script : str) -> None:
        '''Sets a script formatting the even page footer of an Excel file.
        Only effect in Excel 2007 when IsHFDiffOddEven is true.
        
        :param section: 0: Left Section, 1: Center Section, 2: Right Section.
        :param footer_script: Footer format script.'''
        raise NotImplementedError()
    
    def get_even_footer(self, section : int) -> str:
        '''Gets a script formatting the even footer of an Excel file.
        
        :param section: 0: Left Section, 1: Center Section, 2: Right Section.'''
        raise NotImplementedError()
    
    def set_first_page_header(self, section : int, header_script : str) -> None:
        '''Sets a script formatting the first page header of an Excel file.
        Only effect in Excel 2007 when IsHFDiffFirst is true.
        
        :param section: 0: Left Section, 1: Center Section, 2: Right Section.
        :param header_script: Header format script.'''
        raise NotImplementedError()
    
    def get_first_page_header(self, section : int) -> str:
        '''Gets a script formatting the first page header of an Excel file.
        
        :param section: 0: Left Section, 1: Center Section, 2: Right Section.'''
        raise NotImplementedError()
    
    def set_first_page_footer(self, section : int, footer_script : str) -> None:
        '''Sets a script formatting the first page footer of an Excel file.
        
        :param section: 0: Left Section, 1: Center Section, 2: Right Section.
        :param footer_script: Footer format script.'''
        raise NotImplementedError()
    
    def get_first_page_footer(self, section : int) -> str:
        '''Gets a script formatting the first page footer of an Excel file.
        
        :param section: 0: Left Section, 1: Center Section, 2: Right Section.'''
        raise NotImplementedError()
    
    def set_header_picture(self, section : int, header_picture : List[int]) -> aspose.cells.drawing.Picture:
        '''Sets an image in the header of a worksheet.
        
        :param section: 0: Left Section, 1: Center Section, 2: Right Section.
        :param header_picture: Image data.
        :returns: Returns :py:class:`aspose.cells.drawing.Picture` object.'''
        raise NotImplementedError()
    
    def set_footer_picture(self, section : int, footer_picture : List[int]) -> aspose.cells.drawing.Picture:
        '''Sets an image in the footer of a worksheet.
        
        :param section: 0: Left Section, 1: Center Section, 2: Right Section.
        :param footer_picture: Image data.
        :returns: Returns :py:class:`aspose.cells.drawing.Picture` object.'''
        raise NotImplementedError()
    
    def set_picture(self, is_first : bool, is_even : bool, is_header : bool, section : int, image_data : List[int]) -> aspose.cells.drawing.Picture:
        '''Sets an image in the header/footer of a worksheet.
        
        :param is_first: Indicates whether setting the picture of first page header/footer.
        :param is_even: Indicates whether setting the picture of even page header/footer.
        :param is_header: Indicates whether setting the picture of header/footer.
        :param section: 0: Left Section, 1: Center Section, 2: Right Section.
        :param image_data: Image data.
        :returns: Returns :py:class:`aspose.cells.drawing.Picture` object.'''
        raise NotImplementedError()
    
    @property
    def ods_page_background(self) -> aspose.cells.ods.OdsPageBackground:
        '''Gets the background of ODS.'''
        raise NotImplementedError()
    
    @property
    def print_area(self) -> str:
        '''Represents the range to be printed.'''
        raise NotImplementedError()
    
    @print_area.setter
    def print_area(self, value : str) -> None:
        '''Represents the range to be printed.'''
        raise NotImplementedError()
    
    @property
    def print_title_columns(self) -> str:
        '''Represents the columns that contain the cells to be repeated on the left side of each page.'''
        raise NotImplementedError()
    
    @print_title_columns.setter
    def print_title_columns(self, value : str) -> None:
        '''Represents the columns that contain the cells to be repeated on the left side of each page.'''
        raise NotImplementedError()
    
    @property
    def print_title_rows(self) -> str:
        '''Represents the rows that contain the cells to be repeated at the top of each page.'''
        raise NotImplementedError()
    
    @print_title_rows.setter
    def print_title_rows(self, value : str) -> None:
        '''Represents the rows that contain the cells to be repeated at the top of each page.'''
        raise NotImplementedError()
    
    @property
    def black_and_white(self) -> bool:
        '''Represents if elements of the document will be printed in black and white.'''
        raise NotImplementedError()
    
    @black_and_white.setter
    def black_and_white(self, value : bool) -> None:
        '''Represents if elements of the document will be printed in black and white.'''
        raise NotImplementedError()
    
    @property
    def center_horizontally(self) -> bool:
        '''Represent if the sheet is printed centered horizontally.'''
        raise NotImplementedError()
    
    @center_horizontally.setter
    def center_horizontally(self, value : bool) -> None:
        '''Represent if the sheet is printed centered horizontally.'''
        raise NotImplementedError()
    
    @property
    def center_vertically(self) -> bool:
        '''Represent if the sheet is printed centered vertically.'''
        raise NotImplementedError()
    
    @center_vertically.setter
    def center_vertically(self, value : bool) -> None:
        '''Represent if the sheet is printed centered vertically.'''
        raise NotImplementedError()
    
    @property
    def print_draft(self) -> bool:
        '''Represents if the sheet will be printed without graphics.'''
        raise NotImplementedError()
    
    @print_draft.setter
    def print_draft(self, value : bool) -> None:
        '''Represents if the sheet will be printed without graphics.'''
        raise NotImplementedError()
    
    @property
    def footer_margin(self) -> float:
        '''Represents the distance from the bottom of the page to the footer, in unit of centimeters.'''
        raise NotImplementedError()
    
    @footer_margin.setter
    def footer_margin(self, value : float) -> None:
        '''Represents the distance from the bottom of the page to the footer, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def footer_margin_inch(self) -> float:
        '''Represents the distance from the bottom of the page to the footer, in unit of inches.'''
        raise NotImplementedError()
    
    @footer_margin_inch.setter
    def footer_margin_inch(self, value : float) -> None:
        '''Represents the distance from the bottom of the page to the footer, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def header_margin(self) -> float:
        '''Represents the distance from the top of the page to the header, in unit of centimeters.'''
        raise NotImplementedError()
    
    @header_margin.setter
    def header_margin(self, value : float) -> None:
        '''Represents the distance from the top of the page to the header, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def header_margin_inch(self) -> float:
        '''Represents the distance from the top of the page to the header, in unit of inches.'''
        raise NotImplementedError()
    
    @header_margin_inch.setter
    def header_margin_inch(self, value : float) -> None:
        '''Represents the distance from the top of the page to the header, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def printer_settings(self) -> List[int]:
        '''Gets and sets the settings of the default printer.'''
        raise NotImplementedError()
    
    @printer_settings.setter
    def printer_settings(self, value : List[int]) -> None:
        '''Gets and sets the settings of the default printer.'''
        raise NotImplementedError()
    
    @property
    def left_margin(self) -> float:
        '''Represents the size of the left margin, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_margin.setter
    def left_margin(self, value : float) -> None:
        '''Represents the size of the left margin, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left_margin_inch(self) -> float:
        '''Represents the size of the left margin, in unit of inches.'''
        raise NotImplementedError()
    
    @left_margin_inch.setter
    def left_margin_inch(self, value : float) -> None:
        '''Represents the size of the left margin, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def right_margin(self) -> float:
        '''Represents the size of the right margin, in unit of centimeters.'''
        raise NotImplementedError()
    
    @right_margin.setter
    def right_margin(self, value : float) -> None:
        '''Represents the size of the right margin, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def right_margin_inch(self) -> float:
        '''Represents the size of the right margin, in unit of inches.'''
        raise NotImplementedError()
    
    @right_margin_inch.setter
    def right_margin_inch(self, value : float) -> None:
        '''Represents the size of the right margin, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_margin(self) -> float:
        '''Represents the size of the top margin, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_margin.setter
    def top_margin(self, value : float) -> None:
        '''Represents the size of the top margin, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_margin_inch(self) -> float:
        '''Represents the size of the top margin, in unit of inches.'''
        raise NotImplementedError()
    
    @top_margin_inch.setter
    def top_margin_inch(self, value : float) -> None:
        '''Represents the size of the top margin, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def bottom_margin(self) -> float:
        '''Represents the size of the bottom margin, in unit of centimeters.'''
        raise NotImplementedError()
    
    @bottom_margin.setter
    def bottom_margin(self, value : float) -> None:
        '''Represents the size of the bottom margin, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def bottom_margin_inch(self) -> float:
        '''Represents the size of the bottom margin, in unit of inches.'''
        raise NotImplementedError()
    
    @bottom_margin_inch.setter
    def bottom_margin_inch(self, value : float) -> None:
        '''Represents the size of the bottom margin, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def first_page_number(self) -> int:
        '''Represents the first page number that will be used when this sheet is printed.'''
        raise NotImplementedError()
    
    @first_page_number.setter
    def first_page_number(self, value : int) -> None:
        '''Represents the first page number that will be used when this sheet is printed.'''
        raise NotImplementedError()
    
    @property
    def fit_to_pages_tall(self) -> int:
        '''Represents  the number of pages tall the worksheet will be scaled to when it\'s printed.
        The default value is 1.'''
        raise NotImplementedError()
    
    @fit_to_pages_tall.setter
    def fit_to_pages_tall(self, value : int) -> None:
        '''Represents  the number of pages tall the worksheet will be scaled to when it\'s printed.
        The default value is 1.'''
        raise NotImplementedError()
    
    @property
    def fit_to_pages_wide(self) -> int:
        '''Represents the number of pages wide the worksheet will be scaled to when it\'s printed.
        The default value is 1.'''
        raise NotImplementedError()
    
    @fit_to_pages_wide.setter
    def fit_to_pages_wide(self, value : int) -> None:
        '''Represents the number of pages wide the worksheet will be scaled to when it\'s printed.
        The default value is 1.'''
        raise NotImplementedError()
    
    @property
    def is_percent_scale(self) -> bool:
        '''If this property is False, the FitToPagesWide and FitToPagesTall properties control how the worksheet is scaled.'''
        raise NotImplementedError()
    
    @is_percent_scale.setter
    def is_percent_scale(self, value : bool) -> None:
        '''If this property is False, the FitToPagesWide and FitToPagesTall properties control how the worksheet is scaled.'''
        raise NotImplementedError()
    
    @property
    def order(self) -> aspose.cells.PrintOrderType:
        '''Represents the order that Microsoft Excel uses to number pages when printing a large worksheet.'''
        raise NotImplementedError()
    
    @order.setter
    def order(self, value : aspose.cells.PrintOrderType) -> None:
        '''Represents the order that Microsoft Excel uses to number pages when printing a large worksheet.'''
        raise NotImplementedError()
    
    @property
    def is_automatic_paper_size(self) -> bool:
        '''Indicates whether the paper size is automatic.'''
        raise NotImplementedError()
    
    @property
    def paper_size(self) -> aspose.cells.PaperSizeType:
        '''Represents the size of the paper.'''
        raise NotImplementedError()
    
    @paper_size.setter
    def paper_size(self, value : aspose.cells.PaperSizeType) -> None:
        '''Represents the size of the paper.'''
        raise NotImplementedError()
    
    @property
    def paper_width(self) -> float:
        '''Gets the width of the paper in unit of inches, considered page orientation.'''
        raise NotImplementedError()
    
    @property
    def paper_height(self) -> float:
        '''Gets the height of the paper in unit of inches , considered page orientation.'''
        raise NotImplementedError()
    
    @property
    def orientation(self) -> aspose.cells.PageOrientationType:
        '''Represents page print orientation.'''
        raise NotImplementedError()
    
    @orientation.setter
    def orientation(self, value : aspose.cells.PageOrientationType) -> None:
        '''Represents page print orientation.'''
        raise NotImplementedError()
    
    @property
    def print_comments(self) -> aspose.cells.PrintCommentsType:
        '''Represents the way comments are printed with the sheet.'''
        raise NotImplementedError()
    
    @print_comments.setter
    def print_comments(self, value : aspose.cells.PrintCommentsType) -> None:
        '''Represents the way comments are printed with the sheet.'''
        raise NotImplementedError()
    
    @property
    def print_errors(self) -> aspose.cells.PrintErrorsType:
        '''Specifies the type of print error displayed.'''
        raise NotImplementedError()
    
    @print_errors.setter
    def print_errors(self, value : aspose.cells.PrintErrorsType) -> None:
        '''Specifies the type of print error displayed.'''
        raise NotImplementedError()
    
    @property
    def print_headings(self) -> bool:
        '''Represents if row and column headings are printed with this page.'''
        raise NotImplementedError()
    
    @print_headings.setter
    def print_headings(self, value : bool) -> None:
        '''Represents if row and column headings are printed with this page.'''
        raise NotImplementedError()
    
    @property
    def print_gridlines(self) -> bool:
        '''Represents if cell gridlines are printed on the page.'''
        raise NotImplementedError()
    
    @print_gridlines.setter
    def print_gridlines(self, value : bool) -> None:
        '''Represents if cell gridlines are printed on the page.'''
        raise NotImplementedError()
    
    @property
    def zoom(self) -> int:
        '''Represents the scaling factor in percent. It should be between 10 and 400.'''
        raise NotImplementedError()
    
    @zoom.setter
    def zoom(self, value : int) -> None:
        '''Represents the scaling factor in percent. It should be between 10 and 400.'''
        raise NotImplementedError()
    
    @property
    def is_auto_first_page_number(self) -> bool:
        '''Indicates whether the first the page number is automatically assigned.'''
        raise NotImplementedError()
    
    @is_auto_first_page_number.setter
    def is_auto_first_page_number(self, value : bool) -> None:
        '''Indicates whether the first the page number is automatically assigned.'''
        raise NotImplementedError()
    
    @property
    def print_quality(self) -> int:
        '''Represents the print quality.'''
        raise NotImplementedError()
    
    @print_quality.setter
    def print_quality(self, value : int) -> None:
        '''Represents the print quality.'''
        raise NotImplementedError()
    
    @property
    def print_copies(self) -> int:
        '''Get and sets number of copies to print.'''
        raise NotImplementedError()
    
    @print_copies.setter
    def print_copies(self, value : int) -> None:
        '''Get and sets number of copies to print.'''
        raise NotImplementedError()
    
    @property
    def is_hf_diff_odd_even(self) -> bool:
        '''True means that the header/footer of the odd pages is different with odd pages.'''
        raise NotImplementedError()
    
    @is_hf_diff_odd_even.setter
    def is_hf_diff_odd_even(self, value : bool) -> None:
        '''True means that the header/footer of the odd pages is different with odd pages.'''
        raise NotImplementedError()
    
    @property
    def is_hf_diff_first(self) -> bool:
        '''True means that the header/footer of the first page is different with other pages.'''
        raise NotImplementedError()
    
    @is_hf_diff_first.setter
    def is_hf_diff_first(self, value : bool) -> None:
        '''True means that the header/footer of the first page is different with other pages.'''
        raise NotImplementedError()
    
    @property
    def is_hf_scale_with_doc(self) -> bool:
        '''Indicates whether header and footer are scaled with document scaling.
        Only applies for Excel 2007.'''
        raise NotImplementedError()
    
    @is_hf_scale_with_doc.setter
    def is_hf_scale_with_doc(self, value : bool) -> None:
        '''Indicates whether header and footer are scaled with document scaling.
        Only applies for Excel 2007.'''
        raise NotImplementedError()
    
    @property
    def is_hf_align_margins(self) -> bool:
        '''Indicates whether header and footer margins are aligned with the page margins.
        If this property is true, the left header and footer will be aligned with the left margin,
        and the right header and footer will be aligned with the right margin.
        This option is enabled by default.'''
        raise NotImplementedError()
    
    @is_hf_align_margins.setter
    def is_hf_align_margins(self, value : bool) -> None:
        '''Indicates whether header and footer margins are aligned with the page margins.
        If this property is true, the left header and footer will be aligned with the left margin,
        and the right header and footer will be aligned with the right margin.
        This option is enabled by default.'''
        raise NotImplementedError()
    

class PaginatedSaveOptions(SaveOptions):
    '''Represents the options for pagination.'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def default_font(self) -> str:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set the DefaultFont such as MingLiu or MS Gothic to show these characters.
        If this property is not set, Aspose.Cells will use system default font to show these unicode characters.'''
        raise NotImplementedError()
    
    @default_font.setter
    def default_font(self, value : str) -> None:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set the DefaultFont such as MingLiu or MS Gothic to show these characters.
        If this property is not set, Aspose.Cells will use system default font to show these unicode characters.'''
        raise NotImplementedError()
    
    @property
    def check_workbook_default_font(self) -> bool:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set this to true to try to use workbook\'s default font to show these characters first.'''
        raise NotImplementedError()
    
    @check_workbook_default_font.setter
    def check_workbook_default_font(self, value : bool) -> None:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set this to true to try to use workbook\'s default font to show these characters first.'''
        raise NotImplementedError()
    
    @property
    def check_font_compatibility(self) -> bool:
        '''Indicates whether to check font compatibility for every character in text.'''
        raise NotImplementedError()
    
    @check_font_compatibility.setter
    def check_font_compatibility(self, value : bool) -> None:
        '''Indicates whether to check font compatibility for every character in text.'''
        raise NotImplementedError()
    
    @property
    def is_font_substitution_char_granularity(self) -> bool:
        '''Indicates whether to only substitute the font of character when the cell font is not compatibility for it.'''
        raise NotImplementedError()
    
    @is_font_substitution_char_granularity.setter
    def is_font_substitution_char_granularity(self, value : bool) -> None:
        '''Indicates whether to only substitute the font of character when the cell font is not compatibility for it.'''
        raise NotImplementedError()
    
    @property
    def one_page_per_sheet(self) -> bool:
        '''If OnePagePerSheet is true , all content of one sheet will output to only one page in result.
        The paper size of pagesetup will be invalid, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @one_page_per_sheet.setter
    def one_page_per_sheet(self, value : bool) -> None:
        '''If OnePagePerSheet is true , all content of one sheet will output to only one page in result.
        The paper size of pagesetup will be invalid, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @property
    def all_columns_in_one_page_per_sheet(self) -> bool:
        '''If AllColumnsInOnePagePerSheet is true , all column content of one sheet will output to only one page in result.
        The width of paper size of pagesetup will be ignored, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @all_columns_in_one_page_per_sheet.setter
    def all_columns_in_one_page_per_sheet(self, value : bool) -> None:
        '''If AllColumnsInOnePagePerSheet is true , all column content of one sheet will output to only one page in result.
        The width of paper size of pagesetup will be ignored, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @property
    def ignore_error(self) -> bool:
        '''Indicates if you need to hide the error while rendering.
        The error can be error in shape, image, chart rendering, etc.'''
        raise NotImplementedError()
    
    @ignore_error.setter
    def ignore_error(self, value : bool) -> None:
        '''Indicates if you need to hide the error while rendering.
        The error can be error in shape, image, chart rendering, etc.'''
        raise NotImplementedError()
    
    @property
    def output_blank_page_when_nothing_to_print(self) -> bool:
        '''Indicates whether to output a blank page when there is nothing to print.'''
        raise NotImplementedError()
    
    @output_blank_page_when_nothing_to_print.setter
    def output_blank_page_when_nothing_to_print(self, value : bool) -> None:
        '''Indicates whether to output a blank page when there is nothing to print.'''
        raise NotImplementedError()
    
    @property
    def page_index(self) -> int:
        '''Gets the 0-based index of the first page to save.'''
        raise NotImplementedError()
    
    @page_index.setter
    def page_index(self, value : int) -> None:
        '''Sets the 0-based index of the first page to save.'''
        raise NotImplementedError()
    
    @property
    def page_count(self) -> int:
        '''Gets the number of pages to save.'''
        raise NotImplementedError()
    
    @page_count.setter
    def page_count(self, value : int) -> None:
        '''Sets the number of pages to save.'''
        raise NotImplementedError()
    
    @property
    def printing_page_type(self) -> aspose.cells.PrintingPageType:
        '''Indicates which pages will not be printed.'''
        raise NotImplementedError()
    
    @printing_page_type.setter
    def printing_page_type(self, value : aspose.cells.PrintingPageType) -> None:
        '''Indicates which pages will not be printed.'''
        raise NotImplementedError()
    
    @property
    def gridline_type(self) -> aspose.cells.GridlineType:
        '''Gets gridline type.'''
        raise NotImplementedError()
    
    @gridline_type.setter
    def gridline_type(self, value : aspose.cells.GridlineType) -> None:
        '''Sets gridline type.'''
        raise NotImplementedError()
    
    @property
    def text_cross_type(self) -> aspose.cells.TextCrossType:
        '''Gets displaying text type when the text width is larger than cell width.'''
        raise NotImplementedError()
    
    @text_cross_type.setter
    def text_cross_type(self, value : aspose.cells.TextCrossType) -> None:
        '''Sets displaying text type when the text width is larger than cell width.'''
        raise NotImplementedError()
    
    @property
    def default_edit_language(self) -> aspose.cells.DefaultEditLanguage:
        '''Gets default edit language.'''
        raise NotImplementedError()
    
    @default_edit_language.setter
    def default_edit_language(self, value : aspose.cells.DefaultEditLanguage) -> None:
        '''Sets default edit language.'''
        raise NotImplementedError()
    
    @property
    def sheet_set(self) -> aspose.cells.rendering.SheetSet:
        '''Gets the sheets to render. Default is all visible sheets in the workbook: :py:attr:`aspose.cells.rendering.SheetSet.visible`.'''
        raise NotImplementedError()
    
    @sheet_set.setter
    def sheet_set(self, value : aspose.cells.rendering.SheetSet) -> None:
        '''Sets the sheets to render. Default is all visible sheets in the workbook: :py:attr:`aspose.cells.rendering.SheetSet.visible`.'''
        raise NotImplementedError()
    
    @property
    def draw_object_event_handler(self) -> aspose.cells.rendering.DrawObjectEventHandler:
        '''Implements this interface to get DrawObject and Bound when rendering.'''
        raise NotImplementedError()
    
    @draw_object_event_handler.setter
    def draw_object_event_handler(self, value : aspose.cells.rendering.DrawObjectEventHandler) -> None:
        '''Implements this interface to get DrawObject and Bound when rendering.'''
        raise NotImplementedError()
    
    @property
    def page_saving_callback(self) -> aspose.cells.rendering.IPageSavingCallback:
        '''Control/Indicate progress of page saving process.'''
        raise NotImplementedError()
    
    @page_saving_callback.setter
    def page_saving_callback(self, value : aspose.cells.rendering.IPageSavingCallback) -> None:
        '''Control/Indicate progress of page saving process.'''
        raise NotImplementedError()
    
    @property
    def emf_render_setting(self) -> aspose.cells.EmfRenderSetting:
        '''Setting for rendering Emf metafile.'''
        raise NotImplementedError()
    
    @emf_render_setting.setter
    def emf_render_setting(self, value : aspose.cells.EmfRenderSetting) -> None:
        '''Setting for rendering Emf metafile.'''
        raise NotImplementedError()
    

class PaneCollection:
    '''Represents all Pane objects shown in the specified window.'''
    
    @property
    def first_visible_row_of_bottom_pane(self) -> int:
        '''Gets and sets the first visible row of the bottom pane.'''
        raise NotImplementedError()
    
    @first_visible_row_of_bottom_pane.setter
    def first_visible_row_of_bottom_pane(self, value : int) -> None:
        '''Gets and sets the first visible row of the bottom pane.'''
        raise NotImplementedError()
    
    @property
    def first_visible_column_of_right_pane(self) -> int:
        '''Gets and sets the first visible column of the right pane.'''
        raise NotImplementedError()
    
    @first_visible_column_of_right_pane.setter
    def first_visible_column_of_right_pane(self, value : int) -> None:
        '''Gets and sets the first visible column of the right pane.'''
        raise NotImplementedError()
    
    @property
    def acitve_pane_type(self) -> aspose.cells.drawing.RectangleAlignmentType:
        '''Gets and sets the active pane.'''
        raise NotImplementedError()
    
    @acitve_pane_type.setter
    def acitve_pane_type(self, value : aspose.cells.drawing.RectangleAlignmentType) -> None:
        '''Gets and sets the active pane.'''
        raise NotImplementedError()
    

class PasteOptions:
    '''Represents the paste special options.'''
    
    @property
    def paste_type(self) -> aspose.cells.PasteType:
        '''The paste special type.'''
        raise NotImplementedError()
    
    @paste_type.setter
    def paste_type(self, value : aspose.cells.PasteType) -> None:
        '''The paste special type.'''
        raise NotImplementedError()
    
    @property
    def skip_blanks(self) -> bool:
        '''Indicates whether skips blank cells.'''
        raise NotImplementedError()
    
    @skip_blanks.setter
    def skip_blanks(self, value : bool) -> None:
        '''Indicates whether skips blank cells.'''
        raise NotImplementedError()
    
    @property
    def only_visible_cells(self) -> bool:
        '''True means only copying visible cells.'''
        raise NotImplementedError()
    
    @only_visible_cells.setter
    def only_visible_cells(self, value : bool) -> None:
        '''True means only copying visible cells.'''
        raise NotImplementedError()
    
    @property
    def transpose(self) -> bool:
        '''True to transpose rows and columns when the range is pasted. The default value is False.'''
        raise NotImplementedError()
    
    @transpose.setter
    def transpose(self, value : bool) -> None:
        '''True to transpose rows and columns when the range is pasted. The default value is False.'''
        raise NotImplementedError()
    
    @property
    def operation_type(self) -> aspose.cells.PasteOperationType:
        '''Gets and sets the operation type when pasting range.'''
        raise NotImplementedError()
    
    @operation_type.setter
    def operation_type(self, value : aspose.cells.PasteOperationType) -> None:
        '''Gets and sets the operation type when pasting range.'''
        raise NotImplementedError()
    
    @property
    def ignore_links_to_original_file(self) -> bool:
        '''Ingore links to the original file.'''
        raise NotImplementedError()
    
    @ignore_links_to_original_file.setter
    def ignore_links_to_original_file(self, value : bool) -> None:
        '''Ingore links to the original file.'''
        raise NotImplementedError()
    

class PdfSaveOptions(PaginatedSaveOptions):
    '''Represents the options for saving pdf file.'''
    
    def set_image_resample(self, desired_ppi : int, jpeg_quality : int) -> None:
        '''Sets desired PPI(pixels per inch) of resample images and jpeg quality.
        All images will be converted to JPEG with the specified quality setting,
        and images that are greater than the specified PPI (pixels per inch) will be resampled.
        
        :param desired_ppi: Desired pixels per inch. 220 high quality. 150 screen quality. 96 email quality.
        :param jpeg_quality: 0 - 100% JPEG quality.'''
        raise NotImplementedError()
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def default_font(self) -> str:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set the DefaultFont such as MingLiu or MS Gothic to show these characters.
        If this property is not set, Aspose.Cells will use system default font to show these unicode characters.'''
        raise NotImplementedError()
    
    @default_font.setter
    def default_font(self, value : str) -> None:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set the DefaultFont such as MingLiu or MS Gothic to show these characters.
        If this property is not set, Aspose.Cells will use system default font to show these unicode characters.'''
        raise NotImplementedError()
    
    @property
    def check_workbook_default_font(self) -> bool:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set this to true to try to use workbook\'s default font to show these characters first.'''
        raise NotImplementedError()
    
    @check_workbook_default_font.setter
    def check_workbook_default_font(self, value : bool) -> None:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set this to true to try to use workbook\'s default font to show these characters first.'''
        raise NotImplementedError()
    
    @property
    def check_font_compatibility(self) -> bool:
        '''Indicates whether to check font compatibility for every character in text.'''
        raise NotImplementedError()
    
    @check_font_compatibility.setter
    def check_font_compatibility(self, value : bool) -> None:
        '''Indicates whether to check font compatibility for every character in text.'''
        raise NotImplementedError()
    
    @property
    def is_font_substitution_char_granularity(self) -> bool:
        '''Indicates whether to only substitute the font of character when the cell font is not compatibility for it.'''
        raise NotImplementedError()
    
    @is_font_substitution_char_granularity.setter
    def is_font_substitution_char_granularity(self, value : bool) -> None:
        '''Indicates whether to only substitute the font of character when the cell font is not compatibility for it.'''
        raise NotImplementedError()
    
    @property
    def one_page_per_sheet(self) -> bool:
        '''If OnePagePerSheet is true , all content of one sheet will output to only one page in result.
        The paper size of pagesetup will be invalid, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @one_page_per_sheet.setter
    def one_page_per_sheet(self, value : bool) -> None:
        '''If OnePagePerSheet is true , all content of one sheet will output to only one page in result.
        The paper size of pagesetup will be invalid, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @property
    def all_columns_in_one_page_per_sheet(self) -> bool:
        '''If AllColumnsInOnePagePerSheet is true , all column content of one sheet will output to only one page in result.
        The width of paper size of pagesetup will be ignored, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @all_columns_in_one_page_per_sheet.setter
    def all_columns_in_one_page_per_sheet(self, value : bool) -> None:
        '''If AllColumnsInOnePagePerSheet is true , all column content of one sheet will output to only one page in result.
        The width of paper size of pagesetup will be ignored, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @property
    def ignore_error(self) -> bool:
        '''Indicates if you need to hide the error while rendering.
        The error can be error in shape, image, chart rendering, etc.'''
        raise NotImplementedError()
    
    @ignore_error.setter
    def ignore_error(self, value : bool) -> None:
        '''Indicates if you need to hide the error while rendering.
        The error can be error in shape, image, chart rendering, etc.'''
        raise NotImplementedError()
    
    @property
    def output_blank_page_when_nothing_to_print(self) -> bool:
        '''Indicates whether to output a blank page when there is nothing to print.'''
        raise NotImplementedError()
    
    @output_blank_page_when_nothing_to_print.setter
    def output_blank_page_when_nothing_to_print(self, value : bool) -> None:
        '''Indicates whether to output a blank page when there is nothing to print.'''
        raise NotImplementedError()
    
    @property
    def page_index(self) -> int:
        '''Gets the 0-based index of the first page to save.'''
        raise NotImplementedError()
    
    @page_index.setter
    def page_index(self, value : int) -> None:
        '''Sets the 0-based index of the first page to save.'''
        raise NotImplementedError()
    
    @property
    def page_count(self) -> int:
        '''Gets the number of pages to save.'''
        raise NotImplementedError()
    
    @page_count.setter
    def page_count(self, value : int) -> None:
        '''Sets the number of pages to save.'''
        raise NotImplementedError()
    
    @property
    def printing_page_type(self) -> aspose.cells.PrintingPageType:
        '''Indicates which pages will not be printed.'''
        raise NotImplementedError()
    
    @printing_page_type.setter
    def printing_page_type(self, value : aspose.cells.PrintingPageType) -> None:
        '''Indicates which pages will not be printed.'''
        raise NotImplementedError()
    
    @property
    def gridline_type(self) -> aspose.cells.GridlineType:
        '''Gets gridline type.'''
        raise NotImplementedError()
    
    @gridline_type.setter
    def gridline_type(self, value : aspose.cells.GridlineType) -> None:
        '''Sets gridline type.'''
        raise NotImplementedError()
    
    @property
    def text_cross_type(self) -> aspose.cells.TextCrossType:
        '''Gets displaying text type when the text width is larger than cell width.'''
        raise NotImplementedError()
    
    @text_cross_type.setter
    def text_cross_type(self, value : aspose.cells.TextCrossType) -> None:
        '''Sets displaying text type when the text width is larger than cell width.'''
        raise NotImplementedError()
    
    @property
    def default_edit_language(self) -> aspose.cells.DefaultEditLanguage:
        '''Gets default edit language.'''
        raise NotImplementedError()
    
    @default_edit_language.setter
    def default_edit_language(self, value : aspose.cells.DefaultEditLanguage) -> None:
        '''Sets default edit language.'''
        raise NotImplementedError()
    
    @property
    def sheet_set(self) -> aspose.cells.rendering.SheetSet:
        '''Gets the sheets to render. Default is all visible sheets in the workbook: :py:attr:`aspose.cells.rendering.SheetSet.visible`.'''
        raise NotImplementedError()
    
    @sheet_set.setter
    def sheet_set(self, value : aspose.cells.rendering.SheetSet) -> None:
        '''Sets the sheets to render. Default is all visible sheets in the workbook: :py:attr:`aspose.cells.rendering.SheetSet.visible`.'''
        raise NotImplementedError()
    
    @property
    def draw_object_event_handler(self) -> aspose.cells.rendering.DrawObjectEventHandler:
        '''Implements this interface to get DrawObject and Bound when rendering.'''
        raise NotImplementedError()
    
    @draw_object_event_handler.setter
    def draw_object_event_handler(self, value : aspose.cells.rendering.DrawObjectEventHandler) -> None:
        '''Implements this interface to get DrawObject and Bound when rendering.'''
        raise NotImplementedError()
    
    @property
    def page_saving_callback(self) -> aspose.cells.rendering.IPageSavingCallback:
        '''Control/Indicate progress of page saving process.'''
        raise NotImplementedError()
    
    @page_saving_callback.setter
    def page_saving_callback(self, value : aspose.cells.rendering.IPageSavingCallback) -> None:
        '''Control/Indicate progress of page saving process.'''
        raise NotImplementedError()
    
    @property
    def emf_render_setting(self) -> aspose.cells.EmfRenderSetting:
        '''Setting for rendering Emf metafile.'''
        raise NotImplementedError()
    
    @emf_render_setting.setter
    def emf_render_setting(self, value : aspose.cells.EmfRenderSetting) -> None:
        '''Setting for rendering Emf metafile.'''
        raise NotImplementedError()
    
    @property
    def embed_standard_windows_fonts(self) -> bool:
        '''True to embed true type fonts.
        Affects only ASCII characters 32-127.
        Fonts for character codes greater than 127 are always embedded.
        Fonts are always embedded for PDF/A-1a, PDF/A-1b standard.
        Default is true.'''
        raise NotImplementedError()
    
    @embed_standard_windows_fonts.setter
    def embed_standard_windows_fonts(self, value : bool) -> None:
        '''True to embed true type fonts.
        Affects only ASCII characters 32-127.
        Fonts for character codes greater than 127 are always embedded.
        Fonts are always embedded for PDF/A-1a, PDF/A-1b standard.
        Default is true.'''
        raise NotImplementedError()
    
    @property
    def bookmark(self) -> aspose.cells.rendering.PdfBookmarkEntry:
        '''Gets and sets the :py:class:`aspose.cells.rendering.PdfBookmarkEntry` object.'''
        raise NotImplementedError()
    
    @bookmark.setter
    def bookmark(self, value : aspose.cells.rendering.PdfBookmarkEntry) -> None:
        '''Gets and sets the :py:class:`aspose.cells.rendering.PdfBookmarkEntry` object.'''
        raise NotImplementedError()
    
    @property
    def compliance(self) -> aspose.cells.rendering.PdfCompliance:
        '''Gets the PDF standards compliance level for output documents.'''
        raise NotImplementedError()
    
    @compliance.setter
    def compliance(self, value : aspose.cells.rendering.PdfCompliance) -> None:
        '''Sets the PDF standards compliance level for output documents.'''
        raise NotImplementedError()
    
    @property
    def security_options(self) -> aspose.cells.rendering.pdfsecurity.PdfSecurityOptions:
        '''Set this options, when security is need in xls2pdf result.'''
        raise NotImplementedError()
    
    @security_options.setter
    def security_options(self, value : aspose.cells.rendering.pdfsecurity.PdfSecurityOptions) -> None:
        '''Set this options, when security is need in xls2pdf result.'''
        raise NotImplementedError()
    
    @property
    def image_type(self) -> aspose.cells.drawing.ImageType:
        '''Represents the image type when converting the chart and shape .'''
        raise NotImplementedError()
    
    @image_type.setter
    def image_type(self, value : aspose.cells.drawing.ImageType) -> None:
        '''Represents the image type when converting the chart and shape .'''
        raise NotImplementedError()
    
    @property
    def calculate_formula(self) -> bool:
        '''Indicates whether to calculate formulas before saving pdf file.'''
        raise NotImplementedError()
    
    @calculate_formula.setter
    def calculate_formula(self, value : bool) -> None:
        '''Indicates whether to calculate formulas before saving pdf file.'''
        raise NotImplementedError()
    
    @property
    def pdf_compression(self) -> aspose.cells.rendering.PdfCompressionCore:
        '''Indicate the compression algorithm'''
        raise NotImplementedError()
    
    @pdf_compression.setter
    def pdf_compression(self, value : aspose.cells.rendering.PdfCompressionCore) -> None:
        '''Indicate the compression algorithm'''
        raise NotImplementedError()
    
    @property
    def created_time(self) -> datetime:
        '''Gets and sets the time of generating the pdf document.'''
        raise NotImplementedError()
    
    @created_time.setter
    def created_time(self, value : datetime) -> None:
        '''Gets and sets the time of generating the pdf document.'''
        raise NotImplementedError()
    
    @property
    def producer(self) -> str:
        '''Gets and sets producer of generated pdf document.'''
        raise NotImplementedError()
    
    @producer.setter
    def producer(self, value : str) -> None:
        '''Gets and sets producer of generated pdf document.'''
        raise NotImplementedError()
    
    @property
    def optimization_type(self) -> aspose.cells.rendering.PdfOptimizationType:
        '''Gets and sets pdf optimization type.'''
        raise NotImplementedError()
    
    @optimization_type.setter
    def optimization_type(self, value : aspose.cells.rendering.PdfOptimizationType) -> None:
        '''Gets and sets pdf optimization type.'''
        raise NotImplementedError()
    
    @property
    def custom_properties_export(self) -> aspose.cells.rendering.PdfCustomPropertiesExport:
        '''Gets a value determining the way :py:class:`aspose.cells.properties.CustomDocumentPropertyCollection` are exported to PDF file. Default value is None.'''
        raise NotImplementedError()
    
    @custom_properties_export.setter
    def custom_properties_export(self, value : aspose.cells.rendering.PdfCustomPropertiesExport) -> None:
        '''Sets a value determining the way :py:class:`aspose.cells.properties.CustomDocumentPropertyCollection` are exported to PDF file. Default value is None.'''
        raise NotImplementedError()
    
    @property
    def export_document_structure(self) -> bool:
        '''Indicates whether to export document structure.'''
        raise NotImplementedError()
    
    @export_document_structure.setter
    def export_document_structure(self, value : bool) -> None:
        '''Indicates whether to export document structure.'''
        raise NotImplementedError()
    
    @property
    def display_doc_title(self) -> bool:
        '''Indicates whether the window\'s title bar should display the document title.'''
        raise NotImplementedError()
    
    @display_doc_title.setter
    def display_doc_title(self, value : bool) -> None:
        '''Indicates whether the window\'s title bar should display the document title.'''
        raise NotImplementedError()
    
    @property
    def font_encoding(self) -> aspose.cells.rendering.PdfFontEncoding:
        '''Gets embedded font encoding in pdf.'''
        raise NotImplementedError()
    
    @font_encoding.setter
    def font_encoding(self, value : aspose.cells.rendering.PdfFontEncoding) -> None:
        '''Sets embedded font encoding in pdf.'''
        raise NotImplementedError()
    
    @property
    def watermark(self) -> aspose.cells.rendering.RenderingWatermark:
        '''Gets watermark to output.'''
        raise NotImplementedError()
    
    @watermark.setter
    def watermark(self, value : aspose.cells.rendering.RenderingWatermark) -> None:
        '''Sets watermark to output.'''
        raise NotImplementedError()
    
    @property
    def embed_attachments(self) -> bool:
        raise NotImplementedError()
    
    @embed_attachments.setter
    def embed_attachments(self, value : bool) -> None:
        raise NotImplementedError()
    

class PptxSaveOptions(PaginatedSaveOptions):
    '''Represents the pptx save options.'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def default_font(self) -> str:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set the DefaultFont such as MingLiu or MS Gothic to show these characters.
        If this property is not set, Aspose.Cells will use system default font to show these unicode characters.'''
        raise NotImplementedError()
    
    @default_font.setter
    def default_font(self, value : str) -> None:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set the DefaultFont such as MingLiu or MS Gothic to show these characters.
        If this property is not set, Aspose.Cells will use system default font to show these unicode characters.'''
        raise NotImplementedError()
    
    @property
    def check_workbook_default_font(self) -> bool:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set this to true to try to use workbook\'s default font to show these characters first.'''
        raise NotImplementedError()
    
    @check_workbook_default_font.setter
    def check_workbook_default_font(self, value : bool) -> None:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set this to true to try to use workbook\'s default font to show these characters first.'''
        raise NotImplementedError()
    
    @property
    def check_font_compatibility(self) -> bool:
        '''Indicates whether to check font compatibility for every character in text.'''
        raise NotImplementedError()
    
    @check_font_compatibility.setter
    def check_font_compatibility(self, value : bool) -> None:
        '''Indicates whether to check font compatibility for every character in text.'''
        raise NotImplementedError()
    
    @property
    def is_font_substitution_char_granularity(self) -> bool:
        '''Indicates whether to only substitute the font of character when the cell font is not compatibility for it.'''
        raise NotImplementedError()
    
    @is_font_substitution_char_granularity.setter
    def is_font_substitution_char_granularity(self, value : bool) -> None:
        '''Indicates whether to only substitute the font of character when the cell font is not compatibility for it.'''
        raise NotImplementedError()
    
    @property
    def one_page_per_sheet(self) -> bool:
        '''If OnePagePerSheet is true , all content of one sheet will output to only one page in result.
        The paper size of pagesetup will be invalid, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @one_page_per_sheet.setter
    def one_page_per_sheet(self, value : bool) -> None:
        '''If OnePagePerSheet is true , all content of one sheet will output to only one page in result.
        The paper size of pagesetup will be invalid, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @property
    def all_columns_in_one_page_per_sheet(self) -> bool:
        '''If AllColumnsInOnePagePerSheet is true , all column content of one sheet will output to only one page in result.
        The width of paper size of pagesetup will be ignored, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @all_columns_in_one_page_per_sheet.setter
    def all_columns_in_one_page_per_sheet(self, value : bool) -> None:
        '''If AllColumnsInOnePagePerSheet is true , all column content of one sheet will output to only one page in result.
        The width of paper size of pagesetup will be ignored, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @property
    def ignore_error(self) -> bool:
        '''Indicates if you need to hide the error while rendering.
        The error can be error in shape, image, chart rendering, etc.'''
        raise NotImplementedError()
    
    @ignore_error.setter
    def ignore_error(self, value : bool) -> None:
        '''Indicates if you need to hide the error while rendering.
        The error can be error in shape, image, chart rendering, etc.'''
        raise NotImplementedError()
    
    @property
    def output_blank_page_when_nothing_to_print(self) -> bool:
        '''Indicates whether to output a blank page when there is nothing to print.'''
        raise NotImplementedError()
    
    @output_blank_page_when_nothing_to_print.setter
    def output_blank_page_when_nothing_to_print(self, value : bool) -> None:
        '''Indicates whether to output a blank page when there is nothing to print.'''
        raise NotImplementedError()
    
    @property
    def page_index(self) -> int:
        '''Gets the 0-based index of the first page to save.'''
        raise NotImplementedError()
    
    @page_index.setter
    def page_index(self, value : int) -> None:
        '''Sets the 0-based index of the first page to save.'''
        raise NotImplementedError()
    
    @property
    def page_count(self) -> int:
        '''Gets the number of pages to save.'''
        raise NotImplementedError()
    
    @page_count.setter
    def page_count(self, value : int) -> None:
        '''Sets the number of pages to save.'''
        raise NotImplementedError()
    
    @property
    def printing_page_type(self) -> aspose.cells.PrintingPageType:
        '''Indicates which pages will not be printed.'''
        raise NotImplementedError()
    
    @printing_page_type.setter
    def printing_page_type(self, value : aspose.cells.PrintingPageType) -> None:
        '''Indicates which pages will not be printed.'''
        raise NotImplementedError()
    
    @property
    def gridline_type(self) -> aspose.cells.GridlineType:
        '''Gets gridline type.'''
        raise NotImplementedError()
    
    @gridline_type.setter
    def gridline_type(self, value : aspose.cells.GridlineType) -> None:
        '''Sets gridline type.'''
        raise NotImplementedError()
    
    @property
    def text_cross_type(self) -> aspose.cells.TextCrossType:
        '''Gets displaying text type when the text width is larger than cell width.'''
        raise NotImplementedError()
    
    @text_cross_type.setter
    def text_cross_type(self, value : aspose.cells.TextCrossType) -> None:
        '''Sets displaying text type when the text width is larger than cell width.'''
        raise NotImplementedError()
    
    @property
    def default_edit_language(self) -> aspose.cells.DefaultEditLanguage:
        '''Gets default edit language.'''
        raise NotImplementedError()
    
    @default_edit_language.setter
    def default_edit_language(self, value : aspose.cells.DefaultEditLanguage) -> None:
        '''Sets default edit language.'''
        raise NotImplementedError()
    
    @property
    def sheet_set(self) -> aspose.cells.rendering.SheetSet:
        '''Gets the sheets to render. Default is all visible sheets in the workbook: :py:attr:`aspose.cells.rendering.SheetSet.visible`.'''
        raise NotImplementedError()
    
    @sheet_set.setter
    def sheet_set(self, value : aspose.cells.rendering.SheetSet) -> None:
        '''Sets the sheets to render. Default is all visible sheets in the workbook: :py:attr:`aspose.cells.rendering.SheetSet.visible`.'''
        raise NotImplementedError()
    
    @property
    def draw_object_event_handler(self) -> aspose.cells.rendering.DrawObjectEventHandler:
        '''Implements this interface to get DrawObject and Bound when rendering.'''
        raise NotImplementedError()
    
    @draw_object_event_handler.setter
    def draw_object_event_handler(self, value : aspose.cells.rendering.DrawObjectEventHandler) -> None:
        '''Implements this interface to get DrawObject and Bound when rendering.'''
        raise NotImplementedError()
    
    @property
    def page_saving_callback(self) -> aspose.cells.rendering.IPageSavingCallback:
        '''Control/Indicate progress of page saving process.'''
        raise NotImplementedError()
    
    @page_saving_callback.setter
    def page_saving_callback(self, value : aspose.cells.rendering.IPageSavingCallback) -> None:
        '''Control/Indicate progress of page saving process.'''
        raise NotImplementedError()
    
    @property
    def emf_render_setting(self) -> aspose.cells.EmfRenderSetting:
        '''Setting for rendering Emf metafile.'''
        raise NotImplementedError()
    
    @emf_render_setting.setter
    def emf_render_setting(self, value : aspose.cells.EmfRenderSetting) -> None:
        '''Setting for rendering Emf metafile.'''
        raise NotImplementedError()
    
    @property
    def ignore_hidden_rows(self) -> bool:
        '''Inidicates whether ignoring hidden rows when converting Excel to PowerPoint.'''
        raise NotImplementedError()
    
    @ignore_hidden_rows.setter
    def ignore_hidden_rows(self, value : bool) -> None:
        '''Inidicates whether ignoring hidden rows when converting Excel to PowerPoint.'''
        raise NotImplementedError()
    
    @property
    def adjust_font_size_for_row_type(self) -> aspose.cells.slides.AdjustFontSizeForRowType:
        '''Represents what type of line needs to be adjusted size of font if height of row is small.'''
        raise NotImplementedError()
    
    @adjust_font_size_for_row_type.setter
    def adjust_font_size_for_row_type(self, value : aspose.cells.slides.AdjustFontSizeForRowType) -> None:
        '''Represents what type of line needs to be adjusted size of font if height of row is small.'''
        raise NotImplementedError()
    
    @property
    def export_view_type(self) -> aspose.cells.slides.SlideViewType:
        '''Gets and sets the display type when exporting to PowerPoint.
        The default exporting type is working as printing.'''
        raise NotImplementedError()
    
    @export_view_type.setter
    def export_view_type(self, value : aspose.cells.slides.SlideViewType) -> None:
        '''Gets and sets the display type when exporting to PowerPoint.
        The default exporting type is working as printing.'''
        raise NotImplementedError()
    

class ProtectedRange:
    '''A specified range to be allowed to edit when the sheet protection is ON.'''
    
    def get_areas(self) -> List[aspose.cells.CellArea]:
        '''Gets all referred areas.
        
        :returns: Returns all referred areas.'''
        raise NotImplementedError()
    
    def add_area(self, start_row : int, start_column : int, end_row : int, end_column : int) -> None:
        '''Adds a referred area to this
        
        :param start_row: The start row.
        :param start_column: The start column.
        :param end_row: The end row.
        :param end_column: The end column.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets the Range title. This is used as a descriptor, not as a named range definition.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets the Range title. This is used as a descriptor, not as a named range definition.'''
        raise NotImplementedError()
    
    @property
    def cell_area(self) -> aspose.cells.CellArea:
        '''Gets the :py:attr:`aspose.cells.ProtectedRange.cell_area` object represents the cell area to be protected.'''
        raise NotImplementedError()
    
    @property
    def is_protected_with_password(self) -> bool:
        '''Indicates whether the worksheets is protected with password.'''
        raise NotImplementedError()
    
    @property
    def password(self) -> str:
        '''Represents the password to protect the range.'''
        raise NotImplementedError()
    
    @password.setter
    def password(self, value : str) -> None:
        '''Represents the password to protect the range.'''
        raise NotImplementedError()
    
    @property
    def security_descriptor(self) -> str:
        '''The security descriptor defines user accounts who may edit this range without providing a password to access the range.'''
        raise NotImplementedError()
    
    @security_descriptor.setter
    def security_descriptor(self, value : str) -> None:
        '''The security descriptor defines user accounts who may edit this range without providing a password to access the range.'''
        raise NotImplementedError()
    

class ProtectedRangeCollection:
    '''Encapsulates a collection of :py:class:`aspose.cells.ProtectedRange` objects.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.ProtectedRange]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.ProtectedRange], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.ProtectedRange, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.ProtectedRange, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ProtectedRange) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ProtectedRange, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ProtectedRange, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def add(self, name : str, start_row : int, start_column : int, end_row : int, end_column : int) -> int:
        '''Adds a :py:class:`aspose.cells.ProtectedRange` item to the collection.
        
        :param name: Range title. This is used as a descriptor, not as a named range definition.
        :param start_row: Start row index of the range.
        :param start_column: Start column index of the range.
        :param end_row: End row index of the range.
        :param end_column: End column index of the range.
        :returns: object index.'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.ProtectedRange) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class Protection:
    '''Represents the various types of protection options available for a worksheet.'''
    
    def copy(self, source : aspose.cells.Protection) -> None:
        '''Copy protection info.'''
        raise NotImplementedError()
    
    def get_password_hash(self) -> int:
        '''Gets the hash of current password.'''
        raise NotImplementedError()
    
    def verify_password(self, password : str) -> bool:
        '''Verifies password.
        
        :param password: The password.'''
        raise NotImplementedError()
    
    @property
    def allow_deleting_column(self) -> bool:
        '''Represents if the deletion of columns is allowed on a protected worksheet.'''
        raise NotImplementedError()
    
    @allow_deleting_column.setter
    def allow_deleting_column(self, value : bool) -> None:
        '''Represents if the deletion of columns is allowed on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def is_deleting_columns_allowed(self) -> bool:
        '''Represents if the deletion of columns is allowed on a protected worksheet.'''
        raise NotImplementedError()
    
    @is_deleting_columns_allowed.setter
    def is_deleting_columns_allowed(self, value : bool) -> None:
        '''Represents if the deletion of columns is allowed on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def allow_deleting_row(self) -> bool:
        '''Represents if the deletion of rows is allowed on a protected worksheet.'''
        raise NotImplementedError()
    
    @allow_deleting_row.setter
    def allow_deleting_row(self, value : bool) -> None:
        '''Represents if the deletion of rows is allowed on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def is_deleting_rows_allowed(self) -> bool:
        '''Represents if the deletion of rows is allowed on a protected worksheet.'''
        raise NotImplementedError()
    
    @is_deleting_rows_allowed.setter
    def is_deleting_rows_allowed(self, value : bool) -> None:
        '''Represents if the deletion of rows is allowed on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def allow_filtering(self) -> bool:
        '''Represents if the user is allowed to make use of an AutoFilter that was created before the sheet was protected.'''
        raise NotImplementedError()
    
    @allow_filtering.setter
    def allow_filtering(self, value : bool) -> None:
        '''Represents if the user is allowed to make use of an AutoFilter that was created before the sheet was protected.'''
        raise NotImplementedError()
    
    @property
    def is_filtering_allowed(self) -> bool:
        '''Represents if the user is allowed to make use of an AutoFilter that was created before the sheet was protected.'''
        raise NotImplementedError()
    
    @is_filtering_allowed.setter
    def is_filtering_allowed(self, value : bool) -> None:
        '''Represents if the user is allowed to make use of an AutoFilter that was created before the sheet was protected.'''
        raise NotImplementedError()
    
    @property
    def allow_formatting_cell(self) -> bool:
        '''Represents if the formatting of cells is allowed on a protected worksheet.'''
        raise NotImplementedError()
    
    @allow_formatting_cell.setter
    def allow_formatting_cell(self, value : bool) -> None:
        '''Represents if the formatting of cells is allowed on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def is_formatting_cells_allowed(self) -> bool:
        '''Represents if the formatting of cells is allowed on a protected worksheet.'''
        raise NotImplementedError()
    
    @is_formatting_cells_allowed.setter
    def is_formatting_cells_allowed(self, value : bool) -> None:
        '''Represents if the formatting of cells is allowed on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def allow_formatting_column(self) -> bool:
        '''Represents if the formatting of columns is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @allow_formatting_column.setter
    def allow_formatting_column(self, value : bool) -> None:
        '''Represents if the formatting of columns is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @property
    def is_formatting_columns_allowed(self) -> bool:
        '''Represents if the formatting of columns is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @is_formatting_columns_allowed.setter
    def is_formatting_columns_allowed(self, value : bool) -> None:
        '''Represents if the formatting of columns is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @property
    def allow_formatting_row(self) -> bool:
        '''Represents if the formatting of rows is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @allow_formatting_row.setter
    def allow_formatting_row(self, value : bool) -> None:
        '''Represents if the formatting of rows is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @property
    def is_formatting_rows_allowed(self) -> bool:
        '''Represents if the formatting of rows is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @is_formatting_rows_allowed.setter
    def is_formatting_rows_allowed(self, value : bool) -> None:
        '''Represents if the formatting of rows is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @property
    def allow_inserting_column(self) -> bool:
        '''Represents if the insertion of columns is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @allow_inserting_column.setter
    def allow_inserting_column(self, value : bool) -> None:
        '''Represents if the insertion of columns is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @property
    def is_inserting_columns_allowed(self) -> bool:
        '''Represents if the insertion of columns is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @is_inserting_columns_allowed.setter
    def is_inserting_columns_allowed(self, value : bool) -> None:
        '''Represents if the insertion of columns is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @property
    def allow_inserting_hyperlink(self) -> bool:
        '''Represents if the insertion of hyperlinks is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @allow_inserting_hyperlink.setter
    def allow_inserting_hyperlink(self, value : bool) -> None:
        '''Represents if the insertion of hyperlinks is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @property
    def is_inserting_hyperlinks_allowed(self) -> bool:
        '''Represents if the insertion of hyperlinks is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @is_inserting_hyperlinks_allowed.setter
    def is_inserting_hyperlinks_allowed(self, value : bool) -> None:
        '''Represents if the insertion of hyperlinks is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @property
    def allow_inserting_row(self) -> bool:
        '''Represents if the insertion of rows is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @allow_inserting_row.setter
    def allow_inserting_row(self, value : bool) -> None:
        '''Represents if the insertion of rows is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @property
    def is_inserting_rows_allowed(self) -> bool:
        '''Represents if the insertion of rows is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @is_inserting_rows_allowed.setter
    def is_inserting_rows_allowed(self, value : bool) -> None:
        '''Represents if the insertion of rows is allowed on a protected worksheet'''
        raise NotImplementedError()
    
    @property
    def allow_sorting(self) -> bool:
        '''Represents if the sorting option is allowed on a protected worksheet.'''
        raise NotImplementedError()
    
    @allow_sorting.setter
    def allow_sorting(self, value : bool) -> None:
        '''Represents if the sorting option is allowed on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def is_sorting_allowed(self) -> bool:
        '''Represents if the sorting option is allowed on a protected worksheet.'''
        raise NotImplementedError()
    
    @is_sorting_allowed.setter
    def is_sorting_allowed(self, value : bool) -> None:
        '''Represents if the sorting option is allowed on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def allow_using_pivot_table(self) -> bool:
        '''Represents if the user is allowed to manipulate pivot tables on a protected worksheet.'''
        raise NotImplementedError()
    
    @allow_using_pivot_table.setter
    def allow_using_pivot_table(self, value : bool) -> None:
        '''Represents if the user is allowed to manipulate pivot tables on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def is_using_pivot_tables_allowed(self) -> bool:
        '''Represents if the user is allowed to manipulate pivot tables on a protected worksheet.'''
        raise NotImplementedError()
    
    @is_using_pivot_tables_allowed.setter
    def is_using_pivot_tables_allowed(self, value : bool) -> None:
        '''Represents if the user is allowed to manipulate pivot tables on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def allow_editing_content(self) -> bool:
        '''Represents if the user is allowed to edit contents of locked cells on a protected worksheet.'''
        raise NotImplementedError()
    
    @allow_editing_content.setter
    def allow_editing_content(self, value : bool) -> None:
        '''Represents if the user is allowed to edit contents of locked cells on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def is_editing_contents_allowed(self) -> bool:
        '''Represents if the user is allowed to edit contents of locked cells on a protected worksheet.'''
        raise NotImplementedError()
    
    @is_editing_contents_allowed.setter
    def is_editing_contents_allowed(self, value : bool) -> None:
        '''Represents if the user is allowed to edit contents of locked cells on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def allow_editing_object(self) -> bool:
        '''Represents if the user is allowed to manipulate drawing objects on a protected worksheet.'''
        raise NotImplementedError()
    
    @allow_editing_object.setter
    def allow_editing_object(self, value : bool) -> None:
        '''Represents if the user is allowed to manipulate drawing objects on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def is_editing_objects_allowed(self) -> bool:
        '''Represents if the user is allowed to manipulate drawing objects on a protected worksheet.'''
        raise NotImplementedError()
    
    @is_editing_objects_allowed.setter
    def is_editing_objects_allowed(self, value : bool) -> None:
        '''Represents if the user is allowed to manipulate drawing objects on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def allow_editing_scenario(self) -> bool:
        '''Represents if the user is allowed to edit scenarios on a protected worksheet.'''
        raise NotImplementedError()
    
    @allow_editing_scenario.setter
    def allow_editing_scenario(self, value : bool) -> None:
        '''Represents if the user is allowed to edit scenarios on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def is_editing_scenarios_allowed(self) -> bool:
        '''Represents if the user is allowed to edit scenarios on a protected worksheet.'''
        raise NotImplementedError()
    
    @is_editing_scenarios_allowed.setter
    def is_editing_scenarios_allowed(self, value : bool) -> None:
        '''Represents if the user is allowed to edit scenarios on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def password(self) -> str:
        '''Represents the password to protect the worksheet.'''
        raise NotImplementedError()
    
    @password.setter
    def password(self, value : str) -> None:
        '''Represents the password to protect the worksheet.'''
        raise NotImplementedError()
    
    @property
    def is_protected_with_password(self) -> bool:
        '''Indicates whether the worksheets is protected with password.'''
        raise NotImplementedError()
    
    @property
    def allow_selecting_locked_cell(self) -> bool:
        '''Represents if the user is allowed to select locked cells on a protected worksheet.'''
        raise NotImplementedError()
    
    @allow_selecting_locked_cell.setter
    def allow_selecting_locked_cell(self, value : bool) -> None:
        '''Represents if the user is allowed to select locked cells on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def is_selecting_locked_cells_allowed(self) -> bool:
        '''Represents if the user is allowed to select locked cells on a protected worksheet.'''
        raise NotImplementedError()
    
    @is_selecting_locked_cells_allowed.setter
    def is_selecting_locked_cells_allowed(self, value : bool) -> None:
        '''Represents if the user is allowed to select locked cells on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def allow_selecting_unlocked_cell(self) -> bool:
        '''Represents if the user is allowed to select unlocked cells on a protected worksheet.'''
        raise NotImplementedError()
    
    @allow_selecting_unlocked_cell.setter
    def allow_selecting_unlocked_cell(self, value : bool) -> None:
        '''Represents if the user is allowed to select unlocked cells on a protected worksheet.'''
        raise NotImplementedError()
    
    @property
    def is_selecting_unlocked_cells_allowed(self) -> bool:
        '''Represents if the user is allowed to select unlocked cells on a protected worksheet.'''
        raise NotImplementedError()
    
    @is_selecting_unlocked_cells_allowed.setter
    def is_selecting_unlocked_cells_allowed(self, value : bool) -> None:
        '''Represents if the user is allowed to select unlocked cells on a protected worksheet.'''
        raise NotImplementedError()
    

class QueryTable:
    '''Represents QueryTable information.'''
    
    @property
    def connection_id(self) -> int:
        '''Gets the connection id of the query table.'''
        raise NotImplementedError()
    
    @property
    def external_connection(self) -> aspose.cells.externalconnections.ExternalConnection:
        '''Gets the relate external connection.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets the name of querytable.'''
        raise NotImplementedError()
    
    @property
    def result_range(self) -> aspose.cells.Range:
        '''Gets the range of the result.'''
        raise NotImplementedError()
    
    @property
    def preserve_formatting(self) -> bool:
        '''Returns the PreserveFormatting of the object.'''
        raise NotImplementedError()
    
    @preserve_formatting.setter
    def preserve_formatting(self, value : bool) -> None:
        '''Returns or sets the PreserveFormatting of the object.'''
        raise NotImplementedError()
    
    @property
    def adjust_column_width(self) -> bool:
        '''Returns the AdjustColumnWidth of the object.'''
        raise NotImplementedError()
    
    @adjust_column_width.setter
    def adjust_column_width(self, value : bool) -> None:
        '''Returns or sets the AdjustColumnWidth of the object.'''
        raise NotImplementedError()
    

class QueryTableCollection:
    '''A collection of :py:class:`aspose.cells.QueryTableCollection` objects that represent QueryTable collection information.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.QueryTable]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.QueryTable], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.QueryTable, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.QueryTable, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.QueryTable) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.QueryTable, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.QueryTable, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.QueryTable) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class Range:
    '''Encapsulates the object that represents a range of cells within a spreadsheet.'''
    
    @overload
    def auto_fill(self, target : aspose.cells.Range) -> None:
        '''Automaticall fill the target range.
        
        :param target: the target range.'''
        raise NotImplementedError()
    
    @overload
    def auto_fill(self, target : aspose.cells.Range, auto_fill_type : aspose.cells.AutoFillType) -> None:
        '''Automaticall fill the target range.
        
        :param target: The targed range.
        :param auto_fill_type: The auto fill type.'''
        raise NotImplementedError()
    
    @overload
    def set_style(self, style : aspose.cells.Style, explicit_flag : bool) -> None:
        '''Apply the cell style.
        
        :param style: The cell style.
        :param explicit_flag: True, only overwriting formatting which is explicitly set.'''
        raise NotImplementedError()
    
    @overload
    def set_style(self, style : aspose.cells.Style) -> None:
        '''Sets the style of the range.
        
        :param style: The Style object.'''
        raise NotImplementedError()
    
    @overload
    def set_outline_borders(self, border_style : aspose.cells.CellBorderType, border_color : aspose.cells.CellsColor) -> None:
        '''Sets the outline borders around a range of cells with same border style and color.
        
        :param border_style: Border style.
        :param border_color: Border color.'''
        raise NotImplementedError()
    
    @overload
    def set_outline_borders(self, border_style : aspose.cells.CellBorderType, border_color : aspose.pydrawing.Color) -> None:
        '''Sets the outline borders around a range of cells with same border style and color.
        
        :param border_style: Border style.
        :param border_color: Border color.'''
        raise NotImplementedError()
    
    @overload
    def set_outline_borders(self, border_styles : List[aspose.cells.CellBorderType], border_colors : List[aspose.pydrawing.Color]) -> None:
        '''Sets out line borders around a range of cells.
        
        :param border_styles: Border styles.
        :param border_colors: Border colors.'''
        raise NotImplementedError()
    
    @overload
    def set_outline_border(self, border_edge : aspose.cells.BorderType, border_style : aspose.cells.CellBorderType, border_color : aspose.cells.CellsColor) -> None:
        '''Sets outline border around a range of cells.
        
        :param border_edge: Border edge.
        :param border_style: Border style.
        :param border_color: Border color.'''
        raise NotImplementedError()
    
    @overload
    def set_outline_border(self, border_edge : aspose.cells.BorderType, border_style : aspose.cells.CellBorderType, border_color : aspose.pydrawing.Color) -> None:
        '''Sets outline border around a range of cells.
        
        :param border_edge: Border edge.
        :param border_style: Border style.
        :param border_color: Border color.'''
        raise NotImplementedError()
    
    @overload
    def copy(self, range : aspose.cells.Range, options : aspose.cells.PasteOptions) -> None:
        '''Copying the range with paste special options.
        
        :param range: The source range.
        :param options: The paste special options.'''
        raise NotImplementedError()
    
    @overload
    def copy(self, range : aspose.cells.Range) -> None:
        '''Copies data (including formulas), formatting, drawing objects etc. from a source range.
        
        :param range: Source :py:class:`aspose.cells.Range` object.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str, text_to_display : str, screen_tip : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to a specified cell or a range of cells.
        
        :param address: Address of the hyperlink.
        :param text_to_display: The text to be displayed for the specified hyperlink.
        :param screen_tip: The screenTip text for the specified hyperlink.
        :returns: :py:class:`aspose.cells.Hyperlink` object.'''
        raise NotImplementedError()
    
    def get_enumerator(self) -> collections.abc.Iterator[Any]:
        '''Gets the enumerator for cells in this Range.
        
        :returns: The cells enumerator'''
        raise NotImplementedError()
    
    def is_intersect(self, range : aspose.cells.Range) -> bool:
        '''Indicates whether the range is intersect.
        
        :param range: The range.
        :returns: Whether the range is intersect.'''
        raise NotImplementedError()
    
    def intersect(self, range : aspose.cells.Range) -> aspose.cells.Range:
        '''Returns a :py:class:`aspose.cells.Range` object that represents the rectangular intersection of two ranges.
        
        :param range: The intersecting range.
        :returns: Returns a :py:class:`aspose.cells.Range` object'''
        raise NotImplementedError()
    
    def union_rang(self, range : aspose.cells.Range) -> List[aspose.cells.Range]:
        '''Returns the union result of two ranges.
        
        :param range: The range
        :returns: The union of two ranges.'''
        raise NotImplementedError()
    
    def union_ranges(self, ranges : List[aspose.cells.Range]) -> aspose.cells.UnionRange:
        raise NotImplementedError()
    
    def union(self, range : aspose.cells.Range) -> List[Any]:
        '''Returns the union of two ranges.
        
        :param range: The range
        :returns: The union of two ranges.'''
        raise NotImplementedError()
    
    def is_blank(self) -> bool:
        '''Indicates whether the range contains values.'''
        raise NotImplementedError()
    
    def merge(self) -> None:
        '''Combines a range of cells into a single cell.'''
        raise NotImplementedError()
    
    def un_merge(self) -> None:
        '''Unmerges merged cells of this range.'''
        raise NotImplementedError()
    
    def put_value(self, string_value : str, is_converted : bool, set_style : bool) -> None:
        '''Puts a value into the range, if appropriate the value will be converted to other data type and cell\'s number format will be reset.
        
        :param string_value: Input value
        :param is_converted: True: converted to other data type if appropriate.
        :param set_style: True: set the number format to cell\'s style when converting to other data type'''
        raise NotImplementedError()
    
    def apply_style(self, style : aspose.cells.Style, flag : aspose.cells.StyleFlag) -> None:
        '''Applies formats for a whole range.
        
        :param style: The style object which will be applied.
        :param flag: Flags which indicates applied formatting properties.'''
        raise NotImplementedError()
    
    def set_inside_borders(self, border_edge : aspose.cells.BorderType, line_style : aspose.cells.CellBorderType, border_color : aspose.cells.CellsColor) -> None:
        '''Set inside borders of the range.
        
        :param border_edge: Inside borde type, only can be :py:attr:`aspose.cells.BorderType.VERTICAL` and :py:attr:`aspose.cells.BorderType.HORIZONTAL`.
        :param line_style: The border style.
        :param border_color: The color of the border.'''
        raise NotImplementedError()
    
    def move_to(self, dest_row : int, dest_column : int) -> None:
        '''Move the current range to the dest range.
        
        :param dest_row: The start row of the dest range.
        :param dest_column: The start column of the dest range.'''
        raise NotImplementedError()
    
    def copy_data(self, range : aspose.cells.Range) -> None:
        '''Copies cell data (including formulas) from a source range.
        
        :param range: Source :py:class:`aspose.cells.Range` object.'''
        raise NotImplementedError()
    
    def copy_value(self, range : aspose.cells.Range) -> None:
        '''Copies cell value from a source range.
        
        :param range: Source :py:class:`aspose.cells.Range` object.'''
        raise NotImplementedError()
    
    def copy_style(self, range : aspose.cells.Range) -> None:
        '''Copies style settings from a source range.
        
        :param range: Source :py:class:`aspose.cells.Range` object.'''
        raise NotImplementedError()
    
    def transpose(self) -> None:
        raise NotImplementedError()
    
    def get(self, row_offset : int, column_offset : int) -> aspose.cells.Cell:
        raise NotImplementedError()
    
    def get_cell_or_null(self, row_offset : int, column_offset : int) -> aspose.cells.Cell:
        '''Gets :py:class:`aspose.cells.Cell` object or null in this range.
        
        :param row_offset: Row offset in this range, zero based.
        :param column_offset: Column offset in this range, zero based.
        :returns: :py:class:`aspose.cells.Cell` object.'''
        raise NotImplementedError()
    
    def get_offset(self, row_offset : int, column_offset : int) -> aspose.cells.Range:
        '''Gets :py:class:`aspose.cells.Range` range by offset.
        
        :param row_offset: Row offset in this range, zero based.
        :param column_offset: Column offset in this range, zero based.'''
        raise NotImplementedError()
    
    def to_image(self, options : aspose.cells.rendering.ImageOrPrintOptions) -> List[int]:
        raise NotImplementedError()
    
    def to_json(self, options : aspose.cells.JsonSaveOptions) -> str:
        raise NotImplementedError()
    
    def to_html(self, save_options : aspose.cells.HtmlSaveOptions) -> List[int]:
        raise NotImplementedError()
    
    @property
    def current_region(self) -> aspose.cells.Range:
        '''Returns a Range object that represents the current region.
        The current region is a range bounded by any combination of blank rows and blank columns.'''
        raise NotImplementedError()
    
    @property
    def hyperlinks(self) -> List[aspose.cells.Hyperlink]:
        '''Gets all hyperlink in the range.'''
        raise NotImplementedError()
    
    @property
    def row_count(self) -> int:
        '''Gets the count of rows in the range.'''
        raise NotImplementedError()
    
    @property
    def column_count(self) -> int:
        '''Gets the count of columns in the range.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets the name of the range.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Sets the name of the range.'''
        raise NotImplementedError()
    
    @property
    def refers_to(self) -> str:
        '''Gets the range\'s refers to.'''
        raise NotImplementedError()
    
    @property
    def address(self) -> str:
        '''Gets address of the range.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> float:
        '''Gets the distance, in points, from the left edge of column A to the left edge of the range.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> float:
        '''Gets the distance, in points, from the top edge of row 1 to the top edge of the range.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> float:
        '''Gets the width of a range in points.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> float:
        '''Gets the width of a range in points.'''
        raise NotImplementedError()
    
    @property
    def first_row(self) -> int:
        '''Gets the index of the first row of the range.'''
        raise NotImplementedError()
    
    @property
    def first_column(self) -> int:
        '''Gets the index of the first column of the range.'''
        raise NotImplementedError()
    
    @property
    def value(self) -> Any:
        '''Gets and sets the value of the range.'''
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : Any) -> None:
        '''Gets and sets the value of the range.'''
        raise NotImplementedError()
    
    @property
    def column_width(self) -> float:
        '''Sets or gets the column width of this range'''
        raise NotImplementedError()
    
    @column_width.setter
    def column_width(self, value : float) -> None:
        '''Sets or gets the column width of this range'''
        raise NotImplementedError()
    
    @property
    def row_height(self) -> float:
        '''Sets or gets the height of rows in this range'''
        raise NotImplementedError()
    
    @row_height.setter
    def row_height(self, value : float) -> None:
        '''Sets or gets the height of rows in this range'''
        raise NotImplementedError()
    
    @property
    def entire_column(self) -> aspose.cells.Range:
        '''Gets a Range object that represents the entire column (or columns) that contains the specified range.'''
        raise NotImplementedError()
    
    @property
    def entire_row(self) -> aspose.cells.Range:
        '''Gets a Range object that represents the entire row (or rows) that contains the specified range.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.Range.worksheet`object which contains this range.'''
        raise NotImplementedError()
    

class RangeCollection:
    '''Encapsulates a collection of :py:class:`aspose.cells.Range` objects.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.Range]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.Range], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Range, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Range, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Range) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Range, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Range, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def add(self, range : aspose.cells.Range) -> int:
        '''Adds a :py:class:`aspose.cells.Range` item to the collection.
        
        :param range: Range object'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.Range) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class ReferredArea:
    '''Represents a referred area by the formula.'''
    
    @overload
    def get_values(self) -> Any:
        '''Gets cell values in this area.
        
        :returns: If this area is invalid, "#REF!" will be returned;
        If this area is one single cell, then return the cell value object;
        Otherwise return one 2D array for all values in this area.'''
        raise NotImplementedError()
    
    @overload
    def get_values(self, calculate_formulas : bool) -> Any:
        '''Gets cell values in this area.
        
        :param calculate_formulas: In this range, if there are some formulas that have not been calculated,
        this flag denotes whether those formulas should be calculated recursively
        :returns: If this area is invalid, "#REF!" will be returned;
        If this area is one single cell, then return the cell value object;
        Otherwise return one 2D array for all values in this area.'''
        raise NotImplementedError()
    
    @overload
    def get_value(self, row_offset : int, col_offset : int) -> Any:
        '''Gets cell value with given offset from the top-left of this area.
        
        :param row_offset: row offset from the start row of this area
        :param col_offset: column offset from the start row of this area
        :returns: "#REF!" if this area is invalid;
        "#N/A" if given offset out of this area;
        Otherwise return the cell value at given position.'''
        raise NotImplementedError()
    
    @overload
    def get_value(self, row_offset : int, col_offset : int, calculate_formulas : bool) -> Any:
        '''Gets cell value with given offset from the top-left of this area.
        
        :param row_offset: row offset from the start row of this area
        :param col_offset: column offset from the start row of this area
        :param calculate_formulas: Whether calculate it recursively if the specified reference is formula
        :returns: "#REF!" if this area is invalid;
        "#N/A" if given offset out of this area;
        Otherwise return the cell value at given position.'''
        raise NotImplementedError()
    
    @property
    def is_external_link(self) -> bool:
        '''Indicates whether this is an external link.'''
        raise NotImplementedError()
    
    @property
    def external_file_name(self) -> str:
        '''Get the external file name if this is an external reference.'''
        raise NotImplementedError()
    
    @property
    def sheet_name(self) -> str:
        '''Indicates which sheet this reference is in.'''
        raise NotImplementedError()
    
    @property
    def is_entire_row(self) -> bool:
        raise NotImplementedError()
    
    @property
    def is_entire_column(self) -> bool:
        raise NotImplementedError()
    
    @property
    def is_area(self) -> bool:
        '''Indicates whether this is an area.'''
        raise NotImplementedError()
    
    @property
    def end_column(self) -> int:
        '''The end column of the area.'''
        raise NotImplementedError()
    
    @property
    def start_column(self) -> int:
        '''The start column of the area.'''
        raise NotImplementedError()
    
    @property
    def end_row(self) -> int:
        '''The end row of the area.'''
        raise NotImplementedError()
    
    @property
    def start_row(self) -> int:
        '''The start row of the area.'''
        raise NotImplementedError()
    

class ReferredAreaCollection:
    '''Represents all referred cells and areas.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.ReferredArea]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.ReferredArea], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.ReferredArea, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.ReferredArea, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ReferredArea) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ReferredArea, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ReferredArea, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.ReferredArea) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class ReplaceOptions:
    '''Represent the replace options.'''
    
    @property
    def case_sensitive(self) -> bool:
        '''Indicates if the searched string is case sensitive.'''
        raise NotImplementedError()
    
    @case_sensitive.setter
    def case_sensitive(self, value : bool) -> None:
        '''Indicates if the searched string is case sensitive.'''
        raise NotImplementedError()
    
    @property
    def match_entire_cell_contents(self) -> bool:
        '''Indicates whether to match entire cells contents'''
        raise NotImplementedError()
    
    @match_entire_cell_contents.setter
    def match_entire_cell_contents(self, value : bool) -> None:
        '''Indicates whether to match entire cells contents'''
        raise NotImplementedError()
    
    @property
    def regex_key(self) -> bool:
        '''Indicates whether the searched key is regex. If true then the searched key will be taken as regex.'''
        raise NotImplementedError()
    
    @regex_key.setter
    def regex_key(self, value : bool) -> None:
        '''Indicates whether the searched key is regex. If true then the searched key will be taken as regex.'''
        raise NotImplementedError()
    
    @property
    def font_settings(self) -> List[aspose.cells.FontSetting]:
        '''The rich formatted settings for the replaced text.'''
        raise NotImplementedError()
    
    @font_settings.setter
    def font_settings(self, value : List[aspose.cells.FontSetting]) -> None:
        '''The rich formatted settings for the replaced text.'''
        raise NotImplementedError()
    

class Row:
    '''Represents a single row in a worksheet.'''
    
    def get_cell_by_index(self, index : int) -> aspose.cells.Cell:
        '''Get the cell by specific index in the cells collection of this row.
        
        :param index: The index(position) of the cell in the cells collection of this row.
        :returns: The Cell object at given position.'''
        raise NotImplementedError()
    
    def get_enumerator(self, reversed : bool, sync : bool) -> collections.abc.Iterator[Any]:
        '''Gets an enumerator that iterates cells through this row.
        
        :param reversed: whether enumerate cells in reversed order
        :param sync: whether the returned enumerator should check the modification of cells in this row
        and keep synchronized with it.
        :returns: The cell enumerator'''
        raise NotImplementedError()
    
    def get_cell_or_null(self, column : int) -> aspose.cells.Cell:
        '''Gets the cell or null in the specific index.
        
        :param column: The column index
        :returns: Returns the cell object if the cell exists.
        Or returns null if the cell object does not exist.'''
        raise NotImplementedError()
    
    def get_style(self) -> aspose.cells.Style:
        '''Gets the style of this row.'''
        raise NotImplementedError()
    
    def set_style(self, style : aspose.cells.Style) -> None:
        '''Sets the style of this row.
        
        :param style: the style to be used as the default style for cells in this row.'''
        raise NotImplementedError()
    
    def copy_settings(self, source : aspose.cells.Row, check_style : bool) -> None:
        '''Copy settings of row, such as style, height, visibility, ...etc.
        
        :param source: the source row whose settings will be copied to this one
        :param check_style: whether check and gather style.
        Only takes effect and be needed when two row objects belong to different workbook and the styles of two workbooks are different.'''
        raise NotImplementedError()
    
    def apply_style(self, style : aspose.cells.Style, flag : aspose.cells.StyleFlag) -> None:
        '''Applies formats for a whole row.
        
        :param style: The style object which will be applied.
        :param flag: Flags which indicates applied formatting properties.'''
        raise NotImplementedError()
    
    def equals(self, row : aspose.cells.Row) -> bool:
        '''Checks whether this object refers to the same row with another row object.
        
        :param row: another row object
        :returns: true if two row objects refers to the same row.'''
        raise NotImplementedError()
    
    @property
    def is_blank(self) -> bool:
        '''Indicates whether the row contains any data'''
        raise NotImplementedError()
    
    @property
    def is_collapsed(self) -> bool:
        '''whether the row is collapsed'''
        raise NotImplementedError()
    
    @is_collapsed.setter
    def is_collapsed(self, value : bool) -> None:
        '''whether the row is collapsed'''
        raise NotImplementedError()
    
    @property
    def height(self) -> float:
        '''Gets and sets the row height in unit of Points.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : float) -> None:
        '''Gets and sets the row height in unit of Points.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the row is hidden.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the row is hidden.'''
        raise NotImplementedError()
    
    @property
    def index(self) -> int:
        '''Gets the index of this row.'''
        raise NotImplementedError()
    
    @property
    def group_level(self) -> int:
        '''Gets the group level of the row.'''
        raise NotImplementedError()
    
    @group_level.setter
    def group_level(self, value : int) -> None:
        '''Gets the group level of the row.'''
        raise NotImplementedError()
    
    @property
    def is_height_matched(self) -> bool:
        '''Indicates whether the row height matches current default font setting of the workbook.
        True of this property also denotes the row height is "automatic" without custom height value set by user.'''
        raise NotImplementedError()
    
    @is_height_matched.setter
    def is_height_matched(self, value : bool) -> None:
        '''Indicates whether the row height matches current default font setting of the workbook.
        True of this property also denotes the row height is "automatic" without custom height value set by user.'''
        raise NotImplementedError()
    
    @property
    def has_custom_style(self) -> bool:
        '''Indicates whether this row has custom style settings(different from the default one inherited from workbook).'''
        raise NotImplementedError()
    
    @property
    def first_cell(self) -> aspose.cells.Cell:
        '''Gets the first cell object in the row.'''
        raise NotImplementedError()
    
    @property
    def first_data_cell(self) -> aspose.cells.Cell:
        '''Gets the first non-blank cell in the row.'''
        raise NotImplementedError()
    
    @property
    def last_cell(self) -> aspose.cells.Cell:
        '''Gets the last cell object in the row.'''
        raise NotImplementedError()
    
    @property
    def last_data_cell(self) -> aspose.cells.Cell:
        '''Gets the last non-blank cell in the row.'''
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.cells.Cell:
        '''Gets the cell.'''
        raise NotImplementedError()
    

class RowCollection:
    '''Collects the :py:class:`aspose.cells.Row` objects that represent the individual rows in a worksheet.'''
    
    def get_enumerator(self, reversed : bool, sync : bool) -> collections.abc.Iterator[Any]:
        '''Gets an enumerator that iterates rows through this collection
        
        :param reversed: whether enumerate rows in reversed order
        :param sync: whether the returned enumerator should check the modification of row collection
        and keep synchronized with it.
        :returns: The row enumerator'''
        raise NotImplementedError()
    
    def get_row_by_index(self, index : int) -> aspose.cells.Row:
        '''Gets the row object by the position in the list.
        
        :param index: The position.
        :returns: The Row object at given position.'''
        raise NotImplementedError()
    
    def clear(self) -> None:
        '''Clear all rows and cells.'''
        raise NotImplementedError()
    
    def remove_at(self, index : int) -> None:
        '''Remove the row item at the specified index(position) in this collection.
        
        :param index: zero-based index(position, not :py:attr:`aspose.cells.Row.index`) of the existing row item in this collection.'''
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        '''Gets the number of rows in this collection.'''
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.cells.Row:
        '''Gets a :py:class:`aspose.cells.Row` object by given row index. The Row object of given row index will be instantiated if it does not exist before.'''
        raise NotImplementedError()
    

class SaveOptions:
    '''Represents all save options'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    

class Scenario:
    '''Represents an individual scenario.'''
    
    @property
    def comment(self) -> str:
        '''Gets and sets the comment of scenario.'''
        raise NotImplementedError()
    
    @comment.setter
    def comment(self, value : str) -> None:
        '''Gets and sets the comment of scenario.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of scenario.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of scenario.'''
        raise NotImplementedError()
    
    @property
    def user(self) -> str:
        '''Gets name of user who last changed the scenario.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether scenario is hidden.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether scenario is hidden.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''Indicates whether scenario is locked for editing when the sheet is protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''Indicates whether scenario is locked for editing when the sheet is protected.'''
        raise NotImplementedError()
    
    @property
    def input_cells(self) -> aspose.cells.ScenarioInputCellCollection:
        '''Gets the input cells of scenario.'''
        raise NotImplementedError()
    

class ScenarioCollection:
    '''Represents the list of scenarios.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.Scenario]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.Scenario], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Scenario, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Scenario, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Scenario) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Scenario, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Scenario, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def add(self, name : str) -> int:
        '''Adds a scenario.
        
        :param name: The name of scenario.
        :returns: The index in the list of scenarios.'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.Scenario) -> int:
        raise NotImplementedError()
    
    @property
    def active_index(self) -> int:
        '''Gets and sets which scenario is selected.'''
        raise NotImplementedError()
    
    @active_index.setter
    def active_index(self, value : int) -> None:
        '''Gets and sets which scenario is selected.'''
        raise NotImplementedError()
    
    @property
    def last_selected(self) -> int:
        '''Indicates which scenario was last selected by the user to be run/shown.'''
        raise NotImplementedError()
    
    @last_selected.setter
    def last_selected(self, value : int) -> None:
        '''Indicates which scenario was last selected by the user to be run/shown.'''
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class ScenarioInputCell:
    '''Represents input cell for the scenario.'''
    
    @property
    def row(self) -> int:
        '''Gets and sets the row index of the input cell.'''
        raise NotImplementedError()
    
    @property
    def column(self) -> int:
        '''Gets and sets the column index of the input cell.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the input cell address.'''
        raise NotImplementedError()
    
    @property
    def value(self) -> str:
        '''Gets and sets value of the input cell.'''
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : str) -> None:
        '''Gets and sets value of the input cell.'''
        raise NotImplementedError()
    
    @property
    def is_deleted(self) -> bool:
        '''Indicates whether input cell is deleted.'''
        raise NotImplementedError()
    
    @is_deleted.setter
    def is_deleted(self, value : bool) -> None:
        '''Indicates whether input cell is deleted.'''
        raise NotImplementedError()
    

class ScenarioInputCellCollection:
    '''Represents the list of the scenario\'s input cells.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.ScenarioInputCell]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.ScenarioInputCell], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.ScenarioInputCell, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.ScenarioInputCell, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ScenarioInputCell) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ScenarioInputCell, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ScenarioInputCell, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def add(self, row : int, column : int, value : str) -> int:
        '''Adds an input cell.
        
        :param row: The row index of input cell.
        :param column: The column index of input cell.
        :param value: The value of input cell.'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.ScenarioInputCell) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class SettableChartGlobalizationSettings(aspose.cells.charts.ChartGlobalizationSettings):
    '''Implementation of PivotGlobalizationSettings that supports user to set/change pre-defined texts.'''
    
    def get_series_name(self) -> str:
        '''Gets the name of Series in the Chart.'''
        raise NotImplementedError()
    
    def get_chart_title_name(self) -> str:
        '''Gets the name of Chart Title.'''
        raise NotImplementedError()
    
    def get_legend_increase_name(self) -> str:
        '''Gets the name of increase for Legend.'''
        raise NotImplementedError()
    
    def get_legend_decrease_name(self) -> str:
        '''Gets the name of Decrease for Legend.'''
        raise NotImplementedError()
    
    def get_legend_total_name(self) -> str:
        '''Gets the name of Total for Legend.'''
        raise NotImplementedError()
    
    def get_axis_title_name(self) -> str:
        '''Gets the name of Title for Axis.'''
        raise NotImplementedError()
    
    def get_other_name(self) -> str:
        '''Gets the name of "Other" labels for Chart.'''
        raise NotImplementedError()
    
    def get_axis_unit_name(self, type : aspose.cells.charts.DisplayUnitType) -> str:
        '''Gets the Name of Axis Unit.'''
        raise NotImplementedError()
    
    def set_series_name(self, name : str) -> None:
        '''Sets the name of Series in the Chart.
        
        :param name: local dependent name'''
        raise NotImplementedError()
    
    def set_chart_title_name(self, name : str) -> None:
        '''Sets the name of Chart Title.
        
        :param name: local dependent name'''
        raise NotImplementedError()
    
    def set_legend_increase_name(self, name : str) -> None:
        '''Sets the name of increase for Legend.
        
        :param name: local dependent name'''
        raise NotImplementedError()
    
    def set_legend_decrease_name(self, name : str) -> None:
        '''Sets the name of Decrease for Legend.
        
        :param name: local dependent name'''
        raise NotImplementedError()
    
    def set_legend_total_name(self, name : str) -> None:
        '''Sets the name of Total for Legend.
        
        :param name: local dependent name'''
        raise NotImplementedError()
    
    def set_axis_title_name(self, name : str) -> None:
        '''Sets the name of Title for Axis.
        
        :param name: local dependent name'''
        raise NotImplementedError()
    
    def set_other_name(self, name : str) -> None:
        '''Sets the name of "Other" labels for Chart.
        
        :param name: local dependent name'''
        raise NotImplementedError()
    
    def set_axis_unit_name(self, type : aspose.cells.charts.DisplayUnitType, name : str) -> None:
        '''Sets the Name of Axis Unit.
        
        :param name: local dependent name'''
        raise NotImplementedError()
    

class SettableGlobalizationSettings(GlobalizationSettings):
    '''Implementation of GlobalizationSettings that supports user to set/change pre-defined texts.'''
    
    def get_pivot_total_name(self) -> str:
        '''Gets the name of "Total" label in the PivotTable.
        You need to override this method when the PivotTable contains two or more PivotFields in the data area.
        
        :returns: The name of "Total" label'''
        raise NotImplementedError()
    
    def get_pivot_grand_total_name(self) -> str:
        '''Gets the name of "Grand Total" label in the PivotTable.
        
        :returns: The name of "Grand Total" label'''
        raise NotImplementedError()
    
    def get_multiple_items_name(self) -> str:
        '''Gets the name of "(Multiple Items)" label in the PivotTable.
        
        :returns: The name of "(Multiple Items)" label'''
        raise NotImplementedError()
    
    def get_all_name(self) -> str:
        '''Gets the name of "(All)" label in the PivotTable.
        
        :returns: The name of "(All)" label'''
        raise NotImplementedError()
    
    def get_protection_name_of_pivot_table(self) -> str:
        '''Gets the protection name in the PivotTable.
        
        :returns: The protection name of PivotTable'''
        raise NotImplementedError()
    
    def get_column_labels_of_pivot_table(self) -> str:
        '''Gets the name of "Column Labels" label in the PivotTable.
        
        :returns: The name of column labels'''
        raise NotImplementedError()
    
    def get_row_labels_name_of_pivot_table(self) -> str:
        '''Gets the name of "Row Labels" label in the PivotTable.
        
        :returns: The name of row labels'''
        raise NotImplementedError()
    
    def get_empty_data_name(self) -> str:
        '''Gets the name of "(blank)" label in the PivotTable.
        
        :returns: The name of empty data'''
        raise NotImplementedError()
    
    def get_data_field_header_name_of_pivot_table(self) -> str:
        '''Gets the the name of the value area field header in the PivotTable.
        
        :returns: The name of data field header name'''
        raise NotImplementedError()
    
    def get_sub_total_name(self, sub_total_type : aspose.cells.pivot.PivotFieldSubtotalType) -> str:
        '''Gets the name of :py:class:`aspose.cells.pivot.PivotFieldSubtotalType` type in the PivotTable.
        
        :param sub_total_type: The :py:class:`aspose.cells.pivot.PivotFieldSubtotalType` type
        :returns: The name of :py:class:`aspose.cells.pivot.PivotFieldSubtotalType` type'''
        raise NotImplementedError()
    
    def get_total_name(self, function_type : aspose.cells.ConsolidationFunction) -> str:
        '''Gets the total name of specific function.
        
        :param function_type: The function type.
        :returns: The total name of the function.'''
        raise NotImplementedError()
    
    def get_grand_total_name(self, function_type : aspose.cells.ConsolidationFunction) -> str:
        '''Gets the grand total name of the function.
        
        :param function_type: The function type.
        :returns: The grand total name of the function.'''
        raise NotImplementedError()
    
    def get_default_sheet_name(self) -> str:
        '''Gets the default sheet name for adding worksheet automatically.
        Default is "Sheet".
        
        :returns: the default sheet name for adding worksheet automatically'''
        raise NotImplementedError()
    
    def get_table_row_type_of_headers(self) -> str:
        '''Gets the type name of table rows that consists of the table header.
        Default is "Headers", so in formula "#Headers" represents the table header.
        
        :returns: the type name of table rows'''
        raise NotImplementedError()
    
    def get_table_row_type_of_data(self) -> str:
        '''Gets the type name of table rows that consists of data region of referenced table.
        Default is "Data", so in formula "#Data" represents the data region of the table.
        
        :returns: the type name of table rows'''
        raise NotImplementedError()
    
    def get_table_row_type_of_all(self) -> str:
        '''Gets the type name of table rows that consists of all rows in referenced table.
        
        :returns: the type name of table rows'''
        raise NotImplementedError()
    
    def get_table_row_type_of_totals(self) -> str:
        '''Gets the type name of table rows that consists of the total row of referenced table.
        
        :returns: the type name of table rows'''
        raise NotImplementedError()
    
    def get_table_row_type_of_current(self) -> str:
        '''Gets the type name of table rows that consists of the current row in referenced table.
        
        :returns: the type name of table rows'''
        raise NotImplementedError()
    
    def get_error_value_string(self, err : str) -> str:
        '''Gets the display string value for cell\'s error value
        
        :param err: error values such as #VALUE!,#NAME?
        :returns: By default returns the error value itself'''
        raise NotImplementedError()
    
    def get_boolean_value_string(self, bv : bool) -> str:
        '''Gets the display string value for cell\'s boolean value
        
        :param bv: boolean value
        :returns: By default returns "TRUE" for true value and "FALSE" for false value.'''
        raise NotImplementedError()
    
    def get_local_function_name(self, standard_name : str) -> str:
        '''Gets the locale dependent function name according to given standard function name.
        
        :param standard_name: Standard(en-US locale) function name.
        :returns: Locale dependent function name. The locale was specified by the Workbook for which this settings is used.'''
        raise NotImplementedError()
    
    def get_standard_function_name(self, local_name : str) -> str:
        '''Gets the standard function name according to given locale dependent function name.
        
        :param local_name: Locale dependent function name. The locale was specified by the Workbook for which this settings is used.
        :returns: Standard(en-US locale) function name.'''
        raise NotImplementedError()
    
    def get_local_built_in_name(self, standard_name : str) -> str:
        '''Gets the locale dependent text for built-in Name according to given standard text.
        
        :param standard_name: Standard(en-US locale) text of built-in Name.
        :returns: Locale dependent text. The locale was specified by the Workbook for which this settings is used.'''
        raise NotImplementedError()
    
    def get_standard_built_in_name(self, local_name : str) -> str:
        '''Gets the standard text of built-in Name according to given locale dependent text.
        
        :param local_name: Locale dependent text of built-in Name. The locale was specified by the Workbook for which this settings is used.
        :returns: Standard(en-US locale) text.'''
        raise NotImplementedError()
    
    def get_standard_header_footer_font_style_name(self, localfont_style_name : str) -> str:
        '''Gets standard English font style name(Regular, Bold, Italic) for Header/Footer according to given locale font style name.
        
        :param localfont_style_name: Locale font style name for Header/Footer.
        :returns: Standard English font style name(Regular, Bold, Italic)'''
        raise NotImplementedError()
    
    def get_comment_title_name(self, type : aspose.cells.rendering.CommentTitleType) -> str:
        '''Gets the locale dependent comment title name according to comment title type.
        
        :param type: type of comment title
        :returns: locale dependent comment title name'''
        raise NotImplementedError()
    
    def compare(self, v1 : str, v2 : str, ignore_case : bool) -> int:
        '''Compares two string values according to certain collation rules.
        
        :param v1: the first string
        :param v2: the second string
        :param ignore_case: whether ignore case when comparing values
        :returns: Integer that indicates the lexical relationship between the two comparands'''
        raise NotImplementedError()
    
    def set_total_name(self, function_type : aspose.cells.ConsolidationFunction, name : str) -> None:
        '''Sets the total name of specific function.
        
        :param function_type: The function type.
        :param name: The total name of the function.'''
        raise NotImplementedError()
    
    def set_grand_total_name(self, function_type : aspose.cells.ConsolidationFunction, name : str) -> None:
        '''Sets the grand total name of specific function.
        
        :param function_type: The function type.
        :param name: The grand total name of the function.'''
        raise NotImplementedError()
    
    def set_table_row_type_of_headers(self, name : str) -> None:
        '''Sets the type name of table rows that consists of the table header.
        
        :param name: the type name of table rows'''
        raise NotImplementedError()
    
    def set_table_row_type_of_data(self, name : str) -> None:
        '''Sets the type name of table rows that consists of data region of referenced table.
        
        :param name: the type name of table rows'''
        raise NotImplementedError()
    
    def set_table_row_type_of_all(self, name : str) -> None:
        '''Sets the type name of table rows that consists of all rows in referenced table.
        
        :param name: the type name of table rows'''
        raise NotImplementedError()
    
    def set_table_row_type_of_totals(self, name : str) -> None:
        '''Sets the type name of table rows that consists of the total row of referenced table.
        
        :param name: the type name of table rows'''
        raise NotImplementedError()
    
    def set_table_row_type_of_current(self, name : str) -> None:
        '''Sets the type name of table rows that consists of the current row in referenced table.
        
        :param name: the type name of table rows'''
        raise NotImplementedError()
    
    def set_boolean_value_string(self, bv : bool, name : str) -> None:
        '''Sets the display string value for cell\'s boolean value
        
        :param bv: boolean value
        :param name: string value of the boolean value'''
        raise NotImplementedError()
    
    def set_local_function_name(self, standard_name : str, local_name : str, bidirectional : bool) -> None:
        '''Sets the locale dependent function name corresponding to given standard function name.
        
        :param standard_name: Standard(en-US locale) function name.
        :param local_name: Locale dependent function name
        :param bidirectional: Whether map the local function name to standard function name automatically.
        If true, the local name will be mapped to standard name automatically
        so user does not need to call :py:func:`aspose.cells.SettableGlobalizationSettings.set_standard_function_name` again
        for the same standard and local names pair'''
        raise NotImplementedError()
    
    def set_standard_function_name(self, local_name : str, standard_name : str, bidirectional : bool) -> None:
        '''Sets the locale dependent function name according to given standard function name.
        
        :param local_name: Locale dependent function name
        :param standard_name: Standard(en-US locale) function name.
        :param bidirectional: Whether map the standard function name to local function name automatically.
        If true, the standar name will be mapped to local name automatically
        so user does not need to call :py:func:`aspose.cells.SettableGlobalizationSettings.set_local_function_name` again
        for the same standard and local names pair'''
        raise NotImplementedError()
    
    def set_local_built_in_name(self, standard_name : str, local_name : str, bidirectional : bool) -> None:
        '''Sets the locale dependent text for the built-in name with given standard name text.
        
        :param standard_name: Standard(en-US locale) name text of built-in name.
        :param local_name: Locale dependent name text
        :param bidirectional: Whether map the local name text to standard name text automatically.
        If true, the local name text will be mapped to standard name text automatically
        so user does not need to call :py:func:`aspose.cells.SettableGlobalizationSettings.set_standard_built_in_name` again
        for the same standard and local names pair'''
        raise NotImplementedError()
    
    def set_standard_built_in_name(self, local_name : str, standard_name : str, bidirectional : bool) -> None:
        '''Sets the locale dependent function name according to given standard function name.
        
        :param local_name: Locale dependent function name
        :param standard_name: Standard(en-US locale) function name.
        :param bidirectional: Whether map the standard name text to local name text automatically.
        If true, the standar name text will be mapped to local name text automatically
        so user does not need to call :py:func:`aspose.cells.SettableGlobalizationSettings.set_local_built_in_name` again
        for the same standard and local names pair'''
        raise NotImplementedError()
    
    def set_list_separator(self, c : str) -> None:
        '''Sets the separator for list, parameters of function, ...etc.
        
        :param c: the specified separator'''
        raise NotImplementedError()
    
    def set_row_separator_of_formula_array(self, c : str) -> None:
        '''Sets the separator for rows in array data in formula.
        
        :param c: the specified separator'''
        raise NotImplementedError()
    
    def set_column_separator_of_formula_array(self, c : str) -> None:
        '''Sets the separator for the items in array\'s row data in formula.
        
        :param c: the specified separator'''
        raise NotImplementedError()
    
    def set_standard_header_footer_font_style_name(self, localfont_style_name : str, standard_name : str) -> None:
        '''Sets the locale dependent function name according to given standard function name.
        
        :param localfont_style_name: Locale font style name for Header/Footer.
        :param standard_name: Standard(en-US locale) function name.'''
        raise NotImplementedError()
    
    def set_comment_title_name(self, type : aspose.cells.rendering.CommentTitleType, name : str) -> None:
        '''Gets the locale dependent comment title name according to comment title type.
        
        :param type: type of comment title
        :param name: locale dependent comment title name'''
        raise NotImplementedError()
    
    @property
    def chart_settings(self) -> aspose.cells.charts.ChartGlobalizationSettings:
        '''Gets the globalization settings for Chart.'''
        raise NotImplementedError()
    
    @chart_settings.setter
    def chart_settings(self, value : aspose.cells.charts.ChartGlobalizationSettings) -> None:
        '''Sets the globalization settings for Chart.'''
        raise NotImplementedError()
    
    @property
    def pivot_settings(self) -> aspose.cells.settings.PivotGlobalizationSettings:
        '''Gets the globalization settings for pivot table.'''
        raise NotImplementedError()
    
    @pivot_settings.setter
    def pivot_settings(self, value : aspose.cells.settings.PivotGlobalizationSettings) -> None:
        '''Sets the globalization settings for pivot table.'''
        raise NotImplementedError()
    
    @property
    def list_separator(self) -> str:
        '''Gets the separator for list, parameters of function, ...etc.'''
        raise NotImplementedError()
    
    @property
    def row_separator_of_formula_array(self) -> str:
        '''Gets the separator for rows in array data in formula.'''
        raise NotImplementedError()
    
    @property
    def column_separator_of_formula_array(self) -> str:
        '''Gets the separator for the items in array\'s row data in formula.'''
        raise NotImplementedError()
    

class SettablePivotGlobalizationSettings(aspose.cells.settings.PivotGlobalizationSettings):
    '''Implementation of PivotGlobalizationSettings that supports user to set/change pre-defined texts.'''
    
    def get_text_of_total(self) -> str:
        '''Gets the text of "Total" label in the PivotTable.
        You need to override this method when the PivotTable contains two or more PivotFields in the data area.
        
        :returns: The text of "Total" label'''
        raise NotImplementedError()
    
    def get_text_of_grand_total(self) -> str:
        '''Gets the text of "Grand Total" label in the PivotTable.
        
        :returns: The text of "Grand Total" label'''
        raise NotImplementedError()
    
    def get_text_of_multiple_items(self) -> str:
        '''Gets the text of "(Multiple Items)" label in the PivotTable.
        
        :returns: The text of "(Multiple Items)" label'''
        raise NotImplementedError()
    
    def get_text_of_all(self) -> str:
        '''Gets the text of "(All)" label in the PivotTable.
        
        :returns: The text of "(All)" label'''
        raise NotImplementedError()
    
    def get_text_of_protection(self) -> str:
        '''Gets the protection name in the PivotTable.
        
        :returns: The protection name of PivotTable'''
        raise NotImplementedError()
    
    def get_text_of_protected_name(self, protected_name : str) -> str:
        '''Gets the text for specified protected name.
        
        :param protected_name: The protected name in PivotTable.
        :returns: The local prorected names of PivotTable.'''
        raise NotImplementedError()
    
    def get_text_of_column_labels(self) -> str:
        '''Gets the text of "Column Labels" label in the PivotTable.
        
        :returns: The text of column labels'''
        raise NotImplementedError()
    
    def get_text_of_row_labels(self) -> str:
        '''Gets the text of "Row Labels" label in the PivotTable.
        
        :returns: The text of row labels'''
        raise NotImplementedError()
    
    def get_text_of_empty_data(self) -> str:
        '''Gets the text of "(blank)" label in the PivotTable.
        
        :returns: The text of empty data'''
        raise NotImplementedError()
    
    def get_text_of_data_field_header(self) -> str:
        '''Gets the the text of the value area field header in the PivotTable.
        
        :returns: The text of data field header name'''
        raise NotImplementedError()
    
    def get_short_text_of_12_months(self) -> List[str]:
        '''Gets all short formatted string of 12 months.'''
        raise NotImplementedError()
    
    def get_text_of_4_quaters(self) -> List[str]:
        '''Gets the local text of 4 Quaters.'''
        raise NotImplementedError()
    
    def get_text_of_years(self) -> str:
        '''Gets the local text of "Years".'''
        raise NotImplementedError()
    
    def get_text_of_quarters(self) -> str:
        '''Get the local text of "Quarters".'''
        raise NotImplementedError()
    
    def get_text_of_months(self) -> str:
        '''Gets the local text of "Months".'''
        raise NotImplementedError()
    
    def get_text_of_days(self) -> str:
        '''Gets the local text of "Days".'''
        raise NotImplementedError()
    
    def get_text_of_hours(self) -> str:
        '''Gets the local text of "Hours".'''
        raise NotImplementedError()
    
    def get_text_of_minutes(self) -> str:
        '''Gets the local text of "Minutes".'''
        raise NotImplementedError()
    
    def get_text_of_seconds(self) -> str:
        '''Gets the local text of "Seconds"'''
        raise NotImplementedError()
    
    def get_text_of_range(self) -> str:
        '''Gets the local text of "Range"'''
        raise NotImplementedError()
    
    def get_text_of_sub_total(self, sub_total_type : aspose.cells.pivot.PivotFieldSubtotalType) -> str:
        '''Gets the text of :py:class:`aspose.cells.pivot.PivotFieldSubtotalType` type in the PivotTable.
        
        :param sub_total_type: The :py:class:`aspose.cells.pivot.PivotFieldSubtotalType`
        :returns: The text of given type'''
        raise NotImplementedError()
    
    def set_text_of_total(self, text : str) -> None:
        '''Sets the text of "Total" label in the PivotTable.
        
        :param text: custom text'''
        raise NotImplementedError()
    
    def set_text_of_grand_total(self, text : str) -> None:
        '''Sets the text of "Grand Total" label in the PivotTable.
        
        :param text: custom text'''
        raise NotImplementedError()
    
    def set_text_of_multiple_items(self, text : str) -> None:
        '''Sets the text of "(Multiple Items)" label in the PivotTable.
        
        :param text: custom text'''
        raise NotImplementedError()
    
    def set_text_of_all(self, text : str) -> None:
        '''Sets the text of "(All)" label in the PivotTable.
        
        :param text: custom text'''
        raise NotImplementedError()
    
    def set_text_of_protected_name(self, protected_name : str, text : str) -> None:
        '''Sets the text for specific protected name.
        
        :param protected_name: The protected name in PivotTable.
        :param text: The local prorected names of PivotTable.'''
        raise NotImplementedError()
    
    def set_text_of_column_labels(self, text : str) -> None:
        '''Gets the text of "Column Labels" label in the PivotTable.
        
        :param text: The text of column labels'''
        raise NotImplementedError()
    
    def set_text_of_row_labels(self, text : str) -> None:
        '''Sets the text of "Row Labels" label in the PivotTable.
        
        :param text: The text of row labels'''
        raise NotImplementedError()
    
    def set_text_of_empty_data(self, text : str) -> None:
        '''Sets the text of "(blank)" label in the PivotTable.
        
        :param text: The text of empty data'''
        raise NotImplementedError()
    
    def set_text_of_data_field_header(self, text : str) -> None:
        '''Sets the the text of the value area field header in the PivotTable.
        
        :param text: The text of data field header name'''
        raise NotImplementedError()
    
    def set_text_of_sub_total(self, sub_total_type : aspose.cells.pivot.PivotFieldSubtotalType, text : str) -> None:
        '''Sets the text of :py:class:`aspose.cells.pivot.PivotFieldSubtotalType` type in the PivotTable.
        
        :param sub_total_type: The :py:class:`aspose.cells.pivot.PivotFieldSubtotalType`
        :param text: The text of given type'''
        raise NotImplementedError()
    

class SpreadsheetML2003SaveOptions(SaveOptions):
    '''Represents the options for saving Excel 2003 spreadml file.'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def is_indented_formatting(self) -> bool:
        '''Causes child elements to be indented.'''
        raise NotImplementedError()
    
    @is_indented_formatting.setter
    def is_indented_formatting(self, value : bool) -> None:
        '''Causes child elements to be indented.'''
        raise NotImplementedError()
    
    @property
    def limit_as_xls(self) -> bool:
        '''Limit as xls, the max row index is 65535 and the max column index is 255.'''
        raise NotImplementedError()
    
    @limit_as_xls.setter
    def limit_as_xls(self, value : bool) -> None:
        '''Limit as xls, the max row index is 65535 and the max column index is 255.'''
        raise NotImplementedError()
    
    @property
    def export_column_index_of_cell(self) -> bool:
        '''The default value is false, it means that column index  will be ignored if the cell is contiguous to the previous cell.'''
        raise NotImplementedError()
    
    @export_column_index_of_cell.setter
    def export_column_index_of_cell(self, value : bool) -> None:
        '''The default value is false, it means that column index  will be ignored if the cell is contiguous to the previous cell.'''
        raise NotImplementedError()
    

class StreamProviderOptions:
    '''Represents the stream options.'''
    
    @property
    def resource_loading_type(self) -> aspose.cells.ResourceLoadingType:
        '''Gets and sets the type of loading resource.'''
        raise NotImplementedError()
    
    @resource_loading_type.setter
    def resource_loading_type(self, value : aspose.cells.ResourceLoadingType) -> None:
        '''Gets and sets the type of loading resource.'''
        raise NotImplementedError()
    
    @property
    def default_path(self) -> str:
        '''The default path(URL) saved in generated html file for the referred source.
        For example, the sheet data saved in xxx_files/sheet001.htm, the url used in the main html file should be like "src="xxx_files/sheet001.htm""'''
        raise NotImplementedError()
    
    @property
    def custom_path(self) -> str:
        '''The user custom path(URL) saved in generated html file for the referred source. If not defined by user, DefaultPath will be used.
        For example, the sheet data will be saved by user to d:/sheet001.htm, the url used in the main html file should be "d:/sheet001.htm" or other valid relative path that can be accessed by the main html file.'''
        raise NotImplementedError()
    
    @custom_path.setter
    def custom_path(self, value : str) -> None:
        '''The user custom path(URL) saved in generated html file for the referred source. If not defined by user, DefaultPath will be used.
        For example, the sheet data will be saved by user to d:/sheet001.htm, the url used in the main html file should be "d:/sheet001.htm" or other valid relative path that can be accessed by the main html file.'''
        raise NotImplementedError()
    
    @property
    def stream(self) -> io.RawIOBase:
        '''Gets/Sets the stream'''
        raise NotImplementedError()
    
    @stream.setter
    def stream(self, value : io.RawIOBase) -> None:
        '''Gets/Sets the stream'''
        raise NotImplementedError()
    

class Style:
    '''Represents display style of excel document,such as font,color,alignment,border,etc.
    The Style object contains all style attributes (font, number format, alignment, and so on) as properties.'''
    
    @overload
    def set_border(self, border_type : aspose.cells.BorderType, border_style : aspose.cells.CellBorderType, border_color : aspose.pydrawing.Color) -> bool:
        '''Sets the borders of the style.
        
        :param border_type: The border(s) to be set, can be combination of :py:class:`aspose.cells.BorderType`.
        :param border_style: The style of the border.
        :param border_color: The color of the border.
        :returns: Whether current border settings have been changed.'''
        raise NotImplementedError()
    
    @overload
    def set_border(self, border_type : aspose.cells.BorderType, border_style : aspose.cells.CellBorderType, border_color : aspose.cells.CellsColor) -> bool:
        '''Sets the borders of the style.
        
        :param border_type: The border(s) to be set, can be combination of :py:class:`aspose.cells.BorderType`.
        :param border_style: The style of the border.
        :param border_color: The color of the border.
        :returns: Whether current border settings have been changed.'''
        raise NotImplementedError()
    
    def set_pattern_color(self, pattern : aspose.cells.BackgroundType, color1 : aspose.pydrawing.Color, color2 : aspose.pydrawing.Color) -> None:
        '''Sets the background color.
        
        :param pattern: The pattern.
        :param color1: The foreground color.
        :param color2: The background color. Only works when pattern is not BackgroundType.None and BackgroundType.Solid.'''
        raise NotImplementedError()
    
    def copy(self, style : aspose.cells.Style) -> None:
        '''Copies data from another style object
        
        :param style: Source Style object'''
        raise NotImplementedError()
    
    def update(self) -> None:
        '''Apply the named style to the styles of the cells which use this named style.
        It works like clicking the "ok" button after you finished modifying the style.
        Only applies for named style.'''
        raise NotImplementedError()
    
    def is_modified(self, modify_flag : aspose.cells.StyleModifyFlag) -> bool:
        '''Checks whether the specified properties of the style have been modified.
        Used for style of ConditionalFormattings to check whether the specified properties of this style should be used when applying the ConditionalFormattings on a cell.
        
        :param modify_flag: Style modified flags
        :returns: true if the specified properties have been modified'''
        raise NotImplementedError()
    
    def set_custom(self, custom : str, builtin_preference : bool) -> None:
        '''Sets the Custom number format string of a cell.
        
        :param custom: Custom number format string, should be InvariantCulture pattern.
        :param builtin_preference: If given Custom number format string matches one of the built-in number formats
        corresponding to current regional settings, whether set the number format as built-in instead of Custom.'''
        raise NotImplementedError()
    
    def set_two_color_gradient(self, color1 : aspose.pydrawing.Color, color2 : aspose.pydrawing.Color, gradient_style_type : aspose.cells.drawing.GradientStyleType, variant : int) -> None:
        '''Sets the specified fill to a two-color gradient.
        
        :param color1: One gradient color.
        :param color2: Two gradient color.
        :param gradient_style_type: Gradient shading style.
        :param variant: The gradient variant. Can be a value from 1 through 4, corresponding to one of the four variants on the Gradient tab in the Fill Effects dialog box. If style is GradientStyle.FromCenter, the Variant argument can only be 1 or 2.'''
        raise NotImplementedError()
    
    def get_two_color_gradient(self, color1 : List[aspose.pydrawing.Color], color2 : List[aspose.pydrawing.Color], gradient_style_type : List[aspose.cells.drawing.GradientStyleType], variant : List[int]) -> None:
        '''Get the two-color gradient setting.
        
        :param color1: One gradient color.
        :param color2: Two gradient color.
        :param gradient_style_type: Gradient shading style.
        :param variant: The gradient variant.'''
        raise NotImplementedError()
    
    def get_two_color_gradient_setting(self) -> aspose.cells.TwoColorGradient:
        '''Get the two-color gradient setting.'''
        raise NotImplementedError()
    
    def to_json(self) -> str:
        '''Convert :py:class:`aspose.cells.Style` to JSON struct data.'''
        raise NotImplementedError()
    
    @property
    def background_theme_color(self) -> aspose.cells.ThemeColor:
        '''Gets and sets the background theme color.'''
        raise NotImplementedError()
    
    @background_theme_color.setter
    def background_theme_color(self, value : aspose.cells.ThemeColor) -> None:
        '''Gets and sets the background theme color.'''
        raise NotImplementedError()
    
    @property
    def foreground_theme_color(self) -> aspose.cells.ThemeColor:
        '''Gets and sets the foreground theme color.'''
        raise NotImplementedError()
    
    @foreground_theme_color.setter
    def foreground_theme_color(self, value : aspose.cells.ThemeColor) -> None:
        '''Gets and sets the foreground theme color.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets the name of the style.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Sets the name of the style.'''
        raise NotImplementedError()
    
    @property
    def pattern(self) -> aspose.cells.BackgroundType:
        '''Gets the cell background pattern type.'''
        raise NotImplementedError()
    
    @pattern.setter
    def pattern(self, value : aspose.cells.BackgroundType) -> None:
        '''Sets the cell background pattern type.'''
        raise NotImplementedError()
    
    @property
    def borders(self) -> aspose.cells.BorderCollection:
        '''Gets the :py:class:`aspose.cells.BorderCollection` of the style.'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.pydrawing.Color:
        '''Gets a style\'s background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.pydrawing.Color) -> None:
        '''Sets a style\'s background color.'''
        raise NotImplementedError()
    
    @property
    def background_argb_color(self) -> int:
        '''Gets and sets the background color with a 32-bit ARGB value.'''
        raise NotImplementedError()
    
    @background_argb_color.setter
    def background_argb_color(self, value : int) -> None:
        '''Gets and sets the background color with a 32-bit ARGB value.'''
        raise NotImplementedError()
    
    @property
    def foreground_color(self) -> aspose.pydrawing.Color:
        '''Gets a style\'s foreground color.'''
        raise NotImplementedError()
    
    @foreground_color.setter
    def foreground_color(self, value : aspose.pydrawing.Color) -> None:
        '''Sets a style\'s foreground color.'''
        raise NotImplementedError()
    
    @property
    def foreground_argb_color(self) -> int:
        '''Gets and sets the foreground color with a 32-bit ARGB value.'''
        raise NotImplementedError()
    
    @foreground_argb_color.setter
    def foreground_argb_color(self, value : int) -> None:
        '''Gets and sets the foreground color with a 32-bit ARGB value.'''
        raise NotImplementedError()
    
    @property
    def has_borders(self) -> bool:
        '''Checks whether there are borders have been set for the style.'''
        raise NotImplementedError()
    
    @property
    def parent_style(self) -> aspose.cells.Style:
        '''Gets the parent style of this style.'''
        raise NotImplementedError()
    
    @property
    def is_number_format_applied(self) -> bool:
        '''Indicate whether the number formatting should be applied.'''
        raise NotImplementedError()
    
    @is_number_format_applied.setter
    def is_number_format_applied(self, value : bool) -> None:
        '''Indicate whether the number formatting should be applied.'''
        raise NotImplementedError()
    
    @property
    def is_font_applied(self) -> bool:
        '''Indicate whether the font formatting should be applied.'''
        raise NotImplementedError()
    
    @is_font_applied.setter
    def is_font_applied(self, value : bool) -> None:
        '''Indicate whether the font formatting should be applied.'''
        raise NotImplementedError()
    
    @property
    def is_alignment_applied(self) -> bool:
        '''Indicate whether the alignment formatting should be applied.'''
        raise NotImplementedError()
    
    @is_alignment_applied.setter
    def is_alignment_applied(self, value : bool) -> None:
        '''Indicate whether the alignment formatting should be applied.'''
        raise NotImplementedError()
    
    @property
    def is_border_applied(self) -> bool:
        '''Indicate whether the border formatting should be applied.'''
        raise NotImplementedError()
    
    @is_border_applied.setter
    def is_border_applied(self, value : bool) -> None:
        '''Indicate whether the border formatting should be applied.'''
        raise NotImplementedError()
    
    @property
    def is_fill_applied(self) -> bool:
        '''Indicate whether the fill formatting should be applied.'''
        raise NotImplementedError()
    
    @is_fill_applied.setter
    def is_fill_applied(self, value : bool) -> None:
        '''Indicate whether the fill formatting should be applied.'''
        raise NotImplementedError()
    
    @property
    def is_protection_applied(self) -> bool:
        '''Indicate whether the protection formatting should be applied.'''
        raise NotImplementedError()
    
    @is_protection_applied.setter
    def is_protection_applied(self, value : bool) -> None:
        '''Indicate whether the protection formatting should be applied.'''
        raise NotImplementedError()
    
    @property
    def indent_level(self) -> int:
        '''Represents the indent level for the cell or range. Can only be an integer from 0 to 250.'''
        raise NotImplementedError()
    
    @indent_level.setter
    def indent_level(self, value : int) -> None:
        '''Represents the indent level for the cell or range. Can only be an integer from 0 to 250.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.Style.font` object.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> int:
        '''Represents text rotation angle.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : int) -> None:
        '''Represents text rotation angle.'''
        raise NotImplementedError()
    
    @property
    def horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets the horizontal alignment type of the text in a cell.'''
        raise NotImplementedError()
    
    @horizontal_alignment.setter
    def horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Sets the horizontal alignment type of the text in a cell.'''
        raise NotImplementedError()
    
    @property
    def vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets the vertical alignment type of the text in a cell.'''
        raise NotImplementedError()
    
    @vertical_alignment.setter
    def vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Sets the vertical alignment type of the text in a cell.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets a value indicating whether the text within a cell is wrapped.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Sets a value indicating whether the text within a cell is wrapped.'''
        raise NotImplementedError()
    
    @property
    def number(self) -> int:
        '''Gets the display format of numbers and dates. The formatting patterns are different for different regions.'''
        raise NotImplementedError()
    
    @number.setter
    def number(self, value : int) -> None:
        '''Sets the display format of numbers and dates. The formatting patterns are different for different regions.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''Gets a value indicating whether a cell can be modified or not.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''Sets a value indicating whether a cell can be modified or not.'''
        raise NotImplementedError()
    
    @property
    def custom(self) -> str:
        '''Represents the custom number format string of this style object.
        If the custom number format is not set(For example, the number format is builtin), "" will be returned.'''
        raise NotImplementedError()
    
    @custom.setter
    def custom(self, value : str) -> None:
        '''Represents the custom number format string of this style object.
        If the custom number format is not set(For example, the number format is builtin), "" will be returned.'''
        raise NotImplementedError()
    
    @property
    def culture_custom(self) -> str:
        '''Gets and sets the culture-dependent pattern string for number format.
        If no number format has been set for this object, null will be returned.
        If number format is builtin, the pattern string corresponding to the builtin number will be returned.'''
        raise NotImplementedError()
    
    @culture_custom.setter
    def culture_custom(self, value : str) -> None:
        '''Gets and sets the culture-dependent pattern string for number format.
        If no number format has been set for this object, null will be returned.
        If number format is builtin, the pattern string corresponding to the builtin number will be returned.'''
        raise NotImplementedError()
    
    @property
    def invariant_custom(self) -> str:
        '''Gets the culture-independent pattern string for number format.
        If no number format has been set for this object, null will be returned.
        If number format is builtin, the pattern string corresponding to the builtin number will be returned.'''
        raise NotImplementedError()
    
    @property
    def is_formula_hidden(self) -> bool:
        '''Represents if the formula will be hidden when the worksheet is protected.'''
        raise NotImplementedError()
    
    @is_formula_hidden.setter
    def is_formula_hidden(self, value : bool) -> None:
        '''Represents if the formula will be hidden when the worksheet is protected.'''
        raise NotImplementedError()
    
    @property
    def shrink_to_fit(self) -> bool:
        '''Represents if text automatically shrinks to fit in the available column width.'''
        raise NotImplementedError()
    
    @shrink_to_fit.setter
    def shrink_to_fit(self, value : bool) -> None:
        '''Represents if text automatically shrinks to fit in the available column width.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @property
    def is_justify_distributed(self) -> bool:
        '''Indicates if the cells justified or distributed alignment should be used on the last line of text.'''
        raise NotImplementedError()
    
    @is_justify_distributed.setter
    def is_justify_distributed(self, value : bool) -> None:
        '''Indicates if the cells justified or distributed alignment should be used on the last line of text.'''
        raise NotImplementedError()
    
    @property
    def quote_prefix(self) -> bool:
        '''Indicates whether the cell\'s value starts with single quote mark.'''
        raise NotImplementedError()
    
    @quote_prefix.setter
    def quote_prefix(self, value : bool) -> None:
        '''Indicates whether the cell\'s value starts with single quote mark.'''
        raise NotImplementedError()
    
    @property
    def is_gradient(self) -> bool:
        '''Indicates whether the cell shading is a gradient pattern.'''
        raise NotImplementedError()
    
    @is_gradient.setter
    def is_gradient(self, value : bool) -> None:
        '''Indicates whether the cell shading is a gradient pattern.'''
        raise NotImplementedError()
    
    @property
    def is_percent(self) -> bool:
        '''Indicates whether the number format is a percent format.'''
        raise NotImplementedError()
    
    @property
    def is_date_time(self) -> bool:
        '''Indicates whether the number format is a date format.'''
        raise NotImplementedError()
    

class StyleFlag:
    '''Represents flags which indicates applied formatting properties.'''
    
    @property
    def all(self) -> bool:
        '''All properties will be applied.'''
        raise NotImplementedError()
    
    @all.setter
    def all(self, value : bool) -> None:
        '''All properties will be applied.'''
        raise NotImplementedError()
    
    @property
    def borders(self) -> bool:
        '''All borders settings will be applied.'''
        raise NotImplementedError()
    
    @borders.setter
    def borders(self, value : bool) -> None:
        '''All borders settings will be applied.'''
        raise NotImplementedError()
    
    @property
    def left_border(self) -> bool:
        '''Left border settings will be applied.'''
        raise NotImplementedError()
    
    @left_border.setter
    def left_border(self, value : bool) -> None:
        '''Left border settings will be applied.'''
        raise NotImplementedError()
    
    @property
    def right_border(self) -> bool:
        '''Right border settings will be applied.'''
        raise NotImplementedError()
    
    @right_border.setter
    def right_border(self, value : bool) -> None:
        '''Right border settings will be applied.'''
        raise NotImplementedError()
    
    @property
    def top_border(self) -> bool:
        '''Top border settings will be applied.'''
        raise NotImplementedError()
    
    @top_border.setter
    def top_border(self, value : bool) -> None:
        '''Top border settings will be applied.'''
        raise NotImplementedError()
    
    @property
    def bottom_border(self) -> bool:
        '''Bottom border settings will be applied.'''
        raise NotImplementedError()
    
    @bottom_border.setter
    def bottom_border(self, value : bool) -> None:
        '''Bottom border settings will be applied.'''
        raise NotImplementedError()
    
    @property
    def diagonal_down_border(self) -> bool:
        '''Diagonal down border settings will be applied.'''
        raise NotImplementedError()
    
    @diagonal_down_border.setter
    def diagonal_down_border(self, value : bool) -> None:
        '''Diagonal down border settings will be applied.'''
        raise NotImplementedError()
    
    @property
    def diagonal_up_border(self) -> bool:
        '''Diagonal up border settings will be applied.'''
        raise NotImplementedError()
    
    @diagonal_up_border.setter
    def diagonal_up_border(self, value : bool) -> None:
        '''Diagonal up border settings will be applied.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> bool:
        '''Font settings will be applied.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : bool) -> None:
        '''Font settings will be applied.'''
        raise NotImplementedError()
    
    @property
    def font_size(self) -> bool:
        '''Font size setting will be applied.'''
        raise NotImplementedError()
    
    @font_size.setter
    def font_size(self, value : bool) -> None:
        '''Font size setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def font_name(self) -> bool:
        '''Font name setting will be applied.'''
        raise NotImplementedError()
    
    @font_name.setter
    def font_name(self, value : bool) -> None:
        '''Font name setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def font_color(self) -> bool:
        '''Font color setting will be applied.'''
        raise NotImplementedError()
    
    @font_color.setter
    def font_color(self, value : bool) -> None:
        '''Font color setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def font_bold(self) -> bool:
        '''Font bold setting will be applied.'''
        raise NotImplementedError()
    
    @font_bold.setter
    def font_bold(self, value : bool) -> None:
        '''Font bold setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def font_italic(self) -> bool:
        '''Font italic setting will be applied.'''
        raise NotImplementedError()
    
    @font_italic.setter
    def font_italic(self, value : bool) -> None:
        '''Font italic setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def font_underline(self) -> bool:
        '''Font underline setting will be applied.'''
        raise NotImplementedError()
    
    @font_underline.setter
    def font_underline(self, value : bool) -> None:
        '''Font underline setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def font_strike(self) -> bool:
        '''Font strikeout setting will be applied.'''
        raise NotImplementedError()
    
    @font_strike.setter
    def font_strike(self, value : bool) -> None:
        '''Font strikeout setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def font_script(self) -> bool:
        '''Font script setting will be applied.'''
        raise NotImplementedError()
    
    @font_script.setter
    def font_script(self, value : bool) -> None:
        '''Font script setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def number_format(self) -> bool:
        '''Number format setting will be applied.'''
        raise NotImplementedError()
    
    @number_format.setter
    def number_format(self, value : bool) -> None:
        '''Number format setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def alignments(self) -> bool:
        '''Alignment setting will be applied.'''
        raise NotImplementedError()
    
    @alignments.setter
    def alignments(self, value : bool) -> None:
        '''Alignment setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def horizontal_alignment(self) -> bool:
        '''Horizontal alignment setting will be applied.'''
        raise NotImplementedError()
    
    @horizontal_alignment.setter
    def horizontal_alignment(self, value : bool) -> None:
        '''Horizontal alignment setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def vertical_alignment(self) -> bool:
        '''Vertical alignment setting will be applied.'''
        raise NotImplementedError()
    
    @vertical_alignment.setter
    def vertical_alignment(self, value : bool) -> None:
        '''Vertical alignment setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def indent(self) -> bool:
        '''Indent level setting will be applied.'''
        raise NotImplementedError()
    
    @indent.setter
    def indent(self, value : bool) -> None:
        '''Indent level setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def rotation(self) -> bool:
        '''Rotation setting will be applied.'''
        raise NotImplementedError()
    
    @rotation.setter
    def rotation(self, value : bool) -> None:
        '''Rotation setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def wrap_text(self) -> bool:
        '''Wrap text setting will be applied.'''
        raise NotImplementedError()
    
    @wrap_text.setter
    def wrap_text(self, value : bool) -> None:
        '''Wrap text setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def shrink_to_fit(self) -> bool:
        '''Shrink to fit setting will be applied.'''
        raise NotImplementedError()
    
    @shrink_to_fit.setter
    def shrink_to_fit(self, value : bool) -> None:
        '''Shrink to fit setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> bool:
        '''Text direction setting will be applied.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : bool) -> None:
        '''Text direction setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def cell_shading(self) -> bool:
        '''Cell shading setting will be applied.'''
        raise NotImplementedError()
    
    @cell_shading.setter
    def cell_shading(self, value : bool) -> None:
        '''Cell shading setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def locked(self) -> bool:
        '''Locked setting will be applied.'''
        raise NotImplementedError()
    
    @locked.setter
    def locked(self, value : bool) -> None:
        '''Locked setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def hide_formula(self) -> bool:
        '''Hide formula setting will be applied.'''
        raise NotImplementedError()
    
    @hide_formula.setter
    def hide_formula(self, value : bool) -> None:
        '''Hide formula setting will be applied.'''
        raise NotImplementedError()
    
    @property
    def quote_prefix(self) -> bool:
        '''Hide formula setting will be applied.'''
        raise NotImplementedError()
    
    @quote_prefix.setter
    def quote_prefix(self, value : bool) -> None:
        '''Hide formula setting will be applied.'''
        raise NotImplementedError()
    

class SubtotalSetting:
    '''Represents the setting of the subtotal .'''
    
    @property
    def group_by(self) -> int:
        '''The field to group by, as a zero-based integer offset'''
        raise NotImplementedError()
    
    @property
    def subtotal_function(self) -> aspose.cells.ConsolidationFunction:
        '''The subtotal function.'''
        raise NotImplementedError()
    
    @property
    def total_list(self) -> List[int]:
        '''An array of zero-based field offsets, indicating the fields to which the subtotals are added.'''
        raise NotImplementedError()
    
    @property
    def summary_below_data(self) -> bool:
        '''Indicates whether add summary below data.'''
        raise NotImplementedError()
    

class SvgSaveOptions(ImageSaveOptions):
    '''Represents Svg save options.
    For advanced usage, please use :py:class:`aspose.cells.rendering.WorkbookRender` or :py:class:`aspose.cells.rendering.SheetRender`.'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def image_or_print_options(self) -> aspose.cells.rendering.ImageOrPrintOptions:
        '''Additional image creation options.'''
        raise NotImplementedError()
    
    @property
    def stream_provider(self) -> aspose.cells.IStreamProvider:
        '''Gets the IStreamProvider for exporting objects.'''
        raise NotImplementedError()
    
    @stream_provider.setter
    def stream_provider(self, value : aspose.cells.IStreamProvider) -> None:
        '''Sets the IStreamProvider for exporting objects.'''
        raise NotImplementedError()
    
    @property
    def sheet_index(self) -> int:
        '''Gets and sets which worksheet should be exported.
        If the value is -1, the active  worksheet will be exported.'''
        raise NotImplementedError()
    
    @sheet_index.setter
    def sheet_index(self, value : int) -> None:
        '''Gets and sets which worksheet should be exported.
        If the value is -1, the active  worksheet will be exported.'''
        raise NotImplementedError()
    

class SystemTimeInterruptMonitor(AbstractInterruptMonitor):
    
    def start_monitor(self, ms_limit : int) -> None:
        raise NotImplementedError()
    
    @property
    def is_interruption_requested(self) -> bool:
        '''Indicates whether interruption is requested for current operation.
        If true then current operation will be interrupted.
        Implementation should perform fast and efficient check here, otherwise it may become another bottleneck for the procedure.'''
        raise NotImplementedError()
    
    @property
    def terminate_without_exception(self) -> bool:
        '''When procedure is interrupted, whether terminate the procedure quietly or throw an Exception.
        Default is false, that is, when :py:attr:`aspose.cells.AbstractInterruptMonitor.is_interruption_requested` is true,
        a :py:class:`aspose.cells.CellsException` with code :py:attr:`aspose.cells.ExceptionType.INTERRUPTED` will be thrown.'''
        raise NotImplementedError()
    

class ThemeColor:
    '''Represents a theme color.'''
    
    @property
    def color_type(self) -> aspose.cells.ThemeColorType:
        '''Gets and sets the theme type.'''
        raise NotImplementedError()
    
    @color_type.setter
    def color_type(self, value : aspose.cells.ThemeColorType) -> None:
        '''Gets and sets the theme type.'''
        raise NotImplementedError()
    
    @property
    def tint(self) -> float:
        '''Gets and sets the tint value.'''
        raise NotImplementedError()
    
    @tint.setter
    def tint(self, value : float) -> None:
        '''Gets and sets the tint value.'''
        raise NotImplementedError()
    

class ThreadInterruptMonitor(AbstractInterruptMonitor):
    
    def start_monitor(self, ms_limit : int) -> None:
        raise NotImplementedError()
    
    def finish_monitor(self) -> None:
        raise NotImplementedError()
    
    @property
    def is_interruption_requested(self) -> bool:
        '''Indicates whether interruption is requested for current operation.
        If true then current operation will be interrupted.
        Implementation should perform fast and efficient check here, otherwise it may become another bottleneck for the procedure.'''
        raise NotImplementedError()
    
    @property
    def terminate_without_exception(self) -> bool:
        '''When procedure is interrupted, whether terminate the procedure quietly or throw an Exception.
        Default is false, that is, when :py:attr:`aspose.cells.AbstractInterruptMonitor.is_interruption_requested` is true,
        a :py:class:`aspose.cells.CellsException` with code :py:attr:`aspose.cells.ExceptionType.INTERRUPTED` will be thrown.'''
        raise NotImplementedError()
    

class ThreadedComment:
    '''Represents the threaded comment.'''
    
    @property
    def row(self) -> int:
        '''Gets the row index of the comment.'''
        raise NotImplementedError()
    
    @property
    def column(self) -> int:
        '''Gets the column index of the comment.'''
        raise NotImplementedError()
    
    @property
    def notes(self) -> str:
        '''Gets and sets the text of the comment.'''
        raise NotImplementedError()
    
    @notes.setter
    def notes(self, value : str) -> None:
        '''Gets and sets the text of the comment.'''
        raise NotImplementedError()
    
    @property
    def author(self) -> aspose.cells.ThreadedCommentAuthor:
        '''Gets the author of the comment.'''
        raise NotImplementedError()
    
    @author.setter
    def author(self, value : aspose.cells.ThreadedCommentAuthor) -> None:
        '''Gets the author of the comment.'''
        raise NotImplementedError()
    
    @property
    def created_time(self) -> datetime:
        '''Gets and sets the created time of this threaded comment.'''
        raise NotImplementedError()
    
    @created_time.setter
    def created_time(self, value : datetime) -> None:
        '''Gets and sets the created time of this threaded comment.'''
        raise NotImplementedError()
    

class ThreadedCommentAuthor:
    '''Represents the person who creates the threaded comments;'''
    
    @property
    def name(self) -> str:
        '''Gets and sets the name.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name.'''
        raise NotImplementedError()
    
    @property
    def user_id(self) -> str:
        '''Gets and sets the id of the user.'''
        raise NotImplementedError()
    
    @user_id.setter
    def user_id(self, value : str) -> None:
        '''Gets and sets the id of the user.'''
        raise NotImplementedError()
    
    @property
    def provider_id(self) -> str:
        '''Gets the id of the provider.'''
        raise NotImplementedError()
    
    @provider_id.setter
    def provider_id(self, value : str) -> None:
        '''Gets the id of the provider.'''
        raise NotImplementedError()
    

class ThreadedCommentAuthorCollection:
    '''Represents all persons who .'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.ThreadedCommentAuthor]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.ThreadedCommentAuthor], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.ThreadedCommentAuthor, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.ThreadedCommentAuthor, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ThreadedCommentAuthor) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ThreadedCommentAuthor, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ThreadedCommentAuthor, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def add(self, name : str, user_id : str, provider_id : str) -> int:
        '''Adds one thread comment person.
        
        :param name: The name of the person.
        :param provider_id: The id of the provider'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.ThreadedCommentAuthor) -> int:
        raise NotImplementedError()
    
    @property
    def current_person(self) -> aspose.cells.ThreadedCommentAuthor:
        '''Gets and sets the current user.'''
        raise NotImplementedError()
    
    @current_person.setter
    def current_person(self, value : aspose.cells.ThreadedCommentAuthor) -> None:
        '''Gets and sets the current user.'''
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class ThreadedCommentCollection:
    '''Represents the list of threaded comments.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.ThreadedComment]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.ThreadedComment], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.ThreadedComment, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.ThreadedComment, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ThreadedComment) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ThreadedComment, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.ThreadedComment, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def add(self, text : str, author : aspose.cells.ThreadedCommentAuthor) -> int:
        '''Adds a threaded comment;
        
        :param text: The text of the threaded comment.
        :param author: The author of the threaded comment'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.ThreadedComment) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class Top10:
    '''Describe the Top10 conditional formatting rule.
    This conditional formatting rule highlights cells whose
    values fall in the top N or bottom N bracket, as specified.'''
    
    @property
    def is_percent(self) -> bool:
        '''Get or set whether a "top/bottom n" rule is a "top/bottom n percent" rule.
        Default value is false.'''
        raise NotImplementedError()
    
    @is_percent.setter
    def is_percent(self, value : bool) -> None:
        '''Get or set whether a "top/bottom n" rule is a "top/bottom n percent" rule.
        Default value is false.'''
        raise NotImplementedError()
    
    @property
    def is_bottom(self) -> bool:
        '''Get or set whether a "top/bottom n" rule is a "bottom n" rule.
        Default value is false.'''
        raise NotImplementedError()
    
    @is_bottom.setter
    def is_bottom(self, value : bool) -> None:
        '''Get or set whether a "top/bottom n" rule is a "bottom n" rule.
        Default value is false.'''
        raise NotImplementedError()
    
    @property
    def rank(self) -> int:
        '''Get or set the value of "n" in a "top/bottom n" conditional formatting rule.
        If IsPercent is true, the value must between 0 and 100.
        Otherwise it must between 0 and 1000.
        Default value is 10.'''
        raise NotImplementedError()
    
    @rank.setter
    def rank(self, value : int) -> None:
        '''Get or set the value of "n" in a "top/bottom n" conditional formatting rule.
        If IsPercent is true, the value must between 0 and 100.
        Otherwise it must between 0 and 1000.
        Default value is 10.'''
        raise NotImplementedError()
    

class Top10Filter:
    '''Represents the top 10 filter.'''
    
    @property
    def is_top(self) -> bool:
        '''Indicates whether it\'s top filter.'''
        raise NotImplementedError()
    
    @is_top.setter
    def is_top(self, value : bool) -> None:
        '''Indicates whether it\'s top filter.'''
        raise NotImplementedError()
    
    @property
    def is_percent(self) -> bool:
        '''Indicates whether the items is percent.'''
        raise NotImplementedError()
    
    @is_percent.setter
    def is_percent(self, value : bool) -> None:
        '''Indicates whether the items is percent.'''
        raise NotImplementedError()
    
    @property
    def items(self) -> int:
        '''Gets and sets the items of the filter.'''
        raise NotImplementedError()
    
    @items.setter
    def items(self, value : int) -> None:
        '''Gets and sets the items of the filter.'''
        raise NotImplementedError()
    
    @property
    def criteria(self) -> Any:
        raise NotImplementedError()
    
    @criteria.setter
    def criteria(self, value : Any) -> None:
        raise NotImplementedError()
    

class TwoColorGradient:
    '''Represents two color gradient.'''
    
    @property
    def color1(self) -> aspose.pydrawing.Color:
        '''Gets and sets the first gradient color.'''
        raise NotImplementedError()
    
    @color1.setter
    def color1(self, value : aspose.pydrawing.Color) -> None:
        '''Gets and sets the first gradient color.'''
        raise NotImplementedError()
    
    @property
    def color2(self) -> aspose.pydrawing.Color:
        '''Gets and sets the second gradient color.'''
        raise NotImplementedError()
    
    @color2.setter
    def color2(self, value : aspose.pydrawing.Color) -> None:
        '''Gets and sets the second gradient color.'''
        raise NotImplementedError()
    
    @property
    def gradient_style_type(self) -> aspose.cells.drawing.GradientStyleType:
        '''Gets and sets gradient shading style.'''
        raise NotImplementedError()
    
    @gradient_style_type.setter
    def gradient_style_type(self, value : aspose.cells.drawing.GradientStyleType) -> None:
        '''Gets and sets gradient shading style.'''
        raise NotImplementedError()
    
    @property
    def variant(self) -> int:
        '''Gets and sets the gradient variant.'''
        raise NotImplementedError()
    
    @variant.setter
    def variant(self, value : int) -> None:
        '''Gets and sets the gradient variant.'''
        raise NotImplementedError()
    

class TxtLoadOptions(AbstractTextLoadOptions):
    '''Represents the options for loading text file.'''
    
    def set_paper_size(self, type : aspose.cells.PaperSizeType) -> None:
        '''Sets the default print paper size from default printer\'s setting.
        
        :param type: The default paper size.'''
        raise NotImplementedError()
    
    @property
    def load_format(self) -> aspose.cells.LoadFormat:
        '''Gets the load format.'''
        raise NotImplementedError()
    
    @property
    def password(self) -> str:
        '''Gets and set the password of the workbook.'''
        raise NotImplementedError()
    
    @password.setter
    def password(self, value : str) -> None:
        '''Gets and set the password of the workbook.'''
        raise NotImplementedError()
    
    @property
    def parsing_formula_on_open(self) -> bool:
        '''Indicates whether parsing the formula when reading the file.'''
        raise NotImplementedError()
    
    @parsing_formula_on_open.setter
    def parsing_formula_on_open(self, value : bool) -> None:
        '''Indicates whether parsing the formula when reading the file.'''
        raise NotImplementedError()
    
    @property
    def parsing_pivot_cached_records(self) -> bool:
        '''Indicates whether parsing pivot cached records when loading the file.
        The default value is false.'''
        raise NotImplementedError()
    
    @parsing_pivot_cached_records.setter
    def parsing_pivot_cached_records(self, value : bool) -> None:
        '''Indicates whether parsing pivot cached records when loading the file.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def language_code(self) -> aspose.cells.CountryCode:
        '''Gets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @language_code.setter
    def language_code(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @property
    def region(self) -> aspose.cells.CountryCode:
        '''Gets the system regional settings based on CountryCode at the time the file was loaded.'''
        raise NotImplementedError()
    
    @region.setter
    def region(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the system regional settings based on CountryCode at the time the file was loaded.'''
        raise NotImplementedError()
    
    @property
    def default_style_settings(self) -> aspose.cells.DefaultStyleSettings:
        '''Gets the default style settings for initializing styles of the workbook'''
        raise NotImplementedError()
    
    @property
    def standard_font(self) -> str:
        '''Sets the default standard font name'''
        raise NotImplementedError()
    
    @standard_font.setter
    def standard_font(self, value : str) -> None:
        '''Sets the default standard font name'''
        raise NotImplementedError()
    
    @property
    def standard_font_size(self) -> float:
        '''Sets the default standard font size.'''
        raise NotImplementedError()
    
    @standard_font_size.setter
    def standard_font_size(self, value : float) -> None:
        '''Sets the default standard font size.'''
        raise NotImplementedError()
    
    @property
    def interrupt_monitor(self) -> aspose.cells.AbstractInterruptMonitor:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.cells.AbstractInterruptMonitor) -> None:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @property
    def ignore_not_printed(self) -> bool:
        '''Ignore the data which are not printed if directly printing the file'''
        raise NotImplementedError()
    
    @ignore_not_printed.setter
    def ignore_not_printed(self, value : bool) -> None:
        '''Ignore the data which are not printed if directly printing the file'''
        raise NotImplementedError()
    
    @property
    def check_data_valid(self) -> bool:
        '''Check whether data is valid in the template file.'''
        raise NotImplementedError()
    
    @check_data_valid.setter
    def check_data_valid(self, value : bool) -> None:
        '''Check whether data is valid in the template file.'''
        raise NotImplementedError()
    
    @property
    def check_excel_restriction(self) -> bool:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @check_excel_restriction.setter
    def check_excel_restriction(self, value : bool) -> None:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @property
    def keep_unparsed_data(self) -> bool:
        '''Whether keep the unparsed data in memory for the Workbook when it is loaded from template file. Default is true.'''
        raise NotImplementedError()
    
    @keep_unparsed_data.setter
    def keep_unparsed_data(self, value : bool) -> None:
        '''Whether keep the unparsed data in memory for the Workbook when it is loaded from template file. Default is true.'''
        raise NotImplementedError()
    
    @property
    def load_filter(self) -> aspose.cells.LoadFilter:
        '''The filter to denote how to load data.'''
        raise NotImplementedError()
    
    @load_filter.setter
    def load_filter(self, value : aspose.cells.LoadFilter) -> None:
        '''The filter to denote how to load data.'''
        raise NotImplementedError()
    
    @property
    def light_cells_data_handler(self) -> aspose.cells.LightCellsDataHandler:
        '''The data handler for processing cells data when reading template file.'''
        raise NotImplementedError()
    
    @light_cells_data_handler.setter
    def light_cells_data_handler(self, value : aspose.cells.LightCellsDataHandler) -> None:
        '''The data handler for processing cells data when reading template file.'''
        raise NotImplementedError()
    
    @property
    def memory_setting(self) -> aspose.cells.MemorySetting:
        '''Gets the memory usage options.'''
        raise NotImplementedError()
    
    @memory_setting.setter
    def memory_setting(self, value : aspose.cells.MemorySetting) -> None:
        '''Sets the memory usage options.'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def auto_fitter_options(self) -> aspose.cells.AutoFitterOptions:
        '''Gets and sets the auto fitter options'''
        raise NotImplementedError()
    
    @auto_fitter_options.setter
    def auto_fitter_options(self, value : aspose.cells.AutoFitterOptions) -> None:
        '''Gets and sets the auto fitter options'''
        raise NotImplementedError()
    
    @property
    def auto_filter(self) -> bool:
        '''Indicates whether auto filtering the data when loading the files.'''
        raise NotImplementedError()
    
    @auto_filter.setter
    def auto_filter(self, value : bool) -> None:
        '''Indicates whether auto filtering the data when loading the files.'''
        raise NotImplementedError()
    
    @property
    def font_configs(self) -> aspose.cells.IndividualFontConfigs:
        '''Gets and sets individual font configs.
        Only works for the :py:class:`aspose.cells.Workbook` which uses this :py:class:`aspose.cells.LoadOptions` to load.'''
        raise NotImplementedError()
    
    @font_configs.setter
    def font_configs(self, value : aspose.cells.IndividualFontConfigs) -> None:
        '''Gets and sets individual font configs.
        Only works for the :py:class:`aspose.cells.Workbook` which uses this :py:class:`aspose.cells.LoadOptions` to load.'''
        raise NotImplementedError()
    
    @property
    def ignore_useless_shapes(self) -> bool:
        '''Indicates whether ignoring useless shapes.'''
        raise NotImplementedError()
    
    @ignore_useless_shapes.setter
    def ignore_useless_shapes(self, value : bool) -> None:
        '''Indicates whether ignoring useless shapes.'''
        raise NotImplementedError()
    
    @property
    def preserve_padding_spaces_in_formula(self) -> bool:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    
    @preserve_padding_spaces_in_formula.setter
    def preserve_padding_spaces_in_formula(self, value : bool) -> None:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    
    @property
    def encoding(self) -> str:
        '''Gets and sets the default encoding. Only applies for csv file.'''
        raise NotImplementedError()
    
    @encoding.setter
    def encoding(self, value : str) -> None:
        '''Gets and sets the default encoding. Only applies for csv file.'''
        raise NotImplementedError()
    
    @property
    def load_style_strategy(self) -> aspose.cells.TxtLoadStyleStrategy:
        '''Indicates the strategy to apply style for parsed values when converting string value to number or datetime.'''
        raise NotImplementedError()
    
    @load_style_strategy.setter
    def load_style_strategy(self, value : aspose.cells.TxtLoadStyleStrategy) -> None:
        '''Indicates the strategy to apply style for parsed values when converting string value to number or datetime.'''
        raise NotImplementedError()
    
    @property
    def convert_numeric_data(self) -> bool:
        '''Gets a value that indicates whether the string in text file is converted to numeric data.'''
        raise NotImplementedError()
    
    @convert_numeric_data.setter
    def convert_numeric_data(self, value : bool) -> None:
        '''Sets a value that indicates whether the string in text file is converted to numeric data.'''
        raise NotImplementedError()
    
    @property
    def convert_date_time_data(self) -> bool:
        '''Gets a value that indicates whether the string in text file is converted to date data.'''
        raise NotImplementedError()
    
    @convert_date_time_data.setter
    def convert_date_time_data(self, value : bool) -> None:
        '''Sets a value that indicates whether the string in text file is converted to date data.'''
        raise NotImplementedError()
    
    @property
    def keep_precision(self) -> bool:
        '''Indicates whether not parsing a string value if the length is 15.'''
        raise NotImplementedError()
    
    @keep_precision.setter
    def keep_precision(self, value : bool) -> None:
        '''Indicates whether not parsing a string value if the length is 15.'''
        raise NotImplementedError()
    
    @property
    def separator(self) -> str:
        '''Gets and sets character separator of text file.'''
        raise NotImplementedError()
    
    @separator.setter
    def separator(self, value : str) -> None:
        '''Gets and sets character separator of text file.'''
        raise NotImplementedError()
    
    @property
    def separator_string(self) -> str:
        '''Gets and sets a string value as separator.'''
        raise NotImplementedError()
    
    @separator_string.setter
    def separator_string(self, value : str) -> None:
        '''Gets and sets a string value as separator.'''
        raise NotImplementedError()
    
    @property
    def is_multi_encoded(self) -> bool:
        '''True means that the file contains several encoding.'''
        raise NotImplementedError()
    
    @is_multi_encoded.setter
    def is_multi_encoded(self, value : bool) -> None:
        '''True means that the file contains several encoding.'''
        raise NotImplementedError()
    
    @property
    def preferred_parsers(self) -> List[aspose.cells.ICustomParser]:
        '''Gets and sets preferred value parsers for loading text file.'''
        raise NotImplementedError()
    
    @preferred_parsers.setter
    def preferred_parsers(self, value : List[aspose.cells.ICustomParser]) -> None:
        '''Gets and sets preferred value parsers for loading text file.'''
        raise NotImplementedError()
    
    @property
    def has_formula(self) -> bool:
        '''Indicates whether the text is formula if it starts with "=".'''
        raise NotImplementedError()
    
    @has_formula.setter
    def has_formula(self, value : bool) -> None:
        '''Indicates whether the text is formula if it starts with "=".'''
        raise NotImplementedError()
    
    @property
    def has_text_qualifier(self) -> bool:
        '''Whether there is text qualifier for cell value. Default is true.'''
        raise NotImplementedError()
    
    @has_text_qualifier.setter
    def has_text_qualifier(self, value : bool) -> None:
        '''Whether there is text qualifier for cell value. Default is true.'''
        raise NotImplementedError()
    
    @property
    def text_qualifier(self) -> str:
        '''Specifies the text qualifier for cell values. Default qualifier is \'"\'.'''
        raise NotImplementedError()
    
    @text_qualifier.setter
    def text_qualifier(self, value : str) -> None:
        '''Specifies the text qualifier for cell values. Default qualifier is \'"\'.'''
        raise NotImplementedError()
    
    @property
    def treat_consecutive_delimiters_as_one(self) -> bool:
        '''Whether consecutive delimiters should be treated as one.'''
        raise NotImplementedError()
    
    @treat_consecutive_delimiters_as_one.setter
    def treat_consecutive_delimiters_as_one(self, value : bool) -> None:
        '''Whether consecutive delimiters should be treated as one.'''
        raise NotImplementedError()
    
    @property
    def treat_quote_prefix_as_value(self) -> bool:
        '''Indicates whether the leading single quote sign should be taken as part of the value of one cell.
        Default is true. If it is false, the leading single quote will be removed from corresponding cell\'s value
        and :py:attr:`aspose.cells.Style.quote_prefix` will be set as true for the cell.'''
        raise NotImplementedError()
    
    @treat_quote_prefix_as_value.setter
    def treat_quote_prefix_as_value(self, value : bool) -> None:
        '''Indicates whether the leading single quote sign should be taken as part of the value of one cell.
        Default is true. If it is false, the leading single quote will be removed from corresponding cell\'s value
        and :py:attr:`aspose.cells.Style.quote_prefix` will be set as true for the cell.'''
        raise NotImplementedError()
    
    @property
    def extend_to_next_sheet(self) -> bool:
        '''Whether extends data to next sheet when the rows or columns of data exceed limit.
        Default is false.'''
        raise NotImplementedError()
    
    @extend_to_next_sheet.setter
    def extend_to_next_sheet(self, value : bool) -> None:
        '''Whether extends data to next sheet when the rows or columns of data exceed limit.
        Default is false.'''
        raise NotImplementedError()
    
    @property
    def header_rows_count(self) -> int:
        '''The count of header rows to be repeated for extended sheets.'''
        raise NotImplementedError()
    
    @header_rows_count.setter
    def header_rows_count(self, value : int) -> None:
        '''The count of header rows to be repeated for extended sheets.'''
        raise NotImplementedError()
    
    @property
    def header_columns_count(self) -> int:
        '''The count of header columns to be repeated for extended sheets.'''
        raise NotImplementedError()
    
    @header_columns_count.setter
    def header_columns_count(self, value : int) -> None:
        '''The count of header columns to be repeated for extended sheets.'''
        raise NotImplementedError()
    
    @property
    def max_row_count(self) -> int:
        '''The maximum count of rows to be imported for one sheet.'''
        raise NotImplementedError()
    
    @max_row_count.setter
    def max_row_count(self, value : int) -> None:
        '''The maximum count of rows to be imported for one sheet.'''
        raise NotImplementedError()
    
    @property
    def max_column_count(self) -> int:
        '''The maximum count of columns to be imported for one sheet.'''
        raise NotImplementedError()
    
    @max_column_count.setter
    def max_column_count(self, value : int) -> None:
        '''The maximum count of columns to be imported for one sheet.'''
        raise NotImplementedError()
    

class TxtSaveOptions(SaveOptions):
    '''Represents the save options for csv/tab delimited/other text format.'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def separator(self) -> str:
        '''Gets and sets char Delimiter of text file.'''
        raise NotImplementedError()
    
    @separator.setter
    def separator(self, value : str) -> None:
        '''Gets and sets char Delimiter of text file.'''
        raise NotImplementedError()
    
    @property
    def separator_string(self) -> str:
        '''Gets and sets a string value as separator.'''
        raise NotImplementedError()
    
    @separator_string.setter
    def separator_string(self, value : str) -> None:
        '''Gets and sets a string value as separator.'''
        raise NotImplementedError()
    
    @property
    def encoding(self) -> str:
        '''Gets and sets the default encoding.'''
        raise NotImplementedError()
    
    @encoding.setter
    def encoding(self, value : str) -> None:
        '''Gets and sets the default encoding.'''
        raise NotImplementedError()
    
    @property
    def always_quoted(self) -> bool:
        '''Indicates whether always adding \'"\' for each field.
        If true then all values will be quoted;
        If false then values will only be quoted when needed(for example,
        when values contain special characters such as \'"\' , \'\n\' or separator character).
        Default is false.'''
        raise NotImplementedError()
    
    @always_quoted.setter
    def always_quoted(self, value : bool) -> None:
        '''Indicates whether always adding \'"\' for each field.
        If true then all values will be quoted;
        If false then values will only be quoted when needed(for example,
        when values contain special characters such as \'"\' , \'\n\' or separator character).
        Default is false.'''
        raise NotImplementedError()
    
    @property
    def quote_type(self) -> aspose.cells.TxtValueQuoteType:
        '''Gets how to quote values in the exported text file.'''
        raise NotImplementedError()
    
    @quote_type.setter
    def quote_type(self, value : aspose.cells.TxtValueQuoteType) -> None:
        '''Sets how to quote values in the exported text file.'''
        raise NotImplementedError()
    
    @property
    def format_strategy(self) -> aspose.cells.CellValueFormatStrategy:
        '''Gets and sets the format strategy when exporting the cell value as string.'''
        raise NotImplementedError()
    
    @format_strategy.setter
    def format_strategy(self, value : aspose.cells.CellValueFormatStrategy) -> None:
        '''Gets and sets the format strategy when exporting the cell value as string.'''
        raise NotImplementedError()
    
    @property
    def light_cells_data_provider(self) -> aspose.cells.LightCellsDataProvider:
        '''The data provider for saving workbook in light mode.'''
        raise NotImplementedError()
    
    @light_cells_data_provider.setter
    def light_cells_data_provider(self, value : aspose.cells.LightCellsDataProvider) -> None:
        '''The data provider for saving workbook in light mode.'''
        raise NotImplementedError()
    
    @property
    def trim_leading_blank_row_and_column(self) -> bool:
        '''Indicates whether leading blank rows and columns should be trimmed like what ms excel does.
        Default is true.'''
        raise NotImplementedError()
    
    @trim_leading_blank_row_and_column.setter
    def trim_leading_blank_row_and_column(self, value : bool) -> None:
        '''Indicates whether leading blank rows and columns should be trimmed like what ms excel does.
        Default is true.'''
        raise NotImplementedError()
    
    @property
    def trim_tailing_blank_cells(self) -> bool:
        '''Indicates whether tailing blank cells in one row should be trimmed. Default is false.'''
        raise NotImplementedError()
    
    @trim_tailing_blank_cells.setter
    def trim_tailing_blank_cells(self, value : bool) -> None:
        '''Indicates whether tailing blank cells in one row should be trimmed. Default is false.'''
        raise NotImplementedError()
    
    @property
    def keep_separators_for_blank_row(self) -> bool:
        '''Indicates whether separators should be output for blank row.
        Default value is false so by default the content for blank row will be empty.'''
        raise NotImplementedError()
    
    @keep_separators_for_blank_row.setter
    def keep_separators_for_blank_row(self, value : bool) -> None:
        '''Indicates whether separators should be output for blank row.
        Default value is false so by default the content for blank row will be empty.'''
        raise NotImplementedError()
    
    @property
    def export_area(self) -> aspose.cells.CellArea:
        '''The range of cells to be exported.'''
        raise NotImplementedError()
    
    @export_area.setter
    def export_area(self, value : aspose.cells.CellArea) -> None:
        '''The range of cells to be exported.'''
        raise NotImplementedError()
    
    @property
    def export_quote_prefix(self) -> bool:
        '''Indicates whether the single quote sign should be exported as part of the value of one cell
        when :py:attr:`aspose.cells.Style.quote_prefix` is true for it. Default is false.'''
        raise NotImplementedError()
    
    @export_quote_prefix.setter
    def export_quote_prefix(self, value : bool) -> None:
        '''Indicates whether the single quote sign should be exported as part of the value of one cell
        when :py:attr:`aspose.cells.Style.quote_prefix` is true for it. Default is false.'''
        raise NotImplementedError()
    
    @property
    def export_all_sheets(self) -> bool:
        '''Indicates whether exporting all sheets to the text file.
        If it is false, only export the activesheet, just like MS Excel.'''
        raise NotImplementedError()
    
    @export_all_sheets.setter
    def export_all_sheets(self, value : bool) -> None:
        '''Indicates whether exporting all sheets to the text file.
        If it is false, only export the activesheet, just like MS Excel.'''
        raise NotImplementedError()
    

class UnionRange:
    '''Represents union range.'''
    
    @overload
    def set_outline_borders(self, border_styles : List[aspose.cells.CellBorderType], border_colors : List[aspose.pydrawing.Color]) -> None:
        '''Sets out line borders around a range of cells.
        
        :param border_styles: Border styles.
        :param border_colors: Border colors.'''
        raise NotImplementedError()
    
    @overload
    def set_outline_borders(self, border_style : aspose.cells.CellBorderType, border_color : aspose.pydrawing.Color) -> None:
        '''Sets the outline borders around a range of cells with same border style and color.
        
        :param border_style: Border style.
        :param border_color: Border color.'''
        raise NotImplementedError()
    
    @overload
    def intersect(self, range : str) -> aspose.cells.UnionRange:
        '''Intersects another range.
        
        :param range: The range.'''
        raise NotImplementedError()
    
    @overload
    def intersect(self, union_range : aspose.cells.UnionRange) -> aspose.cells.UnionRange:
        '''Intersects another range.
        
        :param union_range: The range.'''
        raise NotImplementedError()
    
    @overload
    def intersect(self, ranges : List[aspose.cells.Range]) -> aspose.cells.UnionRange:
        '''Intersects another range.
        
        :param ranges: The range.'''
        raise NotImplementedError()
    
    @overload
    def union(self, range : str) -> aspose.cells.UnionRange:
        '''Union another range.
        
        :param range: The range.'''
        raise NotImplementedError()
    
    @overload
    def union(self, union_range : aspose.cells.UnionRange) -> aspose.cells.UnionRange:
        '''Union another range.
        
        :param union_range: The range.'''
        raise NotImplementedError()
    
    @overload
    def union(self, ranges : List[aspose.cells.Range]) -> aspose.cells.UnionRange:
        '''Union the ranges.
        
        :param ranges: The ranges.'''
        raise NotImplementedError()
    
    def merge(self) -> None:
        '''Combines a range of cells into a single cell.'''
        raise NotImplementedError()
    
    def un_merge(self) -> None:
        '''Unmerges merged cells of this range.'''
        raise NotImplementedError()
    
    def put_value(self, string_value : str, is_converted : bool, set_style : bool) -> None:
        '''Puts a value into the range, if appropriate the value will be converted to other data type and cell\'s number format will be reset.
        
        :param string_value: Input value
        :param is_converted: True: converted to other data type if appropriate.
        :param set_style: True: set the number format to cell\'s style when converting to other data type'''
        raise NotImplementedError()
    
    def set_style(self, style : aspose.cells.Style) -> None:
        '''Sets the style of the range.
        
        :param style: The Style object.'''
        raise NotImplementedError()
    
    def apply_style(self, style : aspose.cells.Style, flag : aspose.cells.StyleFlag) -> None:
        '''Applies formats for a whole range.
        
        :param style: The style object which will be applied.
        :param flag: Flags which indicates applied formatting properties.'''
        raise NotImplementedError()
    
    def copy(self, range : aspose.cells.UnionRange, options : aspose.cells.PasteOptions) -> None:
        '''Copying the range with paste special options.
        
        :param range: The source range.
        :param options: The paste special options.'''
        raise NotImplementedError()
    
    def get_enumerator(self) -> collections.abc.Iterator[Any]:
        '''Gets the enumerator for cells in this Range.
        
        :returns: The cells enumerator'''
        raise NotImplementedError()
    
    @property
    def first_row(self) -> int:
        '''Gets the index of the first row of the range.'''
        raise NotImplementedError()
    
    @property
    def first_column(self) -> int:
        '''Gets the index of the first column of the range.'''
        raise NotImplementedError()
    
    @property
    def row_count(self) -> int:
        '''Gets the count of rows in the range.'''
        raise NotImplementedError()
    
    @property
    def column_count(self) -> int:
        '''Gets the count of rows in the range.'''
        raise NotImplementedError()
    
    @property
    def value(self) -> Any:
        '''Gets and sets the values of the range.'''
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : Any) -> None:
        '''Gets and sets the values of the range.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets the name of the range.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Sets the name of the range.'''
        raise NotImplementedError()
    
    @property
    def refers_to(self) -> str:
        '''Gets the range\'s refers to.'''
        raise NotImplementedError()
    
    @property
    def has_range(self) -> bool:
        '''Indicates whether this has range.'''
        raise NotImplementedError()
    
    @property
    def hyperlinks(self) -> List[aspose.cells.Hyperlink]:
        '''Gets all hyperlink in the range.'''
        raise NotImplementedError()
    
    @property
    def cell_count(self) -> int:
        '''Gets all cell count in the range.'''
        raise NotImplementedError()
    
    @property
    def range_count(self) -> int:
        '''Gets the count of the ranges.'''
        raise NotImplementedError()
    
    @property
    def ranges(self) -> List[aspose.cells.Range]:
        '''Gets all union ranges.'''
        raise NotImplementedError()
    

class Validation:
    '''Represents data validation.settings.'''
    
    @overload
    def get_formula1(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the value or expression associated with this validation.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The value or expression associated with this validation.'''
        raise NotImplementedError()
    
    @overload
    def get_formula1(self, is_r1c1 : bool, is_local : bool, row : int, column : int) -> str:
        '''Gets the value or expression associated with this validation for specific cell.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :param row: The row index.
        :param column: The column index.
        :returns: The value or expression associated with this validation.'''
        raise NotImplementedError()
    
    @overload
    def get_formula2(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the value or expression associated with this validation.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The value or expression associated with this validation.'''
        raise NotImplementedError()
    
    @overload
    def get_formula2(self, is_r1c1 : bool, is_local : bool, row : int, column : int) -> str:
        '''Gets the value or expression associated with this validation for specific cell.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :param row: The row index.
        :param column: The column index.
        :returns: The value or expression associated with this validation.'''
        raise NotImplementedError()
    
    @overload
    def add_area(self, cell_area : aspose.cells.CellArea) -> None:
        '''Applies the validation to the area.
        
        :param cell_area: The area.'''
        raise NotImplementedError()
    
    @overload
    def add_area(self, cell_area : aspose.cells.CellArea, check_intersection : bool, check_edge : bool) -> None:
        '''Applies the validation to the area.
        
        :param cell_area: The area.
        :param check_intersection: Whether check the intersection of given area with existing validations\' areas.
        If one validation has been applied in given area(or part of it),
        then the existing validation should be removed at first from given area.
        Otherwise corruption may be caused for the generated Validations.
        If user is sure that the added area does not intersect with any existing area,
        this parameter can be set as false for performance consideration.
        :param check_edge: Whether check the edge of this validation\'s applied areas.
        Validation\'s internal settings depend on the top-left one of its applied ranges,
        so if given area will become the new top-left one of the applied ranges,
        the internal settings should be changed and rebuilt, otherwise unexpected result may be caused.
        If user is sure that the added area is not the top-left one,
        this parameter can be set as false for performance consideration.'''
        raise NotImplementedError()
    
    def set_formula1(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the value or expression associated with this validation.
        
        :param formula: The value or expression associated with this format condition.
        :param is_r1c1: Whether the formula is R1C1 formula.
        :param is_local: Whether the formula is locale formatted.'''
        raise NotImplementedError()
    
    def set_formula2(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the value or expression associated with this validation.
        
        :param formula: The value or expression associated with this format condition.
        :param is_r1c1: Whether the formula is R1C1 formula.
        :param is_local: Whether the formula is locale formatted.'''
        raise NotImplementedError()
    
    def get_list_value(self, row : int, column : int) -> Any:
        '''Get the value for list of the validation for the specified cell.
        
        :param row: The row index.
        :param column: The column index.
        :returns: The value to produce the list of this validation for the specified cell.
        If the list references to a range, then the returned value will be a :py:class:`aspose.cells.ReferredArea` object;
        Otherwise the returned value may be null, object[], or simple object.'''
        raise NotImplementedError()
    
    def get_value(self, row : int, column : int, is_value1 : bool) -> Any:
        '''Get the value of validation on the specific cell.
        
        :param row: The row index.
        :param column: The column index.
        :param is_value1: Indicates whether getting the first value.'''
        raise NotImplementedError()
    
    def add_areas(self, areas : List[aspose.cells.CellArea], check_intersection : bool, check_edge : bool) -> None:
        '''Applies the validation to given areas.
        
        :param areas: The areas.
        :param check_intersection: Whether check the intersection of given area with existing validations\' areas.
        If one validation has been applied in given area(or part of it),
        then the existing validation should be removed at first from given area.
        Otherwise corruption may be caused for the generated Validations.
        If user is sure that all the added areas do not intersect with any existing area,
        this parameter can be set as false for performance consideration.
        :param check_edge: Whether check the edge of this validation\'s applied areas.
        Validation\'s internal settings depend on the top-left one of its applied ranges,
        so if one of given areas will become the new top-left one of the applied ranges,
        the internal settings should be changed and rebuilt, otherwise unexpected result may be caused.
        If user is sure that no one of those added areas is the top-left,
        this parameter can be set as false for performance consideration.'''
        raise NotImplementedError()
    
    def remove_area(self, cell_area : aspose.cells.CellArea) -> None:
        '''Remove the validation settings in the range.
        
        :param cell_area: the areas where this validation settings should be removed.'''
        raise NotImplementedError()
    
    def remove_areas(self, areas : List[aspose.cells.CellArea]) -> None:
        '''Removes this validation from given areas.
        
        :param areas: the areas where this validation settings should be removed.'''
        raise NotImplementedError()
    
    def remove_a_cell(self, row : int, column : int) -> None:
        '''Remove the validation settings in the cell.
        
        :param row: The row index.
        :param column: The column index.'''
        raise NotImplementedError()
    
    def copy(self, source : aspose.cells.Validation, copy_option : aspose.cells.CopyOptions) -> None:
        '''Copy validation.
        
        :param source: The source validation.
        :param copy_option: The copy option.'''
        raise NotImplementedError()
    
    @property
    def operator(self) -> aspose.cells.OperatorType:
        '''Represents the operator for the data validation.'''
        raise NotImplementedError()
    
    @operator.setter
    def operator(self, value : aspose.cells.OperatorType) -> None:
        '''Represents the operator for the data validation.'''
        raise NotImplementedError()
    
    @property
    def alert_style(self) -> aspose.cells.ValidationAlertType:
        '''Represents the validation alert style.'''
        raise NotImplementedError()
    
    @alert_style.setter
    def alert_style(self, value : aspose.cells.ValidationAlertType) -> None:
        '''Represents the validation alert style.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.ValidationType:
        '''Represents the data validation type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.cells.ValidationType) -> None:
        '''Represents the data validation type.'''
        raise NotImplementedError()
    
    @property
    def input_message(self) -> str:
        '''Represents the data validation input message.'''
        raise NotImplementedError()
    
    @input_message.setter
    def input_message(self, value : str) -> None:
        '''Represents the data validation input message.'''
        raise NotImplementedError()
    
    @property
    def input_title(self) -> str:
        '''Represents the title of the data-validation input dialog box.'''
        raise NotImplementedError()
    
    @input_title.setter
    def input_title(self, value : str) -> None:
        '''Represents the title of the data-validation input dialog box.'''
        raise NotImplementedError()
    
    @property
    def error_message(self) -> str:
        '''Represents the data validation error message.'''
        raise NotImplementedError()
    
    @error_message.setter
    def error_message(self, value : str) -> None:
        '''Represents the data validation error message.'''
        raise NotImplementedError()
    
    @property
    def error_title(self) -> str:
        '''Represents the title of the data-validation error dialog box.'''
        raise NotImplementedError()
    
    @error_title.setter
    def error_title(self, value : str) -> None:
        '''Represents the title of the data-validation error dialog box.'''
        raise NotImplementedError()
    
    @property
    def show_input(self) -> bool:
        '''Indicates whether the data validation input message will be displayed whenever the user selects a cell in the data validation range.'''
        raise NotImplementedError()
    
    @show_input.setter
    def show_input(self, value : bool) -> None:
        '''Indicates whether the data validation input message will be displayed whenever the user selects a cell in the data validation range.'''
        raise NotImplementedError()
    
    @property
    def show_error(self) -> bool:
        '''Indicates whether the data validation error message will be displayed whenever the user enters invalid data.'''
        raise NotImplementedError()
    
    @show_error.setter
    def show_error(self, value : bool) -> None:
        '''Indicates whether the data validation error message will be displayed whenever the user enters invalid data.'''
        raise NotImplementedError()
    
    @property
    def ignore_blank(self) -> bool:
        '''Indicates whether blank values are permitted by the range data validation.'''
        raise NotImplementedError()
    
    @ignore_blank.setter
    def ignore_blank(self, value : bool) -> None:
        '''Indicates whether blank values are permitted by the range data validation.'''
        raise NotImplementedError()
    
    @property
    def formula1(self) -> str:
        '''Represents the value or expression associated with the data validation.'''
        raise NotImplementedError()
    
    @formula1.setter
    def formula1(self, value : str) -> None:
        '''Represents the value or expression associated with the data validation.'''
        raise NotImplementedError()
    
    @property
    def formula2(self) -> str:
        '''Represents the value or expression associated with the data validation.'''
        raise NotImplementedError()
    
    @formula2.setter
    def formula2(self, value : str) -> None:
        '''Represents the value or expression associated with the data validation.'''
        raise NotImplementedError()
    
    @property
    def value1(self) -> Any:
        '''Represents the first value associated with the data validation.'''
        raise NotImplementedError()
    
    @value1.setter
    def value1(self, value : Any) -> None:
        '''Represents the first value associated with the data validation.'''
        raise NotImplementedError()
    
    @property
    def value2(self) -> Any:
        '''Represents the second value associated with the data validation.'''
        raise NotImplementedError()
    
    @value2.setter
    def value2(self, value : Any) -> None:
        '''Represents the second value associated with the data validation.'''
        raise NotImplementedError()
    
    @property
    def in_cell_drop_down(self) -> bool:
        '''Indicates whether data validation displays a drop-down list that contains acceptable values.'''
        raise NotImplementedError()
    
    @in_cell_drop_down.setter
    def in_cell_drop_down(self, value : bool) -> None:
        '''Indicates whether data validation displays a drop-down list that contains acceptable values.'''
        raise NotImplementedError()
    
    @property
    def areas(self) -> List[aspose.cells.CellArea]:
        '''Gets all :py:class:`aspose.cells.CellArea` which contain the data validation settings.'''
        raise NotImplementedError()
    

class ValidationCollection:
    '''Represents data validation collection.'''
    
    @overload
    def add(self) -> int:
        '''Adds a data validation to the collection.
        
        :returns: :py:class:`aspose.cells.Validation` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, ca : aspose.cells.CellArea) -> int:
        '''Adds a data validation to the collection.
        
        :param ca: The area contains this validation.
        :returns: :py:class:`aspose.cells.Validation` object index.'''
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.Validation]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.Validation], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Validation, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Validation, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Validation) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Validation, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Validation, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def remove_a_cell(self, row : int, column : int) -> None:
        '''Removes all validation setting on the cell.
        
        :param row: The row index of the cell.
        :param column: The column index of the cell.'''
        raise NotImplementedError()
    
    def remove_area(self, ca : aspose.cells.CellArea) -> None:
        '''Removes all validation setting on the range..
        
        :param ca: The range which contains the validations setting.'''
        raise NotImplementedError()
    
    def get_validation_in_cell(self, row : int, column : int) -> aspose.cells.Validation:
        '''Gets the validation applied to given cell.
        
        :param row: The row index.
        :param column: The column index.
        :returns: Returns a :py:class:`aspose.cells.Validation` object or null if there is no validation for given cell'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.Validation) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class VerticalPageBreak:
    '''Encapsulates the object that represents a vertical page break.'''
    
    @property
    def start_row(self) -> int:
        '''Gets the start row index of the vertical page break.'''
        raise NotImplementedError()
    
    @property
    def end_row(self) -> int:
        '''Gets the end row index of the vertical page break.'''
        raise NotImplementedError()
    
    @property
    def column(self) -> int:
        '''Gets the column index of the vertical page break.'''
        raise NotImplementedError()
    

class VerticalPageBreakCollection:
    '''Encapsulates a collection of :py:class:`aspose.cells.VerticalPageBreak` objects.'''
    
    @overload
    def add(self, start_row : int, end_row : int, column : int) -> int:
        '''Adds a vertical page break to the collection.
        
        :param start_row: Start row index, zero based.
        :param end_row: End row index, zero based.
        :param column: Column index, zero based.
        :returns: :py:class:`aspose.cells.VerticalPageBreak` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, column : int) -> int:
        '''Adds a vertical page break to the collection.
        
        :param column: Cell column index, zero based.
        :returns: :py:class:`aspose.cells.VerticalPageBreak` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, row : int, column : int) -> int:
        '''Adds a vertical page break to the collection.
        
        :param row: Cell row index, zero based.
        :param column: Cell column index, zero based.
        :returns: :py:class:`aspose.cells.VerticalPageBreak` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, cell_name : str) -> int:
        '''Adds a vertical page break to the collection.
        
        :param cell_name: Cell name.
        :returns: :py:class:`aspose.cells.VerticalPageBreak` object index.'''
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.VerticalPageBreak]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.VerticalPageBreak], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.VerticalPageBreak, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.VerticalPageBreak, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.VerticalPageBreak) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.VerticalPageBreak, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.VerticalPageBreak, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.VerticalPageBreak) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class WarningInfo:
    '''Warning info'''
    
    @property
    def warning_type(self) -> aspose.cells.WarningType:
        '''Get warning type.'''
        raise NotImplementedError()
    
    @property
    def description(self) -> str:
        '''Get description of warning info.'''
        raise NotImplementedError()
    
    @property
    def error_object(self) -> Any:
        '''The error object.'''
        raise NotImplementedError()
    
    @property
    def corrected_object(self) -> Any:
        '''Gets and sets the corrected object.'''
        raise NotImplementedError()
    
    @corrected_object.setter
    def corrected_object(self, value : Any) -> None:
        '''Gets and sets the corrected object.'''
        raise NotImplementedError()
    

class Workbook:
    '''Represents a root object to create an Excel spreadsheet.'''
    
    @overload
    def save(self, file_name : str, save_format : aspose.cells.SaveFormat) -> None:
        '''Saves the workbook to the disk.
        
        :param file_name: The file name.
        :param save_format: The save format type.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_name : str) -> None:
        '''Save the workbook to the disk.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_name : str, save_options : aspose.cells.SaveOptions) -> None:
        '''Saves the workbook to the disk.
        
        :param file_name: The file name.
        :param save_options: The save options.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io.RawIOBase, save_format : aspose.cells.SaveFormat) -> None:
        '''Saves the workbook to the stream.
        
        :param stream: The file stream.
        :param save_format: The save file format type.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io.RawIOBase, save_options : aspose.cells.SaveOptions) -> None:
        '''Saves the workbook to the stream.
        
        :param stream: The file stream.
        :param save_options: The save options.'''
        raise NotImplementedError()
    
    @overload
    def replace(self, place_holder : str, new_value : str) -> int:
        '''Replaces a cell\'s value with a new string.
        
        :param place_holder: Cell placeholder
        :param new_value: String value to replace'''
        raise NotImplementedError()
    
    @overload
    def replace(self, place_holder : str, new_value : int) -> int:
        '''Replaces a cell\'s value with a new integer.
        
        :param place_holder: Cell placeholder
        :param new_value: Integer value to replace'''
        raise NotImplementedError()
    
    @overload
    def replace(self, place_holder : str, new_value : float) -> int:
        '''Replaces a cell\'s value with a new double.
        
        :param place_holder: Cell placeholder
        :param new_value: Double value to replace'''
        raise NotImplementedError()
    
    @overload
    def replace(self, place_holder : str, new_values : List[str], is_vertical : bool) -> int:
        '''Replaces a cell\'s value with a new string array.
        
        :param place_holder: Cell placeholder
        :param new_values: String array to replace
        :param is_vertical: True - Vertical, False - Horizontal'''
        raise NotImplementedError()
    
    @overload
    def replace(self, place_holder : str, new_values : List[int], is_vertical : bool) -> int:
        '''Replaces cells\' values with an integer array.
        
        :param place_holder: Cell placeholder
        :param new_values: Integer array to replace
        :param is_vertical: True - Vertical, False - Horizontal'''
        raise NotImplementedError()
    
    @overload
    def replace(self, place_holder : str, new_values : List[float], is_vertical : bool) -> int:
        '''Replaces cells\' values with a double array.
        
        :param place_holder: Cell placeholder
        :param new_values: Double array to replace
        :param is_vertical: True - Vertical, False - Horizontal'''
        raise NotImplementedError()
    
    @overload
    def replace(self, bool_value : bool, new_value : Any) -> int:
        '''Replaces cells\' values with new data.
        
        :param bool_value: The boolean value to be replaced.
        :param new_value: New value. Can be string, integer, double or DateTime value.'''
        raise NotImplementedError()
    
    @overload
    def replace(self, int_value : int, new_value : Any) -> int:
        '''Replaces cells\' values with new data.
        
        :param int_value: The integer value to be replaced.
        :param new_value: New value. Can be string, integer, double or DateTime value.'''
        raise NotImplementedError()
    
    @overload
    def replace(self, place_holder : str, new_value : str, options : aspose.cells.ReplaceOptions) -> int:
        '''Replaces a cell\'s value with a new string.
        
        :param place_holder: Cell placeholder
        :param new_value: String value to replace
        :param options: The replace options'''
        raise NotImplementedError()
    
    @overload
    def copy(self, source : aspose.cells.Workbook, copy_options : aspose.cells.CopyOptions) -> None:
        '''Copies another Workbook object.
        
        :param source: Source Workbook object.
        :param copy_options: The options of copying other workbook.'''
        raise NotImplementedError()
    
    @overload
    def copy(self, source : aspose.cells.Workbook) -> None:
        '''Copies data from a source Workbook object.
        
        :param source: Source Workbook object.'''
        raise NotImplementedError()
    
    @overload
    def calculate_formula(self) -> None:
        '''Calculates the result of formulas.'''
        raise NotImplementedError()
    
    @overload
    def calculate_formula(self, ignore_error : bool) -> None:
        '''Calculates the result of formulas.
        
        :param ignore_error: Indicates if hide the error in calculating formulas. The error may be unsupported function, external links, etc.'''
        raise NotImplementedError()
    
    @overload
    def calculate_formula(self, options : aspose.cells.CalculationOptions) -> None:
        '''Calculating formulas in this workbook.
        
        :param options: Options for calculation'''
        raise NotImplementedError()
    
    @overload
    def refresh_dynamic_array_formulas(self, calculate : bool) -> None:
        '''Refreshes dynamic array formulas(spill into new range of neighboring cells according to current data)
        Other formulas in the workbook will not be calculated recursively even if they were used by dynamic array formulas.
        
        :param calculate: Whether calculates and updates cell values for those dynamic array formulas'''
        raise NotImplementedError()
    
    @overload
    def refresh_dynamic_array_formulas(self, calculate : bool, copts : aspose.cells.CalculationOptions) -> None:
        '''Refreshes dynamic array formulas(spill into new range of neighboring cells according to current data)
        
        :param calculate: Whether calculates and updates cell values for those dynamic array formulas
        :param copts: The options for calculating formulas'''
        raise NotImplementedError()
    
    @overload
    def import_xml(self, url : str, sheet_name : str, row : int, col : int) -> None:
        '''Imports/Updates an XML data file into the workbook.
        
        :param url: the url/path of the xml file.
        :param sheet_name: the destination sheet name.
        :param row: the destination row
        :param col: the destination column'''
        raise NotImplementedError()
    
    @overload
    def import_xml(self, stream : io.RawIOBase, sheet_name : str, row : int, col : int) -> None:
        '''Imports/Updates an XML data file into the workbook.
        
        :param stream: the xml file stream.
        :param sheet_name: the destination sheet name.
        :param row: the destination row.
        :param col: the destination column.'''
        raise NotImplementedError()
    
    @overload
    def export_xml(self, map_name : str, path : str) -> None:
        '''Export XML data linked by the specified XML map.
        
        :param map_name: name of the XML map that need to be exported
        :param path: the export path'''
        raise NotImplementedError()
    
    @overload
    def export_xml(self, map_name : str, stream : io.RawIOBase) -> None:
        '''Export XML data.
        
        :param map_name: name of the XML map that need to be exported
        :param stream: the export stream'''
        raise NotImplementedError()
    
    def parse_formulas(self, ignore_error : bool) -> None:
        '''Parses all formulas which have not been parsed when they were loaded from template file or set to a cell.
        
        :param ignore_error: Whether ignore error for invalid formula.
        For one invalid formula, if ignore error then this formula will be ignored
        and the process will continue to parse other formulas, otherwise exception will be thrown.'''
        raise NotImplementedError()
    
    def start_access_cache(self, opts : aspose.cells.AccessCacheOptions) -> None:
        '''Starts the session that uses caches to access data.
        
        :param opts: options of data access'''
        raise NotImplementedError()
    
    def close_access_cache(self, opts : aspose.cells.AccessCacheOptions) -> None:
        '''Closes the session that uses caches to access data.
        
        :param opts: options of data access'''
        raise NotImplementedError()
    
    def remove_unused_styles(self) -> None:
        '''Remove all unused styles.'''
        raise NotImplementedError()
    
    def create_style(self) -> aspose.cells.Style:
        '''Creates a new style.
        
        :returns: Returns a style object.'''
        raise NotImplementedError()
    
    def create_builtin_style(self, type : aspose.cells.BuiltinStyleType) -> aspose.cells.Style:
        '''Creates built-in style by given type.
        
        :param type: The builtin style stype.
        :returns: :py:class:`aspose.cells.Style` object'''
        raise NotImplementedError()
    
    def create_cells_color(self) -> aspose.cells.CellsColor:
        '''Creates a :py:class:`aspose.cells.CellsColor` object.
        
        :returns: Returns a :py:class:`aspose.cells.CellsColor` object.'''
        raise NotImplementedError()
    
    def combine(self, second_workbook : aspose.cells.Workbook) -> None:
        '''Combines another Workbook object.
        
        :param second_workbook: Another Workbook object.'''
        raise NotImplementedError()
    
    def get_style_in_pool(self, index : int) -> aspose.cells.Style:
        '''Gets the style in the style pool.
        All styles in the workbook will be gathered into a pool.
        There is only a simple reference index in the cells.
        
        :param index: The index.
        :returns: The style in the pool corresponds to given index, may be null.'''
        raise NotImplementedError()
    
    def get_fonts(self) -> List[aspose.cells.Font]:
        '''Gets all fonts in the style pool.'''
        raise NotImplementedError()
    
    def get_named_style(self, name : str) -> aspose.cells.Style:
        '''Gets the named style in the style pool.
        
        :param name: name of the style
        :returns: named style, maybe null.'''
        raise NotImplementedError()
    
    def change_palette(self, color : aspose.pydrawing.Color, index : int) -> None:
        '''Changes the palette for the spreadsheet in the specified index.
        
        :param color: Color structure.
        :param index: Palette index, 0 - 55.'''
        raise NotImplementedError()
    
    def is_color_in_palette(self, color : aspose.pydrawing.Color) -> bool:
        '''Checks if a color is in the palette for the spreadsheet.
        
        :param color: Color structure.
        :returns: Returns true if this color is in the palette. Otherwise, returns false'''
        raise NotImplementedError()
    
    def get_matching_color(self, raw_color : aspose.pydrawing.Color) -> aspose.pydrawing.Color:
        '''Find best matching Color in current palette.
        
        :param raw_color: Raw color.
        :returns: Best matching color.'''
        raise NotImplementedError()
    
    def set_encryption_options(self, encryption_type : aspose.cells.EncryptionType, key_length : int) -> None:
        '''Set Encryption Options.
        
        :param encryption_type: The encryption type.
        :param key_length: The key length.'''
        raise NotImplementedError()
    
    def protect(self, protection_type : aspose.cells.ProtectionType, password : str) -> None:
        '''Protects a workbook.
        
        :param protection_type: Protection type.
        :param password: Password to protect the workbook.'''
        raise NotImplementedError()
    
    def protect_shared_workbook(self, password : str) -> None:
        '''Protects a shared workbook.
        
        :param password: Password to protect the workbook.'''
        raise NotImplementedError()
    
    def unprotect(self, password : str) -> None:
        '''Unprotects a workbook.
        
        :param password: Password to unprotect the workbook.'''
        raise NotImplementedError()
    
    def unprotect_shared_workbook(self, password : str) -> None:
        '''Unprotects a shared workbook.
        
        :param password: Password to unprotect the workbook.'''
        raise NotImplementedError()
    
    def remove_macro(self) -> None:
        '''Removes VBA/macro from this spreadsheet.'''
        raise NotImplementedError()
    
    def remove_digital_signature(self) -> None:
        '''Removes digital signature from this spreadsheet.'''
        raise NotImplementedError()
    
    def accept_all_revisions(self) -> None:
        '''Accepts all tracked changes in the workbook.'''
        raise NotImplementedError()
    
    def remove_external_links(self) -> None:
        '''Removes all external links in the workbook.'''
        raise NotImplementedError()
    
    def get_theme_color(self, type : aspose.cells.ThemeColorType) -> aspose.pydrawing.Color:
        '''Gets theme color.
        
        :param type: The theme color type.
        :returns: The theme color.'''
        raise NotImplementedError()
    
    def set_theme_color(self, type : aspose.cells.ThemeColorType, color : aspose.pydrawing.Color) -> None:
        '''Sets the theme color
        
        :param type: The theme color type.
        :param color: the theme color'''
        raise NotImplementedError()
    
    def custom_theme(self, theme_name : str, colors : List[aspose.pydrawing.Color]) -> None:
        '''Customs the theme.
        
        :param theme_name: The theme name
        :param colors: The theme colors'''
        raise NotImplementedError()
    
    def copy_theme(self, source : aspose.cells.Workbook) -> None:
        '''Copies the theme from another workbook.
        
        :param source: Source workbook.'''
        raise NotImplementedError()
    
    def has_exernal_links(self) -> bool:
        '''Indicates whether this workbook contains external links to other data sources.
        
        :returns: Whether this workbook contains external links to other data sources.'''
        raise NotImplementedError()
    
    def update_custom_function_definition(self, definition : aspose.cells.CustomFunctionDefinition) -> None:
        '''Updates definition of custom functions.
        
        :param definition: Special definition of custom functions for user\'s special requirement.'''
        raise NotImplementedError()
    
    def update_linked_data_source(self, external_workbooks : List[aspose.cells.Workbook]) -> None:
        '''If this workbook contains external links to other data source,
        Aspose.Cells will attempt to retrieve the latest data from give sources.
        
        :param external_workbooks: Workbooks that will be used to update data of external links referenced by this workbook.
        The match of those workbooks with external links is determined by :py:attr:`aspose.cells.Workbook.file_name`
        and :py:attr:`aspose.cells.ExternalLink.data_source`. So please make sure :py:attr:`aspose.cells.Workbook.file_name` has
        been specified with the proper value for every workbook so they can be linked to corresponding external link.'''
        raise NotImplementedError()
    
    def set_digital_signature(self, digital_signature_collection : aspose.cells.digitalsignatures.DigitalSignatureCollection) -> None:
        '''Sets digital signature to an spreadsheet file (Excel2007 and later).'''
        raise NotImplementedError()
    
    def add_digital_signature(self, digital_signature_collection : aspose.cells.digitalsignatures.DigitalSignatureCollection) -> None:
        '''Adds digital signature to an OOXML spreadsheet file (Excel2007 and later).'''
        raise NotImplementedError()
    
    def get_digital_signature(self) -> aspose.cells.digitalsignatures.DigitalSignatureCollection:
        '''Gets digital signature from file.'''
        raise NotImplementedError()
    
    def remove_personal_information(self) -> None:
        '''Removes personal information.'''
        raise NotImplementedError()
    
    @property
    def settings(self) -> aspose.cells.WorkbookSettings:
        '''Represents the workbook settings.'''
        raise NotImplementedError()
    
    @property
    def worksheets(self) -> aspose.cells.WorksheetCollection:
        '''Gets the :py:class:`aspose.cells.WorksheetCollection` collection in the spreadsheet.'''
        raise NotImplementedError()
    
    @property
    def is_licensed(self) -> bool:
        '''Indicates whether license is set.'''
        raise NotImplementedError()
    
    @property
    def colors(self) -> List[aspose.pydrawing.Color]:
        '''Returns colors in the palette for the spreadsheet.'''
        raise NotImplementedError()
    
    @property
    def count_of_styles_in_pool(self) -> int:
        '''Gets number of the styles in the style pool.'''
        raise NotImplementedError()
    
    @property
    def default_style(self) -> aspose.cells.Style:
        '''Gets the default :py:class:`aspose.cells.Style` object of the workbook.'''
        raise NotImplementedError()
    
    @default_style.setter
    def default_style(self, value : aspose.cells.Style) -> None:
        '''Sets the default :py:class:`aspose.cells.Style` object of the workbook.'''
        raise NotImplementedError()
    
    @property
    def is_digitally_signed(self) -> bool:
        '''Indicates if this spreadsheet is digitally signed.'''
        raise NotImplementedError()
    
    @property
    def is_workbook_protected_with_password(self) -> bool:
        '''Indicates whether structure or window is protected with password.'''
        raise NotImplementedError()
    
    @property
    def vba_project(self) -> aspose.cells.vba.VbaProject:
        '''Gets the :py:attr:`aspose.cells.Workbook.vba_project` in a spreadsheet.'''
        raise NotImplementedError()
    
    @property
    def has_macro(self) -> bool:
        '''Indicates if this spreadsheet contains macro/VBA.'''
        raise NotImplementedError()
    
    @property
    def has_revisions(self) -> bool:
        '''Gets if the workbook has any tracked changes'''
        raise NotImplementedError()
    
    @property
    def file_name(self) -> str:
        '''Gets and sets the current file name.'''
        raise NotImplementedError()
    
    @file_name.setter
    def file_name(self, value : str) -> None:
        '''Gets and sets the current file name.'''
        raise NotImplementedError()
    
    @property
    def cells_data_table_factory(self) -> aspose.cells.CellsDataTableFactory:
        '''Gets the factory for building ICellsDataTable from custom objects'''
        raise NotImplementedError()
    
    @property
    def data_sorter(self) -> aspose.cells.DataSorter:
        '''Gets a DataSorter object to sort data.'''
        raise NotImplementedError()
    
    @property
    def theme(self) -> str:
        '''Gets the theme name.'''
        raise NotImplementedError()
    
    @property
    def built_in_document_properties(self) -> aspose.cells.properties.BuiltInDocumentPropertyCollection:
        '''Returns a :py:class:`aspose.cells.properties.DocumentProperty` collection that represents all the built-in document properties of the spreadsheet.'''
        raise NotImplementedError()
    
    @property
    def custom_document_properties(self) -> aspose.cells.properties.CustomDocumentPropertyCollection:
        '''Returns a :py:class:`aspose.cells.properties.DocumentProperty` collection that represents all the custom document properties of the spreadsheet.'''
        raise NotImplementedError()
    
    @property
    def file_format(self) -> aspose.cells.FileFormatType:
        '''Gets and sets the file format.'''
        raise NotImplementedError()
    
    @file_format.setter
    def file_format(self, value : aspose.cells.FileFormatType) -> None:
        '''Gets and sets the file format.'''
        raise NotImplementedError()
    
    @property
    def interrupt_monitor(self) -> aspose.cells.AbstractInterruptMonitor:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.cells.AbstractInterruptMonitor) -> None:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @property
    def content_type_properties(self) -> aspose.cells.properties.ContentTypePropertyCollection:
        '''Gets the list of  :py:class:`aspose.cells.properties.ContentTypeProperty` objects in the workbook.'''
        raise NotImplementedError()
    
    @property
    def custom_xml_parts(self) -> aspose.cells.markup.CustomXmlPartCollection:
        '''Represents a Custom XML Data Storage Part (custom XML data within a package).'''
        raise NotImplementedError()
    
    @property
    def data_mashup(self) -> aspose.cells.querytables.DataMashup:
        '''Gets mashup data.'''
        raise NotImplementedError()
    
    @property
    def ribbon_xml(self) -> str:
        '''Gets and sets the XML file that defines the Ribbon UI.'''
        raise NotImplementedError()
    
    @ribbon_xml.setter
    def ribbon_xml(self, value : str) -> None:
        '''Gets and sets the XML file that defines the Ribbon UI.'''
        raise NotImplementedError()
    
    @property
    def absolute_path(self) -> str:
        '''Gets and sets the absolute path of the file.'''
        raise NotImplementedError()
    
    @absolute_path.setter
    def absolute_path(self, value : str) -> None:
        '''Gets and sets the absolute path of the file.'''
        raise NotImplementedError()
    
    @property
    def data_connections(self) -> aspose.cells.externalconnections.ExternalConnectionCollection:
        '''Gets the :py:class:`aspose.cells.externalconnections.ExternalConnection` collection.'''
        raise NotImplementedError()
    

class WorkbookDesigner:
    '''Encapsulates the object that represents a designer spreadsheet.'''
    
    @overload
    def set_data_source(self, data_source : str, cells_data_table : aspose.cells.ICellsDataTable) -> None:
        '''Sets data source of a :py:class:`aspose.cells.ICellsDataTable` object.
        
        :param data_source: The name of the data source.
        :param cells_data_table: data table.'''
        raise NotImplementedError()
    
    @overload
    def set_data_source(self, variable : str, data : Any) -> None:
        '''Sets data binding to a variable.
        
        :param variable: Variable name created using smart marker.
        :param data: Source data.'''
        raise NotImplementedError()
    
    @overload
    def process(self) -> None:
        '''Processes the smart markers and populates the data source values.'''
        raise NotImplementedError()
    
    @overload
    def process(self, is_preserved : bool) -> None:
        '''Processes the smart markers and populates the data source values.
        
        :param is_preserved: True if the unrecognized smart marker is preserved.'''
        raise NotImplementedError()
    
    @overload
    def process(self, sheet_index : int, is_preserved : bool) -> None:
        '''Processes the smart markers and populates the data source values.
        
        :param sheet_index: Worksheet index.
        :param is_preserved: True if the unrecognized smart marker is preserved.'''
        raise NotImplementedError()
    
    def clear_data_source(self) -> None:
        '''Clears all data sources.'''
        raise NotImplementedError()
    
    def set_json_data_source(self, variable : str, data : str) -> None:
        ''''''
        raise NotImplementedError()
    
    def get_smart_markers(self) -> List[str]:
        '''Returns a collection of smart markers in a spreadsheet.
        
        :returns: A collection of smart markers'''
        raise NotImplementedError()
    
    @property
    def workbook(self) -> aspose.cells.Workbook:
        '''Gets and sets the :py:attr:`aspose.cells.WorkbookDesigner.workbook` object.'''
        raise NotImplementedError()
    
    @workbook.setter
    def workbook(self, value : aspose.cells.Workbook) -> None:
        '''Gets and sets the :py:attr:`aspose.cells.WorkbookDesigner.workbook` object.'''
        raise NotImplementedError()
    
    @property
    def repeat_formulas_with_subtotal(self) -> bool:
        '''Indicates whether repeating formulas with subtotal row.'''
        raise NotImplementedError()
    
    @repeat_formulas_with_subtotal.setter
    def repeat_formulas_with_subtotal(self, value : bool) -> None:
        '''Indicates whether repeating formulas with subtotal row.'''
        raise NotImplementedError()
    
    @property
    def update_empty_string_as_null(self) -> bool:
        '''If TRUE, Null will be inserted if the value is "";'''
        raise NotImplementedError()
    
    @update_empty_string_as_null.setter
    def update_empty_string_as_null(self, value : bool) -> None:
        '''If TRUE, Null will be inserted if the value is "";'''
        raise NotImplementedError()
    
    @property
    def update_reference(self) -> bool:
        '''Indicates if references in other worksheets will be updated.'''
        raise NotImplementedError()
    
    @update_reference.setter
    def update_reference(self, value : bool) -> None:
        '''Indicates if references in other worksheets will be updated.'''
        raise NotImplementedError()
    
    @property
    def calculate_formula(self) -> bool:
        '''Indicates whether formulas should be calculated.'''
        raise NotImplementedError()
    
    @calculate_formula.setter
    def calculate_formula(self, value : bool) -> None:
        '''Indicates whether formulas should be calculated.'''
        raise NotImplementedError()
    
    @property
    def call_back(self) -> aspose.cells.ISmartMarkerCallBack:
        '''Gets and sets callback interface of processing smartmarker.'''
        raise NotImplementedError()
    
    @call_back.setter
    def call_back(self, value : aspose.cells.ISmartMarkerCallBack) -> None:
        '''Gets and sets callback interface of processing smartmarker.'''
        raise NotImplementedError()
    
    @property
    def line_by_line(self) -> bool:
        '''Indicates whether processing the smart marker line by line.'''
        raise NotImplementedError()
    
    @line_by_line.setter
    def line_by_line(self, value : bool) -> None:
        '''Indicates whether processing the smart marker line by line.'''
        raise NotImplementedError()
    

class WorkbookSettings:
    '''Represents all settings of the workbook.'''
    
    def get_theme_font(self, type : aspose.cells.FontSchemeType) -> str:
        '''Gets the default theme font name.
        
        :param type: The scheme type of the font.'''
        raise NotImplementedError()
    
    def set_page_orientation_type(self, page_orientation_type : aspose.cells.PageOrientationType) -> None:
        '''Set the type of  print orientation for the whole workbook.
        
        :param page_orientation_type: The page orientation type'''
        raise NotImplementedError()
    
    @property
    def stream_provider(self) -> aspose.cells.IStreamProvider:
        '''Gets and sets the stream provider for external resource.'''
        raise NotImplementedError()
    
    @stream_provider.setter
    def stream_provider(self, value : aspose.cells.IStreamProvider) -> None:
        '''Gets and sets the stream provider for external resource.'''
        raise NotImplementedError()
    
    @property
    def resource_provider(self) -> aspose.cells.IStreamProvider:
        '''Gets and sets the stream provider for external resource, such as loading image data for picture of type "LinkToFile".'''
        raise NotImplementedError()
    
    @resource_provider.setter
    def resource_provider(self, value : aspose.cells.IStreamProvider) -> None:
        '''Gets and sets the stream provider for external resource, such as loading image data for picture of type "LinkToFile".'''
        raise NotImplementedError()
    
    @property
    def author(self) -> str:
        '''Gets and sets the author of the file.'''
        raise NotImplementedError()
    
    @author.setter
    def author(self, value : str) -> None:
        '''Gets and sets the author of the file.'''
        raise NotImplementedError()
    
    @property
    def check_custom_number_format(self) -> bool:
        '''Indicates whether checking custom number format when setting Style.Custom.'''
        raise NotImplementedError()
    
    @check_custom_number_format.setter
    def check_custom_number_format(self, value : bool) -> None:
        '''Indicates whether checking custom number format when setting Style.Custom.'''
        raise NotImplementedError()
    
    @property
    def enable_macros(self) -> bool:
        '''Enable macros;'''
        raise NotImplementedError()
    
    @enable_macros.setter
    def enable_macros(self, value : bool) -> None:
        '''Enable macros;'''
        raise NotImplementedError()
    
    @property
    def date1904(self) -> bool:
        '''Gets a value which represents if the workbook uses the 1904 date system.'''
        raise NotImplementedError()
    
    @date1904.setter
    def date1904(self, value : bool) -> None:
        '''Sets a value which represents if the workbook uses the 1904 date system.'''
        raise NotImplementedError()
    
    @property
    def protection_type(self) -> aspose.cells.ProtectionType:
        '''Gets the protection type of the workbook.'''
        raise NotImplementedError()
    
    @property
    def display_drawing_objects(self) -> aspose.cells.DisplayDrawingObjects:
        '''Indicates whether and how to show objects in the workbook.'''
        raise NotImplementedError()
    
    @display_drawing_objects.setter
    def display_drawing_objects(self, value : aspose.cells.DisplayDrawingObjects) -> None:
        '''Indicates whether and how to show objects in the workbook.'''
        raise NotImplementedError()
    
    @property
    def sheet_tab_bar_width(self) -> int:
        '''Width of worksheet tab bar (in 1/1000 of window width).'''
        raise NotImplementedError()
    
    @sheet_tab_bar_width.setter
    def sheet_tab_bar_width(self, value : int) -> None:
        '''Width of worksheet tab bar (in 1/1000 of window width).'''
        raise NotImplementedError()
    
    @property
    def show_tabs(self) -> bool:
        '''Get a value whether the Workbook tabs are displayed.'''
        raise NotImplementedError()
    
    @show_tabs.setter
    def show_tabs(self, value : bool) -> None:
        '''Get or sets a value whether the Workbook tabs are displayed.'''
        raise NotImplementedError()
    
    @property
    def first_visible_tab(self) -> int:
        '''Gets the first visible worksheet tab.'''
        raise NotImplementedError()
    
    @first_visible_tab.setter
    def first_visible_tab(self, value : int) -> None:
        '''Sets the first visible worksheet tab.'''
        raise NotImplementedError()
    
    @property
    def is_h_scroll_bar_visible(self) -> bool:
        '''Gets a value indicating whether the generated spreadsheet will contain a horizontal scroll bar.'''
        raise NotImplementedError()
    
    @is_h_scroll_bar_visible.setter
    def is_h_scroll_bar_visible(self, value : bool) -> None:
        '''Sets a value indicating whether the generated spreadsheet will contain a horizontal scroll bar.'''
        raise NotImplementedError()
    
    @property
    def is_v_scroll_bar_visible(self) -> bool:
        '''Gets a value indicating whether the generated spreadsheet will contain a vertical scroll bar.'''
        raise NotImplementedError()
    
    @is_v_scroll_bar_visible.setter
    def is_v_scroll_bar_visible(self, value : bool) -> None:
        '''Sets a value indicating whether the generated spreadsheet will contain a vertical scroll bar.'''
        raise NotImplementedError()
    
    @property
    def shared(self) -> bool:
        '''Gets a value that indicates whether the Workbook is shared.'''
        raise NotImplementedError()
    
    @shared.setter
    def shared(self, value : bool) -> None:
        '''Sets a value that indicates whether the Workbook is shared.'''
        raise NotImplementedError()
    
    @property
    def language_code(self) -> aspose.cells.CountryCode:
        '''Gets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @language_code.setter
    def language_code(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @property
    def region(self) -> aspose.cells.CountryCode:
        '''Gets the regional settings for workbook.'''
        raise NotImplementedError()
    
    @region.setter
    def region(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the regional settings for workbook.'''
        raise NotImplementedError()
    
    @property
    def globalization_settings(self) -> aspose.cells.GlobalizationSettings:
        '''Gets and sets the globalization settings.'''
        raise NotImplementedError()
    
    @globalization_settings.setter
    def globalization_settings(self, value : aspose.cells.GlobalizationSettings) -> None:
        '''Gets and sets the globalization settings.'''
        raise NotImplementedError()
    
    @property
    def number_decimal_separator(self) -> str:
        '''Gets the decimal separator for formatting/parsing numeric values. Default is the decimal separator of current Region.'''
        raise NotImplementedError()
    
    @number_decimal_separator.setter
    def number_decimal_separator(self, value : str) -> None:
        '''Sets the decimal separator for formatting/parsing numeric values. Default is the decimal separator of current Region.'''
        raise NotImplementedError()
    
    @property
    def number_group_separator(self) -> str:
        '''Gets the character that separates groups of digits to the left of the decimal in numeric values. Default is the group separator of current Region.'''
        raise NotImplementedError()
    
    @number_group_separator.setter
    def number_group_separator(self, value : str) -> None:
        '''Sets the character that separates groups of digits to the left of the decimal in numeric values. Default is the group separator of current Region.'''
        raise NotImplementedError()
    
    @property
    def password(self) -> str:
        '''Represents Workbook file encryption password.'''
        raise NotImplementedError()
    
    @password.setter
    def password(self, value : str) -> None:
        '''Represents Workbook file encryption password.'''
        raise NotImplementedError()
    
    @property
    def write_protection(self) -> aspose.cells.WriteProtection:
        '''Provides access to the workbook write protection options.'''
        raise NotImplementedError()
    
    @property
    def is_encrypted(self) -> bool:
        '''Gets a value that indicates whether a password is required to open this workbook.'''
        raise NotImplementedError()
    
    @property
    def is_protected(self) -> bool:
        '''Gets a value that indicates whether the structure or window of the Workbook is protected.'''
        raise NotImplementedError()
    
    @property
    def is_default_encrypted(self) -> bool:
        '''Indicates whether encrypting the workbook with default password if Structure and Windows of the workbook are locked.'''
        raise NotImplementedError()
    
    @is_default_encrypted.setter
    def is_default_encrypted(self, value : bool) -> None:
        '''Indicates whether encrypting the workbook with default password if Structure and Windows of the workbook are locked.'''
        raise NotImplementedError()
    
    @property
    def is_minimized(self) -> bool:
        '''Represents whether the generated spreadsheet will be opened Minimized.'''
        raise NotImplementedError()
    
    @is_minimized.setter
    def is_minimized(self, value : bool) -> None:
        '''Represents whether the generated spreadsheet will be opened Minimized.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether this workbook is hidden.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether this workbook is hidden.'''
        raise NotImplementedError()
    
    @property
    def auto_compress_pictures(self) -> bool:
        '''Specifies a boolean value that indicates the application automatically compressed pictures in the workbook.'''
        raise NotImplementedError()
    
    @auto_compress_pictures.setter
    def auto_compress_pictures(self, value : bool) -> None:
        '''Specifies a boolean value that indicates the application automatically compressed pictures in the workbook.'''
        raise NotImplementedError()
    
    @property
    def remove_personal_information(self) -> bool:
        '''True if personal information can be removed from the specified workbook.'''
        raise NotImplementedError()
    
    @remove_personal_information.setter
    def remove_personal_information(self, value : bool) -> None:
        '''True if personal information can be removed from the specified workbook.'''
        raise NotImplementedError()
    
    @property
    def hide_pivot_field_list(self) -> bool:
        '''Gets and sets whether hide the field list for the PivotTable.'''
        raise NotImplementedError()
    
    @hide_pivot_field_list.setter
    def hide_pivot_field_list(self, value : bool) -> None:
        '''Gets and sets whether hide the field list for the PivotTable.'''
        raise NotImplementedError()
    
    @property
    def update_links_type(self) -> aspose.cells.UpdateLinksType:
        '''Gets and sets how updates external links when the workbook is opened.'''
        raise NotImplementedError()
    
    @update_links_type.setter
    def update_links_type(self, value : aspose.cells.UpdateLinksType) -> None:
        '''Gets and sets how updates external links when the workbook is opened.'''
        raise NotImplementedError()
    
    @property
    def max_row(self) -> int:
        '''Gets the max row index, zero-based.'''
        raise NotImplementedError()
    
    @property
    def max_column(self) -> int:
        '''Gets the max column index, zero-based.'''
        raise NotImplementedError()
    
    @property
    def default_style_settings(self) -> aspose.cells.DefaultStyleSettings:
        '''Gets the settings for workbook\'s default style-related properties.'''
        raise NotImplementedError()
    
    @property
    def window_left(self) -> float:
        '''The distance from the left edge of the client area to the left edge of the window, in unit of point.'''
        raise NotImplementedError()
    
    @window_left.setter
    def window_left(self, value : float) -> None:
        '''The distance from the left edge of the client area to the left edge of the window, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def window_left_inch(self) -> float:
        '''The distance from the left edge of the client area to the left edge of the window.
        In unit of inch.'''
        raise NotImplementedError()
    
    @window_left_inch.setter
    def window_left_inch(self, value : float) -> None:
        '''The distance from the left edge of the client area to the left edge of the window.
        In unit of inch.'''
        raise NotImplementedError()
    
    @property
    def window_left_cm(self) -> float:
        '''The distance from the left edge of the client area to the left edge of the window.
        In unit of centimeter.'''
        raise NotImplementedError()
    
    @window_left_cm.setter
    def window_left_cm(self, value : float) -> None:
        '''The distance from the left edge of the client area to the left edge of the window.
        In unit of centimeter.'''
        raise NotImplementedError()
    
    @property
    def window_top(self) -> float:
        '''The distance from the top edge of the client area to the top edge of the window, in unit of point.'''
        raise NotImplementedError()
    
    @window_top.setter
    def window_top(self, value : float) -> None:
        '''The distance from the top edge of the client area to the top edge of the window, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def window_top_inch(self) -> float:
        '''The distance from the top edge of the client area to the top edge of the window, in unit of inch.'''
        raise NotImplementedError()
    
    @window_top_inch.setter
    def window_top_inch(self, value : float) -> None:
        '''The distance from the top edge of the client area to the top edge of the window, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def window_top_cm(self) -> float:
        '''The distance from the top edge of the client area to the top edge of the window, in unit of centimeter.'''
        raise NotImplementedError()
    
    @window_top_cm.setter
    def window_top_cm(self, value : float) -> None:
        '''The distance from the top edge of the client area to the top edge of the window, in unit of centimeter.'''
        raise NotImplementedError()
    
    @property
    def window_width(self) -> float:
        '''The width of the window, in unit of point.'''
        raise NotImplementedError()
    
    @window_width.setter
    def window_width(self, value : float) -> None:
        '''The width of the window, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def window_width_inch(self) -> float:
        '''The width of the window, in unit of inch.'''
        raise NotImplementedError()
    
    @window_width_inch.setter
    def window_width_inch(self, value : float) -> None:
        '''The width of the window, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def window_width_cm(self) -> float:
        '''The width of the window, in unit of centimeter.'''
        raise NotImplementedError()
    
    @window_width_cm.setter
    def window_width_cm(self, value : float) -> None:
        '''The width of the window, in unit of centimeter.'''
        raise NotImplementedError()
    
    @property
    def window_height(self) -> float:
        '''The height of the window, in unit of point.'''
        raise NotImplementedError()
    
    @window_height.setter
    def window_height(self, value : float) -> None:
        '''The height of the window, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def window_height_inch(self) -> float:
        '''The height of the window, in unit of inch.'''
        raise NotImplementedError()
    
    @window_height_inch.setter
    def window_height_inch(self, value : float) -> None:
        '''The height of the window, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def window_height_cm(self) -> float:
        '''The height of the window, in unit of centimeter.'''
        raise NotImplementedError()
    
    @window_height_cm.setter
    def window_height_cm(self, value : float) -> None:
        '''The height of the window, in unit of centimeter.'''
        raise NotImplementedError()
    
    @property
    def update_adjacent_cells_border(self) -> bool:
        '''Indicates whether update adjacent cells\' border.'''
        raise NotImplementedError()
    
    @update_adjacent_cells_border.setter
    def update_adjacent_cells_border(self, value : bool) -> None:
        '''Indicates whether update adjacent cells\' border.'''
        raise NotImplementedError()
    
    @property
    def significant_digits(self) -> int:
        '''Gets and sets the number of significant digits.
        The default value is :py:attr:`aspose.cells.CellsHelper.significant_digits`.'''
        raise NotImplementedError()
    
    @significant_digits.setter
    def significant_digits(self, value : int) -> None:
        '''Gets and sets the number of significant digits.
        The default value is :py:attr:`aspose.cells.CellsHelper.significant_digits`.'''
        raise NotImplementedError()
    
    @property
    def check_compatibility(self) -> bool:
        '''Indicates whether check compatibility with earlier versions when saving workbook.'''
        raise NotImplementedError()
    
    @check_compatibility.setter
    def check_compatibility(self, value : bool) -> None:
        '''Indicates whether check compatibility with earlier versions when saving workbook.'''
        raise NotImplementedError()
    
    @property
    def check_excel_restriction(self) -> bool:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @check_excel_restriction.setter
    def check_excel_restriction(self, value : bool) -> None:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @property
    def auto_recover(self) -> bool:
        '''Indicates whether the file is marked for auto-recovery.'''
        raise NotImplementedError()
    
    @auto_recover.setter
    def auto_recover(self, value : bool) -> None:
        '''Indicates whether the file is marked for auto-recovery.'''
        raise NotImplementedError()
    
    @property
    def crash_save(self) -> bool:
        '''indicates whether the application last saved the workbook file after a crash.'''
        raise NotImplementedError()
    
    @crash_save.setter
    def crash_save(self, value : bool) -> None:
        '''indicates whether the application last saved the workbook file after a crash.'''
        raise NotImplementedError()
    
    @property
    def data_extract_load(self) -> bool:
        '''indicates whether the application last opened the workbook for data recovery.'''
        raise NotImplementedError()
    
    @data_extract_load.setter
    def data_extract_load(self, value : bool) -> None:
        '''indicates whether the application last opened the workbook for data recovery.'''
        raise NotImplementedError()
    
    @property
    def repair_load(self) -> bool:
        '''Indicates whether the application last opened the workbook in safe or repair mode.'''
        raise NotImplementedError()
    
    @repair_load.setter
    def repair_load(self, value : bool) -> None:
        '''Indicates whether the application last opened the workbook in safe or repair mode.'''
        raise NotImplementedError()
    
    @property
    def build_version(self) -> str:
        '''Specifies the incremental public release of the application.'''
        raise NotImplementedError()
    
    @build_version.setter
    def build_version(self, value : str) -> None:
        '''Specifies the incremental public release of the application.'''
        raise NotImplementedError()
    
    @property
    def memory_setting(self) -> aspose.cells.MemorySetting:
        '''Gets the memory usage options. The new option will be taken as the default option for newly created worksheets but does not take effect for existing worksheets.'''
        raise NotImplementedError()
    
    @memory_setting.setter
    def memory_setting(self, value : aspose.cells.MemorySetting) -> None:
        '''Sets the memory usage options. The new option will be taken as the default option for newly created worksheets but does not take effect for existing worksheets.'''
        raise NotImplementedError()
    
    @property
    def paper_size(self) -> aspose.cells.PaperSizeType:
        '''Gets and sets the default print paper size.'''
        raise NotImplementedError()
    
    @paper_size.setter
    def paper_size(self, value : aspose.cells.PaperSizeType) -> None:
        '''Gets and sets the default print paper size.'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def max_rows_of_shared_formula(self) -> int:
        '''Gets and sets the max row number of shared formula.'''
        raise NotImplementedError()
    
    @max_rows_of_shared_formula.setter
    def max_rows_of_shared_formula(self, value : int) -> None:
        '''Gets and sets the max row number of shared formula.'''
        raise NotImplementedError()
    
    @property
    def compliance(self) -> aspose.cells.OoxmlCompliance:
        '''Specifies the OOXML version for the output document. The default value is Ecma376_2006.'''
        raise NotImplementedError()
    
    @compliance.setter
    def compliance(self, value : aspose.cells.OoxmlCompliance) -> None:
        '''Specifies the OOXML version for the output document. The default value is Ecma376_2006.'''
        raise NotImplementedError()
    
    @property
    def quote_prefix_to_style(self) -> bool:
        '''Indicates whether setting :py:attr:`aspose.cells.Style.quote_prefix` property when entering the string value(which starts  with single quote mark ) to the cell'''
        raise NotImplementedError()
    
    @quote_prefix_to_style.setter
    def quote_prefix_to_style(self, value : bool) -> None:
        '''Indicates whether setting :py:attr:`aspose.cells.Style.quote_prefix` property when entering the string value(which starts  with single quote mark ) to the cell'''
        raise NotImplementedError()
    
    @property
    def formula_settings(self) -> aspose.cells.FormulaSettings:
        '''Gets the settings for formula-related features.'''
        raise NotImplementedError()
    

class Worksheet:
    '''Encapsulates the object that represents a single worksheet.'''
    
    @overload
    def freeze_panes(self, row : int, column : int, freezed_rows : int, freezed_columns : int) -> None:
        '''Freezes panes at the specified cell in the worksheet.
        
        :param row: Row index.
        :param column: Column index.
        :param freezed_rows: Number of visible rows in top pane, no more than row index.
        :param freezed_columns: Number of visible columns in left pane, no more than column index.'''
        raise NotImplementedError()
    
    @overload
    def freeze_panes(self, cell_name : str, freezed_rows : int, freezed_columns : int) -> None:
        '''Freezes panes at the specified cell in the worksheet.
        
        :param cell_name: Cell name.
        :param freezed_rows: Number of visible rows in top pane, no more than row index.
        :param freezed_columns: Number of visible columns in left pane, no more than column index.'''
        raise NotImplementedError()
    
    @overload
    def copy(self, source_sheet : aspose.cells.Worksheet) -> None:
        '''Copies contents and formats from another worksheet.
        
        :param source_sheet: Source worksheet.'''
        raise NotImplementedError()
    
    @overload
    def copy(self, source_sheet : aspose.cells.Worksheet, copy_options : aspose.cells.CopyOptions) -> None:
        '''Copies contents and formats from another worksheet.
        
        :param source_sheet: Source worksheet.'''
        raise NotImplementedError()
    
    @overload
    def auto_fit_column(self, column_index : int, first_row : int, last_row : int) -> None:
        '''Autofits the column width.
        
        :param column_index: Column index.
        :param first_row: First row index.
        :param last_row: Last row index.'''
        raise NotImplementedError()
    
    @overload
    def auto_fit_column(self, column_index : int) -> None:
        '''Autofits the column width.
        
        :param column_index: Column index.'''
        raise NotImplementedError()
    
    @overload
    def auto_fit_columns(self) -> None:
        '''Autofits all columns in this worksheet.'''
        raise NotImplementedError()
    
    @overload
    def auto_fit_columns(self, options : aspose.cells.AutoFitterOptions) -> None:
        '''Autofits all columns in this worksheet.
        
        :param options: The auto fitting options'''
        raise NotImplementedError()
    
    @overload
    def auto_fit_columns(self, first_column : int, last_column : int) -> None:
        '''Autofits the columns width.
        
        :param first_column: First column index.
        :param last_column: Last column index.'''
        raise NotImplementedError()
    
    @overload
    def auto_fit_columns(self, first_column : int, last_column : int, options : aspose.cells.AutoFitterOptions) -> None:
        '''Autofits the columns width.
        
        :param first_column: First column index.
        :param last_column: Last column index.
        :param options: The auto fitting options'''
        raise NotImplementedError()
    
    @overload
    def auto_fit_columns(self, first_row : int, first_column : int, last_row : int, last_column : int) -> None:
        '''Autofits the columns width.
        
        :param first_row: First row index.
        :param first_column: First column index.
        :param last_row: Last row index.
        :param last_column: Last column index.'''
        raise NotImplementedError()
    
    @overload
    def auto_fit_columns(self, first_row : int, first_column : int, last_row : int, last_column : int, options : aspose.cells.AutoFitterOptions) -> None:
        '''Autofits the columns width.
        
        :param first_row: First row index.
        :param first_column: First column index.
        :param last_row: Last row index.
        :param last_column: Last column index.
        :param options: The auto fitting options'''
        raise NotImplementedError()
    
    @overload
    def auto_fit_row(self, row_index : int, first_column : int, last_column : int) -> None:
        '''Autofits the row height.
        
        :param row_index: Row index.
        :param first_column: First column index.
        :param last_column: Last column index.'''
        raise NotImplementedError()
    
    @overload
    def auto_fit_row(self, row_index : int, first_column : int, last_column : int, options : aspose.cells.AutoFitterOptions) -> None:
        '''Autofits the row height.
        
        :param row_index: Row index.
        :param first_column: First column index.
        :param last_column: Last column index.
        :param options: The auto fitter options'''
        raise NotImplementedError()
    
    @overload
    def auto_fit_row(self, start_row : int, end_row : int, start_column : int, end_column : int) -> None:
        '''Autofits row height in a rectangle range.
        
        :param start_row: Start row index.
        :param end_row: End row index.
        :param start_column: Start column index.
        :param end_column: End column index.'''
        raise NotImplementedError()
    
    @overload
    def auto_fit_row(self, row_index : int) -> None:
        '''Autofits the row height.
        
        :param row_index: Row index.'''
        raise NotImplementedError()
    
    @overload
    def auto_fit_rows(self) -> None:
        '''Autofits all rows in this worksheet.'''
        raise NotImplementedError()
    
    @overload
    def auto_fit_rows(self, only_auto : bool) -> None:
        '''Autofits all rows in this worksheet.
        
        :param only_auto: True,only autofits the row height when row height is not customed.'''
        raise NotImplementedError()
    
    @overload
    def auto_fit_rows(self, options : aspose.cells.AutoFitterOptions) -> None:
        '''Autofits all rows in this worksheet.
        
        :param options: The auto fitter options'''
        raise NotImplementedError()
    
    @overload
    def auto_fit_rows(self, start_row : int, end_row : int) -> None:
        '''Autofits row height in a range.
        
        :param start_row: Start row index.
        :param end_row: End row index.'''
        raise NotImplementedError()
    
    @overload
    def auto_fit_rows(self, start_row : int, end_row : int, options : aspose.cells.AutoFitterOptions) -> None:
        '''Autofits row height in a range.
        
        :param start_row: Start row index.
        :param end_row: End row index.
        :param options: The options of auto fitter.'''
        raise NotImplementedError()
    
    @overload
    def protect(self, type : aspose.cells.ProtectionType) -> None:
        '''Protects worksheet.
        
        :param type: Protection type.'''
        raise NotImplementedError()
    
    @overload
    def protect(self, type : aspose.cells.ProtectionType, password : str, old_password : str) -> None:
        '''Protects worksheet.
        
        :param type: Protection type.
        :param password: Password.
        :param old_password: If the worksheet is already protected by a password, please supply the old password.
        Otherwise, you can set a null value or blank string to this parameter.'''
        raise NotImplementedError()
    
    @overload
    def unprotect(self) -> None:
        '''Unprotects worksheet.'''
        raise NotImplementedError()
    
    @overload
    def unprotect(self, password : str) -> None:
        '''Unprotects worksheet.
        
        :param password: Password'''
        raise NotImplementedError()
    
    @overload
    def calculate_formula(self, formula : str) -> Any:
        '''Calculates a formula.
        
        :param formula: Formula to be calculated.
        :returns: Calculated formula result.'''
        raise NotImplementedError()
    
    @overload
    def calculate_formula(self, formula : str, opts : aspose.cells.CalculationOptions) -> Any:
        '''Calculates a formula expression directly.
        
        :param formula: Formula to be calculated.
        :param opts: Options for calculating formula
        :returns: Calculated result of given formula.
        The returned object may be of possible types of :py:attr:`aspose.cells.Cell.value`, or ReferredArea.'''
        raise NotImplementedError()
    
    @overload
    def calculate_formula(self, formula : str, p_opts : aspose.cells.FormulaParseOptions, c_opts : aspose.cells.CalculationOptions, base_cell_row : int, base_cell_column : int, calculation_data : aspose.cells.CalculationData) -> Any:
        '''Calculates a formula expression directly.
        
        :param formula: Formula to be calculated.
        :param p_opts: Options for parsing formula.
        :param c_opts: Options for calculating formula.
        :param base_cell_row: The row index of the base cell.
        :param base_cell_column: The column index of the base cell.
        :param calculation_data: The calculation data. It is used for the situation
        that user needs to calculate some static formulas when implementing custom calculation engine.
        For such kind of situation, user needs to specify it with the calculation data provided
        for :py:func:`aspose.cells.AbstractCalculationEngine.calculate`.
        :returns: Calculated result of given formula.
        The returned object may be of possible types of :py:attr:`aspose.cells.Cell.value`, or ReferredArea.'''
        raise NotImplementedError()
    
    @overload
    def calculate_formula(self, options : aspose.cells.CalculationOptions, recursive : bool) -> None:
        '''Calculates all formulas in this worksheet.
        
        :param options: Options for calculation
        :param recursive: True means if the worksheet\' cells depend on the cells of other worksheets,
        the dependent cells in other worksheets will be calculated too.
        False means all the formulas in the worksheet have been calculated and the values are right.'''
        raise NotImplementedError()
    
    @overload
    def calculate_array_formula(self, formula : str, opts : aspose.cells.CalculationOptions) -> List[List[Any]]:
        '''Calculates a formula as array formula.
        
        :param formula: Formula to be calculated.
        :param opts: Options for calculating formula'''
        raise NotImplementedError()
    
    @overload
    def calculate_array_formula(self, formula : str, opts : aspose.cells.CalculationOptions, max_row_count : int, max_column_count : int) -> List[List[Any]]:
        '''Calculates a formula as array formula.
        
        :param formula: Formula to be calculated.
        :param opts: Options for calculating formula
        :param max_row_count: the maximum row count of resultant data.
        If it is non-positive or greater than the actual row count, then actual row count will be used.
        :param max_column_count: the maximum column count of resultant data.
        If it is non-positive or greater than the actual row count, then actual column count will be used.
        :returns: Calculated formula result.'''
        raise NotImplementedError()
    
    @overload
    def calculate_array_formula(self, formula : str, p_opts : aspose.cells.FormulaParseOptions, c_opts : aspose.cells.CalculationOptions, base_cell_row : int, base_cell_column : int, max_row_count : int, max_column_count : int, calculation_data : aspose.cells.CalculationData) -> List[List[Any]]:
        '''Calculates a formula as array formula.
        
        :param formula: Formula to be calculated.
        :param p_opts: Options for parsing formula
        :param c_opts: Options for calculating formula
        :param base_cell_row: The row index of the base cell.
        :param base_cell_column: The column index of the base cell.
        :param max_row_count: The maximum row count of resultant data.
        If it is non-positive or greater than the actual row count, then actual row count will be used.
        :param max_column_count: The maximum column count of resultant data.
        If it is non-positive or greater than the actual row count, then actual column count will be used.
        :param calculation_data: The calculation data. It is used for the situation
        that user needs to calculate some static formulas when implementing custom calculation engine.
        For such kind of situation, user needs to specify it with the calculation data provided
        for :py:func:`aspose.cells.AbstractCalculationEngine.calculate`.
        :returns: Calculated formula result.'''
        raise NotImplementedError()
    
    @overload
    def refresh_pivot_tables(self) -> None:
        '''Refreshes all the PivotTables in this Worksheet.'''
        raise NotImplementedError()
    
    @overload
    def refresh_pivot_tables(self, option : aspose.cells.pivot.PivotTableRefreshOption) -> bool:
        raise NotImplementedError()
    
    def get_panes(self) -> aspose.cells.PaneCollection:
        '''Gets the window panes.'''
        raise NotImplementedError()
    
    def get_freezed_panes(self, row : List[int], column : List[int], freezed_rows : List[int], freezed_columns : List[int]) -> bool:
        '''Gets the freeze panes.
        
        :param row: Row index.
        :param column: Column index.
        :param freezed_rows: Number of visible rows in top pane, no more than row index.
        :param freezed_columns: Number of visible columns in left pane, no more than column index.
        :returns: Return whether the worksheet is frozen'''
        raise NotImplementedError()
    
    def split(self) -> None:
        '''Splits window.'''
        raise NotImplementedError()
    
    def un_freeze_panes(self) -> None:
        '''Unfreezes panes in the worksheet.'''
        raise NotImplementedError()
    
    def remove_split(self) -> None:
        '''Removes split window.'''
        raise NotImplementedError()
    
    def add_page_breaks(self, cell_name : str) -> None:
        '''Adds page break.'''
        raise NotImplementedError()
    
    def get_advanced_filter(self) -> aspose.cells.AdvancedFilter:
        raise NotImplementedError()
    
    def advanced_filter(self, is_filter : bool, list_range : str, criteria_range : str, copy_to : str, unique_record_only : bool) -> None:
        '''Filters data using complex criteria.
        
        :param is_filter: Indicates whether filtering the list in place.
        :param list_range: The list range.
        :param criteria_range: The criteria range.
        :param copy_to: The range where copying data to.
        :param unique_record_only: Only displaying or copying unique rows.'''
        raise NotImplementedError()
    
    def remove_auto_filter(self) -> None:
        '''Removes the auto filter of the worksheet.'''
        raise NotImplementedError()
    
    def set_visible(self, is_visible : bool, ignore_error : bool) -> None:
        '''Sets the visible options.
        
        :param is_visible: Whether the worksheet is visible
        :param ignore_error: Whether to ignore error if this option is not valid.'''
        raise NotImplementedError()
    
    def select_range(self, start_row : int, start_column : int, total_rows : int, total_columns : int, remove_others : bool) -> None:
        '''Selects a range.
        
        :param start_row: The start row.
        :param start_column: The start column
        :param total_rows: The number of rows.
        :param total_columns: The number of columns
        :param remove_others: True means removing other selected range and only select this range.'''
        raise NotImplementedError()
    
    def remove(self) -> None:
        raise NotImplementedError()
    
    def remove_all_drawing_objects(self) -> None:
        '''Removes all drawing objects in this worksheet.'''
        raise NotImplementedError()
    
    def clear_comments(self) -> None:
        '''Clears all comments in designer spreadsheet.'''
        raise NotImplementedError()
    
    def move_to(self, index : int) -> None:
        '''Moves the sheet to another location in the spreadsheet.
        
        :param index: Destination sheet index.'''
        raise NotImplementedError()
    
    def replace(self, old_string : str, new_string : str) -> int:
        '''Replaces all cells\' text with a new string.
        
        :param old_string: Old string value.
        :param new_string: New string value.'''
        raise NotImplementedError()
    
    def get_selected_ranges(self) -> List[Any]:
        '''Gets selected ranges of cells in the designer spreadsheet.
        
        :returns: An :py:class:`List[Any]` which contains selected ranges.'''
        raise NotImplementedError()
    
    def get_printing_page_breaks(self, options : aspose.cells.rendering.ImageOrPrintOptions) -> List[aspose.cells.CellArea]:
        '''Gets automatic page breaks.
        
        :param options: The print options
        :returns: The automatic page breaks areas.'''
        raise NotImplementedError()
    
    def start_access_cache(self, opts : aspose.cells.AccessCacheOptions) -> None:
        '''Starts the session that uses caches to access the data in this worksheet.
        
        :param opts: options of data access'''
        raise NotImplementedError()
    
    def close_access_cache(self, opts : aspose.cells.AccessCacheOptions) -> None:
        '''Closes the session that uses caches to access the data in this worksheet.
        
        :param opts: options of data access'''
        raise NotImplementedError()
    
    def convert_formula_reference_style(self, formula : str, to_r1c1 : bool, base_cell_row : int, base_cell_column : int) -> str:
        '''Converts the formula reference style.
        
        :param formula: The formula to be converted.
        :param to_r1c1: Which reference style to convert the formula to.
        If the original formula is of A1 reference style,
        then this value should be true so the formula will be converted from A1 to R1C1 reference style;
        If the original formula is of R1C1 reference style,
        then this value should be false so the formula will be converted from R1C1 to A1 reference style;
        :param base_cell_row: The row index of the base cell.
        :param base_cell_column: The column index of the base cell.
        :returns: The converted formula.'''
        raise NotImplementedError()
    
    def xml_map_query(self, path : str, xml_map : aspose.cells.XmlMap) -> List[Any]:
        '''Query cell areas that mapped/linked to the specific path of xml map.
        
        :param path: xml element path
        :param xml_map: Specify an xml map if you want to query for the specific path within a specific map
        :returns: :py:class:`aspose.cells.CellArea` list that mapped/linked to the specific path of xml map, an empty list is returned if nothing is mapped/linked.'''
        raise NotImplementedError()
    
    @property
    def protection(self) -> aspose.cells.Protection:
        '''Represents the various types of protection options available for a worksheet. Supports advanced protection options in ExcelXP and above version.'''
        raise NotImplementedError()
    
    @property
    def unique_id(self) -> str:
        '''Gets and sets the unique id, it is same as {15DB5C3C-A5A1-48AF-8F25-3D86AC232D4F}.'''
        raise NotImplementedError()
    
    @unique_id.setter
    def unique_id(self, value : str) -> None:
        '''Gets and sets the unique id, it is same as {15DB5C3C-A5A1-48AF-8F25-3D86AC232D4F}.'''
        raise NotImplementedError()
    
    @property
    def workbook(self) -> aspose.cells.Workbook:
        '''Gets the workbook object which contains this sheet.'''
        raise NotImplementedError()
    
    @property
    def cells(self) -> aspose.cells.Cells:
        '''Gets the :py:attr:`aspose.cells.Worksheet.cells` collection.'''
        raise NotImplementedError()
    
    @property
    def query_tables(self) -> aspose.cells.QueryTableCollection:
        '''Gets :py:class:`aspose.cells.QueryTableCollection` in the worksheet.'''
        raise NotImplementedError()
    
    @property
    def pivot_tables(self) -> aspose.cells.pivot.PivotTableCollection:
        '''Gets all pivot tables in this worksheet.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.SheetType:
        '''Represents worksheet type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.cells.SheetType) -> None:
        '''Represents worksheet type.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets the name of the worksheet.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Sets the name of the worksheet.'''
        raise NotImplementedError()
    
    @property
    def show_formulas(self) -> bool:
        '''Indicates whether to show formulas or their results.'''
        raise NotImplementedError()
    
    @show_formulas.setter
    def show_formulas(self, value : bool) -> None:
        '''Indicates whether to show formulas or their results.'''
        raise NotImplementedError()
    
    @property
    def is_gridlines_visible(self) -> bool:
        '''Gets a value indicating whether the gridlines are visible.Default is true.'''
        raise NotImplementedError()
    
    @is_gridlines_visible.setter
    def is_gridlines_visible(self, value : bool) -> None:
        '''Sets a value indicating whether the gridlines are visible.Default is true.'''
        raise NotImplementedError()
    
    @property
    def is_row_column_headers_visible(self) -> bool:
        '''Gets a value indicating whether the worksheet will display row and column headers.
        Default is true.'''
        raise NotImplementedError()
    
    @is_row_column_headers_visible.setter
    def is_row_column_headers_visible(self, value : bool) -> None:
        '''Sets a value indicating whether the worksheet will display row and column headers.
        Default is true.'''
        raise NotImplementedError()
    
    @property
    def pane_state(self) -> aspose.cells.PaneStateType:
        '''Indicates whether the pane has horizontal or vertical splits, and whether those splits are frozen.'''
        raise NotImplementedError()
    
    @property
    def display_zeros(self) -> bool:
        '''True if zero values are displayed.'''
        raise NotImplementedError()
    
    @display_zeros.setter
    def display_zeros(self, value : bool) -> None:
        '''True if zero values are displayed.'''
        raise NotImplementedError()
    
    @property
    def display_right_to_left(self) -> bool:
        '''Indicates if the specified worksheet is displayed from right to left instead of from left to right.
        Default is false.'''
        raise NotImplementedError()
    
    @display_right_to_left.setter
    def display_right_to_left(self, value : bool) -> None:
        '''Indicates if the specified worksheet is displayed from right to left instead of from left to right.
        Default is false.'''
        raise NotImplementedError()
    
    @property
    def is_outline_shown(self) -> bool:
        '''Indicates whether to show outline.'''
        raise NotImplementedError()
    
    @is_outline_shown.setter
    def is_outline_shown(self, value : bool) -> None:
        '''Indicates whether to show outline.'''
        raise NotImplementedError()
    
    @property
    def is_selected(self) -> bool:
        '''Indicates whether this worksheet is selected when the workbook is opened.'''
        raise NotImplementedError()
    
    @is_selected.setter
    def is_selected(self, value : bool) -> None:
        '''Indicates whether this worksheet is selected when the workbook is opened.'''
        raise NotImplementedError()
    
    @property
    def list_objects(self) -> aspose.cells.tables.ListObjectCollection:
        '''Gets all ListObjects in this worksheet.'''
        raise NotImplementedError()
    
    @property
    def tab_id(self) -> int:
        '''Specifies the internal identifier for the sheet.'''
        raise NotImplementedError()
    
    @tab_id.setter
    def tab_id(self, value : int) -> None:
        '''Specifies the internal identifier for the sheet.'''
        raise NotImplementedError()
    
    @property
    def horizontal_page_breaks(self) -> aspose.cells.HorizontalPageBreakCollection:
        '''Gets the :py:class:`aspose.cells.HorizontalPageBreakCollection` collection.'''
        raise NotImplementedError()
    
    @property
    def vertical_page_breaks(self) -> aspose.cells.VerticalPageBreakCollection:
        '''Gets the :py:class:`aspose.cells.VerticalPageBreakCollection` collection.'''
        raise NotImplementedError()
    
    @property
    def hyperlinks(self) -> aspose.cells.HyperlinkCollection:
        '''Gets the :py:class:`aspose.cells.HyperlinkCollection` collection.'''
        raise NotImplementedError()
    
    @property
    def page_setup(self) -> aspose.cells.PageSetup:
        '''Represents the page setup description in this sheet.'''
        raise NotImplementedError()
    
    @property
    def auto_filter(self) -> aspose.cells.AutoFilter:
        '''Represents auto filter for the specified worksheet.'''
        raise NotImplementedError()
    
    @property
    def has_autofilter(self) -> bool:
        '''Indicates whether this worksheet has auto filter.'''
        raise NotImplementedError()
    
    @property
    def transition_evaluation(self) -> bool:
        '''Indicates whether the Transition Formula Evaluation (Lotus compatibility) option is enabled.'''
        raise NotImplementedError()
    
    @transition_evaluation.setter
    def transition_evaluation(self, value : bool) -> None:
        '''Indicates whether the Transition Formula Evaluation (Lotus compatibility) option is enabled.'''
        raise NotImplementedError()
    
    @property
    def transition_entry(self) -> bool:
        '''Indicates whether the Transition Formula Entry (Lotus compatibility) option is enabled.'''
        raise NotImplementedError()
    
    @transition_entry.setter
    def transition_entry(self, value : bool) -> None:
        '''Indicates whether the Transition Formula Entry (Lotus compatibility) option is enabled.'''
        raise NotImplementedError()
    
    @property
    def visibility_type(self) -> aspose.cells.VisibilityType:
        '''Indicates the visible state for this sheet.'''
        raise NotImplementedError()
    
    @visibility_type.setter
    def visibility_type(self, value : aspose.cells.VisibilityType) -> None:
        '''Indicates the visible state for this sheet.'''
        raise NotImplementedError()
    
    @property
    def is_visible(self) -> bool:
        '''Represents if the worksheet is visible.'''
        raise NotImplementedError()
    
    @is_visible.setter
    def is_visible(self, value : bool) -> None:
        '''Represents if the worksheet is visible.'''
        raise NotImplementedError()
    
    @property
    def sparkline_groups(self) -> aspose.cells.charts.SparklineGroupCollection:
        '''Gets the sparkline groups in the worksheet.'''
        raise NotImplementedError()
    
    @property
    def charts(self) -> aspose.cells.charts.ChartCollection:
        '''Gets a :py:class:`aspose.cells.charts.Chart` collection'''
        raise NotImplementedError()
    
    @property
    def comments(self) -> aspose.cells.CommentCollection:
        '''Gets the :py:class:`aspose.cells.Comment` collection.'''
        raise NotImplementedError()
    
    @property
    def pictures(self) -> aspose.cells.drawing.PictureCollection:
        '''Gets a :py:class:`aspose.cells.drawing.Picture` collection.'''
        raise NotImplementedError()
    
    @property
    def text_boxes(self) -> aspose.cells.drawing.TextBoxCollection:
        '''Gets a :py:class:`aspose.cells.drawing.TextBox` collection.'''
        raise NotImplementedError()
    
    @property
    def check_boxes(self) -> aspose.cells.drawing.CheckBoxCollection:
        '''Gets a :py:class:`aspose.cells.drawing.CheckBox` collection.'''
        raise NotImplementedError()
    
    @property
    def ole_objects(self) -> aspose.cells.drawing.OleObjectCollection:
        '''Represents a collection of :py:class:`aspose.cells.drawing.OleObject` in a worksheet.'''
        raise NotImplementedError()
    
    @property
    def shapes(self) -> aspose.cells.drawing.ShapeCollection:
        '''Returns all drawing shapes in this worksheet.'''
        raise NotImplementedError()
    
    @property
    def slicers(self) -> aspose.cells.slicers.SlicerCollection:
        '''Get the Slicer collection in the worksheet'''
        raise NotImplementedError()
    
    @property
    def timelines(self) -> aspose.cells.timelines.TimelineCollection:
        '''Get the Timeline collection in the worksheet'''
        raise NotImplementedError()
    
    @property
    def index(self) -> int:
        '''Gets the index of sheet in the worksheet collection.'''
        raise NotImplementedError()
    
    @property
    def is_protected(self) -> bool:
        '''Indicates if the worksheet is protected.'''
        raise NotImplementedError()
    
    @property
    def validations(self) -> aspose.cells.ValidationCollection:
        '''Gets the data validation setting collection in the worksheet.'''
        raise NotImplementedError()
    
    @property
    def allow_edit_ranges(self) -> aspose.cells.ProtectedRangeCollection:
        '''Gets the allow edit range collection in the worksheet.'''
        raise NotImplementedError()
    
    @property
    def error_check_options(self) -> aspose.cells.ErrorCheckOptionCollection:
        '''Gets error check setting applied on certain ranges.'''
        raise NotImplementedError()
    
    @property
    def outline(self) -> aspose.cells.Outline:
        '''Gets the outline on this worksheet.'''
        raise NotImplementedError()
    
    @property
    def first_visible_row(self) -> int:
        '''Represents first visible row index.'''
        raise NotImplementedError()
    
    @first_visible_row.setter
    def first_visible_row(self, value : int) -> None:
        '''Represents first visible row index.'''
        raise NotImplementedError()
    
    @property
    def first_visible_column(self) -> int:
        '''Represents first visible column index.'''
        raise NotImplementedError()
    
    @first_visible_column.setter
    def first_visible_column(self, value : int) -> None:
        '''Represents first visible column index.'''
        raise NotImplementedError()
    
    @property
    def zoom(self) -> int:
        '''Represents the scaling factor in percentage. It should be between 10 and 400.'''
        raise NotImplementedError()
    
    @zoom.setter
    def zoom(self, value : int) -> None:
        '''Represents the scaling factor in percentage. It should be between 10 and 400.'''
        raise NotImplementedError()
    
    @property
    def view_type(self) -> aspose.cells.ViewType:
        '''Gets and sets the view type.'''
        raise NotImplementedError()
    
    @view_type.setter
    def view_type(self, value : aspose.cells.ViewType) -> None:
        '''Gets and sets the view type.'''
        raise NotImplementedError()
    
    @property
    def is_page_break_preview(self) -> bool:
        '''Indicates whether the specified worksheet is shown in normal view or page break preview.'''
        raise NotImplementedError()
    
    @is_page_break_preview.setter
    def is_page_break_preview(self, value : bool) -> None:
        '''Indicates whether the specified worksheet is shown in normal view or page break preview.'''
        raise NotImplementedError()
    
    @property
    def is_ruler_visible(self) -> bool:
        '''Indicates whether the ruler is visible. This property is only applied for page break preview.'''
        raise NotImplementedError()
    
    @is_ruler_visible.setter
    def is_ruler_visible(self, value : bool) -> None:
        '''Indicates whether the ruler is visible. This property is only applied for page break preview.'''
        raise NotImplementedError()
    
    @property
    def tab_color(self) -> aspose.pydrawing.Color:
        '''Represents worksheet tab color.'''
        raise NotImplementedError()
    
    @tab_color.setter
    def tab_color(self, value : aspose.pydrawing.Color) -> None:
        '''Represents worksheet tab color.'''
        raise NotImplementedError()
    
    @property
    def code_name(self) -> str:
        '''Gets worksheet code name.'''
        raise NotImplementedError()
    
    @code_name.setter
    def code_name(self, value : str) -> None:
        '''Gets worksheet code name.'''
        raise NotImplementedError()
    
    @property
    def background_image(self) -> List[int]:
        '''Gets and sets worksheet background image.'''
        raise NotImplementedError()
    
    @background_image.setter
    def background_image(self, value : List[int]) -> None:
        '''Gets and sets worksheet background image.'''
        raise NotImplementedError()
    
    @property
    def conditional_formattings(self) -> aspose.cells.ConditionalFormattingCollection:
        '''Gets the ConditionalFormattings in the worksheet.'''
        raise NotImplementedError()
    
    @property
    def active_cell(self) -> str:
        '''Gets the active cell in the worksheet.'''
        raise NotImplementedError()
    
    @active_cell.setter
    def active_cell(self, value : str) -> None:
        '''Sets the active cell in the worksheet.'''
        raise NotImplementedError()
    
    @property
    def custom_properties(self) -> aspose.cells.properties.CustomPropertyCollection:
        '''Gets an object representing
        the identifier information associated with a worksheet.'''
        raise NotImplementedError()
    
    @property
    def smart_tag_setting(self) -> aspose.cells.markup.SmartTagSetting:
        '''Gets all :py:class:`aspose.cells.markup.SmartTagCollection` objects of the worksheet.'''
        raise NotImplementedError()
    
    @property
    def scenarios(self) -> aspose.cells.ScenarioCollection:
        '''Gets the collection of :py:class:`aspose.cells.Scenario`.'''
        raise NotImplementedError()
    
    @property
    def cell_watches(self) -> aspose.cells.CellWatchCollection:
        '''Gets collection of cells on this worksheet being watched in the \'watch window\'.'''
        raise NotImplementedError()
    

class WorksheetCollection:
    '''Encapsulates a collection of :py:class:`aspose.cells.Worksheet` objects.'''
    
    @overload
    def get(self, index : int) -> aspose.cells.Worksheet:
        '''Add API for Python Via .Net.since this[int index] is unsupported
        
        :param index: The zero based index of the element.'''
        raise NotImplementedError()
    
    @overload
    def get(self, sheet_name : str) -> aspose.cells.Worksheet:
        '''Add API for Python Via .Net.since this[string sheetName] is unsupported
        
        :param sheet_name: Worksheet name'''
        raise NotImplementedError()
    
    @overload
    def add(self, type : aspose.cells.SheetType) -> int:
        '''Adds a worksheet to the collection.
        
        :param type: Worksheet type.
        :returns: :py:class:`aspose.cells.Worksheet` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self) -> int:
        '''Adds a worksheet to the collection.
        
        :returns: :py:class:`aspose.cells.Worksheet` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, sheet_name : str) -> aspose.cells.Worksheet:
        '''Adds a worksheet to the collection.
        
        :param sheet_name: Worksheet name
        :returns: :py:class:`aspose.cells.Worksheet` object.'''
        raise NotImplementedError()
    
    @overload
    def register_add_in_function(self, add_in_file : str, function_name : str, lib : bool) -> int:
        '''Adds addin function into the workbook
        
        :param add_in_file: the file contains the addin functions
        :param function_name: the addin function name
        :param lib: whether the given addin file is in the directory or sub-directory of Workbook Add-In library.
        This flag takes effect and makes difference when given addInFile is of relative path:
        true denotes the path is relative to Add-In library and false denotes the path is relative to this Workbook.
        :returns: ID of the data which contains given addin function'''
        raise NotImplementedError()
    
    @overload
    def register_add_in_function(self, id : int, function_name : str) -> str:
        '''Adds addin function into the workbook
        
        :param id: ID of the data which contains addin functions,
        can be got by the first call of :py:func:`aspose.cells.WorksheetCollection.register_add_in_function` for the same addin file.
        :param function_name: the addin function name
        :returns: URL of the addin file which contains addin functions'''
        raise NotImplementedError()
    
    @overload
    def add_copy(self, sheet_name : str) -> int:
        '''Adds a worksheet to the collection and copies data from an existed worksheet.
        
        :param sheet_name: Name of source worksheet.
        :returns: :py:class:`aspose.cells.Worksheet` object index.'''
        raise NotImplementedError()
    
    @overload
    def add_copy(self, sheet_index : int) -> int:
        '''Adds a worksheet to the collection and copies data from an existed worksheet.
        
        :param sheet_index: Index of source worksheet.
        :returns: :py:class:`aspose.cells.Worksheet` object index.'''
        raise NotImplementedError()
    
    @overload
    def add_copy(self, source : List[aspose.cells.Worksheet], dest_sheet_names : List[str]) -> None:
        '''Copy a group of worksheets.
        
        :param source: The source worksheets.
        :param dest_sheet_names: The names of the copied sheets.'''
        raise NotImplementedError()
    
    @overload
    def get_range_by_name(self, range_name : str) -> aspose.cells.Range:
        '''Gets Range object by pre-defined name.
        
        :param range_name: Name of range.
        :returns: Range object.
        
        Returns null if the named range does not exist.'''
        raise NotImplementedError()
    
    @overload
    def get_range_by_name(self, range_name : str, current_sheet_index : int, include_table : bool) -> aspose.cells.Range:
        '''Gets :py:class:`aspose.cells.Range` by pre-defined name or table\'s name
        
        :param range_name: Name of range or table\'s name.
        :param current_sheet_index: The sheet index. -1 represents global .
        :param include_table: Indicates whether checking all tables.'''
        raise NotImplementedError()
    
    @overload
    def refresh_pivot_tables(self) -> None:
        '''Refreshes all the PivotTables in the WorksheetCollection.'''
        raise NotImplementedError()
    
    @overload
    def refresh_pivot_tables(self, option : aspose.cells.pivot.PivotTableRefreshOption) -> bool:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.Worksheet]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.Worksheet], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Worksheet, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.Worksheet, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Worksheet) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Worksheet, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.Worksheet, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def create_range(self, address : str, sheet_index : int) -> aspose.cells.Range:
        '''Creates a :py:class:`aspose.cells.Range` object from an address of the range.
        
        :param address: The address of the range.
        :param sheet_index: The sheet index.
        :returns: A :py:class:`aspose.cells.Range` object'''
        raise NotImplementedError()
    
    def create_union_range(self, address : str, sheet_index : int) -> aspose.cells.UnionRange:
        '''Creates a :py:class:`aspose.cells.Range` object from an address of the range.
        
        :param address: The address of the range.
        :param sheet_index: The sheet index.
        :returns: A :py:class:`aspose.cells.Range` object'''
        raise NotImplementedError()
    
    def get_sheet_by_code_name(self, code_name : str) -> aspose.cells.Worksheet:
        '''Gets the worksheet by the code name.
        
        :param code_name: Worksheet code name.
        :returns: The element with the specified code name.'''
        raise NotImplementedError()
    
    def sort_names(self) -> None:
        '''Sorts the defined names.'''
        raise NotImplementedError()
    
    def swap_sheet(self, sheet_index1 : int, sheet_index2 : int) -> None:
        '''Swaps the two sheets.
        
        :param sheet_index1: The first worksheet.
        :param sheet_index2: The second worksheet.'''
        raise NotImplementedError()
    
    def remove_by_name(self, name : str) -> None:
        raise NotImplementedError()
    
    def remove_by_index(self, index : int) -> None:
        raise NotImplementedError()
    
    def remove_at(self, name : str) -> None:
        '''Removes the element at a specified name.
        
        :param name: The name of the element to remove.'''
        raise NotImplementedError()
    
    def get_named_ranges(self) -> List[aspose.cells.Range]:
        '''Gets all pre-defined named ranges in the spreadsheet.
        
        :returns: An array of Range objects.
        If the defined Name\'s reference is external or has multiple ranges, no Range object will be returned for this Name.
        
        
        Returns null if the named range does not exist.'''
        raise NotImplementedError()
    
    def get_named_ranges_and_tables(self) -> List[aspose.cells.Range]:
        '''Gets all pre-defined named ranges in the spreadsheet.
        
        :returns: An array of Range objects.
        
        Returns null if the named range does not exist.'''
        raise NotImplementedError()
    
    def set_ole_size(self, start_row : int, end_row : int, start_column : int, end_column : int) -> None:
        '''Sets displayed size when Workbook file is used as an Ole object.
        
        :param start_row: Start row index.
        :param end_row: End row index.
        :param start_column: Start column index.
        :param end_column: End column index.'''
        raise NotImplementedError()
    
    def clear_pivottables(self) -> None:
        '''Clears pivot tables from the spreadsheet.'''
        raise NotImplementedError()
    
    def refresh_all(self) -> None:
        '''Refresh all pivot tables and charts with pivot source.'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.Worksheet) -> int:
        raise NotImplementedError()
    
    @property
    def web_extension_task_panes(self) -> aspose.cells.webextensions.WebExtensionTaskPaneCollection:
        '''Gets the list of task panes.'''
        raise NotImplementedError()
    
    @property
    def web_extensions(self) -> aspose.cells.webextensions.WebExtensionCollection:
        '''Gets the list of task panes.'''
        raise NotImplementedError()
    
    @property
    def threaded_comment_authors(self) -> aspose.cells.ThreadedCommentAuthorCollection:
        '''Gets the list of threaded comment authors.'''
        raise NotImplementedError()
    
    @property
    def is_refresh_all_connections(self) -> bool:
        '''Indicates whether refresh all connections on opening file in MS Excel.'''
        raise NotImplementedError()
    
    @is_refresh_all_connections.setter
    def is_refresh_all_connections(self, value : bool) -> None:
        '''Indicates whether refresh all connections on opening file in MS Excel.'''
        raise NotImplementedError()
    
    @property
    def names(self) -> aspose.cells.NameCollection:
        '''Gets the collection of all the Name objects in the spreadsheet.'''
        raise NotImplementedError()
    
    @property
    def active_sheet_name(self) -> str:
        '''Represents the name of active worksheet when the spreadsheet is opened.'''
        raise NotImplementedError()
    
    @active_sheet_name.setter
    def active_sheet_name(self, value : str) -> None:
        '''Represents the name of active worksheet when the spreadsheet is opened.'''
        raise NotImplementedError()
    
    @property
    def active_sheet_index(self) -> int:
        '''Represents the index of active worksheet when the spreadsheet is opened.'''
        raise NotImplementedError()
    
    @active_sheet_index.setter
    def active_sheet_index(self, value : int) -> None:
        '''Represents the index of active worksheet when the spreadsheet is opened.'''
        raise NotImplementedError()
    
    @property
    def dxfs(self) -> aspose.cells.DxfCollection:
        '''Gets the master differential formatting records.'''
        raise NotImplementedError()
    
    @property
    def xml_maps(self) -> aspose.cells.XmlMapCollection:
        '''Gets and sets the XML maps in the workbook.'''
        raise NotImplementedError()
    
    @xml_maps.setter
    def xml_maps(self, value : aspose.cells.XmlMapCollection) -> None:
        '''Gets and sets the XML maps in the workbook.'''
        raise NotImplementedError()
    
    @property
    def built_in_document_properties(self) -> aspose.cells.properties.BuiltInDocumentPropertyCollection:
        '''Returns a :py:class:`aspose.cells.properties.DocumentProperty` collection that represents all the built-in document properties of the spreadsheet.'''
        raise NotImplementedError()
    
    @property
    def custom_document_properties(self) -> aspose.cells.properties.CustomDocumentPropertyCollection:
        '''Returns a :py:class:`aspose.cells.properties.DocumentProperty` collection that represents all the custom document properties of the spreadsheet.'''
        raise NotImplementedError()
    
    @property
    def ole_size(self) -> Any:
        '''Gets and Sets displayed size when Workbook file is used as an Ole object.'''
        raise NotImplementedError()
    
    @ole_size.setter
    def ole_size(self, value : Any) -> None:
        '''Gets and Sets displayed size when Workbook file is used as an Ole object.'''
        raise NotImplementedError()
    
    @property
    def external_links(self) -> aspose.cells.ExternalLinkCollection:
        '''Represents external links in a workbook.'''
        raise NotImplementedError()
    
    @property
    def table_styles(self) -> aspose.cells.tables.TableStyleCollection:
        '''Gets :py:attr:`aspose.cells.WorksheetCollection.table_styles` object.'''
        raise NotImplementedError()
    
    @property
    def revision_logs(self) -> aspose.cells.revisions.RevisionLogCollection:
        '''Represents revision logs.'''
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class WriteProtection:
    '''Specifies write protection settings for a workbook.'''
    
    def validate_password(self, password : str) -> bool:
        '''Returns true if the specified password is the same as the write-protection password the file was protected with.
        
        :param password: The specified password.'''
        raise NotImplementedError()
    
    @property
    def author(self) -> str:
        '''Gets and sets the author.'''
        raise NotImplementedError()
    
    @author.setter
    def author(self, value : str) -> None:
        '''Gets and sets the author.'''
        raise NotImplementedError()
    
    @property
    def recommend_read_only(self) -> bool:
        '''Indicates if the Read Only Recommended option is selected.'''
        raise NotImplementedError()
    
    @recommend_read_only.setter
    def recommend_read_only(self, value : bool) -> None:
        '''Indicates if the Read Only Recommended option is selected.'''
        raise NotImplementedError()
    
    @property
    def is_write_protected(self) -> bool:
        '''Indicates whether this workbook is write protected.'''
        raise NotImplementedError()
    
    @property
    def password(self) -> str:
        '''Sets the protected password to modify the file.'''
        raise NotImplementedError()
    
    @password.setter
    def password(self, value : str) -> None:
        '''Sets the protected password to modify the file.'''
        raise NotImplementedError()
    

class XlsSaveOptions(SaveOptions):
    '''Represents the save options for the Excel 97-2003 file format: xls and xlt.'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def light_cells_data_provider(self) -> aspose.cells.LightCellsDataProvider:
        '''The data provider for saving workbook in light mode.'''
        raise NotImplementedError()
    
    @light_cells_data_provider.setter
    def light_cells_data_provider(self, value : aspose.cells.LightCellsDataProvider) -> None:
        '''The data provider for saving workbook in light mode.'''
        raise NotImplementedError()
    
    @property
    def is_template(self) -> bool:
        '''Indicates whether saving a template file.'''
        raise NotImplementedError()
    
    @is_template.setter
    def is_template(self, value : bool) -> None:
        '''Indicates whether saving a template file.'''
        raise NotImplementedError()
    
    @property
    def match_color(self) -> bool:
        '''Indicates whether matching font color because there are 56 colors in the standard color palette.'''
        raise NotImplementedError()
    
    @match_color.setter
    def match_color(self, value : bool) -> None:
        '''Indicates whether matching font color because there are 56 colors in the standard color palette.'''
        raise NotImplementedError()
    
    @property
    def wps_compatibility(self) -> bool:
        raise NotImplementedError()
    
    @wps_compatibility.setter
    def wps_compatibility(self, value : bool) -> None:
        raise NotImplementedError()
    

class XlsbSaveOptions(SaveOptions):
    '''Represents the options for saving xlsb file.'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def compression_type(self) -> aspose.cells.OoxmlCompressionType:
        '''Gets and sets the compression type for ooxml file.'''
        raise NotImplementedError()
    
    @compression_type.setter
    def compression_type(self, value : aspose.cells.OoxmlCompressionType) -> None:
        '''Gets and sets the compression type for ooxml file.'''
        raise NotImplementedError()
    
    @property
    def export_all_column_indexes(self) -> bool:
        '''Indicates whether exporting all column indexes for cells.'''
        raise NotImplementedError()
    
    @export_all_column_indexes.setter
    def export_all_column_indexes(self, value : bool) -> None:
        '''Indicates whether exporting all column indexes for cells.'''
        raise NotImplementedError()
    
    @property
    def light_cells_data_provider(self) -> aspose.cells.LightCellsDataProvider:
        '''The data provider for saving workbook in light mode.'''
        raise NotImplementedError()
    
    @light_cells_data_provider.setter
    def light_cells_data_provider(self, value : aspose.cells.LightCellsDataProvider) -> None:
        '''The data provider for saving workbook in light mode.'''
        raise NotImplementedError()
    

class XmlColumnProperty:
    '''Represents Xml Data Binding information.'''
    

class XmlDataBinding:
    '''Represents Xml Data Binding information.'''
    
    @property
    def url(self) -> str:
        '''Gets source url of this data binding.'''
        raise NotImplementedError()
    

class XmlLoadOptions(LoadOptions):
    '''Represents the options of loading xml.'''
    
    def set_paper_size(self, type : aspose.cells.PaperSizeType) -> None:
        '''Sets the default print paper size from default printer\'s setting.
        
        :param type: The default paper size.'''
        raise NotImplementedError()
    
    @property
    def load_format(self) -> aspose.cells.LoadFormat:
        '''Gets the load format.'''
        raise NotImplementedError()
    
    @property
    def password(self) -> str:
        '''Gets and set the password of the workbook.'''
        raise NotImplementedError()
    
    @password.setter
    def password(self, value : str) -> None:
        '''Gets and set the password of the workbook.'''
        raise NotImplementedError()
    
    @property
    def parsing_formula_on_open(self) -> bool:
        '''Indicates whether parsing the formula when reading the file.'''
        raise NotImplementedError()
    
    @parsing_formula_on_open.setter
    def parsing_formula_on_open(self, value : bool) -> None:
        '''Indicates whether parsing the formula when reading the file.'''
        raise NotImplementedError()
    
    @property
    def parsing_pivot_cached_records(self) -> bool:
        '''Indicates whether parsing pivot cached records when loading the file.
        The default value is false.'''
        raise NotImplementedError()
    
    @parsing_pivot_cached_records.setter
    def parsing_pivot_cached_records(self, value : bool) -> None:
        '''Indicates whether parsing pivot cached records when loading the file.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def language_code(self) -> aspose.cells.CountryCode:
        '''Gets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @language_code.setter
    def language_code(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the user interface language of the Workbook version based on CountryCode that has saved the file.'''
        raise NotImplementedError()
    
    @property
    def region(self) -> aspose.cells.CountryCode:
        '''Gets the system regional settings based on CountryCode at the time the file was loaded.'''
        raise NotImplementedError()
    
    @region.setter
    def region(self, value : aspose.cells.CountryCode) -> None:
        '''Sets the system regional settings based on CountryCode at the time the file was loaded.'''
        raise NotImplementedError()
    
    @property
    def default_style_settings(self) -> aspose.cells.DefaultStyleSettings:
        '''Gets the default style settings for initializing styles of the workbook'''
        raise NotImplementedError()
    
    @property
    def standard_font(self) -> str:
        '''Sets the default standard font name'''
        raise NotImplementedError()
    
    @standard_font.setter
    def standard_font(self, value : str) -> None:
        '''Sets the default standard font name'''
        raise NotImplementedError()
    
    @property
    def standard_font_size(self) -> float:
        '''Sets the default standard font size.'''
        raise NotImplementedError()
    
    @standard_font_size.setter
    def standard_font_size(self, value : float) -> None:
        '''Sets the default standard font size.'''
        raise NotImplementedError()
    
    @property
    def interrupt_monitor(self) -> aspose.cells.AbstractInterruptMonitor:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.cells.AbstractInterruptMonitor) -> None:
        '''Gets and sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @property
    def ignore_not_printed(self) -> bool:
        '''Ignore the data which are not printed if directly printing the file'''
        raise NotImplementedError()
    
    @ignore_not_printed.setter
    def ignore_not_printed(self, value : bool) -> None:
        '''Ignore the data which are not printed if directly printing the file'''
        raise NotImplementedError()
    
    @property
    def check_data_valid(self) -> bool:
        '''Check whether data is valid in the template file.'''
        raise NotImplementedError()
    
    @check_data_valid.setter
    def check_data_valid(self, value : bool) -> None:
        '''Check whether data is valid in the template file.'''
        raise NotImplementedError()
    
    @property
    def check_excel_restriction(self) -> bool:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @check_excel_restriction.setter
    def check_excel_restriction(self, value : bool) -> None:
        '''Whether check restriction of excel file when user modify cells related objects.
        For example, excel does not allow inputting string value longer than 32K.
        When you input a value longer than 32K such as by Cell.PutValue(string), if this property is true, you will get an Exception.
        If this property is false, we will accept your input string value as the cell\'s value so that later
        you can output the complete string value for other file formats such as CSV.
        However, if you have set such kind of value that is invalid for excel file format,
        you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.'''
        raise NotImplementedError()
    
    @property
    def keep_unparsed_data(self) -> bool:
        '''Whether keep the unparsed data in memory for the Workbook when it is loaded from template file. Default is true.'''
        raise NotImplementedError()
    
    @keep_unparsed_data.setter
    def keep_unparsed_data(self, value : bool) -> None:
        '''Whether keep the unparsed data in memory for the Workbook when it is loaded from template file. Default is true.'''
        raise NotImplementedError()
    
    @property
    def load_filter(self) -> aspose.cells.LoadFilter:
        '''The filter to denote how to load data.'''
        raise NotImplementedError()
    
    @load_filter.setter
    def load_filter(self, value : aspose.cells.LoadFilter) -> None:
        '''The filter to denote how to load data.'''
        raise NotImplementedError()
    
    @property
    def light_cells_data_handler(self) -> aspose.cells.LightCellsDataHandler:
        '''The data handler for processing cells data when reading template file.'''
        raise NotImplementedError()
    
    @light_cells_data_handler.setter
    def light_cells_data_handler(self, value : aspose.cells.LightCellsDataHandler) -> None:
        '''The data handler for processing cells data when reading template file.'''
        raise NotImplementedError()
    
    @property
    def memory_setting(self) -> aspose.cells.MemorySetting:
        '''Gets the memory usage options.'''
        raise NotImplementedError()
    
    @memory_setting.setter
    def memory_setting(self, value : aspose.cells.MemorySetting) -> None:
        '''Sets the memory usage options.'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def auto_fitter_options(self) -> aspose.cells.AutoFitterOptions:
        '''Gets and sets the auto fitter options'''
        raise NotImplementedError()
    
    @auto_fitter_options.setter
    def auto_fitter_options(self, value : aspose.cells.AutoFitterOptions) -> None:
        '''Gets and sets the auto fitter options'''
        raise NotImplementedError()
    
    @property
    def auto_filter(self) -> bool:
        '''Indicates whether auto filtering the data when loading the files.'''
        raise NotImplementedError()
    
    @auto_filter.setter
    def auto_filter(self, value : bool) -> None:
        '''Indicates whether auto filtering the data when loading the files.'''
        raise NotImplementedError()
    
    @property
    def font_configs(self) -> aspose.cells.IndividualFontConfigs:
        '''Gets and sets individual font configs.
        Only works for the :py:class:`aspose.cells.Workbook` which uses this :py:class:`aspose.cells.LoadOptions` to load.'''
        raise NotImplementedError()
    
    @font_configs.setter
    def font_configs(self, value : aspose.cells.IndividualFontConfigs) -> None:
        '''Gets and sets individual font configs.
        Only works for the :py:class:`aspose.cells.Workbook` which uses this :py:class:`aspose.cells.LoadOptions` to load.'''
        raise NotImplementedError()
    
    @property
    def ignore_useless_shapes(self) -> bool:
        '''Indicates whether ignoring useless shapes.'''
        raise NotImplementedError()
    
    @ignore_useless_shapes.setter
    def ignore_useless_shapes(self, value : bool) -> None:
        '''Indicates whether ignoring useless shapes.'''
        raise NotImplementedError()
    
    @property
    def preserve_padding_spaces_in_formula(self) -> bool:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    
    @preserve_padding_spaces_in_formula.setter
    def preserve_padding_spaces_in_formula(self, value : bool) -> None:
        '''Indicates whether preserve those spaces and line breaks that are padded between formula tokens
        while getting and setting formulas.
        Default value is false.'''
        raise NotImplementedError()
    
    @property
    def start_cell(self) -> str:
        '''Gets and sets the start cell.'''
        raise NotImplementedError()
    
    @start_cell.setter
    def start_cell(self, value : str) -> None:
        '''Gets and sets the start cell.'''
        raise NotImplementedError()
    
    @property
    def is_xml_map(self) -> bool:
        '''Indicates whether mapping xml to Excel.
        The default value is false.'''
        raise NotImplementedError()
    
    @is_xml_map.setter
    def is_xml_map(self, value : bool) -> None:
        '''Indicates whether mapping xml to Excel.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def contains_multiple_worksheets(self) -> bool:
        '''Indicates whether importing xml as multiple worksheets.'''
        raise NotImplementedError()
    
    @contains_multiple_worksheets.setter
    def contains_multiple_worksheets(self, value : bool) -> None:
        '''Indicates whether importing xml as multiple worksheets.'''
        raise NotImplementedError()
    
    @property
    def convert_numeric_or_date(self) -> bool:
        '''Indicates whether converting the value in xml file to numeric or date.'''
        raise NotImplementedError()
    
    @convert_numeric_or_date.setter
    def convert_numeric_or_date(self, value : bool) -> None:
        '''Indicates whether converting the value in xml file to numeric or date.'''
        raise NotImplementedError()
    
    @property
    def number_format(self) -> str:
        '''Gets and sets the format of numeric value.'''
        raise NotImplementedError()
    
    @number_format.setter
    def number_format(self, value : str) -> None:
        '''Gets and sets the format of numeric value.'''
        raise NotImplementedError()
    
    @property
    def date_format(self) -> str:
        '''Gets and sets the format of date value.'''
        raise NotImplementedError()
    
    @date_format.setter
    def date_format(self, value : str) -> None:
        '''Gets and sets the format of date value.'''
        raise NotImplementedError()
    
    @property
    def ignore_root_attributes(self) -> bool:
        '''Indicates whether ignore attributes of the root element.'''
        raise NotImplementedError()
    
    @ignore_root_attributes.setter
    def ignore_root_attributes(self, value : bool) -> None:
        '''Indicates whether ignore attributes of the root element.'''
        raise NotImplementedError()
    

class XmlMap:
    '''Represents Xml map information.'''
    
    @property
    def name(self) -> str:
        '''Returns the name of the object.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Returns or sets the name of the object.'''
        raise NotImplementedError()
    
    @property
    def root_element_name(self) -> str:
        '''Gets root element name.'''
        raise NotImplementedError()
    
    @property
    def data_binding(self) -> aspose.cells.XmlDataBinding:
        '''Gets an :py:class:`aspose.cells.XmlDataBinding` of this map.'''
        raise NotImplementedError()
    

class XmlMapCollection:
    '''A collection of :py:class:`aspose.cells.XmlMap` objects that represent XmlMap information.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.XmlMap]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.XmlMap], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.XmlMap, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.XmlMap, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.XmlMap) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.XmlMap, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.XmlMap, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def add(self, url : str) -> int:
        '''Add a :py:class:`aspose.cells.XmlMap` by the url/path of a xml/xsd file.
        
        :param url: url/path of a xml/xsd file.
        :returns: :py:class:`aspose.cells.XmlMap` object index.'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.XmlMap) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class XmlSaveOptions(SaveOptions):
    '''Represents the options of saving the workbook as an xml file.'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def sheet_indexes(self) -> List[int]:
        '''Represents the indexes of exported sheets.'''
        raise NotImplementedError()
    
    @sheet_indexes.setter
    def sheet_indexes(self, value : List[int]) -> None:
        '''Represents the indexes of exported sheets.'''
        raise NotImplementedError()
    
    @property
    def export_area(self) -> aspose.cells.CellArea:
        '''Gets the exporting range.'''
        raise NotImplementedError()
    
    @export_area.setter
    def export_area(self, value : aspose.cells.CellArea) -> None:
        '''Sets the exporting range.'''
        raise NotImplementedError()
    
    @property
    def has_header_row(self) -> bool:
        '''Indicates whether the range contains header row.'''
        raise NotImplementedError()
    
    @has_header_row.setter
    def has_header_row(self, value : bool) -> None:
        '''Indicates whether the range contains header row.'''
        raise NotImplementedError()
    
    @property
    def xml_map_name(self) -> str:
        '''Indicates whether exporting xml map in the file.'''
        raise NotImplementedError()
    
    @xml_map_name.setter
    def xml_map_name(self, value : str) -> None:
        '''Indicates whether exporting xml map in the file.'''
        raise NotImplementedError()
    
    @property
    def sheet_name_as_element_name(self) -> bool:
        '''Indicates whether exporting sheet\'s name as the name of the element.'''
        raise NotImplementedError()
    
    @sheet_name_as_element_name.setter
    def sheet_name_as_element_name(self, value : bool) -> None:
        '''Indicates whether exporting sheet\'s name as the name of the element.'''
        raise NotImplementedError()
    
    @property
    def data_as_attribute(self) -> bool:
        '''Indicates whether exporting data as attributes of element.'''
        raise NotImplementedError()
    
    @data_as_attribute.setter
    def data_as_attribute(self, value : bool) -> None:
        '''Indicates whether exporting data as attributes of element.'''
        raise NotImplementedError()
    

class XpsSaveOptions(PaginatedSaveOptions):
    '''Represents the additional options when saving the file as the Xps.'''
    
    @property
    def save_format(self) -> aspose.cells.SaveFormat:
        '''Gets the save file format.'''
        raise NotImplementedError()
    
    @property
    def clear_data(self) -> bool:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @clear_data.setter
    def clear_data(self, value : bool) -> None:
        '''Make the workbook empty after saving the file.'''
        raise NotImplementedError()
    
    @property
    def cached_file_folder(self) -> str:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @cached_file_folder.setter
    def cached_file_folder(self, value : str) -> None:
        '''The cached file folder is used to store some large data.'''
        raise NotImplementedError()
    
    @property
    def validate_merged_areas(self) -> bool:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @validate_merged_areas.setter
    def validate_merged_areas(self, value : bool) -> None:
        '''Indicates whether validate merged cells before saving the file.'''
        raise NotImplementedError()
    
    @property
    def merge_areas(self) -> bool:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @merge_areas.setter
    def merge_areas(self, value : bool) -> None:
        '''Indicates whether merge the areas of conditional formatting and validation before saving the file.'''
        raise NotImplementedError()
    
    @property
    def create_directory(self) -> bool:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @create_directory.setter
    def create_directory(self, value : bool) -> None:
        '''If true and the directory does not exist, the directory will be automatically created before saving the file.'''
        raise NotImplementedError()
    
    @property
    def sort_names(self) -> bool:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_names.setter
    def sort_names(self, value : bool) -> None:
        '''Indicates whether sorting defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def sort_external_names(self) -> bool:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @sort_external_names.setter
    def sort_external_names(self, value : bool) -> None:
        '''Indicates whether sorting external defined names before saving file.'''
        raise NotImplementedError()
    
    @property
    def refresh_chart_cache(self) -> bool:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @refresh_chart_cache.setter
    def refresh_chart_cache(self, value : bool) -> None:
        '''Indicates whether refreshing chart cache data'''
        raise NotImplementedError()
    
    @property
    def warning_callback(self) -> aspose.cells.IWarningCallback:
        '''Gets warning callback.'''
        raise NotImplementedError()
    
    @warning_callback.setter
    def warning_callback(self, value : aspose.cells.IWarningCallback) -> None:
        '''Sets warning callback.'''
        raise NotImplementedError()
    
    @property
    def update_smart_art(self) -> bool:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @update_smart_art.setter
    def update_smart_art(self, value : bool) -> None:
        '''Indicates whether updating smart art setting.
        The default value is false.'''
        raise NotImplementedError()
    
    @property
    def encrypt_document_properties(self) -> bool:
        raise NotImplementedError()
    
    @encrypt_document_properties.setter
    def encrypt_document_properties(self, value : bool) -> None:
        raise NotImplementedError()
    
    @property
    def default_font(self) -> str:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set the DefaultFont such as MingLiu or MS Gothic to show these characters.
        If this property is not set, Aspose.Cells will use system default font to show these unicode characters.'''
        raise NotImplementedError()
    
    @default_font.setter
    def default_font(self, value : str) -> None:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set the DefaultFont such as MingLiu or MS Gothic to show these characters.
        If this property is not set, Aspose.Cells will use system default font to show these unicode characters.'''
        raise NotImplementedError()
    
    @property
    def check_workbook_default_font(self) -> bool:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set this to true to try to use workbook\'s default font to show these characters first.'''
        raise NotImplementedError()
    
    @check_workbook_default_font.setter
    def check_workbook_default_font(self, value : bool) -> None:
        '''When characters in the Excel are Unicode and not be set with correct font in cell style,
        They may appear as block in pdf,image.
        Set this to true to try to use workbook\'s default font to show these characters first.'''
        raise NotImplementedError()
    
    @property
    def check_font_compatibility(self) -> bool:
        '''Indicates whether to check font compatibility for every character in text.'''
        raise NotImplementedError()
    
    @check_font_compatibility.setter
    def check_font_compatibility(self, value : bool) -> None:
        '''Indicates whether to check font compatibility for every character in text.'''
        raise NotImplementedError()
    
    @property
    def is_font_substitution_char_granularity(self) -> bool:
        '''Indicates whether to only substitute the font of character when the cell font is not compatibility for it.'''
        raise NotImplementedError()
    
    @is_font_substitution_char_granularity.setter
    def is_font_substitution_char_granularity(self, value : bool) -> None:
        '''Indicates whether to only substitute the font of character when the cell font is not compatibility for it.'''
        raise NotImplementedError()
    
    @property
    def one_page_per_sheet(self) -> bool:
        '''If OnePagePerSheet is true , all content of one sheet will output to only one page in result.
        The paper size of pagesetup will be invalid, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @one_page_per_sheet.setter
    def one_page_per_sheet(self, value : bool) -> None:
        '''If OnePagePerSheet is true , all content of one sheet will output to only one page in result.
        The paper size of pagesetup will be invalid, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @property
    def all_columns_in_one_page_per_sheet(self) -> bool:
        '''If AllColumnsInOnePagePerSheet is true , all column content of one sheet will output to only one page in result.
        The width of paper size of pagesetup will be ignored, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @all_columns_in_one_page_per_sheet.setter
    def all_columns_in_one_page_per_sheet(self, value : bool) -> None:
        '''If AllColumnsInOnePagePerSheet is true , all column content of one sheet will output to only one page in result.
        The width of paper size of pagesetup will be ignored, and the other settings of pagesetup
        will still take effect.'''
        raise NotImplementedError()
    
    @property
    def ignore_error(self) -> bool:
        '''Indicates if you need to hide the error while rendering.
        The error can be error in shape, image, chart rendering, etc.'''
        raise NotImplementedError()
    
    @ignore_error.setter
    def ignore_error(self, value : bool) -> None:
        '''Indicates if you need to hide the error while rendering.
        The error can be error in shape, image, chart rendering, etc.'''
        raise NotImplementedError()
    
    @property
    def output_blank_page_when_nothing_to_print(self) -> bool:
        '''Indicates whether to output a blank page when there is nothing to print.'''
        raise NotImplementedError()
    
    @output_blank_page_when_nothing_to_print.setter
    def output_blank_page_when_nothing_to_print(self, value : bool) -> None:
        '''Indicates whether to output a blank page when there is nothing to print.'''
        raise NotImplementedError()
    
    @property
    def page_index(self) -> int:
        '''Gets the 0-based index of the first page to save.'''
        raise NotImplementedError()
    
    @page_index.setter
    def page_index(self, value : int) -> None:
        '''Sets the 0-based index of the first page to save.'''
        raise NotImplementedError()
    
    @property
    def page_count(self) -> int:
        '''Gets the number of pages to save.'''
        raise NotImplementedError()
    
    @page_count.setter
    def page_count(self, value : int) -> None:
        '''Sets the number of pages to save.'''
        raise NotImplementedError()
    
    @property
    def printing_page_type(self) -> aspose.cells.PrintingPageType:
        '''Indicates which pages will not be printed.'''
        raise NotImplementedError()
    
    @printing_page_type.setter
    def printing_page_type(self, value : aspose.cells.PrintingPageType) -> None:
        '''Indicates which pages will not be printed.'''
        raise NotImplementedError()
    
    @property
    def gridline_type(self) -> aspose.cells.GridlineType:
        '''Gets gridline type.'''
        raise NotImplementedError()
    
    @gridline_type.setter
    def gridline_type(self, value : aspose.cells.GridlineType) -> None:
        '''Sets gridline type.'''
        raise NotImplementedError()
    
    @property
    def text_cross_type(self) -> aspose.cells.TextCrossType:
        '''Gets displaying text type when the text width is larger than cell width.'''
        raise NotImplementedError()
    
    @text_cross_type.setter
    def text_cross_type(self, value : aspose.cells.TextCrossType) -> None:
        '''Sets displaying text type when the text width is larger than cell width.'''
        raise NotImplementedError()
    
    @property
    def default_edit_language(self) -> aspose.cells.DefaultEditLanguage:
        '''Gets default edit language.'''
        raise NotImplementedError()
    
    @default_edit_language.setter
    def default_edit_language(self, value : aspose.cells.DefaultEditLanguage) -> None:
        '''Sets default edit language.'''
        raise NotImplementedError()
    
    @property
    def sheet_set(self) -> aspose.cells.rendering.SheetSet:
        '''Gets the sheets to render. Default is all visible sheets in the workbook: :py:attr:`aspose.cells.rendering.SheetSet.visible`.'''
        raise NotImplementedError()
    
    @sheet_set.setter
    def sheet_set(self, value : aspose.cells.rendering.SheetSet) -> None:
        '''Sets the sheets to render. Default is all visible sheets in the workbook: :py:attr:`aspose.cells.rendering.SheetSet.visible`.'''
        raise NotImplementedError()
    
    @property
    def draw_object_event_handler(self) -> aspose.cells.rendering.DrawObjectEventHandler:
        '''Implements this interface to get DrawObject and Bound when rendering.'''
        raise NotImplementedError()
    
    @draw_object_event_handler.setter
    def draw_object_event_handler(self, value : aspose.cells.rendering.DrawObjectEventHandler) -> None:
        '''Implements this interface to get DrawObject and Bound when rendering.'''
        raise NotImplementedError()
    
    @property
    def page_saving_callback(self) -> aspose.cells.rendering.IPageSavingCallback:
        '''Control/Indicate progress of page saving process.'''
        raise NotImplementedError()
    
    @page_saving_callback.setter
    def page_saving_callback(self, value : aspose.cells.rendering.IPageSavingCallback) -> None:
        '''Control/Indicate progress of page saving process.'''
        raise NotImplementedError()
    
    @property
    def emf_render_setting(self) -> aspose.cells.EmfRenderSetting:
        '''Setting for rendering Emf metafile.'''
        raise NotImplementedError()
    
    @emf_render_setting.setter
    def emf_render_setting(self, value : aspose.cells.EmfRenderSetting) -> None:
        '''Setting for rendering Emf metafile.'''
        raise NotImplementedError()
    

class AccessCacheOptions:
    '''Cache options for data access. Can be combined with | operator for multiple options together.'''
    
    NONE : AccessCacheOptions
    '''No cache for any data access.'''
    ALL : AccessCacheOptions
    '''Apply all possible optimizations for all kinds of data access in the workbook.
    All settings and data should not be changed during the optimized access.'''
    POSITION_AND_SIZE : AccessCacheOptions
    '''Apply possible optimization for getting object(such as Shape)\'s position and size.
    Row height and column width settings should not be changed during the optimized access.'''
    CELLS_DATA : AccessCacheOptions
    '''Apply possible optimization for getting cells\' values.
    Cells data(data and settings of Cell, Row) should not be changed during
    the optimized access, no new Cell/Row objects should be created either(such as
    by :py:func:`aspose.cells.Cells.__getitem__`).'''
    CELL_DISPLAY : AccessCacheOptions
    '''Apply possible optimization for getting display-related results of
    cells(:py:attr:`aspose.cells.Cell.display_string_value`, :py:func:`aspose.cells.Cell.get_style`, :py:func:`aspose.cells.Cell.get_display_style`, etc.).
    Cells data and style-related objects(Cell/Row/Column styles, column width, etc.) should not be changed
    during the optimized access.'''
    GET_FORMULA : AccessCacheOptions
    '''Apply possible optimization for getting formulas.
    All data and settings which may affect the formula expression(Worksheet\'s name, Name\'s text,
    table\'s column, etc.) should not be changed during the optimized access.'''
    SET_FORMULA : AccessCacheOptions
    '''Apply possible optimization for setting formulas.
    All data and settings which may affect the formula expression(Worksheet\'s name, Name\'s text,
    table\'s column, etc.) should not be changed during the optimized access.'''
    CALCULATE_FORMULA : AccessCacheOptions
    '''Apply possible optimization for calculating formulas.
    Cells data should not be changed during the optimized access, none new objects(Cell, Row, etc.)
    should be created either(such as by :py:func:`aspose.cells.Cells.__getitem__`).'''
    CONDITIONAL_FORMATTING : AccessCacheOptions
    '''Apply possible optimization for getting formatting result of conditional formattings.
    All data and settings which may affect the result of conditional formattings(settings of
    conditional formattings, dependent cell values, etc.) should not be changed during the optimized access.'''
    VALIDATION : AccessCacheOptions
    '''Apply possible optimization for getting validation result.
    All data and settings which may affect the result of validation(settings of the validation,
    dependent cell values, etc.) should not be changed during the optimized access.'''

class AutoFillType:
    '''Represents the auto fill type.'''
    
    COPY : AutoFillType
    '''Copies the value and format of the source area to the target area'''
    DEFAULT : AutoFillType
    '''Automatically fills the target area with the value and format.'''
    FORMATS : AutoFillType
    '''Copies only the format of the source area to the target area,'''
    SERIES : AutoFillType
    '''Extend the value in the source area to the target area in the form of a series and copy format to the target area.'''
    VALUES : AutoFillType
    '''Copies only the value of the source area to the target area,'''

class AutoFitMergedCellsType:
    '''Represents the type of auto fitting merged cells.'''
    
    NONE : AutoFitMergedCellsType
    '''Ignore merged cells.'''
    FIRST_LINE : AutoFitMergedCellsType
    '''Only expands the height of the first row.'''
    LAST_LINE : AutoFitMergedCellsType
    '''Only expands the height of the last row.'''
    EACH_LINE : AutoFitMergedCellsType
    '''Only expands the height of each row.'''

class AutoFitWrappedTextType:
    '''Represents the type of auto fitting wrapped text.'''
    
    DEFAULT : AutoFitWrappedTextType
    '''Works as MS Excel.'''
    PARAGRAPH : AutoFitWrappedTextType
    '''Auto fit width with the longest paragraph.'''

class BackgroundType:
    '''Enumerates cell background pattern types.'''
    
    DIAGONAL_CROSSHATCH : BackgroundType
    '''Represents diagonal crosshatch pattern.'''
    DIAGONAL_STRIPE : BackgroundType
    '''Represents diagonal stripe pattern.'''
    GRAY6 : BackgroundType
    '''Represents 6.25% gray pattern'''
    GRAY12 : BackgroundType
    '''Represents 12.5% gray pattern'''
    GRAY25 : BackgroundType
    '''Represents 25% gray pattern.'''
    GRAY50 : BackgroundType
    '''Represents 50% gray pattern.'''
    GRAY75 : BackgroundType
    '''Represents 75% gray pattern.'''
    HORIZONTAL_STRIPE : BackgroundType
    '''Represents horizontal stripe pattern.'''
    NONE : BackgroundType
    '''Represents no background.'''
    REVERSE_DIAGONAL_STRIPE : BackgroundType
    '''Represents reverse diagonal stripe pattern.'''
    SOLID : BackgroundType
    '''Represents solid pattern.'''
    THICK_DIAGONAL_CROSSHATCH : BackgroundType
    '''Represents thick diagonal crosshatch pattern.'''
    THIN_DIAGONAL_CROSSHATCH : BackgroundType
    '''Represents thin diagonal crosshatch pattern.'''
    THIN_DIAGONAL_STRIPE : BackgroundType
    '''Represents thin diagonal stripe pattern.'''
    THIN_HORIZONTAL_CROSSHATCH : BackgroundType
    '''Represents thin horizontal crosshatch pattern.'''
    THIN_HORIZONTAL_STRIPE : BackgroundType
    '''Represents thin horizontal stripe pattern.'''
    THIN_REVERSE_DIAGONAL_STRIPE : BackgroundType
    '''Represents thin reverse diagonal stripe pattern.'''
    THIN_VERTICAL_STRIPE : BackgroundType
    '''Represents thin vertical stripe pattern.'''
    VERTICAL_STRIPE : BackgroundType
    '''Represents vertical stripe pattern.'''

class BorderType:
    '''Enumerates the border line and diagonal line types.'''
    
    BOTTOM_BORDER : BorderType
    '''Represents bottom border line.'''
    DIAGONAL_DOWN : BorderType
    '''Represents the diagonal line from top left to right bottom.'''
    DIAGONAL_UP : BorderType
    '''Represents the diagonal line from bottom left to right top.'''
    LEFT_BORDER : BorderType
    '''Represents left border line.'''
    RIGHT_BORDER : BorderType
    '''Represents right border line exists.'''
    TOP_BORDER : BorderType
    '''Represents top border line.'''
    HORIZONTAL : BorderType
    '''Only for dynamic style,such as conditional formatting.'''
    VERTICAL : BorderType
    '''Only for dynamic style,such as conditional formatting.'''

class BuiltinStyleType:
    '''Represents all built-in style types.'''
    
    TWENTY_PERCENT_ACCENT1 : BuiltinStyleType
    TWENTY_PERCENT_ACCENT2 : BuiltinStyleType
    TWENTY_PERCENT_ACCENT3 : BuiltinStyleType
    TWENTY_PERCENT_ACCENT4 : BuiltinStyleType
    TWENTY_PERCENT_ACCENT5 : BuiltinStyleType
    TWENTY_PERCENT_ACCENT6 : BuiltinStyleType
    FORTY_PERCENT_ACCENT1 : BuiltinStyleType
    FORTY_PERCENT_ACCENT2 : BuiltinStyleType
    FORTY_PERCENT_ACCENT3 : BuiltinStyleType
    FORTY_PERCENT_ACCENT4 : BuiltinStyleType
    FORTY_PERCENT_ACCENT5 : BuiltinStyleType
    FORTY_PERCENT_ACCENT6 : BuiltinStyleType
    SIXTY_PERCENT_ACCENT1 : BuiltinStyleType
    SIXTY_PERCENT_ACCENT2 : BuiltinStyleType
    SIXTY_PERCENT_ACCENT3 : BuiltinStyleType
    SIXTY_PERCENT_ACCENT4 : BuiltinStyleType
    SIXTY_PERCENT_ACCENT5 : BuiltinStyleType
    SIXTY_PERCENT_ACCENT6 : BuiltinStyleType
    ACCENT1 : BuiltinStyleType
    ACCENT2 : BuiltinStyleType
    ACCENT3 : BuiltinStyleType
    ACCENT4 : BuiltinStyleType
    ACCENT5 : BuiltinStyleType
    ACCENT6 : BuiltinStyleType
    BAD : BuiltinStyleType
    CALCULATION : BuiltinStyleType
    CHECK_CELL : BuiltinStyleType
    COMMA : BuiltinStyleType
    COMMA1 : BuiltinStyleType
    CURRENCY : BuiltinStyleType
    CURRENCY1 : BuiltinStyleType
    EXPLANATORY_TEXT : BuiltinStyleType
    GOOD : BuiltinStyleType
    HEADER1 : BuiltinStyleType
    HEADER2 : BuiltinStyleType
    HEADER3 : BuiltinStyleType
    HEADER4 : BuiltinStyleType
    HYPERLINK : BuiltinStyleType
    FOLLOWED_HYPERLINK : BuiltinStyleType
    INPUT : BuiltinStyleType
    LINKED_CELL : BuiltinStyleType
    NEUTRAL : BuiltinStyleType
    NORMAL : BuiltinStyleType
    NOTE : BuiltinStyleType
    OUTPUT : BuiltinStyleType
    PERCENT : BuiltinStyleType
    TITLE : BuiltinStyleType
    TOTAL : BuiltinStyleType
    WARNING_TEXT : BuiltinStyleType
    ROW_LEVEL : BuiltinStyleType
    COLUMN_LEVEL : BuiltinStyleType

class CalcModeType:
    '''Represents the mode type of calculating formulas.'''
    
    AUTOMATIC : CalcModeType
    AUTOMATIC_EXCEPT_TABLE : CalcModeType
    MANUAL : CalcModeType

class CalculationPrecisionStrategy:
    '''Enumerates strategies for handling calculation precision.
    Because of the precision issue of IEEE 754 Floating-Point Arithmetic, some "seemingly simple" formulas may not be calculated as the expected result.
    Such as formula "=-0.45+0.43+0.02", when calculating operands by \'+\' operator directly, the result is not zero. For such kind of precision issue,
    some special strategies may give the expected result.'''
    
    NONE : CalculationPrecisionStrategy
    '''No strategy applied on calculation.
    When calculating just use the original double value as operand and return the result directly.
    Most efficient for performance and applicable for most cases.'''
    ROUND : CalculationPrecisionStrategy
    '''Rounds the calculation result according with significant digits.'''
    DECIMAL : CalculationPrecisionStrategy
    '''Uses decimal as operands when possible.
    Most inefficient for performance.'''

class CellBorderType:
    '''Enumerates a cell\'s border type.'''
    
    DASH_DOT : CellBorderType
    '''Represents thin dash-dotted line.'''
    DASH_DOT_DOT : CellBorderType
    '''Represents thin dash-dot-dotted line.'''
    DASHED : CellBorderType
    '''Represents dashed line.'''
    DOTTED : CellBorderType
    '''Represents dotted line.'''
    DOUBLE : CellBorderType
    '''Represents double line.'''
    HAIR : CellBorderType
    '''Represents hair line.'''
    MEDIUM_DASH_DOT : CellBorderType
    '''Represents medium dash-dotted line.'''
    MEDIUM_DASH_DOT_DOT : CellBorderType
    '''Represents medium dash-dot-dotted line.'''
    MEDIUM_DASHED : CellBorderType
    '''Represents medium dashed line.'''
    NONE : CellBorderType
    '''Represents no line.'''
    MEDIUM : CellBorderType
    '''Represents medium line.'''
    SLANTED_DASH_DOT : CellBorderType
    '''Represents slanted medium dash-dotted line.'''
    THICK : CellBorderType
    '''Represents thick line.'''
    THIN : CellBorderType
    '''Represents thin line.'''

class CellValueFormatStrategy:
    '''Specifies how to apply style for the value of the cell.'''
    
    NONE : CellValueFormatStrategy
    '''Not formatted.'''
    CELL_STYLE : CellValueFormatStrategy
    '''Only formatted with the cell\'s original style.'''
    DISPLAY_STYLE : CellValueFormatStrategy
    '''Formatted with the cell\'s displayed style.'''
    DISPLAY_STRING : CellValueFormatStrategy
    '''Gets the displayed string shown in ms excel.
    The main difference from :py:attr:`aspose.cells.CellValueFormatStrategy.DISPLAY_STYLE` is this option also considers the effect of column width.
    If the column width is too small to show the formatted string completely,
    "#" may be shown, just like what ms excel does.'''

class CellValueType:
    '''Specifies a cell value type.'''
    
    IS_UNKNOWN : CellValueType
    '''Cell value type is unknown.'''
    IS_NULL : CellValueType
    '''Blank cell. Corresponding value should be null.'''
    IS_NUMERIC : CellValueType
    '''Cell value is numeric. Corresponding value must be int or double.'''
    IS_DATE_TIME : CellValueType
    '''Cell value is datetime. Corresponding value must be DateTime.'''
    IS_STRING : CellValueType
    '''Cell value is string. Corresponding value must be string.'''
    IS_BOOL : CellValueType
    '''Cell value is boolean. Corresponding value must be bool.'''
    IS_ERROR : CellValueType
    '''Cell contains error value. Corresponding value must be error string.'''

class CellsUnitType:
    
    PIXEL : CellsUnitType
    POINT : CellsUnitType
    INCH : CellsUnitType
    CM : CellsUnitType
    CHARACTER : CellsUnitType

class ColorType:
    '''Represents all color type'''
    
    AUTOMATIC : ColorType
    '''Automatic color.'''
    AUTOMATIC_INDEX : ColorType
    '''It\'s automatic color,but the displayed color depends the setting of the OS System.'''
    RGB : ColorType
    '''The RGB color.'''
    INDEXED_COLOR : ColorType
    '''The color index in the color palette.'''
    THEME : ColorType
    '''The theme color.'''

class ConsolidationFunction:
    '''Represents consolidation function.'''
    
    SUM : ConsolidationFunction
    '''Represents Sum function.'''
    COUNT : ConsolidationFunction
    '''Represents Count function.'''
    AVERAGE : ConsolidationFunction
    '''Represents Average function.'''
    MAX : ConsolidationFunction
    '''Represents Max function.'''
    MIN : ConsolidationFunction
    '''Represents Min function.'''
    PRODUCT : ConsolidationFunction
    '''Represents Product function.'''
    COUNT_NUMS : ConsolidationFunction
    '''Represents Count Nums function.'''
    STD_DEV : ConsolidationFunction
    '''Represents StdDev function.'''
    STD_DEVP : ConsolidationFunction
    '''Represents StdDevp function.'''
    VAR : ConsolidationFunction
    '''Represents Var function.'''
    VARP : ConsolidationFunction
    '''Represents Varp function.'''
    DISTINCT_COUNT : ConsolidationFunction
    '''Represents Distinct Count function.'''

class CopyFormatType:
    '''Represents type of copying format when inserting rows.'''
    
    SAME_AS_ABOVE : CopyFormatType
    '''Formats same as above row.'''
    SAME_AS_BELOW : CopyFormatType
    '''Formats same as below row.'''
    CLEAR : CopyFormatType
    '''Clears formatting.'''

class CountryCode:
    '''Represents Excel country identifiers.'''
    
    DEFAULT : CountryCode
    USA : CountryCode
    '''United States'''
    CANADA : CountryCode
    '''Canada'''
    LATIN_AMERIC : CountryCode
    '''Latin America, except Brazil'''
    RUSSIA : CountryCode
    '''Russia'''
    EGYPT : CountryCode
    '''Egypt'''
    GREECE : CountryCode
    '''Greece'''
    NETHERLANDS : CountryCode
    '''Netherlands'''
    BELGIUM : CountryCode
    '''Belgium'''
    FRANCE : CountryCode
    '''France'''
    SPAIN : CountryCode
    '''Spain'''
    HUNGARY : CountryCode
    '''Hungary'''
    ITALY : CountryCode
    '''Italy'''
    SWITZERLAND : CountryCode
    '''Switzerland'''
    AUSTRIA : CountryCode
    '''Austria'''
    UNITED_KINGDOM : CountryCode
    '''United Kingdom'''
    DENMARK : CountryCode
    '''Denmark'''
    SWEDEN : CountryCode
    '''Sweden'''
    NORWAY : CountryCode
    '''Norway'''
    POLAND : CountryCode
    '''Poland'''
    GERMANY : CountryCode
    '''Germany'''
    MEXICO : CountryCode
    '''Mexico'''
    BRAZIL : CountryCode
    '''Brazil'''
    AUSTRALIA : CountryCode
    '''Australia'''
    NEW_ZEALAND : CountryCode
    '''New Zealand'''
    THAILAND : CountryCode
    '''Thailand'''
    JAPAN : CountryCode
    '''Japan'''
    SOUTH_KOREA : CountryCode
    '''SouthKorea'''
    VIET_NAM : CountryCode
    '''Viet Nam'''
    CHINA : CountryCode
    '''People\'s Republic of China'''
    TURKEY : CountryCode
    '''Turkey'''
    INDIA : CountryCode
    '''India'''
    ALGERIA : CountryCode
    '''Algeria'''
    MOROCCO : CountryCode
    '''Morocco'''
    LIBYA : CountryCode
    '''Libya'''
    PORTUGAL : CountryCode
    '''Portugal'''
    ICELAND : CountryCode
    '''Iceland'''
    FINLAND : CountryCode
    '''Finland'''
    CZECH : CountryCode
    '''Czech Republic'''
    TAIWAN : CountryCode
    '''Taiwan'''
    LEBANON : CountryCode
    '''Lebanon'''
    JORDAN : CountryCode
    '''Jordan'''
    SYRIA : CountryCode
    '''Syria'''
    IRAQ : CountryCode
    '''Iraq'''
    KUWAIT : CountryCode
    '''Kuwait'''
    SAUDI : CountryCode
    '''Saudi Arabia'''
    UNITED_ARAB_EMIRATES : CountryCode
    '''United Arab Emirates'''
    ISRAEL : CountryCode
    '''Israel'''
    QATAR : CountryCode
    '''Qatar'''
    IRAN : CountryCode
    '''Iran'''

class DataBarAxisPosition:
    '''Specifies the axis position for a range of cells with conditional formatting as data bars.'''
    
    AUTOMATIC : DataBarAxisPosition
    '''Display the axis at a variable position based on the ratio of the minimum negative value to the maximum positive value in the range.
    Positive values are displayed in a left-to-right direction.
    Negative values are displayed in a right-to-left direction.
    When all values are positive or all values are negative, no axis is displayed.'''
    MIDPOINT : DataBarAxisPosition
    '''Display the axis at the midpoint of the cell regardless of the set of values in the range.
    Positive values are displayed in a left-to-right direction.
    Negative values are displayed in a right-to-left direction.'''
    NONE : DataBarAxisPosition
    '''No axis is displayed, and both positive and negative values are displayed in the left-to-right direction.'''

class DataBarBorderType:
    '''Specifies the border type of a data bar.'''
    
    NONE : DataBarBorderType
    '''The data bar has no border.'''
    SOLID : DataBarBorderType
    '''The data bar has a solid border.'''

class DataBarFillType:
    '''Specifies how a data bar is filled with color.'''
    
    SOLID : DataBarFillType
    '''The data bar is filled with solid color.'''
    GRADIENT : DataBarFillType
    '''The data bar is filled with a color gradient.'''

class DataBarNegativeColorType:
    '''Specifies whether to use the same border and fill color as positive data bars.'''
    
    COLOR : DataBarNegativeColorType
    '''Use the color specified in the Negative Value and Axis Setting dialog box
    or by using the ColorType and BorderColorType properties of the NegativeBarFormat object.'''
    SAME_AS_POSITIVE : DataBarNegativeColorType
    '''Use the same color as positive data bars.'''

class DateTimeGroupingType:
    '''Specifies how to group dateTime values.'''
    
    DAY : DateTimeGroupingType
    '''Group by day.'''
    HOUR : DateTimeGroupingType
    '''Group by hour.'''
    MINUTE : DateTimeGroupingType
    '''Group by Minute.'''
    MONTH : DateTimeGroupingType
    '''Group by Month.'''
    SECOND : DateTimeGroupingType
    '''Group by Second.'''
    YEAR : DateTimeGroupingType
    '''Group by Year.'''

class DefaultEditLanguage:
    '''Represents the default edit language.'''
    
    AUTO : DefaultEditLanguage
    '''Represents auto detecting edit language according to the text itself.'''
    ENGLISH : DefaultEditLanguage
    '''Represents English language.'''
    CJK : DefaultEditLanguage
    '''Represents Chinese, Japanese, Korean language.'''

class DirectoryType:
    '''Represents the directory  type of the file name.'''
    
    VOLUME : DirectoryType
    '''Represents an MS-DOS drive letter. It is followed by the drive letter.
    Or UNC file names, such as \\server\share\myfile.xls'''
    SAME_VOLUME : DirectoryType
    '''Indicates that the source workbook is on the same drive as the dependent workbook (the drive letter is omitted)'''
    DOWN_DIRECTORY : DirectoryType
    '''Indicates that the source workbook is in a subdirectory of the current directory.'''
    UP_DIRECTORY : DirectoryType
    '''Indicates that the source workbook is in the parent directory of the current directory.'''

class DisplayDrawingObjects:
    '''Represents whether and how to show objects in the workbook.'''
    
    DISPLAY_SHAPES : DisplayDrawingObjects
    '''Show all objects'''
    PLACEHOLDERS : DisplayDrawingObjects
    '''Show placeholders'''
    HIDE : DisplayDrawingObjects
    '''Hide all shapes.'''

class DynamicFilterType:
    '''Dynamic filter type.'''
    
    ABOVE_AVERAGE : DynamicFilterType
    '''Shows values that are above average.'''
    BELOW_AVERAGE : DynamicFilterType
    '''Shows values that are below average.'''
    LAST_MONTH : DynamicFilterType
    '''Shows last month\'s dates.'''
    LAST_QUARTER : DynamicFilterType
    '''Shows last quarter\'s dates.'''
    LAST_WEEK : DynamicFilterType
    '''Shows last week\'s dates.'''
    LAST_YEAR : DynamicFilterType
    '''Shows last year\'s dates.'''
    JANUARY : DynamicFilterType
    '''Shows the dates that are in January, regardless of year.'''
    OCTOBER : DynamicFilterType
    '''Shows the dates that are in October, regardless of year.'''
    NOVEMBER : DynamicFilterType
    '''Shows the dates that are in November, regardless of year.'''
    DECEMBER : DynamicFilterType
    '''Shows the dates that are in December, regardless of year.'''
    FEBRUARY : DynamicFilterType
    '''Shows the dates that are in February, regardless of year.'''
    MARCH : DynamicFilterType
    '''Shows the dates that are in March, regardless of year.'''
    APRIL : DynamicFilterType
    '''Shows the dates that are in April, regardless of year.'''
    MAY : DynamicFilterType
    '''Shows the dates that are in May, regardless of year.'''
    JUNE : DynamicFilterType
    '''Shows the dates that are in June, regardless of year.'''
    JULY : DynamicFilterType
    '''Shows the dates that are in July, regardless of year.'''
    AUGUST : DynamicFilterType
    '''Shows the dates that are in August, regardless of year.'''
    SEPTEMBER : DynamicFilterType
    '''Shows the dates that are in September, regardless of year.'''
    NEXT_MONTH : DynamicFilterType
    '''Shows next month\'s dates.'''
    NEXT_QUARTER : DynamicFilterType
    '''Shows next quarter\'s dates.'''
    NEXT_WEEK : DynamicFilterType
    '''Shows next week\'s dates.'''
    NEXT_YEAR : DynamicFilterType
    '''Shows next year\'s dates.'''
    NONE : DynamicFilterType
    '''None.'''
    QUARTER1 : DynamicFilterType
    '''Shows the dates that are in the 1st quarter, regardless of year.'''
    QUARTER2 : DynamicFilterType
    '''Shows the dates that are in the 2nd quarter, regardless of year.'''
    QUARTER3 : DynamicFilterType
    '''Shows the dates that are in the 3rd quarter, regardless of year.'''
    QUARTER4 : DynamicFilterType
    '''Shows the dates that are in the 4th quarter, regardless of year.'''
    THIS_MONTH : DynamicFilterType
    '''Shows this month\'s dates.'''
    THIS_QUARTER : DynamicFilterType
    '''Shows this quarter\'s dates.'''
    THIS_WEEK : DynamicFilterType
    '''Shows this week\'s dates.'''
    THIS_YEAR : DynamicFilterType
    '''Shows this year\'s dates.'''
    TODAY : DynamicFilterType
    '''Shows today\'s dates.'''
    TOMORROW : DynamicFilterType
    '''Shows tomorrow\'s dates.'''
    YEAR_TO_DATE : DynamicFilterType
    '''Shows the dates between the beginning of the year and today, inclusive.'''
    YESTERDAY : DynamicFilterType
    '''Shows yesterday\'s dates.'''

class EmfRenderSetting:
    '''Setting for rendering Emf metafile.'''
    
    EMF_ONLY : EmfRenderSetting
    '''Only rendering Emf records.'''
    EMF_PLUS_PREFER : EmfRenderSetting
    '''Prefer rendering EmfPlus records.'''

class EncryptionType:
    '''Encryption Type.
    Only used by excel2003.
    We will encrypt 2007/2010 workbook using SHA AES the same as Excel does, and this EncryptionType will be ignored.'''
    
    XOR : EncryptionType
    COMPATIBLE : EncryptionType
    '''Office 97/2000 compatible.'''
    ENHANCED_CRYPTOGRAPHIC_PROVIDER_V1 : EncryptionType
    STRONG_CRYPTOGRAPHIC_PROVIDER : EncryptionType

class ErrorCheckType:
    '''Represents all error check type.'''
    
    EVALUATION_ERROR : ErrorCheckType
    '''Ignore errors when cells contain formulas that result in an error.'''
    CALC : ErrorCheckType
    EMPTY_CELL_REF : ErrorCheckType
    '''Ignore errors when formulas refer to empty cells.'''
    NUMBER_STORED_AS_TEXT : ErrorCheckType
    '''Ignore errors when numbers are formatted as text or are preceded by an apostrophe'''
    TEXT_NUMBER : ErrorCheckType
    '''Ignore errors when numbers are formatted as text or are preceded by an apostrophe'''
    INCONSIST_RANGE : ErrorCheckType
    '''Ignore errors when formulas omit certain cells in a region.'''
    INCONSIST_FORMULA : ErrorCheckType
    '''Ignore errors when a formula in a region of your worksheet differs from other formulas in the same region.'''
    TWO_DIGIT_TEXT_YEAR : ErrorCheckType
    '''Ignore errors when formulas contain text formatted cells with years represented as 2 digits.'''
    TEXT_DATE : ErrorCheckType
    '''Ignore errors when formulas contain text formatted cells with years represented as 2 digits.'''
    UNLOCKED_FORMULA : ErrorCheckType
    '''Ignore errors when unlocked cells contain formulas.'''
    UNPROCTED_FORMULA : ErrorCheckType
    '''Ignore errors when unlocked cells contain formulas.'''
    TABLE_DATA_VALIDATION : ErrorCheckType
    '''Ignore errors when a cell\'s value in a Table does not comply with the Data Validation rules specified.'''
    VALIDATION : ErrorCheckType
    '''Ignore errors when a cell\'s value in a Table does not comply with the Data Validation rules specified.'''
    CALCULATED_COLUMN : ErrorCheckType
    '''Ignore errors when cells contain a value different from a calculated column formula.'''

class ExceptionType:
    '''Represents custom exception type code.'''
    
    CHART : ExceptionType
    '''Invalid chart setting.'''
    DATA_TYPE : ExceptionType
    '''Invalid data type setting.'''
    DATA_VALIDATION : ExceptionType
    '''Invalid data validation setting.'''
    CONDITIONAL_FORMATTING : ExceptionType
    '''Invalid data validation setting.'''
    FILE_FORMAT : ExceptionType
    '''Invalid file format.'''
    FORMULA : ExceptionType
    '''Invalid formula.'''
    INVALID_DATA : ExceptionType
    '''Invalid data.'''
    INVALID_OPERATOR : ExceptionType
    '''Invalid operator.'''
    INCORRECT_PASSWORD : ExceptionType
    '''Incorrect password.'''
    LICENSE : ExceptionType
    '''License related errors.'''
    LIMITATION : ExceptionType
    '''Out of MS Excel limitation error.'''
    PAGE_SETUP : ExceptionType
    '''Invalid page setup setting.'''
    PIVOT_TABLE : ExceptionType
    '''Invalid pivotTable setting.'''
    SHAPE : ExceptionType
    '''Invalid drawing object setting.'''
    SPARKLINE : ExceptionType
    '''Invalid sparkline object setting.'''
    SHEET_NAME : ExceptionType
    '''Invalid worksheet name.'''
    SHEET_TYPE : ExceptionType
    '''Invalid worksheet type.'''
    INTERRUPTED : ExceptionType
    '''The process is interrupted.'''
    IO : ExceptionType
    '''The file is invalid.'''
    PERMISSION : ExceptionType
    '''Permission is required to open this file.'''
    UNSUPPORTED_FEATURE : ExceptionType
    '''Unsupported feature.'''
    UNSUPPORTED_STREAM : ExceptionType
    '''Unsupported stream to be opened.'''
    UNDISCLOSED_INFORMATION : ExceptionType
    '''Files contains some undisclosed information.'''
    FILE_CORRUPTED : ExceptionType
    '''File content is corrupted.'''

class ExternalLinkType:
    '''Represents the type of external link.'''
    
    DDE_LINK : ExternalLinkType
    '''Represents the DDE link.'''
    EXTERNAL : ExternalLinkType
    '''Represents external link.'''

class FileFormatType:
    '''Represents the file format types.'''
    
    CSV : FileFormatType
    '''Comma-Separated Values(CSV) text file.'''
    XLSX : FileFormatType
    '''Office Open XML SpreadsheetML file (macro-free).'''
    XLSM : FileFormatType
    '''Office Open XML SpreadsheetML Macro-Enabled file.'''
    XLTX : FileFormatType
    '''Office Open XML SpreadsheetML Template (macro-free).'''
    XLTM : FileFormatType
    '''Office Open XML SpreadsheetML Macro-Enabled Template.'''
    XLAM : FileFormatType
    '''Office Open XML SpreadsheetML addinMacro-Enabled file.'''
    TSV : FileFormatType
    '''Tab-Separated Values(TSV) text file.'''
    TAB_DELIMITED : FileFormatType
    '''Tab-Separated Values(TSV) text file, same with :py:attr:`aspose.cells.FileFormatType.TSV`.'''
    HTML : FileFormatType
    '''HTML format.'''
    M_HTML : FileFormatType
    '''MHTML (Web archive) format.'''
    ODS : FileFormatType
    '''Open Document Sheet(ODS) file.'''
    EXCEL_97_TO_2003 : FileFormatType
    '''Excel97-2003 spreadsheet file.'''
    SPREADSHEET_ML : FileFormatType
    '''Excel 2003 XML Data file.'''
    XLSB : FileFormatType
    '''The Excel Binary File Format (.xlsb)'''
    UNKNOWN : FileFormatType
    '''Represents unrecognized format, cannot be loaded.'''
    PDF : FileFormatType
    '''PDF (Adobe Portable Document) format.'''
    XPS : FileFormatType
    '''XPS (XML Paper Specification) format.'''
    TIFF : FileFormatType
    '''Represents a TIFF file.'''
    SVG : FileFormatType
    '''SVG file.'''
    EXCEL95 : FileFormatType
    '''Represents an Excel95 xls file.'''
    EXCEL4 : FileFormatType
    '''Represents an Excel4.0 xls file.'''
    EXCEL3 : FileFormatType
    '''Represents an Excel3.0 xls file.'''
    EXCEL2 : FileFormatType
    '''Represents an Excel2.1 xls file.'''
    PPTX : FileFormatType
    '''Represents a pptx file.'''
    DOCX : FileFormatType
    '''Represents a docx file.'''
    DIF : FileFormatType
    '''Data Interchange Format.'''
    DOC : FileFormatType
    '''Represents a doc file.'''
    PPT : FileFormatType
    '''Represents a ppt file.'''
    MAPI_MESSAGE : FileFormatType
    '''Represents a email file.'''
    MS_EQUATION : FileFormatType
    '''Represents the MS Equation 3.0 object.'''
    OLE_10_NATIVE : FileFormatType
    '''Represents the embedded native object.'''
    VSD : FileFormatType
    '''Represents MS Visio VSD binary format.'''
    VSDX : FileFormatType
    '''Represents MS Visio 2013 VSDX file format.'''
    DOCM : FileFormatType
    '''Represents a docm file.'''
    DOTX : FileFormatType
    '''Represents a dotx file.'''
    DOTM : FileFormatType
    '''Represents a dotm file.'''
    PPTM : FileFormatType
    '''Represents a pptm file.'''
    POTX : FileFormatType
    '''Represents a Potx file.'''
    POTM : FileFormatType
    '''Represents a Potm file.'''
    PPSX : FileFormatType
    '''Represents a ppsx file.'''
    PPSM : FileFormatType
    '''Represents a ppsm file.'''
    OOXML : FileFormatType
    '''Represents office open xml file(such as xlsx, docx,pptx, etc).'''
    ODT : FileFormatType
    '''Represents an ODT file.'''
    ODP : FileFormatType
    '''Represents a ODP file.'''
    ODF : FileFormatType
    '''Represents an ODF file.'''
    ODG : FileFormatType
    '''Represents an ODG file.'''
    XML : FileFormatType
    '''Represents a simple xml file.'''
    XLT : FileFormatType
    '''Excel97-2003 spreadsheet template.'''
    OTT : FileFormatType
    '''Represents an OTT file.'''
    BMP : FileFormatType
    '''Represents a BMP file.'''
    OTS : FileFormatType
    '''Represents an ots file.'''
    NUMBERS : FileFormatType
    '''Represents Numbers 9.0 file format by Apple Inc.'''
    NUMBERS09 : FileFormatType
    '''Represents Numbers 9.0 file format by Apple Inc.'''
    MARKDOWN : FileFormatType
    '''Represents markdown document.'''
    GRAPH_CHART : FileFormatType
    '''Represents embedded graph chart.'''
    FODS : FileFormatType
    '''Represents OpenDocument Flat XML Spreadsheet (.fods) file format.'''
    SXC : FileFormatType
    '''Represents StarOffice Calc Spreadsheet (.sxc) file format.'''
    OTP : FileFormatType
    '''Represents a OTP file.'''
    NUMBERS35 : FileFormatType
    '''Represents Numbers 3.5 file format since 2014 by Apple Inc'''
    OLE : FileFormatType
    EMF : FileFormatType
    '''Windows Enhanced Metafile.'''
    WMF : FileFormatType
    '''Windows Metafile.'''
    JPG : FileFormatType
    '''JPEG JFIF.'''
    PNG : FileFormatType
    '''Portable Network Graphics.'''
    GIF : FileFormatType
    '''Gif'''
    WEB_P : FileFormatType
    JSON : FileFormatType
    '''Json'''
    SQL_SCRIPT : FileFormatType
    '''Sql'''
    X_HTML : FileFormatType
    '''Rrepesents XHtml file.'''
    ONE_NOTE : FileFormatType
    '''Rrepesents One Note file.'''
    MICROSOFT_CABINET : FileFormatType
    '''///'''
    RTF : FileFormatType
    EPUB : FileFormatType
    '''EPUB'''
    AZW3 : FileFormatType
    '''AZW3'''
    CHM : FileFormatType
    OXPS : FileFormatType
    '''OXPS (Open XML Paper Specification) format.'''
    G_ZIP : FileFormatType
    '''Rrepesents GZip file.'''

class FilterOperatorType:
    '''Custom Filter operator type.'''
    
    LESS_OR_EQUAL : FilterOperatorType
    '''Represents LessOrEqual operator.'''
    LESS_THAN : FilterOperatorType
    '''Represents LessThan operator.'''
    EQUAL : FilterOperatorType
    '''Represents Equal operator.'''
    GREATER_THAN : FilterOperatorType
    '''Represents GreaterThan operator.'''
    NOT_EQUAL : FilterOperatorType
    '''Represents NotEqual operator.'''
    GREATER_OR_EQUAL : FilterOperatorType
    '''Represents GreaterOrEqual operator.'''
    NONE : FilterOperatorType
    '''Represents no comparison.'''
    BEGINS_WITH : FilterOperatorType
    '''Begins with the text.'''
    ENDS_WITH : FilterOperatorType
    '''Ends with the text.'''
    CONTAINS : FilterOperatorType
    '''Contains the text.'''
    NOT_CONTAINS : FilterOperatorType
    '''Not contains the text.'''

class FilterType:
    '''The filter type.'''
    
    COLOR_FILTER : FilterType
    '''Filter by fill color of the cell.'''
    CUSTOM_FILTERS : FilterType
    '''Custom filter type.'''
    DYNAMIC_FILTER : FilterType
    '''Dynamic filter type.'''
    MULTIPLE_FILTERS : FilterType
    '''When multiple values are chosen to filter by, or when a group of date values are chosen to filter by,
    this element groups those criteria together.'''
    ICON_FILTER : FilterType
    '''Filter by icon of conditional formatting.'''
    TOP10 : FilterType
    '''Top 10 filter.'''
    NONE : FilterType
    '''No filter.'''

class FontSchemeType:
    '''Represents the scheme type of the font.'''
    
    NONE : FontSchemeType
    '''None'''
    MAJOR : FontSchemeType
    '''Major scheme.'''
    MINOR : FontSchemeType
    '''Minor scheme.'''

class FontSourceType:
    '''Specifies the type of a font source.'''
    
    FONT_FILE : FontSourceType
    '''represents single font file.'''
    FONTS_FOLDER : FontSourceType
    '''represents folder with font files.'''
    MEMORY_FONT : FontSourceType
    '''represents single font in memory.'''

class FontUnderlineType:
    '''Enumerates the font underline types.'''
    
    NONE : FontUnderlineType
    '''Represents no underline.'''
    SINGLE : FontUnderlineType
    '''Represents single underline.'''
    DOUBLE : FontUnderlineType
    '''Represents double underline.'''
    ACCOUNTING : FontUnderlineType
    '''Represents single accounting underline.'''
    DOUBLE_ACCOUNTING : FontUnderlineType
    '''Represents double accounting underline.'''
    DASH : FontUnderlineType
    '''Represents Dashed Underline'''
    DASH_DOT_DOT_HEAVY : FontUnderlineType
    '''Represents Thick Dash-Dot-Dot Underline'''
    DASH_DOT_HEAVY : FontUnderlineType
    '''Represents Thick Dash-Dot Underline'''
    DASHED_HEAVY : FontUnderlineType
    '''Represents Thick Dashed Underline'''
    DASH_LONG : FontUnderlineType
    '''Represents Long Dashed Underline'''
    DASH_LONG_HEAVY : FontUnderlineType
    '''Represents Thick Long Dashed Underline'''
    DOT_DASH : FontUnderlineType
    '''Represents Dash-Dot Underline'''
    DOT_DOT_DASH : FontUnderlineType
    '''Represents Dash-Dot-Dot Underline'''
    DOTTED : FontUnderlineType
    '''Represents Dotted Underline'''
    DOTTED_HEAVY : FontUnderlineType
    '''Represents Thick Dotted Underline'''
    HEAVY : FontUnderlineType
    '''Represents Thick Underline'''
    WAVE : FontUnderlineType
    '''Represents Wave Underline'''
    WAVY_DOUBLE : FontUnderlineType
    '''Represents Double Wave Underline'''
    WAVY_HEAVY : FontUnderlineType
    '''Represents Heavy Wave Underline'''
    WORDS : FontUnderlineType
    '''Represents Underline Non-Space Characters Only'''

class FormatConditionType:
    '''Conditional format rule type.'''
    
    CELL_VALUE : FormatConditionType
    '''This conditional formatting rule compares a cell value
    to a formula calculated result, using an operator.'''
    EXPRESSION : FormatConditionType
    '''This conditional formatting rule contains a formula to
    evaluate. When the formula result is true, the cell is
    highlighted.'''
    TOP10 : FormatConditionType
    '''This conditional formatting rule highlights cells whose
    values fall in the top N or bottom N bracket, as
    specified.'''
    UNIQUE_VALUES : FormatConditionType
    '''This conditional formatting rule highlights unique
    values in the range.'''
    DUPLICATE_VALUES : FormatConditionType
    '''This conditional formatting rule highlights duplicated
    values.'''
    CONTAINS_TEXT : FormatConditionType
    '''This conditional formatting rule highlights cells
    containing given text. Equivalent to using the SEARCH()
    sheet function to determine whether the cell contains
    the text.'''
    NOT_CONTAINS_TEXT : FormatConditionType
    '''This conditional formatting rule highlights cells that
    do not contain given text. Equivalent of using SEARCH()
    sheet function to determine whether the cell contains
    the text or not.'''
    BEGINS_WITH : FormatConditionType
    '''This conditional formatting rule highlights cells in the
    range that begin with the given text. Equivalent to
    using the LEFT() sheet function and comparing values.'''
    ENDS_WITH : FormatConditionType
    '''This conditional formatting rule highlights cells ending
    with given text. Equivalent to using the RIGHT() sheet
    function and comparing values.'''
    CONTAINS_BLANKS : FormatConditionType
    '''This conditional formatting rule highlights cells that
    are completely blank. Equivalent of using LEN(TRIM()).
    This means that if the cell contains only characters
    that TRIM() would remove, then it is considered blank.
    An empty cell is also considered blank.'''
    NOT_CONTAINS_BLANKS : FormatConditionType
    '''This conditional formatting rule highlights cells that
    are not blank. Equivalent of using LEN(TRIM()). This
    means that if the cell contains only characters that
    TRIM() would remove, then it is considered blank. An
    empty cell is also considered blank.'''
    CONTAINS_ERRORS : FormatConditionType
    '''This conditional formatting rule highlights cells with
    formula errors. Equivalent to using ISERROR() sheet
    function to determine if there is a formula error.'''
    NOT_CONTAINS_ERRORS : FormatConditionType
    '''This conditional formatting rule highlights cells
    without formula errors. Equivalent to using ISERROR()
    sheet function to determine if there is a formula error.'''
    TIME_PERIOD : FormatConditionType
    '''This conditional formatting rule highlights cells
    containing dates in the specified time period. The
    underlying value of the cell is evaluated, therefore the
    cell does not need to be formatted as a date to be
    evaluated. For example, with a cell containing the
    value 38913 the conditional format shall be applied if
    the rule requires a value of 7/14/2006.'''
    ABOVE_AVERAGE : FormatConditionType
    '''This conditional formatting rule highlights cells that
    are above or below the average for all values in the
    range.'''
    COLOR_SCALE : FormatConditionType
    '''This conditional formatting rule creates a gradated
    color scale on the cells.'''
    DATA_BAR : FormatConditionType
    '''This conditional formatting rule displays a gradated
    data bar in the range of cells.'''
    ICON_SET : FormatConditionType
    '''This conditional formatting rule applies icons to cells
    according to their values.'''

class FormatConditionValueType:
    '''Condition value type.'''
    
    FORMULA : FormatConditionValueType
    '''The minimum/ midpoint / maximum value for the
    gradient is determined by a formula.'''
    MAX : FormatConditionValueType
    '''Indicates that the maximum value in the range shall be
    used as the maximum value for the gradient.'''
    MIN : FormatConditionValueType
    '''Indicates that the minimum value in the range shall be
    used as the minimum value for the gradient.'''
    NUMBER : FormatConditionValueType
    '''Indicates that the minimum / midpoint / maximum
    value for the gradient is specified by a constant
    numeric value.'''
    PERCENT : FormatConditionValueType
    '''Value indicates a percentage between the minimum
    and maximum values in the range shall be used as the
    minimum / midpoint / maximum value for the gradient.'''
    PERCENTILE : FormatConditionValueType
    '''Value indicates a percentile ranking in the range shall
    be used as the minimum / midpoint / maximum value
    for the gradient.'''
    AUTOMATIC_MAX : FormatConditionValueType
    '''Indicates that the Automatic maximum value in the range shall be
    used as the Automatic maximum value for the gradient.'''
    AUTOMATIC_MIN : FormatConditionValueType
    '''Indicates that the Automatic minimum value in the range shall be
    used as the Automatic minimum value for the gradient.'''

class GridlineType:
    '''Enumerates grid line Type.'''
    
    DOTTED : GridlineType
    '''Represents dotted line.'''
    HAIR : GridlineType
    '''Represents hair line.'''

class HeaderFooterCommandType:
    '''Represents the command type of header and footer.'''
    
    TEXT : HeaderFooterCommandType
    '''The text.'''
    CURRENT_PAGE : HeaderFooterCommandType
    '''Current page number'''
    PAGECOUNT : HeaderFooterCommandType
    '''Page count'''
    CURRENT_DATE : HeaderFooterCommandType
    '''Current date'''
    CURRENT_TIME : HeaderFooterCommandType
    '''Current time'''
    SHEET_NAME : HeaderFooterCommandType
    '''Sheet name'''
    FILE_NAME : HeaderFooterCommandType
    '''File name without path'''
    FILE_PATH : HeaderFooterCommandType
    '''File path without file name'''
    PICTURE : HeaderFooterCommandType
    '''Picture'''

class HtmlCrossType:
    '''Represents five types of html cross string.'''
    
    DEFAULT : HtmlCrossType
    '''Display like MS Excel,depends on the next cell.
    If the next cell is null,the string will cross,or it will be truncated'''
    MS_EXPORT : HtmlCrossType
    '''Display the string like MS Excel exporting html.'''
    CROSS : HtmlCrossType
    '''Display HTML cross string, this performance for creating large html files will be more than ten times faster than setting the value to Default or FitToCell.'''
    CROSS_HIDE_RIGHT : HtmlCrossType
    '''Display HTML cross string and hide the right string when the texts overlap.'''
    FIT_TO_CELL : HtmlCrossType
    '''Only displaying the string within the width of cell.'''

class HtmlExportDataOptions:
    '''Represents the options for exporting html data.'''
    
    TABLE : HtmlExportDataOptions
    '''Export file to html which only contains table part.'''
    ALL : HtmlExportDataOptions
    '''Export all the data to html.'''

class HtmlHiddenColDisplayType:
    '''Represents two types of showing the hidden columns in html.'''
    
    HIDDEN : HtmlHiddenColDisplayType
    '''Hidden the hidden columns in html page.'''
    REMOVE : HtmlHiddenColDisplayType
    '''Remove the hidden columns in html page.'''

class HtmlHiddenRowDisplayType:
    '''Represents two types of showing the hidden rows in html.'''
    
    HIDDEN : HtmlHiddenRowDisplayType
    '''Hidden the hidden rows in html page.'''
    REMOVE : HtmlHiddenRowDisplayType
    '''Remove the hidden rows in html page.'''

class HtmlLinkTargetType:
    '''Represents the type of target attribute in HTML ` <>` tag.'''
    
    BLANK : HtmlLinkTargetType
    '''Opens the linked document in a new window or tab'''
    PARENT : HtmlLinkTargetType
    '''Opens the linked document in the parent frame'''
    SELF : HtmlLinkTargetType
    '''Opens the linked document in the same frame as it was clicked (this is default)'''
    TOP : HtmlLinkTargetType
    '''Opens the linked document in the full body of the window'''

class HtmlOfficeMathOutputType:
    
    IMAGE : HtmlOfficeMathOutputType
    MATH_ML : HtmlOfficeMathOutputType

class HyperlinkType:
    '''Represents the type of hyperlink.'''
    
    URL : HyperlinkType
    '''URL'''
    FILE : HyperlinkType
    '''Link to external file.'''
    CELL : HyperlinkType
    '''Link the cell of the workbook.'''
    UNKNOWN : HyperlinkType
    '''Unknown type.'''

class IconSetType:
    '''Icon set type for conditional formatting.
    The threshold values for triggering the different icons within a set are
    configurable, and the icon order is reversible.'''
    
    ARROWS3 : IconSetType
    '''3 arrows icon set.'''
    ARROWS_GRAY3 : IconSetType
    '''3 gray arrows icon set.'''
    FLAGS3 : IconSetType
    '''3 flags icon set.'''
    SIGNS3 : IconSetType
    '''3 signs icon set.'''
    SYMBOLS3 : IconSetType
    '''3 symbols icon set (circled).'''
    SYMBOLS32 : IconSetType
    '''3 Symbols icon set (uncircled).'''
    TRAFFIC_LIGHTS31 : IconSetType
    '''3 traffic lights icon set (unrimmed).'''
    TRAFFIC_LIGHTS32 : IconSetType
    '''3 traffic lights icon set with thick black border.'''
    ARROWS4 : IconSetType
    '''4 arrows icon set.'''
    ARROWS_GRAY4 : IconSetType
    '''4 gray arrows icon set.'''
    RATING4 : IconSetType
    '''4 ratings icon set.'''
    RED_TO_BLACK4 : IconSetType
    '''4 \'red to black\' icon set.'''
    TRAFFIC_LIGHTS4 : IconSetType
    '''4 traffic lights icon set.'''
    ARROWS5 : IconSetType
    '''5 arrows icon set.'''
    ARROWS_GRAY5 : IconSetType
    '''5 gray arrows icon set.'''
    QUARTERS5 : IconSetType
    '''5 quarters icon set.'''
    RATING5 : IconSetType
    '''5 rating icon set.'''
    STARS3 : IconSetType
    '''3 stars set'''
    BOXES5 : IconSetType
    '''5 boxes set'''
    TRIANGLES3 : IconSetType
    '''3 triangles set'''
    NONE : IconSetType
    '''None'''
    CUSTOM_SET : IconSetType
    '''CustomSet.
    This element is read-only.'''
    SMILIES3 : IconSetType
    '''3 smilies.
    Only for .ods.'''
    COLOR_SMILIES3 : IconSetType
    '''3 color smilies.
    Only for .ods.'''

class LoadDataFilterOptions:
    '''Represents the options to filter data when loading workbook from template.'''
    
    NONE : LoadDataFilterOptions
    '''Load nothing for sheet data'''
    ALL : LoadDataFilterOptions
    '''Load all'''
    CELL_BLANK : LoadDataFilterOptions
    '''Load cells whose value is blank'''
    CELL_STRING : LoadDataFilterOptions
    '''Load cells whose value is string'''
    CELL_NUMERIC : LoadDataFilterOptions
    '''Load cells whose value is numeric(including datetime)'''
    CELL_ERROR : LoadDataFilterOptions
    '''Load cells whose value is error'''
    CELL_BOOL : LoadDataFilterOptions
    '''Load cells whose value is bool'''
    CELL_VALUE : LoadDataFilterOptions
    '''Load cells value(all value types) only'''
    FORMULA : LoadDataFilterOptions
    '''Load cell formulas.'''
    CELL_DATA : LoadDataFilterOptions
    '''Load cells data including values, formulas and formatting'''
    CHART : LoadDataFilterOptions
    '''Load charts'''
    SHAPE : LoadDataFilterOptions
    '''Load shapes'''
    DRAWING : LoadDataFilterOptions
    '''Drawing objects(including Chart, Picture, OleObject and all other drawing objects)'''
    MERGED_AREA : LoadDataFilterOptions
    '''Load merged cells'''
    CONDITIONAL_FORMATTING : LoadDataFilterOptions
    '''Load conditional formatting'''
    DATA_VALIDATION : LoadDataFilterOptions
    '''Load data validations'''
    PIVOT_TABLE : LoadDataFilterOptions
    '''Load pivot tables'''
    TABLE : LoadDataFilterOptions
    '''Load tables'''
    HYPERLINKS : LoadDataFilterOptions
    '''Load hyperlinks'''
    SHEET_SETTINGS : LoadDataFilterOptions
    '''Load settings for worksheet'''
    SHEET_DATA : LoadDataFilterOptions
    '''Load all data of worksheet, such as cells data, settings, objects, ...etc.'''
    BOOK_SETTINGS : LoadDataFilterOptions
    '''Load settings for workbook'''
    SETTINGS : LoadDataFilterOptions
    '''Load settings for workbook and worksheet'''
    XML_MAP : LoadDataFilterOptions
    '''Load XmlMap'''
    STRUCTURE : LoadDataFilterOptions
    '''Load structure of the workbook'''
    DOCUMENT_PROPERTIES : LoadDataFilterOptions
    '''Load document properties'''
    DEFINED_NAMES : LoadDataFilterOptions
    '''Load defined Name objects'''
    VBA : LoadDataFilterOptions
    '''Load VBA projects'''
    STYLE : LoadDataFilterOptions
    '''Load styles for cell formatting'''
    PICTURE : LoadDataFilterOptions
    '''Load pictures'''
    OLE_OBJECT : LoadDataFilterOptions
    '''Load OleObjects'''
    REVISION : LoadDataFilterOptions
    '''Load revision logs'''

class LoadFormat:
    '''Represents the load file format.'''
    
    AUTO : LoadFormat
    '''Represents recognizing the format automatically.'''
    CSV : LoadFormat
    '''Comma-Separated Values(CSV) text file.
    NOTE: This member is now obsolete. Instead,
    please use :py:attr:`aspose.cells.LoadFormat.CSV` property.
    This property will be removed 6 months later since April 2021.
    Aspose apologizes for any inconvenience you may have experienced.'''
    XLSX : LoadFormat
    '''Represents Office Open XML spreadsheetML workbook or template, with or without macros.'''
    TSV : LoadFormat
    '''Tab-Separated Values(TSV) text file.
    NOTE: This member is now obsolete. Instead,
    please use :py:attr:`aspose.cells.LoadFormat.TSV` property.
    This property will be removed 6 months later since April 2021.
    Aspose apologizes for any inconvenience you may have experienced.'''
    TAB_DELIMITED : LoadFormat
    '''Represents a tab delimited text file, same with :py:attr:`aspose.cells.LoadFormat.TSV`.'''
    HTML : LoadFormat
    '''Represents a html file.'''
    M_HTML : LoadFormat
    '''Represents a mhtml file.'''
    ODS : LoadFormat
    '''Open Document Sheet(ODS) file.
    NOTE: This member is now obsolete. Instead,
    please use :py:attr:`aspose.cells.LoadFormat.ODS` property.
    This property will be removed 6 months later since April 2021.
    Aspose apologizes for any inconvenience you may have experienced.'''
    EXCEL_97_TO_2003 : LoadFormat
    '''Represents an Excel97-2003 xls file.'''
    SPREADSHEET_ML : LoadFormat
    '''Represents an Excel 2003 xml file.'''
    XLSB : LoadFormat
    '''Represents an xlsb file.'''
    OTS : LoadFormat
    '''Open Document Template Sheet(OTS) file.'''
    NUMBERS : LoadFormat
    '''Represents a numbers file.'''
    FODS : LoadFormat
    '''Represents OpenDocument Flat XML Spreadsheet (.fods) file format.
    NOTE: This member is now obsolete. Instead,
    please use :py:attr:`aspose.cells.LoadFormat.FODS` property.
    This property will be removed 6 months later since April 2021.
    Aspose apologizes for any inconvenience you may have experienced.'''
    SXC : LoadFormat
    '''Represents StarOffice Calc Spreadsheet (.sxc) file format.
    NOTE: This member is now obsolete. Instead,
    please use :py:attr:`aspose.cells.LoadFormat.SXC` property.
    This property will be removed 6 months later since April 2021.
    Aspose apologizes for any inconvenience you may have experienced.'''
    XML : LoadFormat
    '''Represents a simple xml file.'''
    EPUB : LoadFormat
    '''Reprents an EPUB file.'''
    AZW3 : LoadFormat
    '''Represents an AZW3 file.'''
    CHM : LoadFormat
    UNKNOWN : LoadFormat
    '''Represents unrecognized format, cannot be loaded.'''
    IMAGE : LoadFormat
    '''Image'''
    JSON : LoadFormat
    '''Json'''

class LookAtType:
    '''Represents look at type.'''
    
    CONTAINS : LookAtType
    '''Cell value Contains the find object.'''
    START_WITH : LookAtType
    '''Cell value Starts with the find object.'''
    END_WITH : LookAtType
    '''Cell value ends with the find object.'''
    ENTIRE_CONTENT : LookAtType
    '''Cell value is same as the find object.'''

class LookInType:
    '''Represents look in type.'''
    
    FORMULAS : LookInType
    '''If the cell contains a formula, find object from formula, else find it from the value.'''
    VALUES : LookInType
    '''Only find object from the formatted values.'''
    VALUES_EXCLUDE_FORMULA_CELL : LookInType
    '''Only find object from the values of cells which do not contains formula.'''
    COMMENTS : LookInType
    '''Only find object from the comments.'''
    ONLY_FORMULAS : LookInType
    '''Only find object from formulas.'''
    ORIGINAL_VALUES : LookInType
    '''Only find object from the original values.'''

class MemorySetting:
    '''Memory usage options.'''
    
    NORMAL : MemorySetting
    '''Default option for cells model.'''
    MEMORY_PREFERENCE : MemorySetting
    '''Memory performance preferrable.
    With this option the data will be held in compact format so for common scenarios it may give lower memory cost.
    However, this option also may degrade R/W performance a bit in some special cases.'''

class MergeEmptyTdType:
    '''Represents the merge type for empty TD element when exporting file to html.'''
    
    DEFAULT : MergeEmptyTdType
    '''Display like MS Excel.'''
    NONE : MergeEmptyTdType
    '''Empty TD elements will not be merged when exporting file to html.
    This will generate a significantly larger html file.'''
    MERGE_FORCELY : MergeEmptyTdType
    '''Merging empty TD element forcedly when exporting file to html.
    The size of html file will be reduced significantly after setting value to true.
    If you want to import the html file to excel or export perfect grid lines when saving file to html,
    please keep the default value.'''

class MergedCellsShrinkType:
    
    NONE : MergedCellsShrinkType
    SHRINK_TO_FIT : MergedCellsShrinkType
    KEEP_HEADER_ONLY : MergedCellsShrinkType

class NameScopeType:
    '''Represents the scope type of defined names.'''
    
    ALL : NameScopeType
    '''All defined names.'''
    WORKBOOK : NameScopeType
    '''The defined names in the workbook.'''
    WORKSHEET : NameScopeType
    '''The defined names in a worksheet or all worksheets.'''

class NumberCategoryType:
    '''Represents category type of cell\'s number formatting.'''
    
    GENERAL : NumberCategoryType
    '''General'''
    TEXT : NumberCategoryType
    '''Text'''
    NUMBER : NumberCategoryType
    '''Number'''
    DATE : NumberCategoryType
    '''Date or Date and Time'''
    TIME : NumberCategoryType
    '''Time'''
    FRACTION : NumberCategoryType
    '''Fraction'''
    SCIENTIFIC : NumberCategoryType
    '''Scientific'''

class OoxmlCompliance:
    '''Allows to specify which OOXML specification will be used when saving in the Xlsx format.'''
    
    ECMA_376_2006 : OoxmlCompliance
    '''ECMA-376 1st Edition, 2006.'''
    ISO_29500_2008_STRICT : OoxmlCompliance
    '''ISO/IEC 29500:2008 Strict compliance level.'''

class OoxmlCompressionType:
    '''The Ooxml compression type'''
    
    LEVEL1 : OoxmlCompressionType
    '''The fastest but least effective compression.'''
    LEVEL2 : OoxmlCompressionType
    '''A little slower, but better, than level 1.'''
    LEVEL3 : OoxmlCompressionType
    '''A little slower, but better, than level 2.'''
    LEVEL4 : OoxmlCompressionType
    '''A little slower, but better, than level 3.'''
    LEVEL5 : OoxmlCompressionType
    '''A little slower than level 4, but with better compression.'''
    LEVEL6 : OoxmlCompressionType
    '''A good balance of speed and compression efficiency.'''
    LEVEL7 : OoxmlCompressionType
    '''Pretty good compression!'''
    LEVEL8 : OoxmlCompressionType
    '''Better compression than Level7!'''
    LEVEL9 : OoxmlCompressionType
    '''The "best" compression, where best means greatest reduction in size of the input data stream.
    This is also the slowest compression.'''

class OperatorType:
    '''Represents the operator type of conditional format and data validation.'''
    
    BETWEEN : OperatorType
    '''Represents Between operator of conditional format and data validation.'''
    EQUAL : OperatorType
    '''Represents Equal operator of conditional format and data validation.'''
    GREATER_THAN : OperatorType
    '''Represents GreaterThan operator of conditional format and data validation.'''
    GREATER_OR_EQUAL : OperatorType
    '''Represents GreaterOrEqual operator of conditional format and data validation.'''
    LESS_THAN : OperatorType
    '''Represents LessThan operator of conditional format and data validation.'''
    LESS_OR_EQUAL : OperatorType
    '''Represents LessOrEqual operator of conditional format and data validation.'''
    NONE : OperatorType
    '''Represents no comparison.'''
    NOT_BETWEEN : OperatorType
    '''Represents NotBetween operator of conditional format and data validation.'''
    NOT_EQUAL : OperatorType
    '''Represents NotEqual operator of conditional format and data validation.'''

class PageLayoutAlignmentType:
    '''Enumerates page layout alignment types.'''
    
    BOTTOM : PageLayoutAlignmentType
    '''Represents bottom page layout alignment.'''
    CENTER : PageLayoutAlignmentType
    '''Represents center page layout alignment.'''
    LEFT : PageLayoutAlignmentType
    '''Represents left page layout alignment.'''
    RIGHT : PageLayoutAlignmentType
    '''Represents right page layout alignment.'''
    TOP : PageLayoutAlignmentType
    '''Represents top page layout alignment.'''

class PageOrientationType:
    '''Represents print orientation constants.'''
    
    LANDSCAPE : PageOrientationType
    '''Landscape orientation'''
    PORTRAIT : PageOrientationType
    '''Portrait orientation'''

class PaneStateType:
    '''Represents state of the sheet\'s pane.'''
    
    FROZEN : PaneStateType
    '''Panes are frozen, but were not before being frozen.'''
    FROZEN_SPLIT : PaneStateType
    '''Panes are frozen and were split before being frozen.'''
    SPLIT : PaneStateType
    '''Panes are split, but not frozen.'''
    NORMAL : PaneStateType
    '''Panes are not frozen and not split.'''

class PaperSizeType:
    '''Represents paper size constants.'''
    
    PAPER_LETTER : PaperSizeType
    '''Letter (8-1/2 in. x 11 in.)'''
    PAPER_LETTER_SMALL : PaperSizeType
    '''Letter Small (8-1/2 in. x 11 in.)'''
    PAPER_TABLOID : PaperSizeType
    '''Tabloid (11 in. x 17 in.)'''
    PAPER_LEDGER : PaperSizeType
    '''Ledger (17 in. x 11 in.)'''
    PAPER_LEGAL : PaperSizeType
    '''Legal (8-1/2 in. x 14 in.)'''
    PAPER_STATEMENT : PaperSizeType
    '''Statement (5-1/2 in. x 8-1/2 in.)'''
    PAPER_EXECUTIVE : PaperSizeType
    '''Executive (7-1/4 in. x 10-1/2 in.)'''
    PAPER_A3 : PaperSizeType
    '''A3 (297 mm x 420 mm)'''
    PAPER_A4 : PaperSizeType
    '''A4 (210 mm x 297 mm)'''
    PAPER_A4_SMALL : PaperSizeType
    '''A4 Small (210 mm x 297 mm)'''
    PAPER_A5 : PaperSizeType
    '''A5 (148 mm x 210 mm)'''
    PAPER_B4 : PaperSizeType
    '''JIS B4 (257 mm x 364 mm)'''
    PAPER_B5 : PaperSizeType
    '''JIS B5 (182 mm x 257 mm)'''
    PAPER_FOLIO : PaperSizeType
    '''Folio (8-1/2 in. x 13 in.)'''
    PAPER_QUARTO : PaperSizeType
    '''Quarto (215 mm x 275 mm)'''
    PAPER_10X14 : PaperSizeType
    '''10 in. x 14 in.'''
    PAPER_11X17 : PaperSizeType
    '''11 in. x 17 in.'''
    PAPER_NOTE : PaperSizeType
    '''Note (8-1/2 in. x 11 in.)'''
    PAPER_ENVELOPE9 : PaperSizeType
    '''Envelope #9 (3-7/8 in. x 8-7/8 in.)'''
    PAPER_ENVELOPE10 : PaperSizeType
    '''Envelope #10 (4-1/8 in. x 9-1/2 in.)'''
    PAPER_ENVELOPE11 : PaperSizeType
    '''Envelope #11 (4-1/2 in. x 10-3/8 in.)'''
    PAPER_ENVELOPE12 : PaperSizeType
    '''Envelope #12 (4-1/2 in. x 11 in.)'''
    PAPER_ENVELOPE14 : PaperSizeType
    '''Envelope #14 (5 in. x 11-1/2 in.)'''
    PAPER_C_SHEET : PaperSizeType
    '''C size sheet'''
    PAPER_D_SHEET : PaperSizeType
    '''D size sheet'''
    PAPER_E_SHEET : PaperSizeType
    '''E size sheet'''
    PAPER_ENVELOPE_DL : PaperSizeType
    '''Envelope DL (110 mm x 220 mm)'''
    PAPER_ENVELOPE_C5 : PaperSizeType
    '''Envelope C5 (162 mm x 229 mm)'''
    PAPER_ENVELOPE_C3 : PaperSizeType
    '''Envelope C3 (324 mm x 458 mm)'''
    PAPER_ENVELOPE_C4 : PaperSizeType
    '''Envelope C4 (229 mm x 324 mm)'''
    PAPER_ENVELOPE_C6 : PaperSizeType
    '''Envelope C6 (114 mm x 162 mm)'''
    PAPER_ENVELOPE_C65 : PaperSizeType
    '''Envelope C65 (114 mm x 229 mm)'''
    PAPER_ENVELOPE_B4 : PaperSizeType
    '''Envelope B4 (250 mm x 353 mm)'''
    PAPER_ENVELOPE_B5 : PaperSizeType
    '''Envelope B5 (176 mm x 250 mm)'''
    PAPER_ENVELOPE_B6 : PaperSizeType
    '''Envelope B6 (176 mm x 125 mm)'''
    PAPER_ENVELOPE_ITALY : PaperSizeType
    '''Envelope Italy (110 mm x 230 mm)'''
    PAPER_ENVELOPE_MONARCH : PaperSizeType
    '''Envelope Monarch (3-7/8 in. x 7-1/2 in.)'''
    PAPER_ENVELOPE_PERSONAL : PaperSizeType
    '''Envelope (3-5/8 in. x 6-1/2 in.)'''
    PAPER_FANFOLD_US : PaperSizeType
    '''U.S. Standard Fanfold (14-7/8 in. x 11 in.)'''
    PAPER_FANFOLD_STD_GERMAN : PaperSizeType
    '''German Standard Fanfold (8-1/2 in. x 12 in.)'''
    PAPER_FANFOLD_LEGAL_GERMAN : PaperSizeType
    '''German Legal Fanfold (8-1/2 in. x 13 in.)'''
    PAPER_ISOB4 : PaperSizeType
    '''B4 (ISO) 250 x 353 mm'''
    PAPER_JAPANESE_POSTCARD : PaperSizeType
    '''Japanese Postcard (100mm × 148mm)'''
    PAPER_9X11 : PaperSizeType
    '''9? × 11?'''
    PAPER_10X11 : PaperSizeType
    '''10? × 11?'''
    PAPER_15X11 : PaperSizeType
    '''15? × 11?'''
    PAPER_ENVELOPE_INVITE : PaperSizeType
    '''Envelope Invite(220mm × 220mm)'''
    PAPER_LETTER_EXTRA : PaperSizeType
    '''US Letter Extra 9 \275 x 12 in'''
    PAPER_LEGAL_EXTRA : PaperSizeType
    '''US Legal Extra 9 \275 x 15 in'''
    PAPER_TABLOID_EXTRA : PaperSizeType
    '''US Tabloid Extra 11.69 x 18 in'''
    PAPER_A4_EXTRA : PaperSizeType
    '''A4 Extra 9.27 x 12.69 in'''
    PAPER_LETTER_TRANSVERSE : PaperSizeType
    '''Letter Transverse 8 \275 x 11 in'''
    PAPER_A4_TRANSVERSE : PaperSizeType
    '''A4 Transverse 210 x 297 mm'''
    PAPER_LETTER_EXTRA_TRANSVERSE : PaperSizeType
    '''Letter Extra Transverse 9\275 x 12 in'''
    PAPER_SUPER_A : PaperSizeType
    '''SuperA/SuperA/A4 227 x 356 mm'''
    PAPER_SUPER_B : PaperSizeType
    '''SuperB/SuperB/A3 305 x 487 mm'''
    PAPER_LETTER_PLUS : PaperSizeType
    '''US Letter Plus 8.5 x 12.69 in'''
    PAPER_A4_PLUS : PaperSizeType
    '''A4 Plus 210 x 330 mm'''
    PAPER_A5_TRANSVERSE : PaperSizeType
    '''A5 Transverse 148 x 210 mm'''
    PAPER_JISB5_TRANSVERSE : PaperSizeType
    '''B5 (JIS) Transverse 182 x 257 mm'''
    PAPER_A3_EXTRA : PaperSizeType
    '''A3 Extra 322 x 445 mm'''
    PAPER_A5_EXTRA : PaperSizeType
    '''A5 Extra 174 x 235 mm'''
    PAPER_ISOB5_EXTRA : PaperSizeType
    '''B5 (ISO) Extra 201 x 276 mm'''
    PAPER_A2 : PaperSizeType
    '''A2 420 x 594 mm'''
    PAPER_A3_TRANSVERSE : PaperSizeType
    '''A3 Transverse 297 x 420 mm'''
    PAPER_A3_EXTRA_TRANSVERSE : PaperSizeType
    '''A3 Extra Transverse 322 x 445 mm'''
    PAPER_JAPANESE_DOUBLE_POSTCARD : PaperSizeType
    '''Japanese Double Postcard 200 x 148 mm'''
    PAPER_A6 : PaperSizeType
    '''A6 105 x 148 mm'''
    PAPER_JAPANESE_ENVELOPE_KAKU2 : PaperSizeType
    '''Japanese Envelope Kaku #2'''
    PAPER_JAPANESE_ENVELOPE_KAKU3 : PaperSizeType
    '''Japanese Envelope Kaku #3'''
    PAPER_JAPANESE_ENVELOPE_CHOU3 : PaperSizeType
    '''Japanese Envelope Chou #3'''
    PAPER_JAPANESE_ENVELOPE_CHOU4 : PaperSizeType
    '''Japanese Envelope Chou #4'''
    PAPER_LETTER_ROTATED : PaperSizeType
    '''11in × 8.5in'''
    PAPER_A3_ROTATED : PaperSizeType
    '''420mm × 297mm'''
    PAPER_A4_ROTATED : PaperSizeType
    '''297mm × 210mm'''
    PAPER_A5_ROTATED : PaperSizeType
    '''210mm × 148mm'''
    PAPER_JISB4_ROTATED : PaperSizeType
    '''B4 (JIS) Rotated 364 x 257 mm'''
    PAPER_JISB5_ROTATED : PaperSizeType
    '''B5 (JIS) Rotated 257 x 182 mm'''
    PAPER_JAPANESE_POSTCARD_ROTATED : PaperSizeType
    '''Japanese Postcard Rotated 148 x 100 mm'''
    PAPER_JAPANESE_DOUBLE_POSTCARD_ROTATED : PaperSizeType
    '''Double Japanese Postcard Rotated 148 x 200 mm'''
    PAPER_A6_ROTATED : PaperSizeType
    '''A6 Rotated 148 x 105 mm'''
    PAPER_JAPANESE_ENVELOPE_KAKU_2_ROTATED : PaperSizeType
    '''Japanese Envelope Kaku #2 Rotated'''
    PAPER_JAPANESE_ENVELOPE_KAKU_3_ROTATED : PaperSizeType
    '''Japanese Envelope Kaku #3 Rotated'''
    PAPER_JAPANESE_ENVELOPE_CHOU_3_ROTATED : PaperSizeType
    '''Japanese Envelope Chou #3 Rotated'''
    PAPER_JAPANESE_ENVELOPE_CHOU_4_ROTATED : PaperSizeType
    '''Japanese Envelope Chou #4 Rotated'''
    PAPER_JISB6 : PaperSizeType
    '''B6 (JIS) 128 x 182 mm'''
    PAPER_JISB6_ROTATED : PaperSizeType
    '''B6 (JIS) Rotated 182 x 128 mm'''
    PAPER_12X11 : PaperSizeType
    '''12 x 11 in'''
    PAPER_JAPANESE_ENVELOPE_YOU4 : PaperSizeType
    '''Japanese Envelope You #4'''
    PAPER_JAPANESE_ENVELOPE_YOU_4_ROTATED : PaperSizeType
    '''Japanese Envelope You #4 Rotated'''
    PAPER_PRC16K : PaperSizeType
    '''PRC 16K 146 x 215 mm'''
    PAPER_PRC32K : PaperSizeType
    '''PRC 32K 97 x 151 mm'''
    PAPER_PRC_BIG_32K : PaperSizeType
    '''PRC 32K(Big) 97 x 151 mm'''
    PAPER_PRC_ENVELOPE1 : PaperSizeType
    '''PRC Envelope #1 102 x 165 mm'''
    PAPER_PRC_ENVELOPE2 : PaperSizeType
    '''PRC Envelope #2 102 x 176 mm'''
    PAPER_PRC_ENVELOPE3 : PaperSizeType
    '''PRC Envelope #3 125 x 176 mm'''
    PAPER_PRC_ENVELOPE4 : PaperSizeType
    '''PRC Envelope #4 110 x 208 mm'''
    PAPER_PRC_ENVELOPE5 : PaperSizeType
    '''PRC Envelope #5 110 x 220 mm'''
    PAPER_PRC_ENVELOPE6 : PaperSizeType
    '''PRC Envelope #6 120 x 230 mm'''
    PAPER_PRC_ENVELOPE7 : PaperSizeType
    '''PRC Envelope #7 160 x 230 mm'''
    PAPER_PRC_ENVELOPE8 : PaperSizeType
    '''PRC Envelope #8 120 x 309 mm'''
    PAPER_PRC_ENVELOPE9 : PaperSizeType
    '''PRC Envelope #9 229 x 324 mm'''
    PAPER_PRC_ENVELOPE10 : PaperSizeType
    '''PRC Envelope #10 324 x 458 mm'''
    PAPER_PRC16K_ROTATED : PaperSizeType
    '''PRC 16K Rotated'''
    PAPER_PRC32K_ROTATED : PaperSizeType
    '''PRC 32K Rotated'''
    PAPER_PRC_BIG_32K_ROTATED : PaperSizeType
    '''PRC 32K(Big) Rotated'''
    PAPER_PRC_ENVELOPE_1_ROTATED : PaperSizeType
    '''PRC Envelope #1 Rotated 165 x 102 mm'''
    PAPER_PRC_ENVELOPE_2_ROTATED : PaperSizeType
    '''PRC Envelope #2 Rotated 176 x 102 mm'''
    PAPER_PRC_ENVELOPE_3_ROTATED : PaperSizeType
    '''PRC Envelope #3 Rotated 176 x 125 mm'''
    PAPER_PRC_ENVELOPE_4_ROTATED : PaperSizeType
    '''PRC Envelope #4 Rotated 208 x 110 mm'''
    PAPER_PRC_ENVELOPE_5_ROTATED : PaperSizeType
    '''PRC Envelope #5 Rotated 220 x 110 mm'''
    PAPER_PRC_ENVELOPE_6_ROTATED : PaperSizeType
    '''PRC Envelope #6 Rotated 230 x 120 mm'''
    PAPER_PRC_ENVELOPE_7_ROTATED : PaperSizeType
    '''PRC Envelope #7 Rotated 230 x 160 mm'''
    PAPER_PRC_ENVELOPE_8_ROTATED : PaperSizeType
    '''PRC Envelope #8 Rotated 309 x 120 mm'''
    PAPER_PRC_ENVELOPE_9_ROTATED : PaperSizeType
    '''PRC Envelope #9 Rotated 324 x 229 mm'''
    PAPER_PRC_ENVELOPE_10_ROTATED : PaperSizeType
    '''PRC Envelope #10 Rotated 458 x 324 mm'''
    PAPER_B3 : PaperSizeType
    '''usual B3(13.9 x 19.7 in)'''
    PAPER_BUSINESS_CARD : PaperSizeType
    '''Business Card(90mm x 55 mm)'''
    PAPER_THERMAL : PaperSizeType
    '''Thermal(3 x 11 in)'''
    CUSTOM : PaperSizeType
    '''Represents the custom paper size.'''

class ParameterType:
    '''Represents all parameters\' type or return value type of function.'''
    
    REFERENCE : ParameterType
    VALUE : ParameterType
    ARRAY : ParameterType

class PasteOperationType:
    '''Represents operation type when pasting range.'''
    
    NONE : PasteOperationType
    '''No operation.'''
    ADD : PasteOperationType
    '''Add'''
    SUBTRACT : PasteOperationType
    '''Subtract'''
    MULTIPLY : PasteOperationType
    '''Multiply'''
    DIVIDE : PasteOperationType
    '''Divide'''

class PasteType:
    '''Represents the paste special type.'''
    
    ALL : PasteType
    '''Copies all data of the range.'''
    DEFAULT : PasteType
    '''It works as "All" behavior of MS Excel.'''
    ALL_EXCEPT_BORDERS : PasteType
    '''Copies all data of the range without the range.'''
    DEFAULT_EXCEPT_BORDERS : PasteType
    '''It works as "All except borders" behavior of MS Excel.'''
    COLUMN_WIDTHS : PasteType
    '''Only copies the widths of the range.'''
    ROW_HEIGHTS : PasteType
    '''Only copies the heights of the range.'''
    COMMENTS : PasteType
    FORMATS : PasteType
    FORMULAS : PasteType
    FORMULAS_AND_NUMBER_FORMATS : PasteType
    VALIDATION : PasteType
    VALUES : PasteType
    VALUES_AND_FORMATS : PasteType
    VALUES_AND_NUMBER_FORMATS : PasteType

class PrintCommentsType:
    '''Represents the way comments are printed with the sheet.'''
    
    PRINT_IN_PLACE : PrintCommentsType
    '''Represents to print comments as displayed on sheet.'''
    PRINT_NO_COMMENTS : PrintCommentsType
    '''Represents not to print comments.'''
    PRINT_SHEET_END : PrintCommentsType
    '''Represents to print comments at end of sheet.'''
    PRINT_WITH_THREADED_COMMENTS : PrintCommentsType

class PrintErrorsType:
    '''Represents print errors constants.'''
    
    PRINT_ERRORS_BLANK : PrintErrorsType
    '''Represents not to print errors.'''
    PRINT_ERRORS_DASH : PrintErrorsType
    '''Represents to print errors as "--".'''
    PRINT_ERRORS_DISPLAYED : PrintErrorsType
    '''Represents to print errors as displayed.'''
    PRINT_ERRORS_NA : PrintErrorsType
    '''Represents to print errors as "#N/A".'''

class PrintOrderType:
    '''Represent print order constants.'''
    
    DOWN_THEN_OVER : PrintOrderType
    '''Down, then over'''
    OVER_THEN_DOWN : PrintOrderType
    '''Over, then down'''

class PrintSizeType:
    '''Represents the printed chart size.'''
    
    FULL : PrintSizeType
    '''Use full page.'''
    FIT : PrintSizeType
    '''Scale to fit page.'''
    CUSTOM : PrintSizeType
    '''Custom.'''

class PrintingPageType:
    '''Indicates which pages will not be printed.'''
    
    DEFAULT : PrintingPageType
    '''Prints all pages.'''
    IGNORE_BLANK : PrintingPageType
    '''Don\'t print the pages which the cells are blank.'''
    IGNORE_STYLE : PrintingPageType
    '''Don\'t print the pages which cells only contain styles.'''

class ProtectionType:
    '''Represents workbook/worksheet protection type.'''
    
    ALL : ProtectionType
    '''Represents to protect all.'''
    CONTENTS : ProtectionType
    '''Represents to protect contents, used in Worksheet protection.'''
    OBJECTS : ProtectionType
    '''Represents to protect objects, used in Worksheet protection.'''
    SCENARIOS : ProtectionType
    '''Represents to protect scenarios, used in Worksheet protection.'''
    STRUCTURE : ProtectionType
    '''Represents to protect structure, used in Workbook protection.'''
    WINDOWS : ProtectionType
    '''Represents to protect window, used in Workbook protection.'''
    NONE : ProtectionType
    '''Represents no protection. Only for Reading property.'''

class RenameStrategy:
    '''Strategy option for duplicate names of columns.'''
    
    EXCEPTION : RenameStrategy
    '''Throws exception.'''
    DIGIT : RenameStrategy
    '''Named with digit. Duplicated names will become ...1, ...2, etc.'''
    LETTER : RenameStrategy
    '''Named with letter.. Duplicated names will become ...A, ...B, etc.'''

class ResourceLoadingType:
    '''Represents how to loading the linked resource.'''
    
    DEFAULT : ResourceLoadingType
    '''Loads this resource as usual.'''
    SKIP : ResourceLoadingType
    '''Skips loading of this resource.'''
    USER_PROVIDED : ResourceLoadingType
    '''Use stream provided by user'''

class SaveFormat:
    '''Represents the format in which the workbook is saved.'''
    
    CSV : SaveFormat
    '''Comma-Separated Values(CSV) text file.
    NOTE: This member is now obsolete. Instead,
    please use :py:attr:`aspose.cells.SaveFormat.CSV` property.
    This property will be removed 6 months later since April 2021.
    Aspose apologizes for any inconvenience you may have experienced.'''
    XLSX : SaveFormat
    '''Represents an xlsx file.'''
    XLSM : SaveFormat
    '''Represents an xlsm file which enable macros.'''
    XLTX : SaveFormat
    '''Represents an xltx file.'''
    XLTM : SaveFormat
    '''Represents an xltm file which enable macros.'''
    XLAM : SaveFormat
    '''Represents an xltm file which enable addin macros.'''
    TSV : SaveFormat
    '''Tab-Separated Values(TSV) text file.
    NOTE: This member is now obsolete. Instead,
    please use :py:attr:`aspose.cells.SaveFormat.TSV` property.
    This property will be removed 6 months later since April 2021.
    Aspose apologizes for any inconvenience you may have experienced.'''
    TAB_DELIMITED : SaveFormat
    '''Represents a tab delimited text file, same with :py:attr:`aspose.cells.SaveFormat.TSV`.'''
    HTML : SaveFormat
    '''Represents a html file.'''
    M_HTML : SaveFormat
    '''Represents a mhtml file.'''
    ODS : SaveFormat
    '''Open Document Sheet(ODS) file.
    NOTE: This member is now obsolete. Instead,
    please use :py:attr:`aspose.cells.SaveFormat.ODS` property.
    This property will be removed 6 months later since April 2021.
    Aspose apologizes for any inconvenience you may have experienced.'''
    EXCEL_97_TO_2003 : SaveFormat
    '''Represents an Excel97-2003 xls file.'''
    SPREADSHEET_ML : SaveFormat
    '''Represents an Excel 2003 xml file.'''
    XLSB : SaveFormat
    '''Represents an xlsb file.'''
    AUTO : SaveFormat
    '''If saving the file to the disk,the file format accords to the extension of the file name.
    If saving the file to the stream, the file format is xlsx.'''
    UNKNOWN : SaveFormat
    '''Represents unrecognized format, cannot be saved.'''
    PDF : SaveFormat
    '''Represents a Pdf file.'''
    XPS : SaveFormat
    '''XPS (XML Paper Specification) format.
    NOTE: This member is now obsolete. Instead,
    please use :py:attr:`aspose.cells.SaveFormat.XPS` property.
    This property will be removed 6 months later since April 2021.
    Aspose apologizes for any inconvenience you may have experienced.'''
    TIFF : SaveFormat
    '''Represents a TIFF file.
    NOTE: This member is now obsolete. Instead,
    please use :py:attr:`aspose.cells.SaveFormat.TIFF` property.
    This property will be removed 6 months later since April 2021.
    Aspose apologizes for any inconvenience you may have experienced.'''
    SVG : SaveFormat
    '''SVG file.
    NOTE: This member is now obsolete. Instead,
    please use :py:attr:`aspose.cells.SaveFormat.SVG` property.
    This property will be removed 6 months later since April 2021.
    Aspose apologizes for any inconvenience you may have experienced.'''
    DIF : SaveFormat
    '''Data Interchange Format.'''
    OTS : SaveFormat
    '''Open Document Template Sheet(OTS) file.'''
    XLT : SaveFormat
    '''Excel 97-2003 template file.'''
    XML : SaveFormat
    '''Represents a simple xml file.'''
    NUMBERS : SaveFormat
    '''Represents a numbers file.'''
    MARKDOWN : SaveFormat
    '''Represents markdown document.'''
    FODS : SaveFormat
    '''Represents OpenDocument Flat XML Spreadsheet (.fods) file format.
    NOTE: This member is now obsolete. Instead,
    please use :py:attr:`aspose.cells.SaveFormat.FODS` property.
    This property will be removed 6 months later since April 2021.
    Aspose apologizes for any inconvenience you may have experienced.'''
    SXC : SaveFormat
    '''Represents StarOffice Calc Spreadsheet (.sxc) file format.
    NOTE: This member is now obsolete. Instead,
    please use :py:attr:`aspose.cells.SaveFormat.SXC` property.
    This property will be removed 6 months later since April 2021.
    Aspose apologizes for any inconvenience you may have experienced.'''
    PPTX : SaveFormat
    '''Represents .pptx file.'''
    DOCX : SaveFormat
    '''Represents .docx file.'''
    EMF : SaveFormat
    '''Windows Enhanced Metafile.'''
    JPG : SaveFormat
    '''JPEG JFIF.'''
    PNG : SaveFormat
    '''Portable Network Graphics.'''
    BMP : SaveFormat
    '''Windows Bitmap'''
    GIF : SaveFormat
    '''Gif'''
    JSON : SaveFormat
    '''Json'''
    SQL_SCRIPT : SaveFormat
    '''Sql'''
    X_HTML : SaveFormat
    '''Rrepesents XHtml file.'''
    EPUB : SaveFormat
    '''Represents Epub file.'''
    AZW3 : SaveFormat

class SheetType:
    '''Specifies the worksheet type.'''
    
    VB : SheetType
    '''Visual Basic module'''
    WORKSHEET : SheetType
    CHART : SheetType
    '''Chart'''
    BIFF4_MACRO : SheetType
    '''BIFF4 Macro sheet'''
    INTERNATIONAL_MACRO : SheetType
    '''International Macro sheet'''
    OTHER : SheetType
    DIALOG : SheetType
    '''Dialog worksheet'''

class ShiftType:
    '''Represent the shift options when deleting a range of cells.'''
    
    DOWN : ShiftType
    '''Shift cells down.'''
    LEFT : ShiftType
    '''Shift cells left.'''
    NONE : ShiftType
    '''Do not shift cells.'''
    RIGHT : ShiftType
    '''Shift cells right.'''
    UP : ShiftType
    '''Shift cells up.'''

class SortOnType:
    '''Sorted value type.'''
    
    VALUE : SortOnType
    '''Sorts by cells\' value.'''
    CELL_COLOR : SortOnType
    '''Sorts by cells\' color.'''
    FONT_COLOR : SortOnType
    '''Sorts by cells\' font color.'''
    ICON : SortOnType
    '''Sorts by conditional icon.'''

class SortOrder:
    '''Represents sort order for the data range.'''
    
    ASCENDING : SortOrder
    DESCENDING : SortOrder
    NATURAL : SortOrder

class StyleModifyFlag:
    '''The style modified flags.'''
    
    LEFT_BORDER : StyleModifyFlag
    '''Indicates whether left border has been modified for the style.'''
    RIGHT_BORDER : StyleModifyFlag
    '''Indicates whether right border has been modified for the style.'''
    TOP_BORDER : StyleModifyFlag
    '''Indicates whether top border has been modified for the style.'''
    BOTTOM_BORDER : StyleModifyFlag
    '''Indicates whether bottom border has been modified for the style.'''
    DIAGONAL_DOWN_BORDER : StyleModifyFlag
    '''Indicates whether diagonal-down border has been modified for the style.'''
    DIAGONAL_UP_BORDER : StyleModifyFlag
    '''Indicates whether diagonal-up border has been modified for the style.'''
    DIAGONAL : StyleModifyFlag
    '''Indicates whether one or more diagonal borders(:py:attr:`aspose.cells.StyleModifyFlag.DIAGONAL_DOWN_BORDER`,
    :py:attr:`aspose.cells.StyleModifyFlag.DIAGONAL_UP_BORDER`) have been modified for the style.'''
    HORIZONTAL_BORDER : StyleModifyFlag
    '''Indicates whether horizontal border has been modified for the style.
    Only for dynamic style, such as conditional formatting.'''
    VERTICAL_BORDER : StyleModifyFlag
    '''Indicates whether vertical border has been modified for the style.
    Only for dynamic style, such as conditional formatting.'''
    BORDERS : StyleModifyFlag
    '''Indicates whether one or more borders(:py:attr:`aspose.cells.StyleModifyFlag.LEFT_BORDER`,
    :py:attr:`aspose.cells.StyleModifyFlag.RIGHT_BORDER`, :py:attr:`aspose.cells.StyleModifyFlag.TOP_BORDER`, :py:attr:`aspose.cells.StyleModifyFlag.BOTTOM_BORDER`,
    :py:attr:`aspose.cells.StyleModifyFlag.DIAGONAL`, :py:attr:`aspose.cells.StyleModifyFlag.HORIZONTAL_BORDER`, :py:attr:`aspose.cells.StyleModifyFlag.VERTICAL_BORDER`)
    have been modified for the style.'''
    NUMBER_FORMAT : StyleModifyFlag
    '''Indicates whether numberformat has been modified.'''
    HORIZONTAL_ALIGNMENT : StyleModifyFlag
    '''Indicates whether horizontal alignment has been modified.'''
    VERTICAL_ALIGNMENT : StyleModifyFlag
    '''Indicates whether vertical alignment has been modified.'''
    INDENT : StyleModifyFlag
    '''Indicates whether indent property has been modified.'''
    ROTATION : StyleModifyFlag
    '''Indicates whether rotation property has been modified.'''
    WRAP_TEXT : StyleModifyFlag
    '''Indicates whether wrap text property has been modified.'''
    SHRINK_TO_FIT : Sty