export declare const POLICY_DESCRIPTION_ANNOTATION = "@cdkDescription";
export declare function checkParseSchema(schemaStr: string): void;
export declare function checkParsePolicy(policyStatement: string): void;
/**
 * Extracts the Description of the Policy searching for the @see POLICY_DESCRIPTION_ANNOTATION annotation on top of policy contents (before effect)
 * @param policyStatement The policy statement in string format
 * @returns Returns the description if found or null
 */
export declare function getPolicyDescription(policyStatement: string): string | null;
export declare function checkParseTemplate(templateStatement: string): void;
export declare function validatePolicy(policyStatement: string, schemaStr: string): void;
export declare function cleanUpApiNameForNamespace(apiName: string): string;
export declare function buildSchema(namespace: string, actionNames: string[], principalGroupType?: string): Record<string, Record<string, any>>;
