# Generated by Django 5.0.1 on 2024-01-29 16:48

import datetime
import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('cloud', '0001_initial'),
        ('geolocation', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Club',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='Contact',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('Answered', 'Answered'), ('No Answered', 'No Answered')], default='No Answered', max_length=20, verbose_name='Status')),
                ('name', models.CharField(max_length=150, null=True)),
                ('host', models.CharField(default='no host catched', max_length=150)),
                ('email', models.EmailField(max_length=254, verbose_name='Email')),
                ('subject', models.CharField(max_length=150, verbose_name='Subject')),
                ('message', models.TextField(verbose_name='Message')),
            ],
        ),
        migrations.CreateModel(
            name='DataEmail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.EmailField(max_length=254, unique=True)),
                ('date', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='FacebookPageCommentsReply',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('from_user', models.CharField(max_length=250)),
                ('comment', models.TextField()),
                ('created', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='IGPost',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('container_id', models.CharField(blank=True, default='noid', max_length=500)),
                ('feed_id', models.CharField(blank=True, default='noid', max_length=500)),
                ('token', models.CharField(blank=True, default='empty', max_length=500)),
                ('publish_status', models.CharField(blank=True, default='noid', max_length=500)),
                ('status', models.CharField(blank=True, choices=[('publish', 'Publish'), ('draft', 'Draft')], default='draft', max_length=80)),
                ('mediatype', models.CharField(blank=True, choices=[('POST', 'POST'), ('REELS', 'Reels'), ('CAROUSEL', 'Carousel'), ('STORIES', 'Stories')], default='Post', max_length=80)),
                ('caption', models.TextField(blank=True)),
                ('audioname', models.CharField(blank=True, default='Original Audio', max_length=500)),
                ('schedule', models.DateTimeField(blank=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='JobApplication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=50, verbose_name='First Name')),
                ('last_name', models.CharField(max_length=50, verbose_name='Last Name')),
                ('email', models.EmailField(max_length=254, verbose_name='Email Address')),
                ('phone', models.CharField(max_length=15, verbose_name='Phone Number')),
                ('address', models.CharField(max_length=300, verbose_name='Address')),
                ('cv', models.FileField(blank=True, null=True, upload_to='cv/', verbose_name='Upload CV')),
                ('position_applied', models.CharField(max_length=100, verbose_name='Position Applied For')),
                ('salary_expectations', models.DecimalField(decimal_places=2, max_digits=10, verbose_name='Salary Expectations')),
                ('availability', models.CharField(choices=[('', 'Choose One'), ('Part-Time', 'Part-Time'), ('Full-Time', 'Full-Time'), ('Internship', 'Internship'), ('Freelance', 'Freelance')], default='Choose One', max_length=100)),
                ('comments', models.TextField(blank=True, null=True, verbose_name='Additional Comments')),
                ('created', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'verbose_name': 'Job Application',
                'verbose_name_plural': 'Job Applications',
            },
        ),
        migrations.CreateModel(
            name='PaypalClient',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255)),
                ('file', models.FileField(upload_to='resources/')),
                ('uploaded_at', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='SiteControl',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ip', models.CharField(max_length=60)),
                ('lon', models.CharField(max_length=100)),
                ('lat', models.CharField(max_length=100)),
                ('dateview', models.DateTimeField(auto_now_add=True)),
                ('pishing', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='TemplateSections',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('section', models.CharField(max_length=80, verbose_name='Section')),
                ('lang', models.CharField(default='en', max_length=80)),
                ('created', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='Addresses',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(default='Not Selected', max_length=50)),
                ('address', models.CharField(help_text='Required', max_length=255, verbose_name='Address Line')),
                ('phone', models.CharField(max_length=14, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('city_address', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='geolocation.city')),
                ('country_address', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='geolocation.country', verbose_name='Country')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='APIStelaClient',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('client_key', models.CharField(max_length=255, unique=True)),
                ('secret_key', models.CharField(max_length=255)),
                ('is_subscriber', models.BooleanField(default=False)),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='api_client', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='BillFile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255)),
                ('pdf', models.FileField(upload_to='facturas/')),
                ('upload_date', models.DateTimeField(default=django.utils.timezone.now)),
                ('comments', models.TextField(blank=True)),
                ('client', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='BillingRecipt',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_generated', models.BooleanField(default=False)),
                ('is_budget', models.BooleanField(default=False)),
                ('status', models.CharField(default='Pending', max_length=60)),
                ('payment_option', models.CharField(blank=True, max_length=200, null=True)),
                ('option', models.CharField(choices=[('budget_development', 'Budget Development'), ('Monthly charge', 'Monthly charge'), ('Billing receipt', 'Billing receipt'), ('budget_marketing', 'Budget Marketing'), ('Others', 'Others'), ('budget_design', 'Budget Design')], max_length=60, null=True, verbose_name='Case')),
                ('report', models.TextField(null=True, verbose_name='Report')),
                ('amount', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('discount', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('tax', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='owner', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Booking',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=250, verbose_name='name')),
                ('address', models.CharField(max_length=250, verbose_name='billing_address')),
                ('email', models.EmailField(max_length=254, verbose_name='email')),
                ('type', models.CharField(max_length=250)),
                ('date', models.DateField()),
                ('dateConfirm', models.BooleanField(default=False)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='bookings', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='BookingServices',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('service', models.CharField(max_length=250)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='booking_services', to='stela_control.booking')),
            ],
        ),
        migrations.CreateModel(
            name='BudgetControl',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('control_id', models.CharField(max_length=20)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('recipt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='budget_control', to='stela_control.billingrecipt')),
            ],
        ),
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('woman', 'woman'), ('male', 'male'), ('curvy', 'curvy'), ('kids', 'kids'), ('furniture', 'furniture'), ('Select Type', 'Select Type'), ('Consulting', 'Consulting')], default='Select Type', max_length=30, verbose_name='Type')),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('slug', models.SlugField(help_text='Required', max_length=255)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('lang', models.CharField(default='en', max_length=80)),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Company',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200, verbose_name='Startup Name')),
                ('business', models.CharField(blank=True, choices=[('Beauty and Personal Care Services', 'Beauty and Personal Care Services'), ('IT Development Services', 'IT Development Services'), ('E-commerce', 'E-commerce'), ('Health and Wellness', 'Health and Wellness'), ('Education and Training', 'Education and Training'), ('Marketing and Advertising Services', 'Marketing and Advertising Services'), ('Restaurants and Food Services', 'Restaurants and Food Services'), ('Logistics and Transportation Services', 'Logistics and Transportation Services'), ('Media Creators', 'Media Creators'), ('Consulting', 'Consulting'), ('Repair and Maintenance Services', 'Repair and Maintenance Services')], max_length=100, null=True, verbose_name='Business Type')),
                ('logo', models.ImageField(upload_to='brands/', verbose_name='Brand Logo')),
                ('description', models.TextField()),
                ('web', models.URLField(verbose_name='Website')),
                ('email', models.EmailField(max_length=200, verbose_name='Contact email')),
                ('phone', models.CharField(max_length=20)),
                ('address', models.TextField()),
                ('lang', models.CharField(default='en', max_length=80)),
                ('created', models.DateField(auto_now_add=True)),
                ('city_legal', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='geolocation.city')),
                ('country_legal', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='geolocation.country', verbose_name='Country')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='company', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ContactResponse',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('message', models.TextField(verbose_name='Response')),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='contact_response', to='stela_control.contact')),
            ],
        ),
        migrations.CreateModel(
            name='Content',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('category', models.CharField(blank=True, choices=[('News', 'News'), ('Stories', 'Stories'), ('Reviews', 'Reviews'), ('Events', 'Events'), ('Honors', 'Honors')], default='News', max_length=100)),
                ('card', models.CharField(blank=True, choices=[('card-light-danger', 'card-light-danger'), ('card-dark-blue', 'card-dark-blue'), ('card-tale', 'card-tale'), ('card-light-blue', 'card-light-blue')], max_length=50, null=True, verbose_name='Color Card')),
                ('about', models.CharField(blank=True, choices=[('Mission', 'Mission'), ('Vision', 'Vision'), ('Values', 'Values')], default='Mission', max_length=60, null=True, verbose_name='Title')),
                ('section', models.CharField(default='No section', max_length=200, verbose_name='Section')),
                ('path', models.CharField(choices=[('Stela Websites', 'Stela Websites'), ('Stela Business App', 'Stela Business App'), ('Services', 'Services')], max_length=60, null=True, verbose_name='Path Title')),
                ('appstela', models.CharField(choices=[('Communications', 'Communications'), ('Sweet Content', 'Sweet Content'), ('Marketing', 'Marketing'), ('Users Control', 'Users Control'), ('Fintech', 'Fintech'), ('Inventory', 'Inventory'), ('Operations', 'Operations'), ('Maintance', 'Maintance'), ('Speed', 'Speed'), ('Workflow', 'Workflow'), ('Support', 'Support')], max_length=60, null=True, verbose_name='App Title')),
                ('tag', models.CharField(max_length=100, null=True, verbose_name='Tag')),
                ('status', models.CharField(blank=True, choices=[('Publish', 'Publish'), ('Draft', 'Draft')], default='Draft', max_length=10, null=True, verbose_name='Status')),
                ('title', models.CharField(max_length=100, verbose_name='Title')),
                ('media', models.FileField(blank=True, null=True, upload_to='media/')),
                ('folder_doc', models.FileField(blank=True, null=True, upload_to='bucket/')),
                ('subtitle', models.CharField(blank=True, max_length=250, null=True, verbose_name='Subtitle')),
                ('content', models.TextField(blank=True)),
                ('slug', models.SlugField(help_text='Required', max_length=255)),
                ('lang', models.CharField(default='en', max_length=80)),
                ('url', models.CharField(max_length=100, null=True, verbose_name='url')),
                ('site', models.CharField(max_length=100, null=True, verbose_name='Website')),
                ('schedule', models.DateTimeField(blank=True, null=True)),
                ('is_schedule', models.BooleanField(default=False)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('author', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='author', to=settings.AUTH_USER_MODEL)),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='template', to='stela_control.templatesections', verbose_name='Parent')),
            ],
        ),
        migrations.CreateModel(
            name='Comments',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150, verbose_name='Name')),
                ('email', models.EmailField(max_length=254, verbose_name='Email')),
                ('status', models.CharField(choices=[('Draft', 'Draft'), ('Published', 'Published')], default='Draft', max_length=10)),
                ('lang', models.CharField(max_length=80)),
                ('message', models.TextField(verbose_name='Message')),
                ('post', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='comments', to='stela_control.content')),
            ],
        ),
        migrations.CreateModel(
            name='Customer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('full_name', models.CharField(max_length=250, verbose_name='Full Name')),
                ('userid', models.CharField(max_length=20, verbose_name='Costumer ID')),
                ('email', models.EmailField(max_length=254, verbose_name='email')),
                ('country', models.CharField(blank=True, default='No Country', max_length=150, null=True, verbose_name='Country')),
                ('address', models.CharField(max_length=150, verbose_name='Address')),
                ('phone', models.CharField(max_length=50, verbose_name='phone_number')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ControlFacturacion',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('control_id', models.CharField(max_length=15)),
                ('base', models.DecimalField(decimal_places=2, max_digits=8, null=True)),
                ('iva', models.DecimalField(decimal_places=2, max_digits=8, null=True)),
                ('total', models.DecimalField(decimal_places=2, max_digits=15, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('origin', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='control', to='stela_control.billingrecipt')),
                ('owner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('customer', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='stela_control.customer')),
            ],
        ),
        migrations.AddField(
            model_name='billingrecipt',
            name='customer',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='customer', to='stela_control.customer'),
        ),
        migrations.CreateModel(
            name='Discussion',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('topic', models.CharField(max_length=255)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('club', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stela_control.club')),
                ('starter', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='DynamicBullets',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('icon', models.CharField(blank=True, max_length=250, null=True, verbose_name='Icon')),
                ('percentaje', models.IntegerField(blank=True, default=0, null=True)),
                ('quantity', models.IntegerField(blank=True, default=0, null=True)),
                ('bullet_title', models.CharField(max_length=250, null=True, verbose_name='Bullet Title')),
                ('content_bullet', models.TextField(null=True, verbose_name='Content Bullet')),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='bullet_content', to='stela_control.content')),
            ],
        ),
        migrations.CreateModel(
            name='FacebookPage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('fans', models.IntegerField(default=0)),
                ('followers', models.IntegerField(default=0)),
                ('name', models.CharField(max_length=250)),
                ('category', models.CharField(max_length=250)),
                ('asset_id', models.CharField(default='noid', max_length=50)),
                ('token', models.CharField(default='not_token', max_length=250)),
                ('image', models.CharField(max_length=2000)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='FacebookPageConversations',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('core_id', models.CharField(max_length=500)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('page', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='conversations', to='stela_control.facebookpage')),
            ],
        ),
        migrations.CreateModel(
            name='FacebookPageEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('active', 'Scheduled'), ('is_canceled', 'Cancel Event'), ('is_draft', 'Draft'), ('is_online', 'Online')], default='Select Type', max_length=80)),
                ('type', models.CharField(choices=[('', 'Select Type'), ('private', 'Private'), ('public', 'Public'), ('group', 'Group'), ('community', 'Community'), ('friends', 'Friends'), ('work_company', 'Work Company')], default='Scheduled', max_length=80)),
                ('category', models.CharField(choices=[('', 'Select Category'), ('CLASSIC_LITERATURE', 'Classic Literature'), ('COMEDY', 'Comedy'), ('CRAFTS', 'Crafts'), ('DANCE', 'Dance'), ('DRINKS', 'Drinks'), ('FITNESS_AND_WORKOUTS', 'Fitness & Workouts'), ('FOODS', 'Foods'), ('GAMES,', 'Games'), ('GARDENING', 'Gardening'), ('HEALTH_AND_MEDICAL', 'Health & Medical'), ('HEALTHY_LIVING_AND_SELF_CARE', 'Healthy Living & Self Care'), ('HOME_AND_GARDEN', 'Home & Garden'), ('MUSIC_AND_AUDIO', 'Music & Audio'), ('PARTIES', 'Parties'), ('PROFESSIONAL_NETWORKING', 'Professional Networking'), ('RELIGIONS', 'Religions'), ('SHOPPING_EVENT', 'Shopping Event'), ('SOCIAL_ISSUES', 'Social Issues'), ('SPORTS', 'Sports'), ('THEATER', 'Theater'), ('TV_AND_MOVIES', 'Tv & Movies'), ('VISUAL_ARTS', 'Visual Arts')], default='Select Category', max_length=80)),
                ('name', models.CharField(max_length=250)),
                ('lang', models.CharField(default='en', max_length=80)),
                ('start_time', models.DateField()),
                ('location', models.CharField(default='No location selected', max_length=250)),
                ('description', models.TextField(blank=True)),
                ('cover', models.ImageField(upload_to='events/')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='event_owner', to=settings.AUTH_USER_MODEL)),
                ('page', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='events', to='stela_control.facebookpage')),
            ],
        ),
        migrations.CreateModel(
            name='FacebookPageImpressions',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('qty', models.IntegerField(default=0)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='impressions', to='stela_control.facebookpage')),
            ],
        ),
        migrations.CreateModel(
            name='FacebookPageMessages',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('from_message', models.CharField(max_length=250)),
                ('to_message', models.CharField(max_length=250)),
                ('message', models.TextField()),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('conversation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stela_control.facebookpageconversations')),
            ],
        ),
        migrations.CreateModel(
            name='FacebookPostPage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('feed_id', models.CharField(blank=True, default='noid', max_length=500)),
                ('content', models.TextField()),
                ('schedule', models.DateTimeField(blank=True, null=True)),
                ('is_video', models.BooleanField(default=False)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='page', to='stela_control.facebookpage')),
            ],
        ),
        migrations.CreateModel(
            name='FacebookPostMedia',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('media', models.FileField(blank=True, null=True, upload_to='fb_media/')),
                ('post', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stela_control.facebookpostpage')),
            ],
        ),
        migrations.CreateModel(
            name='FacebookPageShares',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('from_user', models.CharField(max_length=250)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('post', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stela_control.facebookpostpage')),
            ],
        ),
        migrations.CreateModel(
            name='FacebookPageLikes',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('from_user', models.CharField(max_length=250)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('post', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stela_control.facebookpostpage')),
            ],
        ),
        migrations.CreateModel(
            name='FacebookPageComments',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('from_user', models.CharField(max_length=250)),
                ('from_user_id', models.CharField(max_length=500)),
                ('comment', models.CharField(max_length=2000)),
                ('comment_id', models.CharField(max_length=500)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('update_rate', models.DateTimeField(default=datetime.datetime(2024, 1, 29, 13, 48, 47, 637127))),
                ('post', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stela_control.facebookpostpage')),
            ],
        ),
        migrations.CreateModel(
            name='FAQ',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('Draft', 'Draft'), ('Publish', 'Publish')], default='Draft', max_length=10, verbose_name='Status')),
                ('legal', models.CharField(choices=[('shipping', 'Shipping and Logistics'), ('marketplace', 'Marketplace Program'), ('product', 'Product/Service'), ('support', 'Technical Support'), ('purchase', 'Purchasing Process'), ('inquiry', 'General Inquiries')], default='shipping', max_length=28, verbose_name='Legal')),
                ('lang', models.CharField(default='en', max_length=80)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='author_faq', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='FormsetFAQ',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('question', models.CharField(max_length=150, verbose_name='Questions')),
                ('response', models.TextField(verbose_name='Answer')),
                ('faq', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='fitems', to='stela_control.faq')),
            ],
        ),
        migrations.CreateModel(
            name='IGMediaContent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('media', models.FileField(blank=True, null=True, upload_to='igmedia/')),
                ('cover', models.FileField(blank=True, null=True, upload_to='igcover/')),
                ('post', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='igitem', to='stela_control.igpost')),
            ],
        ),
        migrations.CreateModel(
            name='IGCarouselMetric',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('album_engagement', models.IntegerField(blank=True, default=0)),
                ('album_impressions', models.IntegerField(blank=True, default=0)),
                ('album_reach', models.IntegerField(blank=True, default=0)),
                ('album_saved', models.IntegerField(blank=True, default=0)),
                ('album_video_views', models.IntegerField(blank=True, default=0)),
                ('post', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='metric_carousel', to='stela_control.igpost')),
            ],
        ),
        migrations.CreateModel(
            name='IGPostMetric',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('engagement', models.IntegerField(blank=True, default=0)),
                ('impressions', models.IntegerField(blank=True, default=0)),
                ('reach', models.IntegerField(blank=True, default=0)),
                ('saved', models.IntegerField(blank=True, default=0)),
                ('video_views', models.IntegerField(blank=True, default=0)),
                ('post', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='metric_post', to='stela_control.igpost')),
            ],
        ),
        migrations.CreateModel(
            name='IGReelMetric',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('comments', models.IntegerField(blank=True, default=0)),
                ('likes', models.IntegerField(blank=True, default=0)),
                ('plays', models.IntegerField(blank=True, default=0)),
                ('reach', models.IntegerField(blank=True, default=0)),
                ('saved', models.IntegerField(blank=True, default=0)),
                ('shares', models.IntegerField(blank=True, default=0)),
                ('total_interactions', models.IntegerField(blank=True, default=0)),
                ('post', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='metric_reel', to='stela_control.igpost')),
            ],
        ),
        migrations.CreateModel(
            name='IGStoriesMetric',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('exits', models.IntegerField(blank=True, default=0)),
                ('impressions', models.IntegerField(blank=True, default=0)),
                ('replies', models.IntegerField(blank=True, default=0)),
                ('taps_forward', models.IntegerField(blank=True, default=0)),
                ('taps_back', models.IntegerField(blank=True, default=0)),
                ('post', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='metric_stories', to='stela_control.igpost')),
            ],
        ),
        migrations.CreateModel(
            name='IGUserTag',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('igname', models.CharField(blank=True, default='noid', max_length=200)),
                ('post', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='stela_control.igpost')),
            ],
        ),
        migrations.CreateModel(
            name='ImageGallery',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(upload_to='gallery/', verbose_name='Image')),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stela_control.content')),
            ],
        ),
        migrations.CreateModel(
            name='InstagramAccount',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('commerce_id', models.CharField(default='no_commerce', max_length=250)),
                ('followers', models.IntegerField(default=0)),
                ('title', models.CharField(max_length=250)),
                ('username', models.CharField(max_length=250)),
                ('asset_id', models.CharField(default='noid', max_length=50)),
                ('image', models.CharField(max_length=2000)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='igpost',
            name='parent',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='media', to='stela_control.instagramaccount'),
        ),
        migrations.CreateModel(
            name='Inventory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('Active', 'Active'), ('Pending', 'Pending'), ('Inactive', 'Inactive')], default='Inactive', max_length=10, verbose_name='Status')),
                ('sku', models.CharField(help_text='Required', max_length=255, verbose_name='SKU')),
                ('title', models.CharField(help_text='Required', max_length=255, verbose_name='Title')),
                ('yearly', models.BooleanField(default=False)),
                ('type', models.CharField(choices=[('Service', 'Service'), ('Product', 'Product'), ('Publishing', 'Publishing'), ('Reviews Works', 'Reviews Works')], default='Select Type', max_length=30, verbose_name='Type')),
                ('description', models.TextField(blank=True, help_text='No Required', verbose_name='Description')),
                ('image', models.ImageField(upload_to='inventory/', verbose_name='Image')),
                ('slug', models.SlugField(help_text='Required', max_length=255)),
                ('price', models.DecimalField(blank=True, decimal_places=2, error_messages={'name': {'max_lenght': 'The price must be between 0 and 9999.99'}}, help_text='Maximun 9999.99', max_digits=6, null=True, verbose_name='Price USD')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('url', models.URLField()),
                ('published_date', models.DateTimeField(blank=True, null=True, verbose_name='Published Date')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('lang', models.CharField(default='en', max_length=80)),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='products', to='stela_control.category')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='Elements',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Required', max_length=255, verbose_name='Service')),
                ('subtitle', models.CharField(help_text='Required', max_length=255, verbose_name='Subtitle')),
                ('description', models.TextField(blank=True, help_text='No Required', verbose_name='Description')),
                ('image', models.ImageField(upload_to='services/', verbose_name='Image')),
                ('price', models.DecimalField(blank=True, decimal_places=2, error_messages={'name': {'max_lenght': 'The price must be between 0 and 9999.99'}}, help_text='Maximun 9999.99', max_digits=6, null=True, verbose_name='Price USD')),
                ('status', models.CharField(choices=[('Active', 'Active'), ('Inactive', 'Inactive')], max_length=10)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('slug', models.SlugField(blank=True, max_length=255)),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='elements', to='stela_control.inventory')),
            ],
        ),
        migrations.CreateModel(
            name='CommentsWorks',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('full_name', models.CharField(max_length=250)),
                ('cover', models.ImageField(upload_to='comment_profile/', verbose_name='Profile')),
                ('content', models.TextField(verbose_name='Message')),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='comments', to='stela_control.inventory')),
            ],
        ),
        migrations.CreateModel(
            name='Bulletpoints',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.CharField(blank=True, max_length=250, verbose_name='Bulletpoint')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stela_control.inventory')),
            ],
        ),
        migrations.CreateModel(
            name='ItemCloud',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.DecimalField(decimal_places=2, max_digits=8)),
                ('qty', models.IntegerField(default=1, verbose_name='Qty')),
                ('field', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cloud.usagecloud')),
                ('recipt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='cloud_recipt', to='stela_control.billingrecipt')),
            ],
        ),
        migrations.CreateModel(
            name='ItemDiscount',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field', models.CharField(choices=[('No Selected', 'No Selected'), ('Stela Payment Free Suscription', 'Stela Payment Free Suscription'), ('Initial Payment', 'Initial Payment'), ('Promotional Discount', 'Promotional Discount')], max_length=60)),
                ('amount', models.DecimalField(decimal_places=2, max_digits=8)),
                ('recipt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='discounts', to='stela_control.billingrecipt')),
            ],
        ),
        migrations.CreateModel(
            name='ItemServices',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.DecimalField(decimal_places=2, max_digits=8)),
                ('qty', models.IntegerField(default=1, verbose_name='Qty')),
                ('field', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stela_control.elements')),
                ('recipt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='service_recipt', to='stela_control.billingrecipt')),
            ],
        ),
        migrations.CreateModel(
            name='EmploymentHistory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('employer', models.CharField(max_length=100, verbose_name='Employer')),
                ('job_title', models.CharField(max_length=100, verbose_name='Job Title')),
                ('employment_period_from', models.DateField(verbose_name='Employment Period From')),
                ('employment_period_to', models.DateField(blank=True, null=True, verbose_name='Employment Period To')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Job Description')),
                ('job_application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='employment_history', to='stela_control.jobapplication')),
            ],
        ),
        migrations.CreateModel(
            name='Education',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('institution_name', models.CharField(max_length=100, verbose_name='Institution Name')),
                ('degree_obtained', models.CharField(blank=True, max_length=100, null=True, verbose_name='Degree Obtained')),
                ('study_period_from', models.DateField(blank=True, null=True, verbose_name='Study Period From')),
                ('study_period_to', models.DateField(blank=True, null=True, verbose_name='Study Period To')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description of Study')),
                ('job_application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='education', to='stela_control.jobapplication')),
            ],
        ),
        migrations.CreateModel(
            name='LiteraryWork',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100)),
                ('publication_date', models.DateField()),
                ('genre', models.CharField(max_length=50)),
                ('synopsis', models.TextField()),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='literary_author', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Message',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content', models.TextField()),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('title', models.CharField(max_length=255)),
                ('file', models.FileField(upload_to='resources/')),
                ('uploaded_at', models.DateTimeField(auto_now_add=True)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='messages', to=settings.AUTH_USER_MODEL)),
                ('club', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stela_control.club')),
            ],
        ),
        migrations.CreateModel(
            name='ModuleItems',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.DecimalField(decimal_places=2, max_digits=8)),
                ('qty', models.IntegerField(default=1, verbose_name='Qty')),
                ('field', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stela_control.elements')),
                ('recipt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='modules', to='stela_control.billingrecipt')),
            ],
        ),
        migrations.CreateModel(
            name='Newsletter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('template', models.CharField(choices=[('Style Template 3', 'Style Template 3'), ('Style Template 2', 'Style Template 2'), ('Style Template 4', 'Style Template 4'), ('Style Template 1', 'Style Template 1')], max_length=60, null=True, verbose_name='Style')),
                ('subject', models.CharField(max_length=250, verbose_name='Subject')),
                ('body', models.TextField(verbose_name='Messages')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(choices=[('Send', 'Send'), ('Draft', 'Draft')], max_length=20)),
                ('email', models.ManyToManyField(to='stela_control.dataemail', verbose_name='Emails')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='lead', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Notifications',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(default='No Read', max_length=200)),
                ('title', models.CharField(max_length=200)),
                ('description', models.CharField(max_length=200)),
                ('section', models.CharField(max_length=200)),
                ('url', models.CharField(max_length=200)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Order',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('section', models.CharField(choices=[('Store', 'Store'), ('Cloud Domains', 'Cloud Domains'), ('Cloud Elastic Instance', 'Cloud Elastic Instance'), ('Stela Websites', 'Stela Websites'), ('Stela Design', 'Stela Design'), ('No Selected', 'No Selected'), ('Stela Marketing', 'Stela Marketing')], default='No Selected', max_length=50)),
                ('email', models.EmailField(max_length=254, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('key_validator', models.CharField(max_length=200)),
                ('transaction_id', models.CharField(max_length=200, null=True)),
                ('payment_option', models.CharField(blank=True, max_length=200, null=True)),
                ('subtotal', models.DecimalField(decimal_places=2, max_digits=7, null=True)),
                ('taxes', models.DecimalField(decimal_places=2, max_digits=7, null=True)),
                ('profit', models.DecimalField(decimal_places=2, max_digits=7, null=True)),
                ('payment_fee', models.DecimalField(decimal_places=2, max_digits=7, null=True)),
                ('total_paid', models.DecimalField(decimal_places=2, max_digits=7, null=True)),
                ('status', models.CharField(choices=[('Completed', 'Completed'), ('Pending', 'Pending')], default='Pending', max_length=100)),
                ('billing', models.IntegerField(null=True)),
                ('customer', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='stela_control.customer')),
                ('owner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='InvoiceControl',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('control_id', models.CharField(default='Not ID', max_length=20)),
                ('section', models.CharField(max_length=200, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('recipt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='billing_control', to='stela_control.billingrecipt')),
                ('order', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='stela_control.order')),
            ],
        ),
        migrations.CreateModel(
            name='FacturaItems',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='compra', to='stela_control.controlfacturacion')),
                ('recipt', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='stela_control.invoicecontrol')),
                ('origin', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='stela_control.order')),
            ],
        ),
        migrations.AddField(
            model_name='controlfacturacion',
            name='order',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='stela_control.order'),
        ),
        migrations.CreateModel(
            name='ClubPoints',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('points', models.IntegerField()),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stela_control.order')),
            ],
        ),
        migrations.CreateModel(
            name='Budget',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('withdraw', models.BooleanField(default=False)),
                ('amount', models.DecimalField(decimal_places=2, max_digits=7)),
                ('date', models.DateTimeField(auto_now_add=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stela_control.order')),
            ],
        ),
        migrations.CreateModel(
            name='PathControl',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('step', models.CharField(choices=[('Step 4', 'Step 4'), ('Step 2', 'Step 2'), ('Step 3', 'Step 3')], default='No Selected', max_length=50)),
                ('superuser', models.CharField(max_length=200, null=True)),
                ('password', models.CharField(max_length=200, null=True)),
                ('url', models.CharField(max_length=200, null=True)),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='path', to='stela_control.order')),
            ],
        ),
        migrations.CreateModel(
            name='PetData',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name="Pet's name")),
                ('image', models.ImageField(upload_to='images/', verbose_name='Image')),
                ('family', models.CharField(choices=[('Dog', 'Dog')], help_text='Choose Please', max_length=10, verbose_name='Pet Family')),
                ('allergy', models.BooleanField(default=False, verbose_name="It's Allergic?")),
                ('reactive', models.CharField(blank=True, max_length=250, null=True, verbose_name='Product React')),
                ('weight', models.CharField(choices=[('1 to 10', '1 to 10'), ('10 to 25', '10 to 25'), ('26 to 40', '26 to 40'), ('41 to 70', '41 to 70'), ('71 to 91', '71 to 91'), ('91 +', '91 +')], help_text='Choose Please', max_length=40, verbose_name='Weght LBS')),
                ('breed', models.CharField(choices=[('Short Coat Breeds', 'Short Coat Breeds'), ('Wire Coat Breeds', 'Wire Coat Breeds'), ('Soft Coat Breeds', 'Soft Coat Breeds'), ('Double Coat Breeds', 'Double Coat Breeds'), ('Doodles Breeds', 'Doodles Breeds')], help_text='Choose Please', max_length=80, verbose_name='Pet Breed')),
                ('price', models.DecimalField(blank=True, decimal_places=2, error_messages={'name': {'max_lenght': 'The price must be between 0 and 999.99'}}, help_text='Maximun 999.99', max_digits=5, null=True, verbose_name='Regular price USD')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pet_owner', to=settings.AUTH_USER_MODEL)),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='pet_service', to='stela_control.inventory')),
            ],
        ),
        migrations.CreateModel(
            name='ProStelaData',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(default='No title', max_length=150)),
                ('chatbox', models.TextField(default='Empty')),
                ('storage_data', models.TextField(default='Empty')),
                ('response_time', models.DecimalField(decimal_places=2, max_digits=6)),
                ('section', models.CharField(default='custom', max_length=150)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('model', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='model_expert', to='stela_control.content')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='prostela', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ProStelaUsage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tokens', models.IntegerField(default=0)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('prompt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='prompt_data', to='stela_control.prosteladata')),
            ],
        ),
        migrations.CreateModel(
            name='Reference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='Name')),
                ('contact_info', models.TextField(verbose_name='Contact Information')),
                ('relationship', models.CharField(blank=True, max_length=100, null=True, verbose_name='Relationship')),
                ('job_application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='references', to='stela_control.jobapplication')),
            ],
        ),
        migrations.CreateModel(
            name='Reviews',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rate', models.IntegerField(default=1)),
                ('ip', models.CharField(blank=True, max_length=20)),
                ('status', models.CharField(choices=[('Draft', 'Draft'), ('Publish', 'Publish')], default='Draft', max_length=10)),
                ('lang', models.CharField(max_length=80)),
                ('message', models.TextField(verbose_name='Message')),
                ('create', models.DateTimeField(auto_now_add=True)),
                ('catalog', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='reviews', to='stela_control.inventory')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='SetFaq',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('question', models.CharField(default='', max_length=250, verbose_name='Question')),
                ('answer', models.TextField()),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('faq', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='set_faq', to='stela_control.faq')),
            ],
        ),
        migrations.CreateModel(
            name='SitePolicy',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, max_length=150, null=True, verbose_name='Title')),
                ('status', models.CharField(blank=True, choices=[('Publish', 'Publish'), ('Draft', 'Draft')], default='Draft', max_length=10, verbose_name='Status')),
                ('section', models.CharField(blank=True, choices=[('budget_design_terms', 'Budget Design Terms'), ('budget_marketing_terms', 'Budget Marketing Terms'), ('monthly_terms', 'Billing Terms'), ('Disclaimer', 'Disclaimer'), ('Privacy Policy', 'Privacy Policy'), ('Cookie Policy', 'Cookie Policy'), ('budget_development_terms', 'Budget Development Terms'), ('Terms and Conditions', 'Terms and Conditions'), ('billing_terms', 'Monthly Billing Terms'), ('Return Policy', 'Return Policy')], default='Terms and Conditions', max_length=150)),
                ('lang', models.CharField(default='en', max_length=80)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='site_docs', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='LegalProvision',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('clause', models.CharField(max_length=150, verbose_name='Clause')),
                ('clause_content', models.TextField(blank=True, verbose_name='Content')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('policy', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='content', to='stela_control.sitepolicy')),
            ],
        ),
        migrations.CreateModel(
            name='SiteViews',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('host', models.CharField(default='no catch data', max_length=150)),
                ('page', models.CharField(default='page no catched', max_length=150)),
                ('views', models.IntegerField(default=0)),
                ('lastdate', models.CharField(default='no catch data', max_length=150)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('blog', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='stela_control.content')),
                ('country', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='geolocation.country', verbose_name='Country')),
            ],
        ),
        migrations.CreateModel(
            name='Sizes',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('size', models.CharField(max_length=20, verbose_name='size')),
                ('owner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='StelaColors',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=20)),
                ('code1', models.CharField(blank=True, max_length=10, null=True)),
                ('code2', models.CharField(blank=True, max_length=10, null=True)),
                ('code3', models.CharField(blank=True, max_length=10, null=True)),
                ('owner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='StelaPayments',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField(null=True)),
                ('billing', models.IntegerField(null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('key_validator', models.CharField(max_length=200)),
                ('transaction_id', models.CharField(max_length=200, null=True)),
                ('payment_option', models.CharField(blank=True, max_length=200, null=True)),
                ('subtotal', models.DecimalField(decimal_places=2, max_digits=7, null=True)),
                ('taxes', models.DecimalField(decimal_places=2, max_digits=7, null=True)),
                ('profit', models.DecimalField(decimal_places=2, max_digits=7, null=True)),
                ('payment_fee', models.DecimalField(decimal_places=2, max_digits=7, null=True)),
                ('total_paid', models.DecimalField(decimal_places=2, max_digits=7, null=True)),
                ('host', models.CharField(max_length=200)),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='StelaSelection',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('validator', models.CharField(default='No user', max_length=50)),
                ('status', models.CharField(choices=[('Pending', 'Pending'), ('Checked', 'Checked'), ('Payeed', 'Payeed')], default='Pending', max_length=10)),
                ('amount', models.DecimalField(blank=True, decimal_places=2, error_messages={'name': {'max_lenght': 'The price must be between 0 and 9999.99'}}, max_digits=6, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('domain', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='cloud.domains')),
                ('integration', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='stela_control.inventory')),
            ],
        ),
        migrations.CreateModel(
            name='StelaItems',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('module', models.CharField(max_length=150, verbose_name='Title')),
                ('amount', models.DecimalField(blank=True, decimal_places=2, max_digits=6, null=True)),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='parent', to='stela_control.stelaselection')),
            ],
        ),
        migrations.CreateModel(
            name='Support',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.EmailField(max_length=254)),
                ('terms', models.BooleanField(verbose_name='Responsibility commitment')),
                ('message', models.TextField(verbose_name='Brief description')),
                ('option', models.CharField(choices=[('My delivery has been delayed', 'My delivery has been delayed'), ('I have a problem with my project', 'I have a problem with my project'), ('Payments Issue', 'Payments Issue'), ('I have a problem with my subscription', 'I have a problem with my subscription'), ('My account has an error', 'My account has an error'), ('Others', 'Others')], max_length=60, verbose_name='Case')),
                ('image', models.ImageField(blank=True, null=True, upload_to='cases/', verbose_name='Image (optional)')),
                ('ticket', models.CharField(max_length=60)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(choices=[('Completed', 'Completed'), ('Pending', 'Pending')], default='Pending', max_length=50, null=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='user_support', to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
        ),
        migrations.CreateModel(
            name='ChatSupport',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('response', models.TextField(verbose_name='Answer')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='chat_response', to=settings.AUTH_USER_MODEL, verbose_name='Usuario')),
                ('case', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stela_control.support')),
            ],
        ),
        migrations.CreateModel(
            name='SupportResponse',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('response', models.TextField(verbose_name='Answer')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('case', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stela_control.support')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='user_response', to=settings.AUTH_USER_MODEL, verbose_name='Usuario')),
            ],
        ),
        migrations.CreateModel(
            name='Team',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('Publish', 'Publish'), ('Draft', 'Draft')], default='Draft', max_length=10, verbose_name='Status')),
                ('full_name', models.CharField(max_length=150, verbose_name='Staff Full Name')),
                ('description', models.TextField()),
                ('image', models.ImageField(upload_to='profile/', verbose_name='Image')),
                ('lang', models.CharField(default='es', max_length=80)),
                ('staff', models.CharField(max_length=150, verbose_name='Staff')),
                ('owner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='owner_team', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='SocialLinks',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('social', models.CharField(choices=[('Facebook', 'Facebook'), ('Github', 'Github'), ('Wikipedia', 'Wikipedia'), ('Instagram', 'Instagram'), ('Tiktok', 'Tiktok'), ('Linkedin', 'Linkedin'), ('Youtube', 'Youtube'), ('X', 'X')], default='No Selected', max_length=50)),
                ('url', models.CharField(max_length=80)),
                ('parent_company', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='company_social', to='stela_control.company')),
                ('parent_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='owner_social', to=settings.AUTH_USER_MODEL)),
                ('parent_staff', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='staff_social', to='stela_control.team')),
            ],
        ),
        migrations.CreateModel(
            name='ProfileGallery',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(upload_to='profile_gallery/', verbose_name='Image')),
                ('created', models.DateField(auto_now_add=True)),
                ('profile', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='gallery', to='stela_control.team')),
            ],
        ),
        migrations.CreateModel(
            name='Templates',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('Inactive', 'Inactive'), ('Active', 'Active')], default='Inactive', max_length=10, verbose_name='Status')),
                ('title', models.CharField(max_length=150, verbose_name='Title')),
                ('image', models.ImageField(upload_to='templates/', verbose_name='Image')),
                ('slug', models.SlugField(help_text='Required', max_length=255)),
                ('url', models.CharField(max_length=50, verbose_name='Url')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('integration', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='items', to='stela_control.inventory')),
            ],
        ),
        migrations.AddField(
            model_name='stelaselection',
            name='template',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='templates', to='stela_control.templates'),
        ),
        migrations.CreateModel(
            name='Variant',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('color', models.CharField(blank=True, max_length=50, null=True, verbose_name='Color')),
                ('size', models.CharField(blank=True, max_length=50, null=True, verbose_name='Size')),
                ('price', models.DecimalField(decimal_places=2, max_digits=8, verbose_name='Variant Price USD')),
                ('image', models.ImageField(blank=True, null=True, upload_to='inventory/variants/', verbose_name='Variant Image')),
                ('sku', models.CharField(blank=True, max_length=255, null=True, verbose_name='SKU')),
                ('weight', models.DecimalField(blank=True, decimal_places=2, max_digits=6, null=True, verbose_name='Weight (kg)')),
                ('material', models.CharField(blank=True, max_length=100, null=True, verbose_name='Material')),
                ('warranty', models.CharField(blank=True, max_length=255, null=True, verbose_name='Warranty Information')),
                ('technical_specs', models.TextField(blank=True, verbose_name='Technical Specifications')),
                ('safety_information', models.TextField(blank=True, verbose_name='Safety Information')),
                ('compliance_certificates', models.CharField(blank=True, max_length=255, null=True, verbose_name='Compliance Certificates')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='variant', to='stela_control.inventory')),
            ],
        ),
        migrations.CreateModel(
            name='OrderItems',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nameitem', models.CharField(max_length=200)),
                ('amount', models.DecimalField(blank=True, decimal_places=2, max_digits=6, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('elements', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='stela_control.elements')),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='purchases', to='stela_control.order')),
                ('stela_selection', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='stela_control.stelaselection')),
                ('product', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='stela_control.variant')),
            ],
        ),
        migrations.CreateModel(
            name='ItemProducts',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.DecimalField(decimal_places=2, max_digits=8)),
                ('qty', models.IntegerField(default=1, verbose_name='Qty')),
                ('recipt', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='product_recipt', to='stela_control.billingrecipt')),
                ('field', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stela_control.variant')),
            ],
        ),
        migrations.CreateModel(
            name='VariantsImage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, verbose_name='Catalogue Title')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='catalog', to='stela_control.variant')),
            ],
        ),
        migrations.CreateModel(
            name='Gallery',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('Product Detail', 'Product Detail'), ('Product Description', 'Product Description')], default='Select Type', max_length=30, verbose_name='Type')),
                ('title', models.CharField(default='No selected', max_length=255)),
                ('image', models.ImageField(blank=True, upload_to='product/')),
                ('catalogue', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='img', to='stela_control.variantsimage')),
            ],
        ),
        migrations.CreateModel(
            name='Wallet',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('Zelle', 'Zelle'), ('Binance', 'Binance'), ('Paypal', 'Paypal')], max_length=100, verbose_name='Type of Wallet')),
                ('email', models.EmailField(max_length=254, unique=True, verbose_name='email')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='SendMoney',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ipadress', models.CharField(blank=True, max_length=20)),
                ('amount', models.DecimalField(decimal_places=2, max_digits=8)),
                ('date', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(choices=[('Completed', 'Completed'), ('Pending', 'Pending')], default='Pending', max_length=50)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('wallet', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stela_control.wallet')),
            ],
        ),
        migrations.CreateModel(
            name='WishList',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='whishlist', to='stela_control.variant')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='YouTubeToken',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('access_token', models.CharField(max_length=255)),
                ('refresh_token', models.CharField(max_length=255)),
                ('token_type', models.CharField(max_length=50)),
                ('expires_in', models.DateTimeField()),
                ('scope', models.TextField()),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='youtube_token', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ProStelaExpert',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model', models.CharField(max_length=80)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='owner_proexpert', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('owner', 'model')},
            },
        ),
    ]
