"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .logprobs import Logprobs, LogprobsTypedDict
from friendli.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import NotRequired, TypedDict


StreamedChatChoiceType = Literal["function"]
r"""The type of the tool."""


class StreamedChatChoiceFunctionTypedDict(TypedDict):
    name: str
    r"""The name of the function to call."""
    arguments: str
    r"""The arguments for calling the function, generated by the model in JSON format.
    Ensure to validate these arguments in your code before invoking the function since the model may not always produce valid JSON.

    """


class StreamedChatChoiceFunction(BaseModel):
    name: str
    r"""The name of the function to call."""

    arguments: str
    r"""The arguments for calling the function, generated by the model in JSON format.
    Ensure to validate these arguments in your code before invoking the function since the model may not always produce valid JSON.

    """


class StreamedChatChoiceToolCallsTypedDict(TypedDict):
    index: int
    r"""The index of tool call being generated."""
    id: str
    r"""The ID of the tool call."""
    type: StreamedChatChoiceType
    r"""The type of the tool."""
    function: StreamedChatChoiceFunctionTypedDict


class StreamedChatChoiceToolCalls(BaseModel):
    index: int
    r"""The index of tool call being generated."""

    id: str
    r"""The ID of the tool call."""

    type: StreamedChatChoiceType
    r"""The type of the tool."""

    function: StreamedChatChoiceFunction


class DeltaTypedDict(TypedDict):
    role: NotRequired[str]
    r"""Role of the generated message author, in this case `assistant`."""
    content: NotRequired[str]
    r"""The contents of the assistant message."""
    tool_calls: NotRequired[StreamedChatChoiceToolCallsTypedDict]


class Delta(BaseModel):
    role: Optional[str] = None
    r"""Role of the generated message author, in this case `assistant`."""

    content: Optional[str] = None
    r"""The contents of the assistant message."""

    tool_calls: Optional[StreamedChatChoiceToolCalls] = None


class StreamedChatChoiceTypedDict(TypedDict):
    index: int
    r"""The index of the choice in the list of generated choices."""
    delta: DeltaTypedDict
    finish_reason: NotRequired[Nullable[str]]
    r"""Termination condition of the generation. `stop` means the API returned the full chat completions generated by the model without running into any limits. `length` means the generation exceeded `max_tokens` or the conversation exceeded the max context length."""
    logprobs: NotRequired[LogprobsTypedDict]
    r"""Log probability information for the choice."""


class StreamedChatChoice(BaseModel):
    index: int
    r"""The index of the choice in the list of generated choices."""

    delta: Delta

    finish_reason: OptionalNullable[str] = UNSET
    r"""Termination condition of the generation. `stop` means the API returned the full chat completions generated by the model without running into any limits. `length` means the generation exceeded `max_tokens` or the conversation exceeded the max context length."""

    logprobs: Optional[Logprobs] = None
    r"""Log probability information for the choice."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["finish_reason", "logprobs"]
        nullable_fields = ["finish_reason"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
