import ast
from pathlib import Path
from typing import Optional


class NoSuchProject(Exception):
    def __init__(self, root: Path | str) -> None:
        super().__init__(f"No such project: {root}")


class Project:
    def __init__(self, root: Path | str, *, name: Optional[str] = None) -> None:
        self._root = Path(root)
        if not self._root.exists() or self._root.is_file():
            raise NoSuchProject(root)
        self._name = name or self.root.absolute().name
        self._python_files = {}
        for python_file in self._root.glob("**/*.py"):
            python_file = python_file.relative_to(self._root)
            self._python_files[python_file] = ast.parse(
                python_file.read_text(encoding="utf-8")
            )

    @property
    def root(self) -> Path:
        return self._root

    @property
    def name(self) -> str:
        return self._name
