# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MirrorPolicyObjectArgs', 'MirrorPolicyObject']

@pulumi.input_type
class MirrorPolicyObjectArgs:
    def __init__(__self__, *,
                 remote_destination_ip: pulumi.Input[str],
                 source_ip: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MirrorPolicyObject resource.
        :param pulumi.Input[str] remote_destination_ip: Remote destination IP
        :param pulumi.Input[str] source_ip: Source IP
        :param pulumi.Input[str] name: The name of the policy object
        """
        pulumi.set(__self__, "remote_destination_ip", remote_destination_ip)
        pulumi.set(__self__, "source_ip", source_ip)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="remoteDestinationIp")
    def remote_destination_ip(self) -> pulumi.Input[str]:
        """
        Remote destination IP
        """
        return pulumi.get(self, "remote_destination_ip")

    @remote_destination_ip.setter
    def remote_destination_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "remote_destination_ip", value)

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> pulumi.Input[str]:
        """
        Source IP
        """
        return pulumi.get(self, "source_ip")

    @source_ip.setter
    def source_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _MirrorPolicyObjectState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 remote_destination_ip: Optional[pulumi.Input[str]] = None,
                 source_ip: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering MirrorPolicyObject resources.
        :param pulumi.Input[str] name: The name of the policy object
        :param pulumi.Input[str] remote_destination_ip: Remote destination IP
        :param pulumi.Input[str] source_ip: Source IP
        :param pulumi.Input[int] version: The version of the object
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if remote_destination_ip is not None:
            pulumi.set(__self__, "remote_destination_ip", remote_destination_ip)
        if source_ip is not None:
            pulumi.set(__self__, "source_ip", source_ip)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="remoteDestinationIp")
    def remote_destination_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Remote destination IP
        """
        return pulumi.get(self, "remote_destination_ip")

    @remote_destination_ip.setter
    def remote_destination_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_destination_ip", value)

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Source IP
        """
        return pulumi.get(self, "source_ip")

    @source_ip.setter
    def source_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_ip", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class MirrorPolicyObject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 remote_destination_ip: Optional[pulumi.Input[str]] = None,
                 source_ip: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a Mirror Policy Object .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.MirrorPolicyObject("example",
            name="Example",
            remote_destination_ip="10.1.1.1",
            source_ip="10.2.1.1")
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/mirrorPolicyObject:MirrorPolicyObject example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the policy object
        :param pulumi.Input[str] remote_destination_ip: Remote destination IP
        :param pulumi.Input[str] source_ip: Source IP
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MirrorPolicyObjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Mirror Policy Object .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.MirrorPolicyObject("example",
            name="Example",
            remote_destination_ip="10.1.1.1",
            source_ip="10.2.1.1")
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/mirrorPolicyObject:MirrorPolicyObject example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param MirrorPolicyObjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MirrorPolicyObjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 remote_destination_ip: Optional[pulumi.Input[str]] = None,
                 source_ip: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MirrorPolicyObjectArgs.__new__(MirrorPolicyObjectArgs)

            __props__.__dict__["name"] = name
            if remote_destination_ip is None and not opts.urn:
                raise TypeError("Missing required property 'remote_destination_ip'")
            __props__.__dict__["remote_destination_ip"] = remote_destination_ip
            if source_ip is None and not opts.urn:
                raise TypeError("Missing required property 'source_ip'")
            __props__.__dict__["source_ip"] = source_ip
            __props__.__dict__["version"] = None
        super(MirrorPolicyObject, __self__).__init__(
            'sdwan:index/mirrorPolicyObject:MirrorPolicyObject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            remote_destination_ip: Optional[pulumi.Input[str]] = None,
            source_ip: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'MirrorPolicyObject':
        """
        Get an existing MirrorPolicyObject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the policy object
        :param pulumi.Input[str] remote_destination_ip: Remote destination IP
        :param pulumi.Input[str] source_ip: Source IP
        :param pulumi.Input[int] version: The version of the object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MirrorPolicyObjectState.__new__(_MirrorPolicyObjectState)

        __props__.__dict__["name"] = name
        __props__.__dict__["remote_destination_ip"] = remote_destination_ip
        __props__.__dict__["source_ip"] = source_ip
        __props__.__dict__["version"] = version
        return MirrorPolicyObject(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the policy object
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="remoteDestinationIp")
    def remote_destination_ip(self) -> pulumi.Output[str]:
        """
        Remote destination IP
        """
        return pulumi.get(self, "remote_destination_ip")

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> pulumi.Output[str]:
        """
        Source IP
        """
        return pulumi.get(self, "source_ip")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

