#
# This file is part of Invenio.
# Copyright (C) 2022 CERN.
#
# Invenio is free software; you can redistribute it and/or modify it
# under the terms of the MIT License; see LICENSE file for more details.

"""Create funders vocabulary table."""

import sqlalchemy as sa
import sqlalchemy_utils
from alembic import op
from sqlalchemy.dialects import mysql, postgresql

# revision identifiers, used by Alembic.
revision = '676dd587542d'
down_revision = '17c703ce1eb7'
branch_labels = ()
depends_on = None


def upgrade():
    """Upgrade database."""
    op.create_table(
        'funder_metadata',
        sa.Column(
            'created',
            sa.DateTime().with_variant(mysql.DATETIME(fsp=6), 'mysql'),
            nullable=False
        ),
        sa.Column(
            'updated',
            sa.DateTime().with_variant(mysql.DATETIME(fsp=6), 'mysql'),
            nullable=False
        ),
        sa.Column(
            'id',
            sqlalchemy_utils.types.uuid.UUIDType(),
            nullable=False
        ),
        sa.Column(
            'json',
            sa.JSON()
            .with_variant(sqlalchemy_utils.types.json.JSONType(), 'mysql')
            .with_variant(
                postgresql.JSONB(none_as_null=True, astext_type=sa.Text()),
                'postgresql'
            ).with_variant(sqlalchemy_utils.types.json.JSONType(), 'sqlite'),
            nullable=True
        ),
        sa.Column('version_id', sa.Integer(), nullable=False),
        sa.Column('pid', sa.String(), nullable=True),
        sa.PrimaryKeyConstraint('id', name=op.f('pk_funder_metadata')),
        sa.UniqueConstraint('pid', name=op.f('uq_funder_metadata_pid'))
    )
    # ### end Alembic commands ###


def downgrade():
    """Downgrade database."""
    op.drop_table('funder_metadata')
    # ### end Alembic commands ###
