from typing import Final

# HTML tag attribute map
HTML_ATTRIBUTES: Final[dict[str, list[str]]] = {
    "A": [
        "href",
        "target",
        "download",
        "rel",
        "hreflang",
        "typereferrerpolicy",
        "media",
        "ping",
        "class_",
        "id",
    ],
    "Area": [
        "alt",
        "coords",
        "download",
        "href",
        "ping",
        "referrerpolicy",
        "rel",
        "shape",
        "target",
    ],
    "Audio": [
        "autoplay",
        "controls",
        "loop",
        "muted",
        "preload",
        "src",
    ],
    "Base": [
        "href",
        "target",
    ],
    "Bdi": [
        "dir",
    ],
    "Blockquote": [
        "cite",
    ],
    "Button": [
        "name",
        "type",
        "value",
        "autofocus",
        "disabled",
        "form",
        "formaction",
        "formenctype",
        "formmethod",
        "formnovalidate",
        "formtarget",
        "popovertarget",
        "popovertargetaction",
    ],
    "Canvas": [
        "width",
        "height",
    ],
    "Col": ["span"],
    "Colgroup": ["span"],
    "Data": ["value"],
    "Dd": ["cite", "datetime"],
    "Details": ["open"],
    "Dialog": ["open"],
    "Embed": [
        "src",
        "typewidthheight",
    ],
    "Fieldset": [
        "disabled",
        "form",
        "name",
    ],
    "Form": [
        "accept-charset",
        "action",
        "autocomplete",
        "enctype",
        "method",
        "name",
        "novalidate",
        "rel",
        "target",
    ],
    "Head": [
        "profile",
    ],
    "Iframe": [
        "src",
        "srcdoc",
        "width",
        "height",
        "allow",
        "allowfullscreen",
        "allowpaymentrequest",
        "loading",
        "name",
        "referrerpolicy",
        "sandbox",
    ],
    "Img": [
        "src",
        "width",
        "heightsrcset",
        "alt",
        "crossorigin",
        "ismap",
        "loading",
        "longdesc",
        "referrerpolicy",
        "sizesusemap",
    ],
    "Input": [
        "type",
        "value",
        "readonly",
        "required",
        "accept",
        "alt",
        "autocomplete",
        "autofocus",
        "checked",
        "dirname",
        "disabled",
        "form",
        "formaction",
        "formenctype",
        "formmethod",
        "formnovalidate",
        "formtarget",
        "height",
        "list",
        "max",
        "maxlength",
        "min",
        "minlength",
        "multiple",
        "name",
        "pattern",
        "placeholder",
        "popovertarget",
        "popovertargetaction",
        "size",
        "src",
        "step",
    ],
    "Ins": [
        "cite",
        "datetime",
    ],
    "Label": ["for"],
    "Li": [
        "value",
    ],
    "Link": [
        "href",
        "as_",
        "blocking",
        "crossorigin",
        "disabled",
        "fetchpriority",
        "hreflang",
        "imagesizes",
        "imagesrcset",
        "integrity",
        "media",
        "referrerpolicy",
        "rel",
        "sizes",
        "title",
        "type",
    ],
    "Map": [
        "name",
    ],
    "Marquee": [
        "behavior",
        "direction",
        "height",
        "width",
        "loop",
        "scrollamount",
        "scrolldelay",
        "truespeed",
        "vspace",
    ],
    "Menu": [
        "compact",
    ],
    "Meta": [
        "charset",
        "content",
        "http_equiv",
        "media",
        "name",
    ],
    "Meter": [
        "value",
        "min",
        "max",
        "low",
        "high",
        "optimum",
    ],
    "Object": [
        "archive",
        "border",
        "classidcodebase",
        "codetype",
        "data",
        "declare",
        "form",
        "height",
        "name",
        "standby",
        "type",
        "usemap",
        "width",
    ],
    "Ol": [
        "compact",
        "reversed",
        "start",
        "type",
    ],
    "Optgroup": [
        "disabled",
        "label",
    ],
    "Option": [
        "disabled",
        "label",
        "selected",
        "value",
    ],
    "Output": [
        "for_",
        "form",
        "name",
    ],
    "Pre": [
        "width",
        "wrap",
    ],
    "Progress": [
        "max",
        "value",
    ],
    "Q": [
        "cite",
    ],
    "Script": [
        "async",
        "attributionsrc",
        "blocking",
        "crossorigin",
        "defer",
        "fetchpriority",
        "integrity",
        "nomodule",
        "noncereferrerpolicy",
        "src",
        "type",
    ],
    "Select": [
        "autocomplete",
        "autofocus",
        "disabled",
        "form",
        "multiple",
        "name",
        "required",
        "size",
    ],
    "Slot": [
        "name",
    ],
    "Source": [
        "src",
        "type",
        "sizes",
        "media",
        "srcset",
        "height",
        "width",
    ],
    "Style": [
        "media",
        "nonce",
        "title",
        "blocking",
    ],
    "Td": [
        "colspan",
        "rowspan",
        "headers",
    ],
    "Template": [
        "shadowrootmode",
        "shadowrootdelegatesfocus",
        "shadowrootclonable",
        "shadowrootserializable",
    ],
    "Textarea": [
        "autocapitalize",
        "autocomplete",
        "autocorrect",
        "autofocus",
        "cols",
        "dirname",
        "disabled",
        "form",
        "maxlength",
        "minlength",
        "name",
        "placeholder",
        "readonly",
        "required",
        "rows",
        "spellcheck",
        "wrap",
    ],
    "Th": [
        "abbr",
        "colspan",
        "headers",
        "rowspan",
        "scope",
    ],
    "Time": [
        "datetime",
    ],
    "Track": [
        "default",
        "kind",
        "label",
        "srclang",
        "src",
    ],
    "Ul": [
        "compact",
        "type",
    ],
    "Video": [
        "src",
        "autoplay",
        "controls",
        "controlslist",
        "crossorigin",
        "disablepictureinpicture",
        "disableremoteplayback",
        "height",
        "width",
        "loop",
        "muted",
        "playsinline",
        "poster",
        "preload",
    ],
}
