ICD_CODES = [
    ('A000', 'Cholera due to Vibrio cholerae 01, biovar cholerae'),
    ('A001', 'Cholera due to Vibrio cholerae 01, biovar eltor'),
    ('A009', 'Cholera, unspecified'),
    ('A0100', 'Typhoid fever, unspecified'),
    ('A0101', 'Typhoid meningitis'),
    ('A0102', 'Typhoid fever with heart involvement'),
    ('A0103', 'Typhoid pneumonia'),
    ('A0104', 'Typhoid arthritis'),
    ('A0105', 'Typhoid osteomyelitis'),
    ('A0109', 'Typhoid fever with other complications'),
    ('A011', 'Paratyphoid fever A'),
    ('A012', 'Paratyphoid fever B'),
    ('A013', 'Paratyphoid fever C'),
    ('A014', 'Paratyphoid fever, unspecified'),
    ('A020', 'Salmonella enteritis'),
    ('A021', 'Salmonella sepsis'),
    ('A0220', 'Localized salmonella infection, unspecified'),
    ('A0221', 'Salmonella meningitis'),
    ('A0222', 'Salmonella pneumonia'),
    ('A0223', 'Salmonella arthritis'),
    ('A0224', 'Salmonella osteomyelitis'),
    ('A0225', 'Salmonella pyelonephritis'),
    ('A0229', 'Salmonella with other localized infection'),
    ('A028', 'Other specified salmonella infections'),
    ('A029', 'Salmonella infection, unspecified'),
    ('A030', 'Shigellosis due to Shigella dysenteriae'),
    ('A031', 'Shigellosis due to Shigella flexneri'),
    ('A032', 'Shigellosis due to Shigella boydii'),
    ('A033', 'Shigellosis due to Shigella sonnei'),
    ('A038', 'Other shigellosis'),
    ('A039', 'Shigellosis, unspecified'),
    ('A040', 'Enteropathogenic Escherichia coli infection'),
    ('A041', 'Enterotoxigenic Escherichia coli infection'),
    ('A042', 'Enteroinvasive Escherichia coli infection'),
    ('A043', 'Enterohemorrhagic Escherichia coli infection'),
    ('A044', 'Other intestinal Escherichia coli infections'),
    ('A045', 'Campylobacter enteritis'),
    ('A046', 'Enteritis due to Yersinia enterocolitica'),
    ('A047', 'Enterocolitis due to Clostridium difficile'),
    ('A0471', 'Enterocolitis due to Clostridium difficile, recurrent'),
    ('A0472', 'Enterocolitis d/t Clostridium difficile, not spcf as recur'),
    ('A048', 'Other specified bacterial intestinal infections'),
    ('A049', 'Bacterial intestinal infection, unspecified'),
    ('A050', 'Foodborne staphylococcal intoxication'),
    ('A051', 'Botulism food poisoning'),
    ('A052', 'Foodborne Clostridium perfringens intoxication'),
    ('A053', 'Foodborne Vibrio parahaemolyticus intoxication'),
    ('A054', 'Foodborne Bacillus cereus intoxication'),
    ('A055', 'Foodborne Vibrio vulnificus intoxication'),
    ('A058', 'Other specified bacterial foodborne intoxications'),
    ('A059', 'Bacterial foodborne intoxication, unspecified'),
    ('A060', 'Acute amebic dysentery'),
    ('A061', 'Chronic intestinal amebiasis'),
    ('A062', 'Amebic nondysenteric colitis'),
    ('A063', 'Ameboma of intestine'),
    ('A064', 'Amebic liver abscess'),
    ('A065', 'Amebic lung abscess'),
    ('A066', 'Amebic brain abscess'),
    ('A067', 'Cutaneous amebiasis'),
    ('A0681', 'Amebic cystitis'),
    ('A0682', 'Other amebic genitourinary infections'),
    ('A0689', 'Other amebic infections'),
    ('A069', 'Amebiasis, unspecified'),
    ('A070', 'Balantidiasis'),
    ('A071', 'Giardiasis [lambliasis]'),
    ('A072', 'Cryptosporidiosis'),
    ('A073', 'Isosporiasis'),
    ('A074', 'Cyclosporiasis'),
    ('A078', 'Other specified protozoal intestinal diseases'),
    ('A079', 'Protozoal intestinal disease, unspecified'),
    ('A080', 'Rotaviral enteritis'),
    ('A0811', 'Acute gastroenteropathy due to Norwalk agent'),
    ('A0819', 'Acute gastroenteropathy due to other small round viruses'),
    ('A082', 'Adenoviral enteritis'),
    ('A0831', 'Calicivirus enteritis'),
    ('A0832', 'Astrovirus enteritis'),
    ('A0839', 'Other viral enteritis'),
    ('A084', 'Viral intestinal infection, unspecified'),
    ('A088', 'Other specified intestinal infections'),
    ('A09', 'Infectious gastroenteritis and colitis, unspecified'),
    ('A150', 'Tuberculosis of lung'),
    ('A154', 'Tuberculosis of intrathoracic lymph nodes'),
    ('A155', 'Tuberculosis of larynx, trachea and bronchus'),
    ('A156', 'Tuberculous pleurisy'),
    ('A157', 'Primary respiratory tuberculosis'),
    ('A158', 'Other respiratory tuberculosis'),
    ('A159', 'Respiratory tuberculosis unspecified'),
    ('A170', 'Tuberculous meningitis'),
    ('A171', 'Meningeal tuberculoma'),
    ('A1781', 'Tuberculoma of brain and spinal cord'),
    ('A1782', 'Tuberculous meningoencephalitis'),
    ('A1783', 'Tuberculous neuritis'),
    ('A1789', 'Other tuberculosis of nervous system'),
    ('A179', 'Tuberculosis of nervous system, unspecified'),
    ('A1801', 'Tuberculosis of spine'),
    ('A1802', 'Tuberculous arthritis of other joints'),
    ('A1803', 'Tuberculosis of other bones'),
    ('A1809', 'Other musculoskeletal tuberculosis'),
    ('A1810', 'Tuberculosis of genitourinary system, unspecified'),
    ('A1811', 'Tuberculosis of kidney and ureter'),
    ('A1812', 'Tuberculosis of bladder'),
    ('A1813', 'Tuberculosis of other urinary organs'),
    ('A1814', 'Tuberculosis of prostate'),
    ('A1815', 'Tuberculosis of other male genital organs'),
    ('A1816', 'Tuberculosis of cervix'),
    ('A1817', 'Tuberculous female pelvic inflammatory disease'),
    ('A1818', 'Tuberculosis of other female genital organs'),
    ('A182', 'Tuberculous peripheral lymphadenopathy'),
    ('A1831', 'Tuberculous peritonitis'),
    ('A1832', 'Tuberculous enteritis'),
    ('A1839', 'Retroperitoneal tuberculosis'),
    ('A184', 'Tuberculosis of skin and subcutaneous tissue'),
    ('A1850', 'Tuberculosis of eye, unspecified'),
    ('A1851', 'Tuberculous episcleritis'),
    ('A1852', 'Tuberculous keratitis'),
    ('A1853', 'Tuberculous chorioretinitis'),
    ('A1854', 'Tuberculous iridocyclitis'),
    ('A1859', 'Other tuberculosis of eye'),
    ('A186', 'Tuberculosis of (inner) (middle) ear'),
    ('A187', 'Tuberculosis of adrenal glands'),
    ('A1881', 'Tuberculosis of thyroid gland'),
    ('A1882', 'Tuberculosis of other endocrine glands'),
    ('A1883', 'Tuberculosis of digestive tract organs, NEC'),
    ('A1884', 'Tuberculosis of heart'),
    ('A1885', 'Tuberculosis of spleen'),
    ('A1889', 'Tuberculosis of other sites'),
    ('A190', 'Acute miliary tuberculosis of a single specified site'),
    ('A191', 'Acute miliary tuberculosis of multiple sites'),
    ('A192', 'Acute miliary tuberculosis, unspecified'),
    ('A198', 'Other miliary tuberculosis'),
    ('A199', 'Miliary tuberculosis, unspecified'),
    ('A200', 'Bubonic plague'),
    ('A201', 'Cellulocutaneous plague'),
    ('A202', 'Pneumonic plague'),
    ('A203', 'Plague meningitis'),
    ('A207', 'Septicemic plague'),
    ('A208', 'Other forms of plague'),
    ('A209', 'Plague, unspecified'),
    ('A210', 'Ulceroglandular tularemia'),
    ('A211', 'Oculoglandular tularemia'),
    ('A212', 'Pulmonary tularemia'),
    ('A213', 'Gastrointestinal tularemia'),
    ('A217', 'Generalized tularemia'),
    ('A218', 'Other forms of tularemia'),
    ('A219', 'Tularemia, unspecified'),
    ('A220', 'Cutaneous anthrax'),
    ('A221', 'Pulmonary anthrax'),
    ('A222', 'Gastrointestinal anthrax'),
    ('A227', 'Anthrax sepsis'),
    ('A228', 'Other forms of anthrax'),
    ('A229', 'Anthrax, unspecified'),
    ('A230', 'Brucellosis due to Brucella melitensis'),
    ('A231', 'Brucellosis due to Brucella abortus'),
    ('A232', 'Brucellosis due to Brucella suis'),
    ('A233', 'Brucellosis due to Brucella canis'),
    ('A238', 'Other brucellosis'),
    ('A239', 'Brucellosis, unspecified'),
    ('A240', 'Glanders'),
    ('A241', 'Acute and fulminating melioidosis'),
    ('A242', 'Subacute and chronic melioidosis'),
    ('A243', 'Other melioidosis'),
    ('A249', 'Melioidosis, unspecified'),
    ('A250', 'Spirillosis'),
    ('A251', 'Streptobacillosis'),
    ('A259', 'Rat-bite fever, unspecified'),
    ('A260', 'Cutaneous erysipeloid'),
    ('A267', 'Erysipelothrix sepsis'),
    ('A268', 'Other forms of erysipeloid'),
    ('A269', 'Erysipeloid, unspecified'),
    ('A270', 'Leptospirosis icterohemorrhagica'),
    ('A2781', 'Aseptic meningitis in leptospirosis'),
    ('A2789', 'Other forms of leptospirosis'),
    ('A279', 'Leptospirosis, unspecified'),
    ('A280', 'Pasteurellosis'),
    ('A281', 'Cat-scratch disease'),
    ('A282', 'Extraintestinal yersiniosis'),
    ('A288', 'Oth zoonotic bacterial diseases, not elsewhere classified'),
    ('A289', 'Zoonotic bacterial disease, unspecified'),
    ('A300', 'Indeterminate leprosy'),
    ('A301', 'Tuberculoid leprosy'),
    ('A302', 'Borderline tuberculoid leprosy'),
    ('A303', 'Borderline leprosy'),
    ('A304', 'Borderline lepromatous leprosy'),
    ('A305', 'Lepromatous leprosy'),
    ('A308', 'Other forms of leprosy'),
    ('A309', 'Leprosy, unspecified'),
    ('A310', 'Pulmonary mycobacterial infection'),
    ('A311', 'Cutaneous mycobacterial infection'),
    ('A312', 'Dissem mycobacterium avium-intracellulare complex (DMAC)'),
    ('A318', 'Other mycobacterial infections'),
    ('A319', 'Mycobacterial infection, unspecified'),
    ('A320', 'Cutaneous listeriosis'),
    ('A3211', 'Listerial meningitis'),
    ('A3212', 'Listerial meningoencephalitis'),
    ('A327', 'Listerial sepsis'),
    ('A3281', 'Oculoglandular listeriosis'),
    ('A3282', 'Listerial endocarditis'),
    ('A3289', 'Other forms of listeriosis'),
    ('A329', 'Listeriosis, unspecified'),
    ('A33', 'Tetanus neonatorum'),
    ('A34', 'Obstetrical tetanus'),
    ('A35', 'Other tetanus'),
    ('A360', 'Pharyngeal diphtheria'),
    ('A361', 'Nasopharyngeal diphtheria'),
    ('A362', 'Laryngeal diphtheria'),
    ('A363', 'Cutaneous diphtheria'),
    ('A3681', 'Diphtheritic cardiomyopathy'),
    ('A3682', 'Diphtheritic radiculomyelitis'),
    ('A3683', 'Diphtheritic polyneuritis'),
    ('A3684', 'Diphtheritic tubulo-interstitial nephropathy'),
    ('A3685', 'Diphtheritic cystitis'),
    ('A3686', 'Diphtheritic conjunctivitis'),
    ('A3689', 'Other diphtheritic complications'),
    ('A369', 'Diphtheria, unspecified'),
    ('A3700', 'Whooping cough due to Bordetella pertussis without pneumonia'),
    ('A3701', 'Whooping cough due to Bordetella pertussis with pneumonia'),
    ('A3710', 'Whooping cough due to Bordetella parapertussis w/o pneumonia'),
    ('A3711', 'Whooping cough due to Bordetella parapertussis w pneumonia'),
    ('A3780', 'Whooping cough due to other Bordetella species w/o pneumonia'),
    ('A3781', 'Whooping cough due to oth Bordetella species with pneumonia'),
    ('A3790', 'Whooping cough, unspecified species without pneumonia'),
    ('A3791', 'Whooping cough, unspecified species with pneumonia'),
    ('A380', 'Scarlet fever with otitis media'),
    ('A381', 'Scarlet fever with myocarditis'),
    ('A388', 'Scarlet fever with other complications'),
    ('A389', 'Scarlet fever, uncomplicated'),
    ('A390', 'Meningococcal meningitis'),
    ('A391', 'Waterhouse-Friderichsen syndrome'),
    ('A392', 'Acute meningococcemia'),
    ('A393', 'Chronic meningococcemia'),
    ('A394', 'Meningococcemia, unspecified'),
    ('A3950', 'Meningococcal carditis, unspecified'),
    ('A3951', 'Meningococcal endocarditis'),
    ('A3952', 'Meningococcal myocarditis'),
    ('A3953', 'Meningococcal pericarditis'),
    ('A3981', 'Meningococcal encephalitis'),
    ('A3982', 'Meningococcal retrobulbar neuritis'),
    ('A3983', 'Meningococcal arthritis'),
    ('A3984', 'Postmeningococcal arthritis'),
    ('A3989', 'Other meningococcal infections'),
    ('A399', 'Meningococcal infection, unspecified'),
    ('A400', 'Sepsis due to streptococcus, group A'),
    ('A401', 'Sepsis due to streptococcus, group B'),
    ('A403', 'Sepsis due to Streptococcus pneumoniae'),
    ('A408', 'Other streptococcal sepsis'),
    ('A409', 'Streptococcal sepsis, unspecified'),
    ('A4101', 'Sepsis due to Methicillin susceptible Staphylococcus aureus'),
    ('A4102', 'Sepsis due to Methicillin resistant Staphylococcus aureus'),
    ('A411', 'Sepsis due to other specified staphylococcus'),
    ('A412', 'Sepsis due to unspecified staphylococcus'),
    ('A413', 'Sepsis due to Hemophilus influenzae'),
    ('A414', 'Sepsis due to anaerobes'),
    ('A4150', 'Gram-negative sepsis, unspecified'),
    ('A4151', 'Sepsis due to Escherichia coli [E. coli]'),
    ('A4152', 'Sepsis due to Pseudomonas'),
    ('A4153', 'Sepsis due to Serratia'),
    ('A4154', 'Sepsis due to Acinetobacter baumannii'),
    ('A4159', 'Other Gram-negative sepsis'),
    ('A4181', 'Sepsis due to Enterococcus'),
    ('A4189', 'Other specified sepsis'),
    ('A419', 'Sepsis, unspecified organism'),
    ('A420', 'Pulmonary actinomycosis'),
    ('A421', 'Abdominal actinomycosis'),
    ('A422', 'Cervicofacial actinomycosis'),
    ('A427', 'Actinomycotic sepsis'),
    ('A4281', 'Actinomycotic meningitis'),
    ('A4282', 'Actinomycotic encephalitis'),
    ('A4289', 'Other forms of actinomycosis'),
    ('A429', 'Actinomycosis, unspecified'),
    ('A430', 'Pulmonary nocardiosis'),
    ('A431', 'Cutaneous nocardiosis'),
    ('A438', 'Other forms of nocardiosis'),
    ('A439', 'Nocardiosis, unspecified'),
    ('A440', 'Systemic bartonellosis'),
    ('A441', 'Cutaneous and mucocutaneous bartonellosis'),
    ('A448', 'Other forms of bartonellosis'),
    ('A449', 'Bartonellosis, unspecified'),
    ('A46', 'Erysipelas'),
    ('A480', 'Gas gangrene'),
    ('A481', "Legionnaires' disease"),
    ('A482', "Nonpneumonic Legionnaires' disease [Pontiac fever]"),
    ('A483', 'Toxic shock syndrome'),
    ('A484', 'Brazilian purpuric fever'),
    ('A4851', 'Infant botulism'),
    ('A4852', 'Wound botulism'),
    ('A488', 'Other specified bacterial diseases'),
    ('A4901', 'Methicillin suscep staph infection, unsp site'),
    ('A4902', 'Methicillin resis staph infection, unsp site'),
    ('A491', 'Streptococcal infection, unspecified site'),
    ('A492', 'Hemophilus influenzae infection, unspecified site'),
    ('A493', 'Mycoplasma infection, unspecified site'),
    ('A498', 'Other bacterial infections of unspecified site'),
    ('A499', 'Bacterial infection, unspecified'),
    ('A5001', 'Early congenital syphilitic oculopathy'),
    ('A5002', 'Early congenital syphilitic osteochondropathy'),
    ('A5003', 'Early congenital syphilitic pharyngitis'),
    ('A5004', 'Early congenital syphilitic pneumonia'),
    ('A5005', 'Early congenital syphilitic rhinitis'),
    ('A5006', 'Early cutaneous congenital syphilis'),
    ('A5007', 'Early mucocutaneous congenital syphilis'),
    ('A5008', 'Early visceral congenital syphilis'),
    ('A5009', 'Other early congenital syphilis, symptomatic'),
    ('A501', 'Early congenital syphilis, latent'),
    ('A502', 'Early congenital syphilis, unspecified'),
    ('A5030', 'Late congenital syphilitic oculopathy, unspecified'),
    ('A5031', 'Late congenital syphilitic interstitial keratitis'),
    ('A5032', 'Late congenital syphilitic chorioretinitis'),
    ('A5039', 'Other late congenital syphilitic oculopathy'),
    ('A5040', 'Late congenital neurosyphilis, unspecified'),
    ('A5041', 'Late congenital syphilitic meningitis'),
    ('A5042', 'Late congenital syphilitic encephalitis'),
    ('A5043', 'Late congenital syphilitic polyneuropathy'),
    ('A5044', 'Late congenital syphilitic optic nerve atrophy'),
    ('A5045', 'Juvenile general paresis'),
    ('A5049', 'Other late congenital neurosyphilis'),
    ('A5051', "Clutton's joints"),
    ('A5052', "Hutchinson's teeth"),
    ('A5053', "Hutchinson's triad"),
    ('A5054', 'Late congenital cardiovascular syphilis'),
    ('A5055', 'Late congenital syphilitic arthropathy'),
    ('A5056', 'Late congenital syphilitic osteochondropathy'),
    ('A5057', 'Syphilitic saddle nose'),
    ('A5059', 'Other late congenital syphilis, symptomatic'),
    ('A506', 'Late congenital syphilis, latent'),
    ('A507', 'Late congenital syphilis, unspecified'),
    ('A509', 'Congenital syphilis, unspecified'),
    ('A510', 'Primary genital syphilis'),
    ('A511', 'Primary anal syphilis'),
    ('A512', 'Primary syphilis of other sites'),
    ('A5131', 'Condyloma latum'),
    ('A5132', 'Syphilitic alopecia'),
    ('A5139', 'Other secondary syphilis of skin'),
    ('A5141', 'Secondary syphilitic meningitis'),
    ('A5142', 'Secondary syphilitic female pelvic disease'),
    ('A5143', 'Secondary syphilitic oculopathy'),
    ('A5144', 'Secondary syphilitic nephritis'),
    ('A5145', 'Secondary syphilitic hepatitis'),
    ('A5146', 'Secondary syphilitic osteopathy'),
    ('A5149', 'Other secondary syphilitic conditions'),
    ('A515', 'Early syphilis, latent'),
    ('A519', 'Early syphilis, unspecified'),
    ('A5200', 'Cardiovascular syphilis, unspecified'),
    ('A5201', 'Syphilitic aneurysm of aorta'),
    ('A5202', 'Syphilitic aortitis'),
    ('A5203', 'Syphilitic endocarditis'),
    ('A5204', 'Syphilitic cerebral arteritis'),
    ('A5205', 'Other cerebrovascular syphilis'),
    ('A5206', 'Other syphilitic heart involvement'),
    ('A5209', 'Other cardiovascular syphilis'),
    ('A5210', 'Symptomatic neurosyphilis, unspecified'),
    ('A5211', 'Tabes dorsalis'),
    ('A5212', 'Other cerebrospinal syphilis'),
    ('A5213', 'Late syphilitic meningitis'),
    ('A5214', 'Late syphilitic encephalitis'),
    ('A5215', 'Late syphilitic neuropathy'),
    ('A5216', "Charcot's arthropathy (tabetic)"),
    ('A5217', 'General paresis'),
    ('A5219', 'Other symptomatic neurosyphilis'),
    ('A522', 'Asymptomatic neurosyphilis'),
    ('A523', 'Neurosyphilis, unspecified'),
    ('A5271', 'Late syphilitic oculopathy'),
    ('A5272', 'Syphilis of lung and bronchus'),
    ('A5273', 'Symptomatic late syphilis of other respiratory organs'),
    ('A5274', 'Syphilis of liver and other viscera'),
    ('A5275', 'Syphilis of kidney and ureter'),
    ('A5276', 'Other genitourinary symptomatic late syphilis'),
    ('A5277', 'Syphilis of bone and joint'),
    ('A5278', 'Syphilis of other musculoskeletal tissue'),
    ('A5279', 'Other symptomatic late syphilis'),
    ('A528', 'Late syphilis, latent'),
    ('A529', 'Late syphilis, unspecified'),
    ('A530', 'Latent syphilis, unspecified as early or late'),
    ('A539', 'Syphilis, unspecified'),
    ('A5400', 'Gonococcal infection of lower genitourinary tract, unsp'),
    ('A5401', 'Gonococcal cystitis and urethritis, unspecified'),
    ('A5402', 'Gonococcal vulvovaginitis, unspecified'),
    ('A5403', 'Gonococcal cervicitis, unspecified'),
    ('A5409', 'Other gonococcal infection of lower genitourinary tract'),
    ('A541', 'Gonocl infct of lower GU tract w periureth and acc glnd abcs'),
    ('A5421', 'Gonococcal infection of kidney and ureter'),
    ('A5422', 'Gonococcal prostatitis'),
    ('A5423', 'Gonococcal infection of other male genital organs'),
    ('A5424', 'Gonococcal female pelvic inflammatory disease'),
    ('A5429', 'Other gonococcal genitourinary infections'),
    ('A5430', 'Gonococcal infection of eye, unspecified'),
    ('A5431', 'Gonococcal conjunctivitis'),
    ('A5432', 'Gonococcal iridocyclitis'),
    ('A5433', 'Gonococcal keratitis'),
    ('A5439', 'Other gonococcal eye infection'),
    ('A5440', 'Gonococcal infection of musculoskeletal system, unspecified'),
    ('A5441', 'Gonococcal spondylopathy'),
    ('A5442', 'Gonococcal arthritis'),
    ('A5443', 'Gonococcal osteomyelitis'),
    ('A5449', 'Gonococcal infection of other musculoskeletal tissue'),
    ('A545', 'Gonococcal pharyngitis'),
    ('A546', 'Gonococcal infection of anus and rectum'),
    ('A5481', 'Gonococcal meningitis'),
    ('A5482', 'Gonococcal brain abscess'),
    ('A5483', 'Gonococcal heart infection'),
    ('A5484', 'Gonococcal pneumonia'),
    ('A5485', 'Gonococcal peritonitis'),
    ('A5486', 'Gonococcal sepsis'),
    ('A5489', 'Other gonococcal infections'),
    ('A549', 'Gonococcal infection, unspecified'),
    ('A55', 'Chlamydial lymphogranuloma (venereum)'),
    ('A5600', 'Chlamydial infection of lower genitourinary tract, unsp'),
    ('A5601', 'Chlamydial cystitis and urethritis'),
    ('A5602', 'Chlamydial vulvovaginitis'),
    ('A5609', 'Other chlamydial infection of lower genitourinary tract'),
    ('A5611', 'Chlamydial female pelvic inflammatory disease'),
    ('A5619', 'Other chlamydial genitourinary infection'),
    ('A562', 'Chlamydial infection of genitourinary tract, unspecified'),
    ('A563', 'Chlamydial infection of anus and rectum'),
    ('A564', 'Chlamydial infection of pharynx'),
    ('A568', 'Sexually transmitted chlamydial infection of other sites'),
    ('A57', 'Chancroid'),
    ('A58', 'Granuloma inguinale'),
    ('A5900', 'Urogenital trichomoniasis, unspecified'),
    ('A5901', 'Trichomonal vulvovaginitis'),
    ('A5902', 'Trichomonal prostatitis'),
    ('A5903', 'Trichomonal cystitis and urethritis'),
    ('A5909', 'Other urogenital trichomoniasis'),
    ('A598', 'Trichomoniasis of other sites'),
    ('A599', 'Trichomoniasis, unspecified'),
    ('A6000', 'Herpesviral infection of urogenital system, unspecified'),
    ('A6001', 'Herpesviral infection of penis'),
    ('A6002', 'Herpesviral infection of other male genital organs'),
    ('A6003', 'Herpesviral cervicitis'),
    ('A6004', 'Herpesviral vulvovaginitis'),
    ('A6009', 'Herpesviral infection of other urogenital tract'),
    ('A601', 'Herpesviral infection of perianal skin and rectum'),
    ('A609', 'Anogenital herpesviral infection, unspecified'),
    ('A630', 'Anogenital (venereal) warts'),
    ('A638', 'Other specified predominantly sexually transmitted diseases'),
    ('A64', 'Unspecified sexually transmitted disease'),
    ('A65', 'Nonvenereal syphilis'),
    ('A660', 'Initial lesions of yaws'),
    ('A661', 'Multiple papillomata and wet crab yaws'),
    ('A662', 'Other early skin lesions of yaws'),
    ('A663', 'Hyperkeratosis of yaws'),
    ('A664', 'Gummata and ulcers of yaws'),
    ('A665', 'Gangosa'),
    ('A666', 'Bone and joint lesions of yaws'),
    ('A667', 'Other manifestations of yaws'),
    ('A668', 'Latent yaws'),
    ('A669', 'Yaws, unspecified'),
    ('A670', 'Primary lesions of pinta'),
    ('A671', 'Intermediate lesions of pinta'),
    ('A672', 'Late lesions of pinta'),
    ('A673', 'Mixed lesions of pinta'),
    ('A679', 'Pinta, unspecified'),
    ('A680', 'Louse-borne relapsing fever'),
    ('A681', 'Tick-borne relapsing fever'),
    ('A689', 'Relapsing fever, unspecified'),
    ('A690', 'Necrotizing ulcerative stomatitis'),
    ('A691', "Other Vincent's infections"),
    ('A6920', 'Lyme disease, unspecified'),
    ('A6921', 'Meningitis due to Lyme disease'),
    ('A6922', 'Other neurologic disorders in Lyme disease'),
    ('A6923', 'Arthritis due to Lyme disease'),
    ('A6929', 'Other conditions associated with Lyme disease'),
    ('A698', 'Other specified spirochetal infections'),
    ('A699', 'Spirochetal infection, unspecified'),
    ('A70', 'Chlamydia psittaci infections'),
    ('A710', 'Initial stage of trachoma'),
    ('A711', 'Active stage of trachoma'),
    ('A719', 'Trachoma, unspecified'),
    ('A740', 'Chlamydial conjunctivitis'),
    ('A7481', 'Chlamydial peritonitis'),
    ('A7489', 'Other chlamydial diseases'),
    ('A749', 'Chlamydial infection, unspecified'),
    ('A750', 'Epidemic louse-borne typhus fever d/t Rickettsia prowazekii'),
    ('A751', "Recrudescent typhus [Brill's disease]"),
    ('A752', 'Typhus fever due to Rickettsia typhi'),
    ('A753', 'Typhus fever due to Rickettsia tsutsugamushi'),
    ('A759', 'Typhus fever, unspecified'),
    ('A770', 'Spotted fever due to Rickettsia rickettsii'),
    ('A771', 'Spotted fever due to Rickettsia conorii'),
    ('A772', 'Spotted fever due to Rickettsia siberica'),
    ('A773', 'Spotted fever due to Rickettsia australis'),
    ('A7740', 'Ehrlichiosis, unspecified'),
    ('A7741', 'Ehrlichiosis chafeensis [E. chafeensis]'),
    ('A7749', 'Other ehrlichiosis'),
    ('A778', 'Other spotted fevers'),
    ('A779', 'Spotted fever, unspecified'),
    ('A78', 'Q fever'),
    ('A790', 'Trench fever'),
    ('A791', 'Rickettsialpox due to Rickettsia akari'),
    ('A7981', 'Rickettsiosis due to Ehrlichia sennetsu'),
    ('A7982', 'Anaplasmosis [A. phagocytophilum]'),
    ('A7989', 'Other specified rickettsioses'),
    ('A799', 'Rickettsiosis, unspecified'),
    ('A800', 'Acute paralytic poliomyelitis, vaccine-associated'),
    ('A801', 'Acute paralytic poliomyelitis, wild virus, imported'),
    ('A802', 'Acute paralytic poliomyelitis, wild virus, indigenous'),
    ('A8030', 'Acute paralytic poliomyelitis, unspecified'),
    ('A8039', 'Other acute paralytic poliomyelitis'),
    ('A804', 'Acute nonparalytic poliomyelitis'),
    ('A809', 'Acute poliomyelitis, unspecified'),
    ('A8100', 'Creutzfeldt-Jakob disease, unspecified'),
    ('A8101', 'Variant Creutzfeldt-Jakob disease'),
    ('A8109', 'Other Creutzfeldt-Jakob disease'),
    ('A811', 'Subacute sclerosing panencephalitis'),
    ('A812', 'Progressive multifocal leukoencephalopathy'),
    ('A8181', 'Kuru'),
    ('A8182', 'Gerstmann-Straussler-Scheinker syndrome'),
    ('A8183', 'Fatal familial insomnia'),
    ('A8189', 'Other atypical virus infections of central nervous system'),
    ('A819', 'Atypical virus infection of central nervous system, unsp'),
    ('A820', 'Sylvatic rabies'),
    ('A821', 'Urban rabies'),
    ('A829', 'Rabies, unspecified'),
    ('A830', 'Japanese encephalitis'),
    ('A831', 'Western equine encephalitis'),
    ('A832', 'Eastern equine encephalitis'),
    ('A833', 'St Louis encephalitis'),
    ('A834', 'Australian encephalitis'),
    ('A835', 'California encephalitis'),
    ('A836', 'Rocio virus disease'),
    ('A838', 'Other mosquito-borne viral encephalitis'),
    ('A839', 'Mosquito-borne viral encephalitis, unspecified'),
    ('A840', 'Far Eastern tick-borne encephalitis'),
    ('A841', 'Central European tick-borne encephalitis'),
    ('A848', 'Other tick-borne viral encephalitis'),
    ('A8481', 'Powassan virus disease'),
    ('A8489', 'Other tick-borne viral encephalitis'),
    ('A849', 'Tick-borne viral encephalitis, unspecified'),
    ('A850', 'Enteroviral encephalitis'),
    ('A851', 'Adenoviral encephalitis'),
    ('A852', 'Arthropod-borne viral encephalitis, unspecified'),
    ('A858', 'Other specified viral encephalitis'),
    ('A86', 'Unspecified viral encephalitis'),
    ('A870', 'Enteroviral meningitis'),
    ('A871', 'Adenoviral meningitis'),
    ('A872', 'Lymphocytic choriomeningitis'),
    ('A878', 'Other viral meningitis'),
    ('A879', 'Viral meningitis, unspecified'),
    ('A880', 'Enteroviral exanthematous fever [Boston exanthem]'),
    ('A881', 'Epidemic vertigo'),
    ('A888', 'Other specified viral infections of central nervous system'),
    ('A89', 'Unspecified viral infection of central nervous system'),
    ('A90', 'Dengue fever [classical dengue]'),
    ('A91', 'Dengue hemorrhagic fever'),
    ('A920', 'Chikungunya virus disease'),
    ('A921', "O'nyong-nyong fever"),
    ('A922', 'Venezuelan equine fever'),
    ('A9230', 'West Nile virus infection, unspecified'),
    ('A9231', 'West Nile virus infection with encephalitis'),
    ('A9232', 'West Nile virus infection with oth neurologic manifestation'),
    ('A9239', 'West Nile virus infection with other complications'),
    ('A924', 'Rift Valley fever'),
    ('A925', 'Zika virus disease'),
    ('A928', 'Other specified mosquito-borne viral fevers'),
    ('A929', 'Mosquito-borne viral fever, unspecified'),
    ('A930', 'Oropouche virus disease'),
    ('A931', 'Sandfly fever'),
    ('A932', 'Colorado tick fever'),
    ('A938', 'Other specified arthropod-borne viral fevers'),
    ('A94', 'Unspecified arthropod-borne viral fever'),
    ('A950', 'Sylvatic yellow fever'),
    ('A951', 'Urban yellow fever'),
    ('A959', 'Yellow fever, unspecified'),
    ('A960', 'Junin hemorrhagic fever'),
    ('A961', 'Machupo hemorrhagic fever'),
    ('A962', 'Lassa fever'),
    ('A968', 'Other arenaviral hemorrhagic fevers'),
    ('A969', 'Arenaviral hemorrhagic fever, unspecified'),
    ('A980', 'Crimean-Congo hemorrhagic fever'),
    ('A981', 'Omsk hemorrhagic fever'),
    ('A982', 'Kyasanur Forest disease'),
    ('A983', 'Marburg virus disease'),
    ('A984', 'Ebola virus disease'),
    ('A985', 'Hemorrhagic fever with renal syndrome'),
    ('A988', 'Other specified viral hemorrhagic fevers'),
    ('A99', 'Unspecified viral hemorrhagic fever'),
    ('B000', 'Eczema herpeticum'),
    ('B001', 'Herpesviral vesicular dermatitis'),
    ('B002', 'Herpesviral gingivostomatitis and pharyngotonsillitis'),
    ('B003', 'Herpesviral meningitis'),
    ('B004', 'Herpesviral encephalitis'),
    ('B0050', 'Herpesviral ocular disease, unspecified'),
    ('B0051', 'Herpesviral iridocyclitis'),
    ('B0052', 'Herpesviral keratitis'),
    ('B0053', 'Herpesviral conjunctivitis'),
    ('B0059', 'Other herpesviral disease of eye'),
    ('B007', 'Disseminated herpesviral disease'),
    ('B0081', 'Herpesviral hepatitis'),
    ('B0082', 'Herpes simplex myelitis'),
    ('B0089', 'Other herpesviral infection'),
    ('B009', 'Herpesviral infection, unspecified'),
    ('B010', 'Varicella meningitis'),
    ('B0111', 'Varicella encephalitis and encephalomyelitis'),
    ('B0112', 'Varicella myelitis'),
    ('B012', 'Varicella pneumonia'),
    ('B0181', 'Varicella keratitis'),
    ('B0189', 'Other varicella complications'),
    ('B019', 'Varicella without complication'),
    ('B020', 'Zoster encephalitis'),
    ('B021', 'Zoster meningitis'),
    ('B0221', 'Postherpetic geniculate ganglionitis'),
    ('B0222', 'Postherpetic trigeminal neuralgia'),
    ('B0223', 'Postherpetic polyneuropathy'),
    ('B0224', 'Postherpetic myelitis'),
    ('B0229', 'Other postherpetic nervous system involvement'),
    ('B0230', 'Zoster ocular disease, unspecified'),
    ('B0231', 'Zoster conjunctivitis'),
    ('B0232', 'Zoster iridocyclitis'),
    ('B0233', 'Zoster keratitis'),
    ('B0234', 'Zoster scleritis'),
    ('B0239', 'Other herpes zoster eye disease'),
    ('B027', 'Disseminated zoster'),
    ('B028', 'Zoster with other complications'),
    ('B029', 'Zoster without complications'),
    ('B03', 'Smallpox'),
    ('B04', 'Monkeypox'),
    ('B050', 'Measles complicated by encephalitis'),
    ('B051', 'Measles complicated by meningitis'),
    ('B052', 'Measles complicated by pneumonia'),
    ('B053', 'Measles complicated by otitis media'),
    ('B054', 'Measles with intestinal complications'),
    ('B0581', 'Measles keratitis and keratoconjunctivitis'),
    ('B0589', 'Other measles complications'),
    ('B059', 'Measles without complication'),
    ('B0600', 'Rubella with neurological complication, unspecified'),
    ('B0601', 'Rubella encephalitis'),
    ('B0602', 'Rubella meningitis'),
    ('B0609', 'Other neurological complications of rubella'),
    ('B0681', 'Rubella pneumonia'),
    ('B0682', 'Rubella arthritis'),
    ('B0689', 'Other rubella complications'),
    ('B069', 'Rubella without complication'),
    ('B070', 'Plantar wart'),
    ('B078', 'Other viral warts'),
    ('B079', 'Viral wart, unspecified'),
    ('B08010', 'Cowpox'),
    ('B08011', 'Vaccinia not from vaccine'),
    ('B0802', 'Orf virus disease'),
    ('B0803', "Pseudocowpox [milker's node]"),
    ('B0804', 'Paravaccinia, unspecified'),
    ('B0809', 'Other orthopoxvirus infections'),
    ('B081', 'Molluscum contagiosum'),
    ('B0820', 'Exanthema subitum [sixth disease], unspecified'),
    ('B0821', 'Exanthema subitum [sixth disease] due to human herpesvirus 6'),
    ('B0822', 'Exanthema subitum [sixth disease] due to human herpesvirus 7'),
    ('B083', 'Erythema infectiosum [fifth disease]'),
    ('B084', 'Enteroviral vesicular stomatitis with exanthem'),
    ('B085', 'Enteroviral vesicular pharyngitis'),
    ('B0860', 'Parapoxvirus infection, unspecified'),
    ('B0861', 'Bovine stomatitis'),
    ('B0862', 'Sealpox'),
    ('B0869', 'Other parapoxvirus infections'),
    ('B0870', 'Yatapoxvirus infection, unspecified'),
    ('B0871', 'Tanapox virus disease'),
    ('B0872', 'Yaba pox virus disease'),
    ('B0879', 'Other yatapoxvirus infections'),
    ('B088', 'Oth viral infections with skin and mucous membrane lesions'),
    ('B09', 'Unsp viral infection with skin and mucous membrane lesions'),
    ('B1001', 'Human herpesvirus 6 encephalitis'),
    ('B1009', 'Other human herpesvirus encephalitis'),
    ('B1081', 'Human herpesvirus 6 infection'),
    ('B1082', 'Human herpesvirus 7 infection'),
    ('B1089', 'Other human herpesvirus infection'),
    ('B150', 'Hepatitis A with hepatic coma'),
    ('B159', 'Hepatitis A without hepatic coma'),
    ('B160', 'Acute hepatitis B with delta-agent with hepatic coma'),
    ('B161', 'Acute hepatitis B with delta-agent without hepatic coma'),
    ('B162', 'Acute hepatitis B without delta-agent with hepatic coma'),
    ('B169', 'Acute hepatitis B w/o delta-agent and without hepatic coma'),
    ('B170', 'Acute delta-(super) infection of hepatitis B carrier'),
    ('B1710', 'Acute hepatitis C without hepatic coma'),
    ('B1711', 'Acute hepatitis C with hepatic coma'),
    ('B172', 'Acute hepatitis E'),
    ('B178', 'Other specified acute viral hepatitis'),
    ('B179', 'Acute viral hepatitis, unspecified'),
    ('B180', 'Chronic viral hepatitis B with delta-agent'),
    ('B181', 'Chronic viral hepatitis B without delta-agent'),
    ('B182', 'Chronic viral hepatitis C'),
    ('B188', 'Other chronic viral hepatitis'),
    ('B189', 'Chronic viral hepatitis, unspecified'),
    ('B190', 'Unspecified viral hepatitis with hepatic coma'),
    ('B1910', 'Unspecified viral hepatitis B without hepatic coma'),
    ('B1911', 'Unspecified viral hepatitis B with hepatic coma'),
    ('B1920', 'Unspecified viral hepatitis C without hepatic coma'),
    ('B1921', 'Unspecified viral hepatitis C with hepatic coma'),
    ('B199', 'Unspecified viral hepatitis without hepatic coma'),
    ('B20', 'Human immunodeficiency virus [HIV] disease'),
    ('B250', 'Cytomegaloviral pneumonitis'),
    ('B251', 'Cytomegaloviral hepatitis'),
    ('B252', 'Cytomegaloviral pancreatitis'),
    ('B258', 'Other cytomegaloviral diseases'),
    ('B259', 'Cytomegaloviral disease, unspecified'),
    ('B260', 'Mumps orchitis'),
    ('B261', 'Mumps meningitis'),
    ('B262', 'Mumps encephalitis'),
    ('B263', 'Mumps pancreatitis'),
    ('B2681', 'Mumps hepatitis'),
    ('B2682', 'Mumps myocarditis'),
    ('B2683', 'Mumps nephritis'),
    ('B2684', 'Mumps polyneuropathy'),
    ('B2685', 'Mumps arthritis'),
    ('B2689', 'Other mumps complications'),
    ('B269', 'Mumps without complication'),
    ('B2700', 'Gammaherpesviral mononucleosis without complication'),
    ('B2701', 'Gammaherpesviral mononucleosis with polyneuropathy'),
    ('B2702', 'Gammaherpesviral mononucleosis with meningitis'),
    ('B2709', 'Gammaherpesviral mononucleosis with other complications'),
    ('B2710', 'Cytomegaloviral mononucleosis without complications'),
    ('B2711', 'Cytomegaloviral mononucleosis with polyneuropathy'),
    ('B2712', 'Cytomegaloviral mononucleosis with meningitis'),
    ('B2719', 'Cytomegaloviral mononucleosis with other complication'),
    ('B2780', 'Other infectious mononucleosis without complication'),
    ('B2781', 'Other infectious mononucleosis with polyneuropathy'),
    ('B2782', 'Other infectious mononucleosis with meningitis'),
    ('B2789', 'Other infectious mononucleosis with other complication'),
    ('B2790', 'Infectious mononucleosis, unspecified without complication'),
    ('B2791', 'Infectious mononucleosis, unspecified with polyneuropathy'),
    ('B2792', 'Infectious mononucleosis, unspecified with meningitis'),
    ('B2799', 'Infectious mononucleosis, unsp with other complication'),
    ('B300', 'Keratoconjunctivitis due to adenovirus'),
    ('B301', 'Conjunctivitis due to adenovirus'),
    ('B302', 'Viral pharyngoconjunctivitis'),
    ('B303', 'Acute epidemic hemorrhagic conjunctivitis (enteroviral)'),
    ('B308', 'Other viral conjunctivitis'),
    ('B309', 'Viral conjunctivitis, unspecified'),
    ('B330', 'Epidemic myalgia'),
    ('B331', 'Ross River disease'),
    ('B3320', 'Viral carditis, unspecified'),
    ('B3321', 'Viral endocarditis'),
    ('B3322', 'Viral myocarditis'),
    ('B3323', 'Viral pericarditis'),
    ('B3324', 'Viral cardiomyopathy'),
    ('B333', 'Retrovirus infections, not elsewhere classified'),
    ('B334', 'Hantavirus (cardio)-pulmonary syndrome [HPS] [HCPS]'),
    ('B338', 'Other specified viral diseases'),
    ('B340', 'Adenovirus infection, unspecified'),
    ('B341', 'Enterovirus infection, unspecified'),
    ('B342', 'Coronavirus infection, unspecified'),
    ('B343', 'Parvovirus infection, unspecified'),
    ('B344', 'Papovavirus infection, unspecified'),
    ('B348', 'Other viral infections of unspecified site'),
    ('B349', 'Viral infection, unspecified'),
    ('B350', 'Tinea barbae and tinea capitis'),
    ('B351', 'Tinea unguium'),
    ('B352', 'Tinea manuum'),
    ('B353', 'Tinea pedis'),
    ('B354', 'Tinea corporis'),
    ('B355', 'Tinea imbricata'),
    ('B356', 'Tinea cruris'),
    ('B358', 'Other dermatophytoses'),
    ('B359', 'Dermatophytosis, unspecified'),
    ('B360', 'Pityriasis versicolor'),
    ('B361', 'Tinea nigra'),
    ('B362', 'White piedra'),
    ('B363', 'Black piedra'),
    ('B368', 'Other specified superficial mycoses'),
    ('B369', 'Superficial mycosis, unspecified'),
    ('B370', 'Candidal stomatitis'),
    ('B371', 'Pulmonary candidiasis'),
    ('B372', 'Candidiasis of skin and nail'),
    ('B373', 'Candidiasis of vulva and vagina'),
    ('B3731', 'Acute candidiasis of vulva and vagina'),
    ('B3732', 'Chronic candidiasis of vulva and vagina'),
    ('B3741', 'Candidal cystitis and urethritis'),
    ('B3742', 'Candidal balanitis'),
    ('B3749', 'Other urogenital candidiasis'),
    ('B375', 'Candidal meningitis'),
    ('B376', 'Candidal endocarditis'),
    ('B377', 'Candidal sepsis'),
    ('B3781', 'Candidal esophagitis'),
    ('B3782', 'Candidal enteritis'),
    ('B3783', 'Candidal cheilitis'),
    ('B3784', 'Candidal otitis externa'),
    ('B3789', 'Other sites of candidiasis'),
    ('B379', 'Candidiasis, unspecified'),
    ('B380', 'Acute pulmonary coccidioidomycosis'),
    ('B381', 'Chronic pulmonary coccidioidomycosis'),
    ('B382', 'Pulmonary coccidioidomycosis, unspecified'),
    ('B383', 'Cutaneous coccidioidomycosis'),
    ('B384', 'Coccidioidomycosis meningitis'),
    ('B387', 'Disseminated coccidioidomycosis'),
    ('B3881', 'Prostatic coccidioidomycosis'),
    ('B3889', 'Other forms of coccidioidomycosis'),
    ('B389', 'Coccidioidomycosis, unspecified'),
    ('B390', 'Acute pulmonary histoplasmosis capsulati'),
    ('B391', 'Chronic pulmonary histoplasmosis capsulati'),
    ('B392', 'Pulmonary histoplasmosis capsulati, unspecified'),
    ('B393', 'Disseminated histoplasmosis capsulati'),
    ('B394', 'Histoplasmosis capsulati, unspecified'),
    ('B395', 'Histoplasmosis duboisii'),
    ('B399', 'Histoplasmosis, unspecified'),
    ('B400', 'Acute pulmonary blastomycosis'),
    ('B401', 'Chronic pulmonary blastomycosis'),
    ('B402', 'Pulmonary blastomycosis, unspecified'),
    ('B403', 'Cutaneous blastomycosis'),
    ('B407', 'Disseminated blastomycosis'),
    ('B4081', 'Blastomycotic meningoencephalitis'),
    ('B4089', 'Other forms of blastomycosis'),
    ('B409', 'Blastomycosis, unspecified'),
    ('B410', 'Pulmonary paracoccidioidomycosis'),
    ('B417', 'Disseminated paracoccidioidomycosis'),
    ('B418', 'Other forms of paracoccidioidomycosis'),
    ('B419', 'Paracoccidioidomycosis, unspecified'),
    ('B420', 'Pulmonary sporotrichosis'),
    ('B421', 'Lymphocutaneous sporotrichosis'),
    ('B427', 'Disseminated sporotrichosis'),
    ('B4281', 'Cerebral sporotrichosis'),
    ('B4282', 'Sporotrichosis arthritis'),
    ('B4289', 'Other forms of sporotrichosis'),
    ('B429', 'Sporotrichosis, unspecified'),
    ('B430', 'Cutaneous chromomycosis'),
    ('B431', 'Pheomycotic brain abscess'),
    ('B432', 'Subcutaneous pheomycotic abscess and cyst'),
    ('B438', 'Other forms of chromomycosis'),
    ('B439', 'Chromomycosis, unspecified'),
    ('B440', 'Invasive pulmonary aspergillosis'),
    ('B441', 'Other pulmonary aspergillosis'),
    ('B442', 'Tonsillar aspergillosis'),
    ('B447', 'Disseminated aspergillosis'),
    ('B4481', 'Allergic bronchopulmonary aspergillosis'),
    ('B4489', 'Other forms of aspergillosis'),
    ('B449', 'Aspergillosis, unspecified'),
    ('B450', 'Pulmonary cryptococcosis'),
    ('B451', 'Cerebral cryptococcosis'),
    ('B452', 'Cutaneous cryptococcosis'),
    ('B453', 'Osseous cryptococcosis'),
    ('B457', 'Disseminated cryptococcosis'),
    ('B458', 'Other forms of cryptococcosis'),
    ('B459', 'Cryptococcosis, unspecified'),
    ('B460', 'Pulmonary mucormycosis'),
    ('B461', 'Rhinocerebral mucormycosis'),
    ('B462', 'Gastrointestinal mucormycosis'),
    ('B463', 'Cutaneous mucormycosis'),
    ('B464', 'Disseminated mucormycosis'),
    ('B465', 'Mucormycosis, unspecified'),
    ('B468', 'Other zygomycoses'),
    ('B469', 'Zygomycosis, unspecified'),
    ('B470', 'Eumycetoma'),
    ('B471', 'Actinomycetoma'),
    ('B479', 'Mycetoma, unspecified'),
    ('B480', 'Lobomycosis'),
    ('B481', 'Rhinosporidiosis'),
    ('B482', 'Allescheriasis'),
    ('B483', 'Geotrichosis'),
    ('B484', 'Penicillosis'),
    ('B488', 'Other specified mycoses'),
    ('B49', 'Unspecified mycosis'),
    ('B500', 'Plasmodium falciparum malaria with cerebral complications'),
    ('B508', 'Other severe and complicated Plasmodium falciparum malaria'),
    ('B509', 'Plasmodium falciparum malaria, unspecified'),
    ('B510', 'Plasmodium vivax malaria with rupture of spleen'),
    ('B518', 'Plasmodium vivax malaria with other complications'),
    ('B519', 'Plasmodium vivax malaria without complication'),
    ('B520', 'Plasmodium malariae malaria with nephropathy'),
    ('B528', 'Plasmodium malariae malaria with other complications'),
    ('B529', 'Plasmodium malariae malaria without complication'),
    ('B530', 'Plasmodium ovale malaria'),
    ('B531', 'Malaria due to simian plasmodia'),
    ('B538', 'Other malaria, not elsewhere classified'),
    ('B54', 'Unspecified malaria'),
    ('B550', 'Visceral leishmaniasis'),
    ('B551', 'Cutaneous leishmaniasis'),
    ('B552', 'Mucocutaneous leishmaniasis'),
    ('B559', 'Leishmaniasis, unspecified'),
    ('B560', 'Gambiense trypanosomiasis'),
    ('B561', 'Rhodesiense trypanosomiasis'),
    ('B569', 'African trypanosomiasis, unspecified'),
    ('B570', "Acute Chagas' disease with heart involvement"),
    ('B571', "Acute Chagas' disease without heart involvement"),
    ('B572', "Chagas' disease (chronic) with heart involvement"),
    ('B5730', "Chagas' disease with digestive system involvement, unsp"),
    ('B5731', "Megaesophagus in Chagas' disease"),
    ('B5732', "Megacolon in Chagas' disease"),
    ('B5739', "Other digestive system involvement in Chagas' disease"),
    ('B5740', "Chagas' disease with nervous system involvement, unspecified"),
    ('B5741', "Meningitis in Chagas' disease"),
    ('B5742', "Meningoencephalitis in Chagas' disease"),
    ('B5749', "Other nervous system involvement in Chagas' disease"),
    ('B575', "Chagas' disease (chronic) with other organ involvement"),
    ('B5800', 'Toxoplasma oculopathy, unspecified'),
    ('B5801', 'Toxoplasma chorioretinitis'),
    ('B5809', 'Other toxoplasma oculopathy'),
    ('B581', 'Toxoplasma hepatitis'),
    ('B582', 'Toxoplasma meningoencephalitis'),
    ('B583', 'Pulmonary toxoplasmosis'),
    ('B5881', 'Toxoplasma myocarditis'),
    ('B5882', 'Toxoplasma myositis'),
    ('B5883', 'Toxoplasma tubulo-interstitial nephropathy'),
    ('B5889', 'Toxoplasmosis with other organ involvement'),
    ('B589', 'Toxoplasmosis, unspecified'),
    ('B59', 'Pneumocystosis'),
    ('B600', 'Babesiosis'),
    ('B6000', 'Babesiosis, unspecified'),
    ('B6001', 'Babesiosis due to Babesia microti  '),
    ('B6002', 'Babesiosis due to Babesia duncani'),
    ('B6003', 'Babesiosis due to Babesia divergens '),
    ('B6009', 'Other babesiosis'),
    ('B6010', 'Acanthamebiasis, unspecified'),
    ('B6011', 'Meningoencephalitis due to Acanthamoeba (culbertsoni)'),
    ('B6012', 'Conjunctivitis due to Acanthamoeba'),
    ('B6013', 'Keratoconjunctivitis due to Acanthamoeba'),
    ('B6019', 'Other acanthamebic disease'),
    ('B602', 'Naegleriasis'),
    ('B608', 'Other specified protozoal diseases'),
    ('B64', 'Unspecified protozoal disease'),
    ('B650', 'Schistosomiasis due to Schistosoma haematobium'),
    ('B651', 'Schistosomiasis due to Schistosoma mansoni'),
    ('B652', 'Schistosomiasis due to Schistosoma japonicum'),
    ('B653', 'Cercarial dermatitis'),
    ('B658', 'Other schistosomiasis'),
    ('B659', 'Schistosomiasis, unspecified'),
    ('B660', 'Opisthorchiasis'),
    ('B661', 'Clonorchiasis'),
    ('B662', 'Dicroceliasis'),
    ('B663', 'Fascioliasis'),
    ('B664', 'Paragonimiasis'),
    ('B665', 'Fasciolopsiasis'),
    ('B668', 'Other specified fluke infections'),
    ('B669', 'Fluke infection, unspecified'),
    ('B670', 'Echinococcus granulosus infection of liver'),
    ('B671', 'Echinococcus granulosus infection of lung'),
    ('B672', 'Echinococcus granulosus infection of bone'),
    ('B6731', 'Echinococcus granulosus infection, thyroid gland'),
    ('B6732', 'Echinococcus granulosus infection, multiple sites'),
    ('B6739', 'Echinococcus granulosus infection, other sites'),
    ('B674', 'Echinococcus granulosus infection, unspecified'),
    ('B675', 'Echinococcus multilocularis infection of liver'),
    ('B6761', 'Echinococcus multilocularis infection, multiple sites'),
    ('B6769', 'Echinococcus multilocularis infection, other sites'),
    ('B677', 'Echinococcus multilocularis infection, unspecified'),
    ('B678', 'Echinococcosis, unspecified, of liver'),
    ('B6790', 'Echinococcosis, unspecified'),
    ('B6799', 'Other echinococcosis'),
    ('B680', 'Taenia solium taeniasis'),
    ('B681', 'Taenia saginata taeniasis'),
    ('B689', 'Taeniasis, unspecified'),
    ('B690', 'Cysticercosis of central nervous system'),
    ('B691', 'Cysticercosis of eye'),
    ('B6981', 'Myositis in cysticercosis'),
    ('B6989', 'Cysticercosis of other sites'),
    ('B699', 'Cysticercosis, unspecified'),
    ('B700', 'Diphyllobothriasis'),
    ('B701', 'Sparganosis'),
    ('B710', 'Hymenolepiasis'),
    ('B711', 'Dipylidiasis'),
    ('B718', 'Other specified cestode infections'),
    ('B719', 'Cestode infection, unspecified'),
    ('B72', 'Dracunculiasis'),
    ('B7300', 'Onchocerciasis with eye involvement, unspecified'),
    ('B7301', 'Onchocerciasis with endophthalmitis'),
    ('B7302', 'Onchocerciasis with glaucoma'),
    ('B7309', 'Onchocerciasis with other eye involvement'),
    ('B731', 'Onchocerciasis without eye disease'),
    ('B740', 'Filariasis due to Wuchereria bancrofti'),
    ('B741', 'Filariasis due to Brugia malayi'),
    ('B742', 'Filariasis due to Brugia timori'),
    ('B743', 'Loiasis'),
    ('B744', 'Mansonelliasis'),
    ('B748', 'Other filariases'),
    ('B749', 'Filariasis, unspecified'),
    ('B75', 'Trichinellosis'),
    ('B760', 'Ancylostomiasis'),
    ('B761', 'Necatoriasis'),
    ('B768', 'Other hookworm diseases'),
    ('B769', 'Hookworm disease, unspecified'),
    ('B770', 'Ascariasis with intestinal complications'),
    ('B7781', 'Ascariasis pneumonia'),
    ('B7789', 'Ascariasis with other complications'),
    ('B779', 'Ascariasis, unspecified'),
    ('B780', 'Intestinal strongyloidiasis'),
    ('B781', 'Cutaneous strongyloidiasis'),
    ('B787', 'Disseminated strongyloidiasis'),
    ('B789', 'Strongyloidiasis, unspecified'),
    ('B79', 'Trichuriasis'),
    ('B80', 'Enterobiasis'),
    ('B810', 'Anisakiasis'),
    ('B811', 'Intestinal capillariasis'),
    ('B812', 'Trichostrongyliasis'),
    ('B813', 'Intestinal angiostrongyliasis'),
    ('B814', 'Mixed intestinal helminthiases'),
    ('B818', 'Other specified intestinal helminthiases'),
    ('B820', 'Intestinal helminthiasis, unspecified'),
    ('B829', 'Intestinal parasitism, unspecified'),
    ('B830', 'Visceral larva migrans'),
    ('B831', 'Gnathostomiasis'),
    ('B832', 'Angiostrongyliasis due to Parastrongylus cantonensis'),
    ('B833', 'Syngamiasis'),
    ('B834', 'Internal hirudiniasis'),
    ('B838', 'Other specified helminthiases'),
    ('B839', 'Helminthiasis, unspecified'),
    ('B850', 'Pediculosis due to Pediculus humanus capitis'),
    ('B851', 'Pediculosis due to Pediculus humanus corporis'),
    ('B852', 'Pediculosis, unspecified'),
    ('B853', 'Phthiriasis'),
    ('B854', 'Mixed pediculosis and phthiriasis'),
    ('B86', 'Scabies'),
    ('B870', 'Cutaneous myiasis'),
    ('B871', 'Wound myiasis'),
    ('B872', 'Ocular myiasis'),
    ('B873', 'Nasopharyngeal myiasis'),
    ('B874', 'Aural myiasis'),
    ('B8781', 'Genitourinary myiasis'),
    ('B8782', 'Intestinal myiasis'),
    ('B8789', 'Myiasis of other sites'),
    ('B879', 'Myiasis, unspecified'),
    ('B880', 'Other acariasis'),
    ('B881', 'Tungiasis [sandflea infestation]'),
    ('B882', 'Other arthropod infestations'),
    ('B883', 'External hirudiniasis'),
    ('B888', 'Other specified infestations'),
    ('B889', 'Infestation, unspecified'),
    ('B89', 'Unspecified parasitic disease'),
    ('B900', 'Sequelae of central nervous system tuberculosis'),
    ('B901', 'Sequelae of genitourinary tuberculosis'),
    ('B902', 'Sequelae of tuberculosis of bones and joints'),
    ('B908', 'Sequelae of tuberculosis of other organs'),
    ('B909', 'Sequelae of respiratory and unspecified tuberculosis'),
    ('B91', 'Sequelae of poliomyelitis'),
    ('B92', 'Sequelae of leprosy'),
    ('B940', 'Sequelae of trachoma'),
    ('B941', 'Sequelae of viral encephalitis'),
    ('B942', 'Sequelae of viral hepatitis'),
    ('B948', 'Sequelae of oth infectious and parasitic diseases'),
    ('B949', 'Sequelae of unspecified infectious and parasitic disease'),
    ('B950', 'Streptococcus, group A, causing diseases classd elswhr'),
    ('B951', 'Streptococcus, group B, causing diseases classd elswhr'),
    ('B952', 'Enterococcus as the cause of diseases classified elsewhere'),
    ('B953', 'Streptococcus pneumoniae causing diseases classd elswhr'),
    ('B954', 'Oth streptococcus as the cause of diseases classd elswhr'),
    ('B955', 'Unsp streptococcus as the cause of diseases classd elswhr'),
    ('B9561', 'Methicillin suscep staph infct causing dis classd elswhr'),
    ('B9562', 'Methicillin resis staph infct causing diseases classd elswhr'),
    ('B957', 'Oth staphylococcus as the cause of diseases classd elswhr'),
    ('B958', 'Unsp staphylococcus as the cause of diseases classd elswhr'),
    ('B960', 'Mycoplasma pneumoniae as the cause of diseases classd elswhr'),
    ('B961', 'Klebsiella pneumoniae as the cause of diseases classd elswhr'),
    ('B9620', 'Unsp Escherichia coli as the cause of diseases classd elswhr'),
    ('B9621', 'Shig tox E coli [STEC] O157 causing diseases classd elswhr'),
    ('B9622', 'Oth shiga toxin E coli [STEC] causing diseases classd elswhr'),
    ('B9623', 'Unsp shig tox E coli [STEC] causing diseases classd elswhr'),
    ('B9629', 'Oth Escherichia coli as the cause of diseases classd elswhr'),
    ('B963', 'Hemophilus influenzae as the cause of diseases classd elswhr'),
    ('B964', 'Proteus (mirabilis) (morganii) causing dis classd elswhr'),
    ('B965', 'Pseudomonas (mallei) causing diseases classd elswhr'),
    ('B966', 'Bacteroides fragilis as the cause of diseases classd elswhr'),
    ('B967', 'Clostridium perfringens causing diseases classd elswhr'),
    ('B9681', 'Helicobacter pylori as the cause of diseases classd elswhr'),
    ('B9682', 'Vibrio vulnificus as the cause of diseases classd elswhr'),
    ('B9683', 'Acinetobacter baumannii causing diseases classd elswhr'),
    ('B9689', 'Oth bacterial agents as the cause of diseases classd elswhr'),
    ('B970', 'Adenovirus as the cause of diseases classified elsewhere'),
    ('B9710', 'Unsp enterovirus as the cause of diseases classd elswhr'),
    ('B9711', 'Coxsackievirus as the cause of diseases classified elsewhere'),
    ('B9712', 'Echovirus as the cause of diseases classified elsewhere'),
    ('B9719', 'Oth enterovirus as the cause of diseases classd elswhr'),
    ('B9721', 'SARS-associated coronavirus causing diseases classd elswhr'),
    ('B9729', 'Oth coronavirus as the cause of diseases classd elswhr'),
    ('B9730', 'Unsp retrovirus as the cause of diseases classd elswhr'),
    ('B9731', 'Lentivirus as the cause of diseases classified elsewhere'),
    ('B9732', 'Oncovirus as the cause of diseases classified elsewhere'),
    ('B9733', 'HTLV-I as the cause of diseases classified elsewhere'),
    ('B9734', 'HTLV-II as the cause of diseases classified elsewhere'),
    ('B9735', 'HIV 2 as the cause of diseases classified elsewhere'),
    ('B9739', 'Oth retrovirus as the cause of diseases classified elsewhere'),
    ('B974', 'Respiratory syncytial virus causing diseases classd elswhr'),
    ('B975', 'Reovirus as the cause of diseases classified elsewhere'),
    ('B976', 'Parvovirus as the cause of diseases classified elsewhere'),
    ('B977', 'Papillomavirus as the cause of diseases classified elsewhere'),
    ('B9781', 'Human metapneumovirus as the cause of diseases classd elswhr'),
    ('B9789', 'Oth viral agents as the cause of diseases classd elswhr'),
    ('B998', 'Other infectious disease'),
    ('B999', 'Unspecified infectious disease'),
    ('C000', 'Malignant neoplasm of external upper lip'),
    ('C001', 'Malignant neoplasm of external lower lip'),
    ('C002', 'Malignant neoplasm of external lip, unspecified'),
    ('C003', 'Malignant neoplasm of upper lip, inner aspect'),
    ('C004', 'Malignant neoplasm of lower lip, inner aspect'),
    ('C005', 'Malignant neoplasm of lip, unspecified, inner aspect'),
    ('C006', 'Malignant neoplasm of commissure of lip, unspecified'),
    ('C008', 'Malignant neoplasm of overlapping sites of lip'),
    ('C009', 'Malignant neoplasm of lip, unspecified'),
    ('C01', 'Malignant neoplasm of base of tongue'),
    ('C020', 'Malignant neoplasm of dorsal surface of tongue'),
    ('C021', 'Malignant neoplasm of border of tongue'),
    ('C022', 'Malignant neoplasm of ventral surface of tongue'),
    ('C023', 'Malig neoplasm of anterior two-thirds of tongue, part unsp'),
    ('C024', 'Malignant neoplasm of lingual tonsil'),
    ('C028', 'Malignant neoplasm of overlapping sites of tongue'),
    ('C029', 'Malignant neoplasm of tongue, unspecified'),
    ('C030', 'Malignant neoplasm of upper gum'),
    ('C031', 'Malignant neoplasm of lower gum'),
    ('C039', 'Malignant neoplasm of gum, unspecified'),
    ('C040', 'Malignant neoplasm of anterior floor of mouth'),
    ('C041', 'Malignant neoplasm of lateral floor of mouth'),
    ('C048', 'Malignant neoplasm of overlapping sites of floor of mouth'),
    ('C049', 'Malignant neoplasm of floor of mouth, unspecified'),
    ('C050', 'Malignant neoplasm of hard palate'),
    ('C051', 'Malignant neoplasm of soft palate'),
    ('C052', 'Malignant neoplasm of uvula'),
    ('C058', 'Malignant neoplasm of overlapping sites of palate'),
    ('C059', 'Malignant neoplasm of palate, unspecified'),
    ('C060', 'Malignant neoplasm of cheek mucosa'),
    ('C061', 'Malignant neoplasm of vestibule of mouth'),
    ('C062', 'Malignant neoplasm of retromolar area'),
    ('C0680', 'Malignant neoplasm of ovrlp sites of unsp parts of mouth'),
    ('C0689', 'Malignant neoplasm of overlapping sites of oth prt mouth'),
    ('C069', 'Malignant neoplasm of mouth, unspecified'),
    ('C07', 'Malignant neoplasm of parotid gland'),
    ('C080', 'Malignant neoplasm of submandibular gland'),
    ('C081', 'Malignant neoplasm of sublingual gland'),
    ('C089', 'Malignant neoplasm of major salivary gland, unspecified'),
    ('C090', 'Malignant neoplasm of tonsillar fossa'),
    ('C091', 'Malig neoplasm of tonsillar pillar (anterior) (posterior)'),
    ('C098', 'Malignant neoplasm of overlapping sites of tonsil'),
    ('C099', 'Malignant neoplasm of tonsil, unspecified'),
    ('C100', 'Malignant neoplasm of vallecula'),
    ('C101', 'Malignant neoplasm of anterior surface of epiglottis'),
    ('C102', 'Malignant neoplasm of lateral wall of oropharynx'),
    ('C103', 'Malignant neoplasm of posterior wall of oropharynx'),
    ('C104', 'Malignant neoplasm of branchial cleft'),
    ('C108', 'Malignant neoplasm of overlapping sites of oropharynx'),
    ('C109', 'Malignant neoplasm of oropharynx, unspecified'),
    ('C110', 'Malignant neoplasm of superior wall of nasopharynx'),
    ('C111', 'Malignant neoplasm of posterior wall of nasopharynx'),
    ('C112', 'Malignant neoplasm of lateral wall of nasopharynx'),
    ('C113', 'Malignant neoplasm of anterior wall of nasopharynx'),
    ('C118', 'Malignant neoplasm of overlapping sites of nasopharynx'),
    ('C119', 'Malignant neoplasm of nasopharynx, unspecified'),
    ('C12', 'Malignant neoplasm of pyriform sinus'),
    ('C130', 'Malignant neoplasm of postcricoid region'),
    ('C131', 'Malig neoplasm of aryepiglottic fold, hypopharyngeal aspect'),
    ('C132', 'Malignant neoplasm of posterior wall of hypopharynx'),
    ('C138', 'Malignant neoplasm of overlapping sites of hypopharynx'),
    ('C139', 'Malignant neoplasm of hypopharynx, unspecified'),
    ('C140', 'Malignant neoplasm of pharynx, unspecified'),
    ('C142', "Malignant neoplasm of Waldeyer's ring"),
    ('C148', 'Malig neoplm of ovrlp sites of lip, oral cavity and pharynx'),
    ('C153', 'Malignant neoplasm of upper third of esophagus'),
    ('C154', 'Malignant neoplasm of middle third of esophagus'),
    ('C155', 'Malignant neoplasm of lower third of esophagus'),
    ('C158', 'Malignant neoplasm of overlapping sites of esophagus'),
    ('C159', 'Malignant neoplasm of esophagus, unspecified'),
    ('C160', 'Malignant neoplasm of cardia'),
    ('C161', 'Malignant neoplasm of fundus of stomach'),
    ('C162', 'Malignant neoplasm of body of stomach'),
    ('C163', 'Malignant neoplasm of pyloric antrum'),
    ('C164', 'Malignant neoplasm of pylorus'),
    ('C165', 'Malignant neoplasm of lesser curvature of stomach, unsp'),
    ('C166', 'Malignant neoplasm of greater curvature of stomach, unsp'),
    ('C168', 'Malignant neoplasm of overlapping sites of stomach'),
    ('C169', 'Malignant neoplasm of stomach, unspecified'),
    ('C170', 'Malignant neoplasm of duodenum'),
    ('C171', 'Malignant neoplasm of jejunum'),
    ('C172', 'Malignant neoplasm of ileum'),
    ('C173', "Meckel's diverticulum, malignant"),
    ('C178', 'Malignant neoplasm of overlapping sites of small intestine'),
    ('C179', 'Malignant neoplasm of small intestine, unspecified'),
    ('C180', 'Malignant neoplasm of cecum'),
    ('C181', 'Malignant neoplasm of appendix'),
    ('C182', 'Malignant neoplasm of ascending colon'),
    ('C183', 'Malignant neoplasm of hepatic flexure'),
    ('C184', 'Malignant neoplasm of transverse colon'),
    ('C185', 'Malignant neoplasm of splenic flexure'),
    ('C186', 'Malignant neoplasm of descending colon'),
    ('C187', 'Malignant neoplasm of sigmoid colon'),
    ('C188', 'Malignant neoplasm of overlapping sites of colon'),
    ('C189', 'Malignant neoplasm of colon, unspecified'),
    ('C19', 'Malignant neoplasm of rectosigmoid junction'),
    ('C20', 'Malignant neoplasm of rectum'),
    ('C210', 'Malignant neoplasm of anus, unspecified'),
    ('C211', 'Malignant neoplasm of anal canal'),
    ('C212', 'Malignant neoplasm of cloacogenic zone'),
    ('C218', 'Malig neoplasm of ovrlp sites of rectum, anus and anal canal'),
    ('C220', 'Liver cell carcinoma'),
    ('C221', 'Intrahepatic bile duct carcinoma'),
    ('C222', 'Hepatoblastoma'),
    ('C223', 'Angiosarcoma of liver'),
    ('C224', 'Other sarcomas of liver'),
    ('C227', 'Other specified carcinomas of liver'),
    ('C228', 'Malignant neoplasm of liver, primary, unspecified as to type'),
    ('C229', 'Malig neoplasm of liver, not specified as primary or sec'),
    ('C23', 'Malignant neoplasm of gallbladder'),
    ('C240', 'Malignant neoplasm of extrahepatic bile duct'),
    ('C241', 'Malignant neoplasm of ampulla of Vater'),
    ('C248', 'Malignant neoplasm of overlapping sites of biliary tract'),
    ('C249', 'Malignant neoplasm of biliary tract, unspecified'),
    ('C250', 'Malignant neoplasm of head of pancreas'),
    ('C251', 'Malignant neoplasm of body of pancreas'),
    ('C252', 'Malignant neoplasm of tail of pancreas'),
    ('C253', 'Malignant neoplasm of pancreatic duct'),
    ('C254', 'Malignant neoplasm of endocrine pancreas'),
    ('C257', 'Malignant neoplasm of other parts of pancreas'),
    ('C258', 'Malignant neoplasm of overlapping sites of pancreas'),
    ('C259', 'Malignant neoplasm of pancreas, unspecified'),
    ('C260', 'Malignant neoplasm of intestinal tract, part unspecified'),
    ('C261', 'Malignant neoplasm of spleen'),
    ('C269', 'Malignant neoplasm of ill-defined sites within the dgstv sys'),
    ('C300', 'Malignant neoplasm of nasal cavity'),
    ('C301', 'Malignant neoplasm of middle ear'),
    ('C310', 'Malignant neoplasm of maxillary sinus'),
    ('C311', 'Malignant neoplasm of ethmoidal sinus'),
    ('C312', 'Malignant neoplasm of frontal sinus'),
    ('C313', 'Malignant neoplasm of sphenoid sinus'),
    ('C318', 'Malignant neoplasm of overlapping sites of accessory sinuses'),
    ('C319', 'Malignant neoplasm of accessory sinus, unspecified'),
    ('C320', 'Malignant neoplasm of glottis'),
    ('C321', 'Malignant neoplasm of supraglottis'),
    ('C322', 'Malignant neoplasm of subglottis'),
    ('C323', 'Malignant neoplasm of laryngeal cartilage'),
    ('C328', 'Malignant neoplasm of overlapping sites of larynx'),
    ('C329', 'Malignant neoplasm of larynx, unspecified'),
    ('C33', 'Malignant neoplasm of trachea'),
    ('C3400', 'Malignant neoplasm of unspecified main bronchus'),
    ('C3401', 'Malignant neoplasm of right main bronchus'),
    ('C3402', 'Malignant neoplasm of left main bronchus'),
    ('C3410', 'Malignant neoplasm of upper lobe, unsp bronchus or lung'),
    ('C3411', 'Malignant neoplasm of upper lobe, right bronchus or lung'),
    ('C3412', 'Malignant neoplasm of upper lobe, left bronchus or lung'),
    ('C342', 'Malignant neoplasm of middle lobe, bronchus or lung'),
    ('C3430', 'Malignant neoplasm of lower lobe, unsp bronchus or lung'),
    ('C3431', 'Malignant neoplasm of lower lobe, right bronchus or lung'),
    ('C3432', 'Malignant neoplasm of lower lobe, left bronchus or lung'),
    ('C3480', 'Malignant neoplasm of ovrlp sites of unsp bronchus and lung'),
    ('C3481', 'Malignant neoplasm of ovrlp sites of right bronchus and lung'),
    ('C3482', 'Malignant neoplasm of ovrlp sites of left bronchus and lung'),
    ('C3490', 'Malignant neoplasm of unsp part of unsp bronchus or lung'),
    ('C3491', 'Malignant neoplasm of unsp part of right bronchus or lung'),
    ('C3492', 'Malignant neoplasm of unsp part of left bronchus or lung'),
    ('C37', 'Malignant neoplasm of thymus'),
    ('C380', 'Malignant neoplasm of heart'),
    ('C381', 'Malignant neoplasm of anterior mediastinum'),
    ('C382', 'Malignant neoplasm of posterior mediastinum'),
    ('C383', 'Malignant neoplasm of mediastinum, part unspecified'),
    ('C384', 'Malignant neoplasm of pleura'),
    ('C388', 'Malig neoplm of ovrlp sites of heart, mediastinum and pleura'),
    ('C390', 'Malignant neoplasm of upper respiratory tract, part unsp'),
    ('C399', 'Malignant neoplasm of lower respiratory tract, part unsp'),
    ('C4000', 'Malig neoplasm of scapula and long bones of unsp upper limb'),
    ('C4001', 'Malig neoplasm of scapula and long bones of right upper limb'),
    ('C4002', 'Malig neoplasm of scapula and long bones of left upper limb'),
    ('C4010', 'Malignant neoplasm of short bones of unspecified upper limb'),
    ('C4011', 'Malignant neoplasm of short bones of right upper limb'),
    ('C4012', 'Malignant neoplasm of short bones of left upper limb'),
    ('C4020', 'Malignant neoplasm of long bones of unspecified lower limb'),
    ('C4021', 'Malignant neoplasm of long bones of right lower limb'),
    ('C4022', 'Malignant neoplasm of long bones of left lower limb'),
    ('C4030', 'Malignant neoplasm of short bones of unspecified lower limb'),
    ('C4031', 'Malignant neoplasm of short bones of right lower limb'),
    ('C4032', 'Malignant neoplasm of short bones of left lower limb'),
    ('C4080', 'Malig neoplm of ovrlp sites of bone/artic cartl of unsp limb'),
    ('C4081', 'Malig neoplm of ovrlp sites of bone/artic cartl of r limb'),
    ('C4082', 'Malig neoplm of ovrlp sites of bone/artic cartl of left limb'),
    ('C4090', 'Malig neoplasm of unsp bones and artic cartlg of unsp limb'),
    ('C4091', 'Malig neoplasm of unsp bones and artic cartlg of right limb'),
    ('C4092', 'Malig neoplasm of unsp bones and artic cartlg of left limb'),
    ('C410', 'Malignant neoplasm of bones of skull and face'),
    ('C411', 'Malignant neoplasm of mandible'),
    ('C412', 'Malignant neoplasm of vertebral column'),
    ('C413', 'Malignant neoplasm of ribs, sternum and clavicle'),
    ('C414', 'Malignant neoplasm of pelvic bones, sacrum and coccyx'),
    ('C419', 'Malignant neoplasm of bone and articular cartilage, unsp'),
    ('C430', 'Malignant melanoma of lip'),
    ('C4310', 'Malignant melanoma of unspecified eyelid, including canthus'),
    ('C4311', 'Malignant melanoma of right eyelid, including canthus'),
    ('C43111', 'Malignant melanoma of right upper eyelid, including canthus'),
    ('C43112', 'Malignant melanoma of right lower eyelid, including canthus'),
    ('C4312', 'Malignant melanoma of left eyelid, including canthus'),
    ('C43121', 'Malignant melanoma of left upper eyelid, including canthus'),
    ('C43122', 'Malignant melanoma of left lower eyelid, including canthus'),
    ('C4320', 'Malignant melanoma of unsp ear and external auricular canal'),
    ('C4321', 'Malignant melanoma of right ear and external auricular canal'),
    ('C4322', 'Malignant melanoma of left ear and external auricular canal'),
    ('C4330', 'Malignant melanoma of unspecified part of face'),
    ('C4331', 'Malignant melanoma of nose'),
    ('C4339', 'Malignant melanoma of other parts of face'),
    ('C434', 'Malignant melanoma of scalp and neck'),
    ('C4351', 'Malignant melanoma of anal skin'),
    ('C4352', 'Malignant melanoma of skin of breast'),
    ('C4359', 'Malignant melanoma of other part of trunk'),
    ('C4360', 'Malignant melanoma of unsp upper limb, including shoulder'),
    ('C4361', 'Malignant melanoma of right upper limb, including shoulder'),
    ('C4362', 'Malignant melanoma of left upper limb, including shoulder'),
    ('C4370', 'Malignant melanoma of unspecified lower limb, including hip'),
    ('C4371', 'Malignant melanoma of right lower limb, including hip'),
    ('C4372', 'Malignant melanoma of left lower limb, including hip'),
    ('C438', 'Malignant melanoma of overlapping sites of skin'),
    ('C439', 'Malignant melanoma of skin, unspecified'),
    ('C4400', 'Unspecified malignant neoplasm of skin of lip'),
    ('C4401', 'Basal cell carcinoma of skin of lip'),
    ('C4402', 'Squamous cell carcinoma of skin of lip'),
    ('C4409', 'Other specified malignant neoplasm of skin of lip'),
    ('C44101', 'Unsp malignant neoplasm skin/ unsp eyelid, including canthus'),
    ('C44102', 'Unsp malignant neoplasm skin/ right eyelid, inc canthus'),
    ('C441021', 'Unsp malig neoplasm skin/ right upper eyelid, inc canthus'),
    ('C441022', 'Unsp malig neoplasm skin/ right lower eyelid, inc canthus'),
    ('C44109', 'Unsp malignant neoplasm skin/ left eyelid, including canthus'),
    ('C441091', 'Unsp malignant neoplasm skin/ left upper eyelid, inc canthus'),
    ('C441092', 'Unsp malignant neoplasm skin/ left lower eyelid, inc canthus'),
    ('C44111', 'Basal cell carcinoma skin/ unsp eyelid, including canthus'),
    ('C44112', 'Basal cell carcinoma skin/ right eyelid, including canthus'),
    ('C441121', 'Basal cell carcinoma skin/ right upper eyelid, inc canthus'),
    ('C441122', 'Basal cell carcinoma skin/ right lower eyelid, inc canthus'),
    ('C44119', 'Basal cell carcinoma skin/ left eyelid, including canthus'),
    ('C441191', 'Basal cell carcinoma skin/ left upper eyelid, inc canthus'),
    ('C441192', 'Basal cell carcinoma skin/ left lower eyelid, inc canthus'),
    ('C44121', 'Squamous cell carcinoma skin/ unsp eyelid, including canthus'),
    ('C44122', 'Squamous cell carcinoma skin/ right eyelid, inc canthus'),
    ('C441221', 'Squamous cell carcinoma skin/ r upper eyelid, inc canthus'),
    ('C441222', 'Squamous cell carcinoma skin/ right low eyelid, inc canthus'),
    ('C44129', 'Squamous cell carcinoma skin/ left eyelid, including canthus'),
    ('C441291', 'Squamous cell carcinoma skin/ left upper eyelid, inc canthus'),
    ('C441292', 'Squamous cell carcinoma skin/ left lower eyelid, inc canthus'),
    ('C44131', 'Sebaceous cell carcinoma skin/ unsplid, including canthus'),
    ('C441321', 'Sebaceous cell carcinoma skin/ r upper eyelid, inc canthus'),
    ('C441322', 'Sebaceous cell carcinoma skin/ right low eyelid, inc canthus'),
    ('C441391', 'Sebaceous cell carcinoma skin/ left upr eyelid, inc canthus'),
    ('C441392', 'Sebaceous cell carcinoma skin/ left low eyelid, inc canthus'),
    ('C44191', 'Oth malignant neoplasm skin/ unsp eyelid, including canthus'),
    ('C44192', 'Oth malignant neoplasm skin/ right eyelid, including canthus'),
    ('C441921', 'Oth malignant neoplasm skin/ right upper eyelid, inc canthus'),
    ('C441922', 'Oth malignant neoplasm skin/ right lower eyelid, inc canthus'),
    ('C44199', 'Oth malignant neoplasm skin/ left eyelid, including canthus'),
    ('C441991', 'Oth malignant neoplasm skin/ left upper eyelid, inc canthus'),
    ('C441992', 'Oth malignant neoplasm skin/ left lower eyelid, inc canthus'),
    ('C44201', 'Unsp malig neoplasm skin/ unsp ear and external auric canal'),
    ('C44202', 'Unsp malig neoplasm skin/ right ear and external auric canal'),
    ('C44209', 'Unsp malig neoplasm skin/ left ear and external auric canal'),
    ('C44211', 'Basal cell carcinoma skin/ unsp ear and external auric canal'),
    ('C44212', 'Basal cell carcinoma skin/ r ear and external auric canal'),
    ('C44219', 'Basal cell carcinoma skin/ left ear and external auric canal'),
    ('C44221', 'Squamous cell carcinoma skin/ unsp ear and extrn auric canal'),
    ('C44222', 'Squamous cell carcinoma skin/ r ear and external auric canal'),
    ('C44229', 'Squamous cell carcinoma skin/ left ear and extrn auric canal'),
    ('C44291', 'Oth malig neoplasm skin/ unsp ear and external auric canal'),
    ('C44292', 'Oth malig neoplasm skin/ right ear and external auric canal'),
    ('C44299', 'Oth malig neoplasm skin/ left ear and external auric canal'),
    ('C44300', 'Unsp malignant neoplasm of skin of unspecified part of face'),
    ('C44301', 'Unspecified malignant neoplasm of skin of nose'),
    ('C44309', 'Unsp malignant neoplasm of skin of other parts of face'),
    ('C44310', 'Basal cell carcinoma of skin of unspecified parts of face'),
    ('C44311', 'Basal cell carcinoma of skin of nose'),
    ('C44319', 'Basal cell carcinoma of skin of other parts of face'),
    ('C44320', 'Squamous cell carcinoma of skin of unspecified parts of face'),
    ('C44321', 'Squamous cell carcinoma of skin of nose'),
    ('C44329', 'Squamous cell carcinoma of skin of other parts of face'),
    ('C44390', 'Oth malignant neoplasm of skin of unspecified parts of face'),
    ('C44391', 'Other specified malignant neoplasm of skin of nose'),
    ('C44399', 'Oth malignant neoplasm of skin of other parts of face'),
    ('C4440', 'Unspecified malignant neoplasm of skin of scalp and neck'),
    ('C4441', 'Basal cell carcinoma of skin of scalp and neck'),
    ('C4442', 'Squamous cell carcinoma of skin of scalp and neck'),
    ('C4449', 'Other specified malignant neoplasm of skin of scalp and neck'),
    ('C44500', 'Unspecified malignant neoplasm of anal skin'),
    ('C44501', 'Unspecified malignant neoplasm of skin of breast'),
    ('C44509', 'Unsp malignant neoplasm of skin of other part of trunk'),
    ('C44510', 'Basal cell carcinoma of anal skin'),
    ('C44511', 'Basal cell carcinoma of skin of breast'),
    ('C44519', 'Basal cell carcinoma of skin of other part of trunk'),
    ('C44520', 'Squamous cell carcinoma of anal skin'),
    ('C44521', 'Squamous cell carcinoma of skin of breast'),
    ('C44529', 'Squamous cell carcinoma of skin of other part of trunk'),
    ('C44590', 'Other specified malignant neoplasm of anal skin'),
    ('C44591', 'Other specified malignant neoplasm of skin of breast'),
    ('C44599', 'Oth malignant neoplasm of skin of other part of trunk'),
    ('C44601', 'Unsp malignant neoplasm skin/ unsp upper limb, inc shoulder'),
    ('C44602', 'Unsp malignant neoplasm skin/ right upper limb, inc shoulder'),
    ('C44609', 'Unsp malignant neoplasm skin/ left upper limb, inc shoulder'),
    ('C44611', 'Basal cell carcinoma skin/ unsp upper limb, inc shoulder'),
    ('C44612', 'Basal cell carcinoma skin/ right upper limb, inc shoulder'),
    ('C44619', 'Basal cell carcinoma skin/ left upper limb, inc shoulder'),
    ('C44621', 'Squamous cell carcinoma skin/ unsp upper limb, inc shoulder'),
    ('C44622', 'Squamous cell carcinoma skin/ right upper limb, inc shoulder'),
    ('C44629', 'Squamous cell carcinoma skin/ left upper limb, inc shoulder'),
    ('C44691', 'Oth malignant neoplasm skin/ unsp upper limb, inc shoulder'),
    ('C44692', 'Oth malignant neoplasm skin/ right upper limb, inc shoulder'),
    ('C44699', 'Oth malignant neoplasm skin/ left upper limb, inc shoulder'),
    ('C44701', 'Unsp malignant neoplasm skin/ unsp lower limb, including hip'),
    ('C44702', 'Unsp malignant neoplasm skin/ right lower limb, inc hip'),
    ('C44709', 'Unsp malignant neoplasm skin/ left lower limb, including hip'),
    ('C44711', 'Basal cell carcinoma skin/ unsp lower limb, including hip'),
    ('C44712', 'Basal cell carcinoma skin/ right lower limb, including hip'),
    ('C44719', 'Basal cell carcinoma skin/ left lower limb, including hip'),
    ('C44721', 'Squamous cell carcinoma skin/ unsp lower limb, including hip'),
    ('C44722', 'Squamous cell carcinoma skin/ right lower limb, inc hip'),
    ('C44729', 'Squamous cell carcinoma skin/ left lower limb, including hip'),
    ('C44791', 'Oth malignant neoplasm skin/ unsp lower limb, including hip'),
    ('C44792', 'Oth malignant neoplasm skin/ right lower limb, including hip'),
    ('C44799', 'Oth malignant neoplasm skin/ left lower limb, including hip'),
    ('C4480', 'Unspecified malignant neoplasm of overlapping sites of skin'),
    ('C4481', 'Basal cell carcinoma of overlapping sites of skin'),
    ('C4482', 'Squamous cell carcinoma of overlapping sites of skin'),
    ('C4489', 'Oth malignant neoplasm of overlapping sites of skin'),
    ('C4490', 'Unspecified malignant neoplasm of skin, unspecified'),
    ('C4491', 'Basal cell carcinoma of skin, unspecified'),
    ('C4492', 'Squamous cell carcinoma of skin, unspecified'),
    ('C4499', 'Other specified malignant neoplasm of skin, unspecified'),
    ('C450', 'Mesothelioma of pleura'),
    ('C451', 'Mesothelioma of peritoneum'),
    ('C452', 'Mesothelioma of pericardium'),
    ('C457', 'Mesothelioma of other sites'),
    ('C459', 'Mesothelioma, unspecified'),
    ('C460', "Kaposi's sarcoma of skin"),
    ('C461', "Kaposi's sarcoma of soft tissue"),
    ('C462', "Kaposi's sarcoma of palate"),
    ('C463', "Kaposi's sarcoma of lymph nodes"),
    ('C464', "Kaposi's sarcoma of gastrointestinal sites"),
    ('C4650', "Kaposi's sarcoma of unspecified lung"),
    ('C4651', "Kaposi's sarcoma of right lung"),
    ('C4652', "Kaposi's sarcoma of left lung"),
    ('C467', "Kaposi's sarcoma of other sites"),
    ('C469', "Kaposi's sarcoma, unspecified"),
    ('C470', 'Malignant neoplasm of prph nerves of head, face and neck'),
    ('C4710', 'Malig neoplm of prph nerves of unsp upper limb, inc shoulder'),
    ('C4711', 'Malig neoplm of prph nerves of right upper limb, inc shldr'),
    ('C4712', 'Malig neoplm of prph nerves of left upper limb, inc shoulder'),
    ('C4720', 'Malig neoplasm of prph nerves of unsp lower limb, inc hip'),
    ('C4721', 'Malig neoplasm of prph nerves of right lower limb, inc hip'),
    ('C4722', 'Malig neoplasm of prph nerves of left lower limb, inc hip'),
    ('C473', 'Malignant neoplasm of peripheral nerves of thorax'),
    ('C474', 'Malignant neoplasm of peripheral nerves of abdomen'),
    ('C475', 'Malignant neoplasm of peripheral nerves of pelvis'),
    ('C476', 'Malignant neoplasm of peripheral nerves of trunk, unsp'),
    ('C478', 'Malig neoplm of ovrlp sites of prph nrv and autonm nrv sys'),
    ('C479', 'Malig neoplasm of prph nerves and autonm nervous sys, unsp'),
    ('C480', 'Malignant neoplasm of retroperitoneum'),
    ('C481', 'Malignant neoplasm of specified parts of peritoneum'),
    ('C482', 'Malignant neoplasm of peritoneum, unspecified'),
    ('C488', 'Malig neoplasm of ovrlp sites of retroperiton and peritoneum'),
    ('C490', 'Malig neoplm of conn and soft tissue of head, face and neck'),
    ('C4910', 'Malig neoplm of conn & soft tiss of unsp upr lmb, inc shldr'),
    ('C4911', 'Malig neoplm of conn and soft tiss of r upr limb, inc shldr'),
    ('C4912', 'Malig neoplm of conn and soft tiss of l upr limb, inc shldr'),
    ('C4920', 'Malig neoplm of conn and soft tiss of unsp low limb, inc hip'),
    ('C4921', 'Malig neoplm of conn and soft tiss of r low limb, inc hip'),
    ('C4922', 'Malig neoplm of conn and soft tiss of left low limb, inc hip'),
    ('C493', 'Malignant neoplasm of connective and soft tissue of thorax'),
    ('C494', 'Malignant neoplasm of connective and soft tissue of abdomen'),
    ('C495', 'Malignant neoplasm of connective and soft tissue of pelvis'),
    ('C496', 'Malignant neoplasm of conn and soft tissue of trunk, unsp'),
    ('C498', 'Malignant neoplasm of ovrlp sites of conn and soft tissue'),
    ('C499', 'Malignant neoplasm of connective and soft tissue, unsp'),
    ('C49A0', 'Gastrointestinal stromal tumor, unspecified site'),
    ('C49A1', 'Gastrointestinal stromal tumor of esophagus'),
    ('C49A2', 'Gastrointestinal stromal tumor of stomach'),
    ('C49A3', 'Gastrointestinal stromal tumor of small intestine'),
    ('C49A4', 'Gastrointestinal stromal tumor of large intestine'),
    ('C49A5', 'Gastrointestinal stromal tumor of rectum'),
    ('C49A9', 'Gastrointestinal stromal tumor of other sites'),
    ('C4A0', 'Merkel cell carcinoma of lip'),
    ('C4A10', 'Merkel cell carcinoma of unsp eyelid, including canthus'),
    ('C4A11', 'Merkel cell carcinoma of right eyelid, including canthus'),
    ('C4A111', 'Merkel cell carcinoma of right upper eyelid, including canthus'),
    ('C4A112', 'Merkel cell carcinoma of right lower eyelid, including canthus'),
    ('C4A12', 'Merkel cell carcinoma of left eyelid, including canthus'),
    ('C4A121', 'Merkel cell carcinoma of left upper eyelid, including canthus'),
    ('C4A122', 'Merkel cell carcinoma of left lower eyelid, including canthus'),
    ('C4A20', 'Merkel cell carcinoma of unsp ear and external auric canal'),
    ('C4A21', 'Merkel cell carcinoma of right ear and external auric canal'),
    ('C4A22', 'Merkel cell carcinoma of left ear and external auric canal'),
    ('C4A30', 'Merkel cell carcinoma of unspecified part of face'),
    ('C4A31', 'Merkel cell carcinoma of nose'),
    ('C4A39', 'Merkel cell carcinoma of other parts of face'),
    ('C4A4', 'Merkel cell carcinoma of scalp and neck'),
    ('C4A51', 'Merkel cell carcinoma of anal skin'),
    ('C4A52', 'Merkel cell carcinoma of skin of breast'),
    ('C4A59', 'Merkel cell carcinoma of other part of trunk'),
    ('C4A60', 'Merkel cell carcinoma of unsp upper limb, including shoulder'),
    ('C4A61', 'Merkel cell carcinoma of right upper limb, inc shoulder'),
    ('C4A62', 'Merkel cell carcinoma of left upper limb, including shoulder'),
    ('C4A70', 'Merkel cell carcinoma of unsp lower limb, including hip'),
    ('C4A71', 'Merkel cell carcinoma of right lower limb, including hip'),
    ('C4A72', 'Merkel cell carcinoma of left lower limb, including hip'),
    ('C4A8', 'Merkel cell carcinoma of overlapping sites'),
    ('C4A9', 'Merkel cell carcinoma, unspecified'),
    ('C50011', 'Malignant neoplasm of nipple and areola, right female breast'),
    ('C50012', 'Malignant neoplasm of nipple and areola, left female breast'),
    ('C50019', 'Malignant neoplasm of nipple and areola, unsp female breast'),
    ('C50021', 'Malignant neoplasm of nipple and areola, right male breast'),
    ('C50022', 'Malignant neoplasm of nipple and areola, left male breast'),
    ('C50029', 'Malignant neoplasm of nipple and areola, unsp male breast'),
    ('C50111', 'Malignant neoplasm of central portion of right female breast'),
    ('C50112', 'Malignant neoplasm of central portion of left female breast'),
    ('C50119', 'Malignant neoplasm of central portion of unsp female breast'),
    ('C50121', 'Malignant neoplasm of central portion of right male breast'),
    ('C50122', 'Malignant neoplasm of central portion of left male breast'),
    ('C50129', 'Malignant neoplasm of central portion of unsp male breast'),
    ('C50211', 'Malig neoplm of upper-inner quadrant of right female breast'),
    ('C50212', 'Malig neoplasm of upper-inner quadrant of left female breast'),
    ('C50219', 'Malig neoplasm of upper-inner quadrant of unsp female breast'),
    ('C50221', 'Malig neoplasm of upper-inner quadrant of right male breast'),
    ('C50222', 'Malig neoplasm of upper-inner quadrant of left male breast'),
    ('C50229', 'Malig neoplasm of upper-inner quadrant of unsp male breast'),
    ('C50311', 'Malig neoplm of lower-inner quadrant of right female breast'),
    ('C50312', 'Malig neoplasm of lower-inner quadrant of left female breast'),
    ('C50319', 'Malig neoplasm of lower-inner quadrant of unsp female breast'),
    ('C50321', 'Malig neoplasm of lower-inner quadrant of right male breast'),
    ('C50322', 'Malig neoplasm of lower-inner quadrant of left male breast'),
    ('C50329', 'Malig neoplasm of lower-inner quadrant of unsp male breast'),
    ('C50411', 'Malig neoplm of upper-outer quadrant of right female breast'),
    ('C50412', 'Malig neoplasm of upper-outer quadrant of left female breast'),
    ('C50419', 'Malig neoplasm of upper-outer quadrant of unsp female breast'),
    ('C50421', 'Malig neoplasm of upper-outer quadrant of right male breast'),
    ('C50422', 'Malig neoplasm of upper-outer quadrant of left male breast'),
    ('C50429', 'Malig neoplasm of upper-outer quadrant of unsp male breast'),
    ('C50511', 'Malig neoplm of lower-outer quadrant of right female breast'),
    ('C50512', 'Malig neoplasm of lower-outer quadrant of left female breast'),
    ('C50519', 'Malig neoplasm of lower-outer quadrant of unsp female breast'),
    ('C50521', 'Malig neoplasm of lower-outer quadrant of right male breast'),
    ('C50522', 'Malig neoplasm of lower-outer quadrant of left male breast'),
    ('C50529', 'Malig neoplasm of lower-outer quadrant of unsp male breast'),
    ('C50611', 'Malignant neoplasm of axillary tail of right female breast'),
    ('C50612', 'Malignant neoplasm of axillary tail of left female breast'),
    ('C50619', 'Malignant neoplasm of axillary tail of unsp female breast'),
    ('C50621', 'Malignant neoplasm of axillary tail of right male breast'),
    ('C50622', 'Malignant neoplasm of axillary tail of left male breast'),
    ('C50629', 'Malignant neoplasm of axillary tail of unsp male breast'),
    ('C50811', 'Malignant neoplasm of ovrlp sites of right female breast'),
    ('C50812', 'Malignant neoplasm of ovrlp sites of left female breast'),
    ('C50819', 'Malignant neoplasm of ovrlp sites of unsp female breast'),
    ('C50821', 'Malignant neoplasm of overlapping sites of right male breast'),
    ('C50822', 'Malignant neoplasm of overlapping sites of left male breast'),
    ('C50829', 'Malignant neoplasm of overlapping sites of unsp male breast'),
    ('C50911', 'Malignant neoplasm of unsp site of right female breast'),
    ('C50912', 'Malignant neoplasm of unspecified site of left female breast'),
    ('C50919', 'Malignant neoplasm of unsp site of unspecified female breast'),
    ('C50921', 'Malignant neoplasm of unspecified site of right male breast'),
    ('C50922', 'Malignant neoplasm of unspecified site of left male breast'),
    ('C50929', 'Malignant neoplasm of unsp site of unspecified male breast'),
    ('C510', 'Malignant neoplasm of labium majus'),
    ('C511', 'Malignant neoplasm of labium minus'),
    ('C512', 'Malignant neoplasm of clitoris'),
    ('C518', 'Malignant neoplasm of overlapping sites of vulva'),
    ('C519', 'Malignant neoplasm of vulva, unspecified'),
    ('C52', 'Malignant neoplasm of vagina'),
    ('C530', 'Malignant neoplasm of endocervix'),
    ('C531', 'Malignant neoplasm of exocervix'),
    ('C538', 'Malignant neoplasm of overlapping sites of cervix uteri'),
    ('C539', 'Malignant neoplasm of cervix uteri, unspecified'),
    ('C540', 'Malignant neoplasm of isthmus uteri'),
    ('C541', 'Malignant neoplasm of endometrium'),
    ('C542', 'Malignant neoplasm of myometrium'),
    ('C543', 'Malignant neoplasm of fundus uteri'),
    ('C548', 'Malignant neoplasm of overlapping sites of corpus uteri'),
    ('C549', 'Malignant neoplasm of corpus uteri, unspecified'),
    ('C55', 'Malignant neoplasm of uterus, part unspecified'),
    ('C561', 'Malignant neoplasm of right ovary'),
    ('C562', 'Malignant neoplasm of left ovary'),
    ('C563', 'Malignant neoplasm of bilateral ovaries'),
    ('C569', 'Malignant neoplasm of unspecified ovary'),
    ('C5700', 'Malignant neoplasm of unspecified fallopian tube'),
    ('C5701', 'Malignant neoplasm of right fallopian tube'),
    ('C5702', 'Malignant neoplasm of left fallopian tube'),
    ('C5710', 'Malignant neoplasm of unspecified broad ligament'),
    ('C5711', 'Malignant neoplasm of right broad ligament'),
    ('C5712', 'Malignant neoplasm of left broad ligament'),
    ('C5720', 'Malignant neoplasm of unspecified round ligament'),
    ('C5721', 'Malignant neoplasm of right round ligament'),
    ('C5722', 'Malignant neoplasm of left round ligament'),
    ('C573', 'Malignant neoplasm of parametrium'),
    ('C574', 'Malignant neoplasm of uterine adnexa, unspecified'),
    ('C577', 'Malignant neoplasm of other specified female genital organs'),
    ('C578', 'Malignant neoplasm of ovrlp sites of female genital organs'),
    ('C579', 'Malignant neoplasm of female genital organ, unspecified'),
    ('C58', 'Malignant neoplasm of placenta'),
    ('C600', 'Malignant neoplasm of prepuce'),
    ('C601', 'Malignant neoplasm of glans penis'),
    ('C602', 'Malignant neoplasm of body of penis'),
    ('C608', 'Malignant neoplasm of overlapping sites of penis'),
    ('C609', 'Malignant neoplasm of penis, unspecified'),
    ('C61', 'Malignant neoplasm of prostate'),
    ('C6200', 'Malignant neoplasm of unspecified undescended testis'),
    ('C6201', 'Malignant neoplasm of undescended right testis'),
    ('C6202', 'Malignant neoplasm of undescended left testis'),
    ('C6210', 'Malignant neoplasm of unspecified descended testis'),
    ('C6211', 'Malignant neoplasm of descended right testis'),
    ('C6212', 'Malignant neoplasm of descended left testis'),
    ('C6290', 'Malig neoplasm of unsp testis, unsp descended or undescended'),
    ('C6291', 'Malig neoplm of right testis, unsp descended or undescended'),
    ('C6292', 'Malig neoplasm of left testis, unsp descended or undescended'),
    ('C6300', 'Malignant neoplasm of unspecified epididymis'),
    ('C6301', 'Malignant neoplasm of right epididymis'),
    ('C6302', 'Malignant neoplasm of left epididymis'),
    ('C6310', 'Malignant neoplasm of unspecified spermatic cord'),
    ('C6311', 'Malignant neoplasm of right spermatic cord'),
    ('C6312', 'Malignant neoplasm of left spermatic cord'),
    ('C632', 'Malignant neoplasm of scrotum'),
    ('C637', 'Malignant neoplasm of other specified male genital organs'),
    ('C638', 'Malignant neoplasm of ovrlp sites of male genital organs'),
    ('C639', 'Malignant neoplasm of male genital organ, unspecified'),
    ('C641', 'Malignant neoplasm of right kidney, except renal pelvis'),
    ('C642', 'Malignant neoplasm of left kidney, except renal pelvis'),
    ('C649', 'Malignant neoplasm of unsp kidney, except renal pelvis'),
    ('C651', 'Malignant neoplasm of right renal pelvis'),
    ('C652', 'Malignant neoplasm of left renal pelvis'),
    ('C659', 'Malignant neoplasm of unspecified renal pelvis'),
    ('C661', 'Malignant neoplasm of right ureter'),
    ('C662', 'Malignant neoplasm of left ureter'),
    ('C669', 'Malignant neoplasm of unspecified ureter'),
    ('C670', 'Malignant neoplasm of trigone of bladder'),
    ('C671', 'Malignant neoplasm of dome of bladder'),
    ('C672', 'Malignant neoplasm of lateral wall of bladder'),
    ('C673', 'Malignant neoplasm of anterior wall of bladder'),
    ('C674', 'Malignant neoplasm of posterior wall of bladder'),
    ('C675', 'Malignant neoplasm of bladder neck'),
    ('C676', 'Malignant neoplasm of ureteric orifice'),
    ('C677', 'Malignant neoplasm of urachus'),
    ('C678', 'Malignant neoplasm of overlapping sites of bladder'),
    ('C679', 'Malignant neoplasm of bladder, unspecified'),
    ('C680', 'Malignant neoplasm of urethra'),
    ('C681', 'Malignant neoplasm of paraurethral glands'),
    ('C688', 'Malignant neoplasm of overlapping sites of urinary organs'),
    ('C689', 'Malignant neoplasm of urinary organ, unspecified'),
    ('C6900', 'Malignant neoplasm of unspecified conjunctiva'),
    ('C6901', 'Malignant neoplasm of right conjunctiva'),
    ('C6902', 'Malignant neoplasm of left conjunctiva'),
    ('C6910', 'Malignant neoplasm of unspecified cornea'),
    ('C6911', 'Malignant neoplasm of right cornea'),
    ('C6912', 'Malignant neoplasm of left cornea'),
    ('C6920', 'Malignant neoplasm of unspecified retina'),
    ('C6921', 'Malignant neoplasm of right retina'),
    ('C6922', 'Malignant neoplasm of left retina'),
    ('C6930', 'Malignant neoplasm of unspecified choroid'),
    ('C6931', 'Malignant neoplasm of right choroid'),
    ('C6932', 'Malignant neoplasm of left choroid'),
    ('C6940', 'Malignant neoplasm of unspecified ciliary body'),
    ('C6941', 'Malignant neoplasm of right ciliary body'),
    ('C6942', 'Malignant neoplasm of left ciliary body'),
    ('C6950', 'Malignant neoplasm of unspecified lacrimal gland and duct'),
    ('C6951', 'Malignant neoplasm of right lacrimal gland and duct'),
    ('C6952', 'Malignant neoplasm of left lacrimal gland and duct'),
    ('C6960', 'Malignant neoplasm of unspecified orbit'),
    ('C6961', 'Malignant neoplasm of right orbit'),
    ('C6962', 'Malignant neoplasm of left orbit'),
    ('C6980', 'Malignant neoplasm of ovrlp sites of unsp eye and adnexa'),
    ('C6981', 'Malignant neoplasm of ovrlp sites of right eye and adnexa'),
    ('C6982', 'Malignant neoplasm of ovrlp sites of left eye and adnexa'),
    ('C6990', 'Malignant neoplasm of unspecified site of unspecified eye'),
    ('C6991', 'Malignant neoplasm of unspecified site of right eye'),
    ('C6992', 'Malignant neoplasm of unspecified site of left eye'),
    ('C700', 'Malignant neoplasm of cerebral meninges'),
    ('C701', 'Malignant neoplasm of spinal meninges'),
    ('C709', 'Malignant neoplasm of meninges, unspecified'),
    ('C710', 'Malignant neoplasm of cerebrum, except lobes and ventricles'),
    ('C711', 'Malignant neoplasm of frontal lobe'),
    ('C712', 'Malignant neoplasm of temporal lobe'),
    ('C713', 'Malignant neoplasm of parietal lobe'),
    ('C714', 'Malignant neoplasm of occipital lobe'),
    ('C715', 'Malignant neoplasm of cerebral ventricle'),
    ('C716', 'Malignant neoplasm of cerebellum'),
    ('C717', 'Malignant neoplasm of brain stem'),
    ('C718', 'Malignant neoplasm of overlapping sites of brain'),
    ('C719', 'Malignant neoplasm of brain, unspecified'),
    ('C720', 'Malignant neoplasm of spinal cord'),
    ('C721', 'Malignant neoplasm of cauda equina'),
    ('C7220', 'Malignant neoplasm of unspecified olfactory nerve'),
    ('C7221', 'Malignant neoplasm of right olfactory nerve'),
    ('C7222', 'Malignant neoplasm of left olfactory nerve'),
    ('C7230', 'Malignant neoplasm of unspecified optic nerve'),
    ('C7231', 'Malignant neoplasm of right optic nerve'),
    ('C7232', 'Malignant neoplasm of left optic nerve'),
    ('C7240', 'Malignant neoplasm of unspecified acoustic nerve'),
    ('C7241', 'Malignant neoplasm of right acoustic nerve'),
    ('C7242', 'Malignant neoplasm of left acoustic nerve'),
    ('C7250', 'Malignant neoplasm of unspecified cranial nerve'),
    ('C7259', 'Malignant neoplasm of other cranial nerves'),
    ('C729', 'Malignant neoplasm of central nervous system, unspecified'),
    ('C73', 'Malignant neoplasm of thyroid gland'),
    ('C7400', 'Malignant neoplasm of cortex of unspecified adrenal gland'),
    ('C7401', 'Malignant neoplasm of cortex of right adrenal gland'),
    ('C7402', 'Malignant neoplasm of cortex of left adrenal gland'),
    ('C7410', 'Malignant neoplasm of medulla of unspecified adrenal gland'),
    ('C7411', 'Malignant neoplasm of medulla of right adrenal gland'),
    ('C7412', 'Malignant neoplasm of medulla of left adrenal gland'),
    ('C7490', 'Malignant neoplasm of unsp part of unspecified adrenal gland'),
    ('C7491', 'Malignant neoplasm of unsp part of right adrenal gland'),
    ('C7492', 'Malignant neoplasm of unspecified part of left adrenal gland'),
    ('C750', 'Malignant neoplasm of parathyroid gland'),
    ('C751', 'Malignant neoplasm of pituitary gland'),
    ('C752', 'Malignant neoplasm of craniopharyngeal duct'),
    ('C753', 'Malignant neoplasm of pineal gland'),
    ('C754', 'Malignant neoplasm of carotid body'),
    ('C755', 'Malignant neoplasm of aortic body and other paraganglia'),
    ('C758', 'Malignant neoplasm with pluriglandular involvement, unsp'),
    ('C759', 'Malignant neoplasm of endocrine gland, unspecified'),
    ('C760', 'Malignant neoplasm of head, face and neck'),
    ('C761', 'Malignant neoplasm of thorax'),
    ('C762', 'Malignant neoplasm of abdomen'),
    ('C763', 'Malignant neoplasm of pelvis'),
    ('C7640', 'Malignant neoplasm of unspecified upper limb'),
    ('C7641', 'Malignant neoplasm of right upper limb'),
    ('C7642', 'Malignant neoplasm of left upper limb'),
    ('C7650', 'Malignant neoplasm of unspecified lower limb'),
    ('C7651', 'Malignant neoplasm of right lower limb'),
    ('C7652', 'Malignant neoplasm of left lower limb'),
    ('C768', 'Malignant neoplasm of other specified ill-defined sites'),
    ('C770', 'Sec and unsp malig neoplasm of nodes of head, face and neck'),
    ('C771', 'Secondary and unsp malignant neoplasm of intrathorac nodes'),
    ('C772', 'Secondary and unsp malignant neoplasm of intra-abd nodes'),
    ('C773', 'Sec and unsp malig neoplasm of axilla and upper limb nodes'),
    ('C774', 'Sec and unsp malig neoplasm of inguinal and lower limb nodes'),
    ('C775', 'Secondary and unsp malignant neoplasm of intrapelv nodes'),
    ('C778', 'Sec and unsp malig neoplasm of nodes of multiple regions'),
    ('C779', 'Secondary and unsp malignant neoplasm of lymph node, unsp'),
    ('C7800', 'Secondary malignant neoplasm of unspecified lung'),
    ('C7801', 'Secondary malignant neoplasm of right lung'),
    ('C7802', 'Secondary malignant neoplasm of left lung'),
    ('C781', 'Secondary malignant neoplasm of mediastinum'),
    ('C782', 'Secondary malignant neoplasm of pleura'),
    ('C7830', 'Secondary malignant neoplasm of unsp respiratory organ'),
    ('C7839', 'Secondary malignant neoplasm of other respiratory organs'),
    ('C784', 'Secondary malignant neoplasm of small intestine'),
    ('C785', 'Secondary malignant neoplasm of large intestine and rectum'),
    ('C786', 'Secondary malignant neoplasm of retroperiton and peritoneum'),
    ('C787', 'Secondary malig neoplasm of liver and intrahepatic bile duct'),
    ('C7880', 'Secondary malignant neoplasm of unspecified digestive organ'),
    ('C7889', 'Secondary malignant neoplasm of other digestive organs'),
    ('C7900', 'Secondary malignant neoplasm of unsp kidney and renal pelvis'),
    ('C7901', 'Secondary malignant neoplasm of r kidney and renal pelvis'),
    ('C7902', 'Secondary malignant neoplasm of left kidney and renal pelvis'),
    ('C7910', 'Secondary malignant neoplasm of unspecified urinary organs'),
    ('C7911', 'Secondary malignant neoplasm of bladder'),
    ('C7919', 'Secondary malignant neoplasm of other urinary organs'),
    ('C792', 'Secondary malignant neoplasm of skin'),
    ('C7931', 'Secondary malignant neoplasm of brain'),
    ('C7932', 'Secondary malignant neoplasm of cerebral meninges'),
    ('C7940', 'Secondary malignant neoplasm of unsp part of nervous system'),
    ('C7949', 'Secondary malignant neoplasm of oth parts of nervous system'),
    ('C7951', 'Secondary malignant neoplasm of bone'),
    ('C7952', 'Secondary malignant neoplasm of bone marrow'),
    ('C7960', 'Secondary malignant neoplasm of unspecified ovary'),
    ('C7961', 'Secondary malignant neoplasm of right ovary'),
    ('C7962', 'Secondary malignant neoplasm of left ovary'),
    ('C7963', 'Secondary malignant neoplasm of bilateral ovaries'),
    ('C7970', 'Secondary malignant neoplasm of unspecified adrenal gland'),
    ('C7971', 'Secondary malignant neoplasm of right adrenal gland'),
    ('C7972', 'Secondary malignant neoplasm of left adrenal gland'),
    ('C7981', 'Secondary malignant neoplasm of breast'),
    ('C7982', 'Secondary malignant neoplasm of genital organs'),
    ('C7989', 'Secondary malignant neoplasm of other specified sites'),
    ('C799', 'Secondary malignant neoplasm of unspecified site'),
    ('C7A00', 'Malignant carcinoid tumor of unspecified site'),
    ('C7A010', 'Malignant carcinoid tumor of the duodenum'),
    ('C7A011', 'Malignant carcinoid tumor of the jejunum'),
    ('C7A012', 'Malignant carcinoid tumor of the ileum'),
    ('C7A019', 'Malignant carcinoid tumor of the sm int, unsp portion'),
    ('C7A020', 'Malignant carcinoid tumor of the appendix'),
    ('C7A021', 'Malignant carcinoid tumor of the cecum'),
    ('C7A022', 'Malignant carcinoid tumor of the ascending colon'),
    ('C7A023', 'Malignant carcinoid tumor of the transverse colon'),
    ('C7A024', 'Malignant carcinoid tumor of the descending colon'),
    ('C7A025', 'Malignant carcinoid tumor of the sigmoid colon'),
    ('C7A026', 'Malignant carcinoid tumor of the rectum'),
    ('C7A029', 'Malignant carcinoid tumor of the lg int, unsp portion'),
    ('C7A090', 'Malignant carcinoid tumor of the bronchus and lung'),
    ('C7A091', 'Malignant carcinoid tumor of the thymus'),
    ('C7A092', 'Malignant carcinoid tumor of the stomach'),
    ('C7A093', 'Malignant carcinoid tumor of the kidney'),
    ('C7A094', 'Malignant carcinoid tumor of the foregut unsp'),
    ('C7A095', 'Malignant carcinoid tumor of the midgut unsp'),
    ('C7A096', 'Malignant carcinoid tumor of the hindgut unsp'),
    ('C7A098', 'Malignant carcinoid tumors of other sites'),
    ('C7A1', 'Malignant poorly differentiated neuroendocrine tumors'),
    ('C7A8', 'Other malignant neuroendocrine tumors'),
    ('C7B00', 'Secondary carcinoid tumors, unspecified site'),
    ('C7B01', 'Secondary carcinoid tumors of distant lymph nodes'),
    ('C7B02', 'Secondary carcinoid tumors of liver'),
    ('C7B03', 'Secondary carcinoid tumors of bone'),
    ('C7B04', 'Secondary carcinoid tumors of peritoneum'),
    ('C7B09', 'Secondary carcinoid tumors of other sites'),
    ('C7B1', 'Secondary Merkel cell carcinoma'),
    ('C7B8', 'Other secondary neuroendocrine tumors'),
    ('C800', 'Disseminated malignant neoplasm, unspecified'),
    ('C801', 'Malignant (primary) neoplasm, unspecified'),
    ('C802', 'Malignant neoplasm associated with transplanted organ'),
    ('C8100', 'Nodular lymphocyte predominant Hodgkin lymphoma, unsp site'),
    ('C8101', 'Nodlr lymphocy predom Hdgkn lymph, nodes of head, face, & nk'),
    ('C8102', 'Nodular lymphocy predom Hodgkin lymphoma, intrathorac nodes'),
    ('C8103', 'Nodular lymphocyte predom Hodgkin lymphoma, intra-abd nodes'),
    ('C8104', 'Nodlr lymphocy predom Hdgkn lymph, nodes of axla and upr lmb'),
    ('C8105', 'Nodlr lymphocy predom Hdgkn lymph,nodes of ing rgn & low lmb'),
    ('C8106', 'Nodular lymphocyte predom Hodgkin lymphoma, intrapelv nodes'),
    ('C8107', 'Nodular lymphocyte predominant Hodgkin lymphoma, spleen'),
    ('C8108', 'Nodular lymphocyte predom Hodgkin lymphoma, nodes mult site'),
    ('C8109', 'Nodlr lymphocy predom Hdgkn lymph, extrnod & solid org site'),
    ('C8110', 'Nodular sclerosis Hodgkin lymphoma, unsp site'),
    ('C8111', 'Nodlr scler Hdgkn lymph, nodes of head, face, and neck'),
    ('C8112', 'Nodular sclerosis Hodgkin lymphoma, intrathorac nodes'),
    ('C8113', 'Nodular sclerosis Hodgkin lymphoma, intra-abd nodes'),
    ('C8114', 'Nodlr scler Hdgkn lymph, nodes of axla and upper limb'),
    ('C8115', 'Nodlr scler Hdgkn lymph, nodes of ing rgn and low limb'),
    ('C8116', 'Nodular sclerosis Hodgkin lymphoma, intrapelv nodes'),
    ('C8117', 'Nodular sclerosis Hodgkin lymphoma, spleen'),
    ('C8118', 'Nodular sclerosis Hodgkin lymphoma, nodes mult site'),
    ('C8119', 'Nodlr scler Hdgkn lymph, extrnod and solid organ sites'),
    ('C8120', 'Mixed cellularity Hodgkin lymphoma, unsp site'),
    ('C8121', 'Mix cellular Hdgkn lymph, nodes of head, face, and nk'),
    ('C8122', 'Mixed cellular Hodgkin lymphoma, intrathorac nodes'),
    ('C8123', 'Mixed cellular Hodgkin lymphoma, intra-abd nodes'),
    ('C8124', 'Mix cellular Hdgkn lymph, nodes of axla and upper limb'),
    ('C8125', 'Mix cellular Hdgkn lymph, nodes of ing rgn and low lmb'),
    ('C8126', 'Mixed cellular Hodgkin lymphoma, intrapelv nodes'),
    ('C8127', 'Mixed cellularity Hodgkin lymphoma, spleen'),
    ('C8128', 'Mixed cellular Hodgkin lymphoma, nodes mult site'),
    ('C8129', 'Mix cellular Hdgkn lymph, extrnod and solid org sites'),
    ('C8130', 'Lymphocyte depleted Hodgkin lymphoma, unsp site'),
    ('C8131', 'Lymphocy deplet Hdgkn lymph, nodes of head, face, & nk'),
    ('C8132', 'Lymphocy depleted Hodgkin lymphoma, intrathorac nodes'),
    ('C8133', 'Lymphocy depleted Hodgkin lymphoma, intra-abd nodes'),
    ('C8134', 'Lymphocy deplet Hdgkn lymph, nodes of axla and upr lmb'),
    ('C8135', 'Lymphocy deplet Hdgkn lymph,nodes of ing rgn & low lmb'),
    ('C8136', 'Lymphocy depleted Hodgkin lymphoma, intrapelv nodes'),
    ('C8137', 'Lymphocyte depleted Hodgkin lymphoma, spleen'),
    ('C8138', 'Lymphocy depleted Hodgkin lymphoma, nodes mult site'),
    ('C8139', 'Lymphocy deplet Hdgkn lymph, extrnod & solid org site'),
    ('C8140', 'Lymphocyte-rich Hodgkin lymphoma, unspecified site'),
    ('C8141', 'Lymp-rich Hodgkin lymph, nodes of head, face, and neck'),
    ('C8142', 'Lymp-rich Hodgkin lymphoma, intrathorac nodes'),
    ('C8143', 'Lymp-rich Hodgkin lymphoma, intra-abd lymph nodes'),
    ('C8144', 'Lymp-rich Hdgkn lymph, nodes of axilla and upper limb'),
    ('C8145', 'Lymp-rich Hdgkn lymph, nodes of ing rgn and lower limb'),
    ('C8146', 'Lymp-rich Hodgkin lymphoma, intrapelv lymph nodes'),
    ('C8147', 'Lymphocyte-rich Hodgkin lymphoma, spleen'),
    ('C8148', 'Lymp-rich Hodgkin lymphoma, lymph nodes mult site'),
    ('C8149', 'Lymp-rich Hodgkin lymph, extrnod and solid organ sites'),
    ('C8170', 'Other Hodgkin lymphoma, unspecified site'),
    ('C8171', 'Oth Hodgkin lymphoma, nodes of head, face, and neck'),
    ('C8172', 'Other Hodgkin lymphoma, intrathoracic lymph nodes'),
    ('C8173', 'Oth Hodgkin lymphoma, intra-abdominal lymph nodes'),
    ('C8174', 'Oth Hodgkin lymphoma, nodes of axilla and upper limb'),
    ('C8175', 'Oth Hodgkin lymph, nodes of ing region and lower limb'),
    ('C8176', 'Other Hodgkin lymphoma, intrapelvic lymph nodes'),
    ('C8177', 'Other Hodgkin lymphoma, spleen'),
    ('C8178', 'Oth Hodgkin lymphoma, lymph nodes mult site'),
    ('C8179', 'Oth Hodgkin lymphoma, extrnod and solid organ sites'),
    ('C8190', 'Hodgkin lymphoma, unspecified, unspecified site'),
    ('C8191', 'Hodgkin lymphoma, unsp, lymph nodes of head, face, and neck'),
    ('C8192', 'Hodgkin lymphoma, unspecified, intrathoracic lymph nodes'),
    ('C8193', 'Hodgkin lymphoma, unspecified, intra-abdominal lymph nodes'),
    ('C8194', 'Hodgkin lymphoma, unsp, lymph nodes of axilla and upper limb'),
    ('C8195', 'Hodgkin lymphoma, unsp, nodes of ing region and lower limb'),
    ('C8196', 'Hodgkin lymphoma, unspecified, intrapelvic lymph nodes'),
    ('C8197', 'Hodgkin lymphoma, unspecified, spleen'),
    ('C8198', 'Hodgkin lymphoma, unspecified, lymph nodes of multiple sites'),
    ('C8199', 'Hodgkin lymphoma, unsp, extranodal and solid organ sites'),
    ('C8200', 'Follicular lymphoma grade I, unspecified site'),
    ('C8201', 'Follicular lymphoma grade I, nodes of head, face, and neck'),
    ('C8202', 'Follicular lymphoma grade I, intrathoracic lymph nodes'),
    ('C8203', 'Follicular lymphoma grade I, intra-abdominal lymph nodes'),
    ('C8204', 'Follicular lymphoma grade I, nodes of axilla and upper limb'),
    ('C8205', 'Foliclar lymph grade I, nodes of ing region and lower limb'),
    ('C8206', 'Follicular lymphoma grade I, intrapelvic lymph nodes'),
    ('C8207', 'Follicular lymphoma grade I, spleen'),
    ('C8208', 'Follicular lymphoma grade I, lymph nodes of multiple sites'),
    ('C8209', 'Follicular lymphoma grade I, extrnod and solid organ sites'),
    ('C8210', 'Follicular lymphoma grade II, unspecified site'),
    ('C8211', 'Follicular lymphoma grade II, nodes of head, face, and neck'),
    ('C8212', 'Follicular lymphoma grade II, intrathoracic lymph nodes'),
    ('C8213', 'Follicular lymphoma grade II, intra-abdominal lymph nodes'),
    ('C8214', 'Follicular lymphoma grade II, nodes of axilla and upper limb'),
    ('C8215', 'Foliclar lymph grade II, nodes of ing region and lower limb'),
    ('C8216', 'Follicular lymphoma grade II, intrapelvic lymph nodes'),
    ('C8217', 'Follicular lymphoma grade II, spleen'),
    ('C8218', 'Follicular lymphoma grade II, lymph nodes of multiple sites'),
    ('C8219', 'Follicular lymphoma grade II, extrnod and solid organ sites'),
    ('C8220', 'Follicular lymphoma grade III, unspecified, unspecified site'),
    ('C8221', 'Foliclar lymph grade III, unsp, nodes of head, face, and nk'),
    ('C8222', 'Follicular lymphoma grade III, unsp, intrathorac lymph nodes'),
    ('C8223', 'Follicular lymphoma grade III, unsp, intra-abd lymph nodes'),
    ('C8224', 'Foliclar lymph grade III, unsp, nodes of axla and upper limb'),
    ('C8225', 'Foliclar lymph grade III, unsp, nodes of ing rgn and low lmb'),
    ('C8226', 'Follicular lymphoma grade III, unsp, intrapelvic lymph nodes'),
    ('C8227', 'Follicular lymphoma grade III, unspecified, spleen'),
    ('C8228', 'Follicular lymphoma grade III, unsp, lymph nodes mult site'),
    ('C8229', 'Foliclar lymph grade III, unsp, extrnod and solid org sites'),
    ('C8230', 'Follicular lymphoma grade IIIa, unspecified site'),
    ('C8231', 'Foliclar lymphoma grade IIIa, nodes of head, face, and neck'),
    ('C8232', 'Follicular lymphoma grade IIIa, intrathoracic lymph nodes'),
    ('C8233', 'Follicular lymphoma grade IIIa, intra-abdominal lymph nodes'),
    ('C8234', 'Foliclar lymphoma grade IIIa, nodes of axilla and upper limb'),
    ('C8235', 'Foliclar lymph grade IIIa, nodes of ing rgn and lower limb'),
    ('C8236', 'Follicular lymphoma grade IIIa, intrapelvic lymph nodes'),
    ('C8237', 'Follicular lymphoma grade IIIa, spleen'),
    ('C8238', 'Follicular lymphoma grade IIIa, lymph nodes mult site'),
    ('C8239', 'Foliclar lymphoma grade IIIa, extrnod and solid organ sites'),
    ('C8240', 'Follicular lymphoma grade IIIb, unspecified site'),
    ('C8241', 'Foliclar lymphoma grade IIIb, nodes of head, face, and neck'),
    ('C8242', 'Follicular lymphoma grade IIIb, intrathoracic lymph nodes'),
    ('C8243', 'Follicular lymphoma grade IIIb, intra-abdominal lymph nodes'),
    ('C8244', 'Foliclar lymphoma grade IIIb, nodes of axilla and upper limb'),
    ('C8245', 'Foliclar lymph grade IIIb, nodes of ing rgn and lower limb'),
    ('C8246', 'Follicular lymphoma grade IIIb, intrapelvic lymph nodes'),
    ('C8247', 'Follicular lymphoma grade IIIb, spleen'),
    ('C8248', 'Follicular lymphoma grade IIIb, lymph nodes mult site'),
    ('C8249', 'Foliclar lymphoma grade IIIb, extrnod and solid organ sites'),
    ('C8250', 'Diffuse follicle center lymphoma, unspecified site'),
    ('C8251', 'Diffuse folicl center lymph, nodes of head, face, and neck'),
    ('C8252', 'Diffuse follicle center lymphoma, intrathoracic lymph nodes'),
    ('C8253', 'Diffuse follicle center lymphoma, intra-abd lymph nodes'),
    ('C8254', 'Diffuse folicl center lymph, nodes of axilla and upper limb'),
    ('C8255', 'Diffus folicl cntr lymph, nodes of ing region and lower limb'),
    ('C8256', 'Diffuse follicle center lymphoma, intrapelvic lymph nodes'),
    ('C8257', 'Diffuse follicle center lymphoma, spleen'),
    ('C8258', 'Diffuse follicle center lymphoma, lymph nodes mult site'),
    ('C8259', 'Diffuse folicl center lymph, extrnod and solid organ sites'),
    ('C8260', 'Cutaneous follicle center lymphoma, unspecified site'),
    ('C8261', 'Cutan folicl center lymphoma, nodes of head, face, and neck'),
    ('C8262', 'Cutaneous follicle center lymphoma, intrathorac lymph nodes'),
    ('C8263', 'Cutaneous follicle center lymphoma, intra-abd lymph nodes'),
    ('C8264', 'Cutan folicl center lymphoma, nodes of axilla and upper limb'),
    ('C8265', 'Cutan folicl cntr lymph, nodes of ing region and lower limb'),
    ('C8266', 'Cutaneous follicle center lymphoma, intrapelvic lymph nodes'),
    ('C8267', 'Cutaneous follicle center lymphoma, spleen'),
    ('C8268', 'Cutaneous follicle center lymphoma, lymph nodes mult site'),
    ('C8269', 'Cutan folicl center lymphoma, extrnod and solid organ sites'),
    ('C8280', 'Other types of follicular lymphoma, unspecified site'),
    ('C8281', 'Oth types of foliclar lymph, nodes of head, face, and neck'),
    ('C8282', 'Oth types of follicular lymphoma, intrathoracic lymph nodes'),
    ('C8283', 'Oth types of follicular lymphoma, intra-abd lymph nodes'),
    ('C8284', 'Oth types of foliclar lymph, nodes of axilla and upper limb'),
    ('C8285', 'Oth types of foliclar lymph, nodes of ing rgn and lower limb'),
    ('C8286', 'Other types of follicular lymphoma, intrapelvic lymph nodes'),
    ('C8287', 'Other types of follicular lymphoma, spleen'),
    ('C8288', 'Oth types of follicular lymphoma, lymph nodes mult site'),
    ('C8289', 'Oth types of foliclar lymph, extrnod and solid organ sites'),
    ('C8290', 'Follicular lymphoma, unspecified, unspecified site'),
    ('C8291', 'Follicular lymphoma, unsp, nodes of head, face, and neck'),
    ('C8292', 'Follicular lymphoma, unspecified, intrathoracic lymph nodes'),
    ('C8293', 'Follicular lymphoma, unsp, intra-abdominal lymph nodes'),
    ('C8294', 'Follicular lymphoma, unsp, nodes of axilla and upper limb'),
    ('C8295', 'Foliclar lymphoma, unsp, nodes of ing region and lower limb'),
    ('C8296', 'Follicular lymphoma, unspecified, intrapelvic lymph nodes'),
    ('C8297', 'Follicular lymphoma, unspecified, spleen'),
    ('C8298', 'Follicular lymphoma, unsp, lymph nodes of multiple sites'),
    ('C8299', 'Follicular lymphoma, unsp, extranodal and solid organ sites'),
    ('C8300', 'Small cell B-cell lymphoma, unspecified site'),
    ('C8301', 'Small cell B-cell lymphoma, nodes of head, face, and neck'),
    ('C8302', 'Small cell B-cell lymphoma, intrathoracic lymph nodes'),
    ('C8303', 'Small cell B-cell lymphoma, intra-abdominal lymph nodes'),
    ('C8304', 'Small cell B-cell lymphoma, nodes of axilla and upper limb'),
    ('C8305', 'Small cell B-cell lymph, nodes of ing region and lower limb'),
    ('C8306', 'Small cell B-cell lymphoma, intrapelvic lymph nodes'),
    ('C8307', 'Small cell B-cell lymphoma, spleen'),
    ('C8308', 'Small cell B-cell lymphoma, lymph nodes of multiple sites'),
    ('C8309', 'Small cell B-cell lymphoma, extranodal and solid organ sites'),
    ('C8310', 'Mantle cell lymphoma, unspecified site'),
    ('C8311', 'Mantle cell lymphoma, lymph nodes of head, face, and neck'),
    ('C8312', 'Mantle cell lymphoma, intrathoracic lymph nodes'),
    ('C8313', 'Mantle cell lymphoma, intra-abdominal lymph nodes'),
    ('C8314', 'Mantle cell lymphoma, lymph nodes of axilla and upper limb'),
    ('C8315', 'Mantle cell lymphoma, nodes of ing region and lower limb'),
    ('C8316', 'Mantle cell lymphoma, intrapelvic lymph nodes'),
    ('C8317', 'Mantle cell lymphoma, spleen'),
    ('C8318', 'Mantle cell lymphoma, lymph nodes of multiple sites'),
    ('C8319', 'Mantle cell lymphoma, extranodal and solid organ sites'),
    ('C8330', 'Diffuse large B-cell lymphoma, unspecified site'),
    ('C8331', 'Diffuse large B-cell lymphoma, nodes of head, face, and neck'),
    ('C8332', 'Diffuse large B-cell lymphoma, intrathoracic lymph nodes'),
    ('C8333', 'Diffuse large B-cell lymphoma, intra-abdominal lymph nodes'),
    ('C8334', 'Diffuse large B-cell lymph, nodes of axilla and upper limb'),
    ('C8335', 'Diffus large B-cell lymph, nodes of ing rgn and lower limb'),
    ('C8336', 'Diffuse large B-cell lymphoma, intrapelvic lymph nodes'),
    ('C8337', 'Diffuse large B-cell lymphoma, spleen'),
    ('C8338', 'Diffuse large B-cell lymphoma, lymph nodes of multiple sites'),
    ('C8339', 'Diffuse large B-cell lymphoma, extrnod and solid organ sites'),
    ('C8350', 'Lymphoblastic (diffuse) lymphoma, unspecified site'),
    ('C8351', 'Lymphoblastic lymphoma, nodes of head, face, and neck'),
    ('C8352', 'Lymphoblastic (diffuse) lymphoma, intrathoracic lymph nodes'),
    ('C8353', 'Lymphoblastic (diffuse) lymphoma, intra-abd lymph nodes'),
    ('C8354', 'Lymphoblastic lymphoma, nodes of axilla and upper limb'),
    ('C8355', 'Lymphoblastic lymphoma, nodes of ing region and lower limb'),
    ('C8356', 'Lymphoblastic (diffuse) lymphoma, intrapelvic lymph nodes'),
    ('C8357', 'Lymphoblastic (diffuse) lymphoma, spleen'),
    ('C8358', 'Lymphoblastic (diffuse) lymphoma, lymph nodes mult site'),
    ('C8359', 'Lymphoblastic lymphoma, extrnod and solid organ sites'),
    ('C8370', 'Burkitt lymphoma, unspecified site'),
    ('C8371', 'Burkitt lymphoma, lymph nodes of head, face, and neck'),
    ('C8372', 'Burkitt lymphoma, intrathoracic lymph nodes'),
    ('C8373', 'Burkitt lymphoma, intra-abdominal lymph nodes'),
    ('C8374', 'Burkitt lymphoma, lymph nodes of axilla and upper limb'),
    ('C8375', 'Burkitt lymphoma, nodes of inguinal region and lower limb'),
    ('C8376', 'Burkitt lymphoma, intrapelvic lymph nodes'),
    ('C8377', 'Burkitt lymphoma, spleen'),
    ('C8378', 'Burkitt lymphoma, lymph nodes of multiple sites'),
    ('C8379', 'Burkitt lymphoma, extranodal and solid organ sites'),
    ('C8380', 'Other non-follicular lymphoma, unspecified site'),
    ('C8381', 'Oth non-follic lymphoma, lymph nodes of head, face, and neck'),
    ('C8382', 'Other non-follicular lymphoma, intrathoracic lymph nodes'),
    ('C8383', 'Other non-follicular lymphoma, intra-abdominal lymph nodes'),
    ('C8384', 'Oth non-follic lymphoma, nodes of axilla and upper limb'),
    ('C8385', 'Oth non-follic lymphoma, nodes of ing region and lower limb'),
    ('C8386', 'Other non-follicular lymphoma, intrapelvic lymph nodes'),
    ('C8387', 'Other non-follicular lymphoma, spleen'),
    ('C8388', 'Other non-follicular lymphoma, lymph nodes of multiple sites'),
    ('C8389', 'Oth non-follic lymphoma, extranodal and solid organ sites'),
    ('C8390', 'Non-follicular (diffuse) lymphoma, unsp, unspecified site'),
    ('C8391', 'Non-follic lymphoma, unsp, nodes of head, face, and neck'),
    ('C8392', 'Non-follic (diffuse) lymphoma, unsp, intrathorac lymph nodes'),
    ('C8393', 'Non-follic (diffuse) lymphoma, unsp, intra-abd lymph nodes'),
    ('C8394', 'Non-follic lymphoma, unsp, nodes of axilla and upper limb'),
    ('C8395', 'Non-follic lymph, unsp, nodes of ing region and lower limb'),
    ('C8396', 'Non-follic (diffuse) lymphoma, unsp, intrapelvic lymph nodes'),
    ('C8397', 'Non-follicular (diffuse) lymphoma, unspecified, spleen'),
    ('C8398', 'Non-follic (diffuse) lymphoma, unsp, lymph nodes mult site'),
    ('C8399', 'Non-follic lymphoma, unsp, extrnod and solid organ sites'),
    ('C8400', 'Mycosis fungoides, unspecified site'),
    ('C8401', 'Mycosis fungoides, lymph nodes of head, face, and neck'),
    ('C8402', 'Mycosis fungoides, intrathoracic lymph nodes'),
    ('C8403', 'Mycosis fungoides, intra-abdominal lymph nodes'),
    ('C8404', 'Mycosis fungoides, lymph nodes of axilla and upper limb'),
    ('C8405', 'Mycosis fungoides, nodes of inguinal region and lower limb'),
    ('C8406', 'Mycosis fungoides, intrapelvic lymph nodes'),
    ('C8407', 'Mycosis fungoides, spleen'),
    ('C8408', 'Mycosis fungoides, lymph nodes of multiple sites'),
    ('C8409', 'Mycosis fungoides, extranodal and solid organ sites'),
    ('C8410', 'Sezary disease, unspecified site'),
    ('C8411', 'Sezary disease, lymph nodes of head, face, and neck'),
    ('C8412', 'Sezary disease, intrathoracic lymph nodes'),
    ('C8413', 'Sezary disease, intra-abdominal lymph nodes'),
    ('C8414', 'Sezary disease, lymph nodes of axilla and upper limb'),
    ('C8415', 'Sezary disease, nodes of inguinal region and lower limb'),
    ('C8416', 'Sezary disease, intrapelvic lymph nodes'),
    ('C8417', 'Sezary disease, spleen'),
    ('C8418', 'Sezary disease, lymph nodes of multiple sites'),
    ('C8419', 'Sezary disease, extranodal and solid organ sites'),
    ('C8440', 'Peripheral T-cell lymphoma, NEC, unspecified site'),
    ('C8441', 'Prph T-cell lymphoma, NEC, nodes of head, face, and neck'),
    ('C8442', 'Peripheral T-cell lymphoma, NEC, intrathoracic lympth nodes'),
    ('C8443', 'Peripheral T-cell lymphoma, NEC, intra-abdominal lymph nodes'),
    ('C8444', 'Prph T-cell lymphoma, NEC, nodes of axilla and upper limb'),
    ('C8445', 'Prph T-cell lymph, NEC, nodes of ing region and lower limb'),
    ('C8446', 'Peripheral T-cell lymphoma, NEC, intrapelvic nodes'),
    ('C8447', 'Peripheral T-cell lymphoma, not elsewhere classified, spleen'),
    ('C8448', 'Peripheral T-cell lymphoma, NEC, lymph nodes mult site'),
    ('C8449', 'Prph T-cell lymphoma, NEC, extrnod and solid organ sites'),
    ('C8460', 'Anaplastic large cell lymphoma, ALK-positive, unsp site'),
    ('C8461', 'Anaplstc lg cell lymph, ALK-pos, nodes of head, face, and nk'),
    ('C8462', 'Anaplastic large cell lymphoma, ALK-pos, intrathorac nodes'),
    ('C8463', 'Anaplastic large cell lymphoma, ALK-pos, intra-abd nodes'),
    ('C8464', 'Anaplstc lg cell lymph, ALK-pos, nodes of axla and upr limb'),
    ('C8465', 'Anaplstc lg cell lymph, ALK-pos, nodes of ing rgn & low lmb'),
    ('C8466', 'Anaplastic large cell lymphoma, ALK-pos, intrapelv nodes'),
    ('C8467', 'Anaplastic large cell lymphoma, ALK-positive, spleen'),
    ('C8468', 'Anaplastic large cell lymphoma, ALK-pos, nodes mult site'),
    ('C8469', 'Anaplstc lg cell lymph, ALK-pos, extrnod and solid org sites'),
    ('C8470', 'Anaplastic large cell lymphoma, ALK-negative, unsp site'),
    ('C8471', 'Anaplstc lg cell lymph, ALK-neg, nodes of head, face, and nk'),
    ('C8472', 'Anaplastic large cell lymphoma, ALK-neg, intrathorac nodes'),
    ('C8473', 'Anaplastic large cell lymphoma, ALK-neg, intra-abd nodes'),
    ('C8474', 'Anaplstc lg cell lymph, ALK-neg, nodes of axla and upr limb'),
    ('C8475', 'Anaplstc lg cell lymph, ALK-neg, nodes of ing rgn & low lmb'),
    ('C8476', 'Anaplastic large cell lymphoma, ALK-neg, intrapelv nodes'),
    ('C8477', 'Anaplastic large cell lymphoma, ALK-negative, spleen'),
    ('C8478', 'Anaplastic large cell lymphoma, ALK-neg, nodes mult site'),
    ('C8479', 'Anaplstc lg cell lymph, ALK-neg, extrnod and solid org sites'),
    ('C847A', 'Anaplastic large cell lymphoma, ALK-negative, breast'),
    ('C8490', 'Mature T/NK-cell lymphomas, unspecified, unspecified site'),
    ('C8491', 'Mature T/NK-cell lymph, unsp, nodes of head, face, and neck'),
    ('C8492', 'Mature T/NK-cell lymphomas, unsp, intrathoracic lymph nodes'),
    ('C8493', 'Mature T/NK-cell lymphomas, unsp, intra-abd lymph nodes'),
    ('C8494', 'Mature T/NK-cell lymph, unsp, nodes of axilla and upper limb'),
    ('C8495', 'Mature T/NK-cell lymph, unsp, nodes of ing rgn and low limb'),
    ('C8496', 'Mature T/NK-cell lymphomas, unsp, intrapelvic lymph nodes'),
    ('C8497', 'Mature T/NK-cell lymphomas, unspecified, spleen'),
    ('C8498', 'Mature T/NK-cell lymphomas, unsp, lymph nodes mult site'),
    ('C8499', 'Mature T/NK-cell lymph, unsp, extrnod and solid organ sites'),
    ('C84A0', 'Cutaneous T-cell lymphoma, unspecified, unspecified site'),
    ('C84A1', 'Cutan T-cell lymphoma, unsp nodes of head, face, and neck'),
    ('C84A2', 'Cutaneous T-cell lymphoma, unsp, intrathoracic lymph nodes'),
    ('C84A3', 'Cutaneous T-cell lymphoma, unsp, intra-abdominal lymph nodes'),
    ('C84A4', 'Cutan T-cell lymphoma, unsp, nodes of axilla and upper limb'),
    ('C84A5', 'Cutan T-cell lymph, unsp, nodes of ing region and lower limb'),
    ('C84A6', 'Cutaneous T-cell lymphoma, unsp, intrapelvic lymph nodes'),
    ('C84A7', 'Cutaneous T-cell lymphoma, unspecified, spleen'),
    ('C84A8', 'Cutaneous T-cell lymphoma, unsp, lymph nodes mult site'),
    ('C84A9', 'Cutan T-cell lymphoma, unsp, extrnod and solid organ sites'),
    ('C84Z0', 'Other mature T/NK-cell lymphomas, unspecified site'),
    ('C84Z1', 'Oth mature T/NK-cell lymph, nodes of head, face, and neck'),
    ('C84Z2', 'Other mature T/NK-cell lymphomas, intrathoracic lymph nodes'),
    ('C84Z3', 'Oth mature T/NK-cell lymphomas, intra-abdominal lymph nodes'),
    ('C84Z4', 'Oth mature T/NK-cell lymph, nodes of axilla and upper limb'),
    ('C84Z5', 'Oth mature T/NK-cell lymph, nodes of ing rgn and lower limb'),
    ('C84Z6', 'Other mature T/NK-cell lymphomas, intrapelvic lymph nodes'),
    ('C84Z7', 'Other mature T/NK-cell lymphomas, spleen'),
    ('C84Z8', 'Oth mature T/NK-cell lymphomas, lymph nodes mult site'),
    ('C84Z9', 'Oth mature T/NK-cell lymph, extrnod and solid organ sites'),
    ('C8510', 'Unspecified B-cell lymphoma, unspecified site'),
    ('C8511', 'Unsp B-cell lymphoma, lymph nodes of head, face, and neck'),
    ('C8512', 'Unspecified B-cell lymphoma, intrathoracic lymph nodes'),
    ('C8513', 'Unspecified B-cell lymphoma, intra-abdominal lymph nodes'),
    ('C8514', 'Unsp B-cell lymphoma, lymph nodes of axilla and upper limb'),
    ('C8515', 'Unsp B-cell lymphoma, nodes of ing region and lower limb'),
    ('C8516', 'Unspecified B-cell lymphoma, intrapelvic lymph nodes'),
    ('C8517', 'Unspecified B-cell lymphoma, spleen'),
    ('C8518', 'Unspecified B-cell lymphoma, lymph nodes of multiple sites'),
    ('C8519', 'Unsp B-cell lymphoma, extranodal and solid organ sites'),
    ('C8520', 'Mediastinal (thymic) large B-cell lymphoma, unspecified site'),
    ('C8521', 'Mediastnl large B-cell lymph, nodes of head, face, and neck'),
    ('C8522', 'Mediastnl (thymic) large B-cell lymphoma, intrathorac nodes'),
    ('C8523', 'Mediastinal (thymic) large B-cell lymphoma, intra-abd nodes'),
    ('C8524', 'Mediastnl large B-cell lymph, nodes of axilla and upper limb'),
    ('C8525', 'Mediastnl lg B-cell lymph, nodes of ing rgn and lower limb'),
    ('C8526', 'Mediastinal (thymic) large B-cell lymphoma, intrapelv nodes'),
    ('C8527', 'Mediastinal (thymic) large B-cell lymphoma, spleen'),
    ('C8528', 'Mediastinal (thymic) large B-cell lymphoma, nodes mult site'),
    ('C8529', 'Mediastnl large B-cell lymph, extrnod and solid organ sites'),
    ('C8580', 'Oth types of non-Hodgkin lymphoma, unspecified site'),
    ('C8581', 'Oth types of non-hodg lymph, nodes of head, face, and neck'),
    ('C8582', 'Oth types of non-Hodgkin lymphoma, intrathoracic lymph nodes'),
    ('C8583', 'Oth types of non-Hodgkin lymphoma, intra-abd lymph nodes'),
    ('C8584', 'Oth types of non-hodg lymph, nodes of axilla and upper limb'),
    ('C8585', 'Oth types of non-hodg lymph, nodes of ing rgn and lower limb'),
    ('C8586', 'Oth types of non-Hodgkin lymphoma, intrapelvic lymph nodes'),
    ('C8587', 'Other specified types of non-Hodgkin lymphoma, spleen'),
    ('C8588', 'Oth types of non-Hodgkin lymphoma, lymph nodes mult site'),
    ('C8589', 'Oth types of non-hodg lymph, extrnod and solid organ sites'),
    ('C8590', 'Non-Hodgkin lymphoma, unspecified, unspecified site'),
    ('C8591', 'Non-Hodgkin lymphoma, unsp, nodes of head, face, and neck'),
    ('C8592', 'Non-Hodgkin lymphoma, unspecified, intrathoracic lymph nodes'),
    ('C8593', 'Non-Hodgkin lymphoma, unsp, intra-abdominal lymph nodes'),
    ('C8594', 'Non-Hodgkin lymphoma, unsp, nodes of axilla and upper limb'),
    ('C8595', 'Non-hodg lymphoma, unsp, nodes of ing region and lower limb'),
    ('C8596', 'Non-Hodgkin lymphoma, unspecified, intrapelvic lymph nodes'),
    ('C8597', 'Non-Hodgkin lymphoma, unspecified, spleen'),
    ('C8598', 'Non-Hodgkin lymphoma, unsp, lymph nodes of multiple sites'),
    ('C8599', 'Non-Hodgkin lymphoma, unsp, extranodal and solid organ sites'),
    ('C860', 'Extranodal NK/T-cell lymphoma, nasal type'),
    ('C861', 'Hepatosplenic T-cell lymphoma'),
    ('C862', 'Enteropathy-type (intestinal) T-cell lymphoma'),
    ('C863', 'Subcutaneous panniculitis-like T-cell lymphoma'),
    ('C864', 'Blastic NK-cell lymphoma'),
    ('C865', 'Angioimmunoblastic T-cell lymphoma'),
    ('C866', 'Primary cutaneous CD30-positive T-cell proliferations'),
    ('C880', 'Waldenstrom macroglobulinemia'),
    ('C882', 'Heavy chain disease'),
    ('C883', 'Immunoproliferative small intestinal disease'),
    ('C884', 'Extrnod mrgnl zn B-cell lymph of mucosa-assoc lymphoid tiss'),
    ('C888', 'Other malignant immunoproliferative diseases'),
    ('C889', 'Malignant immunoproliferative disease, unspecified'),
    ('C9000', 'Multiple myeloma not having achieved remission'),
    ('C9001', 'Multiple myeloma in remission'),
    ('C9002', 'Multiple myeloma in relapse'),
    ('C9010', 'Plasma cell leukemia not having achieved remission'),
    ('C9011', 'Plasma cell leukemia in remission'),
    ('C9012', 'Plasma cell leukemia in relapse'),
    ('C9020', 'Extramedullary plasmacytoma not having achieved remission'),
    ('C9021', 'Extramedullary plasmacytoma in remission'),
    ('C9022', 'Extramedullary plasmacytoma in relapse'),
    ('C9030', 'Solitary plasmacytoma not having achieved remission'),
    ('C9031', 'Solitary plasmacytoma in remission'),
    ('C9032', 'Solitary plasmacytoma in relapse'),
    ('C9100', 'Acute lymphoblastic leukemia not having achieved remission'),
    ('C9101', 'Acute lymphoblastic leukemia, in remission'),
    ('C9102', 'Acute lymphoblastic leukemia, in relapse'),
    ('C9110', 'Chronic lymphocytic leuk of B-cell type not achieve remis'),
    ('C9111', 'Chronic lymphocytic leukemia of B-cell type in remission'),
    ('C9112', 'Chronic lymphocytic leukemia of B-cell type in relapse'),
    ('C9130', 'Prolymphocytic leukemia of B-cell type not achieve remission'),
    ('C9131', 'Prolymphocytic leukemia of B-cell type, in remission'),
    ('C9132', 'Prolymphocytic leukemia of B-cell type, in relapse'),
    ('C9140', 'Hairy cell leukemia not having achieved remission'),
    ('C9141', 'Hairy cell leukemia, in remission'),
    ('C9142', 'Hairy cell leukemia, in relapse'),
    ('C9150', 'Adult T-cell lymph/leuk (HTLV-1-assoc) not achieve remission'),
    ('C9151', 'Adult T-cell lymphoma/leukemia (HTLV-1-assoc), in remission'),
    ('C9152', 'Adult T-cell lymphoma/leukemia (HTLV-1-assoc), in relapse'),
    ('C9160', 'Prolymphocytic leukemia of T-cell type not achieve remission'),
    ('C9161', 'Prolymphocytic leukemia of T-cell type, in remission'),
    ('C9162', 'Prolymphocytic leukemia of T-cell type, in relapse'),
    ('C9190', 'Lymphoid leukemia, unspecified not having achieved remission'),
    ('C9191', 'Lymphoid leukemia, unspecified, in remission'),
    ('C9192', 'Lymphoid leukemia, unspecified, in relapse'),
    ('C91A0', 'Mature B-cell leukemia Burkitt-type not achieve remission'),
    ('C91A1', 'Mature B-cell leukemia Burkitt-type, in remission'),
    ('C91A2', 'Mature B-cell leukemia Burkitt-type, in relapse'),
    ('C91Z0', 'Other lymphoid leukemia not having achieved remission'),
    ('C91Z1', 'Other lymphoid leukemia, in remission'),
    ('C91Z2', 'Other lymphoid leukemia, in relapse'),
    ('C9200', 'Acute myeloblastic leukemia, not having achieved remission'),
    ('C9201', 'Acute myeloblastic leukemia, in remission'),
    ('C9202', 'Acute myeloblastic leukemia, in relapse'),
    ('C9210', 'Chronic myeloid leuk, BCR/ABL-positive, not achieve remis'),
    ('C9211', 'Chronic myeloid leukemia, BCR/ABL-positive, in remission'),
    ('C9212', 'Chronic myeloid leukemia, BCR/ABL-positive, in relapse'),
    ('C9220', 'Atyp chronic myeloid leuk, BCR/ABL-neg, not achieve remis'),
    ('C9221', 'Atypical chronic myeloid leukemia, BCR/ABL-neg, in remission'),
    ('C9222', 'Atypical chronic myeloid leukemia, BCR/ABL-neg, in relapse'),
    ('C9230', 'Myeloid sarcoma, not having achieved remission'),
    ('C9231', 'Myeloid sarcoma, in remission'),
    ('C9232', 'Myeloid sarcoma, in relapse'),
    ('C9240', 'Acute promyelocytic leukemia, not having achieved remission'),
    ('C9241', 'Acute promyelocytic leukemia, in remission'),
    ('C9242', 'Acute promyelocytic leukemia, in relapse'),
    ('C9250', 'Acute myelomonocytic leukemia, not having achieved remission'),
    ('C9251', 'Acute myelomonocytic leukemia, in remission'),
    ('C9252', 'Acute myelomonocytic leukemia, in relapse'),
    ('C9260', 'Acute myeloid leukemia w 11q23-abnormality not achieve remis'),
    ('C9261', 'Acute myeloid leukemia with 11q23-abnormality in remission'),
    ('C9262', 'Acute myeloid leukemia with 11q23-abnormality in relapse'),
    ('C9290', 'Myeloid leukemia, unspecified, not having achieved remission'),
    ('C9291', 'Myeloid leukemia, unspecified in remission'),
    ('C9292', 'Myeloid leukemia, unspecified in relapse'),
    ('C92A0', 'Acute myeloid leuk w multilin dysplasia, not achieve remis'),
    ('C92A1', 'Acute myeloid leukemia w multilin dysplasia, in remission'),
    ('C92A2', 'Acute myeloid leukemia w multilineage dysplasia, in relapse'),
    ('C92Z0', 'Other myeloid leukemia not having achieved remission'),
    ('C92Z1', 'Other myeloid leukemia, in remission'),
    ('C92Z2', 'Other myeloid leukemia, in relapse'),
    ('C9300', 'Acute monoblastic/monocytic leukemia, not achieve remission'),
    ('C9301', 'Acute monoblastic/monocytic leukemia, in remission'),
    ('C9302', 'Acute monoblastic/monocytic leukemia, in relapse'),
    ('C9310', 'Chronic myelomonocytic leukemia not achieve remission'),
    ('C9311', 'Chronic myelomonocytic leukemia, in remission'),
    ('C9312', 'Chronic myelomonocytic leukemia, in relapse'),
    ('C9330', 'Juvenile myelomonocytic leukemia, not achieve remission'),
    ('C9331', 'Juvenile myelomonocytic leukemia, in remission'),
    ('C9332', 'Juvenile myelomonocytic leukemia, in relapse'),
    ('C9390', 'Monocytic leukemia, unsp, not having achieved remission'),
    ('C9391', 'Monocytic leukemia, unspecified in remission'),
    ('C9392', 'Monocytic leukemia, unspecified in relapse'),
    ('C93Z0', 'Other monocytic leukemia, not having achieved remission'),
    ('C93Z1', 'Other monocytic leukemia, in remission'),
    ('C93Z2', 'Other monocytic leukemia, in relapse'),
    ('C9400', 'Acute erythroid leukemia, not having achieved remission'),
    ('C9401', 'Acute erythroid leukemia, in remission'),
    ('C9402', 'Acute erythroid leukemia, in relapse'),
    ('C9420', 'Acute megakaryoblastic leukemia not achieve remission'),
    ('C9421', 'Acute megakaryoblastic leukemia, in remission'),
    ('C9422', 'Acute megakaryoblastic leukemia, in relapse'),
    ('C9430', 'Mast cell leukemia not having achieved remission'),
    ('C9431', 'Mast cell leukemia, in remission'),
    ('C9432', 'Mast cell leukemia, in relapse'),
    ('C9440', 'Acute panmyelosis w myelofibrosis not achieve remission'),
    ('C9441', 'Acute panmyelosis with myelofibrosis, in remission'),
    ('C9442', 'Acute panmyelosis with myelofibrosis, in relapse'),
    ('C946', 'Myelodysplastic disease, not elsewhere classified'),
    ('C9480', 'Other specified leukemias not having achieved remission'),
    ('C9481', 'Other specified leukemias, in remission'),
    ('C9482', 'Other specified leukemias, in relapse'),
    ('C9500', 'Acute leukemia of unsp cell type not achieve remission'),
    ('C9501', 'Acute leukemia of unspecified cell type, in remission'),
    ('C9502', 'Acute leukemia of unspecified cell type, in relapse'),
    ('C9510', 'Chronic leukemia of unsp cell type not achieve remission'),
    ('C9511', 'Chronic leukemia of unspecified cell type, in remission'),
    ('C9512', 'Chronic leukemia of unspecified cell type, in relapse'),
    ('C9590', 'Leukemia, unspecified not having achieved remission'),
    ('C9591', 'Leukemia, unspecified, in remission'),
    ('C9592', 'Leukemia, unspecified, in relapse'),
    ('C960', 'Multifocal and multisystemic Langerhans-cell histiocytosis'),
    ('C962', 'Malignant mast cell tumor'),
    ('C9620', 'Malignant mast cell neoplasm, unspecified'),
    ('C9621', 'Aggressive systemic mastocytosis'),
    ('C9622', 'Mast cell sarcoma'),
    ('C9629', 'Other malignant mast cell neoplasm'),
    ('C964', 'Sarcoma of dendritic cells (accessory cells)'),
    ('C965', 'Multifocal and unisystemic Langerhans-cell histiocytosis'),
    ('C966', 'Unifocal Langerhans-cell histiocytosis'),
    ('C969', 'Malig neoplm of lymphoid, hematpoetc and rel tissue, unsp'),
    ('C96A', 'Histiocytic sarcoma'),
    ('C96Z', 'Oth malig neoplm of lymphoid, hematpoetc and related tissue'),
    ('D0000', 'Carcinoma in situ of oral cavity, unspecified site'),
    ('D0001', 'Carcinoma in situ of labial mucosa and vermilion border'),
    ('D0002', 'Carcinoma in situ of buccal mucosa'),
    ('D0003', 'Carcinoma in situ of gingiva and edentulous alveolar ridge'),
    ('D0004', 'Carcinoma in situ of soft palate'),
    ('D0005', 'Carcinoma in situ of hard palate'),
    ('D0006', 'Carcinoma in situ of floor of mouth'),
    ('D0007', 'Carcinoma in situ of tongue'),
    ('D0008', 'Carcinoma in situ of pharynx'),
    ('D001', 'Carcinoma in situ of esophagus'),
    ('D002', 'Carcinoma in situ of stomach'),
    ('D010', 'Carcinoma in situ of colon'),
    ('D011', 'Carcinoma in situ of rectosigmoid junction'),
    ('D012', 'Carcinoma in situ of rectum'),
    ('D013', 'Carcinoma in situ of anus and anal canal'),
    ('D0140', 'Carcinoma in situ of unspecified part of intestine'),
    ('D0149', 'Carcinoma in situ of other parts of intestine'),
    ('D015', 'Carcinoma in situ of liver, gallbladder and bile ducts'),
    ('D017', 'Carcinoma in situ of other specified digestive organs'),
    ('D019', 'Carcinoma in situ of digestive organ, unspecified'),
    ('D020', 'Carcinoma in situ of larynx'),
    ('D021', 'Carcinoma in situ of trachea'),
    ('D0220', 'Carcinoma in situ of unspecified bronchus and lung'),
    ('D0221', 'Carcinoma in situ of right bronchus and lung'),
    ('D0222', 'Carcinoma in situ of left bronchus and lung'),
    ('D023', 'Carcinoma in situ of other parts of respiratory system'),
    ('D024', 'Carcinoma in situ of respiratory system, unspecified'),
    ('D030', 'Melanoma in situ of lip'),
    ('D0310', 'Melanoma in situ of unspecified eyelid, including canthus'),
    ('D0311', 'Melanoma in situ of right eyelid, including canthus'),
    ('D03111', 'Melanoma in situ of right upper eyelid, including canthus'),
    ('D03112', 'Melanoma in situ of right lower eyelid, including canthus'),
    ('D0312', 'Melanoma in situ of left eyelid, including canthus'),
    ('D03121', 'Melanoma in situ of left upper eyelid, including canthus'),
    ('D03122', 'Melanoma in situ of left lower eyelid, including canthus'),
    ('D0320', 'Melanoma in situ of unsp ear and external auricular canal'),
    ('D0321', 'Melanoma in situ of right ear and external auricular canal'),
    ('D0322', 'Melanoma in situ of left ear and external auricular canal'),
    ('D0330', 'Melanoma in situ of unspecified part of face'),
    ('D0339', 'Melanoma in situ of other parts of face'),
    ('D034', 'Melanoma in situ of scalp and neck'),
    ('D0351', 'Melanoma in situ of anal skin'),
    ('D0352', 'Melanoma in situ of breast (skin) (soft tissue)'),
    ('D0359', 'Melanoma in situ of other part of trunk'),
    ('D0360', 'Melanoma in situ of unsp upper limb, including shoulder'),
    ('D0361', 'Melanoma in situ of right upper limb, including shoulder'),
    ('D0362', 'Melanoma in situ of left upper limb, including shoulder'),
    ('D0370', 'Melanoma in situ of unspecified lower limb, including hip'),
    ('D0371', 'Melanoma in situ of right lower limb, including hip'),
    ('D0372', 'Melanoma in situ of left lower limb, including hip'),
    ('D038', 'Melanoma in situ of other sites'),
    ('D039', 'Melanoma in situ, unspecified'),
    ('D040', 'Carcinoma in situ of skin of lip'),
    ('D0410', 'Carcinoma in situ of skin of unsp eyelid, including canthus'),
    ('D0411', 'Carcinoma in situ of skin of right eyelid, including canthus'),
    ('D04111', 'Ca in situ skin of right upper eyelid, including canthus'),
    ('D04112', 'Ca in situ skin of right lower eyelid, including canthus'),
    ('D0412', 'Carcinoma in situ of skin of left eyelid, including canthus'),
    ('D04121', 'Ca in situ skin of left upper eyelid, including canthus'),
    ('D04122', 'Ca in situ skin of left lower eyelid, including canthus'),
    ('D0420', 'Ca in situ skin of unsp ear and external auricular canal'),
    ('D0421', 'Ca in situ skin of right ear and external auricular canal'),
    ('D0422', 'Ca in situ skin of left ear and external auricular canal'),
    ('D0430', 'Carcinoma in situ of skin of unspecified part of face'),
    ('D0439', 'Carcinoma in situ of skin of other parts of face'),
    ('D044', 'Carcinoma in situ of skin of scalp and neck'),
    ('D045', 'Carcinoma in situ of skin of trunk'),
    ('D0460', 'Ca in situ skin of unsp upper limb, including shoulder'),
    ('D0461', 'Ca in situ skin of right upper limb, including shoulder'),
    ('D0462', 'Ca in situ skin of left upper limb, including shoulder'),
    ('D0470', 'Carcinoma in situ of skin of unsp lower limb, including hip'),
    ('D0471', 'Carcinoma in situ of skin of right lower limb, including hip'),
    ('D0472', 'Carcinoma in situ of skin of left lower limb, including hip'),
    ('D048', 'Carcinoma in situ of skin of other sites'),
    ('D049', 'Carcinoma in situ of skin, unspecified'),
    ('D0500', 'Lobular carcinoma in situ of unspecified breast'),
    ('D0501', 'Lobular carcinoma in situ of right breast'),
    ('D0502', 'Lobular carcinoma in situ of left breast'),
    ('D0510', 'Intraductal carcinoma in situ of unspecified breast'),
    ('D0511', 'Intraductal carcinoma in situ of right breast'),
    ('D0512', 'Intraductal carcinoma in situ of left breast'),
    ('D0580', 'Oth type of carcinoma in situ of unspecified breast'),
    ('D0581', 'Other specified type of carcinoma in situ of right breast'),
    ('D0582', 'Other specified type of carcinoma in situ of left breast'),
    ('D0590', 'Unspecified type of carcinoma in situ of unspecified breast'),
    ('D0591', 'Unspecified type of carcinoma in situ of right breast'),
    ('D0592', 'Unspecified type of carcinoma in situ of left breast'),
    ('D060', 'Carcinoma in situ of endocervix'),
    ('D061', 'Carcinoma in situ of exocervix'),
    ('D067', 'Carcinoma in situ of other parts of cervix'),
    ('D069', 'Carcinoma in situ of cervix, unspecified'),
    ('D070', 'Carcinoma in situ of endometrium'),
    ('D071', 'Carcinoma in situ of vulva'),
    ('D072', 'Carcinoma in situ of vagina'),
    ('D0730', 'Carcinoma in situ of unspecified female genital organs'),
    ('D0739', 'Carcinoma in situ of other female genital organs'),
    ('D074', 'Carcinoma in situ of penis'),
    ('D075', 'Carcinoma in situ of prostate'),
    ('D0760', 'Carcinoma in situ of unspecified male genital organs'),
    ('D0761', 'Carcinoma in situ of scrotum'),
    ('D0769', 'Carcinoma in situ of other male genital organs'),
    ('D090', 'Carcinoma in situ of bladder'),
    ('D0910', 'Carcinoma in situ of unspecified urinary organ'),
    ('D0919', 'Carcinoma in situ of other urinary organs'),
    ('D0920', 'Carcinoma in situ of unspecified eye'),
    ('D0921', 'Carcinoma in situ of right eye'),
    ('D0922', 'Carcinoma in situ of left eye'),
    ('D093', 'Carcinoma in situ of thyroid and other endocrine glands'),
    ('D098', 'Carcinoma in situ of other specified sites'),
    ('D099', 'Carcinoma in situ, unspecified'),
    ('D100', 'Benign neoplasm of lip'),
    ('D101', 'Benign neoplasm of tongue'),
    ('D102', 'Benign neoplasm of floor of mouth'),
    ('D1030', 'Benign neoplasm of unspecified part of mouth'),
    ('D1039', 'Benign neoplasm of other parts of mouth'),
    ('D104', 'Benign neoplasm of tonsil'),
    ('D105', 'Benign neoplasm of other parts of oropharynx'),
    ('D106', 'Benign neoplasm of nasopharynx'),
    ('D107', 'Benign neoplasm of hypopharynx'),
    ('D109', 'Benign neoplasm of pharynx, unspecified'),
    ('D110', 'Benign neoplasm of parotid gland'),
    ('D117', 'Benign neoplasm of other major salivary glands'),
    ('D119', 'Benign neoplasm of major salivary gland, unspecified'),
    ('D120', 'Benign neoplasm of cecum'),
    ('D121', 'Benign neoplasm of appendix'),
    ('D122', 'Benign neoplasm of ascending colon'),
    ('D123', 'Benign neoplasm of transverse colon'),
    ('D124', 'Benign neoplasm of descending colon'),
    ('D125', 'Benign neoplasm of sigmoid colon'),
    ('D126', 'Benign neoplasm of colon, unspecified'),
    ('D127', 'Benign neoplasm of rectosigmoid junction'),
    ('D128', 'Benign neoplasm of rectum'),
    ('D129', 'Benign neoplasm of anus and anal canal'),
    ('D130', 'Benign neoplasm of esophagus'),
    ('D131', 'Benign neoplasm of stomach'),
    ('D132', 'Benign neoplasm of duodenum'),
    ('D1330', 'Benign neoplasm of unspecified part of small intestine'),
    ('D1339', 'Benign neoplasm of other parts of small intestine'),
    ('D134', 'Benign neoplasm of liver'),
    ('D135', 'Benign neoplasm of extrahepatic bile ducts'),
    ('D136', 'Benign neoplasm of pancreas'),
    ('D137', 'Benign neoplasm of endocrine pancreas'),
    ('D139', 'Benign neoplasm of ill-defined sites within the dgstv sys'),
    ('D1391', 'Familial adenomatous polyposis'),
    ('D1399', 'Benign neoplasm of ill-defined sites within the dgstv sys'),
    ('D140', 'Benign neoplasm of mid ear, nasl cav and accessory sinuses'),
    ('D141', 'Benign neoplasm of larynx'),
    ('D142', 'Benign neoplasm of trachea'),
    ('D1430', 'Benign neoplasm of unspecified bronchus and lung'),
    ('D1431', 'Benign neoplasm of right bronchus and lung'),
    ('D1432', 'Benign neoplasm of left bronchus and lung'),
    ('D144', 'Benign neoplasm of respiratory system, unspecified'),
    ('D150', 'Benign neoplasm of thymus'),
    ('D151', 'Benign neoplasm of heart'),
    ('D152', 'Benign neoplasm of mediastinum'),
    ('D157', 'Benign neoplasm of other specified intrathoracic organs'),
    ('D159', 'Benign neoplasm of intrathoracic organ, unspecified'),
    ('D1600', 'Benign neoplasm of scapula and long bones of unsp upper limb'),
    ('D1601', 'Benign neoplm of scapula and long bones of right upper limb'),
    ('D1602', 'Benign neoplasm of scapula and long bones of left upper limb'),
    ('D1610', 'Benign neoplasm of short bones of unspecified upper limb'),
    ('D1611', 'Benign neoplasm of short bones of right upper limb'),
    ('D1612', 'Benign neoplasm of short bones of left upper limb'),
    ('D1620', 'Benign neoplasm of long bones of unspecified lower limb'),
    ('D1621', 'Benign neoplasm of long bones of right lower limb'),
    ('D1622', 'Benign neoplasm of long bones of left lower limb'),
    ('D1630', 'Benign neoplasm of short bones of unspecified lower limb'),
    ('D1631', 'Benign neoplasm of short bones of right lower limb'),
    ('D1632', 'Benign neoplasm of short bones of left lower limb'),
    ('D164', 'Benign neoplasm of bones of skull and face'),
    ('D165', 'Benign neoplasm of lower jaw bone'),
    ('D166', 'Benign neoplasm of vertebral column'),
    ('D167', 'Benign neoplasm of ribs, sternum and clavicle'),
    ('D168', 'Benign neoplasm of pelvic bones, sacrum and coccyx'),
    ('D169', 'Benign neoplasm of bone and articular cartilage, unspecified'),
    ('D170', 'Ben lipomatous neoplm of skin, subcu of head, face and neck'),
    ('D171', 'Benign lipomatous neoplasm of skin, subcu of trunk'),
    ('D1720', 'Benign lipomatous neoplasm of skin, subcu of unsp limb'),
    ('D1721', 'Benign lipomatous neoplasm of skin, subcu of right arm'),
    ('D1722', 'Benign lipomatous neoplasm of skin, subcu of left arm'),
    ('D1723', 'Benign lipomatous neoplasm of skin, subcu of right leg'),
    ('D1724', 'Benign lipomatous neoplasm of skin, subcu of left leg'),
    ('D1730', 'Benign lipomatous neoplasm of skin, subcu of unsp sites'),
    ('D1739', 'Benign lipomatous neoplasm of skin, subcu of sites'),
    ('D174', 'Benign lipomatous neoplasm of intrathoracic organs'),
    ('D175', 'Benign lipomatous neoplasm of intra-abdominal organs'),
    ('D176', 'Benign lipomatous neoplasm of spermatic cord'),
    ('D1771', 'Benign lipomatous neoplasm of kidney'),
    ('D1772', 'Benign lipomatous neoplasm of other genitourinary organ'),
    ('D1779', 'Benign lipomatous neoplasm of other sites'),
    ('D179', 'Benign lipomatous neoplasm, unspecified'),
    ('D1800', 'Hemangioma unspecified site'),
    ('D1801', 'Hemangioma of skin and subcutaneous tissue'),
    ('D1802', 'Hemangioma of intracranial structures'),
    ('D1803', 'Hemangioma of intra-abdominal structures'),
    ('D1809', 'Hemangioma of other sites'),
    ('D181', 'Lymphangioma, any site'),
    ('D190', 'Benign neoplasm of mesothelial tissue of pleura'),
    ('D191', 'Benign neoplasm of mesothelial tissue of peritoneum'),
    ('D197', 'Benign neoplasm of mesothelial tissue of other sites'),
    ('D199', 'Benign neoplasm of mesothelial tissue, unspecified'),
    ('D200', 'Benign neoplasm of soft tissue of retroperitoneum'),
    ('D201', 'Benign neoplasm of soft tissue of peritoneum'),
    ('D210', 'Benign neoplasm of connctv/soft tiss of head, face and neck'),
    ('D2110', 'Ben neoplm of connctv/soft tiss of unsp upr limb, inc shldr'),
    ('D2111', 'Ben neoplm of connctv/soft tiss of r upper limb, inc shldr'),
    ('D2112', 'Ben neoplm of connctv/soft tiss of left upr limb, inc shldr'),
    ('D2120', 'Ben neoplm of connctv/soft tiss of unsp lower limb, inc hip'),
    ('D2121', 'Ben neoplm of connctv/soft tiss of right lower limb, inc hip'),
    ('D2122', 'Ben neoplm of connctv/soft tiss of left lower limb, inc hip'),
    ('D213', 'Benign neoplasm of connective and oth soft tissue of thorax'),
    ('D214', 'Benign neoplasm of connective and oth soft tissue of abdomen'),
    ('D215', 'Benign neoplasm of connective and oth soft tissue of pelvis'),
    ('D216', 'Benign neoplasm of connctv/soft tiss of trunk, unsp'),
    ('D219', 'Benign neoplasm of connective and other soft tissue, unsp'),
    ('D220', 'Melanocytic nevi of lip'),
    ('D2210', 'Melanocytic nevi of unspecified eyelid, including canthus'),
    ('D2211', 'Melanocytic nevi of right eyelid, including canthus'),
    ('D22111', 'Melanocytic nevi of right upper eyelid, including canthus'),
    ('D22112', 'Melanocytic nevi of right lower eyelid, including canthus'),
    ('D2212', 'Melanocytic nevi of left eyelid, including canthus'),
    ('D22121', 'Melanocytic nevi of left upper eyelid, including canthus'),
    ('D22122', 'Melanocytic nevi of left lower eyelid, including canthu'),
    ('D2220', 'Melanocytic nevi of unsp ear and external auricular canal'),
    ('D2221', 'Melanocytic nevi of right ear and external auricular canal'),
    ('D2222', 'Melanocytic nevi of left ear and external auricular canal'),
    ('D2230', 'Melanocytic nevi of unspecified part of face'),
    ('D2239', 'Melanocytic nevi of other parts of face'),
    ('D224', 'Melanocytic nevi of scalp and neck'),
    ('D225', 'Melanocytic nevi of trunk'),
    ('D2260', 'Melanocytic nevi of unsp upper limb, including shoulder'),
    ('D2261', 'Melanocytic nevi of right upper limb, including shoulder'),
    ('D2262', 'Melanocytic nevi of left upper limb, including shoulder'),
    ('D2270', 'Melanocytic nevi of unspecified lower limb, including hip'),
    ('D2271', 'Melanocytic nevi of right lower limb, including hip'),
    ('D2272', 'Melanocytic nevi of left lower limb, including hip'),
    ('D229', 'Melanocytic nevi, unspecified'),
    ('D230', 'Other benign neoplasm of skin of lip'),
    ('D2310', 'Oth benign neoplasm skin/ unsp eyelid, including canthus'),
    ('D2311', 'Oth benign neoplasm skin/ right eyelid, including canthus'),
    ('D23111', 'Other benign neoplasm skin/ right upper eyelid, inc canthus'),
    ('D23112', 'Other benign neoplasm skin/ right lower eyelid, inc canthus'),
    ('D2312', 'Oth benign neoplasm skin/ left eyelid, including canthus'),
    ('D23121', 'Other benign neoplasm skin/ left upper eyelid, inc canthus'),
    ('D23122', 'Other benign neoplasm skin/ left lower eyelid, inc canthus'),
    ('D2320', 'Oth benign neoplasm skin/ unsp ear and external auric canal'),
    ('D2321', 'Oth benign neoplasm skin/ right ear and external auric canal'),
    ('D2322', 'Oth benign neoplasm skin/ left ear and external auric canal'),
    ('D2330', 'Other benign neoplasm of skin of unspecified part of face'),
    ('D2339', 'Other benign neoplasm of skin of other parts of face'),
    ('D234', 'Other benign neoplasm of skin of scalp and neck'),
    ('D235', 'Other benign neoplasm of skin of trunk'),
    ('D2360', 'Oth benign neoplasm skin/ unsp upper limb, inc shoulder'),
    ('D2361', 'Oth benign neoplasm skin/ right upper limb, inc shoulder'),
    ('D2362', 'Oth benign neoplasm skin/ left upper limb, inc shoulder'),
    ('D2370', 'Oth benign neoplasm skin/ unsp lower limb, including hip'),
    ('D2371', 'Oth benign neoplasm skin/ right lower limb, including hip'),
    ('D2372', 'Oth benign neoplasm skin/ left lower limb, including hip'),
    ('D239', 'Other benign neoplasm of skin, unspecified'),
    ('D241', 'Benign neoplasm of right breast'),
    ('D242', 'Benign neoplasm of left breast'),
    ('D249', 'Benign neoplasm of unspecified breast'),
    ('D250', 'Submucous leiomyoma of uterus'),
    ('D251', 'Intramural leiomyoma of uterus'),
    ('D252', 'Subserosal leiomyoma of uterus'),
    ('D259', 'Leiomyoma of uterus, unspecified'),
    ('D260', 'Other benign neoplasm of cervix uteri'),
    ('D261', 'Other benign neoplasm of corpus uteri'),
    ('D267', 'Other benign neoplasm of other parts of uterus'),
    ('D269', 'Other benign neoplasm of uterus, unspecified'),
    ('D270', 'Benign neoplasm of right ovary'),
    ('D271', 'Benign neoplasm of left ovary'),
    ('D279', 'Benign neoplasm of unspecified ovary'),
    ('D280', 'Benign neoplasm of vulva'),
    ('D281', 'Benign neoplasm of vagina'),
    ('D282', 'Benign neoplasm of uterine tubes and ligaments'),
    ('D287', 'Benign neoplasm of other specified female genital organs'),
    ('D289', 'Benign neoplasm of female genital organ, unspecified'),
    ('D290', 'Benign neoplasm of penis'),
    ('D291', 'Benign neoplasm of prostate'),
    ('D2920', 'Benign neoplasm of unspecified testis'),
    ('D2921', 'Benign neoplasm of right testis'),
    ('D2922', 'Benign neoplasm of left testis'),
    ('D2930', 'Benign neoplasm of unspecified epididymis'),
    ('D2931', 'Benign neoplasm of right epididymis'),
    ('D2932', 'Benign neoplasm of left epididymis'),
    ('D294', 'Benign neoplasm of scrotum'),
    ('D298', 'Benign neoplasm of other specified male genital organs'),
    ('D299', 'Benign neoplasm of male genital organ, unspecified'),
    ('D3000', 'Benign neoplasm of unspecified kidney'),
    ('D3001', 'Benign neoplasm of right kidney'),
    ('D3002', 'Benign neoplasm of left kidney'),
    ('D3010', 'Benign neoplasm of unspecified renal pelvis'),
    ('D3011', 'Benign neoplasm of right renal pelvis'),
    ('D3012', 'Benign neoplasm of left renal pelvis'),
    ('D3020', 'Benign neoplasm of unspecified ureter'),
    ('D3021', 'Benign neoplasm of right ureter'),
    ('D3022', 'Benign neoplasm of left ureter'),
    ('D303', 'Benign neoplasm of bladder'),
    ('D304', 'Benign neoplasm of urethra'),
    ('D308', 'Benign neoplasm of other specified urinary organs'),
    ('D309', 'Benign neoplasm of urinary organ, unspecified'),
    ('D3100', 'Benign neoplasm of unspecified conjunctiva'),
    ('D3101', 'Benign neoplasm of right conjunctiva'),
    ('D3102', 'Benign neoplasm of left conjunctiva'),
    ('D3110', 'Benign neoplasm of unspecified cornea'),
    ('D3111', 'Benign neoplasm of right cornea'),
    ('D3112', 'Benign neoplasm of left cornea'),
    ('D3120', 'Benign neoplasm of unspecified retina'),
    ('D3121', 'Benign neoplasm of right retina'),
    ('D3122', 'Benign neoplasm of left retina'),
    ('D3130', 'Benign neoplasm of unspecified choroid'),
    ('D3131', 'Benign neoplasm of right choroid'),
    ('D3132', 'Benign neoplasm of left choroid'),
    ('D3140', 'Benign neoplasm of unspecified ciliary body'),
    ('D3141', 'Benign neoplasm of right ciliary body'),
    ('D3142', 'Benign neoplasm of left ciliary body'),
    ('D3150', 'Benign neoplasm of unspecified lacrimal gland and duct'),
    ('D3151', 'Benign neoplasm of right lacrimal gland and duct'),
    ('D3152', 'Benign neoplasm of left lacrimal gland and duct'),
    ('D3160', 'Benign neoplasm of unspecified site of unspecified orbit'),
    ('D3161', 'Benign neoplasm of unspecified site of right orbit'),
    ('D3162', 'Benign neoplasm of unspecified site of left orbit'),
    ('D3190', 'Benign neoplasm of unspecified part of unspecified eye'),
    ('D3191', 'Benign neoplasm of unspecified part of right eye'),
    ('D3192', 'Benign neoplasm of unspecified part of left eye'),
    ('D320', 'Benign neoplasm of cerebral meninges'),
    ('D321', 'Benign neoplasm of spinal meninges'),
    ('D329', 'Benign neoplasm of meninges, unspecified'),
    ('D330', 'Benign neoplasm of brain, supratentorial'),
    ('D331', 'Benign neoplasm of brain, infratentorial'),
    ('D332', 'Benign neoplasm of brain, unspecified'),
    ('D333', 'Benign neoplasm of cranial nerves'),
    ('D334', 'Benign neoplasm of spinal cord'),
    ('D337', 'Benign neoplasm of oth parts of central nervous system'),
    ('D339', 'Benign neoplasm of central nervous system, unspecified'),
    ('D34', 'Benign neoplasm of thyroid gland'),
    ('D3500', 'Benign neoplasm of unspecified adrenal gland'),
    ('D3501', 'Benign neoplasm of right adrenal gland'),
    ('D3502', 'Benign neoplasm of left adrenal gland'),
    ('D351', 'Benign neoplasm of parathyroid gland'),
    ('D352', 'Benign neoplasm of pituitary gland'),
    ('D353', 'Benign neoplasm of craniopharyngeal duct'),
    ('D354', 'Benign neoplasm of pineal gland'),
    ('D355', 'Benign neoplasm of carotid body'),
    ('D356', 'Benign neoplasm of aortic body and other paraganglia'),
    ('D357', 'Benign neoplasm of other specified endocrine glands'),
    ('D359', 'Benign neoplasm of endocrine gland, unspecified'),
    ('D360', 'Benign neoplasm of lymph nodes'),
    ('D3610', 'Benign neoplasm of prph nerves and autonm nervous sys, unsp'),
    ('D3611', 'Ben neoplm of prph nerves and autonm nrv sys of face/hed/nk'),
    ('D3612', 'Ben neoplm of prph nrv & autonm nrv sys, upr lmb, inc shldr'),
    ('D3613', 'Ben neoplm of prph nrv & autonm nrv sys of low lmb, inc hip'),
    ('D3614', 'Benign neoplm of prph nerves and autonm nrv sys of thorax'),
    ('D3615', 'Benign neoplm of prph nerves and autonm nervous sys of abd'),
    ('D3616', 'Benign neoplm of prph nerves and autonm nrv sys of pelvis'),
    ('D3617', 'Ben neoplm of prph nerves and autonm nrv sys of trunk, unsp'),
    ('D367', 'Benign neoplasm of other specified sites'),
    ('D369', 'Benign neoplasm, unspecified site'),
    ('D3701', 'Neoplasm of uncertain behavior of lip'),
    ('D3702', 'Neoplasm of uncertain behavior of tongue'),
    ('D37030', 'Neoplasm of uncertain behavior of the parotid salivary gland'),
    ('D37031', 'Neoplasm of uncrt behavior of the sublingual salivary gland'),
    ('D37032', 'Neoplasm of uncrt behav of the submandibular salivary gland'),
    ('D37039', 'Neoplasm of uncrt behavior of the major salivary gland, unsp'),
    ('D3704', 'Neoplasm of uncertain behavior of the minor salivary glands'),
    ('D3705', 'Neoplasm of uncertain behavior of pharynx'),
    ('D3709', 'Neoplasm of uncertain behavior of sites of the oral cavity'),
    ('D371', 'Neoplasm of uncertain behavior of stomach'),
    ('D372', 'Neoplasm of uncertain behavior of small intestine'),
    ('D373', 'Neoplasm of uncertain behavior of appendix'),
    ('D374', 'Neoplasm of uncertain behavior of colon'),
    ('D375', 'Neoplasm of uncertain behavior of rectum'),
    ('D376', 'Neoplasm of uncertain behavior of liver, GB & bile duct'),
    ('D378', 'Neoplasm of uncertain behavior of oth digestive organs'),
    ('D379', 'Neoplasm of uncertain behavior of digestive organ, unsp'),
    ('D380', 'Neoplasm of uncertain behavior of larynx'),
    ('D381', 'Neoplasm of uncertain behavior of trachea, bronchus and lung'),
    ('D382', 'Neoplasm of uncertain behavior of pleura'),
    ('D383', 'Neoplasm of uncertain behavior of mediastinum'),
    ('D384', 'Neoplasm of uncertain behavior of thymus'),
    ('D385', 'Neoplasm of uncertain behavior of other respiratory organs'),
    ('D386', 'Neoplasm of uncertain behavior of respiratory organ, unsp'),
    ('D390', 'Neoplasm of uncertain behavior of uterus'),
    ('D3910', 'Neoplasm of uncertain behavior of unspecified ovary'),
    ('D3911', 'Neoplasm of uncertain behavior of right ovary'),
    ('D3912', 'Neoplasm of uncertain behavior of left ovary'),
    ('D392', 'Neoplasm of uncertain behavior of placenta'),
    ('D398', 'Neoplasm of uncertain behavior of oth female genital organs'),
    ('D399', 'Neoplasm of uncertain behavior of female genital organ, unsp'),
    ('D3A00', 'Benign carcinoid tumor of unspecified site'),
    ('D3A010', 'Benign carcinoid tumor of the duodenum'),
    ('D3A011', 'Benign carcinoid tumor of the jejunum'),
    ('D3A012', 'Benign carcinoid tumor of the ileum'),
    ('D3A019', 'Benign carcinoid tumor of the small intestine, unsp portion'),
    ('D3A020', 'Benign carcinoid tumor of the appendix'),
    ('D3A021', 'Benign carcinoid tumor of the cecum'),
    ('D3A022', 'Benign carcinoid tumor of the ascending colon'),
    ('D3A023', 'Benign carcinoid tumor of the transverse colon'),
    ('D3A024', 'Benign carcinoid tumor of the descending colon'),
    ('D3A025', 'Benign carcinoid tumor of the sigmoid colon'),
    ('D3A026', 'Benign carcinoid tumor of the rectum'),
    ('D3A029', 'Benign carcinoid tumor of the large intestine, unsp portion'),
    ('D3A090', 'Benign carcinoid tumor of the bronchus and lung'),
    ('D3A091', 'Benign carcinoid tumor of the thymus'),
    ('D3A092', 'Benign carcinoid tumor of the stomach'),
    ('D3A093', 'Benign carcinoid tumor of the kidney'),
    ('D3A094', 'Benign carcinoid tumor of the foregut unsp'),
    ('D3A095', 'Benign carcinoid tumor of the midgut unsp'),
    ('D3A096', 'Benign carcinoid tumor of the hindgut unsp'),
    ('D3A098', 'Benign carcinoid tumors of other sites'),
    ('D3A8', 'Other benign neuroendocrine tumors'),
    ('D400', 'Neoplasm of uncertain behavior of prostate'),
    ('D4010', 'Neoplasm of uncertain behavior of unspecified testis'),
    ('D4011', 'Neoplasm of uncertain behavior of right testis'),
    ('D4012', 'Neoplasm of uncertain behavior of left testis'),
    ('D408', 'Neoplasm of uncertain behavior of oth male genital organs'),
    ('D409', 'Neoplasm of uncertain behavior of male genital organ, unsp'),
    ('D4100', 'Neoplasm of uncertain behavior of unspecified kidney'),
    ('D4101', 'Neoplasm of uncertain behavior of right kidney'),
    ('D4102', 'Neoplasm of uncertain behavior of left kidney'),
    ('D4110', 'Neoplasm of uncertain behavior of unspecified renal pelvis'),
    ('D4111', 'Neoplasm of uncertain behavior of right renal pelvis'),
    ('D4112', 'Neoplasm of uncertain behavior of left renal pelvis'),
    ('D4120', 'Neoplasm of uncertain behavior of unspecified ureter'),
    ('D4121', 'Neoplasm of uncertain behavior of right ureter'),
    ('D4122', 'Neoplasm of uncertain behavior of left ureter'),
    ('D413', 'Neoplasm of uncertain behavior of urethra'),
    ('D414', 'Neoplasm of uncertain behavior of bladder'),
    ('D418', 'Neoplasm of uncertain behavior of oth urinary organs'),
    ('D419', 'Neoplasm of uncertain behavior of unspecified urinary organ'),
    ('D420', 'Neoplasm of uncertain behavior of cerebral meninges'),
    ('D421', 'Neoplasm of uncertain behavior of spinal meninges'),
    ('D429', 'Neoplasm of uncertain behavior of meninges, unspecified'),
    ('D430', 'Neoplasm of uncertain behavior of brain, supratentorial'),
    ('D431', 'Neoplasm of uncertain behavior of brain, infratentorial'),
    ('D432', 'Neoplasm of uncertain behavior of brain, unspecified'),
    ('D433', 'Neoplasm of uncertain behavior of cranial nerves'),
    ('D434', 'Neoplasm of uncertain behavior of spinal cord'),
    ('D438', 'Neoplasm of uncertain behavior of prt central nervous system'),
    ('D439', 'Neoplasm of uncertain behavior of cnsl, unsp'),
    ('D440', 'Neoplasm of uncertain behavior of thyroid gland'),
    ('D4410', 'Neoplasm of uncertain behavior of unspecified adrenal gland'),
    ('D4411', 'Neoplasm of uncertain behavior of right adrenal gland'),
    ('D4412', 'Neoplasm of uncertain behavior of left adrenal gland'),
    ('D442', 'Neoplasm of uncertain behavior of parathyroid gland'),
    ('D443', 'Neoplasm of uncertain behavior of pituitary gland'),
    ('D444', 'Neoplasm of uncertain behavior of craniopharyngeal duct'),
    ('D445', 'Neoplasm of uncertain behavior of pineal gland'),
    ('D446', 'Neoplasm of uncertain behavior of carotid body'),
    ('D447', 'Neoplasm of uncrt behav of aortic body and oth paraganglia'),
    ('D449', 'Neoplasm of uncertain behavior of unsp endocrine gland'),
    ('D45', 'Polycythemia vera'),
    ('D460', 'Refractory anemia without ring sideroblasts, so stated'),
    ('D461', 'Refractory anemia with ring sideroblasts'),
    ('D4620', 'Refractory anemia with excess of blasts, unspecified'),
    ('D4621', 'Refractory anemia with excess of blasts 1'),
    ('D4622', 'Refractory anemia with excess of blasts 2'),
    ('D464', 'Refractory anemia, unspecified'),
    ('D469', 'Myelodysplastic syndrome, unspecified'),
    ('D46A', 'Refractory cytopenia with multilineage dysplasia'),
    ('D46B', 'Refract cytopenia w multilin dysplasia and ring sideroblasts'),
    ('D46C', 'Myelodysplastic syndrome w isolated del(5q) chromsoml abnlt'),
    ('D46Z', 'Other myelodysplastic syndromes'),
    ('D470', 'Histiocytic and mast cell tumors of uncertain behavior'),
    ('D4701', 'Cutaneous mastocytosis'),
    ('D4702', 'Systemic mastocytosis'),
    ('D4709', 'Other mast cell neoplasms of uncertain behavior'),
    ('D471', 'Chronic myeloproliferative disease'),
    ('D472', 'Monoclonal gammopathy'),
    ('D473', 'Essential (hemorrhagic) thrombocythemia'),
    ('D474', 'Osteomyelofibrosis'),
    ('D479', 'Neoplm of uncrt behav of lymphoid,hematpoetc & rel tiss,unsp'),
    ('D47Z1', 'Post-transplant lymphoproliferative disorder (PTLD)'),
    ('D47Z2', 'Castleman disease'),
    ('D47Z9', 'Oth neoplm of uncrt behav of lymphoid, hematpoetc & rel tiss'),
    ('D480', 'Neoplasm of uncertain behavior of bone/artic cartl'),
    ('D481', 'Neoplasm of uncertain behavior of connctv/soft tiss'),
    ('D48110', 'Desmoid tumor of head and neck'),
    ('D48111', 'Desmoid tumor of chest wall'),
    ('D48112', 'Desmoid tumor, intrathoracic'),
    ('D48113', 'Desmoid tumor of abdominal wall'),
    ('D48114', 'Desmoid tumor, intraabdominal'),
    ('D48115', 'Desmoid tumor of upper extremity and shoulder girdle'),
    ('D48116', 'Desmoid tumor of lower extremity and pelvic girdle'),
    ('D48117', 'Desmoid tumor of back'),
    ('D48118', 'Desmoid tumor of other site'),
    ('D48119', 'Desmoid tumor of unspecified site'),
    ('D4819', 'Oth neoplasm of uncertain behavior of connctv/soft tiss'),
    ('D482', 'Neoplm of uncrt behav of prph nerves and autonm nervous sys'),
    ('D483', 'Neoplasm of uncertain behavior of retroperitoneum'),
    ('D484', 'Neoplasm of uncertain behavior of peritoneum'),
    ('D485', 'Neoplasm of uncertain behavior of skin'),
    ('D4860', 'Neoplasm of uncertain behavior of unspecified breast'),
    ('D4861', 'Neoplasm of uncertain behavior of right breast'),
    ('D4862', 'Neoplasm of uncertain behavior of left breast'),
    ('D487', 'Neoplasm of uncertain behavior of other specified sites'),
    ('D489', 'Neoplasm of uncertain behavior, unspecified'),
    ('D490', 'Neoplasm of unspecified behavior of digestive system'),
    ('D491', 'Neoplasm of unspecified behavior of respiratory system'),
    ('D492', 'Neoplasm of unsp behavior of bone, soft tissue, and skin'),
    ('D493', 'Neoplasm of unspecified behavior of breast'),
    ('D494', 'Neoplasm of unspecified behavior of bladder'),
    ('D495', 'Neoplasm of unsp behavior of other genitourinary organs'),
    ('D49511', 'Neoplasm of unspecified behavior of right kidney'),
    ('D49512', 'Neoplasm of unspecified behavior of left kidney'),
    ('D49519', 'Neoplasm of unspecified behavior of unspecified kidney'),
    ('D4959', 'Neoplasm of unspecified behavior of other GU organ'),
    ('D496', 'Neoplasm of unspecified behavior of brain'),
    ('D497', 'Neoplm of unsp behav of endo glands and oth prt nervous sys'),
    ('D4981', 'Neoplasm of unspecified behavior of retina and choroid'),
    ('D4989', 'Neoplasm of unspecified behavior of other specified sites'),
    ('D499', 'Neoplasm of unspecified behavior of unspecified site'),
    ('D500', 'Iron deficiency anemia secondary to blood loss (chronic)'),
    ('D501', 'Sideropenic dysphagia'),
    ('D508', 'Other iron deficiency anemias'),
    ('D509', 'Iron deficiency anemia, unspecified'),
    ('D510', 'Vitamin B12 defic anemia due to intrinsic factor deficiency'),
    ('D511', 'Vit B12 defic anemia d/t slctv vit B12 malabsorp w protein'),
    ('D512', 'Transcobalamin II deficiency'),
    ('D513', 'Other dietary vitamin B12 deficiency anemia'),
    ('D518', 'Other vitamin B12 deficiency anemias'),
    ('D519', 'Vitamin B12 deficiency anemia, unspecified'),
    ('D520', 'Dietary folate deficiency anemia'),
    ('D521', 'Drug-induced folate deficiency anemia'),
    ('D528', 'Other folate deficiency anemias'),
    ('D529', 'Folate deficiency anemia, unspecified'),
    ('D530', 'Protein deficiency anemia'),
    ('D531', 'Other megaloblastic anemias, not elsewhere classified'),
    ('D532', 'Scorbutic anemia'),
    ('D538', 'Other specified nutritional anemias'),
    ('D539', 'Nutritional anemia, unspecified'),
    ('D550', 'Anemia due to glucose-6-phosphate dehydrogenase deficiency'),
    ('D551', 'Anemia due to other disorders of glutathione metabolism'),
    ('D552', 'Anemia due to disorders of glycolytic enzymes'),
    ('D5521', 'Anemia due to pyruvate kinase deficiency'),
    ('D5529', 'Anemia due to other disorders of glycolytic enzymes'),
    ('D553', 'Anemia due to disorders of nucleotide metabolism'),
    ('D558', 'Other anemias due to enzyme disorders'),
    ('D559', 'Anemia due to enzyme disorder, unspecified'),
    ('D560', 'Alpha thalassemia'),
    ('D561', 'Beta thalassemia'),
    ('D562', 'Delta-beta thalassemia'),
    ('D563', 'Thalassemia minor'),
    ('D564', 'Hereditary persistence of fetal hemoglobin [HPFH]'),
    ('D565', 'Hemoglobin E-beta thalassemia'),
    ('D568', 'Other thalassemias'),
    ('D569', 'Thalassemia, unspecified'),
    ('D5700', 'Hb-SS disease with crisis, unspecified'),
    ('D5701', 'Hb-SS disease with acute chest syndrome'),
    ('D5702', 'Hb-SS disease with splenic sequestration'),
    ('D5703', 'Hb-SS disease with cerebral vascular involvement'),
    ('D5704', 'Hb-SS disease with dactylitis'),
    ('D5709', 'Hb-SS disease with crisis with other specified complication'),
    ('D571', 'Sickle-cell disease without crisis'),
    ('D5720', 'Sickle-cell/Hb-C disease without crisis'),
    ('D57211', 'Sickle-cell/Hb-C disease with acute chest syndrome'),
    ('D57212', 'Sickle-cell/Hb-C disease with splenic sequestration'),
    ('D57213', 'Sickle-cell/Hb-C disease with cerebral vascular involvement'),
    ('D57214', 'Sickle-cell/Hb-C disease with dactylitis'),
    ('D57218', 'Sickle-cell/Hb-C disease with crisis with oth complication'),
    ('D57219', 'Sickle-cell/Hb-C disease with crisis, unspecified'),
    ('D573', 'Sickle-cell trait'),
    ('D5740', 'Sickle-cell thalassemia without crisis'),
    ('D5741', 'Sickle-cell thalassemia, unspecified, with crisis'),
    ('D57411', 'Sickle-cell thalassemia, unsp, with acute chest syndrome'),
    ('D57412', 'Sickle-cell thalassemia, unsp, with splenic sequestration'),
    ('D57413', 'Sickle-cell thalassemia, unsp, with cerebral vascular invl'),
    ('D57414', 'Sickle-cell thalassemia, unspecified, with dactylitis'),
    ('D57418', 'Sickle-cell thalassemia, unsp, with crisis with oth comp'),
    ('D57419', 'Sickle-cell thalassemia, unspecified, with crisis'),
    ('D5742', 'Sickle-cell thalassemia beta zero without crisis'),
    ('D57431', 'Sickle-cell thalassemia beta zero with acute chest syndrome'),
    ('D57432', 'Sickle-cell thalassemia beta zero with splenic sequestration'),
    ('D57433', 'Sickle-cell thalassemia beta zero with cereb vascular invl'),
    ('D57434', 'Sickle-cell thalassemia beta zero with dactylitis'),
    ('D57438', 'Sickle-cell thalassemia beta zero with crisis with oth comp'),
    ('D57439', 'Sickle-cell thalassemia beta zero with crisis, unspecified'),
    ('D5744', 'Sickle-cell thalassemia beta plus without crisis'),
    ('D57451', 'Sickle-cell thalassemia beta plus with acute chest syndrome'),
    ('D57452', 'Sickle-cell thalassemia beta plus with splenic sequestration'),
    ('D57453', 'Sickle-cell thalassemia beta plus with cereb vascular invl'),
    ('D57454', 'Sickle-cell thalassemia beta plus with dactylitis'),
    ('D57458', 'Sickle-cell thalassemia beta plus with crisis with oth comp'),
    ('D57459', 'Sickle-cell thalassemia beta plus with crisis, unspecified'),
    ('D5780', 'Other sickle-cell disorders without crisis'),
    ('D57811', 'Other sickle-cell disorders with acute chest syndrome'),
    ('D57812', 'Other sickle-cell disorders with splenic sequestration'),
    ('D57813', 'Other sickle-cell disorders with cerebral vascular invl '),
    ('D57814', 'Other sickle-cell disorders with dactylitis'),
    ('D57818', 'Other sickle-cell disorders with crisis with oth comp '),
    ('D57819', 'Other sickle-cell disorders with crisis, unspecified'),
    ('D580', 'Hereditary spherocytosis'),
    ('D581', 'Hereditary elliptocytosis'),
    ('D582', 'Other hemoglobinopathies'),
    ('D588', 'Other specified hereditary hemolytic anemias'),
    ('D589', 'Hereditary hemolytic anemia, unspecified'),
    ('D590', 'Drug-induced autoimmune hemolytic anemia'),
    ('D591', 'Other autoimmune hemolytic anemias'),
    ('D5910', 'Autoimmune hemolytic anemia, unspecified'),
    ('D5911', 'Warm autoimmune hemolytic anemia'),
    ('D5912', 'Cold autoimmune hemolytic anemia'),
    ('D5913', 'Mixed type autoimmune hemolytic anemia '),
    ('D5919', 'Other autoimmune hemolytic anemia '),
    ('D592', 'Drug-induced nonautoimmune hemolytic anemia'),
    ('D593', 'Hemolytic-uremic syndrome'),
    ('D5930', 'Hemolytic-uremic syndrome, unspecified'),
    ('D5931', 'Infection-associated hemolytic-uremic syndrome'),
    ('D5932', 'Hereditary hemolytic-uremic syndrome'),
    ('D5939', 'Other hemolytic-uremic syndrome'),
    ('D594', 'Other nonautoimmune hemolytic anemias'),
    ('D595', 'Paroxysmal nocturnal hemoglobinuria [Marchiafava-Micheli]'),
    ('D596', 'Hemoglobinuria due to hemolysis from other external causes'),
    ('D598', 'Other acquired hemolytic anemias'),
    ('D599', 'Acquired hemolytic anemia, unspecified'),
    ('D600', 'Chronic acquired pure red cell aplasia'),
    ('D601', 'Transient acquired pure red cell aplasia'),
    ('D608', 'Other acquired pure red cell aplasias'),
    ('D609', 'Acquired pure red cell aplasia, unspecified'),
    ('D6101', 'Constitutional (pure) red blood cell aplasia'),
    ('D6102', 'Shwachman-Diamond syndrome'),
    ('D6109', 'Other constitutional aplastic anemia'),
    ('D611', 'Drug-induced aplastic anemia'),
    ('D612', 'Aplastic anemia due to other external agents'),
    ('D613', 'Idiopathic aplastic anemia'),
    ('D61810', 'Antineoplastic chemotherapy induced pancytopenia'),
    ('D61811', 'Other drug-induced pancytopenia'),
    ('D61818', 'Other pancytopenia'),
    ('D6182', 'Myelophthisis'),
    ('D6189', 'Oth aplastic anemias and other bone marrow failure syndromes'),
    ('D619', 'Aplastic anemia, unspecified'),
    ('D62', 'Acute posthemorrhagic anemia'),
    ('D630', 'Anemia in neoplastic disease'),
    ('D631', 'Anemia in chronic kidney disease'),
    ('D638', 'Anemia in other chronic diseases classified elsewhere'),
    ('D640', 'Hereditary sideroblastic anemia'),
    ('D641', 'Secondary sideroblastic anemia due to disease'),
    ('D642', 'Secondary sideroblastic anemia due to drugs and toxins'),
    ('D643', 'Other sideroblastic anemias'),
    ('D644', 'Congenital dyserythropoietic anemia'),
    ('D6481', 'Anemia due to antineoplastic chemotherapy'),
    ('D6489', 'Other specified anemias'),
    ('D649', 'Anemia, unspecified'),
    ('D65', 'Disseminated intravascular coagulation'),
    ('D66', 'Hereditary factor VIII deficiency'),
    ('D67', 'Hereditary factor IX deficiency'),
    ('D680', "Von Willebrand's disease"),
    ('D6800', 'Von Willebrand disease, unspecified'),
    ('D6801', 'Von Willebrand disease, type 1'),
    ('D68020', 'Von Willebrand disease, type 2A'),
    ('D68021', 'Von Willebrand disease, type 2B'),
    ('D68022', 'Von Willebrand disease, type 2M'),
    ('D68023', 'Von Willebrand disease, type 2N'),
    ('D68029', 'Von Willebrand disease, type 2, unspecified'),
    ('D6803', 'Von Willebrand disease, type 3'),
    ('D6804', 'Acquired von Willebrand disease'),
    ('D6809', 'Other von Willebrand disease'),
    ('D681', 'Hereditary factor XI deficiency'),
    ('D682', 'Hereditary deficiency of other clotting factors'),
    ('D68311', 'Acquired hemophilia'),
    ('D68312', 'Antiphospholipid antibody with hemorrhagic disorder'),
    ('D68318', 'Oth hemorrhagic disord d/t intrns circ anticoag,antib,inhib'),
    ('D6832', 'Hemorrhagic disord d/t extrinsic circulating anticoagulants'),
    ('D684', 'Acquired coagulation factor deficiency'),
    ('D6851', 'Activated protein C resistance'),
    ('D6852', 'Prothrombin gene mutation'),
    ('D6859', 'Other primary thrombophilia'),
    ('D6861', 'Antiphospholipid syndrome'),
    ('D6862', 'Lupus anticoagulant syndrome'),
    ('D6869', 'Other thrombophilia'),
    ('D688', 'Other specified coagulation defects'),
    ('D689', 'Coagulation defect, unspecified'),
    ('D690', 'Allergic purpura'),
    ('D691', 'Qualitative platelet defects'),
    ('D692', 'Other nonthrombocytopenic purpura'),
    ('D693', 'Immune thrombocytopenic purpura'),
    ('D6941', 'Evans syndrome'),
    ('D6942', 'Congenital and hereditary thrombocytopenia purpura'),
    ('D6949', 'Other primary thrombocytopenia'),
    ('D6951', 'Posttransfusion purpura'),
    ('D6959', 'Other secondary thrombocytopenia'),
    ('D696', 'Thrombocytopenia, unspecified'),
    ('D698', 'Other specified hemorrhagic conditions'),
    ('D699', 'Hemorrhagic condition, unspecified'),
    ('D700', 'Congenital agranulocytosis'),
    ('D701', 'Agranulocytosis secondary to cancer chemotherapy'),
    ('D702', 'Other drug-induced agranulocytosis'),
    ('D703', 'Neutropenia due to infection'),
    ('D704', 'Cyclic neutropenia'),
    ('D708', 'Other neutropenia'),
    ('D709', 'Neutropenia, unspecified'),
    ('D71', 'Functional disorders of polymorphonuclear neutrophils'),
    ('D720', 'Genetic anomalies of leukocytes'),
    ('D721', 'Eosinophilia'),
    ('D7210', 'Eosinophilia, unspecified'),
    ('D72110', 'Idiopathic hypereosinophilic syndrome [IHES]'),
    ('D72111', 'Lymphocytic Variant Hypereosinophilic Syndrome [LHES]'),
    ('D72118', 'Other hypereosinophilic syndrome'),
    ('D72119', 'Hypereosinophilic syndrome [HES], unspecified'),
    ('D7212', 'Drug rash with eosinophilia and systemic symptoms syndrome'),
    ('D7218', 'Eosinophilia in diseases classified elsewhere'),
    ('D7219', 'Other eosinophilia'),
    ('D72810', 'Lymphocytopenia'),
    ('D72818', 'Other decreased white blood cell count'),
    ('D72819', 'Decreased white blood cell count, unspecified'),
    ('D72820', 'Lymphocytosis (symptomatic)'),
    ('D72821', 'Monocytosis (symptomatic)'),
    ('D72822', 'Plasmacytosis'),
    ('D72823', 'Leukemoid reaction'),
    ('D72824', 'Basophilia'),
    ('D72825', 'Bandemia'),
    ('D72828', 'Other elevated white blood cell count'),
    ('D72829', 'Elevated white blood cell count, unspecified'),
    ('D7289', 'Other specified disorders of white blood cells'),
    ('D729', 'Disorder of white blood cells, unspecified'),
    ('D730', 'Hyposplenism'),
    ('D731', 'Hypersplenism'),
    ('D732', 'Chronic congestive splenomegaly'),
    ('D733', 'Abscess of spleen'),
    ('D734', 'Cyst of spleen'),
    ('D735', 'Infarction of spleen'),
    ('D7381', 'Neutropenic splenomegaly'),
    ('D7389', 'Other diseases of spleen'),
    ('D739', 'Disease of spleen, unspecified'),
    ('D740', 'Congenital methemoglobinemia'),
    ('D748', 'Other methemoglobinemias'),
    ('D749', 'Methemoglobinemia, unspecified'),
    ('D750', 'Familial erythrocytosis'),
    ('D751', 'Secondary polycythemia'),
    ('D7581', 'Myelofibrosis'),
    ('D7582', 'Heparin induced thrombocytopenia (HIT)'),
    ('D75821', 'Non-immune heparin-induced thrombocytopenia'),
    ('D75822', 'Immune-mediated heparin-induced thrombocytopenia'),
    ('D75828', 'Other heparin-induced thrombocytopenia syndrome'),
    ('D75829', 'Heparin-induced thrombocytopenia, unspecified'),
    ('D75838', 'Other thrombocytosis'),
    ('D75839', 'Thrombocytosis, unspecified'),
    ('D7584', 'Other platelet-activating anti-PF4 disorders'),
    ('D7589', 'Other specified diseases of blood and blood-forming organs'),
    ('D759', 'Disease of blood and blood-forming organs, unspecified'),
    ('D75A', 'Glucose-6-phosphate dehydrgnse (G6PD) defic without anemia'),
    ('D761', 'Hemophagocytic lymphohistiocytosis'),
    ('D762', 'Hemophagocytic syndrome, infection-associated'),
    ('D763', 'Other histiocytosis syndromes'),
    ('D77', 'Oth disord of bld/bld-frm organs in diseases classd elswhr'),
    ('D7801', 'Intraop hemor/hemtom of the spleen comp a proc on the spleen'),
    ('D7802', 'Intraop hemor/hemtom of the spleen comp oth procedure'),
    ('D7811', 'Accidental pnctr & lac of the spleen dur proc on the spleen'),
    ('D7812', 'Accidental pnctr & lac of the spleen during oth procedure'),
    ('D7821', 'Postprocedural hemor of the spleen fol proc on spleen'),
    ('D7822', 'Postproc hemor of the spleen following oth procedure'),
    ('D7831', 'Postprocedural hematoma of the spleen fol proc on spleen'),
    ('D7832', 'Postproc hematoma of the spleen following other procedure'),
    ('D7833', 'Postprocedural seroma of the spleen fol proc on spleen'),
    ('D7834', 'Postproc seroma of the spleen following other procedure'),
    ('D7881', 'Other intraoperative complications of the spleen'),
    ('D7889', 'Other postprocedural complications of the spleen'),
    ('D800', 'Hereditary hypogammaglobulinemia'),
    ('D801', 'Nonfamilial hypogammaglobulinemia'),
    ('D802', 'Selective deficiency of immunoglobulin A [IgA]'),
    ('D803', 'Selective deficiency of immunoglobulin G [IgG] subclasses'),
    ('D804', 'Selective deficiency of immunoglobulin M [IgM]'),
    ('D805', 'Immunodeficiency with increased immunoglobulin M [IgM]'),
    ('D806', 'Antibody defic w near-norm immunoglob or w hyperimmunoglob'),
    ('D807', 'Transient hypogammaglobulinemia of infancy'),
    ('D808', 'Other immunodeficiencies with predominantly antibody defects'),
    ('D809', 'Immunodeficiency with predominantly antibody defects, unsp'),
    ('D810', 'Severe combined immunodeficiency with reticular dysgenesis'),
    ('D811', 'Severe combined immunodeficiency w low T- and B-cell numbers'),
    ('D812', 'Severe combined immunodef w low or normal B-cell numbers'),
    ('D813', 'Adenosine deaminase [ADA] deficiency'),
    ('D814', "Nezelof's syndrome"),
    ('D815', 'Purine nucleoside phosphorylase [PNP] deficiency'),
    ('D816', 'Major histocompatibility complex class I deficiency'),
    ('D817', 'Major histocompatibility complex class II deficiency'),
    ('D81810', 'Biotinidase deficiency'),
    ('D81818', 'Other biotin-dependent carboxylase deficiency'),
    ('D81819', 'Biotin-dependent carboxylase deficiency, unspecified'),
    ('D8182', 'Activated Phosphoinositide 3-kinase Delta Syndrome [APDS]'),
    ('D8189', 'Other combined immunodeficiencies'),
    ('D819', 'Combined immunodeficiency, unspecified'),
    ('D820', 'Wiskott-Aldrich syndrome'),
    ('D821', "Di George's syndrome"),
    ('D822', 'Immunodeficiency with short-limbed stature'),
    ('D823', 'Immunodef fol heredit defctv response to Epstein-Barr virus'),
    ('D824', 'Hyperimmunoglobulin E [IgE] syndrome'),
    ('D828', 'Immunodeficiency associated with oth major defects'),
    ('D829', 'Immunodeficiency associated with major defect, unspecified'),
    ('D830', 'Com variab immunodef w predom abnlt of B-cell nums & functn'),
    ('D831', 'Com variab immunodef w predom immunoreg T-cell disorders'),
    ('D832', 'Common variable immunodef w autoantibodies to B- or T-cells'),
    ('D838', 'Other common variable immunodeficiencies'),
    ('D839', 'Common variable immunodeficiency, unspecified'),
    ('D840', 'Lymphocyte function antigen-1 [LFA-1] defect'),
    ('D841', 'Defects in the complement system'),
    ('D848', 'Other specified immunodeficiencies'),
    ('D8481', 'Immunodeficiency due to conditions classified elsewhere'),
    ('D84821', 'Immunodeficiency due to drugs'),
    ('D84822', 'Immunodeficiency due to external causes'),
    ('D8489', 'Other immunodeficiencies'),
    ('D849', 'Immunodeficiency, unspecified'),
    ('D860', 'Sarcoidosis of lung'),
    ('D861', 'Sarcoidosis of lymph nodes'),
    ('D862', 'Sarcoidosis of lung with sarcoidosis of lymph nodes'),
    ('D863', 'Sarcoidosis of skin'),
    ('D8681', 'Sarcoid meningitis'),
    ('D8682', 'Multiple cranial nerve palsies in sarcoidosis'),
    ('D8683', 'Sarcoid iridocyclitis'),
    ('D8684', 'Sarcoid pyelonephritis'),
    ('D8685', 'Sarcoid myocarditis'),
    ('D8686', 'Sarcoid arthropathy'),
    ('D8687', 'Sarcoid myositis'),
    ('D8689', 'Sarcoidosis of other sites'),
    ('D869', 'Sarcoidosis, unspecified'),
    ('D890', 'Polyclonal hypergammaglobulinemia'),
    ('D891', 'Cryoglobulinemia'),
    ('D892', 'Hypergammaglobulinemia, unspecified'),
    ('D893', 'Immune reconstitution syndrome'),
    ('D8940', 'Mast cell activation, unspecified'),
    ('D8941', 'Monoclonal mast cell activation syndrome'),
    ('D8942', 'Idiopathic mast cell activation syndrome'),
    ('D8943', 'Secondary mast cell activation'),
    ('D8944', 'Hereditary alpha tryptasemia '),
    ('D8949', 'Other mast cell activation disorder'),
    ('D89810', 'Acute graft-versus-host disease'),
    ('D89811', 'Chronic graft-versus-host disease'),
    ('D89812', 'Acute on chronic graft-versus-host disease'),
    ('D89813', 'Graft-versus-host disease, unspecified'),
    ('D8982', 'Autoimmune lymphoproliferative syndrome [ALPS]'),
    ('D89831', 'Cytokine release syndrome, grade 1'),
    ('D89832', 'Cytokine release syndrome, grade 2'),
    ('D89833', 'Cytokine release syndrome, grade 3'),
    ('D89834', 'Cytokine release syndrome, grade 4'),
    ('D89835', 'Cytokine release syndrome, grade 5'),
    ('D89839', 'Cytokine release syndrome, grade unspecified'),
    ('D8984', 'IgG4-related disease'),
    ('D8989', 'Oth disrd involving the immune mechanism, NEC'),
    ('D899', 'Disorder involving the immune mechanism, unspecified'),
    ('E000', 'Congenital iodine-deficiency syndrome, neurological type'),
    ('E001', 'Congenital iodine-deficiency syndrome, myxedematous type'),
    ('E002', 'Congenital iodine-deficiency syndrome, mixed type'),
    ('E009', 'Congenital iodine-deficiency syndrome, unspecified'),
    ('E010', 'Iodine-deficiency related diffuse (endemic) goiter'),
    ('E011', 'Iodine-deficiency related multinodular (endemic) goiter'),
    ('E012', 'Iodine-deficiency related (endemic) goiter, unspecified'),
    ('E018', 'Oth iodine-deficiency related thyroid disord and allied cond'),
    ('E02', 'Subclinical iodine-deficiency hypothyroidism'),
    ('E030', 'Congenital hypothyroidism with diffuse goiter'),
    ('E031', 'Congenital hypothyroidism without goiter'),
    ('E032', 'Hypothyroidism due to meds and oth exogenous substances'),
    ('E033', 'Postinfectious hypothyroidism'),
    ('E034', 'Atrophy of thyroid (acquired)'),
    ('E035', 'Myxedema coma'),
    ('E038', 'Other specified hypothyroidism'),
    ('E039', 'Hypothyroidism, unspecified'),
    ('E040', 'Nontoxic diffuse goiter'),
    ('E041', 'Nontoxic single thyroid nodule'),
    ('E042', 'Nontoxic multinodular goiter'),
    ('E048', 'Other specified nontoxic goiter'),
    ('E049', 'Nontoxic goiter, unspecified'),
    ('E0500', 'Thyrotoxicosis w diffuse goiter w/o thyrotoxic crisis'),
    ('E0501', 'Thyrotoxicosis w diffuse goiter w thyrotoxic crisis or storm'),
    ('E0510', 'Thyrotxcosis w toxic sing thyroid nodule w/o thyrotxc crisis'),
    ('E0511', 'Thyrotxcosis w toxic single thyroid nodule w thyrotxc crisis'),
    ('E0520', 'Thyrotxcosis w toxic multinod goiter w/o thyrotoxic crisis'),
    ('E0521', 'Thyrotxcosis w toxic multinodular goiter w thyrotoxic crisis'),
    ('E0530', 'Thyrotxcosis from ectopic thyroid tissue w/o thyrotxc crisis'),
    ('E0531', 'Thyrotxcosis from ectopic thyroid tissue w thyrotoxic crisis'),
    ('E0540', 'Thyrotoxicosis factitia without thyrotoxic crisis or storm'),
    ('E0541', 'Thyrotoxicosis factitia with thyrotoxic crisis or storm'),
    ('E0580', 'Other thyrotoxicosis without thyrotoxic crisis or storm'),
    ('E0581', 'Other thyrotoxicosis with thyrotoxic crisis or storm'),
    ('E0590', 'Thyrotoxicosis, unsp without thyrotoxic crisis or storm'),
    ('E0591', 'Thyrotoxicosis, unspecified with thyrotoxic crisis or storm'),
    ('E060', 'Acute thyroiditis'),
    ('E061', 'Subacute thyroiditis'),
    ('E062', 'Chronic thyroiditis with transient thyrotoxicosis'),
    ('E063', 'Autoimmune thyroiditis'),
    ('E064', 'Drug-induced thyroiditis'),
    ('E065', 'Other chronic thyroiditis'),
    ('E069', 'Thyroiditis, unspecified'),
    ('E070', 'Hypersecretion of calcitonin'),
    ('E071', 'Dyshormogenetic goiter'),
    ('E0781', 'Sick-euthyroid syndrome'),
    ('E0789', 'Other specified disorders of thyroid'),
    ('E079', 'Disorder of thyroid, unspecified'),
    ('E0800', 'Diab d/t undrl cond w hyprosm w/o nonket hyprgly-hypros coma'),
    ('E0801', 'Diabetes due to underlying condition w hyprosm w coma'),
    ('E0810', 'Diabetes due to underlying condition w ketoacidosis w/o coma'),
    ('E0811', 'Diabetes due to underlying condition w ketoacidosis w coma'),
    ('E0821', 'Diabetes due to underlying condition w diabetic nephropathy'),
    ('E0822', 'Diabetes due to undrl cond w diabetic chronic kidney disease'),
    ('E0829', 'Diabetes due to undrl condition w oth diabetic kidney comp'),
    ('E08311', 'Diab due to undrl cond w unsp diabetic rtnop w macular edema'),
    ('E08319', 'Diab due to undrl cond w unsp diab rtnop w/o macular edema'),
    ('E08321', 'Diab d/t undrl cond w mild nonprlf diab rtnop w mclr edema'),
    ('E083211', 'Diabetes with mild nonp rtnop with macular edema, right eye'),
    ('E083212', 'Diabetes with mild nonp rtnop with macular edema, left eye'),
    ('E083213', 'Diabetes with mild nonp rtnop with macular edema, bilateral'),
    ('E083219', 'Diabetes with mild nonp rtnop with macular edema, unsp'),
    ('E08329', 'Diab d/t undrl cond w mild nonprlf diab rtnop w/o mclr edema'),
    ('E083291', 'Diabetes with mild nonp rtnop without macular edema, r eye'),
    ('E083292', 'Diab with mild nonp rtnop without macular edema, left eye'),
    ('E083293', 'Diabetes with mild nonp rtnop without macular edema, bi'),
    ('E083299', 'Diabetes with mild nonp rtnop without macular edema, unsp'),
    ('E08331', 'Diab due to undrl cond w mod nonprlf diab rtnop w mclr edema'),
    ('E083311', 'Diabetes with moderate nonp rtnop with macular edema, r eye'),
    ('E083312', 'Diab with moderate nonp rtnop with macular edema, left eye'),
    ('E083313', 'Diabetes with moderate nonp rtnop with macular edema, bi'),
    ('E083319', 'Diabetes with moderate nonp rtnop with macular edema, unsp'),
    ('E08339', 'Diab d/t undrl cond w mod nonprlf diab rtnop w/o mclr edema'),
    ('E083391', 'Diab with moderate nonp rtnop without macular edema, r eye'),
    ('E083392', 'Diab with moderate nonp rtnop without macular edema, l eye'),
    ('E083393', 'Diabetes with moderate nonp rtnop without macular edema, bi'),
    ('E083399', 'Diab with moderate nonp rtnop without macular edema, unsp'),
    ('E08341', 'Diab d/t undrl cond w severe nonprlf diab rtnop w mclr edema'),
    ('E083411', 'Diabetes with severe nonp rtnop with macular edema, r eye'),
    ('E083412', 'Diabetes with severe nonp rtnop with macular edema, left eye'),
    ('E083413', 'Diabetes with severe nonp rtnop with macular edema, bi'),
    ('E083419', 'Diabetes with severe nonp rtnop with macular edema, unsp'),
    ('E08349', 'Diab d/t undrl cond w sev nonprlf diab rtnop w/o mclr edema'),
    ('E083491', 'Diabetes with severe nonp rtnop without macular edema, r eye'),
    ('E083492', 'Diab with severe nonp rtnop without macular edema, left eye'),
    ('E083493', 'Diabetes with severe nonp rtnop without macular edema, bi'),
    ('E083499', 'Diabetes with severe nonp rtnop without macular edema, unsp'),
    ('E08351', 'Diab due to undrl cond w prolif diab rtnop w macular edema'),
    ('E083511', 'Diab with prolif diabetic rtnop with macular edema, r eye'),
    ('E083512', 'Diab with prolif diabetic rtnop with macular edema, left eye'),
    ('E083513', 'Diabetes with prolif diabetic rtnop with macular edema, bi'),
    ('E083519', 'Diabetes with prolif diabetic rtnop with macular edema, unsp'),
    ('E08352', 'Diabetes with prolif diabetic rtnop with trctn dtch macula'),
    ('E083521', 'Diab with prolif diab rtnop with trctn dtch macula, r eye'),
    ('E083522', 'Diab with prolif diab rtnop with trctn dtch macula, left eye'),
    ('E083523', 'Diab with prolif diabetic rtnop with trctn dtch macula, bi'),
    ('E083529', 'Diab with prolif diabetic rtnop with trctn dtch macula, unsp'),
    ('E08353', 'Diabetes with prolif diabetic rtnop with trctn dtch n-mcla'),
    ('E083531', 'Diab with prolif diab rtnop with trctn dtch n-mcla, r eye'),
    ('E083532', 'Diab with prolif diab rtnop with trctn dtch n-mcla, left eye'),
    ('E083533', 'Diab with prolif diabetic rtnop with trctn dtch n-mcla, bi'),
    ('E083539', 'Diab with prolif diabetic rtnop with trctn dtch n-mcla, unsp'),
    ('E08354', 'Diabetes with prolif diabetic rtnop with combined detachment'),
    ('E083541', 'Diabetes with prolif diabetic rtnop with comb detach, r eye'),
    ('E083542', 'Diab with prolif diabetic rtnop with comb detach, left eye'),
    ('E083543', 'Diabetes with prolif diabetic rtnop with combined detach, bi'),
    ('E083549', 'Diabetes with prolif diabetic rtnop with comb detach, unsp'),
    ('E08355', 'Diabetes with stable proliferative diabetic retinopathy'),
    ('E083551', 'Diabetes with stable prolif diabetic retinopathy, right eye'),
    ('E083552', 'Diabetes with stable prolif diabetic retinopathy, left eye'),
    ('E083553', 'Diabetes with stable prolif diabetic retinopathy, bilateral'),
    ('E083559', 'Diabetes with stable prolif diabetic retinopathy, unsp'),
    ('E08359', 'Diab due to undrl cond w prolif diab rtnop w/o macular edema'),
    ('E083591', 'Diab with prolif diabetic rtnop without macular edema, r eye'),
    ('E083592', 'Diab with prolif diab rtnop without macular edema, left eye'),
    ('E083593', 'Diab with prolif diabetic rtnop without macular edema, bi'),
    ('E083599', 'Diab with prolif diabetic rtnop without macular edema, unsp'),
    ('E0836', 'Diabetes due to underlying condition w diabetic cataract'),
    ('E0837', 'Diabetes with diabetic macular edema, resolved fol treatment'),
    ('E0837X1', 'Diab with diabetic macular edema, resolved fol trtmt, r eye'),
    ('E0837X2', 'Diab with diab macular edema, resolved fol trtmt, left eye'),
    ('E0837X3', 'Diabetes with diabetic macular edema, resolved fol trtmt, bi'),
    ('E0837X9', 'Diab with diabetic macular edema, resolved fol trtmt, unsp'),
    ('E0839', 'Diabetes due to undrl condition w oth diabetic opth comp'),
    ('E0840', 'Diabetes due to underlying condition w diabetic neurop, unsp'),
    ('E0841', 'Diabetes due to undrl condition w diabetic mononeuropathy'),
    ('E0842', 'Diabetes due to underlying condition w diabetic polyneurop'),
    ('E0843', 'Diab due to undrl cond w diabetic autonm (poly)neuropathy'),
    ('E0844', 'Diabetes due to underlying condition w diabetic amyotrophy'),
    ('E0849', 'Diabetes due to undrl condition w oth diabetic neuro comp'),
    ('E0851', 'Diab due to undrl cond w diab prph angiopath w/o gangrene'),
    ('E0852', 'Diab due to undrl cond w diabetic prph angiopath w gangrene'),
    ('E0859', 'Diabetes due to underlying condition w oth circulatory comp'),
    ('E08610', 'Diabetes due to undrl cond w diabetic neuropathic arthrop'),
    ('E08618', 'Diabetes due to underlying condition w oth diabetic arthrop'),
    ('E08620', 'Diabetes due to underlying condition w diabetic dermatitis'),
    ('E08621', 'Diabetes mellitus due to underlying condition w foot ulcer'),
    ('E08622', 'Diabetes due to underlying condition w oth skin ulcer'),
    ('E08628', 'Diabetes due to underlying condition w oth skin comp'),
    ('E08630', 'Diabetes due to underlying condition w periodontal disease'),
    ('E08638', 'Diabetes due to underlying condition w oth oral comp'),
    ('E08641', 'Diabetes due to underlying condition w hypoglycemia w coma'),
    ('E08649', 'Diabetes due to underlying condition w hypoglycemia w/o coma'),
    ('E0865', 'Diabetes due to underlying condition w hyperglycemia'),
    ('E0869', 'Diabetes due to underlying condition w oth complication'),
    ('E088', 'Diabetes due to underlying condition w unsp complications'),
    ('E089', 'Diabetes due to underlying condition w/o complications'),
    ('E0900', 'Drug/chem diab w hyprosm w/o nonket hyprgly-hypros coma'),
    ('E0901', 'Drug/chem diabetes mellitus w hyperosmolarity w coma'),
    ('E0910', 'Drug/chem diabetes mellitus w ketoacidosis w/o coma'),
    ('E0911', 'Drug/chem diabetes mellitus w ketoacidosis w coma'),
    ('E0921', 'Drug/chem diabetes mellitus w diabetic nephropathy'),
    ('E0922', 'Drug/chem diabetes w diabetic chronic kidney disease'),
    ('E0929', 'Drug/chem diabetes w oth diabetic kidney complication'),
    ('E09311', 'Drug/chem diabetes w unsp diabetic rtnop w macular edema'),
    ('E09319', 'Drug/chem diabetes w unsp diabetic rtnop w/o macular edema'),
    ('E09321', 'Drug/chem diab w mild nonprlf diabetic rtnop w macular edema'),
    ('E093211', 'Drug/chem diab with mild nonp rtnop with mclr edema, r eye'),
    ('E093212', 'Drug/chem diab with mild nonp rtnop with mclr edema, l eye'),
    ('E093213', 'Drug/chem diab with mild nonp rtnop with macular edema, bi'),
    ('E093219', 'Drug/chem diab with mild nonp rtnop with macular edema, unsp'),
    ('E09329', 'Drug/chem diab w mild nonprlf diab rtnop w/o macular edema'),
    ('E093291', 'Drug/chem diab with mild nonp rtnop w/o mclr edema, r eye'),
    ('E093292', 'Drug/chem diab with mild nonp rtnop w/o mclr edema, l eye'),
    ('E093293', 'Drug/chem diab with mild nonp rtnop without mclr edema, bi'),
    ('E093299', 'Drug/chem diab with mild nonp rtnop without mclr edema, unsp'),
    ('E09331', 'Drug/chem diab w moderate nonprlf diab rtnop w macular edema'),
    ('E093311', 'Drug/chem diab with mod nonp rtnop with macular edema, r eye'),
    ('E093312', 'Drug/chem diab with mod nonp rtnop with macular edema, l eye'),
    ('E093313', 'Drug/chem diab with mod nonp rtnop with macular edema, bi'),
    ('E093319', 'Drug/chem diab with mod nonp rtnop with macular edema, unsp'),
    ('E09339', 'Drug/chem diab w mod nonprlf diab rtnop w/o macular edema'),
    ('E093391', 'Drug/chem diab with mod nonp rtnop without mclr edema, r eye'),
    ('E093392', 'Drug/chem diab with mod nonp rtnop without mclr edema, l eye'),
    ('E093393', 'Drug/chem diab with mod nonp rtnop without macular edema, bi'),
    ('E093399', 'Drug/chem diab with mod nonp rtnop without mclr edema, unsp'),
    ('E09341', 'Drug/chem diab w severe nonprlf diab rtnop w macular edema'),
    ('E093411', 'Drug/chem diab with severe nonp rtnop with mclr edema, r eye'),
    ('E093412', 'Drug/chem diab with severe nonp rtnop with mclr edema, l eye'),
    ('E093413', 'Drug/chem diab with severe nonp rtnop with macular edema, bi'),
    ('E093419', 'Drug/chem diab with severe nonp rtnop with mclr edema, unsp'),
    ('E09349', 'Drug/chem diab w severe nonprlf diab rtnop w/o macular edema'),
    ('E093491', 'Drug/chem diab with severe nonp rtnop w/o mclr edema, r eye'),
    ('E093492', 'Drug/chem diab with severe nonp rtnop w/o mclr edema, l eye'),
    ('E093493', 'Drug/chem diab with severe nonp rtnop without mclr edema, bi'),
    ('E093499', 'Drug/chem diab with severe nonp rtnop w/o mclr edema, unsp'),
    ('E09351', 'Drug/chem diabetes w prolif diabetic rtnop w macular edema'),
    ('E093511', 'Drug/chem diab with prolif diab rtnop with mclr edema, r eye'),
    ('E093512', 'Drug/chem diab with prolif diab rtnop with mclr edema, l eye'),
    ('E093513', 'Drug/chem diab with prolif diab rtnop with macular edema, bi'),
    ('E093519', 'Drug/chem diab with prolif diab rtnop with mclr edema, unsp'),
    ('E09359', 'Drug/chem diabetes w prolif diabetic rtnop w/o macular edema'),
    ('E093591', 'Drug/chem diab with prolif diab rtnop w/o mclr edema, r eye'),
    ('E093592', 'Drug/chem diab with prolif diab rtnop w/o mclr edema, l eye'),
    ('E093593', 'Drug/chem diab with prolif diab rtnop without mclr edema, bi'),
    ('E093599', 'Drug/chem diab with prolif diab rtnop w/o mclr edema, unsp'),
    ('E0936', 'Drug/chem diabetes mellitus w diabetic cataract'),
    ('E0937X1', 'Drug/chem diab w diab mclr edma, resolved fol trtmt, r eye'),
    ('E0937X2', 'Drug/chem diab w diab mclr edma, resolved fol trtmt, l eye'),
    ('E0937X3', 'Drug/chem diab with diab mclr edema, resolved fol trtmt, bi'),
    ('E0937X9', 'Drug/chem diab with diab mclr edma, resolved fol trtmt, unsp'),
    ('E0939', 'Drug/chem diabetes w oth diabetic ophthalmic complication'),
    ('E0940', 'Drug/chem diabetes w neuro comp w diabetic neuropathy, unsp'),
    ('E0941', 'Drug/chem diabetes w neuro comp w diabetic mononeuropathy'),
    ('E0942', 'Drug/chem diabetes w neurological comp w diabetic polyneurop'),
    ('E0943', 'Drug/chem diab w neuro comp w diab autonm (poly)neuropathy'),
    ('E0944', 'Drug/chem diabetes w neurological comp w diabetic amyotrophy'),
    ('E0949', 'Drug/chem diabetes w neuro comp w oth diabetic neuro comp'),
    ('E0951', 'Drug/chem diabetes w diabetic prph angiopath w/o gangrene'),
    ('E0952', 'Drug/chem diabetes w diabetic prph angiopath w gangrene'),
    ('E0959', 'Drug/chem diabetes mellitus w oth circulatory complications'),
    ('E09610', 'Drug/chem diabetes w diabetic neuropathic arthropathy'),
    ('E09618', 'Drug/chem diabetes mellitus w oth diabetic arthropathy'),
    ('E09620', 'Drug/chem diabetes mellitus w diabetic dermatitis'),
    ('E09621', 'Drug or chemical induced diabetes mellitus with foot ulcer'),
    ('E09622', 'Drug or chemical induced diabetes mellitus w oth skin ulcer'),
    ('E09628', 'Drug/chem diabetes mellitus w oth skin complications'),
    ('E09630', 'Drug/chem diabetes mellitus w periodontal disease'),
    ('E09638', 'Drug/chem diabetes mellitus w oth oral complications'),
    ('E09641', 'Drug/chem diabetes mellitus w hypoglycemia w coma'),
    ('E09649', 'Drug/chem diabetes mellitus w hypoglycemia w/o coma'),
    ('E0965', 'Drug or chemical induced diabetes mellitus w hyperglycemia'),
    ('E0969', 'Drug/chem diabetes mellitus w oth complication'),
    ('E098', 'Drug/chem diabetes mellitus w unsp complications'),
    ('E099', 'Drug or chemical induced diabetes mellitus w/o complications'),
    ('E1010', 'Type 1 diabetes mellitus with ketoacidosis without coma'),
    ('E1011', 'Type 1 diabetes mellitus with ketoacidosis with coma'),
    ('E1021', 'Type 1 diabetes mellitus with diabetic nephropathy'),
    ('E1022', 'Type 1 diabetes mellitus w diabetic chronic kidney disease'),
    ('E1029', 'Type 1 diabetes mellitus w oth diabetic kidney complication'),
    ('E10311', 'Type 1 diabetes w unsp diabetic retinopathy w macular edema'),
    ('E10319', 'Type 1 diabetes w unsp diabetic rtnop w/o macular edema'),
    ('E10321', 'Type 1 diab w mild nonprlf diabetic rtnop w macular edema'),
    ('E103211', 'Type 1 diab with mild nonp rtnop with macular edema, r eye'),
    ('E103212', 'Type 1 diab with mild nonp rtnop with macular edema, l eye'),
    ('E103213', 'Type 1 diabetes with mild nonp rtnop with macular edema, bi'),
    ('E103219', 'Type 1 diab with mild nonp rtnop with macular edema, unsp'),
    ('E10329', 'Type 1 diab w mild nonprlf diabetic rtnop w/o macular edema'),
    ('E103291', 'Type 1 diab with mild nonp rtnop without mclr edema, r eye'),
    ('E103292', 'Type 1 diab with mild nonp rtnop without mclr edema, l eye'),
    ('E103293', 'Type 1 diab with mild nonp rtnop without macular edema, bi'),
    ('E103299', 'Type 1 diab with mild nonp rtnop without macular edema, unsp'),
    ('E10331', 'Type 1 diab w moderate nonprlf diab rtnop w macular edema'),
    ('E103311', 'Type 1 diab with mod nonp rtnop with macular edema, r eye'),
    ('E103312', 'Type 1 diab with mod nonp rtnop with macular edema, l eye'),
    ('E103313', 'Type 1 diab with moderate nonp rtnop with macular edema, bi'),
    ('E103319', 'Type 1 diab with mod nonp rtnop with macular edema, unsp'),
    ('E10339', 'Type 1 diab w moderate nonprlf diab rtnop w/o macular edema'),
    ('E103391', 'Type 1 diab with mod nonp rtnop without macular edema, r eye'),
    ('E103392', 'Type 1 diab with mod nonp rtnop without macular edema, l eye'),
    ('E103393', 'Type 1 diab with mod nonp rtnop without macular edema, bi'),
    ('E103399', 'Type 1 diab with mod nonp rtnop without macular edema, unsp'),
    ('E10341', 'Type 1 diab w severe nonprlf diabetic rtnop w macular edema'),
    ('E103411', 'Type 1 diab with severe nonp rtnop with macular edema, r eye'),
    ('E103412', 'Type 1 diab with severe nonp rtnop with macular edema, l eye'),
    ('E103413', 'Type 1 diab with severe nonp rtnop with macular edema, bi'),
    ('E103419', 'Type 1 diab with severe nonp rtnop with macular edema, unsp'),
    ('E10349', 'Type 1 diab w severe nonprlf diab rtnop w/o macular edema'),
    ('E103491', 'Type 1 diab with severe nonp rtnop without mclr edema, r eye'),
    ('E103492', 'Type 1 diab with severe nonp rtnop without mclr edema, l eye'),
    ('E103493', 'Type 1 diab with severe nonp rtnop without mclr edema, bi'),
    ('E103499', 'Type 1 diab with severe nonp rtnop without mclr edema, unsp'),
    ('E10351', 'Type 1 diab with prolif diab rtnop with macular edema, r eye'),
    ('E103511', 'Type 1 diab with prolif diab rtnop with macular edema, bi'),
    ('E103512', 'Type 1 diab with prolif diab rtnop with macular edema, l eye'),
    ('E103513', 'Type 1 diab with prolif diab rtnop with macular edema, bi'),
    ('E103519', 'Type 1 diab with prolif diab rtnop with macular edema, unsp'),
    ('E10352', 'Type 1 diab with prolif diab rtnop with trctn dtch macula'),
    ('E103521', 'Type 1 diab w prolif diab rtnop w trctn dtch macula, r eye'),
    ('E103522', 'Type 1 diab w prolif diab rtnop w trctn dtch macula, l eye'),
    ('E103523', 'Type 1 diab w prolif diab rtnop with trctn dtch macula, bi'),
    ('E103529', 'Type 1 diab w prolif diab rtnop with trctn dtch macula, unsp'),
    ('E10353', 'Type 1 diab with prolif diab rtnop with trctn dtch n-mcla'),
    ('E103531', 'Type 1 diab w prolif diab rtnop w trctn dtch n-mcla, r eye'),
    ('E103532', 'Type 1 diab w prolif diab rtnop w trctn dtch n-mcla, l eye'),
    ('E103533', 'Type 1 diab w prolif diab rtnop with trctn dtch n-mcla, bi'),
    ('E103539', 'Type 1 diab w prolif diab rtnop with trctn dtch n-mcla, unsp'),
    ('E10354', 'Type 1 diabetes with prolif diabetic rtnop with comb detach'),
    ('E103541', 'Type 1 diab with prolif diab rtnop with comb detach, r eye'),
    ('E103542', 'Type 1 diab with prolif diab rtnop with comb detach, l eye'),
    ('E103543', 'Type 1 diab with prolif diabetic rtnop with comb detach, bi'),
    ('E103549', 'Type 1 diab with prolif diab rtnop with comb detach, unsp'),
    ('E10355', 'Type 1 diabetes with stable prolif diabetic retinopathy'),
    ('E103551', 'Type 1 diabetes with stable prolif diabetic rtnop, right eye'),
    ('E103552', 'Type 1 diabetes with stable prolif diabetic rtnop, left eye'),
    ('E103553', 'Type 1 diabetes with stable prolif diabetic rtnop, bilateral'),
    ('E103559', 'Type 1 diabetes with stable prolif diabetic rtnop, unsp'),
    ('E10359', 'Type 1 diabetes w prolif diabetic rtnop w/o macular edema'),
    ('E103591', 'Type 1 diab with prolif diab rtnop without mclr edema, r eye'),
    ('E103592', 'Type 1 diab with prolif diab rtnop without mclr edema, l eye'),
    ('E103593', 'Type 1 diab with prolif diab rtnop without macular edema, bi'),
    ('E103599', 'Type 1 diab with prolif diab rtnop without mclr edema, unsp'),
    ('E1036', 'Type 1 diabetes mellitus with diabetic cataract'),
    ('E1037', 'Type 1 diab with diabetic macular edema, resolved fol trtmt'),
    ('E1037X1', 'Type 1 diab with diab mclr edema, resolved fol trtmt, r eye'),
    ('E1037X2', 'Type 1 diab with diab mclr edema, resolved fol trtmt, l eye'),
    ('E1037X3', 'Type 1 diab with diab macular edema, resolved fol trtmt, bi'),
    ('E1037X9', 'Type 1 diab with diab mclr edema, resolved fol trtmt, unsp'),
    ('E1039', 'Type 1 diabetes w oth diabetic ophthalmic complication'),
    ('E1040', 'Type 1 diabetes mellitus with diabetic neuropathy, unsp'),
    ('E1041', 'Type 1 diabetes mellitus with diabetic mononeuropathy'),
    ('E1042', 'Type 1 diabetes mellitus with diabetic polyneuropathy'),
    ('E1043', 'Type 1 diabetes w diabetic autonomic (poly)neuropathy'),
    ('E1044', 'Type 1 diabetes mellitus with diabetic amyotrophy'),
    ('E1049', 'Type 1 diabetes w oth diabetic neurological complication'),
    ('E1051', 'Type 1 diabetes w diabetic peripheral angiopath w/o gangrene'),
    ('E1052', 'Type 1 diabetes w diabetic peripheral angiopathy w gangrene'),
    ('E1059', 'Type 1 diabetes mellitus with oth circulatory complications'),
    ('E10610', 'Type 1 diabetes mellitus w diabetic neuropathic arthropathy'),
    ('E10618', 'Type 1 diabetes mellitus with other diabetic arthropathy'),
    ('E10620', 'Type 1 diabetes mellitus with diabetic dermatitis'),
    ('E10621', 'Type 1 diabetes mellitus with foot ulcer'),
    ('E10622', 'Type 1 diabetes mellitus with other skin ulcer'),
    ('E10628', 'Type 1 diabetes mellitus with other skin complications'),
    ('E10630', 'Type 1 diabetes mellitus with periodontal disease'),
    ('E10638', 'Type 1 diabetes mellitus with other oral complications'),
    ('E10641', 'Type 1 diabetes mellitus with hypoglycemia with coma'),
    ('E10649', 'Type 1 diabetes mellitus with hypoglycemia without coma'),
    ('E1065', 'Type 1 diabetes mellitus with hyperglycemia'),
    ('E1069', 'Type 1 diabetes mellitus with other specified complication'),
    ('E108', 'Type 1 diabetes mellitus with unspecified complications'),
    ('E109', 'Type 1 diabetes mellitus without complications'),
    ('E1100', 'Type 2 diab w hyprosm w/o nonket hyprgly-hypros coma (NKHHC)'),
    ('E1101', 'Type 2 diabetes mellitus with hyperosmolarity with coma'),
    ('E1110', 'Type 2 diabetes mellitus with ketoacidosis without coma'),
    ('E1111', 'Type 2 diabetes mellitus with ketoacidosis with coma'),
    ('E1121', 'Type 2 diabetes mellitus with diabetic nephropathy'),
    ('E1122', 'Type 2 diabetes mellitus w diabetic chronic kidney disease'),
    ('E1129', 'Type 2 diabetes mellitus w oth diabetic kidney complication'),
    ('E11311', 'Type 2 diabetes w unsp diabetic retinopathy w macular edema'),
    ('E11319', 'Type 2 diabetes w unsp diabetic rtnop w/o macular edema'),
    ('E11321', 'Type 2 diab w mild nonprlf diabetic rtnop w macular edema'),
    ('E113211', 'Type 2 diab with mild nonp rtnop with macular edema, r eye'),
    ('E113212', 'Type 2 diab with mild nonp rtnop with macular edema, l eye'),
    ('E113213', 'Type 2 diabetes with mild nonp rtnop with macular edema, bi'),
    ('E113219', 'Type 2 diab with mild nonp rtnop with macular edema, unsp'),
    ('E11329', 'Type 2 diab w mild nonprlf diabetic rtnop w/o macular edema'),
    ('E113291', 'Type 2 diab with mild nonp rtnop without mclr edema, r eye'),
    ('E113292', 'Type 2 diab with mild nonp rtnop without mclr edema, l eye'),
    ('E113293', 'Type 2 diab with mild nonp rtnop without macular edema, bi'),
    ('E113299', 'Type 2 diab with mild nonp rtnop without macular edema, unsp'),
    ('E11331', 'Type 2 diab w moderate nonprlf diab rtnop w macular edema'),
    ('E113311', 'Type 2 diab with mod nonp rtnop with macular edema, r eye'),
    ('E113312', 'Type 2 diab with mod nonp rtnop with macular edema, l eye'),
    ('E113313', 'Type 2 diab with moderate nonp rtnop with macular edema, bi'),
    ('E113319', 'Type 2 diab with mod nonp rtnop with macular edema, unsp'),
    ('E11339', 'Type 2 diab w moderate nonprlf diab rtnop w/o macular edema'),
    ('E113391', 'Type 2 diab with mod nonp rtnop without macular edema, r eye'),
    ('E113392', 'Type 2 diab with mod nonp rtnop without macular edema, l eye'),
    ('E113393', 'Type 2 diab with mod nonp rtnop without macular edema, bi'),
    ('E113399', 'Type 2 diab with mod nonp rtnop without macular edema, unsp'),
    ('E11341', 'Type 2 diab w severe nonprlf diabetic rtnop w macular edema'),
    ('E113411', 'Type 2 diab with severe nonp rtnop with macular edema, r eye'),
    ('E113412', 'Type 2 diab with severe nonp rtnop with macular edema, l eye'),
    ('E113413', 'Type 2 diab with severe nonp rtnop with macular edema, bi'),
    ('E113419', 'Type 2 diab with severe nonp rtnop with macular edema, unsp'),
    ('E11349', 'Type 2 diab w severe nonprlf diab rtnop w/o macular edema'),
    ('E113491', 'Type 2 diab with severe nonp rtnop without mclr edema, r eye'),
    ('E113492', 'Type 2 diab with severe nonp rtnop without mclr edema, l eye'),
    ('E113493', 'Type 2 diab with severe nonp rtnop without macular edema, bi'),
    ('E113499', 'Type 2 diab with severe nonp rtnop without mclr edema, unsp'),
    ('E11351', 'Type 2 diabetes w prolif diabetic rtnop w macular edema'),
    ('E113511', 'Type 2 diab with prolif diab rtnop with macular edema, r eye'),
    ('E113512', 'Type 2 diab with prolif diab rtnop with macular edema, l eye'),
    ('E113513', 'Type 2 diab with prolif diab rtnop with macular edema, bi'),
    ('E113519', 'Type 2 diab with prolif diab rtnop with macular edema, unsp'),
    ('E113521', 'Type 2 diab w prolif diab rtnop w trctn dtch macula, r eye'),
    ('E113522', 'Type 2 diab w prolif diab rtnop w trctn dtch macula, l eye'),
    ('E113523', 'Type 2 diab w prolif diab rtnop with trctn dtch macula, bi'),
    ('E113529', 'Type 2 diab w prolif diab rtnop with trctn dtch macula, unsp'),
    ('E113531', 'Type 2 diab w prolif diab rtnop w trctn dtch n-mcla, r eye'),
    ('E113532', 'Type 2 diab w prolif diab rtnop w trctn dtch n-mcla, l eye'),
    ('E113533', 'Type 2 diab w prolif diab rtnop with trctn dtch n-mcla, bi'),
    ('E113539', 'Type 2 diab w prolif diab rtnop with trctn dtch n-mcla, unsp'),
    ('E113541', 'Type 2 diab with prolif diab rtnop with comb detach, r eye'),
    ('E113542', 'Type 2 diab with prolif diab rtnop with comb detach, l eye'),
    ('E113543', 'Type 2 diab with prolif diabetic rtnop with comb detach, bi'),
    ('E113549', 'Type 2 diab with prolif diab rtnop with comb detach, unsp'),
    ('E113551', 'Type 2 diabetes with stable prolif diabetic rtnop, right eye'),
    ('E113552', 'Type 2 diabetes with stable prolif diabetic rtnop, left eye'),
    ('E113553', 'Type 2 diabetes with stable prolif diabetic rtnop, bilateral'),
    ('E113559', 'Type 2 diabetes with stable prolif diabetic rtnop, unsp'),
    ('E11359', 'Type 2 diabetes w prolif diabetic rtnop w/o macular edema'),
    ('E113591', 'Type 2 diab with prolif diab rtnop without mclr edema, r eye'),
    ('E113592', 'Type 2 diab with prolif diab rtnop without mclr edema, l eye'),
    ('E113593', 'Type 2 diab with prolif diab rtnop without macular edema, bi'),
    ('E113599', 'Type 2 diab with prolif diab rtnop without mclr edema, unsp'),
    ('E1136', 'Type 2 diabetes mellitus with diabetic cataract'),
    ('E1137X1', 'Type 2 diab with diab mclr edema, resolved fol trtmt, r eye'),
    ('E1137X2', 'Type 2 diab with diab mclr edema, resolved fol trtmt, l eye'),
    ('E1137X3', 'Type 2 diab with diab macular edema, resolved fol trtmt, bi'),
    ('E1137X9', 'Type 2 diab with diab mclr edema, resolved fol trtmt, unsp'),
    ('E1139', 'Type 2 diabetes w oth diabetic ophthalmic complication'),
    ('E1140', 'Type 2 diabetes mellitus with diabetic neuropathy, unsp'),
    ('E1141', 'Type 2 diabetes mellitus with diabetic mononeuropathy'),
    ('E1142', 'Type 2 diabetes mellitus with diabetic polyneuropathy'),
    ('E1143', 'Type 2 diabetes w diabetic autonomic (poly)neuropathy'),
    ('E1144', 'Type 2 diabetes mellitus with diabetic amyotrophy'),
    ('E1149', 'Type 2 diabetes w oth diabetic neurological complication'),
    ('E1151', 'Type 2 diabetes w diabetic peripheral angiopath w/o gangrene'),
    ('E1152', 'Type 2 diabetes w diabetic peripheral angiopathy w gangrene'),
    ('E1159', 'Type 2 diabetes mellitus with oth circulatory complications'),
    ('E11610', 'Type 2 diabetes mellitus w diabetic neuropathic arthropathy'),
    ('E11618', 'Type 2 diabetes mellitus with other diabetic arthropathy'),
    ('E11620', 'Type 2 diabetes mellitus with diabetic dermatitis'),
    ('E11621', 'Type 2 diabetes mellitus with foot ulcer'),
    ('E11622', 'Type 2 diabetes mellitus with other skin ulcer'),
    ('E11628', 'Type 2 diabetes mellitus with other skin complications'),
    ('E11630', 'Type 2 diabetes mellitus with periodontal disease'),
    ('E11638', 'Type 2 diabetes mellitus with other oral complications'),
    ('E11641', 'Type 2 diabetes mellitus with hypoglycemia with coma'),
    ('E11649', 'Type 2 diabetes mellitus with hypoglycemia without coma'),
    ('E1165', 'Type 2 diabetes mellitus with hyperglycemia'),
    ('E1169', 'Type 2 diabetes mellitus with other specified complication'),
    ('E118', 'Type 2 diabetes mellitus with unspecified complications'),
    ('E119', 'Type 2 diabetes mellitus without complications'),
    ('E1300', 'Oth diab w hyprosm w/o nonket hyprgly-hypros coma (NKHHC)'),
    ('E1301', 'Oth diabetes mellitus with hyperosmolarity with coma'),
    ('E1310', 'Oth diabetes mellitus with ketoacidosis without coma'),
    ('E1311', 'Oth diabetes mellitus with ketoacidosis with coma'),
    ('E1321', 'Other specified diabetes mellitus with diabetic nephropathy'),
    ('E1322', 'Oth diabetes mellitus with diabetic chronic kidney disease'),
    ('E1329', 'Oth diabetes mellitus with oth diabetic kidney complication'),
    ('E13311', 'Oth diabetes w unsp diabetic retinopathy w macular edema'),
    ('E13319', 'Oth diabetes w unsp diabetic retinopathy w/o macular edema'),
    ('E13321', 'Oth diabetes w mild nonprlf diabetic rtnop w macular edema'),
    ('E133211', 'Oth diabetes with mild nonp rtnop with macular edema, r eye'),
    ('E133212', 'Oth diab with mild nonp rtnop with macular edema, left eye'),
    ('E133213', 'Oth diabetes with mild nonp rtnop with macular edema, bi'),
    ('E133219', 'Oth diabetes with mild nonp rtnop with macular edema, unsp'),
    ('E13329', 'Oth diabetes w mild nonprlf diabetic rtnop w/o macular edema'),
    ('E133291', 'Oth diab with mild nonp rtnop without macular edema, r eye'),
    ('E133292', 'Oth diab with mild nonp rtnop without macular edema, l eye'),
    ('E133293', 'Oth diabetes with mild nonp rtnop without macular edema, bi'),
    ('E133299', 'Oth diab with mild nonp rtnop without macular edema, unsp'),
    ('E13331', 'Oth diab w moderate nonprlf diabetic rtnop w macular edema'),
    ('E133311', 'Oth diab with moderate nonp rtnop with macular edema, r eye'),
    ('E133312', 'Oth diab with moderate nonp rtnop with macular edema, l eye'),
    ('E133313', 'Oth diabetes with moderate nonp rtnop with macular edema, bi'),
    ('E133319', 'Oth diab with moderate nonp rtnop with macular edema, unsp'),
    ('E13339', 'Oth diab w moderate nonprlf diabetic rtnop w/o macular edema'),
    ('E133391', 'Oth diab with mod nonp rtnop without macular edema, r eye'),
    ('E133392', 'Oth diab with mod nonp rtnop without macular edema, l eye'),
    ('E133393', 'Oth diab with moderate nonp rtnop without macular edema, bi'),
    ('E133399', 'Oth diab with mod nonp rtnop without macular edema, unsp'),
    ('E13341', 'Oth diabetes w severe nonprlf diabetic rtnop w macular edema'),
    ('E133411', 'Oth diab with severe nonp rtnop with macular edema, r eye'),
    ('E133412', 'Oth diab with severe nonp rtnop with macular edema, left eye'),
    ('E133413', 'Oth diabetes with severe nonp rtnop with macular edema, bi'),
    ('E133419', 'Oth diabetes with severe nonp rtnop with macular edema, unsp'),
    ('E13349', 'Oth diab w severe nonprlf diabetic rtnop w/o macular edema'),
    ('E133491', 'Oth diab with severe nonp rtnop without macular edema, r eye'),
    ('E133492', 'Oth diab with severe nonp rtnop without macular edema, l eye'),
    ('E133493', 'Oth diab with severe nonp rtnop without macular edema, bi'),
    ('E133499', 'Oth diab with severe nonp rtnop without macular edema, unsp'),
    ('E13351', 'Oth diabetes w prolif diabetic retinopathy w macular edema'),
    ('E133511', 'Oth diab with prolif diab rtnop with macular edema, r eye'),
    ('E133512', 'Oth diab with prolif diab rtnop with macular edema, left eye'),
    ('E133513', 'Oth diab with prolif diabetic rtnop with macular edema, bi'),
    ('E133519', 'Oth diab with prolif diabetic rtnop with macular edema, unsp'),
    ('E133521', 'Oth diab w prolif diab rtnop with trctn dtch macula, r eye'),
    ('E133522', 'Oth diab w prolif diab rtnop with trctn dtch macula, l eye'),
    ('E133523', 'Oth diab with prolif diab rtnop with trctn dtch macula, bi'),
    ('E133529', 'Oth diab with prolif diab rtnop with trctn dtch macula, unsp'),
    ('E133531', 'Oth diab w prolif diab rtnop with trctn dtch n-mcla, r eye'),
    ('E133532', 'Oth diab w prolif diab rtnop with trctn dtch n-mcla, l eye'),
    ('E133533', 'Oth diab with prolif diab rtnop with trctn dtch n-mcla, bi'),
    ('E133539', 'Oth diab with prolif diab rtnop with trctn dtch n-mcla, unsp'),
    ('E133541', 'Oth diab with prolif diabetic rtnop with comb detach, r eye'),
    ('E133542', 'Oth diab with prolif diab rtnop with comb detach, left eye'),
    ('E133543', 'Oth diabetes with prolif diabetic rtnop with comb detach, bi'),
    ('E133549', 'Oth diab with prolif diabetic rtnop with comb detach, unsp'),
    ('E133551', 'Oth diabetes with stable prolif diabetic rtnop, right eye'),
    ('E133552', 'Oth diabetes with stable prolif diabetic rtnop, left eye'),
    ('E133553', 'Oth diabetes with stable prolif diabetic rtnop, bilateral'),
    ('E133559', 'Oth diabetes with stable prolif diabetic retinopathy, unsp'),
    ('E13359', 'Oth diabetes w prolif diabetic retinopathy w/o macular edema'),
    ('E133591', 'Oth diab with prolif diab rtnop without macular edema, r eye'),
    ('E133592', 'Oth diab with prolif diab rtnop without macular edema, l eye'),
    ('E133593', 'Oth diab with prolif diab rtnop without macular edema, bi'),
    ('E133599', 'Oth diab with prolif diab rtnop without macular edema, unsp'),
    ('E1336', 'Other specified diabetes mellitus with diabetic cataract'),
    ('E1337X1', 'Oth diab with diab macular edema, resolved fol trtmt, r eye'),
    ('E1337X2', 'Oth diab with diab macular edema, resolved fol trtmt, l eye'),
    ('E1337X3', 'Oth diab with diabetic macular edema, resolved fol trtmt, bi'),
    ('E1337X9', 'Oth diab with diab macular edema, resolved fol trtmt, unsp'),
    ('E1339', 'Oth diabetes mellitus w oth diabetic ophthalmic complication'),
    ('E1340', 'Oth diabetes mellitus with diabetic neuropathy, unspecified'),
    ('E1341', 'Oth diabetes mellitus with diabetic mononeuropathy'),
    ('E1342', 'Oth diabetes mellitus with diabetic polyneuropathy'),
    ('E1343', 'Oth diabetes mellitus w diabetic autonomic (poly)neuropathy'),
    ('E1344', 'Other specified diabetes mellitus with diabetic amyotrophy'),
    ('E1349', 'Oth diabetes w oth diabetic neurological complication'),
    ('E1351', 'Oth diabetes w diabetic peripheral angiopathy w/o gangrene'),
    ('E1352', 'Oth diabetes w diabetic peripheral angiopathy w gangrene'),
    ('E1359', 'Oth diabetes mellitus with other circulatory complications'),
    ('E13610', 'Oth diabetes mellitus with diabetic neuropathic arthropathy'),
    ('E13618', 'Oth diabetes mellitus with other diabetic arthropathy'),
    ('E13620', 'Other specified diabetes mellitus with diabetic dermatitis'),
    ('E13621', 'Other specified diabetes mellitus with foot ulcer'),
    ('E13622', 'Other specified diabetes mellitus with other skin ulcer'),
    ('E13628', 'Oth diabetes mellitus with other skin complications'),
    ('E13630', 'Other specified diabetes mellitus with periodontal disease'),
    ('E13638', 'Oth diabetes mellitus with other oral complications'),
    ('E13641', 'Oth diabetes mellitus with hypoglycemia with coma'),
    ('E13649', 'Oth diabetes mellitus with hypoglycemia without coma'),
    ('E1365', 'Other specified diabetes mellitus with hyperglycemia'),
    ('E1369', 'Oth diabetes mellitus with other specified complication'),
    ('E138', 'Oth diabetes mellitus with unspecified complications'),
    ('E139', 'Other specified diabetes mellitus without complications'),
    ('E15', 'Nondiabetic hypoglycemic coma'),
    ('E160', 'Drug-induced hypoglycemia without coma'),
    ('E161', 'Other hypoglycemia'),
    ('E162', 'Hypoglycemia, unspecified'),
    ('E163', 'Increased secretion of glucagon'),
    ('E164', 'Increased secretion of gastrin'),
    ('E168', 'Other specified disorders of pancreatic internal secretion'),
    ('E169', 'Disorder of pancreatic internal secretion, unspecified'),
    ('E200', 'Idiopathic hypoparathyroidism'),
    ('E201', 'Pseudohypoparathyroidism'),
    ('E208', 'Other hypoparathyroidism'),
    ('E20810', 'Autosomal dominant hypocalcemia'),
    ('E20811', 'Secondary hypoparathyroidism in diseases classd elswhr'),
    ('E20812', 'Autoimmune hypoparathyroidism'),
    ('E20818', 'Oth hypoparathyroidism due to impaired PTH secretion'),
    ('E20819', 'Hypoparathyroidism due to impaired PTH secretion, unsp'),
    ('E2089', 'Other specified hypoparathyroidism'),
    ('E209', 'Hypoparathyroidism, unspecified'),
    ('E210', 'Primary hyperparathyroidism'),
    ('E211', 'Secondary hyperparathyroidism, not elsewhere classified'),
    ('E212', 'Other hyperparathyroidism'),
    ('E213', 'Hyperparathyroidism, unspecified'),
    ('E214', 'Other specified disorders of parathyroid gland'),
    ('E215', 'Disorder of parathyroid gland, unspecified'),
    ('E220', 'Acromegaly and pituitary gigantism'),
    ('E221', 'Hyperprolactinemia'),
    ('E222', 'Syndrome of inappropriate secretion of antidiuretic hormone'),
    ('E228', 'Other hyperfunction of pituitary gland'),
    ('E229', 'Hyperfunction of pituitary gland, unspecified'),
    ('E230', 'Hypopituitarism'),
    ('E231', 'Drug-induced hypopituitarism'),
    ('E232', 'Diabetes insipidus'),
    ('E233', 'Hypothalamic dysfunction, not elsewhere classified'),
    ('E236', 'Other disorders of pituitary gland'),
    ('E237', 'Disorder of pituitary gland, unspecified'),
    ('E240', "Pituitary-dependent Cushing's disease"),
    ('E241', "Nelson's syndrome"),
    ('E242', "Drug-induced Cushing's syndrome"),
    ('E243', 'Ectopic ACTH syndrome'),
    ('E244', "Alcohol-induced pseudo-Cushing's syndrome"),
    ('E248', "Other Cushing's syndrome"),
    ('E249', "Cushing's syndrome, unspecified"),
    ('E250', 'Congenital adrenogenital disorders assoc w enzyme deficiency'),
    ('E258', 'Other adrenogenital disorders'),
    ('E259', 'Adrenogenital disorder, unspecified'),
    ('E2601', "Conn's syndrome"),
    ('E2602', 'Glucocorticoid-remediable aldosteronism'),
    ('E2609', 'Other primary hyperaldosteronism'),
    ('E261', 'Secondary hyperaldosteronism'),
    ('E2681', "Bartter's syndrome"),
    ('E2689', 'Other hyperaldosteronism'),
    ('E269', 'Hyperaldosteronism, unspecified'),
    ('E270', 'Other adrenocortical overactivity'),
    ('E271', 'Primary adrenocortical insufficiency'),
    ('E272', 'Addisonian crisis'),
    ('E273', 'Drug-induced adrenocortical insufficiency'),
    ('E2740', 'Unspecified adrenocortical insufficiency'),
    ('E2749', 'Other adrenocortical insufficiency'),
    ('E275', 'Adrenomedullary hyperfunction'),
    ('E278', 'Other specified disorders of adrenal gland'),
    ('E279', 'Disorder of adrenal gland, unspecified'),
    ('E280', 'Estrogen excess'),
    ('E281', 'Androgen excess'),
    ('E282', 'Polycystic ovarian syndrome'),
    ('E28310', 'Symptomatic premature menopause'),
    ('E28319', 'Asymptomatic premature menopause'),
    ('E2839', 'Other primary ovarian failure'),
    ('E288', 'Other ovarian dysfunction'),
    ('E289', 'Ovarian dysfunction, unspecified'),
    ('E290', 'Testicular hyperfunction'),
    ('E291', 'Testicular hypofunction'),
    ('E298', 'Other testicular dysfunction'),
    ('E299', 'Testicular dysfunction, unspecified'),
    ('E300', 'Delayed puberty'),
    ('E301', 'Precocious puberty'),
    ('E308', 'Other disorders of puberty'),
    ('E309', 'Disorder of puberty, unspecified'),
    ('E310', 'Autoimmune polyglandular failure'),
    ('E311', 'Polyglandular hyperfunction'),
    ('E3120', 'Multiple endocrine neoplasia [MEN] syndrome, unspecified'),
    ('E3121', 'Multiple endocrine neoplasia [MEN] type I'),
    ('E3122', 'Multiple endocrine neoplasia [MEN] type IIA'),
    ('E3123', 'Multiple endocrine neoplasia [MEN] type IIB'),
    ('E318', 'Other polyglandular dysfunction'),
    ('E319', 'Polyglandular dysfunction, unspecified'),
    ('E320', 'Persistent hyperplasia of thymus'),
    ('E321', 'Abscess of thymus'),
    ('E328', 'Other diseases of thymus'),
    ('E329', 'Disease of thymus, unspecified'),
    ('E340', 'Carcinoid syndrome'),
    ('E341', 'Other hypersecretion of intestinal hormones'),
    ('E342', 'Ectopic hormone secretion, not elsewhere classified'),
    ('E343', 'Short stature due to endocrine disorder'),
    ('E3430', 'Short stature due to endocrine disorder, unspecified'),
    ('E3431', 'Constitutional short stature'),
    ('E34321', 'Primary insulin-like growth factor-1 (IGF-1) deficiency'),
    ('E34322', 'Insulin-like growth factor-1 (IGF-1) resistance'),
    ('E344', 'Constitutional tall stature'),
    ('E3450', 'Androgen insensitivity syndrome, unspecified'),
    ('E3451', 'Complete androgen insensitivity syndrome'),
    ('E3452', 'Partial androgen insensitivity syndrome'),
    ('E348', 'Other specified endocrine disorders'),
    ('E349', 'Endocrine disorder, unspecified'),
    ('E35', 'Disorders of endocrine glands in diseases classd elswhr'),
    ('E3601', 'Intraop hemor/hemtom of endo sys org comp an endo sys proc'),
    ('E3602', 'Intraop hemor/hemtom of an endo sys org comp oth procedure'),
    ('E3611', 'Acc pnctr & lac of an endo sys org during an endo sys proc'),
    ('E3612', 'Acc pnctr & lac of an endo sys org during oth procedure'),
    ('E368', 'Other intraoperative complications of endocrine system'),
    ('E40', 'Kwashiorkor'),
    ('E41', 'Nutritional marasmus'),
    ('E42', 'Marasmic kwashiorkor'),
    ('E43', 'Unspecified severe protein-calorie malnutrition'),
    ('E440', 'Moderate protein-calorie malnutrition'),
    ('E441', 'Mild protein-calorie malnutrition'),
    ('E45', 'Retarded development following protein-calorie malnutrition'),
    ('E46', 'Unspecified protein-calorie malnutrition'),
    ('E500', 'Vitamin A deficiency with conjunctival xerosis'),
    ('E501', "Vitamin A deficiency w Bitot's spot and conjunctival xerosis"),
    ('E502', 'Vitamin A deficiency with corneal xerosis'),
    ('E503', 'Vitamin A deficiency with corneal ulceration and xerosis'),
    ('E504', 'Vitamin A deficiency with keratomalacia'),
    ('E505', 'Vitamin A deficiency with night blindness'),
    ('E506', 'Vitamin A deficiency with xerophthalmic scars of cornea'),
    ('E507', 'Other ocular manifestations of vitamin A deficiency'),
    ('E508', 'Other manifestations of vitamin A deficiency'),
    ('E509', 'Vitamin A deficiency, unspecified'),
    ('E5111', 'Dry beriberi'),
    ('E5112', 'Wet beriberi'),
    ('E512', "Wernicke's encephalopathy"),
    ('E518', 'Other manifestations of thiamine deficiency'),
    ('E519', 'Thiamine deficiency, unspecified'),
    ('E52', 'Niacin deficiency [pellagra]'),
    ('E530', 'Riboflavin deficiency'),
    ('E531', 'Pyridoxine deficiency'),
    ('E538', 'Deficiency of other specified B group vitamins'),
    ('E539', 'Vitamin B deficiency, unspecified'),
    ('E54', 'Ascorbic acid deficiency'),
    ('E550', 'Rickets, active'),
    ('E559', 'Vitamin D deficiency, unspecified'),
    ('E560', 'Deficiency of vitamin E'),
    ('E561', 'Deficiency of vitamin K'),
    ('E568', 'Deficiency of other vitamins'),
    ('E569', 'Vitamin deficiency, unspecified'),
    ('E58', 'Dietary calcium deficiency'),
    ('E59', 'Dietary selenium deficiency'),
    ('E60', 'Dietary zinc deficiency'),
    ('E610', 'Copper deficiency'),
    ('E611', 'Iron deficiency'),
    ('E612', 'Magnesium deficiency'),
    ('E613', 'Manganese deficiency'),
    ('E614', 'Chromium deficiency'),
    ('E615', 'Molybdenum deficiency'),
    ('E616', 'Vanadium deficiency'),
    ('E617', 'Deficiency of multiple nutrient elements'),
    ('E618', 'Deficiency of other specified nutrient elements'),
    ('E619', 'Deficiency of nutrient element, unspecified'),
    ('E630', 'Essential fatty acid [EFA] deficiency'),
    ('E631', 'Imbalance of constituents of food intake'),
    ('E638', 'Other specified nutritional deficiencies'),
    ('E639', 'Nutritional deficiency, unspecified'),
    ('E640', 'Sequelae of protein-calorie malnutrition'),
    ('E641', 'Sequelae of vitamin A deficiency'),
    ('E642', 'Sequelae of vitamin C deficiency'),
    ('E643', 'Sequelae of rickets'),
    ('E648', 'Sequelae of other nutritional deficiencies'),
    ('E649', 'Sequelae of unspecified nutritional deficiency'),
    ('E65', 'Localized adiposity'),
    ('E6601', 'Morbid (severe) obesity due to excess calories'),
    ('E6609', 'Other obesity due to excess calories'),
    ('E661', 'Drug-induced obesity'),
    ('E662', 'Morbid (severe) obesity with alveolar hypoventilation'),
    ('E663', 'Overweight'),
    ('E668', 'Other obesity'),
    ('E669', 'Obesity, unspecified'),
    ('E670', 'Hypervitaminosis A'),
    ('E671', 'Hypercarotenemia'),
    ('E672', 'Megavitamin-B6 syndrome'),
    ('E673', 'Hypervitaminosis D'),
    ('E678', 'Other specified hyperalimentation'),
    ('E68', 'Sequelae of hyperalimentation'),
    ('E700', 'Classical phenylketonuria'),
    ('E701', 'Other hyperphenylalaninemias'),
    ('E7020', 'Disorder of tyrosine metabolism, unspecified'),
    ('E7021', 'Tyrosinemia'),
    ('E7029', 'Other disorders of tyrosine metabolism'),
    ('E7030', 'Albinism, unspecified'),
    ('E70310', 'X-linked ocular albinism'),
    ('E70311', 'Autosomal recessive ocular albinism'),
    ('E70318', 'Other ocular albinism'),
    ('E70319', 'Ocular albinism, unspecified'),
    ('E70320', 'Tyrosinase negative oculocutaneous albinism'),
    ('E70321', 'Tyrosinase positive oculocutaneous albinism'),
    ('E70328', 'Other oculocutaneous albinism'),
    ('E70329', 'Oculocutaneous albinism, unspecified'),
    ('E70330', 'Chediak-Higashi syndrome'),
    ('E70331', 'Hermansky-Pudlak syndrome'),
    ('E70338', 'Other albinism with hematologic abnormality'),
    ('E70339', 'Albinism with hematologic abnormality, unspecified'),
    ('E7039', 'Other specified albinism'),
    ('E7040', 'Disorders of histidine metabolism, unspecified'),
    ('E7041', 'Histidinemia'),
    ('E7049', 'Other disorders of histidine metabolism'),
    ('E705', 'Disorders of tryptophan metabolism'),
    ('E708', 'Other disorders of aromatic amino-acid metabolism'),
    ('E7081', 'Aromatic L-amino acid decarboxylase deficiency'),
    ('E7089', 'Other disorders of aromatic amino-acid metabolism'),
    ('E709', 'Disorder of aromatic amino-acid metabolism, unspecified'),
    ('E710', 'Maple-syrup-urine disease'),
    ('E71110', 'Isovaleric acidemia'),
    ('E71111', '3-methylglutaconic aciduria'),
    ('E71118', 'Other branched-chain organic acidurias'),
    ('E71120', 'Methylmalonic acidemia'),
    ('E71121', 'Propionic acidemia'),
    ('E71128', 'Other disorders of propionate metabolism'),
    ('E7119', 'Other disorders of branched-chain amino-acid metabolism'),
    ('E712', 'Disorder of branched-chain amino-acid metabolism, unsp'),
    ('E7130', 'Disorder of fatty-acid metabolism, unspecified'),
    ('E71310', 'Long chain/very long chain acyl CoA dehydrogenase deficiency'),
    ('E71311', 'Medium chain acyl CoA dehydrogenase deficiency'),
    ('E71312', 'Short chain acyl CoA dehydrogenase deficiency'),
    ('E71313', 'Glutaric aciduria type II'),
    ('E71314', 'Muscle carnitine palmitoyltransferase deficiency'),
    ('E71318', 'Other disorders of fatty-acid oxidation'),
    ('E7132', 'Disorders of ketone metabolism'),
    ('E7139', 'Other disorders of fatty-acid metabolism'),
    ('E7140', 'Disorder of carnitine metabolism, unspecified'),
    ('E7141', 'Primary carnitine deficiency'),
    ('E7142', 'Carnitine deficiency due to inborn errors of metabolism'),
    ('E7143', 'Iatrogenic carnitine deficiency'),
    ('E71440', 'Ruvalcaba-Myhre-Smith syndrome'),
    ('E71448', 'Other secondary carnitine deficiency'),
    ('E7150', 'Peroxisomal disorder, unspecified'),
    ('E71510', 'Zellweger syndrome'),
    ('E71511', 'Neonatal adrenoleukodystrophy'),
    ('E71518', 'Other disorders of peroxisome biogenesis'),
    ('E71520', 'Childhood cerebral X-linked adrenoleukodystrophy'),
    ('E71521', 'Adolescent X-linked adrenoleukodystrophy'),
    ('E71522', 'Adrenomyeloneuropathy'),
    ('E71528', 'Other X-linked adrenoleukodystrophy'),
    ('E71529', 'X-linked adrenoleukodystrophy, unspecified type'),
    ('E7153', 'Other group 2 peroxisomal disorders'),
    ('E71540', 'Rhizomelic chondrodysplasia punctata'),
    ('E71541', 'Zellweger-like syndrome'),
    ('E71542', 'Other group 3 peroxisomal disorders'),
    ('E71548', 'Other peroxisomal disorders'),
    ('E7200', 'Disorders of amino-acid transport, unspecified'),
    ('E7201', 'Cystinuria'),
    ('E7202', "Hartnup's disease"),
    ('E7203', "Lowe's syndrome"),
    ('E7204', 'Cystinosis'),
    ('E7209', 'Other disorders of amino-acid transport'),
    ('E7210', 'Disorders of sulfur-bearing amino-acid metabolism, unsp'),
    ('E7211', 'Homocystinuria'),
    ('E7212', 'Methylenetetrahydrofolate reductase deficiency'),
    ('E7219', 'Other disorders of sulfur-bearing amino-acid metabolism'),
    ('E7220', 'Disorder of urea cycle metabolism, unspecified'),
    ('E7221', 'Argininemia'),
    ('E7222', 'Arginosuccinic aciduria'),
    ('E7223', 'Citrullinemia'),
    ('E7229', 'Other disorders of urea cycle metabolism'),
    ('E723', 'Disorders of lysine and hydroxylysine metabolism'),
    ('E724', 'Disorders of ornithine metabolism'),
    ('E7250', 'Disorder of glycine metabolism, unspecified'),
    ('E7251', 'Non-ketotic hyperglycinemia'),
    ('E7252', 'Trimethylaminuria'),
    ('E7253', 'Primary hyperoxaluria'),
    ('E7259', 'Other disorders of glycine metabolism'),
    ('E728', 'Other specified disorders of amino-acid metabolism'),
    ('E7281', 'Disorders of gamma aminobutyric acid metabolism'),
    ('E7289', 'Other specified disorders of amino-acid metabolism'),
    ('E729', 'Disorder of amino-acid metabolism, unspecified'),
    ('E730', 'Congenital lactase deficiency'),
    ('E731', 'Secondary lactase deficiency'),
    ('E738', 'Other lactose intolerance'),
    ('E739', 'Lactose intolerance, unspecified'),
    ('E7400', 'Glycogen storage disease, unspecified'),
    ('E7401', 'von Gierke disease'),
    ('E7402', 'Pompe disease'),
    ('E7403', 'Cori disease'),
    ('E7404', 'McArdle disease'),
    ('E7405', 'Lysosome-associated membrane protein 2 [LAMP2] deficiency'),
    ('E7409', 'Other glycogen storage disease'),
    ('E7410', 'Disorder of fructose metabolism, unspecified'),
    ('E7411', 'Essential fructosuria'),
    ('E7412', 'Hereditary fructose intolerance'),
    ('E7419', 'Other disorders of fructose metabolism'),
    ('E7420', 'Disorders of galactose metabolism, unspecified'),
    ('E7421', 'Galactosemia'),
    ('E7429', 'Other disorders of galactose metabolism'),
    ('E7431', 'Sucrase-isomaltase deficiency'),
    ('E7439', 'Other disorders of intestinal carbohydrate absorption'),
    ('E744', 'Disorders of pyruvate metabolism and gluconeogenesis'),
    ('E748', 'Other specified disorders of carbohydrate metabolism'),
    ('E74810', 'Glucose transporter protein type 1 deficiency'),
    ('E74818', 'Other disorders of glucose transport'),
    ('E74819', 'Disorders of glucose transport, unspecified'),
    ('E7489', 'Other specified disorders of carbohydrate metabolism'),
    ('E749', 'Disorder of carbohydrate metabolism, unspecified'),
    ('E7500', 'GM2 gangliosidosis, unspecified'),
    ('E7501', 'Sandhoff disease'),
    ('E7502', 'Tay-Sachs disease'),
    ('E7509', 'Other GM2 gangliosidosis'),
    ('E7510', 'Unspecified gangliosidosis'),
    ('E7511', 'Mucolipidosis IV'),
    ('E7519', 'Other gangliosidosis'),
    ('E7521', 'Fabry (-Anderson) disease'),
    ('E7522', 'Gaucher disease'),
    ('E7523', 'Krabbe disease'),
    ('E75240', 'Niemann-Pick disease type A'),
    ('E75241', 'Niemann-Pick disease type B'),
    ('E75242', 'Niemann-Pick disease type C'),
    ('E75243', 'Niemann-Pick disease type D'),
    ('E75244', 'Niemann-Pick disease type A/B'),
    ('E75248', 'Other Niemann-Pick disease'),
    ('E75249', 'Niemann-Pick disease, unspecified'),
    ('E7525', 'Metachromatic leukodystrophy'),
    ('E7526', 'Sulfatase deficiency'),
    ('E7527', 'Pelizaeus-Merzbacher disease'),
    ('E7528', 'Canavan disease'),
    ('E7529', 'Other sphingolipidosis'),
    ('E753', 'Sphingolipidosis, unspecified'),
    ('E754', 'Neuronal ceroid lipofuscinosis'),
    ('E755', 'Other lipid storage disorders'),
    ('E756', 'Lipid storage disorder, unspecified'),
    ('E7601', "Hurler's syndrome"),
    ('E7602', 'Hurler-Scheie syndrome'),
    ('E7603', "Scheie's syndrome"),
    ('E761', 'Mucopolysaccharidosis, type II'),
    ('E76210', 'Morquio A mucopolysaccharidoses'),
    ('E76211', 'Morquio B mucopolysaccharidoses'),
    ('E76219', 'Morquio mucopolysaccharidoses, unspecified'),
    ('E7622', 'Sanfilippo mucopolysaccharidoses'),
    ('E7629', 'Other mucopolysaccharidoses'),
    ('E763', 'Mucopolysaccharidosis, unspecified'),
    ('E768', 'Other disorders of glucosaminoglycan metabolism'),
    ('E769', 'Glucosaminoglycan metabolism disorder, unspecified'),
    ('E770', 'Defects in post-translational mod of lysosomal enzymes'),
    ('E771', 'Defects in glycoprotein degradation'),
    ('E778', 'Other disorders of glycoprotein metabolism'),
    ('E779', 'Disorder of glycoprotein metabolism, unspecified'),
    ('E780', 'Pure hypercholesterolemia'),
    ('E7800', 'Pure hypercholesterolemia, unspecified'),
    ('E7801', 'Familial hypercholesterolemia'),
    ('E781', 'Pure hyperglyceridemia'),
    ('E782', 'Mixed hyperlipidemia'),
    ('E783', 'Hyperchylomicronemia'),
    ('E784', 'Elevated Lipoprotein(a)'),
    ('E7841', 'Other hyperlipidemia'),
    ('E7849', 'Other hyperlipidemia'),
    ('E785', 'Hyperlipidemia, unspecified'),
    ('E786', 'Lipoprotein deficiency'),
    ('E7870', 'Disorder of bile acid and cholesterol metabolism, unsp'),
    ('E7871', 'Barth syndrome'),
    ('E7872', 'Smith-Lemli-Opitz syndrome'),
    ('E7879', 'Other disorders of bile acid and cholesterol metabolism'),
    ('E7881', 'Lipoid dermatoarthritis'),
    ('E7889', 'Other lipoprotein metabolism disorders'),
    ('E789', 'Disorder of lipoprotein metabolism, unspecified'),
    ('E790', 'Hyperuricemia w/o signs of inflam arthrit and tophaceous dis'),
    ('E791', 'Lesch-Nyhan syndrome'),
    ('E792', 'Myoadenylate deaminase deficiency'),
    ('E798', 'Other disorders of purine and pyrimidine metabolism'),
    ('E7981', 'Aicardi-Goutieres syndrome'),
    ('E7982', 'Hereditary xanthinuria'),
    ('E7989', 'Oth disrd of purine and pyrimidine metabolism'),
    ('E799', 'Disorder of purine and pyrimidine metabolism, unspecified'),
    ('E800', 'Hereditary erythropoietic porphyria'),
    ('E801', 'Porphyria cutanea tarda'),
    ('E8020', 'Unspecified porphyria'),
    ('E8021', 'Acute intermittent (hepatic) porphyria'),
    ('E8029', 'Other porphyria'),
    ('E803', 'Defects of catalase and peroxidase'),
    ('E804', 'Gilbert syndrome'),
    ('E805', 'Crigler-Najjar syndrome'),
    ('E806', 'Other disorders of bilirubin metabolism'),
    ('E807', 'Disorder of bilirubin metabolism, unspecified'),
    ('E8300', 'Disorder of copper metabolism, unspecified'),
    ('E8301', "Wilson's disease"),
    ('E8309', 'Other disorders of copper metabolism'),
    ('E8310', 'Disorder of iron metabolism, unspecified'),
    ('E83110', 'Hereditary hemochromatosis'),
    ('E83111', 'Hemochromatosis due to repeated red blood cell transfusions'),
    ('E83118', 'Other hemochromatosis'),
    ('E83119', 'Hemochromatosis, unspecified'),
    ('E8319', 'Other disorders of iron metabolism'),
    ('E832', 'Disorders of zinc metabolism'),
    ('E8330', 'Disorder of phosphorus metabolism, unspecified'),
    ('E8331', 'Familial hypophosphatemia'),
    ('E8332', 'Hereditary vitamin D-dependent rickets (type 1) (type 2)'),
    ('E8339', 'Other disorders of phosphorus metabolism'),
    ('E8340', 'Disorders of magnesium metabolism, unspecified'),
    ('E8341', 'Hypermagnesemia'),
    ('E8342', 'Hypomagnesemia'),
    ('E8349', 'Other disorders of magnesium metabolism'),
    ('E8350', 'Unspecified disorder of calcium metabolism'),
    ('E8351', 'Hypocalcemia'),
    ('E8352', 'Hypercalcemia'),
    ('E8359', 'Other disorders of calcium metabolism'),
    ('E8381', 'Hungry bone syndrome'),
    ('E8389', 'Other disorders of mineral metabolism'),
    ('E839', 'Disorder of mineral metabolism, unspecified'),
    ('E840', 'Cystic fibrosis with pulmonary manifestations'),
    ('E8411', 'Meconium ileus in cystic fibrosis'),
    ('E8419', 'Cystic fibrosis with other intestinal manifestations'),
    ('E848', 'Cystic fibrosis with other manifestations'),
    ('E849', 'Cystic fibrosis, unspecified'),
    ('E850', 'Non-neuropathic heredofamilial amyloidosis'),
    ('E851', 'Neuropathic heredofamilial amyloidosis'),
    ('E852', 'Heredofamilial amyloidosis, unspecified'),
    ('E853', 'Secondary systemic amyloidosis'),
    ('E854', 'Organ-limited amyloidosis'),
    ('E858', 'Other amyloidosis'),
    ('E8581', 'Light chain (AL) amyloidosis'),
    ('E8582', 'Wild-type transthyretin-related (ATTR) amyloidosis'),
    ('E8589', 'Other amyloidosis'),
    ('E859', 'Amyloidosis, unspecified'),
    ('E860', 'Dehydration'),
    ('E861', 'Hypovolemia'),
    ('E869', 'Volume depletion, unspecified'),
    ('E870', 'Hyperosmolality and hypernatremia'),
    ('E871', 'Hypo-osmolality and hyponatremia'),
    ('E872', 'Acidosis'),
    ('E8720', 'Acidosis, unspecified'),
    ('E8721', 'Acute metabolic acidosis'),
    ('E8722', 'Chronic metabolic acidosis'),
    ('E8729', 'Other acidosis'),
    ('E873', 'Alkalosis'),
    ('E874', 'Mixed disorder of acid-base balance'),
    ('E875', 'Hyperkalemia'),
    ('E876', 'Hypokalemia'),
    ('E8770', 'Fluid overload, unspecified'),
    ('E8771', 'Transfusion associated circulatory overload'),
    ('E8779', 'Other fluid overload'),
    ('E878', 'Oth disorders of electrolyte and fluid balance, NEC'),
    ('E8801', 'Alpha-1-antitrypsin deficiency'),
    ('E8802', 'Plasminogen deficiency'),
    ('E8809', 'Oth disorders of plasma-protein metabolism, NEC'),
    ('E881', 'Lipodystrophy, not elsewhere classified'),
    ('E882', 'Lipomatosis, not elsewhere classified'),
    ('E883', 'Tumor lysis syndrome'),
    ('E8840', 'Mitochondrial metabolism disorder, unspecified'),
    ('E8841', 'MELAS syndrome'),
    ('E8842', 'MERRF syndrome'),
    ('E8843', 'Disorders of mitochondrial tRNA synthetases'),
    ('E8849', 'Other mitochondrial metabolism disorders'),
    ('E8881', 'Metabolic syndrome'),
    ('E88810', 'Metabolic syndrome'),
    ('E88811', 'Insulin resistance syndrome, Type A'),
    ('E88818', 'Other insulin resistance'),
    ('E88819', 'Insulin resistance, unspecified'),
    ('E8889', 'Other specified metabolic disorders'),
    ('E889', 'Metabolic disorder, unspecified'),
    ('E88A', 'Wasting disease (syndrome) due to underlying condition'),
    ('E890', 'Postprocedural hypothyroidism'),
    ('E891', 'Postprocedural hypoinsulinemia'),
    ('E892', 'Postprocedural hypoparathyroidism'),
    ('E893', 'Postprocedural hypopituitarism'),
    ('E8940', 'Asymptomatic postprocedural ovarian failure'),
    ('E8941', 'Symptomatic postprocedural ovarian failure'),
    ('E895', 'Postprocedural testicular hypofunction'),
    ('E896', 'Postprocedural adrenocortical (-medullary) hypofunction'),
    ('E89810', 'Postproc hemor of endo sys org fol an endo sys proc'),
    ('E89811', 'Postproc hemor of an endo sys org fol oth procedure'),
    ('E89820', 'Postproc hematoma of an endo sys org fol an endo sys proc'),
    ('E89821', 'Postproc hematoma of an endo sys org fol other procedure'),
    ('E89822', 'Postproc seroma of an endo sys org fol an endo sys procedure'),
    ('E89823', 'Postproc seroma of an endo sys org following other procedure'),
    ('E8989', 'Oth postproc endocrine and metabolic comp and disorders'),
    ('F0150', 'Vascular dementia, unsp severity, without beh/psych/mood/anx'),
    ('F0151', 'Vascular dementia with behavioral disturbance'),
    ('F01511', 'Vascular dementia, unspecified severity, with agitation'),
    ('F01518', 'Vascular dementia, unsp severity, with other beh disturb'),
    ('F0152', 'Vascular dementia, unsp severity, with psychotic disturb'),
    ('F0153', 'Vascular dementia, unspecified severity, with mood disturb'),
    ('F0154', 'Vascular dementia, unspecified severity, with anxiety'),
    ('F01A0', 'Vascular dementia, mild, without beh/psych/mood/anx'),
    ('F01A11', 'Vascular dementia, mild, with agitation'),
    ('F01A18', 'Vascular dementia, mild, with other behavioral disturbance'),
    ('F01A2', 'Vascular dementia, mild, with psychotic disturbance'),
    ('F01A3', 'Vascular dementia, mild, with mood disturbance'),
    ('F01A4', 'Vascular dementia, mild, with anxiety'),
    ('F01B0', 'Vascular dementia, moderate, without beh/psych/mood/anx'),
    ('F01B11', 'Vascular dementia, moderate, with agitation'),
    ('F01B18', 'Vascular dementia, moderate, with other behavioral disturb'),
    ('F01B2', 'Vascular dementia, moderate, with psychotic disturbance'),
    ('F01B3', 'Vascular dementia, moderate, with mood disturbance'),
    ('F01B4', 'Vascular dementia, moderate, with anxiety'),
    ('F01C0', 'Vascular dementia, severe, without beh/psych/mood/anx'),
    ('F01C11', 'Vascular dementia, severe, with agitation'),
    ('F01C18', 'Vascular dementia, severe, with other behavioral disturbance'),
    ('F01C2', 'Vascular dementia, severe, with psychotic disturbance'),
    ('F01C3', 'Vascular dementia, severe, with mood disturbance'),
    ('F01C4', 'Vascular dementia, severe, with anxiety'),
    ('F0280', 'Dem in oth dis classd elswhr, unsp sev, w/o beh/psych/mood/anx'),
    ('F0281', 'Dementia in oth diseases classd elswhr w behavioral disturb'),
    ('F02811', 'Dem in other dis classd elswhr, unsp severt, with agitation'),
    ('F02818', 'Dem in oth dis classd elswhr, unsp sev, with oth beh distrb'),
    ('F0282', 'Dem in other dis classd elswhr, unsp sev, with psych distrb'),
    ('F0283', 'Dem in other dis classd elswhr, unsp sev, with mood distrb'),
    ('F0284', 'Dem in other dis classd elswhr, unsp severity, with anxiety'),
    ('F02A0', 'Dem in other dis classd elswhr, mild, w/o beh/psych/mood/anx'),
    ('F02A11', 'Dem in other diseases classd elswhr, mild, with agitation'),
    ('F02A18', 'Dem in other dis classd elswhr, mild, with other beh distrb'),
    ('F02A2', 'Dem in other dis classd elswhr, mild, with psych disturb'),
    ('F02A3', 'Dem in other diseases classd elswhr, mild, with mood disturb'),
    ('F02A4', 'Dementia in other diseases classd elswhr, mild, with anxiety'),
    ('F02B0', 'Dem in other dis classd elswhr, mod, w/o beh/psych/mood/anx'),
    ('F02B11', 'Dem in other dis classd elswhr, moderate, with agitation'),
    ('F02B18', 'Dem in other dis classd elswhr, mod, with other beh disturb'),
    ('F02B2', 'Dem in other dis classd elswhr, moderate, with psych disturb'),
    ('F02B3', 'Dem in other dis classd elswhr, moderate, with mood disturb'),
    ('F02B4', 'Dem in other diseases classd elswhr, moderate, with anxiety'),
    ('F02C0', 'Dem in other dis classd elswhr, sev, w/o beh/psych/mood/anx'),
    ('F02C11', 'Dem in other diseases classd elswhr, severe, with agitation'),
    ('F02C18', 'Dem in other dis classd elswhr, sev, with other beh distrb'),
    ('F02C2', 'Dem in other dis classd elswhr, severe, with psych disturb'),
    ('F02C3', 'Dem in other dis classd elswhr, severe, with mood disturb'),
    ('F02C4', 'Dem in other diseases classd elswhr, severe, with anxiety'),
    ('F0390', 'Unsp dementia, unsp severity, without beh/psych/mood/anx'),
    ('F0391', 'Unspecified dementia with behavioral disturbance'),
    ('F03911', 'Unspecified dementia, unspecified severity, with agitation'),
    ('F03918', 'Unsp dementia, unsp severity, with other behavioral disturb'),
    ('F0392', 'Unsp dementia, unspecified severity, with psychotic disturb'),
    ('F0393', 'Unsp dementia, unspecified severity, with mood disturb'),
    ('F0394', 'Unspecified dementia, unspecified severity, with anxiety'),
    ('F03A0', 'Unspecified dementia, mild, without beh/psych/mood/anx'),
    ('F03A11', 'Unspecified dementia, mild, with agitation'),
    ('F03A18', 'Unspecified dementia, mild, with other behavioral disturb'),
    ('F03A2', 'Unspecified dementia, mild, with psychotic disturbance'),
    ('F03A3', 'Unspecified dementia, mild, with mood disturbance'),
    ('F03A4', 'Unspecified dementia, mild, with anxiety'),
    ('F03B0', 'Unspecified dementia, moderate, without beh/psych/mood/anx'),
    ('F03B11', 'Unspecified dementia, moderate, with agitation'),
    ('F03B18', 'Unsp dementia, moderate, with other behavioral disturb'),
    ('F03B2', 'Unspecified dementia, moderate, with psychotic disturbance'),
    ('F03B3', 'Unspecified dementia, moderate, with mood disturbance'),
    ('F03B4', 'Unspecified dementia, moderate, with anxiety'),
    ('F03C0', 'Unspecified dementia, severe, without beh/psych/mood/anx'),
    ('F03C11', 'Unspecified dementia, severe, with agitation'),
    ('F03C18', 'Unspecified dementia, severe, with other behavioral disturb'),
    ('F03C2', 'Unspecified dementia, severe, with psychotic disturbance'),
    ('F03C3', 'Unspecified dementia, severe, with mood disturbance'),
    ('F03C4', 'Unspecified dementia, severe, with anxiety'),
    ('F04', 'Amnestic disorder due to known physiological condition'),
    ('F05', 'Delirium due to known physiological condition'),
    ('F060', 'Psychotic disorder w hallucin due to known physiol condition'),
    ('F061', 'Catatonic disorder due to known physiological condition'),
    ('F062', 'Psychotic disorder w delusions due to known physiol cond'),
    ('F0630', 'Mood disorder due to known physiological condition, unsp'),
    ('F0631', 'Mood disorder due to known physiol cond w depressv features'),
    ('F0632', 'Mood disord d/t physiol cond w major depressive-like epsd'),
    ('F0633', 'Mood disorder due to known physiol cond w manic features'),
    ('F0634', 'Mood disorder due to known physiol cond w mixed features'),
    ('F064', 'Anxiety disorder due to known physiological condition'),
    ('F0670', 'Mild neurocog disord d/t known physiol cond w/o beh distrb'),
    ('F0671', 'Mild neurocog disord d/t known physiol cond with beh distrb'),
    ('F068', 'Oth mental disorders due to known physiological condition'),
    ('F070', 'Personality change due to known physiological condition'),
    ('F0781', 'Postconcussional syndrome'),
    ('F0789', 'Oth personality & behavrl disord due to known physiol cond'),
    ('F079', 'Unsp personality & behavrl disord due to known physiol cond'),
    ('F09', 'Unsp mental disorder due to known physiological condition'),
    ('F1010', 'Alcohol abuse, uncomplicated'),
    ('F1011', 'Alcohol abuse, in remission'),
    ('F10120', 'Alcohol abuse with intoxication, uncomplicated'),
    ('F10121', 'Alcohol abuse with intoxication delirium'),
    ('F10129', 'Alcohol abuse with intoxication, unspecified'),
    ('F10130 ', 'Alcohol abuse with withdrawal, uncomplicated '),
    ('F10131', 'Alcohol abuse with withdrawal delirium '),
    ('F10132', 'Alcohol abuse with withdrawal with perceptual disturbance'),
    ('F10139', 'Alcohol abuse with withdrawal, unspecified'),
    ('F1014', 'Alcohol abuse with alcohol-induced mood disorder'),
    ('F10150', 'Alcohol abuse w alcoh-induce psychotic disorder w delusions'),
    ('F10151', 'Alcohol abuse w alcoh-induce psychotic disorder w hallucin'),
    ('F10159', 'Alcohol abuse with alcohol-induced psychotic disorder, unsp'),
    ('F10180', 'Alcohol abuse with alcohol-induced anxiety disorder'),
    ('F10181', 'Alcohol abuse with alcohol-induced sexual dysfunction'),
    ('F10182', 'Alcohol abuse with alcohol-induced sleep disorder'),
    ('F10188', 'Alcohol abuse with other alcohol-induced disorder'),
    ('F1019', 'Alcohol abuse with unspecified alcohol-induced disorder'),
    ('F1020', 'Alcohol dependence, uncomplicated'),
    ('F1021', 'Alcohol dependence, in remission'),
    ('F10220', 'Alcohol dependence with intoxication, uncomplicated'),
    ('F10221', 'Alcohol dependence with intoxication delirium'),
    ('F10229', 'Alcohol dependence with intoxication, unspecified'),
    ('F10230', 'Alcohol dependence with withdrawal, uncomplicated'),
    ('F10231', 'Alcohol dependence with withdrawal delirium'),
    ('F10232', 'Alcohol dependence w withdrawal with perceptual disturbance'),
    ('F10239', 'Alcohol dependence with withdrawal, unspecified'),
    ('F1024', 'Alcohol dependence with alcohol-induced mood disorder'),
    ('F10250', 'Alcohol depend w alcoh-induce psychotic disorder w delusions'),
    ('F10251', 'Alcohol depend w alcoh-induce psychotic disorder w hallucin'),
    ('F10259', 'Alcohol dependence w alcoh-induce psychotic disorder, unsp'),
    ('F1026', 'Alcohol depend w alcoh-induce persisting amnestic disorder'),
    ('F1027', 'Alcohol dependence with alcohol-induced persisting dementia'),
    ('F10280', 'Alcohol dependence with alcohol-induced anxiety disorder'),
    ('F10281', 'Alcohol dependence with alcohol-induced sexual dysfunction'),
    ('F10282', 'Alcohol dependence with alcohol-induced sleep disorder'),
    ('F10288', 'Alcohol dependence with other alcohol-induced disorder'),
    ('F1029', 'Alcohol dependence with unspecified alcohol-induced disorder'),
    ('F1090', 'Alcohol use, unspecified, uncomplicated'),
    ('F1091', 'Alcohol use, unspecified, in remission'),
    ('F10920', 'Alcohol use, unspecified with intoxication, uncomplicated'),
    ('F10921', 'Alcohol use, unspecified with intoxication delirium'),
    ('F10929', 'Alcohol use, unspecified with intoxication, unspecified'),
    ('F10930 ', 'Alcohol use, unspecified with withdrawal, uncomplicated '),
    ('F10931', 'Alcohol use, unspecified with withdrawal delirium '),
    ('F10932', 'Alcohol use, unspecified with w/drawal w perceptual disturb'),
    ('F10939', 'Alcohol use, unspecified with withdrawal, unspecified'),
    ('F1094', 'Alcohol use, unspecified with alcohol-induced mood disorder'),
    ('F10950', 'Alcohol use, unsp w alcoh-induce psych disorder w delusions'),
    ('F10951', 'Alcohol use, unsp w alcoh-induce psych disorder w hallucin'),
    ('F10959', 'Alcohol use, unsp w alcohol-induced psychotic disorder, unsp'),
    ('F1096', 'Alcohol use, unsp w alcoh-induce persist amnestic disorder'),
    ('F1097', 'Alcohol use, unsp with alcohol-induced persisting dementia'),
    ('F10980', 'Alcohol use, unsp with alcohol-induced anxiety disorder'),
    ('F10981', 'Alcohol use, unsp with alcohol-induced sexual dysfunction'),
    ('F10982', 'Alcohol use, unspecified with alcohol-induced sleep disorder'),
    ('F10988', 'Alcohol use, unspecified with other alcohol-induced disorder'),
    ('F1099', 'Alcohol use, unsp with unspecified alcohol-induced disorder'),
    ('F1110', 'Opioid abuse, uncomplicated'),
    ('F1111', 'Opioid abuse, in remission'),
    ('F11120', 'Opioid abuse with intoxication, uncomplicated'),
    ('F11121', 'Opioid abuse with intoxication delirium'),
    ('F11122', 'Opioid abuse with intoxication with perceptual disturbance'),
    ('F11129', 'Opioid abuse with intoxication, unspecified'),
    ('F1113', 'Opioid abuse with withdrawal'),
    ('F1114', 'Opioid abuse with opioid-induced mood disorder'),
    ('F11150', 'Opioid abuse w opioid-induced psychotic disorder w delusions'),
    ('F11151', 'Opioid abuse w opioid-induced psychotic disorder w hallucin'),
    ('F11159', 'Opioid abuse with opioid-induced psychotic disorder, unsp'),
    ('F11181', 'Opioid abuse with opioid-induced sexual dysfunction'),
    ('F11182', 'Opioid abuse with opioid-induced sleep disorder'),
    ('F11188', 'Opioid abuse with other opioid-induced disorder'),
    ('F1119', 'Opioid abuse with unspecified opioid-induced disorder'),
    ('F1120', 'Opioid dependence, uncomplicated'),
    ('F1121', 'Opioid dependence, in remission'),
    ('F11220', 'Opioid dependence with intoxication, uncomplicated'),
    ('F11221', 'Opioid dependence with intoxication delirium'),
    ('F11222', 'Opioid dependence w intoxication with perceptual disturbance'),
    ('F11229', 'Opioid dependence with intoxication, unspecified'),
    ('F1123', 'Opioid dependence with withdrawal'),
    ('F1124', 'Opioid dependence with opioid-induced mood disorder'),
    ('F11250', 'Opioid depend w opioid-induc psychotic disorder w delusions'),
    ('F11251', 'Opioid depend w opioid-induc psychotic disorder w hallucin'),
    ('F11259', 'Opioid dependence w opioid-induced psychotic disorder, unsp'),
    ('F11281', 'Opioid dependence with opioid-induced sexual dysfunction'),
    ('F11282', 'Opioid dependence with opioid-induced sleep disorder'),
    ('F11288', 'Opioid dependence with other opioid-induced disorder'),
    ('F1129', 'Opioid dependence with unspecified opioid-induced disorder'),
    ('F1190', 'Opioid use, unspecified, uncomplicated'),
    ('F1191', 'Opioid use, unspecified, in remission'),
    ('F11920', 'Opioid use, unspecified with intoxication, uncomplicated'),
    ('F11921', 'Opioid use, unspecified with intoxication delirium'),
    ('F11922', 'Opioid use, unsp w intoxication with perceptual disturbance'),
    ('F11929', 'Opioid use, unspecified with intoxication, unspecified'),
    ('F1193', 'Opioid use, unspecified with withdrawal'),
    ('F1194', 'Opioid use, unspecified with opioid-induced mood disorder'),
    ('F11950', 'Opioid use, unsp w opioid-induc psych disorder w delusions'),
    ('F11951', 'Opioid use, unsp w opioid-induc psych disorder w hallucin'),
    ('F11959', 'Opioid use, unsp w opioid-induced psychotic disorder, unsp'),
    ('F11981', 'Opioid use, unsp with opioid-induced sexual dysfunction'),
    ('F11982', 'Opioid use, unspecified with opioid-induced sleep disorder'),
    ('F11988', 'Opioid use, unspecified with other opioid-induced disorder'),
    ('F1199', 'Opioid use, unsp with unspecified opioid-induced disorder'),
    ('F1210', 'Cannabis abuse, uncomplicated'),
    ('F1211', 'Cannabis abuse, in remission'),
    ('F12120', 'Cannabis abuse with intoxication, uncomplicated'),
    ('F12121', 'Cannabis abuse with intoxication delirium'),
    ('F12122', 'Cannabis abuse with intoxication with perceptual disturbance'),
    ('F12129', 'Cannabis abuse with intoxication, unspecified'),
    ('F1213', 'Cannabis abuse with withdrawal'),
    ('F12150', 'Cannabis abuse with psychotic disorder with delusions'),
    ('F12151', 'Cannabis abuse with psychotic disorder with hallucinations'),
    ('F12159', 'Cannabis abuse with psychotic disorder, unspecified'),
    ('F12180', 'Cannabis abuse with cannabis-induced anxiety disorder'),
    ('F12188', 'Cannabis abuse with other cannabis-induced disorder'),
    ('F1219', 'Cannabis abuse with unspecified cannabis-induced disorder'),
    ('F1220', 'Cannabis dependence, uncomplicated'),
    ('F1221', 'Cannabis dependence, in remission'),
    ('F12220', 'Cannabis dependence with intoxication, uncomplicated'),
    ('F12221', 'Cannabis dependence with intoxication delirium'),
    ('F12222', 'Cannabis dependence w intoxication w perceptual disturbance'),
    ('F12229', 'Cannabis dependence with intoxication, unspecified'),
    ('F1223', 'Cannabis dependence with withdrawal'),
    ('F12250', 'Cannabis dependence with psychotic disorder with delusions'),
    ('F12251', 'Cannabis dependence w psychotic disorder with hallucinations'),
    ('F12259', 'Cannabis dependence with psychotic disorder, unspecified'),
    ('F12280', 'Cannabis dependence with cannabis-induced anxiety disorder'),
    ('F12288', 'Cannabis dependence with other cannabis-induced disorder'),
    ('F1229', 'Cannabis dependence with unsp cannabis-induced disorder'),
    ('F1290', 'Cannabis use, unspecified, uncomplicated'),
    ('F1291', 'Cannabis use, unspecified, in remission'),
    ('F12920', 'Cannabis use, unspecified with intoxication, uncomplicated'),
    ('F12921', 'Cannabis use, unspecified with intoxication delirium'),
    ('F12922', 'Cannabis use, unsp w intoxication w perceptual disturbance'),
    ('F12929', 'Cannabis use, unspecified with intoxication, unspecified'),
    ('F1293', 'Cannabis use, unspecified with withdrawal'),
    ('F12950', 'Cannabis use, unsp with psychotic disorder with delusions'),
    ('F12951', 'Cannabis use, unsp w psychotic disorder with hallucinations'),
    ('F12959', 'Cannabis use, unsp with psychotic disorder, unspecified'),
    ('F12980', 'Cannabis use, unspecified with anxiety disorder'),
    ('F12988', 'Cannabis use, unsp with other cannabis-induced disorder'),
    ('F1299', 'Cannabis use, unsp with unsp cannabis-induced disorder'),
    ('F1310', 'Sedative, hypnotic or anxiolytic abuse, uncomplicated'),
    ('F1311', 'Sedative, hypnotic or anxiolytic abuse, in remission'),
    ('F13120', 'Sedatv/hyp/anxiolytc abuse w intoxication, uncomplicated'),
    ('F13121', 'Sedatv/hyp/anxiolytc abuse w intoxication delirium'),
    ('F13129', 'Sedative, hypnotic or anxiolytic abuse w intoxication, unsp'),
    ('F13130', 'Sedatv/hyp/anxiolytc abuse with withdrawal, uncomplicated'),
    ('F13131', 'Sedatv/hyp/anxiolytc abuse with withdrawal delirium'),
    ('F13132', 'Sedatv/hyp/anxiolytc abuse with w/drawal w perceptl disturb'),
    ('F13139', 'Sedatv/hyp/anxiolytc abuse with withdrawal, unspecified'),
    ('F1314', 'Sedative, hypnotic or anxiolytic abuse w mood disorder'),
    ('F13150', 'Sedatv/hyp/anxiolytc abuse w psychotic disorder w delusions'),
    ('F13151', 'Sedatv/hyp/anxiolytc abuse w psychotic disorder w hallucin'),
    ('F13159', 'Sedatv/hyp/anxiolytc abuse w psychotic disorder, unsp'),
    ('F13180', 'Sedative, hypnotic or anxiolytic abuse w anxiety disorder'),
    ('F13181', 'Sedative, hypnotic or anxiolytic abuse w sexual dysfunction'),
    ('F13182', 'Sedative, hypnotic or anxiolytic abuse w sleep disorder'),
    ('F13188', 'Sedative, hypnotic or anxiolytic abuse w oth disorder'),
    ('F1319', 'Sedative, hypnotic or anxiolytic abuse w unsp disorder'),
    ('F1320', 'Sedative, hypnotic or anxiolytic dependence, uncomplicated'),
    ('F1321', 'Sedative, hypnotic or anxiolytic dependence, in remission'),
    ('F13220', 'Sedatv/hyp/anxiolytc dependence w intoxication, uncomp'),
    ('F13221', 'Sedatv/hyp/anxiolytc dependence w intoxication delirium'),
    ('F13229', 'Sedatv/hyp/anxiolytc dependence w intoxication, unsp'),
    ('F13230', 'Sedatv/hyp/anxiolytc dependence w withdrawal, uncomplicated'),
    ('F13231', 'Sedatv/hyp/anxiolytc dependence w withdrawal delirium'),
    ('F13232', 'Sedatv/hyp/anxiolytc depend w w/drawal w perceptual disturb'),
    ('F13239', 'Sedatv/hyp/anxiolytc dependence w withdrawal, unsp'),
    ('F1324', 'Sedative, hypnotic or anxiolytic dependence w mood disorder'),
    ('F13250', 'Sedatv/hyp/anxiolytc depend w psychotic disorder w delusions'),
    ('F13251', 'Sedatv/hyp/anxiolytc depend w psychotic disorder w hallucin'),
    ('F13259', 'Sedatv/hyp/anxiolytc dependence w psychotic disorder, unsp'),
    ('F1326', 'Sedatv/hyp/anxiolytc depend w persisting amnestic disorder'),
    ('F1327', 'Sedatv/hyp/anxiolytc dependence w persisting dementia'),
    ('F13280', 'Sedatv/hyp/anxiolytc dependence w anxiety disorder'),
    ('F13281', 'Sedatv/hyp/anxiolytc dependence w sexual dysfunction'),
    ('F13282', 'Sedative, hypnotic or anxiolytic dependence w sleep disorder'),
    ('F13288', 'Sedative, hypnotic or anxiolytic dependence w oth disorder'),
    ('F1329', 'Sedative, hypnotic or anxiolytic dependence w unsp disorder'),
    ('F1390', 'Sedative, hypnotic, or anxiolytic use, unsp, uncomplicated'),
    ('F1391', 'Sedatv/hyp/anxiolytc use, unspecified, in remission'),
    ('F13920', 'Sedatv/hyp/anxiolytc use, unsp w intoxication, uncomplicated'),
    ('F13921', 'Sedatv/hyp/anxiolytc use, unsp w intoxication delirium'),
    ('F13929', 'Sedatv/hyp/anxiolytc use, unsp w intoxication, unsp'),
    ('F13930', 'Sedatv/hyp/anxiolytc use, unsp w withdrawal, uncomplicated'),
    ('F13931', 'Sedatv/hyp/anxiolytc use, unsp w withdrawal delirium'),
    ('F13932', 'Sedatv/hyp/anxiolytc use, unsp w w/drawal w perceptl disturb'),
    ('F13939', 'Sedatv/hyp/anxiolytc use, unsp w withdrawal, unsp'),
    ('F1394', 'Sedative, hypnotic or anxiolytic use, unsp w mood disorder'),
    ('F13950', 'Sedatv/hyp/anxiolytc use, unsp w psych disorder w delusions'),
    ('F13951', 'Sedatv/hyp/anxiolytc use, unsp w psych disorder w hallucin'),
    ('F13959', 'Sedatv/hyp/anxiolytc use, unsp w psychotic disorder, unsp'),
    ('F1396', 'Sedatv/hyp/anxiolytc use, unsp w persist amnestic disorder'),
    ('F1397', 'Sedatv/hyp/anxiolytc use, unsp w persisting dementia'),
    ('F13980', 'Sedatv/hyp/anxiolytc use, unsp w anxiety disorder'),
    ('F13981', 'Sedatv/hyp/anxiolytc use, unsp w sexual dysfunction'),
    ('F13982', 'Sedative, hypnotic or anxiolytic use, unsp w sleep disorder'),
    ('F13988', 'Sedative, hypnotic or anxiolytic use, unsp w oth disorder'),
    ('F1399', 'Sedative, hypnotic or anxiolytic use, unsp w unsp disorder'),
    ('F1410', 'Cocaine abuse, uncomplicated'),
    ('F1411', 'Cocaine abuse, in remission'),
    ('F14120', 'Cocaine abuse with intoxication, uncomplicated'),
    ('F14121', 'Cocaine abuse with intoxication with delirium'),
    ('F14122', 'Cocaine abuse with intoxication with perceptual disturbance'),
    ('F14129', 'Cocaine abuse with intoxication, unspecified'),
    ('F1413', 'Cocaine abuse, unspecified with withdrawal'),
    ('F1414', 'Cocaine abuse with cocaine-induced mood disorder'),
    ('F14150', 'Cocaine abuse w cocaine-induc psychotic disorder w delusions'),
    ('F14151', 'Cocaine abuse w cocaine-induc psychotic disorder w hallucin'),
    ('F14159', 'Cocaine abuse with cocaine-induced psychotic disorder, unsp'),
    ('F14180', 'Cocaine abuse with cocaine-induced anxiety disorder'),
    ('F14181', 'Cocaine abuse with cocaine-induced sexual dysfunction'),
    ('F14182', 'Cocaine abuse with cocaine-induced sleep disorder'),
    ('F14188', 'Cocaine abuse with other cocaine-induced disorder'),
    ('F1419', 'Cocaine abuse with unspecified cocaine-induced disorder'),
    ('F1420', 'Cocaine dependence, uncomplicated'),
    ('F1421', 'Cocaine dependence, in remission'),
    ('F14220', 'Cocaine dependence with intoxication, uncomplicated'),
    ('F14221', 'Cocaine dependence with intoxication delirium'),
    ('F14222', 'Cocaine dependence w intoxication w perceptual disturbance'),
    ('F14229', 'Cocaine dependence with intoxication, unspecified'),
    ('F1423', 'Cocaine dependence with withdrawal'),
    ('F1424', 'Cocaine dependence with cocaine-induced mood disorder'),
    ('F14250', 'Cocaine depend w cocaine-induc psych disorder w delusions'),
    ('F14251', 'Cocaine depend w cocaine-induc psychotic disorder w hallucin'),
    ('F14259', 'Cocaine dependence w cocaine-induc psychotic disorder, unsp'),
    ('F14280', 'Cocaine dependence with cocaine-induced anxiety disorder'),
    ('F14281', 'Cocaine dependence with cocaine-induced sexual dysfunction'),
    ('F14282', 'Cocaine dependence with cocaine-induced sleep disorder'),
    ('F14288', 'Cocaine dependence with other cocaine-induced disorder'),
    ('F1429', 'Cocaine dependence with unspecified cocaine-induced disorder'),
    ('F1490', 'Cocaine use, unspecified, uncomplicated'),
    ('F1491', 'Cocaine use, unspecified, in remission'),
    ('F14920', 'Cocaine use, unspecified with intoxication, uncomplicated'),
    ('F14921', 'Cocaine use, unspecified with intoxication delirium'),
    ('F14922', 'Cocaine use, unsp w intoxication with perceptual disturbance'),
    ('F14929', 'Cocaine use, unspecified with intoxication, unspecified'),
    ('F1493', 'Cocaine use, unspecified with withdrawal'),
    ('F1494', 'Cocaine use, unspecified with cocaine-induced mood disorder'),
    ('F14950', 'Cocaine use, unsp w cocaine-induc psych disorder w delusions'),
    ('F14951', 'Cocaine use, unsp w cocaine-induc psych disorder w hallucin'),
    ('F14959', 'Cocaine use, unsp w cocaine-induced psychotic disorder, unsp'),
    ('F14980', 'Cocaine use, unsp with cocaine-induced anxiety disorder'),
    ('F14981', 'Cocaine use, unsp with cocaine-induced sexual dysfunction'),
    ('F14982', 'Cocaine use, unspecified with cocaine-induced sleep disorder'),
    ('F14988', 'Cocaine use, unspecified with other cocaine-induced disorder'),
    ('F1499', 'Cocaine use, unsp with unspecified cocaine-induced disorder'),
    ('F1510', 'Other stimulant abuse, uncomplicated'),
    ('F1511', 'Other stimulant abuse, in remission'),
    ('F15120', 'Other stimulant abuse with intoxication, uncomplicated'),
    ('F15121', 'Other stimulant abuse with intoxication delirium'),
    ('F15122', 'Oth stimulant abuse w intoxication w perceptual disturbance'),
    ('F15129', 'Other stimulant abuse with intoxication, unspecified'),
    ('F1513', 'Other stimulant abuse with withdrawal '),
    ('F1514', 'Other stimulant abuse with stimulant-induced mood disorder'),
    ('F15150', 'Oth stimulant abuse w stim-induce psych disorder w delusions'),
    ('F15151', 'Oth stimulant abuse w stim-induce psych disorder w hallucin'),
    ('F15159', 'Oth stimulant abuse w stim-induce psychotic disorder, unsp'),
    ('F15180', 'Oth stimulant abuse with stimulant-induced anxiety disorder'),
    ('F15181', 'Oth stimulant abuse w stimulant-induced sexual dysfunction'),
    ('F15182', 'Other stimulant abuse with stimulant-induced sleep disorder'),
    ('F15188', 'Other stimulant abuse with other stimulant-induced disorder'),
    ('F1519', 'Other stimulant abuse with unsp stimulant-induced disorder'),
    ('F1520', 'Other stimulant dependence, uncomplicated'),
    ('F1521', 'Other stimulant dependence, in remission'),
    ('F15220', 'Other stimulant dependence with intoxication, uncomplicated'),
    ('F15221', 'Other stimulant dependence with intoxication delirium'),
    ('F15222', 'Oth stimulant dependence w intox w perceptual disturbance'),
    ('F15229', 'Other stimulant dependence with intoxication, unspecified'),
    ('F1523', 'Other stimulant dependence with withdrawal'),
    ('F1524', 'Oth stimulant dependence w stimulant-induced mood disorder'),
    ('F15250', 'Oth stim depend w stim-induce psych disorder w delusions'),
    ('F15251', 'Oth stimulant depend w stim-induce psych disorder w hallucin'),
    ('F15259', 'Oth stimulant depend w stim-induce psychotic disorder, unsp'),
    ('F15280', 'Oth stimulant dependence w stim-induce anxiety disorder'),
    ('F15281', 'Oth stimulant dependence w stim-induce sexual dysfunction'),
    ('F15282', 'Oth stimulant dependence w stimulant-induced sleep disorder'),
    ('F15288', 'Oth stimulant dependence with oth stimulant-induced disorder'),
    ('F1529', 'Oth stimulant dependence w unsp stimulant-induced disorder'),
    ('F1590', 'Other stimulant use, unspecified, uncomplicated'),
    ('F1591', 'Other stimulant use, unspecified, in remission'),
    ('F15920', 'Other stimulant use, unsp with intoxication, uncomplicated'),
    ('F15921', 'Other stimulant use, unspecified with intoxication delirium'),
    ('F15922', 'Oth stimulant use, unsp w intox w perceptual disturbance'),
    ('F15929', 'Other stimulant use, unsp with intoxication, unspecified'),
    ('F1593', 'Other stimulant use, unspecified with withdrawal'),
    ('F1594', 'Oth stimulant use, unsp with stimulant-induced mood disorder'),
    ('F15950', 'Oth stim use, unsp w stim-induce psych disorder w delusions'),
    ('F15951', 'Oth stim use, unsp w stim-induce psych disorder w hallucin'),
    ('F15959', 'Oth stimulant use, unsp w stim-induce psych disorder, unsp'),
    ('F15980', 'Oth stimulant use, unsp w stimulant-induced anxiety disorder'),
    ('F15981', 'Oth stimulant use, unsp w stim-induce sexual dysfunction'),
    ('F15982', 'Oth stimulant use, unsp w stimulant-induced sleep disorder'),
    ('F15988', 'Oth stimulant use, unsp with oth stimulant-induced disorder'),
    ('F1599', 'Oth stimulant use, unsp with unsp stimulant-induced disorder'),
    ('F1610', 'Hallucinogen abuse, uncomplicated'),
    ('F1611', 'Hallucinogen abuse, in remission'),
    ('F16120', 'Hallucinogen abuse with intoxication, uncomplicated'),
    ('F16121', 'Hallucinogen abuse with intoxication with delirium'),
    ('F16122', 'Hallucinogen abuse w intoxication w perceptual disturbance'),
    ('F16129', 'Hallucinogen abuse with intoxication, unspecified'),
    ('F1614', 'Hallucinogen abuse with hallucinogen-induced mood disorder'),
    ('F16150', 'Hallucinogen abuse w psychotic disorder w delusions'),
    ('F16151', 'Hallucinogen abuse w psychotic disorder w hallucinations'),
    ('F16159', 'Hallucinogen abuse w psychotic disorder, unsp'),
    ('F16180', 'Hallucinogen abuse w hallucinogen-induced anxiety disorder'),
    ('F16183', 'Hallucign abuse w hallucign persisting perception disorder'),
    ('F16188', 'Hallucinogen abuse with other hallucinogen-induced disorder'),
    ('F1619', 'Hallucinogen abuse with unsp hallucinogen-induced disorder'),
    ('F1620', 'Hallucinogen dependence, uncomplicated'),
    ('F1621', 'Hallucinogen dependence, in remission'),
    ('F16220', 'Hallucinogen dependence with intoxication, uncomplicated'),
    ('F16221', 'Hallucinogen dependence with intoxication with delirium'),
    ('F16229', 'Hallucinogen dependence with intoxication, unspecified'),
    ('F1624', 'Hallucinogen dependence w hallucinogen-induced mood disorder'),
    ('F16250', 'Hallucinogen dependence w psychotic disorder w delusions'),
    ('F16251', 'Hallucinogen dependence w psychotic disorder w hallucin'),
    ('F16259', 'Hallucinogen dependence w psychotic disorder, unsp'),
    ('F16280', 'Hallucinogen dependence w anxiety disorder'),
    ('F16283', 'Hallucign depend w hallucign persisting perception disorder'),
    ('F16288', 'Hallucinogen dependence w oth hallucinogen-induced disorder'),
    ('F1629', 'Hallucinogen dependence w unsp hallucinogen-induced disorder'),
    ('F1690', 'Hallucinogen use, unspecified, uncomplicated'),
    ('F1691', 'Hallucinogen use, unspecified, in remission'),
    ('F16920', 'Hallucinogen use, unsp with intoxication, uncomplicated'),
    ('F16921', 'Hallucinogen use, unsp with intoxication with delirium'),
    ('F16929', 'Hallucinogen use, unspecified with intoxication, unspecified'),
    ('F1694', 'Hallucinogen use, unsp w hallucinogen-induced mood disorder'),
    ('F16950', 'Hallucinogen use, unsp w psychotic disorder w delusions'),
    ('F16951', 'Hallucinogen use, unsp w psychotic disorder w hallucinations'),
    ('F16959', 'Hallucinogen use, unsp w psychotic disorder, unsp'),
    ('F16980', 'Hallucinogen use, unsp w anxiety disorder'),
    ('F16983', 'Hallucign use, unsp w hallucign persist perception disorder'),
    ('F16988', 'Hallucinogen use, unsp w oth hallucinogen-induced disorder'),
    ('F1699', 'Hallucinogen use, unsp w unsp hallucinogen-induced disorder'),
    ('F17200', 'Nicotine dependence, unspecified, uncomplicated'),
    ('F17201', 'Nicotine dependence, unspecified, in remission'),
    ('F17203', 'Nicotine dependence unspecified, with withdrawal'),
    ('F17208', 'Nicotine dependence, unsp, w oth nicotine-induced disorders'),
    ('F17209', 'Nicotine dependence, unsp, w unsp nicotine-induced disorders'),
    ('F17210', 'Nicotine dependence, cigarettes, uncomplicated'),
    ('F17211', 'Nicotine dependence, cigarettes, in remission'),
    ('F17213', 'Nicotine dependence, cigarettes, with withdrawal'),
    ('F17218', 'Nicotine dependence, cigarettes, w oth disorders'),
    ('F17219', 'Nicotine dependence, cigarettes, w unsp disorders'),
    ('F17220', 'Nicotine dependence, chewing tobacco, uncomplicated'),
    ('F17221', 'Nicotine dependence, chewing tobacco, in remission'),
    ('F17223', 'Nicotine dependence, chewing tobacco, with withdrawal'),
    ('F17228', 'Nicotine dependence, chewing tobacco, w oth disorders'),
    ('F17229', 'Nicotine dependence, chewing tobacco, w unsp disorders'),
    ('F17290', 'Nicotine dependence, other tobacco product, uncomplicated'),
    ('F17291', 'Nicotine dependence, other tobacco product, in remission'),
    ('F17293', 'Nicotine dependence, other tobacco product, with withdrawal'),
    ('F17298', 'Nicotine dependence, oth tobacco product, w oth disorders'),
    ('F17299', 'Nicotine dependence, oth tobacco product, w unsp disorders'),
    ('F1810', 'Inhalant abuse, uncomplicated'),
    ('F1811', 'Inhalant abuse, in remission'),
    ('F18120', 'Inhalant abuse with intoxication, uncomplicated'),
    ('F18121', 'Inhalant abuse with intoxication delirium'),
    ('F18129', 'Inhalant abuse with intoxication, unspecified'),
    ('F1814', 'Inhalant abuse with inhalant-induced mood disorder'),
    ('F18150', 'Inhalant abuse w inhalnt-induce psych disorder w delusions'),
    ('F18151', 'Inhalant abuse w inhalnt-induce psych disorder w hallucin'),
    ('F18159', 'Inhalant abuse w inhalant-induced psychotic disorder, unsp'),
    ('F1817', 'Inhalant abuse with inhalant-induced dementia'),
    ('F18180', 'Inhalant abuse with inhalant-induced anxiety disorder'),
    ('F18188', 'Inhalant abuse with other inhalant-induced disorder'),
    ('F1819', 'Inhalant abuse with unspecified inhalant-induced disorder'),
    ('F1820', 'Inhalant dependence, uncomplicated'),
    ('F1821', 'Inhalant dependence, in remission'),
    ('F18220', 'Inhalant dependence with intoxication, uncomplicated'),
    ('F18221', 'Inhalant dependence with intoxication delirium'),
    ('F18229', 'Inhalant dependence with intoxication, unspecified'),
    ('F1824', 'Inhalant dependence with inhalant-induced mood disorder'),
    ('F18250', 'Inhalant depend w inhalnt-induce psych disorder w delusions'),
    ('F18251', 'Inhalant depend w inhalnt-induce psych disorder w hallucin'),
    ('F18259', 'Inhalant depend w inhalnt-induce psychotic disorder, unsp'),
    ('F1827', 'Inhalant dependence with inhalant-induced dementia'),
    ('F18280', 'Inhalant dependence with inhalant-induced anxiety disorder'),
    ('F18288', 'Inhalant dependence with other inhalant-induced disorder'),
    ('F1829', 'Inhalant dependence with unsp inhalant-induced disorder'),
    ('F1890', 'Inhalant use, unspecified, uncomplicated'),
    ('F1891', 'Inhalant use, unspecified, in remission'),
    ('F18920', 'Inhalant use, unspecified with intoxication, uncomplicated'),
    ('F18921', 'Inhalant use, unspecified with intoxication with delirium'),
    ('F18929', 'Inhalant use, unspecified with intoxication, unspecified'),
    ('F1894', 'Inhalant use, unsp with inhalant-induced mood disorder'),
    ('F18950', 'Inhalant use, unsp w inhalnt-induce psych disord w delusions'),
    ('F18951', 'Inhalant use, unsp w inhalnt-induce psych disord w hallucin'),
    ('F18959', 'Inhalant use, unsp w inhalnt-induce psychotic disorder, unsp'),
    ('F1897', 'Inhalant use, unsp with inhalant-induced persisting dementia'),
    ('F18980', 'Inhalant use, unsp with inhalant-induced anxiety disorder'),
    ('F18988', 'Inhalant use, unsp with other inhalant-induced disorder'),
    ('F1899', 'Inhalant use, unsp with unsp inhalant-induced disorder'),
    ('F1910', 'Other psychoactive substance abuse, uncomplicated'),
    ('F1911', 'Other psychoactive substance abuse, in remission'),
    ('F19120', 'Oth psychoactive substance abuse w intoxication, uncomp'),
    ('F19121', 'Oth psychoactive substance abuse with intoxication delirium'),
    ('F19122', 'Oth psychoactv substance abuse w intox w perceptual disturb'),
    ('F19129', 'Other psychoactive substance abuse with intoxication, unsp'),
    ('F19130', 'Other psychoactive substance abuse with withdrawal, uncomp'),
    ('F19131', 'Other psychoactive substance abuse with withdrawal delirium'),
    ('F19132', 'Other psychoactv sub abuse with w/drawal w perceptl disturb'),
    ('F19139', 'Other psychoactv substance abuse with withdrawal, unsp'),
    ('F1914', 'Oth psychoactive substance abuse w mood disorder'),
    ('F19150', 'Oth psychoactv substance abuse w psych disorder w delusions'),
    ('F19151', 'Oth psychoactv substance abuse w psych disorder w hallucin'),
    ('F19159', 'Oth psychoactive substance abuse w psychotic disorder, unsp'),
    ('F1916', 'Oth psychoactv substance abuse w persist amnestic disorder'),
    ('F1917', 'Oth psychoactive substance abuse w persisting dementia'),
    ('F19180', 'Oth psychoactive substance abuse w anxiety disorder'),
    ('F19181', 'Oth psychoactive substance abuse w sexual dysfunction'),
    ('F19182', 'Oth psychoactive substance abuse w sleep disorder'),
    ('F19188', 'Oth psychoactive substance abuse w oth disorder'),
    ('F1919', 'Oth psychoactive substance abuse w unsp disorder'),
    ('F1920', 'Other psychoactive substance dependence, uncomplicated'),
    ('F1921', 'Other psychoactive substance dependence, in remission'),
    ('F19220', 'Oth psychoactive substance dependence w intoxication, uncomp'),
    ('F19221', 'Oth psychoactive substance dependence w intox delirium'),
    ('F19222', 'Oth psychoactv substance depend w intox w perceptual disturb'),
    ('F19229', 'Oth psychoactive substance dependence w intoxication, unsp'),
    ('F19230', 'Oth psychoactive substance dependence w withdrawal, uncomp'),
    ('F19231', 'Oth psychoactive substance dependence w withdrawal delirium'),
    ('F19232', 'Oth psychoactv sub depend w w/drawal w perceptl disturb'),
    ('F19239', 'Oth psychoactive substance dependence with withdrawal, unsp'),
    ('F1924', 'Oth psychoactive substance dependence w mood disorder'),
    ('F19250', 'Oth psychoactv substance depend w psych disorder w delusions'),
    ('F19251', 'Oth psychoactv substance depend w psych disorder w hallucin'),
    ('F19259', 'Oth psychoactv substance depend w psychotic disorder, unsp'),
    ('F1926', 'Oth psychoactv substance depend w persist amnestic disorder'),
    ('F1927', 'Oth psychoactive substance dependence w persisting dementia'),
    ('F19280', 'Oth psychoactive substance dependence w anxiety disorder'),
    ('F19281', 'Oth psychoactive substance dependence w sexual dysfunction'),
    ('F19282', 'Oth psychoactive substance dependence w sleep disorder'),
    ('F19288', 'Oth psychoactive substance dependence w oth disorder'),
    ('F1929', 'Oth psychoactive substance dependence w unsp disorder'),
    ('F1990', 'Other psychoactive substance use, unspecified, uncomplicated'),
    ('F1991', 'Other psychoactive substance use, unspecified, in remission'),
    ('F19920', 'Oth psychoactive substance use, unsp w intoxication, uncomp'),
    ('F19921', 'Oth psychoactive substance use, unsp w intox w delirium'),
    ('F19922', 'Oth psychoactv sub use, unsp w intox w perceptl disturb'),
    ('F19929', 'Oth psychoactive substance use, unsp with intoxication, unsp'),
    ('F19930', 'Oth psychoactive substance use, unsp w withdrawal, uncomp'),
    ('F19931', 'Oth psychoactive substance use, unsp w withdrawal delirium'),
    ('F19932', 'Oth psychoactv sub use, unsp w w/drawal w perceptl disturb'),
    ('F19939', 'Other psychoactive substance use, unsp with withdrawal, unsp'),
    ('F1994', 'Oth psychoactive substance use, unsp w mood disorder'),
    ('F19950', 'Oth psychoactv sub use, unsp w psych disorder w delusions'),
    ('F19951', 'Oth psychoactv sub use, unsp w psych disorder w hallucin'),
    ('F19959', 'Oth psychoactv substance use, unsp w psych disorder, unsp'),
    ('F1996', 'Oth psychoactv sub use, unsp w persist amnestic disorder'),
    ('F1997', 'Oth psychoactive substance use, unsp w persisting dementia'),
    ('F19980', 'Oth psychoactive substance use, unsp w anxiety disorder'),
    ('F19981', 'Oth psychoactive substance use, unsp w sexual dysfunction'),
    ('F19982', 'Oth psychoactive substance use, unsp w sleep disorder'),
    ('F19988', 'Oth psychoactive substance use, unsp w oth disorder'),
    ('F1999', 'Oth psychoactive substance use, unsp w unsp disorder'),
    ('F200', 'Paranoid schizophrenia'),
    ('F201', 'Disorganized schizophrenia'),
    ('F202', 'Catatonic schizophrenia'),
    ('F203', 'Undifferentiated schizophrenia'),
    ('F205', 'Residual schizophrenia'),
    ('F2081', 'Schizophreniform disorder'),
    ('F2089', 'Other schizophrenia'),
    ('F209', 'Schizophrenia, unspecified'),
    ('F21', 'Schizotypal disorder'),
    ('F22', 'Delusional disorders'),
    ('F23', 'Brief psychotic disorder'),
    ('F24', 'Shared psychotic disorder'),
    ('F250', 'Schizoaffective disorder, bipolar type'),
    ('F251', 'Schizoaffective disorder, depressive type'),
    ('F258', 'Other schizoaffective disorders'),
    ('F259', 'Schizoaffective disorder, unspecified'),
    ('F28', 'Oth psych disorder not due to a sub or known physiol cond'),
    ('F29', 'Unsp psychosis not due to a substance or known physiol cond'),
    ('F3010', 'Manic episode without psychotic symptoms, unspecified'),
    ('F3011', 'Manic episode without psychotic symptoms, mild'),
    ('F3012', 'Manic episode without psychotic symptoms, moderate'),
    ('F3013', 'Manic episode, severe, without psychotic symptoms'),
    ('F302', 'Manic episode, severe with psychotic symptoms'),
    ('F303', 'Manic episode in partial remission'),
    ('F304', 'Manic episode in full remission'),
    ('F308', 'Other manic episodes'),
    ('F309', 'Manic episode, unspecified'),
    ('F310', 'Bipolar disorder, current episode hypomanic'),
    ('F3110', 'Bipolar disord, crnt episode manic w/o psych features, unsp'),
    ('F3111', 'Bipolar disord, crnt episode manic w/o psych features, mild'),
    ('F3112', 'Bipolar disord, crnt episode manic w/o psych features, mod'),
    ('F3113', 'Bipolar disord, crnt epsd manic w/o psych features, severe'),
    ('F312', 'Bipolar disord, crnt episode manic severe w psych features'),
    ('F3130', 'Bipolar disord, crnt epsd depress, mild or mod severt, unsp'),
    ('F3131', 'Bipolar disorder, current episode depressed, mild'),
    ('F3132', 'Bipolar disorder, current episode depressed, moderate'),
    ('F314', 'Bipolar disord, crnt epsd depress, sev, w/o psych features'),
    ('F315', 'Bipolar disord, crnt epsd depress, severe, w psych features'),
    ('F3160', 'Bipolar disorder, current episode mixed, unspecified'),
    ('F3161', 'Bipolar disorder, current episode mixed, mild'),
    ('F3162', 'Bipolar disorder, current episode mixed, moderate'),
    ('F3163', 'Bipolar disord, crnt epsd mixed, severe, w/o psych features'),
    ('F3164', 'Bipolar disord, crnt episode mixed, severe, w psych features'),
    ('F3170', 'Bipolar disord, currently in remis, most recent episode unsp'),
    ('F3171', 'Bipolar disord, in partial remis, most recent epsd hypomanic'),
    ('F3172', 'Bipolar disord, in full remis, most recent episode hypomanic'),
    ('F3173', 'Bipolar disord, in partial remis, most recent episode manic'),
    ('F3174', 'Bipolar disorder, in full remis, most recent episode manic'),
    ('F3175', 'Bipolar disord, in partial remis, most recent epsd depress'),
    ('F3176', 'Bipolar disorder, in full remis, most recent episode depress'),
    ('F3177', 'Bipolar disord, in partial remis, most recent episode mixed'),
    ('F3178', 'Bipolar disorder, in full remis, most recent episode mixed'),
    ('F3181', 'Bipolar II disorder'),
    ('F3189', 'Other bipolar disorder'),
    ('F319', 'Bipolar disorder, unspecified'),
    ('F320', 'Major depressive disorder, single episode, mild'),
    ('F321', 'Major depressive disorder, single episode, moderate'),
    ('F322', 'Major depressv disord, single epsd, sev w/o psych features'),
    ('F323', 'Major depressv disord, single epsd, severe w psych features'),
    ('F324', 'Major depressv disorder, single episode, in partial remis'),
    ('F325', 'Major depressive disorder, single episode, in full remission'),
    ('F328', 'Other depressive episodes'),
    ('F3281', 'Premenstrual dysphoric disorder'),
    ('F3289', 'Other specified depressive episodes'),
    ('F329', 'Major depressive disorder, single episode, unspecified'),
    ('F32A', 'Depression, unspecified'),
    ('F330', 'Major depressive disorder, recurrent, mild'),
    ('F331', 'Major depressive disorder, recurrent, moderate'),
    ('F332', 'Major depressv disorder, recurrent severe w/o psych features'),
    ('F333', 'Major depressv disorder, recurrent, severe w psych symptoms'),
    ('F3340', 'Major depressive disorder, recurrent, in remission, unsp'),
    ('F3341', 'Major depressive disorder, recurrent, in partial remission'),
    ('F3342', 'Major depressive disorder, recurrent, in full remission'),
    ('F338', 'Other recurrent depressive disorders'),
    ('F339', 'Major depressive disorder, recurrent, unspecified'),
    ('F340', 'Cyclothymic disorder'),
    ('F341', 'Dysthymic disorder'),
    ('F348', 'Other persistent mood [affective] disorders'),
    ('F3481', 'Disruptive mood dysregulation disorder'),
    ('F3489', 'Other specified persistent mood disorders'),
    ('F349', 'Persistent mood [affective] disorder, unspecified'),
    ('F39', 'Unspecified mood [affective] disorder'),
    ('F4000', 'Agoraphobia, unspecified'),
    ('F4001', 'Agoraphobia with panic disorder'),
    ('F4002', 'Agoraphobia without panic disorder'),
    ('F4010', 'Social phobia, unspecified'),
    ('F4011', 'Social phobia, generalized'),
    ('F40210', 'Arachnophobia'),
    ('F40218', 'Other animal type phobia'),
    ('F40220', 'Fear of thunderstorms'),
    ('F40228', 'Other natural environment type phobia'),
    ('F40230', 'Fear of blood'),
    ('F40231', 'Fear of injections and transfusions'),
    ('F40232', 'Fear of other medical care'),
    ('F40233', 'Fear of injury'),
    ('F40240', 'Claustrophobia'),
    ('F40241', 'Acrophobia'),
    ('F40242', 'Fear of bridges'),
    ('F40243', 'Fear of flying'),
    ('F40248', 'Other situational type phobia'),
    ('F40290', 'Androphobia'),
    ('F40291', 'Gynephobia'),
    ('F40298', 'Other specified phobia'),
    ('F408', 'Other phobic anxiety disorders'),
    ('F409', 'Phobic anxiety disorder, unspecified'),
    ('F410', 'Panic disorder without agoraphobia'),
    ('F411', 'Generalized anxiety disorder'),
    ('F413', 'Other mixed anxiety disorders'),
    ('F418', 'Other specified anxiety disorders'),
    ('F419', 'Anxiety disorder, unspecified'),
    ('F42', 'Obsessive-compulsive disorder'),
    ('F422', 'Mixed obsessional thoughts and acts'),
    ('F423', 'Hoarding disorder'),
    ('F424', 'Excoriation (skin-picking) disorder'),
    ('F428', 'Other obsessive-compulsive disorder'),
    ('F429', 'Obsessive-compulsive disorder, unspecified'),
    ('F430', 'Acute stress reaction'),
    ('F4310', 'Post-traumatic stress disorder, unspecified'),
    ('F4311', 'Post-traumatic stress disorder, acute'),
    ('F4312', 'Post-traumatic stress disorder, chronic'),
    ('F4320', 'Adjustment disorder, unspecified'),
    ('F4321', 'Adjustment disorder with depressed mood'),
    ('F4322', 'Adjustment disorder with anxiety'),
    ('F4323', 'Adjustment disorder with mixed anxiety and depressed mood'),
    ('F4324', 'Adjustment disorder with disturbance of conduct'),
    ('F4325', 'Adjustment disorder w mixed disturb of emotions and conduct'),
    ('F4329', 'Adjustment disorder with other symptoms'),
    ('F438', 'Other reactions to severe stress'),
    ('F4381', 'Prolonged grief disorder'),
    ('F4389', 'Other reactions to severe stress'),
    ('F439', 'Reaction to severe stress, unspecified'),
    ('F440', 'Dissociative amnesia'),
    ('F441', 'Dissociative fugue'),
    ('F442', 'Dissociative stupor'),
    ('F444', 'Conversion disorder with motor symptom or deficit'),
    ('F445', 'Conversion disorder with seizures or convulsions'),
    ('F446', 'Conversion disorder with sensory symptom or deficit'),
    ('F447', 'Conversion disorder with mixed symptom presentation'),
    ('F4481', 'Dissociative identity disorder'),
    ('F4489', 'Other dissociative and conversion disorders'),
    ('F449', 'Dissociative and conversion disorder, unspecified'),
    ('F450', 'Somatization disorder'),
    ('F451', 'Undifferentiated somatoform disorder'),
    ('F4520', 'Hypochondriacal disorder, unspecified'),
    ('F4521', 'Hypochondriasis'),
    ('F4522', 'Body dysmorphic disorder'),
    ('F4529', 'Other hypochondriacal disorders'),
    ('F4541', 'Pain disorder exclusively related to psychological factors'),
    ('F4542', 'Pain disorder with related psychological factors'),
    ('F458', 'Other somatoform disorders'),
    ('F459', 'Somatoform disorder, unspecified'),
    ('F481', 'Depersonalization-derealization syndrome'),
    ('F482', 'Pseudobulbar affect'),
    ('F488', 'Other specified nonpsychotic mental disorders'),
    ('F489', 'Nonpsychotic mental disorder, unspecified'),
    ('F5000', 'Anorexia nervosa, unspecified'),
    ('F5001', 'Anorexia nervosa, restricting type'),
    ('F5002', 'Anorexia nervosa, binge eating/purging type'),
    ('F502', 'Bulimia nervosa'),
    ('F508', 'Other eating disorders'),
    ('F5081', 'Binge eating disorder'),
    ('F5082', 'Avoidant/restrictive food intake disorder'),
    ('F5089', 'Other specified eating disorder'),
    ('F509', 'Eating disorder, unspecified'),
    ('F5101', 'Primary insomnia'),
    ('F5102', 'Adjustment insomnia'),
    ('F5103', 'Paradoxical insomnia'),
    ('F5104', 'Psychophysiologic insomnia'),
    ('F5105', 'Insomnia due to other mental disorder'),
    ('F5109', 'Oth insomnia not due to a substance or known physiol cond'),
    ('F5111', 'Primary hypersomnia'),
    ('F5112', 'Insufficient sleep syndrome'),
    ('F5113', 'Hypersomnia due to other mental disorder'),
    ('F5119', 'Oth hypersomnia not due to a substance or known physiol cond'),
    ('F513', 'Sleepwalking [somnambulism]'),
    ('F514', 'Sleep terrors [night terrors]'),
    ('F515', 'Nightmare disorder'),
    ('F518', 'Oth sleep disord not due to a sub or known physiol cond'),
    ('F519', 'Sleep disorder not due to a sub or known physiol cond, unsp'),
    ('F520', 'Hypoactive sexual desire disorder'),
    ('F521', 'Sexual aversion disorder'),
    ('F5221', 'Male erectile disorder'),
    ('F5222', 'Female sexual arousal disorder'),
    ('F5231', 'Female orgasmic disorder'),
    ('F5232', 'Male orgasmic disorder'),
    ('F524', 'Premature ejaculation'),
    ('F525', 'Vaginismus not due to a substance or known physiol condition'),
    ('F526', 'Dyspareunia not due to a substance or known physiol cond'),
    ('F528', 'Oth sexual dysfnct not due to a sub or known physiol cond'),
    ('F529', 'Unsp sexual dysfnct not due to a sub or known physiol cond'),
    ('F53', 'Puerperal psychosis'),
    ('F530', 'Postpartum depression'),
    ('F531', 'Puerperal psychosis'),
    ('F54', 'Psych & behavrl factors assoc w disord or dis classd elswhr'),
    ('F550', 'Abuse of antacids'),
    ('F551', 'Abuse of herbal or folk remedies'),
    ('F552', 'Abuse of laxatives'),
    ('F553', 'Abuse of steroids or hormones'),
    ('F554', 'Abuse of vitamins'),
    ('F558', 'Abuse of other non-psychoactive substances'),
    ('F59', 'Unsp behavrl synd assoc w physiol disturb and physcl factors'),
    ('F600', 'Paranoid personality disorder'),
    ('F601', 'Schizoid personality disorder'),
    ('F602', 'Antisocial personality disorder'),
    ('F603', 'Borderline personality disorder'),
    ('F604', 'Histrionic personality disorder'),
    ('F605', 'Obsessive-compulsive personality disorder'),
    ('F606', 'Avoidant personality disorder'),
    ('F607', 'Dependent personality disorder'),
    ('F6081', 'Narcissistic personality disorder'),
    ('F6089', 'Other specific personality disorders'),
    ('F609', 'Personality disorder, unspecified'),
    ('F630', 'Pathological gambling'),
    ('F631', 'Pyromania'),
    ('F632', 'Kleptomania'),
    ('F633', 'Trichotillomania'),
    ('F6381', 'Intermittent explosive disorder'),
    ('F6389', 'Other impulse disorders'),
    ('F639', 'Impulse disorder, unspecified'),
    ('F640', 'Transsexualism'),
    ('F641', 'Dual role transvestism'),
    ('F642', 'Gender identity disorder of childhood'),
    ('F648', 'Other gender identity disorders'),
    ('F649', 'Gender identity disorder, unspecified'),
    ('F650', 'Fetishism'),
    ('F651', 'Transvestic fetishism'),
    ('F652', 'Exhibitionism'),
    ('F653', 'Voyeurism'),
    ('F654', 'Pedophilia'),
    ('F6550', 'Sadomasochism, unspecified'),
    ('F6551', 'Sexual masochism'),
    ('F6552', 'Sexual sadism'),
    ('F6581', 'Frotteurism'),
    ('F6589', 'Other paraphilias'),
    ('F659', 'Paraphilia, unspecified'),
    ('F66', 'Other sexual disorders'),
    ('F6810', 'Factitious disorder imposed on self, unspecified'),
    ('F6811', 'Factitious disorder w predom psych signs and symptoms'),
    ('F6812', 'Factit disord impsd on self, with predom physcl signs/symp'),
    ('F6813', 'Factit disord impsd on self, w comb psych & physcl signs/symp'),
    ('F688', 'Other specified disorders of adult personality and behavior'),
    ('F68A', 'Factitious disorder imposed on another'),
    ('F69', 'Unspecified disorder of adult personality and behavior'),
    ('F70', 'Mild intellectual disabilities'),
    ('F71', 'Moderate intellectual disabilities'),
    ('F72', 'Severe intellectual disabilities'),
    ('F73', 'Profound intellectual disabilities'),
    ('F78', 'Other intellectual disabilities'),
    ('F78A1', 'SYNGAP1-related intellectual disability'),
    ('F78A9', 'Other genetic related intellectual disability'),
    ('F79', 'Unspecified intellectual disabilities'),
    ('F800', 'Phonological disorder'),
    ('F801', 'Expressive language disorder'),
    ('F802', 'Mixed receptive-expressive language disorder'),
    ('F804', 'Speech and language development delay due to hearing loss'),
    ('F8081', 'Childhood onset fluency disorder'),
    ('F8082', 'Social pragmatic communication disorder'),
    ('F8089', 'Other developmental disorders of speech and language'),
    ('F809', 'Developmental disorder of speech and language, unspecified'),
    ('F810', 'Specific reading disorder'),
    ('F812', 'Mathematics disorder'),
    ('F8181', 'Disorder of written expression'),
    ('F8189', 'Other developmental disorders of scholastic skills'),
    ('F819', 'Developmental disorder of scholastic skills, unspecified'),
    ('F82', 'Specific developmental disorder of motor function'),
    ('F840', 'Autistic disorder'),
    ('F842', "Rett's syndrome"),
    ('F843', 'Other childhood disintegrative disorder'),
    ('F845', "Asperger's syndrome"),
    ('F848', 'Other pervasive developmental disorders'),
    ('F849', 'Pervasive developmental disorder, unspecified'),
    ('F88', 'Other disorders of psychological development'),
    ('F89', 'Unspecified disorder of psychological development'),
    ('F900', 'Attn-defct hyperactivity disorder, predom inattentive type'),
    ('F901', 'Attn-defct hyperactivity disorder, predom hyperactive type'),
    ('F902', 'Attention-deficit hyperactivity disorder, combined type'),
    ('F908', 'Attention-deficit hyperactivity disorder, other type'),
    ('F909', 'Attention-deficit hyperactivity disorder, unspecified type'),
    ('F910', 'Conduct disorder confined to family context'),
    ('F911', 'Conduct disorder, childhood-onset type'),
    ('F912', 'Conduct disorder, adolescent-onset type'),
    ('F913', 'Oppositional defiant disorder'),
    ('F918', 'Other conduct disorders'),
    ('F919', 'Conduct disorder, unspecified'),
    ('F930', 'Separation anxiety disorder of childhood'),
    ('F938', 'Other childhood emotional disorders'),
    ('F939', 'Childhood emotional disorder, unspecified'),
    ('F940', 'Selective mutism'),
    ('F941', 'Reactive attachment disorder of childhood'),
    ('F942', 'Disinhibited attachment disorder of childhood'),
    ('F948', 'Other childhood disorders of social functioning'),
    ('F949', 'Childhood disorder of social functioning, unspecified'),
    ('F950', 'Transient tic disorder'),
    ('F951', 'Chronic motor or vocal tic disorder'),
    ('F952', "Tourette's disorder"),
    ('F958', 'Other tic disorders'),
    ('F959', 'Tic disorder, unspecified'),
    ('F980', 'Enuresis not due to a substance or known physiol condition'),
    ('F981', 'Encopresis not due to a substance or known physiol condition'),
    ('F9821', 'Rumination disorder of infancy'),
    ('F9829', 'Other feeding disorders of infancy and early childhood'),
    ('F983', 'Pica of infancy and childhood'),
    ('F984', 'Stereotyped movement disorders'),
    ('F985', 'Adult onset fluency disorder'),
    ('F988', 'Oth behav/emotn disord w onset usly occur in chldhd and adol'),
    ('F989', 'Unsp behav/emotn disord w onst usly occur in chldhd and adol'),
    ('F99', 'Mental disorder, not otherwise specified'),
    ('G000', 'Hemophilus meningitis'),
    ('G001', 'Pneumococcal meningitis'),
    ('G002', 'Streptococcal meningitis'),
    ('G003', 'Staphylococcal meningitis'),
    ('G008', 'Other bacterial meningitis'),
    ('G009', 'Bacterial meningitis, unspecified'),
    ('G01', 'Meningitis in bacterial diseases classified elsewhere'),
    ('G02', 'Meningitis in oth infec/parastc diseases classd elswhr'),
    ('G030', 'Nonpyogenic meningitis'),
    ('G031', 'Chronic meningitis'),
    ('G032', 'Benign recurrent meningitis [Mollaret]'),
    ('G038', 'Meningitis due to other specified causes'),
    ('G039', 'Meningitis, unspecified'),
    ('G0400', 'Acute disseminated encephalitis and encephalomyelitis, unsp'),
    ('G0401', 'Postinfect acute dissem encephalitis and encephalomyelitis'),
    ('G0402', 'Postimmun ac dissem encphlts, myelitis and encephalomyelitis'),
    ('G041', 'Tropical spastic paraplegia'),
    ('G042', 'Bacterial meningoencephalitis and meningomyelitis, NEC'),
    ('G0430', 'Acute necrotizing hemorrhagic encephalopathy, unspecified'),
    ('G0431', 'Postinfectious acute necrotizing hemorrhagic encephalopathy'),
    ('G0432', 'Postimmun acute necrotizing hemorrhagic encephalopathy'),
    ('G0439', 'Other acute necrotizing hemorrhagic encephalopathy'),
    ('G0481', 'Other encephalitis and encephalomyelitis'),
    ('G0482', 'Acute flaccid myelitis'),
    ('G0489', 'Other myelitis'),
    ('G0490', 'Encephalitis and encephalomyelitis, unspecified'),
    ('G0491', 'Myelitis, unspecified'),
    ('G053', 'Encephalitis and encephalomyelitis in diseases classd elswhr'),
    ('G054', 'Myelitis in diseases classified elsewhere'),
    ('G060', 'Intracranial abscess and granuloma'),
    ('G061', 'Intraspinal abscess and granuloma'),
    ('G062', 'Extradural and subdural abscess, unspecified'),
    ('G07', 'Intcrn & intraspinal abscs & granuloma in dis classd elswhr'),
    ('G08', 'Intracranial and intraspinal phlebitis and thrombophlebitis'),
    ('G09', 'Sequelae of inflammatory diseases of central nervous system'),
    ('G10', "Huntington's disease"),
    ('G110', 'Congenital nonprogressive ataxia'),
    ('G111', 'Early-onset cerebellar ataxia'),
    ('G1110', 'Early-onset cerebellar ataxia, unspecified'),
    ('G1111', 'Friedreich ataxia'),
    ('G1119', 'Other early-onset cerebellar ataxia '),
    ('G112', 'Late-onset cerebellar ataxia'),
    ('G113', 'Cerebellar ataxia with defective DNA repair'),
    ('G114', 'Hereditary spastic paraplegia'),
    ('G115', 'Hypomyelination - hypogonadotropic hypogonadism - hypodontia'),
    ('G116', 'Leukodystrophy with vanishing white matter disease'),
    ('G118', 'Other hereditary ataxias'),
    ('G119', 'Hereditary ataxia, unspecified'),
    ('G120', 'Infantile spinal muscular atrophy, type I [Werdnig-Hoffman]'),
    ('G121', 'Other inherited spinal muscular atrophy'),
    ('G1220', 'Motor neuron disease, unspecified'),
    ('G1221', 'Amyotrophic lateral sclerosis'),
    ('G1222', 'Progressive bulbar palsy'),
    ('G1223', 'Primary lateral sclerosis'),
    ('G1224', 'Familial motor neuron disease'),
    ('G1225', 'Progressive spinal muscle atrophy'),
    ('G1229', 'Other motor neuron disease'),
    ('G128', 'Other spinal muscular atrophies and related syndromes'),
    ('G129', 'Spinal muscular atrophy, unspecified'),
    ('G130', 'Paraneoplastic neuromyopathy and neuropathy'),
    ('G131', 'Oth systemic atrophy aff cnsl in neoplastic disease'),
    ('G132', 'Systemic atrophy primarily affecting the cnsl in myxedema'),
    ('G138', 'Systemic atrophy aff cnsl in oth diseases classd elswhr'),
    ('G14', 'Postpolio syndrome'),
    ('G20', "Parkinson's disease"),
    ('G20A1', "Parkinson's dis w/o dyskinesia, w/o mention of fluctuations"),
    ('G20A2', "Parkinson's disease without dyskinesia, with fluctuations"),
    ('G20B1', "Parkinson's dis with dyskinesia, w/o mention of fluctuations"),
    ('G20B2', "Parkinson's disease with dyskinesia, with fluctuations"),
    ('G20C', 'Parkinsonism, unspecified'),
    ('G210', 'Malignant neuroleptic syndrome'),
    ('G2111', 'Neuroleptic induced parkinsonism'),
    ('G2119', 'Other drug induced secondary parkinsonism'),
    ('G212', 'Secondary parkinsonism due to other external agents'),
    ('G213', 'Postencephalitic parkinsonism'),
    ('G214', 'Vascular parkinsonism'),
    ('G218', 'Other secondary parkinsonism'),
    ('G219', 'Secondary parkinsonism, unspecified'),
    ('G230', 'Hallervorden-Spatz disease'),
    ('G231', 'Progressive supranuclear ophthalmoplegia'),
    ('G232', 'Striatonigral degeneration'),
    ('G233', 'Hypomyelination with atrophy of basal ganglia and cerebellum'),
    ('G238', 'Other specified degenerative diseases of basal ganglia'),
    ('G239', 'Degenerative disease of basal ganglia, unspecified'),
    ('G2401', 'Drug induced subacute dyskinesia'),
    ('G2402', 'Drug induced acute dystonia'),
    ('G2409', 'Other drug induced dystonia'),
    ('G241', 'Genetic torsion dystonia'),
    ('G242', 'Idiopathic nonfamilial dystonia'),
    ('G243', 'Spasmodic torticollis'),
    ('G244', 'Idiopathic orofacial dystonia'),
    ('G245', 'Blepharospasm'),
    ('G248', 'Other dystonia'),
    ('G249', 'Dystonia, unspecified'),
    ('G250', 'Essential tremor'),
    ('G251', 'Drug-induced tremor'),
    ('G252', 'Other specified forms of tremor'),
    ('G253', 'Myoclonus'),
    ('G254', 'Drug-induced chorea'),
    ('G255', 'Other chorea'),
    ('G2561', 'Drug induced tics'),
    ('G2569', 'Other tics of organic origin'),
    ('G2570', 'Drug induced movement disorder, unspecified'),
    ('G2571', 'Drug induced akathisia'),
    ('G2579', 'Other drug induced movement disorders'),
    ('G2581', 'Restless legs syndrome'),
    ('G2582', 'Stiff-man syndrome'),
    ('G2583', 'Benign shuddering attacks'),
    ('G2589', 'Other specified extrapyramidal and movement disorders'),
    ('G259', 'Extrapyramidal and movement disorder, unspecified'),
    ('G26', 'Extrapyramidal and movement disord in diseases classd elswhr'),
    ('G300', "Alzheimer's disease with early onset"),
    ('G301', "Alzheimer's disease with late onset"),
    ('G308', "Other Alzheimer's disease"),
    ('G309', "Alzheimer's disease, unspecified"),
    ('G3101', "Pick's disease"),
    ('G3109', 'Other frontotemporal neurocognitive disorder'),
    ('G311', 'Senile degeneration of brain, not elsewhere classified'),
    ('G312', 'Degeneration of nervous system due to alcohol'),
    ('G3180', 'Leukodystrophy, unspecified'),
    ('G3181', 'Alpers disease'),
    ('G3182', "Leigh's disease"),
    ('G3183', 'Neurocognitive disorder with Lewy bodies'),
    ('G3184', 'Mild cognitive impairment of uncertain or unknown etiology'),
    ('G3185', 'Corticobasal degeneration'),
    ('G3186', 'Alexander disease'),
    ('G3189', 'Other specified degenerative diseases of nervous system'),
    ('G319', 'Degenerative disease of nervous system, unspecified'),
    ('G320', 'Subac comb degeneration of spinal cord in dis classd elswhr'),
    ('G3281', 'Cerebellar ataxia in diseases classified elsewhere'),
    ('G3289', 'Oth degeneratv disord of nervous sys in dis classd elswhr'),
    ('G35', 'Multiple sclerosis'),
    ('G360', 'Neuromyelitis optica [Devic]'),
    ('G361', 'Acute and subacute hemorrhagic leukoencephalitis [Hurst]'),
    ('G368', 'Other specified acute disseminated demyelination'),
    ('G369', 'Acute disseminated demyelination, unspecified'),
    ('G370', 'Diffuse sclerosis of central nervous system'),
    ('G371', 'Central demyelination of corpus callosum'),
    ('G372', 'Central pontine myelinolysis'),
    ('G373', 'Acute transverse myelitis in demyelinating disease of cnsl'),
    ('G374', 'Subacute necrotizing myelitis of central nervous system'),
    ('G375', 'Concentric sclerosis [Balo] of central nervous system'),
    ('G378', 'Oth demyelinating diseases of central nervous system'),
    ('G3781', 'Myelin oligodendrocyte glycoprotein antibody disease'),
    ('G3789', 'Other specified demyelinating diseases of cnsl'),
    ('G379', 'Demyelinating disease of central nervous system, unspecified'),
    ('G40001', 'Local-rel idio epi w seiz of loc onst, not ntrct, w stat epi'),
    ('G40009', 'Local-rel idio epi w seiz of loc onst,not ntrct,w/o stat epi'),
    ('G40011', 'Local-rel idio epi w seiz of loc onset, ntrct, w stat epi'),
    ('G40019', 'Local-rel idio epi w seiz of loc onset, ntrct, w/o stat epi'),
    ('G40101', 'Local-rel symptc epi w simp part seiz, not ntrct, w stat epi'),
    ('G40109', 'Local-rel symptc epi w simp prt seiz,not ntrct, w/o stat epi'),
    ('G40111', 'Local-rel symptc epi w simple part seiz, ntrct, w stat epi'),
    ('G40119', 'Local-rel symptc epi w simple part seiz, ntrct, w/o stat epi'),
    ('G40201', 'Local-rel symptc epi w cmplx prt seiz, not ntrct, w stat epi'),
    ('G40209', 'Local-rel symptc epi w cmplx prt seiz,not ntrct,w/o stat epi'),
    ('G40211', 'Local-rel symptc epi w cmplx partial seiz, ntrct, w stat epi'),
    ('G40219', 'Local-rel symptc epi w cmplx part seiz, ntrct, w/o stat epi'),
    ('G40301', 'Gen idiopathic epilepsy, not intractable, w stat epi'),
    ('G40309', 'Gen idiopathic epilepsy, not intractable, w/o stat epi'),
    ('G40311', 'Generalized idiopathic epilepsy, intractable, w stat epi'),
    ('G40319', 'Generalized idiopathic epilepsy, intractable, w/o stat epi'),
    ('G40401', 'Oth generalized epilepsy, not intractable, w stat epi'),
    ('G40409', 'Oth generalized epilepsy, not intractable, w/o stat epi'),
    ('G40411', 'Oth generalized epilepsy, intractable, w status epilepticus'),
    ('G40419', 'Oth generalized epilepsy, intractable, w/o stat epi'),
    ('G4042 ', 'Cyclin-Dependent Kinase-Like 5 Deficiency Disorder'),
    ('G40501', 'Epileptic seiz rel to extrn causes, not ntrct, w stat epi'),
    ('G40509', 'Epileptic seiz rel to extrn causes, not ntrct, w/o stat epi'),
    ('G40801', 'Other epilepsy, not intractable, with status epilepticus'),
    ('G40802', 'Other epilepsy, not intractable, without status epilepticus'),
    ('G40803', 'Other epilepsy, intractable, with status epilepticus'),
    ('G40804', 'Other epilepsy, intractable, without status epilepticus'),
    ('G40811', 'Lennox-Gastaut syndrome, not intractable, w stat epi'),
    ('G40812', 'Lennox-Gastaut syndrome, not intractable, w/o stat epi'),
    ('G40813', 'Lennox-Gastaut syndrome, intractable, w status epilepticus'),
    ('G40814', 'Lennox-Gastaut syndrome, intractable, w/o status epilepticus'),
    ('G40821', 'Epileptic spasms, not intractable, with status epilepticus'),
    ('G40822', 'Epileptic spasms, not intractable, w/o status epilepticus'),
    ('G40823', 'Epileptic spasms, intractable, with status epilepticus'),
    ('G40824', 'Epileptic spasms, intractable, without status epilepticus'),
    ('G40833', 'Dravet syndrome, intractable, with status epilepticus'),
    ('G40834', 'Dravet syndrome, intractable, without status epilepticus'),
    ('G4089', 'Other seizures'),
    ('G40901', 'Epilepsy, unsp, not intractable, with status epilepticus'),
    ('G40909', 'Epilepsy, unsp, not intractable, without status epilepticus'),
    ('G40911', 'Epilepsy, unspecified, intractable, with status epilepticus'),
    ('G40919', 'Epilepsy, unsp, intractable, without status epilepticus'),
    ('G40A01', 'Absence epileptic syndrome, not intractable, w stat epi'),
    ('G40A09', 'Absence epileptic syndrome, not intractable, w/o stat epi'),
    ('G40A11', 'Absence epileptic syndrome, intractable, w stat epi'),
    ('G40A19', 'Absence epileptic syndrome, intractable, w/o stat epi'),
    ('G40B01', 'Juvenile myoclonic epilepsy, not intractable, w stat epi'),
    ('G40B09', 'Juvenile myoclonic epilepsy, not intractable, w/o stat epi'),
    ('G40B11', 'Juvenile myoclonic epilepsy, intractable, w stat epi'),
    ('G40B19', 'Juvenile myoclonic epilepsy, intractable, w/o stat epi'),
    ('G40C01', 'Lafora progr myoclonus epilepsy, not ntrct, with stat epi'),
    ('G40C09', 'Lafora progr myoclonus epilepsy, not ntrct, without stat epi'),
    ('G40C11', 'Lafora progressive myoclonus epilepsy, ntrct, with stat epi'),
    ('G40C19', 'Lafora progr myoclonus epilepsy, ntrct, without stat epi'),
    ('G43001', 'Migraine w/o aura, not intractable, with status migrainosus'),
    ('G43009', 'Migraine w/o aura, not intractable, w/o status migrainosus'),
    ('G43011', 'Migraine without aura, intractable, with status migrainosus'),
    ('G43019', 'Migraine w/o aura, intractable, without status migrainosus'),
    ('G43101', 'Migraine with aura, not intractable, with status migrainosus'),
    ('G43109', 'Migraine with aura, not intractable, w/o status migrainosus'),
    ('G43111', 'Migraine with aura, intractable, with status migrainosus'),
    ('G43119', 'Migraine with aura, intractable, without status migrainosus'),
    ('G43401', 'Hemiplegic migraine, not intractable, w status migrainosus'),
    ('G43409', 'Hemiplegic migraine, not intractable, w/o status migrainosus'),
    ('G43411', 'Hemiplegic migraine, intractable, with status migrainosus'),
    ('G43419', 'Hemiplegic migraine, intractable, without status migrainosus'),
    ('G43501', 'Perst migraine aura w/o cereb infrc, not ntrct, w stat migr'),
    ('G43509', 'Perst migrn aura w/o cereb infrc, not ntrct, w/o stat migr'),
    ('G43511', 'Perst migraine aura w/o cerebral infrc, ntrct, w stat migr'),
    ('G43519', 'Perst migraine aura w/o cerebral infrc, ntrct, w/o stat migr'),
    ('G43601', 'Perst migraine aura w cerebral infrc, not ntrct, w stat migr'),
    ('G43609', 'Perst migraine aura w cereb infrc, not ntrct, w/o stat migr'),
    ('G43611', 'Perst migraine aura w cerebral infrc, ntrct, w stat migr'),
    ('G43619', 'Perst migraine aura w cerebral infrc, ntrct, w/o stat migr'),
    ('G43701', 'Chronic migraine w/o aura, not intractable, w stat migr'),
    ('G43709', 'Chronic migraine w/o aura, not intractable, w/o stat migr'),
    ('G43711', 'Chronic migraine w/o aura, intractable, w status migrainosus'),
    ('G43719', 'Chronic migraine w/o aura, intractable, w/o stat migr'),
    ('G43801', 'Other migraine, not intractable, with status migrainosus'),
    ('G43809', 'Other migraine, not intractable, without status migrainosus'),
    ('G43811', 'Other migraine, intractable, with status migrainosus'),
    ('G43819', 'Other migraine, intractable, without status migrainosus'),
    ('G43821', 'Menstrual migraine, not intractable, with status migrainosus'),
    ('G43829', 'Menstrual migraine, not intractable, w/o status migrainosus'),
    ('G43831', 'Menstrual migraine, intractable, with status migrainosus'),
    ('G43839', 'Menstrual migraine, intractable, without status migrainosus'),
    ('G43901', 'Migraine, unsp, not intractable, with status migrainosus'),
    ('G43909', 'Migraine, unsp, not intractable, without status migrainosus'),
    ('G43911', 'Migraine, unspecified, intractable, with status migrainosus'),
    ('G43919', 'Migraine, unsp, intractable, without status migrainosus'),
    ('G43A0', 'Cyclical vomiting, in migraine, not intractable'),
    ('G43A1', 'Cyclical vomiting, in migraine, intractable'),
    ('G43B0', 'Ophthalmoplegic migraine, not intractable'),
    ('G43B1', 'Ophthalmoplegic migraine, intractable'),
    ('G43C0', 'Periodic headache syndromes in chld/adlt, not intractable'),
    ('G43C1', 'Periodic headache syndromes in child or adult, intractable'),
    ('G43D0', 'Abdominal migraine, not intractable'),
    ('G43D1', 'Abdominal migraine, intractable'),
    ('G43E01', 'Chronic migraine with aura, not intractable, with stat migr'),
    ('G43E09', 'Chronic migraine with aura, not ntrct, without stat migr'),
    ('G43E11', 'Chronic migraine with aura, intractable, with stat migr'),
    ('G43E19', 'Chronic migraine with aura, intractable, without stat migr'),
    ('G44001', 'Cluster headache syndrome, unspecified, intractable'),
    ('G44009', 'Cluster headache syndrome, unspecified, not intractable'),
    ('G44011', 'Episodic cluster headache, intractable'),
    ('G44019', 'Episodic cluster headache, not intractable'),
    ('G44021', 'Chronic cluster headache, intractable'),
    ('G44029', 'Chronic cluster headache, not intractable'),
    ('G44031', 'Episodic paroxysmal hemicrania, intractable'),
    ('G44039', 'Episodic paroxysmal hemicrania, not intractable'),
    ('G44041', 'Chronic paroxysmal hemicrania, intractable'),
    ('G44049', 'Chronic paroxysmal hemicrania, not intractable'),
    ('G44051', 'Shrt lst unil nerlgif hdache w cnjnct inject/tear, ntrct'),
    ('G44059', 'Shrt lst unil nerlgif hdache w cnjnct inject/tear, not ntrct'),
    ('G44091', 'Other trigeminal autonomic cephalgias (TAC), intractable'),
    ('G44099', 'Other trigeminal autonomic cephalgias (TAC), not intractable'),
    ('G441', 'Vascular headache, not elsewhere classified'),
    ('G44201', 'Tension-type headache, unspecified, intractable'),
    ('G44209', 'Tension-type headache, unspecified, not intractable'),
    ('G44211', 'Episodic tension-type headache, intractable'),
    ('G44219', 'Episodic tension-type headache, not intractable'),
    ('G44221', 'Chronic tension-type headache, intractable'),
    ('G44229', 'Chronic tension-type headache, not intractable'),
    ('G44301', 'Post-traumatic headache, unspecified, intractable'),
    ('G44309', 'Post-traumatic headache, unspecified, not intractable'),
    ('G44311', 'Acute post-traumatic headache, intractable'),
    ('G44319', 'Acute post-traumatic headache, not intractable'),
    ('G44321', 'Chronic post-traumatic headache, intractable'),
    ('G44329', 'Chronic post-traumatic headache, not intractable'),
    ('G4440', 'Drug-induced headache, NEC, not intractable'),
    ('G4441', 'Drug-induced headache, not elsewhere classified, intractable'),
    ('G4451', 'Hemicrania continua'),
    ('G4452', 'New daily persistent headache (NDPH)'),
    ('G4453', 'Primary thunderclap headache'),
    ('G4459', 'Other complicated headache syndrome'),
    ('G4481', 'Hypnic headache'),
    ('G4482', 'Headache associated with sexual activity'),
    ('G4483', 'Primary cough headache'),
    ('G4484', 'Primary exertional headache'),
    ('G4485', 'Primary stabbing headache'),
    ('G4486', 'Cervicogenic headache '),
    ('G4489', 'Other headache syndrome'),
    ('G450', 'Vertebro-basilar artery syndrome'),
    ('G451', 'Carotid artery syndrome (hemispheric)'),
    ('G452', 'Multiple and bilateral precerebral artery syndromes'),
    ('G453', 'Amaurosis fugax'),
    ('G454', 'Transient global amnesia'),
    ('G458', 'Oth transient cerebral ischemic attacks and related synd'),
    ('G459', 'Transient cerebral ischemic attack, unspecified'),
    ('G460', 'Middle cerebral artery syndrome'),
    ('G461', 'Anterior cerebral artery syndrome'),
    ('G462', 'Posterior cerebral artery syndrome'),
    ('G463', 'Brain stem stroke syndrome'),
    ('G464', 'Cerebellar stroke syndrome'),
    ('G465', 'Pure motor lacunar syndrome'),
    ('G466', 'Pure sensory lacunar syndrome'),
    ('G467', 'Other lacunar syndromes'),
    ('G468', 'Oth vascular syndromes of brain in cerebrovascular diseases'),
    ('G4700', 'Insomnia, unspecified'),
    ('G4701', 'Insomnia due to medical condition'),
    ('G4709', 'Other insomnia'),
    ('G4710', 'Hypersomnia, unspecified'),
    ('G4711', 'Idiopathic hypersomnia with long sleep time'),
    ('G4712', 'Idiopathic hypersomnia without long sleep time'),
    ('G4713', 'Recurrent hypersomnia'),
    ('G4714', 'Hypersomnia due to medical condition'),
    ('G4719', 'Other hypersomnia'),
    ('G4720', 'Circadian rhythm sleep disorder, unspecified type'),
    ('G4721', 'Circadian rhythm sleep disorder, delayed sleep phase type'),
    ('G4722', 'Circadian rhythm sleep disorder, advanced sleep phase type'),
    ('G4723', 'Circadian rhythm sleep disorder, irregular sleep wake type'),
    ('G4724', 'Circadian rhythm sleep disorder, free running type'),
    ('G4725', 'Circadian rhythm sleep disorder, jet lag type'),
    ('G4726', 'Circadian rhythm sleep disorder, shift work type'),
    ('G4727', 'Circadian rhythm sleep disorder in conditions classd elswhr'),
    ('G4729', 'Other circadian rhythm sleep disorder'),
    ('G4730', 'Sleep apnea, unspecified'),
    ('G4731', 'Primary central sleep apnea'),
    ('G4732', 'High altitude periodic breathing'),
    ('G4733', 'Obstructive sleep apnea (adult) (pediatric)'),
    ('G4734', 'Idio sleep related nonobstructive alveolar hypoventilation'),
    ('G4735', 'Congenital central alveolar hypoventilation syndrome'),
    ('G4736', 'Sleep related hypoventilation in conditions classd elswhr'),
    ('G4737', 'Central sleep apnea in conditions classified elsewhere'),
    ('G4739', 'Other sleep apnea'),
    ('G47411', 'Narcolepsy with cataplexy'),
    ('G47419', 'Narcolepsy without cataplexy'),
    ('G47421', 'Narcolepsy in conditions classified elsewhere with cataplexy'),
    ('G47429', 'Narcolepsy in conditions classified elsewhere w/o cataplexy'),
    ('G4750', 'Parasomnia, unspecified'),
    ('G4751', 'Confusional arousals'),
    ('G4752', 'REM sleep behavior disorder'),
    ('G4753', 'Recurrent isolated sleep paralysis'),
    ('G4754', 'Parasomnia in conditions classified elsewhere'),
    ('G4759', 'Other parasomnia'),
    ('G4761', 'Periodic limb movement disorder'),
    ('G4762', 'Sleep related leg cramps'),
    ('G4763', 'Sleep related bruxism'),
    ('G4769', 'Other sleep related movement disorders'),
    ('G478', 'Other sleep disorders'),
    ('G479', 'Sleep disorder, unspecified'),
    ('G500', 'Trigeminal neuralgia'),
    ('G501', 'Atypical facial pain'),
    ('G508', 'Other disorders of trigeminal nerve'),
    ('G509', 'Disorder of trigeminal nerve, unspecified'),
    ('G510', "Bell's palsy"),
    ('G511', 'Geniculate ganglionitis'),
    ('G512', "Melkersson's syndrome"),
    ('G513', 'Clonic hemifacial spasm'),
    ('G5131', 'Clonic hemifacial spasm, right'),
    ('G5132', 'Clonic hemifacial spasm, left'),
    ('G5133', 'Clonic hemifacial spasm, bilateral'),
    ('G5139', 'Clonic hemifacial spasm, unspecified'),
    ('G514', 'Facial myokymia'),
    ('G518', 'Other disorders of facial nerve'),
    ('G519', 'Disorder of facial nerve, unspecified'),
    ('G520', 'Disorders of olfactory nerve'),
    ('G521', 'Disorders of glossopharyngeal nerve'),
    ('G522', 'Disorders of vagus nerve'),
    ('G523', 'Disorders of hypoglossal nerve'),
    ('G527', 'Disorders of multiple cranial nerves'),
    ('G528', 'Disorders of other specified cranial nerves'),
    ('G529', 'Cranial nerve disorder, unspecified'),
    ('G53', 'Cranial nerve disorders in diseases classified elsewhere'),
    ('G540', 'Brachial plexus disorders'),
    ('G541', 'Lumbosacral plexus disorders'),
    ('G542', 'Cervical root disorders, not elsewhere classified'),
    ('G543', 'Thoracic root disorders, not elsewhere classified'),
    ('G544', 'Lumbosacral root disorders, not elsewhere classified'),
    ('G545', 'Neuralgic amyotrophy'),
    ('G546', 'Phantom limb syndrome with pain'),
    ('G547', 'Phantom limb syndrome without pain'),
    ('G548', 'Other nerve root and plexus disorders'),
    ('G549', 'Nerve root and plexus disorder, unspecified'),
    ('G55', 'Nerve root and plexus compressions in diseases classd elswhr'),
    ('G5600', 'Carpal tunnel syndrome, unspecified upper limb'),
    ('G5601', 'Carpal tunnel syndrome, right upper limb'),
    ('G5602', 'Carpal tunnel syndrome, left upper limb'),
    ('G5603', 'Carpal tunnel syndrome, bilateral upper limbs'),
    ('G5610', 'Other lesions of median nerve, unspecified upper limb'),
    ('G5611', 'Other lesions of median nerve, right upper limb'),
    ('G5612', 'Other lesions of median nerve, left upper limb'),
    ('G5613', 'Other lesions of median nerve, bilateral upper limbs'),
    ('G5620', 'Lesion of ulnar nerve, unspecified upper limb'),
    ('G5621', 'Lesion of ulnar nerve, right upper limb'),
    ('G5622', 'Lesion of ulnar nerve, left upper limb'),
    ('G5623', 'Lesion of ulnar nerve, bilateral upper limbs'),
    ('G5630', 'Lesion of radial nerve, unspecified upper limb'),
    ('G5631', 'Lesion of radial nerve, right upper limb'),
    ('G5632', 'Lesion of radial nerve, left upper limb'),
    ('G5633', 'Lesion of radial nerve, bilateral upper limbs'),
    ('G5640', 'Causalgia of unspecified upper limb'),
    ('G5641', 'Causalgia of right upper limb'),
    ('G5642', 'Causalgia of left upper limb'),
    ('G5643', 'Causalgia of bilateral upper limbs'),
    ('G5680', 'Other specified mononeuropathies of unspecified upper limb'),
    ('G5681', 'Other specified mononeuropathies of right upper limb'),
    ('G5682', 'Other specified mononeuropathies of left upper limb'),
    ('G5683', 'Other specified mononeuropathies of bilateral upper limbs'),
    ('G5690', 'Unspecified mononeuropathy of unspecified upper limb'),
    ('G5691', 'Unspecified mononeuropathy of right upper limb'),
    ('G5692', 'Unspecified mononeuropathy of left upper limb'),
    ('G5693', 'Unspecified mononeuropathy of bilateral upper limbs'),
    ('G5700', 'Lesion of sciatic nerve, unspecified lower limb'),
    ('G5701', 'Lesion of sciatic nerve, right lower limb'),
    ('G5702', 'Lesion of sciatic nerve, left lower limb'),
    ('G5703', 'Lesion of sciatic nerve, bilateral lower limbs'),
    ('G5710', 'Meralgia paresthetica, unspecified lower limb'),
    ('G5711', 'Meralgia paresthetica, right lower limb'),
    ('G5712', 'Meralgia paresthetica, left lower limb'),
    ('G5713', 'Meralgia paresthetica, bilateral lower limbs'),
    ('G5720', 'Lesion of femoral nerve, unspecified lower limb'),
    ('G5721', 'Lesion of femoral nerve, right lower limb'),
    ('G5722', 'Lesion of femoral nerve, left lower limb'),
    ('G5723', 'Lesion of femoral nerve, bilateral lower limbs'),
    ('G5730', 'Lesion of lateral popliteal nerve, unspecified lower limb'),
    ('G5731', 'Lesion of lateral popliteal nerve, right lower limb'),
    ('G5732', 'Lesion of lateral popliteal nerve, left lower limb'),
    ('G5733', 'Lesion of lateral popliteal nerve, bilateral lower limbs'),
    ('G5740', 'Lesion of medial popliteal nerve, unspecified lower limb'),
    ('G5741', 'Lesion of medial popliteal nerve, right lower limb'),
    ('G5742', 'Lesion of medial popliteal nerve, left lower limb'),
    ('G5743', 'Lesion of medial popliteal nerve, bilateral lower limbs'),
    ('G5750', 'Tarsal tunnel syndrome, unspecified lower limb'),
    ('G5751', 'Tarsal tunnel syndrome, right lower limb'),
    ('G5752', 'Tarsal tunnel syndrome, left lower limb'),
    ('G5753', 'Tarsal tunnel syndrome, bilateral lower limbs'),
    ('G5760', 'Lesion of plantar nerve, unspecified lower limb'),
    ('G5761', 'Lesion of plantar nerve, right lower limb'),
    ('G5762', 'Lesion of plantar nerve, left lower limb'),
    ('G5763', 'Lesion of plantar nerve, bilateral lower limbs'),
    ('G5770', 'Causalgia of unspecified lower limb'),
    ('G5771', 'Causalgia of right lower limb'),
    ('G5772', 'Causalgia of left lower limb'),
    ('G5773', 'Causalgia of bilateral lower limbs'),
    ('G5780', 'Other specified mononeuropathies of unspecified lower limb'),
    ('G5781', 'Other specified mononeuropathies of right lower limb'),
    ('G5782', 'Other specified mononeuropathies of left lower limb'),
    ('G5783', 'Other specified mononeuropathies of bilateral lower limbs'),
    ('G5790', 'Unspecified mononeuropathy of unspecified lower limb'),
    ('G5791', 'Unspecified mononeuropathy of right lower limb'),
    ('G5792', 'Unspecified mononeuropathy of left lower limb'),
    ('G5793', 'Unspecified mononeuropathy of bilateral lower limbs'),
    ('G580', 'Intercostal neuropathy'),
    ('G587', 'Mononeuritis multiplex'),
    ('G588', 'Other specified mononeuropathies'),
    ('G589', 'Mononeuropathy, unspecified'),
    ('G59', 'Mononeuropathy in diseases classified elsewhere'),
    ('G600', 'Hereditary motor and sensory neuropathy'),
    ('G601', "Refsum's disease"),
    ('G602', 'Neuropathy in association with hereditary ataxia'),
    ('G603', 'Idiopathic progressive neuropathy'),
    ('G608', 'Other hereditary and idiopathic neuropathies'),
    ('G609', 'Hereditary and idiopathic neuropathy, unspecified'),
    ('G610', 'Guillain-Barre syndrome'),
    ('G611', 'Serum neuropathy'),
    ('G6181', 'Chronic inflammatory demyelinating polyneuritis'),
    ('G6182', 'Multifocal motor neuropathy'),
    ('G6189', 'Other inflammatory polyneuropathies'),
    ('G619', 'Inflammatory polyneuropathy, unspecified'),
    ('G620', 'Drug-induced polyneuropathy'),
    ('G621', 'Alcoholic polyneuropathy'),
    ('G622', 'Polyneuropathy due to other toxic agents'),
    ('G6281', 'Critical illness polyneuropathy'),
    ('G6282', 'Radiation-induced polyneuropathy'),
    ('G6289', 'Other specified polyneuropathies'),
    ('G629', 'Polyneuropathy, unspecified'),
    ('G63', 'Polyneuropathy in diseases classified elsewhere'),
    ('G64', 'Other disorders of peripheral nervous system'),
    ('G650', 'Sequelae of Guillain-Barre syndrome'),
    ('G651', 'Sequelae of other inflammatory polyneuropathy'),
    ('G652', 'Sequelae of toxic polyneuropathy'),
    ('G7000', 'Myasthenia gravis without (acute) exacerbation'),
    ('G7001', 'Myasthenia gravis with (acute) exacerbation'),
    ('G701', 'Toxic myoneural disorders'),
    ('G702', 'Congenital and developmental myasthenia'),
    ('G7080', 'Lambert-Eaton syndrome, unspecified'),
    ('G7081', 'Lambert-Eaton syndrome in disease classified elsewhere'),
    ('G7089', 'Other specified myoneural disorders'),
    ('G709', 'Myoneural disorder, unspecified'),
    ('G710', 'Muscular dystrophy'),
    ('G7100', 'Muscular dystrophy, unspecified'),
    ('G7101', 'Duchenne or Becker muscular dystrophy'),
    ('G7102', 'Facioscapulohumeral muscular dystrophy'),
    ('G7109', 'Other specified muscular dystrophies'),
    ('G7111', 'Myotonic muscular dystrophy'),
    ('G7112', 'Myotonia congenita'),
    ('G7113', 'Myotonic chondrodystrophy'),
    ('G7114', 'Drug induced myotonia'),
    ('G7119', 'Other specified myotonic disorders'),
    ('G712', 'Congenital myopathies'),
    ('G7120', 'Congenital myopathy, unspecified'),
    ('G7121', 'Nemaline myopathy'),
    ('G71220', 'X-linked myotubular myopathy '),
    ('G71228', 'Other centronuclear myopathy'),
    ('G7129', 'Other congenital myopathy'),
    ('G713', 'Mitochondrial myopathy, not elsewhere classified'),
    ('G718', 'Other primary disorders of muscles'),
    ('G719', 'Primary disorder of muscle, unspecified'),
    ('G720', 'Drug-induced myopathy'),
    ('G721', 'Alcoholic myopathy'),
    ('G722', 'Myopathy due to other toxic agents'),
    ('G723', 'Periodic paralysis'),
    ('G7241', 'Inclusion body myositis [IBM]'),
    ('G7249', 'Oth inflammatory and immune myopathies, NEC'),
    ('G7281', 'Critical illness myopathy'),
    ('G7289', 'Other specified myopathies'),
    ('G729', 'Myopathy, unspecified'),
    ('G731', 'Lambert-Eaton syndrome in neoplastic disease'),
    ('G733', 'Myasthenic syndromes in other diseases classified elsewhere'),
    ('G737', 'Myopathy in diseases classified elsewhere'),
    ('G800', 'Spastic quadriplegic cerebral palsy'),
    ('G801', 'Spastic diplegic cerebral palsy'),
    ('G802', 'Spastic hemiplegic cerebral palsy'),
    ('G803', 'Athetoid cerebral palsy'),
    ('G804', 'Ataxic cerebral palsy'),
    ('G808', 'Other cerebral palsy'),
    ('G809', 'Cerebral palsy, unspecified'),
    ('G8100', 'Flaccid hemiplegia affecting unspecified side'),
    ('G8101', 'Flaccid hemiplegia affecting right dominant side'),
    ('G8102', 'Flaccid hemiplegia affecting left dominant side'),
    ('G8103', 'Flaccid hemiplegia affecting right nondominant side'),
    ('G8104', 'Flaccid hemiplegia affecting left nondominant side'),
    ('G8110', 'Spastic hemiplegia affecting unspecified side'),
    ('G8111', 'Spastic hemiplegia affecting right dominant side'),
    ('G8112', 'Spastic hemiplegia affecting left dominant side'),
    ('G8113', 'Spastic hemiplegia affecting right nondominant side'),
    ('G8114', 'Spastic hemiplegia affecting left nondominant side'),
    ('G8190', 'Hemiplegia, unspecified affecting unspecified side'),
    ('G8191', 'Hemiplegia, unspecified affecting right dominant side'),
    ('G8192', 'Hemiplegia, unspecified affecting left dominant side'),
    ('G8193', 'Hemiplegia, unspecified affecting right nondominant side'),
    ('G8194', 'Hemiplegia, unspecified affecting left nondominant side'),
    ('G8220', 'Paraplegia, unspecified'),
    ('G8221', 'Paraplegia, complete'),
    ('G8222', 'Paraplegia, incomplete'),
    ('G8250', 'Quadriplegia, unspecified'),
    ('G8251', 'Quadriplegia, C1-C4 complete'),
    ('G8252', 'Quadriplegia, C1-C4 incomplete'),
    ('G8253', 'Quadriplegia, C5-C7 complete'),
    ('G8254', 'Quadriplegia, C5-C7 incomplete'),
    ('G830', 'Diplegia of upper limbs'),
    ('G8310', 'Monoplegia of lower limb affecting unspecified side'),
    ('G8311', 'Monoplegia of lower limb affecting right dominant side'),
    ('G8312', 'Monoplegia of lower limb affecting left dominant side'),
    ('G8313', 'Monoplegia of lower limb affecting right nondominant side'),
    ('G8314', 'Monoplegia of lower limb affecting left nondominant side'),
    ('G8320', 'Monoplegia of upper limb affecting unspecified side'),
    ('G8321', 'Monoplegia of upper limb affecting right dominant side'),
    ('G8322', 'Monoplegia of upper limb affecting left dominant side'),
    ('G8323', 'Monoplegia of upper limb affecting right nondominant side'),
    ('G8324', 'Monoplegia of upper limb affecting left nondominant side'),
    ('G8330', 'Monoplegia, unspecified affecting unspecified side'),
    ('G8331', 'Monoplegia, unspecified affecting right dominant side'),
    ('G8332', 'Monoplegia, unspecified affecting left dominant side'),
    ('G8333', 'Monoplegia, unspecified affecting right nondominant side'),
    ('G8334', 'Monoplegia, unspecified affecting left nondominant side'),
    ('G834', 'Cauda equina syndrome'),
    ('G835', 'Locked-in state'),
    ('G8381', 'Brown-Sequard syndrome'),
    ('G8382', 'Anterior cord syndrome'),
    ('G8383', 'Posterior cord syndrome'),
    ('G8384', "Todd's paralysis (postepileptic)"),
    ('G8389', 'Other specified paralytic syndromes'),
    ('G839', 'Paralytic syndrome, unspecified'),
    ('G890', 'Central pain syndrome'),
    ('G8911', 'Acute pain due to trauma'),
    ('G8912', 'Acute post-thoracotomy pain'),
    ('G8918', 'Other acute postprocedural pain'),
    ('G8921', 'Chronic pain due to trauma'),
    ('G8922', 'Chronic post-thoracotomy pain'),
    ('G8928', 'Other chronic postprocedural pain'),
    ('G8929', 'Other chronic pain'),
    ('G893', 'Neoplasm related pain (acute) (chronic)'),
    ('G894', 'Chronic pain syndrome'),
    ('G9001', 'Carotid sinus syncope'),
    ('G9009', 'Other idiopathic peripheral autonomic neuropathy'),
    ('G901', 'Familial dysautonomia [Riley-Day]'),
    ('G902', "Horner's syndrome"),
    ('G903', 'Multi-system degeneration of the autonomic nervous system'),
    ('G904', 'Autonomic dysreflexia'),
    ('G9050', 'Complex regional pain syndrome I, unspecified'),
    ('G90511', 'Complex regional pain syndrome I of right upper limb'),
    ('G90512', 'Complex regional pain syndrome I of left upper limb'),
    ('G90513', 'Complex regional pain syndrome I of upper limb, bilateral'),
    ('G90519', 'Complex regional pain syndrome I of unspecified upper limb'),
    ('G90521', 'Complex regional pain syndrome I of right lower limb'),
    ('G90522', 'Complex regional pain syndrome I of left lower limb'),
    ('G90523', 'Complex regional pain syndrome I of lower limb, bilateral'),
    ('G90529', 'Complex regional pain syndrome I of unspecified lower limb'),
    ('G9059', 'Complex regional pain syndrome I of other specified site'),
    ('G908', 'Other disorders of autonomic nervous system'),
    ('G909', 'Disorder of the autonomic nervous system, unspecified'),
    ('G90A', 'Postural orthostatic tachycardia syndrome [POTS]'),
    ('G90B', 'LMNB1-related autosomal dominant leukodystrophy'),
    ('G910', 'Communicating hydrocephalus'),
    ('G911', 'Obstructive hydrocephalus'),
    ('G912', '(Idiopathic) normal pressure hydrocephalus'),
    ('G913', 'Post-traumatic hydrocephalus, unspecified'),
    ('G914', 'Hydrocephalus in diseases classified elsewhere'),
    ('G918', 'Other hydrocephalus'),
    ('G919', 'Hydrocephalus, unspecified'),
    ('G92', 'Toxic encephalopathy'),
    ('G9200', 'Immune effor cell-associated neurotoxicity synd, grade unsp'),
    ('G9201', 'Immune effector cell-associated neurotoxicity synd, grade 1'),
    ('G9202', 'Immune effector cell-associated neurotoxicity synd, grade 2'),
    ('G9203', 'Immune effector cell-associated neurotoxicity synd, grade 3'),
    ('G9204', 'Immune effector cell-associated neurotoxicity synd, grade 4'),
    ('G9205', 'Immune effector cell-associated neurotoxicity synd, grade 5'),
    ('G928', 'Other toxic encephalopathy'),
    ('G929', 'Unspecified toxic encephalopathy'),
    ('G930', 'Cerebral cysts'),
    ('G931', 'Anoxic brain damage, not elsewhere classified'),
    ('G932', 'Benign intracranial hypertension'),
    ('G933', 'Postviral fatigue syndrome'),
    ('G9331', 'Postviral fatigue syndrome'),
    ('G9332', 'Myalgic encephalomyelitis/chronic fatigue syndrome'),
    ('G9339', 'Other post infection and related fatigue syndromes'),
    ('G9340', 'Encephalopathy, unspecified'),
    ('G9341', 'Metabolic encephalopathy'),
    ('G9342', 'Megaloencephalic leukoencephalopathy with subcortical cysts'),
    ('G9343', 'Leukoencephalopathy with calcifications and cysts'),
    ('G9344', 'Adult-onset leukodystrophy with axonal spheroids'),
    ('G9349', 'Other encephalopathy'),
    ('G935', 'Compression of brain'),
    ('G936', 'Cerebral edema'),
    ('G937', "Reye's syndrome"),
    ('G9381', 'Temporal sclerosis'),
    ('G9382', 'Brain death'),
    ('G9389', 'Other specified disorders of brain'),
    ('G939', 'Disorder of brain, unspecified'),
    ('G94', 'Other disorders of brain in diseases classified elsewhere'),
    ('G950', 'Syringomyelia and syringobulbia'),
    ('G9511', 'Acute infarction of spinal cord (embolic) (nonembolic)'),
    ('G9519', 'Other vascular myelopathies'),
    ('G9520', 'Unspecified cord compression'),
    ('G9529', 'Other cord compression'),
    ('G9581', 'Conus medullaris syndrome'),
    ('G9589', 'Other specified diseases of spinal cord'),
    ('G959', 'Disease of spinal cord, unspecified'),
    ('G960', 'Cerebrospinal fluid leak'),
    ('G9600', 'Cerebrospinal fluid leak, unspecified'),
    ('G9601', 'Cranial cerebrospinal fluid leak, spontaneous'),
    ('G9602', 'Spinal cerebrospinal fluid leak, spontaneous'),
    ('G9608 ', 'Other cranial cerebrospinal fluid leak'),
    ('G9609', 'Other spinal cerebrospinal fluid leak'),
    ('G9611', 'Dural tear'),
    ('G9612', 'Meningeal adhesions (cerebral) (spinal)'),
    ('G9619', 'Other disorders of meninges, not elsewhere classified'),
    ('G96191', 'Perineural cyst'),
    ('G96198', 'Other disorders of meninges, not elsewhere classified'),
    ('G968', 'Other specified disorders of central nervous system'),
    ('G96810', 'Intracranial hypotension, unspecified'),
    ('G96811', 'Intracranial hypotension, spontaneous'),
    ('G96819', 'Other intracranial hypotension'),
    ('G9689', 'Other specified disorders of central nervous system'),
    ('G969', 'Disorder of central nervous system, unspecified'),
    ('G970', 'Cerebrospinal fluid leak from spinal puncture'),
    ('G971', 'Other reaction to spinal and lumbar puncture'),
    ('G972', 'Intracranial hypotension following ventricular shunting'),
    ('G9731', 'Intraop hemor/hemtom of a nervous sys org comp nrv sys proc'),
    ('G9732', 'Intraop hemor/hemtom of a nervous sys org comp oth procedure'),
    ('G9741', 'Accidental puncture or laceration of dura during a procedure'),
    ('G9748', 'Acc pnctr & lac of nervous sys org during a nervous sys proc'),
    ('G9749', 'Acc pnctr & lac of nervous sys org during oth procedure'),
    ('G9751', 'Postproc hemor of a nrv sys org fol a nrv sys proc'),
    ('G9752', 'Postproc hemor of a nervous sys org fol oth procedure'),
    ('G9761', 'Postp hematoma of a nervous sys org fol a nervous sys proc'),
    ('G9762', 'Postproc hematoma of a nervous sys org fol other procedure'),
    ('G9763', 'Postproc seroma of a nervous sys org fol a nervous sys proc'),
    ('G9764', 'Postproc seroma of a nervous sys org fol other procedure'),
    ('G9781', 'Other intraoperative complications of nervous system'),
    ('G9782', 'Oth postproc complications and disorders of nervous sys'),
    ('G9783', 'Intracranial hypotension following lumbar CSF shunting'),
    ('G9784', 'Intracranial hypotension following other procedure'),
    ('G980', 'Neurogenic arthritis, not elsewhere classified'),
    ('G988', 'Other disorders of nervous system'),
    ('G990', 'Autonomic neuropathy in diseases classified elsewhere'),
    ('G992', 'Myelopathy in diseases classified elsewhere'),
    ('G998', 'Oth disrd of nervous system in diseases classified elsewhere'),
    ('H00011', 'Hordeolum externum right upper eyelid'),
    ('H00012', 'Hordeolum externum right lower eyelid'),
    ('H00013', 'Hordeolum externum right eye, unspecified eyelid'),
    ('H00014', 'Hordeolum externum left upper eyelid'),
    ('H00015', 'Hordeolum externum left lower eyelid'),
    ('H00016', 'Hordeolum externum left eye, unspecified eyelid'),
    ('H00019', 'Hordeolum externum unspecified eye, unspecified eyelid'),
    ('H00021', 'Hordeolum internum right upper eyelid'),
    ('H00022', 'Hordeolum internum right lower eyelid'),
    ('H00023', 'Hordeolum internum right eye, unspecified eyelid'),
    ('H00024', 'Hordeolum internum left upper eyelid'),
    ('H00025', 'Hordeolum internum left lower eyelid'),
    ('H00026', 'Hordeolum internum left eye, unspecified eyelid'),
    ('H00029', 'Hordeolum internum unspecified eye, unspecified eyelid'),
    ('H00031', 'Abscess of right upper eyelid'),
    ('H00032', 'Abscess of right lower eyelid'),
    ('H00033', 'Abscess of eyelid right eye, unspecified eyelid'),
    ('H00034', 'Abscess of left upper eyelid'),
    ('H00035', 'Abscess of left lower eyelid'),
    ('H00036', 'Abscess of eyelid left eye, unspecified eyelid'),
    ('H00039', 'Abscess of eyelid unspecified eye, unspecified eyelid'),
    ('H0011', 'Chalazion right upper eyelid'),
    ('H0012', 'Chalazion right lower eyelid'),
    ('H0013', 'Chalazion right eye, unspecified eyelid'),
    ('H0014', 'Chalazion left upper eyelid'),
    ('H0015', 'Chalazion left lower eyelid'),
    ('H0016', 'Chalazion left eye, unspecified eyelid'),
    ('H0019', 'Chalazion unspecified eye, unspecified eyelid'),
    ('H01001', 'Unspecified blepharitis right upper eyelid'),
    ('H01002', 'Unspecified blepharitis right lower eyelid'),
    ('H01003', 'Unspecified blepharitis right eye, unspecified eyelid'),
    ('H01004', 'Unspecified blepharitis left upper eyelid'),
    ('H01005', 'Unspecified blepharitis left lower eyelid'),
    ('H01006', 'Unspecified blepharitis left eye, unspecified eyelid'),
    ('H01009', 'Unspecified blepharitis unspecified eye, unspecified eyelid'),
    ('H0100A', 'Unspecified blepharitis right eye, upper and lower eyelids'),
    ('H0100B', 'Unspecified blepharitis left eye, upper and lower eyelids'),
    ('H01011', 'Ulcerative blepharitis right upper eyelid'),
    ('H01012', 'Ulcerative blepharitis right lower eyelid'),
    ('H01013', 'Ulcerative blepharitis right eye, unspecified eyelid'),
    ('H01014', 'Ulcerative blepharitis left upper eyelid'),
    ('H01015', 'Ulcerative blepharitis left lower eyelid'),
    ('H01016', 'Ulcerative blepharitis left eye, unspecified eyelid'),
    ('H01019', 'Ulcerative blepharitis unspecified eye, unspecified eyelid'),
    ('H0101A', 'Ulcerative blepharitis right eye, upper and lower eyelids'),
    ('H0101B', 'Ulcerative blepharitis left eye, upper and lower eyelids'),
    ('H01021', 'Squamous blepharitis right upper eyelid'),
    ('H01022', 'Squamous blepharitis right lower eyelid'),
    ('H01023', 'Squamous blepharitis right eye, unspecified eyelid'),
    ('H01024', 'Squamous blepharitis left upper eyelid'),
    ('H01025', 'Squamous blepharitis left lower eyelid'),
    ('H01026', 'Squamous blepharitis left eye, unspecified eyelid'),
    ('H01029', 'Squamous blepharitis unspecified eye, unspecified eyelid'),
    ('H0102A', 'Squamous blepharitis right eye, upper and lower eyelids'),
    ('H0102B', 'Squamous blepharitis left eye, upper and lower eyelids'),
    ('H01111', 'Allergic dermatitis of right upper eyelid'),
    ('H01112', 'Allergic dermatitis of right lower eyelid'),
    ('H01113', 'Allergic dermatitis of right eye, unspecified eyelid'),
    ('H01114', 'Allergic dermatitis of left upper eyelid'),
    ('H01115', 'Allergic dermatitis of left lower eyelid'),
    ('H01116', 'Allergic dermatitis of left eye, unspecified eyelid'),
    ('H01119', 'Allergic dermatitis of unspecified eye, unspecified eyelid'),
    ('H01121', 'Discoid lupus erythematosus of right upper eyelid'),
    ('H01122', 'Discoid lupus erythematosus of right lower eyelid'),
    ('H01123', 'Discoid lupus erythematosus of right eye, unspecified eyelid'),
    ('H01124', 'Discoid lupus erythematosus of left upper eyelid'),
    ('H01125', 'Discoid lupus erythematosus of left lower eyelid'),
    ('H01126', 'Discoid lupus erythematosus of left eye, unspecified eyelid'),
    ('H01129', 'Discoid lupus erythematosus of unsp eye, unspecified eyelid'),
    ('H01131', 'Eczematous dermatitis of right upper eyelid'),
    ('H01132', 'Eczematous dermatitis of right lower eyelid'),
    ('H01133', 'Eczematous dermatitis of right eye, unspecified eyelid'),
    ('H01134', 'Eczematous dermatitis of left upper eyelid'),
    ('H01135', 'Eczematous dermatitis of left lower eyelid'),
    ('H01136', 'Eczematous dermatitis of left eye, unspecified eyelid'),
    ('H01139', 'Eczematous dermatitis of unspecified eye, unspecified eyelid'),
    ('H01141', 'Xeroderma of right upper eyelid'),
    ('H01142', 'Xeroderma of right lower eyelid'),
    ('H01143', 'Xeroderma of right eye, unspecified eyelid'),
    ('H01144', 'Xeroderma of left upper eyelid'),
    ('H01145', 'Xeroderma of left lower eyelid'),
    ('H01146', 'Xeroderma of left eye, unspecified eyelid'),
    ('H01149', 'Xeroderma of unspecified eye, unspecified eyelid'),
    ('H018', 'Other specified inflammations of eyelid'),
    ('H019', 'Unspecified inflammation of eyelid'),
    ('H02001', 'Unspecified entropion of right upper eyelid'),
    ('H02002', 'Unspecified entropion of right lower eyelid'),
    ('H02003', 'Unspecified entropion of right eye, unspecified eyelid'),
    ('H02004', 'Unspecified entropion of left upper eyelid'),
    ('H02005', 'Unspecified entropion of left lower eyelid'),
    ('H02006', 'Unspecified entropion of left eye, unspecified eyelid'),
    ('H02009', 'Unspecified entropion of unspecified eye, unspecified eyelid'),
    ('H02011', 'Cicatricial entropion of right upper eyelid'),
    ('H02012', 'Cicatricial entropion of right lower eyelid'),
    ('H02013', 'Cicatricial entropion of right eye, unspecified eyelid'),
    ('H02014', 'Cicatricial entropion of left upper eyelid'),
    ('H02015', 'Cicatricial entropion of left lower eyelid'),
    ('H02016', 'Cicatricial entropion of left eye, unspecified eyelid'),
    ('H02019', 'Cicatricial entropion of unspecified eye, unspecified eyelid'),
    ('H02021', 'Mechanical entropion of right upper eyelid'),
    ('H02022', 'Mechanical entropion of right lower eyelid'),
    ('H02023', 'Mechanical entropion of right eye, unspecified eyelid'),
    ('H02024', 'Mechanical entropion of left upper eyelid'),
    ('H02025', 'Mechanical entropion of left lower eyelid'),
    ('H02026', 'Mechanical entropion of left eye, unspecified eyelid'),
    ('H02029', 'Mechanical entropion of unspecified eye, unspecified eyelid'),
    ('H02031', 'Senile entropion of right upper eyelid'),
    ('H02032', 'Senile entropion of right lower eyelid'),
    ('H02033', 'Senile entropion of right eye, unspecified eyelid'),
    ('H02034', 'Senile entropion of left upper eyelid'),
    ('H02035', 'Senile entropion of left lower eyelid'),
    ('H02036', 'Senile entropion of left eye, unspecified eyelid'),
    ('H02039', 'Senile entropion of unspecified eye, unspecified eyelid'),
    ('H02041', 'Spastic entropion of right upper eyelid'),
    ('H02042', 'Spastic entropion of right lower eyelid'),
    ('H02043', 'Spastic entropion of right eye, unspecified eyelid'),
    ('H02044', 'Spastic entropion of left upper eyelid'),
    ('H02045', 'Spastic entropion of left lower eyelid'),
    ('H02046', 'Spastic entropion of left eye, unspecified eyelid'),
    ('H02049', 'Spastic entropion of unspecified eye, unspecified eyelid'),
    ('H02051', 'Trichiasis without entropion right upper eyelid'),
    ('H02052', 'Trichiasis without entropion right lower eyelid'),
    ('H02053', 'Trichiasis without entropion right eye, unspecified eyelid'),
    ('H02054', 'Trichiasis without entropion left upper eyelid'),
    ('H02055', 'Trichiasis without entropion left lower eyelid'),
    ('H02056', 'Trichiasis without entropion left eye, unspecified eyelid'),
    ('H02059', 'Trichiasis without entropion unsp eye, unspecified eyelid'),
    ('H02101', 'Unspecified ectropion of right upper eyelid'),
    ('H02102', 'Unspecified ectropion of right lower eyelid'),
    ('H02103', 'Unspecified ectropion of right eye, unspecified eyelid'),
    ('H02104', 'Unspecified ectropion of left upper eyelid'),
    ('H02105', 'Unspecified ectropion of left lower eyelid'),
    ('H02106', 'Unspecified ectropion of left eye, unspecified eyelid'),
    ('H02109', 'Unspecified ectropion of unspecified eye, unspecified eyelid'),
    ('H02111', 'Cicatricial ectropion of right upper eyelid'),
    ('H02112', 'Cicatricial ectropion of right lower eyelid'),
    ('H02113', 'Cicatricial ectropion of right eye, unspecified eyelid'),
    ('H02114', 'Cicatricial ectropion of left upper eyelid'),
    ('H02115', 'Cicatricial ectropion of left lower eyelid'),
    ('H02116', 'Cicatricial ectropion of left eye, unspecified eyelid'),
    ('H02119', 'Cicatricial ectropion of unspecified eye, unspecified eyelid'),
    ('H02121', 'Mechanical ectropion of right upper eyelid'),
    ('H02122', 'Mechanical ectropion of right lower eyelid'),
    ('H02123', 'Mechanical ectropion of right eye, unspecified eyelid'),
    ('H02124', 'Mechanical ectropion of left upper eyelid'),
    ('H02125', 'Mechanical ectropion of left lower eyelid'),
    ('H02126', 'Mechanical ectropion of left eye, unspecified eyelid'),
    ('H02129', 'Mechanical ectropion of unspecified eye, unspecified eyelid'),
    ('H02131', 'Senile ectropion of right upper eyelid'),
    ('H02132', 'Senile ectropion of right lower eyelid'),
    ('H02133', 'Senile ectropion of right eye, unspecified eyelid'),
    ('H02134', 'Senile ectropion of left upper eyelid'),
    ('H02135', 'Senile ectropion of left lower eyelid'),
    ('H02136', 'Senile ectropion of left eye, unspecified eyelid'),
    ('H02139', 'Senile ectropion of unspecified eye, unspecified eyelid'),
    ('H02141', 'Spastic ectropion of right upper eyelid'),
    ('H02142', 'Spastic ectropion of right lower eyelid'),
    ('H02143', 'Spastic ectropion of right eye, unspecified eyelid'),
    ('H02144', 'Spastic ectropion of left upper eyelid'),
    ('H02145', 'Spastic ectropion of left lower eyelid'),
    ('H02146', 'Spastic ectropion of left eye, unspecified eyelid'),
    ('H02149', 'Spastic ectropion of unspecified eye, unspecified eyelid'),
    ('H02151', 'Paralytic ectropion of right upper eyelid'),
    ('H02152', 'Paralytic ectropion of right lower eyelid'),
    ('H02153', 'Paralytic ectropion of right eye, unspecified eyelid'),
    ('H02154', 'Paralytic ectropion of left upper eyelid'),
    ('H02155', 'Paralytic ectropion of left lower eyelid'),
    ('H02156', 'Paralytic ectropion of left eye, unspecified eyelid'),
    ('H02159', 'Paralytic ectropion of unspecified eye, unspecified eyelid'),
    ('H02201', 'Unspecified lagophthalmos right upper eyelid'),
    ('H02202', 'Unspecified lagophthalmos right lower eyelid'),
    ('H02203', 'Unspecified lagophthalmos right eye, unspecified eyelid'),
    ('H02204', 'Unspecified lagophthalmos left upper eyelid'),
    ('H02205', 'Unspecified lagophthalmos left lower eyelid'),
    ('H02206', 'Unspecified lagophthalmos left eye, unspecified eyelid'),
    ('H02209', 'Unsp lagophthalmos unspecified eye, unspecified eyelid'),
    ('H0220A', 'Unspecified lagophthalmos right eye, upper and lower eyelids'),
    ('H0220B', 'Unspecified lagophthalmos left eye, upper and lower eyelids'),
    ('H0220C', 'Unsp lagophthalmos, bilateral, upper and lower eyelids'),
    ('H02211', 'Cicatricial lagophthalmos right upper eyelid'),
    ('H02212', 'Cicatricial lagophthalmos right lower eyelid'),
    ('H02213', 'Cicatricial lagophthalmos right eye, unspecified eyelid'),
    ('H02214', 'Cicatricial lagophthalmos left upper eyelid'),
    ('H02215', 'Cicatricial lagophthalmos left lower eyelid'),
    ('H02216', 'Cicatricial lagophthalmos left eye, unspecified eyelid'),
    ('H02219', 'Cicatricial lagophthalmos unsp eye, unspecified eyelid'),
    ('H0221A', 'Cicatricial lagophthalmos right eye, upper and lower eyelids'),
    ('H0221B', 'Cicatricial lagophthalmos left eye, upper and lower eyelids'),
    ('H0221C', 'Cicatricial lagophthalmos, bi, upper and lower eyelids'),
    ('H02221', 'Mechanical lagophthalmos right upper eyelid'),
    ('H02222', 'Mechanical lagophthalmos right lower eyelid'),
    ('H02223', 'Mechanical lagophthalmos right eye, unspecified eyelid'),
    ('H02224', 'Mechanical lagophthalmos left upper eyelid'),
    ('H02225', 'Mechanical lagophthalmos left lower eyelid'),
    ('H02226', 'Mechanical lagophthalmos left eye, unspecified eyelid'),
    ('H02229', 'Mechanical lagophthalmos unspecified eye, unspecified eyelid'),
    ('H0222A', 'Mechanical lagophthalmos right eye, upper and lower eyelids'),
    ('H0222B', 'Mechanical lagophthalmos left eye, upper and lower eyelids'),
    ('H0222C', 'Mechanical lagophthalmos, bilateral, upper and lower eyelids'),
    ('H02231', 'Paralytic lagophthalmos right upper eyelid'),
    ('H02232', 'Paralytic lagophthalmos right lower eyelid'),
    ('H02233', 'Paralytic lagophthalmos right eye, unspecified eyelid'),
    ('H02234', 'Paralytic lagophthalmos left upper eyelid'),
    ('H02235', 'Paralytic lagophthalmos left lower eyelid'),
    ('H02236', 'Paralytic lagophthalmos left eye, unspecified eyelid'),
    ('H02239', 'Paralytic lagophthalmos unspecified eye, unspecified eyelid'),
    ('H0223A', 'Paralytic lagophthalmos right eye, upper and lower eyelids'),
    ('H0223B', 'Paralytic lagophthalmos left eye, upper and lower eyelids'),
    ('H0223C', 'Paralytic lagophthalmos, bilateral, upper and lower eyelids'),
    ('H0230', 'Blepharochalasis unspecified eye, unspecified eyelid'),
    ('H0231', 'Blepharochalasis right upper eyelid'),
    ('H0232', 'Blepharochalasis right lower eyelid'),
    ('H0233', 'Blepharochalasis right eye, unspecified eyelid'),
    ('H0234', 'Blepharochalasis left upper eyelid'),
    ('H0235', 'Blepharochalasis left lower eyelid'),
    ('H0236', 'Blepharochalasis left eye, unspecified eyelid'),
    ('H02401', 'Unspecified ptosis of right eyelid'),
    ('H02402', 'Unspecified ptosis of left eyelid'),
    ('H02403', 'Unspecified ptosis of bilateral eyelids'),
    ('H02409', 'Unspecified ptosis of unspecified eyelid'),
    ('H02411', 'Mechanical ptosis of right eyelid'),
    ('H02412', 'Mechanical ptosis of left eyelid'),
    ('H02413', 'Mechanical ptosis of bilateral eyelids'),
    ('H02419', 'Mechanical ptosis of unspecified eyelid'),
    ('H02421', 'Myogenic ptosis of right eyelid'),
    ('H02422', 'Myogenic ptosis of left eyelid'),
    ('H02423', 'Myogenic ptosis of bilateral eyelids'),
    ('H02429', 'Myogenic ptosis of unspecified eyelid'),
    ('H02431', 'Paralytic ptosis of right eyelid'),
    ('H02432', 'Paralytic ptosis of left eyelid'),
    ('H02433', 'Paralytic ptosis of bilateral eyelids'),
    ('H02439', 'Paralytic ptosis unspecified eyelid'),
    ('H02511', 'Abnormal innervation syndrome right upper eyelid'),
    ('H02512', 'Abnormal innervation syndrome right lower eyelid'),
    ('H02513', 'Abnormal innervation syndrome right eye, unspecified eyelid'),
    ('H02514', 'Abnormal innervation syndrome left upper eyelid'),
    ('H02515', 'Abnormal innervation syndrome left lower eyelid'),
    ('H02516', 'Abnormal innervation syndrome left eye, unspecified eyelid'),
    ('H02519', 'Abnormal innervation syndrome unsp eye, unspecified eyelid'),
    ('H02521', 'Blepharophimosis right upper eyelid'),
    ('H02522', 'Blepharophimosis right lower eyelid'),
    ('H02523', 'Blepharophimosis right eye, unspecified eyelid'),
    ('H02524', 'Blepharophimosis left upper eyelid'),
    ('H02525', 'Blepharophimosis left lower eyelid'),
    ('H02526', 'Blepharophimosis left eye, unspecified eyelid'),
    ('H02529', 'Blepharophimosis unspecified eye, unspecified lid'),
    ('H02531', 'Eyelid retraction right upper eyelid'),
    ('H02532', 'Eyelid retraction right lower eyelid'),
    ('H02533', 'Eyelid retraction right eye, unspecified eyelid'),
    ('H02534', 'Eyelid retraction left upper eyelid'),
    ('H02535', 'Eyelid retraction left lower eyelid'),
    ('H02536', 'Eyelid retraction left eye, unspecified eyelid'),
    ('H02539', 'Eyelid retraction unspecified eye, unspecified lid'),
    ('H0259', 'Other disorders affecting eyelid function'),
    ('H0260', 'Xanthelasma of unspecified eye, unspecified eyelid'),
    ('H0261', 'Xanthelasma of right upper eyelid'),
    ('H0262', 'Xanthelasma of right lower eyelid'),
    ('H0263', 'Xanthelasma of right eye, unspecified eyelid'),
    ('H0264', 'Xanthelasma of left upper eyelid'),
    ('H0265', 'Xanthelasma of left lower eyelid'),
    ('H0266', 'Xanthelasma of left eye, unspecified eyelid'),
    ('H0270', 'Unsp degenerative disorders of eyelid and periocular area'),
    ('H02711', 'Chloasma of right upper eyelid and periocular area'),
    ('H02712', 'Chloasma of right lower eyelid and periocular area'),
    ('H02713', 'Chloasma of right eye, unsp eyelid and periocular area'),
    ('H02714', 'Chloasma of left upper eyelid and periocular area'),
    ('H02715', 'Chloasma of left lower eyelid and periocular area'),
    ('H02716', 'Chloasma of left eye, unspecified eyelid and periocular area'),
    ('H02719', 'Chloasma of unsp eye, unspecified eyelid and periocular area'),
    ('H02721', 'Madarosis of right upper eyelid and periocular area'),
    ('H02722', 'Madarosis of right lower eyelid and periocular area'),
    ('H02723', 'Madarosis of right eye, unsp eyelid and periocular area'),
    ('H02724', 'Madarosis of left upper eyelid and periocular area'),
    ('H02725', 'Madarosis of left lower eyelid and periocular area'),
    ('H02726', 'Madarosis of left eye, unsp eyelid and periocular area'),
    ('H02729', 'Madarosis of unsp eye, unsp eyelid and periocular area'),
    ('H02731', 'Vitiligo of right upper eyelid and periocular area'),
    ('H02732', 'Vitiligo of right lower eyelid and periocular area'),
    ('H02733', 'Vitiligo of right eye, unsp eyelid and periocular area'),
    ('H02734', 'Vitiligo of left upper eyelid and periocular area'),
    ('H02735', 'Vitiligo of left lower eyelid and periocular area'),
    ('H02736', 'Vitiligo of left eye, unspecified eyelid and periocular area'),
    ('H02739', 'Vitiligo of unsp eye, unspecified eyelid and periocular area'),
    ('H0279', 'Other degenerative disorders of eyelid and periocular area'),
    ('H02811', 'Retained foreign body in right upper eyelid'),
    ('H02812', 'Retained foreign body in right lower eyelid'),
    ('H02813', 'Retained foreign body in right eye, unspecified eyelid'),
    ('H02814', 'Retained foreign body in left upper eyelid'),
    ('H02815', 'Retained foreign body in left lower eyelid'),
    ('H02816', 'Retained foreign body in left eye, unspecified eyelid'),
    ('H02819', 'Retained foreign body in unspecified eye, unspecified eyelid'),
    ('H02821', 'Cysts of right upper eyelid'),
    ('H02822', 'Cysts of right lower eyelid'),
    ('H02823', 'Cysts of right eye, unspecified eyelid'),
    ('H02824', 'Cysts of left upper eyelid'),
    ('H02825', 'Cysts of left lower eyelid'),
    ('H02826', 'Cysts of left eye, unspecified eyelid'),
    ('H02829', 'Cysts of unspecified eye, unspecified eyelid'),
    ('H02831', 'Dermatochalasis of right upper eyelid'),
    ('H02832', 'Dermatochalasis of right lower eyelid'),
    ('H02833', 'Dermatochalasis of right eye, unspecified eyelid'),
    ('H02834', 'Dermatochalasis of left upper eyelid'),
    ('H02835', 'Dermatochalasis of left lower eyelid'),
    ('H02836', 'Dermatochalasis of left eye, unspecified eyelid'),
    ('H02839', 'Dermatochalasis of unspecified eye, unspecified eyelid'),
    ('H02841', 'Edema of right upper eyelid'),
    ('H02842', 'Edema of right lower eyelid'),
    ('H02843', 'Edema of right eye, unspecified eyelid'),
    ('H02844', 'Edema of left upper eyelid'),
    ('H02845', 'Edema of left lower eyelid'),
    ('H02846', 'Edema of left eye, unspecified eyelid'),
    ('H02849', 'Edema of unspecified eye, unspecified eyelid'),
    ('H02851', 'Elephantiasis of right upper eyelid'),
    ('H02852', 'Elephantiasis of right lower eyelid'),
    ('H02853', 'Elephantiasis of right eye, unspecified eyelid'),
    ('H02854', 'Elephantiasis of left upper eyelid'),
    ('H02855', 'Elephantiasis of left lower eyelid'),
    ('H02856', 'Elephantiasis of left eye, unspecified eyelid'),
    ('H02859', 'Elephantiasis of unspecified eye, unspecified eyelid'),
    ('H02861', 'Hypertrichosis of right upper eyelid'),
    ('H02862', 'Hypertrichosis of right lower eyelid'),
    ('H02863', 'Hypertrichosis of right eye, unspecified eyelid'),
    ('H02864', 'Hypertrichosis of left upper eyelid'),
    ('H02865', 'Hypertrichosis of left lower eyelid'),
    ('H02866', 'Hypertrichosis of left eye, unspecified eyelid'),
    ('H02869', 'Hypertrichosis of unspecified eye, unspecified eyelid'),
    ('H02871', 'Vascular anomalies of right upper eyelid'),
    ('H02872', 'Vascular anomalies of right lower eyelid'),
    ('H02873', 'Vascular anomalies of right eye, unspecified eyelid'),
    ('H02874', 'Vascular anomalies of left upper eyelid'),
    ('H02875', 'Vascular anomalies of left lower eyelid'),
    ('H02876', 'Vascular anomalies of left eye, unspecified eyelid'),
    ('H02879', 'Vascular anomalies of unspecified eye, unspecified eyelid'),
    ('H02881', 'Meibomian gland dysfunction right upper eyelid'),
    ('H02882', 'Meibomian gland dysfunction right lower eyelid'),
    ('H02883', 'Meibomian gland dysfunction of right eye, unspecified eyelid'),
    ('H02884', 'Meibomian gland dysfunction left upper eyelid'),
    ('H02885', 'Meibomian gland dysfunction left lower eyelid'),
    ('H02886', 'Meibomian gland dysfunction of left eye, unspecified eyelid'),
    ('H02889', 'Meibomian gland dysfunction of unsp, unspecified eyelid'),
    ('H0288A', 'Meibomian gland dysfnct right eye, upper and lower eyelids'),
    ('H0288B', 'Meibomian gland dysfnct left eye, upper and lower eyelid'),
    ('H0289', 'Other specified disorders of eyelid'),
    ('H029', 'Unspecified disorder of eyelid'),
    ('H04001', 'Unspecified dacryoadenitis, right lacrimal gland'),
    ('H04002', 'Unspecified dacryoadenitis, left lacrimal gland'),
    ('H04003', 'Unspecified dacryoadenitis, bilateral lacrimal glands'),
    ('H04009', 'Unspecified dacryoadenitis, unspecified lacrimal gland'),
    ('H04011', 'Acute dacryoadenitis, right lacrimal gland'),
    ('H04012', 'Acute dacryoadenitis, left lacrimal gland'),
    ('H04013', 'Acute dacryoadenitis, bilateral lacrimal glands'),
    ('H04019', 'Acute dacryoadenitis, unspecified lacrimal gland'),
    ('H04021', 'Chronic dacryoadenitis, right lacrimal gland'),
    ('H04022', 'Chronic dacryoadenitis, left lacrimal gland'),
    ('H04023', 'Chronic dacryoadenitis, bilateral lacrimal gland'),
    ('H04029', 'Chronic dacryoadenitis, unspecified lacrimal gland'),
    ('H04031', 'Chronic enlargement of right lacrimal gland'),
    ('H04032', 'Chronic enlargement of left lacrimal gland'),
    ('H04033', 'Chronic enlargement of bilateral lacrimal glands'),
    ('H04039', 'Chronic enlargement of unspecified lacrimal gland'),
    ('H04111', 'Dacryops of right lacrimal gland'),
    ('H04112', 'Dacryops of left lacrimal gland'),
    ('H04113', 'Dacryops of bilateral lacrimal glands'),
    ('H04119', 'Dacryops of unspecified lacrimal gland'),
    ('H04121', 'Dry eye syndrome of right lacrimal gland'),
    ('H04122', 'Dry eye syndrome of left lacrimal gland'),
    ('H04123', 'Dry eye syndrome of bilateral lacrimal glands'),
    ('H04129', 'Dry eye syndrome of unspecified lacrimal gland'),
    ('H04131', 'Lacrimal cyst, right lacrimal gland'),
    ('H04132', 'Lacrimal cyst, left lacrimal gland'),
    ('H04133', 'Lacrimal cyst, bilateral lacrimal glands'),
    ('H04139', 'Lacrimal cyst, unspecified lacrimal gland'),
    ('H04141', 'Primary lacrimal gland atrophy, right lacrimal gland'),
    ('H04142', 'Primary lacrimal gland atrophy, left lacrimal gland'),
    ('H04143', 'Primary lacrimal gland atrophy, bilateral lacrimal glands'),
    ('H04149', 'Primary lacrimal gland atrophy, unspecified lacrimal gland'),
    ('H04151', 'Secondary lacrimal gland atrophy, right lacrimal gland'),
    ('H04152', 'Secondary lacrimal gland atrophy, left lacrimal gland'),
    ('H04153', 'Secondary lacrimal gland atrophy, bilateral lacrimal glands'),
    ('H04159', 'Secondary lacrimal gland atrophy, unspecified lacrimal gland'),
    ('H04161', 'Lacrimal gland dislocation, right lacrimal gland'),
    ('H04162', 'Lacrimal gland dislocation, left lacrimal gland'),
    ('H04163', 'Lacrimal gland dislocation, bilateral lacrimal glands'),
    ('H04169', 'Lacrimal gland dislocation, unspecified lacrimal gland'),
    ('H0419', 'Other specified disorders of lacrimal gland'),
    ('H04201', 'Unspecified epiphora, right side'),
    ('H04202', 'Unspecified epiphora, left side'),
    ('H04203', 'Unspecified epiphora, bilateral'),
    ('H04209', 'Unspecified epiphora, unspecified side'),
    ('H04211', 'Epiphora due to excess lacrimation, right lacrimal gland'),
    ('H04212', 'Epiphora due to excess lacrimation, left lacrimal gland'),
    ('H04213', 'Epiphora due to excess lacrimation, bi lacrimal glands'),
    ('H04219', 'Epiphora due to excess lacrimation, unsp lacrimal gland'),
    ('H04221', 'Epiphora due to insufficient drainage, right side'),
    ('H04222', 'Epiphora due to insufficient drainage, left side'),
    ('H04223', 'Epiphora due to insufficient drainage, bilateral'),
    ('H04229', 'Epiphora due to insufficient drainage, unspecified side'),
    ('H04301', 'Unspecified dacryocystitis of right lacrimal passage'),
    ('H04302', 'Unspecified dacryocystitis of left lacrimal passage'),
    ('H04303', 'Unspecified dacryocystitis of bilateral lacrimal passages'),
    ('H04309', 'Unspecified dacryocystitis of unspecified lacrimal passage'),
    ('H04311', 'Phlegmonous dacryocystitis of right lacrimal passage'),
    ('H04312', 'Phlegmonous dacryocystitis of left lacrimal passage'),
    ('H04313', 'Phlegmonous dacryocystitis of bilateral lacrimal passages'),
    ('H04319', 'Phlegmonous dacryocystitis of unspecified lacrimal passage'),
    ('H04321', 'Acute dacryocystitis of right lacrimal passage'),
    ('H04322', 'Acute dacryocystitis of left lacrimal passage'),
    ('H04323', 'Acute dacryocystitis of bilateral lacrimal passages'),
    ('H04329', 'Acute dacryocystitis of unspecified lacrimal passage'),
    ('H04331', 'Acute lacrimal canaliculitis of right lacrimal passage'),
    ('H04332', 'Acute lacrimal canaliculitis of left lacrimal passage'),
    ('H04333', 'Acute lacrimal canaliculitis of bilateral lacrimal passages'),
    ('H04339', 'Acute lacrimal canaliculitis of unspecified lacrimal passage'),
    ('H04411', 'Chronic dacryocystitis of right lacrimal passage'),
    ('H04412', 'Chronic dacryocystitis of left lacrimal passage'),
    ('H04413', 'Chronic dacryocystitis of bilateral lacrimal passages'),
    ('H04419', 'Chronic dacryocystitis of unspecified lacrimal passage'),
    ('H04421', 'Chronic lacrimal canaliculitis of right lacrimal passage'),
    ('H04422', 'Chronic lacrimal canaliculitis of left lacrimal passage'),
    ('H04423', 'Chronic lacrimal canaliculitis of bi lacrimal passages'),
    ('H04429', 'Chronic lacrimal canaliculitis of unsp lacrimal passage'),
    ('H04431', 'Chronic lacrimal mucocele of right lacrimal passage'),
    ('H04432', 'Chronic lacrimal mucocele of left lacrimal passage'),
    ('H04433', 'Chronic lacrimal mucocele of bilateral lacrimal passages'),
    ('H04439', 'Chronic lacrimal mucocele of unspecified lacrimal passage'),
    ('H04511', 'Dacryolith of right lacrimal passage'),
    ('H04512', 'Dacryolith of left lacrimal passage'),
    ('H04513', 'Dacryolith of bilateral lacrimal passages'),
    ('H04519', 'Dacryolith of unspecified lacrimal passage'),
    ('H04521', 'Eversion of right lacrimal punctum'),
    ('H04522', 'Eversion of left lacrimal punctum'),
    ('H04523', 'Eversion of bilateral lacrimal punctum'),
    ('H04529', 'Eversion of unspecified lacrimal punctum'),
    ('H04531', 'Neonatal obstruction of right nasolacrimal duct'),
    ('H04532', 'Neonatal obstruction of left nasolacrimal duct'),
    ('H04533', 'Neonatal obstruction of bilateral nasolacrimal duct'),
    ('H04539', 'Neonatal obstruction of unspecified nasolacrimal duct'),
    ('H04541', 'Stenosis of right lacrimal canaliculi'),
    ('H04542', 'Stenosis of left lacrimal canaliculi'),
    ('H04543', 'Stenosis of bilateral lacrimal canaliculi'),
    ('H04549', 'Stenosis of unspecified lacrimal canaliculi'),
    ('H04551', 'Acquired stenosis of right nasolacrimal duct'),
    ('H04552', 'Acquired stenosis of left nasolacrimal duct'),
    ('H04553', 'Acquired stenosis of bilateral nasolacrimal duct'),
    ('H04559', 'Acquired stenosis of unspecified nasolacrimal duct'),
    ('H04561', 'Stenosis of right lacrimal punctum'),
    ('H04562', 'Stenosis of left lacrimal punctum'),
    ('H04563', 'Stenosis of bilateral lacrimal punctum'),
    ('H04569', 'Stenosis of unspecified lacrimal punctum'),
    ('H04571', 'Stenosis of right lacrimal sac'),
    ('H04572', 'Stenosis of left lacrimal sac'),
    ('H04573', 'Stenosis of bilateral lacrimal sac'),
    ('H04579', 'Stenosis of unspecified lacrimal sac'),
    ('H04611', 'Lacrimal fistula right lacrimal passage'),
    ('H04612', 'Lacrimal fistula left lacrimal passage'),
    ('H04613', 'Lacrimal fistula bilateral lacrimal passages'),
    ('H04619', 'Lacrimal fistula unspecified lacrimal passage'),
    ('H0469', 'Other changes of lacrimal passages'),
    ('H04811', 'Granuloma of right lacrimal passage'),
    ('H04812', 'Granuloma of left lacrimal passage'),
    ('H04813', 'Granuloma of bilateral lacrimal passages'),
    ('H04819', 'Granuloma of unspecified lacrimal passage'),
    ('H0489', 'Other disorders of lacrimal system'),
    ('H049', 'Disorder of lacrimal system, unspecified'),
    ('H0500', 'Unspecified acute inflammation of orbit'),
    ('H05011', 'Cellulitis of right orbit'),
    ('H05012', 'Cellulitis of left orbit'),
    ('H05013', 'Cellulitis of bilateral orbits'),
    ('H05019', 'Cellulitis of unspecified orbit'),
    ('H05021', 'Osteomyelitis of right orbit'),
    ('H05022', 'Osteomyelitis of left orbit'),
    ('H05023', 'Osteomyelitis of bilateral orbits'),
    ('H05029', 'Osteomyelitis of unspecified orbit'),
    ('H05031', 'Periostitis of right orbit'),
    ('H05032', 'Periostitis of left orbit'),
    ('H05033', 'Periostitis of bilateral orbits'),
    ('H05039', 'Periostitis of unspecified orbit'),
    ('H05041', 'Tenonitis of right orbit'),
    ('H05042', 'Tenonitis of left orbit'),
    ('H05043', 'Tenonitis of bilateral orbits'),
    ('H05049', 'Tenonitis of unspecified orbit'),
    ('H0510', 'Unspecified chronic inflammatory disorders of orbit'),
    ('H05111', 'Granuloma of right orbit'),
    ('H05112', 'Granuloma of left orbit'),
    ('H05113', 'Granuloma of bilateral orbits'),
    ('H05119', 'Granuloma of unspecified orbit'),
    ('H05121', 'Orbital myositis, right orbit'),
    ('H05122', 'Orbital myositis, left orbit'),
    ('H05123', 'Orbital myositis, bilateral'),
    ('H05129', 'Orbital myositis, unspecified orbit'),
    ('H0520', 'Unspecified exophthalmos'),
    ('H05211', 'Displacement (lateral) of globe, right eye'),
    ('H05212', 'Displacement (lateral) of globe, left eye'),
    ('H05213', 'Displacement (lateral) of globe, bilateral'),
    ('H05219', 'Displacement (lateral) of globe, unspecified eye'),
    ('H05221', 'Edema of right orbit'),
    ('H05222', 'Edema of left orbit'),
    ('H05223', 'Edema of bilateral orbit'),
    ('H05229', 'Edema of unspecified orbit'),
    ('H05231', 'Hemorrhage of right orbit'),
    ('H05232', 'Hemorrhage of left orbit'),
    ('H05233', 'Hemorrhage of bilateral orbit'),
    ('H05239', 'Hemorrhage of unspecified orbit'),
    ('H05241', 'Constant exophthalmos, right eye'),
    ('H05242', 'Constant exophthalmos, left eye'),
    ('H05243', 'Constant exophthalmos, bilateral'),
    ('H05249', 'Constant exophthalmos, unspecified eye'),
    ('H05251', 'Intermittent exophthalmos, right eye'),
    ('H05252', 'Intermittent exophthalmos, left eye'),
    ('H05253', 'Intermittent exophthalmos, bilateral'),
    ('H05259', 'Intermittent exophthalmos, unspecified eye'),
    ('H05261', 'Pulsating exophthalmos, right eye'),
    ('H05262', 'Pulsating exophthalmos, left eye'),
    ('H05263', 'Pulsating exophthalmos, bilateral'),
    ('H05269', 'Pulsating exophthalmos, unspecified eye'),
    ('H0530', 'Unspecified deformity of orbit'),
    ('H05311', 'Atrophy of right orbit'),
    ('H05312', 'Atrophy of left orbit'),
    ('H05313', 'Atrophy of bilateral orbit'),
    ('H05319', 'Atrophy of unspecified orbit'),
    ('H05321', 'Deformity of right orbit due to bone disease'),
    ('H05322', 'Deformity of left orbit due to bone disease'),
    ('H05323', 'Deformity of bilateral orbits due to bone disease'),
    ('H05329', 'Deformity of unspecified orbit due to bone disease'),
    ('H05331', 'Deformity of right orbit due to trauma or surgery'),
    ('H05332', 'Deformity of left orbit due to trauma or surgery'),
    ('H05333', 'Deformity of bilateral orbits due to trauma or surgery'),
    ('H05339', 'Deformity of unspecified orbit due to trauma or surgery'),
    ('H05341', 'Enlargement of right orbit'),
    ('H05342', 'Enlargement of left orbit'),
    ('H05343', 'Enlargement of bilateral orbits'),
    ('H05349', 'Enlargement of unspecified orbit'),
    ('H05351', 'Exostosis of right orbit'),
    ('H05352', 'Exostosis of left orbit'),
    ('H05353', 'Exostosis of bilateral orbits'),
    ('H05359', 'Exostosis of unspecified orbit'),
    ('H05401', 'Unspecified enophthalmos, right eye'),
    ('H05402', 'Unspecified enophthalmos, left eye'),
    ('H05403', 'Unspecified enophthalmos, bilateral'),
    ('H05409', 'Unspecified enophthalmos, unspecified eye'),
    ('H05411', 'Enophthalmos due to atrophy of orbital tissue, right eye'),
    ('H05412', 'Enophthalmos due to atrophy of orbital tissue, left eye'),
    ('H05413', 'Enophthalmos due to atrophy of orbital tissue, bilateral'),
    ('H05419', 'Enophthalmos due to atrophy of orbital tissue, unsp eye'),
    ('H05421', 'Enophthalmos due to trauma or surgery, right eye'),
    ('H05422', 'Enophthalmos due to trauma or surgery, left eye'),
    ('H05423', 'Enophthalmos due to trauma or surgery, bilateral'),
    ('H05429', 'Enophthalmos due to trauma or surgery, unspecified eye'),
    ('H0550', 'Retained (old) fb following penetrating wound of unsp orbit'),
    ('H0551', 'Retained (old) fb following penetrating wound of right orbit'),
    ('H0552', 'Retained (old) fb following penetrating wound of left orbit'),
    ('H0553', 'Retained (old) fb following penetrating wound of bi orbit'),
    ('H05811', 'Cyst of right orbit'),
    ('H05812', 'Cyst of left orbit'),
    ('H05813', 'Cyst of bilateral orbits'),
    ('H05819', 'Cyst of unspecified orbit'),
    ('H05821', 'Myopathy of extraocular muscles, right orbit'),
    ('H05822', 'Myopathy of extraocular muscles, left orbit'),
    ('H05823', 'Myopathy of extraocular muscles, bilateral'),
    ('H05829', 'Myopathy of extraocular muscles, unspecified orbit'),
    ('H0589', 'Other disorders of orbit'),
    ('H059', 'Unspecified disorder of orbit'),
    ('H10011', 'Acute follicular conjunctivitis, right eye'),
    ('H10012', 'Acute follicular conjunctivitis, left eye'),
    ('H10013', 'Acute follicular conjunctivitis, bilateral'),
    ('H10019', 'Acute follicular conjunctivitis, unspecified eye'),
    ('H10021', 'Other mucopurulent conjunctivitis, right eye'),
    ('H10022', 'Other mucopurulent conjunctivitis, left eye'),
    ('H10023', 'Other mucopurulent conjunctivitis, bilateral'),
    ('H10029', 'Other mucopurulent conjunctivitis, unspecified eye'),
    ('H1010', 'Acute atopic conjunctivitis, unspecified eye'),
    ('H1011', 'Acute atopic conjunctivitis, right eye'),
    ('H1012', 'Acute atopic conjunctivitis, left eye'),
    ('H1013', 'Acute atopic conjunctivitis, bilateral'),
    ('H10211', 'Acute toxic conjunctivitis, right eye'),
    ('H10212', 'Acute toxic conjunctivitis, left eye'),
    ('H10213', 'Acute toxic conjunctivitis, bilateral'),
    ('H10219', 'Acute toxic conjunctivitis, unspecified eye'),
    ('H10221', 'Pseudomembranous conjunctivitis, right eye'),
    ('H10222', 'Pseudomembranous conjunctivitis, left eye'),
    ('H10223', 'Pseudomembranous conjunctivitis, bilateral'),
    ('H10229', 'Pseudomembranous conjunctivitis, unspecified eye'),
    ('H10231', 'Serous conjunctivitis, except viral, right eye'),
    ('H10232', 'Serous conjunctivitis, except viral, left eye'),
    ('H10233', 'Serous conjunctivitis, except viral, bilateral'),
    ('H10239', 'Serous conjunctivitis, except viral, unspecified eye'),
    ('H1030', 'Unspecified acute conjunctivitis, unspecified eye'),
    ('H1031', 'Unspecified acute conjunctivitis, right eye'),
    ('H1032', 'Unspecified acute conjunctivitis, left eye'),
    ('H1033', 'Unspecified acute conjunctivitis, bilateral'),
    ('H10401', 'Unspecified chronic conjunctivitis, right eye'),
    ('H10402', 'Unspecified chronic conjunctivitis, left eye'),
    ('H10403', 'Unspecified chronic conjunctivitis, bilateral'),
    ('H10409', 'Unspecified chronic conjunctivitis, unspecified eye'),
    ('H10411', 'Chronic giant papillary conjunctivitis, right eye'),
    ('H10412', 'Chronic giant papillary conjunctivitis, left eye'),
    ('H10413', 'Chronic giant papillary conjunctivitis, bilateral'),
    ('H10419', 'Chronic giant papillary conjunctivitis, unspecified eye'),
    ('H10421', 'Simple chronic conjunctivitis, right eye'),
    ('H10422', 'Simple chronic conjunctivitis, left eye'),
    ('H10423', 'Simple chronic conjunctivitis, bilateral'),
    ('H10429', 'Simple chronic conjunctivitis, unspecified eye'),
    ('H10431', 'Chronic follicular conjunctivitis, right eye'),
    ('H10432', 'Chronic follicular conjunctivitis, left eye'),
    ('H10433', 'Chronic follicular conjunctivitis, bilateral'),
    ('H10439', 'Chronic follicular conjunctivitis, unspecified eye'),
    ('H1044', 'Vernal conjunctivitis'),
    ('H1045', 'Other chronic allergic conjunctivitis'),
    ('H10501', 'Unspecified blepharoconjunctivitis, right eye'),
    ('H10502', 'Unspecified blepharoconjunctivitis, left eye'),
    ('H10503', 'Unspecified blepharoconjunctivitis, bilateral'),
    ('H10509', 'Unspecified blepharoconjunctivitis, unspecified eye'),
    ('H10511', 'Ligneous conjunctivitis, right eye'),
    ('H10512', 'Ligneous conjunctivitis, left eye'),
    ('H10513', 'Ligneous conjunctivitis, bilateral'),
    ('H10519', 'Ligneous conjunctivitis, unspecified eye'),
    ('H10521', 'Angular blepharoconjunctivitis, right eye'),
    ('H10522', 'Angular blepharoconjunctivitis, left eye'),
    ('H10523', 'Angular blepharoconjunctivitis, bilateral'),
    ('H10529', 'Angular blepharoconjunctivitis, unspecified eye'),
    ('H10531', 'Contact blepharoconjunctivitis, right eye'),
    ('H10532', 'Contact blepharoconjunctivitis, left eye'),
    ('H10533', 'Contact blepharoconjunctivitis, bilateral'),
    ('H10539', 'Contact blepharoconjunctivitis, unspecified eye'),
    ('H10811', 'Pingueculitis, right eye'),
    ('H10812', 'Pingueculitis, left eye'),
    ('H10813', 'Pingueculitis, bilateral'),
    ('H10819', 'Pingueculitis, unspecified eye'),
    ('H10821', 'Rosacea conjunctivitis, right eye'),
    ('H10822', 'Rosacea conjunctivitis, left eye'),
    ('H10823', 'Rosacea conjunctivitis, bilateral'),
    ('H10829', 'Rosacea conjunctivitis, unspecified eye'),
    ('H1089', 'Other conjunctivitis'),
    ('H109', 'Unspecified conjunctivitis'),
    ('H11001', 'Unspecified pterygium of right eye'),
    ('H11002', 'Unspecified pterygium of left eye'),
    ('H11003', 'Unspecified pterygium of eye, bilateral'),
    ('H11009', 'Unspecified pterygium of unspecified eye'),
    ('H11011', 'Amyloid pterygium of right eye'),
    ('H11012', 'Amyloid pterygium of left eye'),
    ('H11013', 'Amyloid pterygium of eye, bilateral'),
    ('H11019', 'Amyloid pterygium of unspecified eye'),
    ('H11021', 'Central pterygium of right eye'),
    ('H11022', 'Central pterygium of left eye'),
    ('H11023', 'Central pterygium of eye, bilateral'),
    ('H11029', 'Central pterygium of unspecified eye'),
    ('H11031', 'Double pterygium of right eye'),
    ('H11032', 'Double pterygium of left eye'),
    ('H11033', 'Double pterygium of eye, bilateral'),
    ('H11039', 'Double pterygium of unspecified eye'),
    ('H11041', 'Peripheral pterygium, stationary, right eye'),
    ('H11042', 'Peripheral pterygium, stationary, left eye'),
    ('H11043', 'Peripheral pterygium, stationary, bilateral'),
    ('H11049', 'Peripheral pterygium, stationary, unspecified eye'),
    ('H11051', 'Peripheral pterygium, progressive, right eye'),
    ('H11052', 'Peripheral pterygium, progressive, left eye'),
    ('H11053', 'Peripheral pterygium, progressive, bilateral'),
    ('H11059', 'Peripheral pterygium, progressive, unspecified eye'),
    ('H11061', 'Recurrent pterygium of right eye'),
    ('H11062', 'Recurrent pterygium of left eye'),
    ('H11063', 'Recurrent pterygium of eye, bilateral'),
    ('H11069', 'Recurrent pterygium of unspecified eye'),
    ('H1110', 'Unspecified conjunctival degenerations'),
    ('H11111', 'Conjunctival deposits, right eye'),
    ('H11112', 'Conjunctival deposits, left eye'),
    ('H11113', 'Conjunctival deposits, bilateral'),
    ('H11119', 'Conjunctival deposits, unspecified eye'),
    ('H11121', 'Conjunctival concretions, right eye'),
    ('H11122', 'Conjunctival concretions, left eye'),
    ('H11123', 'Conjunctival concretions, bilateral'),
    ('H11129', 'Conjunctival concretions, unspecified eye'),
    ('H11131', 'Conjunctival pigmentations, right eye'),
    ('H11132', 'Conjunctival pigmentations, left eye'),
    ('H11133', 'Conjunctival pigmentations, bilateral'),
    ('H11139', 'Conjunctival pigmentations, unspecified eye'),
    ('H11141', 'Conjunctival xerosis, unspecified, right eye'),
    ('H11142', 'Conjunctival xerosis, unspecified, left eye'),
    ('H11143', 'Conjunctival xerosis, unspecified, bilateral'),
    ('H11149', 'Conjunctival xerosis, unspecified, unspecified eye'),
    ('H11151', 'Pinguecula, right eye'),
    ('H11152', 'Pinguecula, left eye'),
    ('H11153', 'Pinguecula, bilateral'),
    ('H11159', 'Pinguecula, unspecified eye'),
    ('H11211', 'Conjunctival adhesions and strands (localized), right eye'),
    ('H11212', 'Conjunctival adhesions and strands (localized), left eye'),
    ('H11213', 'Conjunctival adhesions and strands (localized), bilateral'),
    ('H11219', 'Conjunctival adhesions and strands (localized), unsp eye'),
    ('H11221', 'Conjunctival granuloma, right eye'),
    ('H11222', 'Conjunctival granuloma, left eye'),
    ('H11223', 'Conjunctival granuloma, bilateral'),
    ('H11229', 'Conjunctival granuloma, unspecified'),
    ('H11231', 'Symblepharon, right eye'),
    ('H11232', 'Symblepharon, left eye'),
    ('H11233', 'Symblepharon, bilateral'),
    ('H11239', 'Symblepharon, unspecified eye'),
    ('H11241', 'Scarring of conjunctiva, right eye'),
    ('H11242', 'Scarring of conjunctiva, left eye'),
    ('H11243', 'Scarring of conjunctiva, bilateral'),
    ('H11249', 'Scarring of conjunctiva, unspecified eye'),
    ('H1130', 'Conjunctival hemorrhage, unspecified eye'),
    ('H1131', 'Conjunctival hemorrhage, right eye'),
    ('H1132', 'Conjunctival hemorrhage, left eye'),
    ('H1133', 'Conjunctival hemorrhage, bilateral'),
    ('H11411', 'Vascular abnormalities of conjunctiva, right eye'),
    ('H11412', 'Vascular abnormalities of conjunctiva, left eye'),
    ('H11413', 'Vascular abnormalities of conjunctiva, bilateral'),
    ('H11419', 'Vascular abnormalities of conjunctiva, unspecified eye'),
    ('H11421', 'Conjunctival edema, right eye'),
    ('H11422', 'Conjunctival edema, left eye'),
    ('H11423', 'Conjunctival edema, bilateral'),
    ('H11429', 'Conjunctival edema, unspecified eye'),
    ('H11431', 'Conjunctival hyperemia, right eye'),
    ('H11432', 'Conjunctival hyperemia, left eye'),
    ('H11433', 'Conjunctival hyperemia, bilateral'),
    ('H11439', 'Conjunctival hyperemia, unspecified eye'),
    ('H11441', 'Conjunctival cysts, right eye'),
    ('H11442', 'Conjunctival cysts, left eye'),
    ('H11443', 'Conjunctival cysts, bilateral'),
    ('H11449', 'Conjunctival cysts, unspecified eye'),
    ('H11811', 'Pseudopterygium of conjunctiva, right eye'),
    ('H11812', 'Pseudopterygium of conjunctiva, left eye'),
    ('H11813', 'Pseudopterygium of conjunctiva, bilateral'),
    ('H11819', 'Pseudopterygium of conjunctiva, unspecified eye'),
    ('H11821', 'Conjunctivochalasis, right eye'),
    ('H11822', 'Conjunctivochalasis, left eye'),
    ('H11823', 'Conjunctivochalasis, bilateral'),
    ('H11829', 'Conjunctivochalasis, unspecified eye'),
    ('H1189', 'Other specified disorders of conjunctiva'),
    ('H119', 'Unspecified disorder of conjunctiva'),
    ('H15001', 'Unspecified scleritis, right eye'),
    ('H15002', 'Unspecified scleritis, left eye'),
    ('H15003', 'Unspecified scleritis, bilateral'),
    ('H15009', 'Unspecified scleritis, unspecified eye'),
    ('H15011', 'Anterior scleritis, right eye'),
    ('H15012', 'Anterior scleritis, left eye'),
    ('H15013', 'Anterior scleritis, bilateral'),
    ('H15019', 'Anterior scleritis, unspecified eye'),
    ('H15021', 'Brawny scleritis, right eye'),
    ('H15022', 'Brawny scleritis, left eye'),
    ('H15023', 'Brawny scleritis, bilateral'),
    ('H15029', 'Brawny scleritis, unspecified eye'),
    ('H15031', 'Posterior scleritis, right eye'),
    ('H15032', 'Posterior scleritis, left eye'),
    ('H15033', 'Posterior scleritis, bilateral'),
    ('H15039', 'Posterior scleritis, unspecified eye'),
    ('H15041', 'Scleritis with corneal involvement, right eye'),
    ('H15042', 'Scleritis with corneal involvement, left eye'),
    ('H15043', 'Scleritis with corneal involvement, bilateral'),
    ('H15049', 'Scleritis with corneal involvement, unspecified eye'),
    ('H15051', 'Scleromalacia perforans, right eye'),
    ('H15052', 'Scleromalacia perforans, left eye'),
    ('H15053', 'Scleromalacia perforans, bilateral'),
    ('H15059', 'Scleromalacia perforans, unspecified eye'),
    ('H15091', 'Other scleritis, right eye'),
    ('H15092', 'Other scleritis, left eye'),
    ('H15093', 'Other scleritis, bilateral'),
    ('H15099', 'Other scleritis, unspecified eye'),
    ('H15101', 'Unspecified episcleritis, right eye'),
    ('H15102', 'Unspecified episcleritis, left eye'),
    ('H15103', 'Unspecified episcleritis, bilateral'),
    ('H15109', 'Unspecified episcleritis, unspecified eye'),
    ('H15111', 'Episcleritis periodica fugax, right eye'),
    ('H15112', 'Episcleritis periodica fugax, left eye'),
    ('H15113', 'Episcleritis periodica fugax, bilateral'),
    ('H15119', 'Episcleritis periodica fugax, unspecified eye'),
    ('H15121', 'Nodular episcleritis, right eye'),
    ('H15122', 'Nodular episcleritis, left eye'),
    ('H15123', 'Nodular episcleritis, bilateral'),
    ('H15129', 'Nodular episcleritis, unspecified eye'),
    ('H15811', 'Equatorial staphyloma, right eye'),
    ('H15812', 'Equatorial staphyloma, left eye'),
    ('H15813', 'Equatorial staphyloma, bilateral'),
    ('H15819', 'Equatorial staphyloma, unspecified eye'),
    ('H15821', 'Localized anterior staphyloma, right eye'),
    ('H15822', 'Localized anterior staphyloma, left eye'),
    ('H15823', 'Localized anterior staphyloma, bilateral'),
    ('H15829', 'Localized anterior staphyloma, unspecified eye'),
    ('H15831', 'Staphyloma posticum, right eye'),
    ('H15832', 'Staphyloma posticum, left eye'),
    ('H15833', 'Staphyloma posticum, bilateral'),
    ('H15839', 'Staphyloma posticum, unspecified eye'),
    ('H15841', 'Scleral ectasia, right eye'),
    ('H15842', 'Scleral ectasia, left eye'),
    ('H15843', 'Scleral ectasia, bilateral'),
    ('H15849', 'Scleral ectasia, unspecified eye'),
    ('H15851', 'Ring staphyloma, right eye'),
    ('H15852', 'Ring staphyloma, left eye'),
    ('H15853', 'Ring staphyloma, bilateral'),
    ('H15859', 'Ring staphyloma, unspecified eye'),
    ('H1589', 'Other disorders of sclera'),
    ('H159', 'Unspecified disorder of sclera'),
    ('H16001', 'Unspecified corneal ulcer, right eye'),
    ('H16002', 'Unspecified corneal ulcer, left eye'),
    ('H16003', 'Unspecified corneal ulcer, bilateral'),
    ('H16009', 'Unspecified corneal ulcer, unspecified eye'),
    ('H16011', 'Central corneal ulcer, right eye'),
    ('H16012', 'Central corneal ulcer, left eye'),
    ('H16013', 'Central corneal ulcer, bilateral'),
    ('H16019', 'Central corneal ulcer, unspecified eye'),
    ('H16021', 'Ring corneal ulcer, right eye'),
    ('H16022', 'Ring corneal ulcer, left eye'),
    ('H16023', 'Ring corneal ulcer, bilateral'),
    ('H16029', 'Ring corneal ulcer, unspecified eye'),
    ('H16031', 'Corneal ulcer with hypopyon, right eye'),
    ('H16032', 'Corneal ulcer with hypopyon, left eye'),
    ('H16033', 'Corneal ulcer with hypopyon, bilateral'),
    ('H16039', 'Corneal ulcer with hypopyon, unspecified eye'),
    ('H16041', 'Marginal corneal ulcer, right eye'),
    ('H16042', 'Marginal corneal ulcer, left eye'),
    ('H16043', 'Marginal corneal ulcer, bilateral'),
    ('H16049', 'Marginal corneal ulcer, unspecified eye'),
    ('H16051', "Mooren's corneal ulcer, right eye"),
    ('H16052', "Mooren's corneal ulcer, left eye"),
    ('H16053', "Mooren's corneal ulcer, bilateral"),
    ('H16059', "Mooren's corneal ulcer, unspecified eye"),
    ('H16061', 'Mycotic corneal ulcer, right eye'),
    ('H16062', 'Mycotic corneal ulcer, left eye'),
    ('H16063', 'Mycotic corneal ulcer, bilateral'),
    ('H16069', 'Mycotic corneal ulcer, unspecified eye'),
    ('H16071', 'Perforated corneal ulcer, right eye'),
    ('H16072', 'Perforated corneal ulcer, left eye'),
    ('H16073', 'Perforated corneal ulcer, bilateral'),
    ('H16079', 'Perforated corneal ulcer, unspecified eye'),
    ('H16101', 'Unspecified superficial keratitis, right eye'),
    ('H16102', 'Unspecified superficial keratitis, left eye'),
    ('H16103', 'Unspecified superficial keratitis, bilateral'),
    ('H16109', 'Unspecified superficial keratitis, unspecified eye'),
    ('H16111', 'Macular keratitis, right eye'),
    ('H16112', 'Macular keratitis, left eye'),
    ('H16113', 'Macular keratitis, bilateral'),
    ('H16119', 'Macular keratitis, unspecified eye'),
    ('H16121', 'Filamentary keratitis, right eye'),
    ('H16122', 'Filamentary keratitis, left eye'),
    ('H16123', 'Filamentary keratitis, bilateral'),
    ('H16129', 'Filamentary keratitis, unspecified eye'),
    ('H16131', 'Photokeratitis, right eye'),
    ('H16132', 'Photokeratitis, left eye'),
    ('H16133', 'Photokeratitis, bilateral'),
    ('H16139', 'Photokeratitis, unspecified eye'),
    ('H16141', 'Punctate keratitis, right eye'),
    ('H16142', 'Punctate keratitis, left eye'),
    ('H16143', 'Punctate keratitis, bilateral'),
    ('H16149', 'Punctate keratitis, unspecified eye'),
    ('H16201', 'Unspecified keratoconjunctivitis, right eye'),
    ('H16202', 'Unspecified keratoconjunctivitis, left eye'),
    ('H16203', 'Unspecified keratoconjunctivitis, bilateral'),
    ('H16209', 'Unspecified keratoconjunctivitis, unspecified eye'),
    ('H16211', 'Exposure keratoconjunctivitis, right eye'),
    ('H16212', 'Exposure keratoconjunctivitis, left eye'),
    ('H16213', 'Exposure keratoconjunctivitis, bilateral'),
    ('H16219', 'Exposure keratoconjunctivitis, unspecified eye'),
    ('H16221', "Keratoconjunct sicca, not specified as Sjogren's, right eye"),
    ('H16222', "Keratoconjunct sicca, not specified as Sjogren's, left eye"),
    ('H16223', "Keratoconjunct sicca, not specified as Sjogren's, bilateral"),
    ('H16229', "Keratoconjunct sicca, not specified as Sjogren's, unsp eye"),
    ('H16231', 'Neurotrophic keratoconjunctivitis, right eye'),
    ('H16232', 'Neurotrophic keratoconjunctivitis, left eye'),
    ('H16233', 'Neurotrophic keratoconjunctivitis, bilateral'),
    ('H16239', 'Neurotrophic keratoconjunctivitis, unspecified eye'),
    ('H16241', 'Ophthalmia nodosa, right eye'),
    ('H16242', 'Ophthalmia nodosa, left eye'),
    ('H16243', 'Ophthalmia nodosa, bilateral'),
    ('H16249', 'Ophthalmia nodosa, unspecified eye'),
    ('H16251', 'Phlyctenular keratoconjunctivitis, right eye'),
    ('H16252', 'Phlyctenular keratoconjunctivitis, left eye'),
    ('H16253', 'Phlyctenular keratoconjunctivitis, bilateral'),
    ('H16259', 'Phlyctenular keratoconjunctivitis, unspecified eye'),
    ('H16261', 'Vernal keratoconjunct, w limbar and corneal involv, r eye'),
    ('H16262', 'Vernal keratoconjunct, w limbar and corneal involv, left eye'),
    ('H16263', 'Vernal keratoconjunct, w limbar and corneal involv, bi'),
    ('H16269', 'Vernal keratoconjunct, w limbar and corneal involv, unsp eye'),
    ('H16291', 'Other keratoconjunctivitis, right eye'),
    ('H16292', 'Other keratoconjunctivitis, left eye'),
    ('H16293', 'Other keratoconjunctivitis, bilateral'),
    ('H16299', 'Other keratoconjunctivitis, unspecified eye'),
    ('H16301', 'Unspecified interstitial keratitis, right eye'),
    ('H16302', 'Unspecified interstitial keratitis, left eye'),
    ('H16303', 'Unspecified interstitial keratitis, bilateral'),
    ('H16309', 'Unspecified interstitial keratitis, unspecified eye'),
    ('H16311', 'Corneal abscess, right eye'),
    ('H16312', 'Corneal abscess, left eye'),
    ('H16313', 'Corneal abscess, bilateral'),
    ('H16319', 'Corneal abscess, unspecified eye'),
    ('H16321', 'Diffuse interstitial keratitis, right eye'),
    ('H16322', 'Diffuse interstitial keratitis, left eye'),
    ('H16323', 'Diffuse interstitial keratitis, bilateral'),
    ('H16329', 'Diffuse interstitial keratitis, unspecified eye'),
    ('H16331', 'Sclerosing keratitis, right eye'),
    ('H16332', 'Sclerosing keratitis, left eye'),
    ('H16333', 'Sclerosing keratitis, bilateral'),
    ('H16339', 'Sclerosing keratitis, unspecified eye'),
    ('H16391', 'Other interstitial and deep keratitis, right eye'),
    ('H16392', 'Other interstitial and deep keratitis, left eye'),
    ('H16393', 'Other interstitial and deep keratitis, bilateral'),
    ('H16399', 'Other interstitial and deep keratitis, unspecified eye'),
    ('H16401', 'Unspecified corneal neovascularization, right eye'),
    ('H16402', 'Unspecified corneal neovascularization, left eye'),
    ('H16403', 'Unspecified corneal neovascularization, bilateral'),
    ('H16409', 'Unspecified corneal neovascularization, unspecified eye'),
    ('H16411', 'Ghost vessels (corneal), right eye'),
    ('H16412', 'Ghost vessels (corneal), left eye'),
    ('H16413', 'Ghost vessels (corneal), bilateral'),
    ('H16419', 'Ghost vessels (corneal), unspecified eye'),
    ('H16421', 'Pannus (corneal), right eye'),
    ('H16422', 'Pannus (corneal), left eye'),
    ('H16423', 'Pannus (corneal), bilateral'),
    ('H16429', 'Pannus (corneal), unspecified eye'),
    ('H16431', 'Localized vascularization of cornea, right eye'),
    ('H16432', 'Localized vascularization of cornea, left eye'),
    ('H16433', 'Localized vascularization of cornea, bilateral'),
    ('H16439', 'Localized vascularization of cornea, unspecified eye'),
    ('H16441', 'Deep vascularization of cornea, right eye'),
    ('H16442', 'Deep vascularization of cornea, left eye'),
    ('H16443', 'Deep vascularization of cornea, bilateral'),
    ('H16449', 'Deep vascularization of cornea, unspecified eye'),
    ('H168', 'Other keratitis'),
    ('H169', 'Unspecified keratitis'),
    ('H1700', 'Adherent leukoma, unspecified eye'),
    ('H1701', 'Adherent leukoma, right eye'),
    ('H1702', 'Adherent leukoma, left eye'),
    ('H1703', 'Adherent leukoma, bilateral'),
    ('H1710', 'Central corneal opacity, unspecified eye'),
    ('H1711', 'Central corneal opacity, right eye'),
    ('H1712', 'Central corneal opacity, left eye'),
    ('H1713', 'Central corneal opacity, bilateral'),
    ('H17811', 'Minor opacity of cornea, right eye'),
    ('H17812', 'Minor opacity of cornea, left eye'),
    ('H17813', 'Minor opacity of cornea, bilateral'),
    ('H17819', 'Minor opacity of cornea, unspecified eye'),
    ('H17821', 'Peripheral opacity of cornea, right eye'),
    ('H17822', 'Peripheral opacity of cornea, left eye'),
    ('H17823', 'Peripheral opacity of cornea, bilateral'),
    ('H17829', 'Peripheral opacity of cornea, unspecified eye'),
    ('H1789', 'Other corneal scars and opacities'),
    ('H179', 'Unspecified corneal scar and opacity'),
    ('H18001', 'Unspecified corneal deposit, right eye'),
    ('H18002', 'Unspecified corneal deposit, left eye'),
    ('H18003', 'Unspecified corneal deposit, bilateral'),
    ('H18009', 'Unspecified corneal deposit, unspecified eye'),
    ('H18011', 'Anterior corneal pigmentations, right eye'),
    ('H18012', 'Anterior corneal pigmentations, left eye'),
    ('H18013', 'Anterior corneal pigmentations, bilateral'),
    ('H18019', 'Anterior corneal pigmentations, unspecified eye'),
    ('H18021', 'Argentous corneal deposits, right eye'),
    ('H18022', 'Argentous corneal deposits, left eye'),
    ('H18023', 'Argentous corneal deposits, bilateral'),
    ('H18029', 'Argentous corneal deposits, unspecified eye'),
    ('H18031', 'Corneal deposits in metabolic disorders, right eye'),
    ('H18032', 'Corneal deposits in metabolic disorders, left eye'),
    ('H18033', 'Corneal deposits in metabolic disorders, bilateral'),
    ('H18039', 'Corneal deposits in metabolic disorders, unspecified eye'),
    ('H18041', 'Kayser-Fleischer ring, right eye'),
    ('H18042', 'Kayser-Fleischer ring, left eye'),
    ('H18043', 'Kayser-Fleischer ring, bilateral'),
    ('H18049', 'Kayser-Fleischer ring, unspecified eye'),
    ('H18051', 'Posterior corneal pigmentations, right eye'),
    ('H18052', 'Posterior corneal pigmentations, left eye'),
    ('H18053', 'Posterior corneal pigmentations, bilateral'),
    ('H18059', 'Posterior corneal pigmentations, unspecified eye'),
    ('H18061', 'Stromal corneal pigmentations, right eye'),
    ('H18062', 'Stromal corneal pigmentations, left eye'),
    ('H18063', 'Stromal corneal pigmentations, bilateral'),
    ('H18069', 'Stromal corneal pigmentations, unspecified eye'),
    ('H1810', 'Bullous keratopathy, unspecified eye'),
    ('H1811', 'Bullous keratopathy, right eye'),
    ('H1812', 'Bullous keratopathy, left eye'),
    ('H1813', 'Bullous keratopathy, bilateral'),
    ('H1820', 'Unspecified corneal edema'),
    ('H18211', 'Corneal edema secondary to contact lens, right eye'),
    ('H18212', 'Corneal edema secondary to contact lens, left eye'),
    ('H18213', 'Corneal edema secondary to contact lens, bilateral'),
    ('H18219', 'Corneal edema secondary to contact lens, unspecified eye'),
    ('H18221', 'Idiopathic corneal edema, right eye'),
    ('H18222', 'Idiopathic corneal edema, left eye'),
    ('H18223', 'Idiopathic corneal edema, bilateral'),
    ('H18229', 'Idiopathic corneal edema, unspecified eye'),
    ('H18231', 'Secondary corneal edema, right eye'),
    ('H18232', 'Secondary corneal edema, left eye'),
    ('H18233', 'Secondary corneal edema, bilateral'),
    ('H18239', 'Secondary corneal edema, unspecified eye'),
    ('H1830', 'Unspecified corneal membrane change'),
    ('H18311', "Folds and rupture in Bowman's membrane, right eye"),
    ('H18312', "Folds and rupture in Bowman's membrane, left eye"),
    ('H18313', "Folds and rupture in Bowman's membrane, bilateral"),
    ('H18319', "Folds and rupture in Bowman's membrane, unspecified eye"),
    ('H18321', "Folds in Descemet's membrane, right eye"),
    ('H18322', "Folds in Descemet's membrane, left eye"),
    ('H18323', "Folds in Descemet's membrane, bilateral"),
    ('H18329', "Folds in Descemet's membrane, unspecified eye"),
    ('H18331', "Rupture in Descemet's membrane, right eye"),
    ('H18332', "Rupture in Descemet's membrane, left eye"),
    ('H18333', "Rupture in Descemet's membrane, bilateral"),
    ('H18339', "Rupture in Descemet's membrane, unspecified eye"),
    ('H1840', 'Unspecified corneal degeneration'),
    ('H18411', 'Arcus senilis, right eye'),
    ('H18412', 'Arcus senilis, left eye'),
    ('H18413', 'Arcus senilis, bilateral'),
    ('H18419', 'Arcus senilis, unspecified eye'),
    ('H18421', 'Band keratopathy, right eye'),
    ('H18422', 'Band keratopathy, left eye'),
    ('H18423', 'Band keratopathy, bilateral'),
    ('H18429', 'Band keratopathy, unspecified eye'),
    ('H1843', 'Other calcerous corneal degeneration'),
    ('H18441', 'Keratomalacia, right eye'),
    ('H18442', 'Keratomalacia, left eye'),
    ('H18443', 'Keratomalacia, bilateral'),
    ('H18449', 'Keratomalacia, unspecified eye'),
    ('H18451', 'Nodular corneal degeneration, right eye'),
    ('H18452', 'Nodular corneal degeneration, left eye'),
    ('H18453', 'Nodular corneal degeneration, bilateral'),
    ('H18459', 'Nodular corneal degeneration, unspecified eye'),
    ('H18461', 'Peripheral corneal degeneration, right eye'),
    ('H18462', 'Peripheral corneal degeneration, left eye'),
    ('H18463', 'Peripheral corneal degeneration, bilateral'),
    ('H18469', 'Peripheral corneal degeneration, unspecified eye'),
    ('H1849', 'Other corneal degeneration'),
    ('H1850', 'Unspecified hereditary corneal dystrophies'),
    ('H18501', 'Unspecified hereditary corneal dystrophies, right eye'),
    ('H18502', 'Unspecified hereditary corneal dystrophies, left eye'),
    ('H18503', 'Unspecified hereditary corneal dystrophies, bilateral'),
    ('H18509', 'Unspecified hereditary corneal dystrophies, unspecified eye'),
    ('H1851', 'Endothelial corneal dystrophy'),
    ('H18511', 'Endothelial corneal dystrophy, right eye'),
    ('H18512', 'Endothelial corneal dystrophy, left eye'),
    ('H18513', 'Endothelial corneal dystrophy, bilateral'),
    ('H18519', 'Endothelial corneal dystrophy, unspecified eye'),
    ('H1852', 'Epithelial (juvenile) corneal dystrophy'),
    ('H18521', 'Epithelial (juvenile) corneal dystrophy, right eye'),
    ('H18522', 'Epithelial (juvenile) corneal dystrophy, left eye'),
    ('H18523', 'Epithelial (juvenile) corneal dystrophy, bilateral'),
    ('H18529', 'Epithelial (juvenile) corneal dystrophy, unspecified eye'),
    ('H1853', 'Granular corneal dystrophy'),
    ('H18531', 'Granular corneal dystrophy, right eye'),
    ('H18532', 'Granular corneal dystrophy, left eye'),
    ('H18533', 'Granular corneal dystrophy, bilateral'),
    ('H18539', 'Granular corneal dystrophy, unspecified eye'),
    ('H1854', 'Lattice corneal dystrophy'),
    ('H18541', 'Lattice corneal dystrophy, right eye'),
    ('H18542', 'Lattice corneal dystrophy, left eye'),
    ('H18543', 'Lattice corneal dystrophy, bilateral'),
    ('H18549', 'Lattice corneal dystrophy, unspecified eye'),
    ('H1855', 'Macular corneal dystrophy'),
    ('H18551', 'Macular corneal dystrophy, right eye'),
    ('H18552', 'Macular corneal dystrophy, left eye'),
    ('H18553', 'Macular corneal dystrophy, bilateral'),
    ('H18559', 'Macular corneal dystrophy, unspecified eye'),
    ('H1859', 'Other hereditary corneal dystrophies'),
    ('H18591', 'Other hereditary corneal dystrophies, right eye'),
    ('H18592', 'Other hereditary corneal dystrophies, left eye'),
    ('H18593', 'Other hereditary corneal dystrophies, bilateral'),
    ('H18599', 'Other hereditary corneal dystrophies, unspecified eye'),
    ('H18601', 'Keratoconus, unspecified, right eye'),
    ('H18602', 'Keratoconus, unspecified, left eye'),
    ('H18603', 'Keratoconus, unspecified, bilateral'),
    ('H18609', 'Keratoconus, unspecified, unspecified eye'),
    ('H18611', 'Keratoconus, stable, right eye'),
    ('H18612', 'Keratoconus, stable, left eye'),
    ('H18613', 'Keratoconus, stable, bilateral'),
    ('H18619', 'Keratoconus, stable, unspecified eye'),
    ('H18621', 'Keratoconus, unstable, right eye'),
    ('H18622', 'Keratoconus, unstable, left eye'),
    ('H18623', 'Keratoconus, unstable, bilateral'),
    ('H18629', 'Keratoconus, unstable, unspecified eye'),
    ('H1870', 'Unspecified corneal deformity'),
    ('H18711', 'Corneal ectasia, right eye'),
    ('H18712', 'Corneal ectasia, left eye'),
    ('H18713', 'Corneal ectasia, bilateral'),
    ('H18719', 'Corneal ectasia, unspecified eye'),
    ('H18721', 'Corneal staphyloma, right eye'),
    ('H18722', 'Corneal staphyloma, left eye'),
    ('H18723', 'Corneal staphyloma, bilateral'),
    ('H18729', 'Corneal staphyloma, unspecified eye'),
    ('H18731', 'Descemetocele, right eye'),
    ('H18732', 'Descemetocele, left eye'),
    ('H18733', 'Descemetocele, bilateral'),
    ('H18739', 'Descemetocele, unspecified eye'),
    ('H18791', 'Other corneal deformities, right eye'),
    ('H18792', 'Other corneal deformities, left eye'),
    ('H18793', 'Other corneal deformities, bilateral'),
    ('H18799', 'Other corneal deformities, unspecified eye'),
    ('H18811', 'Anesthesia and hypoesthesia of cornea, right eye'),
    ('H18812', 'Anesthesia and hypoesthesia of cornea, left eye'),
    ('H18813', 'Anesthesia and hypoesthesia of cornea, bilateral'),
    ('H18819', 'Anesthesia and hypoesthesia of cornea, unspecified eye'),
    ('H18821', 'Corneal disorder due to contact lens, right eye'),
    ('H18822', 'Corneal disorder due to contact lens, left eye'),
    ('H18823', 'Corneal disorder due to contact lens, bilateral'),
    ('H18829', 'Corneal disorder due to contact lens, unspecified eye'),
    ('H18831', 'Recurrent erosion of cornea, right eye'),
    ('H18832', 'Recurrent erosion of cornea, left eye'),
    ('H18833', 'Recurrent erosion of cornea, bilateral'),
    ('H18839', 'Recurrent erosion of cornea, unspecified eye'),
    ('H18891', 'Other specified disorders of cornea, right eye'),
    ('H18892', 'Other specified disorders of cornea, left eye'),
    ('H18893', 'Other specified disorders of cornea, bilateral'),
    ('H18899', 'Other specified disorders of cornea, unspecified eye'),
    ('H189', 'Unspecified disorder of cornea'),
    ('H2000', 'Unspecified acute and subacute iridocyclitis'),
    ('H20011', 'Primary iridocyclitis, right eye'),
    ('H20012', 'Primary iridocyclitis, left eye'),
    ('H20013', 'Primary iridocyclitis, bilateral'),
    ('H20019', 'Primary iridocyclitis, unspecified eye'),
    ('H20021', 'Recurrent acute iridocyclitis, right eye'),
    ('H20022', 'Recurrent acute iridocyclitis, left eye'),
    ('H20023', 'Recurrent acute iridocyclitis, bilateral'),
    ('H20029', 'Recurrent acute iridocyclitis, unspecified eye'),
    ('H20031', 'Secondary infectious iridocyclitis, right eye'),
    ('H20032', 'Secondary infectious iridocyclitis, left eye'),
    ('H20033', 'Secondary infectious iridocyclitis, bilateral'),
    ('H20039', 'Secondary infectious iridocyclitis, unspecified eye'),
    ('H20041', 'Secondary noninfectious iridocyclitis, right eye'),
    ('H20042', 'Secondary noninfectious iridocyclitis, left eye'),
    ('H20043', 'Secondary noninfectious iridocyclitis, bilateral'),
    ('H20049', 'Secondary noninfectious iridocyclitis, unspecified eye'),
    ('H20051', 'Hypopyon, right eye'),
    ('H20052', 'Hypopyon, left eye'),
    ('H20053', 'Hypopyon, bilateral'),
    ('H20059', 'Hypopyon, unspecified eye'),
    ('H2010', 'Chronic iridocyclitis, unspecified eye'),
    ('H2011', 'Chronic iridocyclitis, right eye'),
    ('H2012', 'Chronic iridocyclitis, left eye'),
    ('H2013', 'Chronic iridocyclitis, bilateral'),
    ('H2020', 'Lens-induced iridocyclitis, unspecified eye'),
    ('H2021', 'Lens-induced iridocyclitis, right eye'),
    ('H2022', 'Lens-induced iridocyclitis, left eye'),
    ('H2023', 'Lens-induced iridocyclitis, bilateral'),
    ('H20811', "Fuchs' heterochromic cyclitis, right eye"),
    ('H20812', "Fuchs' heterochromic cyclitis, left eye"),
    ('H20813', "Fuchs' heterochromic cyclitis, bilateral"),
    ('H20819', "Fuchs' heterochromic cyclitis, unspecified eye"),
    ('H20821', 'Vogt-Koyanagi syndrome, right eye'),
    ('H20822', 'Vogt-Koyanagi syndrome, left eye'),
    ('H20823', 'Vogt-Koyanagi syndrome, bilateral'),
    ('H20829', 'Vogt-Koyanagi syndrome, unspecified eye'),
    ('H209', 'Unspecified iridocyclitis'),
    ('H2100', 'Hyphema, unspecified eye'),
    ('H2101', 'Hyphema, right eye'),
    ('H2102', 'Hyphema, left eye'),
    ('H2103', 'Hyphema, bilateral'),
    ('H211X1', 'Other vascular disorders of iris and ciliary body, right eye'),
    ('H211X2', 'Other vascular disorders of iris and ciliary body, left eye'),
    ('H211X3', 'Other vascular disorders of iris and ciliary body, bilateral'),
    ('H211X9', 'Other vascular disorders of iris and ciliary body, unsp eye'),
    ('H21211', 'Degeneration of chamber angle, right eye'),
    ('H21212', 'Degeneration of chamber angle, left eye'),
    ('H21213', 'Degeneration of chamber angle, bilateral'),
    ('H21219', 'Degeneration of chamber angle, unspecified eye'),
    ('H21221', 'Degeneration of ciliary body, right eye'),
    ('H21222', 'Degeneration of ciliary body, left eye'),
    ('H21223', 'Degeneration of ciliary body, bilateral'),
    ('H21229', 'Degeneration of ciliary body, unspecified eye'),
    ('H21231', 'Degeneration of iris (pigmentary), right eye'),
    ('H21232', 'Degeneration of iris (pigmentary), left eye'),
    ('H21233', 'Degeneration of iris (pigmentary), bilateral'),
    ('H21239', 'Degeneration of iris (pigmentary), unspecified eye'),
    ('H21241', 'Degeneration of pupillary margin, right eye'),
    ('H21242', 'Degeneration of pupillary margin, left eye'),
    ('H21243', 'Degeneration of pupillary margin, bilateral'),
    ('H21249', 'Degeneration of pupillary margin, unspecified eye'),
    ('H21251', 'Iridoschisis, right eye'),
    ('H21252', 'Iridoschisis, left eye'),
    ('H21253', 'Iridoschisis, bilateral'),
    ('H21259', 'Iridoschisis, unspecified eye'),
    ('H21261', 'Iris atrophy (essential) (progressive), right eye'),
    ('H21262', 'Iris atrophy (essential) (progressive), left eye'),
    ('H21263', 'Iris atrophy (essential) (progressive), bilateral'),
    ('H21269', 'Iris atrophy (essential) (progressive), unspecified eye'),
    ('H21271', 'Miotic pupillary cyst, right eye'),
    ('H21272', 'Miotic pupillary cyst, left eye'),
    ('H21273', 'Miotic pupillary cyst, bilateral'),
    ('H21279', 'Miotic pupillary cyst, unspecified eye'),
    ('H2129', 'Other iris atrophy'),
    ('H21301', 'Idio cysts of iris, ciliary body or ant chamber, right eye'),
    ('H21302', 'Idio cysts of iris, ciliary body or ant chamber, left eye'),
    ('H21303', 'Idio cysts of iris, ciliary body or ant chamber, bilateral'),
    ('H21309', 'Idio cysts of iris, ciliary body or ant chamber, unsp eye'),
    ('H21311', 'Exudative cysts of iris or anterior chamber, right eye'),
    ('H21312', 'Exudative cysts of iris or anterior chamber, left eye'),
    ('H21313', 'Exudative cysts of iris or anterior chamber, bilateral'),
    ('H21319', 'Exudative cysts of iris or anterior chamber, unspecified eye'),
    ('H21321', 'Implant cysts of iris, ciliary body or ant chamber, r eye'),
    ('H21322', 'Implant cysts of iris, ciliary body or ant chamber, left eye'),
    ('H21323', 'Implant cysts of iris, ciliary body or ant chamber, bi'),
    ('H21329', 'Implant cysts of iris, ciliary body or ant chamber, unsp eye'),
    ('H21331', 'Parastc cyst of iris, ciliary body or ant chamber, right eye'),
    ('H21332', 'Parastc cyst of iris, ciliary body or ant chamber, left eye'),
    ('H21333', 'Parasitic cyst of iris, ciliary body or ant chamber, bi'),
    ('H21339', 'Parastc cyst of iris, ciliary body or ant chamber, unsp eye'),
    ('H21341', 'Primary cyst of pars plana, right eye'),
    ('H21342', 'Primary cyst of pars plana, left eye'),
    ('H21343', 'Primary cyst of pars plana, bilateral'),
    ('H21349', 'Primary cyst of pars plana, unspecified eye'),
    ('H21351', 'Exudative cyst of pars plana, right eye'),
    ('H21352', 'Exudative cyst of pars plana, left eye'),
    ('H21353', 'Exudative cyst of pars plana, bilateral'),
    ('H21359', 'Exudative cyst of pars plana, unspecified eye'),
    ('H2140', 'Pupillary membranes, unspecified eye'),
    ('H2141', 'Pupillary membranes, right eye'),
    ('H2142', 'Pupillary membranes, left eye'),
    ('H2143', 'Pupillary membranes, bilateral'),
    ('H21501', 'Unspecified adhesions of iris, right eye'),
    ('H21502', 'Unspecified adhesions of iris, left eye'),
    ('H21503', 'Unspecified adhesions of iris, bilateral'),
    ('H21509', 'Unsp adhesions of iris and ciliary body, unspecified eye'),
    ('H21511', 'Anterior synechiae (iris), right eye'),
    ('H21512', 'Anterior synechiae (iris), left eye'),
    ('H21513', 'Anterior synechiae (iris), bilateral'),
    ('H21519', 'Anterior synechiae (iris), unspecified eye'),
    ('H21521', 'Goniosynechiae, right eye'),
    ('H21522', 'Goniosynechiae, left eye'),
    ('H21523', 'Goniosynechiae, bilateral'),
    ('H21529', 'Goniosynechiae, unspecified eye'),
    ('H21531', 'Iridodialysis, right eye'),
    ('H21532', 'Iridodialysis, left eye'),
    ('H21533', 'Iridodialysis, bilateral'),
    ('H21539', 'Iridodialysis, unspecified eye'),
    ('H21541', 'Posterior synechiae (iris), right eye'),
    ('H21542', 'Posterior synechiae (iris), left eye'),
    ('H21543', 'Posterior synechiae (iris), bilateral'),
    ('H21549', 'Posterior synechiae (iris), unspecified eye'),
    ('H21551', 'Recession of chamber angle, right eye'),
    ('H21552', 'Recession of chamber angle, left eye'),
    ('H21553', 'Recession of chamber angle, bilateral'),
    ('H21559', 'Recession of chamber angle, unspecified eye'),
    ('H21561', 'Pupillary abnormality, right eye'),
    ('H21562', 'Pupillary abnormality, left eye'),
    ('H21563', 'Pupillary abnormality, bilateral'),
    ('H21569', 'Pupillary abnormality, unspecified eye'),
    ('H2181', 'Floppy iris syndrome'),
    ('H2182', 'Plateau iris syndrome (post-iridectomy) (postprocedural)'),
    ('H2189', 'Other specified disorders of iris and ciliary body'),
    ('H219', 'Unspecified disorder of iris and ciliary body'),
    ('H22', 'Disorders of iris and ciliary body in diseases classd elswhr'),
    ('H25011', 'Cortical age-related cataract, right eye'),
    ('H25012', 'Cortical age-related cataract, left eye'),
    ('H25013', 'Cortical age-related cataract, bilateral'),
    ('H25019', 'Cortical age-related cataract, unspecified eye'),
    ('H25031', 'Anterior subcapsular polar age-related cataract, right eye'),
    ('H25032', 'Anterior subcapsular polar age-related cataract, left eye'),
    ('H25033', 'Anterior subcapsular polar age-related cataract, bilateral'),
    ('H25039', 'Anterior subcapsular polar age-related cataract, unsp eye'),
    ('H25041', 'Posterior subcapsular polar age-related cataract, right eye'),
    ('H25042', 'Posterior subcapsular polar age-related cataract, left eye'),
    ('H25043', 'Posterior subcapsular polar age-related cataract, bilateral'),
    ('H25049', 'Posterior subcapsular polar age-related cataract, unsp eye'),
    ('H25091', 'Other age-related incipient cataract, right eye'),
    ('H25092', 'Other age-related incipient cataract, left eye'),
    ('H25093', 'Other age-related incipient cataract, bilateral'),
    ('H25099', 'Other age-related incipient cataract, unspecified eye'),
    ('H2510', 'Age-related nuclear cataract, unspecified eye'),
    ('H2511', 'Age-related nuclear cataract, right eye'),
    ('H2512', 'Age-related nuclear cataract, left eye'),
    ('H2513', 'Age-related nuclear cataract, bilateral'),
    ('H2520', 'Age-related cataract, morgagnian type, unspecified eye'),
    ('H2521', 'Age-related cataract, morgagnian type, right eye'),
    ('H2522', 'Age-related cataract, morgagnian type, left eye'),
    ('H2523', 'Age-related cataract, morgagnian type, bilateral'),
    ('H25811', 'Combined forms of age-related cataract, right eye'),
    ('H25812', 'Combined forms of age-related cataract, left eye'),
    ('H25813', 'Combined forms of age-related cataract, bilateral'),
    ('H25819', 'Combined forms of age-related cataract, unspecified eye'),
    ('H2589', 'Other age-related cataract'),
    ('H259', 'Unspecified age-related cataract'),
    ('H26001', 'Unspecified infantile and juvenile cataract, right eye'),
    ('H26002', 'Unspecified infantile and juvenile cataract, left eye'),
    ('H26003', 'Unspecified infantile and juvenile cataract, bilateral'),
    ('H26009', 'Unspecified infantile and juvenile cataract, unspecified eye'),
    ('H26011', 'Infantile and juv cortical/lamellar/zonular cataract, r eye'),
    ('H26012', 'Infantile and juv cortical/lamellar/zonular cataract, l eye'),
    ('H26013', 'Infantile and juv cortical/lamellar/zonular cataract, bi'),
    ('H26019', 'Infantile & juv cortical/lamellar/zonular cataract, unsp eye'),
    ('H26031', 'Infantile and juvenile nuclear cataract, right eye'),
    ('H26032', 'Infantile and juvenile nuclear cataract, left eye'),
    ('H26033', 'Infantile and juvenile nuclear cataract, bilateral'),
    ('H26039', 'Infantile and juvenile nuclear cataract, unspecified eye'),
    ('H26041', 'Ant subcapsular polar infantile and juvenile cataract, r eye'),
    ('H26042', 'Ant subcapsular polar infantile and juv cataract, left eye'),
    ('H26043', 'Ant subcapsular polar infantile and juvenile cataract, bi'),
    ('H26049', 'Ant subcapsular polar infantile and juv cataract, unsp eye'),
    ('H26051', 'Post subcapsular polar infantile and juv cataract, r eye'),
    ('H26052', 'Post subcapsular polar infantile and juv cataract, left eye'),
    ('H26053', 'Post subcapsular polar infantile and juvenile cataract, bi'),
    ('H26059', 'Post subcapsular polar infantile and juv cataract, unsp eye'),
    ('H26061', 'Combined forms of infantile and juvenile cataract, right eye'),
    ('H26062', 'Combined forms of infantile and juvenile cataract, left eye'),
    ('H26063', 'Combined forms of infantile and juvenile cataract, bilateral'),
    ('H26069', 'Combined forms of infantile and juvenile cataract, unsp eye'),
    ('H2609', 'Other infantile and juvenile cataract'),
    ('H26101', 'Unspecified traumatic cataract, right eye'),
    ('H26102', 'Unspecified traumatic cataract, left eye'),
    ('H26103', 'Unspecified traumatic cataract, bilateral'),
    ('H26109', 'Unspecified traumatic cataract, unspecified eye'),
    ('H26111', 'Localized traumatic opacities, right eye'),
    ('H26112', 'Localized traumatic opacities, left eye'),
    ('H26113', 'Localized traumatic opacities, bilateral'),
    ('H26119', 'Localized traumatic opacities, unspecified eye'),
    ('H26121', 'Partially resolved traumatic cataract, right eye'),
    ('H26122', 'Partially resolved traumatic cataract, left eye'),
    ('H26123', 'Partially resolved traumatic cataract, bilateral'),
    ('H26129', 'Partially resolved traumatic cataract, unspecified eye'),
    ('H26131', 'Total traumatic cataract, right eye'),
    ('H26132', 'Total traumatic cataract, left eye'),
    ('H26133', 'Total traumatic cataract, bilateral'),
    ('H26139', 'Total traumatic cataract, unspecified eye'),
    ('H2620', 'Unspecified complicated cataract'),
    ('H26211', 'Cataract with neovascularization, right eye'),
    ('H26212', 'Cataract with neovascularization, left eye'),
    ('H26213', 'Cataract with neovascularization, bilateral'),
    ('H26219', 'Cataract with neovascularization, unspecified eye'),
    ('H26221', 'Cataract secondary to ocular disorders, right eye'),
    ('H26222', 'Cataract secondary to ocular disorders, left eye'),
    ('H26223', 'Cataract secondary to ocular disorders, bilateral'),
    ('H26229', 'Cataract secondary to ocular disorders, unsp eye'),
    ('H26231', 'Glaucomatous flecks (subcapsular), right eye'),
    ('H26232', 'Glaucomatous flecks (subcapsular), left eye'),
    ('H26233', 'Glaucomatous flecks (subcapsular), bilateral'),
    ('H26239', 'Glaucomatous flecks (subcapsular), unspecified eye'),
    ('H2630', 'Drug-induced cataract, unspecified eye'),
    ('H2631', 'Drug-induced cataract, right eye'),
    ('H2632', 'Drug-induced cataract, left eye'),
    ('H2633', 'Drug-induced cataract, bilateral'),
    ('H2640', 'Unspecified secondary cataract'),
    ('H26411', "Soemmering's ring, right eye"),
    ('H26412', "Soemmering's ring, left eye"),
    ('H26413', "Soemmering's ring, bilateral"),
    ('H26419', "Soemmering's ring, unspecified eye"),
    ('H26491', 'Other secondary cataract, right eye'),
    ('H26492', 'Other secondary cataract, left eye'),
    ('H26493', 'Other secondary cataract, bilateral'),
    ('H26499', 'Other secondary cataract, unspecified eye'),
    ('H268', 'Other specified cataract'),
    ('H269', 'Unspecified cataract'),
    ('H2700', 'Aphakia, unspecified eye'),
    ('H2701', 'Aphakia, right eye'),
    ('H2702', 'Aphakia, left eye'),
    ('H2703', 'Aphakia, bilateral'),
    ('H2710', 'Unspecified dislocation of lens'),
    ('H27111', 'Subluxation of lens, right eye'),
    ('H27112', 'Subluxation of lens, left eye'),
    ('H27113', 'Subluxation of lens, bilateral'),
    ('H27119', 'Subluxation of lens, unspecified eye'),
    ('H27121', 'Anterior dislocation of lens, right eye'),
    ('H27122', 'Anterior dislocation of lens, left eye'),
    ('H27123', 'Anterior dislocation of lens, bilateral'),
    ('H27129', 'Anterior dislocation of lens, unspecified eye'),
    ('H27131', 'Posterior dislocation of lens, right eye'),
    ('H27132', 'Posterior dislocation of lens, left eye'),
    ('H27133', 'Posterior dislocation of lens, bilateral'),
    ('H27139', 'Posterior dislocation of lens, unspecified eye'),
    ('H278', 'Other specified disorders of lens'),
    ('H279', 'Unspecified disorder of lens'),
    ('H28', 'Cataract in diseases classified elsewhere'),
    ('H30001', 'Unspecified focal chorioretinal inflammation, right eye'),
    ('H30002', 'Unspecified focal chorioretinal inflammation, left eye'),
    ('H30003', 'Unspecified focal chorioretinal inflammation, bilateral'),
    ('H30009', 'Unsp focal chorioretinal inflammation, unspecified eye'),
    ('H30011', 'Focal chorioretinal inflammation, juxtapapillary, right eye'),
    ('H30012', 'Focal chorioretinal inflammation, juxtapapillary, left eye'),
    ('H30013', 'Focal chorioretinal inflammation, juxtapapillary, bilateral'),
    ('H30019', 'Focal chorioretinal inflammation, juxtapapillary, unsp eye'),
    ('H30021', 'Focal chorioretin inflammation of posterior pole, right eye'),
    ('H30022', 'Focal chorioretinal inflammation of posterior pole, left eye'),
    ('H30023', 'Focal chorioretin inflammation of posterior pole, bilateral'),
    ('H30029', 'Focal chorioretinal inflammation of posterior pole, unsp eye'),
    ('H30031', 'Focal chorioretinal inflammation, peripheral, right eye'),
    ('H30032', 'Focal chorioretinal inflammation, peripheral, left eye'),
    ('H30033', 'Focal chorioretinal inflammation, peripheral, bilateral'),
    ('H30039', 'Focal chorioretinal inflammation, peripheral, unsp eye'),
    ('H30041', 'Focal chorioretin inflam, macular or paramacular, right eye'),
    ('H30042', 'Focal chorioretin inflam, macular or paramacular, left eye'),
    ('H30043', 'Focal chorioretin inflam, macular or paramacular, bilateral'),
    ('H30049', 'Focal chorioretin inflam, macular or paramacular, unsp eye'),
    ('H30101', 'Unsp disseminated chorioretinal inflammation, right eye'),
    ('H30102', 'Unsp disseminated chorioretinal inflammation, left eye'),
    ('H30103', 'Unsp disseminated chorioretinal inflammation, bilateral'),
    ('H30109', 'Unsp disseminated chorioretinal inflammation, unsp eye'),
    ('H30111', 'Dissem chorioretin inflammation of posterior pole, right eye'),
    ('H30112', 'Dissem chorioretin inflammation of posterior pole, left eye'),
    ('H30113', 'Dissem chorioretin inflammation of posterior pole, bilateral'),
    ('H30119', 'Dissem chorioretin inflammation of posterior pole, unsp eye'),
    ('H30121', 'Disseminated chorioretin inflammation, peripheral right eye'),
    ('H30122', 'Disseminated chorioretin inflammation, peripheral, left eye'),
    ('H30123', 'Disseminated chorioretin inflammation, peripheral, bilateral'),
    ('H30129', 'Disseminated chorioretin inflammation, peripheral, unsp eye'),
    ('H30131', 'Dissem chorioretin inflammation, generalized, right eye'),
    ('H30132', 'Disseminated chorioretin inflammation, generalized, left eye'),
    ('H30133', 'Dissem chorioretin inflammation, generalized, bilateral'),
    ('H30139', 'Disseminated chorioretin inflammation, generalized, unsp eye'),
    ('H30141', 'Acute post multifoc placoid pigment epitheliopathy, r eye'),
    ('H30142', 'Acute post multifoc placoid pigment epitheliopathy, left eye'),
    ('H30143', 'Acute posterior multifoc placoid pigment epitheliopathy, bi'),
    ('H30149', 'Acute post multifoc placoid pigment epitheliopathy, unsp eye'),
    ('H3020', 'Posterior cyclitis, unspecified eye'),
    ('H3021', 'Posterior cyclitis, right eye'),
    ('H3022', 'Posterior cyclitis, left eye'),
    ('H3023', 'Posterior cyclitis, bilateral'),
    ('H30811', "Harada's disease, right eye"),
    ('H30812', "Harada's disease, left eye"),
    ('H30813', "Harada's disease, bilateral"),
    ('H30819', "Harada's disease, unspecified eye"),
    ('H30891', 'Other chorioretinal inflammations, right eye'),
    ('H30892', 'Other chorioretinal inflammations, left eye'),
    ('H30893', 'Other chorioretinal inflammations, bilateral'),
    ('H30899', 'Other chorioretinal inflammations, unspecified eye'),
    ('H3090', 'Unspecified chorioretinal inflammation, unspecified eye'),
    ('H3091', 'Unspecified chorioretinal inflammation, right eye'),
    ('H3092', 'Unspecified chorioretinal inflammation, left eye'),
    ('H3093', 'Unspecified chorioretinal inflammation, bilateral'),
    ('H31001', 'Unspecified chorioretinal scars, right eye'),
    ('H31002', 'Unspecified chorioretinal scars, left eye'),
    ('H31003', 'Unspecified chorioretinal scars, bilateral'),
    ('H31009', 'Unspecified chorioretinal scars, unspecified eye'),
    ('H31011', 'Macula scars of posterior pole (post-traumatic), right eye'),
    ('H31012', 'Macula scars of posterior pole (post-traumatic), left eye'),
    ('H31013', 'Macula scars of posterior pole (post-traumatic), bilateral'),
    ('H31019', 'Macula scars of posterior pole (post-traumatic), unsp eye'),
    ('H31021', 'Solar retinopathy, right eye'),
    ('H31022', 'Solar retinopathy, left eye'),
    ('H31023', 'Solar retinopathy, bilateral'),
    ('H31029', 'Solar retinopathy, unspecified eye'),
    ('H31091', 'Other chorioretinal scars, right eye'),
    ('H31092', 'Other chorioretinal scars, left eye'),
    ('H31093', 'Other chorioretinal scars, bilateral'),
    ('H31099', 'Other chorioretinal scars, unspecified eye'),
    ('H31101', 'Choroidal degeneration, unspecified, right eye'),
    ('H31102', 'Choroidal degeneration, unspecified, left eye'),
    ('H31103', 'Choroidal degeneration, unspecified, bilateral'),
    ('H31109', 'Choroidal degeneration, unspecified, unspecified eye'),
    ('H31111', 'Age-related choroidal atrophy, right eye'),
    ('H31112', 'Age-related choroidal atrophy, left eye'),
    ('H31113', 'Age-related choroidal atrophy, bilateral'),
    ('H31119', 'Age-related choroidal atrophy, unspecified eye'),
    ('H31121', 'Diffuse secondary atrophy of choroid, right eye'),
    ('H31122', 'Diffuse secondary atrophy of choroid, left eye'),
    ('H31123', 'Diffuse secondary atrophy of choroid, bilateral'),
    ('H31129', 'Diffuse secondary atrophy of choroid, unspecified eye'),
    ('H3120', 'Hereditary choroidal dystrophy, unspecified'),
    ('H3121', 'Choroideremia'),
    ('H3122', 'Choroidal dystrophy (central areolar) (peripapillary)'),
    ('H3123', 'Gyrate atrophy, choroid'),
    ('H3129', 'Other hereditary choroidal dystrophy'),
    ('H31301', 'Unspecified choroidal hemorrhage, right eye'),
    ('H31302', 'Unspecified choroidal hemorrhage, left eye'),
    ('H31303', 'Unspecified choroidal hemorrhage, bilateral'),
    ('H31309', 'Unspecified choroidal hemorrhage, unspecified eye'),
    ('H31311', 'Expulsive choroidal hemorrhage, right eye'),
    ('H31312', 'Expulsive choroidal hemorrhage, left eye'),
    ('H31313', 'Expulsive choroidal hemorrhage, bilateral'),
    ('H31319', 'Expulsive choroidal hemorrhage, unspecified eye'),
    ('H31321', 'Choroidal rupture, right eye'),
    ('H31322', 'Choroidal rupture, left eye'),
    ('H31323', 'Choroidal rupture, bilateral'),
    ('H31329', 'Choroidal rupture, unspecified eye'),
    ('H31401', 'Unspecified choroidal detachment, right eye'),
    ('H31402', 'Unspecified choroidal detachment, left eye'),
    ('H31403', 'Unspecified choroidal detachment, bilateral'),
    ('H31409', 'Unspecified choroidal detachment, unspecified eye'),
    ('H31411', 'Hemorrhagic choroidal detachment, right eye'),
    ('H31412', 'Hemorrhagic choroidal detachment, left eye'),
    ('H31413', 'Hemorrhagic choroidal detachment, bilateral'),
    ('H31419', 'Hemorrhagic choroidal detachment, unspecified eye'),
    ('H31421', 'Serous choroidal detachment, right eye'),
    ('H31422', 'Serous choroidal detachment, left eye'),
    ('H31423', 'Serous choroidal detachment, bilateral'),
    ('H31429', 'Serous choroidal detachment, unspecified eye'),
    ('H318', 'Other specified disorders of choroid'),
    ('H319', 'Unspecified disorder of choroid'),
    ('H32', 'Chorioretinal disorders in diseases classified elsewhere'),
    ('H33001', 'Unspecified retinal detachment with retinal break, right eye'),
    ('H33002', 'Unspecified retinal detachment with retinal break, left eye'),
    ('H33003', 'Unspecified retinal detachment with retinal break, bilateral'),
    ('H33009', 'Unsp retinal detachment with retinal break, unspecified eye'),
    ('H33011', 'Retinal detachment with single break, right eye'),
    ('H33012', 'Retinal detachment with single break, left eye'),
    ('H33013', 'Retinal detachment with single break, bilateral'),
    ('H33019', 'Retinal detachment with single break, unspecified eye'),
    ('H33021', 'Retinal detachment with multiple breaks, right eye'),
    ('H33022', 'Retinal detachment with multiple breaks, left eye'),
    ('H33023', 'Retinal detachment with multiple breaks, bilateral'),
    ('H33029', 'Retinal detachment with multiple breaks, unspecified eye'),
    ('H33031', 'Retinal detachment with giant retinal tear, right eye'),
    ('H33032', 'Retinal detachment with giant retinal tear, left eye'),
    ('H33033', 'Retinal detachment with giant retinal tear, bilateral'),
    ('H33039', 'Retinal detachment with giant retinal tear, unspecified eye'),
    ('H33041', 'Retinal detachment with retinal dialysis, right eye'),
    ('H33042', 'Retinal detachment with retinal dialysis, left eye'),
    ('H33043', 'Retinal detachment with retinal dialysis, bilateral'),
    ('H33049', 'Retinal detachment with retinal dialysis, unspecified eye'),
    ('H33051', 'Total retinal detachment, right eye'),
    ('H33052', 'Total retinal detachment, left eye'),
    ('H33053', 'Total retinal detachment, bilateral'),
    ('H33059', 'Total retinal detachment, unspecified eye'),
    ('H33101', 'Unspecified retinoschisis, right eye'),
    ('H33102', 'Unspecified retinoschisis, left eye'),
    ('H33103', 'Unspecified retinoschisis, bilateral'),
    ('H33109', 'Unspecified retinoschisis, unspecified eye'),
    ('H33111', 'Cyst of ora serrata, right eye'),
    ('H33112', 'Cyst of ora serrata, left eye'),
    ('H33113', 'Cyst of ora serrata, bilateral'),
    ('H33119', 'Cyst of ora serrata, unspecified eye'),
    ('H33121', 'Parasitic cyst of retina, right eye'),
    ('H33122', 'Parasitic cyst of retina, left eye'),
    ('H33123', 'Parasitic cyst of retina, bilateral'),
    ('H33129', 'Parasitic cyst of retina, unspecified eye'),
    ('H33191', 'Other retinoschisis and retinal cysts, right eye'),
    ('H33192', 'Other retinoschisis and retinal cysts, left eye'),
    ('H33193', 'Other retinoschisis and retinal cysts, bilateral'),
    ('H33199', 'Other retinoschisis and retinal cysts, unspecified eye'),
    ('H3320', 'Serous retinal detachment, unspecified eye'),
    ('H3321', 'Serous retinal detachment, right eye'),
    ('H3322', 'Serous retinal detachment, left eye'),
    ('H3323', 'Serous retinal detachment, bilateral'),
    ('H33301', 'Unspecified retinal break, right eye'),
    ('H33302', 'Unspecified retinal break, left eye'),
    ('H33303', 'Unspecified retinal break, bilateral'),
    ('H33309', 'Unspecified retinal break, unspecified eye'),
    ('H33311', 'Horseshoe tear of retina without detachment, right eye'),
    ('H33312', 'Horseshoe tear of retina without detachment, left eye'),
    ('H33313', 'Horseshoe tear of retina without detachment, bilateral'),
    ('H33319', 'Horseshoe tear of retina without detachment, unspecified eye'),
    ('H33321', 'Round hole, right eye'),
    ('H33322', 'Round hole, left eye'),
    ('H33323', 'Round hole, bilateral'),
    ('H33329', 'Round hole, unspecified eye'),
    ('H33331', 'Multiple defects of retina without detachment, right eye'),
    ('H33332', 'Multiple defects of retina without detachment, left eye'),
    ('H33333', 'Multiple defects of retina without detachment, bilateral'),
    ('H33339', 'Multiple defects of retina without detachment, unsp eye'),
    ('H3340', 'Traction detachment of retina, unspecified eye'),
    ('H3341', 'Traction detachment of retina, right eye'),
    ('H3342', 'Traction detachment of retina, left eye'),
    ('H3343', 'Traction detachment of retina, bilateral'),
    ('H338', 'Other retinal detachments'),
    ('H3400', 'Transient retinal artery occlusion, unspecified eye'),
    ('H3401', 'Transient retinal artery occlusion, right eye'),
    ('H3402', 'Transient retinal artery occlusion, left eye'),
    ('H3403', 'Transient retinal artery occlusion, bilateral'),
    ('H3410', 'Central retinal artery occlusion, unspecified eye'),
    ('H3411', 'Central retinal artery occlusion, right eye'),
    ('H3412', 'Central retinal artery occlusion, left eye'),
    ('H3413', 'Central retinal artery occlusion, bilateral'),
    ('H34211', 'Partial retinal artery occlusion, right eye'),
    ('H34212', 'Partial retinal artery occlusion, left eye'),
    ('H34213', 'Partial retinal artery occlusion, bilateral'),
    ('H34219', 'Partial retinal artery occlusion, unspecified eye'),
    ('H34231', 'Retinal artery branch occlusion, right eye'),
    ('H34232', 'Retinal artery branch occlusion, left eye'),
    ('H34233', 'Retinal artery branch occlusion, bilateral'),
    ('H34239', 'Retinal artery branch occlusion, unspecified eye'),
    ('H34811', 'Central retinal vein occlusion, right eye'),
    ('H348110', 'Central retinal vein occls, right eye, with macular edema'),
    ('H348111', 'Central retinal vein occlusion, right eye, w rtnl neovas'),
    ('H348112', 'Central retinal vein occlusion, right eye, stable'),
    ('H34812', 'Central retinal vein occlusion, left eye'),
    ('H348120', 'Central retinal vein occlusion, left eye, with macular edema'),
    ('H348121', 'Central retinal vein occlusion, left eye, w rtnl neovas'),
    ('H348122', 'Central retinal vein occlusion, left eye, stable'),
    ('H34813', 'Central retinal vein occlusion, bilateral'),
    ('H348130', 'Central retinal vein occlusion, bi, with macular edema'),
    ('H348131', 'Central retinal vein occlusion, bilateral, w rtnl neovas'),
    ('H348132', 'Central retinal vein occlusion, bilateral, stable'),
    ('H34819', 'Central retinal vein occlusion, unspecified eye'),
    ('H348190', 'Central retinal vein occlusion, unsp, with macular edema'),
    ('H348191', 'Central retinal vein occlusion, unsp, w rtnl neovas'),
    ('H348192', 'Central retinal vein occlusion, unspecified eye, stable'),
    ('H34821', 'Venous engorgement, right eye'),
    ('H34822', 'Venous engorgement, left eye'),
    ('H34823', 'Venous engorgement, bilateral'),
    ('H34829', 'Venous engorgement, unspecified eye'),
    ('H34831', 'Tributary (branch) retinal vein occlusion, right eye'),
    ('H348310', 'Trib rtnl vein occlusion, right eye, with macular edema'),
    ('H348311', 'Trib rtnl vein occlusion, right eye, w rtnl neovas'),
    ('H348312', 'Tributary (branch) retinal vein occlusion, right eye, stable'),
    ('H34832', 'Tributary (branch) retinal vein occlusion, left eye'),
    ('H348320', 'Trib rtnl vein occlusion, left eye, with macular edema'),
    ('H348321', 'Trib rtnl vein occlusion, left eye, w rtnl neovas'),
    ('H348322', 'Tributary (branch) retinal vein occlusion, left eye, stable'),
    ('H34833', 'Tributary (branch) retinal vein occlusion, bilateral'),
    ('H348330', 'Trib rtnl vein occlusion, bilateral, with macular edema'),
    ('H348331', 'Trib rtnl vein occlusion, bilateral, w rtnl neovas'),
    ('H348332', 'Tributary (branch) retinal vein occlusion, bilateral, stable'),
    ('H34839', 'Tributary (branch) retinal vein occlusion, unspecified eye'),
    ('H348390', 'Trib rtnl vein occlusion, unsp, with macular edema'),
    ('H348391', 'Trib rtnl vein occlusion, unspecified eye, w rtnl neovas'),
    ('H348392', 'Trib rtnl vein occlusion, unspecified eye, stable'),
    ('H349', 'Unspecified retinal vascular occlusion'),
    ('H3500', 'Unspecified background retinopathy'),
    ('H35011', 'Changes in retinal vascular appearance, right eye'),
    ('H35012', 'Changes in retinal vascular appearance, left eye'),
    ('H35013', 'Changes in retinal vascular appearance, bilateral'),
    ('H35019', 'Changes in retinal vascular appearance, unspecified eye'),
    ('H35021', 'Exudative retinopathy, right eye'),
    ('H35022', 'Exudative retinopathy, left eye'),
    ('H35023', 'Exudative retinopathy, bilateral'),
    ('H35029', 'Exudative retinopathy, unspecified eye'),
    ('H35031', 'Hypertensive retinopathy, right eye'),
    ('H35032', 'Hypertensive retinopathy, left eye'),
    ('H35033', 'Hypertensive retinopathy, bilateral'),
    ('H35039', 'Hypertensive retinopathy, unspecified eye'),
    ('H35041', 'Retinal micro-aneurysms, unspecified, right eye'),
    ('H35042', 'Retinal micro-aneurysms, unspecified, left eye'),
    ('H35043', 'Retinal micro-aneurysms, unspecified, bilateral'),
    ('H35049', 'Retinal micro-aneurysms, unspecified, unspecified eye'),
    ('H35051', 'Retinal neovascularization, unspecified, right eye'),
    ('H35052', 'Retinal neovascularization, unspecified, left eye'),
    ('H35053', 'Retinal neovascularization, unspecified, bilateral'),
    ('H35059', 'Retinal neovascularization, unspecified, unspecified eye'),
    ('H35061', 'Retinal vasculitis, right eye'),
    ('H35062', 'Retinal vasculitis, left eye'),
    ('H35063', 'Retinal vasculitis, bilateral'),
    ('H35069', 'Retinal vasculitis, unspecified eye'),
    ('H35071', 'Retinal telangiectasis, right eye'),
    ('H35072', 'Retinal telangiectasis, left eye'),
    ('H35073', 'Retinal telangiectasis, bilateral'),
    ('H35079', 'Retinal telangiectasis, unspecified eye'),
    ('H3509', 'Other intraretinal microvascular abnormalities'),
    ('H35101', 'Retinopathy of prematurity, unspecified, right eye'),
    ('H35102', 'Retinopathy of prematurity, unspecified, left eye'),
    ('H35103', 'Retinopathy of prematurity, unspecified, bilateral'),
    ('H35109', 'Retinopathy of prematurity, unspecified, unspecified eye'),
    ('H35111', 'Retinopathy of prematurity, stage 0, right eye'),
    ('H35112', 'Retinopathy of prematurity, stage 0, left eye'),
    ('H35113', 'Retinopathy of prematurity, stage 0, bilateral'),
    ('H35119', 'Retinopathy of prematurity, stage 0, unspecified eye'),
    ('H35121', 'Retinopathy of prematurity, stage 1, right eye'),
    ('H35122', 'Retinopathy of prematurity, stage 1, left eye'),
    ('H35123', 'Retinopathy of prematurity, stage 1, bilateral'),
    ('H35129', 'Retinopathy of prematurity, stage 1, unspecified eye'),
    ('H35131', 'Retinopathy of prematurity, stage 2, right eye'),
    ('H35132', 'Retinopathy of prematurity, stage 2, left eye'),
    ('H35133', 'Retinopathy of prematurity, stage 2, bilateral'),
    ('H35139', 'Retinopathy of prematurity, stage 2, unspecified eye'),
    ('H35141', 'Retinopathy of prematurity, stage 3, right eye'),
    ('H35142', 'Retinopathy of prematurity, stage 3, left eye'),
    ('H35143', 'Retinopathy of prematurity, stage 3, bilateral'),
    ('H35149', 'Retinopathy of prematurity, stage 3, unspecified eye'),
    ('H35151', 'Retinopathy of prematurity, stage 4, right eye'),
    ('H35152', 'Retinopathy of prematurity, stage 4, left eye'),
    ('H35153', 'Retinopathy of prematurity, stage 4, bilateral'),
    ('H35159', 'Retinopathy of prematurity, stage 4, unspecified eye'),
    ('H35161', 'Retinopathy of prematurity, stage 5, right eye'),
    ('H35162', 'Retinopathy of prematurity, stage 5, left eye'),
    ('H35163', 'Retinopathy of prematurity, stage 5, bilateral'),
    ('H35169', 'Retinopathy of prematurity, stage 5, unspecified eye'),
    ('H35171', 'Retrolental fibroplasia, right eye'),
    ('H35172', 'Retrolental fibroplasia, left eye'),
    ('H35173', 'Retrolental fibroplasia, bilateral'),
    ('H35179', 'Retrolental fibroplasia, unspecified eye'),
    ('H3520', 'Other non-diabetic proliferative retinopathy, unsp eye'),
    ('H3521', 'Other non-diabetic proliferative retinopathy, right eye'),
    ('H3522', 'Other non-diabetic proliferative retinopathy, left eye'),
    ('H3523', 'Other non-diabetic proliferative retinopathy, bilateral'),
    ('H3530', 'Unspecified macular degeneration'),
    ('H3531', 'Nonexudative age-related macular degeneration'),
    ('H353110', 'Nexdtve age-related mclr degn, right eye, stage unspecified'),
    ('H353111', 'Nexdtve age-related mclr degn, right eye, early dry stage'),
    ('H353112', 'Nexdtve age-related mclr degn, right eye, intermed dry stage'),
    ('H353113', 'Nexdtve age-rel mclr degn, r eye, adv atrpc w/o sbfvl involv'),
    ('H353114', 'Nexdtve age-rel mclr degn, r eye, adv atrpc w sbfvl involv'),
    ('H353120', 'Nexdtve age-related mclr degn, left eye, stage unspecified'),
    ('H353121', 'Nexdtve age-related mclr degn, left eye, early dry stage'),
    ('H353122', 'Nexdtve age-related mclr degn, left eye, intermed dry stage'),
    ('H353123', 'Nexdtve age-rel mclr degn, l eye, adv atrpc w/o sbfvl involv'),
    ('H353124', 'Nexdtve age-rel mclr degn, l eye, adv atrpc w sbfvl involv'),
    ('H353130', 'Nexdtve age-related mclr degn, bilateral, stage unspecified'),
    ('H353131', 'Nexdtve age-related mclr degn, bilateral, early dry stage'),
    ('H353132', 'Nexdtve age-related mclr degn, bilateral, intermed dry stage'),
    ('H353133', 'Nexdtve age-rel mclr degn, bi, adv atrpc w/o sbfvl involv'),
    ('H353134', 'Nexdtve age-rel mclr degn, bi, adv atrpc with sbfvl involv'),
    ('H353190', 'Nonexudative age-related mclr degn, unsp, stage unspecified'),
    ('H353191', 'Nonexudative age-related mclr degn, unsp, early dry stage'),
    ('H353192', 'Nonexudative age-related mclr degn, unsp, intermed dry stage'),
    ('H353193', 'Nexdtve age-rel mclr degn, unsp, adv atrpc w/o sbfvl involv'),
    ('H353194', 'Nexdtve age-rel mclr degn, unsp, adv atrpc with sbfvl involv'),
    ('H3532', 'Exudative age-related macular degeneration'),
    ('H353210', 'Exudative age-rel mclr degn, right eye, stage unspecified'),
    ('H353211', 'Exdtve age-rel mclr degn, right eye, with actv chrdl neovas'),
    ('H353212', 'Exdtve age-rel mclr degn, right eye, with inact chrdl neovas'),
    ('H353213', 'Exudative age-rel mclr degn, right eye, with inactive scar'),
    ('H353220', 'Exudative age-related mclr degn, left eye, stage unspecified'),
    ('H353221', 'Exdtve age-rel mclr degn, left eye, with actv chrdl neovas'),
    ('H353222', 'Exdtve age-rel mclr degn, left eye, with inact chrdl neovas'),
    ('H353223', 'Exudative age-rel mclr degn, left eye, with inactive scar'),
    ('H353230', 'Exudative age-rel mclr degn, bilateral, stage unspecified'),
    ('H353231', 'Exudative age-rel mclr degn, bi, with actv chrdl neovas'),
    ('H353232', 'Exudative age-rel mclr degn, bi, with inact chrdl neovas'),
    ('H353233', 'Exudative age-rel mclr degn, bilateral, with inactive scar'),
    ('H353290', 'Exudative age-related mclr degn, unsp, stage unspecified'),
    ('H353291', 'Exudative age-rel mclr degn, unsp, with actv chrdl neovas'),
    ('H353292', 'Exudative age-rel mclr degn, unsp, with inact chrdl neovas'),
    ('H353293', 'Exudative age-related mclr degn, unsp, with inactive scar'),
    ('H3533', 'Angioid streaks of macula'),
    ('H35341', 'Macular cyst, hole, or pseudohole, right eye'),
    ('H35342', 'Macular cyst, hole, or pseudohole, left eye'),
    ('H35343', 'Macular cyst, hole, or pseudohole, bilateral'),
    ('H35349', 'Macular cyst, hole, or pseudohole, unspecified eye'),
    ('H35351', 'Cystoid macular degeneration, right eye'),
    ('H35352', 'Cystoid macular degeneration, left eye'),
    ('H35353', 'Cystoid macular degeneration, bilateral'),
    ('H35359', 'Cystoid macular degeneration, unspecified eye'),
    ('H35361', 'Drusen (degenerative) of macula, right eye'),
    ('H35362', 'Drusen (degenerative) of macula, left eye'),
    ('H35363', 'Drusen (degenerative) of macula, bilateral'),
    ('H35369', 'Drusen (degenerative) of macula, unspecified eye'),
    ('H35371', 'Puckering of macula, right eye'),
    ('H35372', 'Puckering of macula, left eye'),
    ('H35373', 'Puckering of macula, bilateral'),
    ('H35379', 'Puckering of macula, unspecified eye'),
    ('H35381', 'Toxic maculopathy, right eye'),
    ('H35382', 'Toxic maculopathy, left eye'),
    ('H35383', 'Toxic maculopathy, bilateral'),
    ('H35389', 'Toxic maculopathy, unspecified eye'),
    ('H3540', 'Unspecified peripheral retinal degeneration'),
    ('H35411', 'Lattice degeneration of retina, right eye'),
    ('H35412', 'Lattice degeneration of retina, left eye'),
    ('H35413', 'Lattice degeneration of retina, bilateral'),
    ('H35419', 'Lattice degeneration of retina, unspecified eye'),
    ('H35421', 'Microcystoid degeneration of retina, right eye'),
    ('H35422', 'Microcystoid degeneration of retina, left eye'),
    ('H35423', 'Microcystoid degeneration of retina, bilateral'),
    ('H35429', 'Microcystoid degeneration of retina, unspecified eye'),
    ('H35431', 'Paving stone degeneration of retina, right eye'),
    ('H35432', 'Paving stone degeneration of retina, left eye'),
    ('H35433', 'Paving stone degeneration of retina, bilateral'),
    ('H35439', 'Paving stone degeneration of retina, unspecified eye'),
    ('H35441', 'Age-related reticular degeneration of retina, right eye'),
    ('H35442', 'Age-related reticular degeneration of retina, left eye'),
    ('H35443', 'Age-related reticular degeneration of retina, bilateral'),
    ('H35449', 'Age-related reticular degeneration of retina, unsp eye'),
    ('H35451', 'Secondary pigmentary degeneration, right eye'),
    ('H35452', 'Secondary pigmentary degeneration, left eye'),
    ('H35453', 'Secondary pigmentary degeneration, bilateral'),
    ('H35459', 'Secondary pigmentary degeneration, unspecified eye'),
    ('H35461', 'Secondary vitreoretinal degeneration, right eye'),
    ('H35462', 'Secondary vitreoretinal degeneration, left eye'),
    ('H35463', 'Secondary vitreoretinal degeneration, bilateral'),
    ('H35469', 'Secondary vitreoretinal degeneration, unspecified eye'),
    ('H3550', 'Unspecified hereditary retinal dystrophy'),
    ('H3551', 'Vitreoretinal dystrophy'),
    ('H3552', 'Pigmentary retinal dystrophy'),
    ('H3553', 'Other dystrophies primarily involving the sensory retina'),
    ('H3554', 'Dystrophies primarily w the retinal pigment epithelium'),
    ('H3560', 'Retinal hemorrhage, unspecified eye'),
    ('H3561', 'Retinal hemorrhage, right eye'),
    ('H3562', 'Retinal hemorrhage, left eye'),
    ('H3563', 'Retinal hemorrhage, bilateral'),
    ('H3570', 'Unspecified separation of retinal layers'),
    ('H35711', 'Central serous chorioretinopathy, right eye'),
    ('H35712', 'Central serous chorioretinopathy, left eye'),
    ('H35713', 'Central serous chorioretinopathy, bilateral'),
    ('H35719', 'Central serous chorioretinopathy, unspecified eye'),
    ('H35721', 'Serous detachment of retinal pigment epithelium, right eye'),
    ('H35722', 'Serous detachment of retinal pigment epithelium, left eye'),
    ('H35723', 'Serous detachment of retinal pigment epithelium, bilateral'),
    ('H35729', 'Serous detachment of retinal pigment epithelium, unsp eye'),
    ('H35731', 'Hemorrhagic detach of retinal pigment epithelium, right eye'),
    ('H35732', 'Hemorrhagic detach of retinal pigment epithelium, left eye'),
    ('H35733', 'Hemorrhagic detach of retinal pigment epithelium, bilateral'),
    ('H35739', 'Hemorrhagic detach of retinal pigment epithelium, unsp eye'),
    ('H3581', 'Retinal edema'),
    ('H3582', 'Retinal ischemia'),
    ('H3589', 'Other specified retinal disorders'),
    ('H359', 'Unspecified retinal disorder'),
    ('H36', 'Retinal disorders in diseases classified elsewhere'),
    ('H36811', 'Nonproliferative sickle-cell retinopathy, right eye'),
    ('H36812', 'Nonproliferative sickle-cell retinopathy, left eye'),
    ('H36813', 'Nonproliferative sickle-cell retinopathy, bilateral'),
    ('H36819', 'Nonproliferative sickle-cell retinopathy, unspecified eye'),
    ('H36821', 'Proliferative sickle-cell retinopathy, right eye'),
    ('H36822', 'Proliferative sickle-cell retinopathy, left eye'),
    ('H36823', 'Proliferative sickle-cell retinopathy, bilateral'),
    ('H36829', 'Proliferative sickle-cell retinopathy, unspecified eye'),
    ('H3689', 'Other retinal disorders in diseases classified elsewhere'),
    ('H40001', 'Preglaucoma, unspecified, right eye'),
    ('H40002', 'Preglaucoma, unspecified, left eye'),
    ('H40003', 'Preglaucoma, unspecified, bilateral'),
    ('H40009', 'Preglaucoma, unspecified, unspecified eye'),
    ('H40011', 'Open angle with borderline findings, low risk, right eye'),
    ('H40012', 'Open angle with borderline findings, low risk, left eye'),
    ('H40013', 'Open angle with borderline findings, low risk, bilateral'),
    ('H40019', 'Open angle with borderline findings, low risk, unsp eye'),
    ('H40021', 'Open angle with borderline findings, high risk, right eye'),
    ('H40022', 'Open angle with borderline findings, high risk, left eye'),
    ('H40023', 'Open angle with borderline findings, high risk, bilateral'),
    ('H40029', 'Open angle with borderline findings, high risk, unsp eye'),
    ('H40031', 'Anatomical narrow angle, right eye'),
    ('H40032', 'Anatomical narrow angle, left eye'),
    ('H40033', 'Anatomical narrow angle, bilateral'),
    ('H40039', 'Anatomical narrow angle, unspecified eye'),
    ('H40041', 'Steroid responder, right eye'),
    ('H40042', 'Steroid responder, left eye'),
    ('H40043', 'Steroid responder, bilateral'),
    ('H40049', 'Steroid responder, unspecified eye'),
    ('H40051', 'Ocular hypertension, right eye'),
    ('H40052', 'Ocular hypertension, left eye'),
    ('H40053', 'Ocular hypertension, bilateral'),
    ('H40059', 'Ocular hypertension, unspecified eye'),
    ('H40061', 'Primary angle closure without glaucoma damage, right eye'),
    ('H40062', 'Primary angle closure without glaucoma damage, left eye'),
    ('H40063', 'Primary angle closure without glaucoma damage, bilateral'),
    ('H40069', 'Primary angle closure without glaucoma damage, unsp eye'),
    ('H4010X0', 'Unspecified open-angle glaucoma, stage unspecified'),
    ('H4010X1', 'Unspecified open-angle glaucoma, mild stage'),
    ('H4010X2', 'Unspecified open-angle glaucoma, moderate stage'),
    ('H4010X3', 'Unspecified open-angle glaucoma, severe stage'),
    ('H4010X4', 'Unspecified open-angle glaucoma, indeterminate stage'),
    ('H401110', 'Primary open-angle glaucoma, right eye, stage unspecified'),
    ('H401111', 'Primary open-angle glaucoma, right eye, mild stage'),
    ('H401112', 'Primary open-angle glaucoma, right eye, moderate stage'),
    ('H401113', 'Primary open-angle glaucoma, right eye, severe stage'),
    ('H401114', 'Primary open-angle glaucoma, right eye, indeterminate stage'),
    ('H401120', 'Primary open-angle glaucoma, left eye, stage unspecified'),
    ('H401121', 'Primary open-angle glaucoma, left eye, mild stage'),
    ('H401122', 'Primary open-angle glaucoma, left eye, moderate stage'),
    ('H401123', 'Primary open-angle glaucoma, left eye, severe stage'),
    ('H401124', 'Primary open-angle glaucoma, left eye, indeterminate stage'),
    ('H401130', 'Primary open-angle glaucoma, bilateral, stage unspecified'),
    ('H401131', 'Primary open-angle glaucoma, bilateral, mild stage'),
    ('H401132', 'Primary open-angle glaucoma, bilateral, moderate stage'),
    ('H401133', 'Primary open-angle glaucoma, bilateral, severe stage'),
    ('H401134', 'Primary open-angle glaucoma, bilateral, indeterminate stage'),
    ('H401190', 'Primary open-angle glaucoma, unsp, stage unspecified'),
    ('H401191', 'Primary open-angle glaucoma, unspecified eye, mild stage'),
    ('H401192', 'Primary open-angle glaucoma, unspecified eye, moderate stage'),
    ('H401193', 'Primary open-angle glaucoma, unspecified eye, severe stage'),
    ('H401194', 'Primary open-angle glaucoma, unsp, indeterminate stage'),
    ('H4011X0', 'Primary open-angle glaucoma, stage unspecified'),
    ('H4011X1', 'Primary open-angle glaucoma, mild stage'),
    ('H4011X2', 'Primary open-angle glaucoma, moderate stage'),
    ('H4011X3', 'Primary open-angle glaucoma, severe stage'),
    ('H4011X4', 'Primary open-angle glaucoma, indeterminate stage'),
    ('H401210', 'Low-tension glaucoma, right eye, stage unspecified'),
    ('H401211', 'Low-tension glaucoma, right eye, mild stage'),
    ('H401212', 'Low-tension glaucoma, right eye, moderate stage'),
    ('H401213', 'Low-tension glaucoma, right eye, severe stage'),
    ('H401214', 'Low-tension glaucoma, right eye, indeterminate stage'),
    ('H401220', 'Low-tension glaucoma, left eye, stage unspecified'),
    ('H401221', 'Low-tension glaucoma, left eye, mild stage'),
    ('H401222', 'Low-tension glaucoma, left eye, moderate stage'),
    ('H401223', 'Low-tension glaucoma, left eye, severe stage'),
    ('H401224', 'Low-tension glaucoma, left eye, indeterminate stage'),
    ('H401230', 'Low-tension glaucoma, bilateral, stage unspecified'),
    ('H401231', 'Low-tension glaucoma, bilateral, mild stage'),
    ('H401232', 'Low-tension glaucoma, bilateral, moderate stage'),
    ('H401233', 'Low-tension glaucoma, bilateral, severe stage'),
    ('H401234', 'Low-tension glaucoma, bilateral, indeterminate stage'),
    ('H401290', 'Low-tension glaucoma, unspecified eye, stage unspecified'),
    ('H401291', 'Low-tension glaucoma, unspecified eye, mild stage'),
    ('H401292', 'Low-tension glaucoma, unspecified eye, moderate stage'),
    ('H401293', 'Low-tension glaucoma, unspecified eye, severe stage'),
    ('H401294', 'Low-tension glaucoma, unspecified eye, indeterminate stage'),
    ('H401310', 'Pigmentary glaucoma, right eye, stage unspecified'),
    ('H401311', 'Pigmentary glaucoma, right eye, mild stage'),
    ('H401312', 'Pigmentary glaucoma, right eye, moderate stage'),
    ('H401313', 'Pigmentary glaucoma, right eye, severe stage'),
    ('H401314', 'Pigmentary glaucoma, right eye, indeterminate stage'),
    ('H401320', 'Pigmentary glaucoma, left eye, stage unspecified'),
    ('H401321', 'Pigmentary glaucoma, left eye, mild stage'),
    ('H401322', 'Pigmentary glaucoma, left eye, moderate stage'),
    ('H401323', 'Pigmentary glaucoma, left eye, severe stage'),
    ('H401324', 'Pigmentary glaucoma, left eye, indeterminate stage'),
    ('H401330', 'Pigmentary glaucoma, bilateral, stage unspecified'),
    ('H401331', 'Pigmentary glaucoma, bilateral, mild stage'),
    ('H401332', 'Pigmentary glaucoma, bilateral, moderate stage'),
    ('H401333', 'Pigmentary glaucoma, bilateral, severe stage'),
    ('H401334', 'Pigmentary glaucoma, bilateral, indeterminate stage'),
    ('H401390', 'Pigmentary glaucoma, unspecified eye, stage unspecified'),
    ('H401391', 'Pigmentary glaucoma, unspecified eye, mild stage'),
    ('H401392', 'Pigmentary glaucoma, unspecified eye, moderate stage'),
    ('H401393', 'Pigmentary glaucoma, unspecified eye, severe stage'),
    ('H401394', 'Pigmentary glaucoma, unspecified eye, indeterminate stage'),
    ('H401410', 'Capslr glaucoma w/pseudxf lens, right eye, stage unsp'),
    ('H401411', 'Capslr glaucoma w/pseudxf lens, right eye, mild stage'),
    ('H401412', 'Capslr glaucoma w/pseudxf lens, right eye, moderate stage'),
    ('H401413', 'Capslr glaucoma w/pseudxf lens, right eye, severe stage'),
    ('H401414', 'Capslr glaucoma w/pseudxf lens, r eye, indeterminate stage'),
    ('H401420', 'Capslr glaucoma w/pseudxf lens, left eye, stage unsp'),
    ('H401421', 'Capslr glaucoma w/pseudxf lens, left eye, mild stage'),
    ('H401422', 'Capslr glaucoma w/pseudxf lens, left eye, moderate stage'),
    ('H401423', 'Capslr glaucoma w/pseudxf lens, left eye, severe stage'),
    ('H401424', 'Capslr glaucoma w/pseudxf lens, l eye, indeterminate stage'),
    ('H401430', 'Capslr glaucoma w/pseudxf lens, bilateral, stage unsp'),
    ('H401431', 'Capslr glaucoma w/pseudxf lens, bilateral, mild stage'),
    ('H401432', 'Capslr glaucoma w/pseudxf lens, bilateral, moderate stage'),
    ('H401433', 'Capslr glaucoma w/pseudxf lens, bilateral, severe stage'),
    ('H401434', 'Capslr glaucoma w/pseudxf lens, bi, indeterminate stage'),
    ('H401490', 'Capslr glaucoma w/pseudxf lens, unsp eye, stage unsp'),
    ('H401491', 'Capslr glaucoma w/pseudxf lens, unsp eye, mild stage'),
    ('H401492', 'Capslr glaucoma w/pseudxf lens, unsp eye, moderate stage'),
    ('H401493', 'Capslr glaucoma w/pseudxf lens, unsp eye, severe stage'),
    ('H401494', 'Capslr glaucoma w/pseudxf lens, unsp eye, indeterminate stg'),
    ('H40151', 'Residual stage of open-angle glaucoma, right eye'),
    ('H40152', 'Residual stage of open-angle glaucoma, left eye'),
    ('H40153', 'Residual stage of open-angle glaucoma, bilateral'),
    ('H40159', 'Residual stage of open-angle glaucoma, unspecified eye'),
    ('H4020X0', 'Unsp primary angle-closure glaucoma, stage unspecified'),
    ('H4020X1', 'Unspecified primary angle-closure glaucoma, mild stage'),
    ('H4020X2', 'Unspecified primary angle-closure glaucoma, moderate stage'),
    ('H4020X3', 'Unspecified primary angle-closure glaucoma, severe stage'),
    ('H4020X4', 'Unsp primary angle-closure glaucoma, indeterminate stage'),
    ('H40211', 'Acute angle-closure glaucoma, right eye'),
    ('H40212', 'Acute angle-closure glaucoma, left eye'),
    ('H40213', 'Acute angle-closure glaucoma, bilateral'),
    ('H40219', 'Acute angle-closure glaucoma, unspecified eye'),
    ('H402210', 'Chronic angle-closure glaucoma, right eye, stage unspecified'),
    ('H402211', 'Chronic angle-closure glaucoma, right eye, mild stage'),
    ('H402212', 'Chronic angle-closure glaucoma, right eye, moderate stage'),
    ('H402213', 'Chronic angle-closure glaucoma, right eye, severe stage'),
    ('H402214', 'Chronic angle-closure glaucoma, r eye, indeterminate stage'),
    ('H402220', 'Chronic angle-closure glaucoma, left eye, stage unspecified'),
    ('H402221', 'Chronic angle-closure glaucoma, left eye, mild stage'),
    ('H402222', 'Chronic angle-closure glaucoma, left eye, moderate stage'),
    ('H402223', 'Chronic angle-closure glaucoma, left eye, severe stage'),
    ('H402224', 'Chronic angle-closure glaucoma, l eye, indeterminate stage'),
    ('H402230', 'Chronic angle-closure glaucoma, bilateral, stage unspecified'),
    ('H402231', 'Chronic angle-closure glaucoma, bilateral, mild stage'),
    ('H402232', 'Chronic angle-closure glaucoma, bilateral, moderate stage'),
    ('H402233', 'Chronic angle-closure glaucoma, bilateral, severe stage'),
    ('H402234', 'Chronic angle-closure glaucoma, bi, indeterminate stage'),
    ('H402290', 'Chronic angle-closure glaucoma, unsp eye, stage unspecified'),
    ('H402291', 'Chronic angle-closure glaucoma, unspecified eye, mild stage'),
    ('H402292', 'Chronic angle-closure glaucoma, unsp eye, moderate stage'),
    ('H402293', 'Chronic angle-closure glaucoma, unsp eye, severe stage'),
    ('H402294', 'Chr angle-closure glaucoma, unsp eye, indeterminate stage'),
    ('H40231', 'Intermittent angle-closure glaucoma, right eye'),
    ('H40232', 'Intermittent angle-closure glaucoma, left eye'),
    ('H40233', 'Intermittent angle-closure glaucoma, bilateral'),
    ('H40239', 'Intermittent angle-closure glaucoma, unspecified eye'),
    ('H40241', 'Residual stage of angle-closure glaucoma, right eye'),
    ('H40242', 'Residual stage of angle-closure glaucoma, left eye'),
    ('H40243', 'Residual stage of angle-closure glaucoma, bilateral'),
    ('H40249', 'Residual stage of angle-closure glaucoma, unspecified eye'),
    ('H4030X0', 'Glaucoma secondary to eye trauma, unsp eye, stage unsp'),
    ('H4030X1', 'Glaucoma secondary to eye trauma, unsp eye, mild stage'),
    ('H4030X2', 'Glaucoma secondary to eye trauma, unsp eye, moderate stage'),
    ('H4030X3', 'Glaucoma secondary to eye trauma, unsp eye, severe stage'),
    ('H4030X4', 'Glaucoma sec to eye trauma, unsp eye, indeterminate stage'),
    ('H4031X0', 'Glaucoma secondary to eye trauma, right eye, stage unsp'),
    ('H4031X1', 'Glaucoma secondary to eye trauma, right eye, mild stage'),
    ('H4031X2', 'Glaucoma secondary to eye trauma, right eye, moderate stage'),
    ('H4031X3', 'Glaucoma secondary to eye trauma, right eye, severe stage'),
    ('H4031X4', 'Glaucoma secondary to eye trauma, r eye, indeterminate stage'),
    ('H4032X0', 'Glaucoma secondary to eye trauma, left eye, stage unsp'),
    ('H4032X1', 'Glaucoma secondary to eye trauma, left eye, mild stage'),
    ('H4032X2', 'Glaucoma secondary to eye trauma, left eye, moderate stage'),
    ('H4032X3', 'Glaucoma secondary to eye trauma, left eye, severe stage'),
    ('H4032X4', 'Glaucoma sec to eye trauma, left eye, indeterminate stage'),
    ('H4033X0', 'Glaucoma secondary to eye trauma, bilateral, stage unsp'),
    ('H4033X1', 'Glaucoma secondary to eye trauma, bilateral, mild stage'),
    ('H4033X2', 'Glaucoma secondary to eye trauma, bilateral, moderate stage'),
    ('H4033X3', 'Glaucoma secondary to eye trauma, bilateral, severe stage'),
    ('H4033X4', 'Glaucoma secondary to eye trauma, bi, indeterminate stage'),
    ('H4040X0', 'Glaucoma secondary to eye inflammation, unsp eye, stage unsp'),
    ('H4040X1', 'Glaucoma secondary to eye inflammation, unsp eye, mild stage'),
    ('H4040X2', 'Glaucoma secondary to eye inflam, unsp eye, moderate stage'),
    ('H4040X3', 'Glaucoma secondary to eye inflam, unsp eye, severe stage'),
    ('H4040X4', 'Glaucoma sec to eye inflam, unsp eye, indeterminate stage'),
    ('H4041X0', 'Glaucoma secondary to eye inflam, right eye, stage unsp'),
    ('H4041X1', 'Glaucoma secondary to eye inflam, right eye, mild stage'),
    ('H4041X2', 'Glaucoma secondary to eye inflam, right eye, moderate stage'),
    ('H4041X3', 'Glaucoma secondary to eye inflam, right eye, severe stage'),
    ('H4041X4', 'Glaucoma secondary to eye inflam, r eye, indeterminate stage'),
    ('H4042X0', 'Glaucoma secondary to eye inflammation, left eye, stage unsp'),
    ('H4042X1', 'Glaucoma secondary to eye inflammation, left eye, mild stage'),
    ('H4042X2', 'Glaucoma secondary to eye inflam, left eye, moderate stage'),
    ('H4042X3', 'Glaucoma secondary to eye inflam, left eye, severe stage'),
    ('H4042X4', 'Glaucoma sec to eye inflam, left eye, indeterminate stage'),
    ('H4043X0', 'Glaucoma secondary to eye inflam, bilateral, stage unsp'),
    ('H4043X1', 'Glaucoma secondary to eye inflam, bilateral, mild stage'),
    ('H4043X2', 'Glaucoma secondary to eye inflam, bilateral, moderate stage'),
    ('H4043X3', 'Glaucoma secondary to eye inflam, bilateral, severe stage'),
    ('H4043X4', 'Glaucoma secondary to eye inflam, bi, indeterminate stage'),
    ('H4050X0', 'Glaucoma secondary to oth eye disord, unsp eye, stage unsp'),
    ('H4050X1', 'Glaucoma secondary to oth eye disord, unsp eye, mild stage'),
    ('H4050X2', 'Glaucoma sec to oth eye disord, unsp eye, moderate stage'),
    ('H4050X3', 'Glaucoma secondary to oth eye disord, unsp eye, severe stage'),
    ('H4050X4', 'Glaucoma sec to oth eye disord, unsp eye, indeterminate stg'),
    ('H4051X0', 'Glaucoma secondary to oth eye disord, right eye, stage unsp'),
    ('H4051X1', 'Glaucoma secondary to oth eye disord, right eye, mild stage'),
    ('H4051X2', 'Glaucoma secondary to oth eye disord, r eye, moderate stage'),
    ('H4051X3', 'Glaucoma secondary to oth eye disord, r eye, severe stage'),
    ('H4051X4', 'Glaucoma sec to oth eye disord, r eye, indeterminate stage'),
    ('H4052X0', 'Glaucoma secondary to oth eye disord, left eye, stage unsp'),
    ('H4052X1', 'Glaucoma secondary to oth eye disord, left eye, mild stage'),
    ('H4052X2', 'Glaucoma sec to oth eye disord, left eye, moderate stage'),
    ('H4052X3', 'Glaucoma secondary to oth eye disord, left eye, severe stage'),
    ('H4052X4', 'Glaucoma sec to oth eye disord, l eye, indeterminate stage'),
    ('H4053X0', 'Glaucoma secondary to oth eye disorders, bi, stage unsp'),
    ('H4053X1', 'Glaucoma secondary to oth eye disorders, bi, mild stage'),
    ('H4053X2', 'Glaucoma secondary to oth eye disorders, bi, moderate stage'),
    ('H4053X3', 'Glaucoma secondary to oth eye disorders, bi, severe stage'),
    ('H4053X4', 'Glaucoma sec to oth eye disord, bi, indeterminate stage'),
    ('H4060X0', 'Glaucoma secondary to drugs, unsp eye, stage unspecified'),
    ('H4060X1', 'Glaucoma secondary to drugs, unspecified eye, mild stage'),
    ('H4060X2', 'Glaucoma secondary to drugs, unspecified eye, moderate stage'),
    ('H4060X3', 'Glaucoma secondary to drugs, unspecified eye, severe stage'),
    ('H4060X4', 'Glaucoma secondary to drugs, unsp eye, indeterminate stage'),
    ('H4061X0', 'Glaucoma secondary to drugs, right eye, stage unspecified'),
    ('H4061X1', 'Glaucoma secondary to drugs, right eye, mild stage'),
    ('H4061X2', 'Glaucoma secondary to drugs, right eye, moderate stage'),
    ('H4061X3', 'Glaucoma secondary to drugs, right eye, severe stage'),
    ('H4061X4', 'Glaucoma secondary to drugs, right eye, indeterminate stage'),
    ('H4062X0', 'Glaucoma secondary to drugs, left eye, stage unspecified'),
    ('H4062X1', 'Glaucoma secondary to drugs, left eye, mild stage'),
    ('H4062X2', 'Glaucoma secondary to drugs, left eye, moderate stage'),
    ('H4062X3', 'Glaucoma secondary to drugs, left eye, severe stage'),
    ('H4062X4', 'Glaucoma secondary to drugs, left eye, indeterminate stage'),
    ('H4063X0', 'Glaucoma secondary to drugs, bilateral, stage unspecified'),
    ('H4063X1', 'Glaucoma secondary to drugs, bilateral, mild stage'),
    ('H4063X2', 'Glaucoma secondary to drugs, bilateral, moderate stage'),
    ('H4063X3', 'Glaucoma secondary to drugs, bilateral, severe stage'),
    ('H4063X4', 'Glaucoma secondary to drugs, bilateral, indeterminate stage'),
    ('H40811', 'Glaucoma w increased episcleral venous pressure, right eye'),
    ('H40812', 'Glaucoma with increased episcleral venous pressure, left eye'),
    ('H40813', 'Glaucoma w increased episcleral venous pressure, bilateral'),
    ('H40819', 'Glaucoma with increased episcleral venous pressure, unsp eye'),
    ('H40821', 'Hypersecretion glaucoma, right eye'),
    ('H40822', 'Hypersecretion glaucoma, left eye'),
    ('H40823', 'Hypersecretion glaucoma, bilateral'),
    ('H40829', 'Hypersecretion glaucoma, unspecified eye'),
    ('H40831', 'Aqueous misdirection, right eye'),
    ('H40832', 'Aqueous misdirection, left eye'),
    ('H40833', 'Aqueous misdirection, bilateral'),
    ('H40839', 'Aqueous misdirection, unspecified eye'),
    ('H4089', 'Other specified glaucoma'),
    ('H409', 'Unspecified glaucoma'),
    ('H42', 'Glaucoma in diseases classified elsewhere'),
    ('H4300', 'Vitreous prolapse, unspecified eye'),
    ('H4301', 'Vitreous prolapse, right eye'),
    ('H4302', 'Vitreous prolapse, left eye'),
    ('H4303', 'Vitreous prolapse, bilateral'),
    ('H4310', 'Vitreous hemorrhage, unspecified eye'),
    ('H4311', 'Vitreous hemorrhage, right eye'),
    ('H4312', 'Vitreous hemorrhage, left eye'),
    ('H4313', 'Vitreous hemorrhage, bilateral'),
    ('H4320', 'Crystalline deposits in vitreous body, unspecified eye'),
    ('H4321', 'Crystalline deposits in vitreous body, right eye'),
    ('H4322', 'Crystalline deposits in vitreous body, left eye'),
    ('H4323', 'Crystalline deposits in vitreous body, bilateral'),
    ('H43311', 'Vitreous membranes and strands, right eye'),
    ('H43312', 'Vitreous membranes and strands, left eye'),
    ('H43313', 'Vitreous membranes and strands, bilateral'),
    ('H43319', 'Vitreous membranes and strands, unspecified eye'),
    ('H43391', 'Other vitreous opacities, right eye'),
    ('H43392', 'Other vitreous opacities, left eye'),
    ('H43393', 'Other vitreous opacities, bilateral'),
    ('H43399', 'Other vitreous opacities, unspecified eye'),
    ('H43811', 'Vitreous degeneration, right eye'),
    ('H43812', 'Vitreous degeneration, left eye'),
    ('H43813', 'Vitreous degeneration, bilateral'),
    ('H43819', 'Vitreous degeneration, unspecified eye'),
    ('H43821', 'Vitreomacular adhesion, right eye'),
    ('H43822', 'Vitreomacular adhesion, left eye'),
    ('H43823', 'Vitreomacular adhesion, bilateral'),
    ('H43829', 'Vitreomacular adhesion, unspecified eye'),
    ('H4389', 'Other disorders of vitreous body'),
    ('H439', 'Unspecified disorder of vitreous body'),
    ('H44001', 'Unspecified purulent endophthalmitis, right eye'),
    ('H44002', 'Unspecified purulent endophthalmitis, left eye'),
    ('H44003', 'Unspecified purulent endophthalmitis, bilateral'),
    ('H44009', 'Unspecified purulent endophthalmitis, unspecified eye'),
    ('H44011', 'Panophthalmitis (acute), right eye'),
    ('H44012', 'Panophthalmitis (acute), left eye'),
    ('H44013', 'Panophthalmitis (acute), bilateral'),
    ('H44019', 'Panophthalmitis (acute), unspecified eye'),
    ('H44021', 'Vitreous abscess (chronic), right eye'),
    ('H44022', 'Vitreous abscess (chronic), left eye'),
    ('H44023', 'Vitreous abscess (chronic), bilateral'),
    ('H44029', 'Vitreous abscess (chronic), unspecified eye'),
    ('H44111', 'Panuveitis, right eye'),
    ('H44112', 'Panuveitis, left eye'),
    ('H44113', 'Panuveitis, bilateral'),
    ('H44119', 'Panuveitis, unspecified eye'),
    ('H44121', 'Parasitic endophthalmitis, unspecified, right eye'),
    ('H44122', 'Parasitic endophthalmitis, unspecified, left eye'),
    ('H44123', 'Parasitic endophthalmitis, unspecified, bilateral'),
    ('H44129', 'Parasitic endophthalmitis, unspecified, unspecified eye'),
    ('H44131', 'Sympathetic uveitis, right eye'),
    ('H44132', 'Sympathetic uveitis, left eye'),
    ('H44133', 'Sympathetic uveitis, bilateral'),
    ('H44139', 'Sympathetic uveitis, unspecified eye'),
    ('H4419', 'Other endophthalmitis'),
    ('H4420', 'Degenerative myopia, unspecified eye'),
    ('H4421', 'Degenerative myopia, right eye'),
    ('H4422', 'Degenerative myopia, left eye'),
    ('H4423', 'Degenerative myopia, bilateral'),
    ('H442A1', 'Degeneratv myopia with choroidal neovascularization, r eye'),
    ('H442A2', 'Degeneratv myopia with choroidal neovascularization, l eye'),
    ('H442A3', 'Degeneratv myopia with choroidal neovascularization, bi eye'),
    ('H442A9', 'Degenerative myopia with choroidal neovascularization, unsp'),
    ('H442B1', 'Degenerative myopia with macular hole, right eye'),
    ('H442B2', 'Degenerative myopia with macular hole, left eye'),
    ('H442B3', 'Degenerative myopia with macular hole, bilateral eye'),
    ('H442B9', 'Degenerative myopia with macular hole, unspecified eye'),
    ('H442C1', 'Degenerative myopia with retinal detachment, right eye'),
    ('H442C2', 'Degenerative myopia with retinal detachment, left eye'),
    ('H442C3', 'Degenerative myopia with retinal detachment, bilateral eye'),
    ('H442C9', 'Degenerative myopia with retinal detachment, unspecified eye'),
    ('H442D1', 'Degenerative myopia with foveoschisis, right eye'),
    ('H442D2', 'Degenerative myopia with foveoschisis, left eye'),
    ('H442D3', 'Degenerative myopia with foveoschisis, bilateral eye'),
    ('H442D9', 'Degenerative myopia with foveoschisis, unspecified eye'),
    ('H442E1', 'Degenerative myopia with other maculopathy, right eye'),
    ('H442E2', 'Degenerative myopia with other maculopathy, left eye'),
    ('H442E3', 'Degenerative myopia with other maculopathy, bilateral eye'),
    ('H442E9', 'Degenerative myopia with other maculopathy, unspecified eye'),
    ('H4430', 'Unspecified degenerative disorder of globe'),
    ('H44311', 'Chalcosis, right eye'),
    ('H44312', 'Chalcosis, left eye'),
    ('H44313', 'Chalcosis, bilateral'),
    ('H44319', 'Chalcosis, unspecified eye'),
    ('H44321', 'Siderosis of eye, right eye'),
    ('H44322', 'Siderosis of eye, left eye'),
    ('H44323', 'Siderosis of eye, bilateral'),
    ('H44329', 'Siderosis of eye, unspecified eye'),
    ('H44391', 'Other degenerative disorders of globe, right eye'),
    ('H44392', 'Other degenerative disorders of globe, left eye'),
    ('H44393', 'Other degenerative disorders of globe, bilateral'),
    ('H44399', 'Other degenerative disorders of globe, unspecified eye'),
    ('H4440', 'Unspecified hypotony of eye'),
    ('H44411', 'Flat anterior chamber hypotony of right eye'),
    ('H44412', 'Flat anterior chamber hypotony of left eye'),
    ('H44413', 'Flat anterior chamber hypotony of eye, bilateral'),
    ('H44419', 'Flat anterior chamber hypotony of unspecified eye'),
    ('H44421', 'Hypotony of right eye due to ocular fistula'),
    ('H44422', 'Hypotony of left eye due to ocular fistula'),
    ('H44423', 'Hypotony of eye due to ocular fistula, bilateral'),
    ('H44429', 'Hypotony of unspecified eye due to ocular fistula'),
    ('H44431', 'Hypotony of eye due to other ocular disorders, right eye'),
    ('H44432', 'Hypotony of eye due to other ocular disorders, left eye'),
    ('H44433', 'Hypotony of eye due to other ocular disorders, bilateral'),
    ('H44439', 'Hypotony of eye due to other ocular disorders, unsp eye'),
    ('H44441', 'Primary hypotony of right eye'),
    ('H44442', 'Primary hypotony of left eye'),
    ('H44443', 'Primary hypotony of eye, bilateral'),
    ('H44449', 'Primary hypotony of unspecified eye'),
    ('H4450', 'Unspecified degenerated conditions of globe'),
    ('H44511', 'Absolute glaucoma, right eye'),
    ('H44512', 'Absolute glaucoma, left eye'),
    ('H44513', 'Absolute glaucoma, bilateral'),
    ('H44519', 'Absolute glaucoma, unspecified eye'),
    ('H44521', 'Atrophy of globe, right eye'),
    ('H44522', 'Atrophy of globe, left eye'),
    ('H44523', 'Atrophy of globe, bilateral'),
    ('H44529', 'Atrophy of globe, unspecified eye'),
    ('H44531', 'Leucocoria, right eye'),
    ('H44532', 'Leucocoria, left eye'),
    ('H44533', 'Leucocoria, bilateral'),
    ('H44539', 'Leucocoria, unspecified eye'),
    ('H44601', 'Unsp retained (old) intraocular fb, magnetic, right eye'),
    ('H44602', 'Unsp retained (old) intraocular fb, magnetic, left eye'),
    ('H44603', 'Unsp retained (old) intraocular fb, magnetic, bilateral'),
    ('H44609', 'Unsp retained (old) intraocular fb, magnetic, unsp eye'),
    ('H44611', 'Retained (old) magnetic fb in ant chamber, right eye'),
    ('H44612', 'Retained (old) magnetic fb in ant chamber, left eye'),
    ('H44613', 'Retained (old) magnetic fb in ant chamber, bilateral'),
    ('H44619', 'Retained (old) magnetic fb in ant chamber, unsp eye'),
    ('H44621', 'Retained (old) magnetic fb in iris or ciliary body, r eye'),
    ('H44622', 'Retained (old) magnetic fb in iris or ciliary body, left eye'),
    ('H44623', 'Retained (old) magnetic fb in iris or ciliary body, bi'),
    ('H44629', 'Retained (old) magnetic fb in iris or ciliary body, unsp eye'),
    ('H44631', 'Retained (old) magnetic foreign body in lens, right eye'),
    ('H44632', 'Retained (old) magnetic foreign body in lens, left eye'),
    ('H44633', 'Retained (old) magnetic foreign body in lens, bilateral'),
    ('H44639', 'Retained (old) magnetic foreign body in lens, unsp eye'),
    ('H44641', 'Retained (old) magnetic fb in post wall of globe, right eye'),
    ('H44642', 'Retained (old) magnetic fb in post wall of globe, left eye'),
    ('H44643', 'Retained (old) magnetic fb in posterior wall of globe, bi'),
    ('H44649', 'Retained (old) magnetic fb in post wall of globe, unsp eye'),
    ('H44651', 'Retained (old) magnetic fb in vitreous body, right eye'),
    ('H44652', 'Retained (old) magnetic fb in vitreous body, left eye'),
    ('H44653', 'Retained (old) magnetic fb in vitreous body, bilateral'),
    ('H44659', 'Retained (old) magnetic fb in vitreous body, unsp eye'),
    ('H44691', 'Retain (old) intraoc fb, magnet, in oth or mult sites, r eye'),
    ('H44692', 'Retain (old) intraoc fb, magnet, in oth or mult sites, l eye'),
    ('H44693', 'Retained (old) intraoc fb, magnet, in oth or mult sites, bi'),
    ('H44699', 'Retain intraoc fb, magnet, in oth or mult sites, unsp eye'),
    ('H44701', 'Unsp retained (old) intraocular fb, nonmagnetic, right eye'),
    ('H44702', 'Unsp retained (old) intraocular fb, nonmagnetic, left eye'),
    ('H44703', 'Unsp retained (old) intraocular fb, nonmagnetic, bilateral'),
    ('H44709', 'Unsp retained (old) intraocular fb, nonmagnetic, unsp eye'),
    ('H44711', 'Retained (old) foreign body in ant chamber, right eye'),
    ('H44712', 'Retained (old) foreign body in ant chamber, left eye'),
    ('H44713', 'Retained (old) foreign body in ant chamber, bilateral'),
    ('H44719', 'Retained (old) foreign body in ant chamber, unsp eye'),
    ('H44721', 'Retained (old) fb in iris or ciliary body, right eye'),
    ('H44722', 'Retained (old) fb in iris or ciliary body, left eye'),
    ('H44723', 'Retained (old) fb in iris or ciliary body, bilateral'),
    ('H44729', 'Retained (old) fb in iris or ciliary body, unsp eye'),
    ('H44731', 'Retained (nonmagnetic) (old) foreign body in lens, right eye'),
    ('H44732', 'Retained (nonmagnetic) (old) foreign body in lens, left eye'),
    ('H44733', 'Retained (nonmagnetic) (old) foreign body in lens, bilateral'),
    ('H44739', 'Retained (nonmagnetic) (old) foreign body in lens, unsp eye'),
    ('H44741', 'Retained (old) fb in posterior wall of globe, right eye'),
    ('H44742', 'Retained (old) fb in posterior wall of globe, left eye'),
    ('H44743', 'Retained (old) fb in posterior wall of globe, bilateral'),
    ('H44749', 'Retained (old) fb in posterior wall of globe, unsp eye'),
    ('H44751', 'Retained (old) foreign body in vitreous body, right eye'),
    ('H44752', 'Retained (old) foreign body in vitreous body, left eye'),
    ('H44753', 'Retained (old) foreign body in vitreous body, bilateral'),
    ('H44759', 'Retained (old) foreign body in vitreous body, unsp eye'),
    ('H44791', 'Retain (old) intraoc fb, nonmag, in oth or mult sites, r eye'),
    ('H44792', 'Retain (old) intraoc fb, nonmag, in oth or mult sites, l eye'),
    ('H44793', 'Retained (old) intraoc fb, nonmag, in oth or mult sites, bi'),
    ('H44799', 'Retain intraoc fb, nonmag, in oth or mult sites, unsp eye'),
    ('H44811', 'Hemophthalmos, right eye'),
    ('H44812', 'Hemophthalmos, left eye'),
    ('H44813', 'Hemophthalmos, bilateral'),
    ('H44819', 'Hemophthalmos, unspecified eye'),
    ('H44821', 'Luxation of globe, right eye'),
    ('H44822', 'Luxation of globe, left eye'),
    ('H44823', 'Luxation of globe, bilateral'),
    ('H44829', 'Luxation of globe, unspecified eye'),
    ('H4489', 'Other disorders of globe'),
    ('H449', 'Unspecified disorder of globe'),
    ('H4600', 'Optic papillitis, unspecified eye'),
    ('H4601', 'Optic papillitis, right eye'),
    ('H4602', 'Optic papillitis, left eye'),
    ('H4603', 'Optic papillitis, bilateral'),
    ('H4610', 'Retrobulbar neuritis, unspecified eye'),
    ('H4611', 'Retrobulbar neuritis, right eye'),
    ('H4612', 'Retrobulbar neuritis, left eye'),
    ('H4613', 'Retrobulbar neuritis, bilateral'),
    ('H462', 'Nutritional optic neuropathy'),
    ('H463', 'Toxic optic neuropathy'),
    ('H468', 'Other optic neuritis'),
    ('H469', 'Unspecified optic neuritis'),
    ('H47011', 'Ischemic optic neuropathy, right eye'),
    ('H47012', 'Ischemic optic neuropathy, left eye'),
    ('H47013', 'Ischemic optic neuropathy, bilateral'),
    ('H47019', 'Ischemic optic neuropathy, unspecified eye'),
    ('H47021', 'Hemorrhage in optic nerve sheath, right eye'),
    ('H47022', 'Hemorrhage in optic nerve sheath, left eye'),
    ('H47023', 'Hemorrhage in optic nerve sheath, bilateral'),
    ('H47029', 'Hemorrhage in optic nerve sheath, unspecified eye'),
    ('H47031', 'Optic nerve hypoplasia, right eye'),
    ('H47032', 'Optic nerve hypoplasia, left eye'),
    ('H47033', 'Optic nerve hypoplasia, bilateral'),
    ('H47039', 'Optic nerve hypoplasia, unspecified eye'),
    ('H47091', 'Oth disorders of optic nerve, NEC, right eye'),
    ('H47092', 'Oth disorders of optic nerve, NEC, left eye'),
    ('H47093', 'Oth disorders of optic nerve, NEC, bilateral'),
    ('H47099', 'Oth disorders of optic nerve, NEC, unsp eye'),
    ('H4710', 'Unspecified papilledema'),
    ('H4711', 'Papilledema associated with increased intracranial pressure'),
    ('H4712', 'Papilledema associated with decreased ocular pressure'),
    ('H4713', 'Papilledema associated with retinal disorder'),
    ('H47141', 'Foster-Kennedy syndrome, right eye'),
    ('H47142', 'Foster-Kennedy syndrome, left eye'),
    ('H47143', 'Foster-Kennedy syndrome, bilateral'),
    ('H47149', 'Foster-Kennedy syndrome, unspecified eye'),
    ('H4720', 'Unspecified optic atrophy'),
    ('H47211', 'Primary optic atrophy, right eye'),
    ('H47212', 'Primary optic atrophy, left eye'),
    ('H47213', 'Primary optic atrophy, bilateral'),
    ('H47219', 'Primary optic atrophy, unspecified eye'),
    ('H4722', 'Hereditary optic atrophy'),
    ('H47231', 'Glaucomatous optic atrophy, right eye'),
    ('H47232', 'Glaucomatous optic atrophy, left eye'),
    ('H47233', 'Glaucomatous optic atrophy, bilateral'),
    ('H47239', 'Glaucomatous optic atrophy, unspecified eye'),
    ('H47291', 'Other optic atrophy, right eye'),
    ('H47292', 'Other optic atrophy, left eye'),
    ('H47293', 'Other optic atrophy, bilateral'),
    ('H47299', 'Other optic atrophy, unspecified eye'),
    ('H47311', 'Coloboma of optic disc, right eye'),
    ('H47312', 'Coloboma of optic disc, left eye'),
    ('H47313', 'Coloboma of optic disc, bilateral'),
    ('H47319', 'Coloboma of optic disc, unspecified eye'),
    ('H47321', 'Drusen of optic disc, right eye'),
    ('H47322', 'Drusen of optic disc, left eye'),
    ('H47323', 'Drusen of optic disc, bilateral'),
    ('H47329', 'Drusen of optic disc, unspecified eye'),
    ('H47331', 'Pseudopapilledema of optic disc, right eye'),
    ('H47332', 'Pseudopapilledema of optic disc, left eye'),
    ('H47333', 'Pseudopapilledema of optic disc, bilateral'),
    ('H47339', 'Pseudopapilledema of optic disc, unspecified eye'),
    ('H47391', 'Other disorders of optic disc, right eye'),
    ('H47392', 'Other disorders of optic disc, left eye'),
    ('H47393', 'Other disorders of optic disc, bilateral'),
    ('H47399', 'Other disorders of optic disc, unspecified eye'),
    ('H4741', 'Disorders of optic chiasm in (due to) inflammatory disorders'),
    ('H4742', 'Disorders of optic chiasm in (due to) neoplasm'),
    ('H4743', 'Disorders of optic chiasm in (due to) vascular disorders'),
    ('H4749', 'Disorders of optic chiasm in (due to) other disorders'),
    ('H47511', 'Disord of visual pathways in inflam disord, right side'),
    ('H47512', 'Disord of visual pathways in inflam disord, left side'),
    ('H47519', 'Disord of visual pathways in inflam disord, unsp side'),
    ('H47521', 'Disord of visual pathways in (due to) neoplasm, right side'),
    ('H47522', 'Disorders of visual pathways in (due to) neoplasm, left side'),
    ('H47529', 'Disorders of visual pathways in (due to) neoplasm, unsp side'),
    ('H47531', 'Disord of visual pathways in vascular disord, right side'),
    ('H47532', 'Disord of visual pathways in vascular disord, left side'),
    ('H47539', 'Disord of visual pathways in vascular disord, unsp side'),
    ('H47611', 'Cortical blindness, right side of brain'),
    ('H47612', 'Cortical blindness, left side of brain'),
    ('H47619', 'Cortical blindness, unspecified side of brain'),
    ('H47621', 'Disord of visual cortex in inflam disord, r side of brain'),
    ('H47622', 'Disord of visual cortex in inflam disord, left side of brain'),
    ('H47629', 'Disord of visual cortex in inflam disord, unsp side of brain'),
    ('H47631', 'Disord of visual cortex in neoplasm, right side of brain'),
    ('H47632', 'Disord of visual cortex in neoplasm, left side of brain'),
    ('H47639', 'Disord of visual cortex in neoplasm, unsp side of brain'),
    ('H47641', 'Disord of visual cortex in vasc disord, right side of brain'),
    ('H47642', 'Disord of visual cortex in vasc disord, left side of brain'),
    ('H47649', 'Disord of visual cortex in vasc disord, unsp side of brain'),
    ('H479', 'Unspecified disorder of visual pathways'),
    ('H4900', 'Third [oculomotor] nerve palsy, unspecified eye'),
    ('H4901', 'Third [oculomotor] nerve palsy, right eye'),
    ('H4902', 'Third [oculomotor] nerve palsy, left eye'),
    ('H4903', 'Third [oculomotor] nerve palsy, bilateral'),
    ('H4910', 'Fourth [trochlear] nerve palsy, unspecified eye'),
    ('H4911', 'Fourth [trochlear] nerve palsy, right eye'),
    ('H4912', 'Fourth [trochlear] nerve palsy, left eye'),
    ('H4913', 'Fourth [trochlear] nerve palsy, bilateral'),
    ('H4920', 'Sixth [abducent] nerve palsy, unspecified eye'),
    ('H4921', 'Sixth [abducent] nerve palsy, right eye'),
    ('H4922', 'Sixth [abducent] nerve palsy, left eye'),
    ('H4923', 'Sixth [abducent] nerve palsy, bilateral'),
    ('H4930', 'Total (external) ophthalmoplegia, unspecified eye'),
    ('H4931', 'Total (external) ophthalmoplegia, right eye'),
    ('H4932', 'Total (external) ophthalmoplegia, left eye'),
    ('H4933', 'Total (external) ophthalmoplegia, bilateral'),
    ('H4940', 'Progressive external ophthalmoplegia, unspecified eye'),
    ('H4941', 'Progressive external ophthalmoplegia, right eye'),
    ('H4942', 'Progressive external ophthalmoplegia, left eye'),
    ('H4943', 'Progressive external ophthalmoplegia, bilateral'),
    ('H49811', 'Kearns-Sayre syndrome, right eye'),
    ('H49812', 'Kearns-Sayre syndrome, left eye'),
    ('H49813', 'Kearns-Sayre syndrome, bilateral'),
    ('H49819', 'Kearns-Sayre syndrome, unspecified eye'),
    ('H49881', 'Other paralytic strabismus, right eye'),
    ('H49882', 'Other paralytic strabismus, left eye'),
    ('H49883', 'Other paralytic strabismus, bilateral'),
    ('H49889', 'Other paralytic strabismus, unspecified eye'),
    ('H499', 'Unspecified paralytic strabismus'),
    ('H5000', 'Unspecified esotropia'),
    ('H50011', 'Monocular esotropia, right eye'),
    ('H50012', 'Monocular esotropia, left eye'),
    ('H50021', 'Monocular esotropia with A pattern, right eye'),
    ('H50022', 'Monocular esotropia with A pattern, left eye'),
    ('H50031', 'Monocular esotropia with V pattern, right eye'),
    ('H50032', 'Monocular esotropia with V pattern, left eye'),
    ('H50041', 'Monocular esotropia with other noncomitancies, right eye'),
    ('H50042', 'Monocular esotropia with other noncomitancies, left eye'),
    ('H5005', 'Alternating esotropia'),
    ('H5006', 'Alternating esotropia with A pattern'),
    ('H5007', 'Alternating esotropia with V pattern'),
    ('H5008', 'Alternating esotropia with other noncomitancies'),
    ('H5010', 'Unspecified exotropia'),
    ('H50111', 'Monocular exotropia, right eye'),
    ('H50112', 'Monocular exotropia, left eye'),
    ('H50121', 'Monocular exotropia with A pattern, right eye'),
    ('H50122', 'Monocular exotropia with A pattern, left eye'),
    ('H50131', 'Monocular exotropia with V pattern, right eye'),
    ('H50132', 'Monocular exotropia with V pattern, left eye'),
    ('H50141', 'Monocular exotropia with other noncomitancies, right eye'),
    ('H50142', 'Monocular exotropia with other noncomitancies, left eye'),
    ('H5015', 'Alternating exotropia'),
    ('H5016', 'Alternating exotropia with A pattern'),
    ('H5017', 'Alternating exotropia with V pattern'),
    ('H5018', 'Alternating exotropia with other noncomitancies'),
    ('H5021', 'Vertical strabismus, right eye'),
    ('H5022', 'Vertical strabismus, left eye'),
    ('H5030', 'Unspecified intermittent heterotropia'),
    ('H50311', 'Intermittent monocular esotropia, right eye'),
    ('H50312', 'Intermittent monocular esotropia, left eye'),
    ('H5032', 'Intermittent alternating esotropia'),
    ('H50331', 'Intermittent monocular exotropia, right eye'),
    ('H50332', 'Intermittent monocular exotropia, left eye'),
    ('H5034', 'Intermittent alternating exotropia'),
    ('H5040', 'Unspecified heterotropia'),
    ('H50411', 'Cyclotropia, right eye'),
    ('H50412', 'Cyclotropia, left eye'),
    ('H5042', 'Monofixation syndrome'),
    ('H5043', 'Accommodative component in esotropia'),
    ('H5050', 'Unspecified heterophoria'),
    ('H5051', 'Esophoria'),
    ('H5052', 'Exophoria'),
    ('H5053', 'Vertical heterophoria'),
    ('H5054', 'Cyclophoria'),
    ('H5055', 'Alternating heterophoria'),
    ('H5060', 'Mechanical strabismus, unspecified'),
    ('H50611', "Brown's sheath syndrome, right eye"),
    ('H50612', "Brown's sheath syndrome, left eye"),
    ('H50621', 'Inferior oblique muscle entrapment, right eye'),
    ('H50622', 'Inferior oblique muscle entrapment, left eye'),
    ('H50629', 'Inferior oblique muscle entrapment, unspecified eye'),
    ('H50631', 'Inferior rectus muscle entrapment, right eye'),
    ('H50632', 'Inferior rectus muscle entrapment, left eye'),
    ('H50639', 'Inferior rectus muscle entrapment, unspecified eye'),
    ('H50641', 'Lateral rectus muscle entrapment, right eye'),
    ('H50642', 'Lateral rectus muscle entrapment, left eye'),
    ('H50649', 'Lateral rectus muscle entrapment, unspecified eye'),
    ('H50651', 'Medial rectus muscle entrapment, right eye'),
    ('H50652', 'Medial rectus muscle entrapment, left eye'),
    ('H50659', 'Medial rectus muscle entrapment, unspecified eye'),
    ('H50661', 'Superior oblique muscle entrapment, right eye'),
    ('H50662', 'Superior oblique muscle entrapment, left eye'),
    ('H50669', 'Superior oblique muscle entrapment, unspecified eye'),
    ('H50671', 'Superior rectus muscle entrapment, right eye'),
    ('H50672', 'Superior rectus muscle entrapment, left eye'),
    ('H50679', 'Superior rectus muscle entrapment, unspecified eye'),
    ('H50681', 'Extraocular muscle entrapment, unspecified, right eye'),
    ('H50682', 'Extraocular muscle entrapment, unspecified, left eye'),
    ('H50689', 'Extraocular muscle entrapment, unspecified, unspecified eye'),
    ('H5069', 'Other mechanical strabismus'),
    ('H50811', "Duane's syndrome, right eye"),
    ('H50812', "Duane's syndrome, left eye"),
    ('H5089', 'Other specified strabismus'),
    ('H509', 'Unspecified strabismus'),
    ('H510', 'Palsy (spasm) of conjugate gaze'),
    ('H5111', 'Convergence insufficiency'),
    ('H5112', 'Convergence excess'),
    ('H5120', 'Internuclear ophthalmoplegia, unspecified eye'),
    ('H5121', 'Internuclear ophthalmoplegia, right eye'),
    ('H5122', 'Internuclear ophthalmoplegia, left eye'),
    ('H5123', 'Internuclear ophthalmoplegia, bilateral'),
    ('H518', 'Other specified disorders of binocular movement'),
    ('H519', 'Unspecified disorder of binocular movement'),
    ('H5200', 'Hypermetropia, unspecified eye'),
    ('H5201', 'Hypermetropia, right eye'),
    ('H5202', 'Hypermetropia, left eye'),
    ('H5203', 'Hypermetropia, bilateral'),
    ('H5210', 'Myopia, unspecified eye'),
    ('H5211', 'Myopia, right eye'),
    ('H5212', 'Myopia, left eye'),
    ('H5213', 'Myopia, bilateral'),
    ('H52201', 'Unspecified astigmatism, right eye'),
    ('H52202', 'Unspecified astigmatism, left eye'),
    ('H52203', 'Unspecified astigmatism, bilateral'),
    ('H52209', 'Unspecified astigmatism, unspecified eye'),
    ('H52211', 'Irregular astigmatism, right eye'),
    ('H52212', 'Irregular astigmatism, left eye'),
    ('H52213', 'Irregular astigmatism, bilateral'),
    ('H52219', 'Irregular astigmatism, unspecified eye'),
    ('H52221', 'Regular astigmatism, right eye'),
    ('H52222', 'Regular astigmatism, left eye'),
    ('H52223', 'Regular astigmatism, bilateral'),
    ('H52229', 'Regular astigmatism, unspecified eye'),
    ('H5231', 'Anisometropia'),
    ('H5232', 'Aniseikonia'),
    ('H524', 'Presbyopia'),
    ('H52511', 'Internal ophthalmoplegia (complete) (total), right eye'),
    ('H52512', 'Internal ophthalmoplegia (complete) (total), left eye'),
    ('H52513', 'Internal ophthalmoplegia (complete) (total), bilateral'),
    ('H52519', 'Internal ophthalmoplegia (complete) (total), unspecified eye'),
    ('H52521', 'Paresis of accommodation, right eye'),
    ('H52522', 'Paresis of accommodation, left eye'),
    ('H52523', 'Paresis of accommodation, bilateral'),
    ('H52529', 'Paresis of accommodation, unspecified eye'),
    ('H52531', 'Spasm of accommodation, right eye'),
    ('H52532', 'Spasm of accommodation, left eye'),
    ('H52533', 'Spasm of accommodation, bilateral'),
    ('H52539', 'Spasm of accommodation, unspecified eye'),
    ('H526', 'Other disorders of refraction'),
    ('H527', 'Unspecified disorder of refraction'),
    ('H53001', 'Unspecified amblyopia, right eye'),
    ('H53002', 'Unspecified amblyopia, left eye'),
    ('H53003', 'Unspecified amblyopia, bilateral'),
    ('H53009', 'Unspecified amblyopia, unspecified eye'),
    ('H53011', 'Deprivation amblyopia, right eye'),
    ('H53012', 'Deprivation amblyopia, left eye'),
    ('H53013', 'Deprivation amblyopia, bilateral'),
    ('H53019', 'Deprivation amblyopia, unspecified eye'),
    ('H53021', 'Refractive amblyopia, right eye'),
    ('H53022', 'Refractive amblyopia, left eye'),
    ('H53023', 'Refractive amblyopia, bilateral'),
    ('H53029', 'Refractive amblyopia, unspecified eye'),
    ('H53031', 'Strabismic amblyopia, right eye'),
    ('H53032', 'Strabismic amblyopia, left eye'),
    ('H53033', 'Strabismic amblyopia, bilateral'),
    ('H53039', 'Strabismic amblyopia, unspecified eye'),
    ('H53041', 'Amblyopia suspect, right eye'),
    ('H53042', 'Amblyopia suspect, left eye'),
    ('H53043', 'Amblyopia suspect, bilateral'),
    ('H53049', 'Amblyopia suspect, unspecified eye'),
    ('H5310', 'Unspecified subjective visual disturbances'),
    ('H5311', 'Day blindness'),
    ('H53121', 'Transient visual loss, right eye'),
    ('H53122', 'Transient visual loss, left eye'),
    ('H53123', 'Transient visual loss, bilateral'),
    ('H53129', 'Transient visual loss, unspecified eye'),
    ('H53131', 'Sudden visual loss, right eye'),
    ('H53132', 'Sudden visual loss, left eye'),
    ('H53133', 'Sudden visual loss, bilateral'),
    ('H53139', 'Sudden visual loss, unspecified eye'),
    ('H53141', 'Visual discomfort, right eye'),
    ('H53142', 'Visual discomfort, left eye'),
    ('H53143', 'Visual discomfort, bilateral'),
    ('H53149', 'Visual discomfort, unspecified'),
    ('H5315', 'Visual distortions of shape and size'),
    ('H5316', 'Psychophysical visual disturbances'),
    ('H5319', 'Other subjective visual disturbances'),
    ('H532', 'Diplopia'),
    ('H5330', 'Unspecified disorder of binocular vision'),
    ('H5331', 'Abnormal retinal correspondence'),
    ('H5332', 'Fusion with defective stereopsis'),
    ('H5333', 'Simultaneous visual perception without fusion'),
    ('H5334', 'Suppression of binocular vision'),
    ('H5340', 'Unspecified visual field defects'),
    ('H53411', 'Scotoma involving central area, right eye'),
    ('H53412', 'Scotoma involving central area, left eye'),
    ('H53413', 'Scotoma involving central area, bilateral'),
    ('H53419', 'Scotoma involving central area, unspecified eye'),
    ('H53421', 'Scotoma of blind spot area, right eye'),
    ('H53422', 'Scotoma of blind spot area, left eye'),
    ('H53423', 'Scotoma of blind spot area, bilateral'),
    ('H53429', 'Scotoma of blind spot area, unspecified eye'),
    ('H53431', 'Sector or arcuate defects, right eye'),
    ('H53432', 'Sector or arcuate defects, left eye'),
    ('H53433', 'Sector or arcuate defects, bilateral'),
    ('H53439', 'Sector or arcuate defects, unspecified eye'),
    ('H53451', 'Other localized visual field defect, right eye'),
    ('H53452', 'Other localized visual field defect, left eye'),
    ('H53453', 'Other localized visual field defect, bilateral'),
    ('H53459', 'Other localized visual field defect, unspecified eye'),
    ('H53461', 'Homonymous bilateral field defects, right side'),
    ('H53462', 'Homonymous bilateral field defects, left side'),
    ('H53469', 'Homonymous bilateral field defects, unspecified side'),
    ('H5347', 'Heteronymous bilateral field defects'),
    ('H53481', 'Generalized contraction of visual field, right eye'),
    ('H53482', 'Generalized contraction of visual field, left eye'),
    ('H53483', 'Generalized contraction of visual field, bilateral'),
    ('H53489', 'Generalized contraction of visual field, unspecified eye'),
    ('H5350', 'Unspecified color vision deficiencies'),
    ('H5351', 'Achromatopsia'),
    ('H5352', 'Acquired color vision deficiency'),
    ('H5353', 'Deuteranomaly'),
    ('H5354', 'Protanomaly'),
    ('H5355', 'Tritanomaly'),
    ('H5359', 'Other color vision deficiencies'),
    ('H5360', 'Unspecified night blindness'),
    ('H5361', 'Abnormal dark adaptation curve'),
    ('H5362', 'Acquired night blindness'),
    ('H5363', 'Congenital night blindness'),
    ('H5369', 'Other night blindness'),
    ('H5371', 'Glare sensitivity'),
    ('H5372', 'Impaired contrast sensitivity'),
    ('H538', 'Other visual disturbances'),
    ('H539', 'Unspecified visual disturbance'),
    ('H540', 'Blindness, both eyes'),
    ('H540X33', 'Blindness right eye category 3, blindness left eye category 3'),
    ('H540X34', 'Blindness right eye category 3, blindness left eye category 4'),
    ('H540X35', 'Blindness right eye category 3, blindness left eye category 5'),
    ('H540X43', 'Blindness right eye category 4, blindness left eye category 3'),
    ('H540X44', 'Blindness right eye category 4, blindness left eye category 4'),
    ('H540X45', 'Blindness right eye category 4, blindness left eye category 5'),
    ('H540X53', 'Blindness right eye category 5, blindness left eye category 3'),
    ('H540X54', 'Blindness right eye category 5, blindness left eye category 4'),
    ('H540X55', 'Blindness right eye category 5, blindness left eye category 5'),
    ('H5410', 'Blindness, one eye, low vision other eye, unspecified eyes'),
    ('H5411', 'Blindness, right eye, low vision left eye'),
    ('H541131', 'Blindness right eye category 3, low vision left eye category 1'),
    ('H541132', 'Blindness right eye category 3, low vision left eye category 2'),
    ('H541141', 'Blindness right eye category 4, low vision left eye category 1'),
    ('H541142', 'Blindness right eye category 4, low vision left eye category 2'),
    ('H541151', 'Blindness right eye category 5, low vision left eye category 1'),
    ('H541152', 'Blindness right eye category 5, low vision left eye category 2'),
    ('H5412', 'Blindness, left eye, low vision right eye'),
    ('H541213', 'Low vision right eye category 1, blindness left eye category 3'),
    ('H541214', 'Low vision right eye category 1, blindness left eye category 4'),
    ('H541215', 'Low vision right eye category 1, blindness left eye category 5'),
    ('H541223', 'Low vision right eye category 2, blindness left eye category 3'),
    ('H541224', 'Low vision right eye category 2, blindness left eye category 4'),
    ('H541225', 'Low vision right eye category 2, blindness left eye category 5'),
    ('H542', 'Low vision, both eyes'),
    ('H542X11', 'Low vision right eye category 1, low vision left eye category 1'),
    ('H542X12', 'Low vision right eye category 1, low vision left eye category 2'),
    ('H542X21', 'Low vision right eye category 2, low vision left eye category 1'),
    ('H542X22', 'Low vision right eye category 2, low vision left eye category 2'),
    ('H543', 'Unqualified visual loss, both eyes'),
    ('H5440', 'Blindness, one eye, unspecified eye'),
    ('H5441', 'Blindness, right eye, normal vision left eye'),
    ('H54413A', 'Blindness right eye category 3, normal vision left eye'),
    ('H54414A', 'Blindness right eye category 4, normal vision left eye'),
    ('H54415A', 'Blindness right eye category 5, normal vision left eye'),
    ('H5442', 'Blindness, left eye, normal vision right eye'),
    ('H5442A3', 'Blindness left eye category 3, normal vision right eye'),
    ('H5442A4', 'Blindness left eye category 4, normal vision right eye'),
    ('H5442A5', 'Blindness left eye category 5, normal vision right eye'),
    ('H5450', 'Low vision, one eye, unspecified eye'),
    ('H5451', 'Low vision, right eye, normal vision left eye'),
    ('H54511A', 'Low vision right eye category 1, normal vision left eye'),
    ('H54512A', 'Low vision right eye category 2, normal vision left eye'),
    ('H5452', 'Low vision, left eye, normal vision right eye'),
    ('H5452A1', 'Low vision left eye category 1, normal vision right eye'),
    ('H5452A2', 'Low vision left eye category 2, normal vision right eye'),
    ('H5460', 'Unqualified visual loss, one eye, unspecified'),
    ('H5461', 'Unqualified visual loss, right eye, normal vision left eye'),
    ('H5462', 'Unqualified visual loss, left eye, normal vision right eye'),
    ('H547', 'Unspecified visual loss'),
    ('H548', 'Legal blindness, as defined in USA'),
    ('H5500', 'Unspecified nystagmus'),
    ('H5501', 'Congenital nystagmus'),
    ('H5502', 'Latent nystagmus'),
    ('H5503', 'Visual deprivation nystagmus'),
    ('H5504', 'Dissociated nystagmus'),
    ('H5509', 'Other forms of nystagmus'),
    ('H5581', 'Deficient saccadic eye movements'),
    ('H5582', 'Deficient smooth pursuit eye movements'),
    ('H5589', 'Other irregular eye movements'),
    ('H5700', 'Unspecified anomaly of pupillary function'),
    ('H5701', 'Argyll Robertson pupil, atypical'),
    ('H5702', 'Anisocoria'),
    ('H5703', 'Miosis'),
    ('H5704', 'Mydriasis'),
    ('H57051', 'Tonic pupil, right eye'),
    ('H57052', 'Tonic pupil, left eye'),
    ('H57053', 'Tonic pupil, bilateral'),
    ('H57059', 'Tonic pupil, unspecified eye'),
    ('H5709', 'Other anomalies of pupillary function'),
    ('H5710', 'Ocular pain, unspecified eye'),
    ('H5711', 'Ocular pain, right eye'),
    ('H5712', 'Ocular pain, left eye'),
    ('H5713', 'Ocular pain, bilateral'),
    ('H578', 'Other specified disorders of eye and adnexa'),
    ('H57811', 'Brow ptosis, right'),
    ('H57812', 'Brow ptosis, left'),
    ('H57813', 'Brow ptosis, bilateral '),
    ('H57819', 'Brow ptosis, unspecified'),
    ('H5789', 'Other specified disorders of eye and adnexa'),
    ('H578A1', 'Foreign body sensation, right eye'),
    ('H578A2', 'Foreign body sensation, left eye'),
    ('H578A3', 'Foreign body sensation, bilateral eyes'),
    ('H578A9', 'Foreign body sensation, unspecified eye'),
    ('H579', 'Unspecified disorder of eye and adnexa'),
    ('H59011', 'Keratopathy (bullous aphakic) fol cataract surgery, r eye'),
    ('H59012', 'Keratopathy (bullous aphakic) fol cataract surgery, left eye'),
    ('H59013', 'Keratopathy (bullous aphakic) following cataract surgery, bi'),
    ('H59019', 'Keratopathy (bullous aphakic) fol cataract surgery, unsp eye'),
    ('H59021', 'Cataract (lens) fragmt in eye fol cataract surgery, r eye'),
    ('H59022', 'Cataract (lens) fragmt in eye fol cataract surgery, left eye'),
    ('H59023', 'Cataract (lens) fragments in eye fol cataract surgery, bi'),
    ('H59029', 'Cataract (lens) fragmt in eye fol cataract surgery, unsp eye'),
    ('H59031', 'Cystoid macular edema following cataract surgery, right eye'),
    ('H59032', 'Cystoid macular edema following cataract surgery, left eye'),
    ('H59033', 'Cystoid macular edema following cataract surgery, bilateral'),
    ('H59039', 'Cystoid macular edema following cataract surgery, unsp eye'),
    ('H59091', 'Other disorders of the right eye following cataract surgery'),
    ('H59092', 'Other disorders of the left eye following cataract surgery'),
    ('H59093', 'Oth disorders of the eye following cataract surgery, bi'),
    ('H59099', 'Other disorders of unsp eye following cataract surgery'),
    ('H59111', 'Intraop hemor/hemtom of r eye and adnexa comp an opth proc'),
    ('H59112', 'Intraop hemor/hemtom of l eye and adnexa comp an opth proc'),
    ('H59113', 'Intraop hemor/hemtom of eye and adnexa comp an opth proc, bi'),
    ('H59119', 'Intraop hemor/hemtom of unsp eye and adnx comp an opth proc'),
    ('H59121', 'Intraop hemor/hemtom of right eye and adnexa comp oth proc'),
    ('H59122', 'Intraop hemor/hemtom of left eye and adnexa comp oth proc'),
    ('H59123', 'Intraop hemor/hemtom of eye and adnexa comp oth proc, bi'),
    ('H59129', 'Intraop hemor/hemtom of unsp eye and adnexa comp oth proc'),
    ('H59211', 'Acc pnctr & lac of right eye and adnexa during an opth proc'),
    ('H59212', 'Acc pnctr & lac of left eye and adnexa during an opth proc'),
    ('H59213', 'Acc pnctr & lac of eye and adnexa during an opth proc, bi'),
    ('H59219', 'Acc pnctr & lac of unsp eye and adnexa during an opth proc'),
    ('H59221', 'Acc pnctr & lac of right eye and adnexa during oth procedure'),
    ('H59222', 'Acc pnctr & lac of left eye and adnexa during oth procedure'),
    ('H59223', 'Acc pnctr & lac of eye and adnexa during oth procedure, bi'),
    ('H59229', 'Acc pnctr & lac of unsp eye and adnexa during oth procedure'),
    ('H59311', 'Postproc hemor of r eye and adnexa fol an opth proc'),
    ('H59312', 'Postproc hemor of l eye and adnexa fol an opth proc'),
    ('H59313', 'Postproc hemor of eye and adnexa fol an opth proc, bi'),
    ('H59319', 'Postproc hemor of unsp eye and adnx fol an opth proc'),
    ('H59321', 'Postproc hemor of right eye and adnexa fol oth proc'),
    ('H59322', 'Postproc hemor of left eye and adnexa fol oth proc'),
    ('H59323', 'Postproc hemor of eye and adnexa fol oth proc, bi'),
    ('H59329', 'Postproc hemor of unsp eye and adnexa fol oth proc'),
    ('H59331', 'Postproc hematoma of right eye and adnexa fol an opth proc'),
    ('H59332', 'Postproc hematoma of left eye and adnexa fol an opth proc'),
    ('H59333', 'Postproc hematoma of eye and adnexa fol an opth proc, bi'),
    ('H59339', 'Postproc hematoma of unsp and adnexa fol an opth procedure'),
    ('H59341', 'Postproc hematoma of right eye and adnexa fol other proc'),
    ('H59342', 'Postproc hematoma of left eye and adnexa fol other procedure'),
    ('H59343', 'Postproc hematoma of eye and adnexa fol other procedure, bi'),
    ('H59349', 'Postproc hematoma of unsp and adnexa fol other procedure'),
    ('H59351', 'Postproc seroma of right eye and adnexa fol an opth proc'),
    ('H59352', 'Postproc seroma of left eye and adnexa fol an opth procedure'),
    ('H59353', 'Postproc seroma of eye and adnexa fol an opth procedure, bi'),
    ('H59359', 'Postproc seroma of unsp and adnexa fol an opth procedure'),
    ('H59361', 'Postproc seroma of right eye and adnexa fol other procedure'),
    ('H59362', 'Postproc seroma of left eye and adnexa fol other procedure'),
    ('H59363', 'Postproc seroma of eye and adnexa fol other procedure, bi'),
    ('H59369', 'Postproc seroma of unsp and adnexa following other procedure'),
    ('H5940', 'Inflammation (infection) of postprocedural bleb, unspecified'),
    ('H5941', 'Inflammation (infection) of postprocedural bleb, stage 1'),
    ('H5942', 'Inflammation (infection) of postprocedural bleb, stage 2'),
    ('H5943', 'Inflammation (infection) of postprocedural bleb, stage 3'),
    ('H59811', 'Chorioretinal scars after surgery for detachment, right eye'),
    ('H59812', 'Chorioretinal scars after surgery for detachment, left eye'),
    ('H59813', 'Chorioretinal scars after surgery for detachment, bilateral'),
    ('H59819', 'Chorioretinal scars after surgery for detachment, unsp eye'),
    ('H5988', 'Oth intraoperative complications of eye and adnexa, NEC'),
    ('H5989', 'Oth postproc comp and disorders of eye and adnexa, NEC'),
    ('H6000', 'Abscess of external ear, unspecified ear'),
    ('H6001', 'Abscess of right external ear'),
    ('H6002', 'Abscess of left external ear'),
    ('H6003', 'Abscess of external ear, bilateral'),
    ('H6010', 'Cellulitis of external ear, unspecified ear'),
    ('H6011', 'Cellulitis of right external ear'),
    ('H6012', 'Cellulitis of left external ear'),
    ('H6013', 'Cellulitis of external ear, bilateral'),
    ('H6020', 'Malignant otitis externa, unspecified ear'),
    ('H6021', 'Malignant otitis externa, right ear'),
    ('H6022', 'Malignant otitis externa, left ear'),
    ('H6023', 'Malignant otitis externa, bilateral'),
    ('H60311', 'Diffuse otitis externa, right ear'),
    ('H60312', 'Diffuse otitis externa, left ear'),
    ('H60313', 'Diffuse otitis externa, bilateral'),
    ('H60319', 'Diffuse otitis externa, unspecified ear'),
    ('H60321', 'Hemorrhagic otitis externa, right ear'),
    ('H60322', 'Hemorrhagic otitis externa, left ear'),
    ('H60323', 'Hemorrhagic otitis externa, bilateral'),
    ('H60329', 'Hemorrhagic otitis externa, unspecified ear'),
    ('H60331', "Swimmer's ear, right ear"),
    ('H60332', "Swimmer's ear, left ear"),
    ('H60333', "Swimmer's ear, bilateral"),
    ('H60339', "Swimmer's ear, unspecified ear"),
    ('H60391', 'Other infective otitis externa, right ear'),
    ('H60392', 'Other infective otitis externa, left ear'),
    ('H60393', 'Other infective otitis externa, bilateral'),
    ('H60399', 'Other infective otitis externa, unspecified ear'),
    ('H6040', 'Cholesteatoma of external ear, unspecified ear'),
    ('H6041', 'Cholesteatoma of right external ear'),
    ('H6042', 'Cholesteatoma of left external ear'),
    ('H6043', 'Cholesteatoma of external ear, bilateral'),
    ('H60501', 'Unspecified acute noninfective otitis externa, right ear'),
    ('H60502', 'Unspecified acute noninfective otitis externa, left ear'),
    ('H60503', 'Unspecified acute noninfective otitis externa, bilateral'),
    ('H60509', 'Unsp acute noninfective otitis externa, unspecified ear'),
    ('H60511', 'Acute actinic otitis externa, right ear'),
    ('H60512', 'Acute actinic otitis externa, left ear'),
    ('H60513', 'Acute actinic otitis externa, bilateral'),
    ('H60519', 'Acute actinic otitis externa, unspecified ear'),
    ('H60521', 'Acute chemical otitis externa, right ear'),
    ('H60522', 'Acute chemical otitis externa, left ear'),
    ('H60523', 'Acute chemical otitis externa, bilateral'),
    ('H60529', 'Acute chemical otitis externa, unspecified ear'),
    ('H60531', 'Acute contact otitis externa, right ear'),
    ('H60532', 'Acute contact otitis externa, left ear'),
    ('H60533', 'Acute contact otitis externa, bilateral'),
    ('H60539', 'Acute contact otitis externa, unspecified ear'),
    ('H60541', 'Acute eczematoid otitis externa, right ear'),
    ('H60542', 'Acute eczematoid otitis externa, left ear'),
    ('H60543', 'Acute eczematoid otitis externa, bilateral'),
    ('H60549', 'Acute eczematoid otitis externa, unspecified ear'),
    ('H60551', 'Acute reactive otitis externa, right ear'),
    ('H60552', 'Acute reactive otitis externa, left ear'),
    ('H60553', 'Acute reactive otitis externa, bilateral'),
    ('H60559', 'Acute reactive otitis externa, unspecified ear'),
    ('H60591', 'Other noninfective acute otitis externa, right ear'),
    ('H60592', 'Other noninfective acute otitis externa, left ear'),
    ('H60593', 'Other noninfective acute otitis externa, bilateral'),
    ('H60599', 'Other noninfective acute otitis externa, unspecified ear'),
    ('H6060', 'Unspecified chronic otitis externa, unspecified ear'),
    ('H6061', 'Unspecified chronic otitis externa, right ear'),
    ('H6062', 'Unspecified chronic otitis externa, left ear'),
    ('H6063', 'Unspecified chronic otitis externa, bilateral'),
    ('H608X1', 'Other otitis externa, right ear'),
    ('H608X2', 'Other otitis externa, left ear'),
    ('H608X3', 'Other otitis externa, bilateral'),
    ('H608X9', 'Other otitis externa, unspecified ear'),
    ('H6090', 'Unspecified otitis externa, unspecified ear'),
    ('H6091', 'Unspecified otitis externa, right ear'),
    ('H6092', 'Unspecified otitis externa, left ear'),
    ('H6093', 'Unspecified otitis externa, bilateral'),
    ('H61001', 'Unspecified perichondritis of right external ear'),
    ('H61002', 'Unspecified perichondritis of left external ear'),
    ('H61003', 'Unspecified perichondritis of external ear, bilateral'),
    ('H61009', 'Unspecified perichondritis of external ear, unspecified ear'),
    ('H61011', 'Acute perichondritis of right external ear'),
    ('H61012', 'Acute perichondritis of left external ear'),
    ('H61013', 'Acute perichondritis of external ear, bilateral'),
    ('H61019', 'Acute perichondritis of external ear, unspecified ear'),
    ('H61021', 'Chronic perichondritis of right external ear'),
    ('H61022', 'Chronic perichondritis of left external ear'),
    ('H61023', 'Chronic perichondritis of external ear, bilateral'),
    ('H61029', 'Chronic perichondritis of external ear, unspecified ear'),
    ('H61031', 'Chondritis of right external ear'),
    ('H61032', 'Chondritis of left external ear'),
    ('H61033', 'Chondritis of external ear, bilateral'),
    ('H61039', 'Chondritis of external ear, unspecified ear'),
    ('H61101', 'Unspecified noninfective disorders of pinna, right ear'),
    ('H61102', 'Unspecified noninfective disorders of pinna, left ear'),
    ('H61103', 'Unspecified noninfective disorders of pinna, bilateral'),
    ('H61109', 'Unspecified noninfective disorders of pinna, unspecified ear'),
    ('H61111', 'Acquired deformity of pinna, right ear'),
    ('H61112', 'Acquired deformity of pinna, left ear'),
    ('H61113', 'Acquired deformity of pinna, bilateral'),
    ('H61119', 'Acquired deformity of pinna, unspecified ear'),
    ('H61121', 'Hematoma of pinna, right ear'),
    ('H61122', 'Hematoma of pinna, left ear'),
    ('H61123', 'Hematoma of pinna, bilateral'),
    ('H61129', 'Hematoma of pinna, unspecified ear'),
    ('H61191', 'Noninfective disorders of pinna, right ear'),
    ('H61192', 'Noninfective disorders of pinna, left ear'),
    ('H61193', 'Noninfective disorders of pinna, bilateral'),
    ('H61199', 'Noninfective disorders of pinna, unspecified ear'),
    ('H6120', 'Impacted cerumen, unspecified ear'),
    ('H6121', 'Impacted cerumen, right ear'),
    ('H6122', 'Impacted cerumen, left ear'),
    ('H6123', 'Impacted cerumen, bilateral'),
    ('H61301', 'Acquired stenosis of right external ear canal, unspecified'),
    ('H61302', 'Acquired stenosis of left external ear canal, unspecified'),
    ('H61303', 'Acquired stenosis of external ear canal, unsp, bilateral'),
    ('H61309', 'Acquired stenosis of external ear canal, unsp, unsp ear'),
    ('H61311', 'Acquired stenosis of r ext ear canal secondary to trauma'),
    ('H61312', 'Acquired stenosis of l ext ear canal secondary to trauma'),
    ('H61313', 'Acquired stenosis of ext ear canal secondary to trauma, bi'),
    ('H61319', 'Acquired stenosis of ext ear canal sec to trauma, unsp ear'),
    ('H61321', 'Acquired stenosis of r ext ear canal sec to inflam and infct'),
    ('H61322', 'Acquired stenosis of l ext ear canal sec to inflam and infct'),
    ('H61323', 'Acq stenosis of ext ear canal sec to inflam and infct, bi'),
    ('H61329', 'Acq stenos of ext ear canal sec to inflam & infct, unsp ear'),
    ('H61391', 'Other acquired stenosis of right external ear canal'),
    ('H61392', 'Other acquired stenosis of left external ear canal'),
    ('H61393', 'Other acquired stenosis of external ear canal, bilateral'),
    ('H61399', 'Other acquired stenosis of external ear canal, unsp ear'),
    ('H61811', 'Exostosis of right external canal'),
    ('H61812', 'Exostosis of left external canal'),
    ('H61813', 'Exostosis of external canal, bilateral'),
    ('H61819', 'Exostosis of external canal, unspecified ear'),
    ('H61891', 'Other specified disorders of right external ear'),
    ('H61892', 'Other specified disorders of left external ear'),
    ('H61893', 'Other specified disorders of external ear, bilateral'),
    ('H61899', 'Other specified disorders of external ear, unspecified ear'),
    ('H6190', 'Disorder of external ear, unspecified, unspecified ear'),
    ('H6191', 'Disorder of right external ear, unspecified'),
    ('H6192', 'Disorder of left external ear, unspecified'),
    ('H6193', 'Disorder of external ear, unspecified, bilateral'),
    ('H6240', 'Otitis externa in oth diseases classd elswhr, unsp ear'),
    ('H6241', 'Otitis externa in oth diseases classd elswhr, right ear'),
    ('H6242', 'Otitis externa in oth diseases classd elswhr, left ear'),
    ('H6243', 'Otitis externa in oth diseases classd elswhr, bilateral'),
    ('H628X1', 'Oth disorders of r ext ear in diseases classd elswhr'),
    ('H628X2', 'Oth disorders of left external ear in diseases classd elswhr'),
    ('H628X3', 'Oth disorders of ext ear in diseases classd elswhr, bi'),
    ('H628X9', 'Oth disorders of ext ear in diseases classd elswhr, unsp ear'),
    ('H6500', 'Acute serous otitis media, unspecified ear'),
    ('H6501', 'Acute serous otitis media, right ear'),
    ('H6502', 'Acute serous otitis media, left ear'),
    ('H6503', 'Acute serous otitis media, bilateral'),
    ('H6504', 'Acute serous otitis media, recurrent, right ear'),
    ('H6505', 'Acute serous otitis media, recurrent, left ear'),
    ('H6506', 'Acute serous otitis media, recurrent, bilateral'),
    ('H6507', 'Acute serous otitis media, recurrent, unspecified ear'),
    ('H65111', 'Acute and subacute allergic otitis media (serous), r ear'),
    ('H65112', 'Acute and subacute allergic otitis media (serous), left ear'),
    ('H65113', 'Acute and subacute allergic otitis media (serous), bi'),
    ('H65114', 'Acute and subacute allergic otitis media, recur, r ear'),
    ('H65115', 'Acute and subacute allergic otitis media, recur, left ear'),
    ('H65116', 'Acute and subacute allergic otitis media (serous), recur, bi'),
    ('H65117', 'Acute and subacute allergic otitis media, recur, unsp ear'),
    ('H65119', 'Acute and subacute allergic otitis media (serous), unsp ear'),
    ('H65191', 'Other acute nonsuppurative otitis media, right ear'),
    ('H65192', 'Other acute nonsuppurative otitis media, left ear'),
    ('H65193', 'Other acute nonsuppurative otitis media, bilateral'),
    ('H65194', 'Oth acute nonsuppurative otitis media, recurrent, right ear'),
    ('H65195', 'Other acute nonsuppurative otitis media, recurrent, left ear'),
    ('H65196', 'Oth acute nonsuppurative otitis media, recurrent, bilateral'),
    ('H65197', 'Other acute nonsuppurative otitis media recurrent, unsp ear'),
    ('H65199', 'Other acute nonsuppurative otitis media, unspecified ear'),
    ('H6520', 'Chronic serous otitis media, unspecified ear'),
    ('H6521', 'Chronic serous otitis media, right ear'),
    ('H6522', 'Chronic serous otitis media, left ear'),
    ('H6523', 'Chronic serous otitis media, bilateral'),
    ('H6530', 'Chronic mucoid otitis media, unspecified ear'),
    ('H6531', 'Chronic mucoid otitis media, right ear'),
    ('H6532', 'Chronic mucoid otitis media, left ear'),
    ('H6533', 'Chronic mucoid otitis media, bilateral'),
    ('H65411', 'Chronic allergic otitis media, right ear'),
    ('H65412', 'Chronic allergic otitis media, left ear'),
    ('H65413', 'Chronic allergic otitis media, bilateral'),
    ('H65419', 'Chronic allergic otitis media, unspecified ear'),
    ('H65491', 'Other chronic nonsuppurative otitis media, right ear'),
    ('H65492', 'Other chronic nonsuppurative otitis media, left ear'),
    ('H65493', 'Other chronic nonsuppurative otitis media, bilateral'),
    ('H65499', 'Other chronic nonsuppurative otitis media, unspecified ear'),
    ('H6590', 'Unspecified nonsuppurative otitis media, unspecified ear'),
    ('H6591', 'Unspecified nonsuppurative otitis media, right ear'),
    ('H6592', 'Unspecified nonsuppurative otitis media, left ear'),
    ('H6593', 'Unspecified nonsuppurative otitis media, bilateral'),
    ('H66001', 'Acute suppr otitis media w/o spon rupt ear drum, right ear'),
    ('H66002', 'Acute suppr otitis media w/o spon rupt ear drum, left ear'),
    ('H66003', 'Acute suppr otitis media w/o spon rupt ear drum, bilateral'),
    ('H66004', 'Ac suppr otitis media w/o spon rupt ear drum, recur, r ear'),
    ('H66005', 'Ac suppr otitis media w/o spon rupt ear drum, recur, l ear'),
    ('H66006', 'Acute suppr otitis media w/o spon rupt ear drum, recur, bi'),
    ('H66007', 'Ac suppr otitis media w/o spon rupt ear drum,recur, unsp ear'),
    ('H66009', 'Acute suppr otitis media w/o spon rupt ear drum, unsp ear'),
    ('H66011', 'Acute suppr otitis media w spon rupt ear drum, right ear'),
    ('H66012', 'Acute suppr otitis media w spon rupt ear drum, left ear'),
    ('H66013', 'Acute suppr otitis media w spon rupt ear drum, bilateral'),
    ('H66014', 'Acute suppr otitis media w spon rupt ear drum, recur, r ear'),
    ('H66015', 'Acute suppr otitis media w spon rupt ear drum, recur, l ear'),
    ('H66016', 'Acute suppr otitis media w spon rupt ear drum, recurrent, bi'),
    ('H66017', 'Ac suppr otitis media w spon rupt ear drum, recur, unsp ear'),
    ('H66019', 'Acute suppr otitis media w spon rupt ear drum, unsp ear'),
    ('H6610', 'Chronic tubotympanic suppurative otitis media, unspecified'),
    ('H6611', 'Chronic tubotympanic suppurative otitis media, right ear'),
    ('H6612', 'Chronic tubotympanic suppurative otitis media, left ear'),
    ('H6613', 'Chronic tubotympanic suppurative otitis media, bilateral'),
    ('H6620', 'Chronic atticoantral suppurative otitis media, unsp ear'),
    ('H6621', 'Chronic atticoantral suppurative otitis media, right ear'),
    ('H6622', 'Chronic atticoantral suppurative otitis media, left ear'),
    ('H6623', 'Chronic atticoantral suppurative otitis media, bilateral'),
    ('H663X1', 'Other chronic suppurative otitis media, right ear'),
    ('H663X2', 'Other chronic suppurative otitis media, left ear'),
    ('H663X3', 'Other chronic suppurative otitis media, bilateral'),
    ('H663X9', 'Other chronic suppurative otitis media, unspecified ear'),
    ('H6640', 'Suppurative otitis media, unspecified, unspecified ear'),
    ('H6641', 'Suppurative otitis media, unspecified, right ear'),
    ('H6642', 'Suppurative otitis media, unspecified, left ear'),
    ('H6643', 'Suppurative otitis media, unspecified, bilateral'),
    ('H6690', 'Otitis media, unspecified, unspecified ear'),
    ('H6691', 'Otitis media, unspecified, right ear'),
    ('H6692', 'Otitis media, unspecified, left ear'),
    ('H6693', 'Otitis media, unspecified, bilateral'),
    ('H671', 'Otitis media in diseases classified elsewhere, right ear'),
    ('H672', 'Otitis media in diseases classified elsewhere, left ear'),
    ('H673', 'Otitis media in diseases classified elsewhere, bilateral'),
    ('H679', 'Otitis media in diseases classified elsewhere, unsp ear'),
    ('H68001', 'Unspecified Eustachian salpingitis, right ear'),
    ('H68002', 'Unspecified Eustachian salpingitis, left ear'),
    ('H68003', 'Unspecified Eustachian salpingitis, bilateral'),
    ('H68009', 'Unspecified Eustachian salpingitis, unspecified ear'),
    ('H68011', 'Acute Eustachian salpingitis, right ear'),
    ('H68012', 'Acute Eustachian salpingitis, left ear'),
    ('H68013', 'Acute Eustachian salpingitis, bilateral'),
    ('H68019', 'Acute Eustachian salpingitis, unspecified ear'),
    ('H68021', 'Chronic Eustachian salpingitis, right ear'),
    ('H68022', 'Chronic Eustachian salpingitis, left ear'),
    ('H68023', 'Chronic Eustachian salpingitis, bilateral'),
    ('H68029', 'Chronic Eustachian salpingitis, unspecified ear'),
    ('H68101', 'Unspecified obstruction of Eustachian tube, right ear'),
    ('H68102', 'Unspecified obstruction of Eustachian tube, left ear'),
    ('H68103', 'Unspecified obstruction of Eustachian tube, bilateral'),
    ('H68109', 'Unspecified obstruction of Eustachian tube, unspecified ear'),
    ('H68111', 'Osseous obstruction of Eustachian tube, right ear'),
    ('H68112', 'Osseous obstruction of Eustachian tube, left ear'),
    ('H68113', 'Osseous obstruction of Eustachian tube, bilateral'),
    ('H68119', 'Osseous obstruction of Eustachian tube, unspecified ear'),
    ('H68121', 'Intrinsic cartilagenous obst of eustach tube, right ear'),
    ('H68122', 'Intrinsic cartilagenous obst of eustach tube, left ear'),
    ('H68123', 'Intrinsic cartilagenous obst of eustach tube, bilateral'),
    ('H68129', 'Intrinsic cartilagenous obst of eustach tube, unsp ear'),
    ('H68131', 'Extrinsic cartilagenous obst of eustach tube, right ear'),
    ('H68132', 'Extrinsic cartilagenous obst of eustach tube, left ear'),
    ('H68133', 'Extrinsic cartilagenous obst of eustach tube, bilateral'),
    ('H68139', 'Extrinsic cartilagenous obst of eustach tube, unsp ear'),
    ('H6900', 'Patulous Eustachian tube, unspecified ear'),
    ('H6901', 'Patulous Eustachian tube, right ear'),
    ('H6902', 'Patulous Eustachian tube, left ear'),
    ('H6903', 'Patulous Eustachian tube, bilateral'),
    ('H6980', 'Oth disrd of Eustachian tube, unspecified ear'),
    ('H6981', 'Other specified disorders of Eustachian tube, right ear'),
    ('H6982', 'Other specified disorders of Eustachian tube, left ear'),
    ('H6983', 'Other specified disorders of Eustachian tube, bilateral'),
    ('H6990', 'Unspecified Eustachian tube disorder, unspecified ear'),
    ('H6991', 'Unspecified Eustachian tube disorder, right ear'),
    ('H6992', 'Unspecified Eustachian tube disorder, left ear'),
    ('H6993', 'Unspecified Eustachian tube disorder, bilateral'),
    ('H70001', 'Acute mastoiditis without complications, right ear'),
    ('H70002', 'Acute mastoiditis without complications, left ear'),
    ('H70003', 'Acute mastoiditis without complications, bilateral'),
    ('H70009', 'Acute mastoiditis without complications, unspecified ear'),
    ('H70011', 'Subperiosteal abscess of mastoid, right ear'),
    ('H70012', 'Subperiosteal abscess of mastoid, left ear'),
    ('H70013', 'Subperiosteal abscess of mastoid, bilateral'),
    ('H70019', 'Subperiosteal abscess of mastoid, unspecified ear'),
    ('H70091', 'Acute mastoiditis with other complications, right ear'),
    ('H70092', 'Acute mastoiditis with other complications, left ear'),
    ('H70093', 'Acute mastoiditis with other complications, bilateral'),
    ('H70099', 'Acute mastoiditis with other complications, unspecified ear'),
    ('H7010', 'Chronic mastoiditis, unspecified ear'),
    ('H7011', 'Chronic mastoiditis, right ear'),
    ('H7012', 'Chronic mastoiditis, left ear'),
    ('H7013', 'Chronic mastoiditis, bilateral'),
    ('H70201', 'Unspecified petrositis, right ear'),
    ('H70202', 'Unspecified petrositis, left ear'),
    ('H70203', 'Unspecified petrositis, bilateral'),
    ('H70209', 'Unspecified petrositis, unspecified ear'),
    ('H70211', 'Acute petrositis, right ear'),
    ('H70212', 'Acute petrositis, left ear'),
    ('H70213', 'Acute petrositis, bilateral'),
    ('H70219', 'Acute petrositis, unspecified ear'),
    ('H70221', 'Chronic petrositis, right ear'),
    ('H70222', 'Chronic petrositis, left ear'),
    ('H70223', 'Chronic petrositis, bilateral'),
    ('H70229', 'Chronic petrositis, unspecified ear'),
    ('H70811', 'Postauricular fistula, right ear'),
    ('H70812', 'Postauricular fistula, left ear'),
    ('H70813', 'Postauricular fistula, bilateral'),
    ('H70819', 'Postauricular fistula, unspecified ear'),
    ('H70891', 'Other mastoiditis and related conditions, right ear'),
    ('H70892', 'Other mastoiditis and related conditions, left ear'),
    ('H70893', 'Other mastoiditis and related conditions, bilateral'),
    ('H70899', 'Other mastoiditis and related conditions, unspecified ear'),
    ('H7090', 'Unspecified mastoiditis, unspecified ear'),
    ('H7091', 'Unspecified mastoiditis, right ear'),
    ('H7092', 'Unspecified mastoiditis, left ear'),
    ('H7093', 'Unspecified mastoiditis, bilateral'),
    ('H7100', 'Cholesteatoma of attic, unspecified ear'),
    ('H7101', 'Cholesteatoma of attic, right ear'),
    ('H7102', 'Cholesteatoma of attic, left ear'),
    ('H7103', 'Cholesteatoma of attic, bilateral'),
    ('H7110', 'Cholesteatoma of tympanum, unspecified ear'),
    ('H7111', 'Cholesteatoma of tympanum, right ear'),
    ('H7112', 'Cholesteatoma of tympanum, left ear'),
    ('H7113', 'Cholesteatoma of tympanum, bilateral'),
    ('H7120', 'Cholesteatoma of mastoid, unspecified ear'),
    ('H7121', 'Cholesteatoma of mastoid, right ear'),
    ('H7122', 'Cholesteatoma of mastoid, left ear'),
    ('H7123', 'Cholesteatoma of mastoid, bilateral'),
    ('H7130', 'Diffuse cholesteatosis, unspecified ear'),
    ('H7131', 'Diffuse cholesteatosis, right ear'),
    ('H7132', 'Diffuse cholesteatosis, left ear'),
    ('H7133', 'Diffuse cholesteatosis, bilateral'),
    ('H7190', 'Unspecified cholesteatoma, unspecified ear'),
    ('H7191', 'Unspecified cholesteatoma, right ear'),
    ('H7192', 'Unspecified cholesteatoma, left ear'),
    ('H7193', 'Unspecified cholesteatoma, bilateral'),
    ('H7200', 'Central perforation of tympanic membrane, unspecified ear'),
    ('H7201', 'Central perforation of tympanic membrane, right ear'),
    ('H7202', 'Central perforation of tympanic membrane, left ear'),
    ('H7203', 'Central perforation of tympanic membrane, bilateral'),
    ('H7210', 'Attic perforation of tympanic membrane, unspecified ear'),
    ('H7211', 'Attic perforation of tympanic membrane, right ear'),
    ('H7212', 'Attic perforation of tympanic membrane, left ear'),
    ('H7213', 'Attic perforation of tympanic membrane, bilateral'),
    ('H722X1', 'Other marginal perforations of tympanic membrane, right ear'),
    ('H722X2', 'Other marginal perforations of tympanic membrane, left ear'),
    ('H722X3', 'Other marginal perforations of tympanic membrane, bilateral'),
    ('H722X9', 'Other marginal perforations of tympanic membrane, unsp ear'),
    ('H72811', 'Multiple perforations of tympanic membrane, right ear'),
    ('H72812', 'Multiple perforations of tympanic membrane, left ear'),
    ('H72813', 'Multiple perforations of tympanic membrane, bilateral'),
    ('H72819', 'Multiple perforations of tympanic membrane, unspecified ear'),
    ('H72821', 'Total perforations of tympanic membrane, right ear'),
    ('H72822', 'Total perforations of tympanic membrane, left ear'),
    ('H72823', 'Total perforations of tympanic membrane, bilateral'),
    ('H72829', 'Total perforations of tympanic membrane, unspecified ear'),
    ('H7290', 'Unsp perforation of tympanic membrane, unspecified ear'),
    ('H7291', 'Unspecified perforation of tympanic membrane, right ear'),
    ('H7292', 'Unspecified perforation of tympanic membrane, left ear'),
    ('H7293', 'Unspecified perforation of tympanic membrane, bilateral'),
    ('H73001', 'Acute myringitis, right ear'),
    ('H73002', 'Acute myringitis, left ear'),
    ('H73003', 'Acute myringitis, bilateral'),
    ('H73009', 'Acute myringitis, unspecified ear'),
    ('H73011', 'Bullous myringitis, right ear'),
    ('H73012', 'Bullous myringitis, left ear'),
    ('H73013', 'Bullous myringitis, bilateral'),
    ('H73019', 'Bullous myringitis, unspecified ear'),
    ('H73091', 'Other acute myringitis, right ear'),
    ('H73092', 'Other acute myringitis, left ear'),
    ('H73093', 'Other acute myringitis, bilateral'),
    ('H73099', 'Other acute myringitis, unspecified ear'),
    ('H7310', 'Chronic myringitis, unspecified ear'),
    ('H7311', 'Chronic myringitis, right ear'),
    ('H7312', 'Chronic myringitis, left ear'),
    ('H7313', 'Chronic myringitis, bilateral'),
    ('H7320', 'Unspecified myringitis, unspecified ear'),
    ('H7321', 'Unspecified myringitis, right ear'),
    ('H7322', 'Unspecified myringitis, left ear'),
    ('H7323', 'Unspecified myringitis, bilateral'),
    ('H73811', 'Atrophic flaccid tympanic membrane, right ear'),
    ('H73812', 'Atrophic flaccid tympanic membrane, left ear'),
    ('H73813', 'Atrophic flaccid tympanic membrane, bilateral'),
    ('H73819', 'Atrophic flaccid tympanic membrane, unspecified ear'),
    ('H73821', 'Atrophic nonflaccid tympanic membrane, right ear'),
    ('H73822', 'Atrophic nonflaccid tympanic membrane, left ear'),
    ('H73823', 'Atrophic nonflaccid tympanic membrane, bilateral'),
    ('H73829', 'Atrophic nonflaccid tympanic membrane, unspecified ear'),
    ('H73891', 'Other specified disorders of tympanic membrane, right ear'),
    ('H73892', 'Other specified disorders of tympanic membrane, left ear'),
    ('H73893', 'Other specified disorders of tympanic membrane, bilateral'),
    ('H73899', 'Oth disrd of tympanic membrane, unspecified ear'),
    ('H7390', 'Unspecified disorder of tympanic membrane, unspecified ear'),
    ('H7391', 'Unspecified disorder of tympanic membrane, right ear'),
    ('H7392', 'Unspecified disorder of tympanic membrane, left ear'),
    ('H7393', 'Unspecified disorder of tympanic membrane, bilateral'),
    ('H7401', 'Tympanosclerosis, right ear'),
    ('H7402', 'Tympanosclerosis, left ear'),
    ('H7403', 'Tympanosclerosis, bilateral'),
    ('H7409', 'Tympanosclerosis, unspecified ear'),
    ('H7411', 'Adhesive right middle ear disease'),
    ('H7412', 'Adhesive left middle ear disease'),
    ('H7413', 'Adhesive middle ear disease, bilateral'),
    ('H7419', 'Adhesive middle ear disease, unspecified ear'),
    ('H7420', 'Discontinuity and dislocation of ear ossicles, unsp ear'),
    ('H7421', 'Discontinuity and dislocation of right ear ossicles'),
    ('H7422', 'Discontinuity and dislocation of left ear ossicles'),
    ('H7423', 'Discontinuity and dislocation of ear ossicles, bilateral'),
    ('H74311', 'Ankylosis of ear ossicles, right ear'),
    ('H74312', 'Ankylosis of ear ossicles, left ear'),
    ('H74313', 'Ankylosis of ear ossicles, bilateral'),
    ('H74319', 'Ankylosis of ear ossicles, unspecified ear'),
    ('H74321', 'Partial loss of ear ossicles, right ear'),
    ('H74322', 'Partial loss of ear ossicles, left ear'),
    ('H74323', 'Partial loss of ear ossicles, bilateral'),
    ('H74329', 'Partial loss of ear ossicles, unspecified ear'),
    ('H74391', 'Other acquired abnormalities of right ear ossicles'),
    ('H74392', 'Other acquired abnormalities of left ear ossicles'),
    ('H74393', 'Other acquired abnormalities of ear ossicles, bilateral'),
    ('H74399', 'Other acquired abnormalities of ear ossicles, unsp ear'),
    ('H7440', 'Polyp of middle ear, unspecified ear'),
    ('H7441', 'Polyp of right middle ear'),
    ('H7442', 'Polyp of left middle ear'),
    ('H7443', 'Polyp of middle ear, bilateral'),
    ('H748X1', 'Other specified disorders of right middle ear and mastoid'),
    ('H748X2', 'Other specified disorders of left middle ear and mastoid'),
    ('H748X3', 'Oth disrd of middle ear and mastoid, bilateral'),
    ('H748X9', 'Oth disrd of middle ear and mastoid, unspecified ear'),
    ('H7490', 'Unsp disorder of middle ear and mastoid, unspecified ear'),
    ('H7491', 'Unspecified disorder of right middle ear and mastoid'),
    ('H7492', 'Unspecified disorder of left middle ear and mastoid'),
    ('H7493', 'Unspecified disorder of middle ear and mastoid, bilateral'),
    ('H7500', 'Mastoiditis in infec/parastc dis classd elswhr, unsp ear'),
    ('H7501', 'Mastoiditis in infec/parastc diseases classd elswhr, r ear'),
    ('H7502', 'Mastoiditis in infec/parastc dis classd elswhr, left ear'),
    ('H7503', 'Mastoiditis in infec/parastc diseases classd elswhr, bi'),
    ('H7580', 'Oth disrd of mid ear and mast in dis classd elswhr, unsp ear'),
    ('H7581', 'Oth disrd of r mid ear and mastoid in diseases classd elswhr'),
    ('H7582', 'Oth disrd of l mid ear and mastoid in diseases classd elswhr'),
    ('H7583', 'Oth disrd of mid ear and mastoid in dis classd elswhr, bi'),
    ('H8000', 'Otosclerosis w oval window, nonobliterative, unsp ear'),
    ('H8001', 'Otosclerosis w oval window, nonobliterative, right ear'),
    ('H8002', 'Otosclerosis w oval window, nonobliterative, left ear'),
    ('H8003', 'Otosclerosis involving oval window, nonobliterative, bi'),
    ('H8010', 'Otosclerosis involving oval window, obliterative, unsp ear'),
    ('H8011', 'Otosclerosis involving oval window, obliterative, right ear'),
    ('H8012', 'Otosclerosis involving oval window, obliterative, left ear'),
    ('H8013', 'Otosclerosis involving oval window, obliterative, bilateral'),
    ('H8020', 'Cochlear otosclerosis, unspecified ear'),
    ('H8021', 'Cochlear otosclerosis, right ear'),
    ('H8022', 'Cochlear otosclerosis, left ear'),
    ('H8023', 'Cochlear otosclerosis, bilateral'),
    ('H8080', 'Other otosclerosis, unspecified ear'),
    ('H8081', 'Other otosclerosis, right ear'),
    ('H8082', 'Other otosclerosis, left ear'),
    ('H8083', 'Other otosclerosis, bilateral'),
    ('H8090', 'Unspecified otosclerosis, unspecified ear'),
    ('H8091', 'Unspecified otosclerosis, right ear'),
    ('H8092', 'Unspecified otosclerosis, left ear'),
    ('H8093', 'Unspecified otosclerosis, bilateral'),
    ('H8101', "Meniere's disease, right ear"),
    ('H8102', "Meniere's disease, left ear"),
    ('H8103', "Meniere's disease, bilateral"),
    ('H8109', "Meniere's disease, unspecified ear"),
    ('H8110', 'Benign paroxysmal vertigo, unspecified ear'),
    ('H8111', 'Benign paroxysmal vertigo, right ear'),
    ('H8112', 'Benign paroxysmal vertigo, left ear'),
    ('H8113', 'Benign paroxysmal vertigo, bilateral'),
    ('H8120', 'Vestibular neuronitis, unspecified ear'),
    ('H8121', 'Vestibular neuronitis, right ear'),
    ('H8122', 'Vestibular neuronitis, left ear'),
    ('H8123', 'Vestibular neuronitis, bilateral'),
    ('H81311', 'Aural vertigo, right ear'),
    ('H81312', 'Aural vertigo, left ear'),
    ('H81313', 'Aural vertigo, bilateral'),
    ('H81319', 'Aural vertigo, unspecified ear'),
    ('H81391', 'Other peripheral vertigo, right ear'),
    ('H81392', 'Other peripheral vertigo, left ear'),
    ('H81393', 'Other peripheral vertigo, bilateral'),
    ('H81399', 'Other peripheral vertigo, unspecified ear'),
    ('H818X1', 'Other disorders of vestibular function, right ear'),
    ('H818X2', 'Other disorders of vestibular function, left ear'),
    ('H818X3', 'Other disorders of vestibular function, bilateral'),
    ('H818X9', 'Other disorders of vestibular function, unspecified ear'),
    ('H8190', 'Unspecified disorder of vestibular function, unspecified ear'),
    ('H8191', 'Unspecified disorder of vestibular function, right ear'),
    ('H8192', 'Unspecified disorder of vestibular function, left ear'),
    ('H8193', 'Unspecified disorder of vestibular function, bilateral'),
    ('H821', 'Vertiginous syndromes in diseases classd elswhr, right ear'),
    ('H822', 'Vertiginous syndromes in diseases classd elswhr, left ear'),
    ('H823', 'Vertiginous syndromes in diseases classd elswhr, bilateral'),
    ('H829', 'Vertiginous syndromes in diseases classd elswhr, unsp ear'),
    ('H8301', 'Labyrinthitis, right ear'),
    ('H8302', 'Labyrinthitis, left ear'),
    ('H8303', 'Labyrinthitis, bilateral'),
    ('H8309', 'Labyrinthitis, unspecified ear'),
    ('H8311', 'Labyrinthine fistula, right ear'),
    ('H8312', 'Labyrinthine fistula, left ear'),
    ('H8313', 'Labyrinthine fistula, bilateral'),
    ('H8319', 'Labyrinthine fistula, unspecified ear'),
    ('H832X1', 'Labyrinthine dysfunction, right ear'),
    ('H832X2', 'Labyrinthine dysfunction, left ear'),
    ('H832X3', 'Labyrinthine dysfunction, bilateral'),
    ('H832X9', 'Labyrinthine dysfunction, unspecified ear'),
    ('H833X1', 'Noise effects on right inner ear'),
    ('H833X2', 'Noise effects on left inner ear'),
    ('H833X3', 'Noise effects on inner ear, bilateral'),
    ('H833X9', 'Noise effects on inner ear, unspecified ear'),
    ('H838X1', 'Other specified diseases of right inner ear'),
    ('H838X2', 'Other specified diseases of left inner ear'),
    ('H838X3', 'Other specified diseases of inner ear, bilateral'),
    ('H838X9', 'Other specified diseases of inner ear, unspecified ear'),
    ('H8390', 'Unspecified disease of inner ear, unspecified ear'),
    ('H8391', 'Unspecified disease of right inner ear'),
    ('H8392', 'Unspecified disease of left inner ear'),
    ('H8393', 'Unspecified disease of inner ear, bilateral'),
    ('H900', 'Conductive hearing loss, bilateral'),
    ('H9011', 'Condctv hear loss, uni, right ear, w unrestr hear cntra side'),
    ('H9012', 'Condctv hear loss, uni, left ear, w unrestr hear cntra side'),
    ('H902', 'Conductive hearing loss, unspecified'),
    ('H903', 'Sensorineural hearing loss, bilateral'),
    ('H9041', 'Snsrnrl hear loss, uni, right ear, w unrestr hear cntra side'),
    ('H9042', 'Snsrnrl hear loss, uni, left ear, w unrestr hear cntra side'),
    ('H905', 'Unspecified sensorineural hearing loss'),
    ('H906', 'Mixed conductive and sensorineural hearing loss, bilateral'),
    ('H9071', 'Mix cndct/snrl hear loss,uni,r ear,w unrestr hear cntra side'),
    ('H9072', 'Mix cndct/snrl hear loss,uni,l ear,w unrestr hear cntra side'),
    ('H908', 'Mixed conductive and sensorineural hearing loss, unspecified'),
    ('H90A11', 'Condctv hear loss, uni, r ear with rstrcd hear cntra side'),
    ('H90A12', 'Condctv hear loss, uni, left ear with rstrcd hear cntra side'),
    ('H90A21', 'Snsrnrl hear loss, uni, r ear, with rstrcd hear cntra side'),
    ('H90A22', 'Snsrnrl hear loss, uni, l ear, with rstrcd hear cntra side'),
    ('H90A31', 'Mix cndct/snrl hear loss,uni,r ear w rstrcd hear cntra side'),
    ('H90A32', 'Mix cndct/snrl hear loss,uni,l ear w rstrcd hear cntra side'),
    ('H9101', 'Ototoxic hearing loss, right ear'),
    ('H9102', 'Ototoxic hearing loss, left ear'),
    ('H9103', 'Ototoxic hearing loss, bilateral'),
    ('H9109', 'Ototoxic hearing loss, unspecified ear'),
    ('H9110', 'Presbycusis, unspecified ear'),
    ('H9111', 'Presbycusis, right ear'),
    ('H9112', 'Presbycusis, left ear'),
    ('H9113', 'Presbycusis, bilateral'),
    ('H9120', 'Sudden idiopathic hearing loss, unspecified ear'),
    ('H9121', 'Sudden idiopathic hearing loss, right ear'),
    ('H9122', 'Sudden idiopathic hearing loss, left ear'),
    ('H9123', 'Sudden idiopathic hearing loss, bilateral'),
    ('H913', 'Deaf nonspeaking, not elsewhere classified'),
    ('H918X1', 'Other specified hearing loss, right ear'),
    ('H918X2', 'Other specified hearing loss, left ear'),
    ('H918X3', 'Other specified hearing loss, bilateral'),
    ('H918X9', 'Other specified hearing loss, unspecified ear'),
    ('H9190', 'Unspecified hearing loss, unspecified ear'),
    ('H9191', 'Unspecified hearing loss, right ear'),
    ('H9192', 'Unspecified hearing loss, left ear'),
    ('H9193', 'Unspecified hearing loss, bilateral'),
    ('H9201', 'Otalgia, right ear'),
    ('H9202', 'Otalgia, left ear'),
    ('H9203', 'Otalgia, bilateral'),
    ('H9209', 'Otalgia, unspecified ear'),
    ('H9210', 'Otorrhea, unspecified ear'),
    ('H9211', 'Otorrhea, right ear'),
    ('H9212', 'Otorrhea, left ear'),
    ('H9213', 'Otorrhea, bilateral'),
    ('H9220', 'Otorrhagia, unspecified ear'),
    ('H9221', 'Otorrhagia, right ear'),
    ('H9222', 'Otorrhagia, left ear'),
    ('H9223', 'Otorrhagia, bilateral'),
    ('H93011', 'Transient ischemic deafness, right ear'),
    ('H93012', 'Transient ischemic deafness, left ear'),
    ('H93013', 'Transient ischemic deafness, bilateral'),
    ('H93019', 'Transient ischemic deafness, unspecified ear'),
    ('H93091', 'Unspecified degenerative and vascular disorders of right ear'),
    ('H93092', 'Unspecified degenerative and vascular disorders of left ear'),
    ('H93093', 'Unsp degenerative and vascular disorders of ear, bilateral'),
    ('H93099', 'Unsp degenerative and vascular disorders of unspecified ear'),
    ('H9311', 'Tinnitus, right ear'),
    ('H9312', 'Tinnitus, left ear'),
    ('H9313', 'Tinnitus, bilateral'),
    ('H9319', 'Tinnitus, unspecified ear'),
    ('H93211', 'Auditory recruitment, right ear'),
    ('H93212', 'Auditory recruitment, left ear'),
    ('H93213', 'Auditory recruitment, bilateral'),
    ('H93219', 'Auditory recruitment, unspecified ear'),
    ('H93221', 'Diplacusis, right ear'),
    ('H93222', 'Diplacusis, left ear'),
    ('H93223', 'Diplacusis, bilateral'),
    ('H93229', 'Diplacusis, unspecified ear'),
    ('H93231', 'Hyperacusis, right ear'),
    ('H93232', 'Hyperacusis, left ear'),
    ('H93233', 'Hyperacusis, bilateral'),
    ('H93239', 'Hyperacusis, unspecified ear'),
    ('H93241', 'Temporary auditory threshold shift, right ear'),
    ('H93242', 'Temporary auditory threshold shift, left ear'),
    ('H93243', 'Temporary auditory threshold shift, bilateral'),
    ('H93249', 'Temporary auditory threshold shift, unspecified ear'),
    ('H9325', 'Central auditory processing disorder'),
    ('H93291', 'Other abnormal auditory perceptions, right ear'),
    ('H93292', 'Other abnormal auditory perceptions, left ear'),
    ('H93293', 'Other abnormal auditory perceptions, bilateral'),
    ('H93299', 'Other abnormal auditory perceptions, unspecified ear'),
    ('H933X1', 'Disorders of right acoustic nerve'),
    ('H933X2', 'Disorders of left acoustic nerve'),
    ('H933X3', 'Disorders of bilateral acoustic nerves'),
    ('H933X9', 'Disorders of unspecified acoustic nerve'),
    ('H938X1', 'Other specified disorders of right ear'),
    ('H938X2', 'Other specified disorders of left ear'),
    ('H938X3', 'Other specified disorders of ear, bilateral'),
    ('H938X9', 'Other specified disorders of ear, unspecified ear'),
    ('H9390', 'Unspecified disorder of ear, unspecified ear'),
    ('H9391', 'Unspecified disorder of right ear'),
    ('H9392', 'Unspecified disorder of left ear'),
    ('H9393', 'Unspecified disorder of ear, bilateral'),
    ('H93A1', 'Pulsatile tinnitus, right ear'),
    ('H93A2', 'Pulsatile tinnitus, left ear'),
    ('H93A3', 'Pulsatile tinnitus, bilateral'),
    ('H93A9', 'Pulsatile tinnitus, unspecified ear'),
    ('H9400', 'Acustc neuritis in infec/parastc dis classd elswhr, unsp ear'),
    ('H9401', 'Acustc neuritis in infec/parastc dis classd elswhr, r ear'),
    ('H9402', 'Acustc neuritis in infec/parastc dis classd elswhr, left ear'),
    ('H9403', 'Acustc neuritis in infec/parastc diseases classd elswhr, bi'),
    ('H9480', 'Oth disrd of ear in diseases classified elsewhere, unsp ear'),
    ('H9481', 'Oth disrd of right ear in diseases classified elsewhere'),
    ('H9482', 'Oth disrd of left ear in diseases classified elsewhere'),
    ('H9483', 'Oth disrd of ear in diseases classified elsewhere, bilateral'),
    ('H9500', 'Recur cholesteatoma of postmastoidectomy cavity, unsp ear'),
    ('H9501', 'Recur cholesteatoma of postmastoidectomy cavity, right ear'),
    ('H9502', 'Recur cholesteatoma of postmastoidectomy cavity, left ear'),
    ('H9503', 'Recurrent cholesteatoma of postmastoidectomy cavity, bi ears'),
    ('H95111', 'Chronic inflammation of postmastoidectomy cavity, right ear'),
    ('H95112', 'Chronic inflammation of postmastoidectomy cavity, left ear'),
    ('H95113', 'Chronic inflam of postmastoidectomy cavity, bilateral ears'),
    ('H95119', 'Chronic inflammation of postmastoidectomy cavity, unsp ear'),
    ('H95121', 'Granulation of postmastoidectomy cavity, right ear'),
    ('H95122', 'Granulation of postmastoidectomy cavity, left ear'),
    ('H95123', 'Granulation of postmastoidectomy cavity, bilateral ears'),
    ('H95129', 'Granulation of postmastoidectomy cavity, unspecified ear'),
    ('H95131', 'Mucosal cyst of postmastoidectomy cavity, right ear'),
    ('H95132', 'Mucosal cyst of postmastoidectomy cavity, left ear'),
    ('H95133', 'Mucosal cyst of postmastoidectomy cavity, bilateral ears'),
    ('H95139', 'Mucosal cyst of postmastoidectomy cavity, unspecified ear'),
    ('H95191', 'Other disorders following mastoidectomy, right ear'),
    ('H95192', 'Other disorders following mastoidectomy, left ear'),
    ('H95193', 'Other disorders following mastoidectomy, bilateral ears'),
    ('H95199', 'Other disorders following mastoidectomy, unspecified ear'),
    ('H9521', 'Intraop hemor/hemtom of ear/mastd comp a proc on ear/mastd'),
    ('H9522', 'Intraop hemor/hemtom of ear/mastd complicating oth procedure'),
    ('H9531', 'Acc pnctr & lac of the ear/mastd dur proc on the ear/mastd'),
    ('H9532', 'Accidental pnctr & lac of the ear/mastd during oth procedure'),
    ('H9541', 'Postproc hemor of ear/mastd fol proc on ear/mastd'),
    ('H9542', 'Postproc hemor of ear/mastd following oth procedure'),
    ('H9551', 'Postprocedural hematoma of ear/mastd fol proc on ear/mastd'),
    ('H9552', 'Postproc hematoma of ear/mastd following other procedure'),
    ('H9553', 'Postprocedural seroma of ear/mastd fol proc on ear/mastd'),
    ('H9554', 'Postprocedural seroma of ear/mastd following other procedure'),
    ('H95811', 'Postprocedural stenosis of right external ear canal'),
    ('H95812', 'Postprocedural stenosis of left external ear canal'),
    ('H95813', 'Postprocedural stenosis of external ear canal, bilateral'),
    ('H95819', 'Postprocedural stenosis of unspecified external ear canal'),
    ('H9588', 'Oth intraop comp and disorders of the ear/mastd, NEC'),
    ('H9589', 'Oth postproc comp and disorders of the ear/mastd, NEC'),
    ('I00', 'Rheumatic fever without heart involvement'),
    ('I010', 'Acute rheumatic pericarditis'),
    ('I011', 'Acute rheumatic endocarditis'),
    ('I012', 'Acute rheumatic myocarditis'),
    ('I018', 'Other acute rheumatic heart disease'),
    ('I019', 'Acute rheumatic heart disease, unspecified'),
    ('I020', 'Rheumatic chorea with heart involvement'),
    ('I029', 'Rheumatic chorea without heart involvement'),
    ('I050', 'Rheumatic mitral stenosis'),
    ('I051', 'Rheumatic mitral insufficiency'),
    ('I052', 'Rheumatic mitral stenosis with insufficiency'),
    ('I058', 'Other rheumatic mitral valve diseases'),
    ('I059', 'Rheumatic mitral valve disease, unspecified'),
    ('I060', 'Rheumatic aortic stenosis'),
    ('I061', 'Rheumatic aortic insufficiency'),
    ('I062', 'Rheumatic aortic stenosis with insufficiency'),
    ('I068', 'Other rheumatic aortic valve diseases'),
    ('I069', 'Rheumatic aortic valve disease, unspecified'),
    ('I070', 'Rheumatic tricuspid stenosis'),
    ('I071', 'Rheumatic tricuspid insufficiency'),
    ('I072', 'Rheumatic tricuspid stenosis and insufficiency'),
    ('I078', 'Other rheumatic tricuspid valve diseases'),
    ('I079', 'Rheumatic tricuspid valve disease, unspecified'),
    ('I080', 'Rheumatic disorders of both mitral and aortic valves'),
    ('I081', 'Rheumatic disorders of both mitral and tricuspid valves'),
    ('I082', 'Rheumatic disorders of both aortic and tricuspid valves'),
    ('I083', 'Comb rheumatic disord of mitral, aortic and tricuspid valves'),
    ('I088', 'Other rheumatic multiple valve diseases'),
    ('I089', 'Rheumatic multiple valve disease, unspecified'),
    ('I090', 'Rheumatic myocarditis'),
    ('I091', 'Rheumatic diseases of endocardium, valve unspecified'),
    ('I092', 'Chronic rheumatic pericarditis'),
    ('I0981', 'Rheumatic heart failure'),
    ('I0989', 'Other specified rheumatic heart diseases'),
    ('I099', 'Rheumatic heart disease, unspecified'),
    ('I10', 'Essential (primary) hypertension'),
    ('I110', 'Hypertensive heart disease with heart failure'),
    ('I119', 'Hypertensive heart disease without heart failure'),
    ('I120', 'Hyp chr kidney disease w stage 5 chr kidney disease or ESRD'),
    ('I129', 'Hypertensive chronic kidney disease w stg 1-4/unsp chr kdny'),
    ('I130', 'Hyp hrt & chr kdny dis w hrt fail and stg 1-4/unsp chr kdny'),
    ('I1310', 'Hyp hrt & chr kdny dis w/o hrt fail, w stg 1-4/unsp chr kdny'),
    ('I1311', 'Hyp hrt and chr kdny dis w/o hrt fail, w stg 5 chr kdny/ESRD'),
    ('I132', 'Hyp hrt & chr kdny dis w hrt fail and w stg 5 chr kdny/ESRD'),
    ('I150', 'Renovascular hypertension'),
    ('I151', 'Hypertension secondary to other renal disorders'),
    ('I152', 'Hypertension secondary to endocrine disorders'),
    ('I158', 'Other secondary hypertension'),
    ('I159', 'Secondary hypertension, unspecified'),
    ('I160', 'Hypertensive urgency'),
    ('I161', 'Hypertensive emergency'),
    ('I169', 'Hypertensive crisis, unspecified'),
    ('I1A0', 'Resistant hypertension'),
    ('I200', 'Unstable angina'),
    ('I201', 'Angina pectoris with documented spasm'),
    ('I202', 'Refractory angina pectoris'),
    ('I208', 'Other forms of angina pectoris'),
    ('I2081', 'Angina pectoris with coronary microvascular dysfunction'),
    ('I2089', 'Other forms of angina pectoris'),
    ('I209', 'Angina pectoris, unspecified'),
    ('I2101', 'STEMI involving left main coronary artery'),
    ('I2102', 'STEMI involving left anterior descending coronary artery'),
    ('I2109', 'STEMI involving oth coronary artery of anterior wall'),
    ('I2111', 'STEMI involving right coronary artery'),
    ('I2119', 'STEMI involving oth coronary artery of inferior wall'),
    ('I2121', 'STEMI involving left circumflex coronary artery'),
    ('I2129', 'STEMI involving oth sites'),
    ('I213', 'ST elevation (STEMI) myocardial infarction of unsp site'),
    ('I214', 'Non-ST elevation (NSTEMI) myocardial infarction'),
    ('I219', 'Acute myocardial infarction, unspecified'),
    ('I21A1', 'Acute myocardial infarction type 2'),
    ('I21A9', 'Other myocardial infarction type'),
    ('I21B', 'Myocardial infarction with coronary microvascular dysfnct'),
    ('I220', 'Subsequent STEMI of anterior wall'),
    ('I221', 'Subsequent STEMI of inferior wall'),
    ('I222', 'Subsequent non-ST elevation (NSTEMI) myocardial infarction'),
    ('I228', 'Subsequent STEMI of sites'),
    ('I229', 'Subsequent STEMI of unsp site'),
    ('I230', 'Hemopericardium as current complication following AMI'),
    ('I231', 'Atrial septal defect as current complication following AMI'),
    ('I232', 'Ventricular septal defect as current comp following AMI'),
    ('I233', 'Rupture of card wall w/o hemoperic as current comp fol AMI'),
    ('I234', 'Rupture of chord tendne as current comp following AMI'),
    ('I235', 'Rupture of papillary muscle as current comp following AMI'),
    ('I236', 'Thombos of atrium/auric append/ventr as current comp fol AMI'),
    ('I237', 'Postinfarction angina'),
    ('I238', 'Oth current complications following AMI'),
    ('I240', 'Acute coronary thrombosis not resulting in myocardial infrc'),
    ('I241', "Dressler's syndrome"),
    ('I248', 'Other forms of acute ischemic heart disease'),
    ('I2481', 'Acute coronary microvascular dysfunction'),
    ('I2489', 'Other forms of acute ischemic heart disease'),
    ('I249', 'Acute ischemic heart disease, unspecified'),
    ('I2510', 'Athscl heart disease of native coronary artery w/o ang pctrs'),
    ('I25110', 'Athscl heart disease of native cor art w unstable ang pctrs'),
    ('I25111', 'Athscl heart disease of native cor art w ang pctrs w spasm'),
    ('I25112', 'Athscl heart dis of native cor art with refract ang pctrs'),
    ('I25118', 'Athscl heart disease of native cor art w oth ang pctrs'),
    ('I25119', 'Athscl heart disease of native cor art w unsp ang pctrs'),
    ('I252', 'Old myocardial infarction'),
    ('I253', 'Aneurysm of heart'),
    ('I2541', 'Coronary artery aneurysm'),
    ('I2542', 'Coronary artery dissection'),
    ('I255', 'Ischemic cardiomyopathy'),
    ('I256', 'Silent myocardial ischemia'),
    ('I25700', 'Atherosclerosis of CABG, unsp, w unstable angina pectoris'),
    ('I25701', 'Athscl CABG, unsp, w angina pectoris w documented spasm'),
    ('I25702', 'Athscl CABG, unspecified, with refractory angina pectoris'),
    ('I25708', 'Atherosclerosis of CABG, unsp, w oth angina pectoris'),
    ('I25709', 'Atherosclerosis of CABG, unsp, w unsp angina pectoris'),
    ('I25710', 'Athscl autologous vein CABG w unstable angina pectoris'),
    ('I25711', 'Athscl autologous vein CABG w ang pctrs w documented spasm'),
    ('I25712', 'Athscl autologous vein CABG with refractory angina pectoris'),
    ('I25718', 'Athscl autologous vein CABG w oth angina pectoris'),
    ('I25719', 'Athscl autologous vein CABG w unsp angina pectoris'),
    ('I25720', 'Athscl autologous artery CABG w unstable angina pectoris'),
    ('I25721', 'Athscl autologous artery CABG w ang pctrs w documented spasm'),
    ('I25722', 'Athscl autologous artery CABG with refractory ang pctrs'),
    ('I25728', 'Athscl autologous artery CABG w oth angina pectoris'),
    ('I25729', 'Athscl autologous artery CABG w unsp angina pectoris'),
    ('I25730', 'Athscl nonautologous biological CABG w unstable ang pctrs'),
    ('I25731', 'Athscl nonaut biological CABG w ang pctrs w documented spasm'),
    ('I25732', 'Athscl nonaut biological CABG with refractory ang pctrs'),
    ('I25738', 'Athscl nonautologous biological CABG w oth angina pectoris'),
    ('I25739', 'Athscl nonautologous biological CABG w unsp angina pectoris'),
    ('I25750', 'Athscl native cor art of txplt heart w unstable angina'),
    ('I25751', 'Athscl native cor art of txplt heart w ang pctrs w spasm'),
    ('I25752', 'Athscl native cor art of txplt heart with refract ang pctrs'),
    ('I25758', 'Athscl native cor art of transplanted heart w oth ang pctrs'),
    ('I25759', 'Athscl native cor art of transplanted heart w unsp ang pctrs'),
    ('I25760', 'Athscl bypass of cor art of txplt heart w unstable angina'),
    ('I25761', 'Athscl bypass of cor art of txplt heart w ang pctrs w spasm'),
    ('I25762', 'Athscl bypass of cor art of txplt hrt with refract ang pctrs'),
    ('I25768', 'Athscl bypass of cor art of txplt heart w oth ang pctrs'),
    ('I25769', 'Athscl bypass of cor art of txplt heart w unsp ang pctrs'),
    ('I25790', 'Atherosclerosis of CABG w unstable angina pectoris'),
    ('I25791', 'Atherosclerosis of CABG w angina pectoris w documented spasm'),
    ('I25792', 'Athscl other CABG with refractory angina pectoris'),
    ('I25798', 'Atherosclerosis of CABG w oth angina pectoris'),
    ('I25799', 'Atherosclerosis of CABG w unsp angina pectoris'),
    ('I25810', 'Atherosclerosis of CABG w/o angina pectoris'),
    ('I25811', 'Athscl native cor art of transplanted heart w/o ang pctrs'),
    ('I25812', 'Athscl bypass of cor art of transplanted heart w/o ang pctrs'),
    ('I2582', 'Chronic total occlusion of coronary artery'),
    ('I2583', 'Coronary atherosclerosis due to lipid rich plaque'),
    ('I2584', 'Coronary atherosclerosis due to calcified coronary lesion'),
    ('I2585', 'Chronic coronary microvascular dysfunction'),
    ('I2589', 'Other forms of chronic ischemic heart disease'),
    ('I259', 'Chronic ischemic heart disease, unspecified'),
    ('I2601', 'Septic pulmonary embolism with acute cor pulmonale'),
    ('I2602', 'Saddle embolus of pulmonary artery with acute cor pulmonale'),
    ('I2609', 'Other pulmonary embolism with acute cor pulmonale'),
    ('I2690', 'Septic pulmonary embolism without acute cor pulmonale'),
    ('I2692', 'Saddle embolus of pulmonary artery w/o acute cor pulmonale'),
    ('I2693', 'Single subsegmental pulmon emblsm w/o acute cor pulmonale'),
    ('I2694', 'Mult subsegmental pulmon emboli without acute cor pulmonale'),
    ('I2699', 'Other pulmonary embolism without acute cor pulmonale'),
    ('I270', 'Primary pulmonary hypertension'),
    ('I271', 'Kyphoscoliotic heart disease'),
    ('I272', 'Other secondary pulmonary hypertension'),
    ('I2720', 'Pulmonary hypertension, unspecified'),
    ('I2721', 'Secondary pulmonary arterial hypertension'),
    ('I2722', 'Pulmonary hypertension due to left heart disease'),
    ('I2723', 'Pulmonary hypertension due to lung diseases and hypoxia'),
    ('I2724', 'Chronic thromboembolic pulmonary hypertension'),
    ('I2729', 'Other secondary pulmonary hypertension'),
    ('I2781', 'Cor pulmonale (chronic)'),
    ('I2782', 'Chronic pulmonary embolism'),
    ('I2783', "Eisenmenger's syndrome"),
    ('I2789', 'Other specified pulmonary heart diseases'),
    ('I279', 'Pulmonary heart disease, unspecified'),
    ('I280', 'Arteriovenous fistula of pulmonary vessels'),
    ('I281', 'Aneurysm of pulmonary artery'),
    ('I288', 'Other diseases of pulmonary vessels'),
    ('I289', 'Disease of pulmonary vessels, unspecified'),
    ('I300', 'Acute nonspecific idiopathic pericarditis'),
    ('I301', 'Infective pericarditis'),
    ('I308', 'Other forms of acute pericarditis'),
    ('I309', 'Acute pericarditis, unspecified'),
    ('I310', 'Chronic adhesive pericarditis'),
    ('I311', 'Chronic constrictive pericarditis'),
    ('I312', 'Hemopericardium, not elsewhere classified'),
    ('I313', 'Pericardial effusion (noninflammatory)'),
    ('I3131', 'Malignant pericardial effusion in diseases classd elswhr'),
    ('I3139', 'Other pericardial effusion (noninflammatory)'),
    ('I314', 'Cardiac tamponade'),
    ('I318', 'Other specified diseases of pericardium'),
    ('I319', 'Disease of pericardium, unspecified'),
    ('I32', 'Pericarditis in diseases classified elsewhere'),
    ('I330', 'Acute and subacute infective endocarditis'),
    ('I339', 'Acute and subacute endocarditis, unspecified'),
    ('I340', 'Nonrheumatic mitral (valve) insufficiency'),
    ('I341', 'Nonrheumatic mitral (valve) prolapse'),
    ('I342', 'Nonrheumatic mitral (valve) stenosis'),
    ('I348', 'Other nonrheumatic mitral valve disorders'),
    ('I3481', 'Nonrheumatic mitral (valve) annulus calcification'),
    ('I3489', 'Other nonrheumatic mitral valve disorders'),
    ('I349', 'Nonrheumatic mitral valve disorder, unspecified'),
    ('I350', 'Nonrheumatic aortic (valve) stenosis'),
    ('I351', 'Nonrheumatic aortic (valve) insufficiency'),
    ('I352', 'Nonrheumatic aortic (valve) stenosis with insufficiency'),
    ('I358', 'Other nonrheumatic aortic valve disorders'),
    ('I359', 'Nonrheumatic aortic valve disorder, unspecified'),
    ('I360', 'Nonrheumatic tricuspid (valve) stenosis'),
    ('I361', 'Nonrheumatic tricuspid (valve) insufficiency'),
    ('I362', 'Nonrheumatic tricuspid (valve) stenosis with insufficiency'),
    ('I368', 'Other nonrheumatic tricuspid valve disorders'),
    ('I369', 'Nonrheumatic tricuspid valve disorder, unspecified'),
    ('I370', 'Nonrheumatic pulmonary valve stenosis'),
    ('I371', 'Nonrheumatic pulmonary valve insufficiency'),
    ('I372', 'Nonrheumatic pulmonary valve stenosis with insufficiency'),
    ('I378', 'Other nonrheumatic pulmonary valve disorders'),
    ('I379', 'Nonrheumatic pulmonary valve disorder, unspecified'),
    ('I38', 'Endocarditis, valve unspecified'),
    ('I39', 'Endocarditis and heart valve disord in dis classd elswhr'),
    ('I400', 'Infective myocarditis'),
    ('I401', 'Isolated myocarditis'),
    ('I408', 'Other acute myocarditis'),
    ('I409', 'Acute myocarditis, unspecified'),
    ('I41', 'Myocarditis in diseases classified elsewhere'),
    ('I420', 'Dilated cardiomyopathy'),
    ('I421', 'Obstructive hypertrophic cardiomyopathy'),
    ('I422', 'Other hypertrophic cardiomyopathy'),
    ('I423', 'Endomyocardial (eosinophilic) disease'),
    ('I424', 'Endocardial fibroelastosis'),
    ('I425', 'Other restrictive cardiomyopathy'),
    ('I426', 'Alcoholic cardiomyopathy'),
    ('I427', 'Cardiomyopathy due to drug and external agent'),
    ('I428', 'Other cardiomyopathies'),
    ('I429', 'Cardiomyopathy, unspecified'),
    ('I43', 'Cardiomyopathy in diseases classified elsewhere'),
    ('I440', 'Atrioventricular block, first degree'),
    ('I441', 'Atrioventricular block, second degree'),
    ('I442', 'Atrioventricular block, complete'),
    ('I4430', 'Unspecified atrioventricular block'),
    ('I4439', 'Other atrioventricular block'),
    ('I444', 'Left anterior fascicular block'),
    ('I445', 'Left posterior fascicular block'),
    ('I4460', 'Unspecified fascicular block'),
    ('I4469', 'Other fascicular block'),
    ('I447', 'Left bundle-branch block, unspecified'),
    ('I450', 'Right fascicular block'),
    ('I4510', 'Unspecified right bundle-branch block'),
    ('I4519', 'Other right bundle-branch block'),
    ('I452', 'Bifascicular block'),
    ('I453', 'Trifascicular block'),
    ('I454', 'Nonspecific intraventricular block'),
    ('I455', 'Other specified heart block'),
    ('I456', 'Pre-excitation syndrome'),
    ('I4581', 'Long QT syndrome'),
    ('I4589', 'Other specified conduction disorders'),
    ('I459', 'Conduction disorder, unspecified'),
    ('I462', 'Cardiac arrest due to underlying cardiac condition'),
    ('I468', 'Cardiac arrest due to other underlying condition'),
    ('I469', 'Cardiac arrest, cause unspecified'),
    ('I470', 'Re-entry ventricular arrhythmia'),
    ('I471', 'Supraventricular tachycardia'),
    ('I4710', 'Supraventricular tachycardia, unspecified'),
    ('I4711', 'Inappropriate sinus tachycardia, so stated'),
    ('I4719', 'Other supraventricular tachycardia'),
    ('I472', 'Ventricular tachycardia'),
    ('I4720', 'Ventricular tachycardia, unspecified'),
    ('I4721', 'Torsades de pointes'),
    ('I4729', 'Other ventricular tachycardia'),
    ('I479', 'Paroxysmal tachycardia, unspecified'),
    ('I480', 'Paroxysmal atrial fibrillation'),
    ('I481', 'Persistent atrial fibrillation'),
    ('I4811', 'Longstanding persistent atrial fibrillation'),
    ('I4819', 'Other persistent atrial fibrillation'),
    ('I482', 'Chronic atrial fibrillation'),
    ('I4820', 'Chronic atrial fibrillation, unspecified'),
    ('I4821', 'Permanent atrial fibrillation'),
    ('I483', 'Typical atrial flutter'),
    ('I484', 'Atypical atrial flutter'),
    ('I4891', 'Unspecified atrial fibrillation'),
    ('I4892', 'Unspecified atrial flutter'),
    ('I4901', 'Ventricular fibrillation'),
    ('I4902', 'Ventricular flutter'),
    ('I491', 'Atrial premature depolarization'),
    ('I492', 'Junctional premature depolarization'),
    ('I493', 'Ventricular premature depolarization'),
    ('I4940', 'Unspecified premature depolarization'),
    ('I4949', 'Other premature depolarization'),
    ('I495', 'Sick sinus syndrome'),
    ('I498', 'Other specified cardiac arrhythmias'),
    ('I499', 'Cardiac arrhythmia, unspecified'),
    ('I501', 'Left ventricular failure, unspecified'),
    ('I5020', 'Unspecified systolic (congestive) heart failure'),
    ('I5021', 'Acute systolic (congestive) heart failure'),
    ('I5022', 'Chronic systolic (congestive) heart failure'),
    ('I5023', 'Acute on chronic systolic (congestive) heart failure'),
    ('I5030', 'Unspecified diastolic (congestive) heart failure'),
    ('I5031', 'Acute diastolic (congestive) heart failure'),
    ('I5032', 'Chronic diastolic (congestive) heart failure'),
    ('I5033', 'Acute on chronic diastolic (congestive) heart failure'),
    ('I5040', 'Unsp combined systolic and diastolic (congestive) hrt fail'),
    ('I5041', 'Acute combined systolic and diastolic (congestive) hrt fail'),
    ('I5042', 'Chronic combined systolic and diastolic hrt fail'),
    ('I5043', 'Acute on chronic combined systolic and diastolic hrt fail'),
    ('I50810', 'Right heart failure, unspecified'),
    ('I50811', 'Acute right heart failure'),
    ('I50812', 'Chronic right heart failure'),
    ('I50813', 'Acute on chronic right heart failure'),
    ('I50814', 'Right heart failure due to left heart failure'),
    ('I5082', 'Biventricular heart failure'),
    ('I5083', 'High output heart failure'),
    ('I5084', 'End stage heart failure'),
    ('I5089', 'Other heart failure'),
    ('I509', 'Heart failure, unspecified'),
    ('I510', 'Cardiac septal defect, acquired'),
    ('I511', 'Rupture of chordae tendineae, not elsewhere classified'),
    ('I512', 'Rupture of papillary muscle, not elsewhere classified'),
    ('I513', 'Intracardiac thrombosis, not elsewhere classified'),
    ('I514', 'Myocarditis, unspecified'),
    ('I515', 'Myocardial degeneration'),
    ('I517', 'Cardiomegaly'),
    ('I5181', 'Takotsubo syndrome'),
    ('I5189', 'Other ill-defined heart diseases'),
    ('I519', 'Heart disease, unspecified'),
    ('I52', 'Other heart disorders in diseases classified elsewhere'),
    ('I5A', 'Non-ischemic myocardial injury (non-traumatic)'),
    ('I6000', 'Ntrm subarach hemorrhage from unsp carotid siphon and bifurc'),
    ('I6001', 'Ntrm subarach hemor from right carotid siphon and bifurc'),
    ('I6002', 'Ntrm subarach hemorrhage from left carotid siphon and bifurc'),
    ('I6010', 'Ntrm subarach hemorrhage from unsp middle cerebral artery'),
    ('I6011', 'Ntrm subarach hemorrhage from right middle cerebral artery'),
    ('I6012', 'Ntrm subarach hemorrhage from left middle cerebral artery'),
    ('I602', 'Ntrm subarach hemorrhage from anterior communicating artery'),
    ('I6020', 'Ntrm subarach hemor from unsp anterior communicating artery'),
    ('I6021', 'Ntrm subarach hemor from right anterior communicating artery'),
    ('I6022', 'Ntrm subarach hemor from left anterior communicating artery'),
    ('I6030', 'Ntrm subarach hemor from unsp posterior communicating artery'),
    ('I6031', 'Ntrm subarach hemor from right post communicating artery'),
    ('I6032', 'Ntrm subarach hemor from left posterior communicating artery'),
    ('I604', 'Nontraumatic subarachnoid hemorrhage from basilar artery'),
    ('I6050', 'Nontraumatic subarachnoid hemorrhage from unsp verteb art'),
    ('I6051', 'Nontraumatic subarachnoid hemorrhage from r verteb art'),
    ('I6052', 'Nontraumatic subarachnoid hemorrhage from l verteb art'),
    ('I606', 'Nontraumatic subarachnoid hemorrhage from oth intracran art'),
    ('I607', 'Nontraumatic subarachnoid hemorrhage from unsp intracran art'),
    ('I608', 'Other nontraumatic subarachnoid hemorrhage'),
    ('I609', 'Nontraumatic subarachnoid hemorrhage, unspecified'),
    ('I610', 'Nontraumatic intcrbl hemorrhage in hemisphere, subcortical'),
    ('I611', 'Nontraumatic intcrbl hemorrhage in hemisphere, cortical'),
    ('I612', 'Nontraumatic intracerebral hemorrhage in hemisphere, unsp'),
    ('I613', 'Nontraumatic intracerebral hemorrhage in brain stem'),
    ('I614', 'Nontraumatic intracerebral hemorrhage in cerebellum'),
    ('I615', 'Nontraumatic intracerebral hemorrhage, intraventricular'),
    ('I616', 'Nontraumatic intracerebral hemorrhage, multiple localized'),
    ('I618', 'Other nontraumatic intracerebral hemorrhage'),
    ('I619', 'Nontraumatic intracerebral hemorrhage, unspecified'),
    ('I6200', 'Nontraumatic subdural hemorrhage, unspecified'),
    ('I6201', 'Nontraumatic acute subdural hemorrhage'),
    ('I6202', 'Nontraumatic subacute subdural hemorrhage'),
    ('I6203', 'Nontraumatic chronic subdural hemorrhage'),
    ('I621', 'Nontraumatic extradural hemorrhage'),
    ('I629', 'Nontraumatic intracranial hemorrhage, unspecified'),
    ('I6300', 'Cerebral infarction due to thombos unsp precerebral artery'),
    ('I63011', 'Cerebral infarction due to thrombosis of r verteb art'),
    ('I63012', 'Cerebral infarction due to thrombosis of l verteb art'),
    ('I63013', 'Cerebral infrc due to thrombosis of bilateral verteb art'),
    ('I63019', 'Cerebral infarction due to thombos unsp vertebral artery'),
    ('I6302', 'Cerebral infarction due to thrombosis of basilar artery'),
    ('I63031', 'Cerebral infrc due to thrombosis of right carotid artery'),
    ('I63032', 'Cerebral infarction due to thrombosis of left carotid artery'),
    ('I63033', 'Cerebral infrc due to thombos of bilateral carotid arteries'),
    ('I63039', 'Cerebral infarction due to thrombosis of unsp carotid artery'),
    ('I6309', 'Cerebral infarction due to thrombosis of precerebral artery'),
    ('I6310', 'Cerebral infarction due to embolism of unsp precerb artery'),
    ('I63111', 'Cerebral infarction due to embolism of r verteb art'),
    ('I63112', 'Cerebral infarction due to embolism of left vertebral artery'),
    ('I63113', 'Cerebral infarction due to embolism of unsp vertebral artery'),
    ('I63119', 'Cerebral infarction due to embolism of unsp vertebral artery'),
    ('I6312', 'Cerebral infarction due to embolism of basilar artery'),
    ('I63131', 'Cerebral infarction due to embolism of right carotid artery'),
    ('I63132', 'Cerebral infarction due to embolism of left carotid artery'),
    ('I63133', 'Cerebral infrc due to embolism of bilateral carotid arteries'),
    ('I63139', 'Cerebral infarction due to embolism of unsp carotid artery'),
    ('I6319', 'Cerebral infarction due to embolism of precerebral artery'),
    ('I6320', 'Cereb infrc due to unsp occls or stenos of unsp precerb art'),
    ('I63211', 'Cereb infrc due to unsp occls or stenos of right verteb art'),
    ('I63212', 'Cereb infrc due to unsp occls or stenosis of left verteb art'),
    ('I63213', 'Cereb infrc due to unsp occls or stenosis of bi verteb art'),
    ('I63219', 'Cereb infrc due to unsp occls or stenosis of unsp verteb art'),
    ('I6322', 'Cerebral infrc due to unsp occls or stenosis of basilar art'),
    ('I63231', 'Cereb infrc due to unsp occls or stenos of right carotid art'),
    ('I63232', 'Cereb infrc due to unsp occls or stenos of left carotid art'),
    ('I63233', 'Cereb infrc due to unsp occls or stenosis of bi carotid art'),
    ('I63239', 'Cereb infrc due to unsp occls or stenos of unsp crtd artery'),
    ('I6329', 'Cerebral infrc due to unsp occls or stenosis of precerb art'),
    ('I6330', 'Cerebral infarction due to thombos unsp cerebral artery'),
    ('I63311', 'Cereb infrc due to thombos of right middle cerebral artery'),
    ('I63312', 'Cerebral infrc due to thombos of left middle cerebral artery'),
    ('I63313', 'Cerebral infrc due to thombos of bi middle cerebral arteries'),
    ('I63319', 'Cerebral infrc due to thombos unsp middle cerebral artery'),
    ('I63321', 'Cerebral infrc due to thombos of right ant cerebral artery'),
    ('I63322', 'Cerebral infrc due to thombos of left ant cerebral artery'),
    ('I63323', 'Cerebral infrc due to thombos of bilateral ant cerebral arteries'),
    ('I63329', 'Cerebral infrc due to thombos unsp anterior cerebral artery'),
    ('I63331', 'Cerebral infrc due to thombos of right post cerebral artery'),
    ('I63332', 'Cerebral infrc due to thombos of left post cerebral artery'),
    ('I63333', 'Cerebral infrc due to thombos of bi post cerebral arteries'),
    ('I63339', 'Cerebral infrc due to thombos unsp posterior cerebral artery'),
    ('I63341', 'Cerebral infrc due to thrombosis of right cereblr artery'),
    ('I63342', 'Cerebral infarction due to thrombosis of left cereblr artery'),
    ('I63343', 'Cerebral infrc due to thombos of bilateral cereblr arteries'),
    ('I63349', 'Cerebral infarction due to thombos unsp cerebellar artery'),
    ('I6339', 'Cerebral infarction due to thrombosis of oth cerebral artery'),
    ('I6340', 'Cerebral infarction due to embolism of unsp cerebral artery'),
    ('I63411', 'Cereb infrc due to embolism of right middle cerebral artery'),
    ('I63412', 'Cereb infrc due to embolism of left middle cerebral artery'),
    ('I63413', 'Cerebral infrc due to embolism of bi middle cerebral art'),
    ('I63419', 'Cereb infrc due to embolism of unsp middle cerebral artery'),
    ('I63421', 'Cerebral infrc due to embolism of right ant cerebral artery'),
    ('I63422', 'Cerebral infrc due to embolism of left ant cerebral artery'),
    ('I63423', 'Cerebral infrc due to embolism of bi ant cerebral arteries'),
    ('I63429', 'Cerebral infrc due to embolism of unsp ant cerebral artery'),
    ('I63431', 'Cerebral infrc due to embolism of right post cerebral artery'),
    ('I63432', 'Cerebral infrc due to embolism of left post cerebral artery'),
    ('I63433', 'Cerebral infrc due to embolism of bi post cerebral arteries'),
    ('I63439', 'Cerebral infrc due to embolism of unsp post cerebral artery'),
    ('I63441', 'Cerebral infarction due to embolism of right cereblr artery'),
    ('I63442', 'Cerebral infarction due to embolism of left cereblr artery'),
    ('I63443', 'Cerebral infrc due to embolism of bilateral cereblr arteries'),
    ('I63449', 'Cerebral infarction due to embolism of unsp cereblr artery'),
    ('I6349', 'Cerebral infarction due to embolism of other cerebral artery'),
    ('I6350', 'Cereb infrc due to unsp occls or stenos of unsp cereb artery'),
    ('I63511', 'Cereb infrc d/t unsp occls or stenos of right mid cereb art'),
    ('I63512', 'Cereb infrc d/t unsp occls or stenos of left mid cereb art'),
    ('I63513', 'Cereb infrc due to unsp occls or stenos of bi mid cereb art'),
    ('I63519', 'Cereb infrc d/t unsp occls or stenos of unsp mid cereb art'),
    ('I63521', 'Cereb infrc d/t unsp occls or stenos of right ant cereb art'),
    ('I63522', 'Cereb infrc d/t unsp occls or stenos of left ant cereb art'),
    ('I63523', 'Cerebral infrc due to unsp occls or stenos of bi ant cereb art'),
    ('I63529', 'Cereb infrc d/t unsp occls or stenos of unsp ant cereb art'),
    ('I63531', 'Cereb infrc d/t unsp occls or stenos of right post cereb art'),
    ('I63532', 'Cereb infrc d/t unsp occls or stenos of left post cereb art'),
    ('I63533', 'Cerebral infrc due to unsp occls or stenos of bi post cereb art'),
    ('I63539', 'Cereb infrc d/t unsp occls or stenos of unsp post cereb art'),
    ('I63541', 'Cereb infrc due to unsp occls or stenos of right cereblr art'),
    ('I63542', 'Cereb infrc due to unsp occls or stenos of left cereblr art'),
    ('I63543', 'Cereb infrc due to unsp occls or stenosis of bi cereblr art'),
    ('I63549', 'Cereb infrc due to unsp occls or stenos of unsp cereblr art'),
    ('I6359', 'Cereb infrc due to unsp occls or stenosis of cerebral artery'),
    ('I636', 'Cerebral infrc due to cerebral venous thombos, nonpyogenic'),
    ('I638', 'Other cerebral infarction'),
    ('I6381', 'Other cereb infrc due to occls or stenosis of small artery'),
    ('I6389', 'Other cerebral infarction'),
    ('I639', 'Cerebral infarction, unspecified'),
    ('I6501', 'Occlusion and stenosis of right vertebral artery'),
    ('I6502', 'Occlusion and stenosis of left vertebral artery'),
    ('I6503', 'Occlusion and stenosis of bilateral vertebral arteries'),
    ('I6509', 'Occlusion and stenosis of unspecified vertebral artery'),
    ('I651', 'Occlusion and stenosis of basilar artery'),
    ('I6521', 'Occlusion and stenosis of right carotid artery'),
    ('I6522', 'Occlusion and stenosis of left carotid artery'),
    ('I6523', 'Occlusion and stenosis of bilateral carotid arteries'),
    ('I6529', 'Occlusion and stenosis of unspecified carotid artery'),
    ('I658', 'Occlusion and stenosis of other precerebral arteries'),
    ('I659', 'Occlusion and stenosis of unspecified precerebral artery'),
    ('I6601', 'Occlusion and stenosis of right middle cerebral artery'),
    ('I6602', 'Occlusion and stenosis of left middle cerebral artery'),
    ('I6603', 'Occlusion and stenosis of bilateral middle cerebral arteries'),
    ('I6609', 'Occlusion and stenosis of unspecified middle cerebral artery'),
    ('I6611', 'Occlusion and stenosis of right anterior cerebral artery'),
    ('I6612', 'Occlusion and stenosis of left anterior cerebral artery'),
    ('I6613', 'Occlusion and stenosis of bi anterior cerebral arteries'),
    ('I6619', 'Occlusion and stenosis of unsp anterior cerebral artery'),
    ('I6621', 'Occlusion and stenosis of right posterior cerebral artery'),
    ('I6622', 'Occlusion and stenosis of left posterior cerebral artery'),
    ('I6623', 'Occlusion and stenosis of bi posterior cerebral arteries'),
    ('I6629', 'Occlusion and stenosis of unsp posterior cerebral artery'),
    ('I663', 'Occlusion and stenosis of cerebellar arteries'),
    ('I668', 'Occlusion and stenosis of other cerebral arteries'),
    ('I669', 'Occlusion and stenosis of unspecified cerebral artery'),
    ('I670', 'Dissection of cerebral arteries, nonruptured'),
    ('I671', 'Cerebral aneurysm, nonruptured'),
    ('I672', 'Cerebral atherosclerosis'),
    ('I673', 'Progressive vascular leukoencephalopathy'),
    ('I674', 'Hypertensive encephalopathy'),
    ('I675', 'Moyamoya disease'),
    ('I676', 'Nonpyogenic thrombosis of intracranial venous system'),
    ('I677', 'Cerebral arteritis, not elsewhere classified'),
    ('I6781', 'Acute cerebrovascular insufficiency'),
    ('I6782', 'Cerebral ischemia'),
    ('I6783', 'Posterior reversible encephalopathy syndrome'),
    ('I67841', 'Reversible cerebrovascular vasoconstriction syndrome'),
    ('I67848', 'Other cerebrovascular vasospasm and vasoconstriction'),
    ('I67850', 'Cereb autosom dom artopath w subcort infarcts & leukoenceph'),
    ('I67858', 'Other hereditary cerebrovascular disease'),
    ('I6789', 'Other cerebrovascular disease'),
    ('I679', 'Cerebrovascular disease, unspecified'),
    ('I680', 'Cerebral amyloid angiopathy'),
    ('I682', 'Cerebral arteritis in other diseases classified elsewhere'),
    ('I688', 'Oth cerebrovascular disorders in diseases classd elswhr'),
    ('I6900', 'Unspecified sequelae of nontraumatic subarachnoid hemorrhage'),
    ('I6901', 'Cognitive deficits following ntrm subarachnoid hemorrhage'),
    ('I69010', 'Attn and concentration deficit following ntrm subarach hemor'),
    ('I69011', 'Memory deficit following ntrm subarachnoid hemorrhage'),
    ('I69012', 'Vis def/sptl nglct following ntrm subarachnoid hemorrhage'),
    ('I69013', 'Psychomotor deficit following ntrm subarachnoid hemorrhage'),
    ('I69014', 'Fntl lb and exec fcn def following ntrm subarach hemorrhage'),
    ('I69015', 'Cognitive social or emo def following ntrm subarach hemor'),
    ('I69018', 'Other symp and signs w cogn fnctns fol ntrm subarach hemor'),
    ('I69019', 'Unsp symp and signs w cogn fnctns fol ntrm subarach hemor'),
    ('I69020', 'Aphasia following nontraumatic subarachnoid hemorrhage'),
    ('I69021', 'Dysphasia following nontraumatic subarachnoid hemorrhage'),
    ('I69022', 'Dysarthria following nontraumatic subarachnoid hemorrhage'),
    ('I69023', 'Fluency disorder following ntrm subarachnoid hemorrhage'),
    ('I69028', 'Oth speech/lang deficits following ntrm subarach hemorrhage'),
    ('I69031', 'Monoplg upr lmb fol ntrm subarach hemor aff right dom side'),
    ('I69032', 'Monoplg upr lmb fol ntrm subarach hemor aff left dom side'),
    ('I69033', 'Monoplg upr lmb fol ntrm subarach hemor aff r nondom side'),
    ('I69034', 'Monoplg upr lmb fol ntrm subarach hemor aff left nondom side'),
    ('I69039', 'Monoplg upr lmb following ntrm subarach hemor aff unsp side'),
    ('I69041', 'Monoplg low lmb fol ntrm subarach hemor aff right dom side'),
    ('I69042', 'Monoplg low lmb fol ntrm subarach hemor aff left dom side'),
    ('I69043', 'Monoplg low lmb fol ntrm subarach hemor aff r nondom side'),
    ('I69044', 'Monoplg low lmb fol ntrm subarach hemor aff left nondom side'),
    ('I69049', 'Monoplg low lmb following ntrm subarach hemor aff unsp side'),
    ('I69051', 'Hemiplga fol ntrm subarach hemor aff right dominant side'),
    ('I69052', 'Hemiplga fol ntrm subarach hemor aff left dominant side'),
    ('I69053', 'Hemiplga following ntrm subarach hemor aff right nondom side'),
    ('I69054', 'Hemiplga following ntrm subarach hemor aff left nondom side'),
    ('I69059', 'Hemiplga following ntrm subarach hemor affecting unsp side'),
    ('I69061', 'Oth parlyt synd fol ntrm subarach hemor aff right dom side'),
    ('I69062', 'Oth parlyt synd fol ntrm subarach hemor aff left dom side'),
    ('I69063', 'Oth parlyt synd fol ntrm subarach hemor aff r nondom side'),
    ('I69064', 'Oth parlyt synd fol ntrm subarach hemor aff left nondom side'),
    ('I69065', 'Oth paralytic syndrome following ntrm subarach hemor, bi'),
    ('I69069', 'Oth paralytic syndrome fol ntrm subarach hemor aff unsp side'),
    ('I69090', 'Apraxia following nontraumatic subarachnoid hemorrhage'),
    ('I69091', 'Dysphagia following nontraumatic subarachnoid hemorrhage'),
    ('I69092', 'Facial weakness following ntrm subarachnoid hemorrhage'),
    ('I69093', 'Ataxia following nontraumatic subarachnoid hemorrhage'),
    ('I69098', 'Oth sequelae following nontraumatic subarachnoid hemorrhage'),
    ('I6910', 'Unsp sequelae of nontraumatic intracerebral hemorrhage'),
    ('I6911', 'Cognitive deficits following nontraumatic intcrbl hemorrhage'),
    ('I69110', 'Attn and concentration deficit following ntrm intcrbl hemor'),
    ('I69111', 'Memory deficit following nontraumatic intcrbl hemorrhage'),
    ('I69112', 'Vis def/sptl nglct following nontraumatic intcrbl hemorrhage'),
    ('I69113', 'Psychomotor deficit following ntrm intcrbl hemorrhage'),
    ('I69114', 'Fntl lb and exec fcn def following ntrm intcrbl hemorrhage'),
    ('I69115', 'Cognitive social or emo def following ntrm intcrbl hemor'),
    ('I69118', 'Other symp and signs w cogn fnctns fol ntrm intcrbl hemor'),
    ('I69119', 'Unsp symptoms and signs w cogn fnctns fol ntrm intcrbl hemor'),
    ('I69120', 'Aphasia following nontraumatic intracerebral hemorrhage'),
    ('I69121', 'Dysphasia following nontraumatic intracerebral hemorrhage'),
    ('I69122', 'Dysarthria following nontraumatic intracerebral hemorrhage'),
    ('I69123', 'Fluency disorder following nontraumatic intcrbl hemorrhage'),
    ('I69128', 'Oth speech/lang deficits following ntrm intcrbl hemorrhage'),
    ('I69131', 'Monoplg upr lmb fol ntrm intcrbl hemor aff right dom side'),
    ('I69132', 'Monoplg upr lmb fol ntrm intcrbl hemor aff left dom side'),
    ('I69133', 'Monoplg upr lmb fol ntrm intcrbl hemor aff right nondom side'),
    ('I69134', 'Monoplg upr lmb fol ntrm intcrbl hemor aff left nondom side'),
    ('I69139', 'Monoplg upr lmb following ntrm intcrbl hemor aff unsp side'),
    ('I69141', 'Monoplg low lmb fol ntrm intcrbl hemor aff right dom side'),
    ('I69142', 'Monoplg low lmb fol ntrm intcrbl hemor aff left dom side'),
    ('I69143', 'Monoplg low lmb fol ntrm intcrbl hemor aff right nondom side'),
    ('I69144', 'Monoplg low lmb fol ntrm intcrbl hemor aff left nondom side'),
    ('I69149', 'Monoplg low lmb following ntrm intcrbl hemor aff unsp side'),
    ('I69151', 'Hemiplga fol ntrm intcrbl hemor aff right dominant side'),
    ('I69152', 'Hemiplga following ntrm intcrbl hemor aff left dominant side'),
    ('I69153', 'Hemiplga following ntrm intcrbl hemor aff right nondom side'),
    ('I69154', 'Hemiplga following ntrm intcrbl hemor aff left nondom side'),
    ('I69159', 'Hemiplga following ntrm intcrbl hemor affecting unsp side'),
    ('I69161', 'Oth parlyt synd fol ntrm intcrbl hemor aff right dom side'),
    ('I69162', 'Oth parlyt syndrome fol ntrm intcrbl hemor aff left dom side'),
    ('I69163', 'Oth parlyt synd fol ntrm intcrbl hemor aff right nondom side'),
    ('I69164', 'Oth parlyt synd fol ntrm intcrbl hemor aff left nondom side'),
    ('I69165', 'Oth paralytic syndrome following ntrm intcrbl hemor, bi'),
    ('I69169', 'Oth paralytic syndrome fol ntrm intcrbl hemor aff unsp side'),
    ('I69190', 'Apraxia following nontraumatic intracerebral hemorrhage'),
    ('I69191', 'Dysphagia following nontraumatic intracerebral hemorrhage'),
    ('I69192', 'Facial weakness following nontraumatic intcrbl hemorrhage'),
    ('I69193', 'Ataxia following nontraumatic intracerebral hemorrhage'),
    ('I69198', 'Other sequelae of nontraumatic intracerebral hemorrhage'),
    ('I6920', 'Unsp sequelae of other nontraumatic intracranial hemorrhage'),
    ('I6921', 'Cognitive deficits following oth ntrm intcrn hemorrhage'),
    ('I69210', 'Attn and concentration deficit fol other ntrm intcrn hemor'),
    ('I69211', 'Memory deficit following other ntrm intcrn hemorrhage'),
    ('I69212', 'Vis def/sptl nglct following other ntrm intcrn hemorrhage'),
    ('I69213', 'Psychomotor deficit following other ntrm intcrn hemorrhage'),
    ('I69214', 'Fntl lb and exec fcn def following other ntrm intcrn hemor'),
    ('I69215', 'Cognitive social or emo def fol other ntrm intcrn hemor'),
    ('I69218', 'Oth symp and signs w cogn fnctns fol other ntrm intcrn hemor'),
    ('I69219', 'Unsp symp and signs w cogn fnctns fol oth ntrm intcrn hemor'),
    ('I69220', 'Aphasia following other nontraumatic intracranial hemorrhage'),
    ('I69221', 'Dysphasia following oth nontraumatic intracranial hemorrhage'),
    ('I69222', 'Dysarthria following oth nontraumatic intcrn hemorrhage'),
    ('I69223', 'Fluency disorder following oth ntrm intcrn hemorrhage'),
    ('I69228', 'Oth speech/lang deficits following oth ntrm intcrn hemor'),
    ('I69231', 'Monoplg upr lmb fol oth ntrm intcrn hemor aff right dom side'),
    ('I69232', 'Monoplg upr lmb fol oth ntrm intcrn hemor aff left dom side'),
    ('I69233', 'Monoplg upr lmb fol oth ntrm intcrn hemor aff r nondom side'),
    ('I69234', 'Monoplg upr lmb fol oth ntrm intcrn hemor aff l nondom side'),
    ('I69239', 'Monoplg upr lmb fol oth ntrm intcrn hemor aff unsp side'),
    ('I69241', 'Monoplg low lmb fol oth ntrm intcrn hemor aff right dom side'),
    ('I69242', 'Monoplg low lmb fol oth ntrm intcrn hemor aff left dom side'),
    ('I69243', 'Monoplg low lmb fol oth ntrm intcrn hemor aff r nondom side'),
    ('I69244', 'Monoplg low lmb fol oth ntrm intcrn hemor aff l nondom side'),
    ('I69249', 'Monoplg low lmb fol oth ntrm intcrn hemor aff unsp side'),
    ('I69251', 'Hemiplga fol oth ntrm intcrn hemor aff right dominant side'),
    ('I69252', 'Hemiplga fol oth ntrm intcrn hemor aff left dominant side'),
    ('I69253', 'Hemiplga fol oth ntrm intcrn hemor aff right nondom side'),
    ('I69254', 'Hemiplga fol oth ntrm intcrn hemor aff left nondom side'),
    ('I69259', 'Hemiplga following oth ntrm intcrn hemor affecting unsp side'),
    ('I69261', 'Oth parlyt synd fol oth ntrm intcrn hemor aff right dom side'),
    ('I69262', 'Oth parlyt synd fol oth ntrm intcrn hemor aff left dom side'),
    ('I69263', 'Oth parlyt synd fol oth ntrm intcrn hemor aff r nondom side'),
    ('I69264', 'Oth parlyt synd fol oth ntrm intcrn hemor aff l nondom side'),
    ('I69265', 'Oth paralytic syndrome following oth ntrm intcrn hemor, bi'),
    ('I69269', 'Oth parlyt syndrome fol oth ntrm intcrn hemor aff unsp side'),
    ('I69290', 'Apraxia following other nontraumatic intracranial hemorrhage'),
    ('I69291', 'Dysphagia following oth nontraumatic intracranial hemorrhage'),
    ('I69292', 'Facial weakness following oth nontraumatic intcrn hemorrhage'),
    ('I69293', 'Ataxia following other nontraumatic intracranial hemorrhage'),
    ('I69298', 'Other sequelae of other nontraumatic intracranial hemorrhage'),
    ('I6930', 'Unspecified sequelae of cerebral infarction'),
    ('I6931', 'Cognitive deficits following cerebral infarction'),
    ('I69310', 'Attention and concentration deficit following cerebral infrc'),
    ('I69311', 'Memory deficit following cerebral infarction'),
    ('I69312', 'Vis def/sptl nglct following cerebral infarction'),
    ('I69313', 'Psychomotor deficit following cerebral infarction'),
    ('I69314', 'Frontal lobe and exec fcn def following cerebral infarction'),
    ('I69315', 'Cognitive social or emo def following cerebral infarction'),
    ('I69318', 'Other symptoms and signs w cogn fnctns fol cerebral infrc'),
    ('I69319', 'Unsp symptoms and signs w cogn fnctns fol cerebral infrc'),
    ('I69320', 'Aphasia following cerebral infarction'),
    ('I69321', 'Dysphasia following cerebral infarction'),
    ('I69322', 'Dysarthria following cerebral infarction'),
    ('I69323', 'Fluency disorder following cerebral infarction'),
    ('I69328', 'Oth speech/lang deficits following cerebral infarction'),
    ('I69331', 'Monoplg upr lmb fol cerebral infrc aff right dominant side'),
    ('I69332', 'Monoplg upr lmb fol cerebral infrc aff left dominant side'),
    ('I69333', 'Monoplg upr lmb fol cerebral infrc aff right nondom side'),
    ('I69334', 'Monoplg upr lmb fol cerebral infrc aff left nondom side'),
    ('I69339', 'Monoplg upr lmb following cerebral infrc affecting unsp side'),
    ('I69341', 'Monoplg low lmb fol cerebral infrc aff right dominant side'),
    ('I69342', 'Monoplg low lmb fol cerebral infrc aff left dominant side'),
    ('I69343', 'Monoplg low lmb fol cerebral infrc aff right nondom side'),
    ('I69344', 'Monoplg low lmb fol cerebral infrc aff left nondom side'),
    ('I69349', 'Monoplg low lmb following cerebral infrc affecting unsp side'),
    ('I69351', 'Hemiplga following cerebral infrc aff right dominant side'),
    ('I69352', 'Hemiplga following cerebral infrc aff left dominant side'),
    ('I69353', 'Hemiplga following cerebral infrc aff right nondom side'),
    ('I69354', 'Hemiplga following cerebral infrc affecting left nondom side'),
    ('I69359', 'Hemiplga following cerebral infarction affecting unsp side'),
    ('I69361', 'Oth parlyt syndrome fol cereb infrc aff right dominant side'),
    ('I69362', 'Oth parlyt syndrome fol cereb infrc aff left dominant side'),
    ('I69363', 'Oth parlyt syndrome fol cerebral infrc aff right nondom side'),
    ('I69364', 'Oth parlyt syndrome fol cerebral infrc aff left nondom side'),
    ('I69365', 'Oth paralytic syndrome following cerebral infrc, bilateral'),
    ('I69369', 'Oth paralytic syndrome fol cerebral infrc aff unsp side'),
    ('I69390', 'Apraxia following cerebral infarction'),
    ('I69391', 'Dysphagia following cerebral infarction'),
    ('I69392', 'Facial weakness following cerebral infarction'),
    ('I69393', 'Ataxia following cerebral infarction'),
    ('I69398', 'Other sequelae of cerebral infarction'),
    ('I6980', 'Unspecified sequelae of other cerebrovascular disease'),
    ('I6981', 'Cognitive deficits following other cerebrovascular disease'),
    ('I69810', 'Attn and concentration deficit fol other cerebvasc disease'),
    ('I69811', 'Memory deficit following other cerebrovascular disease'),
    ('I69812', 'Vis def/sptl nglct following other cerebrovascular disease'),
    ('I69813', 'Psychomotor deficit following other cerebrovascular disease'),
    ('I69814', 'Fntl lb and exec fcn def following other cerebvasc disease'),
    ('I69815', 'Cognitive social or emo def fol other cerebvasc disease'),
    ('I69818', 'Other symp and signs w cogn fnctns fol other cerebvasc dis'),
    ('I69819', 'Unsp symp and signs w cogn fnctns fol other cerebvasc dis'),
    ('I69820', 'Aphasia following other cerebrovascular disease'),
    ('I69821', 'Dysphasia following other cerebrovascular disease'),
    ('I69822', 'Dysarthria following other cerebrovascular disease'),
    ('I69823', 'Fluency disorder following other cerebrovascular disease'),
    ('I69828', 'Oth speech/lang deficits following oth cerebvasc disease'),
    ('I69831', 'Monoplg upr lmb fol oth cerebvasc disease aff right dom side'),
    ('I69832', 'Monoplg upr lmb fol oth cerebvasc disease aff left dom side'),
    ('I69833', 'Monoplg upr lmb fol oth cerebvasc dis aff right nondom side'),
    ('I69834', 'Monoplg upr lmb fol oth cerebvasc dis aff left nondom side'),
    ('I69839', 'Monoplg upr lmb fol oth cerebvasc disease aff unsp side'),
    ('I69841', 'Monoplg low lmb fol oth cerebvasc disease aff right dom side'),
    ('I69842', 'Monoplg low lmb fol oth cerebvasc disease aff left dom side'),
    ('I69843', 'Monoplg low lmb fol oth cerebvasc dis aff right nondom side'),
    ('I69844', 'Monoplg low lmb fol oth cerebvasc dis aff left nondom side'),
    ('I69849', 'Monoplg low lmb fol oth cerebvasc disease aff unsp side'),
    ('I69851', 'Hemiplga fol oth cerebvasc disease aff right dominant side'),
    ('I69852', 'Hemiplga fol oth cerebvasc disease aff left dominant side'),
    ('I69853', 'Hemiplga fol oth cerebvasc disease aff right nondom side'),
    ('I69854', 'Hemiplga fol oth cerebvasc disease aff left nondom side'),
    ('I69859', 'Hemiplga following oth cerebvasc disease affecting unsp side'),
    ('I69861', 'Oth parlyt synd fol oth cerebvasc disease aff right dom side'),
    ('I69862', 'Oth parlyt synd fol oth cerebvasc disease aff left dom side'),
    ('I69863', 'Oth parlyt synd fol oth cerebvasc dis aff right nondom side'),
    ('I69864', 'Oth parlyt synd fol oth cerebvasc dis aff left nondom side'),
    ('I69865', 'Oth paralytic syndrome following oth cerebvasc disease, bi'),
    ('I69869', 'Oth parlyt syndrome fol oth cerebvasc disease aff unsp side'),
    ('I69890', 'Apraxia following other cerebrovascular disease'),
    ('I69891', 'Dysphagia following other cerebrovascular disease'),
    ('I69892', 'Facial weakness following other cerebrovascular disease'),
    ('I69893', 'Ataxia following other cerebrovascular disease'),
    ('I69898', 'Other sequelae of other cerebrovascular disease'),
    ('I6990', 'Unspecified sequelae of unspecified cerebrovascular disease'),
    ('I6991', 'Cognitive deficits following unsp cerebrovascular disease'),
    ('I69910', 'Attn and concentration deficit fol unsp cerebvasc disease'),
    ('I69911', 'Memory deficit following unspecified cerebrovascular disease'),
    ('I69912', 'Vis def/sptl nglct following unspecified cerebvasc disease'),
    ('I69913', 'Psychomotor deficit following unspecified cerebvasc disease'),
    ('I69914', 'Fntl lb and exec fcn def following unsp cerebvasc disease'),
    ('I69915', 'Cognitive social or emo def following unsp cerebvasc disease'),
    ('I69918', 'Other symp and signs w cogn fnctns fol unsp cerebvasc dis'),
    ('I69919', 'Unsp symp and signs w cogn fnctns fol unsp cerebvasc disease'),
    ('I69920', 'Aphasia following unspecified cerebrovascular disease'),
    ('I69921', 'Dysphasia following unspecified cerebrovascular disease'),
    ('I69922', 'Dysarthria following unspecified cerebrovascular disease'),
    ('I69923', 'Fluency disorder following unsp cerebrovascular disease'),
    ('I69928', 'Oth speech/lang deficits following unsp cerebvasc disease'),
    ('I69931', 'Monoplg upr lmb fol unsp cerebvasc dis aff right dom side'),
    ('I69932', 'Monoplg upr lmb fol unsp cerebvasc disease aff left dom side'),
    ('I69933', 'Monoplg upr lmb fol unsp cerebvasc dis aff right nondom side'),
    ('I69934', 'Monoplg upr lmb fol unsp cerebvasc dis aff left nondom side'),
    ('I69939', 'Monoplg upr lmb fol unsp cerebvasc disease aff unsp side'),
    ('I69941', 'Monoplg low lmb fol unsp cerebvasc dis aff right dom side'),
    ('I69942', 'Monoplg low lmb fol unsp cerebvasc disease aff left dom side'),
    ('I69943', 'Monoplg low lmb fol unsp cerebvasc dis aff right nondom side'),
    ('I69944', 'Monoplg low lmb fol unsp cerebvasc dis aff left nondom side'),
    ('I69949', 'Monoplg low lmb fol unsp cerebvasc disease aff unsp side'),
    ('I69951', 'Hemiplga fol unsp cerebvasc disease aff right dominant side'),
    ('I69952', 'Hemiplga fol unsp cerebvasc disease aff left dominant side'),
    ('I69953', 'Hemiplga fol unsp cerebvasc disease aff right nondom side'),
    ('I69954', 'Hemiplga fol unsp cerebvasc disease aff left nondom side'),
    ('I69959', 'Hemiplga following unsp cerebvasc disease aff unsp side'),
    ('I69961', 'Oth parlyt synd fol unsp cerebvasc dis aff right dom side'),
    ('I69962', 'Oth parlyt synd fol unsp cerebvasc disease aff left dom side'),
    ('I69963', 'Oth parlyt synd fol unsp cerebvasc dis aff right nondom side'),
    ('I69964', 'Oth parlyt synd fol unsp cerebvasc dis aff left nondom side'),
    ('I69965', 'Oth paralytic syndrome following unsp cerebvasc disease, bi'),
    ('I69969', 'Oth parlyt syndrome fol unsp cerebvasc disease aff unsp side'),
    ('I69990', 'Apraxia following unspecified cerebrovascular disease'),
    ('I69991', 'Dysphagia following unspecified cerebrovascular disease'),
    ('I69992', 'Facial weakness following unsp cerebrovascular disease'),
    ('I69993', 'Ataxia following unspecified cerebrovascular disease'),
    ('I69998', 'Other sequelae following unspecified cerebrovascular disease'),
    ('I700', 'Atherosclerosis of aorta'),
    ('I701', 'Atherosclerosis of renal artery'),
    ('I70201', 'Unsp athscl native arteries of extremities, right leg'),
    ('I70202', 'Unsp athscl native arteries of extremities, left leg'),
    ('I70203', 'Unsp athscl native arteries of extremities, bilateral legs'),
    ('I70208', 'Unsp athscl native arteries of extremities, oth extremity'),
    ('I70209', 'Unsp athscl native arteries of extremities, unsp extremity'),
    ('I70211', 'Athscl native arteries of extrm w intrmt claud, right leg'),
    ('I70212', 'Athscl native arteries of extrm w intrmt claud, left leg'),
    ('I70213', 'Athscl native arteries of extrm w intrmt claud, bi legs'),
    ('I70218', 'Athscl native arteries of extrm w intrmt claud, oth extrm'),
    ('I70219', 'Athscl native arteries of extrm w intrmt claud, unsp extrm'),
    ('I70221', 'Athscl native arteries of extremities w rest pain, right leg'),
    ('I70222', 'Athscl native arteries of extremities w rest pain, left leg'),
    ('I70223', 'Athscl native arteries of extrm w rest pain, bilateral legs'),
    ('I70228', 'Athscl native arteries of extrm w rest pain, oth extremity'),
    ('I70229', 'Athscl native arteries of extrm w rest pain, unsp extremity'),
    ('I70231', 'Athscl native arteries of right leg w ulceration of thigh'),
    ('I70232', 'Athscl native arteries of right leg w ulceration of calf'),
    ('I70233', 'Athscl native arteries of right leg w ulceration of ankle'),
    ('I70234', 'Athscl native art of right leg w ulcer of heel and midfoot'),
    ('I70235', 'Athscl native arteries of right leg w ulcer oth prt foot'),
    ('I70238', 'Athscl native art of right leg with ulcer oth prt low leg'),
    ('I70239', 'Athscl native arteries of right leg w ulcer of unsp site'),
    ('I70241', 'Athscl native arteries of left leg w ulceration of thigh'),
    ('I70242', 'Athscl native arteries of left leg w ulceration of calf'),
    ('I70243', 'Athscl native arteries of left leg w ulceration of ankle'),
    ('I70244', 'Athscl native art of left leg w ulcer of heel and midfoot'),
    ('I70245', 'Athscl native arteries of left leg w ulceration oth prt foot'),
    ('I70248', 'Athscl native art of left leg with ulcer oth prt low leg'),
    ('I70249', 'Athscl native arteries of left leg w ulceration of unsp site'),
    ('I7025', 'Athscl native arteries of extremities w ulceration'),
    ('I70261', 'Athscl native arteries of extremities w gangrene, right leg'),
    ('I70262', 'Athscl native arteries of extremities w gangrene, left leg'),
    ('I70263', 'Athscl native arteries of extrm w gangrene, bilateral legs'),
    ('I70268', 'Athscl native arteries of extrm w gangrene, oth extremity'),
    ('I70269', 'Athscl native arteries of extrm w gangrene, unsp extremity'),
    ('I70291', 'Oth athscl native arteries of extremities, right leg'),
    ('I70292', 'Oth athscl native arteries of extremities, left leg'),
    ('I70293', 'Oth athscl native arteries of extremities, bilateral legs'),
    ('I70298', 'Oth athscl native arteries of extremities, oth extremity'),
    ('I70299', 'Oth athscl native arteries of extremities, unsp extremity'),
    ('I70301', 'Unsp athscl unsp type bypass of the extremities, right leg'),
    ('I70302', 'Unsp athscl unsp type bypass of the extremities, left leg'),
    ('I70303', 'Unsp athscl unsp type bypass of the extrm, bilateral legs'),
    ('I70308', 'Unsp athscl unsp type bypass of the extrm, oth extremity'),
    ('I70309', 'Unsp athscl unsp type bypass of the extrm, unsp extremity'),
    ('I70311', 'Athscl unsp type bypass of extrm w intrmt claud, right leg'),
    ('I70312', 'Athscl unsp type bypass of extrm w intrmt claud, left leg'),
    ('I70313', 'Athscl unsp type bypass of the extrm w intrmt claud, bi legs'),
    ('I70318', 'Athscl unsp type bypass of extrm w intrmt claud, oth extrm'),
    ('I70319', 'Athscl unsp type bypass of extrm w intrmt claud, unsp extrm'),
    ('I70321', 'Athscl unsp type bypass of the extrm w rest pain, right leg'),
    ('I70322', 'Athscl unsp type bypass of the extrm w rest pain, left leg'),
    ('I70323', 'Athscl unsp type bypass of the extrm w rest pain, bi legs'),
    ('I70328', 'Athscl unsp type bypass of the extrm w rest pain, oth extrm'),
    ('I70329', 'Athscl unsp type bypass of the extrm w rest pain, unsp extrm'),
    ('I70331', 'Athscl unsp type bypass of the right leg w ulcer of thigh'),
    ('I70332', 'Athscl unsp type bypass of the right leg w ulcer of calf'),
    ('I70333', 'Athscl unsp type bypass of the right leg w ulcer of ankle'),
    ('I70334', 'Athscl unsp type bypass of r leg w ulcer of heel and midft'),
    ('I70335', 'Athscl unsp type bypass of right leg w ulcer oth prt foot'),
    ('I70338', 'Athscl unsp type bypass of right leg w ulcer oth prt low leg'),
    ('I70339', 'Athscl unsp type bypass of right leg w ulcer of unsp site'),
    ('I70341', 'Athscl unsp type bypass of the left leg w ulcer of thigh'),
    ('I70342', 'Athscl unsp type bypass of the left leg w ulceration of calf'),
    ('I70343', 'Athscl unsp type bypass of the left leg w ulcer of ankle'),
    ('I70344', 'Athscl unsp type bypass of left leg w ulc of heel and midft'),
    ('I70345', 'Athscl unsp type bypass of the left leg w ulcer oth prt foot'),
    ('I70348', 'Athscl unsp type bypass of left leg w ulcer oth prt low leg'),
    ('I70349', 'Athscl unsp type bypass of the left leg w ulcer of unsp site'),
    ('I7035', 'Athscl unsp type bypass graft(s) of extremity w ulceration'),
    ('I70361', 'Athscl unsp type bypass of the extrm w gangrene, right leg'),
    ('I70362', 'Athscl unsp type bypass of the extrm w gangrene, left leg'),
    ('I70363', 'Athscl unsp type bypass of the extrm w gangrene, bi legs'),
    ('I70368', 'Athscl unsp type bypass of the extrm w gangrene, oth extrm'),
    ('I70369', 'Athscl unsp type bypass of the extrm w gangrene, unsp extrm'),
    ('I70391', 'Oth athscl unsp type bypass of the extremities, right leg'),
    ('I70392', 'Oth athscl unsp type bypass of the extremities, left leg'),
    ('I70393', 'Oth athscl unsp type bypass of the extrm, bilateral legs'),
    ('I70398', 'Oth athscl unsp type bypass of the extrm, oth extremity'),
    ('I70399', 'Oth athscl unsp type bypass of the extrm, unsp extremity'),
    ('I70401', 'Unsp athscl autologous vein bypass of the extrm, right leg'),
    ('I70402', 'Unsp athscl autologous vein bypass of the extrm, left leg'),
    ('I70403', 'Unsp athscl autol vein bypass of the extrm, bilateral legs'),
    ('I70408', 'Unsp athscl autol vein bypass of the extrm, oth extremity'),
    ('I70409', 'Unsp athscl autol vein bypass of the extrm, unsp extremity'),
    ('I70411', 'Athscl autol vein bypass of extrm w intrmt claud, right leg'),
    ('I70412', 'Athscl autol vein bypass of extrm w intrmt claud, left leg'),
    ('I70413', 'Athscl autol vein bypass of extrm w intrmt claud, bi legs'),
    ('I70418', 'Athscl autol vein bypass of extrm w intrmt claud, oth extrm'),
    ('I70419', 'Athscl autol vein bypass of extrm w intrmt claud, unsp extrm'),
    ('I70421', 'Athscl autol vein bypass of the extrm w rest pain, right leg'),
    ('I70422', 'Athscl autol vein bypass of the extrm w rest pain, left leg'),
    ('I70423', 'Athscl autol vein bypass of the extrm w rest pain, bi legs'),
    ('I70428', 'Athscl autol vein bypass of the extrm w rest pain, oth extrm'),
    ('I70429', 'Athscl autol vein bypass of extrm w rest pain, unsp extrm'),
    ('I70431', 'Athscl autol vein bypass of the right leg w ulcer of thigh'),
    ('I70432', 'Athscl autol vein bypass of the right leg w ulcer of calf'),
    ('I70433', 'Athscl autol vein bypass of the right leg w ulcer of ankle'),
    ('I70434', 'Athscl autol vein bypass of r leg w ulcer of heel and midft'),
    ('I70435', 'Athscl autol vein bypass of right leg w ulcer oth prt foot'),
    ('I70438', 'Athscl autol vein bypass of r leg w ulcer oth prt low leg'),
    ('I70439', 'Athscl autol vein bypass of right leg w ulcer of unsp site'),
    ('I70441', 'Athscl autol vein bypass of the left leg w ulcer of thigh'),
    ('I70442', 'Athscl autol vein bypass of the left leg w ulcer of calf'),
    ('I70443', 'Athscl autol vein bypass of the left leg w ulcer of ankle'),
    ('I70444', 'Athscl autol vein bypass of left leg w ulc of heel and midft'),
    ('I70445', 'Athscl autol vein bypass of left leg w ulcer oth prt foot'),
    ('I70448', 'Athscl autol vein bypass of left leg w ulcer oth prt low leg'),
    ('I70449', 'Athscl autol vein bypass of left leg w ulcer of unsp site'),
    ('I7045', 'Athscl autologous vein bypass of extremity w ulceration'),
    ('I70461', 'Athscl autol vein bypass of the extrm w gangrene, right leg'),
    ('I70462', 'Athscl autol vein bypass of the extrm w gangrene, left leg'),
    ('I70463', 'Athscl autol vein bypass of the extrm w gangrene, bi legs'),
    ('I70468', 'Athscl autol vein bypass of the extrm w gangrene, oth extrm'),
    ('I70469', 'Athscl autol vein bypass of the extrm w gangrene, unsp extrm'),
    ('I70491', 'Oth athscl autologous vein bypass of the extrm, right leg'),
    ('I70492', 'Oth athscl autologous vein bypass of the extrm, left leg'),
    ('I70493', 'Oth athscl autol vein bypass of the extrm, bilateral legs'),
    ('I70498', 'Oth athscl autol vein bypass of the extrm, oth extremity'),
    ('I70499', 'Oth athscl autol vein bypass of the extrm, unsp extremity'),
    ('I70501', 'Unsp athscl nonaut bio bypass of the extremities, right leg'),
    ('I70502', 'Unsp athscl nonaut bio bypass of the extremities, left leg'),
    ('I70503', 'Unsp athscl nonaut bio bypass of the extrm, bilateral legs'),
    ('I70508', 'Unsp athscl nonaut bio bypass of the extrm, oth extremity'),
    ('I70509', 'Unsp athscl nonaut bio bypass of the extrm, unsp extremity'),
    ('I70511', 'Athscl nonaut bio bypass of extrm w intrmt claud, right leg'),
    ('I70512', 'Athscl nonaut bio bypass of extrm w intrmt claud, left leg'),
    ('I70513', 'Athscl nonaut bio bypass of extrm w intrmt claud, bi legs'),
    ('I70518', 'Athscl nonaut bio bypass of extrm w intrmt claud, oth extrm'),
    ('I70519', 'Athscl nonaut bio bypass of extrm w intrmt claud, unsp extrm'),
    ('I70521', 'Athscl nonaut bio bypass of the extrm w rest pain, right leg'),
    ('I70522', 'Athscl nonaut bio bypass of the extrm w rest pain, left leg'),
    ('I70523', 'Athscl nonaut bio bypass of the extrm w rest pain, bi legs'),
    ('I70528', 'Athscl nonaut bio bypass of the extrm w rest pain, oth extrm'),
    ('I70529', 'Athscl nonaut bio bypass of extrm w rest pain, unsp extrm'),
    ('I70531', 'Athscl nonaut bio bypass of the right leg w ulcer of thigh'),
    ('I70532', 'Athscl nonaut bio bypass of the right leg w ulcer of calf'),
    ('I70533', 'Athscl nonaut bio bypass of the right leg w ulcer of ankle'),
    ('I70534', 'Athscl nonaut bio bypass of r leg w ulcer of heel and midft'),
    ('I70535', 'Athscl nonaut bio bypass of right leg w ulcer oth prt foot'),
    ('I70538', 'Athscl nonaut bio bypass of r leg w ulcer oth prt low leg'),
    ('I70539', 'Athscl nonaut bio bypass of right leg w ulcer of unsp site'),
    ('I70541', 'Athscl nonaut bio bypass of the left leg w ulcer of thigh'),
    ('I70542', 'Athscl nonaut bio bypass of the left leg w ulcer of calf'),
    ('I70543', 'Athscl nonaut bio bypass of the left leg w ulcer of ankle'),
    ('I70544', 'Athscl nonaut bio bypass of left leg w ulc of heel and midft'),
    ('I70545', 'Athscl nonaut bio bypass of left leg w ulcer oth prt foot'),
    ('I70548', 'Athscl nonaut bio bypass of left leg w ulcer oth prt low leg'),
    ('I70549', 'Athscl nonaut bio bypass of left leg w ulcer of unsp site'),
    ('I7055', 'Athscl nonautologous bio bypass of extremity w ulceration'),
    ('I70561', 'Athscl nonaut bio bypass of the extrm w gangrene, right leg'),
    ('I70562', 'Athscl nonaut bio bypass of the extrm w gangrene, left leg'),
    ('I70563', 'Athscl nonaut bio bypass of the extrm w gangrene, bi legs'),
    ('I70568', 'Athscl nonaut bio bypass of the extrm w gangrene, oth extrm'),
    ('I70569', 'Athscl nonaut bio bypass of the extrm w gangrene, unsp extrm'),
    ('I70591', 'Oth athscl nonaut bio bypass of the extremities, right leg'),
    ('I70592', 'Oth athscl nonaut bio bypass of the extremities, left leg'),
    ('I70593', 'Oth athscl nonaut bio bypass of the extrm, bilateral legs'),
    ('I70598', 'Oth athscl nonaut bio bypass of the extrm, oth extremity'),
    ('I70599', 'Oth athscl nonaut bio bypass of the extrm, unsp extremity'),
    ('I70601', 'Unsp athscl nonbiol bypass of the extremities, right leg'),
    ('I70602', 'Unsp athscl nonbiol bypass of the extremities, left leg'),
    ('I70603', 'Unsp athscl nonbiol bypass of the extrm, bilateral legs'),
    ('I70608', 'Unsp athscl nonbiol bypass of the extremities, oth extremity'),
    ('I70609', 'Unsp athscl nonbiol bypass of the extrm, unsp extremity'),
    ('I70611', 'Athscl nonbiol bypass of the extrm w intrmt claud, right leg'),
    ('I70612', 'Athscl nonbiol bypass of the extrm w intrmt claud, left leg'),
    ('I70613', 'Athscl nonbiol bypass of the extrm w intrmt claud, bi legs'),
    ('I70618', 'Athscl nonbiol bypass of the extrm w intrmt claud, oth extrm'),
    ('I70619', 'Athscl nonbiol bypass of extrm w intrmt claud, unsp extrm'),
    ('I70621', 'Athscl nonbiol bypass of the extrm w rest pain, right leg'),
    ('I70622', 'Athscl nonbiol bypass of the extrm w rest pain, left leg'),
    ('I70623', 'Athscl nonbiol bypass of the extrm w rest pain, bi legs'),
    ('I70628', 'Athscl nonbiol bypass of the extrm w rest pain, oth extrm'),
    ('I70629', 'Athscl nonbiol bypass of the extrm w rest pain, unsp extrm'),
    ('I70631', 'Athscl nonbiol bypass of the right leg w ulceration of thigh'),
    ('I70632', 'Athscl nonbiol bypass of the right leg w ulceration of calf'),
    ('I70633', 'Athscl nonbiol bypass of the right leg w ulceration of ankle'),
    ('I70634', 'Athscl nonbiol bypass of right leg w ulcer of heel and midft'),
    ('I70635', 'Athscl nonbiol bypass of the right leg w ulcer oth prt foot'),
    ('I70638', 'Athscl nonbiol bypass of right leg w ulcer oth prt low leg'),
    ('I70639', 'Athscl nonbiol bypass of the right leg w ulcer of unsp site'),
    ('I70641', 'Athscl nonbiol bypass of the left leg w ulceration of thigh'),
    ('I70642', 'Athscl nonbiol bypass of the left leg w ulceration of calf'),
    ('I70643', 'Athscl nonbiol bypass of the left leg w ulceration of ankle'),
    ('I70644', 'Athscl nonbiol bypass of left leg w ulcer of heel and midft'),
    ('I70645', 'Athscl nonbiol bypass of the left leg w ulcer oth prt foot'),
    ('I70648', 'Athscl nonbiol bypass of left leg w ulcer oth prt low leg'),
    ('I70649', 'Athscl nonbiol bypass of the left leg w ulcer of unsp site'),
    ('I7065', 'Athscl nonbiological bypass of extremity w ulceration'),
    ('I70661', 'Athscl nonbiol bypass of the extrm w gangrene, right leg'),
    ('I70662', 'Athscl nonbiol bypass of the extrm w gangrene, left leg'),
    ('I70663', 'Athscl nonbiol bypass of the extrm w gangrene, bi legs'),
    ('I70668', 'Athscl nonbiol bypass of the extrm w gangrene, oth extremity'),
    ('I70669', 'Athscl nonbiol bypass of the extrm w gangrene, unsp extrm'),
    ('I70691', 'Oth athscl nonbiol bypass of the extremities, right leg'),
    ('I70692', 'Oth athscl nonbiological bypass of the extremities, left leg'),
    ('I70693', 'Oth athscl nonbiol bypass of the extremities, bilateral legs'),
    ('I70698', 'Oth athscl nonbiol bypass of the extremities, oth extremity'),
    ('I70699', 'Oth athscl nonbiol bypass of the extremities, unsp extremity'),
    ('I70701', 'Unsp athscl type of bypass of the extremities, right leg'),
    ('I70702', 'Unsp athscl type of bypass of the extremities, left leg'),
    ('I70703', 'Unsp athscl type of bypass of the extrm, bilateral legs'),
    ('I70708', 'Unsp athscl type of bypass of the extremities, oth extremity'),
    ('I70709', 'Unsp athscl type of bypass of the extrm, unsp extremity'),
    ('I70711', 'Athscl type of bypass of the extrm w intrmt claud, right leg'),
    ('I70712', 'Athscl type of bypass of the extrm w intrmt claud, left leg'),
    ('I70713', 'Athscl type of bypass of the extrm w intrmt claud, bi legs'),
    ('I70718', 'Athscl type of bypass of the extrm w intrmt claud, oth extrm'),
    ('I70719', 'Athscl type of bypass of extrm w intrmt claud, unsp extrm'),
    ('I70721', 'Athscl type of bypass of the extrm w rest pain, right leg'),
    ('I70722', 'Athscl type of bypass of the extrm w rest pain, left leg'),
    ('I70723', 'Athscl type of bypass of the extrm w rest pain, bi legs'),
    ('I70728', 'Athscl type of bypass of the extrm w rest pain, oth extrm'),
    ('I70729', 'Athscl type of bypass of the extrm w rest pain, unsp extrm'),
    ('I70731', 'Athscl type of bypass of the right leg w ulceration of thigh'),
    ('I70732', 'Athscl type of bypass of the right leg w ulceration of calf'),
    ('I70733', 'Athscl type of bypass of the right leg w ulceration of ankle'),
    ('I70734', 'Athscl type of bypass of right leg w ulcer of heel and midft'),
    ('I70735', 'Athscl type of bypass of the right leg w ulcer oth prt foot'),
    ('I70738', 'Athscl type of bypass of right leg w ulcer oth prt low leg'),
    ('I70739', 'Athscl type of bypass of the right leg w ulcer of unsp site'),
    ('I70741', 'Athscl type of bypass of the left leg w ulceration of thigh'),
    ('I70742', 'Athscl type of bypass of the left leg w ulceration of calf'),
    ('I70743', 'Athscl type of bypass of the left leg w ulceration of ankle'),
    ('I70744', 'Athscl type of bypass of left leg w ulcer of heel and midft'),
    ('I70745', 'Athscl type of bypass of the left leg w ulcer oth prt foot'),
    ('I70748', 'Athscl type of bypass of left leg w ulcer oth prt low leg'),
    ('I70749', 'Athscl type of bypass of the left leg w ulcer of unsp site'),
    ('I7075', 'Athscl type of bypass graft(s) of extremity w ulceration'),
    ('I70761', 'Athscl type of bypass of the extrm w gangrene, right leg'),
    ('I70762', 'Athscl type of bypass of the extrm w gangrene, left leg'),
    ('I70763', 'Athscl type of bypass of the extrm w gangrene, bi legs'),
    ('I70768', 'Athscl type of bypass of the extrm w gangrene, oth extremity'),
    ('I70769', 'Athscl type of bypass of the extrm w gangrene, unsp extrm'),
    ('I70791', 'Oth athscl type of bypass of the extremities, right leg'),
    ('I70792', 'Oth athscl type of bypass of the extremities, left leg'),
    ('I70793', 'Oth athscl type of bypass of the extremities, bilateral legs'),
    ('I70798', 'Oth athscl type of bypass of the extremities, oth extremity'),
    ('I70799', 'Oth athscl type of bypass of the extremities, unsp extremity'),
    ('I708', 'Atherosclerosis of other arteries'),
    ('I7090', 'Unspecified atherosclerosis'),
    ('I7091', 'Generalized atherosclerosis'),
    ('I7092', 'Chronic total occlusion of artery of the extremities'),
    ('I7100', 'Dissection of unspecified site of aorta'),
    ('I7101', 'Dissection of thoracic aorta'),
    ('I71010', 'Dissection of ascending aorta'),
    ('I71011', 'Dissection of aortic arch'),
    ('I71012', 'Dissection of descending thoracic aorta'),
    ('I71019', 'Dissection of thoracic aorta, unspecified'),
    ('I7102', 'Dissection of abdominal aorta'),
    ('I7103', 'Dissection of thoracoabdominal aorta'),
    ('I711', 'Thoracic aortic aneurysm, ruptured'),
    ('I7110', 'Thoracic aortic aneurysm, ruptured, unspecified'),
    ('I7111', 'Aneurysm of the ascending aorta, ruptured'),
    ('I7112', 'Aneurysm of the aortic arch, ruptured'),
    ('I7113', 'Aneurysm of the descending thoracic aorta, ruptured'),
    ('I712', 'Thoracic aortic aneurysm, without rupture'),
    ('I7120', 'Thoracic aortic aneurysm, without rupture, unspecified'),
    ('I7121', 'Aneurysm of the ascending aorta, without rupture'),
    ('I7122', 'Aneurysm of the aortic arch, without rupture'),
    ('I7123', 'Aneurysm of the descending thoracic aorta, without rupture'),
    ('I713', 'Abdominal aortic aneurysm, ruptured'),
    ('I7130', 'Abdominal aortic aneurysm, ruptured, unspecified'),
    ('I7131', 'Pararenal abdominal aortic aneurysm, ruptured'),
    ('I7132', 'Juxtarenal abdominal aortic aneurysm, ruptured'),
    ('I7133', 'Infrarenal abdominal aortic aneurysm, ruptured'),
    ('I714', 'Abdominal aortic aneurysm, without rupture'),
    ('I7140', 'Abdominal aortic aneurysm, without rupture, unspecified'),
    ('I7141', 'Pararenal abdominal aortic aneurysm, without rupture'),
    ('I7142', 'Juxtarenal abdominal aortic aneurysm, without rupture'),
    ('I7143', 'Infrarenal abdominal aortic aneurysm, without rupture'),
    ('I715', 'Thoracoabdominal aortic aneurysm, ruptured'),
    ('I7150', 'Thoracoabdominal aortic aneurysm, ruptured, unspecified'),
    ('I7151', 'Supraceliac aneurysm of the thoracoabdominal aorta, ruptured'),
    ('I7152', 'Paravisceral aneurysm of the thoracoabdominal aorta, ruptd'),
    ('I716', 'Thoracoabdominal aortic aneurysm, without rupture'),
    ('I7160', 'Thoracoabdominal aortic aneurysm, without rupture, unsp'),
    ('I7161', 'Supraceliac aneurysm of the thoracoabdominal aorta, w/o rupt'),
    ('I7162', 'Paravisceral aneurysm of thoracoabdominal aorta, w/o rupt'),
    ('I718', 'Aortic aneurysm of unspecified site, ruptured'),
    ('I719', 'Aortic aneurysm of unspecified site, without rupture'),
    ('I720', 'Aneurysm of carotid artery'),
    ('I721', 'Aneurysm of artery of upper extremity'),
    ('I722', 'Aneurysm of renal artery'),
    ('I723', 'Aneurysm of iliac artery'),
    ('I724', 'Aneurysm of artery of lower extremity'),
    ('I725', 'Aneurysm of other precerebral arteries'),
    ('I726', 'Aneurysm of vertebral artery'),
    ('I728', 'Aneurysm of other specified arteries'),
    ('I729', 'Aneurysm of unspecified site'),
    ('I7300', "Raynaud's syndrome without gangrene"),
    ('I7301', "Raynaud's syndrome with gangrene"),
    ('I731', "Thromboangiitis obliterans [Buerger's disease]"),
    ('I7381', 'Erythromelalgia'),
    ('I7389', 'Other specified peripheral vascular diseases'),
    ('I739', 'Peripheral vascular disease, unspecified'),
    ('I7401', 'Saddle embolus of abdominal aorta'),
    ('I7409', 'Other arterial embolism and thrombosis of abdominal aorta'),
    ('I7410', 'Embolism and thrombosis of unspecified parts of aorta'),
    ('I7411', 'Embolism and thrombosis of thoracic aorta'),
    ('I7419', 'Embolism and thrombosis of other parts of aorta'),
    ('I742', 'Embolism and thrombosis of arteries of the upper extremities'),
    ('I743', 'Embolism and thrombosis of arteries of the lower extremities'),
    ('I744', 'Embolism and thrombosis of arteries of extremities, unsp'),
    ('I745', 'Embolism and thrombosis of iliac artery'),
    ('I748', 'Embolism and thrombosis of other arteries'),
    ('I749', 'Embolism and thrombosis of unspecified artery'),
    ('I75011', 'Atheroembolism of right upper extremity'),
    ('I75012', 'Atheroembolism of left upper extremity'),
    ('I75013', 'Atheroembolism of bilateral upper extremities'),
    ('I75019', 'Atheroembolism of unspecified upper extremity'),
    ('I75021', 'Atheroembolism of right lower extremity'),
    ('I75022', 'Atheroembolism of left lower extremity'),
    ('I75023', 'Atheroembolism of bilateral lower extremities'),
    ('I75029', 'Atheroembolism of unspecified lower extremity'),
    ('I7581', 'Atheroembolism of kidney'),
    ('I7589', 'Atheroembolism of other site'),
    ('I76', 'Septic arterial embolism'),
    ('I770', 'Arteriovenous fistula, acquired'),
    ('I771', 'Stricture of artery'),
    ('I772', 'Rupture of artery'),
    ('I773', 'Arterial fibromuscular dysplasia'),
    ('I774', 'Celiac artery compression syndrome'),
    ('I775', 'Necrosis of artery'),
    ('I776', 'Arteritis, unspecified'),
    ('I7770', 'Dissection of unspecified artery'),
    ('I7771', 'Dissection of carotid artery'),
    ('I7772', 'Dissection of iliac artery'),
    ('I7773', 'Dissection of renal artery'),
    ('I7774', 'Dissection of vertebral artery'),
    ('I7775', 'Dissection of other precerebral arteries'),
    ('I7776', 'Dissection of artery of upper extremity'),
    ('I7777', 'Dissection of artery of lower extremity'),
    ('I7779', 'Dissection of other specified artery'),
    ('I77810', 'Thoracic aortic ectasia'),
    ('I77811', 'Abdominal aortic ectasia'),
    ('I77812', 'Thoracoabdominal aortic ectasia'),
    ('I77819', 'Aortic ectasia, unspecified site'),
    ('I7782', 'Antineutrophilic cytoplasmic antibody [ANCA] vasculitis'),
    ('I7789', 'Other specified disorders of arteries and arterioles'),
    ('I779', 'Disorder of arteries and arterioles, unspecified'),
    ('I780', 'Hereditary hemorrhagic telangiectasia'),
    ('I781', 'Nevus, non-neoplastic'),
    ('I788', 'Other diseases of capillaries'),
    ('I789', 'Disease of capillaries, unspecified'),
    ('I790', 'Aneurysm of aorta in diseases classified elsewhere'),
    ('I791', 'Aortitis in diseases classified elsewhere'),
    ('I798', 'Oth disord of art,arterioles & capilare in dis classd elswhr'),
    ('I8000', 'Phlbts and thombophlb of superfic vessels of unsp low extrm'),
    ('I8001', 'Phlebitis and thombophlb of superfic vessels of r low extrem'),
    ('I8002', 'Phlebitis and thombophlb of superfic vessels of l low extrem'),
    ('I8003', 'Phlbts and thombophlb of superfic vessels of low extrm, bi'),
    ('I8010', 'Phlebitis and thrombophlebitis of unspecified femoral vein'),
    ('I8011', 'Phlebitis and thrombophlebitis of right femoral vein'),
    ('I8012', 'Phlebitis and thrombophlebitis of left femoral vein'),
    ('I8013', 'Phlebitis and thrombophlebitis of femoral vein, bilateral'),
    ('I80201', 'Phlbts and thombophlb of unsp deep vessels of r low extrem'),
    ('I80202', 'Phlbts and thombophlb of unsp deep vessels of l low extrem'),
    ('I80203', 'Phlbts and thombophlb of unsp deep vessels of low extrm, bi'),
    ('I80209', 'Phlbts and thombophlb of unsp deep vessels of unsp low extrm'),
    ('I80211', 'Phlebitis and thrombophlebitis of right iliac vein'),
    ('I80212', 'Phlebitis and thrombophlebitis of left iliac vein'),
    ('I80213', 'Phlebitis and thrombophlebitis of iliac vein, bilateral'),
    ('I80219', 'Phlebitis and thrombophlebitis of unspecified iliac vein'),
    ('I80221', 'Phlebitis and thrombophlebitis of right popliteal vein'),
    ('I80222', 'Phlebitis and thrombophlebitis of left popliteal vein'),
    ('I80223', 'Phlebitis and thrombophlebitis of popliteal vein, bilateral'),
    ('I80229', 'Phlebitis and thrombophlebitis of unspecified popliteal vein'),
    ('I80231', 'Phlebitis and thrombophlebitis of right tibial vein'),
    ('I80232', 'Phlebitis and thrombophlebitis of left tibial vein'),
    ('I80233', 'Phlebitis and thrombophlebitis of tibial vein, bilateral'),
    ('I80239', 'Phlebitis and thrombophlebitis of unspecified tibial vein'),
    ('I80241', 'Phlebitis and thrombophlebitis of right peroneal vein'),
    ('I80242', 'Phlebitis and thrombophlebitis of left peroneal vein'),
    ('I80243', 'Phlebitis and thrombophlebitis of peroneal vein, bilateral'),
    ('I80249', 'Phlebitis and thrombophlebitis of unspecified peroneal vein'),
    ('I80251', 'Phlebitis and thrombophlebitis of right calf muscular vein'),
    ('I80252', 'Phlebitis and thrombophlebitis of left calf muscular vein'),
    ('I80253', 'Phlebitis and thombophlb of calf muscular vein, bilateral'),
    ('I80259', 'Phlebitis and thombophlb of unspecified calf muscular vein'),
    ('I80291', 'Phlebitis and thombophlb of deep vessels of r low extrem'),
    ('I80292', 'Phlebitis and thombophlb of deep vessels of l low extrem'),
    ('I80293', 'Phlebitis and thombophlb of deep vessels of low extrm, bi'),
    ('I80299', 'Phlebitis and thombophlb of deep vessels of unsp low extrm'),
    ('I803', 'Phlebitis and thrombophlebitis of lower extremities, unsp'),
    ('I808', 'Phlebitis and thrombophlebitis of other sites'),
    ('I809', 'Phlebitis and thrombophlebitis of unspecified site'),
    ('I81', 'Portal vein thrombosis'),
    ('I820', 'Budd-Chiari syndrome'),
    ('I821', 'Thrombophlebitis migrans'),
    ('I82210', 'Acute embolism and thrombosis of superior vena cava'),
    ('I82211', 'Chronic embolism and thrombosis of superior vena cava'),
    ('I82220', 'Acute embolism and thrombosis of inferior vena cava'),
    ('I82221', 'Chronic embolism and thrombosis of inferior vena cava'),
    ('I82290', 'Acute embolism and thrombosis of other thoracic veins'),
    ('I82291', 'Chronic embolism and thrombosis of other thoracic veins'),
    ('I823', 'Embolism and thrombosis of renal vein'),
    ('I82401', 'Acute embolism and thombos unsp deep veins of r low extrem'),
    ('I82402', 'Acute embolism and thombos unsp deep veins of l low extrem'),
    ('I82403', 'Acute embolism and thombos unsp deep veins of low extrm, bi'),
    ('I82409', 'Acute embolism and thombos unsp deep vn unsp lower extremity'),
    ('I82411', 'Acute embolism and thrombosis of right femoral vein'),
    ('I82412', 'Acute embolism and thrombosis of left femoral vein'),
    ('I82413', 'Acute embolism and thrombosis of femoral vein, bilateral'),
    ('I82419', 'Acute embolism and thrombosis of unspecified femoral vein'),
    ('I82421', 'Acute embolism and thrombosis of right iliac vein'),
    ('I82422', 'Acute embolism and thrombosis of left iliac vein'),
    ('I82423', 'Acute embolism and thrombosis of iliac vein, bilateral'),
    ('I82429', 'Acute embolism and thrombosis of unspecified iliac vein'),
    ('I82431', 'Acute embolism and thrombosis of right popliteal vein'),
    ('I82432', 'Acute embolism and thrombosis of left popliteal vein'),
    ('I82433', 'Acute embolism and thrombosis of popliteal vein, bilateral'),
    ('I82439', 'Acute embolism and thrombosis of unspecified popliteal vein'),
    ('I82441', 'Acute embolism and thrombosis of right tibial vein'),
    ('I82442', 'Acute embolism and thrombosis of left tibial vein'),
    ('I82443', 'Acute embolism and thrombosis of tibial vein, bilateral'),
    ('I82449', 'Acute embolism and thrombosis of unspecified tibial vein'),
    ('I82451', 'Acute embolism and thrombosis of right peroneal vein'),
    ('I82452', 'Acute embolism and thrombosis of left peroneal vein'),
    ('I82453', 'Acute embolism and thrombosis of peroneal vein, bilateral'),
    ('I82459', 'Acute embolism and thrombosis of unspecified peroneal vein'),
    ('I82461', 'Acute embolism and thrombosis of right calf muscular vein'),
    ('I82462', 'Acute embolism and thrombosis of left calf muscular vein'),
    ('I82463', 'Acute embolism and thombos of calf muscular vein, bilateral'),
    ('I82469', 'Acute embolism and thombos unsp calf muscular vein'),
    ('I82491', 'Acute embolism and thrombosis of deep vein of r low extrem'),
    ('I82492', 'Acute embolism and thrombosis of deep vein of l low extrem'),
    ('I82493', 'Acute embolism and thombos of deep vein of low extrm, bi'),
    ('I82499', 'Acute embolism and thrombosis of deep vein of unsp low extrm'),
    ('I824Y1', 'Ac emblsm and thombos unsp deep veins of r prox low extrm'),
    ('I824Y2', 'Ac emblsm and thombos unsp deep veins of left prox low extrm'),
    ('I824Y3', 'Ac emblsm and thombos unsp deep veins of prox low extrm, bi'),
    ('I824Y9', 'Acute emblsm and thombos unsp deep vn unsp prox low extrm'),
    ('I824Z1', 'Ac emblsm and thombos unsp deep veins of r dist low extrm'),
    ('I824Z2', 'Ac emblsm and thombos unsp deep veins of left dist low extrm'),
    ('I824Z3', 'Ac emblsm and thombos unsp deep veins of dist low extrm, bi'),
    ('I824Z9', 'Acute emblsm and thombos unsp deep vn unsp distal low extrm'),
    ('I82501', 'Chronic embolism and thombos unsp deep veins of r low extrem'),
    ('I82502', 'Chronic embolism and thombos unsp deep veins of l low extrem'),
    ('I82503', 'Chronic emblsm and thombos unsp deep veins of low extrm, bi'),
    ('I82509', 'Chronic embolism and thombos unsp deep vn unsp low extrm'),
    ('I82511', 'Chronic embolism and thrombosis of right femoral vein'),
    ('I82512', 'Chronic embolism and thrombosis of left femoral vein'),
    ('I82513', 'Chronic embolism and thrombosis of femoral vein, bilateral'),
    ('I82519', 'Chronic embolism and thrombosis of unspecified femoral vein'),
    ('I82521', 'Chronic embolism and thrombosis of right iliac vein'),
    ('I82522', 'Chronic embolism and thrombosis of left iliac vein'),
    ('I82523', 'Chronic embolism and thrombosis of iliac vein, bilateral'),
    ('I82529', 'Chronic embolism and thrombosis of unspecified iliac vein'),
    ('I82531', 'Chronic embolism and thrombosis of right popliteal vein'),
    ('I82532', 'Chronic embolism and thrombosis of left popliteal vein'),
    ('I82533', 'Chronic embolism and thrombosis of popliteal vein, bilateral'),
    ('I82539', 'Chronic embolism and thrombosis of unsp popliteal vein'),
    ('I82541', 'Chronic embolism and thrombosis of right tibial vein'),
    ('I82542', 'Chronic embolism and thrombosis of left tibial vein'),
    ('I82543', 'Chronic embolism and thrombosis of tibial vein, bilateral'),
    ('I82549', 'Chronic embolism and thrombosis of unspecified tibial vein'),
    ('I82551', 'Chronic embolism and thrombosis of right peroneal vein'),
    ('I82552', 'Chronic embolism and thrombosis of left peroneal vein'),
    ('I82553', 'Chronic embolism and thrombosis of peroneal vein, bilateral'),
    ('I82559', 'Chronic embolism and thrombosis of unspecified peroneal vein'),
    ('I82561', 'Chronic embolism and thrombosis of right calf muscular vein'),
    ('I82562', 'Chronic embolism and thrombosis of left calf muscular vein'),
    ('I82563', 'Chronic embolism and thombos of calf muscular vein, bi'),
    ('I82569', 'Chronic embolism and thombos unsp calf muscular vein'),
    ('I82591', 'Chronic embolism and thrombosis of deep vein of r low extrem'),
    ('I82592', 'Chronic embolism and thrombosis of deep vein of l low extrem'),
    ('I82593', 'Chronic embolism and thombos of deep vein of low extrm, bi'),
    ('I82599', 'Chronic embolism and thombos of deep vein of unsp low extrm'),
    ('I825Y1', 'Chr emblsm and thombos unsp deep veins of r prox low extrm'),
    ('I825Y2', 'Chr emblsm and thombos unsp deep vn of left prox low extrm'),
    ('I825Y3', 'Chr emblsm and thombos unsp deep veins of prox low extrm, bi'),
    ('I825Y9', 'Chronic emblsm and thombos unsp deep vn unsp prox low extrm'),
    ('I825Z1', 'Chr emblsm and thombos unsp deep veins of r dist low extrm'),
    ('I825Z2', 'Chr emblsm and thombos unsp deep vn of left dist low extrm'),
    ('I825Z3', 'Chr emblsm and thombos unsp deep veins of dist low extrm, bi'),
    ('I825Z9', 'Chr emblsm and thombos unsp deep vn unsp distal low extrm'),
    ('I82601', 'Acute embolism and thombos unsp veins of r up extrem'),
    ('I82602', 'Acute embolism and thombos unsp veins of l up extrem'),
    ('I82603', 'Acute embolism and thombos unsp veins of up extrem, bi'),
    ('I82609', 'Acute embolism and thombos unsp vn unsp upper extremity'),
    ('I82611', 'Acute embolism and thombos of superfic veins of r up extrem'),
    ('I82612', 'Acute embolism and thombos of superfic veins of l up extrem'),
    ('I82613', 'Acute emblsm and thombos of superfic veins of up extrem, bi'),
    ('I82619', 'Acute embolism and thrombosis of superfic vn unsp up extrem'),
    ('I82621', 'Acute embolism and thrombosis of deep veins of r up extrem'),
    ('I82622', 'Acute embolism and thrombosis of deep veins of l up extrem'),
    ('I82623', 'Acute embolism and thombos of deep veins of up extrem, bi'),
    ('I82629', 'Acute embolism and thrombosis of deep vn unsp up extrem'),
    ('I82701', 'Chronic embolism and thombos unsp veins of r up extrem'),
    ('I82702', 'Chronic embolism and thombos unsp veins of l up extrem'),
    ('I82703', 'Chronic embolism and thombos unsp veins of up extrem, bi'),
    ('I82709', 'Chronic embolism and thombos unsp vn unsp upper extremity'),
    ('I82711', 'Chronic emblsm and thombos of superfic veins of r up extrem'),
    ('I82712', 'Chronic emblsm and thombos of superfic veins of l up extrem'),
    ('I82713', 'Chr emblsm and thombos of superfic veins of up extrem, bi'),
    ('I82719', 'Chronic embolism and thombos of superfic vn unsp up extrem'),
    ('I82721', 'Chronic embolism and thrombosis of deep veins of r up extrem'),
    ('I82722', 'Chronic embolism and thrombosis of deep veins of l up extrem'),
    ('I82723', 'Chronic embolism and thombos of deep veins of up extrem, bi'),
    ('I82729', 'Chronic embolism and thrombosis of deep vn unsp up extrem'),
    ('I82811', 'Embolism and thrombosis of superfic veins of right low extrm'),
    ('I82812', 'Embolism and thrombosis of superfic veins of left low extrm'),
    ('I82813', 'Embolism and thombos of superfic veins of low extrm, bi'),
    ('I82819', 'Embolism and thrombosis of superficial vn unsp low extrm'),
    ('I82890', 'Acute embolism and thrombosis of other specified veins'),
    ('I82891', 'Chronic embolism and thrombosis of other specified veins'),
    ('I8290', 'Acute embolism and thrombosis of unspecified vein'),
    ('I8291', 'Chronic embolism and thrombosis of unspecified vein'),
    ('I82A11', 'Acute embolism and thrombosis of right axillary vein'),
    ('I82A12', 'Acute embolism and thrombosis of left axillary vein'),
    ('I82A13', 'Acute embolism and thrombosis of axillary vein, bilateral'),
    ('I82A19', 'Acute embolism and thrombosis of unspecified axillary vein'),
    ('I82A21', 'Chronic embolism and thrombosis of right axillary vein'),
    ('I82A22', 'Chronic embolism and thrombosis of left axillary vein'),
    ('I82A23', 'Chronic embolism and thrombosis of axillary vein, bilateral'),
    ('I82A29', 'Chronic embolism and thrombosis of unspecified axillary vein'),
    ('I82B11', 'Acute embolism and thrombosis of right subclavian vein'),
    ('I82B12', 'Acute embolism and thrombosis of left subclavian vein'),
    ('I82B13', 'Acute embolism and thrombosis of subclavian vein, bilateral'),
    ('I82B19', 'Acute embolism and thrombosis of unspecified subclavian vein'),
    ('I82B21', 'Chronic embolism and thrombosis of right subclavian vein'),
    ('I82B22', 'Chronic embolism and thrombosis of left subclavian vein'),
    ('I82B23', 'Chronic embolism and thrombosis of subclav vein, bilateral'),
    ('I82B29', 'Chronic embolism and thrombosis of unsp subclavian vein'),
    ('I82C11', 'Acute embolism and thrombosis of right internal jugular vein'),
    ('I82C12', 'Acute embolism and thrombosis of left internal jugular vein'),
    ('I82C13', 'Acute embolism and thrombosis of int jugular vein, bilateral'),
    ('I82C19', 'Acute embolism and thrombosis of unsp internal jugular vein'),
    ('I82C21', 'Chronic embolism and thrombosis of r int jugular vein'),
    ('I82C22', 'Chronic embolism and thrombosis of l int jugular vein'),
    ('I82C23', 'Chronic embolism and thombos of int jugular vein, bilateral'),
    ('I82C29', 'Chronic embolism and thombos unsp internal jugular vein'),
    ('I83001', 'Varicose veins of unsp lower extremity with ulcer of thigh'),
    ('I83002', 'Varicose veins of unsp lower extremity with ulcer of calf'),
    ('I83003', 'Varicose veins of unsp lower extremity with ulcer of ankle'),
    ('I83004', 'Varicos vn unsp lower extremity w ulcer of heel and midfoot'),
    ('I83005', 'Varicos vn unsp lower extremity w ulcer oth part of foot'),
    ('I83008', 'Varicos vn unsp low extrm w ulcer oth part of lower leg'),
    ('I83009', 'Varicose veins of unsp lower extremity w ulcer of unsp site'),
    ('I83011', 'Varicose veins of right lower extremity with ulcer of thigh'),
    ('I83012', 'Varicose veins of right lower extremity with ulcer of calf'),
    ('I83013', 'Varicose veins of right lower extremity with ulcer of ankle'),
    ('I83014', 'Varicose veins of r low extrem w ulcer of heel and midfoot'),
    ('I83015', 'Varicose veins of r low extrem w ulcer oth part of foot'),
    ('I83018', 'Varicose veins of r low extrem w ulcer oth part of lower leg'),
    ('I83019', 'Varicose veins of right lower extremity w ulcer of unsp site'),
    ('I83021', 'Varicose veins of left lower extremity with ulcer of thigh'),
    ('I83022', 'Varicose veins of left lower extremity with ulcer of calf'),
    ('I83023', 'Varicose veins of left lower extremity with ulcer of ankle'),
    ('I83024', 'Varicose veins of l low extrem w ulcer of heel and midfoot'),
    ('I83025', 'Varicose veins of l low extrem w ulcer oth part of foot'),
    ('I83028', 'Varicose veins of l low extrem w ulcer oth part of lower leg'),
    ('I83029', 'Varicose veins of left lower extremity w ulcer of unsp site'),
    ('I8310', 'Varicose veins of unsp lower extremity with inflammation'),
    ('I8311', 'Varicose veins of right lower extremity with inflammation'),
    ('I8312', 'Varicose veins of left lower extremity with inflammation'),
    ('I83201', 'Varicos vn unsp low extrm w ulc of thigh and inflammation'),
    ('I83202', 'Varicos vn unsp low extrm w ulc of calf and inflammation'),
    ('I83203', 'Varicos vn unsp low extrm w ulc of ankle and inflammation'),
    ('I83204', 'Varicos vn unsp low extrm w ulc of heel and midft and inflam'),
    ('I83205', 'Varicos vn unsp low extrm w ulc oth part of foot and inflam'),
    ('I83208', 'Varicos vn unsp low extrm w ulc oth prt low extrm and inflam'),
    ('I83209', 'Varicos vn unsp low extrm w ulc of unsp site and inflam'),
    ('I83211', 'Varicos vn of r low extrem w ulc of thigh and inflammation'),
    ('I83212', 'Varicos vn of r low extrem w ulc of calf and inflammation'),
    ('I83213', 'Varicos vn of r low extrem w ulc of ankle and inflammation'),
    ('I83214', 'Varicos vn of r low extrem w ulc of heel & midft and inflam'),
    ('I83215', 'Varicos vn of r low extrem w ulc oth part of foot and inflam'),
    ('I83218', 'Varicos vn of r low extrem w ulc oth prt low extrm & inflam'),
    ('I83219', 'Varicos vn of r low extrem w ulc of unsp site and inflam'),
    ('I83221', 'Varicos vn of l low extrem w ulc of thigh and inflammation'),
    ('I83222', 'Varicos vn of l low extrem w ulc of calf and inflammation'),
    ('I83223', 'Varicos vn of l low extrem w ulc of ankle and inflammation'),
    ('I83224', 'Varicos vn of l low extrem w ulc of heel & midft and inflam'),
    ('I83225', 'Varicos vn of l low extrem w ulc oth part of foot and inflam'),
    ('I83228', 'Varicos vn of l low extrem w ulc oth prt low extrm & inflam'),
    ('I83229', 'Varicos vn of l low extrem w ulc of unsp site and inflam'),
    ('I83811', 'Varicose veins of right lower extremity with pain'),
    ('I83812', 'Varicose veins of left lower extremity with pain'),
    ('I83813', 'Varicose veins of bilateral lower extremities with pain'),
    ('I83819', 'Varicose veins of unspecified lower extremity with pain'),
    ('I83891', 'Varicose veins of right low extrm w oth complications'),
    ('I83892', 'Varicose veins of left lower extremity w oth complications'),
    ('I83893', 'Varicose veins of bi low extrem w oth complications'),
    ('I83899', 'Varicose veins of unsp lower extremity w oth complications'),
    ('I8390', 'Asymptomatic varicose veins of unspecified lower extremity'),
    ('I8391', 'Asymptomatic varicose veins of right lower extremity'),
    ('I8392', 'Asymptomatic varicose veins of left lower extremity'),
    ('I8393', 'Asymptomatic varicose veins of bilateral lower extremities'),
    ('I8500', 'Esophageal varices without bleeding'),
    ('I8501', 'Esophageal varices with bleeding'),
    ('I8510', 'Secondary esophageal varices without bleeding'),
    ('I8511', 'Secondary esophageal varices with bleeding'),
    ('I860', 'Sublingual varices'),
    ('I861', 'Scrotal varices'),
    ('I862', 'Pelvic varices'),
    ('I863', 'Vulval varices'),
    ('I864', 'Gastric varices'),
    ('I868', 'Varicose veins of other specified sites'),
    ('I87001', 'Postthrombotic syndrome w/o complications of r low extrem'),
    ('I87002', 'Postthrombotic syndrome w/o complications of l low extrem'),
    ('I87003', 'Postthrom syndrome w/o complications of bilateral low extrm'),
    ('I87009', 'Postthrombotic syndrome w/o complications of unsp extremity'),
    ('I87011', 'Postthrombotic syndrome with ulcer of right lower extremity'),
    ('I87012', 'Postthrombotic syndrome with ulcer of left lower extremity'),
    ('I87013', 'Postthrombotic syndrome w ulcer of bilateral lower extremity'),
    ('I87019', 'Postthrombotic syndrome with ulcer of unsp lower extremity'),
    ('I87021', 'Postthrombotic syndrome w inflammation of r low extrem'),
    ('I87022', 'Postthrombotic syndrome w inflammation of l low extrem'),
    ('I87023', 'Postthrom syndrome w inflammation of bilateral low extrm'),
    ('I87029', 'Postthrombotic syndrome w inflammation of unsp low extrm'),
    ('I87031', 'Postthrom syndrome w ulcer and inflammation of r low extrem'),
    ('I87032', 'Postthrom syndrome w ulcer and inflammation of l low extrem'),
    ('I87033', 'Postthrom syndrome w ulcer and inflam of bilateral low extrm'),
    ('I87039', 'Postthrom syndrome w ulcer and inflam of unsp low extrm'),
    ('I87091', 'Postthrombotic syndrome w oth complications of r low extrem'),
    ('I87092', 'Postthrombotic syndrome w oth complications of l low extrem'),
    ('I87093', 'Postthrom syndrome w oth comp of bilateral low extrm'),
    ('I87099', 'Postthrom syndrome w oth complications of unsp low extrm'),
    ('I871', 'Compression of vein'),
    ('I872', 'Venous insufficiency (chronic) (peripheral)'),
    ('I87301', 'Chronic venous hypertension w/o comp of r low extrem'),
    ('I87302', 'Chronic venous hypertension w/o comp of l low extrem'),
    ('I87303', 'Chronic venous hypertension w/o comp of bilateral low extrm'),
    ('I87309', 'Chronic venous hypertension w/o comp of unsp low extrm'),
    ('I87311', 'Chronic venous hypertension w ulcer of r low extrem'),
    ('I87312', 'Chronic venous hypertension w ulcer of l low extrem'),
    ('I87313', 'Chronic venous hypertension w ulcer of bilateral low extrm'),
    ('I87319', 'Chronic venous hypertension w ulcer of unsp low extrm'),
    ('I87321', 'Chronic venous hypertension w inflammation of r low extrem'),
    ('I87322', 'Chronic venous hypertension w inflammation of l low extrem'),
    ('I87323', 'Chronic venous htn w inflammation of bilateral low extrm'),
    ('I87329', 'Chronic venous hypertension w inflammation of unsp low extrm'),
    ('I87331', 'Chronic venous htn w ulcer and inflammation of r low extrem'),
    ('I87332', 'Chronic venous htn w ulcer and inflammation of l low extrem'),
    ('I87333', 'Chronic venous htn w ulcer and inflam of bilateral low extrm'),
    ('I87339', 'Chronic venous htn w ulcer and inflam of unsp low extrm'),
    ('I87391', 'Chronic venous hypertension w oth comp of r low extrem'),
    ('I87392', 'Chronic venous hypertension w oth comp of l low extrem'),
    ('I87393', 'Chronic venous htn w oth comp of bilateral low extrm'),
    ('I87399', 'Chronic venous hypertension w oth comp of unsp low extrm'),
    ('I878', 'Other specified disorders of veins'),
    ('I879', 'Disorder of vein, unspecified'),
    ('I880', 'Nonspecific mesenteric lymphadenitis'),
    ('I881', 'Chronic lymphadenitis, except mesenteric'),
    ('I888', 'Other nonspecific lymphadenitis'),
    ('I889', 'Nonspecific lymphadenitis, unspecified'),
    ('I890', 'Lymphedema, not elsewhere classified'),
    ('I891', 'Lymphangitis'),
    ('I898', 'Oth noninfective disorders of lymphatic vessels and nodes'),
    ('I899', 'Noninfective disorder of lymphatic vessels and nodes, unsp'),
    ('I950', 'Idiopathic hypotension'),
    ('I951', 'Orthostatic hypotension'),
    ('I952', 'Hypotension due to drugs'),
    ('I953', 'Hypotension of hemodialysis'),
    ('I9581', 'Postprocedural hypotension'),
    ('I9589', 'Other hypotension'),
    ('I959', 'Hypotension, unspecified'),
    ('I96', 'Gangrene, not elsewhere classified'),
    ('I970', 'Postcardiotomy syndrome'),
    ('I97110', 'Postproc cardiac insufficiency following cardiac surgery'),
    ('I97111', 'Postprocedural cardiac insufficiency following other surgery'),
    ('I97120', 'Postprocedural cardiac arrest following cardiac surgery'),
    ('I97121', 'Postprocedural cardiac arrest following other surgery'),
    ('I97130', 'Postprocedural heart failure following cardiac surgery'),
    ('I97131', 'Postprocedural heart failure following other surgery'),
    ('I97190', 'Oth postproc cardiac functn disturb fol cardiac surgery'),
    ('I97191', 'Oth postproc cardiac functn disturb following oth surgery'),
    ('I972', 'Postmastectomy lymphedema syndrome'),
    ('I973', 'Postprocedural hypertension'),
    ('I97410', 'Intraoperative hemor/hemtom of a circ sys org comp card cath'),
    ('I97411', 'Intraop hemor/hemtom of a circ sys org comp card bypass'),
    ('I97418', 'Intraop hemor/hemtom of circ sys org comp oth circ sys proc'),
    ('I9742', 'Intraop hemor/hemtom of a circ sys org comp oth procedure'),
    ('I9751', 'Acc pnctr & lac of a circ sys org during a circ sys proc'),
    ('I9752', 'Acc pnctr & lac of a circ sys org during oth procedure'),
    ('I97610', 'Postproc hemor of a circ sys org fol a cardiac cath'),
    ('I97611', 'Postproc hemor of a circ sys org fol cardiac bypass'),
    ('I97618', 'Postproc hemor of circ sys org fol oth circ sys proc'),
    ('I9762', 'Postproc hemor of a circ sys org fol oth procedure'),
    ('I97620', 'Postproc hemor of a circ sys org following other procedure'),
    ('I97621', 'Postproc hematoma of a circ sys org fol other procedure'),
    ('I97622', 'Postproc seroma of a circ sys org following other procedure'),
    ('I97630', 'Postproc hematoma of a circ sys org following a cardiac cath'),
    ('I97631', 'Postproc hematoma of a circ sys org following cardiac bypass'),
    ('I97638', 'Postproc hematoma of a circ sys org fol other circ sys proc'),
    ('I97640', 'Postproc seroma of a circ sys org following a cardiac cath'),
    ('I97641', 'Postproc seroma of a circ sys org following cardiac bypass'),
    ('I97648', 'Postproc seroma of a circ sys org fol other circ sys proc'),
    ('I97710', 'Intraoperative cardiac arrest during cardiac surgery'),
    ('I97711', 'Intraoperative cardiac arrest during other surgery'),
    ('I97790', 'Oth intraop cardiac functn disturb during cardiac surgery'),
    ('I97791', 'Oth intraop cardiac functional disturb during oth surgery'),
    ('I97810', 'Intraoperative cerebvasc infarction during cardiac surgery'),
    ('I97811', 'Intraoperative cerebrovascular infarction during oth surgery'),
    ('I97820', 'Postprocedural cerebvasc infarction folowing cardiac surgery'),
    ('I97821', 'Postprocedural cerebrovascular infarction following oth surgery'),
    ('I9788', 'Oth intraoperative complications of the circ sys, NEC'),
    ('I9789', 'Oth postproc comp and disorders of the circ sys, NEC'),
    ('I998', 'Other disorder of circulatory system'),
    ('I999', 'Unspecified disorder of circulatory system'),
    ('J00', 'Acute nasopharyngitis [common cold]'),
    ('J0100', 'Acute maxillary sinusitis, unspecified'),
    ('J0101', 'Acute recurrent maxillary sinusitis'),
    ('J0110', 'Acute frontal sinusitis, unspecified'),
    ('J0111', 'Acute recurrent frontal sinusitis'),
    ('J0120', 'Acute ethmoidal sinusitis, unspecified'),
    ('J0121', 'Acute recurrent ethmoidal sinusitis'),
    ('J0130', 'Acute sphenoidal sinusitis, unspecified'),
    ('J0131', 'Acute recurrent sphenoidal sinusitis'),
    ('J0140', 'Acute pansinusitis, unspecified'),
    ('J0141', 'Acute recurrent pansinusitis'),
    ('J0180', 'Other acute sinusitis'),
    ('J0181', 'Other acute recurrent sinusitis'),
    ('J0190', 'Acute sinusitis, unspecified'),
    ('J0191', 'Acute recurrent sinusitis, unspecified'),
    ('J020', 'Streptococcal pharyngitis'),
    ('J028', 'Acute pharyngitis due to other specified organisms'),
    ('J029', 'Acute pharyngitis, unspecified'),
    ('J0300', 'Acute streptococcal tonsillitis, unspecified'),
    ('J0301', 'Acute recurrent streptococcal tonsillitis'),
    ('J0380', 'Acute tonsillitis due to other specified organisms'),
    ('J0381', 'Acute recurrent tonsillitis due to other specified organisms'),
    ('J0390', 'Acute tonsillitis, unspecified'),
    ('J0391', 'Acute recurrent tonsillitis, unspecified'),
    ('J040', 'Acute laryngitis'),
    ('J0410', 'Acute tracheitis without obstruction'),
    ('J0411', 'Acute tracheitis with obstruction'),
    ('J042', 'Acute laryngotracheitis'),
    ('J0430', 'Supraglottitis, unspecified, without obstruction'),
    ('J0431', 'Supraglottitis, unspecified, with obstruction'),
    ('J050', 'Acute obstructive laryngitis [croup]'),
    ('J0510', 'Acute epiglottitis without obstruction'),
    ('J0511', 'Acute epiglottitis with obstruction'),
    ('J060', 'Acute laryngopharyngitis'),
    ('J069', 'Acute upper respiratory infection, unspecified'),
    ('J09X1', 'Influenza due to ident novel influenza A virus w pneumonia'),
    ('J09X2', 'Flu due to ident novel influenza A virus w oth resp manifest'),
    ('J09X3', 'Influenza due to ident novel influenza A virus w GI manifest'),
    ('J09X9', 'Flu due to ident novel influenza A virus w oth manifest'),
    ('J1000', 'Flu due to oth ident flu virus w unsp type of pneumonia'),
    ('J1001', 'Flu due to oth ident flu virus w same oth ident flu virus pn'),
    ('J1008', 'Influenza due to oth ident influenza virus w oth pneumonia'),
    ('J101', 'Flu due to oth ident influenza virus w oth resp manifest'),
    ('J102', 'Influenza due to oth ident influenza virus w GI manifest'),
    ('J1081', 'Influenza due to oth ident influenza virus w encephalopathy'),
    ('J1082', 'Influenza due to oth ident influenza virus w myocarditis'),
    ('J1083', 'Influenza due to oth ident influenza virus w otitis media'),
    ('J1089', 'Influenza due to oth ident influenza virus w oth manifest'),
    ('J1100', 'Flu due to unidentified flu virus w unsp type of pneumonia'),
    ('J1108', 'Flu due to unidentified flu virus w specified pneumonia'),
    ('J111', 'Flu due to unidentified influenza virus w oth resp manifest'),
    ('J112', 'Influenza due to unidentified influenza virus w GI manifest'),
    ('J1181', 'Flu due to unidentified influenza virus w encephalopathy'),
    ('J1182', 'Influenza due to unidentified influenza virus w myocarditis'),
    ('J1183', 'Influenza due to unidentified influenza virus w otitis media'),
    ('J1189', 'Influenza due to unidentified influenza virus w oth manifest'),
    ('J120', 'Adenoviral pneumonia'),
    ('J121', 'Respiratory syncytial virus pneumonia'),
    ('J122', 'Parainfluenza virus pneumonia'),
    ('J123', 'Human metapneumovirus pneumonia'),
    ('J1281', 'Pneumonia due to SARS-associated coronavirus'),
    ('J1289', 'Other viral pneumonia'),
    ('J129', 'Viral pneumonia, unspecified'),
    ('J13', 'Pneumonia due to Streptococcus pneumoniae'),
    ('J14', 'Pneumonia due to Hemophilus influenzae'),
    ('J150', 'Pneumonia due to Klebsiella pneumoniae'),
    ('J151', 'Pneumonia due to Pseudomonas'),
    ('J1520', 'Pneumonia due to staphylococcus, unspecified'),
    ('J15211', 'Pneumonia due to methicillin suscep staph'),
    ('J15212', 'Pneumonia due to Methicillin resistant Staphylococcus aureus'),
    ('J1529', 'Pneumonia due to other staphylococcus'),
    ('J153', 'Pneumonia due to streptococcus, group B'),
    ('J154', 'Pneumonia due to other streptococci'),
    ('J155', 'Pneumonia due to Escherichia coli'),
    ('J156', 'Pneumonia due to other Gram-negative bacteria'),
    ('J1561', 'Pneumonia due to Acinetobacter baumannii'),
    ('J1569', 'Pneumonia due to other Gram-negative bacteria'),
    ('J157', 'Pneumonia due to Mycoplasma pneumoniae'),
    ('J158', 'Pneumonia due to other specified bacteria'),
    ('J159', 'Unspecified bacterial pneumonia'),
    ('J160', 'Chlamydial pneumonia'),
    ('J168', 'Pneumonia due to other specified infectious organisms'),
    ('J17', 'Pneumonia in diseases classified elsewhere'),
    ('J180', 'Bronchopneumonia, unspecified organism'),
    ('J181', 'Lobar pneumonia, unspecified organism'),
    ('J182', 'Hypostatic pneumonia, unspecified organism'),
    ('J188', 'Other pneumonia, unspecified organism'),
    ('J189', 'Pneumonia, unspecified organism'),
    ('J200', 'Acute bronchitis due to Mycoplasma pneumoniae'),
    ('J201', 'Acute bronchitis due to Hemophilus influenzae'),
    ('J202', 'Acute bronchitis due to streptococcus'),
    ('J203', 'Acute bronchitis due to coxsackievirus'),
    ('J204', 'Acute bronchitis due to parainfluenza virus'),
    ('J205', 'Acute bronchitis due to respiratory syncytial virus'),
    ('J206', 'Acute bronchitis due to rhinovirus'),
    ('J207', 'Acute bronchitis due to echovirus'),
    ('J208', 'Acute bronchitis due to other specified organisms'),
    ('J209', 'Acute bronchitis, unspecified'),
    ('J210', 'Acute bronchiolitis due to respiratory syncytial virus'),
    ('J211', 'Acute bronchiolitis due to human metapneumovirus'),
    ('J218', 'Acute bronchiolitis due to other specified organisms'),
    ('J219', 'Acute bronchiolitis, unspecified'),
    ('J22', 'Unspecified acute lower respiratory infection'),
    ('J300', 'Vasomotor rhinitis'),
    ('J301', 'Allergic rhinitis due to pollen'),
    ('J302', 'Other seasonal allergic rhinitis'),
    ('J305', 'Allergic rhinitis due to food'),
    ('J3081', 'Allergic rhinitis due to animal (cat) (dog) hair and dander'),
    ('J3089', 'Other allergic rhinitis'),
    ('J309', 'Allergic rhinitis, unspecified'),
    ('J310', 'Chronic rhinitis'),
    ('J311', 'Chronic nasopharyngitis'),
    ('J312', 'Chronic pharyngitis'),
    ('J320', 'Chronic maxillary sinusitis'),
    ('J321', 'Chronic frontal sinusitis'),
    ('J322', 'Chronic ethmoidal sinusitis'),
    ('J323', 'Chronic sphenoidal sinusitis'),
    ('J324', 'Chronic pansinusitis'),
    ('J328', 'Other chronic sinusitis'),
    ('J329', 'Chronic sinusitis, unspecified'),
    ('J330', 'Polyp of nasal cavity'),
    ('J331', 'Polypoid sinus degeneration'),
    ('J338', 'Other polyp of sinus'),
    ('J339', 'Nasal polyp, unspecified'),
    ('J340', 'Abscess, furuncle and carbuncle of nose'),
    ('J341', 'Cyst and mucocele of nose and nasal sinus'),
    ('J342', 'Deviated nasal septum'),
    ('J343', 'Hypertrophy of nasal turbinates'),
    ('J3481', 'Nasal mucositis (ulcerative)'),
    ('J3489', 'Other specified disorders of nose and nasal sinuses'),
    ('J349', 'Unspecified disorder of nose and nasal sinuses'),
    ('J3501', 'Chronic tonsillitis'),
    ('J3502', 'Chronic adenoiditis'),
    ('J3503', 'Chronic tonsillitis and adenoiditis'),
    ('J351', 'Hypertrophy of tonsils'),
    ('J352', 'Hypertrophy of adenoids'),
    ('J353', 'Hypertrophy of tonsils with hypertrophy of adenoids'),
    ('J358', 'Other chronic diseases of tonsils and adenoids'),
    ('J359', 'Chronic disease of tonsils and adenoids, unspecified'),
    ('J36', 'Peritonsillar abscess'),
    ('J370', 'Chronic laryngitis'),
    ('J371', 'Chronic laryngotracheitis'),
    ('J3800', 'Paralysis of vocal cords and larynx, unspecified'),
    ('J3801', 'Paralysis of vocal cords and larynx, unilateral'),
    ('J3802', 'Paralysis of vocal cords and larynx, bilateral'),
    ('J381', 'Polyp of vocal cord and larynx'),
    ('J382', 'Nodules of vocal cords'),
    ('J383', 'Other diseases of vocal cords'),
    ('J384', 'Edema of larynx'),
    ('J385', 'Laryngeal spasm'),
    ('J386', 'Stenosis of larynx'),
    ('J387', 'Other diseases of larynx'),
    ('J390', 'Retropharyngeal and parapharyngeal abscess'),
    ('J391', 'Other abscess of pharynx'),
    ('J392', 'Other diseases of pharynx'),
    ('J393', 'Upper respiratory tract hypersensitivity reaction, site unsp'),
    ('J398', 'Other specified diseases of upper respiratory tract'),
    ('J399', 'Disease of upper respiratory tract, unspecified'),
    ('J40', 'Bronchitis, not specified as acute or chronic'),
    ('J410', 'Simple chronic bronchitis'),
    ('J411', 'Mucopurulent chronic bronchitis'),
    ('J418', 'Mixed simple and mucopurulent chronic bronchitis'),
    ('J42', 'Unspecified chronic bronchitis'),
    ('J430', "Unilateral pulmonary emphysema [MacLeod's syndrome]"),
    ('J431', 'Panlobular emphysema'),
    ('J432', 'Centrilobular emphysema'),
    ('J438', 'Other emphysema'),
    ('J439', 'Emphysema, unspecified'),
    ('J440', 'Chr obstructive pulmon disease with (acute) lower resp infct'),
    ('J441', 'Chronic obstructive pulmonary disease w (acute) exacerbation'),
    ('J4481', 'Bronchiolitis obliterans and bronchiolitis obliterans synd'),
    ('J4489', 'Other specified chronic obstructive pulmonary disease'),
    ('J449', 'Chronic obstructive pulmonary disease, unspecified'),
    ('J4A0', 'Restrictive allograft syndrome'),
    ('J4A8', 'Other chronic lung allograft dysfunction'),
    ('J4A9', 'Chronic lung allograft dysfunction, unspecified'),
    ('J4520', 'Mild intermittent asthma, uncomplicated'),
    ('J4521', 'Mild intermittent asthma with (acute) exacerbation'),
    ('J4522', 'Mild intermittent asthma with status asthmaticus'),
    ('J4530', 'Mild persistent asthma, uncomplicated'),
    ('J4531', 'Mild persistent asthma with (acute) exacerbation'),
    ('J4532', 'Mild persistent asthma with status asthmaticus'),
    ('J4540', 'Moderate persistent asthma, uncomplicated'),
    ('J4541', 'Moderate persistent asthma with (acute) exacerbation'),
    ('J4542', 'Moderate persistent asthma with status asthmaticus'),
    ('J4550', 'Severe persistent asthma, uncomplicated'),
    ('J4551', 'Severe persistent asthma with (acute) exacerbation'),
    ('J4552', 'Severe persistent asthma with status asthmaticus'),
    ('J45901', 'Unspecified asthma with (acute) exacerbation'),
    ('J45902', 'Unspecified asthma with status asthmaticus'),
    ('J45909', 'Unspecified asthma, uncomplicated'),
    ('J45990', 'Exercise induced bronchospasm'),
    ('J45991', 'Cough variant asthma'),
    ('J45998', 'Other asthma'),
    ('J470', 'Bronchiectasis with acute lower respiratory infection'),
    ('J471', 'Bronchiectasis with (acute) exacerbation'),
    ('J479', 'Bronchiectasis, uncomplicated'),
    ('J60', "Coalworker's pneumoconiosis"),
    ('J61', 'Pneumoconiosis due to asbestos and other mineral fibers'),
    ('J620', 'Pneumoconiosis due to talc dust'),
    ('J628', 'Pneumoconiosis due to other dust containing silica'),
    ('J630', 'Aluminosis (of lung)'),
    ('J631', 'Bauxite fibrosis (of lung)'),
    ('J632', 'Berylliosis'),
    ('J633', 'Graphite fibrosis (of lung)'),
    ('J634', 'Siderosis'),
    ('J635', 'Stannosis'),
    ('J636', 'Pneumoconiosis due to other specified inorganic dusts'),
    ('J64', 'Unspecified pneumoconiosis'),
    ('J65', 'Pneumoconiosis associated with tuberculosis'),
    ('J660', 'Byssinosis'),
    ('J661', "Flax-dressers' disease"),
    ('J662', 'Cannabinosis'),
    ('J668', 'Airway disease due to other specific organic dusts'),
    ('J670', "Farmer's lung"),
    ('J671', 'Bagassosis'),
    ('J672', "Bird fancier's lung"),
    ('J673', 'Suberosis'),
    ('J674', "Maltworker's lung"),
    ('J675', "Mushroom-worker's lung"),
    ('J676', "Maple-bark-stripper's lung"),
    ('J677', 'Air conditioner and humidifier lung'),
    ('J678', 'Hypersensitivity pneumonitis due to other organic dusts'),
    ('J679', 'Hypersensitivity pneumonitis due to unspecified organic dust'),
    ('J680', 'Bronchitis & pneumonitis d/t chemicals, gas, fumes & vapors'),
    ('J681', 'Pulmonary edema due to chemicals, gases, fumes and vapors'),
    ('J682', 'Upper resp inflam d/t chemicals, gas, fumes and vapors, NEC'),
    ('J683', 'Oth ac & subac resp cond d/t chemicals, gas, fumes & vapors'),
    ('J684', 'Chronic resp cond due to chemicals, gases, fumes and vapors'),
    ('J688', 'Oth resp cond due to chemicals, gases, fumes and vapors'),
    ('J689', 'Unsp resp cond due to chemicals, gases, fumes and vapors'),
    ('J690', 'Pneumonitis due to inhalation of food and vomit'),
    ('J691', 'Pneumonitis due to inhalation of oils and essences'),
    ('J698', 'Pneumonitis due to inhalation of other solids and liquids'),
    ('J700', 'Acute pulmonary manifestations due to radiation'),
    ('J701', 'Chronic and other pulmonary manifestations due to radiation'),
    ('J702', 'Acute drug-induced interstitial lung disorders'),
    ('J703', 'Chronic drug-induced interstitial lung disorders'),
    ('J704', 'Drug-induced interstitial lung disorders, unspecified'),
    ('J705', 'Respiratory conditions due to smoke inhalation'),
    ('J708', 'Respiratory conditions due to oth external agents'),
    ('J709', 'Respiratory conditions due to unspecified external agent'),
    ('J80', 'Acute respiratory distress syndrome'),
    ('J810', 'Acute pulmonary edema'),
    ('J811', 'Chronic pulmonary edema'),
    ('J82', 'Pulmonary eosinophilia, not elsewhere classified'),
    ('J8281', 'Chronic eosinophilic pneumonia'),
    ('J8282', 'Acute eosinophilic pneumonia'),
    ('J8283', 'Eosinophilic asthma'),
    ('J8289', 'Other pulmonary eosinophilia, not elsewhere classified'),
    ('J8401', 'Alveolar proteinosis'),
    ('J8402', 'Pulmonary alveolar microlithiasis'),
    ('J8403', 'Idiopathic pulmonary hemosiderosis'),
    ('J8409', 'Other alveolar and parieto-alveolar conditions'),
    ('J8410', 'Pulmonary fibrosis, unspecified'),
    ('J84111', 'Idiopathic interstitial pneumonia, not otherwise specified'),
    ('J84112', 'Idiopathic pulmonary fibrosis'),
    ('J84113', 'Idiopathic non-specific interstitial pneumonitis'),
    ('J84114', 'Acute interstitial pneumonitis'),
    ('J84115', 'Respiratory bronchiolitis interstitial lung disease'),
    ('J84116', 'Cryptogenic organizing pneumonia'),
    ('J84117', 'Desquamative interstitial pneumonia'),
    ('J8417', 'Oth interstit pulmon dis w fibrosis in dis classd elswhr'),
    ('J84170', 'Interstit lung dis w progr fibrotic phenotype dis classd e'),
    ('J84178', 'Oth interstit pulmon dis with fibrosis in dis classd elswhr'),
    ('J842', 'Lymphoid interstitial pneumonia'),
    ('J8481', 'Lymphangioleiomyomatosis'),
    ('J8482', 'Adult pulmonary Langerhans cell histiocytosis'),
    ('J8483', 'Surfactant mutations of the lung'),
    ('J84841', 'Neuroendocrine cell hyperplasia of infancy'),
    ('J84842', 'Pulmonary interstitial glycogenosis'),
    ('J84843', 'Alveolar capillary dysplasia with vein misalignment'),
    ('J84848', 'Other interstitial lung diseases of childhood'),
    ('J8489', 'Other specified interstitial pulmonary diseases'),
    ('J849', 'Interstitial pulmonary disease, unspecified'),
    ('J850', 'Gangrene and necrosis of lung'),
    ('J851', 'Abscess of lung with pneumonia'),
    ('J852', 'Abscess of lung without pneumonia'),
    ('J853', 'Abscess of mediastinum'),
    ('J860', 'Pyothorax with fistula'),
    ('J869', 'Pyothorax without fistula'),
    ('J90', 'Pleural effusion, not elsewhere classified'),
    ('J910', 'Malignant pleural effusion'),
    ('J918', 'Pleural effusion in other conditions classified elsewhere'),
    ('J920', 'Pleural plaque with presence of asbestos'),
    ('J929', 'Pleural plaque without asbestos'),
    ('J930', 'Spontaneous tension pneumothorax'),
    ('J9311', 'Primary spontaneous pneumothorax'),
    ('J9312', 'Secondary spontaneous pneumothorax'),
    ('J9381', 'Chronic pneumothorax'),
    ('J9382', 'Other air leak'),
    ('J9383', 'Other pneumothorax'),
    ('J939', 'Pneumothorax, unspecified'),
    ('J940', 'Chylous effusion'),
    ('J941', 'Fibrothorax'),
    ('J942', 'Hemothorax'),
    ('J948', 'Other specified pleural conditions'),
    ('J949', 'Pleural condition, unspecified'),
    ('J9500', 'Unspecified tracheostomy complication'),
    ('J9501', 'Hemorrhage from tracheostomy stoma'),
    ('J9502', 'Infection of tracheostomy stoma'),
    ('J9503', 'Malfunction of tracheostomy stoma'),
    ('J9504', 'Tracheo-esophageal fistula following tracheostomy'),
    ('J9509', 'Other tracheostomy complication'),
    ('J951', 'Acute pulmonary insufficiency following thoracic surgery'),
    ('J952', 'Acute pulmonary insufficiency following nonthoracic surgery'),
    ('J953', 'Chronic pulmonary insufficiency following surgery'),
    ('J954', 'Chemical pneumonitis due to anesthesia'),
    ('J955', 'Postprocedural subglottic stenosis'),
    ('J9561', 'Intraop hemor/hemtom of a resp sys org comp resp sys proc'),
    ('J9562', 'Intraop hemor/hemtom of a resp sys org comp oth procedure'),
    ('J9571', 'Accidental pnctr & lac of a resp sys org dur resp sys proc'),
    ('J9572', 'Acc pnctr & lac of a resp sys org during oth procedure'),
    ('J95811', 'Postprocedural pneumothorax'),
    ('J95812', 'Postprocedural air leak'),
    ('J95821', 'Acute postprocedural respiratory failure'),
    ('J95822', 'Acute and chronic postprocedural respiratory failure'),
    ('J95830', 'Postproc hemor of a resp sys org fol a resp sys proc'),
    ('J95831', 'Postproc hemor of a resp sys org fol oth procedure'),
    ('J9584', 'Transfusion-related acute lung injury (TRALI)'),
    ('J95850', 'Mechanical complication of respirator'),
    ('J95851', 'Ventilator associated pneumonia'),
    ('J95859', 'Other complication of respirator [ventilator]'),
    ('J95860', 'Postproc hematoma of a resp sys org fol a resp sys procedure'),
    ('J95861', 'Postproc hematoma of a resp sys org fol other procedure'),
    ('J95862', 'Postproc seroma of a resp sys org fol a resp sys procedure'),
    ('J95863', 'Postproc seroma of a resp sys org following other procedure'),
    ('J9587', 'Transfusion-associated dyspnea (TAD)'),
    ('J9588', 'Oth intraoperative complications of respiratory system, NEC'),
    ('J9589', 'Oth postproc complications and disorders of resp sys, NEC'),
    ('J9600', 'Acute respiratory failure, unsp w hypoxia or hypercapnia'),
    ('J9601', 'Acute respiratory failure with hypoxia'),
    ('J9602', 'Acute respiratory failure with hypercapnia'),
    ('J9610', 'Chronic respiratory failure, unsp w hypoxia or hypercapnia'),
    ('J9611', 'Chronic respiratory failure with hypoxia'),
    ('J9612', 'Chronic respiratory failure with hypercapnia'),
    ('J9620', 'Acute and chr resp failure, unsp w hypoxia or hypercapnia'),
    ('J9621', 'Acute and chronic respiratory failure with hypoxia'),
    ('J9622', 'Acute and chronic respiratory failure with hypercapnia'),
    ('J9690', 'Respiratory failure, unsp, unsp w hypoxia or hypercapnia'),
    ('J9691', 'Respiratory failure, unspecified with hypoxia'),
    ('J9692', 'Respiratory failure, unspecified with hypercapnia'),
    ('J9801', 'Acute bronchospasm'),
    ('J9809', 'Other diseases of bronchus, not elsewhere classified'),
    ('J9811', 'Atelectasis'),
    ('J9819', 'Other pulmonary collapse'),
    ('J982', 'Interstitial emphysema'),
    ('J983', 'Compensatory emphysema'),
    ('J984', 'Other disorders of lung'),
    ('J985', 'Diseases of mediastinum, not elsewhere classified'),
    ('J9851', 'Mediastinitis'),
    ('J9859', 'Other diseases of mediastinum, not elsewhere classified'),
    ('J986', 'Disorders of diaphragm'),
    ('J988', 'Other specified respiratory disorders'),
    ('J989', 'Respiratory disorder, unspecified'),
    ('J99', 'Respiratory disorders in diseases classified elsewhere'),
    ('K000', 'Anodontia'),
    ('K001', 'Supernumerary teeth'),
    ('K002', 'Abnormalities of size and form of teeth'),
    ('K003', 'Mottled teeth'),
    ('K004', 'Disturbances in tooth formation'),
    ('K005', 'Hereditary disturbances in tooth structure, NEC'),
    ('K006', 'Disturbances in tooth eruption'),
    ('K007', 'Teething syndrome'),
    ('K008', 'Other disorders of tooth development'),
    ('K009', 'Disorder of tooth development, unspecified'),
    ('K010', 'Embedded teeth'),
    ('K011', 'Impacted teeth'),
    ('K023', 'Arrested dental caries'),
    ('K0251', 'Dental caries on pit and fissure surface limited to enamel'),
    ('K0252', 'Dental caries on pit and fissure surfc penetrat into dentin'),
    ('K0253', 'Dental caries on pit and fissure surface penetrat into pulp'),
    ('K0261', 'Dental caries on smooth surface limited to enamel'),
    ('K0262', 'Dental caries on smooth surface penetrating into dentin'),
    ('K0263', 'Dental caries on smooth surface penetrating into pulp'),
    ('K027', 'Dental root caries'),
    ('K029', 'Dental caries, unspecified'),
    ('K030', 'Excessive attrition of teeth'),
    ('K031', 'Abrasion of teeth'),
    ('K032', 'Erosion of teeth'),
    ('K033', 'Pathological resorption of teeth'),
    ('K034', 'Hypercementosis'),
    ('K035', 'Ankylosis of teeth'),
    ('K036', 'Deposits [accretions] on teeth'),
    ('K037', 'Posteruptive color changes of dental hard tissues'),
    ('K0381', 'Cracked tooth'),
    ('K0389', 'Other specified diseases of hard tissues of teeth'),
    ('K039', 'Disease of hard tissues of teeth, unspecified'),
    ('K040', 'Pulpitis'),
    ('K0401', 'Reversible pulpitis'),
    ('K0402', 'Irreversible pulpitis'),
    ('K041', 'Necrosis of pulp'),
    ('K042', 'Pulp degeneration'),
    ('K043', 'Abnormal hard tissue formation in pulp'),
    ('K044', 'Acute apical periodontitis of pulpal origin'),
    ('K045', 'Chronic apical periodontitis'),
    ('K046', 'Periapical abscess with sinus'),
    ('K047', 'Periapical abscess without sinus'),
    ('K048', 'Radicular cyst'),
    ('K0490', 'Unspecified diseases of pulp and periapical tissues'),
    ('K0499', 'Other diseases of pulp and periapical tissues'),
    ('K0500', 'Acute gingivitis, plaque induced'),
    ('K0501', 'Acute gingivitis, non-plaque induced'),
    ('K0510', 'Chronic gingivitis, plaque induced'),
    ('K0511', 'Chronic gingivitis, non-plaque induced'),
    ('K0520', 'Aggressive periodontitis, unspecified'),
    ('K0521', 'Aggressive periodontitis, localized'),
    ('K05211', 'Aggressive periodontitis, localized, slight'),
    ('K05212', 'Aggressive periodontitis, localized, moderate'),
    ('K05213', 'Aggressive periodontitis, localized, severe'),
    ('K05219', 'Aggressive periodontitis, localized, unspecified severity'),
    ('K0522', 'Aggressive periodontitis, generalized'),
    ('K05221', 'Aggressive periodontitis, generalized, slight'),
    ('K05222', 'Aggressive periodontitis, generalized, moderate'),
    ('K05223', 'Aggressive periodontitis, generalized, severe'),
    ('K05229', 'Aggressive periodontitis, generalized, unspecified severity'),
    ('K0530', 'Chronic periodontitis, unspecified'),
    ('K0531', 'Chronic periodontitis, localized'),
    ('K05311', 'Chronic periodontitis, localized, slight'),
    ('K05312', 'Chronic periodontitis, localized, moderate'),
    ('K05313', 'Chronic periodontitis, localized, severe'),
    ('K05319', 'Chronic periodontitis, localized, unspecified severity'),
    ('K0532', 'Chronic periodontitis, generalized'),
    ('K05321', 'Chronic periodontitis, generalized, slight'),
    ('K05322', 'Chronic periodontitis, generalized, moderate'),
    ('K05323', 'Chronic periodontitis, generalized, severe'),
    ('K05329', 'Chronic periodontitis, generalized, unspecified severity'),
    ('K054', 'Periodontosis'),
    ('K055', 'Other periodontal diseases'),
    ('K056', 'Periodontal disease, unspecified'),
    ('K060', 'Gingival recession'),
    ('K06010', 'Localized gingival recession, unspecified'),
    ('K06011', 'Localized gingival recession, minimal'),
    ('K06012', 'Localized gingival recession, moderate'),
    ('K06013', 'Localized gingival recession, severe'),
    ('K06020', 'Generalized gingival recession, unspecified'),
    ('K06021', 'Generalized gingival recession, minimal'),
    ('K06022', 'Generalized gingival recession, moderate'),
    ('K06023', 'Generalized gingival recession, severe'),
    ('K061', 'Gingival enlargement'),
    ('K062', 'Gingival & edentulous alveolar ridge lesions assoc w trauma'),
    ('K063', 'Horizontal alveolar bone loss'),
    ('K068', 'Oth disrd of gingiva and edentulous alveolar ridge'),
    ('K069', 'Disorder of gingiva and edentulous alveolar ridge, unsp'),
    ('K080', 'Exfoliation of teeth due to systemic causes'),
    ('K08101', 'Complete loss of teeth, unspecified cause, class I'),
    ('K08102', 'Complete loss of teeth, unspecified cause, class II'),
    ('K08103', 'Complete loss of teeth, unspecified cause, class III'),
    ('K08104', 'Complete loss of teeth, unspecified cause, class IV'),
    ('K08109', 'Complete loss of teeth, unspecified cause, unspecified class'),
    ('K08111', 'Complete loss of teeth due to trauma, class I'),
    ('K08112', 'Complete loss of teeth due to trauma, class II'),
    ('K08113', 'Complete loss of teeth due to trauma, class III'),
    ('K08114', 'Complete loss of teeth due to trauma, class IV'),
    ('K08119', 'Complete loss of teeth due to trauma, unspecified class'),
    ('K08121', 'Complete loss of teeth due to periodontal diseases, class I'),
    ('K08122', 'Complete loss of teeth due to periodontal diseases, class II'),
    ('K08123', 'Complete loss of teeth due to periodontal dis, class III'),
    ('K08124', 'Complete loss of teeth due to periodontal diseases, class IV'),
    ('K08129', 'Complete loss of teeth due to periodontal dis, unsp class'),
    ('K08131', 'Complete loss of teeth due to caries, class I'),
    ('K08132', 'Complete loss of teeth due to caries, class II'),
    ('K08133', 'Complete loss of teeth due to caries, class III'),
    ('K08134', 'Complete loss of teeth due to caries, class IV'),
    ('K08139', 'Complete loss of teeth due to caries, unspecified class'),
    ('K08191', 'Complete loss of teeth due to other specified cause, class I'),
    ('K08192', 'Complete loss of teeth due to oth cause, class II'),
    ('K08193', 'Complete loss of teeth due to oth cause, class III'),
    ('K08194', 'Complete loss of teeth due to oth cause, class IV'),
    ('K08199', 'Complete loss of teeth due to oth cause, unspecified class'),
    ('K0820', 'Unspecified atrophy of edentulous alveolar ridge'),
    ('K0821', 'Minimal atrophy of the mandible'),
    ('K0822', 'Moderate atrophy of the mandible'),
    ('K0823', 'Severe atrophy of the mandible'),
    ('K0824', 'Minimal atrophy of maxilla'),
    ('K0825', 'Moderate atrophy of the maxilla'),
    ('K0826', 'Severe atrophy of the maxilla'),
    ('K083', 'Retained dental root'),
    ('K08401', 'Partial loss of teeth, unspecified cause, class I'),
    ('K08402', 'Partial loss of teeth, unspecified cause, class II'),
    ('K08403', 'Partial loss of teeth, unspecified cause, class III'),
    ('K08404', 'Partial loss of teeth, unspecified cause, class IV'),
    ('K08409', 'Partial loss of teeth, unspecified cause, unspecified class'),
    ('K08411', 'Partial loss of teeth due to trauma, class I'),
    ('K08412', 'Partial loss of teeth due to trauma, class II'),
    ('K08413', 'Partial loss of teeth due to trauma, class III'),
    ('K08414', 'Partial loss of teeth due to trauma, class IV'),
    ('K08419', 'Partial loss of teeth due to trauma, unspecified class'),
    ('K08421', 'Partial loss of teeth due to periodontal diseases, class I'),
    ('K08422', 'Partial loss of teeth due to periodontal diseases, class II'),
    ('K08423', 'Partial loss of teeth due to periodontal diseases, class III'),
    ('K08424', 'Partial loss of teeth due to periodontal diseases, class IV'),
    ('K08429', 'Partial loss of teeth due to periodontal dis, unsp class'),
    ('K08431', 'Partial loss of teeth due to caries, class I'),
    ('K08432', 'Partial loss of teeth due to caries, class II'),
    ('K08433', 'Partial loss of teeth due to caries, class III'),
    ('K08434', 'Partial loss of teeth due to caries, class IV'),
    ('K08439', 'Partial loss of teeth due to caries, unspecified class'),
    ('K08491', 'Partial loss of teeth due to other specified cause, class I'),
    ('K08492', 'Partial loss of teeth due to other specified cause, class II'),
    ('K08493', 'Partial loss of teeth due to oth cause, class III'),
    ('K08494', 'Partial loss of teeth due to other specified cause, class IV'),
    ('K08499', 'Partial loss of teeth due to oth cause, unspecified class'),
    ('K0850', 'Unsatisfactory restoration of tooth, unspecified'),
    ('K0851', 'Open restoration margins of tooth'),
    ('K0852', 'Unrepairable overhanging of dental restorative materials'),
    ('K08530', 'Fractured dental restorative material w/o loss of material'),
    ('K08531', 'Fractured dental restorative material with loss of material'),
    ('K08539', 'Fractured dental restorative material, unspecified'),
    ('K0854', 'Contour of exist restor of tooth biolog incompat w oral hlth'),
    ('K0855', 'Allergy to existing dental restorative material'),
    ('K0856', 'Poor aesthetic of existing restoration of tooth'),
    ('K0859', 'Other unsatisfactory restoration of tooth'),
    ('K088', 'Other specified disorders of teeth and supporting structures'),
    ('K0881', 'Primary occlusal trauma'),
    ('K0882', 'Secondary occlusal trauma'),
    ('K0889', 'Other specified disorders of teeth and supporting structures'),
    ('K089', 'Disorder of teeth and supporting structures, unspecified'),
    ('K090', 'Developmental odontogenic cysts'),
    ('K091', 'Developmental (nonodontogenic) cysts of oral region'),
    ('K098', 'Other cysts of oral region, not elsewhere classified'),
    ('K099', 'Cyst of oral region, unspecified'),
    ('K110', 'Atrophy of salivary gland'),
    ('K111', 'Hypertrophy of salivary gland'),
    ('K1120', 'Sialoadenitis, unspecified'),
    ('K1121', 'Acute sialoadenitis'),
    ('K1122', 'Acute recurrent sialoadenitis'),
    ('K1123', 'Chronic sialoadenitis'),
    ('K113', 'Abscess of salivary gland'),
    ('K114', 'Fistula of salivary gland'),
    ('K115', 'Sialolithiasis'),
    ('K116', 'Mucocele of salivary gland'),
    ('K117', 'Disturbances of salivary secretion'),
    ('K118', 'Other diseases of salivary glands'),
    ('K119', 'Disease of salivary gland, unspecified'),
    ('K120', 'Recurrent oral aphthae'),
    ('K121', 'Other forms of stomatitis'),
    ('K122', 'Cellulitis and abscess of mouth'),
    ('K1230', 'Oral mucositis (ulcerative), unspecified'),
    ('K1231', 'Oral mucositis (ulcerative) due to antineoplastic therapy'),
    ('K1232', 'Oral mucositis (ulcerative) due to other drugs'),
    ('K1233', 'Oral mucositis (ulcerative) due to radiation'),
    ('K1239', 'Other oral mucositis (ulcerative)'),
    ('K130', 'Diseases of lips'),
    ('K131', 'Cheek and lip biting'),
    ('K1321', 'Leukoplakia of oral mucosa, including tongue'),
    ('K1322', 'Minimal keratinized residual ridge mucosa'),
    ('K1323', 'Excessive keratinized residual ridge mucosa'),
    ('K1324', 'Leukokeratosis nicotina palati'),
    ('K1329', 'Other disturbances of oral epithelium, including tongue'),
    ('K133', 'Hairy leukoplakia'),
    ('K134', 'Granuloma and granuloma-like lesions of oral mucosa'),
    ('K135', 'Oral submucous fibrosis'),
    ('K136', 'Irritative hyperplasia of oral mucosa'),
    ('K1370', 'Unspecified lesions of oral mucosa'),
    ('K1379', 'Other lesions of oral mucosa'),
    ('K140', 'Glossitis'),
    ('K141', 'Geographic tongue'),
    ('K142', 'Median rhomboid glossitis'),
    ('K143', 'Hypertrophy of tongue papillae'),
    ('K144', 'Atrophy of tongue papillae'),
    ('K145', 'Plicated tongue'),
    ('K146', 'Glossodynia'),
    ('K148', 'Other diseases of tongue'),
    ('K149', 'Disease of tongue, unspecified'),
    ('K200', 'Eosinophilic esophagitis'),
    ('K208', 'Other esophagitis'),
    ('K2080', 'Other esophagitis without bleeding'),
    ('K2081', 'Other esophagitis with bleeding'),
    ('K209', 'Esophagitis, unspecified'),
    ('K2090', 'Esophagitis, unspecified without bleeding '),
    ('K2091', 'Esophagitis, unspecified with bleeding'),
    ('K210', 'Gastro-esophageal reflux disease with esophagitis'),
    ('K2100', 'Gastro-esophageal reflux dis with esophagitis, without bleed'),
    ('K2101', 'Gastro-esophageal reflux dis with esophagitis, with bleed'),
    ('K219', 'Gastro-esophageal reflux disease without esophagitis '),
    ('K220', 'Achalasia of cardia'),
    ('K2210', 'Ulcer of esophagus without bleeding'),
    ('K2211', 'Ulcer of esophagus with bleeding'),
    ('K222', 'Esophageal obstruction'),
    ('K223', 'Perforation of esophagus'),
    ('K224', 'Dyskinesia of esophagus'),
    ('K225', 'Diverticulum of esophagus, acquired'),
    ('K226', 'Gastro-esophageal laceration-hemorrhage syndrome'),
    ('K2270', "Barrett's esophagus without dysplasia"),
    ('K22710', "Barrett's esophagus with low grade dysplasia"),
    ('K22711', "Barrett's esophagus with high grade dysplasia"),
    ('K22719', "Barrett's esophagus with dysplasia, unspecified"),
    ('K228', 'Other specified diseases of esophagus'),
    ('K2281', 'Esophageal polyp'),
    ('K2282', 'Esophagogastric junction polyp'),
    ('K2289', 'Other specified disease of esophagus'),
    ('K229', 'Disease of esophagus, unspecified'),
    ('K23', 'Disorders of esophagus in diseases classified elsewhere'),
    ('K250', 'Acute gastric ulcer with hemorrhage'),
    ('K251', 'Acute gastric ulcer with perforation'),
    ('K252', 'Acute gastric ulcer with both hemorrhage and perforation'),
    ('K253', 'Acute gastric ulcer without hemorrhage or perforation'),
    ('K254', 'Chronic or unspecified gastric ulcer with hemorrhage'),
    ('K255', 'Chronic or unspecified gastric ulcer with perforation'),
    ('K256', 'Chronic or unsp gastric ulcer w both hemorrhage and perf'),
    ('K257', 'Chronic gastric ulcer without hemorrhage or perforation'),
    ('K259', 'Gastric ulcer, unsp as acute or chronic, w/o hemor or perf'),
    ('K260', 'Acute duodenal ulcer with hemorrhage'),
    ('K261', 'Acute duodenal ulcer with perforation'),
    ('K262', 'Acute duodenal ulcer with both hemorrhage and perforation'),
    ('K263', 'Acute duodenal ulcer without hemorrhage or perforation'),
    ('K264', 'Chronic or unspecified duodenal ulcer with hemorrhage'),
    ('K265', 'Chronic or unspecified duodenal ulcer with perforation'),
    ('K266', 'Chronic or unsp duodenal ulcer w both hemorrhage and perf'),
    ('K267', 'Chronic duodenal ulcer without hemorrhage or perforation'),
    ('K269', 'Duodenal ulcer, unsp as acute or chronic, w/o hemor or perf'),
    ('K270', 'Acute peptic ulcer, site unspecified, with hemorrhage'),
    ('K271', 'Acute peptic ulcer, site unspecified, with perforation'),
    ('K272', 'Acute peptic ulcer, site unsp, w both hemorrhage and perf'),
    ('K273', 'Acute peptic ulcer, site unsp, w/o hemorrhage or perforation'),
    ('K274', 'Chronic or unsp peptic ulcer, site unsp, with hemorrhage'),
    ('K275', 'Chronic or unsp peptic ulcer, site unsp, with perforation'),
    ('K276', 'Chr or unsp peptic ulcer, site unsp, w both hemor and perf'),
    ('K277', 'Chronic peptic ulcer, site unsp, w/o hemorrhage or perf'),
    ('K279', 'Peptic ulc, site unsp, unsp as ac or chr, w/o hemor or perf'),
    ('K280', 'Acute gastrojejunal ulcer with hemorrhage'),
    ('K281', 'Acute gastrojejunal ulcer with perforation'),
    ('K282', 'Acute gastrojejunal ulcer w both hemorrhage and perforation'),
    ('K283', 'Acute gastrojejunal ulcer without hemorrhage or perforation'),
    ('K284', 'Chronic or unspecified gastrojejunal ulcer with hemorrhage'),
    ('K285', 'Chronic or unspecified gastrojejunal ulcer with perforation'),
    ('K286', 'Chronic or unsp gastrojejunal ulcer w both hemor and perf'),
    ('K287', 'Chronic gastrojejunal ulcer w/o hemorrhage or perforation'),
    ('K289', 'Gastrojejunal ulcer, unsp as acute or chr, w/o hemor or perf'),
    ('K2900', 'Acute gastritis without bleeding'),
    ('K2901', 'Acute gastritis with bleeding'),
    ('K2920', 'Alcoholic gastritis without bleeding'),
    ('K2921', 'Alcoholic gastritis with bleeding'),
    ('K2930', 'Chronic superficial gastritis without bleeding'),
    ('K2931', 'Chronic superficial gastritis with bleeding'),
    ('K2940', 'Chronic atrophic gastritis without bleeding'),
    ('K2941', 'Chronic atrophic gastritis with bleeding'),
    ('K2950', 'Unspecified chronic gastritis without bleeding'),
    ('K2951', 'Unspecified chronic gastritis with bleeding'),
    ('K2960', 'Other gastritis without bleeding'),
    ('K2961', 'Other gastritis with bleeding'),
    ('K2970', 'Gastritis, unspecified, without bleeding'),
    ('K2971', 'Gastritis, unspecified, with bleeding'),
    ('K2980', 'Duodenitis without bleeding'),
    ('K2981', 'Duodenitis with bleeding'),
    ('K2990', 'Gastroduodenitis, unspecified, without bleeding'),
    ('K2991', 'Gastroduodenitis, unspecified, with bleeding'),
    ('K30', 'Functional dyspepsia'),
    ('K310', 'Acute dilatation of stomach'),
    ('K311', 'Adult hypertrophic pyloric stenosis'),
    ('K312', 'Hourglass stricture and stenosis of stomach'),
    ('K313', 'Pylorospasm, not elsewhere classified'),
    ('K314', 'Gastric diverticulum'),
    ('K315', 'Obstruction of duodenum'),
    ('K316', 'Fistula of stomach and duodenum'),
    ('K317', 'Polyp of stomach and duodenum'),
    ('K31811', 'Angiodysplasia of stomach and duodenum with bleeding'),
    ('K31819', 'Angiodysplasia of stomach and duodenum without bleeding'),
    ('K3182', 'Dieulafoy lesion (hemorrhagic) of stomach and duodenum'),
    ('K3183', 'Achlorhydria'),
    ('K3184', 'Gastroparesis'),
    ('K3189', 'Other diseases of stomach and duodenum'),
    ('K319', 'Disease of stomach and duodenum, unspecified'),
    ('K31A0', 'Gastric intestinal metaplasia, unspecified '),
    ('K31A11', 'Gastric intestnl metaplasia without dysplasia, w the antrum'),
    ('K31A12', 'Gastr intestnl metaplasia w/o dysplasia, w the body (corpus)'),
    ('K31A13', 'Gastric intestnl metaplasia without dysplasia, w the fundus'),
    ('K31A14', 'Gastric intestnl metaplasia without dysplasia, w the cardia'),
    ('K31A15', 'Gastric intestnl metaplasia without dysplasia, w mult sites'),
    ('K31A19', 'Gastric intestinal metaplasia without dysplasia, unsp site '),
    ('K31A21', 'Gastric intestinal metaplasia with low grade dysplasia'),
    ('K31A22', 'Gastric intestinal metaplasia with high grade dysplasia'),
    ('K31A29', 'Gastric intestinal metaplasia with dysplasia, unspecified'),
    ('K352', 'Acute appendicitis with generalized peritonitis'),
    ('K3520', 'Acute appendicitis with gen peritonitis, without abscess'),
    ('K35200', 'Acute appendicitis with gen peritonitis, w/o perf or abscs'),
    ('K35201', 'Ac appendicitis with gen peritonitis, with perf, w/o abscs'),
    ('K35209', 'Ac appendicitis w gen peritonitis,w/o abscs,unsp as to perf'),
    ('K3521', 'Acute appendicitis with gen peritonitis, with abscess'),
    ('K35210', 'Ac appendicitis with gen peritonitis, w/o perf, with abscs'),
    ('K35211', 'Acute appendicitis with gen peritonitis, with perf and abscs'),
    ('K35219', 'Ac appendicitis w gen peritonitis, w abscs, unsp as to perf'),
    ('K353', 'Acute appendicitis with localized peritonitis'),
    ('K3530', 'Acute appendicitis with loc peritonitis, w/o perf or gangr'),
    ('K3531', 'Acute appendicitis with loc peritonitis and gangr, w/o perf'),
    ('K3532', 'Ac appendicitis w perf, loc peritonitis, & gangr, w/o abscs  '),
    ('K3533', 'Ac appendicitis with perf, loc peritonitis, and gangr, with wbscs'),
    ('K3580', 'Unspecified acute appendicitis'),
    ('K3589', 'Other acute appendicitis'),
    ('K35890', 'Other acute appendicitis without perforation or gangrene'),
    ('K35891', 'Other acute appendicitis without perforation, with gangrene'),
    ('K36', 'Other appendicitis'),
    ('K37', 'Unspecified appendicitis'),
    ('K380', 'Hyperplasia of appendix'),
    ('K381', 'Appendicular concretions'),
    ('K382', 'Diverticulum of appendix'),
    ('K383', 'Fistula of appendix'),
    ('K388', 'Other specified diseases of appendix'),
    ('K389', 'Disease of appendix, unspecified'),
    ('K4000', 'Bi inguinal hernia, w obst, w/o gangrene, not spcf as recur'),
    ('K4001', 'Bilateral inguinal hernia, w obst, w/o gangrene, recurrent'),
    ('K4010', 'Bi inguinal hernia, w gangrene, not specified as recurrent'),
    ('K4011', 'Bilateral inguinal hernia, with gangrene, recurrent'),
    ('K4020', 'Bi inguinal hernia, w/o obst or gangrene, not spcf as recur'),
    ('K4021', 'Bilateral inguinal hernia, w/o obst or gangrene, recurrent'),
    ('K4030', 'Unil inguinal hernia, w obst, w/o gangr, not spcf as recur'),
    ('K4031', 'Unilateral inguinal hernia, w obst, w/o gangrene, recurrent'),
    ('K4040', 'Unil inguinal hernia, w gangrene, not specified as recurrent'),
    ('K4041', 'Unilateral inguinal hernia, with gangrene, recurrent'),
    ('K4090', 'Unil inguinal hernia, w/o obst or gangr, not spcf as recur'),
    ('K4091', 'Unilateral inguinal hernia, w/o obst or gangrene, recurrent'),
    ('K4100', 'Bi femoral hernia, w obst, w/o gangrene, not spcf as recur'),
    ('K4101', 'Bilateral femoral hernia, w obst, w/o gangrene, recurrent'),
    ('K4110', 'Bi femoral hernia, w gangrene, not specified as recurrent'),
    ('K4111', 'Bilateral femoral hernia, with gangrene, recurrent'),
    ('K4120', 'Bi femoral hernia, w/o obst or gangrene, not spcf as recur'),
    ('K4121', 'Bilateral femoral hernia, w/o obst or gangrene, recurrent'),
    ('K4130', 'Unil femoral hernia, w obst, w/o gangrene, not spcf as recur'),
    ('K4131', 'Unilateral femoral hernia, w obst, w/o gangrene, recurrent'),
    ('K4140', 'Unil femoral hernia, w gangrene, not specified as recurrent'),
    ('K4141', 'Unilateral femoral hernia, with gangrene, recurrent'),
    ('K4190', 'Unil femoral hernia, w/o obst or gangrene, not spcf as recur'),
    ('K4191', 'Unilateral femoral hernia, w/o obst or gangrene, recurrent'),
    ('K420', 'Umbilical hernia with obstruction, without gangrene'),
    ('K421', 'Umbilical hernia with gangrene'),
    ('K429', 'Umbilical hernia without obstruction or gangrene'),
    ('K430', 'Incisional hernia with obstruction, without gangrene'),
    ('K431', 'Incisional hernia with gangrene'),
    ('K432', 'Incisional hernia without obstruction or gangrene'),
    ('K433', 'Parastomal hernia with obstruction, without gangrene'),
    ('K434', 'Parastomal hernia with gangrene'),
    ('K435', 'Parastomal hernia without obstruction or gangrene'),
    ('K436', 'Other and unsp ventral hernia with obstruction, w/o gangrene'),
    ('K437', 'Other and unspecified ventral hernia with gangrene'),
    ('K439', 'Ventral hernia without obstruction or gangrene'),
    ('K440', 'Diaphragmatic hernia with obstruction, without gangrene'),
    ('K441', 'Diaphragmatic hernia with gangrene'),
    ('K449', 'Diaphragmatic hernia without obstruction or gangrene'),
    ('K450', 'Oth abdominal hernia with obstruction, without gangrene'),
    ('K451', 'Other specified abdominal hernia with gangrene'),
    ('K458', 'Oth abdominal hernia without obstruction or gangrene'),
    ('K460', 'Unsp abdominal hernia with obstruction, without gangrene'),
    ('K461', 'Unspecified abdominal hernia with gangrene'),
    ('K469', 'Unspecified abdominal hernia without obstruction or gangrene'),
    ('K5000', "Crohn's disease of small intestine without complications"),
    ('K50011', "Crohn's disease of small intestine with rectal bleeding"),
    ('K50012', "Crohn's disease of small intestine w intestinal obstruction"),
    ('K50013', "Crohn's disease of small intestine with fistula"),
    ('K50014', "Crohn's disease of small intestine with abscess"),
    ('K50018', "Crohn's disease of small intestine with other complication"),
    ('K50019', "Crohn's disease of small intestine with unsp complications"),
    ('K5010', "Crohn's disease of large intestine without complications"),
    ('K50111', "Crohn's disease of large intestine with rectal bleeding"),
    ('K50112', "Crohn's disease of large intestine w intestinal obstruction"),
    ('K50113', "Crohn's disease of large intestine with fistula"),
    ('K50114', "Crohn's disease of large intestine with abscess"),
    ('K50118', "Crohn's disease of large intestine with other complication"),
    ('K50119', "Crohn's disease of large intestine with unsp complications"),
    ('K5080', "Crohn's disease of both small and lg int w/o complications"),
    ('K50811', "Crohn's disease of both small and lg int w rectal bleeding"),
    ('K50812', "Crohn's disease of both small and lg int w intestinal obst"),
    ('K50813', "Crohn's disease of both small and large intestine w fistula"),
    ('K50814', "Crohn's disease of both small and large intestine w abscess"),
    ('K50818', "Crohn's disease of both small and lg int w oth complication"),
    ('K50819', "Crohn's disease of both small and lg int w unsp comp"),
    ('K5090', "Crohn's disease, unspecified, without complications"),
    ('K50911', "Crohn's disease, unspecified, with rectal bleeding"),
    ('K50912', "Crohn's disease, unspecified, with intestinal obstruction"),
    ('K50913', "Crohn's disease, unspecified, with fistula"),
    ('K50914', "Crohn's disease, unspecified, with abscess"),
    ('K50918', "Crohn's disease, unspecified, with other complication"),
    ('K50919', "Crohn's disease, unspecified, with unspecified complications"),
    ('K5100', 'Ulcerative (chronic) pancolitis without complications'),
    ('K51011', 'Ulcerative (chronic) pancolitis with rectal bleeding'),
    ('K51012', 'Ulcerative (chronic) pancolitis with intestinal obstruction'),
    ('K51013', 'Ulcerative (chronic) pancolitis with fistula'),
    ('K51014', 'Ulcerative (chronic) pancolitis with abscess'),
    ('K51018', 'Ulcerative (chronic) pancolitis with other complication'),
    ('K51019', 'Ulcerative (chronic) pancolitis with unsp complications'),
    ('K5120', 'Ulcerative (chronic) proctitis without complications'),
    ('K51211', 'Ulcerative (chronic) proctitis with rectal bleeding'),
    ('K51212', 'Ulcerative (chronic) proctitis with intestinal obstruction'),
    ('K51213', 'Ulcerative (chronic) proctitis with fistula'),
    ('K51214', 'Ulcerative (chronic) proctitis with abscess'),
    ('K51218', 'Ulcerative (chronic) proctitis with other complication'),
    ('K51219', 'Ulcerative (chronic) proctitis with unsp complications'),
    ('K5130', 'Ulcerative (chronic) rectosigmoiditis without complications'),
    ('K51311', 'Ulcerative (chronic) rectosigmoiditis with rectal bleeding'),
    ('K51312', 'Ulcerative (chronic) rectosigmoiditis w intestinal obst'),
    ('K51313', 'Ulcerative (chronic) rectosigmoiditis with fistula'),
    ('K51314', 'Ulcerative (chronic) rectosigmoiditis with abscess'),
    ('K51318', 'Ulcerative (chronic) rectosigmoiditis with oth complication'),
    ('K51319', 'Ulcerative (chronic) rectosigmoiditis w unsp complications'),
    ('K5140', 'Inflammatory polyps of colon without complications'),
    ('K51411', 'Inflammatory polyps of colon with rectal bleeding'),
    ('K51412', 'Inflammatory polyps of colon with intestinal obstruction'),
    ('K51413', 'Inflammatory polyps of colon with fistula'),
    ('K51414', 'Inflammatory polyps of colon with abscess'),
    ('K51418', 'Inflammatory polyps of colon with other complication'),
    ('K51419', 'Inflammatory polyps of colon with unspecified complications'),
    ('K5150', 'Left sided colitis without complications'),
    ('K51511', 'Left sided colitis with rectal bleeding'),
    ('K51512', 'Left sided colitis with intestinal obstruction'),
    ('K51513', 'Left sided colitis with fistula'),
    ('K51514', 'Left sided colitis with abscess'),
    ('K51518', 'Left sided colitis with other complication'),
    ('K51519', 'Left sided colitis with unspecified complications'),
    ('K5180', 'Other ulcerative colitis without complications'),
    ('K51811', 'Other ulcerative colitis with rectal bleeding'),
    ('K51812', 'Other ulcerative colitis with intestinal obstruction'),
    ('K51813', 'Other ulcerative colitis with fistula'),
    ('K51814', 'Other ulcerative colitis with abscess'),
    ('K51818', 'Other ulcerative colitis with other complication'),
    ('K51819', 'Other ulcerative colitis with unspecified complications'),
    ('K5190', 'Ulcerative colitis, unspecified, without complications'),
    ('K51911', 'Ulcerative colitis, unspecified with rectal bleeding'),
    ('K51912', 'Ulcerative colitis, unspecified with intestinal obstruction'),
    ('K51913', 'Ulcerative colitis, unspecified with fistula'),
    ('K51914', 'Ulcerative colitis, unspecified with abscess'),
    ('K51918', 'Ulcerative colitis, unspecified with other complication'),
    ('K51919', 'Ulcerative colitis, unsp with unspecified complications'),
    ('K520', 'Gastroenteritis and colitis due to radiation'),
    ('K521', 'Toxic gastroenteritis and colitis'),
    ('K522', 'Allergic and dietetic gastroenteritis and colitis'),
    ('K5221', 'Food protein-induced enterocolitis syndrome'),
    ('K5222', 'Food protein-induced enteropathy'),
    ('K5229', 'Other allergic and dietetic gastroenteritis and colitis'),
    ('K523', 'Indeterminate colitis'),
    ('K5281', 'Eosinophilic gastritis or gastroenteritis'),
    ('K5282', 'Eosinophilic colitis'),
    ('K52831', 'Collagenous colitis'),
    ('K52832', 'Lymphocytic colitis'),
    ('K52838', 'Other microscopic colitis'),
    ('K52839', 'Microscopic colitis, unspecified'),
    ('K5289', 'Other specified noninfective gastroenteritis and colitis'),
    ('K529', 'Noninfective gastroenteritis and colitis, unspecified'),
    ('K550', 'Acute vascular disorders of intestine'),
    ('K55011', 'Focal (segmental) acute ischemia of small intestine'),
    ('K55012', 'Diffuse acute (reversible) ischemia of small intestine'),
    ('K55019', 'Acute ischemia of small intestine, extent unspecified'),
    ('K55021', 'Focal (segmental) acute infarction of small intestine'),
    ('K55022', 'Diffuse acute infarction of small intestine'),
    ('K55029', 'Acute infarction of small intestine, extent unspecified'),
    ('K55031', 'Focal (segmental) acute ischemia of large intestine'),
    ('K55032', 'Diffuse acute (reversible) ischemia of large intestine'),
    ('K55039', 'Acute ischemia of large intestine, extent unspecified'),
    ('K55041', 'Focal (segmental) acute infarction of large intestine'),
    ('K55042', 'Diffuse acute infarction of large intestine'),
    ('K55049', 'Acute infarction of large intestine, extent unspecified'),
    ('K55051', 'Focal acute ischemia of intestine, part unspecified'),
    ('K55052', 'Diffuse acute ischemia of intestine, part unspecified'),
    ('K55059', 'Acute ischemia of intestine, part and extent unspecified'),
    ('K55061', 'Focal acute infarction of intestine, part unspecified'),
    ('K55062', 'Diffuse acute infarction of intestine, part unspecified'),
    ('K55069', 'Acute infarction of intestine, part and extent unspecified'),
    ('K551', 'Chronic vascular disorders of intestine'),
    ('K5520', 'Angiodysplasia of colon without hemorrhage'),
    ('K5521', 'Angiodysplasia of colon with hemorrhage'),
    ('K5530', 'Necrotizing enterocolitis, unspecified'),
    ('K5531', 'Stage 1 necrotizing enterocolitis'),
    ('K5532', 'Stage 2 necrotizing enterocolitis'),
    ('K5533', 'Stage 3 necrotizing enterocolitis'),
    ('K558', 'Other vascular disorders of intestine'),
    ('K559', 'Vascular disorder of intestine, unspecified'),
    ('K560', 'Paralytic ileus'),
    ('K561', 'Intussusception'),
    ('K562', 'Volvulus'),
    ('K563', 'Gallstone ileus'),
    ('K5641', 'Fecal impaction'),
    ('K5649', 'Other impaction of intestine'),
    ('K565', 'Intestinal adhesions w obst (postprocedural) (postinfection)'),
    ('K5650', 'Intestnl adhesions, unsp as to partial versus complete obst'),
    ('K5651', 'Intestinal adhesions [bands], with partial obstruction'),
    ('K5652', 'Intestinal adhesions [bands] with complete obstruction'),
    ('K5660', 'Unspecified intestinal obstruction'),
    ('K56600', 'Partial intestinal obstruction, unspecified as to cause'),
    ('K56601', 'Complete intestinal obstruction, unspecified as to cause'),
    ('K56609', 'Unsp intestnl obst, unsp as to partial versus complete obst'),
    ('K5669', 'Other intestinal obstruction'),
    ('K56690', 'Other partial intestinal obstruction'),
    ('K56691', 'Other complete intestinal obstruction'),
    ('K56699', 'Other intestnl obst unsp as to partial versus complete obst'),
    ('K567', 'Ileus, unspecified'),
    ('K5700', 'Dvtrcli of sm int w perforation and abscess w/o bleeding'),
    ('K5701', 'Dvtrcli of sm int w perforation and abscess w bleeding'),
    ('K5710', 'Dvrtclos of sm int w/o perforation or abscess w/o bleeding'),
    ('K5711', 'Dvrtclos of sm int w/o perforation or abscess w bleeding'),
    ('K5712', 'Dvtrcli of sm int w/o perforation or abscess w/o bleeding'),
    ('K5713', 'Dvtrcli of sm int w/o perforation or abscess w bleeding'),
    ('K5720', 'Dvtrcli of lg int w perforation and abscess w/o bleeding'),
    ('K5721', 'Dvtrcli of lg int w perforation and abscess w bleeding'),
    ('K5730', 'Dvrtclos of lg int w/o perforation or abscess w/o bleeding'),
    ('K5731', 'Dvrtclos of lg int w/o perforation or abscess w bleeding'),
    ('K5732', 'Dvtrcli of lg int w/o perforation or abscess w/o bleeding'),
    ('K5733', 'Dvtrcli of lg int w/o perforation or abscess w bleeding'),
    ('K5740', 'Dvtrcli of both small and lg int w perf and abscs w/o bleed'),
    ('K5741', 'Dvtrcli of both small and lg int w perf and abscess w bleed'),
    ('K5750', 'Dvrtclos of both sm and lg int w/o perf or abscs w/o bleed'),
    ('K5751', 'Dvrtclos of both small and lg int w/o perf or abscs w bleed'),
    ('K5752', 'Dvtrcli of both small and lg int w/o perf or abscs w/o bleed'),
    ('K5753', 'Dvtrcli of both small and lg int w/o perf or abscess w bleed'),
    ('K5780', 'Dvtrcli of intest, part unsp, w perf and abscess w/o bleed'),
    ('K5781', 'Dvtrcli of intest, part unsp, w perf and abscess w bleeding'),
    ('K5790', 'Dvrtclos of intest, part unsp, w/o perf or abscess w/o bleed'),
    ('K5791', 'Dvrtclos of intest, part unsp, w/o perf or abscess w bleed'),
    ('K5792', 'Dvtrcli of intest, part unsp, w/o perf or abscess w/o bleed'),
    ('K5793', 'Dvtrcli of intest, part unsp, w/o perf or abscess w bleeding'),
    ('K580', 'Irritable bowel syndrome with diarrhea'),
    ('K581', 'Irritable bowel syndrome with constipation'),
    ('K582', 'Mixed irritable bowel syndrome'),
    ('K588', 'Other irritable bowel syndrome'),
    ('K589', 'Irritable bowel syndrome without diarrhea'),
    ('K5900', 'Constipation, unspecified'),
    ('K5901', 'Slow transit constipation'),
    ('K5902', 'Outlet dysfunction constipation'),
    ('K5903', 'Drug induced constipation'),
    ('K5904', 'Chronic idiopathic constipation'),
    ('K5909', 'Other constipation'),
    ('K591', 'Functional diarrhea'),
    ('K592', 'Neurogenic bowel, not elsewhere classified'),
    ('K593', 'Megacolon, not elsewhere classified'),
    ('K5931', 'Toxic megacolon'),
    ('K5939', 'Other megacolon'),
    ('K594', 'Anal spasm'),
    ('K598', 'Other specified functional intestinal disorders'),
    ('K5981 ', 'Ogilvie syndrome'),
    ('K5989', 'Other specified functional intestinal disorders'),
    ('K599', 'Functional intestinal disorder, unspecified'),
    ('K600', 'Acute anal fissure'),
    ('K601', 'Chronic anal fissure'),
    ('K602', 'Anal fissure, unspecified'),
    ('K603', 'Anal fistula'),
    ('K604', 'Rectal fistula'),
    ('K605', 'Anorectal fistula'),
    ('K610', 'Anal abscess'),
    ('K611', 'Rectal abscess'),
    ('K612', 'Anorectal abscess'),
    ('K613', 'Ischiorectal abscess'),
    ('K6131', 'Horseshoe abscess'),
    ('K6139', 'Other ischiorectal abscess'),
    ('K614', 'Intrasphincteric abscess'),
    ('K615', 'Supralevator abscess'),
    ('K620', 'Anal polyp'),
    ('K621', 'Rectal polyp'),
    ('K622', 'Anal prolapse'),
    ('K623', 'Rectal prolapse'),
    ('K624', 'Stenosis of anus and rectum'),
    ('K625', 'Hemorrhage of anus and rectum'),
    ('K626', 'Ulcer of anus and rectum'),
    ('K627', 'Radiation proctitis'),
    ('K6281', 'Anal sphincter tear (healed) (nontraumatic) (old)'),
    ('K6282', 'Dysplasia of anus'),
    ('K6289', 'Other specified diseases of anus and rectum'),
    ('K629', 'Disease of anus and rectum, unspecified'),
    ('K630', 'Abscess of intestine'),
    ('K631', 'Perforation of intestine (nontraumatic)'),
    ('K632', 'Fistula of intestine'),
    ('K633', 'Ulcer of intestine'),
    ('K634', 'Enteroptosis'),
    ('K635', 'Polyp of colon'),
    ('K6381', 'Dieulafoy lesion of intestine'),
    ('K638211', 'Small intestinal bacterial overgrowth, hydrogen-subtype'),
    ('K638212', 'Small intestnl bact overgrowth, hydrogen sulfide-subtype'),
    ('K638219', 'Small intestinal bacterial overgrowth, unspecified'),
    ('K63822', 'Small intestinal fungal overgrowth'),
    ('K63829', 'Intestinal methanogen overgrowth, unspecified'),
    ('K6389', 'Other specified diseases of intestine'),
    ('K639', 'Disease of intestine, unspecified'),
    ('K640', 'First degree hemorrhoids'),
    ('K641', 'Second degree hemorrhoids'),
    ('K642', 'Third degree hemorrhoids'),
    ('K643', 'Fourth degree hemorrhoids'),
    ('K644', 'Residual hemorrhoidal skin tags'),
    ('K645', 'Perianal venous thrombosis'),
    ('K648', 'Other hemorrhoids'),
    ('K649', 'Unspecified hemorrhoids'),
    ('K650', 'Generalized (acute) peritonitis'),
    ('K651', 'Peritoneal abscess'),
    ('K652', 'Spontaneous bacterial peritonitis'),
    ('K653', 'Choleperitonitis'),
    ('K654', 'Sclerosing mesenteritis'),
    ('K658', 'Other peritonitis'),
    ('K659', 'Peritonitis, unspecified'),
    ('K660', 'Peritoneal adhesions (postprocedural) (postinfection)'),
    ('K661', 'Hemoperitoneum'),
    ('K668', 'Other specified disorders of peritoneum'),
    ('K669', 'Disorder of peritoneum, unspecified'),
    ('K67', 'Disorders of peritoneum in infectious diseases classd elswhr'),
    ('K6811', 'Postprocedural retroperitoneal abscess'),
    ('K6812', 'Psoas muscle abscess'),
    ('K6819', 'Other retroperitoneal abscess'),
    ('K682', 'Retroperitoneal fibrosis'),
    ('K683', 'Retroperitoneal hematoma'),
    ('K689', 'Other disorders of retroperitoneum'),
    ('K700', 'Alcoholic fatty liver'),
    ('K7010', 'Alcoholic hepatitis without ascites'),
    ('K7011', 'Alcoholic hepatitis with ascites'),
    ('K702', 'Alcoholic fibrosis and sclerosis of liver'),
    ('K7030', 'Alcoholic cirrhosis of liver without ascites'),
    ('K7031', 'Alcoholic cirrhosis of liver with ascites'),
    ('K7040', 'Alcoholic hepatic failure without coma'),
    ('K7041', 'Alcoholic hepatic failure with coma'),
    ('K709', 'Alcoholic liver disease, unspecified'),
    ('K710', 'Toxic liver disease with cholestasis'),
    ('K7110', 'Toxic liver disease with hepatic necrosis, without coma'),
    ('K7111', 'Toxic liver disease with hepatic necrosis, with coma'),
    ('K712', 'Toxic liver disease with acute hepatitis'),
    ('K713', 'Toxic liver disease with chronic persistent hepatitis'),
    ('K714', 'Toxic liver disease with chronic lobular hepatitis'),
    ('K7150', 'Toxic liver disease w chronic active hepatitis w/o ascites'),
    ('K7151', 'Toxic liver disease w chronic active hepatitis with ascites'),
    ('K716', 'Toxic liver disease with hepatitis, not elsewhere classified'),
    ('K717', 'Toxic liver disease with fibrosis and cirrhosis of liver'),
    ('K718', 'Toxic liver disease with other disorders of liver'),
    ('K719', 'Toxic liver disease, unspecified'),
    ('K7200', 'Acute and subacute hepatic failure without coma'),
    ('K7201', 'Acute and subacute hepatic failure with coma'),
    ('K7210', 'Chronic hepatic failure without coma'),
    ('K7211', 'Chronic hepatic failure with coma'),
    ('K7290', 'Hepatic failure, unspecified without coma'),
    ('K7291', 'Hepatic failure, unspecified with coma'),
    ('K730', 'Chronic persistent hepatitis, not elsewhere classified'),
    ('K731', 'Chronic lobular hepatitis, not elsewhere classified'),
    ('K732', 'Chronic active hepatitis, not elsewhere classified'),
    ('K738', 'Other chronic hepatitis, not elsewhere classified'),
    ('K739', 'Chronic hepatitis, unspecified'),
    ('K740', 'Hepatic fibrosis'),
    ('K7400', 'Hepatic fibrosis, unspecified'),
    ('K7401', 'Hepatic fibrosis, early fibrosis'),
    ('K7402', 'Hepatic fibrosis, advanced fibrosis'),
    ('K741', 'Hepatic sclerosis'),
    ('K742', 'Hepatic fibrosis with hepatic sclerosis'),
    ('K743', 'Primary biliary cirrhosis'),
    ('K744', 'Secondary biliary cirrhosis'),
    ('K745', 'Biliary cirrhosis, unspecified'),
    ('K7460', 'Unspecified cirrhosis of liver'),
    ('K7469', 'Other cirrhosis of liver'),
    ('K750', 'Abscess of liver'),
    ('K751', 'Phlebitis of portal vein'),
    ('K752', 'Nonspecific reactive hepatitis'),
    ('K753', 'Granulomatous hepatitis, not elsewhere classified'),
    ('K754', 'Autoimmune hepatitis'),
    ('K7581', 'Nonalcoholic steatohepatitis (NASH)'),
    ('K7589', 'Other specified inflammatory liver diseases'),
    ('K759', 'Inflammatory liver disease, unspecified'),
    ('K760', 'Fatty (change of) liver, not elsewhere classified'),
    ('K761', 'Chronic passive congestion of liver'),
    ('K762', 'Central hemorrhagic necrosis of liver'),
    ('K763', 'Infarction of liver'),
    ('K764', 'Peliosis hepatis'),
    ('K765', 'Hepatic veno-occlusive disease'),
    ('K766', 'Portal hypertension'),
    ('K767', 'Hepatorenal syndrome'),
    ('K7681', 'Hepatopulmonary syndrome'),
    ('K7682', 'Hepatic encephalopathy'),
    ('K7689', 'Other specified diseases of liver'),
    ('K769', 'Liver disease, unspecified'),
    ('K77', 'Liver disorders in diseases classified elsewhere'),
    ('K8000', 'Calculus of gallbladder w acute cholecyst w/o obstruction'),
    ('K8001', 'Calculus of gallbladder w acute cholecystitis w obstruction'),
    ('K8010', 'Calculus of gallbladder w chronic cholecyst w/o obstruction'),
    ('K8011', 'Calculus of gallbladder w chronic cholecyst w obstruction'),
    ('K8012', 'Calculus of GB w acute and chronic cholecyst w/o obstruction'),
    ('K8013', 'Calculus of GB w acute and chronic cholecyst w obstruction'),
    ('K8018', 'Calculus of gallbladder w oth cholecystitis w/o obstruction'),
    ('K8019', 'Calculus of gallbladder w oth cholecystitis with obstruction'),
    ('K8020', 'Calculus of gallbladder w/o cholecystitis w/o obstruction'),
    ('K8021', 'Calculus of gallbladder w/o cholecystitis with obstruction'),
    ('K8030', 'Calculus of bile duct w cholangitis, unsp, w/o obstruction'),
    ('K8031', 'Calculus of bile duct w cholangitis, unsp, with obstruction'),
    ('K8032', 'Calculus of bile duct with acute cholangitis w/o obstruction'),
    ('K8033', 'Calculus of bile duct w acute cholangitis with obstruction'),
    ('K8034', 'Calculus of bile duct w chronic cholangitis w/o obstruction'),
    ('K8035', 'Calculus of bile duct w chronic cholangitis with obstruction'),
    ('K8036', 'Calculus of bile duct w acute and chr cholangitis w/o obst'),
    ('K8037', 'Calculus of bile duct w acute and chronic cholangitis w obst'),
    ('K8040', 'Calculus of bile duct w cholecystitis, unsp, w/o obstruction'),
    ('K8041', 'Calculus of bile duct w cholecystitis, unsp, w obstruction'),
    ('K8042', 'Calculus of bile duct w acute cholecystitis w/o obstruction'),
    ('K8043', 'Calculus of bile duct w acute cholecystitis with obstruction'),
    ('K8044', 'Calculus of bile duct w chronic cholecyst w/o obstruction'),
    ('K8045', 'Calculus of bile duct w chronic cholecystitis w obstruction'),
    ('K8046', 'Calculus of bile duct w acute and chronic cholecyst w/o obst'),
    ('K8047', 'Calculus of bile duct w acute and chronic cholecyst w obst'),
    ('K8050', 'Calculus of bile duct w/o cholangitis or cholecyst w/o obst'),
    ('K8051', 'Calculus of bile duct w/o cholangitis or cholecyst w obst'),
    ('K8060', 'Calculus of GB and bile duct w cholecyst, unsp, w/o obst'),
    ('K8061', 'Calculus of GB and bile duct w cholecyst, unsp, w obst'),
    ('K8062', 'Calculus of GB and bile duct w acute cholecyst w/o obst'),
    ('K8063', 'Calculus of GB and bile duct w acute cholecyst w obstruction'),
    ('K8064', 'Calculus of GB and bile duct w chronic cholecyst w/o obst'),
    ('K8065', 'Calculus of GB and bile duct w chronic cholecyst w obst'),
    ('K8066', 'Calculus of GB and bile duct w ac and chr cholecyst w/o obst'),
    ('K8067', 'Calculus of GB and bile duct w ac and chr cholecyst w obst'),
    ('K8070', 'Calculus of GB and bile duct w/o cholecyst w/o obstruction'),
    ('K8071', 'Calculus of GB and bile duct w/o cholecyst w obstruction'),
    ('K8080', 'Other cholelithiasis without obstruction'),
    ('K8081', 'Other cholelithiasis with obstruction'),
    ('K810', 'Acute cholecystitis'),
    ('K811', 'Chronic cholecystitis'),
    ('K812', 'Acute cholecystitis with chronic cholecystitis'),
    ('K819', 'Cholecystitis, unspecified'),
    ('K820', 'Obstruction of gallbladder'),
    ('K821', 'Hydrops of gallbladder'),
    ('K822', 'Perforation of gallbladder'),
    ('K823', 'Fistula of gallbladder'),
    ('K824', 'Cholesterolosis of gallbladder'),
    ('K828', 'Other specified diseases of gallbladder'),
    ('K829', 'Disease of gallbladder, unspecified'),
    ('K82A1', 'Gangrene of gallbladder in cholecystitis'),
    ('K82A2', 'Perforation of gallbladder in cholecystitis'),
    ('K830', 'Cholangitis'),
    ('K8301', 'Primary sclerosing cholangitis'),
    ('K8309', 'Other cholangitis'),
    ('K831', 'Obstruction of bile duct'),
    ('K832', 'Perforation of bile duct'),
    ('K833', 'Fistula of bile duct'),
    ('K834', 'Spasm of sphincter of Oddi'),
    ('K835', 'Biliary cyst'),
    ('K838', 'Other specified diseases of biliary tract'),
    ('K839', 'Disease of biliary tract, unspecified'),
    ('K850', 'Idiopathic acute pancreatitis'),
    ('K8500', 'Idiopathic acute pancreatitis without necrosis or infection'),
    ('K8501', 'Idiopathic acute pancreatitis with uninfected necrosis'),
    ('K8502', 'Idiopathic acute pancreatitis with infected necrosis'),
    ('K851', 'Biliary acute pancreatitis'),
    ('K8510', 'Biliary acute pancreatitis without necrosis or infection'),
    ('K8511', 'Biliary acute pancreatitis with uninfected necrosis'),
    ('K8512', 'Biliary acute pancreatitis with infected necrosis'),
    ('K852', 'Alcohol induced acute pancreatitis'),
    ('K8520', 'Alcohol induced acute pancreatitis without necrosis or infct'),
    ('K8521', 'Alcohol induced acute pancreatitis with uninfected necrosis'),
    ('K8522', 'Alcohol induced acute pancreatitis with infected necrosis'),
    ('K853', 'Drug induced acute pancreatitis'),
    ('K8530', 'Drug induced acute pancreatitis without necrosis or infct'),
    ('K8531', 'Drug induced acute pancreatitis with uninfected necrosis'),
    ('K8532', 'Drug induced acute pancreatitis with infected necrosis'),
    ('K858', 'Other acute pancreatitis'),
    ('K8580', 'Other acute pancreatitis without necrosis or infection'),
    ('K8581', 'Other acute pancreatitis with uninfected necrosis'),
    ('K8582', 'Other acute pancreatitis with infected necrosis'),
    ('K859', 'Acute pancreatitis, unspecified'),
    ('K8590', 'Acute pancreatitis without necrosis or infection, unsp'),
    ('K8591', 'Acute pancreatitis with uninfected necrosis, unspecified'),
    ('K8592', 'Acute pancreatitis with infected necrosis, unspecified'),
    ('K860', 'Alcohol-induced chronic pancreatitis'),
    ('K861', 'Other chronic pancreatitis'),
    ('K862', 'Cyst of pancreas'),
    ('K863', 'Pseudocyst of pancreas'),
    ('K868', 'Other specified diseases of pancreas'),
    ('K8681', 'Exocrine pancreatic insufficiency'),
    ('K8689', 'Other specified diseases of pancreas'),
    ('K869', 'Disease of pancreas, unspecified'),
    ('K87', 'Disord of GB, biliary trac and pancreas in dis classd elswhr'),
    ('K900', 'Celiac disease'),
    ('K901', 'Tropical sprue'),
    ('K902', 'Blind loop syndrome, not elsewhere classified'),
    ('K903', 'Pancreatic steatorrhea'),
    ('K904', 'Malabsorption due to intolerance, not elsewhere classified'),
    ('K9041', 'Non-celiac gluten sensitivity'),
    ('K9049', 'Malabsorption due to intolerance, not elsewhere classified'),
    ('K9081', "Whipple's disease"),
    ('K90821', 'Short bowel syndrome with colon in continuity'),
    ('K90822', 'Short bowel syndrome without colon in continuity'),
    ('K90829', 'Short bowel syndrome, unspecified'),
    ('K9083', 'Intestinal failure'),
    ('K9089', 'Other intestinal malabsorption'),
    ('K909', 'Intestinal malabsorption, unspecified'),
    ('K910', 'Vomiting following gastrointestinal surgery'),
    ('K911', 'Postgastric surgery syndromes'),
    ('K912', 'Postsurgical malabsorption, not elsewhere classified'),
    ('K913', 'Postprocedural intestinal obstruction'),
    ('K9130', 'Postproc intestinal obst, unsp as to partial versus complete'),
    ('K9131', 'Postprocedural partial intestinal obstruction'),
    ('K9132', 'Postprocedural complete intestinal obstruction'),
    ('K915', 'Postcholecystectomy syndrome'),
    ('K9161', 'Intraop hemor of dgstv sys org comp a dgstv sys proc'),
    ('K9162', 'Intraop hemor of a dgstv sys org comp oth procedure'),
    ('K9171', 'Accidental pnctr & lac of a dgstv sys org dur dgstv sys proc'),
    ('K9172', 'Acc pnctr & lac of a dgstv sys org during oth procedure'),
    ('K9181', 'Other intraoperative complications of digestive system'),
    ('K9182', 'Postprocedural hepatic failure'),
    ('K9183', 'Postprocedural hepatorenal syndrome'),
    ('K91840', 'Postproc hemor of dgstv sys org fol a dgstv sys proc'),
    ('K91841', 'Postproc hemor of a dgstv sys org fol oth procedure'),
    ('K91850', 'Pouchitis'),
    ('K91858', 'Other complications of intestinal pouch'),
    ('K9186', 'Retained cholelithiasis following cholecystectomy'),
    ('K91870', 'Postproc hematoma of a dgstv sys org fol a dgstv sys proc'),
    ('K91871', 'Postproc hematoma of a dgstv sys org fol other procedure'),
    ('K91872', 'Postproc seroma of a dgstv sys org fol a dgstv sys procedure'),
    ('K91873', 'Postproc seroma of a dgstv sys org following other procedure'),
    ('K9189', 'Oth postprocedural complications and disorders of dgstv sys'),
    ('K920', 'Hematemesis'),
    ('K921', 'Melena'),
    ('K922', 'Gastrointestinal hemorrhage, unspecified'),
    ('K9281', 'Gastrointestinal mucositis (ulcerative)'),
    ('K9289', 'Other specified diseases of the digestive system'),
    ('K929', 'Disease of digestive system, unspecified'),
    ('K9400', 'Colostomy complication, unspecified'),
    ('K9401', 'Colostomy hemorrhage'),
    ('K9402', 'Colostomy infection'),
    ('K9403', 'Colostomy malfunction'),
    ('K9409', 'Other complications of colostomy'),
    ('K9410', 'Enterostomy complication, unspecified'),
    ('K9411', 'Enterostomy hemorrhage'),
    ('K9412', 'Enterostomy infection'),
    ('K9413', 'Enterostomy malfunction'),
    ('K9419', 'Other complications of enterostomy'),
    ('K9420', 'Gastrostomy complication, unspecified'),
    ('K9421', 'Gastrostomy hemorrhage'),
    ('K9422', 'Gastrostomy infection'),
    ('K9423', 'Gastrostomy malfunction'),
    ('K9429', 'Other complications of gastrostomy'),
    ('K9430', 'Esophagostomy complications, unspecified'),
    ('K9431', 'Esophagostomy hemorrhage'),
    ('K9432', 'Esophagostomy infection'),
    ('K9433', 'Esophagostomy malfunction'),
    ('K9439', 'Other complications of esophagostomy'),
    ('K9501', 'Infection due to gastric band procedure'),
    ('K9509', 'Other complications of gastric band procedure'),
    ('K9581', 'Infection due to other bariatric procedure'),
    ('K9589', 'Other complications of other bariatric procedure'),
    ('L00', 'Staphylococcal scalded skin syndrome'),
    ('L0100', 'Impetigo, unspecified'),
    ('L0101', 'Non-bullous impetigo'),
    ('L0102', "Bockhart's impetigo"),
    ('L0103', 'Bullous impetigo'),
    ('L0109', 'Other impetigo'),
    ('L011', 'Impetiginization of other dermatoses'),
    ('L0201', 'Cutaneous abscess of face'),
    ('L0202', 'Furuncle of face'),
    ('L0203', 'Carbuncle of face'),
    ('L0211', 'Cutaneous abscess of neck'),
    ('L0212', 'Furuncle of neck'),
    ('L0213', 'Carbuncle of neck'),
    ('L02211', 'Cutaneous abscess of abdominal wall'),
    ('L02212', 'Cutaneous abscess of back [any part, except buttock]'),
    ('L02213', 'Cutaneous abscess of chest wall'),
    ('L02214', 'Cutaneous abscess of groin'),
    ('L02215', 'Cutaneous abscess of perineum'),
    ('L02216', 'Cutaneous abscess of umbilicus'),
    ('L02219', 'Cutaneous abscess of trunk, unspecified'),
    ('L02221', 'Furuncle of abdominal wall'),
    ('L02222', 'Furuncle of back [any part, except buttock]'),
    ('L02223', 'Furuncle of chest wall'),
    ('L02224', 'Furuncle of groin'),
    ('L02225', 'Furuncle of perineum'),
    ('L02226', 'Furuncle of umbilicus'),
    ('L02229', 'Furuncle of trunk, unspecified'),
    ('L02231', 'Carbuncle of abdominal wall'),
    ('L02232', 'Carbuncle of back [any part, except buttock]'),
    ('L02233', 'Carbuncle of chest wall'),
    ('L02234', 'Carbuncle of groin'),
    ('L02235', 'Carbuncle of perineum'),
    ('L02236', 'Carbuncle of umbilicus'),
    ('L02239', 'Carbuncle of trunk, unspecified'),
    ('L0231', 'Cutaneous abscess of buttock'),
    ('L0232', 'Furuncle of buttock'),
    ('L0233', 'Carbuncle of buttock'),
    ('L02411', 'Cutaneous abscess of right axilla'),
    ('L02412', 'Cutaneous abscess of left axilla'),
    ('L02413', 'Cutaneous abscess of right upper limb'),
    ('L02414', 'Cutaneous abscess of left upper limb'),
    ('L02415', 'Cutaneous abscess of right lower limb'),
    ('L02416', 'Cutaneous abscess of left lower limb'),
    ('L02419', 'Cutaneous abscess of limb, unspecified'),
    ('L02421', 'Furuncle of right axilla'),
    ('L02422', 'Furuncle of left axilla'),
    ('L02423', 'Furuncle of right upper limb'),
    ('L02424', 'Furuncle of left upper limb'),
    ('L02425', 'Furuncle of right lower limb'),
    ('L02426', 'Furuncle of left lower limb'),
    ('L02429', 'Furuncle of limb, unspecified'),
    ('L02431', 'Carbuncle of right axilla'),
    ('L02432', 'Carbuncle of left axilla'),
    ('L02433', 'Carbuncle of right upper limb'),
    ('L02434', 'Carbuncle of left upper limb'),
    ('L02435', 'Carbuncle of right lower limb'),
    ('L02436', 'Carbuncle of left lower limb'),
    ('L02439', 'Carbuncle of limb, unspecified'),
    ('L02511', 'Cutaneous abscess of right hand'),
    ('L02512', 'Cutaneous abscess of left hand'),
    ('L02519', 'Cutaneous abscess of unspecified hand'),
    ('L02521', 'Furuncle right hand'),
    ('L02522', 'Furuncle left hand'),
    ('L02529', 'Furuncle unspecified hand'),
    ('L02531', 'Carbuncle of right hand'),
    ('L02532', 'Carbuncle of left hand'),
    ('L02539', 'Carbuncle of unspecified hand'),
    ('L02611', 'Cutaneous abscess of right foot'),
    ('L02612', 'Cutaneous abscess of left foot'),
    ('L02619', 'Cutaneous abscess of unspecified foot'),
    ('L02621', 'Furuncle of right foot'),
    ('L02622', 'Furuncle of left foot'),
    ('L02629', 'Furuncle of unspecified foot'),
    ('L02631', 'Carbuncle of right foot'),
    ('L02632', 'Carbuncle of left foot'),
    ('L02639', 'Carbuncle of unspecified foot'),
    ('L02811', 'Cutaneous abscess of head [any part, except face]'),
    ('L02818', 'Cutaneous abscess of other sites'),
    ('L02821', 'Furuncle of head [any part, except face]'),
    ('L02828', 'Furuncle of other sites'),
    ('L02831', 'Carbuncle of head [any part, except face]'),
    ('L02838', 'Carbuncle of other sites'),
    ('L0291', 'Cutaneous abscess, unspecified'),
    ('L0292', 'Furuncle, unspecified'),
    ('L0293', 'Carbuncle, unspecified'),
    ('L03011', 'Cellulitis of right finger'),
    ('L03012', 'Cellulitis of left finger'),
    ('L03019', 'Cellulitis of unspecified finger'),
    ('L03021', 'Acute lymphangitis of right finger'),
    ('L03022', 'Acute lymphangitis of left finger'),
    ('L03029', 'Acute lymphangitis of unspecified finger'),
    ('L03031', 'Cellulitis of right toe'),
    ('L03032', 'Cellulitis of left toe'),
    ('L03039', 'Cellulitis of unspecified toe'),
    ('L03041', 'Acute lymphangitis of right toe'),
    ('L03042', 'Acute lymphangitis of left toe'),
    ('L03049', 'Acute lymphangitis of unspecified toe'),
    ('L03111', 'Cellulitis of right axilla'),
    ('L03112', 'Cellulitis of left axilla'),
    ('L03113', 'Cellulitis of right upper limb'),
    ('L03114', 'Cellulitis of left upper limb'),
    ('L03115', 'Cellulitis of right lower limb'),
    ('L03116', 'Cellulitis of left lower limb'),
    ('L03119', 'Cellulitis of unspecified part of limb'),
    ('L03121', 'Acute lymphangitis of right axilla'),
    ('L03122', 'Acute lymphangitis of left axilla'),
    ('L03123', 'Acute lymphangitis of right upper limb'),
    ('L03124', 'Acute lymphangitis of left upper limb'),
    ('L03125', 'Acute lymphangitis of right lower limb'),
    ('L03126', 'Acute lymphangitis of left lower limb'),
    ('L03129', 'Acute lymphangitis of unspecified part of limb'),
    ('L03211', 'Cellulitis of face'),
    ('L03212', 'Acute lymphangitis of face'),
    ('L03213', 'Periorbital cellulitis'),
    ('L03221', 'Cellulitis of neck'),
    ('L03222', 'Acute lymphangitis of neck'),
    ('L03311', 'Cellulitis of abdominal wall'),
    ('L03312', 'Cellulitis of back [any part except buttock]'),
    ('L03313', 'Cellulitis of chest wall'),
    ('L03314', 'Cellulitis of groin'),
    ('L03315', 'Cellulitis of perineum'),
    ('L03316', 'Cellulitis of umbilicus'),
    ('L03317', 'Cellulitis of buttock'),
    ('L03319', 'Cellulitis of trunk, unspecified'),
    ('L03321', 'Acute lymphangitis of abdominal wall'),
    ('L03322', 'Acute lymphangitis of back [any part except buttock]'),
    ('L03323', 'Acute lymphangitis of chest wall'),
    ('L03324', 'Acute lymphangitis of groin'),
    ('L03325', 'Acute lymphangitis of perineum'),
    ('L03326', 'Acute lymphangitis of umbilicus'),
    ('L03327', 'Acute lymphangitis of buttock'),
    ('L03329', 'Acute lymphangitis of trunk, unspecified'),
    ('L03811', 'Cellulitis of head [any part, except face]'),
    ('L03818', 'Cellulitis of other sites'),
    ('L03891', 'Acute lymphangitis of head [any part, except face]'),
    ('L03898', 'Acute lymphangitis of other sites'),
    ('L0390', 'Cellulitis, unspecified'),
    ('L0391', 'Acute lymphangitis, unspecified'),
    ('L040', 'Acute lymphadenitis of face, head and neck'),
    ('L041', 'Acute lymphadenitis of trunk'),
    ('L042', 'Acute lymphadenitis of upper limb'),
    ('L043', 'Acute lymphadenitis of lower limb'),
    ('L048', 'Acute lymphadenitis of other sites'),
    ('L049', 'Acute lymphadenitis, unspecified'),
    ('L0501', 'Pilonidal cyst with abscess'),
    ('L0502', 'Pilonidal sinus with abscess'),
    ('L0591', 'Pilonidal cyst without abscess'),
    ('L0592', 'Pilonidal sinus without abscess'),
    ('L080', 'Pyoderma'),
    ('L081', 'Erythrasma'),
    ('L0881', 'Pyoderma vegetans'),
    ('L0882', 'Omphalitis not of newborn'),
    ('L0889', 'Oth local infections of the skin and subcutaneous tissue'),
    ('L089', 'Local infection of the skin and subcutaneous tissue, unsp'),
    ('L100', 'Pemphigus vulgaris'),
    ('L101', 'Pemphigus vegetans'),
    ('L102', 'Pemphigus foliaceous'),
    ('L103', 'Brazilian pemphigus [fogo selvagem]'),
    ('L104', 'Pemphigus erythematosus'),
    ('L105', 'Drug-induced pemphigus'),
    ('L1081', 'Paraneoplastic pemphigus'),
    ('L1089', 'Other pemphigus'),
    ('L109', 'Pemphigus, unspecified'),
    ('L110', 'Acquired keratosis follicularis'),
    ('L111', 'Transient acantholytic dermatosis [Grover]'),
    ('L118', 'Other specified acantholytic disorders'),
    ('L119', 'Acantholytic disorder, unspecified'),
    ('L120', 'Bullous pemphigoid'),
    ('L121', 'Cicatricial pemphigoid'),
    ('L122', 'Chronic bullous disease of childhood'),
    ('L1230', 'Acquired epidermolysis bullosa, unspecified'),
    ('L1231', 'Epidermolysis bullosa due to drug'),
    ('L1235', 'Other acquired epidermolysis bullosa'),
    ('L128', 'Other pemphigoid'),
    ('L129', 'Pemphigoid, unspecified'),
    ('L130', 'Dermatitis herpetiformis'),
    ('L131', 'Subcorneal pustular dermatitis'),
    ('L138', 'Other specified bullous disorders'),
    ('L139', 'Bullous disorder, unspecified'),
    ('L14', 'Bullous disorders in diseases classified elsewhere'),
    ('L200', "Besnier's prurigo"),
    ('L2081', 'Atopic neurodermatitis'),
    ('L2082', 'Flexural eczema'),
    ('L2083', 'Infantile (acute) (chronic) eczema'),
    ('L2084', 'Intrinsic (allergic) eczema'),
    ('L2089', 'Other atopic dermatitis'),
    ('L209', 'Atopic dermatitis, unspecified'),
    ('L210', 'Seborrhea capitis'),
    ('L211', 'Seborrheic infantile dermatitis'),
    ('L218', 'Other seborrheic dermatitis'),
    ('L219', 'Seborrheic dermatitis, unspecified'),
    ('L22', 'Diaper dermatitis'),
    ('L230', 'Allergic contact dermatitis due to metals'),
    ('L231', 'Allergic contact dermatitis due to adhesives'),
    ('L232', 'Allergic contact dermatitis due to cosmetics'),
    ('L233', 'Allergic contact dermatitis due to drugs in contact w skin'),
    ('L234', 'Allergic contact dermatitis due to dyes'),
    ('L235', 'Allergic contact dermatitis due to other chemical products'),
    ('L236', 'Allergic contact dermatitis due to food in contact w skin'),
    ('L237', 'Allergic contact dermatitis due to plants, except food'),
    ('L2381', 'Allergic contact dermatitis due to animal (cat) (dog) dander'),
    ('L2389', 'Allergic contact dermatitis due to other agents'),
    ('L239', 'Allergic contact dermatitis, unspecified cause'),
    ('L240', 'Irritant contact dermatitis due to detergents'),
    ('L241', 'Irritant contact dermatitis due to oils and greases'),
    ('L242', 'Irritant contact dermatitis due to solvents'),
    ('L243', 'Irritant contact dermatitis due to cosmetics'),
    ('L244', 'Irritant contact dermatitis due to drugs in contact w skin'),
    ('L245', 'Irritant contact dermatitis due to other chemical products'),
    ('L246', 'Irritant contact dermatitis due to food in contact with skin'),
    ('L247', 'Irritant contact dermatitis due to plants, except food'),
    ('L2481', 'Irritant contact dermatitis due to metals'),
    ('L2489', 'Irritant contact dermatitis due to other agents'),
    ('L249', 'Irritant contact dermatitis, unspecified cause'),
    ('L24A0 ', 'Irritant cntct derm d/t friction or cntct w body fluids,unsp'),
    ('L24A1', 'Irritant contact dermatitis due to saliva'),
    ('L24A2', 'Irritant cntct derm d/t fecal, urinry or dual incontinence'),
    ('L24A9', 'Irritant cntct derm due friction or cntct w oth body fluids'),
    ('L24B0', 'Irritant contact dermatitis related to unsp stoma or fistula'),
    ('L24B1', 'Irritant contact derm related to digestive stoma or fistula'),
    ('L24B2 ', 'Irritant contact dermatitis related to resp stoma or fistula'),
    ('L24B3 ', 'Irritant cntct derm rel to fecal or urinary stoma or fistula'),
    ('L250', 'Unspecified contact dermatitis due to cosmetics'),
    ('L251', 'Unsp contact dermatitis due to drugs in contact with skin'),
    ('L252', 'Unspecified contact dermatitis due to dyes'),
    ('L253', 'Unsp contact dermatitis due to other chemical products'),
    ('L254', 'Unsp contact dermatitis due to food in contact with skin'),
    ('L255', 'Unspecified contact dermatitis due to plants, except food'),
    ('L258', 'Unspecified contact dermatitis due to other agents'),
    ('L259', 'Unspecified contact dermatitis, unspecified cause'),
    ('L26', 'Exfoliative dermatitis'),
    ('L270', 'Gen skin eruption due to drugs and meds taken internally'),
    ('L271', 'Loc skin eruption due to drugs and meds taken internally'),
    ('L272', 'Dermatitis due to ingested food'),
    ('L278', 'Dermatitis due to other substances taken internally'),
    ('L279', 'Dermatitis due to unspecified substance taken internally'),
    ('L280', 'Lichen simplex chronicus'),
    ('L281', 'Prurigo nodularis'),
    ('L282', 'Other prurigo'),
    ('L290', 'Pruritus ani'),
    ('L291', 'Pruritus scroti'),
    ('L292', 'Pruritus vulvae'),
    ('L293', 'Anogenital pruritus, unspecified'),
    ('L298', 'Other pruritus'),
    ('L299', 'Pruritus, unspecified'),
    ('L300', 'Nummular dermatitis'),
    ('L301', 'Dyshidrosis [pompholyx]'),
    ('L302', 'Cutaneous autosensitization'),
    ('L303', 'Infective dermatitis'),
    ('L304', 'Erythema intertrigo'),
    ('L305', 'Pityriasis alba'),
    ('L308', 'Other specified dermatitis'),
    ('L309', 'Dermatitis, unspecified'),
    ('L400', 'Psoriasis vulgaris'),
    ('L401', 'Generalized pustular psoriasis'),
    ('L402', 'Acrodermatitis continua'),
    ('L403', 'Pustulosis palmaris et plantaris'),
    ('L404', 'Guttate psoriasis'),
    ('L4050', 'Arthropathic psoriasis, unspecified'),
    ('L4051', 'Distal interphalangeal psoriatic arthropathy'),
    ('L4052', 'Psoriatic arthritis mutilans'),
    ('L4053', 'Psoriatic spondylitis'),
    ('L4054', 'Psoriatic juvenile arthropathy'),
    ('L4059', 'Other psoriatic arthropathy'),
    ('L408', 'Other psoriasis'),
    ('L409', 'Psoriasis, unspecified'),
    ('L410', 'Pityriasis lichenoides et varioliformis acuta'),
    ('L411', 'Pityriasis lichenoides chronica'),
    ('L413', 'Small plaque parapsoriasis'),
    ('L414', 'Large plaque parapsoriasis'),
    ('L415', 'Retiform parapsoriasis'),
    ('L418', 'Other parapsoriasis'),
    ('L419', 'Parapsoriasis, unspecified'),
    ('L42', 'Pityriasis rosea'),
    ('L430', 'Hypertrophic lichen planus'),
    ('L431', 'Bullous lichen planus'),
    ('L432', 'Lichenoid drug reaction'),
    ('L433', 'Subacute (active) lichen planus'),
    ('L438', 'Other lichen planus'),
    ('L439', 'Lichen planus, unspecified'),
    ('L440', 'Pityriasis rubra pilaris'),
    ('L441', 'Lichen nitidus'),
    ('L442', 'Lichen striatus'),
    ('L443', 'Lichen ruber moniliformis'),
    ('L444', 'Infantile papular acrodermatitis [Gianotti-Crosti]'),
    ('L448', 'Other specified papulosquamous disorders'),
    ('L449', 'Papulosquamous disorder, unspecified'),
    ('L45', 'Papulosquamous disorders in diseases classified elsewhere'),
    ('L490', 'Exfoliatn due to erythemat cond w < 10 pct of body surface'),
    ('L491', 'Exfoliatn due to erythemat cond w 10-19 pct of body surface'),
    ('L492', 'Exfoliatn due to erythemat cond w 20-29 pct of body surface'),
    ('L493', 'Exfoliatn due to erythemat cond w 30-39 pct of body surface'),
    ('L494', 'Exfoliatn due to erythemat cond w 40-49 pct of body surface'),
    ('L495', 'Exfoliatn due to erythemat cond w 50-59 pct of body surface'),
    ('L496', 'Exfoliatn due to erythemat cond w 60-69 pct of body surface'),
    ('L497', 'Exfoliatn due to erythemat cond w 70-79 pct of body surface'),
    ('L498', 'Exfoliatn due to erythemat cond w 80-89 pct of body surface'),
    ('L499', 'Exfoliatn d/t erythemat cond w 90 or more pct of body surfc'),
    ('L500', 'Allergic urticaria'),
    ('L501', 'Idiopathic urticaria'),
    ('L502', 'Urticaria due to cold and heat'),
    ('L503', 'Dermatographic urticaria'),
    ('L504', 'Vibratory urticaria'),
    ('L505', 'Cholinergic urticaria'),
    ('L506', 'Contact urticaria'),
    ('L508', 'Other urticaria'),
    ('L509', 'Urticaria, unspecified'),
    ('L510', 'Nonbullous erythema multiforme'),
    ('L511', 'Stevens-Johnson syndrome'),
    ('L512', 'Toxic epidermal necrolysis [Lyell]'),
    ('L513', 'Stevens-Johnson synd-tox epdrml necrolysis overlap syndrome'),
    ('L518', 'Other erythema multiforme'),
    ('L519', 'Erythema multiforme, unspecified'),
    ('L52', 'Erythema nodosum'),
    ('L530', 'Toxic erythema'),
    ('L531', 'Erythema annulare centrifugum'),
    ('L532', 'Erythema marginatum'),
    ('L533', 'Other chronic figurate erythema'),
    ('L538', 'Other specified erythematous conditions'),
    ('L539', 'Erythematous condition, unspecified'),
    ('L54', 'Erythema in diseases classified elsewhere'),
    ('L550', 'Sunburn of first degree'),
    ('L551', 'Sunburn of second degree'),
    ('L552', 'Sunburn of third degree'),
    ('L559', 'Sunburn, unspecified'),
    ('L560', 'Drug phototoxic response'),
    ('L561', 'Drug photoallergic response'),
    ('L562', 'Photocontact dermatitis [berloque dermatitis]'),
    ('L563', 'Solar urticaria'),
    ('L564', 'Polymorphous light eruption'),
    ('L565', 'Disseminated superficial actinic porokeratosis (DSAP)'),
    ('L568', 'Oth acute skin changes due to ultraviolet radiation'),
    ('L569', 'Acute skin change due to ultraviolet radiation, unspecified'),
    ('L570', 'Actinic keratosis'),
    ('L571', 'Actinic reticuloid'),
    ('L572', 'Cutis rhomboidalis nuchae'),
    ('L573', 'Poikiloderma of Civatte'),
    ('L574', 'Cutis laxa senilis'),
    ('L575', 'Actinic granuloma'),
    ('L578', 'Oth skin changes due to chr expsr to nonionizing radiation'),
    ('L579', 'Skin changes due to chr expsr to nonionizing radiation, unsp'),
    ('L580', 'Acute radiodermatitis'),
    ('L581', 'Chronic radiodermatitis'),
    ('L589', 'Radiodermatitis, unspecified'),
    ('L590', 'Erythema ab igne [dermatitis ab igne]'),
    ('L598', 'Oth disrd of the skin, subcu related to radiation'),
    ('L599', 'Disorder of the skin, subcu related to radiation, unsp'),
    ('L600', 'Ingrowing nail'),
    ('L601', 'Onycholysis'),
    ('L602', 'Onychogryphosis'),
    ('L603', 'Nail dystrophy'),
    ('L604', "Beau's lines"),
    ('L605', 'Yellow nail syndrome'),
    ('L608', 'Other nail disorders'),
    ('L609', 'Nail disorder, unspecified'),
    ('L62', 'Nail disorders in diseases classified elsewhere'),
    ('L630', 'Alopecia (capitis) totalis'),
    ('L631', 'Alopecia universalis'),
    ('L632', 'Ophiasis'),
    ('L638', 'Other alopecia areata'),
    ('L639', 'Alopecia areata, unspecified'),
    ('L640', 'Drug-induced androgenic alopecia'),
    ('L648', 'Other androgenic alopecia'),
    ('L649', 'Androgenic alopecia, unspecified'),
    ('L650', 'Telogen effluvium'),
    ('L651', 'Anagen effluvium'),
    ('L652', 'Alopecia mucinosa'),
    ('L658', 'Other specified nonscarring hair loss'),
    ('L659', 'Nonscarring hair loss, unspecified'),
    ('L660', 'Pseudopelade'),
    ('L661', 'Lichen planopilaris'),
    ('L662', 'Folliculitis decalvans'),
    ('L663', 'Perifolliculitis capitis abscedens'),
    ('L664', 'Folliculitis ulerythematosa reticulata'),
    ('L668', 'Other cicatricial alopecia'),
    ('L669', 'Cicatricial alopecia, unspecified'),
    ('L670', 'Trichorrhexis nodosa'),
    ('L671', 'Variations in hair color'),
    ('L678', 'Other hair color and hair shaft abnormalities'),
    ('L679', 'Hair color and hair shaft abnormality, unspecified'),
    ('L680', 'Hirsutism'),
    ('L681', 'Acquired hypertrichosis lanuginosa'),
    ('L682', 'Localized hypertrichosis'),
    ('L683', 'Polytrichia'),
    ('L688', 'Other hypertrichosis'),
    ('L689', 'Hypertrichosis, unspecified'),
    ('L700', 'Acne vulgaris'),
    ('L701', 'Acne conglobata'),
    ('L702', 'Acne varioliformis'),
    ('L703', 'Acne tropica'),
    ('L704', 'Infantile acne'),
    ('L705', 'Acne excoriee'),
    ('L708', 'Other acne'),
    ('L709', 'Acne, unspecified'),
    ('L710', 'Perioral dermatitis'),
    ('L711', 'Rhinophyma'),
    ('L718', 'Other rosacea'),
    ('L719', 'Rosacea, unspecified'),
    ('L720', 'Epidermal cyst'),
    ('L7211', 'Pilar cyst'),
    ('L7212', 'Trichodermal cyst'),
    ('L722', 'Steatocystoma multiplex'),
    ('L723', 'Sebaceous cyst'),
    ('L728', 'Other follicular cysts of the skin and subcutaneous tissue'),
    ('L729', 'Follicular cyst of the skin and subcutaneous tissue, unsp'),
    ('L730', 'Acne keloid'),
    ('L731', 'Pseudofolliculitis barbae'),
    ('L732', 'Hidradenitis suppurativa'),
    ('L738', 'Other specified follicular disorders'),
    ('L739', 'Follicular disorder, unspecified'),
    ('L740', 'Miliaria rubra'),
    ('L741', 'Miliaria crystallina'),
    ('L742', 'Miliaria profunda'),
    ('L743', 'Miliaria, unspecified'),
    ('L744', 'Anhidrosis'),
    ('L74510', 'Primary focal hyperhidrosis, axilla'),
    ('L74511', 'Primary focal hyperhidrosis, face'),
    ('L74512', 'Primary focal hyperhidrosis, palms'),
    ('L74513', 'Primary focal hyperhidrosis, soles'),
    ('L74519', 'Primary focal hyperhidrosis, unspecified'),
    ('L7452', 'Secondary focal hyperhidrosis'),
    ('L748', 'Other eccrine sweat disorders'),
    ('L749', 'Eccrine sweat disorder, unspecified'),
    ('L750', 'Bromhidrosis'),
    ('L751', 'Chromhidrosis'),
    ('L752', 'Apocrine miliaria'),
    ('L758', 'Other apocrine sweat disorders'),
    ('L759', 'Apocrine sweat disorder, unspecified'),
    ('L7601', 'Intraop hemor/hemtom of skin, subcu comp a dermatologic proc'),
    ('L7602', 'Intraop hemor/hemtom of skin, subcu comp oth procedure'),
    ('L7611', 'Acc pnctr & lac of skin, subcu during a dermatologic proc'),
    ('L7612', 'Accidental pnctr & lac of skin, subcu during oth procedure'),
    ('L7621', 'Postproc hemor of skin, subcu fol a dermatologic proc'),
    ('L7622', 'Postproc hemor of skin, subcu following oth procedure'),
    ('L7631', 'Postproc hematoma of skin, subcu fol a dermatologic proc'),
    ('L7632', 'Postproc hematoma of skin, subcu following other procedure'),
    ('L7633', 'Postproc seroma of skin, subcu fol a dermatologic procedure'),
    ('L7634', 'Postproc seroma of skin, subcu following other procedure'),
    ('L7681', 'Oth intraoperative complications of skin, subcu'),
    ('L7682', 'Oth postprocedural complications of skin, subcu'),
    ('L80', 'Vitiligo'),
    ('L810', 'Postinflammatory hyperpigmentation'),
    ('L811', 'Chloasma'),
    ('L812', 'Freckles'),
    ('L813', 'Cafe au lait spots'),
    ('L814', 'Other melanin hyperpigmentation'),
    ('L815', 'Leukoderma, not elsewhere classified'),
    ('L816', 'Other disorders of diminished melanin formation'),
    ('L817', 'Pigmented purpuric dermatosis'),
    ('L818', 'Other specified disorders of pigmentation'),
    ('L819', 'Disorder of pigmentation, unspecified'),
    ('L820', 'Inflamed seborrheic keratosis'),
    ('L821', 'Other seborrheic keratosis'),
    ('L83', 'Acanthosis nigricans'),
    ('L84', 'Corns and callosities'),
    ('L850', 'Acquired ichthyosis'),
    ('L851', 'Acquired keratosis [keratoderma] palmaris et plantaris'),
    ('L852', 'Keratosis punctata (palmaris et plantaris)'),
    ('L853', 'Xerosis cutis'),
    ('L858', 'Other specified epidermal thickening'),
    ('L859', 'Epidermal thickening, unspecified'),
    ('L86', 'Keratoderma in diseases classified elsewhere'),
    ('L870', 'Keratos follicularis et parafollicularis in cutem penetrans'),
    ('L871', 'Reactive perforating collagenosis'),
    ('L872', 'Elastosis perforans serpiginosa'),
    ('L878', 'Other transepidermal elimination disorders'),
    ('L879', 'Transepidermal elimination disorder, unspecified'),
    ('L88', 'Pyoderma gangrenosum'),
    ('L89000', 'Pressure ulcer of unspecified elbow, unstageable'),
    ('L89001', 'Pressure ulcer of unspecified elbow, stage 1'),
    ('L89002', 'Pressure ulcer of unspecified elbow, stage 2'),
    ('L89003', 'Pressure ulcer of unspecified elbow, stage 3'),
    ('L89004', 'Pressure ulcer of unspecified elbow, stage 4'),
    ('L89006', 'Pressure-induced deep tissue damage of unspecified elbow'),
    ('L89009', 'Pressure ulcer of unspecified elbow, unspecified stage'),
    ('L89010', 'Pressure ulcer of right elbow, unstageable'),
    ('L89011', 'Pressure ulcer of right elbow, stage 1'),
    ('L89012', 'Pressure ulcer of right elbow, stage 2'),
    ('L89013', 'Pressure ulcer of right elbow, stage 3'),
    ('L89014', 'Pressure ulcer of right elbow, stage 4'),
    ('L89016', 'Pressure-induced deep tissue damage of right elbow'),
    ('L89019', 'Pressure ulcer of right elbow, unspecified stage'),
    ('L89020', 'Pressure ulcer of left elbow, unstageable'),
    ('L89021', 'Pressure ulcer of left elbow, stage 1'),
    ('L89022', 'Pressure ulcer of left elbow, stage 2'),
    ('L89023', 'Pressure ulcer of left elbow, stage 3'),
    ('L89024', 'Pressure ulcer of left elbow, stage 4'),
    ('L89026', 'Pressure-induced deep tissue damage of left elbow'),
    ('L89029', 'Pressure ulcer of left elbow, unspecified stage'),
    ('L89100', 'Pressure ulcer of unspecified part of back, unstageable'),
    ('L89101', 'Pressure ulcer of unspecified part of back, stage 1'),
    ('L89102', 'Pressure ulcer of unspecified part of back, stage 2'),
    ('L89103', 'Pressure ulcer of unspecified part of back, stage 3'),
    ('L89104', 'Pressure ulcer of unspecified part of back, stage 4'),
    ('L89106', 'Pressr-induc deep tissue damage of unspecified part of back'),
    ('L89109', 'Pressure ulcer of unspecified part of back, unspecified stage'),
    ('L89110', 'Pressure ulcer of right upper back, unstageable'),
    ('L89111', 'Pressure ulcer of right upper back, stage 1'),
    ('L89112', 'Pressure ulcer of right upper back, stage 2'),
    ('L89113', 'Pressure ulcer of right upper back, stage 3'),
    ('L89114', 'Pressure ulcer of right upper back, stage 4'),
    ('L89116', 'Pressure-induced deep tissue damage of right upper back'),
    ('L89119', 'Pressure ulcer of right upper back, unspecified stage'),
    ('L89120', 'Pressure ulcer of left upper back, unstageable'),
    ('L89121', 'Pressure ulcer of left upper back, stage 1'),
    ('L89122', 'Pressure ulcer of left upper back, stage 2'),
    ('L89123', 'Pressure ulcer of left upper back, stage 3'),
    ('L89124', 'Pressure ulcer of left upper back, stage 4'),
    ('L89126', 'Pressure-induced deep tissue damage of left upper back'),
    ('L89129', 'Pressure ulcer of left upper back, unspecified stage'),
    ('L89130', 'Pressure ulcer of right lower back, unstageable'),
    ('L89131', 'Pressure ulcer of right lower back, stage 1'),
    ('L89132', 'Pressure ulcer of right lower back, stage 2'),
    ('L89133', 'Pressure ulcer of right lower back, stage 3'),
    ('L89134', 'Pressure ulcer of right lower back, stage 4'),
    ('L89136', 'Pressure-induced deep tissue damage of right lower back'),
    ('L89139', 'Pressure ulcer of right lower back, unspecified stage'),
    ('L89140', 'Pressure ulcer of left lower back, unstageable'),
    ('L89141', 'Pressure ulcer of left lower back, stage 1'),
    ('L89142', 'Pressure ulcer of left lower back, stage 2'),
    ('L89143', 'Pressure ulcer of left lower back, stage 3'),
    ('L89144', 'Pressure ulcer of left lower back, stage 4'),
    ('L89146', 'Pressure-induced deep tissue damage of left lower back'),
    ('L89149', 'Pressure ulcer of left lower back, unspecified stage'),
    ('L89150', 'Pressure ulcer of sacral region, unstageable'),
    ('L89151', 'Pressure ulcer of sacral region, stage 1'),
    ('L89152', 'Pressure ulcer of sacral region, stage 2'),
    ('L89153', 'Pressure ulcer of sacral region, stage 3'),
    ('L89154', 'Pressure ulcer of sacral region, stage 4'),
    ('L89156', 'Pressure-induced deep tissue damage of sacral region'),
    ('L89159', 'Pressure ulcer of sacral region, unspecified stage'),
    ('L89200', 'Pressure ulcer of unspecified hip, unstageable'),
    ('L89201', 'Pressure ulcer of unspecified hip, stage 1'),
    ('L89202', 'Pressure ulcer of unspecified hip, stage 2'),
    ('L89203', 'Pressure ulcer of unspecified hip, stage 3'),
    ('L89204', 'Pressure ulcer of unspecified hip, stage 4'),
    ('L89206', 'Pressure-induced deep tissue damage of unspecified hip'),
    ('L89209', 'Pressure ulcer of unspecified hip, unspecified stage'),
    ('L89210', 'Pressure ulcer of right hip, unstageable'),
    ('L89211', 'Pressure ulcer of right hip, stage 1'),
    ('L89212', 'Pressure ulcer of right hip, stage 2'),
    ('L89213', 'Pressure ulcer of right hip, stage 3'),
    ('L89214', 'Pressure ulcer of right hip, stage 4'),
    ('L89216', 'Pressure-induced deep tissue damage of right hip'),
    ('L89219', 'Pressure ulcer of right hip, unspecified stage'),
    ('L89220', 'Pressure ulcer of left hip, unstageable'),
    ('L89221', 'Pressure ulcer of left hip, stage 1'),
    ('L89222', 'Pressure ulcer of left hip, stage 2'),
    ('L89223', 'Pressure ulcer of left hip, stage 3'),
    ('L89224', 'Pressure ulcer of left hip, stage 4'),
    ('L89226', 'Pressure-induced deep tissue damage of left hip'),
    ('L89229', 'Pressure ulcer of left hip, unspecified stage'),
    ('L89300', 'Pressure ulcer of unspecified buttock, unstageable'),
    ('L89301', 'Pressure ulcer of unspecified buttock, stage 1'),
    ('L89302', 'Pressure ulcer of unspecified buttock, stage 2'),
    ('L89303', 'Pressure ulcer of unspecified buttock, stage 3'),
    ('L89304', 'Pressure ulcer of unspecified buttock, stage 4'),
    ('L89306', 'Pressure-induced deep tissue damage of unspecified buttock'),
    ('L89309', 'Pressure ulcer of unspecified buttock, unspecified stage'),
    ('L89310', 'Pressure ulcer of right buttock, unstageable'),
    ('L89311', 'Pressure ulcer of right buttock, stage 1'),
    ('L89312', 'Pressure ulcer of right buttock, stage 2'),
    ('L89313', 'Pressure ulcer of right buttock, stage 3'),
    ('L89314', 'Pressure ulcer of right buttock, stage 4'),
    ('L89316', 'Pressure-induced deep tissue damage of right buttock'),
    ('L89319', 'Pressure ulcer of right buttock, unspecified stage'),
    ('L89320', 'Pressure ulcer of left buttock, unstageable'),
    ('L89321', 'Pressure ulcer of left buttock, stage 1'),
    ('L89322', 'Pressure ulcer of left buttock, stage 2'),
    ('L89323', 'Pressure ulcer of left buttock, stage 3'),
    ('L89324', 'Pressure ulcer of left buttock, stage 4'),
    ('L89326', 'Pressure-induced deep tissue damage of left buttock'),
    ('L89329', 'Pressure ulcer of left buttock, unspecified stage'),
    ('L8940', 'Pressr ulc of contig site of back, buttock and hip, unsp stg'),
    ('L8941', 'Pressr ulc of contig site of back, buttock and hip, stg 1'),
    ('L8942', 'Pressr ulc of contig site of back, buttock and hip, stg 2'),
    ('L8943', 'Pressr ulc of contig site of back, buttock and hip, stg 3'),
    ('L8944', 'Pressr ulc of contig site of back, buttock and hip, stg 4'),
    ('L8945', 'Pressr ulc of contig site of back, buttock and hip, unstageable'),
    ('L8946', 'Pressr-induc dp tiss damag of contig site of back, butt & hp'),
    ('L89500', 'Pressure ulcer of unspecified ankle, unstageable'),
    ('L89501', 'Pressure ulcer of unspecified ankle, stage 1'),
    ('L89502', 'Pressure ulcer of unspecified ankle, stage 2'),
    ('L89503', 'Pressure ulcer of unspecified ankle, stage 3'),
    ('L89504', 'Pressure ulcer of unspecified ankle, stage 4'),
    ('L89506', 'Pressure-induced deep tissue damage of unspecified ankle'),
    ('L89509', 'Pressure ulcer of unspecified ankle, unspecified stage'),
    ('L89510', 'Pressure ulcer of right ankle, unstageable'),
    ('L89511', 'Pressure ulcer of right ankle, stage 1'),
    ('L89512', 'Pressure ulcer of right ankle, stage 2'),
    ('L89513', 'Pressure ulcer of right ankle, stage 3'),
    ('L89514', 'Pressure ulcer of right ankle, stage 4'),
    ('L89516', 'Pressure-induced deep tissue damage of right ankle'),
    ('L89519', 'Pressure ulcer of right ankle, unspecified stage'),
    ('L89520', 'Pressure ulcer of left ankle, unstageable'),
    ('L89521', 'Pressure ulcer of left ankle, stage 1'),
    ('L89522', 'Pressure ulcer of left ankle, stage 2'),
    ('L89523', 'Pressure ulcer of left ankle, stage 3'),
    ('L89524', 'Pressure ulcer of left ankle, stage 4'),
    ('L89526', 'Pressure-induced deep tissue damage of left ankle'),
    ('L89529', 'Pressure ulcer of left ankle, unspecified stage'),
    ('L89600', 'Pressure ulcer of unspecified heel, unstageable'),
    ('L89601', 'Pressure ulcer of unspecified heel, stage 1'),
    ('L89602', 'Pressure ulcer of unspecified heel, stage 2'),
    ('L89603', 'Pressure ulcer of unspecified heel, stage 3'),
    ('L89604', 'Pressure ulcer of unspecified heel, stage 4'),
    ('L89606', 'Pressure-induced deep tissue damage of unspecified heel'),
    ('L89609', 'Pressure ulcer of unspecified heel, unspecified stage'),
    ('L89610', 'Pressure ulcer of right heel, unstageable'),
    ('L89611', 'Pressure ulcer of right heel, stage 1'),
    ('L89612', 'Pressure ulcer of right heel, stage 2'),
    ('L89613', 'Pressure ulcer of right heel, stage 3'),
    ('L89614', 'Pressure ulcer of right heel, stage 4'),
    ('L89616', 'Pressure-induced deep tissue damage of right heel'),
    ('L89619', 'Pressure ulcer of right heel, unspecified stage'),
    ('L89620', 'Pressure ulcer of left heel, unstageable'),
    ('L89621', 'Pressure ulcer of left heel, stage 1'),
    ('L89622', 'Pressure ulcer of left heel, stage 2'),
    ('L89623', 'Pressure ulcer of left heel, stage 3'),
    ('L89624', 'Pressure ulcer of left heel, stage 4'),
    ('L89626', 'Pressure-induced deep tissue damage of left heel'),
    ('L89629', 'Pressure ulcer of left heel, unspecified stage'),
    ('L89810', 'Pressure ulcer of head, unstageable'),
    ('L89811', 'Pressure ulcer of head, stage 1'),
    ('L89812', 'Pressure ulcer of head, stage 2'),
    ('L89813', 'Pressure ulcer of head, stage 3'),
    ('L89814', 'Pressure ulcer of head, stage 4'),
    ('L89816', 'Pressure-induced deep tissue damage of head'),
    ('L89819', 'Pressure ulcer of head, unspecified stage'),
    ('L89890', 'Pressure ulcer of other site, unstageable'),
    ('L89891', 'Pressure ulcer of other site, stage 1'),
    ('L89892', 'Pressure ulcer of other site, stage 2'),
    ('L89893', 'Pressure ulcer of other site, stage 3'),
    ('L89894', 'Pressure ulcer of other site, stage 4'),
    ('L89896', 'Pressure-induced deep tissue damage of other site'),
    ('L89899', 'Pressure ulcer of other site, unspecified stage'),
    ('L8990', 'Pressure ulcer of unspecified site, unspecified stage'),
    ('L8991', 'Pressure ulcer of unspecified site, stage 1'),
    ('L8992', 'Pressure ulcer of unspecified site, stage 2'),
    ('L8993', 'Pressure ulcer of unspecified site, stage 3'),
    ('L8994', 'Pressure ulcer of unspecified site, stage 4'),
    ('L8995', 'Pressure ulcer of unspecified site, unstageable'),
    ('L8996', 'Pressure-induced deep tissue damage of unspecified site'),
    ('L900', 'Lichen sclerosus et atrophicus'),
    ('L901', 'Anetoderma of Schweninger-Buzzi'),
    ('L902', 'Anetoderma of Jadassohn-Pellizzari'),
    ('L903', 'Atrophoderma of Pasini and Pierini'),
    ('L904', 'Acrodermatitis chronica atrophicans'),
    ('L905', 'Scar conditions and fibrosis of skin'),
    ('L906', 'Striae atrophicae'),
    ('L908', 'Other atrophic disorders of skin'),
    ('L909', 'Atrophic disorder of skin, unspecified'),
    ('L910', 'Hypertrophic scar'),
    ('L918', 'Other hypertrophic disorders of the skin'),
    ('L919', 'Hypertrophic disorder of the skin, unspecified'),
    ('L920', 'Granuloma annulare'),
    ('L921', 'Necrobiosis lipoidica, not elsewhere classified'),
    ('L922', 'Granuloma faciale [eosinophilic granuloma of skin]'),
    ('L923', 'Foreign body granuloma of the skin and subcutaneous tissue'),
    ('L928', 'Oth granulomatous disorders of the skin, subcu'),
    ('L929', 'Granulomatous disorder of the skin, subcu, unsp'),
    ('L930', 'Discoid lupus erythematosus'),
    ('L931', 'Subacute cutaneous lupus erythematosus'),
    ('L932', 'Other local lupus erythematosus'),
    ('L940', 'Localized scleroderma [morphea]'),
    ('L941', 'Linear scleroderma'),
    ('L942', 'Calcinosis cutis'),
    ('L943', 'Sclerodactyly'),
    ('L944', "Gottron's papules"),
    ('L945', 'Poikiloderma vasculare atrophicans'),
    ('L946', 'Ainhum'),
    ('L948', 'Other specified localized connective tissue disorders'),
    ('L949', 'Localized connective tissue disorder, unspecified'),
    ('L950', 'Livedoid vasculitis'),
    ('L951', 'Erythema elevatum diutinum'),
    ('L958', 'Other vasculitis limited to the skin'),
    ('L959', 'Vasculitis limited to the skin, unspecified'),
    ('L97101', 'Non-prs chronic ulcer of unsp thigh limited to brkdwn skin'),
    ('L97102', 'Non-pressure chronic ulcer of unsp thigh w fat layer exposed'),
    ('L97103', 'Non-prs chronic ulcer of unsp thigh w necrosis of muscle'),
    ('L97104', 'Non-pressure chronic ulcer of unsp thigh w necrosis of bone'),
    ('L97105', 'Non-prs chr ulc of unsp thigh with msl invl w/o evd of necr'),
    ('L97106', 'Non-prs chr ulc of unsp thigh with bone invl w/o evd of necr'),
    ('L97108', 'Non-prs chronic ulcer of unspecified thigh with oth severity'),
    ('L97109', 'Non-pressure chronic ulcer of unsp thigh with unsp severity'),
    ('L97111', 'Non-prs chronic ulcer of right thigh limited to brkdwn skin'),
    ('L97112', 'Non-prs chronic ulcer of right thigh w fat layer exposed'),
    ('L97113', 'Non-prs chronic ulcer of right thigh w necrosis of muscle'),
    ('L97114', 'Non-pressure chronic ulcer of right thigh w necrosis of bone'),
    ('L97115', 'Non-prs chr ulcer of r thigh with msl invl w/o evd of necr'),
    ('L97116', 'Non-prs chr ulcer of r thigh with bone invl w/o evd of necr'),
    ('L97118', 'Non-pressure chronic ulcer of right thigh with oth severity'),
    ('L97119', 'Non-pressure chronic ulcer of right thigh with unsp severity'),
    ('L97121', 'Non-prs chronic ulcer of left thigh limited to brkdwn skin'),
    ('L97122', 'Non-pressure chronic ulcer of left thigh w fat layer exposed'),
    ('L97123', 'Non-prs chronic ulcer of left thigh w necrosis of muscle'),
    ('L97124', 'Non-pressure chronic ulcer of left thigh w necrosis of bone'),
    ('L97125', 'Non-prs chr ulc of left thigh with msl invl w/o evd of necr'),
    ('L97126', 'Non-prs chr ulc of left thigh with bone invl w/o evd of necr'),
    ('L97128', 'Non-pressure chronic ulcer of left thigh with oth severity'),
    ('L97129', 'Non-pressure chronic ulcer of left thigh with unsp severity'),
    ('L97201', 'Non-prs chronic ulcer of unsp calf limited to brkdwn skin'),
    ('L97202', 'Non-pressure chronic ulcer of unsp calf w fat layer exposed'),
    ('L97203', 'Non-pressure chronic ulcer of unsp calf w necrosis of muscle'),
    ('L97204', 'Non-pressure chronic ulcer of unsp calf w necrosis of bone'),
    ('L97205', 'Non-prs chr ulcer of unsp calf with msl invl w/o evd of necr'),
    ('L97206', 'Non-prs chr ulc of unsp calf with bone invl w/o evd of necr'),
    ('L97208', 'Non-prs chronic ulcer of unspecified calf with oth severity'),
    ('L97209', 'Non-pressure chronic ulcer of unsp calf with unsp severity'),
    ('L97211', 'Non-prs chronic ulcer of right calf limited to brkdwn skin'),
    ('L97212', 'Non-pressure chronic ulcer of right calf w fat layer exposed'),
    ('L97213', 'Non-prs chronic ulcer of right calf w necrosis of muscle'),
    ('L97214', 'Non-pressure chronic ulcer of right calf w necrosis of bone'),
    ('L97215', 'Non-prs chr ulcer of r calf with msl invl w/o evd of necr'),
    ('L97216', 'Non-prs chr ulcer of r calf with bone invl w/o evd of necr'),
    ('L97218', 'Non-pressure chronic ulcer of right calf with oth severity'),
    ('L97219', 'Non-pressure chronic ulcer of right calf with unsp severity'),
    ('L97221', 'Non-prs chronic ulcer of left calf limited to brkdwn skin'),
    ('L97222', 'Non-pressure chronic ulcer of left calf w fat layer exposed'),
    ('L97223', 'Non-pressure chronic ulcer of left calf w necrosis of muscle'),
    ('L97224', 'Non-pressure chronic ulcer of left calf w necrosis of bone'),
    ('L97225', 'Non-prs chr ulcer of left calf with msl invl w/o evd of necr'),
    ('L97226', 'Non-prs chr ulc of left calf with bone invl w/o evd of necr'),
    ('L97228', 'Non-pressure chronic ulcer of left calf with oth severity'),
    ('L97229', 'Non-pressure chronic ulcer of left calf with unsp severity'),
    ('L97301', 'Non-prs chronic ulcer of unsp ankle limited to brkdwn skin'),
    ('L97302', 'Non-pressure chronic ulcer of unsp ankle w fat layer exposed'),
    ('L97303', 'Non-prs chronic ulcer of unsp ankle w necrosis of muscle'),
    ('L97304', 'Non-pressure chronic ulcer of unsp ankle w necrosis of bone'),
    ('L97305', 'Non-prs chr ulcer of unsp ankl with msl invl w/o evd of necr'),
    ('L97306', 'Non-prs chr ulc of unsp ankl with bone invl w/o evd of necr'),
    ('L97308', 'Non-prs chronic ulcer of unspecified ankle with oth severity'),
    ('L97309', 'Non-pressure chronic ulcer of unsp ankle with unsp severity'),
    ('L97311', 'Non-prs chronic ulcer of right ankle limited to brkdwn skin'),
    ('L97312', 'Non-prs chronic ulcer of right ankle w fat layer exposed'),
    ('L97313', 'Non-prs chronic ulcer of right ankle w necrosis of muscle'),
    ('L97314', 'Non-pressure chronic ulcer of right ankle w necrosis of bone'),
    ('L97315', 'Non-prs chr ulcer of r ankle with msl invl w/o evd of necr'),
    ('L97316', 'Non-prs chr ulcer of r ankle with bone invl w/o evd of necr'),
    ('L97318', 'Non-pressure chronic ulcer of right ankle with oth severity'),
    ('L97319', 'Non-pressure chronic ulcer of right ankle with unsp severity'),
    ('L97321', 'Non-prs chronic ulcer of left ankle limited to brkdwn skin'),
    ('L97322', 'Non-pressure chronic ulcer of left ankle w fat layer exposed'),
    ('L97323', 'Non-prs chronic ulcer of left ankle w necrosis of muscle'),
    ('L97324', 'Non-pressure chronic ulcer of left ankle w necrosis of bone'),
    ('L97325', 'Non-prs chr ulcer of l ankle with msl invl w/o evd of necr'),
    ('L97326', 'Non-prs chr ulcer of l ankle with bone invl w/o evd of necr'),
    ('L97328', 'Non-pressure chronic ulcer of left ankle with oth severity'),
    ('L97329', 'Non-pressure chronic ulcer of left ankle with unsp severity'),
    ('L97401', 'Non-prs chr ulcer of unsp heel and midft lmt to brkdwn skin'),
    ('L97402', 'Non-prs chr ulcer of unsp heel and midfoot w fat layer expos'),
    ('L97403', 'Non-prs chr ulcer of unsp heel and midfoot w necros muscle'),
    ('L97404', 'Non-prs chronic ulcer of unsp heel and midfoot w necros bone'),
    ('L97405', 'Non-prs chr ulc unsp heel/midft w msl invl w/o evd of necr'),
    ('L97406', 'Non-prs chr ulc unsp heel/midft w bne invl w/o evd of necr'),
    ('L97408', 'Non-prs chronic ulcer of unsp heel/midft with oth severity'),
    ('L97409', 'Non-prs chronic ulcer of unsp heel and midfoot w unsp severt'),
    ('L97411', 'Non-prs chr ulcer of right heel and midft lmt to brkdwn skin'),
    ('L97412', 'Non-prs chr ulcer of right heel and midft w fat layer expos'),
    ('L97413', 'Non-prs chr ulcer of right heel and midfoot w necros muscle'),
    ('L97414', 'Non-prs chr ulcer of right heel and midfoot w necros bone'),
    ('L97415', 'Non-prs chr ulc of r heel/midft w msl invl w/o evd of necr'),
    ('L97416', 'Non-prs chr ulc of r heel/midft w bne invl w/o evd of necr'),
    ('L97418', 'Non-prs chronic ulcer of right heel/midft with oth severity'),
    ('L97419', 'Non-prs chr ulcer of right heel and midfoot w unsp severt'),
    ('L97421', 'Non-prs chr ulcer of left heel and midft lmt to brkdwn skin'),
    ('L97422', 'Non-prs chr ulcer of left heel and midfoot w fat layer expos'),
    ('L97423', 'Non-prs chr ulcer of left heel and midfoot w necros muscle'),
    ('L97424', 'Non-prs chronic ulcer of left heel and midfoot w necros bone'),
    ('L97425', 'Non-prs chr ulc of l heel/midft w msl invl w/o evd of necr'),
    ('L97426', 'Non-prs chr ulc of l heel/midft w bne invl w/o evd of necr'),
    ('L97428', 'Non-prs chronic ulcer of left heel/midft with oth severity'),
    ('L97429', 'Non-prs chronic ulcer of left heel and midfoot w unsp severt'),
    ('L97501', 'Non-prs chr ulcer oth prt unsp foot limited to brkdwn skin'),
    ('L97502', 'Non-prs chronic ulcer oth prt unsp foot w fat layer exposed'),
    ('L97503', 'Non-prs chronic ulcer oth prt unsp foot w necrosis of muscle'),
    ('L97504', 'Non-prs chronic ulcer oth prt unsp foot w necrosis of bone'),
    ('L97505', 'Non-prs chr ulc oth prt unsp ft w msl invl w/o evd of necr'),
    ('L97506', 'Non-prs chr ulc oth prt unsp ft w bne invl w/o evd of necr'),
    ('L97508', 'Non-prs chronic ulcer oth prt unsp foot with oth severity'),
    ('L97509', 'Non-pressure chronic ulcer oth prt unsp foot w unsp severity'),
    ('L97511', 'Non-prs chronic ulcer oth prt r foot limited to brkdwn skin'),
    ('L97512', 'Non-prs chronic ulcer oth prt right foot w fat layer exposed'),
    ('L97513', 'Non-prs chronic ulcer oth prt right foot w necros muscle'),
    ('L97514', 'Non-prs chronic ulcer oth prt right foot w necrosis of bone'),
    ('L97515', 'Non-prs chr ulc oth prt r foot with msl invl w/o evd of necr'),
    ('L97516', 'Non-prs chr ulc oth prt r foot with bne invl w/o evd of necr'),
    ('L97518', 'Non-prs chronic ulcer oth prt right foot with oth severity'),
    ('L97519', 'Non-prs chronic ulcer oth prt right foot w unsp severity'),
    ('L97521', 'Non-prs chronic ulcer oth prt l foot limited to brkdwn skin'),
    ('L97522', 'Non-prs chronic ulcer oth prt left foot w fat layer exposed'),
    ('L97523', 'Non-prs chronic ulcer oth prt left foot w necrosis of muscle'),
    ('L97524', 'Non-prs chronic ulcer oth prt left foot w necrosis of bone'),
    ('L97525', 'Non-prs chr ulc oth prt l foot with msl invl w/o evd of necr'),
    ('L97526', 'Non-prs chr ulc oth prt l foot with bne invl w/o evd of necr'),
    ('L97528', 'Non-prs chronic ulcer oth prt left foot with oth severity'),
    ('L97529', 'Non-pressure chronic ulcer oth prt left foot w unsp severity'),
    ('L97801', 'Non-prs chr ulcer oth prt unsp low leg lmt to brkdwn skin'),
    ('L97802', 'Non-prs chr ulcer oth prt unsp low leg w fat layer exposed'),
    ('L97803', 'Non-prs chronic ulcer oth prt unsp lower leg w necros muscle'),
    ('L97804', 'Non-prs chronic ulcer oth prt unsp lower leg w necros bone'),
    ('L97805', 'Non-prs chr ulc oth prt unsp lw leg w msl invl w/o evd necr'),
    ('L97806', 'Non-prs chr ulc oth prt unsp lw leg w bne invl w/o evd necr'),
    ('L97808', 'Non-prs chronic ulcer oth prt unsp low leg with oth severity'),
    ('L97809', 'Non-prs chronic ulcer oth prt unsp lower leg w unsp severity'),
    ('L97811', 'Non-prs chr ulcer oth prt r low leg limited to brkdwn skin'),
    ('L97812', 'Non-prs chronic ulcer oth prt r low leg w fat layer exposed'),
    ('L97813', 'Non-prs chronic ulcer oth prt r low leg w necrosis of muscle'),
    ('L97814', 'Non-prs chronic ulcer oth prt r low leg w necrosis of bone'),
    ('L97815', 'Non-prs chr ulc oth prt r low leg w msl invl w/o evd of necr'),
    ('L97816', 'Non-prs chr ulc oth prt r low leg w bne invl w/o evd of necr'),
    ('L97818', 'Non-prs chronic ulcer oth prt r low leg with oth severity'),
    ('L97819', 'Non-pressure chronic ulcer oth prt r low leg w unsp severity'),
    ('L97821', 'Non-prs chr ulcer oth prt l low leg limited to brkdwn skin'),
    ('L97822', 'Non-prs chronic ulcer oth prt l low leg w fat layer exposed'),
    ('L97823', 'Non-prs chronic ulcer oth prt l low leg w necrosis of muscle'),
    ('L97824', 'Non-prs chronic ulcer oth prt l low leg w necrosis of bone'),
    ('L97825', 'Non-prs chr ulc oth prt l low leg w msl invl w/o evd of necr'),
    ('L97826', 'Non-prs chr ulc oth prt l low leg w bne invl w/o evd of necr'),
    ('L97828', 'Non-prs chronic ulcer oth prt l low leg with oth severity'),
    ('L97829', 'Non-pressure chronic ulcer oth prt l low leg w unsp severity'),
    ('L97901', 'Non-prs chr ulc unsp prt of unsp low leg lmt to brkdwn skin'),
    ('L97902', 'Non-prs chr ulc unsp prt of unsp low leg w fat layer exposed'),
    ('L97903', 'Non-prs chronic ulc unsp prt of unsp low leg w necros muscle'),
    ('L97904', 'Non-prs chronic ulc unsp prt of unsp lower leg w necros bone'),
    ('L97905', 'Non-prs chr ulc unsp prt unsp lw leg w msl invl w/o evd necr'),
    ('L97906', 'Non-prs chr ulc unsp prt unsp lw leg w bne invl w/o evd necr'),
    ('L97908', 'Non-prs chronic ulc unsp prt of unsp low leg with oth severt'),
    ('L97909', 'Non-prs chronic ulc unsp prt of unsp low leg w unsp severity'),
    ('L97911', 'Non-prs chr ulc unsp prt of r low leg limited to brkdwn skin'),
    ('L97912', 'Non-prs chr ulc unsp prt of r low leg w fat layer exposed'),
    ('L97913', 'Non-prs chronic ulc unsp prt of r low leg w necros muscle'),
    ('L97914', 'Non-prs chronic ulc unsp prt of r low leg w necrosis of bone'),
    ('L97915', 'Non-prs chr ulc unsp prt r lw leg w msl invl w/o evd of necr'),
    ('L97916', 'Non-prs chr ulc unsp prt r lw leg w bne invl w/o evd of necr'),
    ('L97918', 'Non-prs chronic ulc unsp prt of r low leg with oth severity'),
    ('L97919', 'Non-prs chronic ulc unsp prt of r low leg w unsp severity'),
    ('L97921', 'Non-prs chr ulc unsp prt of l low leg limited to brkdwn skin'),
    ('L97922', 'Non-prs chr ulc unsp prt of l low leg w fat layer exposed'),
    ('L97923', 'Non-prs chronic ulc unsp prt of l low leg w necros muscle'),
    ('L97924', 'Non-prs chronic ulc unsp prt of l low leg w necrosis of bone'),
    ('L97925', 'Non-prs chr ulc unsp prt l lw leg w msl invl w/o evd of necr'),
    ('L97926', 'Non-prs chr ulc unsp prt l lw leg w bne invl w/o evd of necr'),
    ('L97928', 'Non-prs chronic ulc unsp prt of l low leg with oth severity'),
    ('L97929', 'Non-prs chronic ulc unsp prt of l low leg w unsp severity'),
    ('L980', 'Pyogenic granuloma'),
    ('L981', 'Factitial dermatitis'),
    ('L982', 'Febrile neutrophilic dermatosis [Sweet]'),
    ('L983', 'Eosinophilic cellulitis [Wells]'),
    ('L98411', 'Non-pressure chronic ulcer of buttock limited to brkdwn skin'),
    ('L98412', 'Non-pressure chronic ulcer of buttock with fat layer exposed'),
    ('L98413', 'Non-pressure chronic ulcer of buttock w necrosis of muscle'),
    ('L98414', 'Non-pressure chronic ulcer of buttock with necrosis of bone'),
    ('L98415', 'Non-prs chr ulcer of buttock with msl invl w/o evd of necr'),
    ('L98416', 'Non-prs chr ulcer of buttock with bone invl w/o evd of necr'),
    ('L98418', 'Non-pressure chronic ulcer of buttock with oth severity'),
    ('L98419', 'Non-pressure chronic ulcer of buttock with unsp severity'),
    ('L98421', 'Non-pressure chronic ulcer of back limited to brkdwn skin'),
    ('L98422', 'Non-pressure chronic ulcer of back with fat layer exposed'),
    ('L98423', 'Non-pressure chronic ulcer of back with necrosis of muscle'),
    ('L98424', 'Non-pressure chronic ulcer of back with necrosis of bone'),
    ('L98425', 'Non-prs chr ulcer of back with muscle invl w/o evd of necr'),
    ('L98426', 'Non-prs chr ulcer of back with bone invl without evd of necr'),
    ('L98428', 'Non-pressure chronic ulcer of back with oth severity'),
    ('L98429', 'Non-pressure chronic ulcer of back with unspecified severity'),
    ('L98491', 'Non-prs chronic ulcer skin/ sites limited to brkdwn skin'),
    ('L98492', 'Non-prs chronic ulcer of skin of sites w fat layer exposed'),
    ('L98493', 'Non-prs chronic ulcer of skin of sites w necrosis of muscle'),
    ('L98494', 'Non-prs chronic ulcer of skin of sites w necrosis of bone'),
    ('L98495', 'Non-prs chr ulc skin/ oth site with msl invl w/o evd of necr'),
    ('L98496', 'Non-prs chr ulc skin/ oth site with bne invl w/o evd of necr'),
    ('L98498', 'Non-prs chronic ulcer skin/ other sites with oth severity'),
    ('L98499', 'Non-pressure chronic ulcer of skin of sites w unsp severity'),
    ('L985', 'Mucinosis of the skin'),
    ('L986', 'Oth infiltrative disorders of the skin, subcu'),
    ('L987', 'Excessive and redundant skin and subcutaneous tissue'),
    ('L988', 'Oth disrd of the skin and subcutaneous tissue'),
    ('L989', 'Disorder of the skin and subcutaneous tissue, unspecified'),
    ('L99', 'Oth disorders of skin, subcu in diseases classd elswhr'),
    ('M0000', 'Staphylococcal arthritis, unspecified joint'),
    ('M00011', 'Staphylococcal arthritis, right shoulder'),
    ('M00012', 'Staphylococcal arthritis, left shoulder'),
    ('M00019', 'Staphylococcal arthritis, unspecified shoulder'),
    ('M00021', 'Staphylococcal arthritis, right elbow'),
    ('M00022', 'Staphylococcal arthritis, left elbow'),
    ('M00029', 'Staphylococcal arthritis, unspecified elbow'),
    ('M00031', 'Staphylococcal arthritis, right wrist'),
    ('M00032', 'Staphylococcal arthritis, left wrist'),
    ('M00039', 'Staphylococcal arthritis, unspecified wrist'),
    ('M00041', 'Staphylococcal arthritis, right hand'),
    ('M00042', 'Staphylococcal arthritis, left hand'),
    ('M00049', 'Staphylococcal arthritis, unspecified hand'),
    ('M00051', 'Staphylococcal arthritis, right hip'),
    ('M00052', 'Staphylococcal arthritis, left hip'),
    ('M00059', 'Staphylococcal arthritis, unspecified hip'),
    ('M00061', 'Staphylococcal arthritis, right knee'),
    ('M00062', 'Staphylococcal arthritis, left knee'),
    ('M00069', 'Staphylococcal arthritis, unspecified knee'),
    ('M00071', 'Staphylococcal arthritis, right ankle and foot'),
    ('M00072', 'Staphylococcal arthritis, left ankle and foot'),
    ('M00079', 'Staphylococcal arthritis, unspecified ankle and foot'),
    ('M0008', 'Staphylococcal arthritis, vertebrae'),
    ('M0009', 'Staphylococcal polyarthritis'),
    ('M0010', 'Pneumococcal arthritis, unspecified joint'),
    ('M00111', 'Pneumococcal arthritis, right shoulder'),
    ('M00112', 'Pneumococcal arthritis, left shoulder'),
    ('M00119', 'Pneumococcal arthritis, unspecified shoulder'),
    ('M00121', 'Pneumococcal arthritis, right elbow'),
    ('M00122', 'Pneumococcal arthritis, left elbow'),
    ('M00129', 'Pneumococcal arthritis, unspecified elbow'),
    ('M00131', 'Pneumococcal arthritis, right wrist'),
    ('M00132', 'Pneumococcal arthritis, left wrist'),
    ('M00139', 'Pneumococcal arthritis, unspecified wrist'),
    ('M00141', 'Pneumococcal arthritis, right hand'),
    ('M00142', 'Pneumococcal arthritis, left hand'),
    ('M00149', 'Pneumococcal arthritis, unspecified hand'),
    ('M00151', 'Pneumococcal arthritis, right hip'),
    ('M00152', 'Pneumococcal arthritis, left hip'),
    ('M00159', 'Pneumococcal arthritis, unspecified hip'),
    ('M00161', 'Pneumococcal arthritis, right knee'),
    ('M00162', 'Pneumococcal arthritis, left knee'),
    ('M00169', 'Pneumococcal arthritis, unspecified knee'),
    ('M00171', 'Pneumococcal arthritis, right ankle and foot'),
    ('M00172', 'Pneumococcal arthritis, left ankle and foot'),
    ('M00179', 'Pneumococcal arthritis, unspecified ankle and foot'),
    ('M0018', 'Pneumococcal arthritis, vertebrae'),
    ('M0019', 'Pneumococcal polyarthritis'),
    ('M0020', 'Other streptococcal arthritis, unspecified joint'),
    ('M00211', 'Other streptococcal arthritis, right shoulder'),
    ('M00212', 'Other streptococcal arthritis, left shoulder'),
    ('M00219', 'Other streptococcal arthritis, unspecified shoulder'),
    ('M00221', 'Other streptococcal arthritis, right elbow'),
    ('M00222', 'Other streptococcal arthritis, left elbow'),
    ('M00229', 'Other streptococcal arthritis, unspecified elbow'),
    ('M00231', 'Other streptococcal arthritis, right wrist'),
    ('M00232', 'Other streptococcal arthritis, left wrist'),
    ('M00239', 'Other streptococcal arthritis, unspecified wrist'),
    ('M00241', 'Other streptococcal arthritis, right hand'),
    ('M00242', 'Other streptococcal arthritis, left hand'),
    ('M00249', 'Other streptococcal arthritis, unspecified hand'),
    ('M00251', 'Other streptococcal arthritis, right hip'),
    ('M00252', 'Other streptococcal arthritis, left hip'),
    ('M00259', 'Other streptococcal arthritis, unspecified hip'),
    ('M00261', 'Other streptococcal arthritis, right knee'),
    ('M00262', 'Other streptococcal arthritis, left knee'),
    ('M00269', 'Other streptococcal arthritis, unspecified knee'),
    ('M00271', 'Other streptococcal arthritis, right ankle and foot'),
    ('M00272', 'Other streptococcal arthritis, left ankle and foot'),
    ('M00279', 'Other streptococcal arthritis, unspecified ankle and foot'),
    ('M0028', 'Other streptococcal arthritis, vertebrae'),
    ('M0029', 'Other streptococcal polyarthritis'),
    ('M0080', 'Arthritis due to other bacteria, unspecified joint'),
    ('M00811', 'Arthritis due to other bacteria, right shoulder'),
    ('M00812', 'Arthritis due to other bacteria, left shoulder'),
    ('M00819', 'Arthritis due to other bacteria, unspecified shoulder'),
    ('M00821', 'Arthritis due to other bacteria, right elbow'),
    ('M00822', 'Arthritis due to other bacteria, left elbow'),
    ('M00829', 'Arthritis due to other bacteria, unspecified elbow'),
    ('M00831', 'Arthritis due to other bacteria, right wrist'),
    ('M00832', 'Arthritis due to other bacteria, left wrist'),
    ('M00839', 'Arthritis due to other bacteria, unspecified wrist'),
    ('M00841', 'Arthritis due to other bacteria, right hand'),
    ('M00842', 'Arthritis due to other bacteria, left hand'),
    ('M00849', 'Arthritis due to other bacteria, unspecified hand'),
    ('M00851', 'Arthritis due to other bacteria, right hip'),
    ('M00852', 'Arthritis due to other bacteria, left hip'),
    ('M00859', 'Arthritis due to other bacteria, unspecified hip'),
    ('M00861', 'Arthritis due to other bacteria, right knee'),
    ('M00862', 'Arthritis due to other bacteria, left knee'),
    ('M00869', 'Arthritis due to other bacteria, unspecified knee'),
    ('M00871', 'Arthritis due to other bacteria, right ankle and foot'),
    ('M00872', 'Arthritis due to other bacteria, left ankle and foot'),
    ('M00879', 'Arthritis due to other bacteria, unspecified ankle and foot'),
    ('M0088', 'Arthritis due to other bacteria, vertebrae'),
    ('M0089', 'Polyarthritis due to other bacteria'),
    ('M009', 'Pyogenic arthritis, unspecified'),
    ('M01X0', 'Dir infct of unsp joint in infec/parastc dis classd elswhr'),
    ('M01X11', 'Direct infct of r shldr in infec/parastc dis classd elswhr'),
    ('M01X12', 'Direct infct of l shldr in infec/parastc dis classd elswhr'),
    ('M01X19', 'Dir infct of unsp shldr in infec/parastc dis classd elswhr'),
    ('M01X21', 'Direct infct of r elbow in infec/parastc dis classd elswhr'),
    ('M01X22', 'Direct infct of l elbow in infec/parastc dis classd elswhr'),
    ('M01X29', 'Dir infct of unsp elbow in infec/parastc dis classd elswhr'),
    ('M01X31', 'Direct infct of r wrist in infec/parastc dis classd elswhr'),
    ('M01X32', 'Direct infct of l wrist in infec/parastc dis classd elswhr'),
    ('M01X39', 'Dir infct of unsp wrist in infec/parastc dis classd elswhr'),
    ('M01X41', 'Direct infct of r hand in infec/parastc dis classd elswhr'),
    ('M01X42', 'Direct infct of l hand in infec/parastc dis classd elswhr'),
    ('M01X49', 'Direct infct of unsp hand in infec/parastc dis classd elswhr'),
    ('M01X51', 'Direct infct of r hip in infec/parastc dis classd elswhr'),
    ('M01X52', 'Direct infct of left hip in infec/parastc dis classd elswhr'),
    ('M01X59', 'Direct infct of unsp hip in infec/parastc dis classd elswhr'),
    ('M01X61', 'Direct infct of r knee in infec/parastc dis classd elswhr'),
    ('M01X62', 'Direct infct of l knee in infec/parastc dis classd elswhr'),
    ('M01X69', 'Direct infct of unsp knee in infec/parastc dis classd elswhr'),
    ('M01X71', 'Dir infct of right ank/ft in infec/parastc dis classd elswhr'),
    ('M01X72', 'Dir infct of left ank/ft in infec/parastc dis classd elswhr'),
    ('M01X79', 'Dir infct of unsp ank/ft in infec/parastc dis classd elswhr'),
    ('M01X8', 'Direct infct of verteb in infec/parastc dis classd elswhr'),
    ('M01X9', 'Dir infct of mult joints in infec/parastc dis classd elswhr'),
    ('M0200', 'Arthropathy following intestinal bypass, unspecified site'),
    ('M02011', 'Arthropathy following intestinal bypass, right shoulder'),
    ('M02012', 'Arthropathy following intestinal bypass, left shoulder'),
    ('M02019', 'Arthropathy following intestinal bypass, unsp shoulder'),
    ('M02021', 'Arthropathy following intestinal bypass, right elbow'),
    ('M02022', 'Arthropathy following intestinal bypass, left elbow'),
    ('M02029', 'Arthropathy following intestinal bypass, unspecified elbow'),
    ('M02031', 'Arthropathy following intestinal bypass, right wrist'),
    ('M02032', 'Arthropathy following intestinal bypass, left wrist'),
    ('M02039', 'Arthropathy following intestinal bypass, unspecified wrist'),
    ('M02041', 'Arthropathy following intestinal bypass, right hand'),
    ('M02042', 'Arthropathy following intestinal bypass, left hand'),
    ('M02049', 'Arthropathy following intestinal bypass, unspecified hand'),
    ('M02051', 'Arthropathy following intestinal bypass, right hip'),
    ('M02052', 'Arthropathy following intestinal bypass, left hip'),
    ('M02059', 'Arthropathy following intestinal bypass, unspecified hip'),
    ('M02061', 'Arthropathy following intestinal bypass, right knee'),
    ('M02062', 'Arthropathy following intestinal bypass, left knee'),
    ('M02069', 'Arthropathy following intestinal bypass, unspecified knee'),
    ('M02071', 'Arthropathy following intestinal bypass, right ank/ft'),
    ('M02072', 'Arthropathy following intestinal bypass, left ankle and foot'),
    ('M02079', 'Arthropathy following intestinal bypass, unsp ankle and foot'),
    ('M0208', 'Arthropathy following intestinal bypass, vertebrae'),
    ('M0209', 'Arthropathy following intestinal bypass, multiple sites'),
    ('M0210', 'Postdysenteric arthropathy, unspecified site'),
    ('M02111', 'Postdysenteric arthropathy, right shoulder'),
    ('M02112', 'Postdysenteric arthropathy, left shoulder'),
    ('M02119', 'Postdysenteric arthropathy, unspecified shoulder'),
    ('M02121', 'Postdysenteric arthropathy, right elbow'),
    ('M02122', 'Postdysenteric arthropathy, left elbow'),
    ('M02129', 'Postdysenteric arthropathy, unspecified elbow'),
    ('M02131', 'Postdysenteric arthropathy, right wrist'),
    ('M02132', 'Postdysenteric arthropathy, left wrist'),
    ('M02139', 'Postdysenteric arthropathy, unspecified wrist'),
    ('M02141', 'Postdysenteric arthropathy, right hand'),
    ('M02142', 'Postdysenteric arthropathy, left hand'),
    ('M02149', 'Postdysenteric arthropathy, unspecified hand'),
    ('M02151', 'Postdysenteric arthropathy, right hip'),
    ('M02152', 'Postdysenteric arthropathy, left hip'),
    ('M02159', 'Postdysenteric arthropathy, unspecified hip'),
    ('M02161', 'Postdysenteric arthropathy, right knee'),
    ('M02162', 'Postdysenteric arthropathy, left knee'),
    ('M02169', 'Postdysenteric arthropathy, unspecified knee'),
    ('M02171', 'Postdysenteric arthropathy, right ankle and foot'),
    ('M02172', 'Postdysenteric arthropathy, left ankle and foot'),
    ('M02179', 'Postdysenteric arthropathy, unspecified ankle and foot'),
    ('M0218', 'Postdysenteric arthropathy, vertebrae'),
    ('M0219', 'Postdysenteric arthropathy, multiple sites'),
    ('M0220', 'Postimmunization arthropathy, unspecified site'),
    ('M02211', 'Postimmunization arthropathy, right shoulder'),
    ('M02212', 'Postimmunization arthropathy, left shoulder'),
    ('M02219', 'Postimmunization arthropathy, unspecified shoulder'),
    ('M02221', 'Postimmunization arthropathy, right elbow'),
    ('M02222', 'Postimmunization arthropathy, left elbow'),
    ('M02229', 'Postimmunization arthropathy, unspecified elbow'),
    ('M02231', 'Postimmunization arthropathy, right wrist'),
    ('M02232', 'Postimmunization arthropathy, left wrist'),
    ('M02239', 'Postimmunization arthropathy, unspecified wrist'),
    ('M02241', 'Postimmunization arthropathy, right hand'),
    ('M02242', 'Postimmunization arthropathy, left hand'),
    ('M02249', 'Postimmunization arthropathy, unspecified hand'),
    ('M02251', 'Postimmunization arthropathy, right hip'),
    ('M02252', 'Postimmunization arthropathy, left hip'),
    ('M02259', 'Postimmunization arthropathy, unspecified hip'),
    ('M02261', 'Postimmunization arthropathy, right knee'),
    ('M02262', 'Postimmunization arthropathy, left knee'),
    ('M02269', 'Postimmunization arthropathy, unspecified knee'),
    ('M02271', 'Postimmunization arthropathy, right ankle and foot'),
    ('M02272', 'Postimmunization arthropathy, left ankle and foot'),
    ('M02279', 'Postimmunization arthropathy, unspecified ankle and foot'),
    ('M0228', 'Postimmunization arthropathy, vertebrae'),
    ('M0229', 'Postimmunization arthropathy, multiple sites'),
    ('M0230', "Reiter's disease, unspecified site"),
    ('M02311', "Reiter's disease, right shoulder"),
    ('M02312', "Reiter's disease, left shoulder"),
    ('M02319', "Reiter's disease, unspecified shoulder"),
    ('M02321', "Reiter's disease, right elbow"),
    ('M02322', "Reiter's disease, left elbow"),
    ('M02329', "Reiter's disease, unspecified elbow"),
    ('M02331', "Reiter's disease, right wrist"),
    ('M02332', "Reiter's disease, left wrist"),
    ('M02339', "Reiter's disease, unspecified wrist"),
    ('M02341', "Reiter's disease, right hand"),
    ('M02342', "Reiter's disease, left hand"),
    ('M02349', "Reiter's disease, unspecified hand"),
    ('M02351', "Reiter's disease, right hip"),
    ('M02352', "Reiter's disease, left hip"),
    ('M02359', "Reiter's disease, unspecified hip"),
    ('M02361', "Reiter's disease, right knee"),
    ('M02362', "Reiter's disease, left knee"),
    ('M02369', "Reiter's disease, unspecified knee"),
    ('M02371', "Reiter's disease, right ankle and foot"),
    ('M02372', "Reiter's disease, left ankle and foot"),
    ('M02379', "Reiter's disease, unspecified ankle and foot"),
    ('M0238', "Reiter's disease, vertebrae"),
    ('M0239', "Reiter's disease, multiple sites"),
    ('M0280', 'Other reactive arthropathies, unspecified site'),
    ('M02811', 'Other reactive arthropathies, right shoulder'),
    ('M02812', 'Other reactive arthropathies, left shoulder'),
    ('M02819', 'Other reactive arthropathies, unspecified shoulder'),
    ('M02821', 'Other reactive arthropathies, right elbow'),
    ('M02822', 'Other reactive arthropathies, left elbow'),
    ('M02829', 'Other reactive arthropathies, unspecified elbow'),
    ('M02831', 'Other reactive arthropathies, right wrist'),
    ('M02832', 'Other reactive arthropathies, left wrist'),
    ('M02839', 'Other reactive arthropathies, unspecified wrist'),
    ('M02841', 'Other reactive arthropathies, right hand'),
    ('M02842', 'Other reactive arthropathies, left hand'),
    ('M02849', 'Other reactive arthropathies, unspecified hand'),
    ('M02851', 'Other reactive arthropathies, right hip'),
    ('M02852', 'Other reactive arthropathies, left hip'),
    ('M02859', 'Other reactive arthropathies, unspecified hip'),
    ('M02861', 'Other reactive arthropathies, right knee'),
    ('M02862', 'Other reactive arthropathies, left knee'),
    ('M02869', 'Other reactive arthropathies, unspecified knee'),
    ('M02871', 'Other reactive arthropathies, right ankle and foot'),
    ('M02872', 'Other reactive arthropathies, left ankle and foot'),
    ('M02879', 'Other reactive arthropathies, unspecified ankle and foot'),
    ('M0288', 'Other reactive arthropathies, vertebrae'),
    ('M0289', 'Other reactive arthropathies, multiple sites'),
    ('M029', 'Reactive arthropathy, unspecified'),
    ('M041', 'Periodic fever syndromes'),
    ('M042', 'Cryopyrin-associated periodic syndromes'),
    ('M048', 'Other autoinflammatory syndromes'),
    ('M049', 'Autoinflammatory syndrome, unspecified'),
    ('M0500', "Felty's syndrome, unspecified site"),
    ('M05011', "Felty's syndrome, right shoulder"),
    ('M05012', "Felty's syndrome, left shoulder"),
    ('M05019', "Felty's syndrome, unspecified shoulder"),
    ('M05021', "Felty's syndrome, right elbow"),
    ('M05022', "Felty's syndrome, left elbow"),
    ('M05029', "Felty's syndrome, unspecified elbow"),
    ('M05031', "Felty's syndrome, right wrist"),
    ('M05032', "Felty's syndrome, left wrist"),
    ('M05039', "Felty's syndrome, unspecified wrist"),
    ('M05041', "Felty's syndrome, right hand"),
    ('M05042', "Felty's syndrome, left hand"),
    ('M05049', "Felty's syndrome, unspecified hand"),
    ('M05051', "Felty's syndrome, right hip"),
    ('M05052', "Felty's syndrome, left hip"),
    ('M05059', "Felty's syndrome, unspecified hip"),
    ('M05061', "Felty's syndrome, right knee"),
    ('M05062', "Felty's syndrome, left knee"),
    ('M05069', "Felty's syndrome, unspecified knee"),
    ('M05071', "Felty's syndrome, right ankle and foot"),
    ('M05072', "Felty's syndrome, left ankle and foot"),
    ('M05079', "Felty's syndrome, unspecified ankle and foot"),
    ('M0509', "Felty's syndrome, multiple sites"),
    ('M0510', 'Rheumatoid lung disease w rheumatoid arthritis of unsp site'),
    ('M05111', 'Rheumatoid lung disease w rheumatoid arthritis of r shoulder'),
    ('M05112', 'Rheumatoid lung disease w rheumatoid arthritis of l shoulder'),
    ('M05119', 'Rheu lung disease w rheumatoid arthritis of unsp shoulder'),
    ('M05121', 'Rheumatoid lung disease w rheumatoid arthritis of r elbow'),
    ('M05122', 'Rheumatoid lung disease w rheumatoid arthritis of left elbow'),
    ('M05129', 'Rheumatoid lung disease w rheumatoid arthritis of unsp elbow'),
    ('M05131', 'Rheumatoid lung disease w rheumatoid arthritis of r wrist'),
    ('M05132', 'Rheumatoid lung disease w rheumatoid arthritis of left wrist'),
    ('M05139', 'Rheumatoid lung disease w rheumatoid arthritis of unsp wrist'),
    ('M05141', 'Rheumatoid lung disease w rheumatoid arthritis of right hand'),
    ('M05142', 'Rheumatoid lung disease w rheumatoid arthritis of left hand'),
    ('M05149', 'Rheumatoid lung disease w rheumatoid arthritis of unsp hand'),
    ('M05151', 'Rheumatoid lung disease w rheumatoid arthritis of right hip'),
    ('M05152', 'Rheumatoid lung disease w rheumatoid arthritis of left hip'),
    ('M05159', 'Rheumatoid lung disease w rheumatoid arthritis of unsp hip'),
    ('M05161', 'Rheumatoid lung disease w rheumatoid arthritis of right knee'),
    ('M05162', 'Rheumatoid lung disease w rheumatoid arthritis of left knee'),
    ('M05169', 'Rheumatoid lung disease w rheumatoid arthritis of unsp knee'),
    ('M05171', 'Rheu lung disease w rheumatoid arthritis of right ank/ft'),
    ('M05172', 'Rheu lung disease w rheumatoid arthritis of left ank/ft'),
    ('M05179', 'Rheu lung disease w rheumatoid arthritis of unsp ank/ft'),
    ('M0519', 'Rheumatoid lung disease w rheumatoid arthritis mult site'),
    ('M0520', 'Rheumatoid vasculitis with rheumatoid arthritis of unsp site'),
    ('M05211', 'Rheumatoid vasculitis w rheumatoid arthritis of r shoulder'),
    ('M05212', 'Rheumatoid vasculitis w rheumatoid arthritis of l shoulder'),
    ('M05219', 'Rheu vasculitis w rheumatoid arthritis of unsp shoulder'),
    ('M05221', 'Rheumatoid vasculitis w rheumatoid arthritis of right elbow'),
    ('M05222', 'Rheumatoid vasculitis w rheumatoid arthritis of left elbow'),
    ('M05229', 'Rheumatoid vasculitis w rheumatoid arthritis of unsp elbow'),
    ('M05231', 'Rheumatoid vasculitis w rheumatoid arthritis of right wrist'),
    ('M05232', 'Rheumatoid vasculitis w rheumatoid arthritis of left wrist'),
    ('M05239', 'Rheumatoid vasculitis w rheumatoid arthritis of unsp wrist'),
    ('M05241', 'Rheumatoid vasculitis w rheumatoid arthritis of right hand'),
    ('M05242', 'Rheumatoid vasculitis with rheumatoid arthritis of left hand'),
    ('M05249', 'Rheumatoid vasculitis with rheumatoid arthritis of unsp hand'),
    ('M05251', 'Rheumatoid vasculitis with rheumatoid arthritis of right hip'),
    ('M05252', 'Rheumatoid vasculitis with rheumatoid arthritis of left hip'),
    ('M05259', 'Rheumatoid vasculitis with rheumatoid arthritis of unsp hip'),
    ('M05261', 'Rheumatoid vasculitis w rheumatoid arthritis of right knee'),
    ('M05262', 'Rheumatoid vasculitis with rheumatoid arthritis of left knee'),
    ('M05269', 'Rheumatoid vasculitis with rheumatoid arthritis of unsp knee'),
    ('M05271', 'Rheumatoid vasculitis w rheumatoid arthritis of right ank/ft'),
    ('M05272', 'Rheumatoid vasculitis w rheumatoid arthritis of left ank/ft'),
    ('M05279', 'Rheumatoid vasculitis w rheumatoid arthritis of unsp ank/ft'),
    ('M0529', 'Rheumatoid vasculitis w rheumatoid arthritis mult site'),
    ('M0530', 'Rheumatoid heart disease w rheumatoid arthritis of unsp site'),
    ('M05311', 'Rheu heart disease w rheumatoid arthritis of r shoulder'),
    ('M05312', 'Rheu heart disease w rheumatoid arthritis of l shoulder'),
    ('M05319', 'Rheu heart disease w rheumatoid arthritis of unsp shoulder'),
    ('M05321', 'Rheumatoid heart disease w rheumatoid arthritis of r elbow'),
    ('M05322', 'Rheumatoid heart disease w rheumatoid arthritis of l elbow'),
    ('M05329', 'Rheu heart disease w rheumatoid arthritis of unsp elbow'),
    ('M05331', 'Rheumatoid heart disease w rheumatoid arthritis of r wrist'),
    ('M05332', 'Rheumatoid heart disease w rheumatoid arthritis of l wrist'),
    ('M05339', 'Rheu heart disease w rheumatoid arthritis of unsp wrist'),
    ('M05341', 'Rheu heart disease w rheumatoid arthritis of right hand'),
    ('M05342', 'Rheumatoid heart disease w rheumatoid arthritis of left hand'),
    ('M05349', 'Rheumatoid heart disease w rheumatoid arthritis of unsp hand'),
    ('M05351', 'Rheumatoid heart disease w rheumatoid arthritis of right hip'),
    ('M05352', 'Rheumatoid heart disease w rheumatoid arthritis of left hip'),
    ('M05359', 'Rheumatoid heart disease w rheumatoid arthritis of unsp hip'),
    ('M05361', 'Rheu heart disease w rheumatoid arthritis of right knee'),
    ('M05362', 'Rheumatoid heart disease w rheumatoid arthritis of left knee'),
    ('M05369', 'Rheumatoid heart disease w rheumatoid arthritis of unsp knee'),
    ('M05371', 'Rheu heart disease w rheumatoid arthritis of right ank/ft'),
    ('M05372', 'Rheu heart disease w rheumatoid arthritis of left ank/ft'),
    ('M05379', 'Rheu heart disease w rheumatoid arthritis of unsp ank/ft'),
    ('M0539', 'Rheumatoid heart disease w rheumatoid arthritis mult site'),
    ('M0540', 'Rheumatoid myopathy with rheumatoid arthritis of unsp site'),
    ('M05411', 'Rheumatoid myopathy w rheumatoid arthritis of right shoulder'),
    ('M05412', 'Rheumatoid myopathy w rheumatoid arthritis of left shoulder'),
    ('M05419', 'Rheumatoid myopathy w rheumatoid arthritis of unsp shoulder'),
    ('M05421', 'Rheumatoid myopathy with rheumatoid arthritis of right elbow'),
    ('M05422', 'Rheumatoid myopathy with rheumatoid arthritis of left elbow'),
    ('M05429', 'Rheumatoid myopathy with rheumatoid arthritis of unsp elbow'),
    ('M05431', 'Rheumatoid myopathy with rheumatoid arthritis of right wrist'),
    ('M05432', 'Rheumatoid myopathy with rheumatoid arthritis of left wrist'),
    ('M05439', 'Rheumatoid myopathy with rheumatoid arthritis of unsp wrist'),
    ('M05441', 'Rheumatoid myopathy with rheumatoid arthritis of right hand'),
    ('M05442', 'Rheumatoid myopathy with rheumatoid arthritis of left hand'),
    ('M05449', 'Rheumatoid myopathy with rheumatoid arthritis of unsp hand'),
    ('M05451', 'Rheumatoid myopathy with rheumatoid arthritis of right hip'),
    ('M05452', 'Rheumatoid myopathy with rheumatoid arthritis of left hip'),
    ('M05459', 'Rheumatoid myopathy with rheumatoid arthritis of unsp hip'),
    ('M05461', 'Rheumatoid myopathy with rheumatoid arthritis of right knee'),
    ('M05462', 'Rheumatoid myopathy with rheumatoid arthritis of left knee'),
    ('M05469', 'Rheumatoid myopathy with rheumatoid arthritis of unsp knee'),
    ('M05471', 'Rheumatoid myopathy w rheumatoid arthritis of right ank/ft'),
    ('M05472', 'Rheumatoid myopathy w rheumatoid arthritis of left ank/ft'),
    ('M05479', 'Rheumatoid myopathy w rheumatoid arthritis of unsp ank/ft'),
    ('M0549', 'Rheumatoid myopathy w rheumatoid arthritis of multiple sites'),
    ('M0550', 'Rheumatoid polyneurop w rheumatoid arthritis of unsp site'),
    ('M05511', 'Rheumatoid polyneurop w rheumatoid arthritis of r shoulder'),
    ('M05512', 'Rheumatoid polyneurop w rheumatoid arthritis of l shoulder'),
    ('M05519', 'Rheu polyneurop w rheumatoid arthritis of unsp shoulder'),
    ('M05521', 'Rheumatoid polyneurop w rheumatoid arthritis of right elbow'),
    ('M05522', 'Rheumatoid polyneurop w rheumatoid arthritis of left elbow'),
    ('M05529', 'Rheumatoid polyneurop w rheumatoid arthritis of unsp elbow'),
    ('M05531', 'Rheumatoid polyneurop w rheumatoid arthritis of right wrist'),
    ('M05532', 'Rheumatoid polyneurop w rheumatoid arthritis of left wrist'),
    ('M05539', 'Rheumatoid polyneurop w rheumatoid arthritis of unsp wrist'),
    ('M05541', 'Rheumatoid polyneurop w rheumatoid arthritis of right hand'),
    ('M05542', 'Rheumatoid polyneurop w rheumatoid arthritis of left hand'),
    ('M05549', 'Rheumatoid polyneurop w rheumatoid arthritis of unsp hand'),
    ('M05551', 'Rheumatoid polyneurop w rheumatoid arthritis of right hip'),
    ('M05552', 'Rheumatoid polyneuropathy w rheumatoid arthritis of left hip'),
    ('M05559', 'Rheumatoid polyneuropathy w rheumatoid arthritis of unsp hip'),
    ('M05561', 'Rheumatoid polyneurop w rheumatoid arthritis of right knee'),
    ('M05562', 'Rheumatoid polyneurop w rheumatoid arthritis of left knee'),
    ('M05569', 'Rheumatoid polyneurop w rheumatoid arthritis of unsp knee'),
    ('M05571', 'Rheumatoid polyneurop w rheumatoid arthritis of right ank/ft'),
    ('M05572', 'Rheumatoid polyneurop w rheumatoid arthritis of left ank/ft'),
    ('M05579', 'Rheumatoid polyneurop w rheumatoid arthritis of unsp ank/ft'),
    ('M0559', 'Rheumatoid polyneuropathy w rheumatoid arthritis mult site'),
    ('M0560', 'Rheu arthritis of unsp site w involv of organs and systems'),
    ('M05611', 'Rheu arthritis of r shoulder w involv of organs and systems'),
    ('M05612', 'Rheu arthritis of l shoulder w involv of organs and systems'),
    ('M05619', 'Rheu arthrit of unsp shoulder w involv of organs and systems'),
    ('M05621', 'Rheu arthritis of r elbow w involv of organs and systems'),
    ('M05622', 'Rheu arthritis of l elbow w involv of organs and systems'),
    ('M05629', 'Rheu arthritis of unsp elbow w involv of organs and systems'),
    ('M05631', 'Rheu arthritis of r wrist w involv of organs and systems'),
    ('M05632', 'Rheu arthritis of l wrist w involv of organs and systems'),
    ('M05639', 'Rheu arthritis of unsp wrist w involv of organs and systems'),
    ('M05641', 'Rheu arthritis of right hand w involv of organs and systems'),
    ('M05642', 'Rheu arthritis of left hand w involv of organs and systems'),
    ('M05649', 'Rheu arthritis of unsp hand w involv of organs and systems'),
    ('M05651', 'Rheu arthritis of right hip w involv of organs and systems'),
    ('M05652', 'Rheu arthritis of left hip w involv of organs and systems'),
    ('M05659', 'Rheu arthritis of unsp hip w involv of organs and systems'),
    ('M05661', 'Rheu arthritis of right knee w involv of organs and systems'),
    ('M05662', 'Rheu arthritis of left knee w involv of organs and systems'),
    ('M05669', 'Rheu arthritis of unsp knee w involv of organs and systems'),
    ('M05671', 'Rheu arthrit of right ank/ft w involv of organs and systems'),
    ('M05672', 'Rheu arthritis of left ank/ft w involv of organs and systems'),
    ('M05679', 'Rheu arthritis of unsp ank/ft w involv of organs and systems'),
    ('M0569', 'Rheu arthritis mult site w involv of organs and systems'),
    ('M0570', 'Rheu arthritis w rheu factor of unsp site w/o org/sys involv'),
    ('M05711', 'Rheu arthrit w rheu factor of r shoulder w/o org/sys involv'),
    ('M05712', 'Rheu arthrit w rheu factor of l shoulder w/o org/sys involv'),
    ('M05719', 'Rheu arthrit w rheu factor of unsp shldr w/o org/sys involv'),
    ('M05721', 'Rheu arthritis w rheu factor of r elbow w/o org/sys involv'),
    ('M05722', 'Rheu arthritis w rheu factor of l elbow w/o org/sys involv'),
    ('M05729', 'Rheu arthrit w rheu factor of unsp elbow w/o org/sys involv'),
    ('M05731', 'Rheu arthritis w rheu factor of r wrist w/o org/sys involv'),
    ('M05732', 'Rheu arthritis w rheu factor of l wrist w/o org/sys involv'),
    ('M05739', 'Rheu arthrit w rheu factor of unsp wrist w/o org/sys involv'),
    ('M05741', 'Rheu arthritis w rheu factor of r hand w/o org/sys involv'),
    ('M05742', 'Rheu arthritis w rheu factor of left hand w/o org/sys involv'),
    ('M05749', 'Rheu arthritis w rheu factor of unsp hand w/o org/sys involv'),
    ('M05751', 'Rheu arthritis w rheu factor of right hip w/o org/sys involv'),
    ('M05752', 'Rheu arthritis w rheu factor of left hip w/o org/sys involv'),
    ('M05759', 'Rheu arthritis w rheu factor of unsp hip w/o org/sys involv'),
    ('M05761', 'Rheu arthritis w rheu factor of r knee w/o org/sys involv'),
    ('M05762', 'Rheu arthritis w rheu factor of left knee w/o org/sys involv'),
    ('M05769', 'Rheu arthritis w rheu factor of unsp knee w/o org/sys involv'),
    ('M05771', 'Rheu arthrit w rheu fctr of right ank/ft w/o org/sys involv'),
    ('M05772', 'Rheu arthrit w rheu factor of left ank/ft w/o org/sys involv'),
    ('M05779', 'Rheu arthrit w rheu factor of unsp ank/ft w/o org/sys involv'),
    ('M0579', 'Rheu arthritis w rheu factor mult site w/o org/sys involv'),
    ('M057A', 'Rheu arthrit with rheu factor of oth site w/o org/sys invl'),
    ('M0580', 'Oth rheumatoid arthritis with rheumatoid factor of unsp site'),
    ('M05811', 'Oth rheumatoid arthritis w rheumatoid factor of r shoulder'),
    ('M05812', 'Oth rheumatoid arthritis w rheumatoid factor of l shoulder'),
    ('M05819', 'Oth rheu arthritis w rheumatoid factor of unsp shoulder'),
    ('M05821', 'Oth rheumatoid arthritis w rheumatoid factor of right elbow'),
    ('M05822', 'Oth rheumatoid arthritis w rheumatoid factor of left elbow'),
    ('M05829', 'Oth rheumatoid arthritis w rheumatoid factor of unsp elbow'),
    ('M05831', 'Oth rheumatoid arthritis w rheumatoid factor of right wrist'),
    ('M05832', 'Oth rheumatoid arthritis w rheumatoid factor of left wrist'),
    ('M05839', 'Oth rheumatoid arthritis w rheumatoid factor of unsp wrist'),
    ('M05841', 'Oth rheumatoid arthritis w rheumatoid factor of right hand'),
    ('M05842', 'Oth rheumatoid arthritis with rheumatoid factor of left hand'),
    ('M05849', 'Oth rheumatoid arthritis with rheumatoid factor of unsp hand'),
    ('M05851', 'Oth rheumatoid arthritis with rheumatoid factor of right hip'),
    ('M05852', 'Oth rheumatoid arthritis with rheumatoid factor of left hip'),
    ('M05859', 'Oth rheumatoid arthritis with rheumatoid factor of unsp hip'),
    ('M05861', 'Oth rheumatoid arthritis w rheumatoid factor of right knee'),
    ('M05862', 'Oth rheumatoid arthritis with rheumatoid factor of left knee'),
    ('M05869', 'Oth rheumatoid arthritis with rheumatoid factor of unsp knee'),
    ('M05871', 'Oth rheumatoid arthritis w rheumatoid factor of right ank/ft'),
    ('M05872', 'Oth rheumatoid arthritis w rheumatoid factor of left ank/ft'),
    ('M05879', 'Oth rheumatoid arthritis w rheumatoid factor of unsp ank/ft'),
    ('M0589', 'Oth rheumatoid arthritis w rheumatoid factor mult site'),
    ('M058A', 'Other rheu arthritis with rheumatoid factor of oth site'),
    ('M059', 'Rheumatoid arthritis with rheumatoid factor, unspecified'),
    ('M0600', 'Rheumatoid arthritis without rheumatoid factor, unsp site'),
    ('M06011', 'Rheumatoid arthritis w/o rheumatoid factor, right shoulder'),
    ('M06012', 'Rheumatoid arthritis w/o rheumatoid factor, left shoulder'),
    ('M06019', 'Rheumatoid arthritis w/o rheumatoid factor, unsp shoulder'),
    ('M06021', 'Rheumatoid arthritis without rheumatoid factor, right elbow'),
    ('M06022', 'Rheumatoid arthritis without rheumatoid factor, left elbow'),
    ('M06029', 'Rheumatoid arthritis without rheumatoid factor, unsp elbow'),
    ('M06031', 'Rheumatoid arthritis without rheumatoid factor, right wrist'),
    ('M06032', 'Rheumatoid arthritis without rheumatoid factor, left wrist'),
    ('M06039', 'Rheumatoid arthritis without rheumatoid factor, unsp wrist'),
    ('M06041', 'Rheumatoid arthritis without rheumatoid factor, right hand'),
    ('M06042', 'Rheumatoid arthritis without rheumatoid factor, left hand'),
    ('M06049', 'Rheumatoid arthritis without rheumatoid factor, unsp hand'),
    ('M06051', 'Rheumatoid arthritis without rheumatoid factor, right hip'),
    ('M06052', 'Rheumatoid arthritis without rheumatoid factor, left hip'),
    ('M06059', 'Rheumatoid arthritis without rheumatoid factor, unsp hip'),
    ('M06061', 'Rheumatoid arthritis without rheumatoid factor, right knee'),
    ('M06062', 'Rheumatoid arthritis without rheumatoid factor, left knee'),
    ('M06069', 'Rheumatoid arthritis without rheumatoid factor, unsp knee'),
    ('M06071', 'Rheumatoid arthritis w/o rheumatoid factor, right ank/ft'),
    ('M06072', 'Rheumatoid arthritis w/o rheumatoid factor, left ank/ft'),
    ('M06079', 'Rheumatoid arthritis w/o rheumatoid factor, unsp ank/ft'),
    ('M0608', 'Rheumatoid arthritis without rheumatoid factor, vertebrae'),
    ('M0609', 'Rheumatoid arthritis w/o rheumatoid factor, multiple sites'),
    ('M060A', 'Rheumatoid arthritis without rheumatoid factor, oth site'),
    ('M061', "Adult-onset Still's disease"),
    ('M0620', 'Rheumatoid bursitis, unspecified site'),
    ('M06211', 'Rheumatoid bursitis, right shoulder'),
    ('M06212', 'Rheumatoid bursitis, left shoulder'),
    ('M06219', 'Rheumatoid bursitis, unspecified shoulder'),
    ('M06221', 'Rheumatoid bursitis, right elbow'),
    ('M06222', 'Rheumatoid bursitis, left elbow'),
    ('M06229', 'Rheumatoid bursitis, unspecified elbow'),
    ('M06231', 'Rheumatoid bursitis, right wrist'),
    ('M06232', 'Rheumatoid bursitis, left wrist'),
    ('M06239', 'Rheumatoid bursitis, unspecified wrist'),
    ('M06241', 'Rheumatoid bursitis, right hand'),
    ('M06242', 'Rheumatoid bursitis, left hand'),
    ('M06249', 'Rheumatoid bursitis, unspecified hand'),
    ('M06251', 'Rheumatoid bursitis, right hip'),
    ('M06252', 'Rheumatoid bursitis, left hip'),
    ('M06259', 'Rheumatoid bursitis, unspecified hip'),
    ('M06261', 'Rheumatoid bursitis, right knee'),
    ('M06262', 'Rheumatoid bursitis, left knee'),
    ('M06269', 'Rheumatoid bursitis, unspecified knee'),
    ('M06271', 'Rheumatoid bursitis, right ankle and foot'),
    ('M06272', 'Rheumatoid bursitis, left ankle and foot'),
    ('M06279', 'Rheumatoid bursitis, unspecified ankle and foot'),
    ('M0628', 'Rheumatoid bursitis, vertebrae'),
    ('M0629', 'Rheumatoid bursitis, multiple sites'),
    ('M0630', 'Rheumatoid nodule, unspecified site'),
    ('M06311', 'Rheumatoid nodule, right shoulder'),
    ('M06312', 'Rheumatoid nodule, left shoulder'),
    ('M06319', 'Rheumatoid nodule, unspecified shoulder'),
    ('M06321', 'Rheumatoid nodule, right elbow'),
    ('M06322', 'Rheumatoid nodule, left elbow'),
    ('M06329', 'Rheumatoid nodule, unspecified elbow'),
    ('M06331', 'Rheumatoid nodule, right wrist'),
    ('M06332', 'Rheumatoid nodule, left wrist'),
    ('M06339', 'Rheumatoid nodule, unspecified wrist'),
    ('M06341', 'Rheumatoid nodule, right hand'),
    ('M06342', 'Rheumatoid nodule, left hand'),
    ('M06349', 'Rheumatoid nodule, unspecified hand'),
    ('M06351', 'Rheumatoid nodule, right hip'),
    ('M06352', 'Rheumatoid nodule, left hip'),
    ('M06359', 'Rheumatoid nodule, unspecified hip'),
    ('M06361', 'Rheumatoid nodule, right knee'),
    ('M06362', 'Rheumatoid nodule, left knee'),
    ('M06369', 'Rheumatoid nodule, unspecified knee'),
    ('M06371', 'Rheumatoid nodule, right ankle and foot'),
    ('M06372', 'Rheumatoid nodule, left ankle and foot'),
    ('M06379', 'Rheumatoid nodule, unspecified ankle and foot'),
    ('M0638', 'Rheumatoid nodule, vertebrae'),
    ('M0639', 'Rheumatoid nodule, multiple sites'),
    ('M064', 'Inflammatory polyarthropathy'),
    ('M0680', 'Other specified rheumatoid arthritis, unspecified site'),
    ('M06811', 'Other specified rheumatoid arthritis, right shoulder'),
    ('M06812', 'Other specified rheumatoid arthritis, left shoulder'),
    ('M06819', 'Other specified rheumatoid arthritis, unspecified shoulder'),
    ('M06821', 'Other specified rheumatoid arthritis, right elbow'),
    ('M06822', 'Other specified rheumatoid arthritis, left elbow'),
    ('M06829', 'Other specified rheumatoid arthritis, unspecified elbow'),
    ('M06831', 'Other specified rheumatoid arthritis, right wrist'),
    ('M06832', 'Other specified rheumatoid arthritis, left wrist'),
    ('M06839', 'Other specified rheumatoid arthritis, unspecified wrist'),
    ('M06841', 'Other specified rheumatoid arthritis, right hand'),
    ('M06842', 'Other specified rheumatoid arthritis, left hand'),
    ('M06849', 'Other specified rheumatoid arthritis, unspecified hand'),
    ('M06851', 'Other specified rheumatoid arthritis, right hip'),
    ('M06852', 'Other specified rheumatoid arthritis, left hip'),
    ('M06859', 'Other specified rheumatoid arthritis, unspecified hip'),
    ('M06861', 'Other specified rheumatoid arthritis, right knee'),
    ('M06862', 'Other specified rheumatoid arthritis, left knee'),
    ('M06869', 'Other specified rheumatoid arthritis, unspecified knee'),
    ('M06871', 'Other specified rheumatoid arthritis, right ankle and foot'),
    ('M06872', 'Other specified rheumatoid arthritis, left ankle and foot'),
    ('M06879', 'Oth rheumatoid arthritis, unspecified ankle and foot'),
    ('M0688', 'Other specified rheumatoid arthritis, vertebrae'),
    ('M0689', 'Other specified rheumatoid arthritis, multiple sites'),
    ('M068A ', 'Other specified rheumatoid arthritis, other specified site'),
    ('M069', 'Rheumatoid arthritis, unspecified'),
    ('M0760', 'Enteropathic arthropathies, unspecified site'),
    ('M07611', 'Enteropathic arthropathies, right shoulder'),
    ('M07612', 'Enteropathic arthropathies, left shoulder'),
    ('M07619', 'Enteropathic arthropathies, unspecified shoulder'),
    ('M07621', 'Enteropathic arthropathies, right elbow'),
    ('M07622', 'Enteropathic arthropathies, left elbow'),
    ('M07629', 'Enteropathic arthropathies, unspecified elbow'),
    ('M07631', 'Enteropathic arthropathies, right wrist'),
    ('M07632', 'Enteropathic arthropathies, left wrist'),
    ('M07639', 'Enteropathic arthropathies, unspecified wrist'),
    ('M07641', 'Enteropathic arthropathies, right hand'),
    ('M07642', 'Enteropathic arthropathies, left hand'),
    ('M07649', 'Enteropathic arthropathies, unspecified hand'),
    ('M07651', 'Enteropathic arthropathies, right hip'),
    ('M07652', 'Enteropathic arthropathies, left hip'),
    ('M07659', 'Enteropathic arthropathies, unspecified hip'),
    ('M07661', 'Enteropathic arthropathies, right knee'),
    ('M07662', 'Enteropathic arthropathies, left knee'),
    ('M07669', 'Enteropathic arthropathies, unspecified knee'),
    ('M07671', 'Enteropathic arthropathies, right ankle and foot'),
    ('M07672', 'Enteropathic arthropathies, left ankle and foot'),
    ('M07679', 'Enteropathic arthropathies, unspecified ankle and foot'),
    ('M0768', 'Enteropathic arthropathies, vertebrae'),
    ('M0769', 'Enteropathic arthropathies, multiple sites'),
    ('M0800', 'Unsp juvenile rheumatoid arthritis of unspecified site'),
    ('M08011', 'Unspecified juvenile rheumatoid arthritis, right shoulder'),
    ('M08012', 'Unspecified juvenile rheumatoid arthritis, left shoulder'),
    ('M08019', 'Unsp juvenile rheumatoid arthritis, unspecified shoulder'),
    ('M08021', 'Unspecified juvenile rheumatoid arthritis, right elbow'),
    ('M08022', 'Unspecified juvenile rheumatoid arthritis, left elbow'),
    ('M08029', 'Unspecified juvenile rheumatoid arthritis, unspecified elbow'),
    ('M08031', 'Unspecified juvenile rheumatoid arthritis, right wrist'),
    ('M08032', 'Unspecified juvenile rheumatoid arthritis, left wrist'),
    ('M08039', 'Unspecified juvenile rheumatoid arthritis, unspecified wrist'),
    ('M08041', 'Unspecified juvenile rheumatoid arthritis, right hand'),
    ('M08042', 'Unspecified juvenile rheumatoid arthritis, left hand'),
    ('M08049', 'Unspecified juvenile rheumatoid arthritis, unspecified hand'),
    ('M08051', 'Unspecified juvenile rheumatoid arthritis, right hip'),
    ('M08052', 'Unspecified juvenile rheumatoid arthritis, left hip'),
    ('M08059', 'Unspecified juvenile rheumatoid arthritis, unspecified hip'),
    ('M08061', 'Unspecified juvenile rheumatoid arthritis, right knee'),
    ('M08062', 'Unspecified juvenile rheumatoid arthritis, left knee'),
    ('M08069', 'Unspecified juvenile rheumatoid arthritis, unspecified knee'),
    ('M08071', 'Unsp juvenile rheumatoid arthritis, right ankle and foot'),
    ('M08072', 'Unsp juvenile rheumatoid arthritis, left ankle and foot'),
    ('M08079', 'Unsp juvenile rheumatoid arthritis, unsp ankle and foot'),
    ('M0808', 'Unspecified juvenile rheumatoid arthritis, vertebrae'),
    ('M0809', 'Unspecified juvenile rheumatoid arthritis, multiple sites'),
    ('M080A', 'Unspecified juvenile rheumatoid arthritis, oth site'),
    ('M081', 'Juvenile ankylosing spondylitis'),
    ('M0820', 'Juvenile rheumatoid arthritis with systemic onset, unsp site'),
    ('M08211', 'Juvenile rheumatoid arthritis w systemic onset, r shoulder'),
    ('M08212', 'Juvenile rheumatoid arthritis w systemic onset, l shoulder'),
    ('M08219', 'Juvenile rheu arthritis w systemic onset, unsp shoulder'),
    ('M08221', 'Juvenile rheumatoid arthritis w systemic onset, right elbow'),
    ('M08222', 'Juvenile rheumatoid arthritis w systemic onset, left elbow'),
    ('M08229', 'Juvenile rheumatoid arthritis w systemic onset, unsp elbow'),
    ('M08231', 'Juvenile rheumatoid arthritis w systemic onset, right wrist'),
    ('M08232', 'Juvenile rheumatoid arthritis w systemic onset, left wrist'),
    ('M08239', 'Juvenile rheumatoid arthritis w systemic onset, unsp wrist'),
    ('M08241', 'Juvenile rheumatoid arthritis w systemic onset, right hand'),
    ('M08242', 'Juvenile rheumatoid arthritis with systemic onset, left hand'),
    ('M08249', 'Juvenile rheumatoid arthritis with systemic onset, unsp hand'),
    ('M08251', 'Juvenile rheumatoid arthritis with systemic onset, right hip'),
    ('M08252', 'Juvenile rheumatoid arthritis with systemic onset, left hip'),
    ('M08259', 'Juvenile rheumatoid arthritis with systemic onset, unsp hip'),
    ('M08261', 'Juvenile rheumatoid arthritis w systemic onset, right knee'),
    ('M08262', 'Juvenile rheumatoid arthritis with systemic onset, left knee'),
    ('M08269', 'Juvenile rheumatoid arthritis with systemic onset, unsp knee'),
    ('M08271', 'Juvenile rheumatoid arthritis w systemic onset, right ank/ft'),
    ('M08272', 'Juvenile rheumatoid arthritis w systemic onset, left ank/ft'),
    ('M08279', 'Juvenile rheumatoid arthritis w systemic onset, unsp ank/ft'),
    ('M0828', 'Juvenile rheumatoid arthritis with systemic onset, vertebrae'),
    ('M0829', 'Juvenile rheu arthritis w systemic onset, multiple sites'),
    ('M082A', 'Juvenile rheumatoid arthritis with systemic onset, oth site'),
    ('M083', 'Juvenile rheumatoid polyarthritis (seronegative)'),
    ('M0840', 'Pauciarticular juvenile rheumatoid arthritis, unsp site'),
    ('M08411', 'Pauciarticular juvenile rheumatoid arthritis, right shoulder'),
    ('M08412', 'Pauciarticular juvenile rheumatoid arthritis, left shoulder'),
    ('M08419', 'Pauciarticular juvenile rheumatoid arthritis, unsp shoulder'),
    ('M08421', 'Pauciarticular juvenile rheumatoid arthritis, right elbow'),
    ('M08422', 'Pauciarticular juvenile rheumatoid arthritis, left elbow'),
    ('M08429', 'Pauciarticular juvenile rheumatoid arthritis, unsp elbow'),
    ('M08431', 'Pauciarticular juvenile rheumatoid arthritis, right wrist'),
    ('M08432', 'Pauciarticular juvenile rheumatoid arthritis, left wrist'),
    ('M08439', 'Pauciarticular juvenile rheumatoid arthritis, unsp wrist'),
    ('M08441', 'Pauciarticular juvenile rheumatoid arthritis, right hand'),
    ('M08442', 'Pauciarticular juvenile rheumatoid arthritis, left hand'),
    ('M08449', 'Pauciarticular juvenile rheumatoid arthritis, unsp hand'),
    ('M08451', 'Pauciarticular juvenile rheumatoid arthritis, right hip'),
    ('M08452', 'Pauciarticular juvenile rheumatoid arthritis, left hip'),
    ('M08459', 'Pauciarticular juvenile rheumatoid arthritis, unsp hip'),
    ('M08461', 'Pauciarticular juvenile rheumatoid arthritis, right knee'),
    ('M08462', 'Pauciarticular juvenile rheumatoid arthritis, left knee'),
    ('M08469', 'Pauciarticular juvenile rheumatoid arthritis, unsp knee'),
    ('M08471', 'Pauciarticular juvenile rheumatoid arthritis, right ank/ft'),
    ('M08472', 'Pauciarticular juvenile rheumatoid arthritis, left ank/ft'),
    ('M08479', 'Pauciarticular juvenile rheumatoid arthritis, unsp ank/ft'),
    ('M0848', 'Pauciarticular juvenile rheumatoid arthritis, vertebrae'),
    ('M084A', 'Pauciarticular juvenile rheumatoid arthritis, oth site'),
    ('M0880', 'Other juvenile arthritis, unspecified site'),
    ('M08811', 'Other juvenile arthritis, right shoulder'),
    ('M08812', 'Other juvenile arthritis, left shoulder'),
    ('M08819', 'Other juvenile arthritis, unspecified shoulder'),
    ('M08821', 'Other juvenile arthritis, right elbow'),
    ('M08822', 'Other juvenile arthritis, left elbow'),
    ('M08829', 'Other juvenile arthritis, unspecified elbow'),
    ('M08831', 'Other juvenile arthritis, right wrist'),
    ('M08832', 'Other juvenile arthritis, left wrist'),
    ('M08839', 'Other juvenile arthritis, unspecified wrist'),
    ('M08841', 'Other juvenile arthritis, right hand'),
    ('M08842', 'Other juvenile arthritis, left hand'),
    ('M08849', 'Other juvenile arthritis, unspecified hand'),
    ('M08851', 'Other juvenile arthritis, right hip'),
    ('M08852', 'Other juvenile arthritis, left hip'),
    ('M08859', 'Other juvenile arthritis, unspecified hip'),
    ('M08861', 'Other juvenile arthritis, right knee'),
    ('M08862', 'Other juvenile arthritis, left knee'),
    ('M08869', 'Other juvenile arthritis, unspecified knee'),
    ('M08871', 'Other juvenile arthritis, right ankle and foot'),
    ('M08872', 'Other juvenile arthritis, left ankle and foot'),
    ('M08879', 'Other juvenile arthritis, unspecified ankle and foot'),
    ('M0888', 'Other juvenile arthritis, vertebrae'),
    ('M0889', 'Other juvenile arthritis, multiple sites'),
    ('M0890', 'Juvenile arthritis, unspecified, unspecified site'),
    ('M08911', 'Juvenile arthritis, unspecified, right shoulder'),
    ('M08912', 'Juvenile arthritis, unspecified, left shoulder'),
    ('M08919', 'Juvenile arthritis, unspecified, unspecified shoulder'),
    ('M08921', 'Juvenile arthritis, unspecified, right elbow'),
    ('M08922', 'Juvenile arthritis, unspecified, left elbow'),
    ('M08929', 'Juvenile arthritis, unspecified, unspecified elbow'),
    ('M08931', 'Juvenile arthritis, unspecified, right wrist'),
    ('M08932', 'Juvenile arthritis, unspecified, left wrist'),
    ('M08939', 'Juvenile arthritis, unspecified, unspecified wrist'),
    ('M08941', 'Juvenile arthritis, unspecified, right hand'),
    ('M08942', 'Juvenile arthritis, unspecified, left hand'),
    ('M08949', 'Juvenile arthritis, unspecified, unspecified hand'),
    ('M08951', 'Juvenile arthritis, unspecified, right hip'),
    ('M08952', 'Juvenile arthritis, unspecified, left hip'),
    ('M08959', 'Juvenile arthritis, unspecified, unspecified hip'),
    ('M08961', 'Juvenile arthritis, unspecified, right knee'),
    ('M08962', 'Juvenile arthritis, unspecified, left knee'),
    ('M08969', 'Juvenile arthritis, unspecified, unspecified knee'),
    ('M08971', 'Juvenile arthritis, unspecified, right ankle and foot'),
    ('M08972', 'Juvenile arthritis, unspecified, left ankle and foot'),
    ('M08979', 'Juvenile arthritis, unspecified, unspecified ankle and foot'),
    ('M0898', 'Juvenile arthritis, unspecified, vertebrae'),
    ('M0899', 'Juvenile arthritis, unspecified, multiple sites'),
    ('M089A', 'Juvenile arthritis, unspecified, other specified site'),
    ('M1000', 'Idiopathic gout, unspecified site'),
    ('M10011', 'Idiopathic gout, right shoulder'),
    ('M10012', 'Idiopathic gout, left shoulder'),
    ('M10019', 'Idiopathic gout, unspecified shoulder'),
    ('M10021', 'Idiopathic gout, right elbow'),
    ('M10022', 'Idiopathic gout, left elbow'),
    ('M10029', 'Idiopathic gout, unspecified elbow'),
    ('M10031', 'Idiopathic gout, right wrist'),
    ('M10032', 'Idiopathic gout, left wrist'),
    ('M10039', 'Idiopathic gout, unspecified wrist'),
    ('M10041', 'Idiopathic gout, right hand'),
    ('M10042', 'Idiopathic gout, left hand'),
    ('M10049', 'Idiopathic gout, unspecified hand'),
    ('M10051', 'Idiopathic gout, right hip'),
    ('M10052', 'Idiopathic gout, left hip'),
    ('M10059', 'Idiopathic gout, unspecified hip'),
    ('M10061', 'Idiopathic gout, right knee'),
    ('M10062', 'Idiopathic gout, left knee'),
    ('M10069', 'Idiopathic gout, unspecified knee'),
    ('M10071', 'Idiopathic gout, right ankle and foot'),
    ('M10072', 'Idiopathic gout, left ankle and foot'),
    ('M10079', 'Idiopathic gout, unspecified ankle and foot'),
    ('M1008', 'Idiopathic gout, vertebrae'),
    ('M1009', 'Idiopathic gout, multiple sites'),
    ('M1010', 'Lead-induced gout, unspecified site'),
    ('M10111', 'Lead-induced gout, right shoulder'),
    ('M10112', 'Lead-induced gout, left shoulder'),
    ('M10119', 'Lead-induced gout, unspecified shoulder'),
    ('M10121', 'Lead-induced gout, right elbow'),
    ('M10122', 'Lead-induced gout, left elbow'),
    ('M10129', 'Lead-induced gout, unspecified elbow'),
    ('M10131', 'Lead-induced gout, right wrist'),
    ('M10132', 'Lead-induced gout, left wrist'),
    ('M10139', 'Lead-induced gout, unspecified wrist'),
    ('M10141', 'Lead-induced gout, right hand'),
    ('M10142', 'Lead-induced gout, left hand'),
    ('M10149', 'Lead-induced gout, unspecified hand'),
    ('M10151', 'Lead-induced gout, right hip'),
    ('M10152', 'Lead-induced gout, left hip'),
    ('M10159', 'Lead-induced gout, unspecified hip'),
    ('M10161', 'Lead-induced gout, right knee'),
    ('M10162', 'Lead-induced gout, left knee'),
    ('M10169', 'Lead-induced gout, unspecified knee'),
    ('M10171', 'Lead-induced gout, right ankle and foot'),
    ('M10172', 'Lead-induced gout, left ankle and foot'),
    ('M10179', 'Lead-induced gout, unspecified ankle and foot'),
    ('M1018', 'Lead-induced gout, vertebrae'),
    ('M1019', 'Lead-induced gout, multiple sites'),
    ('M1020', 'Drug-induced gout, unspecified site'),
    ('M10211', 'Drug-induced gout, right shoulder'),
    ('M10212', 'Drug-induced gout, left shoulder'),
    ('M10219', 'Drug-induced gout, unspecified shoulder'),
    ('M10221', 'Drug-induced gout, right elbow'),
    ('M10222', 'Drug-induced gout, left elbow'),
    ('M10229', 'Drug-induced gout, unspecified elbow'),
    ('M10231', 'Drug-induced gout, right wrist'),
    ('M10232', 'Drug-induced gout, left wrist'),
    ('M10239', 'Drug-induced gout, unspecified wrist'),
    ('M10241', 'Drug-induced gout, right hand'),
    ('M10242', 'Drug-induced gout, left hand'),
    ('M10249', 'Drug-induced gout, unspecified hand'),
    ('M10251', 'Drug-induced gout, right hip'),
    ('M10252', 'Drug-induced gout, left hip'),
    ('M10259', 'Drug-induced gout, unspecified hip'),
    ('M10261', 'Drug-induced gout, right knee'),
    ('M10262', 'Drug-induced gout, left knee'),
    ('M10269', 'Drug-induced gout, unspecified knee'),
    ('M10271', 'Drug-induced gout, right ankle and foot'),
    ('M10272', 'Drug-induced gout, left ankle and foot'),
    ('M10279', 'Drug-induced gout, unspecified ankle and foot'),
    ('M1028', 'Drug-induced gout, vertebrae'),
    ('M1029', 'Drug-induced gout, multiple sites'),
    ('M1030', 'Gout due to renal impairment, unspecified site'),
    ('M10311', 'Gout due to renal impairment, right shoulder'),
    ('M10312', 'Gout due to renal impairment, left shoulder'),
    ('M10319', 'Gout due to renal impairment, unspecified shoulder'),
    ('M10321', 'Gout due to renal impairment, right elbow'),
    ('M10322', 'Gout due to renal impairment, left elbow'),
    ('M10329', 'Gout due to renal impairment, unspecified elbow'),
    ('M10331', 'Gout due to renal impairment, right wrist'),
    ('M10332', 'Gout due to renal impairment, left wrist'),
    ('M10339', 'Gout due to renal impairment, unspecified wrist'),
    ('M10341', 'Gout due to renal impairment, right hand'),
    ('M10342', 'Gout due to renal impairment, left hand'),
    ('M10349', 'Gout due to renal impairment, unspecified hand'),
    ('M10351', 'Gout due to renal impairment, right hip'),
    ('M10352', 'Gout due to renal impairment, left hip'),
    ('M10359', 'Gout due to renal impairment, unspecified hip'),
    ('M10361', 'Gout due to renal impairment, right knee'),
    ('M10362', 'Gout due to renal impairment, left knee'),
    ('M10369', 'Gout due to renal impairment, unspecified knee'),
    ('M10371', 'Gout due to renal impairment, right ankle and foot'),
    ('M10372', 'Gout due to renal impairment, left ankle and foot'),
    ('M10379', 'Gout due to renal impairment, unspecified ankle and foot'),
    ('M1038', 'Gout due to renal impairment, vertebrae'),
    ('M1039', 'Gout due to renal impairment, multiple sites'),
    ('M1040', 'Other secondary gout, unspecified site'),
    ('M10411', 'Other secondary gout, right shoulder'),
    ('M10412', 'Other secondary gout, left shoulder'),
    ('M10419', 'Other secondary gout, unspecified shoulder'),
    ('M10421', 'Other secondary gout, right elbow'),
    ('M10422', 'Other secondary gout, left elbow'),
    ('M10429', 'Other secondary gout, unspecified elbow'),
    ('M10431', 'Other secondary gout, right wrist'),
    ('M10432', 'Other secondary gout, left wrist'),
    ('M10439', 'Other secondary gout, unspecified wrist'),
    ('M10441', 'Other secondary gout, right hand'),
    ('M10442', 'Other secondary gout, left hand'),
    ('M10449', 'Other secondary gout, unspecified hand'),
    ('M10451', 'Other secondary gout, right hip'),
    ('M10452', 'Other secondary gout, left hip'),
    ('M10459', 'Other secondary gout, unspecified hip'),
    ('M10461', 'Other secondary gout, right knee'),
    ('M10462', 'Other secondary gout, left knee'),
    ('M10469', 'Other secondary gout, unspecified knee'),
    ('M10471', 'Other secondary gout, right ankle and foot'),
    ('M10472', 'Other secondary gout, left ankle and foot'),
    ('M10479', 'Other secondary gout, unspecified ankle and foot'),
    ('M1048', 'Other secondary gout, vertebrae'),
    ('M1049', 'Other secondary gout, multiple sites'),
    ('M109', 'Gout, unspecified'),
    ('M1100', 'Hydroxyapatite deposition disease, unspecified site'),
    ('M11011', 'Hydroxyapatite deposition disease, right shoulder'),
    ('M11012', 'Hydroxyapatite deposition disease, left shoulder'),
    ('M11019', 'Hydroxyapatite deposition disease, unspecified shoulder'),
    ('M11021', 'Hydroxyapatite deposition disease, right elbow'),
    ('M11022', 'Hydroxyapatite deposition disease, left elbow'),
    ('M11029', 'Hydroxyapatite deposition disease, unspecified elbow'),
    ('M11031', 'Hydroxyapatite deposition disease, right wrist'),
    ('M11032', 'Hydroxyapatite deposition disease, left wrist'),
    ('M11039', 'Hydroxyapatite deposition disease, unspecified wrist'),
    ('M11041', 'Hydroxyapatite deposition disease, right hand'),
    ('M11042', 'Hydroxyapatite deposition disease, left hand'),
    ('M11049', 'Hydroxyapatite deposition disease, unspecified hand'),
    ('M11051', 'Hydroxyapatite deposition disease, right hip'),
    ('M11052', 'Hydroxyapatite deposition disease, left hip'),
    ('M11059', 'Hydroxyapatite deposition disease, unspecified hip'),
    ('M11061', 'Hydroxyapatite deposition disease, right knee'),
    ('M11062', 'Hydroxyapatite deposition disease, left knee'),
    ('M11069', 'Hydroxyapatite deposition disease, unspecified knee'),
    ('M11071', 'Hydroxyapatite deposition disease, right ankle and foot'),
    ('M11072', 'Hydroxyapatite deposition disease, left ankle and foot'),
    ('M11079', 'Hydroxyapatite deposition disease, unsp ankle and foot'),
    ('M1108', 'Hydroxyapatite deposition disease, vertebrae'),
    ('M1109', 'Hydroxyapatite deposition disease, multiple sites'),
    ('M1110', 'Familial chondrocalcinosis, unspecified site'),
    ('M11111', 'Familial chondrocalcinosis, right shoulder'),
    ('M11112', 'Familial chondrocalcinosis, left shoulder'),
    ('M11119', 'Familial chondrocalcinosis, unspecified shoulder'),
    ('M11121', 'Familial chondrocalcinosis, right elbow'),
    ('M11122', 'Familial chondrocalcinosis, left elbow'),
    ('M11129', 'Familial chondrocalcinosis, unspecified elbow'),
    ('M11131', 'Familial chondrocalcinosis, right wrist'),
    ('M11132', 'Familial chondrocalcinosis, left wrist'),
    ('M11139', 'Familial chondrocalcinosis, unspecified wrist'),
    ('M11141', 'Familial chondrocalcinosis, right hand'),
    ('M11142', 'Familial chondrocalcinosis, left hand'),
    ('M11149', 'Familial chondrocalcinosis, unspecified hand'),
    ('M11151', 'Familial chondrocalcinosis, right hip'),
    ('M11152', 'Familial chondrocalcinosis, left hip'),
    ('M11159', 'Familial chondrocalcinosis, unspecified hip'),
    ('M11161', 'Familial chondrocalcinosis, right knee'),
    ('M11162', 'Familial chondrocalcinosis, left knee'),
    ('M11169', 'Familial chondrocalcinosis, unspecified knee'),
    ('M11171', 'Familial chondrocalcinosis, right ankle and foot'),
    ('M11172', 'Familial chondrocalcinosis, left ankle and foot'),
    ('M11179', 'Familial chondrocalcinosis, unspecified ankle and foot'),
    ('M1118', 'Familial chondrocalcinosis, vertebrae'),
    ('M1119', 'Familial chondrocalcinosis, multiple sites'),
    ('M1120', 'Other chondrocalcinosis, unspecified site'),
    ('M11211', 'Other chondrocalcinosis, right shoulder'),
    ('M11212', 'Other chondrocalcinosis, left shoulder'),
    ('M11219', 'Other chondrocalcinosis, unspecified shoulder'),
    ('M11221', 'Other chondrocalcinosis, right elbow'),
    ('M11222', 'Other chondrocalcinosis, left elbow'),
    ('M11229', 'Other chondrocalcinosis, unspecified elbow'),
    ('M11231', 'Other chondrocalcinosis, right wrist'),
    ('M11232', 'Other chondrocalcinosis, left wrist'),
    ('M11239', 'Other chondrocalcinosis, unspecified wrist'),
    ('M11241', 'Other chondrocalcinosis, right hand'),
    ('M11242', 'Other chondrocalcinosis, left hand'),
    ('M11249', 'Other chondrocalcinosis, unspecified hand'),
    ('M11251', 'Other chondrocalcinosis, right hip'),
    ('M11252', 'Other chondrocalcinosis, left hip'),
    ('M11259', 'Other chondrocalcinosis, unspecified hip'),
    ('M11261', 'Other chondrocalcinosis, right knee'),
    ('M11262', 'Other chondrocalcinosis, left knee'),
    ('M11269', 'Other chondrocalcinosis, unspecified knee'),
    ('M11271', 'Other chondrocalcinosis, right ankle and foot'),
    ('M11272', 'Other chondrocalcinosis, left ankle and foot'),
    ('M11279', 'Other chondrocalcinosis, unspecified ankle and foot'),
    ('M1128', 'Other chondrocalcinosis, vertebrae'),
    ('M1129', 'Other chondrocalcinosis, multiple sites'),
    ('M1180', 'Other specified crystal arthropathies, unspecified site'),
    ('M11811', 'Other specified crystal arthropathies, right shoulder'),
    ('M11812', 'Other specified crystal arthropathies, left shoulder'),
    ('M11819', 'Other specified crystal arthropathies, unspecified shoulder'),
    ('M11821', 'Other specified crystal arthropathies, right elbow'),
    ('M11822', 'Other specified crystal arthropathies, left elbow'),
    ('M11829', 'Other specified crystal arthropathies, unspecified elbow'),
    ('M11831', 'Other specified crystal arthropathies, right wrist'),
    ('M11832', 'Other specified crystal arthropathies, left wrist'),
    ('M11839', 'Other specified crystal arthropathies, unspecified wrist'),
    ('M11841', 'Other specified crystal arthropathies, right hand'),
    ('M11842', 'Other specified crystal arthropathies, left hand'),
    ('M11849', 'Other specified crystal arthropathies, unspecified hand'),
    ('M11851', 'Other specified crystal arthropathies, right hip'),
    ('M11852', 'Other specified crystal arthropathies, left hip'),
    ('M11859', 'Other specified crystal arthropathies, unspecified hip'),
    ('M11861', 'Other specified crystal arthropathies, right knee'),
    ('M11862', 'Other specified crystal arthropathies, left knee'),
    ('M11869', 'Other specified crystal arthropathies, unspecified knee'),
    ('M11871', 'Other specified crystal arthropathies, right ankle and foot'),
    ('M11872', 'Other specified crystal arthropathies, left ankle and foot'),
    ('M11879', 'Oth crystal arthropathies, unspecified ankle and foot'),
    ('M1188', 'Other specified crystal arthropathies, vertebrae'),
    ('M1189', 'Other specified crystal arthropathies, multiple sites'),
    ('M119', 'Crystal arthropathy, unspecified'),
    ('M1200', 'Chronic postrheumatic arthropathy, unspecified site'),
    ('M12011', 'Chronic postrheumatic arthropathy [Jaccoud], right shoulder'),
    ('M12012', 'Chronic postrheumatic arthropathy [Jaccoud], left shoulder'),
    ('M12019', 'Chronic postrheumatic arthropathy, unspecified shoulder'),
    ('M12021', 'Chronic postrheumatic arthropathy [Jaccoud], right elbow'),
    ('M12022', 'Chronic postrheumatic arthropathy [Jaccoud], left elbow'),
    ('M12029', 'Chronic postrheumatic arthropathy, unspecified elbow'),
    ('M12031', 'Chronic postrheumatic arthropathy [Jaccoud], right wrist'),
    ('M12032', 'Chronic postrheumatic arthropathy [Jaccoud], left wrist'),
    ('M12039', 'Chronic postrheumatic arthropathy, unspecified wrist'),
    ('M12041', 'Chronic postrheumatic arthropathy [Jaccoud], right hand'),
    ('M12042', 'Chronic postrheumatic arthropathy [Jaccoud], left hand'),
    ('M12049', 'Chronic postrheumatic arthropathy, unspecified hand'),
    ('M12051', 'Chronic postrheumatic arthropathy [Jaccoud], right hip'),
    ('M12052', 'Chronic postrheumatic arthropathy [Jaccoud], left hip'),
    ('M12059', 'Chronic postrheumatic arthropathy [Jaccoud], unspecified hip'),
    ('M12061', 'Chronic postrheumatic arthropathy [Jaccoud], right knee'),
    ('M12062', 'Chronic postrheumatic arthropathy [Jaccoud], left knee'),
    ('M12069', 'Chronic postrheumatic arthropathy, unspecified knee'),
    ('M12071', 'Chronic postrheumatic arthropathy, right ankle and foot'),
    ('M12072', 'Chronic postrheumatic arthropathy, left ankle and foot'),
    ('M12079', 'Chronic postrheumatic arthropathy, unsp ankle and foot'),
    ('M1208', 'Chronic postrheumatic arthropathy [Jaccoud], vertebrae'),
    ('M1209', 'Chronic postrheumatic arthropathy [Jaccoud], multiple sites'),
    ('M1210', 'Kaschin-Beck disease, unspecified site'),
    ('M12111', 'Kaschin-Beck disease, right shoulder'),
    ('M12112', 'Kaschin-Beck disease, left shoulder'),
    ('M12119', 'Kaschin-Beck disease, unspecified shoulder'),
    ('M12121', 'Kaschin-Beck disease, right elbow'),
    ('M12122', 'Kaschin-Beck disease, left elbow'),
    ('M12129', 'Kaschin-Beck disease, unspecified elbow'),
    ('M12131', 'Kaschin-Beck disease, right wrist'),
    ('M12132', 'Kaschin-Beck disease, left wrist'),
    ('M12139', 'Kaschin-Beck disease, unspecified wrist'),
    ('M12141', 'Kaschin-Beck disease, right hand'),
    ('M12142', 'Kaschin-Beck disease, left hand'),
    ('M12149', 'Kaschin-Beck disease, unspecified hand'),
    ('M12151', 'Kaschin-Beck disease, right hip'),
    ('M12152', 'Kaschin-Beck disease, left hip'),
    ('M12159', 'Kaschin-Beck disease, unspecified hip'),
    ('M12161', 'Kaschin-Beck disease, right knee'),
    ('M12162', 'Kaschin-Beck disease, left knee'),
    ('M12169', 'Kaschin-Beck disease, unspecified knee'),
    ('M12171', 'Kaschin-Beck disease, right ankle and foot'),
    ('M12172', 'Kaschin-Beck disease, left ankle and foot'),
    ('M12179', 'Kaschin-Beck disease, unspecified ankle and foot'),
    ('M1218', 'Kaschin-Beck disease, vertebrae'),
    ('M1219', 'Kaschin-Beck disease, multiple sites'),
    ('M1220', 'Villonodular synovitis (pigmented), unspecified site'),
    ('M12211', 'Villonodular synovitis (pigmented), right shoulder'),
    ('M12212', 'Villonodular synovitis (pigmented), left shoulder'),
    ('M12219', 'Villonodular synovitis (pigmented), unspecified shoulder'),
    ('M12221', 'Villonodular synovitis (pigmented), right elbow'),
    ('M12222', 'Villonodular synovitis (pigmented), left elbow'),
    ('M12229', 'Villonodular synovitis (pigmented), unspecified elbow'),
    ('M12231', 'Villonodular synovitis (pigmented), right wrist'),
    ('M12232', 'Villonodular synovitis (pigmented), left wrist'),
    ('M12239', 'Villonodular synovitis (pigmented), unspecified wrist'),
    ('M12241', 'Villonodular synovitis (pigmented), right hand'),
    ('M12242', 'Villonodular synovitis (pigmented), left hand'),
    ('M12249', 'Villonodular synovitis (pigmented), unspecified hand'),
    ('M12251', 'Villonodular synovitis (pigmented), right hip'),
    ('M12252', 'Villonodular synovitis (pigmented), left hip'),
    ('M12259', 'Villonodular synovitis (pigmented), unspecified hip'),
    ('M12261', 'Villonodular synovitis (pigmented), right knee'),
    ('M12262', 'Villonodular synovitis (pigmented), left knee'),
    ('M12269', 'Villonodular synovitis (pigmented), unspecified knee'),
    ('M12271', 'Villonodular synovitis (pigmented), right ankle and foot'),
    ('M12272', 'Villonodular synovitis (pigmented), left ankle and foot'),
    ('M12279', 'Villonodular synovitis (pigmented), unsp ankle and foot'),
    ('M1228', 'Villonodular synovitis (pigmented), vertebrae'),
    ('M1229', 'Villonodular synovitis (pigmented), multiple sites'),
    ('M1230', 'Palindromic rheumatism, unspecified site'),
    ('M12311', 'Palindromic rheumatism, right shoulder'),
    ('M12312', 'Palindromic rheumatism, left shoulder'),
    ('M12319', 'Palindromic rheumatism, unspecified shoulder'),
    ('M12321', 'Palindromic rheumatism, right elbow'),
    ('M12322', 'Palindromic rheumatism, left elbow'),
    ('M12329', 'Palindromic rheumatism, unspecified elbow'),
    ('M12331', 'Palindromic rheumatism, right wrist'),
    ('M12332', 'Palindromic rheumatism, left wrist'),
    ('M12339', 'Palindromic rheumatism, unspecified wrist'),
    ('M12341', 'Palindromic rheumatism, right hand'),
    ('M12342', 'Palindromic rheumatism, left hand'),
    ('M12349', 'Palindromic rheumatism, unspecified hand'),
    ('M12351', 'Palindromic rheumatism, right hip'),
    ('M12352', 'Palindromic rheumatism, left hip'),
    ('M12359', 'Palindromic rheumatism, unspecified hip'),
    ('M12361', 'Palindromic rheumatism, right knee'),
    ('M12362', 'Palindromic rheumatism, left knee'),
    ('M12369', 'Palindromic rheumatism, unspecified knee'),
    ('M12371', 'Palindromic rheumatism, right ankle and foot'),
    ('M12372', 'Palindromic rheumatism, left ankle and foot'),
    ('M12379', 'Palindromic rheumatism, unspecified ankle and foot'),
    ('M1238', 'Palindromic rheumatism, vertebrae'),
    ('M1239', 'Palindromic rheumatism, multiple sites'),
    ('M1240', 'Intermittent hydrarthrosis, unspecified site'),
    ('M12411', 'Intermittent hydrarthrosis, right shoulder'),
    ('M12412', 'Intermittent hydrarthrosis, left shoulder'),
    ('M12419', 'Intermittent hydrarthrosis, unspecified shoulder'),
    ('M12421', 'Intermittent hydrarthrosis, right elbow'),
    ('M12422', 'Intermittent hydrarthrosis, left elbow'),
    ('M12429', 'Intermittent hydrarthrosis, unspecified elbow'),
    ('M12431', 'Intermittent hydrarthrosis, right wrist'),
    ('M12432', 'Intermittent hydrarthrosis, left wrist'),
    ('M12439', 'Intermittent hydrarthrosis, unspecified wrist'),
    ('M12441', 'Intermittent hydrarthrosis, right hand'),
    ('M12442', 'Intermittent hydrarthrosis, left hand'),
    ('M12449', 'Intermittent hydrarthrosis, unspecified hand'),
    ('M12451', 'Intermittent hydrarthrosis, right hip'),
    ('M12452', 'Intermittent hydrarthrosis, left hip'),
    ('M12459', 'Intermittent hydrarthrosis, unspecified hip'),
    ('M12461', 'Intermittent hydrarthrosis, right knee'),
    ('M12462', 'Intermittent hydrarthrosis, left knee'),
    ('M12469', 'Intermittent hydrarthrosis, unspecified knee'),
    ('M12471', 'Intermittent hydrarthrosis, right ankle and foot'),
    ('M12472', 'Intermittent hydrarthrosis, left ankle and foot'),
    ('M12479', 'Intermittent hydrarthrosis, unspecified ankle and foot'),
    ('M1248', 'Intermittent hydrarthrosis, other site'),
    ('M1249', 'Intermittent hydrarthrosis, multiple sites'),
    ('M1250', 'Traumatic arthropathy, unspecified site'),
    ('M12511', 'Traumatic arthropathy, right shoulder'),
    ('M12512', 'Traumatic arthropathy, left shoulder'),
    ('M12519', 'Traumatic arthropathy, unspecified shoulder'),
    ('M12521', 'Traumatic arthropathy, right elbow'),
    ('M12522', 'Traumatic arthropathy, left elbow'),
    ('M12529', 'Traumatic arthropathy, unspecified elbow'),
    ('M12531', 'Traumatic arthropathy, right wrist'),
    ('M12532', 'Traumatic arthropathy, left wrist'),
    ('M12539', 'Traumatic arthropathy, unspecified wrist'),
    ('M12541', 'Traumatic arthropathy, right hand'),
    ('M12542', 'Traumatic arthropathy, left hand'),
    ('M12549', 'Traumatic arthropathy, unspecified hand'),
    ('M12551', 'Traumatic arthropathy, right hip'),
    ('M12552', 'Traumatic arthropathy, left hip'),
    ('M12559', 'Traumatic arthropathy, unspecified hip'),
    ('M12561', 'Traumatic arthropathy, right knee'),
    ('M12562', 'Traumatic arthropathy, left knee'),
    ('M12569', 'Traumatic arthropathy, unspecified knee'),
    ('M12571', 'Traumatic arthropathy, right ankle and foot'),
    ('M12572', 'Traumatic arthropathy, left ankle and foot'),
    ('M12579', 'Traumatic arthropathy, unspecified ankle and foot'),
    ('M1258', 'Traumatic arthropathy, vertebrae'),
    ('M1259', 'Traumatic arthropathy, multiple sites'),
    ('M1280', 'Oth specific arthropathies, NEC, unsp site'),
    ('M12811', 'Oth specific arthropathies, NEC, right shoulder'),
    ('M12812', 'Oth specific arthropathies, NEC, left shoulder'),
    ('M12819', 'Oth specific arthropathies, NEC, unsp shoulder'),
    ('M12821', 'Oth specific arthropathies, NEC, right elbow'),
    ('M12822', 'Oth specific arthropathies, NEC, left elbow'),
    ('M12829', 'Oth specific arthropathies, NEC, unsp elbow'),
    ('M12831', 'Oth specific arthropathies, NEC, right wrist'),
    ('M12832', 'Oth specific arthropathies, NEC, left wrist'),
    ('M12839', 'Oth specific arthropathies, NEC, unsp wrist'),
    ('M12841', 'Oth specific arthropathies, NEC, right hand'),
    ('M12842', 'Oth specific arthropathies, NEC, left hand'),
    ('M12849', 'Oth specific arthropathies, NEC, unsp hand'),
    ('M12851', 'Oth specific arthropathies, NEC, right hip'),
    ('M12852', 'Oth specific arthropathies, NEC, left hip'),
    ('M12859', 'Oth specific arthropathies, NEC, unsp hip'),
    ('M12861', 'Oth specific arthropathies, NEC, right knee'),
    ('M12862', 'Oth specific arthropathies, NEC, left knee'),
    ('M12869', 'Oth specific arthropathies, NEC, unsp knee'),
    ('M12871', 'Oth specific arthropathies, NEC, right ankle and foot'),
    ('M12872', 'Oth specific arthropathies, NEC, left ankle and foot'),
    ('M12879', 'Oth specific arthropathies, NEC, unsp ankle and foot'),
    ('M1288', 'Oth specific arthropathies, NEC, vertebrae'),
    ('M1289', 'Oth specific arthropathies, NEC, multiple sites'),
    ('M129', 'Arthropathy, unspecified'),
    ('M130', 'Polyarthritis, unspecified'),
    ('M1310', 'Monoarthritis, not elsewhere classified, unspecified site'),
    ('M13111', 'Monoarthritis, not elsewhere classified, right shoulder'),
    ('M13112', 'Monoarthritis, not elsewhere classified, left shoulder'),
    ('M13119', 'Monoarthritis, not elsewhere classified, unsp shoulder'),
    ('M13121', 'Monoarthritis, not elsewhere classified, right elbow'),
    ('M13122', 'Monoarthritis, not elsewhere classified, left elbow'),
    ('M13129', 'Monoarthritis, not elsewhere classified, unspecified elbow'),
    ('M13131', 'Monoarthritis, not elsewhere classified, right wrist'),
    ('M13132', 'Monoarthritis, not elsewhere classified, left wrist'),
    ('M13139', 'Monoarthritis, not elsewhere classified, unspecified wrist'),
    ('M13141', 'Monoarthritis, not elsewhere classified, right hand'),
    ('M13142', 'Monoarthritis, not elsewhere classified, left hand'),
    ('M13149', 'Monoarthritis, not elsewhere classified, unspecified hand'),
    ('M13151', 'Monoarthritis, not elsewhere classified, right hip'),
    ('M13152', 'Monoarthritis, not elsewhere classified, left hip'),
    ('M13159', 'Monoarthritis, not elsewhere classified, unspecified hip'),
    ('M13161', 'Monoarthritis, not elsewhere classified, right knee'),
    ('M13162', 'Monoarthritis, not elsewhere classified, left knee'),
    ('M13169', 'Monoarthritis, not elsewhere classified, unspecified knee'),
    ('M13171', 'Monoarthritis, NEC, right ankle and foot'),
    ('M13172', 'Monoarthritis, not elsewhere classified, left ankle and foot'),
    ('M13179', 'Monoarthritis, not elsewhere classified, unsp ankle and foot'),
    ('M1380', 'Other specified arthritis, unspecified site'),
    ('M13811', 'Other specified arthritis, right shoulder'),
    ('M13812', 'Other specified arthritis, left shoulder'),
    ('M13819', 'Other specified arthritis, unspecified shoulder'),
    ('M13821', 'Other specified arthritis, right elbow'),
    ('M13822', 'Other specified arthritis, left elbow'),
    ('M13829', 'Other specified arthritis, unspecified elbow'),
    ('M13831', 'Other specified arthritis, right wrist'),
    ('M13832', 'Other specified arthritis, left wrist'),
    ('M13839', 'Other specified arthritis, unspecified wrist'),
    ('M13841', 'Other specified arthritis, right hand'),
    ('M13842', 'Other specified arthritis, left hand'),
    ('M13849', 'Other specified arthritis, unspecified hand'),
    ('M13851', 'Other specified arthritis, right hip'),
    ('M13852', 'Other specified arthritis, left hip'),
    ('M13859', 'Other specified arthritis, unspecified hip'),
    ('M13861', 'Other specified arthritis, right knee'),
    ('M13862', 'Other specified arthritis, left knee'),
    ('M13869', 'Other specified arthritis, unspecified knee'),
    ('M13871', 'Other specified arthritis, right ankle and foot'),
    ('M13872', 'Other specified arthritis, left ankle and foot'),
    ('M13879', 'Other specified arthritis, unspecified ankle and foot'),
    ('M1388', 'Other specified arthritis, other site'),
    ('M1389', 'Other specified arthritis, multiple sites'),
    ('M1460', "Charcot's joint, unspecified site"),
    ('M14611', "Charcot's joint, right shoulder"),
    ('M14612', "Charcot's joint, left shoulder"),
    ('M14619', "Charcot's joint, unspecified shoulder"),
    ('M14621', "Charcot's joint, right elbow"),
    ('M14622', "Charcot's joint, left elbow"),
    ('M14629', "Charcot's joint, unspecified elbow"),
    ('M14631', "Charcot's joint, right wrist"),
    ('M14632', "Charcot's joint, left wrist"),
    ('M14639', "Charcot's joint, unspecified wrist"),
    ('M14641', "Charcot's joint, right hand"),
    ('M14642', "Charcot's joint, left hand"),
    ('M14649', "Charcot's joint, unspecified hand"),
    ('M14651', "Charcot's joint, right hip"),
    ('M14652', "Charcot's joint, left hip"),
    ('M14659', "Charcot's joint, unspecified hip"),
    ('M14661', "Charcot's joint, right knee"),
    ('M14662', "Charcot's joint, left knee"),
    ('M14669', "Charcot's joint, unspecified knee"),
    ('M14671', "Charcot's joint, right ankle and foot"),
    ('M14672', "Charcot's joint, left ankle and foot"),
    ('M14679', "Charcot's joint, unspecified ankle and foot"),
    ('M1468', "Charcot's joint, vertebrae"),
    ('M1469', "Charcot's joint, multiple sites"),
    ('M1480', 'Arthropathies in oth diseases classd elswhr, unsp site'),
    ('M14811', 'Arthropathies in oth diseases classd elswhr, right shoulder'),
    ('M14812', 'Arthropathies in oth diseases classd elswhr, left shoulder'),
    ('M14819', 'Arthropathies in oth diseases classd elswhr, unsp shoulder'),
    ('M14821', 'Arthropathies in oth diseases classd elswhr, right elbow'),
    ('M14822', 'Arthropathies in oth diseases classd elswhr, left elbow'),
    ('M14829', 'Arthropathies in oth diseases classd elswhr, unsp elbow'),
    ('M14831', 'Arthropathies in oth diseases classd elswhr, right wrist'),
    ('M14832', 'Arthropathies in oth diseases classd elswhr, left wrist'),
    ('M14839', 'Arthropathies in oth diseases classd elswhr, unsp wrist'),
    ('M14841', 'Arthropathies in oth diseases classd elswhr, right hand'),
    ('M14842', 'Arthropathies in oth diseases classd elswhr, left hand'),
    ('M14849', 'Arthropathies in oth diseases classd elswhr, unsp hand'),
    ('M14851', 'Arthropathies in oth diseases classd elswhr, right hip'),
    ('M14852', 'Arthropathies in oth diseases classified elsewhere, left hip'),
    ('M14859', 'Arthropathies in oth diseases classified elsewhere, unsp hip'),
    ('M14861', 'Arthropathies in oth diseases classd elswhr, right knee'),
    ('M14862', 'Arthropathies in oth diseases classd elswhr, left knee'),
    ('M14869', 'Arthropathies in oth diseases classd elswhr, unsp knee'),
    ('M14871', 'Arthropathies in oth diseases classd elswhr, right ank/ft'),
    ('M14872', 'Arthropathies in oth diseases classd elswhr, left ank/ft'),
    ('M14879', 'Arthropathies in oth diseases classd elswhr, unsp ank/ft'),
    ('M1488', 'Arthropathies in oth diseases classd elswhr, vertebrae'),
    ('M1489', 'Arthropathies in oth diseases classd elswhr, multiple sites'),
    ('M150', 'Primary generalized (osteo)arthritis'),
    ('M151', "Heberden's nodes (with arthropathy)"),
    ('M152', "Bouchard's nodes (with arthropathy)"),
    ('M153', 'Secondary multiple arthritis'),
    ('M154', 'Erosive (osteo)arthritis'),
    ('M158', 'Other polyosteoarthritis'),
    ('M159', 'Polyosteoarthritis, unspecified'),
    ('M160', 'Bilateral primary osteoarthritis of hip'),
    ('M1610', 'Unilateral primary osteoarthritis, unspecified hip'),
    ('M1611', 'Unilateral primary osteoarthritis, right hip'),
    ('M1612', 'Unilateral primary osteoarthritis, left hip'),
    ('M162', 'Bilateral osteoarthritis resulting from hip dysplasia'),
    ('M1630', 'Unilateral osteoarth resulting from hip dysplasia, unsp hip'),
    ('M1631', 'Unilateral osteoarth resulting from hip dysplasia, right hip'),
    ('M1632', 'Unilateral osteoarth resulting from hip dysplasia, left hip'),
    ('M164', 'Bilateral post-traumatic osteoarthritis of hip'),
    ('M1650', 'Unilateral post-traumatic osteoarthritis, unspecified hip'),
    ('M1651', 'Unilateral post-traumatic osteoarthritis, right hip'),
    ('M1652', 'Unilateral post-traumatic osteoarthritis, left hip'),
    ('M166', 'Other bilateral secondary osteoarthritis of hip'),
    ('M167', 'Other unilateral secondary osteoarthritis of hip'),
    ('M169', 'Osteoarthritis of hip, unspecified'),
    ('M170', 'Bilateral primary osteoarthritis of knee'),
    ('M1710', 'Unilateral primary osteoarthritis, unspecified knee'),
    ('M1711', 'Unilateral primary osteoarthritis, right knee'),
    ('M1712', 'Unilateral primary osteoarthritis, left knee'),
    ('M172', 'Bilateral post-traumatic osteoarthritis of knee'),
    ('M1730', 'Unilateral post-traumatic osteoarthritis, unspecified knee'),
    ('M1731', 'Unilateral post-traumatic osteoarthritis, right knee'),
    ('M1732', 'Unilateral post-traumatic osteoarthritis, left knee'),
    ('M174', 'Other bilateral secondary osteoarthritis of knee'),
    ('M175', 'Other unilateral secondary osteoarthritis of knee'),
    ('M179', 'Osteoarthritis of knee, unspecified'),
    ('M180', 'Bilateral primary osteoarth of first carpometacarp joints'),
    ('M1810', 'Unil prim osteoarth of first carpometacarp joint, unsp hand'),
    ('M1811', 'Unil primary osteoarth of first carpometacarp joint, r hand'),
    ('M1812', 'Unil primary osteoarth of first carpometacarp joint, l hand'),
    ('M182', 'Bi post-trauma osteoarth of first carpometacarp joints'),
    ('M1830', 'Unil post-trauma osteoarth of 1st carpometacarp jt,unsp hand'),
    ('M1831', 'Unil post-trauma osteoarth of 1st carpometacarp jt, r hand'),
    ('M1832', 'Unil post-trauma osteoarth of 1st carpometacarp jt, l hand'),
    ('M184', 'Oth bi secondary osteoarth of first carpometacarp joints'),
    ('M1850', 'Oth unil sec osteoarth of 1st carpometacarp joint, unsp hand'),
    ('M1851', 'Oth unil sec osteoarth of first carpometacarp joint, r hand'),
    ('M1852', 'Oth unil sec osteoarth of first carpometacarp joint, l hand'),
    ('M189', 'Osteoarthritis of first carpometacarpal joint, unspecified'),
    ('M19011', 'Primary osteoarthritis, right shoulder'),
    ('M19012', 'Primary osteoarthritis, left shoulder'),
    ('M19019', 'Primary osteoarthritis, unspecified shoulder'),
    ('M19021', 'Primary osteoarthritis, right elbow'),
    ('M19022', 'Primary osteoarthritis, left elbow'),
    ('M19029', 'Primary osteoarthritis, unspecified elbow'),
    ('M19031', 'Primary osteoarthritis, right wrist'),
    ('M19032', 'Primary osteoarthritis, left wrist'),
    ('M19039', 'Primary osteoarthritis, unspecified wrist'),
    ('M19041', 'Primary osteoarthritis, right hand'),
    ('M19042', 'Primary osteoarthritis, left hand'),
    ('M19049', 'Primary osteoarthritis, unspecified hand'),
    ('M19071', 'Primary osteoarthritis, right ankle and foot'),
    ('M19072', 'Primary osteoarthritis, left ankle and foot'),
    ('M19079', 'Primary osteoarthritis, unspecified ankle and foot'),
    ('M1909', 'Primary osteoarthritis, other specified site'),
    ('M19111', 'Post-traumatic osteoarthritis, right shoulder'),
    ('M19112', 'Post-traumatic osteoarthritis, left shoulder'),
    ('M19119', 'Post-traumatic osteoarthritis, unspecified shoulder'),
    ('M19121', 'Post-traumatic osteoarthritis, right elbow'),
    ('M19122', 'Post-traumatic osteoarthritis, left elbow'),
    ('M19129', 'Post-traumatic osteoarthritis, unspecified elbow'),
    ('M19131', 'Post-traumatic osteoarthritis, right wrist'),
    ('M19132', 'Post-traumatic osteoarthritis, left wrist'),
    ('M19139', 'Post-traumatic osteoarthritis, unspecified wrist'),
    ('M19141', 'Post-traumatic osteoarthritis, right hand'),
    ('M19142', 'Post-traumatic osteoarthritis, left hand'),
    ('M19149', 'Post-traumatic osteoarthritis, unspecified hand'),
    ('M19171', 'Post-traumatic osteoarthritis, right ankle and foot'),
    ('M19172', 'Post-traumatic osteoarthritis, left ankle and foot'),
    ('M19179', 'Post-traumatic osteoarthritis, unspecified ankle and foot'),
    ('M1919', 'Post-traumatic osteoarthritis, other specified site'),
    ('M19211', 'Secondary osteoarthritis, right shoulder'),
    ('M19212', 'Secondary osteoarthritis, left shoulder'),
    ('M19219', 'Secondary osteoarthritis, unspecified shoulder'),
    ('M19221', 'Secondary osteoarthritis, right elbow'),
    ('M19222', 'Secondary osteoarthritis, left elbow'),
    ('M19229', 'Secondary osteoarthritis, unspecified elbow'),
    ('M19231', 'Secondary osteoarthritis, right wrist'),
    ('M19232', 'Secondary osteoarthritis, left wrist'),
    ('M19239', 'Secondary osteoarthritis, unspecified wrist'),
    ('M19241', 'Secondary osteoarthritis, right hand'),
    ('M19242', 'Secondary osteoarthritis, left hand'),
    ('M19249', 'Secondary osteoarthritis, unspecified hand'),
    ('M19271', 'Secondary osteoarthritis, right ankle and foot'),
    ('M19272', 'Secondary osteoarthritis, left ankle and foot'),
    ('M19279', 'Secondary osteoarthritis, unspecified ankle and foot'),
    ('M1929', 'Secondary osteoarthritis, other specified site'),
    ('M1990', 'Unspecified osteoarthritis, unspecified site'),
    ('M1991', 'Primary osteoarthritis, unspecified site'),
    ('M1992', 'Post-traumatic osteoarthritis, unspecified site'),
    ('M1993', 'Secondary osteoarthritis, unspecified site'),
    ('M1A00X0', 'Idiopathic chronic gout, unspecified site, without tophus'),
    ('M1A00X1', 'Idiopathic chronic gout, unspecified site, with tophus'),
    ('M1A0110', 'Idiopathic chronic gout, right shoulder, without tophus'),
    ('M1A0111', 'Idiopathic chronic gout, right shoulder, with tophus (tophi)'),
    ('M1A0120', 'Idiopathic chronic gout, left shoulder, without tophus'),
    ('M1A0121', 'Idiopathic chronic gout, left shoulder, with tophus (tophi)'),
    ('M1A0190', 'Idiopathic chronic gout, unsp shoulder, without tophus'),
    ('M1A0191', 'Idiopathic chronic gout, unspecified shoulder, with tophus'),
    ('M1A0210', 'Idiopathic chronic gout, right elbow, without tophus (tophi)'),
    ('M1A0211', 'Idiopathic chronic gout, right elbow, with tophus (tophi)'),
    ('M1A0220', 'Idiopathic chronic gout, left elbow, without tophus (tophi)'),
    ('M1A0221', 'Idiopathic chronic gout, left elbow, with tophus (tophi)'),
    ('M1A0290', 'Idiopathic chronic gout, unspecified elbow, without tophus'),
    ('M1A0291', 'Idiopathic chronic gout, unspecified elbow, with tophus'),
    ('M1A0310', 'Idiopathic chronic gout, right wrist, without tophus (tophi)'),
    ('M1A0311', 'Idiopathic chronic gout, right wrist, with tophus (tophi)'),
    ('M1A0320', 'Idiopathic chronic gout, left wrist, without tophus (tophi)'),
    ('M1A0321', 'Idiopathic chronic gout, left wrist, with tophus (tophi)'),
    ('M1A0390', 'Idiopathic chronic gout, unspecified wrist, without tophus'),
    ('M1A0391', 'Idiopathic chronic gout, unspecified wrist, with tophus'),
    ('M1A0410', 'Idiopathic chronic gout, right hand, without tophus (tophi)'),
    ('M1A0411', 'Idiopathic chronic gout, right hand, with tophus (tophi)'),
    ('M1A0420', 'Idiopathic chronic gout, left hand, without tophus (tophi)'),
    ('M1A0421', 'Idiopathic chronic gout, left hand, with tophus (tophi)'),
    ('M1A0490', 'Idiopathic chronic gout, unspecified hand, without tophus'),
    ('M1A0491', 'Idiopathic chronic gout, unspecified hand, with tophus'),
    ('M1A0510', 'Idiopathic chronic gout, right hip, without tophus (tophi)'),
    ('M1A0511', 'Idiopathic chronic gout, right hip, with tophus (tophi)'),
    ('M1A0520', 'Idiopathic chronic gout, left hip, without tophus (tophi)'),
    ('M1A0521', 'Idiopathic chronic gout, left hip, with tophus (tophi)'),
    ('M1A0590', 'Idiopathic chronic gout, unspecified hip, without tophus'),
    ('M1A0591', 'Idiopathic chronic gout, unspecified hip, with tophus'),
    ('M1A0610', 'Idiopathic chronic gout, right knee, without tophus (tophi)'),
    ('M1A0611', 'Idiopathic chronic gout, right knee, with tophus (tophi)'),
    ('M1A0620', 'Idiopathic chronic gout, left knee, without tophus (tophi)'),
    ('M1A0621', 'Idiopathic chronic gout, left knee, with tophus (tophi)'),
    ('M1A0690', 'Idiopathic chronic gout, unspecified knee, without tophus'),
    ('M1A0691', 'Idiopathic chronic gout, unspecified knee, with tophus'),
    ('M1A0710', 'Idiopathic chronic gout, right ankle and foot, w/o tophus'),
    ('M1A0711', 'Idiopathic chronic gout, right ankle and foot, with tophus'),
    ('M1A0720', 'Idiopathic chronic gout, left ankle and foot, without tophus'),
    ('M1A0721', 'Idiopathic chronic gout, left ankle and foot, with tophus'),
    ('M1A0790', 'Idiopathic chronic gout, unsp ankle and foot, without tophus'),
    ('M1A0791', 'Idiopathic chronic gout, unsp ankle and foot, with tophus'),
    ('M1A08X0', 'Idiopathic chronic gout, vertebrae, without tophus (tophi)'),
    ('M1A08X1', 'Idiopathic chronic gout, vertebrae, with tophus (tophi)'),
    ('M1A09X0', 'Idiopathic chronic gout, multiple sites, without tophus'),
    ('M1A09X1', 'Idiopathic chronic gout, multiple sites, with tophus (tophi)'),
    ('M1A10X0', 'Lead-induced chronic gout, unspecified site, without tophus'),
    ('M1A10X1', 'Lead-induced chronic gout, unspecified site, with tophus'),
    ('M1A1110', 'Lead-induced chronic gout, right shoulder, without tophus'),
    ('M1A1111', 'Lead-induced chronic gout, right shoulder, with tophus'),
    ('M1A1120', 'Lead-induced chronic gout, left shoulder, without tophus'),
    ('M1A1121', 'Lead-induced chronic gout, left shoulder, with tophus'),
    ('M1A1190', 'Lead-induced chronic gout, unsp shoulder, without tophus'),
    ('M1A1191', 'Lead-induced chronic gout, unspecified shoulder, with tophus'),
    ('M1A1210', 'Lead-induced chronic gout, right elbow, without tophus'),
    ('M1A1211', 'Lead-induced chronic gout, right elbow, with tophus (tophi)'),
    ('M1A1220', 'Lead-induced chronic gout, left elbow, without tophus'),
    ('M1A1221', 'Lead-induced chronic gout, left elbow, with tophus (tophi)'),
    ('M1A1290', 'Lead-induced chronic gout, unspecified elbow, without tophus'),
    ('M1A1291', 'Lead-induced chronic gout, unspecified elbow, with tophus'),
    ('M1A1310', 'Lead-induced chronic gout, right wrist, without tophus'),
    ('M1A1311', 'Lead-induced chronic gout, right wrist, with tophus (tophi)'),
    ('M1A1320', 'Lead-induced chronic gout, left wrist, without tophus'),
    ('M1A1321', 'Lead-induced chronic gout, left wrist, with tophus (tophi)'),
    ('M1A1390', 'Lead-induced chronic gout, unspecified wrist, without tophus'),
    ('M1A1391', 'Lead-induced chronic gout, unspecified wrist, with tophus'),
    ('M1A1410', 'Lead-induced chronic gout, right hand, without tophus'),
    ('M1A1411', 'Lead-induced chronic gout, right hand, with tophus (tophi)'),
    ('M1A1420', 'Lead-induced chronic gout, left hand, without tophus (tophi)'),
    ('M1A1421', 'Lead-induced chronic gout, left hand, with tophus (tophi)'),
    ('M1A1490', 'Lead-induced chronic gout, unspecified hand, without tophus'),
    ('M1A1491', 'Lead-induced chronic gout, unspecified hand, with tophus'),
    ('M1A1510', 'Lead-induced chronic gout, right hip, without tophus (tophi)'),
    ('M1A1511', 'Lead-induced chronic gout, right hip, with tophus (tophi)'),
    ('M1A1520', 'Lead-induced chronic gout, left hip, without tophus (tophi)'),
    ('M1A1521', 'Lead-induced chronic gout, left hip, with tophus (tophi)'),
    ('M1A1590', 'Lead-induced chronic gout, unspecified hip, without tophus'),
    ('M1A1591', 'Lead-induced chronic gout, unspecified hip, with tophus'),
    ('M1A1610', 'Lead-induced chronic gout, right knee, without tophus'),
    ('M1A1611', 'Lead-induced chronic gout, right knee, with tophus (tophi)'),
    ('M1A1620', 'Lead-induced chronic gout, left knee, without tophus (tophi)'),
    ('M1A1621', 'Lead-induced chronic gout, left knee, with tophus (tophi)'),
    ('M1A1690', 'Lead-induced chronic gout, unspecified knee, without tophus'),
    ('M1A1691', 'Lead-induced chronic gout, unspecified knee, with tophus'),
    ('M1A1710', 'Lead-induced chronic gout, right ankle and foot, w/o tophus'),
    ('M1A1711', 'Lead-induced chronic gout, right ankle and foot, with tophus'),
    ('M1A1720', 'Lead-induced chronic gout, left ankle and foot, w/o tophus'),
    ('M1A1721', 'Lead-induced chronic gout, left ankle and foot, with tophus'),
    ('M1A1790', 'Lead-induced chronic gout, unsp ankle and foot, w/o tophus'),
    ('M1A1791', 'Lead-induced chronic gout, unsp ankle and foot, with tophus'),
    ('M1A18X0', 'Lead-induced chronic gout, vertebrae, without tophus (tophi)'),
    ('M1A18X1', 'Lead-induced chronic gout, vertebrae, with tophus (tophi)'),
    ('M1A19X0', 'Lead-induced chronic gout, multiple sites, without tophus'),
    ('M1A19X1', 'Lead-induced chronic gout, multiple sites, with tophus'),
    ('M1A20X0', 'Drug-induced chronic gout, unspecified site, without tophus'),
    ('M1A20X1', 'Drug-induced chronic gout, unspecified site, with tophus'),
    ('M1A2110', 'Drug-induced chronic gout, right shoulder, without tophus'),
    ('M1A2111', 'Drug-induced chronic gout, right shoulder, with tophus'),
    ('M1A2120', 'Drug-induced chronic gout, left shoulder, without tophus'),
    ('M1A2121', 'Drug-induced chronic gout, left shoulder, with tophus'),
    ('M1A2190', 'Drug-induced chronic gout, unsp shoulder, without tophus'),
    ('M1A2191', 'Drug-induced chronic gout, unspecified shoulder, with tophus'),
    ('M1A2210', 'Drug-induced chronic gout, right elbow, without tophus'),
    ('M1A2211', 'Drug-induced chronic gout, right elbow, with tophus (tophi)'),
    ('M1A2220', 'Drug-induced chronic gout, left elbow, without tophus'),
    ('M1A2221', 'Drug-induced chronic gout, left elbow, with tophus (tophi)'),
    ('M1A2290', 'Drug-induced chronic gout, unspecified elbow, without tophus'),
    ('M1A2291', 'Drug-induced chronic gout, unspecified elbow, with tophus'),
    ('M1A2310', 'Drug-induced chronic gout, right wrist, without tophus'),
    ('M1A2311', 'Drug-induced chronic gout, right wrist, with tophus (tophi)'),
    ('M1A2320', 'Drug-induced chronic gout, left wrist, without tophus'),
    ('M1A2321', 'Drug-induced chronic gout, left wrist, with tophus (tophi)'),
    ('M1A2390', 'Drug-induced chronic gout, unspecified wrist, without tophus'),
    ('M1A2391', 'Drug-induced chronic gout, unspecified wrist, with tophus'),
    ('M1A2410', 'Drug-induced chronic gout, right hand, without tophus'),
    ('M1A2411', 'Drug-induced chronic gout, right hand, with tophus (tophi)'),
    ('M1A2420', 'Drug-induced chronic gout, left hand, without tophus (tophi)'),
    ('M1A2421', 'Drug-induced chronic gout, left hand, with tophus (tophi)'),
    ('M1A2490', 'Drug-induced chronic gout, unspecified hand, without tophus'),
    ('M1A2491', 'Drug-induced chronic gout, unspecified hand, with tophus'),
    ('M1A2510', 'Drug-induced chronic gout, right hip, without tophus (tophi)'),
    ('M1A2511', 'Drug-induced chronic gout, right hip, with tophus (tophi)'),
    ('M1A2520', 'Drug-induced chronic gout, left hip, without tophus (tophi)'),
    ('M1A2521', 'Drug-induced chronic gout, left hip, with tophus (tophi)'),
    ('M1A2590', 'Drug-induced chronic gout, unspecified hip, without tophus'),
    ('M1A2591', 'Drug-induced chronic gout, unspecified hip, with tophus'),
    ('M1A2610', 'Drug-induced chronic gout, right knee, without tophus'),
    ('M1A2611', 'Drug-induced chronic gout, right knee, with tophus (tophi)'),
    ('M1A2620', 'Drug-induced chronic gout, left knee, without tophus (tophi)'),
    ('M1A2621', 'Drug-induced chronic gout, left knee, with tophus (tophi)'),
    ('M1A2690', 'Drug-induced chronic gout, unspecified knee, without tophus'),
    ('M1A2691', 'Drug-induced chronic gout, unspecified knee, with tophus'),
    ('M1A2710', 'Drug-induced chronic gout, right ankle and foot, w/o tophus'),
    ('M1A2711', 'Drug-induced chronic gout, right ankle and foot, with tophus'),
    ('M1A2720', 'Drug-induced chronic gout, left ankle and foot, w/o tophus'),
    ('M1A2721', 'Drug-induced chronic gout, left ankle and foot, with tophus'),
    ('M1A2790', 'Drug-induced chronic gout, unsp ankle and foot, w/o tophus'),
    ('M1A2791', 'Drug-induced chronic gout, unsp ankle and foot, with tophus'),
    ('M1A28X0', 'Drug-induced chronic gout, vertebrae, without tophus (tophi)'),
    ('M1A28X1', 'Drug-induced chronic gout, vertebrae, with tophus (tophi)'),
    ('M1A29X0', 'Drug-induced chronic gout, multiple sites, without tophus'),
    ('M1A29X1', 'Drug-induced chronic gout, multiple sites, with tophus'),
    ('M1A30X0', 'Chronic gout due to renal impairment, unsp site, w/o tophus'),
    ('M1A30X1', 'Chronic gout due to renal impairment, unsp site, with tophus'),
    ('M1A3110', 'Chronic gout due to renal impairment, r shoulder, w/o toph'),
    ('M1A3111', 'Chronic gout due to renal impairment, right shoulder, w toph'),
    ('M1A3120', 'Chronic gout due to renal impairment, l shoulder, w/o toph'),
    ('M1A3121', 'Chronic gout due to renal impairment, left shoulder, w toph'),
    ('M1A3190', 'Chronic gout due to renal impairment, unsp shldr, w/o toph'),
    ('M1A3191', 'Chronic gout due to renal impairment, unsp shoulder, w toph'),
    ('M1A3210', 'Chronic gout due to renal impairment, right elbow, w/o toph'),
    ('M1A3211', 'Chronic gout due to renal impairment, right elbow, w tophus'),
    ('M1A3220', 'Chronic gout due to renal impairment, left elbow, w/o tophus'),
    ('M1A3221', 'Chronic gout due to renal impairment, left elbow, w tophus'),
    ('M1A3290', 'Chronic gout due to renal impairment, unsp elbow, w/o tophus'),
    ('M1A3291', 'Chronic gout due to renal impairment, unsp elbow, w tophus'),
    ('M1A3310', 'Chronic gout due to renal impairment, right wrist, w/o toph'),
    ('M1A3311', 'Chronic gout due to renal impairment, right wrist, w tophus'),
    ('M1A3320', 'Chronic gout due to renal impairment, left wrist, w/o tophus'),
    ('M1A3321', 'Chronic gout due to renal impairment, left wrist, w tophus'),
    ('M1A3390', 'Chronic gout due to renal impairment, unsp wrist, w/o tophus'),
    ('M1A3391', 'Chronic gout due to renal impairment, unsp wrist, w tophus'),
    ('M1A3410', 'Chronic gout due to renal impairment, right hand, w/o tophus'),
    ('M1A3411', 'Chronic gout due to renal impairment, right hand, w tophus'),
    ('M1A3420', 'Chronic gout due to renal impairment, left hand, w/o tophus'),
    ('M1A3421', 'Chronic gout due to renal impairment, left hand, with tophus'),
    ('M1A3490', 'Chronic gout due to renal impairment, unsp hand, w/o tophus'),
    ('M1A3491', 'Chronic gout due to renal impairment, unsp hand, with tophus'),
    ('M1A3510', 'Chronic gout due to renal impairment, right hip, w/o tophus'),
    ('M1A3511', 'Chronic gout due to renal impairment, right hip, with tophus'),
    ('M1A3520', 'Chronic gout due to renal impairment, left hip, w/o tophus'),
    ('M1A3521', 'Chronic gout due to renal impairment, left hip, with tophus'),
    ('M1A3590', 'Chronic gout due to renal impairment, unsp hip, w/o tophus'),
    ('M1A3591', 'Chronic gout due to renal impairment, unsp hip, with tophus'),
    ('M1A3610', 'Chronic gout due to renal impairment, right knee, w/o tophus'),
    ('M1A3611', 'Chronic gout due to renal impairment, right knee, w tophus'),
    ('M1A3620', 'Chronic gout due to renal impairment, left knee, w/o tophus'),
    ('M1A3621', 'Chronic gout due to renal impairment, left knee, with tophus'),
    ('M1A3690', 'Chronic gout due to renal impairment, unsp knee, w/o tophus'),
    ('M1A3691', 'Chronic gout due to renal impairment, unsp knee, with tophus'),
    ('M1A3710', 'Chronic gout due to renal impairment, right ank/ft, w/o toph'),
    ('M1A3711', 'Chronic gout due to renal impairment, right ank/ft, w toph'),
    ('M1A3720', 'Chronic gout due to renal impairment, left ank/ft, w/o toph'),
    ('M1A3721', 'Chronic gout due to renal impairment, left ank/ft, w toph'),
    ('M1A3790', 'Chronic gout due to renal impairment, unsp ank/ft, w/o toph'),
    ('M1A3791', 'Chronic gout due to renal impairment, unsp ank/ft, w toph'),
    ('M1A38X0', 'Chronic gout due to renal impairment, vertebrae, w/o tophus'),
    ('M1A38X1', 'Chronic gout due to renal impairment, vertebrae, with tophus'),
    ('M1A39X0', 'Chronic gout due to renal impairment, mult sites, w/o toph'),
    ('M1A39X1', 'Chronic gout due to renal impairment, multiple sites, w toph'),
    ('M1A40X0', 'Other secondary chronic gout, unsp site, without tophus'),
    ('M1A40X1', 'Other secondary chronic gout, unspecified site, with tophus'),
    ('M1A4110', 'Other secondary chronic gout, right shoulder, without tophus'),
    ('M1A4111', 'Other secondary chronic gout, right shoulder, with tophus'),
    ('M1A4120', 'Other secondary chronic gout, left shoulder, without tophus'),
    ('M1A4121', 'Other secondary chronic gout, left shoulder, with tophus'),
    ('M1A4190', 'Other secondary chronic gout, unsp shoulder, without tophus'),
    ('M1A4191', 'Other secondary chronic gout, unsp shoulder, with tophus'),
    ('M1A4210', 'Other secondary chronic gout, right elbow, without tophus'),
    ('M1A4211', 'Other secondary chronic gout, right elbow, with tophus'),
    ('M1A4220', 'Other secondary chronic gout, left elbow, without tophus'),
    ('M1A4221', 'Other secondary chronic gout, left elbow, with tophus'),
    ('M1A4290', 'Other secondary chronic gout, unsp elbow, without tophus'),
    ('M1A4291', 'Other secondary chronic gout, unspecified elbow, with tophus'),
    ('M1A4310', 'Other secondary chronic gout, right wrist, without tophus'),
    ('M1A4311', 'Other secondary chronic gout, right wrist, with tophus'),
    ('M1A4320', 'Other secondary chronic gout, left wrist, without tophus'),
    ('M1A4321', 'Other secondary chronic gout, left wrist, with tophus'),
    ('M1A4390', 'Other secondary chronic gout, unsp wrist, without tophus'),
    ('M1A4391', 'Other secondary chronic gout, unspecified wrist, with tophus'),
    ('M1A4410', 'Other secondary chronic gout, right hand, without tophus'),
    ('M1A4411', 'Other secondary chronic gout, right hand, with tophus'),
    ('M1A4420', 'Other secondary chronic gout, left hand, without tophus'),
    ('M1A4421', 'Other secondary chronic gout, left hand, with tophus (tophi)'),
    ('M1A4490', 'Other secondary chronic gout, unsp hand, without tophus'),
    ('M1A4491', 'Other secondary chronic gout, unspecified hand, with tophus'),
    ('M1A4510', 'Other secondary chronic gout, right hip, without tophus'),
    ('M1A4511', 'Other secondary chronic gout, right hip, with tophus (tophi)'),
    ('M1A4520', 'Other secondary chronic gout, left hip, without tophus'),
    ('M1A4521', 'Other secondary chronic gout, left hip, with tophus (tophi)'),
    ('M1A4590', 'Other secondary chronic gout, unsp hip, without tophus'),
    ('M1A4591', 'Other secondary chronic gout, unspecified hip, with tophus'),
    ('M1A4610', 'Other secondary chronic gout, right knee, without tophus'),
    ('M1A4611', 'Other secondary chronic gout, right knee, with tophus'),
    ('M1A4620', 'Other secondary chronic gout, left knee, without tophus'),
    ('M1A4621', 'Other secondary chronic gout, left knee, with tophus (tophi)'),
    ('M1A4690', 'Other secondary chronic gout, unsp knee, without tophus'),
    ('M1A4691', 'Other secondary chronic gout, unspecified knee, with tophus'),
    ('M1A4710', 'Oth secondary chronic gout, right ankle and foot, w/o tophus'),
    ('M1A4711', 'Oth secondary chronic gout, right ankle and foot, w tophus'),
    ('M1A4720', 'Oth secondary chronic gout, left ankle and foot, w/o tophus'),
    ('M1A4721', 'Oth secondary chronic gout, left ankle and foot, with tophus'),
    ('M1A4790', 'Oth secondary chronic gout, unsp ankle and foot, w/o tophus'),
    ('M1A4791', 'Oth secondary chronic gout, unsp ankle and foot, with tophus'),
    ('M1A48X0', 'Other secondary chronic gout, vertebrae, without tophus'),
    ('M1A48X1', 'Other secondary chronic gout, vertebrae, with tophus (tophi)'),
    ('M1A49X0', 'Other secondary chronic gout, multiple sites, without tophus'),
    ('M1A49X1', 'Other secondary chronic gout, multiple sites, with tophus'),
    ('M1A9XX0', 'Chronic gout, unspecified, without tophus (tophi)'),
    ('M1A9XX1', 'Chronic gout, unspecified, with tophus (tophi)'),
    ('M20001', 'Unspecified deformity of right finger(s)'),
    ('M20002', 'Unspecified deformity of left finger(s)'),
    ('M20009', 'Unspecified deformity of unspecified finger(s)'),
    ('M20011', 'Mallet finger of right finger(s)'),
    ('M20012', 'Mallet finger of left finger(s)'),
    ('M20019', 'Mallet finger of unspecified finger(s)'),
    ('M20021', 'Boutonniere deformity of right finger(s)'),
    ('M20022', 'Boutonniere deformity of left finger(s)'),
    ('M20029', 'Boutonniere deformity of unspecified finger(s)'),
    ('M20031', 'Swan-neck deformity of right finger(s)'),
    ('M20032', 'Swan-neck deformity of left finger(s)'),
    ('M20039', 'Swan-neck deformity of unspecified finger(s)'),
    ('M20091', 'Other deformity of right finger(s)'),
    ('M20092', 'Other deformity of left finger(s)'),
    ('M20099', 'Other deformity of finger(s), unspecified finger(s)'),
    ('M2010', 'Hallux valgus (acquired), unspecified foot'),
    ('M2011', 'Hallux valgus (acquired), right foot'),
    ('M2012', 'Hallux valgus (acquired), left foot'),
    ('M2020', 'Hallux rigidus, unspecified foot'),
    ('M2021', 'Hallux rigidus, right foot'),
    ('M2022', 'Hallux rigidus, left foot'),
    ('M2030', 'Hallux varus (acquired), unspecified foot'),
    ('M2031', 'Hallux varus (acquired), right foot'),
    ('M2032', 'Hallux varus (acquired), left foot'),
    ('M2040', 'Other hammer toe(s) (acquired), unspecified foot'),
    ('M2041', 'Other hammer toe(s) (acquired), right foot'),
    ('M2042', 'Other hammer toe(s) (acquired), left foot'),
    ('M205X1', 'Other deformities of toe(s) (acquired), right foot'),
    ('M205X2', 'Other deformities of toe(s) (acquired), left foot'),
    ('M205X9', 'Other deformities of toe(s) (acquired), unspecified foot'),
    ('M2060', 'Acquired deformities of toe(s), unsp, unspecified foot'),
    ('M2061', 'Acquired deformities of toe(s), unspecified, right foot'),
    ('M2062', 'Acquired deformities of toe(s), unspecified, left foot'),
    ('M2100', 'Valgus deformity, not elsewhere classified, unspecified site'),
    ('M21021', 'Valgus deformity, not elsewhere classified, right elbow'),
    ('M21022', 'Valgus deformity, not elsewhere classified, left elbow'),
    ('M21029', 'Valgus deformity, not elsewhere classified, unsp elbow'),
    ('M21051', 'Valgus deformity, not elsewhere classified, right hip'),
    ('M21052', 'Valgus deformity, not elsewhere classified, left hip'),
    ('M21059', 'Valgus deformity, not elsewhere classified, unspecified hip'),
    ('M21061', 'Valgus deformity, not elsewhere classified, right knee'),
    ('M21062', 'Valgus deformity, not elsewhere classified, left knee'),
    ('M21069', 'Valgus deformity, not elsewhere classified, unspecified knee'),
    ('M21071', 'Valgus deformity, not elsewhere classified, right ankle'),
    ('M21072', 'Valgus deformity, not elsewhere classified, left ankle'),
    ('M21079', 'Valgus deformity, not elsewhere classified, unsp ankle'),
    ('M2110', 'Varus deformity, not elsewhere classified, unspecified site'),
    ('M21121', 'Varus deformity, not elsewhere classified, right elbow'),
    ('M21122', 'Varus deformity, not elsewhere classified, left elbow'),
    ('M21129', 'Varus deformity, not elsewhere classified, unspecified elbow'),
    ('M21151', 'Varus deformity, not elsewhere classified, right hip'),
    ('M21152', 'Varus deformity, not elsewhere classified, left hip'),
    ('M21159', 'Varus deformity, not elsewhere classified, unspecified'),
    ('M21161', 'Varus deformity, not elsewhere classified, right knee'),
    ('M21162', 'Varus deformity, not elsewhere classified, left knee'),
    ('M21169', 'Varus deformity, not elsewhere classified, unspecified knee'),
    ('M21171', 'Varus deformity, not elsewhere classified, right ankle'),
    ('M21172', 'Varus deformity, not elsewhere classified, left ankle'),
    ('M21179', 'Varus deformity, not elsewhere classified, unspecified ankle'),
    ('M2120', 'Flexion deformity, unspecified site'),
    ('M21211', 'Flexion deformity, right shoulder'),
    ('M21212', 'Flexion deformity, left shoulder'),
    ('M21219', 'Flexion deformity, unspecified shoulder'),
    ('M21221', 'Flexion deformity, right elbow'),
    ('M21222', 'Flexion deformity, left elbow'),
    ('M21229', 'Flexion deformity, unspecified elbow'),
    ('M21231', 'Flexion deformity, right wrist'),
    ('M21232', 'Flexion deformity, left wrist'),
    ('M21239', 'Flexion deformity, unspecified wrist'),
    ('M21241', 'Flexion deformity, right finger joints'),
    ('M21242', 'Flexion deformity, left finger joints'),
    ('M21249', 'Flexion deformity, unspecified finger joints'),
    ('M21251', 'Flexion deformity, right hip'),
    ('M21252', 'Flexion deformity, left hip'),
    ('M21259', 'Flexion deformity, unspecified hip'),
    ('M21261', 'Flexion deformity, right knee'),
    ('M21262', 'Flexion deformity, left knee'),
    ('M21269', 'Flexion deformity, unspecified knee'),
    ('M21271', 'Flexion deformity, right ankle and toes'),
    ('M21272', 'Flexion deformity, left ankle and toes'),
    ('M21279', 'Flexion deformity, unspecified ankle and toes'),
    ('M21331', 'Wrist drop, right wrist'),
    ('M21332', 'Wrist drop, left wrist'),
    ('M21339', 'Wrist drop, unspecified wrist'),
    ('M21371', 'Foot drop, right foot'),
    ('M21372', 'Foot drop, left foot'),
    ('M21379', 'Foot drop, unspecified foot'),
    ('M2140', 'Flat foot [pes planus] (acquired), unspecified foot'),
    ('M2141', 'Flat foot [pes planus] (acquired), right foot'),
    ('M2142', 'Flat foot [pes planus] (acquired), left foot'),
    ('M21511', 'Acquired clawhand, right hand'),
    ('M21512', 'Acquired clawhand, left hand'),
    ('M21519', 'Acquired clawhand, unspecified hand'),
    ('M21521', 'Acquired clubhand, right hand'),
    ('M21522', 'Acquired clubhand, left hand'),
    ('M21529', 'Acquired clubhand, unspecified hand'),
    ('M21531', 'Acquired clawfoot, right foot'),
    ('M21532', 'Acquired clawfoot, left foot'),
    ('M21539', 'Acquired clawfoot, unspecified foot'),
    ('M21541', 'Acquired clubfoot, right foot'),
    ('M21542', 'Acquired clubfoot, left foot'),
    ('M21549', 'Acquired clubfoot, unspecified foot'),
    ('M21611', 'Bunion of right foot'),
    ('M21612', 'Bunion of left foot'),
    ('M21619', 'Bunion of unspecified foot'),
    ('M21621', 'Bunionette of right foot'),
    ('M21622', 'Bunionette of left foot'),
    ('M21629', 'Bunionette of unspecified foot'),
    ('M216X1', 'Other acquired deformities of right foot'),
    ('M216X2', 'Other acquired deformities of left foot'),
    ('M216X9', 'Other acquired deformities of unspecified foot'),
    ('M2170', 'Unequal limb length (acquired), unspecified site'),
    ('M21721', 'Unequal limb length (acquired), right humerus'),
    ('M21722', 'Unequal limb length (acquired), left humerus'),
    ('M21729', 'Unequal limb length (acquired), unspecified humerus'),
    ('M21731', 'Unequal limb length (acquired), right ulna'),
    ('M21732', 'Unequal limb length (acquired), left ulna'),
    ('M21733', 'Unequal limb length (acquired), right radius'),
    ('M21734', 'Unequal limb length (acquired), left radius'),
    ('M21739', 'Unequal limb length (acquired), unspecified ulna and radius'),
    ('M21751', 'Unequal limb length (acquired), right femur'),
    ('M21752', 'Unequal limb length (acquired), left femur'),
    ('M21759', 'Unequal limb length (acquired), unspecified femur'),
    ('M21761', 'Unequal limb length (acquired), right tibia'),
    ('M21762', 'Unequal limb length (acquired), left tibia'),
    ('M21763', 'Unequal limb length (acquired), right fibula'),
    ('M21764', 'Unequal limb length (acquired), left fibula'),
    ('M21769', 'Unequal limb length (acquired), unspecified tibia and fibula'),
    ('M2180', 'Other specified acquired deformities of unspecified limb'),
    ('M21821', 'Other specified acquired deformities of right upper arm'),
    ('M21822', 'Other specified acquired deformities of left upper arm'),
    ('M21829', 'Oth acquired deformities of unspecified upper arm'),
    ('M21831', 'Other specified acquired deformities of right forearm'),
    ('M21832', 'Other specified acquired deformities of left forearm'),
    ('M21839', 'Other specified acquired deformities of unspecified forearm'),
    ('M21851', 'Other specified acquired deformities of right thigh'),
    ('M21852', 'Other specified acquired deformities of left thigh'),
    ('M21859', 'Other specified acquired deformities of unspecified thigh'),
    ('M21861', 'Other specified acquired deformities of right lower leg'),
    ('M21862', 'Other specified acquired deformities of left lower leg'),
    ('M21869', 'Oth acquired deformities of unspecified lower leg'),
    ('M2190', 'Unspecified acquired deformity of unspecified limb'),
    ('M21921', 'Unspecified acquired deformity of right upper arm'),
    ('M21922', 'Unspecified acquired deformity of left upper arm'),
    ('M21929', 'Unspecified acquired deformity of unspecified upper arm'),
    ('M21931', 'Unspecified acquired deformity of right forearm'),
    ('M21932', 'Unspecified acquired deformity of left forearm'),
    ('M21939', 'Unspecified acquired deformity of unspecified forearm'),
    ('M21941', 'Unspecified acquired deformity of hand, right hand'),
    ('M21942', 'Unspecified acquired deformity of hand, left hand'),
    ('M21949', 'Unspecified acquired deformity of hand, unspecified hand'),
    ('M21951', 'Unspecified acquired deformity of right thigh'),
    ('M21952', 'Unspecified acquired deformity of left thigh'),
    ('M21959', 'Unspecified acquired deformity of unspecified thigh'),
    ('M21961', 'Unspecified acquired deformity of right lower leg'),
    ('M21962', 'Unspecified acquired deformity of left lower leg'),
    ('M21969', 'Unspecified acquired deformity of unspecified lower leg'),
    ('M2200', 'Recurrent dislocation of patella, unspecified knee'),
    ('M2201', 'Recurrent dislocation of patella, right knee'),
    ('M2202', 'Recurrent dislocation of patella, left knee'),
    ('M2210', 'Recurrent subluxation of patella, unspecified knee'),
    ('M2211', 'Recurrent subluxation of patella, right knee'),
    ('M2212', 'Recurrent subluxation of patella, left knee'),
    ('M222X1', 'Patellofemoral disorders, right knee'),
    ('M222X2', 'Patellofemoral disorders, left knee'),
    ('M222X9', 'Patellofemoral disorders, unspecified knee'),
    ('M223X1', 'Other derangements of patella, right knee'),
    ('M223X2', 'Other derangements of patella, left knee'),
    ('M223X9', 'Other derangements of patella, unspecified knee'),
    ('M2240', 'Chondromalacia patellae, unspecified knee'),
    ('M2241', 'Chondromalacia patellae, right knee'),
    ('M2242', 'Chondromalacia patellae, left knee'),
    ('M228X1', 'Other disorders of patella, right knee'),
    ('M228X2', 'Other disorders of patella, left knee'),
    ('M228X9', 'Other disorders of patella, unspecified knee'),
    ('M2290', 'Unspecified disorder of patella, unspecified knee'),
    ('M2291', 'Unspecified disorder of patella, right knee'),
    ('M2292', 'Unspecified disorder of patella, left knee'),
    ('M23000', 'Cystic meniscus, unspecified lateral meniscus, right knee'),
    ('M23001', 'Cystic meniscus, unspecified lateral meniscus, left knee'),
    ('M23002', 'Cystic meniscus, unsp lateral meniscus, unspecified knee'),
    ('M23003', 'Cystic meniscus, unspecified medial meniscus, right knee'),
    ('M23004', 'Cystic meniscus, unspecified medial meniscus, left knee'),
    ('M23005', 'Cystic meniscus, unsp medial meniscus, unspecified knee'),
    ('M23006', 'Cystic meniscus, unspecified meniscus, right knee'),
    ('M23007', 'Cystic meniscus, unspecified meniscus, left knee'),
    ('M23009', 'Cystic meniscus, unspecified meniscus, unspecified knee'),
    ('M23011', 'Cystic meniscus, anterior horn of medial meniscus, r knee'),
    ('M23012', 'Cystic meniscus, anterior horn of medial meniscus, left knee'),
    ('M23019', 'Cystic meniscus, anterior horn of medial meniscus, unsp knee'),
    ('M23021', 'Cystic meniscus, posterior horn of medial meniscus, r knee'),
    ('M23022', 'Cystic meniscus, posterior horn of medial meniscus, l knee'),
    ('M23029', 'Cystic meniscus, post horn of medial meniscus, unsp knee'),
    ('M23031', 'Cystic meniscus, other medial meniscus, right knee'),
    ('M23032', 'Cystic meniscus, other medial meniscus, left knee'),
    ('M23039', 'Cystic meniscus, other medial meniscus, unspecified knee'),
    ('M23041', 'Cystic meniscus, anterior horn of lat mensc, right knee'),
    ('M23042', 'Cystic meniscus, anterior horn of lat mensc, left knee'),
    ('M23049', 'Cystic meniscus, anterior horn of lat mensc, unsp knee'),
    ('M23051', 'Cystic meniscus, posterior horn of lat mensc, right knee'),
    ('M23052', 'Cystic meniscus, posterior horn of lat mensc, left knee'),
    ('M23059', 'Cystic meniscus, posterior horn of lat mensc, unsp knee'),
    ('M23061', 'Cystic meniscus, other lateral meniscus, right knee'),
    ('M23062', 'Cystic meniscus, other lateral meniscus, left knee'),
    ('M23069', 'Cystic meniscus, other lateral meniscus, unspecified knee'),
    ('M23200', 'Derang of unsp lat mensc due to old tear/inj, right knee'),
    ('M23201', 'Derangement of unsp lat mensc due to old tear/inj, left knee'),
    ('M23202', 'Derangement of unsp lat mensc due to old tear/inj, unsp knee'),
    ('M23203', 'Derang of unsp medial meniscus due to old tear/inj, r knee'),
    ('M23204', 'Derang of unsp medial meniscus due to old tear/inj, l knee'),
    ('M23205', 'Derang of unsp medial mensc due to old tear/inj, unsp knee'),
    ('M23206', 'Derangement of unsp meniscus due to old tear/inj, right knee'),
    ('M23207', 'Derangement of unsp meniscus due to old tear/inj, left knee'),
    ('M23209', 'Derangement of unsp meniscus due to old tear/inj, unsp knee'),
    ('M23211', 'Derang of ant horn of medial mensc d/t old tear/inj, r knee'),
    ('M23212', 'Derang of ant horn of medial mensc d/t old tear/inj, l knee'),
    ('M23219', 'Derang of ant horn of med mensc d/t old tear/inj, unsp knee'),
    ('M23221', 'Derang of post horn of medial mensc d/t old tear/inj, r knee'),
    ('M23222', 'Derang of post horn of medial mensc d/t old tear/inj, l knee'),
    ('M23229', 'Derang of post horn of med mensc d/t old tear/inj, unsp knee'),
    ('M23231', 'Derang of medial meniscus due to old tear/inj, right knee'),
    ('M23232', 'Derang of medial meniscus due to old tear/inj, left knee'),
    ('M23239', 'Derang of medial meniscus due to old tear/inj, unsp knee'),
    ('M23241', 'Derang of ant horn of lat mensc due to old tear/inj, r knee'),
    ('M23242', 'Derang of ant horn of lat mensc due to old tear/inj, l knee'),
    ('M23249', 'Derang of ant horn of lat mensc d/t old tear/inj, unsp knee'),
    ('M23251', 'Derang of post horn of lat mensc due to old tear/inj, r knee'),
    ('M23252', 'Derang of post horn of lat mensc due to old tear/inj, l knee'),
    ('M23259', 'Derang of post horn of lat mensc d/t old tear/inj, unsp knee'),
    ('M23261', 'Derangement of lat mensc due to old tear/inj, right knee'),
    ('M23262', 'Derangement of lat mensc due to old tear/inj, left knee'),
    ('M23269', 'Derangement of lat mensc due to old tear/inj, unsp knee'),
    ('M23300', 'Oth meniscus derangements, unsp lateral meniscus, right knee'),
    ('M23301', 'Oth meniscus derangements, unsp lateral meniscus, left knee'),
    ('M23302', 'Oth meniscus derangements, unsp lateral meniscus, unsp knee'),
    ('M23303', 'Oth meniscus derangements, unsp medial meniscus, right knee'),
    ('M23304', 'Other meniscus derangements, unsp medial meniscus, left knee'),
    ('M23305', 'Other meniscus derangements, unsp medial meniscus, unsp knee'),
    ('M23306', 'Other meniscus derangements, unsp meniscus, right knee'),
    ('M23307', 'Other meniscus derangements, unspecified meniscus, left knee'),
    ('M23309', 'Other meniscus derangements, unsp meniscus, unspecified knee'),
    ('M23311', 'Oth meniscus derang, ant horn of medial meniscus, r knee'),
    ('M23312', 'Oth meniscus derang, ant horn of medial meniscus, l knee'),
    ('M23319', 'Oth meniscus derang, ant horn of medial meniscus, unsp knee'),
    ('M23321', 'Oth meniscus derang, post horn of medial meniscus, r knee'),
    ('M23322', 'Oth meniscus derang, post horn of medial meniscus, l knee'),
    ('M23329', 'Oth meniscus derang, post horn of medial meniscus, unsp knee'),
    ('M23331', 'Oth meniscus derangements, other medial meniscus, right knee'),
    ('M23332', 'Oth meniscus derangements, other medial meniscus, left knee'),
    ('M23339', 'Oth meniscus derangements, other medial meniscus, unsp knee'),
    ('M23341', 'Oth meniscus derang, anterior horn of lat mensc, right knee'),
    ('M23342', 'Oth meniscus derang, anterior horn of lat mensc, left knee'),
    ('M23349', 'Oth meniscus derang, anterior horn of lat mensc, unsp knee'),
    ('M23351', 'Oth meniscus derang, posterior horn of lat mensc, right knee'),
    ('M23352', 'Oth meniscus derang, posterior horn of lat mensc, left knee'),
    ('M23359', 'Oth meniscus derang, posterior horn of lat mensc, unsp knee'),
    ('M23361', 'Oth meniscus derangements, oth lateral meniscus, right knee'),
    ('M23362', 'Oth meniscus derangements, other lateral meniscus, left knee'),
    ('M23369', 'Oth meniscus derangements, other lateral meniscus, unsp knee'),
    ('M2340', 'Loose body in knee, unspecified knee'),
    ('M2341', 'Loose body in knee, right knee'),
    ('M2342', 'Loose body in knee, left knee'),
    ('M2350', 'Chronic instability of knee, unspecified knee'),
    ('M2351', 'Chronic instability of knee, right knee'),
    ('M2352', 'Chronic instability of knee, left knee'),
    ('M23601', 'Other spontaneous disruption of unsp ligament of right knee'),
    ('M23602', 'Other spontaneous disruption of unsp ligament of left knee'),
    ('M23609', 'Other spontaneous disruption of unsp ligament of unsp knee'),
    ('M23611', 'Oth spon disrupt of anterior cruciate ligament of right knee'),
    ('M23612', 'Oth spon disrupt of anterior cruciate ligament of left knee'),
    ('M23619', 'Oth spon disrupt of anterior cruciate ligament of unsp knee'),
    ('M23621', 'Oth spon disrupt of posterior cruciate ligament of r knee'),
    ('M23622', 'Oth spon disrupt of posterior cruciate ligament of left knee'),
    ('M23629', 'Oth spon disrupt of posterior cruciate ligament of unsp knee'),
    ('M23631', 'Oth spon disruption of medial collat ligament of right knee'),
    ('M23632', 'Oth spon disruption of medial collat ligament of left knee'),
    ('M23639', 'Oth spon disruption of medial collat ligament of unsp knee'),
    ('M23641', 'Oth spon disruption of lateral collat ligament of right knee'),
    ('M23642', 'Oth spon disruption of lateral collat ligament of left knee'),
    ('M23649', 'Oth spon disruption of lateral collat ligament of unsp knee'),
    ('M23671', 'Oth spon disruption of capsular ligament of right knee'),
    ('M23672', 'Oth spontaneous disruption of capsular ligament of left knee'),
    ('M23679', 'Oth spontaneous disruption of capsular ligament of unsp knee'),
    ('M238X1', 'Other internal derangements of right knee'),
    ('M238X2', 'Other internal derangements of left knee'),
    ('M238X9', 'Other internal derangements of unspecified knee'),
    ('M2390', 'Unspecified internal derangement of unspecified knee'),
    ('M2391', 'Unspecified internal derangement of right knee'),
    ('M2392', 'Unspecified internal derangement of left knee'),
    ('M2400', 'Loose body in unspecified joint'),
    ('M24011', 'Loose body in right shoulder'),
    ('M24012', 'Loose body in left shoulder'),
    ('M24019', 'Loose body in unspecified shoulder'),
    ('M24021', 'Loose body in right elbow'),
    ('M24022', 'Loose body in left elbow'),
    ('M24029', 'Loose body in unspecified elbow'),
    ('M24031', 'Loose body in right wrist'),
    ('M24032', 'Loose body in left wrist'),
    ('M24039', 'Loose body in unspecified wrist'),
    ('M24041', 'Loose body in right finger joint(s)'),
    ('M24042', 'Loose body in left finger joint(s)'),
    ('M24049', 'Loose body in unspecified finger joint(s)'),
    ('M24051', 'Loose body in right hip'),
    ('M24052', 'Loose body in left hip'),
    ('M24059', 'Loose body in unspecified hip'),
    ('M24071', 'Loose body in right ankle'),
    ('M24072', 'Loose body in left ankle'),
    ('M24073', 'Loose body in unspecified ankle'),
    ('M24074', 'Loose body in right toe joint(s)'),
    ('M24075', 'Loose body in left toe joint(s)'),
    ('M24076', 'Loose body in unspecified toe joints'),
    ('M2408', 'Loose body, other site'),
    ('M2410', 'Other articular cartilage disorders, unspecified site'),
    ('M24111', 'Other articular cartilage disorders, right shoulder'),
    ('M24112', 'Other articular cartilage disorders, left shoulder'),
    ('M24119', 'Other articular cartilage disorders, unspecified shoulder'),
    ('M24121', 'Other articular cartilage disorders, right elbow'),
    ('M24122', 'Other articular cartilage disorders, left elbow'),
    ('M24129', 'Other articular cartilage disorders, unspecified elbow'),
    ('M24131', 'Other articular cartilage disorders, right wrist'),
    ('M24132', 'Other articular cartilage disorders, left wrist'),
    ('M24139', 'Other articular cartilage disorders, unspecified wrist'),
    ('M24141', 'Other articular cartilage disorders, right hand'),
    ('M24142', 'Other articular cartilage disorders, left hand'),
    ('M24149', 'Other articular cartilage disorders, unspecified hand'),
    ('M24151', 'Other articular cartilage disorders, right hip'),
    ('M24152', 'Other articular cartilage disorders, left hip'),
    ('M24159', 'Other articular cartilage disorders, unspecified hip'),
    ('M24171', 'Other articular cartilage disorders, right ankle'),
    ('M24172', 'Other articular cartilage disorders, left ankle'),
    ('M24173', 'Other articular cartilage disorders, unspecified ankle'),
    ('M24174', 'Other articular cartilage disorders, right foot'),
    ('M24175', 'Other articular cartilage disorders, left foot'),
    ('M24176', 'Other articular cartilage disorders, unspecified foot'),
    ('M2419', 'Other articular cartilage disorders, other specified site'),
    ('M2420', 'Disorder of ligament, unspecified site'),
    ('M24211', 'Disorder of ligament, right shoulder'),
    ('M24212', 'Disorder of ligament, left shoulder'),
    ('M24219', 'Disorder of ligament, unspecified shoulder'),
    ('M24221', 'Disorder of ligament, right elbow'),
    ('M24222', 'Disorder of ligament, left elbow'),
    ('M24229', 'Disorder of ligament, unspecified elbow'),
    ('M24231', 'Disorder of ligament, right wrist'),
    ('M24232', 'Disorder of ligament, left wrist'),
    ('M24239', 'Disorder of ligament, unspecified wrist'),
    ('M24241', 'Disorder of ligament, right hand'),
    ('M24242', 'Disorder of ligament, left hand'),
    ('M24249', 'Disorder of ligament, unspecified hand'),
    ('M24251', 'Disorder of ligament, right hip'),
    ('M24252', 'Disorder of ligament, left hip'),
    ('M24259', 'Disorder of ligament, unspecified hip'),
    ('M24271', 'Disorder of ligament, right ankle'),
    ('M24272', 'Disorder of ligament, left ankle'),
    ('M24273', 'Disorder of ligament, unspecified ankle'),
    ('M24274', 'Disorder of ligament, right foot'),
    ('M24275', 'Disorder of ligament, left foot'),
    ('M24276', 'Disorder of ligament, unspecified foot'),
    ('M2428', 'Disorder of ligament, vertebrae'),
    ('M2429', 'Disorder of ligament, other specified site'),
    ('M2430', 'Pathological dislocation of unsp joint, NEC'),
    ('M24311', 'Pathological dislocation of right shoulder, NEC'),
    ('M24312', 'Pathological dislocation of left shoulder, NEC'),
    ('M24319', 'Pathological dislocation of unsp shoulder, NEC'),
    ('M24321', 'Pathological dislocation of right elbow, NEC'),
    ('M24322', 'Pathological dislocation of left elbow, NEC'),
    ('M24329', 'Pathological dislocation of unsp elbow, NEC'),
    ('M24331', 'Pathological dislocation of right wrist, NEC'),
    ('M24332', 'Pathological dislocation of left wrist, NEC'),
    ('M24339', 'Pathological dislocation of unsp wrist, NEC'),
    ('M24341', 'Pathological dislocation of right hand, NEC'),
    ('M24342', 'Pathological dislocation of left hand, NEC'),
    ('M24349', 'Pathological dislocation of unsp hand, NEC'),
    ('M24351', 'Pathological dislocation of right hip, NEC'),
    ('M24352', 'Pathological dislocation of left hip, NEC'),
    ('M24359', 'Pathological dislocation of unsp hip, NEC'),
    ('M24361', 'Pathological dislocation of right knee, NEC'),
    ('M24362', 'Pathological dislocation of left knee, NEC'),
    ('M24369', 'Pathological dislocation of unsp knee, NEC'),
    ('M24371', 'Pathological dislocation of right ankle, NEC'),
    ('M24372', 'Pathological dislocation of left ankle, NEC'),
    ('M24373', 'Pathological dislocation of unsp ankle, NEC'),
    ('M24374', 'Pathological dislocation of right foot, NEC'),
    ('M24375', 'Pathological dislocation of left foot, NEC'),
    ('M24376', 'Pathological dislocation of unsp foot, NEC'),
    ('M2439', 'Pathological dislocation of other specified joint, NEC'),
    ('M2440', 'Recurrent dislocation, unspecified joint'),
    ('M24411', 'Recurrent dislocation, right shoulder'),
    ('M24412', 'Recurrent dislocation, left shoulder'),
    ('M24419', 'Recurrent dislocation, unspecified shoulder'),
    ('M24421', 'Recurrent dislocation, right elbow'),
    ('M24422', 'Recurrent dislocation, left elbow'),
    ('M24429', 'Recurrent dislocation, unspecified elbow'),
    ('M24431', 'Recurrent dislocation, right wrist'),
    ('M24432', 'Recurrent dislocation, left wrist'),
    ('M24439', 'Recurrent dislocation, unspecified wrist'),
    ('M24441', 'Recurrent dislocation, right hand'),
    ('M24442', 'Recurrent dislocation, left hand'),
    ('M24443', 'Recurrent dislocation, unspecified hand'),
    ('M24444', 'Recurrent dislocation, right finger'),
    ('M24445', 'Recurrent dislocation, left finger'),
    ('M24446', 'Recurrent dislocation, unspecified finger'),
    ('M24451', 'Recurrent dislocation, right hip'),
    ('M24452', 'Recurrent dislocation, left hip'),
    ('M24459', 'Recurrent dislocation, unspecified hip'),
    ('M24461', 'Recurrent dislocation, right knee'),
    ('M24462', 'Recurrent dislocation, left knee'),
    ('M24469', 'Recurrent dislocation, unspecified knee'),
    ('M24471', 'Recurrent dislocation, right ankle'),
    ('M24472', 'Recurrent dislocation, left ankle'),
    ('M24473', 'Recurrent dislocation, unspecified ankle'),
    ('M24474', 'Recurrent dislocation, right foot'),
    ('M24475', 'Recurrent dislocation, left foot'),
    ('M24476', 'Recurrent dislocation, unspecified foot'),
    ('M24477', 'Recurrent dislocation, right toe(s)'),
    ('M24478', 'Recurrent dislocation, left toe(s)'),
    ('M24479', 'Recurrent dislocation, unspecified toe(s)'),
    ('M2449', 'Recurrent dislocation, other specified joint'),
    ('M2450', 'Contracture, unspecified joint'),
    ('M24511', 'Contracture, right shoulder'),
    ('M24512', 'Contracture, left shoulder'),
    ('M24519', 'Contracture, unspecified shoulder'),
    ('M24521', 'Contracture, right elbow'),
    ('M24522', 'Contracture, left elbow'),
    ('M24529', 'Contracture, unspecified elbow'),
    ('M24531', 'Contracture, right wrist'),
    ('M24532', 'Contracture, left wrist'),
    ('M24539', 'Contracture, unspecified wrist'),
    ('M24541', 'Contracture, right hand'),
    ('M24542', 'Contracture, left hand'),
    ('M24549', 'Contracture, unspecified hand'),
    ('M24551', 'Contracture, right hip'),
    ('M24552', 'Contracture, left hip'),
    ('M24559', 'Contracture, unspecified hip'),
    ('M24561', 'Contracture, right knee'),
    ('M24562', 'Contracture, left knee'),
    ('M24569', 'Contracture, unspecified knee'),
    ('M24571', 'Contracture, right ankle'),
    ('M24572', 'Contracture, left ankle'),
    ('M24573', 'Contracture, unspecified ankle'),
    ('M24574', 'Contracture, right foot'),
    ('M24575', 'Contracture, left foot'),
    ('M24576', 'Contracture, unspecified foot'),
    ('M2459', 'Contracture, other specified joint'),
    ('M2460', 'Ankylosis, unspecified joint'),
    ('M24611', 'Ankylosis, right shoulder'),
    ('M24612', 'Ankylosis, left shoulder'),
    ('M24619', 'Ankylosis, unspecified shoulder'),
    ('M24621', 'Ankylosis, right elbow'),
    ('M24622', 'Ankylosis, left elbow'),
    ('M24629', 'Ankylosis, unspecified elbow'),
    ('M24631', 'Ankylosis, right wrist'),
    ('M24632', 'Ankylosis, left wrist'),
    ('M24639', 'Ankylosis, unspecified wrist'),
    ('M24641', 'Ankylosis, right hand'),
    ('M24642', 'Ankylosis, left hand'),
    ('M24649', 'Ankylosis, unspecified hand'),
    ('M24651', 'Ankylosis, right hip'),
    ('M24652', 'Ankylosis, left hip'),
    ('M24659', 'Ankylosis, unspecified hip'),
    ('M24661', 'Ankylosis, right knee'),
    ('M24662', 'Ankylosis, left knee'),
    ('M24669', 'Ankylosis, unspecified knee'),
    ('M24671', 'Ankylosis, right ankle'),
    ('M24672', 'Ankylosis, left ankle'),
    ('M24673', 'Ankylosis, unspecified ankle'),
    ('M24674', 'Ankylosis, right foot'),
    ('M24675', 'Ankylosis, left foot'),
    ('M24676', 'Ankylosis, unspecified foot'),
    ('M2469', 'Ankylosis, other specified joint'),
    ('M247', 'Protrusio acetabuli'),
    ('M2480', 'Oth specific joint derangements of unsp joint, NEC'),
    ('M24811', 'Oth specific joint derangements of right shoulder, NEC'),
    ('M24812', 'Oth specific joint derangements of left shoulder, NEC'),
    ('M24819', 'Oth specific joint derangements of unsp shoulder, NEC'),
    ('M24821', 'Oth specific joint derangements of right elbow, NEC'),
    ('M24822', 'Oth specific joint derangements of left elbow, NEC'),
    ('M24829', 'Oth specific joint derangements of unsp elbow, NEC'),
    ('M24831', 'Oth specific joint derangements of right wrist, NEC'),
    ('M24832', 'Oth specific joint derangements of left wrist, NEC'),
    ('M24839', 'Oth specific joint derangements of unsp wrist, NEC'),
    ('M24841', 'Oth specific joint derangements of right hand, NEC'),
    ('M24842', 'Oth specific joint derangements of left hand, NEC'),
    ('M24849', 'Oth specific joint derangements of unsp hand, NEC'),
    ('M24851', 'Oth specific joint derangements of right hip, NEC'),
    ('M24852', 'Oth specific joint derangements of left hip, NEC'),
    ('M24859', 'Oth specific joint derangements of unsp hip, NEC'),
    ('M24871', 'Oth specific joint derangements of right ankle, NEC'),
    ('M24872', 'Oth specific joint derangements of left ankle, NEC'),
    ('M24873', 'Oth specific joint derangements of unsp ankle, NEC'),
    ('M24874', 'Oth specific joint derangements of right foot, NEC'),
    ('M24875', 'Oth specific joint derangements left foot, NEC'),
    ('M24876', 'Oth specific joint derangements of unsp foot, NEC'),
    ('M2489', 'Other specific joint derangement of oth joint, NEC'),
    ('M249', 'Joint derangement, unspecified'),
    ('M2500', 'Hemarthrosis, unspecified joint'),
    ('M25011', 'Hemarthrosis, right shoulder'),
    ('M25012', 'Hemarthrosis, left shoulder'),
    ('M25019', 'Hemarthrosis, unspecified shoulder'),
    ('M25021', 'Hemarthrosis, right elbow'),
    ('M25022', 'Hemarthrosis, left elbow'),
    ('M25029', 'Hemarthrosis, unspecified elbow'),
    ('M25031', 'Hemarthrosis, right wrist'),
    ('M25032', 'Hemarthrosis, left wrist'),
    ('M25039', 'Hemarthrosis, unspecified wrist'),
    ('M25041', 'Hemarthrosis, right hand'),
    ('M25042', 'Hemarthrosis, left hand'),
    ('M25049', 'Hemarthrosis, unspecified hand'),
    ('M25051', 'Hemarthrosis, right hip'),
    ('M25052', 'Hemarthrosis, left hip'),
    ('M25059', 'Hemarthrosis, unspecified hip'),
    ('M25061', 'Hemarthrosis, right knee'),
    ('M25062', 'Hemarthrosis, left knee'),
    ('M25069', 'Hemarthrosis, unspecified knee'),
    ('M25071', 'Hemarthrosis, right ankle'),
    ('M25072', 'Hemarthrosis, left ankle'),
    ('M25073', 'Hemarthrosis, unspecified ankle'),
    ('M25074', 'Hemarthrosis, right foot'),
    ('M25075', 'Hemarthrosis, left foot'),
    ('M25076', 'Hemarthrosis, unspecified foot'),
    ('M2508', 'Hemarthrosis, vertebrae'),
    ('M2510', 'Fistula, unspecified joint'),
    ('M25111', 'Fistula, right shoulder'),
    ('M25112', 'Fistula, left shoulder'),
    ('M25119', 'Fistula, unspecified shoulder'),
    ('M25121', 'Fistula, right elbow'),
    ('M25122', 'Fistula, left elbow'),
    ('M25129', 'Fistula, unspecified elbow'),
    ('M25131', 'Fistula, right wrist'),
    ('M25132', 'Fistula, left wrist'),
    ('M25139', 'Fistula, unspecified wrist'),
    ('M25141', 'Fistula, right hand'),
    ('M25142', 'Fistula, left hand'),
    ('M25149', 'Fistula, unspecified hand'),
    ('M25151', 'Fistula, right hip'),
    ('M25152', 'Fistula, left hip'),
    ('M25159', 'Fistula, unspecified hip'),
    ('M25161', 'Fistula, right knee'),
    ('M25162', 'Fistula, left knee'),
    ('M25169', 'Fistula, unspecified knee'),
    ('M25171', 'Fistula, right ankle'),
    ('M25172', 'Fistula, left ankle'),
    ('M25173', 'Fistula, unspecified ankle'),
    ('M25174', 'Fistula, right foot'),
    ('M25175', 'Fistula, left foot'),
    ('M25176', 'Fistula, unspecified foot'),
    ('M2518', 'Fistula, vertebrae'),
    ('M2520', 'Flail joint, unspecified joint'),
    ('M25211', 'Flail joint, right shoulder'),
    ('M25212', 'Flail joint, left shoulder'),
    ('M25219', 'Flail joint, unspecified shoulder'),
    ('M25221', 'Flail joint, right elbow'),
    ('M25222', 'Flail joint, left elbow'),
    ('M25229', 'Flail joint, unspecified elbow'),
    ('M25231', 'Flail joint, right wrist'),
    ('M25232', 'Flail joint, left wrist'),
    ('M25239', 'Flail joint, unspecified wrist'),
    ('M25241', 'Flail joint, right hand'),
    ('M25242', 'Flail joint, left hand'),
    ('M25249', 'Flail joint, unspecified hand'),
    ('M25251', 'Flail joint, right hip'),
    ('M25252', 'Flail joint, left hip'),
    ('M25259', 'Flail joint, unspecified hip'),
    ('M25261', 'Flail joint, right knee'),
    ('M25262', 'Flail joint, left knee'),
    ('M25269', 'Flail joint, unspecified knee'),
    ('M25271', 'Flail joint, right ankle and foot'),
    ('M25272', 'Flail joint, left ankle and foot'),
    ('M25279', 'Flail joint, unspecified ankle and foot'),
    ('M2528', 'Flail joint, other site'),
    ('M2530', 'Other instability, unspecified joint'),
    ('M25311', 'Other instability, right shoulder'),
    ('M25312', 'Other instability, left shoulder'),
    ('M25319', 'Other instability, unspecified shoulder'),
    ('M25321', 'Other instability, right elbow'),
    ('M25322', 'Other instability, left elbow'),
    ('M25329', 'Other instability, unspecified elbow'),
    ('M25331', 'Other instability, right wrist'),
    ('M25332', 'Other instability, left wrist'),
    ('M25339', 'Other instability, unspecified wrist'),
    ('M25341', 'Other instability, right hand'),
    ('M25342', 'Other instability, left hand'),
    ('M25349', 'Other instability, unspecified hand'),
    ('M25351', 'Other instability, right hip'),
    ('M25352', 'Other instability, left hip'),
    ('M25359', 'Other instability, unspecified hip'),
    ('M25361', 'Other instability, right knee'),
    ('M25362', 'Other instability, left knee'),
    ('M25369', 'Other instability, unspecified knee'),
    ('M25371', 'Other instability, right ankle'),
    ('M25372', 'Other instability, left ankle'),
    ('M25373', 'Other instability, unspecified ankle'),
    ('M25374', 'Other instability, right foot'),
    ('M25375', 'Other instability, left foot'),
    ('M25376', 'Other instability, unspecified foot'),
    ('M2539', 'Other instability, other specified joint'),
    ('M2540', 'Effusion, unspecified joint'),
    ('M25411', 'Effusion, right shoulder'),
    ('M25412', 'Effusion, left shoulder'),
    ('M25419', 'Effusion, unspecified shoulder'),
    ('M25421', 'Effusion, right elbow'),
    ('M25422', 'Effusion, left elbow'),
    ('M25429', 'Effusion, unspecified elbow'),
    ('M25431', 'Effusion, right wrist'),
    ('M25432', 'Effusion, left wrist'),
    ('M25439', 'Effusion, unspecified wrist'),
    ('M25441', 'Effusion, right hand'),
    ('M25442', 'Effusion, left hand'),
    ('M25449', 'Effusion, unspecified hand'),
    ('M25451', 'Effusion, right hip'),
    ('M25452', 'Effusion, left hip'),
    ('M25459', 'Effusion, unspecified hip'),
    ('M25461', 'Effusion, right knee'),
    ('M25462', 'Effusion, left knee'),
    ('M25469', 'Effusion, unspecified knee'),
    ('M25471', 'Effusion, right ankle'),
    ('M25472', 'Effusion, left ankle'),
    ('M25473', 'Effusion, unspecified ankle'),
    ('M25474', 'Effusion, right foot'),
    ('M25475', 'Effusion, left foot'),
    ('M25476', 'Effusion, unspecified foot'),
    ('M2548', 'Effusion, other site'),
    ('M2550', 'Pain in unspecified joint'),
    ('M2551', 'Pain in shoulder'),
    ('M25511', 'Pain in right shoulder'),
    ('M25512', 'Pain in left shoulder'),
    ('M25519', 'Pain in unspecified shoulder'),
    ('M25521', 'Pain in right elbow'),
    ('M25522', 'Pain in left elbow'),
    ('M25529', 'Pain in unspecified elbow'),
    ('M25531', 'Pain in right wrist'),
    ('M25532', 'Pain in left wrist'),
    ('M25539', 'Pain in unspecified wrist'),
    ('M25541', 'Pain in joints of right hand'),
    ('M25542', 'Pain in joints of left hand'),
    ('M25549', 'Pain in joints of unspecified hand'),
    ('M25551', 'Pain in right hip'),
    ('M25552', 'Pain in left hip'),
    ('M25559', 'Pain in unspecified hip'),
    ('M25561', 'Pain in right knee'),
    ('M25562', 'Pain in left knee'),
    ('M25569', 'Pain in unspecified knee'),
    ('M25571', 'Pain in right ankle and joints of right foot'),
    ('M25572', 'Pain in left ankle and joints of left foot'),
    ('M25579', 'Pain in unspecified ankle and joints of unspecified foot'),
    ('M2559', 'Pain in other specified joint'),
    ('M2560', 'Stiffness of unspecified joint, not elsewhere classified'),
    ('M25611', 'Stiffness of right shoulder, not elsewhere classified'),
    ('M25612', 'Stiffness of left shoulder, not elsewhere classified'),
    ('M25619', 'Stiffness of unspecified shoulder, not elsewhere classified'),
    ('M25621', 'Stiffness of right elbow, not elsewhere classified'),
    ('M25622', 'Stiffness of left elbow, not elsewhere classified'),
    ('M25629', 'Stiffness of unspecified elbow, not elsewhere classified'),
    ('M25631', 'Stiffness of right wrist, not elsewhere classified'),
    ('M25632', 'Stiffness of left wrist, not elsewhere classified'),
    ('M25639', 'Stiffness of unspecified wrist, not elsewhere classified'),
    ('M25641', 'Stiffness of right hand, not elsewhere classified'),
    ('M25642', 'Stiffness of left hand, not elsewhere classified'),
    ('M25649', 'Stiffness of unspecified hand, not elsewhere classified'),
    ('M25651', 'Stiffness of right hip, not elsewhere classified'),
    ('M25652', 'Stiffness of left hip, not elsewhere classified'),
    ('M25659', 'Stiffness of unspecified hip, not elsewhere classified'),
    ('M25661', 'Stiffness of right knee, not elsewhere classified'),
    ('M25662', 'Stiffness of left knee, not elsewhere classified'),
    ('M25669', 'Stiffness of unspecified knee, not elsewhere classified'),
    ('M25671', 'Stiffness of right ankle, not elsewhere classified'),
    ('M25672', 'Stiffness of left ankle, not elsewhere classified'),
    ('M25673', 'Stiffness of unspecified ankle, not elsewhere classified'),
    ('M25674', 'Stiffness of right foot, not elsewhere classified'),
    ('M25675', 'Stiffness of left foot, not elsewhere classified'),
    ('M25676', 'Stiffness of unspecified foot, not elsewhere classified'),
    ('M2569', 'Stiffness of other specified joint, not elsewhere classified'),
    ('M2570', 'Osteophyte, unspecified joint'),
    ('M25711', 'Osteophyte, right shoulder'),
    ('M25712', 'Osteophyte, left shoulder'),
    ('M25719', 'Osteophyte, unspecified shoulder'),
    ('M25721', 'Osteophyte, right elbow'),
    ('M25722', 'Osteophyte, left elbow'),
    ('M25729', 'Osteophyte, unspecified elbow'),
    ('M25731', 'Osteophyte, right wrist'),
    ('M25732', 'Osteophyte, left wrist'),
    ('M25739', 'Osteophyte, unspecified wrist'),
    ('M25741', 'Osteophyte, right hand'),
    ('M25742', 'Osteophyte, left hand'),
    ('M25749', 'Osteophyte, unspecified hand'),
    ('M25751', 'Osteophyte, right hip'),
    ('M25752', 'Osteophyte, left hip'),
    ('M25759', 'Osteophyte, unspecified hip'),
    ('M25761', 'Osteophyte, right knee'),
    ('M25762', 'Osteophyte, left knee'),
    ('M25769', 'Osteophyte, unspecified knee'),
    ('M25771', 'Osteophyte, right ankle'),
    ('M25772', 'Osteophyte, left ankle'),
    ('M25773', 'Osteophyte, unspecified ankle'),
    ('M25774', 'Osteophyte, right foot'),
    ('M25775', 'Osteophyte, left foot'),
    ('M25776', 'Osteophyte, unspecified foot'),
    ('M2578', 'Osteophyte, vertebrae'),
    ('M2580', 'Other specified joint disorders, unspecified joint'),
    ('M25811', 'Other specified joint disorders, right shoulder'),
    ('M25812', 'Other specified joint disorders, left shoulder'),
    ('M25819', 'Other specified joint disorders, unspecified shoulder'),
    ('M25821', 'Other specified joint disorders, right elbow'),
    ('M25822', 'Other specified joint disorders, left elbow'),
    ('M25829', 'Other specified joint disorders, unspecified elbow'),
    ('M25831', 'Other specified joint disorders, right wrist'),
    ('M25832', 'Other specified joint disorders, left wrist'),
    ('M25839', 'Other specified joint disorders, unspecified wrist'),
    ('M25841', 'Other specified joint disorders, right hand'),
    ('M25842', 'Other specified joint disorders, left hand'),
    ('M25849', 'Other specified joint disorders, unspecified hand'),
    ('M25851', 'Other specified joint disorders, right hip'),
    ('M25852', 'Other specified joint disorders, left hip'),
    ('M25859', 'Other specified joint disorders, unspecified hip'),
    ('M25861', 'Other specified joint disorders, right knee'),
    ('M25862', 'Other specified joint disorders, left knee'),
    ('M25869', 'Other specified joint disorders, unspecified knee'),
    ('M25871', 'Other specified joint disorders, right ankle and foot'),
    ('M25872', 'Other specified joint disorders, left ankle and foot'),
    ('M25879', 'Other specified joint disorders, unspecified ankle and foot'),
    ('M259', 'Joint disorder, unspecified'),
    ('M2600', 'Unspecified anomaly of jaw size'),
    ('M2601', 'Maxillary hyperplasia'),
    ('M2602', 'Maxillary hypoplasia'),
    ('M2603', 'Mandibular hyperplasia'),
    ('M2604', 'Mandibular hypoplasia'),
    ('M2605', 'Macrogenia'),
    ('M2606', 'Microgenia'),
    ('M2607', 'Excessive tuberosity of jaw'),
    ('M2609', 'Other specified anomalies of jaw size'),
    ('M2610', 'Unspecified anomaly of jaw-cranial base relationship'),
    ('M2611', 'Maxillary asymmetry'),
    ('M2612', 'Other jaw asymmetry'),
    ('M2619', 'Other specified anomalies of jaw-cranial base relationship'),
    ('M2620', 'Unspecified anomaly of dental arch relationship'),
    ('M26211', "Malocclusion, Angle's class I"),
    ('M26212', "Malocclusion, Angle's class II"),
    ('M26213', "Malocclusion, Angle's class III"),
    ('M26219', "Malocclusion, Angle's class, unspecified"),
    ('M26220', 'Open anterior occlusal relationship'),
    ('M26221', 'Open posterior occlusal relationship'),
    ('M2623', 'Excessive horizontal overlap'),
    ('M2624', 'Reverse articulation'),
    ('M2625', 'Anomalies of interarch distance'),
    ('M2629', 'Other anomalies of dental arch relationship'),
    ('M2630', 'Unsp anomaly of tooth position of fully erupted tooth/teeth'),
    ('M2631', 'Crowding of fully erupted teeth'),
    ('M2632', 'Excessive spacing of fully erupted teeth'),
    ('M2633', 'Horizontal displacement of fully erupted tooth or teeth'),
    ('M2634', 'Vertical displacement of fully erupted tooth or teeth'),
    ('M2635', 'Rotation of fully erupted tooth or teeth'),
    ('M2636', 'Insufficient interocclusal distance of fully erupted teeth'),
    ('M2637', 'Excessive interocclusal distance of fully erupted teeth'),
    ('M2639', 'Oth anomalies of tooth position of fully erupted tooth/teeth'),
    ('M264', 'Malocclusion, unspecified'),
    ('M2650', 'Dentofacial functional abnormalities, unspecified'),
    ('M2651', 'Abnormal jaw closure'),
    ('M2652', 'Limited mandibular range of motion'),
    ('M2653', 'Deviation in opening and closing of the mandible'),
    ('M2654', 'Insufficient anterior guidance'),
    ('M2655', 'Centric occlusion maximum intercuspation discrepancy'),
    ('M2656', 'Non-working side interference'),
    ('M2657', 'Lack of posterior occlusal support'),
    ('M2659', 'Other dentofacial functional abnormalities'),
    ('M2660', 'Temporomandibular joint disorder, unspecified'),
    ('M26601', 'Right temporomandibular joint disorder, unspecified'),
    ('M26602', 'Left temporomandibular joint disorder, unspecified'),
    ('M26603', 'Bilateral temporomandibular joint disorder, unspecified'),
    ('M26609', 'Unspecified TMJ joint disorder, unspecified side'),
    ('M2661', 'Adhesions and ankylosis of temporomandibular joint'),
    ('M26611', 'Adhesions and ankylosis of right temporomandibular joint'),
    ('M26612', 'Adhesions and ankylosis of left temporomandibular joint'),
    ('M26613', 'Adhesions and ankylosis of bilateral temporomandibular joint'),
    ('M26619', 'Adhesions and ankylosis of TMJ joint, unspecified side'),
    ('M2662', 'Arthralgia of temporomandibular joint'),
    ('M26621', 'Arthralgia of right temporomandibular joint'),
    ('M26622', 'Arthralgia of left temporomandibular joint'),
    ('M26623', 'Arthralgia of bilateral temporomandibular joint'),
    ('M26629', 'Arthralgia of temporomandibular joint, unspecified side'),
    ('M2663', 'Articular disc disorder of temporomandibular joint'),
    ('M26631', 'Articular disc disorder of right temporomandibular joint'),
    ('M26632', 'Articular disc disorder of left temporomandibular joint'),
    ('M26633', 'Articular disc disorder of bilateral temporomandibular joint'),
    ('M26639', 'Articular disc disorder of TMJ joint, unspecified side'),
    ('M26641', 'Arthritis of right temporomandibular joint'),
    ('M26642', 'Arthritis of left temporomandibular joint'),
    ('M26643', 'Arthritis of bilateral temporomandibular joint'),
    ('M26649', 'Arthritis of unspecified temporomandibular joint'),
    ('M26651', 'Arthropathy of right temporomandibular joint'),
    ('M26652', 'Arthropathy of left temporomandibular joint'),
    ('M26653', 'Arthropathy of bilateral temporomandibular joint'),
    ('M26659', 'Arthropathy of unspecified temporomandibular joint'),
    ('M2669', 'Other specified disorders of temporomandibular joint'),
    ('M2670', 'Unspecified alveolar anomaly'),
    ('M2671', 'Alveolar maxillary hyperplasia'),
    ('M2672', 'Alveolar mandibular hyperplasia'),
    ('M2673', 'Alveolar maxillary hypoplasia'),
    ('M2674', 'Alveolar mandibular hypoplasia'),
    ('M2679', 'Other specified alveolar anomalies'),
    ('M2681', 'Anterior soft tissue impingement'),
    ('M2682', 'Posterior soft tissue impingement'),
    ('M2689', 'Other dentofacial anomalies'),
    ('M269', 'Dentofacial anomaly, unspecified'),
    ('M270', 'Developmental disorders of jaws'),
    ('M271', 'Giant cell granuloma, central'),
    ('M272', 'Inflammatory conditions of jaws'),
    ('M273', 'Alveolitis of jaws'),
    ('M2740', 'Unspecified cyst of jaw'),
    ('M2749', 'Other cysts of jaw'),
    ('M2751', 'Perforation of root canal space due to endodontic treatment'),
    ('M2752', 'Endodontic overfill'),
    ('M2753', 'Endodontic underfill'),
    ('M2759', 'Oth periradicular pathology assoc w prev endodontic trtmt'),
    ('M2761', 'Osseointegration failure of dental implant'),
    ('M2762', 'Post-osseointegration biological failure of dental implant'),
    ('M2763', 'Post-osseointegration mechanical failure of dental implant'),
    ('M2769', 'Other endosseous dental implant failure'),
    ('M278', 'Other specified diseases of jaws'),
    ('M279', 'Disease of jaws, unspecified'),
    ('M300', 'Polyarteritis nodosa'),
    ('M301', 'Polyarteritis with lung involvement [Churg-Strauss]'),
    ('M302', 'Juvenile polyarteritis'),
    ('M303', 'Mucocutaneous lymph node syndrome [Kawasaki]'),
    ('M308', 'Other conditions related to polyarteritis nodosa'),
    ('M310', 'Hypersensitivity angiitis'),
    ('M311', 'Thrombotic microangiopathy'),
    ('M3110 ', 'Thrombotic microangiopathy, unspecified'),
    ('M3111', 'Hematpoetc stem cell txpltation-assoc throm microangiopathy'),
    ('M3119', 'Other thrombotic microangiopathy'),
    ('M312', 'Lethal midline granuloma'),
    ('M3130', "Wegener's granulomatosis without renal involvement"),
    ('M3131', "Wegener's granulomatosis with renal involvement"),
    ('M314', 'Aortic arch syndrome [Takayasu]'),
    ('M315', 'Giant cell arteritis with polymyalgia rheumatica'),
    ('M316', 'Other giant cell arteritis'),
    ('M317', 'Microscopic polyangiitis'),
    ('M318', 'Other specified necrotizing vasculopathies'),
    ('M319', 'Necrotizing vasculopathy, unspecified'),
    ('M320', 'Drug-induced systemic lupus erythematosus'),
    ('M3210', 'Systemic lupus erythematosus, organ or system involv unsp'),
    ('M3211', 'Endocarditis in systemic lupus erythematosus'),
    ('M3212', 'Pericarditis in systemic lupus erythematosus'),
    ('M3213', 'Lung involvement in systemic lupus erythematosus'),
    ('M3214', 'Glomerular disease in systemic lupus erythematosus'),
    ('M3215', 'Tubulo-interstitial nephrop in sys lupus erythematosus'),
    ('M3219', 'Oth organ or system involv in systemic lupus erythematosus'),
    ('M328', 'Other forms of systemic lupus erythematosus'),
    ('M329', 'Systemic lupus erythematosus, unspecified'),
    ('M3300', 'Juvenile dermatomyositis, organ involvement unspecified'),
    ('M3301', 'Juvenile dermatomyositis with respiratory involvement'),
    ('M3302', 'Juvenile dermatomyositis with myopathy'),
    ('M3303', 'Juvenile dermatomyositis without myopathy'),
    ('M3309', 'Juvenile dermatomyositis with other organ involvement'),
    ('M3310', 'Other dermatomyositis, organ involvement unspecified'),
    ('M3311', 'Other dermatomyositis with respiratory involvement'),
    ('M3312', 'Other dermatomyositis with myopathy'),
    ('M3313', 'Other dermatomyositis without myopathy'),
    ('M3319', 'Other dermatomyositis with other organ involvement'),
    ('M3320', 'Polymyositis, organ involvement unspecified'),
    ('M3321', 'Polymyositis with respiratory involvement'),
    ('M3322', 'Polymyositis with myopathy'),
    ('M3329', 'Polymyositis with other organ involvement'),
    ('M3390', 'Dermatopolymyositis, unsp, organ involvement unspecified'),
    ('M3391', 'Dermatopolymyositis, unsp with respiratory involvement'),
    ('M3392', 'Dermatopolymyositis, unspecified with myopathy'),
    ('M3393', 'Dermatopolymyositis, unspecified without myopathy'),
    ('M3399', 'Dermatopolymyositis, unsp with other organ involvement'),
    ('M340', 'Progressive systemic sclerosis'),
    ('M341', 'CR(E)ST syndrome'),
    ('M342', 'Systemic sclerosis induced by drug and chemical'),
    ('M3481', 'Systemic sclerosis with lung involvement'),
    ('M3482', 'Systemic sclerosis with myopathy'),
    ('M3483', 'Systemic sclerosis with polyneuropathy'),
    ('M3489', 'Other systemic sclerosis'),
    ('M349', 'Systemic sclerosis, unspecified'),
    ('M3500', 'Sjogren syndrome, unspecified'),
    ('M3501', 'Sjogren syndrome with keratoconjunctivitis'),
    ('M3502', 'Sjogren syndrome with lung involvement'),
    ('M3503', 'Sjogren syndrome with myopathy'),
    ('M3504', 'Sjogren syndrome with tubulo-interstitial nephropathy'),
    ('M3505', 'Sjogren syndrome with inflammatory arthritis'),
    ('M3506', 'Sjogren syndrome with peripheral nervous system involvement'),
    ('M3507', 'Sjogren syndrome with central nervous system involvement'),
    ('M3508', 'Sjogren syndrome with gastrointestinal involvement'),
    ('M3509', 'Sjogren syndrome with other organ involvement'),
    ('M350A', 'Sjogren syndrome with glomerular disease'),
    ('M350B', 'Sjogren syndrome with vasculitis'),
    ('M350C', 'Sjogren syndrome with dental involvement '),
    ('M351', 'Other overlap syndromes'),
    ('M352', "Behcet's disease"),
    ('M353', 'Polymyalgia rheumatica'),
    ('M354', 'Diffuse (eosinophilic) fasciitis'),
    ('M355', 'Multifocal fibrosclerosis'),
    ('M356', 'Relapsing panniculitis [Weber-Christian]'),
    ('M357', 'Hypermobility syndrome'),
    ('M358', 'Other specified systemic involvement of connective tissue'),
    ('M359', 'Systemic involvement of connective tissue, unspecified'),
    ('M360', 'Dermato(poly)myositis in neoplastic disease'),
    ('M361', 'Arthropathy in neoplastic disease'),
    ('M362', 'Hemophilic arthropathy'),
    ('M363', 'Arthropathy in other blood disorders'),
    ('M364', 'Arthropathy in hypersensitivity reactions classd elswhr'),
    ('M368', 'Systemic disord of conn tiss in oth diseases classd elswhr'),
    ('M4000', 'Postural kyphosis, site unspecified'),
    ('M4003', 'Postural kyphosis, cervicothoracic region'),
    ('M4004', 'Postural kyphosis, thoracic region'),
    ('M4005', 'Postural kyphosis, thoracolumbar region'),
    ('M4010', 'Other secondary kyphosis, site unspecified'),
    ('M4012', 'Other secondary kyphosis, cervical region'),
    ('M4013', 'Other secondary kyphosis, cervicothoracic region'),
    ('M4014', 'Other secondary kyphosis, thoracic region'),
    ('M4015', 'Other secondary kyphosis, thoracolumbar region'),
    ('M40202', 'Unspecified kyphosis, cervical region'),
    ('M40203', 'Unspecified kyphosis, cervicothoracic region'),
    ('M40204', 'Unspecified kyphosis, thoracic region'),
    ('M40205', 'Unspecified kyphosis, thoracolumbar region'),
    ('M40209', 'Unspecified kyphosis, site unspecified'),
    ('M40292', 'Other kyphosis, cervical region'),
    ('M40293', 'Other kyphosis, cervicothoracic region'),
    ('M40294', 'Other kyphosis, thoracic region'),
    ('M40295', 'Other kyphosis, thoracolumbar region'),
    ('M40299', 'Other kyphosis, site unspecified'),
    ('M4030', 'Flatback syndrome, site unspecified'),
    ('M4035', 'Flatback syndrome, thoracolumbar region'),
    ('M4036', 'Flatback syndrome, lumbar region'),
    ('M4037', 'Flatback syndrome, lumbosacral region'),
    ('M4040', 'Postural lordosis, site unspecified'),
    ('M4045', 'Postural lordosis, thoracolumbar region'),
    ('M4046', 'Postural lordosis, lumbar region'),
    ('M4047', 'Postural lordosis, lumbosacral region'),
    ('M4050', 'Lordosis, unspecified, site unspecified'),
    ('M4055', 'Lordosis, unspecified, thoracolumbar region'),
    ('M4056', 'Lordosis, unspecified, lumbar region'),
    ('M4057', 'Lordosis, unspecified, lumbosacral region'),
    ('M4100', 'Infantile idiopathic scoliosis, site unspecified'),
    ('M4102', 'Infantile idiopathic scoliosis, cervical region'),
    ('M4103', 'Infantile idiopathic scoliosis, cervicothoracic region'),
    ('M4104', 'Infantile idiopathic scoliosis, thoracic region'),
    ('M4105', 'Infantile idiopathic scoliosis, thoracolumbar region'),
    ('M4106', 'Infantile idiopathic scoliosis, lumbar region'),
    ('M4107', 'Infantile idiopathic scoliosis, lumbosacral region'),
    ('M4108', 'Infantile idiopathic scoliosis, sacr/sacrocygl region'),
    ('M41112', 'Juvenile idiopathic scoliosis, cervical region'),
    ('M41113', 'Juvenile idiopathic scoliosis, cervicothoracic region'),
    ('M41114', 'Juvenile idiopathic scoliosis, thoracic region'),
    ('M41115', 'Juvenile idiopathic scoliosis, thoracolumbar region'),
    ('M41116', 'Juvenile idiopathic scoliosis, lumbar region'),
    ('M41117', 'Juvenile idiopathic scoliosis, lumbosacral region'),
    ('M41119', 'Juvenile idiopathic scoliosis, site unspecified'),
    ('M41122', 'Adolescent idiopathic scoliosis, cervical region'),
    ('M41123', 'Adolescent idiopathic scoliosis, cervicothoracic region'),
    ('M41124', 'Adolescent idiopathic scoliosis, thoracic region'),
    ('M41125', 'Adolescent idiopathic scoliosis, thoracolumbar region'),
    ('M41126', 'Adolescent idiopathic scoliosis, lumbar region'),
    ('M41127', 'Adolescent idiopathic scoliosis, lumbosacral region'),
    ('M41129', 'Adolescent idiopathic scoliosis, site unspecified'),
    ('M4120', 'Other idiopathic scoliosis, site unspecified'),
    ('M4122', 'Other idiopathic scoliosis, cervical region'),
    ('M4123', 'Other idiopathic scoliosis, cervicothoracic region'),
    ('M4124', 'Other idiopathic scoliosis, thoracic region'),
    ('M4125', 'Other idiopathic scoliosis, thoracolumbar region'),
    ('M4126', 'Other idiopathic scoliosis, lumbar region'),
    ('M4127', 'Other idiopathic scoliosis, lumbosacral region'),
    ('M4130', 'Thoracogenic scoliosis, site unspecified'),
    ('M4134', 'Thoracogenic scoliosis, thoracic region'),
    ('M4135', 'Thoracogenic scoliosis, thoracolumbar region'),
    ('M4140', 'Neuromuscular scoliosis, site unspecified'),
    ('M4141', 'Neuromuscular scoliosis, occipito-atlanto-axial region'),
    ('M4142', 'Neuromuscular scoliosis, cervical region'),
    ('M4143', 'Neuromuscular scoliosis, cervicothoracic region'),
    ('M4144', 'Neuromuscular scoliosis, thoracic region'),
    ('M4145', 'Neuromuscular scoliosis, thoracolumbar region'),
    ('M4146', 'Neuromuscular scoliosis, lumbar region'),
    ('M4147', 'Neuromuscular scoliosis, lumbosacral region'),
    ('M4150', 'Other secondary scoliosis, site unspecified'),
    ('M4152', 'Other secondary scoliosis, cervical region'),
    ('M4153', 'Other secondary scoliosis, cervicothoracic region'),
    ('M4154', 'Other secondary scoliosis, thoracic region'),
    ('M4155', 'Other secondary scoliosis, thoracolumbar region'),
    ('M4156', 'Other secondary scoliosis, lumbar region'),
    ('M4157', 'Other secondary scoliosis, lumbosacral region'),
    ('M4180', 'Other forms of scoliosis, site unspecified'),
    ('M4182', 'Other forms of scoliosis, cervical region'),
    ('M4183', 'Other forms of scoliosis, cervicothoracic region'),
    ('M4184', 'Other forms of scoliosis, thoracic region'),
    ('M4185', 'Other forms of scoliosis, thoracolumbar region'),
    ('M4186', 'Other forms of scoliosis, lumbar region'),
    ('M4187', 'Other forms of scoliosis, lumbosacral region'),
    ('M419', 'Scoliosis, unspecified'),
    ('M4200', 'Juvenile osteochondrosis of spine, site unspecified'),
    ('M4201', 'Juvenile osteochondrosis of spine, occipt-atlan-ax region'),
    ('M4202', 'Juvenile osteochondrosis of spine, cervical region'),
    ('M4203', 'Juvenile osteochondrosis of spine, cervicothoracic region'),
    ('M4204', 'Juvenile osteochondrosis of spine, thoracic region'),
    ('M4205', 'Juvenile osteochondrosis of spine, thoracolumbar region'),
    ('M4206', 'Juvenile osteochondrosis of spine, lumbar region'),
    ('M4207', 'Juvenile osteochondrosis of spine, lumbosacral region'),
    ('M4208', 'Juvenile osteochondrosis of spine, sacr/sacrocygl region'),
    ('M4209', 'Juvenile osteochondrosis of spine, multiple sites in spine'),
    ('M4210', 'Adult osteochondrosis of spine, site unspecified'),
    ('M4211', 'Adult osteochondrosis of spine, occipt-atlan-ax region'),
    ('M4212', 'Adult osteochondrosis of spine, cervical region'),
    ('M4213', 'Adult osteochondrosis of spine, cervicothoracic region'),
    ('M4214', 'Adult osteochondrosis of spine, thoracic region'),
    ('M4215', 'Adult osteochondrosis of spine, thoracolumbar region'),
    ('M4216', 'Adult osteochondrosis of spine, lumbar region'),
    ('M4217', 'Adult osteochondrosis of spine, lumbosacral region'),
    ('M4218', 'Adult osteochondrosis of spine, sacr/sacrocygl region'),
    ('M4219', 'Adult osteochondrosis of spine, multiple sites in spine'),
    ('M429', 'Spinal osteochondrosis, unspecified'),
    ('M4300', 'Spondylolysis, site unspecified'),
    ('M4301', 'Spondylolysis, occipito-atlanto-axial region'),
    ('M4302', 'Spondylolysis, cervical region'),
    ('M4303', 'Spondylolysis, cervicothoracic region'),
    ('M4304', 'Spondylolysis, thoracic region'),
    ('M4305', 'Spondylolysis, thoracolumbar region'),
    ('M4306', 'Spondylolysis, lumbar region'),
    ('M4307', 'Spondylolysis, lumbosacral region'),
    ('M4308', 'Spondylolysis, sacral and sacrococcygeal region'),
    ('M4309', 'Spondylolysis, multiple sites in spine'),
    ('M4310', 'Spondylolisthesis, site unspecified'),
    ('M4311', 'Spondylolisthesis, occipito-atlanto-axial region'),
    ('M4312', 'Spondylolisthesis, cervical region'),
    ('M4313', 'Spondylolisthesis, cervicothoracic region'),
    ('M4314', 'Spondylolisthesis, thoracic region'),
    ('M4315', 'Spondylolisthesis, thoracolumbar region'),
    ('M4316', 'Spondylolisthesis, lumbar region'),
    ('M4317', 'Spondylolisthesis, lumbosacral region'),
    ('M4318', 'Spondylolisthesis, sacral and sacrococcygeal region'),
    ('M4319', 'Spondylolisthesis, multiple sites in spine'),
    ('M4320', 'Fusion of spine, site unspecified'),
    ('M4321', 'Fusion of spine, occipito-atlanto-axial region'),
    ('M4322', 'Fusion of spine, cervical region'),
    ('M4323', 'Fusion of spine, cervicothoracic region'),
    ('M4324', 'Fusion of spine, thoracic region'),
    ('M4325', 'Fusion of spine, thoracolumbar region'),
    ('M4326', 'Fusion of spine, lumbar region'),
    ('M4327', 'Fusion of spine, lumbosacral region'),
    ('M4328', 'Fusion of spine, sacral and sacrococcygeal region'),
    ('M433', 'Recurrent atlantoaxial dislocation with myelopathy'),
    ('M434', 'Other recurrent atlantoaxial dislocation'),
    ('M435X2', 'Other recurrent vertebral dislocation, cervical region'),
    ('M435X3', 'Oth recurrent vertebral dislocation, cervicothoracic region'),
    ('M435X4', 'Other recurrent vertebral dislocation, thoracic region'),
    ('M435X5', 'Other recurrent vertebral dislocation, thoracolumbar region'),
    ('M435X6', 'Other recurrent vertebral dislocation, lumbar region'),
    ('M435X7', 'Other recurrent vertebral dislocation, lumbosacral region'),
    ('M435X8', 'Oth recurrent vertebral dislocation, sacr/sacrocygl region'),
    ('M435X9', 'Other recurrent vertebral dislocation, site unspecified'),
    ('M436', 'Torticollis'),
    ('M438X1', 'Oth deforming dorsopathies, occipito-atlanto-axial region'),
    ('M438X2', 'Other specified deforming dorsopathies, cervical region'),
    ('M438X3', 'Oth deforming dorsopathies, cervicothoracic region'),
    ('M438X4', 'Other specified deforming dorsopathies, thoracic region'),
    ('M438X5', 'Other specified deforming dorsopathies, thoracolumbar region'),
    ('M438X6', 'Other specified deforming dorsopathies, lumbar region'),
    ('M438X7', 'Other specified deforming dorsopathies, lumbosacral region'),
    ('M438X8', 'Oth deforming dorsopathies, sacral and sacrococcygeal region'),
    ('M438X9', 'Other specified deforming dorsopathies, site unspecified'),
    ('M439', 'Deforming dorsopathy, unspecified'),
    ('M450', 'Ankylosing spondylitis of multiple sites in spine'),
    ('M451', 'Ankylosing spondylitis of occipito-atlanto-axial region'),
    ('M452', 'Ankylosing spondylitis of cervical region'),
    ('M453', 'Ankylosing spondylitis of cervicothoracic region'),
    ('M454', 'Ankylosing spondylitis of thoracic region'),
    ('M455', 'Ankylosing spondylitis of thoracolumbar region'),
    ('M456', 'Ankylosing spondylitis lumbar region'),
    ('M457', 'Ankylosing spondylitis of lumbosacral region'),
    ('M458', 'Ankylosing spondylitis sacral and sacrococcygeal region'),
    ('M459', 'Ankylosing spondylitis of unspecified sites in spine'),
    ('M45A0 ', 'Non-radiographic axial spondyloarthritis unsp site in spin'),
    ('M45A1', 'Non-radiographic axial spondyloarthritis occipt-atlan-ax rgn'),
    ('M45A2', 'Non-radiographic axial spondyloarthritis of cervical region'),
    ('M45A3', 'Non-radiographic axial spondyloarthritis of cervicothor rgn'),
    ('M45A4', 'Non-radiographic axial spondyloarthritis of thoracic region'),
    ('M45A5', 'Non-radiographic axial spondyloarthritis of thrclm region'),
    ('M45A6', 'Non-radiographic axial spondyloarthritis of lumbar region'),
    ('M45A7', 'Non-radiographic axial spondyloarthritis of lumbosacr region'),
    ('M45A8', 'Non-radiographic axial spondyloarthritis sacr/sacrocygl rgn'),
    ('M45AB', 'Non-radiographic axial spondyloarthritis mult site in spine'),
    ('M4600', 'Spinal enthesopathy, site unspecified'),
    ('M4601', 'Spinal enthesopathy, occipito-atlanto-axial region'),
    ('M4602', 'Spinal enthesopathy, cervical region'),
    ('M4603', 'Spinal enthesopathy, cervicothoracic region'),
    ('M4604', 'Spinal enthesopathy, thoracic region'),
    ('M4605', 'Spinal enthesopathy, thoracolumbar region'),
    ('M4606', 'Spinal enthesopathy, lumbar region'),
    ('M4607', 'Spinal enthesopathy, lumbosacral region'),
    ('M4608', 'Spinal enthesopathy, sacral and sacrococcygeal region'),
    ('M4609', 'Spinal enthesopathy, multiple sites in spine'),
    ('M461', 'Sacroiliitis, not elsewhere classified'),
    ('M4620', 'Osteomyelitis of vertebra, site unspecified'),
    ('M4621', 'Osteomyelitis of vertebra, occipito-atlanto-axial region'),
    ('M4622', 'Osteomyelitis of vertebra, cervical region'),
    ('M4623', 'Osteomyelitis of vertebra, cervicothoracic region'),
    ('M4624', 'Osteomyelitis of vertebra, thoracic region'),
    ('M4625', 'Osteomyelitis of vertebra, thoracolumbar region'),
    ('M4626', 'Osteomyelitis of vertebra, lumbar region'),
    ('M4627', 'Osteomyelitis of vertebra, lumbosacral region'),
    ('M4628', 'Osteomyelitis of vertebra, sacral and sacrococcygeal region'),
    ('M4630', 'Infection of intervertebral disc (pyogenic), site unsp'),
    ('M4631', 'Infection of intvrt disc (pyogenic), occipt-atlan-ax region'),
    ('M4632', 'Infection of intervertebral disc (pyogenic), cervical region'),
    ('M4633', 'Infection of intvrt disc (pyogenic), cervicothor region'),
    ('M4634', 'Infection of intervertebral disc (pyogenic), thoracic region'),
    ('M4635', 'Infection of intvrt disc (pyogenic), thoracolumbar region'),
    ('M4636', 'Infection of intervertebral disc (pyogenic), lumbar region'),
    ('M4637', 'Infection of intvrt disc (pyogenic), lumbosacral region'),
    ('M4638', 'Infection of intvrt disc (pyogenic), sacr/sacrocygl region'),
    ('M4639', 'Infection of intvrt disc (pyogenic), multiple sites in spine'),
    ('M4640', 'Discitis, unspecified, site unspecified'),
    ('M4641', 'Discitis, unspecified, occipito-atlanto-axial region'),
    ('M4642', 'Discitis, unspecified, cervical region'),
    ('M4643', 'Discitis, unspecified, cervicothoracic region'),
    ('M4644', 'Discitis, unspecified, thoracic region'),
    ('M4645', 'Discitis, unspecified, thoracolumbar region'),
    ('M4646', 'Discitis, unspecified, lumbar region'),
    ('M4647', 'Discitis, unspecified, lumbosacral region'),
    ('M4648', 'Discitis, unspecified, sacral and sacrococcygeal region'),
    ('M4649', 'Discitis, unspecified, multiple sites in spine'),
    ('M4650', 'Other infective spondylopathies, site unspecified'),
    ('M4651', 'Oth infective spondylopathies, occipito-atlanto-axial region'),
    ('M4652', 'Other infective spondylopathies, cervical region'),
    ('M4653', 'Other infective spondylopathies, cervicothoracic region'),
    ('M4654', 'Other infective spondylopathies, thoracic region'),
    ('M4655', 'Other infective spondylopathies, thoracolumbar region'),
    ('M4656', 'Other infective spondylopathies, lumbar region'),
    ('M4657', 'Other infective spondylopathies, lumbosacral region'),
    ('M4658', 'Oth infective spondylopathies, sacr/sacrocygl region'),
    ('M4659', 'Other infective spondylopathies, multiple sites in spine'),
    ('M4680', 'Oth inflammatory spondylopathies, site unspecified'),
    ('M4681', 'Oth inflammatory spondylopathies, occipt-atlan-ax region'),
    ('M4682', 'Oth inflammatory spondylopathies, cervical region'),
    ('M4683', 'Oth inflammatory spondylopathies, cervicothoracic region'),
    ('M4684', 'Oth inflammatory spondylopathies, thoracic region'),
    ('M4685', 'Oth inflammatory spondylopathies, thoracolumbar region'),
    ('M4686', 'Other specified inflammatory spondylopathies, lumbar region'),
    ('M4687', 'Oth inflammatory spondylopathies, lumbosacral region'),
    ('M4688', 'Oth inflammatory spondylopathies, sacr/sacrocygl region'),
    ('M4689', 'Oth inflammatory spondylopathies, multiple sites in spine'),
    ('M4690', 'Unspecified inflammatory spondylopathy, site unspecified'),
    ('M4691', 'Unsp inflammatory spondylopathy, occipt-atlan-ax region'),
    ('M4692', 'Unspecified inflammatory spondylopathy, cervical region'),
    ('M4693', 'Unsp inflammatory spondylopathy, cervicothoracic region'),
    ('M4694', 'Unspecified inflammatory spondylopathy, thoracic region'),
    ('M4695', 'Unspecified inflammatory spondylopathy, thoracolumbar region'),
    ('M4696', 'Unspecified inflammatory spondylopathy, lumbar region'),
    ('M4697', 'Unspecified inflammatory spondylopathy, lumbosacral region'),
    ('M4698', 'Unsp inflammatory spondylopathy, sacr/sacrocygl region'),
    ('M4699', 'Unsp inflammatory spondylopathy, multiple sites in spine'),
    ('M47011', 'Anterior spinal artery comprsn synd, occipt-atlan-ax region'),
    ('M47012', 'Anterior spinal artery comprsn syndromes, cervical region'),
    ('M47013', 'Anterior spinal artery comprsn syndromes, cervicothor region'),
    ('M47014', 'Anterior spinal artery comprsn syndromes, thoracic region'),
    ('M47015', 'Anterior spinal artery comprsn syndromes, thoracolum region'),
    ('M47016', 'Anterior spinal artery compression syndromes, lumbar region'),
    ('M47019', 'Anterior spinal artery compression syndromes, site unsp'),
    ('M47021', 'Verteb art compression syndromes, occipt-atlan-ax region'),
    ('M47022', 'Vertebral artery compression syndromes, cervical region'),
    ('M47029', 'Vertebral artery compression syndromes, site unspecified'),
    ('M4710', 'Other spondylosis with myelopathy, site unspecified'),
    ('M4711', 'Oth spondylosis w myelopathy, occipito-atlanto-axial region'),
    ('M4712', 'Other spondylosis with myelopathy, cervical region'),
    ('M4713', 'Other spondylosis with myelopathy, cervicothoracic region'),
    ('M4714', 'Other spondylosis with myelopathy, thoracic region'),
    ('M4715', 'Other spondylosis with myelopathy, thoracolumbar region'),
    ('M4716', 'Other spondylosis with myelopathy, lumbar region'),
    ('M4717', 'Other spondylosis with myelopathy, lumbosacral region'),
    ('M4718', 'Oth spondylosis w myelopathy, sacr/sacrocygl region'),
    ('M4720', 'Other spondylosis with radiculopathy, site unspecified'),
    ('M4721', 'Oth spondylosis w radiculopathy, occipt-atlan-ax region'),
    ('M4722', 'Other spondylosis with radiculopathy, cervical region'),
    ('M4723', 'Other spondylosis with radiculopathy, cervicothoracic region'),
    ('M4724', 'Other spondylosis with radiculopathy, thoracic region'),
    ('M4725', 'Other spondylosis with radiculopathy, thoracolumbar region'),
    ('M4726', 'Other spondylosis with radiculopathy, lumbar region'),
    ('M4727', 'Other spondylosis with radiculopathy, lumbosacral region'),
    ('M4728', 'Oth spondylosis w radiculopathy, sacr/sacrocygl region'),
    ('M47811', 'Spondyls w/o myelpath or radiculopathy, occipt-atlan-ax rgn'),
    ('M47812', 'Spondylosis w/o myelopathy or radiculopathy, cervical region'),
    ('M47813', 'Spondyls w/o myelopathy or radiculopathy, cervicothor region'),
    ('M47814', 'Spondylosis w/o myelopathy or radiculopathy, thoracic region'),
    ('M47815', 'Spondyls w/o myelopathy or radiculopathy, thoracolum region'),
    ('M47816', 'Spondylosis w/o myelopathy or radiculopathy, lumbar region'),
    ('M47817', 'Spondyls w/o myelopathy or radiculopathy, lumbosacr region'),
    ('M47818', 'Spondyls w/o myelpath or radiculopathy, sacr/sacrocygl rgn'),
    ('M47819', 'Spondylosis without myelopathy or radiculopathy, site unsp'),
    ('M47891', 'Other spondylosis, occipito-atlanto-axial region'),
    ('M47892', 'Other spondylosis, cervical region'),
    ('M47893', 'Other spondylosis, cervicothoracic region'),
    ('M47894', 'Other spondylosis, thoracic region'),
    ('M47895', 'Other spondylosis, thoracolumbar region'),
    ('M47896', 'Other spondylosis, lumbar region'),
    ('M47897', 'Other spondylosis, lumbosacral region'),
    ('M47898', 'Other spondylosis, sacral and sacrococcygeal region'),
    ('M47899', 'Other spondylosis, site unspecified'),
    ('M479', 'Spondylosis, unspecified'),
    ('M4800', 'Spinal stenosis, site unspecified'),
    ('M4801', 'Spinal stenosis, occipito-atlanto-axial region'),
    ('M4802', 'Spinal stenosis, cervical region'),
    ('M4803', 'Spinal stenosis, cervicothoracic region'),
    ('M4804', 'Spinal stenosis, thoracic region'),
    ('M4805', 'Spinal stenosis, thoracolumbar region'),
    ('M4806', 'Spinal stenosis, lumbar region'),
    ('M48061', 'Spinal stenosis, lumbar region without neurogenic claudication'),
    ('M48062', 'Spinal stenosis, lumbar region with neurogenic claudication'),
    ('M4807', 'Spinal stenosis, lumbosacral region'),
    ('M4808', 'Spinal stenosis, sacral and sacrococcygeal region'),
    ('M4810', 'Ankylosing hyperostosis [Forestier], site unspecified'),
    ('M4811', 'Ankylosing hyperostosis, occipito-atlanto-axial region'),
    ('M4812', 'Ankylosing hyperostosis [Forestier], cervical region'),
    ('M4813', 'Ankylosing hyperostosis [Forestier], cervicothoracic region'),
    ('M4814', 'Ankylosing hyperostosis [Forestier], thoracic region'),
    ('M4815', 'Ankylosing hyperostosis [Forestier], thoracolumbar region'),
    ('M4816', 'Ankylosing hyperostosis [Forestier], lumbar region'),
    ('M4817', 'Ankylosing hyperostosis [Forestier], lumbosacral region'),
    ('M4818', 'Ankylosing hyperostosis, sacral and sacrococcygeal region'),
    ('M4819', 'Ankylosing hyperostosis [Forestier], multiple sites in spine'),
    ('M4820', 'Kissing spine, site unspecified'),
    ('M4821', 'Kissing spine, occipito-atlanto-axial region'),
    ('M4822', 'Kissing spine, cervical region'),
    ('M4823', 'Kissing spine, cervicothoracic region'),
    ('M4824', 'Kissing spine, thoracic region'),
    ('M4825', 'Kissing spine, thoracolumbar region'),
    ('M4826', 'Kissing spine, lumbar region'),
    ('M4827', 'Kissing spine, lumbosacral region'),
    ('M4830', 'Traumatic spondylopathy, site unspecified'),
    ('M4831', 'Traumatic spondylopathy, occipito-atlanto-axial region'),
    ('M4832', 'Traumatic spondylopathy, cervical region'),
    ('M4833', 'Traumatic spondylopathy, cervicothoracic region'),
    ('M4834', 'Traumatic spondylopathy, thoracic region'),
    ('M4835', 'Traumatic spondylopathy, thoracolumbar region'),
    ('M4836', 'Traumatic spondylopathy, lumbar region'),
    ('M4837', 'Traumatic spondylopathy, lumbosacral region'),
    ('M4838', 'Traumatic spondylopathy, sacral and sacrococcygeal region'),
    ('M4840XA', 'Fatigue fracture of vertebra, site unsp, init for fx'),
    ('M4840XD', 'Fatigue fx vertebra, site unsp, subs for fx w routn heal'),
    ('M4840XG', 'Fatigue fx vertebra, site unsp, subs for fx w delay heal'),
    ('M4840XS', 'Fatigue fracture of vertebra, site unsp, sequela of fracture'),
    ('M4841XA', 'Fatigue fracture of vertebra, occipt-atlan-ax region, init'),
    ('M4841XD', 'Fatigue fx vert, occipt-atlan-ax rgn, 7thD'),
    ('M4841XG', 'Fatigue fx vert, occipt-atlan-ax rgn, 7thG'),
    ('M4841XS', 'Fatigue fracture of vertebra, occipt-atlan-ax region, sqla'),
    ('M4842XA', 'Fatigue fracture of vertebra, cervical region, init for fx'),
    ('M4842XD', 'Fatigue fx vertebra, cerv region, subs for fx w routn heal'),
    ('M4842XG', 'Fatigue fx vertebra, cerv region, subs for fx w delay heal'),
    ('M4842XS', 'Fatigue fracture of vertebra, cervical region, sqla'),
    ('M4843XA', 'Fatigue fracture of vertebra, cervicothoracic region, init'),
    ('M4843XD', 'Fatigue fx vert, cervicothor rgn, subs for fx w routn heal'),
    ('M4843XG', 'Fatigue fx vert, cervicothor rgn, subs for fx w delay heal'),
    ('M4843XS', 'Fatigue fracture of vertebra, cervicothoracic region, sqla'),
    ('M4844XA', 'Fatigue fracture of vertebra, thoracic region, init for fx'),
    ('M4844XD', 'Fatigue fx vertebra, thor region, subs for fx w routn heal'),
    ('M4844XG', 'Fatigue fx vertebra, thor region, subs for fx w delay heal'),
    ('M4844XS', 'Fatigue fracture of vertebra, thoracic region, sqla'),
    ('M4845XA', 'Fatigue fracture of vertebra, thoracolumbar region, init'),
    ('M4845XD', 'Fatigue fx vertebra, thrclm region, subs for fx w routn heal'),
    ('M4845XG', 'Fatigue fx vertebra, thrclm region, subs for fx w delay heal'),
    ('M4845XS', 'Fatigue fracture of vertebra, thoracolumbar region, sqla'),
    ('M4846XA', 'Fatigue fracture of vertebra, lumbar region, init for fx'),
    ('M4846XD', 'Fatigue fx vertebra, lumbar region, subs for fx w routn heal'),
    ('M4846XG', 'Fatigue fx vertebra, lumbar region, subs for fx w delay heal'),
    ('M4846XS', 'Fatigue fracture of vertebra, lumbar region, sqla'),
    ('M4847XA', 'Fatigue fracture of vertebra, lumbosacral region, init'),
    ('M4847XD', 'Fatigue fx vert, lumbosacr region, subs for fx w routn heal'),
    ('M4847XG', 'Fatigue fx vert, lumbosacr region, subs for fx w delay heal'),
    ('M4847XS', 'Fatigue fracture of vertebra, lumbosacral region, sqla'),
    ('M4848XA', 'Fatigue fracture of vertebra, sacr/sacrocygl region, init'),
    ('M4848XD', 'Fatigue fx vert, sacr/sacrocygl rgn, 7thD'),
    ('M4848XG', 'Fatigue fx vert, sacr/sacrocygl rgn, 7thG'),
    ('M4848XS', 'Fatigue fracture of vertebra, sacr/sacrocygl region, sqla'),
    ('M4850XA', 'Collapsed vertebra, NEC, site unsp, init'),
    ('M4850XD', 'Collapsed vertebra, NEC, site unsp, subs for fx w routn heal'),
    ('M4850XG', 'Collapsed vertebra, NEC, site unsp, subs for fx w delay heal'),
    ('M4850XS', 'Collapsed vertebra, NEC, site unsp, sequela of fracture'),
    ('M4851XA', 'Collapsed vertebra, NEC, occipito-atlanto-axial region, init'),
    ('M4851XD', 'Collapsed vert, NEC, occipt-atlan-ax rgn, 7thD'),
    ('M4851XG', 'Collapsed vert, NEC, occipt-atlan-ax rgn, 7thG'),
    ('M4851XS', 'Collapsed vertebra, NEC, occipt-atlan-ax region, sqla'),
    ('M4852XA', 'Collapsed vertebra, NEC, cervical region, init'),
    ('M4852XD', 'Collapsed vert, NEC, cerv region, subs for fx w routn heal'),
    ('M4852XG', 'Collapsed vert, NEC, cerv region, subs for fx w delay heal'),
    ('M4852XS', 'Collapsed vertebra, NEC, cervical region, sqla'),
    ('M4853XA', 'Collapsed vertebra, NEC, cervicothoracic region, init'),
    ('M4853XD', 'Collapsed vert, NEC, cervicothor rgn, 7thD'),
    ('M4853XG', 'Collapsed vert, NEC, cervicothor rgn, 7thG'),
    ('M4853XS', 'Collapsed vertebra, NEC, cervicothoracic region, sqla'),
    ('M4854XA', 'Collapsed vertebra, NEC, thoracic region, init'),
    ('M4854XD', 'Collapsed vert, NEC, thor region, subs for fx w routn heal'),
    ('M4854XG', 'Collapsed vert, NEC, thor region, subs for fx w delay heal'),
    ('M4854XS', 'Collapsed vertebra, NEC, thoracic region, sqla'),
    ('M4855XA', 'Collapsed vertebra, NEC, thoracolumbar region, init'),
    ('M4855XD', 'Collapsed vert, NEC, thrclm region, subs for fx w routn heal'),
    ('M4855XG', 'Collapsed vert, NEC, thrclm region, subs for fx w delay heal'),
    ('M4855XS', 'Collapsed vertebra, NEC, thoracolumbar region, sqla'),
    ('M4856XA', 'Collapsed vertebra, NEC, lumbar region, init'),
    ('M4856XD', 'Collapsed vert, NEC, lumbar region, subs for fx w routn heal'),
    ('M4856XG', 'Collapsed vert, NEC, lumbar region, subs for fx w delay heal'),
    ('M4856XS', 'Collapsed vertebra, NEC, lumbar region, sequela of fracture'),
    ('M4857XA', 'Collapsed vertebra, NEC, lumbosacral region, init'),
    ('M4857XD', 'Collapsed vert, NEC, lumbosacr rgn, subs for fx w routn heal'),
    ('M4857XG', 'Collapsed vert, NEC, lumbosacr rgn, subs for fx w delay heal'),
    ('M4857XS', 'Collapsed vertebra, NEC, lumbosacral region, sqla'),
    ('M4858XA', 'Collapsed vertebra, NEC, sacr/sacrocygl region, init'),
    ('M4858XD', 'Collapsed vert, NEC, sacr/sacrocygl rgn, 7thD'),
    ('M4858XG', 'Collapsed vert, NEC, sacr/sacrocygl rgn, 7thG'),
    ('M4858XS', 'Collapsed vertebra, NEC, sacr/sacrocygl region, sqla'),
    ('M488X1', 'Oth spondylopathies, occipito-atlanto-axial region'),
    ('M488X2', 'Other specified spondylopathies, cervical region'),
    ('M488X3', 'Other specified spondylopathies, cervicothoracic region'),
    ('M488X4', 'Other specified spondylopathies, thoracic region'),
    ('M488X5', 'Other specified spondylopathies, thoracolumbar region'),
    ('M488X6', 'Other specified spondylopathies, lumbar region'),
    ('M488X7', 'Other specified spondylopathies, lumbosacral region'),
    ('M488X8', 'Oth spondylopathies, sacral and sacrococcygeal region'),
    ('M488X9', 'Other specified spondylopathies, site unspecified'),
    ('M489', 'Spondylopathy, unspecified'),
    ('M4980', 'Spondylopathy in diseases classified elsewhere, site unsp'),
    ('M4981', 'Spond in diseases classd elswhr, occipt-atlan-ax region'),
    ('M4982', 'Spondylopathy in diseases classd elswhr, cervical region'),
    ('M4983', 'Spondylopathy in diseases classd elswhr, cervicothor region'),
    ('M4984', 'Spondylopathy in diseases classd elswhr, thoracic region'),
    ('M4985', 'Spond in diseases classd elswhr, thoracolumbar region'),
    ('M4986', 'Spondylopathy in diseases classd elswhr, lumbar region'),
    ('M4987', 'Spondylopathy in diseases classd elswhr, lumbosacral region'),
    ('M4988', 'Spond in diseases classd elswhr, sacr/sacrocygl region'),
    ('M4989', 'Spond in diseases classd elswhr, multiple sites in spine'),
    ('M5000', 'Cervical disc disorder with myelopathy, unsp cervical region'),
    ('M5001', 'Cervical disc disorder with myelopathy, high cervical region'),
    ('M5002', 'Cervical disc disorder with myelopathy, mid-cervical region'),
    ('M50020', 'Cerv disc disord with myelpath, mid-cervical rgn, unsp level'),
    ('M50021', 'Cervical disc disorder at C4-C5 level with myelopathy'),
    ('M50022', 'Cervical disc disorder at C5-C6 level with myelopathy'),
    ('M50023', 'Cervical disc disorder at C6-C7 level with myelopathy'),
    ('M5003', 'Cervical disc disorder w myelopathy, cervicothoracic region'),
    ('M5010', 'Cervical disc disorder w radiculopathy, unsp cervical region'),
    ('M5011', 'Cerv disc disorder with radiculopathy, high cervical region'),
    ('M5012', 'Cervical disc disorder w radiculopathy, mid-cervical region'),
    ('M50120', 'Mid-cervical disc disorder, unspecified level'),
    ('M50121', 'Cervical disc disorder at C4-C5 level with radiculopathy'),
    ('M50122', 'Cervical disc disorder at C5-C6 level with radiculopathy'),
    ('M50123', 'Cervical disc disorder at C6-C7 level with radiculopathy'),
    ('M5013', 'Cervical disc disorder w radiculopathy, cervicothor region'),
    ('M5020', 'Other cervical disc displacement, unsp cervical region'),
    ('M5021', 'Other cervical disc displacement, high cervical region'),
    ('M5022', 'Other cervical disc displacement, mid-cervical region'),
    ('M50220', 'Other cerv disc displacmnt, mid-cervical region, unsp level'),
    ('M50221', 'Other cervical disc displacement at C4-C5 level'),
    ('M50222', 'Other cervical disc displacement at C5-C6 level'),
    ('M50223', 'Other cervical disc displacement at C6-C7 level'),
    ('M5023', 'Other cervical disc displacement, cervicothoracic region'),
    ('M5030', 'Other cervical disc degeneration, unsp cervical region'),
    ('M5031', 'Other cervical disc degeneration, high cervical region'),
    ('M5032', 'Other cervical disc degeneration, mid-cervical region'),
    ('M50320', 'Other cerv disc degeneration, mid-cervical rgn, unsp level'),
    ('M50321', 'Other cervical disc degeneration at C4-C5 level'),
    ('M50322', 'Other cervical disc degeneration at C5-C6 level'),
    ('M50323', 'Other cervical disc degeneration at C6-C7 level'),
    ('M5033', 'Other cervical disc degeneration, cervicothoracic region'),
    ('M5080', 'Other cervical disc disorders, unspecified cervical region'),
    ('M5081', 'Other cervical disc disorders, high cervical region'),
    ('M5082', 'Other cervical disc disorders, mid-cervical region'),
    ('M50820', 'Other cervical disc disord, mid-cervical region, unsp level'),
    ('M50821', 'Other cervical disc disorders at C4-C5 level'),
    ('M50822', 'Other cervical disc disorders at C5-C6 level'),
    ('M50823', 'Other cervical disc disorders at C6-C7 level'),
    ('M5083', 'Other cervical disc disorders, cervicothoracic region'),
    ('M5090', 'Cervical disc disorder, unsp, unspecified cervical region'),
    ('M5091', 'Cervical disc disorder, unspecified, high cervical region'),
    ('M5092', 'Cervical disc disorder, unspecified, mid-cervical region'),
    ('M50920', 'Unsp cervical disc disorder, mid-cervical region, unsp level'),
    ('M50921', 'Unspecified cervical disc disorder at C4-C5 level'),
    ('M50922', 'Unspecified cervical disc disorder at C5-C6 level'),
    ('M50923', 'Unspecified cervical disc disorder at C6-C7 level'),
    ('M5093', 'Cervical disc disorder, unspecified, cervicothoracic region'),
    ('M5104', 'Intervertebral disc disorders w myelopathy, thoracic region'),
    ('M5105', 'Intvrt disc disorders w myelopathy, thoracolumbar region'),
    ('M5106', 'Intervertebral disc disorders with myelopathy, lumbar region'),
    ('M5107', 'Intvrt disc disorders w myelopathy, lumbosacral region'),
    ('M5114', 'Intvrt disc disorders w radiculopathy, thoracic region'),
    ('M5115', 'Intvrt disc disorders w radiculopathy, thoracolumbar region'),
    ('M5116', 'Intervertebral disc disorders w radiculopathy, lumbar region'),
    ('M5117', 'Intvrt disc disorders w radiculopathy, lumbosacral region'),
    ('M5124', 'Other intervertebral disc displacement, thoracic region'),
    ('M5125', 'Other intervertebral disc displacement, thoracolumbar region'),
    ('M5126', 'Other intervertebral disc displacement, lumbar region'),
    ('M5127', 'Other intervertebral disc displacement, lumbosacral region'),
    ('M5134', 'Other intervertebral disc degeneration, thoracic region'),
    ('M5135', 'Other intervertebral disc degeneration, thoracolumbar region'),
    ('M5136', 'Other intervertebral disc degeneration, lumbar region'),
    ('M5137', 'Other intervertebral disc degeneration, lumbosacral region'),
    ('M5144', "Schmorl's nodes, thoracic region"),
    ('M5145', "Schmorl's nodes, thoracolumbar region"),
    ('M5146', "Schmorl's nodes, lumbar region"),
    ('M5147', "Schmorl's nodes, lumbosacral region"),
    ('M5184', 'Other intervertebral disc disorders, thoracic region'),
    ('M5185', 'Other intervertebral disc disorders, thoracolumbar region'),
    ('M5186', 'Other intervertebral disc disorders, lumbar region'),
    ('M5187', 'Other intervertebral disc disorders, lumbosacral region'),
    ('M519', 'Unsp thoracic, thoracolum and lumbosacr intvrt disc disorder'),
    ('M51A0', 'Intvrt annulus fibrosus defect, lumbar region, unsp size'),
    ('M51A1', 'Intervertebral annulus fibrosus defect, small, lumbar region'),
    ('M51A2', 'Intervertebral annulus fibrosus defect, large, lumbar region'),
    ('M51A3', 'Intvrt annulus fibrosus defect, lumbosacr region, unsp size'),
    ('M51A4', 'Intvrt annulus fibrosus defect, small, lumbosacral region'),
    ('M51A5', 'Intvrt annulus fibrosus defect, large, lumbosacral region'),
    ('M530', 'Cervicocranial syndrome'),
    ('M531', 'Cervicobrachial syndrome'),
    ('M532X1', 'Spinal instabilities, occipito-atlanto-axial region'),
    ('M532X2', 'Spinal instabilities, cervical region'),
    ('M532X3', 'Spinal instabilities, cervicothoracic region'),
    ('M532X4', 'Spinal instabilities, thoracic region'),
    ('M532X5', 'Spinal instabilities, thoracolumbar region'),
    ('M532X6', 'Spinal instabilities, lumbar region'),
    ('M532X7', 'Spinal instabilities, lumbosacral region'),
    ('M532X8', 'Spinal instabilities, sacral and sacrococcygeal region'),
    ('M532X9', 'Spinal instabilities, site unspecified'),
    ('M533', 'Sacrococcygeal disorders, not elsewhere classified'),
    ('M5380', 'Other specified dorsopathies, site unspecified'),
    ('M5381', 'Other specified dorsopathies, occipito-atlanto-axial region'),
    ('M5382', 'Other specified dorsopathies, cervical region'),
    ('M5383', 'Other specified dorsopathies, cervicothoracic region'),
    ('M5384', 'Other specified dorsopathies, thoracic region'),
    ('M5385', 'Other specified dorsopathies, thoracolumbar region'),
    ('M5386', 'Other specified dorsopathies, lumbar region'),
    ('M5387', 'Other specified dorsopathies, lumbosacral region'),
    ('M5388', 'Oth dorsopathies, sacral and sacrococcygeal region'),
    ('M539', 'Dorsopathy, unspecified'),
    ('M5400', 'Panniculitis affecting regions of neck and back, site unsp'),
    ('M5401', 'Panniculitis aff regions of neck/bk, occipt-atlan-ax region'),
    ('M5402', 'Panniculitis affecting regions of neck/bk, cervical region'),
    ('M5403', 'Panniculitis aff regions of neck/bk, cervicothor region'),
    ('M5404', 'Panniculitis affecting regions of neck/bk, thoracic region'),
    ('M5405', 'Panniculitis affecting regions of neck/bk, thoracolum region'),
    ('M5406', 'Panniculitis affecting regions of neck/bk, lumbar region'),
    ('M5407', 'Panniculitis affecting regions of neck/bk, lumbosacr region'),
    ('M5408', 'Panniculitis aff regions of neck/bk, sacr/sacrocygl region'),
    ('M5409', 'Panniculitis aff regions, neck/bk, multiple sites in spine'),
    ('M5410', 'Radiculopathy, site unspecified'),
    ('M5411', 'Radiculopathy, occipito-atlanto-axial region'),
    ('M5412', 'Radiculopathy, cervical region'),
    ('M5413', 'Radiculopathy, cervicothoracic region'),
    ('M5414', 'Radiculopathy, thoracic region'),
    ('M5415', 'Radiculopathy, thoracolumbar region'),
    ('M5416', 'Radiculopathy, lumbar region'),
    ('M5417', 'Radiculopathy, lumbosacral region'),
    ('M5418', 'Radiculopathy, sacral and sacrococcygeal region'),
    ('M542', 'Cervicalgia'),
    ('M5430', 'Sciatica, unspecified side'),
    ('M5431', 'Sciatica, right side'),
    ('M5432', 'Sciatica, left side'),
    ('M5440', 'Lumbago with sciatica, unspecified side'),
    ('M5441', 'Lumbago with sciatica, right side'),
    ('M5442', 'Lumbago with sciatica, left side'),
    ('M545', 'Low back pain'),
    ('M5450', 'Low back pain, unspecified '),
    ('M5451', 'Vertebrogenic low back pain'),
    ('M5459', 'Other low back pain'),
    ('M546', 'Pain in thoracic spine'),
    ('M5481', 'Occipital neuralgia'),
    ('M5489', 'Other dorsalgia'),
    ('M549', 'Dorsalgia, unspecified'),
    ('M60000', 'Infective myositis, unspecified right arm'),
    ('M60001', 'Infective myositis, unspecified left arm'),
    ('M60002', 'Infective myositis, unspecified arm'),
    ('M60003', 'Infective myositis, unspecified right leg'),
    ('M60004', 'Infective myositis, unspecified left leg'),
    ('M60005', 'Infective myositis, unspecified leg'),
    ('M60009', 'Infective myositis, unspecified site'),
    ('M60011', 'Infective myositis, right shoulder'),
    ('M60012', 'Infective myositis, left shoulder'),
    ('M60019', 'Infective myositis, unspecified shoulder'),
    ('M60021', 'Infective myositis, right upper arm'),
    ('M60022', 'Infective myositis, left upper arm'),
    ('M60029', 'Infective myositis, unspecified upper arm'),
    ('M60031', 'Infective myositis, right forearm'),
    ('M60032', 'Infective myositis, left forearm'),
    ('M60039', 'Infective myositis, unspecified forearm'),
    ('M60041', 'Infective myositis, right hand'),
    ('M60042', 'Infective myositis, left hand'),
    ('M60043', 'Infective myositis, unspecified hand'),
    ('M60044', 'Infective myositis, right finger(s)'),
    ('M60045', 'Infective myositis, left finger(s)'),
    ('M60046', 'Infective myositis, unspecified finger(s)'),
    ('M60051', 'Infective myositis, right thigh'),
    ('M60052', 'Infective myositis, left thigh'),
    ('M60059', 'Infective myositis, unspecified thigh'),
    ('M60061', 'Infective myositis, right lower leg'),
    ('M60062', 'Infective myositis, left lower leg'),
    ('M60069', 'Infective myositis, unspecified lower leg'),
    ('M60070', 'Infective myositis, right ankle'),
    ('M60071', 'Infective myositis, left ankle'),
    ('M60072', 'Infective myositis, unspecified ankle'),
    ('M60073', 'Infective myositis, right foot'),
    ('M60074', 'Infective myositis, left foot'),
    ('M60075', 'Infective myositis, unspecified foot'),
    ('M60076', 'Infective myositis, right toe(s)'),
    ('M60077', 'Infective myositis, left toe(s)'),
    ('M60078', 'Infective myositis, unspecified toe(s)'),
    ('M6008', 'Infective myositis, other site'),
    ('M6009', 'Infective myositis, multiple sites'),
    ('M6010', 'Interstitial myositis of unspecified site'),
    ('M60111', 'Interstitial myositis, right shoulder'),
    ('M60112', 'Interstitial myositis, left shoulder'),
    ('M60119', 'Interstitial myositis, unspecified shoulder'),
    ('M60121', 'Interstitial myositis, right upper arm'),
    ('M60122', 'Interstitial myositis, left upper arm'),
    ('M60129', 'Interstitial myositis, unspecified upper arm'),
    ('M60131', 'Interstitial myositis, right forearm'),
    ('M60132', 'Interstitial myositis, left forearm'),
    ('M60139', 'Interstitial myositis, unspecified forearm'),
    ('M60141', 'Interstitial myositis, right hand'),
    ('M60142', 'Interstitial myositis, left hand'),
    ('M60149', 'Interstitial myositis, unspecified hand'),
    ('M60151', 'Interstitial myositis, right thigh'),
    ('M60152', 'Interstitial myositis, left thigh'),
    ('M60159', 'Interstitial myositis, unspecified thigh'),
    ('M60161', 'Interstitial myositis, right lower leg'),
    ('M60162', 'Interstitial myositis, left lower leg'),
    ('M60169', 'Interstitial myositis, unspecified lower leg'),
    ('M60171', 'Interstitial myositis, right ankle and foot'),
    ('M60172', 'Interstitial myositis, left ankle and foot'),
    ('M60179', 'Interstitial myositis, unspecified ankle and foot'),
    ('M6018', 'Interstitial myositis, other site'),
    ('M6019', 'Interstitial myositis, multiple sites'),
    ('M6020', 'Foreign body granuloma of soft tissue, NEC, unsp site'),
    ('M60211', 'Foreign body granuloma of soft tissue, NEC, right shoulder'),
    ('M60212', 'Foreign body granuloma of soft tissue, NEC, left shoulder'),
    ('M60219', 'Foreign body granuloma of soft tissue, NEC, unsp shoulder'),
    ('M60221', 'Foreign body granuloma of soft tissue, NEC, right upper arm'),
    ('M60222', 'Foreign body granuloma of soft tissue, NEC, left upper arm'),
    ('M60229', 'Foreign body granuloma of soft tissue, NEC, unsp upper arm'),
    ('M60231', 'Foreign body granuloma of soft tissue, NEC, right forearm'),
    ('M60232', 'Foreign body granuloma of soft tissue, NEC, left forearm'),
    ('M60239', 'Foreign body granuloma of soft tissue, NEC, unsp forearm'),
    ('M60241', 'Foreign body granuloma of soft tissue, NEC, right hand'),
    ('M60242', 'Foreign body granuloma of soft tissue, NEC, left hand'),
    ('M60249', 'Foreign body granuloma of soft tissue, NEC, unsp hand'),
    ('M60251', 'Foreign body granuloma of soft tissue, NEC, right thigh'),
    ('M60252', 'Foreign body granuloma of soft tissue, NEC, left thigh'),
    ('M60259', 'Foreign body granuloma of soft tissue, NEC, unsp thigh'),
    ('M60261', 'Foreign body granuloma of soft tissue, NEC, right lower leg'),
    ('M60262', 'Foreign body granuloma of soft tissue, NEC, left lower leg'),
    ('M60269', 'Foreign body granuloma of soft tissue, NEC, unsp lower leg'),
    ('M60271', 'Foreign body granuloma of soft tissue, NEC, right ank/ft'),
    ('M60272', 'Foreign body granuloma of soft tissue, NEC, left ank/ft'),
    ('M60279', 'Foreign body granuloma of soft tissue, NEC, unsp ank/ft'),
    ('M6028', 'Foreign body granuloma of soft tissue, NEC, oth site'),
    ('M6080', 'Other myositis, unspecified site'),
    ('M60811', 'Other myositis, right shoulder'),
    ('M60812', 'Other myositis, left shoulder'),
    ('M60819', 'Other myositis, unspecified shoulder'),
    ('M60821', 'Other myositis, right upper arm'),
    ('M60822', 'Other myositis, left upper arm'),
    ('M60829', 'Other myositis, unspecified upper arm'),
    ('M60831', 'Other myositis, right forearm'),
    ('M60832', 'Other myositis, left forearm'),
    ('M60839', 'Other myositis, unspecified forearm'),
    ('M60841', 'Other myositis, right hand'),
    ('M60842', 'Other myositis, left hand'),
    ('M60849', 'Other myositis, unspecified hand'),
    ('M60851', 'Other myositis, right thigh'),
    ('M60852', 'Other myositis, left thigh'),
    ('M60859', 'Other myositis, unspecified thigh'),
    ('M60861', 'Other myositis, right lower leg'),
    ('M60862', 'Other myositis, left lower leg'),
    ('M60869', 'Other myositis, unspecified lower leg'),
    ('M60871', 'Other myositis, right ankle and foot'),
    ('M60872', 'Other myositis, left ankle and foot'),
    ('M60879', 'Other myositis, unspecified ankle and foot'),
    ('M6088', 'Other myositis, other site'),
    ('M6089', 'Other myositis, multiple sites'),
    ('M609', 'Myositis, unspecified'),
    ('M6100', 'Myositis ossificans traumatica, unspecified site'),
    ('M61011', 'Myositis ossificans traumatica, right shoulder'),
    ('M61012', 'Myositis ossificans traumatica, left shoulder'),
    ('M61019', 'Myositis ossificans traumatica, unspecified shoulder'),
    ('M61021', 'Myositis ossificans traumatica, right upper arm'),
    ('M61022', 'Myositis ossificans traumatica, left upper arm'),
    ('M61029', 'Myositis ossificans traumatica, unspecified upper arm'),
    ('M61031', 'Myositis ossificans traumatica, right forearm'),
    ('M61032', 'Myositis ossificans traumatica, left forearm'),
    ('M61039', 'Myositis ossificans traumatica, unspecified forearm'),
    ('M61041', 'Myositis ossificans traumatica, right hand'),
    ('M61042', 'Myositis ossificans traumatica, left hand'),
    ('M61049', 'Myositis ossificans traumatica, unspecified hand'),
    ('M61051', 'Myositis ossificans traumatica, right thigh'),
    ('M61052', 'Myositis ossificans traumatica, left thigh'),
    ('M61059', 'Myositis ossificans traumatica, unspecified thigh'),
    ('M61061', 'Myositis ossificans traumatica, right lower leg'),
    ('M61062', 'Myositis ossificans traumatica, left lower leg'),
    ('M61069', 'Myositis ossificans traumatica, unspecified lower leg'),
    ('M61071', 'Myositis ossificans traumatica, right ankle and foot'),
    ('M61072', 'Myositis ossificans traumatica, left ankle and foot'),
    ('M61079', 'Myositis ossificans traumatica, unspecified ankle and foot'),
    ('M6108', 'Myositis ossificans traumatica, other site'),
    ('M6109', 'Myositis ossificans traumatica, multiple sites'),
    ('M6110', 'Myositis ossificans progressiva, unspecified site'),
    ('M61111', 'Myositis ossificans progressiva, right shoulder'),
    ('M61112', 'Myositis ossificans progressiva, left shoulder'),
    ('M61119', 'Myositis ossificans progressiva, unspecified shoulder'),
    ('M61121', 'Myositis ossificans progressiva, right upper arm'),
    ('M61122', 'Myositis ossificans progressiva, left upper arm'),
    ('M61129', 'Myositis ossificans progressiva, unspecified arm'),
    ('M61131', 'Myositis ossificans progressiva, right forearm'),
    ('M61132', 'Myositis ossificans progressiva, left forearm'),
    ('M61139', 'Myositis ossificans progressiva, unspecified forearm'),
    ('M61141', 'Myositis ossificans progressiva, right hand'),
    ('M61142', 'Myositis ossificans progressiva, left hand'),
    ('M61143', 'Myositis ossificans progressiva, unspecified hand'),
    ('M61144', 'Myositis ossificans progressiva, right finger(s)'),
    ('M61145', 'Myositis ossificans progressiva, left finger(s)'),
    ('M61146', 'Myositis ossificans progressiva, unspecified finger(s)'),
    ('M61151', 'Myositis ossificans progressiva, right thigh'),
    ('M61152', 'Myositis ossificans progressiva, left thigh'),
    ('M61159', 'Myositis ossificans progressiva, unspecified thigh'),
    ('M61161', 'Myositis ossificans progressiva, right lower leg'),
    ('M61162', 'Myositis ossificans progressiva, left lower leg'),
    ('M61169', 'Myositis ossificans progressiva, unspecified lower leg'),
    ('M61171', 'Myositis ossificans progressiva, right ankle'),
    ('M61172', 'Myositis ossificans progressiva, left ankle'),
    ('M61173', 'Myositis ossificans progressiva, unspecified ankle'),
    ('M61174', 'Myositis ossificans progressiva, right foot'),
    ('M61175', 'Myositis ossificans progressiva, left foot'),
    ('M61176', 'Myositis ossificans progressiva, unspecified foot'),
    ('M61177', 'Myositis ossificans progressiva, right toe(s)'),
    ('M61178', 'Myositis ossificans progressiva, left toe(s)'),
    ('M61179', 'Myositis ossificans progressiva, unspecified toe(s)'),
    ('M6118', 'Myositis ossificans progressiva, other site'),
    ('M6119', 'Myositis ossificans progressiva, multiple sites'),
    ('M6120', 'Paralytic calcifcn and ossification of muscle, unsp site'),
    ('M61211', 'Paralytic calcifcn and ossification of muscle, r shoulder'),
    ('M61212', 'Paralytic calcifcn and ossification of muscle, left shoulder'),
    ('M61219', 'Paralytic calcifcn and ossification of muscle, unsp shoulder'),
    ('M61221', 'Paralytic calcification and ossification of muscle, r up arm'),
    ('M61222', 'Paralytic calcification and ossification of muscle, l up arm'),
    ('M61229', 'Paralytic calcifcn and ossifictn of muscle, unsp upper arm'),
    ('M61231', 'Paralytic calcifcn and ossification of muscle, right forearm'),
    ('M61232', 'Paralytic calcifcn and ossification of muscle, left forearm'),
    ('M61239', 'Paralytic calcifcn and ossification of muscle, unsp forearm'),
    ('M61241', 'Paralytic calcifcn and ossification of muscle, right hand'),
    ('M61242', 'Paralytic calcifcn and ossification of muscle, left hand'),
    ('M61249', 'Paralytic calcifcn and ossification of muscle, unsp hand'),
    ('M61251', 'Paralytic calcifcn and ossification of muscle, right thigh'),
    ('M61252', 'Paralytic calcifcn and ossification of muscle, left thigh'),
    ('M61259', 'Paralytic calcifcn and ossification of muscle, unsp thigh'),
    ('M61261', 'Paralytic calcifcn and ossification of muscle, r low leg'),
    ('M61262', 'Paralytic calcifcn and ossification of muscle, l low leg'),
    ('M61269', 'Paralytic calcifcn and ossifictn of muscle, unsp lower leg'),
    ('M61271', 'Paralytic calcifcn and ossification of muscle, right ank/ft'),
    ('M61272', 'Paralytic calcifcn and ossification of muscle, left ank/ft'),
    ('M61279', 'Paralytic calcifcn and ossification of muscle, unsp ank/ft'),
    ('M6128', 'Paralytic calcification and ossification of muscle, oth site'),
    ('M6129', 'Paralytic calcifcn and ossifictn of muscle, multiple sites'),
    ('M6130', 'Calcifcn and ossifictn of muscles assoc w burns, unsp site'),
    ('M61311', 'Calcifcn and ossifictn of muscles assoc w burns, r shoulder'),
    ('M61312', 'Calcifcn and ossifictn of muscles assoc w burns, l shoulder'),
    ('M61319', 'Calcifcn and ossifictn of muscles assoc w burns, unsp shldr'),
    ('M61321', 'Calcifcn and ossifictn of muscles assoc w burns, r up arm'),
    ('M61322', 'Calcifcn and ossifictn of muscles assoc w burns, l up arm'),
    ('M61329', 'Calcifcn and ossifictn of muscles assoc w burns, unsp up arm'),
    ('M61331', 'Calcifcn and ossifictn of muscles assoc w burns, r forearm'),
    ('M61332', 'Calcifcn and ossifictn of muscles assoc w burns, l forearm'),
    ('M61339', 'Calcifcn and ossifictn of musc assoc w burns, unsp forearm'),
    ('M61341', 'Calcifcn and ossifictn of muscles assoc w burns, right hand'),
    ('M61342', 'Calcifcn and ossifictn of muscles assoc w burns, left hand'),
    ('M61349', 'Calcifcn and ossifictn of muscles assoc w burns, unsp hand'),
    ('M61351', 'Calcifcn and ossifictn of muscles assoc w burns, right thigh'),
    ('M61352', 'Calcifcn and ossifictn of muscles assoc w burns, left thigh'),
    ('M61359', 'Calcifcn and ossifictn of muscles assoc w burns, unsp thigh'),
    ('M61361', 'Calcifcn and ossifictn of muscles assoc w burns, r low leg'),
    ('M61362', 'Calcifcn and ossifictn of muscles assoc w burns, l low leg'),
    ('M61369', 'Calcifcn and ossifictn of musc assoc w burns, unsp low leg'),
    ('M61371', 'Calcifcn and ossifictn of musc assoc w burns, right ank/ft'),
    ('M61372', 'Calcifcn and ossifictn of muscles assoc w burns, left ank/ft'),
    ('M61379', 'Calcifcn and ossifictn of muscles assoc w burns, unsp ank/ft'),
    ('M6138', 'Calcifcn and ossifictn of muscles assoc w burns, oth site'),
    ('M6139', 'Calcifcn and ossifictn of muscles assoc w burns, mult sites'),
    ('M6140', 'Other calcification of muscle, unspecified site'),
    ('M61411', 'Other calcification of muscle, right shoulder'),
    ('M61412', 'Other calcification of muscle, left shoulder'),
    ('M61419', 'Other calcification of muscle, unspecified shoulder'),
    ('M61421', 'Other calcification of muscle, right upper arm'),
    ('M61422', 'Other calcification of muscle, left upper arm'),
    ('M61429', 'Other calcification of muscle, unspecified upper arm'),
    ('M61431', 'Other calcification of muscle, right forearm'),
    ('M61432', 'Other calcification of muscle, left forearm'),
    ('M61439', 'Other calcification of muscle, unspecified forearm'),
    ('M61441', 'Other calcification of muscle, right hand'),
    ('M61442', 'Other calcification of muscle, left hand'),
    ('M61449', 'Other calcification of muscle, unspecified hand'),
    ('M61451', 'Other calcification of muscle, right thigh'),
    ('M61452', 'Other calcification of muscle, left thigh'),
    ('M61459', 'Other calcification of muscle, unspecified thigh'),
    ('M61461', 'Other calcification of muscle, right lower leg'),
    ('M61462', 'Other calcification of muscle, left lower leg'),
    ('M61469', 'Other calcification of muscle, unspecified lower leg'),
    ('M61471', 'Other calcification of muscle, right ankle and foot'),
    ('M61472', 'Other calcification of muscle, left ankle and foot'),
    ('M61479', 'Other calcification of muscle, unspecified ankle and foot'),
    ('M6148', 'Other calcification of muscle, other site'),
    ('M6149', 'Other calcification of muscle, multiple sites'),
    ('M6150', 'Other ossification of muscle, unspecified site'),
    ('M61511', 'Other ossification of muscle, right shoulder'),
    ('M61512', 'Other ossification of muscle, left shoulder'),
    ('M61519', 'Other ossification of muscle, unspecified shoulder'),
    ('M61521', 'Other ossification of muscle, right upper arm'),
    ('M61522', 'Other ossification of muscle, left upper arm'),
    ('M61529', 'Other ossification of muscle, unspecified upper arm'),
    ('M61531', 'Other ossification of muscle, right forearm'),
    ('M61532', 'Other ossification of muscle, left forearm'),
    ('M61539', 'Other ossification of muscle, unspecified forearm'),
    ('M61541', 'Other ossification of muscle, right hand'),
    ('M61542', 'Other ossification of muscle, left hand'),
    ('M61549', 'Other ossification of muscle, unspecified hand'),
    ('M61551', 'Other ossification of muscle, right thigh'),
    ('M61552', 'Other ossification of muscle, left thigh'),
    ('M61559', 'Other ossification of muscle, unspecified thigh'),
    ('M61561', 'Other ossification of muscle, right lower leg'),
    ('M61562', 'Other ossification of muscle, left lower leg'),
    ('M61569', 'Other ossification of muscle, unspecified lower leg'),
    ('M61571', 'Other ossification of muscle, right ankle and foot'),
    ('M61572', 'Other ossification of muscle, left ankle and foot'),
    ('M61579', 'Other ossification of muscle, unspecified ankle and foot'),
    ('M6158', 'Other ossification of muscle, other site'),
    ('M6159', 'Other ossification of muscle, multiple sites'),
    ('M619', 'Calcification and ossification of muscle, unspecified'),
    ('M6200', 'Separation of muscle (nontraumatic), unspecified site'),
    ('M62011', 'Separation of muscle (nontraumatic), right shoulder'),
    ('M62012', 'Separation of muscle (nontraumatic), left shoulder'),
    ('M62019', 'Separation of muscle (nontraumatic), unspecified shoulder'),
    ('M62021', 'Separation of muscle (nontraumatic), right upper arm'),
    ('M62022', 'Separation of muscle (nontraumatic), left upper arm'),
    ('M62029', 'Separation of muscle (nontraumatic), unspecified upper arm'),
    ('M62031', 'Separation of muscle (nontraumatic), right forearm'),
    ('M62032', 'Separation of muscle (nontraumatic), left forearm'),
    ('M62039', 'Separation of muscle (nontraumatic), unspecified forearm'),
    ('M62041', 'Separation of muscle (nontraumatic), right hand'),
    ('M62042', 'Separation of muscle (nontraumatic), left hand'),
    ('M62049', 'Separation of muscle (nontraumatic), unspecified hand'),
    ('M62051', 'Separation of muscle (nontraumatic), right thigh'),
    ('M62052', 'Separation of muscle (nontraumatic), left thigh'),
    ('M62059', 'Separation of muscle (nontraumatic), unspecified thigh'),
    ('M62061', 'Separation of muscle (nontraumatic), right lower leg'),
    ('M62062', 'Separation of muscle (nontraumatic), left lower leg'),
    ('M62069', 'Separation of muscle (nontraumatic), unspecified lower leg'),
    ('M62071', 'Separation of muscle (nontraumatic), right ankle and foot'),
    ('M62072', 'Separation of muscle (nontraumatic), left ankle and foot'),
    ('M62079', 'Separation of muscle (nontraumatic), unsp ankle and foot'),
    ('M6208', 'Separation of muscle (nontraumatic), other site'),
    ('M6210', 'Other rupture of muscle (nontraumatic), unspecified site'),
    ('M62111', 'Other rupture of muscle (nontraumatic), right shoulder'),
    ('M62112', 'Other rupture of muscle (nontraumatic), left shoulder'),
    ('M62119', 'Other rupture of muscle (nontraumatic), unspecified shoulder'),
    ('M62121', 'Other rupture of muscle (nontraumatic), right upper arm'),
    ('M62122', 'Other rupture of muscle (nontraumatic), left upper arm'),
    ('M62129', 'Other rupture of muscle (nontraumatic), unsp upper arm'),
    ('M62131', 'Other rupture of muscle (nontraumatic), right forearm'),
    ('M62132', 'Other rupture of muscle (nontraumatic), left forearm'),
    ('M62139', 'Other rupture of muscle (nontraumatic), unspecified forearm'),
    ('M62141', 'Other rupture of muscle (nontraumatic), right hand'),
    ('M62142', 'Other rupture of muscle (nontraumatic), left hand'),
    ('M62149', 'Other rupture of muscle (nontraumatic), unspecified hand'),
    ('M62151', 'Other rupture of muscle (nontraumatic), right thigh'),
    ('M62152', 'Other rupture of muscle (nontraumatic), left thigh'),
    ('M62159', 'Other rupture of muscle (nontraumatic), unspecified thigh'),
    ('M62161', 'Other rupture of muscle (nontraumatic), right lower leg'),
    ('M62162', 'Other rupture of muscle (nontraumatic), left lower leg'),
    ('M62169', 'Other rupture of muscle (nontraumatic), unsp lower leg'),
    ('M62171', 'Other rupture of muscle (nontraumatic), right ankle and foot'),
    ('M62172', 'Other rupture of muscle (nontraumatic), left ankle and foot'),
    ('M62179', 'Other rupture of muscle (nontraumatic), unsp ankle and foot'),
    ('M6218', 'Other rupture of muscle (nontraumatic), other site'),
    ('M6220', 'Nontraumatic ischemic infarction of muscle, unspecified site'),
    ('M62211', 'Nontraumatic ischemic infarction of muscle, right shoulder'),
    ('M62212', 'Nontraumatic ischemic infarction of muscle, left shoulder'),
    ('M62219', 'Nontraumatic ischemic infarction of muscle, unsp shoulder'),
    ('M62221', 'Nontraumatic ischemic infarction of muscle, right upper arm'),
    ('M62222', 'Nontraumatic ischemic infarction of muscle, left upper arm'),
    ('M62229', 'Nontraumatic ischemic infarction of muscle, unsp upper arm'),
    ('M62231', 'Nontraumatic ischemic infarction of muscle, right forearm'),
    ('M62232', 'Nontraumatic ischemic infarction of muscle, left forearm'),
    ('M62239', 'Nontraumatic ischemic infarction of muscle, unsp forearm'),
    ('M62241', 'Nontraumatic ischemic infarction of muscle, right hand'),
    ('M62242', 'Nontraumatic ischemic infarction of muscle, left hand'),
    ('M62249', 'Nontraumatic ischemic infarction of muscle, unspecified hand'),
    ('M62251', 'Nontraumatic ischemic infarction of muscle, right thigh'),
    ('M62252', 'Nontraumatic ischemic infarction of muscle, left thigh'),
    ('M62259', 'Nontraumatic ischemic infarction of muscle, unsp thigh'),
    ('M62261', 'Nontraumatic ischemic infarction of muscle, right lower leg'),
    ('M62262', 'Nontraumatic ischemic infarction of muscle, left lower leg'),
    ('M62269', 'Nontraumatic ischemic infarction of muscle, unsp lower leg'),
    ('M62271', 'Nontraumatic ischemic infarction of muscle, right ank/ft'),
    ('M62272', 'Nontraumatic ischemic infarction of muscle, left ank/ft'),
    ('M62279', 'Nontraumatic ischemic infarction of muscle, unsp ank/ft'),
    ('M6228', 'Nontraumatic ischemic infarction of muscle, other site'),
    ('M623', 'Immobility syndrome (paraplegic)'),
    ('M6240', 'Contracture of muscle, unspecified site'),
    ('M62411', 'Contracture of muscle, right shoulder'),
    ('M62412', 'Contracture of muscle, left shoulder'),
    ('M62419', 'Contracture of muscle, unspecified shoulder'),
    ('M62421', 'Contracture of muscle, right upper arm'),
    ('M62422', 'Contracture of muscle, left upper arm'),
    ('M62429', 'Contracture of muscle, unspecified upper arm'),
    ('M62431', 'Contracture of muscle, right forearm'),
    ('M62432', 'Contracture of muscle, left forearm'),
    ('M62439', 'Contracture of muscle, unspecified forearm'),
    ('M62441', 'Contracture of muscle, right hand'),
    ('M62442', 'Contracture of muscle, left hand'),
    ('M62449', 'Contracture of muscle, unspecified hand'),
    ('M62451', 'Contracture of muscle, right thigh'),
    ('M62452', 'Contracture of muscle, left thigh'),
    ('M62459', 'Contracture of muscle, unspecified thigh'),
    ('M62461', 'Contracture of muscle, right lower leg'),
    ('M62462', 'Contracture of muscle, left lower leg'),
    ('M62469', 'Contracture of muscle, unspecified lower leg'),
    ('M62471', 'Contracture of muscle, right ankle and foot'),
    ('M62472', 'Contracture of muscle, left ankle and foot'),
    ('M62479', 'Contracture of muscle, unspecified ankle and foot'),
    ('M6248', 'Contracture of muscle, other site'),
    ('M6249', 'Contracture of muscle, multiple sites'),
    ('M6250', 'Muscle wasting and atrophy, NEC, unsp site'),
    ('M62511', 'Muscle wasting and atrophy, NEC, right shoulder'),
    ('M62512', 'Muscle wasting and atrophy, NEC, left shoulder'),
    ('M62519', 'Muscle wasting and atrophy, NEC, unsp shoulder'),
    ('M62521', 'Muscle wasting and atrophy, NEC, right upper arm'),
    ('M62522', 'Muscle wasting and atrophy, NEC, left upper arm'),
    ('M62529', '