# -*- coding: utf-8 -*-
#
# This class was auto-generated from the API references found at
# https://apireference.connect.worldline-solutions.com/
#
from typing import List, Optional

from worldline.connect.sdk.domain.data_object import DataObject
from worldline.connect.sdk.v1.domain.installment_options import InstallmentOptions


class InstallmentOptionsResponse(DataObject):
    """
    | The response contains the details of the installment options
    """

    __installment_options: Optional[List[InstallmentOptions]] = None

    @property
    def installment_options(self) -> Optional[List[InstallmentOptions]]:
        """
        | Array containing installment options their details and characteristics
        
        Type: list[:class:`worldline.connect.sdk.v1.domain.installment_options.InstallmentOptions`]
        """
        return self.__installment_options

    @installment_options.setter
    def installment_options(self, value: Optional[List[InstallmentOptions]]) -> None:
        self.__installment_options = value

    def to_dictionary(self) -> dict:
        dictionary = super(InstallmentOptionsResponse, self).to_dictionary()
        if self.installment_options is not None:
            dictionary['installmentOptions'] = []
            for element in self.installment_options:
                if element is not None:
                    dictionary['installmentOptions'].append(element.to_dictionary())
        return dictionary

    def from_dictionary(self, dictionary: dict) -> 'InstallmentOptionsResponse':
        super(InstallmentOptionsResponse, self).from_dictionary(dictionary)
        if 'installmentOptions' in dictionary:
            if not isinstance(dictionary['installmentOptions'], list):
                raise TypeError('value \'{}\' is not a list'.format(dictionary['installmentOptions']))
            self.installment_options = []
            for element in dictionary['installmentOptions']:
                value = InstallmentOptions()
                self.installment_options.append(value.from_dictionary(element))
        return self
