# -*- coding: utf-8 -*-
#
# This class was auto-generated from the API references found at
# https://apireference.connect.worldline-solutions.com/
#
from typing import Optional

from worldline.connect.sdk.domain.data_object import DataObject


class PayoutReferences(DataObject):

    __invoice_number: Optional[str] = None
    __merchant_order_id: Optional[int] = None
    __merchant_reference: Optional[str] = None

    @property
    def invoice_number(self) -> Optional[str]:
        """
        | Your invoice number (on printed invoice) that is also returned in our report files
        
        Type: str
        """
        return self.__invoice_number

    @invoice_number.setter
    def invoice_number(self, value: Optional[str]) -> None:
        self.__invoice_number = value

    @property
    def merchant_order_id(self) -> Optional[int]:
        """
        | Order Identifier generated by the merchant
        | Note: This does not need to have a unique value for each transaction
        
        Type: int
        """
        return self.__merchant_order_id

    @merchant_order_id.setter
    def merchant_order_id(self, value: Optional[int]) -> None:
        self.__merchant_order_id = value

    @property
    def merchant_reference(self) -> Optional[str]:
        """
        | Note that the maximum length of this field for transactions processed on the GlobalCollect platform is 30. Your unique reference of the transaction that is also returned in our report files. This is almost always used for your reconciliation of our report files.
        
        Type: str
        """
        return self.__merchant_reference

    @merchant_reference.setter
    def merchant_reference(self, value: Optional[str]) -> None:
        self.__merchant_reference = value

    def to_dictionary(self) -> dict:
        dictionary = super(PayoutReferences, self).to_dictionary()
        if self.invoice_number is not None:
            dictionary['invoiceNumber'] = self.invoice_number
        if self.merchant_order_id is not None:
            dictionary['merchantOrderId'] = self.merchant_order_id
        if self.merchant_reference is not None:
            dictionary['merchantReference'] = self.merchant_reference
        return dictionary

    def from_dictionary(self, dictionary: dict) -> 'PayoutReferences':
        super(PayoutReferences, self).from_dictionary(dictionary)
        if 'invoiceNumber' in dictionary:
            self.invoice_number = dictionary['invoiceNumber']
        if 'merchantOrderId' in dictionary:
            self.merchant_order_id = dictionary['merchantOrderId']
        if 'merchantReference' in dictionary:
            self.merchant_reference = dictionary['merchantReference']
        return self
