from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel

VTK_EDGE_OVERLAP:int
VTK_NODE_OVERLAP:int
VTK_NO_OVERLAP:int
VTK_PARTIAL_OVERLAP:int

class vtkAbstractGridConnectivity(vtkmodules.vtkCommonCore.vtkObject):
    def ComputeNeighbors(self) -> None: ...
    def CreateGhostLayers(self, N:int=1) -> None: ...
    def GetGhostedCellGhostArray(self, gridID:int) -> vtkUnsignedCharArray: ...
    def GetGhostedGridCellData(self, gridID:int) -> vtkCellData: ...
    def GetGhostedGridPointData(self, gridID:int) -> vtkPointData: ...
    def GetGhostedPointGhostArray(self, gridID:int) -> vtkUnsignedCharArray: ...
    def GetGhostedPoints(self, gridID:int) -> vtkPoints: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfGhostLayers(self) -> int: ...
    def GetNumberOfGrids(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkAbstractGridConnectivity: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkAbstractGridConnectivity: ...
    def SetNumberOfGhostLayers(self, _arg:int) -> None: ...
    def SetNumberOfGrids(self, N:int) -> None: ...

class vtkCompositeDataGeometryFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCompositeDataGeometryFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCompositeDataGeometryFilter: ...

class vtkDataSetGhostGenerator(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    def FillInputPortInformation(self, port:int, info:vtkInformation) -> int: ...
    def FillOutputPortInformation(self, port:int, info:vtkInformation) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfGhostLayers(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkDataSetGhostGenerator: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDataSetGhostGenerator: ...
    def SetNumberOfGhostLayers(self, _arg:int) -> None: ...

class vtkDataSetSurfaceFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def DataSetExecute(self, input:vtkDataSet, output:vtkPolyData) -> int: ...
    def DelegationOff(self) -> None: ...
    def DelegationOn(self) -> None: ...
    def FastModeOff(self) -> None: ...
    def FastModeOn(self) -> None: ...
    def GetDelegation(self) -> int: ...
    def GetFastMode(self) -> bool: ...
    def GetNonlinearSubdivisionLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOriginalCellIdsName(self) -> str: ...
    def GetOriginalPointIdsName(self) -> str: ...
    def GetPassThroughCellIds(self) -> int: ...
    def GetPassThroughPointIds(self) -> int: ...
    def GetPieceInvariant(self) -> int: ...
    def GetUseStrips(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkDataSetSurfaceFilter: ...
    def PassThroughCellIdsOff(self) -> None: ...
    def PassThroughCellIdsOn(self) -> None: ...
    def PassThroughPointIdsOff(self) -> None: ...
    def PassThroughPointIdsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDataSetSurfaceFilter: ...
    def SetDelegation(self, _arg:int) -> None: ...
    def SetFastMode(self, _arg:bool) -> None: ...
    def SetNonlinearSubdivisionLevel(self, _arg:int) -> None: ...
    def SetOriginalCellIdsName(self, _arg:str) -> None: ...
    def SetOriginalPointIdsName(self, _arg:str) -> None: ...
    def SetPassThroughCellIds(self, _arg:int) -> None: ...
    def SetPassThroughPointIds(self, _arg:int) -> None: ...
    def SetPieceInvariant(self, _arg:int) -> None: ...
    def SetUseStrips(self, __a:int) -> None: ...
    @overload
    def StructuredExecute(self, input:vtkDataSet, output:vtkPolyData, ext:[int, ...], wholeExt:[int, ...]) -> int: ...
    @overload
    def StructuredExecute(self, input:vtkDataSet, output:vtkPolyData, ext32:(int, ...), wholeExt32:(int, ...)) -> int: ...
    @overload
    def UniformGridExecute(self, input:vtkDataSet, output:vtkPolyData, ext:[int, ...], wholeExt:[int, ...], extractface:[bool, bool, bool, bool, bool, bool]) -> int: ...
    @overload
    def UniformGridExecute(self, input:vtkDataSet, output:vtkPolyData, ext32:(int, ...), wholeExt32:(int, ...), extractface:[bool, bool, bool, bool, bool, bool]) -> int: ...
    def UnstructuredGridExecute(self, input:vtkDataSet, output:vtkPolyData) -> int: ...
    def UseStripsOff(self) -> None: ...
    def UseStripsOn(self) -> None: ...

class vtkDataSetRegionSurfaceFilter(vtkDataSetSurfaceFilter):
    def GetInterfaceIDsName(self) -> str: ...
    def GetMaterialIDsName(self) -> str: ...
    def GetMaterialPIDsName(self) -> str: ...
    def GetMaterialPropertiesName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRegionArrayName(self) -> str: ...
    def GetSingleSided(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkDataSetRegionSurfaceFilter: ...
    def RecordOrigCellId(self, newIndex:int, origId:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDataSetRegionSurfaceFilter: ...
    def SetInterfaceIDsName(self, _arg:str) -> None: ...
    def SetMaterialIDsName(self, _arg:str) -> None: ...
    def SetMaterialPIDsName(self, _arg:str) -> None: ...
    def SetMaterialPropertiesName(self, _arg:str) -> None: ...
    def SetRegionArrayName(self, _arg:str) -> None: ...
    def SetSingleSided(self, _arg:bool) -> None: ...
    def UnstructuredGridExecute(self, input:vtkDataSet, output:vtkPolyData) -> int: ...

class vtkExplicitStructuredGridSurfaceFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOriginalCellIdsName(self) -> str: ...
    def GetOriginalPointIdsName(self) -> str: ...
    def GetPassThroughCellIds(self) -> int: ...
    def GetPassThroughPointIds(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExplicitStructuredGridSurfaceFilter: ...
    def PassThroughCellIdsOff(self) -> None: ...
    def PassThroughCellIdsOn(self) -> None: ...
    def PassThroughPointIdsOff(self) -> None: ...
    def PassThroughPointIdsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExplicitStructuredGridSurfaceFilter: ...
    def SetOriginalCellIdsName(self, _arg:str) -> None: ...
    def SetOriginalPointIdsName(self, _arg:str) -> None: ...
    def SetPassThroughCellIds(self, _arg:int) -> None: ...
    def SetPassThroughPointIds(self, _arg:int) -> None: ...

class vtkFastGeomQuadStruct(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:vtkFastGeomQuadStruct) -> None: ...

class vtkGeometryFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def CellClippingOff(self) -> None: ...
    def CellClippingOn(self) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    @overload
    def DataSetExecute(self, input:vtkDataSet, output:vtkPolyData, exc:vtkPolyData) -> int: ...
    @overload
    def DataSetExecute(self, input:vtkDataSet, output:vtkPolyData) -> int: ...
    def DelegationOff(self) -> None: ...
    def DelegationOn(self) -> None: ...
    def ExtentClippingOff(self) -> None: ...
    def ExtentClippingOn(self) -> None: ...
    def FastModeOff(self) -> None: ...
    def FastModeOn(self) -> None: ...
    def GetCellClipping(self) -> bool: ...
    def GetCellMaximum(self) -> int: ...
    def GetCellMaximumMaxValue(self) -> int: ...
    def GetCellMaximumMinValue(self) -> int: ...
    def GetCellMinimum(self) -> int: ...
    def GetCellMinimumMaxValue(self) -> int: ...
    def GetCellMinimumMinValue(self) -> int: ...
    def GetDegree(self) -> int: ...
    def GetDegreeMaxValue(self) -> int: ...
    def GetDegreeMinValue(self) -> int: ...
    def GetDelegation(self) -> int: ...
    def GetExcludedFaces(self) -> vtkPolyData: ...
    def GetExtent(self) -> (float, float, float, float, float, float): ...
    def GetExtentClipping(self) -> bool: ...
    def GetFastMode(self) -> bool: ...
    def GetLocator(self) -> vtkIncrementalPointLocator: ...
    def GetMerging(self) -> bool: ...
    def GetNonlinearSubdivisionLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOriginalCellIdsName(self) -> str: ...
    def GetOriginalPointIdsName(self) -> str: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPassThroughCellIds(self) -> int: ...
    def GetPassThroughPointIds(self) -> int: ...
    def GetPieceInvariant(self) -> int: ...
    def GetPointClipping(self) -> bool: ...
    def GetPointMaximum(self) -> int: ...
    def GetPointMaximumMaxValue(self) -> int: ...
    def GetPointMaximumMinValue(self) -> int: ...
    def GetPointMinimum(self) -> int: ...
    def GetPointMinimumMaxValue(self) -> int: ...
    def GetPointMinimumMinValue(self) -> int: ...
    def GetRemoveGhostInterfaces(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergingOff(self) -> None: ...
    def MergingOn(self) -> None: ...
    def NewInstance(self) -> vtkGeometryFilter: ...
    def PassThroughCellIdsOff(self) -> None: ...
    def PassThroughCellIdsOn(self) -> None: ...
    def PassThroughPointIdsOff(self) -> None: ...
    def PassThroughPointIdsOn(self) -> None: ...
    def PointClippingOff(self) -> None: ...
    def PointClippingOn(self) -> None: ...
    @overload
    def PolyDataExecute(self, input:vtkDataSet, output:vtkPolyData, exc:vtkPolyData) -> int: ...
    @overload
    def PolyDataExecute(self, __a:vtkDataSet, __b:vtkPolyData) -> int: ...
    def RemoveGhostInterfacesOff(self) -> None: ...
    def RemoveGhostInterfacesOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGeometryFilter: ...
    def SetCellClipping(self, _arg:bool) -> None: ...
    def SetCellMaximum(self, _arg:int) -> None: ...
    def SetCellMinimum(self, _arg:int) -> None: ...
    def SetDegree(self, arg:int) -> None: ...
    def SetDelegation(self, _arg:int) -> None: ...
    def SetExcludedFacesConnection(self, algOutput:vtkAlgorithmOutput) -> None: ...
    def SetExcludedFacesData(self, __a:vtkPolyData) -> None: ...
    @overload
    def SetExtent(self, xMin:float, xMax:float, yMin:float, yMax:float, zMin:float, zMax:float) -> None: ...
    @overload
    def SetExtent(self, extent:[float, float, float, float, float, float]) -> None: ...
    def SetExtentClipping(self, _arg:bool) -> None: ...
    def SetFastMode(self, _arg:bool) -> None: ...
    def SetLocator(self, locator:vtkIncrementalPointLocator) -> None: ...
    def SetMerging(self, _arg:bool) -> None: ...
    def SetNonlinearSubdivisionLevel(self, _arg:int) -> None: ...
    def SetOriginalCellIdsName(self, _arg:str) -> None: ...
    def SetOriginalPointIdsName(self, _arg:str) -> None: ...
    def SetOutputPointsPrecision(self, precision:int) -> None: ...
    def SetPassThroughCellIds(self, _arg:int) -> None: ...
    def SetPassThroughPointIds(self, _arg:int) -> None: ...
    def SetPieceInvariant(self, _arg:int) -> None: ...
    def SetPointClipping(self, _arg:bool) -> None: ...
    def SetPointMaximum(self, _arg:int) -> None: ...
    def SetPointMinimum(self, _arg:int) -> None: ...
    def SetRemoveGhostInterfaces(self, _arg:bool) -> None: ...
    @overload
    def StructuredExecute(self, input:vtkDataSet, output:vtkPolyData, inInfo:vtkInformation, exc:vtkPolyData, extractFace:[bool, ...]=...) -> int: ...
    @overload
    def StructuredExecute(self, input:vtkDataSet, output:vtkPolyData, inInfo:vtkInformation, extractFace:[bool, ...]=...) -> int: ...
    def UnstructuredGridExecute(self, input:vtkDataSet, output:vtkPolyData) -> int: ...

class vtkGeometryFilterHelper(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:vtkGeometryFilterHelper) -> None: ...
    @overload
    @staticmethod
    def CopyFilterParams(gf:vtkGeometryFilter, dssf:vtkDataSetSurfaceFilter) -> None: ...
    @overload
    @staticmethod
    def CopyFilterParams(dssf:vtkDataSetSurfaceFilter, gf:vtkGeometryFilter) -> None: ...

class vtkHierarchicalDataSetGeometryFilter(vtkCompositeDataGeometryFilter):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkHierarchicalDataSetGeometryFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkHierarchicalDataSetGeometryFilter: ...

class vtkImageDataGeometryFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetExtent(self) -> (int, int, int, int, int, int): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputTriangles(self) -> int: ...
    def GetThresholdCells(self) -> int: ...
    def GetThresholdValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkImageDataGeometryFilter: ...
    def OutputTrianglesOff(self) -> None: ...
    def OutputTrianglesOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkImageDataGeometryFilter: ...
    @overload
    def SetExtent(self, extent:[int, int, int, int, int, int]) -> None: ...
    @overload
    def SetExtent(self, iMin:int, iMax:int, jMin:int, jMax:int, kMin:int, kMax:int) -> None: ...
    def SetOutputTriangles(self, _arg:int) -> None: ...
    def SetThresholdCells(self, _arg:int) -> None: ...
    def SetThresholdValue(self, _arg:float) -> None: ...
    def ThresholdCellsOff(self) -> None: ...
    def ThresholdCellsOn(self) -> None: ...
    def ThresholdValueOff(self) -> None: ...
    def ThresholdValueOn(self) -> None: ...

class vtkImageDataToUniformGrid(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReverse(self) -> int: ...
    def GetReverseMaxValue(self) -> int: ...
    def GetReverseMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkImageDataToUniformGrid: ...
    def ReverseOff(self) -> None: ...
    def ReverseOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkImageDataToUniformGrid: ...
    def SetReverse(self, _arg:int) -> None: ...

class vtkLinearToQuadraticCellsFilter(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def CreateDefaultLocator(self) -> None: ...
    def GetLocator(self) -> vtkIncrementalPointLocator: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkLinearToQuadraticCellsFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLinearToQuadraticCellsFilter: ...
    def SetLocator(self, locator:vtkIncrementalPointLocator) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...

class vtkMarkBoundaryFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def GenerateBoundaryFacesOff(self) -> None: ...
    def GenerateBoundaryFacesOn(self) -> None: ...
    def GetBoundaryCellsName(self) -> str: ...
    def GetBoundaryFacesName(self) -> str: ...
    def GetBoundaryPointsName(self) -> str: ...
    def GetGenerateBoundaryFaces(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkMarkBoundaryFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkMarkBoundaryFilter: ...
    def SetBoundaryCellsName(self, _arg:str) -> None: ...
    def SetBoundaryFacesName(self, _arg:str) -> None: ...
    def SetBoundaryPointsName(self, _arg:str) -> None: ...
    def SetGenerateBoundaryFaces(self, _arg:bool) -> None: ...

class vtkProjectSphereFilter(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    def GetCenter(self) -> (float, float, float): ...
    def GetKeepPolePoints(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTranslateZ(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def KeepPolePointsOff(self) -> None: ...
    def KeepPolePointsOn(self) -> None: ...
    def NewInstance(self) -> vtkProjectSphereFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkProjectSphereFilter: ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:(float, float, float)) -> None: ...
    def SetKeepPolePoints(self, _arg:bool) -> None: ...
    def SetTranslateZ(self, _arg:bool) -> None: ...
    def TranslateZOff(self) -> None: ...
    def TranslateZOn(self) -> None: ...

class vtkRectilinearGridGeometryFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetExtent(self) -> (int, int, int, int, int, int): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRectilinearGridGeometryFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRectilinearGridGeometryFilter: ...
    @overload
    def SetExtent(self, iMin:int, iMax:int, jMin:int, jMax:int, kMin:int, kMax:int) -> None: ...
    @overload
    def SetExtent(self, extent:[int, int, int, int, int, int]) -> None: ...

class vtkRectilinearGridPartitioner(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    def DuplicateNodesOff(self) -> None: ...
    def DuplicateNodesOn(self) -> None: ...
    def GetDuplicateNodes(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfGhostLayers(self) -> int: ...
    def GetNumberOfPartitions(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkRectilinearGridPartitioner: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRectilinearGridPartitioner: ...
    def SetDuplicateNodes(self, _arg:int) -> None: ...
    def SetNumberOfGhostLayers(self, _arg:int) -> None: ...
    def SetNumberOfPartitions(self, _arg:int) -> None: ...

class vtkStructuredAMRGridConnectivity(vtkAbstractGridConnectivity):
    def ComputeNeighbors(self) -> None: ...
    def CreateGhostLayers(self, N:int=1) -> None: ...
    def GetBalancedRefinement(self) -> bool: ...
    def GetCellCentered(self) -> bool: ...
    def GetGhostedExtent(self, gridID:int, ext:[int, int, int, int, int, int]) -> None: ...
    def GetNeighbor(self, gridID:int, nei:int) -> vtkStructuredAMRNeighbor: ...
    def GetNodeCentered(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfNeighbors(self, gridID:int) -> int: ...
    def Initialize(self, NumberOfLevels:int, N:int, RefinementRatio:int=-1) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkStructuredAMRGridConnectivity: ...
    @overload
    def RegisterGrid(self, gridIdx:int, level:int, refinementRatio:int, extents:[int, int, int, int, int, int], nodesGhostArray:vtkUnsignedCharArray, cellGhostArray:vtkUnsignedCharArray, pointData:vtkPointData, cellData:vtkCellData, gridNodes:vtkPoints) -> None: ...
    @overload
    def RegisterGrid(self, gridIdx:int, level:int, extents:[int, int, int, int, int, int], nodesGhostArray:vtkUnsignedCharArray, cellGhostArray:vtkUnsignedCharArray, pointData:vtkPointData, cellData:vtkCellData, gridNodes:vtkPoints) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkStructuredAMRGridConnectivity: ...
    def SetBalancedRefinement(self, _arg:bool) -> None: ...
    def SetCellCentered(self, _arg:bool) -> None: ...
    def SetNodeCentered(self, _arg:bool) -> None: ...

class vtkStructuredNeighbor(object):
    class NeighborOrientation(int): ...
    HI:'NeighborOrientation'
    LO:'NeighborOrientation'
    ONE_TO_ONE:'NeighborOrientation'
    SUBSET_BOTH:'NeighborOrientation'
    SUBSET_HI:'NeighborOrientation'
    SUBSET_LO:'NeighborOrientation'
    SUPERSET:'NeighborOrientation'
    UNDEFINED:'NeighborOrientation'
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, NeiID:int, overlap:[int, int, int, int, int, int]) -> None: ...
    @overload
    def __init__(self, NeiID:int, overlap:[int, int, int, int, int, int], orient:[int, int, int]) -> None: ...
    @overload
    def __init__(self, N:vtkStructuredNeighbor) -> None: ...
    def ComputeSendAndReceiveExtent(self, gridRealExtent:[int, int, int, int, int, int], gridGhostedExtent:[int, int, int, int, int, int], neiRealExtent:[int, int, int, int, int, int], WholeExtent:[int, int, int, int, int, int], N:int) -> None: ...

class vtkStructuredAMRNeighbor(vtkStructuredNeighbor):
    class NeighborRelationship(int): ...
    CHILD:'NeighborRelationship'
    COARSE_TO_FINE_SIBLING:'NeighborRelationship'
    FINE_TO_COARSE_SIBLING:'NeighborRelationship'
    PARENT:'NeighborRelationship'
    PARTIALLY_OVERLAPPING_CHILD:'NeighborRelationship'
    PARTIALLY_OVERLAPPING_PARENT:'NeighborRelationship'
    SAME_LEVEL_SIBLING:'NeighborRelationship'
    UNDEFINED:'NeighborRelationship'
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, gridLevel:int, neiID:int, neighborLevel:int, gridOverlap:[int, int, int, int, int, int], neiOverlap:[int, int, int, int, int, int], orient:[int, int, int], relationShip:int) -> None: ...
    @overload
    def __init__(self, N:vtkStructuredAMRNeighbor) -> None: ...
    def ComputeSendAndReceiveExtent(self, gridRealExtent:[int, int, int, int, int, int], gridGhostedExtent:[int, int, int, int, int, int], neiRealExtent:[int, int, int, int, int, int], WholeExtent:[int, int, int, int, int, int], N:int) -> None: ...
    def GetReceiveExtentOnGrid(self, ng:int, gridExtent:[int, int, int, int, int, int], ext:[int, int, int, int, int, int]) -> None: ...
    def GetRelationShipString(self) -> str: ...

class vtkStructuredGridConnectivity(vtkAbstractGridConnectivity):
    def ComputeNeighbors(self) -> None: ...
    def CreateGhostLayers(self, N:int=1) -> None: ...
    def FillGhostArrays(self, gridID:int, nodesArray:vtkUnsignedCharArray, cellsArray:vtkUnsignedCharArray) -> None: ...
    def GetDataDimension(self) -> int: ...
    def GetGhostedGridExtent(self, gridID:int, ext:[int, int, int, int, int, int]) -> None: ...
    def GetGridExtent(self, gridID:int, extent:[int, int, int, int, int, int]) -> None: ...
    def GetGridNeighbor(self, gridID:int, nei:int) -> vtkStructuredNeighbor: ...
    def GetNeighbors(self, gridID:int, extents:[int, ...]) -> vtkIdList: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfNeighbors(self, gridID:int) -> int: ...
    def GetWholeExtent(self) -> (int, int, int, int, int, int): ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkStructuredGridConnectivity: ...
    def RegisterGrid(self, gridID:int, extents:[int, int, int, int, int, int], nodesGhostArray:vtkUnsignedCharArray, cellGhostArray:vtkUnsignedCharArray, pointData:vtkPointData, cellData:vtkCellData, gridNodes:vtkPoints) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkStructuredGridConnectivity: ...
    def SetGhostedGridExtent(self, gridID:int, ext:[int, int, int, int, int, int]) -> None: ...
    def SetNumberOfGrids(self, N:int) -> None: ...
    @overload
    def SetWholeExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetWholeExtent(self, _arg:(int, int, int, int, int, int)) -> None: ...

class vtkStructuredGridGeometryFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetExtent(self) -> (int, int, int, int, int, int): ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkStructuredGridGeometryFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkStructuredGridGeometryFilter: ...
    @overload
    def SetExtent(self, iMin:int, iMax:int, jMin:int, jMax:int, kMin:int, kMax:int) -> None: ...
    @overload
    def SetExtent(self, extent:[int, int, int, int, int, int]) -> None: ...

class vtkStructuredGridGhostDataGenerator(vtkDataSetGhostGenerator):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkStructuredGridGhostDataGenerator: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkStructuredGridGhostDataGenerator: ...

class vtkStructuredGridPartitioner(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    def DuplicateNodesOff(self) -> None: ...
    def DuplicateNodesOn(self) -> None: ...
    def GetDuplicateNodes(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfGhostLayers(self) -> int: ...
    def GetNumberOfPartitions(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkStructuredGridPartitioner: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkStructuredGridPartitioner: ...
    def SetDuplicateNodes(self, _arg:int) -> None: ...
    def SetNumberOfGhostLayers(self, _arg:int) -> None: ...
    def SetNumberOfPartitions(self, _arg:int) -> None: ...

class vtkStructuredPointsGeometryFilter(vtkImageDataGeometryFilter):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkStructuredPointsGeometryFilter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkStructuredPointsGeometryFilter: ...

class vtkUniformGridGhostDataGenerator(vtkDataSetGhostGenerator):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkUniformGridGhostDataGenerator: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkUniformGridGhostDataGenerator: ...

class vtkUnstructuredGridGeometryFilter(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridBaseAlgorithm):
    def CellClippingOff(self) -> None: ...
    def CellClippingOn(self) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def DuplicateGhostCellClippingOff(self) -> None: ...
    def DuplicateGhostCellClippingOn(self) -> None: ...
    def ExtentClippingOff(self) -> None: ...
    def ExtentClippingOn(self) -> None: ...
    def GetCellClipping(self) -> int: ...
    def GetCellMaximum(self) -> int: ...
    def GetCellMaximumMaxValue(self) -> int: ...
    def GetCellMaximumMinValue(self) -> int: ...
    def GetCellMinimum(self) -> int: ...
    def GetCellMinimumMaxValue(self) -> int: ...
    def GetCellMinimumMinValue(self) -> int: ...
    def GetDuplicateGhostCellClipping(self) -> int: ...
    def GetExtent(self) -> Pointer: ...
    def GetExtentClipping(self) -> int: ...
    def GetLocator(self) -> vtkIncrementalPointLocator: ...
    def GetMTime(self) -> int: ...
    def GetMerging(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOriginalCellIdsName(self) -> str: ...
    def GetOriginalPointIdsName(self) -> str: ...
    def GetPassThroughCellIds(self) -> int: ...
    def GetPassThroughPointIds(self) -> int: ...
    def GetPointClipping(self) -> int: ...
    def GetPointMaximum(self) -> int: ...
    def GetPointMaximumMaxValue(self) -> int: ...
    def GetPointMaximumMinValue(self) -> int: ...
    def GetPointMinimum(self) -> int: ...
    def GetPointMinimumMaxValue(self) -> int: ...
    def GetPointMinimumMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergingOff(self) -> None: ...
    def MergingOn(self) -> None: ...
    def NewInstance(self) -> vtkUnstructuredGridGeometryFilter: ...
    def PassThroughCellIdsOff(self) -> None: ...
    def PassThroughCellIdsOn(self) -> None: ...
    def PassThroughPointIdsOff(self) -> None: ...
    def PassThroughPointIdsOn(self) -> None: ...
    def PointClippingOff(self) -> None: ...
    def PointClippingOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkUnstructuredGridGeometryFilter: ...
    def SetCellClipping(self, _arg:int) -> None: ...
    def SetCellMaximum(self, _arg:int) -> None: ...
    def SetCellMinimum(self, _arg:int) -> None: ...
    def SetDuplicateGhostCellClipping(self, _arg:int) -> None: ...
    @overload
    def SetExtent(self, xMin:float, xMax:float, yMin:float, yMax:float, zMin:float, zMax:float) -> None: ...
    @overload
    def SetExtent(self, extent:[float, float, float, float, float, float]) -> None: ...
    def SetExtentClipping(self, _arg:int) -> None: ...
    def SetLocator(self, locator:vtkIncrementalPointLocator) -> None: ...
    def SetMerging(self, _arg:int) -> None: ...
    def SetOriginalCellIdsName(self, _arg:str) -> None: ...
    def SetOriginalPointIdsName(self, _arg:str) -> None: ...
    def SetPassThroughCellIds(self, _arg:int) -> None: ...
    def SetPassThroughPointIds(self, _arg:int) -> None: ...
    def SetPointClipping(self, _arg:int) -> None: ...
    def SetPointMaximum(self, _arg:int) -> None: ...
    def SetPointMinimum(self, _arg:int) -> None: ...

