from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkIOCore
import vtkmodules.vtkIOImage

class vtkMINCImageAttributes(vtkmodules.vtkCommonCore.vtkObject):
    @overload
    def AddDimension(self, dimension:str) -> None: ...
    @overload
    def AddDimension(self, dimension:str, length:int) -> None: ...
    def FindImageRange(self, range:[float, float]) -> None: ...
    def FindValidRange(self, range:[float, float]) -> None: ...
    def GetAttributeNames(self, variable:str) -> vtkStringArray: ...
    def GetAttributeValueAsArray(self, variable:str, attribute:str) -> vtkDataArray: ...
    def GetAttributeValueAsDouble(self, variable:str, attribute:str) -> float: ...
    def GetAttributeValueAsInt(self, variable:str, attribute:str) -> int: ...
    def GetAttributeValueAsString(self, variable:str, attribute:str) -> str: ...
    def GetDataType(self) -> int: ...
    def GetDimensionLengths(self) -> vtkIdTypeArray: ...
    def GetDimensionNames(self) -> vtkStringArray: ...
    def GetImageMax(self) -> vtkDoubleArray: ...
    def GetImageMin(self) -> vtkDoubleArray: ...
    def GetName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfImageMinMaxDimensions(self) -> int: ...
    def GetValidateAttributes(self) -> int: ...
    def GetVariableNames(self) -> vtkStringArray: ...
    def HasAttribute(self, variable:str, attribute:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkMINCImageAttributes: ...
    def PrintFileHeader(self) -> None: ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkMINCImageAttributes: ...
    def SetAttributeValueAsArray(self, variable:str, attribute:str, array:vtkDataArray) -> None: ...
    def SetAttributeValueAsDouble(self, variable:str, attribute:str, value:float) -> None: ...
    def SetAttributeValueAsInt(self, variable:str, attribute:str, value:int) -> None: ...
    def SetAttributeValueAsString(self, variable:str, attribute:str, value:str) -> None: ...
    def SetDataType(self, _arg:int) -> None: ...
    def SetImageMax(self, imageMax:vtkDoubleArray) -> None: ...
    def SetImageMin(self, imageMin:vtkDoubleArray) -> None: ...
    def SetName(self, _arg:str) -> None: ...
    def SetNumberOfImageMinMaxDimensions(self, _arg:int) -> None: ...
    def SetValidateAttributes(self, _arg:int) -> None: ...
    def ShallowCopy(self, source:vtkMINCImageAttributes) -> None: ...
    def ValidateAttribute(self, varname:str, attname:str, array:vtkDataArray) -> int: ...
    def ValidateAttributesOff(self) -> None: ...
    def ValidateAttributesOn(self) -> None: ...

class vtkMINCImageReader(vtkmodules.vtkIOImage.vtkImageReader2):
    def CanReadFile(self, name:str) -> int: ...
    @overload
    def GetDataRange(self) -> (float, float): ...
    @overload
    def GetDataRange(self, range:[float, float]) -> None: ...
    def GetDescriptiveName(self) -> str: ...
    def GetDirectionCosines(self) -> vtkMatrix4x4: ...
    def GetFileExtensions(self) -> str: ...
    def GetImageAttributes(self) -> vtkMINCImageAttributes: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTimeSteps(self) -> int: ...
    def GetRescaleIntercept(self) -> float: ...
    def GetRescaleRealValues(self) -> int: ...
    def GetRescaleSlope(self) -> float: ...
    def GetTimeStep(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkMINCImageReader: ...
    def RescaleRealValuesOff(self) -> None: ...
    def RescaleRealValuesOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkMINCImageReader: ...
    def SetFileName(self, name:str) -> None: ...
    def SetRescaleRealValues(self, _arg:int) -> None: ...
    def SetTimeStep(self, _arg:int) -> None: ...

class vtkMINCImageWriter(vtkmodules.vtkIOImage.vtkImageWriter):
    def GetDescriptiveName(self) -> str: ...
    def GetDirectionCosines(self) -> vtkMatrix4x4: ...
    def GetFileExtensions(self) -> str: ...
    def GetHistoryAddition(self) -> str: ...
    def GetImageAttributes(self) -> vtkMINCImageAttributes: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRescaleIntercept(self) -> float: ...
    def GetRescaleSlope(self) -> float: ...
    def GetStrictValidation(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkMINCImageWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkMINCImageWriter: ...
    def SetDirectionCosines(self, matrix:vtkMatrix4x4) -> None: ...
    def SetFileName(self, name:str) -> None: ...
    def SetHistoryAddition(self, _arg:str) -> None: ...
    def SetImageAttributes(self, attributes:vtkMINCImageAttributes) -> None: ...
    def SetRescaleIntercept(self, _arg:float) -> None: ...
    def SetRescaleSlope(self, _arg:float) -> None: ...
    def SetStrictValidation(self, _arg:int) -> None: ...
    def StrictValidationOff(self) -> None: ...
    def StrictValidationOn(self) -> None: ...
    def Write(self) -> None: ...

class vtkMNIObjectReader(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def CanReadFile(self, name:str) -> int: ...
    def GetDescriptiveName(self) -> str: ...
    def GetFileExtensions(self) -> str: ...
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> vtkProperty: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkMNIObjectReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkMNIObjectReader: ...
    def SetFileName(self, _arg:str) -> None: ...

class vtkMNIObjectWriter(vtkmodules.vtkIOCore.vtkWriter):
    def GetDescriptiveName(self) -> str: ...
    def GetFileExtensions(self) -> str: ...
    def GetFileName(self) -> str: ...
    def GetFileType(self) -> int: ...
    def GetFileTypeMaxValue(self) -> int: ...
    def GetFileTypeMinValue(self) -> int: ...
    @overload
    def GetInput(self) -> vtkPolyData: ...
    @overload
    def GetInput(self, port:int) -> vtkPolyData: ...
    def GetLookupTable(self) -> vtkLookupTable: ...
    def GetMapper(self) -> vtkMapper: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> vtkProperty: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkMNIObjectWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkMNIObjectWriter: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetFileType(self, _arg:int) -> None: ...
    def SetFileTypeToASCII(self) -> None: ...
    def SetFileTypeToBinary(self) -> None: ...
    def SetLookupTable(self, table:vtkLookupTable) -> None: ...
    def SetMapper(self, mapper:vtkMapper) -> None: ...
    def SetProperty(self, property:vtkProperty) -> None: ...

class vtkMNITagPointReader(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def CanReadFile(self, name:str) -> int: ...
    def GetComments(self) -> str: ...
    def GetDescriptiveName(self) -> str: ...
    def GetFileExtensions(self) -> str: ...
    def GetFileName(self) -> str: ...
    def GetLabelText(self) -> vtkStringArray: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfVolumes(self) -> int: ...
    def GetPatientIds(self) -> vtkIntArray: ...
    @overload
    def GetPoints(self, port:int) -> vtkPoints: ...
    @overload
    def GetPoints(self) -> vtkPoints: ...
    def GetStructureIds(self) -> vtkIntArray: ...
    def GetWeights(self) -> vtkDoubleArray: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkMNITagPointReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkMNITagPointReader: ...
    def SetFileName(self, _arg:str) -> None: ...

class vtkMNITagPointWriter(vtkmodules.vtkIOCore.vtkWriter):
    def GetComments(self) -> str: ...
    def GetDescriptiveName(self) -> str: ...
    def GetFileExtensions(self) -> str: ...
    def GetFileName(self) -> str: ...
    def GetLabelText(self) -> vtkStringArray: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPatientIds(self) -> vtkIntArray: ...
    @overload
    def GetPoints(self, port:int) -> vtkPoints: ...
    @overload
    def GetPoints(self) -> vtkPoints: ...
    def GetStructureIds(self) -> vtkIntArray: ...
    def GetWeights(self) -> vtkDoubleArray: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkMNITagPointWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkMNITagPointWriter: ...
    def SetComments(self, _arg:str) -> None: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetLabelText(self, a:vtkStringArray) -> None: ...
    def SetPatientIds(self, a:vtkIntArray) -> None: ...
    @overload
    def SetPoints(self, port:int, points:vtkPoints) -> None: ...
    @overload
    def SetPoints(self, points:vtkPoints) -> None: ...
    def SetStructureIds(self, a:vtkIntArray) -> None: ...
    def SetWeights(self, a:vtkDoubleArray) -> None: ...
    def Write(self) -> int: ...

class vtkMNITransformReader(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    def CanReadFile(self, name:str) -> int: ...
    def GetComments(self) -> str: ...
    def GetDescriptiveName(self) -> str: ...
    def GetFileExtensions(self) -> str: ...
    def GetFileName(self) -> str: ...
    def GetNthTransform(self, i:int) -> vtkAbstractTransform: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTransforms(self) -> int: ...
    def GetTransform(self) -> vtkAbstractTransform: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkMNITransformReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkMNITransformReader: ...
    def SetFileName(self, _arg:str) -> None: ...

class vtkMNITransformWriter(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    def AddTransform(self, transform:vtkAbstractTransform) -> None: ...
    def GetComments(self) -> str: ...
    def GetDescriptiveName(self) -> str: ...
    def GetFileExtensions(self) -> str: ...
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTransforms(self) -> int: ...
    def GetTransform(self) -> vtkAbstractTransform: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkMNITransformWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkMNITransformWriter: ...
    def SetComments(self, _arg:str) -> None: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetTransform(self, transform:vtkAbstractTransform) -> None: ...
    def Write(self) -> None: ...

