from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkRenderingCore

VTK_LABEL_FIELD_DATA:int
VTK_LABEL_IDS:int
VTK_LABEL_NORMALS:int
VTK_LABEL_SCALARS:int
VTK_LABEL_TCOORDS:int
VTK_LABEL_TENSORS:int
VTK_LABEL_VECTORS:int

class vtkLabeledDataMapper(vtkmodules.vtkRenderingCore.vtkMapper2D):
    class Coordinates(int): ...
    DISPLAY:'Coordinates'
    WORLD:'Coordinates'
    def CoordinateSystemDisplay(self) -> None: ...
    def CoordinateSystemWorld(self) -> None: ...
    def GetComponentSeparator(self) -> str: ...
    def GetCoordinateSystem(self) -> int: ...
    def GetCoordinateSystemMaxValue(self) -> int: ...
    def GetCoordinateSystemMinValue(self) -> int: ...
    def GetFieldDataArray(self) -> int: ...
    def GetFieldDataName(self) -> str: ...
    def GetInput(self) -> vtkDataSet: ...
    def GetLabelFormat(self) -> str: ...
    def GetLabelMode(self) -> int: ...
    def GetLabelPosition(self, label:int, pos:[float, float, float]) -> None: ...
    def GetLabelText(self, label:int) -> str: ...
    @overload
    def GetLabelTextProperty(self) -> vtkTextProperty: ...
    @overload
    def GetLabelTextProperty(self, type:int) -> vtkTextProperty: ...
    def GetLabeledComponent(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLabels(self) -> int: ...
    def GetTransform(self) -> vtkTransform: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkLabeledDataMapper: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RenderOpaqueGeometry(self, viewport:vtkViewport, actor:vtkActor2D) -> None: ...
    def RenderOverlay(self, viewport:vtkViewport, actor:vtkActor2D) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLabeledDataMapper: ...
    def SetComponentSeparator(self, _arg:str) -> None: ...
    def SetCoordinateSystem(self, _arg:int) -> None: ...
    def SetFieldDataArray(self, arrayIndex:int) -> None: ...
    def SetFieldDataName(self, arrayName:str) -> None: ...
    def SetInputData(self, __a:vtkDataObject) -> None: ...
    def SetLabelFormat(self, _arg:str) -> None: ...
    def SetLabelMode(self, _arg:int) -> None: ...
    def SetLabelModeToLabelFieldData(self) -> None: ...
    def SetLabelModeToLabelIds(self) -> None: ...
    def SetLabelModeToLabelNormals(self) -> None: ...
    def SetLabelModeToLabelScalars(self) -> None: ...
    def SetLabelModeToLabelTCoords(self) -> None: ...
    def SetLabelModeToLabelTensors(self) -> None: ...
    def SetLabelModeToLabelVectors(self) -> None: ...
    @overload
    def SetLabelTextProperty(self, p:vtkTextProperty) -> None: ...
    @overload
    def SetLabelTextProperty(self, p:vtkTextProperty, type:int) -> None: ...
    def SetLabeledComponent(self, _arg:int) -> None: ...
    def SetTransform(self, t:vtkTransform) -> None: ...

class vtkDynamic2DLabelMapper(vtkLabeledDataMapper):
    def GetLabelHeightPadding(self) -> float: ...
    def GetLabelWidthPadding(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReversePriority(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkDynamic2DLabelMapper: ...
    def RenderOpaqueGeometry(self, viewport:vtkViewport, actor:vtkActor2D) -> None: ...
    def RenderOverlay(self, viewport:vtkViewport, actor:vtkActor2D) -> None: ...
    def ReversePriorityOff(self) -> None: ...
    def ReversePriorityOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDynamic2DLabelMapper: ...
    def SetLabelHeightPadding(self, _arg:float) -> None: ...
    def SetLabelWidthPadding(self, _arg:float) -> None: ...
    def SetPriorityArrayName(self, name:str) -> None: ...
    def SetReversePriority(self, _arg:bool) -> None: ...

class vtkLabelRenderStrategy(vtkmodules.vtkCommonCore.vtkObject):
    def ComputeLabelBounds(self, tprop:vtkTextProperty, label:str, bds:[float, float, float, float]) -> None: ...
    def EndFrame(self) -> None: ...
    def GetDefaultTextProperty(self) -> vtkTextProperty: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> vtkRenderer: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkLabelRenderStrategy: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    @overload
    def RenderLabel(self, x:[int, int], tprop:vtkTextProperty, label:str) -> None: ...
    @overload
    def RenderLabel(self, x:[int, int], tprop:vtkTextProperty, label:str, maxWidth:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLabelRenderStrategy: ...
    def SetDefaultTextProperty(self, tprop:vtkTextProperty) -> None: ...
    def SetRenderer(self, ren:vtkRenderer) -> None: ...
    def StartFrame(self) -> None: ...
    def SupportsBoundedSize(self) -> bool: ...
    def SupportsRotation(self) -> bool: ...

class vtkFreeTypeLabelRenderStrategy(vtkLabelRenderStrategy):
    def ComputeLabelBounds(self, tprop:vtkTextProperty, label:str, bds:[float, float, float, float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkFreeTypeLabelRenderStrategy: ...
    def ReleaseGraphicsResources(self, window:vtkWindow) -> None: ...
    def RenderLabel(self, x:[int, int], tprop:vtkTextProperty, label:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkFreeTypeLabelRenderStrategy: ...
    def SupportsBoundedSize(self) -> bool: ...
    def SupportsRotation(self) -> bool: ...

class vtkLabelHierarchy(vtkmodules.vtkCommonDataModel.vtkPointSet):
    class IteratorType(int): ...
    DEPTH_FIRST:'IteratorType'
    FRUSTUM:'IteratorType'
    FULL_SORT:'IteratorType'
    QUEUE:'IteratorType'
    def ComputeHierarchy(self) -> None: ...
    @overload
    def FindCell(self, __a:[float, float, float], __b:vtkCell, __c:int, __d:float, __e:int, __f:[float, float, float], __g:[float, ...]) -> int: ...
    @overload
    def FindCell(self, __a:[float, float, float], __b:vtkCell, __c:vtkGenericCell, __d:int, __e:float, __f:int, __g:[float, float, float], __h:[float, ...]) -> int: ...
    @staticmethod
    def GetAnchorFrustumPlanes(frustumPlanes:[float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float], ren:vtkRenderer, anchorTransform:vtkCoordinate) -> None: ...
    def GetBoundedSizes(self) -> vtkDataArray: ...
    @overload
    def GetCell(self, __a:int) -> vtkCell: ...
    @overload
    def GetCell(self, __a:int, __b:vtkGenericCell) -> None: ...
    @overload
    def GetCell(self, i:int, j:int, k:int) -> vtkCell: ...
    def GetCellPoints(self, __a:int, __b:vtkIdList) -> None: ...
    def GetCellType(self, __a:int) -> int: ...
    def GetCenterPts(self) -> vtkPoints: ...
    def GetCoincidentPoints(self) -> vtkCoincidentPoints: ...
    def GetDiscreteNodeCoordinatesFromWorldPoint(self, ijk:[int, int, int], pt:[float, float, float], level:int) -> None: ...
    def GetIconIndices(self) -> vtkIntArray: ...
    def GetLabels(self) -> vtkAbstractArray: ...
    def GetMaxCellSize(self) -> int: ...
    def GetMaximumDepth(self) -> int: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientations(self) -> vtkDataArray: ...
    @staticmethod
    def GetPathForNodalCoordinates(path:[int, ...], ijk:[int, int, int], level:int) -> bool: ...
    def GetPointCells(self, __a:int, __b:vtkIdList) -> None: ...
    def GetPriorities(self) -> vtkDataArray: ...
    def GetSizes(self) -> vtkDataArray: ...
    def GetTargetLabelCount(self) -> int: ...
    def GetTextProperty(self) -> vtkTextProperty: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkLabelHierarchy: ...
    def NewIterator(self, type:int, ren:vtkRenderer, cam:vtkCamera, frustumPlanes:[float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float], positionsAsNormals:bool, bucketSize:[float, float]) -> vtkLabelHierarchyIterator: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLabelHierarchy: ...
    def SetBoundedSizes(self, arr:vtkDataArray) -> None: ...
    def SetIconIndices(self, arr:vtkIntArray) -> None: ...
    def SetLabels(self, arr:vtkAbstractArray) -> None: ...
    def SetMaximumDepth(self, _arg:int) -> None: ...
    def SetOrientations(self, arr:vtkDataArray) -> None: ...
    def SetPoints(self, __a:vtkPoints) -> None: ...
    def SetPriorities(self, arr:vtkDataArray) -> None: ...
    def SetSizes(self, arr:vtkDataArray) -> None: ...
    def SetTargetLabelCount(self, _arg:int) -> None: ...
    def SetTextProperty(self, tprop:vtkTextProperty) -> None: ...

class vtkLabelHierarchyAlgorithm(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    @overload
    def AddInputData(self, __a:vtkDataObject) -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:vtkDataObject) -> None: ...
    @overload
    def GetInput(self) -> vtkDataObject: ...
    @overload
    def GetInput(self, port:int) -> vtkDataObject: ...
    def GetLabelHierarchyInput(self, port:int) -> vtkLabelHierarchy: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> vtkLabelHierarchy: ...
    @overload
    def GetOutput(self, __a:int) -> vtkLabelHierarchy: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkLabelHierarchyAlgorithm: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLabelHierarchyAlgorithm: ...
    @overload
    def SetInputData(self, __a:vtkDataObject) -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:vtkDataObject) -> None: ...
    def SetOutput(self, d:vtkDataObject) -> None: ...

class vtkLabelHierarchyIterator(vtkmodules.vtkCommonCore.vtkObject):
    def Begin(self, __a:vtkIdTypeArray) -> None: ...
    def BoxAllNodes(self, __a:vtkPolyData) -> None: ...
    def BoxNode(self) -> None: ...
    def GetAllBounds(self) -> int: ...
    def GetBoundedSize(self, sz:[float, float]) -> None: ...
    def GetHierarchy(self) -> vtkLabelHierarchy: ...
    def GetLabel(self) -> str: ...
    def GetLabelId(self) -> int: ...
    def GetNodeGeometry(self, ctr:[float, float, float], size:float) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> float: ...
    def GetPoint(self, x:[float, float, float]) -> None: ...
    def GetSize(self, sz:[float, float]) -> None: ...
    def GetType(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsAtEnd(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkLabelHierarchyIterator: ...
    def Next(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLabelHierarchyIterator: ...
    def SetAllBounds(self, _arg:int) -> None: ...
    def SetTraversedBounds(self, __a:vtkPolyData) -> None: ...

class vtkLabelHierarchyCompositeIterator(vtkLabelHierarchyIterator):
    @overload
    def AddIterator(self, it:vtkLabelHierarchyIterator) -> None: ...
    @overload
    def AddIterator(self, it:vtkLabelHierarchyIterator, count:int) -> None: ...
    def Begin(self, __a:vtkIdTypeArray) -> None: ...
    def BoxAllNodes(self, __a:vtkPolyData) -> None: ...
    def BoxNode(self) -> None: ...
    def ClearIterators(self) -> None: ...
    def GetHierarchy(self) -> vtkLabelHierarchy: ...
    def GetLabelId(self) -> int: ...
    def GetNodeGeometry(self, ctr:[float, float, float], size:float) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsAtEnd(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkLabelHierarchyCompositeIterator: ...
    def Next(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLabelHierarchyCompositeIterator: ...

class vtkLabelPlacementMapper(vtkmodules.vtkRenderingCore.vtkMapper2D):
    class LabelStyle(int): ...
    class LabelShape(int): ...
    FILLED:'LabelStyle'
    NONE:'LabelShape'
    NUMBER_OF_LABEL_SHAPES:'LabelShape'
    NUMBER_OF_LABEL_STYLES:'LabelStyle'
    OUTLINE:'LabelStyle'
    RECT:'LabelShape'
    ROUNDED_RECT:'LabelShape'
    def GeneratePerturbedLabelSpokesOff(self) -> None: ...
    def GeneratePerturbedLabelSpokesOn(self) -> None: ...
    def GetAnchorTransform(self) -> vtkCoordinate: ...
    def GetBackgroundColor(self) -> (float, float, float): ...
    def GetBackgroundOpacity(self) -> float: ...
    def GetBackgroundOpacityMaxValue(self) -> float: ...
    def GetBackgroundOpacityMinValue(self) -> float: ...
    def GetGeneratePerturbedLabelSpokes(self) -> bool: ...
    def GetIteratorType(self) -> int: ...
    def GetMargin(self) -> float: ...
    def GetMaximumLabelFraction(self) -> float: ...
    def GetMaximumLabelFractionMaxValue(self) -> float: ...
    def GetMaximumLabelFractionMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputTraversedBounds(self) -> bool: ...
    def GetPlaceAllLabels(self) -> bool: ...
    def GetPositionsAsNormals(self) -> bool: ...
    def GetRenderStrategy(self) -> vtkLabelRenderStrategy: ...
    def GetShape(self) -> int: ...
    def GetShapeMaxValue(self) -> int: ...
    def GetShapeMinValue(self) -> int: ...
    def GetStyle(self) -> int: ...
    def GetStyleMaxValue(self) -> int: ...
    def GetStyleMinValue(self) -> int: ...
    def GetUseDepthBuffer(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkLabelPlacementMapper: ...
    def OutputTraversedBoundsOff(self) -> None: ...
    def OutputTraversedBoundsOn(self) -> None: ...
    def PlaceAllLabelsOff(self) -> None: ...
    def PlaceAllLabelsOn(self) -> None: ...
    def PositionsAsNormalsOff(self) -> None: ...
    def PositionsAsNormalsOn(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RenderOverlay(self, viewport:vtkViewport, actor:vtkActor2D) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLabelPlacementMapper: ...
    @overload
    def SetBackgroundColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBackgroundColor(self, _arg:(float, float, float)) -> None: ...
    def SetBackgroundOpacity(self, _arg:float) -> None: ...
    def SetGeneratePerturbedLabelSpokes(self, _arg:bool) -> None: ...
    def SetIteratorType(self, _arg:int) -> None: ...
    def SetMargin(self, _arg:float) -> None: ...
    def SetMaximumLabelFraction(self, _arg:float) -> None: ...
    def SetOutputTraversedBounds(self, _arg:bool) -> None: ...
    def SetPlaceAllLabels(self, _arg:bool) -> None: ...
    def SetPositionsAsNormals(self, _arg:bool) -> None: ...
    def SetRenderStrategy(self, s:vtkLabelRenderStrategy) -> None: ...
    def SetShape(self, _arg:int) -> None: ...
    def SetShapeToNone(self) -> None: ...
    def SetShapeToRect(self) -> None: ...
    def SetShapeToRoundedRect(self) -> None: ...
    def SetStyle(self, _arg:int) -> None: ...
    def SetStyleToFilled(self) -> None: ...
    def SetStyleToOutline(self) -> None: ...
    def SetUseDepthBuffer(self, _arg:bool) -> None: ...
    def UseDepthBufferOff(self) -> None: ...
    def UseDepthBufferOn(self) -> None: ...

class vtkLabelPlacer(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class LabelGravity(int): ...
    class OutputCoordinates(int): ...
    BaselineCenter:'LabelGravity'
    BaselineLeft:'LabelGravity'
    BaselineRight:'LabelGravity'
    CenterCenter:'LabelGravity'
    CenterLeft:'LabelGravity'
    CenterRight:'LabelGravity'
    DISPLAY:'OutputCoordinates'
    HorizontalBitMask:'LabelGravity'
    HorizontalCenterBit:'LabelGravity'
    HorizontalLeftBit:'LabelGravity'
    HorizontalRightBit:'LabelGravity'
    LowerCenter:'LabelGravity'
    LowerLeft:'LabelGravity'
    LowerRight:'LabelGravity'
    UpperCenter:'LabelGravity'
    UpperLeft:'LabelGravity'
    UpperRight:'LabelGravity'
    VerticalBaselineBit:'LabelGravity'
    VerticalBitMask:'LabelGravity'
    VerticalBottomBit:'LabelGravity'
    VerticalCenterBit:'LabelGravity'
    VerticalTopBit:'LabelGravity'
    WORLD:'OutputCoordinates'
    def GeneratePerturbedLabelSpokesOff(self) -> None: ...
    def GeneratePerturbedLabelSpokesOn(self) -> None: ...
    def GetAnchorTransform(self) -> vtkCoordinate: ...
    def GetGeneratePerturbedLabelSpokes(self) -> bool: ...
    def GetGravity(self) -> int: ...
    def GetIteratorType(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetMaximumLabelFraction(self) -> float: ...
    def GetMaximumLabelFractionMaxValue(self) -> float: ...
    def GetMaximumLabelFractionMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputCoordinateSystem(self) -> int: ...
    def GetOutputCoordinateSystemMaxValue(self) -> int: ...
    def GetOutputCoordinateSystemMinValue(self) -> int: ...
    def GetOutputTraversedBounds(self) -> bool: ...
    def GetPositionsAsNormals(self) -> bool: ...
    def GetRenderer(self) -> vtkRenderer: ...
    def GetUseDepthBuffer(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkLabelPlacer: ...
    def OutputCoordinateSystemDisplay(self) -> None: ...
    def OutputCoordinateSystemWorld(self) -> None: ...
    def OutputTraversedBoundsOff(self) -> None: ...
    def OutputTraversedBoundsOn(self) -> None: ...
    def PositionsAsNormalsOff(self) -> None: ...
    def PositionsAsNormalsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLabelPlacer: ...
    def SetGeneratePerturbedLabelSpokes(self, _arg:bool) -> None: ...
    def SetGravity(self, gravity:int) -> None: ...
    def SetIteratorType(self, _arg:int) -> None: ...
    def SetMaximumLabelFraction(self, _arg:float) -> None: ...
    def SetOutputCoordinateSystem(self, _arg:int) -> None: ...
    def SetOutputTraversedBounds(self, _arg:bool) -> None: ...
    def SetPositionsAsNormals(self, _arg:bool) -> None: ...
    def SetRenderer(self, __a:vtkRenderer) -> None: ...
    def SetUseDepthBuffer(self, _arg:bool) -> None: ...
    def UseDepthBufferOff(self) -> None: ...
    def UseDepthBufferOn(self) -> None: ...

class vtkLabelSizeCalculator(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    def GetDPI(self) -> int: ...
    def GetFontProperty(self, type:int=0) -> vtkTextProperty: ...
    def GetLabelSizeArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkLabelSizeCalculator: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLabelSizeCalculator: ...
    def SetDPI(self, _arg:int) -> None: ...
    def SetFontProperty(self, fontProp:vtkTextProperty, type:int=0) -> None: ...
    def SetLabelSizeArrayName(self, _arg:str) -> None: ...

class vtkLabeledTreeMapDataMapper(vtkLabeledDataMapper):
    def GetChildMotion(self) -> int: ...
    def GetClipTextMode(self) -> int: ...
    def GetDynamicLevel(self) -> int: ...
    def GetFontSizeRange(self, range:[int, int, int]) -> None: ...
    def GetInputTree(self) -> vtkTree: ...
    def GetLevelRange(self, range:[int, int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkLabeledTreeMapDataMapper: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RenderOpaqueGeometry(self, viewport:vtkViewport, actor:vtkActor2D) -> None: ...
    def RenderOverlay(self, viewport:vtkViewport, actor:vtkActor2D) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLabeledTreeMapDataMapper: ...
    def SetChildMotion(self, _arg:int) -> None: ...
    def SetClipTextMode(self, _arg:int) -> None: ...
    def SetDynamicLevel(self, _arg:int) -> None: ...
    def SetFontSizeRange(self, maxSize:int, minSize:int, delta:int=4) -> None: ...
    def SetLevelRange(self, startLevel:int, endLevel:int) -> None: ...
    def SetRectanglesArrayName(self, name:str) -> None: ...

class vtkPointSetToLabelHierarchy(vtkLabelHierarchyAlgorithm):
    def GetBoundedSizeArrayName(self) -> str: ...
    def GetIconIndexArrayName(self) -> str: ...
    def GetLabelArrayName(self) -> str: ...
    def GetMaximumDepth(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientationArrayName(self) -> str: ...
    def GetPriorityArrayName(self) -> str: ...
    def GetSizeArrayName(self) -> str: ...
    def GetTargetLabelCount(self) -> int: ...
    def GetTextProperty(self) -> vtkTextProperty: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPointSetToLabelHierarchy: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPointSetToLabelHierarchy: ...
    def SetBoundedSizeArrayName(self, name:str) -> None: ...
    def SetIconIndexArrayName(self, name:str) -> None: ...
    def SetLabelArrayName(self, name:str) -> None: ...
    def SetMaximumDepth(self, _arg:int) -> None: ...
    def SetOrientationArrayName(self, name:str) -> None: ...
    def SetPriorityArrayName(self, name:str) -> None: ...
    def SetSizeArrayName(self, name:str) -> None: ...
    def SetTargetLabelCount(self, _arg:int) -> None: ...
    def SetTextProperty(self, tprop:vtkTextProperty) -> None: ...

