"""
    Merge HRIS API

    The unified API for building rich integrations with multiple HR Information System platforms.  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: hello@merge.dev
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from MergePythonSDK.shared.api_client import ApiClient, Endpoint as _Endpoint
from MergePythonSDK.shared.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from MergePythonSDK.hris.model.employee import Employee
from MergePythonSDK.hris.model.employee_endpoint_request import EmployeeEndpointRequest
from MergePythonSDK.hris.model.employee_response import EmployeeResponse
from MergePythonSDK.hris.model.ignore_common_model import IgnoreCommonModel
from MergePythonSDK.hris.model.ignore_common_model_request import IgnoreCommonModelRequest
from MergePythonSDK.hris.model.meta_response import MetaResponse
from MergePythonSDK.shared.model.merge_paginated_response import MergePaginatedResponse


class EmployeesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.employees_create_endpoint = _Endpoint(
            settings={
                'response_type': (EmployeeResponse,),
                'auth': [
                    'accountTokenAuth',
                    'bearerAuth'
                ],
                'endpoint_path': '/hris/v1/employees',
                'operation_id': 'employees_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'employee_endpoint_request',
                    'is_debug_mode',
                    'run_async',
                ],
                'required': [
                    'employee_endpoint_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'employee_endpoint_request':
                        (EmployeeEndpointRequest,),
                    'is_debug_mode':
                        (bool,),
                    'run_async':
                        (bool,),
                },
                'attribute_map': {
                    'is_debug_mode': 'is_debug_mode',
                    'run_async': 'run_async',
                },
                'location_map': {
                    'employee_endpoint_request': 'body',
                    'is_debug_mode': 'query',
                    'run_async': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.employees_ignore_create_endpoint = _Endpoint(
            settings={
                'response_type': (IgnoreCommonModel,),
                'auth': [
                    'accountTokenAuth',
                    'bearerAuth'
                ],
                'endpoint_path': '/hris/v1/employees/ignore/{model_id}',
                'operation_id': 'employees_ignore_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'model_id',
                    'ignore_common_model_request',
                ],
                'required': [
                    'model_id',
                    'ignore_common_model_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'model_id':
                        (str,),
                    'ignore_common_model_request':
                        (IgnoreCommonModelRequest,),
                },
                'attribute_map': {
                    'model_id': 'model_id',
                },
                'location_map': {
                    'model_id': 'path',
                    'ignore_common_model_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.employees_list_endpoint = _Endpoint(
            settings={
                'response_type': (MergePaginatedResponse(Employee),),
                'auth': [
                    'accountTokenAuth',
                    'bearerAuth'
                ],
                'endpoint_path': '/hris/v1/employees',
                'operation_id': 'employees_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'company_id',
                    'created_after',
                    'created_before',
                    'cursor',
                    'display_full_name',
                    'employment_status',
                    'expand',
                    'first_name',
                    'include_deleted_data',
                    'include_remote_data',
                    'include_sensitive_fields',
                    'last_name',
                    'manager_id',
                    'modified_after',
                    'modified_before',
                    'page_size',
                    'pay_group_id',
                    'personal_email',
                    'remote_fields',
                    'remote_id',
                    'team_id',
                    'work_email',
                    'work_location_id',
                ],
                'required': [],
                'nullable': [
                    'display_full_name',
                    'employment_status',
                    'first_name',
                    'last_name',
                    'personal_email',
                    'remote_id',
                    'work_email',
                ],
                'enum': [
                    'employment_status',
                    'expand',
                    'remote_fields',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('employment_status',): {
                        'None': None,
                        "ACTIVE": "ACTIVE",
                        "INACTIVE": "INACTIVE",
                        "PENDING": "PENDING"
                    },
                    ('expand',): {

                        "COMPANY": "company",
                        "COMPANY,PAY_GROUP": "company,pay_group",
                        "EMPLOYMENTS": "employments",
                        "EMPLOYMENTS,COMPANY": "employments,company",
                        "EMPLOYMENTS,COMPANY,PAY_GROUP": "employments,company,pay_group",
                        "EMPLOYMENTS,GROUPS": "employments,groups",
                        "EMPLOYMENTS,GROUPS,COMPANY": "employments,groups,company",
                        "EMPLOYMENTS,GROUPS,COMPANY,PAY_GROUP": "employments,groups,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION": "employments,groups,home_location",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,COMPANY": "employments,groups,home_location,company",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,COMPANY,PAY_GROUP": "employments,groups,home_location,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,MANAGER": "employments,groups,home_location,manager",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,MANAGER,COMPANY": "employments,groups,home_location,manager,company",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,MANAGER,COMPANY,PAY_GROUP": "employments,groups,home_location,manager,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,MANAGER,PAY_GROUP": "employments,groups,home_location,manager,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,MANAGER,TEAM": "employments,groups,home_location,manager,team",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,MANAGER,TEAM,COMPANY": "employments,groups,home_location,manager,team,company",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "employments,groups,home_location,manager,team,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,MANAGER,TEAM,PAY_GROUP": "employments,groups,home_location,manager,team,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,PAY_GROUP": "employments,groups,home_location,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,TEAM": "employments,groups,home_location,team",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,TEAM,COMPANY": "employments,groups,home_location,team,company",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,TEAM,COMPANY,PAY_GROUP": "employments,groups,home_location,team,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,TEAM,PAY_GROUP": "employments,groups,home_location,team,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION": "employments,groups,home_location,work_location",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,COMPANY": "employments,groups,home_location,work_location,company",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,COMPANY,PAY_GROUP": "employments,groups,home_location,work_location,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER": "employments,groups,home_location,work_location,manager",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,COMPANY": "employments,groups,home_location,work_location,manager,company",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,COMPANY,PAY_GROUP": "employments,groups,home_location,work_location,manager,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,PAY_GROUP": "employments,groups,home_location,work_location,manager,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM": "employments,groups,home_location,work_location,manager,team",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,COMPANY": "employments,groups,home_location,work_location,manager,team,company",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "employments,groups,home_location,work_location,manager,team,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,PAY_GROUP": "employments,groups,home_location,work_location,manager,team,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,PAY_GROUP": "employments,groups,home_location,work_location,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,TEAM": "employments,groups,home_location,work_location,team",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,TEAM,COMPANY": "employments,groups,home_location,work_location,team,company",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,TEAM,COMPANY,PAY_GROUP": "employments,groups,home_location,work_location,team,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,TEAM,PAY_GROUP": "employments,groups,home_location,work_location,team,pay_group",
                        "EMPLOYMENTS,GROUPS,MANAGER": "employments,groups,manager",
                        "EMPLOYMENTS,GROUPS,MANAGER,COMPANY": "employments,groups,manager,company",
                        "EMPLOYMENTS,GROUPS,MANAGER,COMPANY,PAY_GROUP": "employments,groups,manager,company,pay_group",
                        "EMPLOYMENTS,GROUPS,MANAGER,PAY_GROUP": "employments,groups,manager,pay_group",
                        "EMPLOYMENTS,GROUPS,MANAGER,TEAM": "employments,groups,manager,team",
                        "EMPLOYMENTS,GROUPS,MANAGER,TEAM,COMPANY": "employments,groups,manager,team,company",
                        "EMPLOYMENTS,GROUPS,MANAGER,TEAM,COMPANY,PAY_GROUP": "employments,groups,manager,team,company,pay_group",
                        "EMPLOYMENTS,GROUPS,MANAGER,TEAM,PAY_GROUP": "employments,groups,manager,team,pay_group",
                        "EMPLOYMENTS,GROUPS,PAY_GROUP": "employments,groups,pay_group",
                        "EMPLOYMENTS,GROUPS,TEAM": "employments,groups,team",
                        "EMPLOYMENTS,GROUPS,TEAM,COMPANY": "employments,groups,team,company",
                        "EMPLOYMENTS,GROUPS,TEAM,COMPANY,PAY_GROUP": "employments,groups,team,company,pay_group",
                        "EMPLOYMENTS,GROUPS,TEAM,PAY_GROUP": "employments,groups,team,pay_group",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION": "employments,groups,work_location",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,COMPANY": "employments,groups,work_location,company",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,COMPANY,PAY_GROUP": "employments,groups,work_location,company,pay_group",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,MANAGER": "employments,groups,work_location,manager",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,MANAGER,COMPANY": "employments,groups,work_location,manager,company",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,MANAGER,COMPANY,PAY_GROUP": "employments,groups,work_location,manager,company,pay_group",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,MANAGER,PAY_GROUP": "employments,groups,work_location,manager,pay_group",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,MANAGER,TEAM": "employments,groups,work_location,manager,team",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,MANAGER,TEAM,COMPANY": "employments,groups,work_location,manager,team,company",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "employments,groups,work_location,manager,team,company,pay_group",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,MANAGER,TEAM,PAY_GROUP": "employments,groups,work_location,manager,team,pay_group",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,PAY_GROUP": "employments,groups,work_location,pay_group",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,TEAM": "employments,groups,work_location,team",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,TEAM,COMPANY": "employments,groups,work_location,team,company",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,TEAM,COMPANY,PAY_GROUP": "employments,groups,work_location,team,company,pay_group",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,TEAM,PAY_GROUP": "employments,groups,work_location,team,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION": "employments,home_location",
                        "EMPLOYMENTS,HOME_LOCATION,COMPANY": "employments,home_location,company",
                        "EMPLOYMENTS,HOME_LOCATION,COMPANY,PAY_GROUP": "employments,home_location,company,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,MANAGER": "employments,home_location,manager",
                        "EMPLOYMENTS,HOME_LOCATION,MANAGER,COMPANY": "employments,home_location,manager,company",
                        "EMPLOYMENTS,HOME_LOCATION,MANAGER,COMPANY,PAY_GROUP": "employments,home_location,manager,company,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,MANAGER,PAY_GROUP": "employments,home_location,manager,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,MANAGER,TEAM": "employments,home_location,manager,team",
                        "EMPLOYMENTS,HOME_LOCATION,MANAGER,TEAM,COMPANY": "employments,home_location,manager,team,company",
                        "EMPLOYMENTS,HOME_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "employments,home_location,manager,team,company,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,MANAGER,TEAM,PAY_GROUP": "employments,home_location,manager,team,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,PAY_GROUP": "employments,home_location,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,TEAM": "employments,home_location,team",
                        "EMPLOYMENTS,HOME_LOCATION,TEAM,COMPANY": "employments,home_location,team,company",
                        "EMPLOYMENTS,HOME_LOCATION,TEAM,COMPANY,PAY_GROUP": "employments,home_location,team,company,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,TEAM,PAY_GROUP": "employments,home_location,team,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION": "employments,home_location,work_location",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,COMPANY": "employments,home_location,work_location,company",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,COMPANY,PAY_GROUP": "employments,home_location,work_location,company,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,MANAGER": "employments,home_location,work_location,manager",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,MANAGER,COMPANY": "employments,home_location,work_location,manager,company",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,MANAGER,COMPANY,PAY_GROUP": "employments,home_location,work_location,manager,company,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,MANAGER,PAY_GROUP": "employments,home_location,work_location,manager,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM": "employments,home_location,work_location,manager,team",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,COMPANY": "employments,home_location,work_location,manager,team,company",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "employments,home_location,work_location,manager,team,company,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,PAY_GROUP": "employments,home_location,work_location,manager,team,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,PAY_GROUP": "employments,home_location,work_location,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,TEAM": "employments,home_location,work_location,team",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,TEAM,COMPANY": "employments,home_location,work_location,team,company",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,TEAM,COMPANY,PAY_GROUP": "employments,home_location,work_location,team,company,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,TEAM,PAY_GROUP": "employments,home_location,work_location,team,pay_group",
                        "EMPLOYMENTS,MANAGER": "employments,manager",
                        "EMPLOYMENTS,MANAGER,COMPANY": "employments,manager,company",
                        "EMPLOYMENTS,MANAGER,COMPANY,PAY_GROUP": "employments,manager,company,pay_group",
                        "EMPLOYMENTS,MANAGER,PAY_GROUP": "employments,manager,pay_group",
                        "EMPLOYMENTS,MANAGER,TEAM": "employments,manager,team",
                        "EMPLOYMENTS,MANAGER,TEAM,COMPANY": "employments,manager,team,company",
                        "EMPLOYMENTS,MANAGER,TEAM,COMPANY,PAY_GROUP": "employments,manager,team,company,pay_group",
                        "EMPLOYMENTS,MANAGER,TEAM,PAY_GROUP": "employments,manager,team,pay_group",
                        "EMPLOYMENTS,PAY_GROUP": "employments,pay_group",
                        "EMPLOYMENTS,TEAM": "employments,team",
                        "EMPLOYMENTS,TEAM,COMPANY": "employments,team,company",
                        "EMPLOYMENTS,TEAM,COMPANY,PAY_GROUP": "employments,team,company,pay_group",
                        "EMPLOYMENTS,TEAM,PAY_GROUP": "employments,team,pay_group",
                        "EMPLOYMENTS,WORK_LOCATION": "employments,work_location",
                        "EMPLOYMENTS,WORK_LOCATION,COMPANY": "employments,work_location,company",
                        "EMPLOYMENTS,WORK_LOCATION,COMPANY,PAY_GROUP": "employments,work_location,company,pay_group",
                        "EMPLOYMENTS,WORK_LOCATION,MANAGER": "employments,work_location,manager",
                        "EMPLOYMENTS,WORK_LOCATION,MANAGER,COMPANY": "employments,work_location,manager,company",
                        "EMPLOYMENTS,WORK_LOCATION,MANAGER,COMPANY,PAY_GROUP": "employments,work_location,manager,company,pay_group",
                        "EMPLOYMENTS,WORK_LOCATION,MANAGER,PAY_GROUP": "employments,work_location,manager,pay_group",
                        "EMPLOYMENTS,WORK_LOCATION,MANAGER,TEAM": "employments,work_location,manager,team",
                        "EMPLOYMENTS,WORK_LOCATION,MANAGER,TEAM,COMPANY": "employments,work_location,manager,team,company",
                        "EMPLOYMENTS,WORK_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "employments,work_location,manager,team,company,pay_group",
                        "EMPLOYMENTS,WORK_LOCATION,MANAGER,TEAM,PAY_GROUP": "employments,work_location,manager,team,pay_group",
                        "EMPLOYMENTS,WORK_LOCATION,PAY_GROUP": "employments,work_location,pay_group",
                        "EMPLOYMENTS,WORK_LOCATION,TEAM": "employments,work_location,team",
                        "EMPLOYMENTS,WORK_LOCATION,TEAM,COMPANY": "employments,work_location,team,company",
                        "EMPLOYMENTS,WORK_LOCATION,TEAM,COMPANY,PAY_GROUP": "employments,work_location,team,company,pay_group",
                        "EMPLOYMENTS,WORK_LOCATION,TEAM,PAY_GROUP": "employments,work_location,team,pay_group",
                        "GROUPS": "groups",
                        "GROUPS,COMPANY": "groups,company",
                        "GROUPS,COMPANY,PAY_GROUP": "groups,company,pay_group",
                        "GROUPS,HOME_LOCATION": "groups,home_location",
                        "GROUPS,HOME_LOCATION,COMPANY": "groups,home_location,company",
                        "GROUPS,HOME_LOCATION,COMPANY,PAY_GROUP": "groups,home_location,company,pay_group",
                        "GROUPS,HOME_LOCATION,MANAGER": "groups,home_location,manager",
                        "GROUPS,HOME_LOCATION,MANAGER,COMPANY": "groups,home_location,manager,company",
                        "GROUPS,HOME_LOCATION,MANAGER,COMPANY,PAY_GROUP": "groups,home_location,manager,company,pay_group",
                        "GROUPS,HOME_LOCATION,MANAGER,PAY_GROUP": "groups,home_location,manager,pay_group",
                        "GROUPS,HOME_LOCATION,MANAGER,TEAM": "groups,home_location,manager,team",
                        "GROUPS,HOME_LOCATION,MANAGER,TEAM,COMPANY": "groups,home_location,manager,team,company",
                        "GROUPS,HOME_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "groups,home_location,manager,team,company,pay_group",
                        "GROUPS,HOME_LOCATION,MANAGER,TEAM,PAY_GROUP": "groups,home_location,manager,team,pay_group",
                        "GROUPS,HOME_LOCATION,PAY_GROUP": "groups,home_location,pay_group",
                        "GROUPS,HOME_LOCATION,TEAM": "groups,home_location,team",
                        "GROUPS,HOME_LOCATION,TEAM,COMPANY": "groups,home_location,team,company",
                        "GROUPS,HOME_LOCATION,TEAM,COMPANY,PAY_GROUP": "groups,home_location,team,company,pay_group",
                        "GROUPS,HOME_LOCATION,TEAM,PAY_GROUP": "groups,home_location,team,pay_group",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION": "groups,home_location,work_location",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,COMPANY": "groups,home_location,work_location,company",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,COMPANY,PAY_GROUP": "groups,home_location,work_location,company,pay_group",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER": "groups,home_location,work_location,manager",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,COMPANY": "groups,home_location,work_location,manager,company",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,COMPANY,PAY_GROUP": "groups,home_location,work_location,manager,company,pay_group",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,PAY_GROUP": "groups,home_location,work_location,manager,pay_group",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM": "groups,home_location,work_location,manager,team",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,COMPANY": "groups,home_location,work_location,manager,team,company",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "groups,home_location,work_location,manager,team,company,pay_group",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,PAY_GROUP": "groups,home_location,work_location,manager,team,pay_group",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,PAY_GROUP": "groups,home_location,work_location,pay_group",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,TEAM": "groups,home_location,work_location,team",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,TEAM,COMPANY": "groups,home_location,work_location,team,company",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,TEAM,COMPANY,PAY_GROUP": "groups,home_location,work_location,team,company,pay_group",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,TEAM,PAY_GROUP": "groups,home_location,work_location,team,pay_group",
                        "GROUPS,MANAGER": "groups,manager",
                        "GROUPS,MANAGER,COMPANY": "groups,manager,company",
                        "GROUPS,MANAGER,COMPANY,PAY_GROUP": "groups,manager,company,pay_group",
                        "GROUPS,MANAGER,PAY_GROUP": "groups,manager,pay_group",
                        "GROUPS,MANAGER,TEAM": "groups,manager,team",
                        "GROUPS,MANAGER,TEAM,COMPANY": "groups,manager,team,company",
                        "GROUPS,MANAGER,TEAM,COMPANY,PAY_GROUP": "groups,manager,team,company,pay_group",
                        "GROUPS,MANAGER,TEAM,PAY_GROUP": "groups,manager,team,pay_group",
                        "GROUPS,PAY_GROUP": "groups,pay_group",
                        "GROUPS,TEAM": "groups,team",
                        "GROUPS,TEAM,COMPANY": "groups,team,company",
                        "GROUPS,TEAM,COMPANY,PAY_GROUP": "groups,team,company,pay_group",
                        "GROUPS,TEAM,PAY_GROUP": "groups,team,pay_group",
                        "GROUPS,WORK_LOCATION": "groups,work_location",
                        "GROUPS,WORK_LOCATION,COMPANY": "groups,work_location,company",
                        "GROUPS,WORK_LOCATION,COMPANY,PAY_GROUP": "groups,work_location,company,pay_group",
                        "GROUPS,WORK_LOCATION,MANAGER": "groups,work_location,manager",
                        "GROUPS,WORK_LOCATION,MANAGER,COMPANY": "groups,work_location,manager,company",
                        "GROUPS,WORK_LOCATION,MANAGER,COMPANY,PAY_GROUP": "groups,work_location,manager,company,pay_group",
                        "GROUPS,WORK_LOCATION,MANAGER,PAY_GROUP": "groups,work_location,manager,pay_group",
                        "GROUPS,WORK_LOCATION,MANAGER,TEAM": "groups,work_location,manager,team",
                        "GROUPS,WORK_LOCATION,MANAGER,TEAM,COMPANY": "groups,work_location,manager,team,company",
                        "GROUPS,WORK_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "groups,work_location,manager,team,company,pay_group",
                        "GROUPS,WORK_LOCATION,MANAGER,TEAM,PAY_GROUP": "groups,work_location,manager,team,pay_group",
                        "GROUPS,WORK_LOCATION,PAY_GROUP": "groups,work_location,pay_group",
                        "GROUPS,WORK_LOCATION,TEAM": "groups,work_location,team",
                        "GROUPS,WORK_LOCATION,TEAM,COMPANY": "groups,work_location,team,company",
                        "GROUPS,WORK_LOCATION,TEAM,COMPANY,PAY_GROUP": "groups,work_location,team,company,pay_group",
                        "GROUPS,WORK_LOCATION,TEAM,PAY_GROUP": "groups,work_location,team,pay_group",
                        "HOME_LOCATION": "home_location",
                        "HOME_LOCATION,COMPANY": "home_location,company",
                        "HOME_LOCATION,COMPANY,PAY_GROUP": "home_location,company,pay_group",
                        "HOME_LOCATION,MANAGER": "home_location,manager",
                        "HOME_LOCATION,MANAGER,COMPANY": "home_location,manager,company",
                        "HOME_LOCATION,MANAGER,COMPANY,PAY_GROUP": "home_location,manager,company,pay_group",
                        "HOME_LOCATION,MANAGER,PAY_GROUP": "home_location,manager,pay_group",
                        "HOME_LOCATION,MANAGER,TEAM": "home_location,manager,team",
                        "HOME_LOCATION,MANAGER,TEAM,COMPANY": "home_location,manager,team,company",
                        "HOME_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "home_location,manager,team,company,pay_group",
                        "HOME_LOCATION,MANAGER,TEAM,PAY_GROUP": "home_location,manager,team,pay_group",
                        "HOME_LOCATION,PAY_GROUP": "home_location,pay_group",
                        "HOME_LOCATION,TEAM": "home_location,team",
                        "HOME_LOCATION,TEAM,COMPANY": "home_location,team,company",
                        "HOME_LOCATION,TEAM,COMPANY,PAY_GROUP": "home_location,team,company,pay_group",
                        "HOME_LOCATION,TEAM,PAY_GROUP": "home_location,team,pay_group",
                        "HOME_LOCATION,WORK_LOCATION": "home_location,work_location",
                        "HOME_LOCATION,WORK_LOCATION,COMPANY": "home_location,work_location,company",
                        "HOME_LOCATION,WORK_LOCATION,COMPANY,PAY_GROUP": "home_location,work_location,company,pay_group",
                        "HOME_LOCATION,WORK_LOCATION,MANAGER": "home_location,work_location,manager",
                        "HOME_LOCATION,WORK_LOCATION,MANAGER,COMPANY": "home_location,work_location,manager,company",
                        "HOME_LOCATION,WORK_LOCATION,MANAGER,COMPANY,PAY_GROUP": "home_location,work_location,manager,company,pay_group",
                        "HOME_LOCATION,WORK_LOCATION,MANAGER,PAY_GROUP": "home_location,work_location,manager,pay_group",
                        "HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM": "home_location,work_location,manager,team",
                        "HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,COMPANY": "home_location,work_location,manager,team,company",
                        "HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "home_location,work_location,manager,team,company,pay_group",
                        "HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,PAY_GROUP": "home_location,work_location,manager,team,pay_group",
                        "HOME_LOCATION,WORK_LOCATION,PAY_GROUP": "home_location,work_location,pay_group",
                        "HOME_LOCATION,WORK_LOCATION,TEAM": "home_location,work_location,team",
                        "HOME_LOCATION,WORK_LOCATION,TEAM,COMPANY": "home_location,work_location,team,company",
                        "HOME_LOCATION,WORK_LOCATION,TEAM,COMPANY,PAY_GROUP": "home_location,work_location,team,company,pay_group",
                        "HOME_LOCATION,WORK_LOCATION,TEAM,PAY_GROUP": "home_location,work_location,team,pay_group",
                        "MANAGER": "manager",
                        "MANAGER,COMPANY": "manager,company",
                        "MANAGER,COMPANY,PAY_GROUP": "manager,company,pay_group",
                        "MANAGER,PAY_GROUP": "manager,pay_group",
                        "MANAGER,TEAM": "manager,team",
                        "MANAGER,TEAM,COMPANY": "manager,team,company",
                        "MANAGER,TEAM,COMPANY,PAY_GROUP": "manager,team,company,pay_group",
                        "MANAGER,TEAM,PAY_GROUP": "manager,team,pay_group",
                        "PAY_GROUP": "pay_group",
                        "TEAM": "team",
                        "TEAM,COMPANY": "team,company",
                        "TEAM,COMPANY,PAY_GROUP": "team,company,pay_group",
                        "TEAM,PAY_GROUP": "team,pay_group",
                        "WORK_LOCATION": "work_location",
                        "WORK_LOCATION,COMPANY": "work_location,company",
                        "WORK_LOCATION,COMPANY,PAY_GROUP": "work_location,company,pay_group",
                        "WORK_LOCATION,MANAGER": "work_location,manager",
                        "WORK_LOCATION,MANAGER,COMPANY": "work_location,manager,company",
                        "WORK_LOCATION,MANAGER,COMPANY,PAY_GROUP": "work_location,manager,company,pay_group",
                        "WORK_LOCATION,MANAGER,PAY_GROUP": "work_location,manager,pay_group",
                        "WORK_LOCATION,MANAGER,TEAM": "work_location,manager,team",
                        "WORK_LOCATION,MANAGER,TEAM,COMPANY": "work_location,manager,team,company",
                        "WORK_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "work_location,manager,team,company,pay_group",
                        "WORK_LOCATION,MANAGER,TEAM,PAY_GROUP": "work_location,manager,team,pay_group",
                        "WORK_LOCATION,PAY_GROUP": "work_location,pay_group",
                        "WORK_LOCATION,TEAM": "work_location,team",
                        "WORK_LOCATION,TEAM,COMPANY": "work_location,team,company",
                        "WORK_LOCATION,TEAM,COMPANY,PAY_GROUP": "work_location,team,company,pay_group",
                        "WORK_LOCATION,TEAM,PAY_GROUP": "work_location,team,pay_group"
                    },
                    ('remote_fields',): {

                        "EMPLOYMENT_STATUS": "employment_status",
                        "EMPLOYMENT_STATUS,ETHNICITY": "employment_status,ethnicity",
                        "EMPLOYMENT_STATUS,ETHNICITY,GENDER": "employment_status,ethnicity,gender",
                        "EMPLOYMENT_STATUS,ETHNICITY,GENDER,MARITAL_STATUS": "employment_status,ethnicity,gender,marital_status",
                        "EMPLOYMENT_STATUS,ETHNICITY,MARITAL_STATUS": "employment_status,ethnicity,marital_status",
                        "EMPLOYMENT_STATUS,GENDER": "employment_status,gender",
                        "EMPLOYMENT_STATUS,GENDER,MARITAL_STATUS": "employment_status,gender,marital_status",
                        "EMPLOYMENT_STATUS,MARITAL_STATUS": "employment_status,marital_status",
                        "ETHNICITY": "ethnicity",
                        "ETHNICITY,GENDER": "ethnicity,gender",
                        "ETHNICITY,GENDER,MARITAL_STATUS": "ethnicity,gender,marital_status",
                        "ETHNICITY,MARITAL_STATUS": "ethnicity,marital_status",
                        "GENDER": "gender",
                        "GENDER,MARITAL_STATUS": "gender,marital_status",
                        "MARITAL_STATUS": "marital_status"
                    },
                },
                'openapi_types': {
                    'company_id':
                        (str,),
                    'created_after':
                        (datetime,),
                    'created_before':
                        (datetime,),
                    'cursor':
                        (str,),
                    'display_full_name':
                        (str, none_type,),
                    'employment_status':
                        (str, none_type,),
                    'expand':
                        (str,),
                    'first_name':
                        (str, none_type,),
                    'include_deleted_data':
                        (bool,),
                    'include_remote_data':
                        (bool,),
                    'include_sensitive_fields':
                        (bool,),
                    'last_name':
                        (str, none_type,),
                    'manager_id':
                        (str,),
                    'modified_after':
                        (datetime,),
                    'modified_before':
                        (datetime,),
                    'page_size':
                        (int,),
                    'pay_group_id':
                        (str,),
                    'personal_email':
                        (str, none_type,),
                    'remote_fields':
                        (str,),
                    'remote_id':
                        (str, none_type,),
                    'team_id':
                        (str,),
                    'work_email':
                        (str, none_type,),
                    'work_location_id':
                        (str,),
                },
                'attribute_map': {
                    'company_id': 'company_id',
                    'created_after': 'created_after',
                    'created_before': 'created_before',
                    'cursor': 'cursor',
                    'display_full_name': 'display_full_name',
                    'employment_status': 'employment_status',
                    'expand': 'expand',
                    'first_name': 'first_name',
                    'include_deleted_data': 'include_deleted_data',
                    'include_remote_data': 'include_remote_data',
                    'include_sensitive_fields': 'include_sensitive_fields',
                    'last_name': 'last_name',
                    'manager_id': 'manager_id',
                    'modified_after': 'modified_after',
                    'modified_before': 'modified_before',
                    'page_size': 'page_size',
                    'pay_group_id': 'pay_group_id',
                    'personal_email': 'personal_email',
                    'remote_fields': 'remote_fields',
                    'remote_id': 'remote_id',
                    'team_id': 'team_id',
                    'work_email': 'work_email',
                    'work_location_id': 'work_location_id',
                },
                'location_map': {
                    'company_id': 'query',
                    'created_after': 'query',
                    'created_before': 'query',
                    'cursor': 'query',
                    'display_full_name': 'query',
                    'employment_status': 'query',
                    'expand': 'query',
                    'first_name': 'query',
                    'include_deleted_data': 'query',
                    'include_remote_data': 'query',
                    'include_sensitive_fields': 'query',
                    'last_name': 'query',
                    'manager_id': 'query',
                    'modified_after': 'query',
                    'modified_before': 'query',
                    'page_size': 'query',
                    'pay_group_id': 'query',
                    'personal_email': 'query',
                    'remote_fields': 'query',
                    'remote_id': 'query',
                    'team_id': 'query',
                    'work_email': 'query',
                    'work_location_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.employees_meta_post_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (MetaResponse,),
                'auth': [
                    'accountTokenAuth',
                    'bearerAuth'
                ],
                'endpoint_path': '/hris/v1/employees/meta/post',
                'operation_id': 'employees_meta_post_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.employees_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (Employee,),
                'auth': [
                    'accountTokenAuth',
                    'bearerAuth'
                ],
                'endpoint_path': '/hris/v1/employees/{id}',
                'operation_id': 'employees_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'expand',
                    'include_remote_data',
                    'include_sensitive_fields',
                    'remote_fields',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'expand',
                    'remote_fields',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('expand',): {

                        "COMPANY": "company",
                        "COMPANY,PAY_GROUP": "company,pay_group",
                        "EMPLOYMENTS": "employments",
                        "EMPLOYMENTS,COMPANY": "employments,company",
                        "EMPLOYMENTS,COMPANY,PAY_GROUP": "employments,company,pay_group",
                        "EMPLOYMENTS,GROUPS": "employments,groups",
                        "EMPLOYMENTS,GROUPS,COMPANY": "employments,groups,company",
                        "EMPLOYMENTS,GROUPS,COMPANY,PAY_GROUP": "employments,groups,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION": "employments,groups,home_location",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,COMPANY": "employments,groups,home_location,company",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,COMPANY,PAY_GROUP": "employments,groups,home_location,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,MANAGER": "employments,groups,home_location,manager",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,MANAGER,COMPANY": "employments,groups,home_location,manager,company",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,MANAGER,COMPANY,PAY_GROUP": "employments,groups,home_location,manager,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,MANAGER,PAY_GROUP": "employments,groups,home_location,manager,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,MANAGER,TEAM": "employments,groups,home_location,manager,team",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,MANAGER,TEAM,COMPANY": "employments,groups,home_location,manager,team,company",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "employments,groups,home_location,manager,team,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,MANAGER,TEAM,PAY_GROUP": "employments,groups,home_location,manager,team,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,PAY_GROUP": "employments,groups,home_location,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,TEAM": "employments,groups,home_location,team",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,TEAM,COMPANY": "employments,groups,home_location,team,company",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,TEAM,COMPANY,PAY_GROUP": "employments,groups,home_location,team,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,TEAM,PAY_GROUP": "employments,groups,home_location,team,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION": "employments,groups,home_location,work_location",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,COMPANY": "employments,groups,home_location,work_location,company",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,COMPANY,PAY_GROUP": "employments,groups,home_location,work_location,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER": "employments,groups,home_location,work_location,manager",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,COMPANY": "employments,groups,home_location,work_location,manager,company",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,COMPANY,PAY_GROUP": "employments,groups,home_location,work_location,manager,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,PAY_GROUP": "employments,groups,home_location,work_location,manager,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM": "employments,groups,home_location,work_location,manager,team",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,COMPANY": "employments,groups,home_location,work_location,manager,team,company",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "employments,groups,home_location,work_location,manager,team,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,PAY_GROUP": "employments,groups,home_location,work_location,manager,team,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,PAY_GROUP": "employments,groups,home_location,work_location,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,TEAM": "employments,groups,home_location,work_location,team",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,TEAM,COMPANY": "employments,groups,home_location,work_location,team,company",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,TEAM,COMPANY,PAY_GROUP": "employments,groups,home_location,work_location,team,company,pay_group",
                        "EMPLOYMENTS,GROUPS,HOME_LOCATION,WORK_LOCATION,TEAM,PAY_GROUP": "employments,groups,home_location,work_location,team,pay_group",
                        "EMPLOYMENTS,GROUPS,MANAGER": "employments,groups,manager",
                        "EMPLOYMENTS,GROUPS,MANAGER,COMPANY": "employments,groups,manager,company",
                        "EMPLOYMENTS,GROUPS,MANAGER,COMPANY,PAY_GROUP": "employments,groups,manager,company,pay_group",
                        "EMPLOYMENTS,GROUPS,MANAGER,PAY_GROUP": "employments,groups,manager,pay_group",
                        "EMPLOYMENTS,GROUPS,MANAGER,TEAM": "employments,groups,manager,team",
                        "EMPLOYMENTS,GROUPS,MANAGER,TEAM,COMPANY": "employments,groups,manager,team,company",
                        "EMPLOYMENTS,GROUPS,MANAGER,TEAM,COMPANY,PAY_GROUP": "employments,groups,manager,team,company,pay_group",
                        "EMPLOYMENTS,GROUPS,MANAGER,TEAM,PAY_GROUP": "employments,groups,manager,team,pay_group",
                        "EMPLOYMENTS,GROUPS,PAY_GROUP": "employments,groups,pay_group",
                        "EMPLOYMENTS,GROUPS,TEAM": "employments,groups,team",
                        "EMPLOYMENTS,GROUPS,TEAM,COMPANY": "employments,groups,team,company",
                        "EMPLOYMENTS,GROUPS,TEAM,COMPANY,PAY_GROUP": "employments,groups,team,company,pay_group",
                        "EMPLOYMENTS,GROUPS,TEAM,PAY_GROUP": "employments,groups,team,pay_group",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION": "employments,groups,work_location",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,COMPANY": "employments,groups,work_location,company",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,COMPANY,PAY_GROUP": "employments,groups,work_location,company,pay_group",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,MANAGER": "employments,groups,work_location,manager",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,MANAGER,COMPANY": "employments,groups,work_location,manager,company",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,MANAGER,COMPANY,PAY_GROUP": "employments,groups,work_location,manager,company,pay_group",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,MANAGER,PAY_GROUP": "employments,groups,work_location,manager,pay_group",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,MANAGER,TEAM": "employments,groups,work_location,manager,team",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,MANAGER,TEAM,COMPANY": "employments,groups,work_location,manager,team,company",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "employments,groups,work_location,manager,team,company,pay_group",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,MANAGER,TEAM,PAY_GROUP": "employments,groups,work_location,manager,team,pay_group",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,PAY_GROUP": "employments,groups,work_location,pay_group",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,TEAM": "employments,groups,work_location,team",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,TEAM,COMPANY": "employments,groups,work_location,team,company",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,TEAM,COMPANY,PAY_GROUP": "employments,groups,work_location,team,company,pay_group",
                        "EMPLOYMENTS,GROUPS,WORK_LOCATION,TEAM,PAY_GROUP": "employments,groups,work_location,team,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION": "employments,home_location",
                        "EMPLOYMENTS,HOME_LOCATION,COMPANY": "employments,home_location,company",
                        "EMPLOYMENTS,HOME_LOCATION,COMPANY,PAY_GROUP": "employments,home_location,company,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,MANAGER": "employments,home_location,manager",
                        "EMPLOYMENTS,HOME_LOCATION,MANAGER,COMPANY": "employments,home_location,manager,company",
                        "EMPLOYMENTS,HOME_LOCATION,MANAGER,COMPANY,PAY_GROUP": "employments,home_location,manager,company,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,MANAGER,PAY_GROUP": "employments,home_location,manager,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,MANAGER,TEAM": "employments,home_location,manager,team",
                        "EMPLOYMENTS,HOME_LOCATION,MANAGER,TEAM,COMPANY": "employments,home_location,manager,team,company",
                        "EMPLOYMENTS,HOME_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "employments,home_location,manager,team,company,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,MANAGER,TEAM,PAY_GROUP": "employments,home_location,manager,team,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,PAY_GROUP": "employments,home_location,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,TEAM": "employments,home_location,team",
                        "EMPLOYMENTS,HOME_LOCATION,TEAM,COMPANY": "employments,home_location,team,company",
                        "EMPLOYMENTS,HOME_LOCATION,TEAM,COMPANY,PAY_GROUP": "employments,home_location,team,company,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,TEAM,PAY_GROUP": "employments,home_location,team,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION": "employments,home_location,work_location",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,COMPANY": "employments,home_location,work_location,company",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,COMPANY,PAY_GROUP": "employments,home_location,work_location,company,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,MANAGER": "employments,home_location,work_location,manager",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,MANAGER,COMPANY": "employments,home_location,work_location,manager,company",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,MANAGER,COMPANY,PAY_GROUP": "employments,home_location,work_location,manager,company,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,MANAGER,PAY_GROUP": "employments,home_location,work_location,manager,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM": "employments,home_location,work_location,manager,team",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,COMPANY": "employments,home_location,work_location,manager,team,company",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "employments,home_location,work_location,manager,team,company,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,PAY_GROUP": "employments,home_location,work_location,manager,team,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,PAY_GROUP": "employments,home_location,work_location,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,TEAM": "employments,home_location,work_location,team",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,TEAM,COMPANY": "employments,home_location,work_location,team,company",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,TEAM,COMPANY,PAY_GROUP": "employments,home_location,work_location,team,company,pay_group",
                        "EMPLOYMENTS,HOME_LOCATION,WORK_LOCATION,TEAM,PAY_GROUP": "employments,home_location,work_location,team,pay_group",
                        "EMPLOYMENTS,MANAGER": "employments,manager",
                        "EMPLOYMENTS,MANAGER,COMPANY": "employments,manager,company",
                        "EMPLOYMENTS,MANAGER,COMPANY,PAY_GROUP": "employments,manager,company,pay_group",
                        "EMPLOYMENTS,MANAGER,PAY_GROUP": "employments,manager,pay_group",
                        "EMPLOYMENTS,MANAGER,TEAM": "employments,manager,team",
                        "EMPLOYMENTS,MANAGER,TEAM,COMPANY": "employments,manager,team,company",
                        "EMPLOYMENTS,MANAGER,TEAM,COMPANY,PAY_GROUP": "employments,manager,team,company,pay_group",
                        "EMPLOYMENTS,MANAGER,TEAM,PAY_GROUP": "employments,manager,team,pay_group",
                        "EMPLOYMENTS,PAY_GROUP": "employments,pay_group",
                        "EMPLOYMENTS,TEAM": "employments,team",
                        "EMPLOYMENTS,TEAM,COMPANY": "employments,team,company",
                        "EMPLOYMENTS,TEAM,COMPANY,PAY_GROUP": "employments,team,company,pay_group",
                        "EMPLOYMENTS,TEAM,PAY_GROUP": "employments,team,pay_group",
                        "EMPLOYMENTS,WORK_LOCATION": "employments,work_location",
                        "EMPLOYMENTS,WORK_LOCATION,COMPANY": "employments,work_location,company",
                        "EMPLOYMENTS,WORK_LOCATION,COMPANY,PAY_GROUP": "employments,work_location,company,pay_group",
                        "EMPLOYMENTS,WORK_LOCATION,MANAGER": "employments,work_location,manager",
                        "EMPLOYMENTS,WORK_LOCATION,MANAGER,COMPANY": "employments,work_location,manager,company",
                        "EMPLOYMENTS,WORK_LOCATION,MANAGER,COMPANY,PAY_GROUP": "employments,work_location,manager,company,pay_group",
                        "EMPLOYMENTS,WORK_LOCATION,MANAGER,PAY_GROUP": "employments,work_location,manager,pay_group",
                        "EMPLOYMENTS,WORK_LOCATION,MANAGER,TEAM": "employments,work_location,manager,team",
                        "EMPLOYMENTS,WORK_LOCATION,MANAGER,TEAM,COMPANY": "employments,work_location,manager,team,company",
                        "EMPLOYMENTS,WORK_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "employments,work_location,manager,team,company,pay_group",
                        "EMPLOYMENTS,WORK_LOCATION,MANAGER,TEAM,PAY_GROUP": "employments,work_location,manager,team,pay_group",
                        "EMPLOYMENTS,WORK_LOCATION,PAY_GROUP": "employments,work_location,pay_group",
                        "EMPLOYMENTS,WORK_LOCATION,TEAM": "employments,work_location,team",
                        "EMPLOYMENTS,WORK_LOCATION,TEAM,COMPANY": "employments,work_location,team,company",
                        "EMPLOYMENTS,WORK_LOCATION,TEAM,COMPANY,PAY_GROUP": "employments,work_location,team,company,pay_group",
                        "EMPLOYMENTS,WORK_LOCATION,TEAM,PAY_GROUP": "employments,work_location,team,pay_group",
                        "GROUPS": "groups",
                        "GROUPS,COMPANY": "groups,company",
                        "GROUPS,COMPANY,PAY_GROUP": "groups,company,pay_group",
                        "GROUPS,HOME_LOCATION": "groups,home_location",
                        "GROUPS,HOME_LOCATION,COMPANY": "groups,home_location,company",
                        "GROUPS,HOME_LOCATION,COMPANY,PAY_GROUP": "groups,home_location,company,pay_group",
                        "GROUPS,HOME_LOCATION,MANAGER": "groups,home_location,manager",
                        "GROUPS,HOME_LOCATION,MANAGER,COMPANY": "groups,home_location,manager,company",
                        "GROUPS,HOME_LOCATION,MANAGER,COMPANY,PAY_GROUP": "groups,home_location,manager,company,pay_group",
                        "GROUPS,HOME_LOCATION,MANAGER,PAY_GROUP": "groups,home_location,manager,pay_group",
                        "GROUPS,HOME_LOCATION,MANAGER,TEAM": "groups,home_location,manager,team",
                        "GROUPS,HOME_LOCATION,MANAGER,TEAM,COMPANY": "groups,home_location,manager,team,company",
                        "GROUPS,HOME_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "groups,home_location,manager,team,company,pay_group",
                        "GROUPS,HOME_LOCATION,MANAGER,TEAM,PAY_GROUP": "groups,home_location,manager,team,pay_group",
                        "GROUPS,HOME_LOCATION,PAY_GROUP": "groups,home_location,pay_group",
                        "GROUPS,HOME_LOCATION,TEAM": "groups,home_location,team",
                        "GROUPS,HOME_LOCATION,TEAM,COMPANY": "groups,home_location,team,company",
                        "GROUPS,HOME_LOCATION,TEAM,COMPANY,PAY_GROUP": "groups,home_location,team,company,pay_group",
                        "GROUPS,HOME_LOCATION,TEAM,PAY_GROUP": "groups,home_location,team,pay_group",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION": "groups,home_location,work_location",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,COMPANY": "groups,home_location,work_location,company",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,COMPANY,PAY_GROUP": "groups,home_location,work_location,company,pay_group",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER": "groups,home_location,work_location,manager",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,COMPANY": "groups,home_location,work_location,manager,company",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,COMPANY,PAY_GROUP": "groups,home_location,work_location,manager,company,pay_group",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,PAY_GROUP": "groups,home_location,work_location,manager,pay_group",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM": "groups,home_location,work_location,manager,team",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,COMPANY": "groups,home_location,work_location,manager,team,company",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "groups,home_location,work_location,manager,team,company,pay_group",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,PAY_GROUP": "groups,home_location,work_location,manager,team,pay_group",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,PAY_GROUP": "groups,home_location,work_location,pay_group",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,TEAM": "groups,home_location,work_location,team",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,TEAM,COMPANY": "groups,home_location,work_location,team,company",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,TEAM,COMPANY,PAY_GROUP": "groups,home_location,work_location,team,company,pay_group",
                        "GROUPS,HOME_LOCATION,WORK_LOCATION,TEAM,PAY_GROUP": "groups,home_location,work_location,team,pay_group",
                        "GROUPS,MANAGER": "groups,manager",
                        "GROUPS,MANAGER,COMPANY": "groups,manager,company",
                        "GROUPS,MANAGER,COMPANY,PAY_GROUP": "groups,manager,company,pay_group",
                        "GROUPS,MANAGER,PAY_GROUP": "groups,manager,pay_group",
                        "GROUPS,MANAGER,TEAM": "groups,manager,team",
                        "GROUPS,MANAGER,TEAM,COMPANY": "groups,manager,team,company",
                        "GROUPS,MANAGER,TEAM,COMPANY,PAY_GROUP": "groups,manager,team,company,pay_group",
                        "GROUPS,MANAGER,TEAM,PAY_GROUP": "groups,manager,team,pay_group",
                        "GROUPS,PAY_GROUP": "groups,pay_group",
                        "GROUPS,TEAM": "groups,team",
                        "GROUPS,TEAM,COMPANY": "groups,team,company",
                        "GROUPS,TEAM,COMPANY,PAY_GROUP": "groups,team,company,pay_group",
                        "GROUPS,TEAM,PAY_GROUP": "groups,team,pay_group",
                        "GROUPS,WORK_LOCATION": "groups,work_location",
                        "GROUPS,WORK_LOCATION,COMPANY": "groups,work_location,company",
                        "GROUPS,WORK_LOCATION,COMPANY,PAY_GROUP": "groups,work_location,company,pay_group",
                        "GROUPS,WORK_LOCATION,MANAGER": "groups,work_location,manager",
                        "GROUPS,WORK_LOCATION,MANAGER,COMPANY": "groups,work_location,manager,company",
                        "GROUPS,WORK_LOCATION,MANAGER,COMPANY,PAY_GROUP": "groups,work_location,manager,company,pay_group",
                        "GROUPS,WORK_LOCATION,MANAGER,PAY_GROUP": "groups,work_location,manager,pay_group",
                        "GROUPS,WORK_LOCATION,MANAGER,TEAM": "groups,work_location,manager,team",
                        "GROUPS,WORK_LOCATION,MANAGER,TEAM,COMPANY": "groups,work_location,manager,team,company",
                        "GROUPS,WORK_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "groups,work_location,manager,team,company,pay_group",
                        "GROUPS,WORK_LOCATION,MANAGER,TEAM,PAY_GROUP": "groups,work_location,manager,team,pay_group",
                        "GROUPS,WORK_LOCATION,PAY_GROUP": "groups,work_location,pay_group",
                        "GROUPS,WORK_LOCATION,TEAM": "groups,work_location,team",
                        "GROUPS,WORK_LOCATION,TEAM,COMPANY": "groups,work_location,team,company",
                        "GROUPS,WORK_LOCATION,TEAM,COMPANY,PAY_GROUP": "groups,work_location,team,company,pay_group",
                        "GROUPS,WORK_LOCATION,TEAM,PAY_GROUP": "groups,work_location,team,pay_group",
                        "HOME_LOCATION": "home_location",
                        "HOME_LOCATION,COMPANY": "home_location,company",
                        "HOME_LOCATION,COMPANY,PAY_GROUP": "home_location,company,pay_group",
                        "HOME_LOCATION,MANAGER": "home_location,manager",
                        "HOME_LOCATION,MANAGER,COMPANY": "home_location,manager,company",
                        "HOME_LOCATION,MANAGER,COMPANY,PAY_GROUP": "home_location,manager,company,pay_group",
                        "HOME_LOCATION,MANAGER,PAY_GROUP": "home_location,manager,pay_group",
                        "HOME_LOCATION,MANAGER,TEAM": "home_location,manager,team",
                        "HOME_LOCATION,MANAGER,TEAM,COMPANY": "home_location,manager,team,company",
                        "HOME_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "home_location,manager,team,company,pay_group",
                        "HOME_LOCATION,MANAGER,TEAM,PAY_GROUP": "home_location,manager,team,pay_group",
                        "HOME_LOCATION,PAY_GROUP": "home_location,pay_group",
                        "HOME_LOCATION,TEAM": "home_location,team",
                        "HOME_LOCATION,TEAM,COMPANY": "home_location,team,company",
                        "HOME_LOCATION,TEAM,COMPANY,PAY_GROUP": "home_location,team,company,pay_group",
                        "HOME_LOCATION,TEAM,PAY_GROUP": "home_location,team,pay_group",
                        "HOME_LOCATION,WORK_LOCATION": "home_location,work_location",
                        "HOME_LOCATION,WORK_LOCATION,COMPANY": "home_location,work_location,company",
                        "HOME_LOCATION,WORK_LOCATION,COMPANY,PAY_GROUP": "home_location,work_location,company,pay_group",
                        "HOME_LOCATION,WORK_LOCATION,MANAGER": "home_location,work_location,manager",
                        "HOME_LOCATION,WORK_LOCATION,MANAGER,COMPANY": "home_location,work_location,manager,company",
                        "HOME_LOCATION,WORK_LOCATION,MANAGER,COMPANY,PAY_GROUP": "home_location,work_location,manager,company,pay_group",
                        "HOME_LOCATION,WORK_LOCATION,MANAGER,PAY_GROUP": "home_location,work_location,manager,pay_group",
                        "HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM": "home_location,work_location,manager,team",
                        "HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,COMPANY": "home_location,work_location,manager,team,company",
                        "HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "home_location,work_location,manager,team,company,pay_group",
                        "HOME_LOCATION,WORK_LOCATION,MANAGER,TEAM,PAY_GROUP": "home_location,work_location,manager,team,pay_group",
                        "HOME_LOCATION,WORK_LOCATION,PAY_GROUP": "home_location,work_location,pay_group",
                        "HOME_LOCATION,WORK_LOCATION,TEAM": "home_location,work_location,team",
                        "HOME_LOCATION,WORK_LOCATION,TEAM,COMPANY": "home_location,work_location,team,company",
                        "HOME_LOCATION,WORK_LOCATION,TEAM,COMPANY,PAY_GROUP": "home_location,work_location,team,company,pay_group",
                        "HOME_LOCATION,WORK_LOCATION,TEAM,PAY_GROUP": "home_location,work_location,team,pay_group",
                        "MANAGER": "manager",
                        "MANAGER,COMPANY": "manager,company",
                        "MANAGER,COMPANY,PAY_GROUP": "manager,company,pay_group",
                        "MANAGER,PAY_GROUP": "manager,pay_group",
                        "MANAGER,TEAM": "manager,team",
                        "MANAGER,TEAM,COMPANY": "manager,team,company",
                        "MANAGER,TEAM,COMPANY,PAY_GROUP": "manager,team,company,pay_group",
                        "MANAGER,TEAM,PAY_GROUP": "manager,team,pay_group",
                        "PAY_GROUP": "pay_group",
                        "TEAM": "team",
                        "TEAM,COMPANY": "team,company",
                        "TEAM,COMPANY,PAY_GROUP": "team,company,pay_group",
                        "TEAM,PAY_GROUP": "team,pay_group",
                        "WORK_LOCATION": "work_location",
                        "WORK_LOCATION,COMPANY": "work_location,company",
                        "WORK_LOCATION,COMPANY,PAY_GROUP": "work_location,company,pay_group",
                        "WORK_LOCATION,MANAGER": "work_location,manager",
                        "WORK_LOCATION,MANAGER,COMPANY": "work_location,manager,company",
                        "WORK_LOCATION,MANAGER,COMPANY,PAY_GROUP": "work_location,manager,company,pay_group",
                        "WORK_LOCATION,MANAGER,PAY_GROUP": "work_location,manager,pay_group",
                        "WORK_LOCATION,MANAGER,TEAM": "work_location,manager,team",
                        "WORK_LOCATION,MANAGER,TEAM,COMPANY": "work_location,manager,team,company",
                        "WORK_LOCATION,MANAGER,TEAM,COMPANY,PAY_GROUP": "work_location,manager,team,company,pay_group",
                        "WORK_LOCATION,MANAGER,TEAM,PAY_GROUP": "work_location,manager,team,pay_group",
                        "WORK_LOCATION,PAY_GROUP": "work_location,pay_group",
                        "WORK_LOCATION,TEAM": "work_location,team",
                        "WORK_LOCATION,TEAM,COMPANY": "work_location,team,company",
                        "WORK_LOCATION,TEAM,COMPANY,PAY_GROUP": "work_location,team,company,pay_group",
                        "WORK_LOCATION,TEAM,PAY_GROUP": "work_location,team,pay_group"
                    },
                    ('remote_fields',): {

                        "EMPLOYMENT_STATUS": "employment_status",
                        "EMPLOYMENT_STATUS,ETHNICITY": "employment_status,ethnicity",
                        "EMPLOYMENT_STATUS,ETHNICITY,GENDER": "employment_status,ethnicity,gender",
                        "EMPLOYMENT_STATUS,ETHNICITY,GENDER,MARITAL_STATUS": "employment_status,ethnicity,gender,marital_status",
                        "EMPLOYMENT_STATUS,ETHNICITY,MARITAL_STATUS": "employment_status,ethnicity,marital_status",
                        "EMPLOYMENT_STATUS,GENDER": "employment_status,gender",
                        "EMPLOYMENT_STATUS,GENDER,MARITAL_STATUS": "employment_status,gender,marital_status",
                        "EMPLOYMENT_STATUS,MARITAL_STATUS": "employment_status,marital_status",
                        "ETHNICITY": "ethnicity",
                        "ETHNICITY,GENDER": "ethnicity,gender",
                        "ETHNICITY,GENDER,MARITAL_STATUS": "ethnicity,gender,marital_status",
                        "ETHNICITY,MARITAL_STATUS": "ethnicity,marital_status",
                        "GENDER": "gender",
                        "GENDER,MARITAL_STATUS": "gender,marital_status",
                        "MARITAL_STATUS": "marital_status"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'expand':
                        (str,),
                    'include_remote_data':
                        (bool,),
                    'include_sensitive_fields':
                        (bool,),
                    'remote_fields':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'expand': 'expand',
                    'include_remote_data': 'include_remote_data',
                    'include_sensitive_fields': 'include_sensitive_fields',
                    'remote_fields': 'remote_fields',
                },
                'location_map': {
                    'id': 'path',
                    'expand': 'query',
                    'include_remote_data': 'query',
                    'include_sensitive_fields': 'query',
                    'remote_fields': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def employees_create(
        self,
        employee_endpoint_request,
        **kwargs
    ) -> "EmployeeResponse":
        """employees_create  # noqa: E501

        Creates an `Employee` object with the given values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.employees_create(employee_endpoint_request, async_req=True)
        >>> result = thread.get()

        Args:
            employee_endpoint_request (EmployeeEndpointRequest):

        Keyword Args:
            is_debug_mode (bool): Whether to include debug fields (such as log file links) in the response.. [optional]
            run_async (bool): Whether or not third-party updates should be run asynchronously.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            EmployeeResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['employee_endpoint_request'] = \
            employee_endpoint_request
        return self.employees_create_endpoint.call_with_http_info(**kwargs)

    def employees_ignore_create(
        self,
        model_id,
        ignore_common_model_request,
        **kwargs
    ) -> "IgnoreCommonModel":
        """employees_ignore_create  # noqa: E501

        Ignores a specific row based on the `model_id` in the url. These records will have their properties set to null, and will not be updated in future syncs. The \"reason\" and \"message\" fields in the request body will be stored for audit purposes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.employees_ignore_create(model_id, ignore_common_model_request, async_req=True)
        >>> result = thread.get()

        Args:
            model_id (str):
            ignore_common_model_request (IgnoreCommonModelRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            IgnoreCommonModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['model_id'] = \
            model_id
        kwargs['ignore_common_model_request'] = \
            ignore_common_model_request
        return self.employees_ignore_create_endpoint.call_with_http_info(**kwargs)

    def employees_list(
        self,
        **kwargs
    ) -> "MergePaginatedResponse(Employee)":
        """employees_list  # noqa: E501

        Returns a list of `Employee` objects.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.employees_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            company_id (str): If provided, will only return employees for this company.. [optional]
            created_after (datetime): If provided, will only return objects created after this datetime.. [optional]
            created_before (datetime): If provided, will only return objects created before this datetime.. [optional]
            cursor (str): The pagination cursor value.. [optional]
            display_full_name (str, none_type): If provided, will only return employees with this display name.. [optional]
            employment_status (str, none_type): If provided, will only return employees with this employment status.. [optional]
            expand (str): Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.. [optional]
            first_name (str, none_type): If provided, will only return employees with this first name.. [optional]
            include_deleted_data (bool): Whether to include data that was marked as deleted by third party webhooks.. [optional]
            include_remote_data (bool): Whether to include the original data Merge fetched from the third-party to produce these models.. [optional]
            include_sensitive_fields (bool): Whether to include sensitive fields (such as social security numbers) in the response.. [optional]
            last_name (str, none_type): If provided, will only return employees with this last name.. [optional]
            manager_id (str): If provided, will only return employees for this manager.. [optional]
            modified_after (datetime): If provided, will only return objects modified after this datetime.. [optional]
            modified_before (datetime): If provided, will only return objects modified before this datetime.. [optional]
            page_size (int): Number of results to return per page.. [optional]
            pay_group_id (str): If provided, will only return employees for this pay group. [optional]
            personal_email (str, none_type): If provided, will only return Employees with this personal email. [optional]
            remote_fields (str): Which fields should be returned in non-normalized form.. [optional]
            remote_id (str, none_type): The API provider's ID for the given object.. [optional]
            team_id (str): If provided, will only return employees for this team.. [optional]
            work_email (str, none_type): If provided, will only return Employees with this work email. [optional]
            work_location_id (str): If provided, will only return employees for this location.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            MergePaginatedResponse(Employee)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.employees_list_endpoint.call_with_http_info(**kwargs)

    def employees_meta_post_retrieve(
        self,
        **kwargs
    ) -> "MetaResponse":
        """employees_meta_post_retrieve  # noqa: E501

        Returns metadata for `Employee` POSTs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.employees_meta_post_retrieve(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            MetaResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.employees_meta_post_retrieve_endpoint.call_with_http_info(**kwargs)

    def employees_retrieve(
        self,
        id,
        **kwargs
    ) -> "Employee":
        """employees_retrieve  # noqa: E501

        Returns an `Employee` object with the given `id`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.employees_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            expand (str): Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.. [optional]
            include_remote_data (bool): Whether to include the original data Merge fetched from the third-party to produce these models.. [optional]
            include_sensitive_fields (bool): Whether to include sensitive fields (such as social security numbers) in the response.. [optional]
            remote_fields (str): Which fields should be returned in non-normalized form.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Employee
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.employees_retrieve_endpoint.call_with_http_info(**kwargs)

