# coding: utf-8

"""
    eLabFTW REST API v2 Documentation

    Some description of the api.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from elabapi_python.api_client import ApiClient


class UploadsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_upload(self, entity_type, id, subid, **kwargs):  # noqa: E501
        """Delete an upload.  # noqa: E501

        The upload gets deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_upload(entity_type, id, subid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param float id: ID of the entity (required)
        :param float subid: ID of the upload (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_upload_with_http_info(entity_type, id, subid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_upload_with_http_info(entity_type, id, subid, **kwargs)  # noqa: E501
            return data

    def delete_upload_with_http_info(self, entity_type, id, subid, **kwargs):  # noqa: E501
        """Delete an upload.  # noqa: E501

        The upload gets deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_upload_with_http_info(entity_type, id, subid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param float id: ID of the entity (required)
        :param float subid: ID of the upload (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_type', 'id', 'subid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_upload" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_type' is set
        if ('entity_type' not in params or
                params['entity_type'] is None):
            raise ValueError("Missing the required parameter `entity_type` when calling `delete_upload`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_upload`")  # noqa: E501
        # verify the required parameter 'subid' is set
        if ('subid' not in params or
                params['subid'] is None):
            raise ValueError("Missing the required parameter `subid` when calling `delete_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_type' in params:
            path_params['entity_type'] = params['entity_type']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'subid' in params:
            path_params['subid'] = params['subid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/{entity_type}/{id}/uploads/{subid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_upload(self, entity_type, id, subid, **kwargs):  # noqa: E501
        """Actions on an upload.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_upload(entity_type, id, subid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param float id: ID of the entity (required)
        :param float subid: ID of the upload (required)
        :param UploadsSubidBody body: Parameters for modifying an upload.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_upload_with_http_info(entity_type, id, subid, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_upload_with_http_info(entity_type, id, subid, **kwargs)  # noqa: E501
            return data

    def patch_upload_with_http_info(self, entity_type, id, subid, **kwargs):  # noqa: E501
        """Actions on an upload.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_upload_with_http_info(entity_type, id, subid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param float id: ID of the entity (required)
        :param float subid: ID of the upload (required)
        :param UploadsSubidBody body: Parameters for modifying an upload.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_type', 'id', 'subid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_upload" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_type' is set
        if ('entity_type' not in params or
                params['entity_type'] is None):
            raise ValueError("Missing the required parameter `entity_type` when calling `patch_upload`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_upload`")  # noqa: E501
        # verify the required parameter 'subid' is set
        if ('subid' not in params or
                params['subid'] is None):
            raise ValueError("Missing the required parameter `subid` when calling `patch_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_type' in params:
            path_params['entity_type'] = params['entity_type']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'subid' in params:
            path_params['subid'] = params['subid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/{entity_type}/{id}/uploads/{subid}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_upload(self, entity_type, id, **kwargs):  # noqa: E501
        """Create an upload.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_upload(entity_type, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param float id: ID of the entity (required)
        :param str file:
        :param str comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_upload_with_http_info(entity_type, id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_upload_with_http_info(entity_type, id, **kwargs)  # noqa: E501
            return data

    def post_upload_with_http_info(self, entity_type, id, **kwargs):  # noqa: E501
        """Create an upload.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_upload_with_http_info(entity_type, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param float id: ID of the entity (required)
        :param str file:
        :param str comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_type', 'id', 'file', 'comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_upload" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_type' is set
        if ('entity_type' not in params or
                params['entity_type'] is None):
            raise ValueError("Missing the required parameter `entity_type` when calling `post_upload`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `post_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_type' in params:
            path_params['entity_type'] = params['entity_type']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501
        if 'comment' in params:
            form_params.append(('comment', params['comment']))  # noqa: E501

        body_params = None
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/{entity_type}/{id}/uploads', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_upload_replace(self, entity_type, id, subid, **kwargs):  # noqa: E501
        """Replace an existing uploaded file. The existing file will be archived and the new one will be added.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_upload_replace(entity_type, id, subid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param float id: ID of the entity (required)
        :param float subid: ID of the upload (required)
        :param Object body: Parameters for replacing an upload.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_upload_replace_with_http_info(entity_type, id, subid, **kwargs)  # noqa: E501
        else:
            (data) = self.post_upload_replace_with_http_info(entity_type, id, subid, **kwargs)  # noqa: E501
            return data

    def post_upload_replace_with_http_info(self, entity_type, id, subid, **kwargs):  # noqa: E501
        """Replace an existing uploaded file. The existing file will be archived and the new one will be added.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_upload_replace_with_http_info(entity_type, id, subid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param float id: ID of the entity (required)
        :param float subid: ID of the upload (required)
        :param Object body: Parameters for replacing an upload.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_type', 'id', 'subid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_upload_replace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_type' is set
        if ('entity_type' not in params or
                params['entity_type'] is None):
            raise ValueError("Missing the required parameter `entity_type` when calling `post_upload_replace`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `post_upload_replace`")  # noqa: E501
        # verify the required parameter 'subid' is set
        if ('subid' not in params or
                params['subid'] is None):
            raise ValueError("Missing the required parameter `subid` when calling `post_upload_replace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_type' in params:
            path_params['entity_type'] = params['entity_type']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'subid' in params:
            path_params['subid'] = params['subid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/{entity_type}/{id}/uploads/{subid}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read_upload(self, entity_type, id, subid, **kwargs):  # noqa: E501
        """Read an upload.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_upload(entity_type, id, subid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param float id: ID of the entity (required)
        :param float subid: ID of the upload (required)
        :param str format: To download the file itself, use `binary` format parameter. 
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.read_upload_with_http_info(entity_type, id, subid, **kwargs)  # noqa: E501
        else:
            (data) = self.read_upload_with_http_info(entity_type, id, subid, **kwargs)  # noqa: E501
            return data

    def read_upload_with_http_info(self, entity_type, id, subid, **kwargs):  # noqa: E501
        """Read an upload.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_upload_with_http_info(entity_type, id, subid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param float id: ID of the entity (required)
        :param float subid: ID of the upload (required)
        :param str format: To download the file itself, use `binary` format parameter. 
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_type', 'id', 'subid', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_upload" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_type' is set
        if ('entity_type' not in params or
                params['entity_type'] is None):
            raise ValueError("Missing the required parameter `entity_type` when calling `read_upload`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `read_upload`")  # noqa: E501
        # verify the required parameter 'subid' is set
        if ('subid' not in params or
                params['subid'] is None):
            raise ValueError("Missing the required parameter `subid` when calling `read_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_type' in params:
            path_params['entity_type'] = params['entity_type']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'subid' in params:
            path_params['subid'] = params['subid']  # noqa: E501

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/{entity_type}/{id}/uploads/{subid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read_uploads(self, entity_type, id, **kwargs):  # noqa: E501
        """Read attached files of that entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_uploads(entity_type, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param float id: ID of the entity (required)
        :return: list[Upload]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.read_uploads_with_http_info(entity_type, id, **kwargs)  # noqa: E501
        else:
            (data) = self.read_uploads_with_http_info(entity_type, id, **kwargs)  # noqa: E501
            return data

    def read_uploads_with_http_info(self, entity_type, id, **kwargs):  # noqa: E501
        """Read attached files of that entity.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_uploads_with_http_info(entity_type, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param float id: ID of the entity (required)
        :return: list[Upload]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_type', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_uploads" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_type' is set
        if ('entity_type' not in params or
                params['entity_type'] is None):
            raise ValueError("Missing the required parameter `entity_type` when calling `read_uploads`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `read_uploads`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_type' in params:
            path_params['entity_type'] = params['entity_type']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token']  # noqa: E501

        return self.api_client.call_api(
            '/{entity_type}/{id}/uploads', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Upload]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
