# Copyright 2025 LangNeuron
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Errors."""


from .eror_path_not_avaible import PathNotAvaibleError
from .error_data_is_uncorrect import DataIsUncorrectError
from .error_db_not_loaded import DbNotLoadedError
from .error_not_found import NotFoundColumnError, NotFoundTableError
from .error_unknown_data_type import UnknownDataTypeError
from .table_already_exist import TableAlredyAvaibleError

__all__ = [
           "DataIsUncorrectError",
           "DbNotLoadedError",
           "NotFoundColumnError",
           "NotFoundTableError",
           "PathNotAvaibleError",
           "TableAlredyAvaibleError",
           "UnknownDataTypeError",
]
