# generated by datamodel-codegen:
#   filename:  common.json
#   timestamp: 2025-09-13T04:49:25+00:00

from __future__ import annotations

from datetime import datetime
from typing import Any, List, Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import Field, RootModel


class EidosCommonDefinitions(RootModel[Any]):
    root: Any = Field(..., title='Eidos common definitions')


class CurrentTime(RootModel[datetime]):
    root: datetime = Field(..., title='Current time')
    """
    Time of current node view. ISO 8601 format
    """


class TimeControl(EidosModel):
    """
    Time control properties
    """

    range: Optional[List[datetime]] = Field(None, max_length=2, min_length=2)
    """
    Time range of time control. ISO 8601 format
    """
    increment: Optional[float] = Field(None, title='Time selector increments')
    """
    Size in seconds of the time selector increments
    """
    zoomToNow: Optional[bool] = Field(True, title='Zoom to now button')
    """
    Adds a button that zooms to the current time
    """
    zoomToExtent: Optional[bool] = Field(True, title='Zoom to timerange extent button')
    """
    Adds a button that zooms to the current time range
    """


class Timezone(RootModel[Optional[str]]):
    root: Optional[str]


class CssSpec(RootModel[Optional[Union[int, str]]]):
    root: Optional[Union[int, str]] = Field(..., title='CSS spec')
    """
    CSS string or pixels as integer or null
    """


class Position(EidosModel):
    top: Optional[CssSpec] = None
    left: Optional[CssSpec] = None
    bottom: Optional[CssSpec] = None
    right: Optional[CssSpec] = None
